## Project: Mini-Project

This project should take approximately a week to complete.

The mini-project is an opportunity for you to design a project that serves a purpose by solving a problem or filling a need. It is also an opportunity to do two things:

* Show what you know
* Learn something new
	
Ideally, there should be a maker component to this project. This is a real world component that works with the code on the micro:bit to do something unique.

## Assignment

* Create an original project using the micro:bit.
* Incorporate a physical component to the project.
* Demonstrate the use of one of the following concepts:

>* Input / Processing / Output
* Variables
* Simple Circuits
* Iteration/Loops
* Conditional Statements
	
## Project ideas

* Make a “New and Improved” Fidget Cube
* Make a Moving Monster
* Make a musical instrument
* Fishing Game
* Make an Air Guitar (uses while loop to do tempo and pitch)
* Screensaver
* Screensaver that uses other inputs to draw
* Interactive book
* Binary Clock or some other way to represent numbers visually

View projects at the following sites for inspiration:

* https://microbit.org/projects/make-it-code-it/
* [Projects](/projects)

## Examples

![Toss the ball project](/static/courses/csintro/miniproject/toss-the-ball.jpg)
Toss the Ball

This is a skill game in which an aluminum foil ball is thrown into a plastic cup. Copper tape lining the sides and bottom of the cup completes the circuit when the ball touches it.

[**micro:bit Bullseye Project**](https://youtu.be/NZUpoSixf4E)
https://youtu.be/NZUpoSixf4E

This is a skill game in which tennis balls are thrown underhand at one of the three rings, which are lined with aluminum foil so they complete a circuit underneath when the ball makes contact with the ring.

[**micro:bit Storybook**](https://youtu.be/yg1NNLMqa9c)
https://youtu.be/yg1NNLMqa9c

This is a prototype of a storybook that could use the micro:bit to display animations for part of the story. Copper tape is used on the underside of the paper flaps to make contact between the GND pin and each of the other pins in sequence.

## Work logs

Because much of the benefit of completing a mini-project like this comes from working through problems, you should consider keeping a work log. 

A work log is a short, bullet point list of what you worked on, and how long it took. Stick to the facts. It shouldn’t take more than thirty seconds or so to write up a work log. Try to do one for every class. A shared Microsoft OneNote notebook is a great way to keep a work log that can be updated regularly.

### Sample Work Log
>**_April 11_**<br/>
_20 min. Created code that reacts when pins P0 and P1 are pressed._<br/>
_0 min. Talked with Mr. Kiang about how to attach wires so they won’t fall off_<br/>
_20 min. Put target back together with pins_<br/>
_10 min. Helped Cody with attaching his scoreboard_

## Journal Entry

At the end of the week, compose a final journal reflection that summarizes the process of your learning over the course of the week. You should go back through your work and discuss the following:

* Talk about one challenge you faced in creating this project, either a challenge in coding or in making the artifact. How did you overcome this challenge?
* What did you demonstrate that you already knew?
* What was the new thing you learned in order to make this? How did you learn about it?
* Was anyone particularly helpful to you along the way? Who and how?
* Describe one specific thing you are proud of in this project.
* What would you do differently next time?
* If you had another week to work on this project, what might you add or improve?

Sample Reflection (excerpt)
>_“I spent this week finishing up little details with my program, making it work better and more user friendly. The part that surprised me the most was the little things that kept popping into my head, little suggestions that could potentially be good to add, but might not be necessary or even useful. At the beginning of the assignment, I just added them as quickly as I thought of them, but as the project neared the midpoint and conclusion, I find myself considering if I actually need them (as previous additions have been since quickly deleted). Another thing that I find interesting about this is that it is a rather specialized project. Not many people would use it except for me. However, this is supposed to be easily used by other people, so I have to take them into consideration as I design the project. I also realized that I had, at some point, broken part of my code without realizing it, so I now have to fix part of it. The reason that it is a problem is because I added a lot of code at once without deleting it, which is unfortunate. Next time I will add small amounts of code and test it first.”_
