# Activity: Collaboratively independent

## Tips for teachers
These tips are just for teachers who are assigning the mini-project to a classroom of students.

Teachers want their students to collaborate on projects but they also want to be able to hold them accountable for getting their work done. Many teachers struggle with assessing exactly how much each individual contributed to a group project, as well as making sure that everyone does his or her “fair share”.

The Mini-Project (and the Final Project) are not group projects. Students are asked to propose their own independent project and are expected to get it done. But they are not on their own in this process! We build in frequent opportunities for students to collaborate and share the collective knowledge of the class as they go. We ask them to be “collaboratively independent.”

Here is how we structure our classes: 

## Beginning of class

For groups of 15 or so, have students each **_briefly_** (no more than 30 seconds or so) report on their progress in front of the group:
* One-line description of project
* Their progress so far
* Something they are going to work on figuring out today
	
It is important that everyone else is listening to each project and volunteering their help or solutions if they are figuring out the same thing or if they have solved that problem in a previous class.

>Example:
_I’m working on a pinball machine. So far I have done the board and the ramp. Today I am going to be working on wiring the bumpers so that when the ball hits the bumper, the micro:bit detects it and displays the score._

>Sample response from a classmate:
_Yesterday I wired up my targets so that when you throw a ball it keeps score. I can show you how I did it._

Ideally students who are working on projects should be aware of what other students are working on and what they are figuring out. It creates more opportunities for collaboration in the classroom and can encourage students to seek help from each other rather than all waiting in line to talk to you.

It’s important to hear from everybody but it shouldn’t take more than five or ten minutes. For groups larger than 15 or 20 students, you may want to split them into two or three larger groups and have them report out to each other.

![Quick progress report](/static/courses/csintro/miniproject/quick-progress-report.png)

## During class
This is a time to circulate and check in with students individually, starting with those students who seem to still be stuck from last time. For the most part, students should be working on their projects in small groups, helping each other wherever and whenever possible.

## End of class
About ten minutes before the end of class, you can have students do a “work-in-progress” report. Gather the students together and have them move from table to table while each student presents one thing that he or she figured out during the class. This is really an informal presentation, and it is understood that it is not finished at all; it is still a “work in progress.” But everyone needs to show something, and the entire group needs to move as one throughout the classroom, almost like physicians making rounds in a hospital. This is an important way to spread ideas throughout the classroom, and to “cross-pollinate” with helpful tips and techniques.

Work-in-progress reports should be short, no more than twenty or thirty seconds. If you have a large class, you might divide the class into several large groups and have them present to each other. 

![Work in progress report](/static/courses/csintro/miniproject/work-in-progress-report.png)
