# Introduction

The micro:bit is an awesome way to start learning how to code and understand the basics of computer science. You’ll be using the Microsoft MakeCode platform, which lets you create programs by dragging and dropping blocks of code—kind of like building with digital LEGO pieces. It’s easy to use, and with it, you can make the micro:bit 
respond to different inputs and learn important coding concepts like loops (doing something over and over), if-then statements (making decisions in code), and variables (storing and using information).

A lot of people focus on the micro:bit's 5x5 LED display because it’s a quick way to see your program in action. But there’s so much more you can do! Think of the micro:bit as the “brain” behind all kinds of physical creations. It can control things you build in real life—not just what happens on its tiny screen.

Your creations don’t need to be super complicated. You can make awesome stuff using everyday materials like cardboard, paper, or whatever else you have around. Since the micro:bit is lightweight and has lots of built-in sensors, it’s easy to add to your designs. Just think ahead about where the micro:bit will fit in your project.

For this first project, we’re going to make something creative where the micro:bit acts as the “face” of your animal. We’re starting this way to show that this class is all about making, building, and creating things with your hands. If you have an art room or crafting supplies nearby, that’s perfect! You’ll be able to use those to bring your ideas to life.

Some common making supplies to gather:

* pizza boxes
* scrap cardboard
* colored construction paper
* colored duct tape
* scissors
* pipe cleaners
* stickers
* feathers
* string
* markers

![Maker materials](/static/courses/csintro/making/maker-materials.png)

# Activity: Design Thinking

![Design thinking](/static/courses/csintro/making/design-thinking.png)

Note: The project later in this unit will use the work you have done in this activity, so it's important not to skip it.

**Objective:** To introduce a process of design that starts with talking to another person. Whatever you build with code should serve a purpose or fill a need. Sometimes what you build will make the world more beautiful, or help somebody else. Our design process, based on a process called design thinking, will give you a specific framework for thinking purposefully about design. 

**Overview:** In this activity, you will interview a friend or a family member about their ideal pet. You should take notes. The first step in coding by design involves understanding someone else’s needs. Then, you can create prototypes that get you closer and closer to the best solution.

**Materials:** A partner, and something to take notes on

**Getting started:**
The goal of this activity is to gather information from your partner that will help you to design a micro:bit pet for your partner.

**5 minutes:** Interview your partner. The goal is to find out what your partner considers to be their ideal pet. You should mostly listen, and ask questions to keep your partner talking for the entire time. Here are some questions to start with:

* Do you have a pet? What is it?
* What do you like about your pet? What do you dislike?
* Is there anything you wish your pet could do? Why?
* Tell me about your ideal pet.

The goal is to find out more about your partner by asking questions. Try to ask “Why?” as much as possible. Your partner will tell you about his or her ideal pet, but you are really finding out more about your partner’s likes and dislikes. When we design, we create real things for real people. So we need to start with understanding them first.

**5 minutes:** Review your notes, and circle anything that seems as if it will be important to understanding how to create the ideal pet for your partner. Circle ideas, advice, anything that could be helpful when you start building. Then, you should use what you have discovered about your partner to fill in the blanks:

"My partner needs a `__________________` because `__________________`."

This definition statement should draw some conclusions about your partner's need based on the conversation you have had with that person.

**5 minutes:** Sketch at least 5 ideas of pets that would meet your partner's needs. Stick figures and diagrams are okay. At this point, quantity is more important than quality. You shouldn't limit yourself to real animals; unicorns and mashups are totally fine!

Make sure you keep your notes and sketches! You will use them in the project for this lesson.

## Examples

![Design thinking sketch 1](/static/courses/csintro/making/dt-sketch1.jpg)

![Design thinking sketch 2](/static/courses/csintro/making/dt-sketch2.jpg)

![Design thinking sketch 3](/static/courses/csintro/making/dt-sketch3.jpg)

![Design thinking sketch 4](/static/courses/csintro/making/dt-sketch4.jpg)

