# Making with micro:bit

This lesson introduces the design thinking process as a way to design something that meets someone else's needs. By focusing on building the micro:bit into a pysical object, you'll gain experience in working with a piece of hardware that has a specific size and weight, and that needs to be supported and held securely.

![micro:bit board](/static/courses/csintro/making/microbit-board.png)

## Lesson objectives 
You will...

* Exercise creativity and resourcefulness by coming up with ideas for using simple household materials to accommodate the micro:bit’s size and weight in many different ways.
* Test and iterate using different materials and sizes in order to create an optimal design to house the micro:bit and battery pack.
* Learn how to download programs and move them to the micro:bit file to run on the micro:bit.
* Use the design thinking process to develop an understanding for a problem or user need.
* Apply your understanding in a creative way by making a “micro:pet” creature. 
	
## Lesson plan

* [**Introduction**: The micro:bit is for making](/courses/csintro/making/introduction)
* [**Activity**: MakeCode download](/courses/csintro/making/activity)
* [**Project**: micro:pet (including mods and rubric)](/courses/csintro/making/project)

## Related standards

[Targeted CSTA standards](/courses/csintro/making/standards)