# Project: Get loopy!

![Birthday Card Project](/static/courses/csintro/iteration/birthday-card.jpg)

In this project, you will create a program with loops, variables, and parameters, then design and build an object that uses the micro:bit program and sound, display, and motion in some way.

## Project expectations

Make sure your project meets these specifications:

* Use at least three different loops in a meaningful way

* Use unique variable names that clearly describe what the variable values hold

* Use sound, display, and motion in a way that’s integral to the program

* The program should compile and run as intended and include meaningful comments in the code

* Provide the written Reflection Diary entry (which we’ll talk about after you complete your project)

## Project ideas

There are many different ways to use the three types of loop blocks. Consider following questions to prompt your brainstorming process:

* How will you use loops to create something useful, entertaining, or interesting?

* What might you make?

Some project suggestions:

* Create an animated gif (looping image that changes) and add music that matches.

* Create an animation that repeats for one of the melodies included in MakeCode (like Happy Birthday).

* Create different animations that run when different buttons are pressed.

* Create an alarm that includes sound and images. What will set the alarm off? What will make the alarm stop sounding?

* Use servo motors to create a creature that dances and changes its expression while a song plays.

### Project example: Hat Man

![Hat Man](/static/courses/csintro/iteration/hatman.png)
Hat Man Project

[**micro:bit Hat Man**](https://youtu.be/Xvybu_T5IL8)
https://youtu.be/Xvybu_T5IL8
<br/>

[**micro:bit Hat Man - inside view**](https://youtu.be/ZfKgFQjygQQ)
https://youtu.be/ZfKgFQjygQQ
<br/>

This project uses the micro:bit light sensor to display a happy face when it is sunny, and a frowning face when it is dark. The micro:bit is connected to a servo mounted on the inside of the container, and the smile and frown are attached to plastic coffee stirrers with tape and hot glue.

## Journal Entry

Write a short reflection of about 150–300 words, addressing the following points:

* Explain how you decided on your particular "loopy" idea. What brainstorming ideas did you come up with?
* What type of loops did you use? For, While, and/or Repeat 
* What was something that was surprising to you about the process of creating this program?
* Describe a difficult point in the process of designing this program, and explain how you resolved it.
* What feedback did your beta testers give you? How did that help you improve your loop demo?
* Publish your MakeCode program and include the link.