# Introduction

When we first started teaching computer science, we noticed something interesting. Most of the beginner courses were focused on math problems or creating geometric shapes, and it was mostly boys signing up. That made us wonder: what if we could teach programming in a way that was more exciting and fun for everyone?

So, we changed things up! Instead of just focusing on the math, we decided to show what programming can help you create. After all, coding is all about solving problems and making things that matter. You could use it to help doctors treat patients, make games that entertain people, or tackle big issues around the world. When our students got to work on problems they cared about, they were way more interested in learning to code. They saw programming as a super cool tool for building their own creative solutions.

And guess what? It worked! We started seeing more girls joining the class, along with boys who brought different interests and ideas. Everyone got to collaborate more, which made the class even better because each student brought something unique to the table.

Now, about a third of the students in our computer science classes are girls, and the best part? They’re not just learning how to code—they’re learning how to think like real developers. From brainstorming ideas to building prototypes, our students are creating things that really make a difference. And that’s what this course is all about!

> _- Authors Mary Kiang and Douglas Kiang_

## Course Introduction
Get ready for an awesome introduction to coding and computer science through hands-on making and design! You’ll be using the micro:bit
microcontroller board, along with Microsoft’s MakeCode, a block-based coding tool that's both easy to use and super powerful.

In this course, you’ll be working on projects where you actually build things—real, physical objects! The idea is that by creating something you can hold in your hands, you’ll naturally learn important coding and computer science concepts. It’s all about learning by doing, and we can’t wait to see what you create!

![micro:bit man](/static/courses/csintro/microbitman.jpg)

* micro:bits may be purchased from these resellers:

>   http://microbit.org/resellers (you will need at least 1 micro:bit for this course).  The "micro:bit Go Kit" includes a battery pack and USB cable as well.

* Other optional suggested micro:bit accessories include:

> * [ ] Alligator/Crocodile clip cables
  * [ ]	Headphone/earbuds (for audio)
  * [ ] Servo motor (for movement)
  * [ ] Croc clip to Male connector (for connecting to Servo motor)
  * [ ] Croc clip to Headphone jack adapter (http://microbit-accessories.co.uk/)
  * [ ] Copper tape

* MakeCode for the micro:bit is a free web app: https://makecode.microbit.org

Copper tape is inexpensive and super useful in all sorts of maker activities so it’s worth it to get a roll to keep on hand for micro:bit projects. We use it in [Lesson 9 (Binary Cash Register)](/test/courses/csintro/binary/project). You can purchase copper tape from vendors such as Adafruit and Sparkfun.

By the time you finish this course, you'll have a solid understanding of key computer science concepts that will set you up for future learning. Plus, you'll build awesome design skills that can be used in all sorts of future projects, whether you’re creating 3D-printed prototypes or developing apps that solve real-world problems.

This course is designed for students in grades 6-8 (ages 11-14). It is designed for people who might not have a background in Computer Science or even teachers who are teaching an "Intro to Computer Science" class for the first time. So, everyone can jump in and learn together!

The course takes about 14 weeks to finish, if you are working on it for a few hours a week. You’ll spend roughly one week on each of the first 11 lessons, and then you’ll need about three weeks to work on an exciting final project. But of course you can always adjust the timeline to fit your needs. This course is flexible and designed to work for you!

## Overall Course Scope & Sequence:

1. [Making](/test/courses/csintro/making) 
2. [Algorithms](/test/courses/csintro/algorithms)
3. [Variables](/test/courses/csintro/variables)
4. [Conditionals](/test/courses/csintro/conditionals)
5. [Iteration](/test/courses/csintro/iteration)
6. [Review/Mini-Project](courses/csintro/miniproject)
7. [Coordinate grid system](/test/courses/csintro/coordinates)
8. [Booleans](/test/courses/csintro/booleans)
9. [Bits, bytes, and binary](/test/courses/csintro/binary) 
10. [Radio](/test/courses/csintro/radio)
11. [Arrays](/test/courses/csintro/arrays)
12. [Accelerometer](/test/courses/csintro/accelerometer)
13. [Independent final project](/test/courses/csintro/finalproject)

Each lesson is made up of the following parts:

* Topic Introduction
* micro:bit Activity (45-60 min) An activity that everyone makes on their micro:bit that teaches the skills learned in this lesson.
* Project (60-120 min) A prompt for an original project that you can create to practice the skills and concepts covered in this lesson.
* Project Mods: Examples of additional things you can do to extend the project
* Standards: A list of [CSTA K-12 Computer Science Standards](https://www.csteachers.org/?page=CSTA_Standards) and/or concepts covered by this lesson.

### Topic introduction

The introduction to each lesson will tell you what learning objectives are covered in the lesson, and presents an overview of that lesson's topic. 

### micro:bit activity (45–60 min)
Each lesson contains a micro:bit activity, which is an example that walks you step-by-step through building a project that demonstrates that lesson's topic. By the time you finish the activity, you will have written code that you can use in a different project of their own design.

You can always challenge yourself by modifying, or "modding" the activity to do something different. We have provided examples and suggestions at the end of many of these activities, and feel free to come up with your own!

### Project (60–120 min)
After the demonstration activity, it is time to challenge yourself to use those same skills to create something that is creative and original. This is where the real learning takes place because instead of following step by step instructions, you will prove to yourself that you can use those skills in a new way to create something that is personal and unique.

There are also a series of Project Mods that students can do to extend the project they have created. These are useful for students who already have some experience with coding or who want an extra challenge.

### Journal
From time to time we will ask you to write down your reflections in a journal. Keeping a personal journal is a powerful tool! It helps you track your progress, organize your thoughts, and see how much you've grown over time. By writing down what you learned from each activity and project, you’ll deepen your understanding and notice patterns in your problem-solving process. Plus, it’s a great way to celebrate your successes and identify areas for improvement, making you a more thoughtful and confident learner!

### Standards
Where applicable, we have mapped each of the lessons to the [Computer Science Teachers Association (CSTA) K-12 Standards](https://www.csteachers.org/?page=CSTA_Standards), which are US nationally recognized standards for computer science education.
