# Final project

The final project is a chance for you to use all of the skills you have been learning throughout the semester to create something that is original, and that solves a problem or serves a purpose.

## Possible ideas
* Create a game
* Create something that helps somebody by solving a problem
* Create something beautiful
* Create a musical instrument

In addition, your project code must do each of the following things:

## Show something you already know
You should demonstrate your knowledge of one or more concepts we have covered in these lessons.

## Show something new
You should demonstrate a technique, efficiency, or block that you went out and learned how to do on your own, either from the documentation, or from another classmate.

## Incorporate a maker component
You should not create a project that exists solely and independently on the micro:bit. Your project should work together with tangible components such as servos, real buttons, switches, to do something unique.

## Timeframe
Try to spend about three weeks on this project. Come up with realistic milestone deadlines (specific things you want to accomplish each week) to keep yourself on task. Try to do a little bit each day; it is much better to work bit by bit over three weeks, than to let a week or two go by without working on it at all. Try things out, get stuck, and get yourself unstuck. Your brain will still be thinking about the project even when you're not in front of the computer.
 
## Record of thinking
A Record of Thinking is like a journal entry (or like the reflection that you did for the mini-project) that tells the story of your learning throughout the past week. Go over your work for the week and what you accomplished, and look at what you did, where you got stuck, and how you figured it out.

Then write a 150- to 300-word Record of Thinking addressing the following:
* Describe something that surprised you this week as you worked on your project.
* Describe a moment where you got stuck. How did you get unstuck?
* Did anyone help you this week? Who and how?
* Choose an adjective that describes how you are feeling about your project this week. Explain why you chose this word.
* What are you working on next week? (for weeks 1 and 2)
* If you had more time to work on this project, what would you add? (for week 3)
	
Sample Record of Thinking Excerpt:

>_Week of April 6<br/>
I guess I would choose the word "elated" because that's what I am feeling right now. After Mr. Kiang helped me figure out why my code wasn't working I was able to see it working exactly how I pictured it last week! That was a great moment. I was surprised how hard writing code that works is. I planned out the steps I wanted it to do but I didn't realize that the loops had to be nested one inside the other so I was stuck for a while. It always seems more simple than it is, that's one thought I will take into next week. Now I have the head attached to the body and the jaws work. I'm going to keep trying to get the lights working._

Note: Ideally, a Record of Thinking is not a detailed list of all of the tasks you completed over the week. Instead, think of the Record of Thinking as a way to help you recall HOW you learned how to do those things. It is an important form of documentation of the learning process that you will be glad to have to look back on, once the project is complete!

## Beta testing
Beta testing is an important part of testing the final projects to uncover bugs or design issues that could make the projects difficult to use. Your project is ready to beta test when it is "feature-complete" i.e., all features need to be incorporated into the micro:bit, and the construction of the real world elements of the project should be done or almost done.

Have a friend or family member use your project and give you feedback. What works well? What needs more polishing? What questions do they have? Is there anything they wish it could do?

Take good notes, then fix all the bugs, add features, and then finish your project!

## Ways to share your project
Your good work should be celebrated! Present the problem you were working to solve, and then demonstrate how your project addresses that problem. Here are some ideas for places to showcase your work.
 
* School Science Fair or Maker Fair

* Online Communities
 - Instructables
 - Hackster.io
 - Arduino Project Hub
 - Reddit communities like r/DIY or r/arduino
 - GitHub (if there's code to share)

* Local Organizations
 - Maker spaces
 - Public library tech programs
 - Youth STEM clubs
 - Local hackerspaces
 - 4-H clubs

* Social Media
 - YouTube tutorial
 - TikTok demonstration
 - Instagram project progress photos
 - Twitter/X thread documenting the build process
 
* Competitions
 - Google Science Fair
 - Local invention competitions
 - State/regional technology contests
 - Engineering challenges for students