# Introduction

Let's review coordinate grids and mapping x and y coordinates on a plane:

## Axes
* The basic coordinate grid has two axes:
	* **x-axis** which runs horizontally (left to right), *and*
	* **y-axis** which runs vertically (up to down).
	
## Origin

These two axes meet at a point called the origin, where both the x- and the y-values are zero. On this basic coordinate grid, the origin is in the lower left corner of the grid and has the coordinates (0,0).
	
## Coordinate pair
The first value in a coordinate pair is the x-value and the second value in a coordinate pair is the y-value, e.g., (x,y).

**Hint:** A simple way to remember which value comes first is to remember their order in the alphabet. The letter x comes before the letter y in the alphabet, and the x-coordinate comes before the y-coordinate in a coordinate pair.
	
## Coordinate value changes
On a basic coordinate grid,

* The value of the x-coordinate increases from left to right and is a measure of how many units a point is horizontally from the origin.
* The value of the y-coordinate increases from bottom to top and is a measure of how many units a point is vertically from the origin.
	
![Math coordinates](/static/courses/csintro/coordinates/math-coords.png)

## Coordinate grid and the micro:bit

The 5 x 5 grid of LEDs on the micro:bit represents a coordinate grid with a horizontal x-axis and a vertical y-axis. It has an origin, and you can refer to the position of the LEDs with coordinate pairs. There are similarities and differences between the micro:bit coordinate grid and basic coordinate grids in math class.

### Similar to coordinate grids in math
The values of the x-coordinates range from 0 through 4 and increase from left to right just as they do in the coordinate grids used in math class.

### Different from coordinate grids in math
	
It is important, however, to understand the two major differences between the micro:bit LED grid and the coordinate grid that you might be used to from other math classes:

* The origin (0,0) is in the top left corner.
* The values of the y-coordinates range from 0 through 4 and increase from top to bottom.

![micro:bit LED coordinates](/static/courses/csintro/coordinates/microbit-led-coords.png)

## Sidebar material

![Rene Descartes](/static/courses/csintro/coordinates/rene-descartes.jpg)
(image credit: Wikipedia Commons)

René Descartes (1596-1650), was a French philosopher and mathematician who developed the coordinate system we use today. A story goes that while lying in bed, he noticed a fly on the ceiling. In wondering how he could describe the fly’s exact position on the ceiling, he decided to use a corner of the ceiling as a reference point and then describe the fly’s position as a measure of how far away from the reference point one would need to travel horizontally and then vertically to reach the fly. His coordinate system proved useful in many ways including creating an important link between the studies of algebra and geometry. Geometric shapes could now be described by points on a coordinate plane.

## Knowledge Check

**Questions:**

1. What location is the origin on the micro:bit screen?
2. What is the range of x-values on the micro:bit screen, and in which direction do they increase?
3. What is the range of y-values on the micro:bit screen, and in which direction do they increase?

**Answers:**

1. (0,0) in the upper left
2. 0 to 4, increasing from left to right horizontally
3. 0 to 4, increasing from top to bottom vertically
