# Booleans

![micro:bit Combo Box](/static/courses/csintro/booleans/cover.jpeg)

This unit introduces the use of the **Boolean** data type to control the flow of a program, keep track of the status of the program, and to include or exclude certain conditions. In an unplugged activity, you will write pseudocode to simulate two coins being tossed at the same time. In the coding activity, you'll take the pseudocode from the unplugged activity and use it to code your micro:bit. In the project, you'll code your own unique program using Booleans and other blocks that you've explored and learned in the previous units.

## Lesson objectives 
You will...

* Understand what Booleans and Boolean operators are, and why and when to use them in a program.
* Learn how to create a Boolean, set the boolean to an initial value, and change the value of the boolean within a micro:bit program.
* Learn how to use the random **true** or **false** block. 
* Apply the above knowledge and skills to create a unique program that uses Booleans and Boolean operators as an integral part of the program.

## Lesson structure
* Introduction: Booleans in daily life
* Unplugged Activity: Two Heads are Better Than One
* micro:bit Activity: Double Coin Flipper
* Project: Boolean
* Assessment: Rubric
* Standards: Listed

## Lesson plan

1. [**Overview**: Booleans](/test/courses/csintro/booleans/overview)
2. [**Unplugged**: Two heads are better than one](/test/courses/csintro/booleans/unplugged)
3. [**Activity**: Double coin flipper](/test/courses/csintro/booleans/activity)
4. [**Project**: Boolean](/test/courses/csintro/booleans/project)

## Flipgrid

The [Flipgrid](https://info.flipgrid.com/) topic for the **Booleans** lesson: https://flipgrid.com/36e0c7e0

## Related standards

[Targeted CSTA standards](/test/courses/csintro/booleans/standards)