# Arrays

![Cover image](/static/courses/csintro/arrays/cover.jpg)

This lesson introduces the fundamental concept of storing and retrieving data in an ordered fashion using Arrays. We'll also look at JavaScript as an alternate way of creating and modifying code. We'll look at the structure of a Melody as a list of notes.
 
## Lesson objectives
You will...
* Explain the steps they would take to sort a series of numbers.
* Recognize three common sorting algorithms.
* Practice creating Arrays.
* Practice storing and retrieving values in Arrays.
* Learn common Array operations such as setting and getting values by index.
* Demonstrate understanding and apply skills by creating a musical instrument that uses a micro:bit and a program that correctly and effectively uses Arrays to store data.
 
## Lesson structure
* Introduction: Arrays
* Unplugged Activity: Different sorts
* micro:bit Activity: Headband charades, Starry Starry Night
* Project: Make a musical instrument
* Assessment: Rubric 
* Standards: Listed
 
## Lesson plan

1. [**Overview**: Arrays](/test/courses/csintro/arrays/overview)
2. [**Unplugged**: Different sorts](/test/courses/csintro/arrays/unplugged)
3. [**Activity**: Headband charades](/test/courses/csintro/arrays/activity)
4. [**Project**: Musical instrument ](/test/courses/csintro/arrays/project)

## Flipgrid

The [Flipgrid](https://info.flipgrid.com/) topic for the **Arrays** lesson: https://flipgrid.com/f0f1bbc5

## Related standards

[Targeted CSTA standards](/test/courses/csintro/arrays/standards)
