# Unplugged: What's your function & crazy conditionals

This is a classroom activity that teachers might choose to run with a classrom of students.

Materials
* Pencils
* Paper (or index cards)

![Inputs process outputs](/static/courses/csintro/algorithms/inputs-process-outputs.png)

In computer programming, algorithms are sets of instructions.

Algorithms ‘tell’ the computer how to process input and what, if any, output to produce.

An example of an algorithm you have seen in math class is the ‘function machine’.

![Inputs function output](/static/courses/csintro/algorithms/input-function-output.png)

A function machine takes an input, processes the input, and then delivers an output.

The inputs and their outputs are usually recorded in an input output table, where the value of x represents the input and the value of y represents the output. See example.

```
Input (x)	Output (y)
======================
    1           2
    2           4
    3           6
    4           8
```

A common math problem is to determine what processing is happening to the input that results in the given output. In the example above, each input is being doubled (multiplied by 2) to produce the corresponding output.

```
Input (x)	Processing =>	Output (y)
======================================
    1            * 2             2
    2            * 2             4
    3            * 2             6
    4            * 2             8
```

## Unplugged: What's your function?
For this activity, the students can work in pairs, Player A and Player B. The pairs will take turns being the function machine for their partner who will be providing input to be processed.

Direct the students how you would like them to record their work. 
They can use pencil and paper or index cards.
On paper, they can keep track of inputs and outputs in a table (see example above).
With index cards, Player A can write each input on one side of an index card, hand the card to Player B, who then writes the corresponding output on the other side of the card.

### To begin:
* Player B decides on a mathematical function or bit of processing* that will be done on whatever input she receives from Player A. 
* Player B should write down the function or bit of processing and set it aside, out of sight of Player A.
* Player A then gives Player B a number to process.
* Player B processes the number and returns an output to Player A.
* Player A can then state what function or bit of processing she thinks Player B is using on the input to produce the given output. One try per round of input/output.
* If Player A states the correct function, Player B confirms that it is correct by showing the previously hidden function and the players switch roles and start the game over.
* If Player A does not guess correctly, Player A provides another input that Player B processes and provides an output for.
* The goal is for Player A to figure out what function or bit of processing Player B is using in the fewest number of rounds of input/output possible.
* After each student has had at least one chance to be the function machine, play more rounds as time permits.

### Notes: 
* The difficulty level of the possible functions should be determined by the teacher and shared with the students ahead of playing. Alternately, the teacher can provide function cards that are handed out at random to be used by the players, rather than the players creating their own.
* The player providing the input should not just guess what the function is. She should be able to explain why she thinks her input resulted in the given output.
* Examples of ‘easier’ functions: 
> * [ ] Add 8
> * [ ] Subtract 6
> * [ ] Multiply by 3
> * [ ] Divide by 2
* Examples of more difficult functions:
> * [ ] Multiply by 2 and then subtract 1
> * [ ] Square the input
> * [ ] Return 20% of the input

## Unplugged: Crazy Conditionals
This is a fun, interactive exercise to introduce conditionals and event handlers as computer processing.  Read through the entire activity and adjust as needed for your class and classroom.
 
### Preparation: 
* Print & cut into strips with one conditional on each strip
* Note that some of the same conditionals can be given to multiple students, while other conditionals are to be given to just one student.
* Except for the first ‘BEGIN’ conditional, hand out the conditionals PRINT SIDE DOWN. 
* Besides the ‘BEGIN’ and ‘STOP’ conditional, give at least two other conditionals to each student. A lesson from this is that it is challenging for a student to keep track of a lot of different conditionals, though not so for a computer! : )
 
### Notes: 
* Some of the same conditionals can be given to multiple students, while other conditionals are to be given to just one student.
* Technically these conditionals are all event handlers because the students are simply waiting for a specific event to trigger them into action.
* Unless instructed otherwise, students do not speak or make noise during this activity.

### Extensions/Variations: 
* Add AND, OR, AND/OR statements to the conditionals.
* Create nested IF’s
* Let students create the IF’s
* Relate this activity to a system and have the students create the conditionals that would end in a product of some kind or the completion of some task.
 
Give these 2 conditionals to all students. 
* These 2 conditionals will be triggered only once. 
* These conditionals start and stop this activity.
* Give the first ‘BEGIN’ conditional to the students PRINT SIDE UP.
 
**IF** the teacher writes the word ‘**BEGIN**’ on the whiteboard,<br/>
**THEN** flip over the conditionals in front of you and follow the directions.
 
**IF** you see the word ‘**STOP**’ on the whiteboard,<br/>
**THEN** sit back, cross your arms, and look at the teacher (smile!).

=================================================================

Give these 6 conditionals to multiple students.
* These 6 conditionals may be triggered more than once.
* Walk around the classroom during the activity to trigger some of these conditionals.

**IF** the teacher says the word ‘popcorn’,<br/>
**THEN** stand up and say ‘Pop!’ once and sit back down.
 
**IF** any student stands up for any reason,<br/>
**THEN** clap 3 times.
 
**IF** anyone writes on the whiteboard with a GREEN marker,<br/>
**THEN** get up and touch something GREEN in the room and sit back down.
 
**IF** anyone walks past you while you are seated,<br/>
**THEN** snap your fingers 3 times.
 
**IF** someone snaps their fingers **AND** you have the letter ‘e’ in your first name,<br/>
**THEN** select a book from the bookcase and sit back down.
 
**IF** anyone writes anything on the whiteboard,<br/>
**THEN** get up and turn around in place one full turn and sit back down.
 
=================================================================

Give one student each of the following 7 conditionals. 
* These 7 conditionals will be triggered only once and set in motion the spelling of STOP on the whiteboard.
 
**IF** the teacher picks up a book,<br/>
**THEN** get up and write the letter S on the whiteboard and sit back down.
 
**IF** someone writes the letter S on the whiteboard,<br/>
**THEN** go open and close the classroom door and sit back down.
 
**IF** someone opens and closes the classroom door,<br/>
**THEN** get up and write the letter T (after the letter S) on the whiteboard.
 
**IF** someone writes the letter T on the whiteboard,<br/>
**THEN** get up and turn the lights on and off and sit back down.
 
**IF** someone turns on and off the lights,<br/>
**THEN** get up and write the letter O (after the letter T) on the whiteboard.
 
**IF** someone writes the letter O on the whiteboard,<br/>
**THEN** get up and sharpen a pencil.
 
**IF** someone sharpens a pencil,<br/>
**THEN** get up and write the letter P (after the letter O) on the whiteboard.

