# Project: Fidget Cube

![Sample fidget cube](/static/courses/csintro/algorithms/fidgetcube.jpg)

A fidget cube is a little cube with something different that you can manipulate on each surface. There are buttons, switches, and dials, and people who like to “fidget” find it relaxing to push, pull, press, and play with it. In this project, you will be challenged to turn the micro:bit into your very own “fidget cube”. 

Here's an example of a fidget cube:

* Original Kickstarter Fidget Cube - [Fidget Cube: A Vinyl Desk Toy](https://www.kickstarter.com/projects/antsylabs/fidget-cube-a-vinyl-desk-toy) (there is a funny video showing the fidget cube in action).

Consider some of the following questions:

* Do you fidget? How about someone you know?
* What kinds of things might that person fidget with? Spinning pens, fidget spinners, rings, coins? 
* There are many different versions of fidget cubes available now. Have you seen them before? Do you have one?
* What are the types of fidget activities on these cubes?
* If you could add or modify features of the fidget cube, what would you choose to do? 
* What would make the ultimate fidget cube?

Remember that a computing device has a number of inputs, and a number of outputs. The code that we'll write in this project will process input by telling the micro:bit what to do when various events occur.

## Project

Make a fidget cube out of the micro:bit by creating a unique output for each of the following inputs:

* on button A pressed
* on button B pressed
* on button A+B pressed
* on shake

See if you can combine a maker element similar to what you created in Lesson 1 by providing a holder for the micro:bit that holds it securely when you press one of the buttons.

![](/static/courses/csintro/algorithms/fidget-cube.jpg)
Sample fidget cube designs

## Project mod 
* Add more inputs and more outputs - use more than 4 different types of input. Try to use other types of output (other than LEDs) such as sound!