# Introduction

What is a micro:bit?
The [micro:bit](www.microbit.org) was created in 2015 in the UK by the BBC and partners to teach computer science to students. The BBC gave away a micro:bit to every Year 7 (6th grade) student in the UK. You can think of a micro:bit as a mini computer.
http://microbit.org

![BBC micro:bit](/static/courses/csintro/algorithms/bbc-microbit.jpg)

## What is a computer?
There are 4 main components that make up any computer:

![Computer components](/static/courses/csintro/algorithms/cpu.png)

1. The Processor – this is usually a small chip inside the computer, and it’s how the computer processes and transforms information. Have you heard of the term “CPU”?  CPU stands for Central Processing Unit. You can think of the processor as the brain of the computer - the faster the processor, the more quickly the computer can think.

2. The Memory – this is how the computer remembers things. There are two types of memory:
>* RAM (random access memory) - You can think of this as the computer’s short-term memory. Things that are stored here will disappear when the computer is turned off. Can you think of examples of things that are stored in our short-term memory? Things that you forget after you go to sleep?
>* Storage (also referred to as the “hard drive”) - This is the computer’s long-term memory, where it can store information even when power is turned off. Can you think of examples of things that are stored in our long-term memory? Things we never forget?

3. Inputs – This is how a computer takes in information from the world. In humans, our input comes in through our senses, such as our ears and eyes. Computer Inputs might be things like: Keyboard, mouse, touchscreen, camera, microphone, game controller, scanner. Can you think of others?

4. Outputs – This is how a computer displays or communicates information. As humans, we communicate information by using our mouths when we talk. What are some examples of communication that don’t involve talking, like blushing or sign language? Some examples of computer outputs are: monitor/screen, headphones/speakers, printer. Can you think of others?

Now, let’s look at our micro:bit, using the [features page on the microbit website](http://microbit.org/guide/features/) as a visual aid.

![micro:bit hardware](/static/courses/csintro/algorithms/microbit-hardware.png)

See if you can answer the following questions:

* Can you find the Processor? 
* How much memory does the micro:bit have? 
* Can you locate the following Inputs? Buttons, Pins, and Accelerometer/Compass
* Where are the Outputs?

Answers:

* Processor: On the back of the micro:bit, just below the Bluetooth and radio antenna
* Memory: 16K, which is smaller than many files on your computer!
* Inputs: Buttons (on board), Pins (at base) Note: Though not pictured, the Light Sensor is located on the LED lights.
* Outputs: LED lights, Pins

All computers need electricity to power them.  There are 3 ways to power your micro:bit:

* Connecting the micro:bit to a computer through the USB port at the top
* By connecting a battery pack to the battery connector
* Through the 3V Pin at the bottom (not the recommended way to power your micro:bit)

On the top left corner, you may notice that your micro:bit has a Bluetooth antenna. This means your micro:bit can communicate and send information to other micro:bits. We will learn more about this feature in Unit 10: Radio communication.

## Knowledge Check

Questions:

1. What are the four main components that make up any computer? 

2. How many programmable buttons are on the micro:bit? 

Answers:

1. The processor, the memory, the inputs and the outputs

2. Two