# Make

A guitar is a plucked stringed musical instrument. Normally, the guitar is an expensive instrument, but here we create a cheap and convenient DIY instrument that can help you enjoy and play real chords on an electric micro:bit guitar. Have fun and enjoy playing the micro:bit guitar by shifting the pitch up and down octaves.

## How it Works?

When you touch pin **1** or pin **2** and **GND** it will play a broken chord, but now you can move the chord down an octave (lowering its pitch) by pressing button **A** and move it up an octave (raising its pitch) by pressing button **B**.

The pitch (frequency) of a note doubles when you move up one octave: `middle A` has a frequency of 440Hz (440 vibrations per second), `high A` has a frequency of 880Hz. This is why making the vibrating part of guitar strings different lengths with your fingers changes the pitch of the note being played.

## Materials you need

* micro:bit and optional battery pack
* 4 crocodile clip leads
* cardboard, scissors, glue, tin foil
* headphones, buzzer, or powered speaker

## How to build and play your electric guitar

Watch this video to see how to make your electric guitar and play it:

https://youtu.be/Yocsl_80YsY

You can connect the electric guitar to some headphones with some crocodile clips you attach to the phone jack.

![Output connections for sound](/static/mb/projects/electric-guitar/connections.jpg)

Here are two pictures of the finished electric guitar with its connections:

![Electric guitar project 1](/static/mb/projects/electric-guitar/guitar-board1.jpg)

![Electric guitar project 2](/static/mb/projects/electric-guitar/guitar-board2.jpg)

Let's go on to code the guitar!

### ~button /projects/electric-guitar/code

Code

### ~
