# Crashy Bird

## ~avatar avatar

All the fun from the Flappy Bird game is coming to the @boardname@ as Crashy Bird!

## ~

This is a simple version of the Flappy Bird game for @boardname@. The objective is to direct a flying bird, which is moving continuously to the right, between sets of obstacles. If the player touches an obstacle, they lose. The purpose of this tutorial is to teach the basics of game sprites, arrays, and loops.

## Step 1: Add the Bird to the Game

First, we are going to add a sprite for the bird from the **Game** menu and make it blink.

```blocks
let bird: game.LedSprite = null
bird = game.createSprite(0, 2)
bird.set(LedSpriteProperty.Blink, 300)
```

## Step 2: Make the Bird fly

Before creating the code for the game actions, let's first add some controls so that we can move around. We'll control the bird by pressing the **A** button to go up or the **B** button to go down.

```blocks
let bird: game.LedSprite = null

input.onButtonPressed(Button.A, function () {
    bird.change(LedSpriteProperty.Y, -1)
})
input.onButtonPressed(Button.B, function () {
    bird.change(LedSpriteProperty.Y, 1)
})
```

## Step 3: Generating obstacles

This is where things will start to get interesting. We're going to randomly generate obstacles. We'll keep all obstacles inside the array. All obstacles will have a single hole for the bird to fly through.

First, create an array of `obstacles` which will hold all of the obstacle sprites.

```blocks
let obstacles: game.LedSprite[] = []
```

Now generate vertical obstacles consisting of 4 sprites and 1 random hole.
Create new variable called `emptyObstacleY`. Using ``||math:pick random||``, generate a random number from `0` to `4` and store it inside `emptyObstacleY`.

Using ``||loops:for||`` loop, iterate from `0` to `4`. For every coordinate not equal to `emptyObstacleY` create and add obstacle sprites to the end of the `obstacles` array.

```blocks
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []

emptyObstacleY = randint(0, 4)
for (let index = 0; index <= 4; index++) {
    if (index != emptyObstacleY) {
        obstacles.push(game.createSprite(4, index))
    }
}
```

Now with every @boardname@ restart you should see different autogenerated vertical obstacles.

Before continuing, make sure that obstacles are generated randomly and that the bird is moving up and down.

```blocks
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []
let bird: game.LedSprite = null

bird = game.createSprite(0, 2)
bird.set(LedSpriteProperty.Blink, 300)

emptyObstacleY = randint(0, 4)
for (let index = 0; index <= 4; index++) {
    if (index != emptyObstacleY) {
        obstacles.push(game.createSprite(4, index))
    }
}

input.onButtonPressed(Button.A, function () {
    bird.change(LedSpriteProperty.Y, -1)
})

input.onButtonPressed(Button.B, function () {
    bird.change(LedSpriteProperty.Y, 1)
})
```

## Step 4: Make obstacles move

Access each obstacle using a ``||for element||`` loop (_iterate_ over the `obstacles` array) and decrease the `obstacle` `X` coordinate by 1.
Right click on the ``||value||`` block and rename it to ``||obstacle||``
; then drag that ``||obstacle||`` block on top of ``||sprite||`` in the ``||game:change x||`` block.

```blocks
let obstacles: game.LedSprite[] = []

basic.forever(function () {
    for (let obstacle of obstacles) {
        obstacle.change(LedSpriteProperty.X, -1)
    }
    basic.pause(1000)
})
```

Obstacles should move towards left every second.

## Step 5: Make obstacles disappear

Make obstacles disappear after reaching leftmost corner. Iterate over all obstacles, delete the obstacle sprites where the `X` coordinate equals `0`, and remove them from the ``obstacles`` array.

```blocks
let obstacles: game.LedSprite[] = []

basic.forever(function () {
    while (obstacles.length > 0 && obstacles[0].get(LedSpriteProperty.X) == 0) {
        obstacles.removeAt(0).delete()
    }

    for (let obstacle of obstacles) {
        obstacle.change(LedSpriteProperty.X, -1)
    }
    basic.pause(1000)
})
```

## Step 6: Generate more obstacles

At the moment, our code generates just one vertical obstacle. We need to put obstacle generation code into the ``||basic:forever||`` loop so that it keeps generating more and more obstacles.

```blocks
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []

basic.forever(function () {
    while (obstacles.length > 0 && obstacles[0].get(LedSpriteProperty.X) == 0) {
        obstacles.removeAt(0).delete()
    }

    for (let obstacle of obstacles) {
        obstacle.change(LedSpriteProperty.X, -1)
    }
    emptyObstacleY = randint(0, 4)
    for (let index = 0; index <= 4; index++) {
        if (index != emptyObstacleY) {
            obstacles.push(game.createSprite(4, index))
        }
    }
    basic.pause(1000)
})
```

Now our screen is full of moving obstacles. Create some spaces between generated obstacles. Let's introduce a `ticks` variable to count how many iterations the ``||basic:forever||`` loop has done and execute obstacle creation only if `ticks` is divisible by 3.

```blocks
let ticks = 0
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []

basic.forever(function () {
    while (obstacles.length > 0 && obstacles[0].get(LedSpriteProperty.X) == 0) {
        obstacles.removeAt(0).delete()
    }

    for (let obstacle of obstacles) {
        obstacle.change(LedSpriteProperty.X, -1)
    }
    if (ticks % 3 == 0) {
        emptyObstacleY = randint(0, 4)
        for (let index = 0; index <= 4; index++) {
            if (index != emptyObstacleY) {
                obstacles.push(game.createSprite(4, index))
            }
        }
    }
    ticks += 1
    basic.pause(1000)
})
```

## Step 7: Game Over

Right now nothing happens when the bird is hit by obstacle. Fix this by iterating over the `obstacles` array and checking if any obstacle sprite coordinate equals the bird coordinate.

```blocks
let bird: game.LedSprite = null
let ticks = 0
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []

basic.forever(function () {
    while (obstacles.length > 0 && obstacles[0].get(LedSpriteProperty.X) == 0) {
        obstacles.removeAt(0).delete()
    }

    for (let obstacle of obstacles) {
        obstacle.change(LedSpriteProperty.X, -1)
    }
    if (ticks % 3 == 0) {
        emptyObstacleY = randint(0, 4)
        for (let index = 0; index <= 4; index++) {
            if (index != emptyObstacleY) {
                obstacles.push(game.createSprite(4, index))
            }
        }
    }

    for (let obstacle of obstacles) {
        if (obstacle.get(LedSpriteProperty.X) == bird.get(LedSpriteProperty.X) && obstacle.get(LedSpriteProperty.Y) == bird.get(LedSpriteProperty.Y)) {
            game.gameOver()
        }
    }

    ticks += 1
    basic.pause(1000)
})
```

## The final code

```blocks
let ticks = 0
let emptyObstacleY = 0
let obstacles: game.LedSprite[] = []
let index = 0
let bird: game.LedSprite = null
input.onButtonPressed(Button.A, function () {
    bird.change(LedSpriteProperty.Y, -1)
})
input.onButtonPressed(Button.B, function () {
    bird.change(LedSpriteProperty.Y, 1)
})
index = 0
obstacles = []
bird = game.createSprite(0, 2)
bird.set(LedSpriteProperty.Blink, 300)
basic.forever(function () {
    while (obstacles.length > 0 && obstacles[0].get(LedSpriteProperty.X) == 0) {
        obstacles.removeAt(0).delete()
    }
    for (let obstacle2 of obstacles) {
        obstacle2.change(LedSpriteProperty.X, -1)
    }
    if (ticks % 3 == 0) {
        emptyObstacleY = randint(0, 4)
        for (let index2 = 0; index2 <= 4; index2++) {
            if (index2 != emptyObstacleY) {
                obstacles.push(game.createSprite(4, index2))
            }
        }
    }
    for (let obstacle3 of obstacles) {
        if (obstacle3.get(LedSpriteProperty.X) == bird.get(LedSpriteProperty.X) && obstacle3.get(LedSpriteProperty.Y) == bird.get(LedSpriteProperty.Y)) {
            game.gameOver()
        }
    }
    ticks += 1
    basic.pause(1000)
})
```

## Exercises

Here are some additional features you can add to the game:

1. Count and show the Crashy Bird game score.
2. Make the obstacles move faster every time an obstacle is passed.

## About the authors

This project was created by [Karolis Vycius](https://www.linkedin.com/in/vycius/). The original Flappy Bird game was developed by [Dong Nguyen](https://en.wikipedia.org/wiki/Flappy_Bird).
