# Headband lesson

Create a charades game to play with your friends.

## Topic

Collection

## Quick Links

* [activity](/lessons/headbands/activity)
* [quiz](/lessons/headbands/quiz)
* [quiz answers](/lessons/headbands/quiz-answers)

## Class

Year 7

## Prior learning/place of lesson in scheme of work

Learn how to create a charades game using **[arrays](/types/array)** to store and retrieve data. We'll  learn how to create a charades game using global variables, a collection of strings, math add, Boolean, on logo down, on logo up, forever loop, if statements, running time as well as simple commands, such as show string and show number.

## What the teacher needs to know

* Algorithm: An unambiguous set of rules or a precise step-by-step guide to solve a problem or achieve a particular objective.
* Command: An instruction for the computer to execute, written in a particular programming language.
* Data: A structured set of numbers, possibly representing digitized text, images, sound or video, which can be processed or transmitted by a computer, also used for numerical (quantitative) information.
* Decomposing: The process through which problems or systems are broken down into their component parts, each of which may then be considered separately.
* Input: Data provided to a computer system, such as via a keyboard, mouse, microphone, camera or physical sensors.
* Output: The information produced by a computer system for its user, typically on a screen, through speakers or on a printer, but possibly through the control of motors in physical systems.
* Programmable toys: Robots designed for children to use, accepting input, storing short sequences of simple instructions and moving according to this stored program.
* Program: A stored set of instructions encoded in a language understood by the computer that does some form of computation, processing input and/or stored data to generate output.
* Script: A computer program typically executed one line at a time through an interpreter, such as the instructions for a Scratch character.
* Selection: A programming construct in which one section of code or another is executed depending on whether a particular condition is met.
* Sequence: To place program instructions in order, with each executed one after the other.
* Simulation: Using a computer to model the state and behaviour of real-world (or imaginary) systems, including physical or social systems; an integral part of most computer games.
* Variables: A way in which computer programs can store, retrieve or change data, such as a score, the time left, or the user’s name.

**QuickStart Computing Glossary

## Documentation

* **collection**
* **[variables](/blocks/variables)**
* **[Boolean](/blocks/logic/boolean)**
* **[on logo up](/reference/input/on-gesture)**
* **[on screen down](/reference/input/on-gesture)**
* **[on screen up](/reference/input/on-gesture)**
* **[show string](/reference/basic/show-string)**
* **[game library](/reference/game)**

## Resources

* Activity: [tutorial](/lessons/headbands/activity)
* Quiz: [quiz](/lessons/headbands/quiz)

## Objectives

* learn how a collection is a group of variables of the same type stored together
* learn how to create a global variable as a place where you can store data so that you can use it later in your code, accessible across functions and in nested code blocks
* learn how to repeat code in the background forever
* learn how to learn how to conditionally run code depending on whether a condition is true or not
* learn how to run code when the @boardname@ is oriented perpendicular to the floor with the logo down
* learn how to get the number of milliseconds elapsed since the script began
* learn how to show a string on the @boardname@ screen
* learn how to show a number of the @boardname@ screen

## Links to the National Curriculum Programmes of Study for Computing

## Progression Pathways / Computational Thinking Framework

### Algorithms

* Designs solutions (algorithms) that use repetition and two-way  selection, ie if, then and else.(AL)
*  Uses logical reasoning to predict  outputs, showing an awareness of inputs (AL)
* Recognises that different solutions exist for the same problem (AL) (AB)  Understands that iteration is the repetition of a process such as a loop (AL)
* Represents solutions using a structured notation (AL) (AB)

### Programming & Development

* Creates programs that implement algorithms to achieve given goals (AL)
*  Declares and assigns variables(AB)
* Understands the difference between, and appropriately uses if and if, then and else statements(AL)
* Uses a variable and relational operators within a loop to govern termination (AL) (GE)
* Has practical experience of a high-level textual language, including using standard libraries when programming(AB) (AL)
* Uses a range of operators and expressions e.g. Boolean, and applies them in the context of program control. (AL)
* Selects the appropriate data types(AL) (AB

### Data & Data Representation

* Understands the difference between data and information(AB)
* Performs more complex searches for information e.g. using Boolean and relational operators(AL) (GE) (EV)

### Hardware & Processing

* Knows that computers collect data from various input devices, including sensors and application software (AB)

### Communication Networks

* Demonstrates responsible use of technologies and online services, and knows a range of ways to report concerns Understands how search engines rank search results (AL)

### Information Technology

* Collects, organizes, and presents data and information in digital content (AB)
* Makes appropriate improvements to solutions based on feedback received, and can comment on the success of the solution (EV)
* Uses criteria to evaluate the quality of solutions, can identify improvements making some refinements to the solution, and future  solutions (EV)

Computational Thinking Concept: AB = Abstraction; DE = Decomposition; AL = Algorithmic Thinking; EV = Evaluation; GE = Generalisation

## Activity

* time: 20 min.
* [tutorial](/lessons/headbands/activity)
* [quiz](/lessons/headbands/quiz)

## Intended follow on

Publish script to the classroom.
