# Adding content to the home page

The Editor home page contains galleries of card links to projects, tutorials, lessons, videos, and other content sources. Many content items featured on the home page are hosted at the editor's website while some other items are from external sources.

Much of content available on the home page is developed or selected by the MakeCode Team. Content from other contributors is welcomed though and can be featured in the home page galleries.

![Home page content example](/static/mb/homepage-content-example.jpg)

## Content requirements

* Your content should be open source and free to use without any restrictions other than author attribution (you may specify an open source license the provides for such usage if you wish).
* The instructions should be well written and easy to follow.
* It should not include any personally identifiable information beyond the author's name (authors can remain anonymous too).
* Content will be reviewed and approved by the MakeCode Team.

## What you need to submit

To list a content item on the home page, you need to provide:

1. A name or title for the content item.
2. A brief one or two sentence description of what your content is or does (preferably in English for localization and is 30 words or less).
3. A thumbnail image that represents your content. Size the image to approximately **300 x 200** pixels.
4. A full URL for the item. For a tutorial, a complete tutorial URL is needed (see https://makecode.com/writing-docs/user-tutorials for more details).

Here is the content link information mapped to a home page card example:

![Home page link example](/static/mb/homepage-link-example.jpg)

1. Name or Title
2. Description
3. Thumbnail image (JPG or PNG)
4. Content link URL (not shown on the home page card)

## Submission process

Create and submit a [GitHub issue](@githubUrl@/issues) requesting your content to be listed. In the issue description, include the name or title of the content item, description, content URL, and copy in the thumbnail image. GitHub will automatically create an image URL for your thumbnail when you paste or drag your image in. Your issue description will look something like this when you write it:

```
Request to include a user content source on the editor home page. The content is a simple tutorial on how the create exploding sprites in Arcade.

## Home page link info

### Name

Exploding Sprites

### Description

Learn how to create moving sprites that randomly explode!

### Content Link

https://arcade.makecode.com/#tutorial:https://makecode.com/_rewr9iop

### Thumbnail

![image](https://github.com/microsoft/pxt/assets/27789908/f5c21294-1145-4010-8de0-560b8afbfeec)
```

## Approval #target-approval

For approval to add items to the home page, please follow the **[instructions](https://support.microbit.org/support/solutions/articles/19000054952-makecode-extension-and-tutorial-approval)** for submitting content to the Micro:bit Foundation.

## Featured content

To request featured space in the Home Page banner carousel, the requirements are similar to gallery items except for the image size. We require a link, a short description, and a "Hero" image that is **2100 x 500** pixels. Please note that banner space is very limited and approval for items included there is very selective.