# Extension Gallery

### ~ hint

#### Accessories

Many extensions are available to work with interface kits, add-on hardware, or other devices and accessories. Check out [the accessories pages on microbit.org](https://microbit.org/buy/accessories/) for more information on these accessories and where to buy them.

### ~

## Categories

```codecard
[{
    "name": "Display",
    "url": "/extensions/extension-gallery#display",
    "cardType": "link"
}, {
    "name": "Electronics",
    "url": "/extensions/extension-gallery#electronics",
    "cardType": "link"
}, {
    "name": "Gaming",
    "url": "/extensions/extension-gallery#gaming",
    "cardType": "link"
}, {
    "name": "Individual sensors",
    "url": "/extensions/extension-gallery#individual-sensors",
    "cardType": "link"
}, {
    "name": "IoT",
    "url": "/extensions/extension-gallery#iot",
    "cardType": "link"
}, {
    "name": "Kits",
    "url": "/extensions/extension-gallery#kits",
    "cardType": "link"
}, {
    "name": "LEDs and lights",
    "url": "/extensions/extension-gallery#leds-and-lights",
    "cardType": "link"
}, {
    "name": "Machine learning",
    "url": "/extensions/extension-gallery#machine-learning",
    "cardType": "link"
}, {
    "name": "Robotics",
    "url": "/extensions/extension-gallery#robotics",
    "cardType": "link"
}, {
    "name": "Sensor boards",
    "url": "/extensions/extension-gallery#sensor-boards",
    "cardType": "link"
}, {
    "name": "Sound",
    "url": "/extensions/extension-gallery#sound",
    "cardType": "link"
}, {
    "name": "Wearables",
    "url": "/extensions/extension-gallery#wearables",
    "cardType": "link"
 }, {
    "name": "Utilities",
    "url": "/extensions/extension-gallery#utilities",
    "cardType": "link"
}]
```

## Display

```codecard
[{
    "name": "Pythom1234 OLED Display SSD1306 128x64",
    "url": "/pkg/Pythom1234/pxt-oled",
    "cardType": "package"
}, {
    "name": "Joy-IT RB-TFT1.8",
    "url": "/pkg/joy-it/pxt-RB-TFT1.8",
    "cardType": "package"
}, {
    "name": "Kitronik 128x64 Display",
    "url": "/pkg/KitronikLtd/pxt-kitronik-128x64Display",
    "cardType": "package"
}, {
    "name": "Monk Makes 7-Segment",
    "url": "/pkg/monkmakes/monkmakes-7-segment",
    "cardType": "package"
}, {
    "name": "Pimoroni inky:bit",
    "url": "/pkg/pimoroni/pxt-inkybit",
    "cardType": "package"
}, {
    "name": "Kitronik :VIEW text32",
    "url": "/pkg/KitronikLtd/pxt-kitronik-viewtext32",
    "cardType": "package"
}, {
  "name": "XinaBox OD01 Display",
  "url":"/pkg/xinabox/pxt-OD01",
  "cardType": "package"
}, {
  "name": "Tinkertanker ssd1306 OLED",
  "url":"/pkg/Tinkertanker/pxt-oled-ssd1306",
  "cardType": "package"
}, {
  "name": "Tinkertanker ssd1306 OLED with reset pin",
  "url":"/pkg/Tinkertanker/pxt-oled-ssd1306",
  "cardType": "package"
}, {
  "name": "Muselab ssd1306 OLED",
  "url":"/pkg/MUSELAB/pxt-muselab-oled-v2",
  "cardType": "package"
}, {
  "name": "I2C LCD 1602 Display",
  "url": "/pkg/1010Technologies/pxt-makerbit-ir-lcd1602",
  "cardType": "package"
}]
```

## Electronics

```codecard
[{
  "name": "Kitronik Stop:Bit",
  "url":"/pkg/KitronikLtd/pxt-kitronik-stopbit",
  "cardType": "package"
}, {
  "name": "Kitronik Access:Bit",
  "url":"/pkg/KitronikLtd/pxt-kitronik-accessbit",
  "cardType": "package"
}, {
  "name": "PCA9685 LED controller",
  "url":"/pkg/jdarling/pxt-pca9685",
  "cardType": "package"
}, {
  "name": "Coolguy expansion board",
  "url":"/pkg/CoolGuy-official/pxt-coolguy",
  "cardType": "package"
}]
```

## Gaming

```codecard
[{
  "name": "Kittenbot JoyFrog",
  "url":"/pkg/KittenBot/pxt-joyfrog",
  "cardType": "package"
}, {
  "name": "Elecfreaks magic wand",
  "url":"/pkg/elecfreaks/pxt-magicwand",
  "cardType": "package"
}, {
  "name": "Kitronik :GAME ZIP64",
  "url":"/pkg/KitronikLtd/pxt-kitronik-zip-64",
  "cardType": "package"
}, {
  "name": "Kitronik :GAME Controller",
  "url":"/pkg/KitronikLtd/pxt-kitronik-game-controller",
  "cardType": "package"
}, {
  "name": "Sparkfun Gamer:bit",
  "url":"/pkg/sparkfun/pxt-gamer-bit",
  "cardType": "package"
}, {
  "name": "4tronix BitCommander",
  "url":"/pkg/4tronix/BitCommander",
  "cardType": "package"
}, {
  "name": "51bit SFC/NES controller",
  "url":"/pkg/51bit/SFC",
  "cardType": "package"
}, {
  "name": "Pimoroni touch:bit",
  "url":"/pkg/pimoroni/pxt-touchbit",
  "cardType": "package"
}, {
  "name": "ALS Robot JoyBit",
  "url":"/pkg/alsrobot-microbit-makecode-packages/ALSRobotJoyBit",
  "cardType": "package"
}]
```

## Individual sensors

```codecard
[{
 "name": "MonkMakes Plant Monitor",
  "url":"/pkg/monkmakes/plant-monitor-makecode",
  "cardType": "package"
}, {
 "name": "SGBotic Ultimate SR04",
  "url":"/pkg/SGBotic/pxt-SGBotic-Ultimate-SR04-RGB",
  "cardType": "package"
}, {
 "name": "TCS3200 Color sensor",
  "url":"/pkg/joy-it/pxt-SEN-Color",
  "cardType": "package"
}, {
 "name": "MPU6050 Gyroscope",
  "url":"/pkg/joy-it/SEN-MPU6050",
  "cardType": "package"
}, {
 "name": "DS18B20",
  "url":"/pkg/bsiever/microbit-dstemp",
  "cardType": "package"
}, {
 "name": "DS18B20 two wire",
  "url":"/pkg/bsiever/microbit-dstemp-2wire",
  "cardType": "package"
}, {
 "name": "DS3231",
  "url":"/pkg/keble6/pxt-DS3231",
  "cardType": "package"
}, {
 "name": "Let's Talk Science COZIR sensor",
  "url":"/pkg/letstalkscience/pxt-cozir",
  "cardType": "package"
}, {
  "name": "MAX6675",
  "url":"/pkg/microsoft/pxt-max6675",
  "cardType": "package"
}, {
  "name": "Sonar",
  "url":"/pkg/microsoft/pxt-sonar",
  "cardType": "package"
}, {
  "name": "Non-blocking Ultrasonic Sensing",
  "url":"/pkg/1010Technologies/pxt-makerbit-ultrasonic",
  "cardType": "package"
}, {
  "name": "HX711 Weight Sensor",
  "url":"/pkg/daferdur/pxt-myHX711",
  "cardType": "package"
}, {
  "name": "Bluetooth Temperature Sensor",
  "url":"/pkg/microsoft/pxt-bluetooth-temperature-sensor",
  "cardType": "package"
}, {
  "name": "Bluetooth MAX6675",
  "url":"/pkg/microsoft/pxt-bluetooth-max6675",
  "cardType": "package"
}, {
  "name": "ky040 rotary",
  "url":"/pkg/Tinkertanker/pxt-rotary-encoder-ky040",
  "cardType": "package"
}, {
  "name": "GY521",
  "url":"/pkg/PaulDFoster/pxt-microbit-GY521",
  "cardType": "package"
}, {
    "name": "DHT11 & DHT22 Temperature and Humidity",
    "url":"/pkg/alankrantas/pxt-DHT11_DHT22",
    "cardType": "package"
}, {
    "name": "gator:light Light sensor",
    "url":"/pkg/sparkfun/pxt-gator-light",
    "cardType": "package"
}, {
    "name": "gator:temp Temperature Sensor",
    "url":"/pkg/sparkfun/pxt-gator-temp",
    "cardType": "package"
}, {
    "name": "gator:microphone Microphone",
    "url":"/pkg/sparkfun/pxt-gator-microphone",
    "cardType": "package"
}, {
    "name": "gator:soil Soil Sensor",
    "url":"/pkg/sparkfun/pxt-gator-soil",
    "cardType": "package"
}, {
    "name": "gator:temp Particle Sensor",
    "url":"/pkg/sparkfun/pxt-gator-particle",
    "cardType": "package"
}, {
    "name": "MonkMakes Sensor",
    "url":"/pkg/monkmakes/pxt-sensor",
    "cardType": "package"
}, {
    "name": "ALS Robot Electromagnet",
    "url":"/pkg/alsrobot-microbit-makecode-packages/ALSRobotElectromagnet",
    "cardType": "package"
}, {
    "name": "MakerBit Touch MPR121",
    "url": "/pkg/1010Technologies/pxt-makerbit-touch",
    "cardType": "package"
}, {
    "name": "Keyestudio Infrared Receiver",
    "url": "/pkg/1010Technologies/pxt-makerbit-ir-receiver",
    "cardType": "package"
}, {
    "name": "BMP280 Barrometer",
    "url": "/pkg/rebeccaclavier/pxt-bmp280",
    "cardType": "package"
}, {
    "name": "STTS751 temperature Sensor",
    "url": "/pkg/makecode-extensions/STTS751",
    "cardType": "package"
}, {    
    "name": "LSM6DSO Accelerometer/Gyroscope",
    "url": "/pkg/makecode-extensions/LSM6DSO",
    "cardType": "package"
}, {    
    "name": "LPS22 Pressure",
    "url": "/pkg/makecode-extensions/LPS22",
    "cardType": "package"
}, {
    "name": "LIS2DW12 motion sensor",
    "url": "/pkg/makecode-extensions/LIS2DW12",
    "cardType": "package"
}, {    
    "name": "LIS2MDL magnetic sensor",
    "url": "/pkg/makecode-extensions/LIS2MDL",
    "cardType": "package"
}, {
    "name": "HTS221 Humidity and temperature",
    "url": "/pkg/makecode-extensions/HTS221",
    "cardType": "package"
}, {
    "name": "gator:UV UV Light sensor",
    "url":"/pkg/sparkfun/pxt-gator-UV",
    "cardType": "package"
}, {
    "name": "Sensirion SEN55 (Air Quality) Sensor",
    "url":"/pkg/bsiever/pxt-sen55",
    "cardType": "package"
}]
```

## IoT

```codecard
[{
  "name": "DFRobot IoT Cloud Kit",
  "url":"/pkg/DFRobot/pxt-DFRobot_IoT_Cloud_Kit",
  "cardType": "package"
}, {
  "name": "iClass IoT",
  "url":"/pkg/KelieLeung/pxt-iClassIoT",
  "cardType": "package"
}, {
  "name": "Kittenbot Wifi",
  "url":"/pkg/KittenBot/pxt-kittenwifi",
  "cardType": "package"
}, {
  "name": "ESP8266 AT",
  "url":"/pkg/CytronTechnologies/pxt-esp8266",
  "cardType": "package"
}, {
  "name": "Wappsto:bit",
  "url":"/pkg/Wappsto/pxt-wappsto",
  "cardType": "package"
}, {
  "name": "Hardwario IoT Kit",
  "url":"/pkg/hardwario/pxt-microbit-hardwario",
  "cardType": "package"
}, {
  "name": "Pi Supply Lora Node",
  "url":"/pkg/PiSupply/pxt-iot-lora-node",
  "cardType": "package"
}, {
  "name": "WiFi:Bit",
  "url":"/pkg/SolderedElectronics/pxt-wifi",
  "cardType": "package"
}, {
  "name": "ESP8266 and ThingSpeak",
  "url":"/pkg/alankrantas/pxt-ESP8266_ThingSpeak",
  "cardType": "package"
}, {
  "name": "DFRobot microIoT board",
  "url":"/pkg/DFRobot/pxt-DFRobot-microIoT",
  "cardType": "package"
}, {
  "name": "Muselab WiFi IoT Shield",
  "url":"/pkg/MUSELAB/pxt-wifi-shield",
  "cardType": "package"
}]
```

## Kits

```codecard
[{
   "name": "Smarthon Smart City",
   "url": "/pkg/SMARTHON/pxt-smartcity",
   "cardType": "package"
}, {
   "name": "HacKids hack:bit",
   "url": "/pkg/HackidsEdu/pxt-hackbit",
   "cardType": "package"
}, {
   "name": "KittenBot Sugar",
   "url": "/pkg/KittenBot/pxt-sugar",
   "cardType": "package"
}, {
   "name": "KittenBot Powerbrick",
   "url": "/pkg/KittenBot/pxt-powerbrick",
   "cardType": "package"
}, {
   "name": "Kitronik LAB:bit",
   "url": "/pkg/KitronikLtd/pxt-kitronik-lab-bit",
   "cardType": "package"
}, {
   "name": "PT-BOT PTKidsBIT",
   "url": "/pkg/iBuilds/pxt-PTKidsBIT",
   "cardType": "package"
}, {
   "name": "Stemhub City",
   "url": "/pkg/stemhub/pxt-StemhubCity",
   "cardType": "package"
}, {
   "name": "Tinkercademy Tinker:Kit",
   "url": "/pkg/Tinkertanker/pxt-tinkercademy-tinker-kit",
   "cardType": "package"
}, {
   "name": "Freenove Starter Kit",
   "url": "/pkg/Freenove/Makecode-Extension-Starter-Kit",
   "cardType": "package"
}, {
  "name": "Elecfreaks PlanetX sensor kit",
  "url":"/pkg/elecfreaks/pxt-PlanetX",
  "cardType": "package"
}, {
  "name": "Inksmith Climate Action Kit: Land",
  "url":"/pkg/climate-action-kits/pxt-climate-action-kit-land",
  "cardType": "package"
}, {
  "name": "Inksmith Climate Action Kit: Energy",
  "url":"/pkg/climate-action-kits/pxt-climate-action-kit-land",
  "cardType": "package"
}, {
  "name": "Grove inventor kit",
  "url":"/pkg/Seeed-Studio/pxt-grove",
  "cardType": "package"
}, {
  "name": "Minode Kit",
  "url":"/pkg/minodekit/pxt-minode",
  "cardType": "package"
}, {
  "name": "DFRobot Boson Kit",
  "url":"/pkg/dfrobot/pxt-dfrobot_bosonkit",
  "cardType": "package"
}, {
  "name": "Joy-IT Joy-Pi Advanced",
  "url":"/pkg/joy-it/pxt-RB-JoyPi-Advanced",
  "cardType": "package"
}, {
  "name": "FWD Edu Climate Action Kit Gen. 2 Kit",
  "url":"/pkg/climate-action-kits/pxt-fwd-edu",
  "cardType": "package"
}]
```

## LEDs and lights

```codecard
[{
  "name": "Kitronik Lamp:Bit",
  "url":"/pkg/KitronikLtd/pxt-kitronik-lampbit",
  "cardType": "package"
}, {
  "name": "Kitronik Halo HD",
  "url":"/pkg/KitronikLtd/pxt-kitronik-halohd",
  "cardType": "package"
}, {
  "name": "NeoPixel",
  "url":"/pkg/microsoft/pxt-neopixel",
  "cardType": "package"
}, {
    "name": "WS2812B",
    "url": "/pkg/microsoft/pxt-ws2812b",
    "cardType": "package"
}, {
  "name": "4tronix Cube:Bit",
  "url":"/pkg/4tronix/cubebit",
  "cardType": "package"
}, {
  "name": "51bit ColorBit",
  "url":"/pkg/51bit/ColorBit",
  "cardType": "package"
}, {
  "name": "Kitronik Zip Tile",
  "url":"/pkg/KitronikLtd/pxt-kitronik-zip-tile",
  "cardType": "package"
}, {
  "name": "MAX7219 8x8",
  "url":"/pkg/alankrantas/pxt-MAX7219_8x8",
  "cardType": "package"
}]
```

## Machine learning

```codecard
[{
  "name": "Kocoafab COCOCAM",
  "url":"/pkg/ekkai/aicococam",
  "cardType": "package"
}, {
  "name": "KittenBot KOI2 AI module",
  "url":"/pkg/KittenBot/pxt-koi2",
  "cardType": "package"
}, {
  "name": "KittenBot KOI AI module",
  "url":"/pkg/KittenBot/pxt-koi",
  "cardType": "package"
}, {
  "name": "Elecfreaks Smart AI Lens",
  "url":"/pkg/elecfreaks/pxt-PlanetX-AI",
  "cardType": "package"
}, {
  "name": "MU Vision camera",
  "url":"/pkg/mu-opensource/pxt-muvision",
  "cardType": "package"
}, {
  "name": "DFRobot HuskyLens",
  "url":"/pkg/DFRobot/pxt-DFRobot_HuskyLens",
  "cardType": "package"
}]
```
## Robotics

```codecard
[{
  "name": "Elecfreaks XGO Rider",
  "url":"/pkg/elecfreaks/XGO-Rider",
  "cardType": "package"
}, {
  "name": "SIYEENOVE mCar",
  "url":"/pkg/siyeenove/pxt_mcar",
  "cardType": "package"
}, {
  "name": "Cytron SUMO:BIT",
  "url":"/pkg/CytronTechnologies/pxt-sumobit",
  "cardType": "package"
}, {
  "name": "PARALLAX cyber:bot",
  "url":"/pkg/parallaxinc/cyberbot_makecode",
  "cardType": "package"
}, {
  "name": "Kitronik Craft & Code",
  "url":"/pkg/KitronikLtd/pxt-kitronik-Craft-and-Code",
  "cardType": "package"
}, {
  "name": "Lectrify Brick:Bit",
  "url":"/pkg/softsmyth/lectrify-b4k",
  "cardType": "package"
}, {
  "name": "KittenBot TabbyBot",
  "url":"/pkg/KittenBot/pxt-tabbyrobot",
  "cardType": "package"
}, {
  "name": "Gcube",
  "url":"/pkg/roborisen/gcube",
  "cardType": "package"
}, {
  "name": "Roversa",
  "url":"/pkg/eb8ga/pxt-roversa-2",
  "cardType": "package"
}, {
  "name": "4tronix M.A.R.S. Rover",
  "url":"/pkg/4tronix/mars-rover",
  "cardType": "package"
}, {
  "name": "Cytron MOTION:BIT",
  "url":"/pkg/CytronTechnologies/pxt-motionbit",
  "cardType": "package"
}, {
  "name": "MAKE&LEARN Didacbot",
  "url":"/pkg/MakeAndLearn/pxt-didacbot",
  "cardType": "package"
}, {
  "name": "Resolute Apprentice Car",
  "url":"/pkg/resolute-support/pxt-apprentice_Car",
  "cardType": "package"
}, {
  "name": "Elecfreaks XGO",
  "url":"/pkg/elecfreaks/pxt-xgo",
  "cardType": "package"
}, {
  "name": "Robotixlab Theta",
  "url":"/pkg/4tronix/Theta",
  "cardType": "package"
}, {
  "name": "Kitronik :CREATE Simple Servo Control Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-simple-servo",
  "cardType": "package"
}, {
  "name": "Kittenbot miniLFR",
  "url":"/pkg/KittenBot/pxt-minilfr",
  "cardType": "package"
}, {
  "name": "Cytron ZOOM:BIT",
  "url":"/pkg/CytronTechnologies/pxt-zoombit",
  "cardType": "package"
}, {
  "name": "Kid Spark Spark:bit",
  "url":"/pkg/KidSpark/pxt-sparkbit",
  "cardType": "package"
}, {
  "name": "BPI TriodeCar",
  "url":"/pkg/BPI-STEAM/pxt-triodecar",
  "cardType": "package"
}, {
  "name": "ArtecRobo Kit",
  "url":"/pkg/artec-kk/pxt-artecrobo-kit",
  "cardType": "package"
}, {
  "name": "Elecfreaks DRONE:BIT",
  "url":"/pkg/elecfreaks/pxt-Dronebit/",
  "cardType": "package"
}, {
  "name": "MakeKit Hoverbit",
  "url":"/pkg/gomakekit/Hoverbit_V2",
  "cardType": "package"
}, {
  "name": "Stemhubbit car",
  "url":"/pkg/stemhub/pxt-Stemhubbit",
  "cardType": "package"
}, {
  "name": "MATRIX Micro",
  "url":"/pkg/matrix-robotics/pxt-MatrixMicro",
  "cardType": "package"
}, {
  "name": "PTKidsBIT",
  "url":"/pkg/iBuilds/pxt-PTKidsBIT-Robot",
  "cardType": "package"
}, {
  "name": "Finch 2.0",
  "url":"/pkg/BirdBrainTechnologies/pxt-finch",
  "cardType": "package"
}, {
  "name": "Bouw je BEP",
  "url":"/pkg/Bouw-je-BEP/Bouw-je-BEP",
  "cardType": "package"
}, {
  "name": "DF Robot Maqueen Plus",
  "url":"/pkg/DFRobot/pxt-DFRobot-Maqueenplus",
  "cardType": "package"
}, {
  "name": "DF Robot Maqueen Plus V2",
  "url":"/pkg/DFRobot/pxt-DFRobot_MaqueenPlus_v20",
  "cardType": "package"
}, {
  "name": "Joy IT Joy Car",
  "url":"/pkg/joy-it/Joy-Car",
  "cardType": "package"
}, {
  "name": "Kitronik :MOVE Motor",
  "url":"/pkg/KitronikLtd/pxt-kitronik-move-motor",
  "cardType": "package"
}, {
  "name": "A4 Technologies CODO",
  "url":"/pkg/CODOmicrobit/pxt-CODO",
  "cardType": "package"
}, {
  "name": "Strawbees Robotic Inventions Kit",
  "url":"/pkg/strawbees/pxt-robotic-inventions",
  "cardType": "package"
}, {
  "name": "Kitronik :MOVE mini",
  "url":"/pkg/KitronikLtd/pxt-kitronik-servo-lite",
  "cardType": "package"
}, {
  "name": "Kitronik Integrated Robotics Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-robotics-board",
  "cardType": "package"
}, {
  "name": "Kitronik Motor Driver Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-motor-driver",
  "cardType": "package"
}, {
  "name": "Kitronik 16 Servo Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-i2c-16-servo",
  "cardType": "package"
}, {
  "name": "YFROBOT Valon",
  "url":"/pkg/YFROBOT-TM/pxt-yfrobot-valon",
  "cardType": "package"
}, {
  "name": "4tronix BitBot",
  "url":"/pkg/4tronix/BitBot",
  "cardType": "package"
},{
  "name": "4tronix Orbit",
  "url":"/pkg/4tronix/Orbit",
  "cardType": "package"
}, {
  "name": "4tronix Drive:Bit",
  "url":"/pkg/4tronix/DriveBit",
  "cardType": "package"
}, {
  "name": "4tronix Servo:Bit",
  "url":"/pkg/4tronix/ServoBit",
  "cardType": "package"
}, {
  "name": "4tronix MiniBit",
  "url":"/pkg/4tronix/MiniBit",
  "cardType": "package"
}, {
  "name": "Elecfreaks TPBot",
  "url":"/pkg/elecfreaks/pxt-TPBot",
  "cardType": "package"
}, {
  "name": "DF Robot Maqueen",
  "url":"/pkg/DFRobot/pxt-maqueen",
  "cardType": "package"
}, {
  "name": "Sunfounder Sloth",
  "url":"/pkg/sunfounder/pxt-sloth",
  "cardType": "package"
}, {
  "name": "Sphero RVR",
  "url":"/pkg/sphero-inc/sphero-sdk-microbit-makecode",
  "cardType": "package"
}, {
  "name": "Sparkfun Moto:bit",
  "url":"/pkg/sparkfun/pxt-moto-bit",
  "cardType": "package"
}, {
 "name": "EBOTICS MIBO",
  "url":"/pkg/EBOTICS/pxt-eboticsMIBO",
  "cardType": "package"
}, {
  "name": "ALSRobot MinCruise",
  "url":"/pkg/alsrobot-microbit-makecode-packages/MiniCruise",
  "cardType": "package"
}, {
  "name": "ReroKit rero:micro",
  "url":"/pkg/ReRoKit/pxt-reromicro",
  "cardType": "package"
}, {
  "name": "PLEN bit full",
  "url":"/pkg/plenprojectcompany/pxt-PLENbit_full",
  "cardType": "package"
}, {
  "name": "PLEN bit",
  "url":"/pkg/plenprojectcompany/pxt-PLENbit",
  "cardType": "package"
}, {
  "name": "UCL Junk Robot",
  "url":"/pkg/chevyng/pxt-ucl-junkrobot",
  "cardType": "package"
}, {
  "name": "Elecfreaks Cutebot",
  "url":"/pkg/elecfreaks/pxt-cutebot",
  "cardType": "package"
}, {
  "name": "Elecfreaks Cutebot Pro",
  "url":"/pkg/elecfreaks/pxt-cutebot-pro",
  "cardType": "package"
}, {
  "name": "Kittenbot RobotBit",
  "url":"/pkg/kittenbot/pxt-robotbit",
  "cardType": "package"
}, {
  "name": "inex iBit",
  "url":"/pkg/emwta/pxt-iBit",
  "cardType": "package"
}, {
  "name": "InkSmith k8 robotics kit",
  "url":"/pkg/k8robotics/pxt-k8",
  "cardType": "package"
}, {
  "name": "Freenove Micro:Rover",
  "url":"/pkg/Freenove/Makecode-Extension-Rover",
  "cardType": "package"
}, {
  "name": "Gigglebot",
  "url":"/pkg/dexterind/pxt-giggle",
  "cardType": "package"
}, {
  "name": "Robobit",
  "url":"/pkg/4tronix/Robobit",
  "cardType": "package"
}, {
  "name": "Pi Supply Bit:Buggy",
  "url":"/pkg/PiSupply/pxt-bitbuggy",
  "cardType": "package"
}, {
  "name": "ALS Robot Coo Coo",
  "url":"/pkg/alsrobot-microbit-makecode-packages/CooCoo",
  "cardType": "package"
}, {
  "name": "ALS Robot CruiseBit",
  "url":"/pkg/alsrobot-microbit-makecode-packages/CruiseBit",
  "cardType": "package"
}, {
  "name": "Hummingbird Bit",
  "url":"/pkg/BirdBrainTechnologies/pxt-hummingbird-bit",
  "cardType": "package"
}, {
  "name": "Inex iKB-1 controller board",
  "url":"/pkg/jcubuntu/pxt-iKB1",
  "cardType": "package"
}, {
  "name": "MakerBit motor controller",
  "url":"/pkg/1010Technologies/pxt-makerbit-motor",
  "cardType": "package"
}, {
  "name": "mikRobot",
  "url":"/pkg/KS-Bulme/pxt-mikRobot",
  "cardType": "package"
}, {
  "name": "Tobbie II",
  "url":"/pkg/kaku111/pxt-tobbieII",
  "cardType": "package"
}, {
  "name": "Kitronik ACCESS:bit",
  "url":"/pkg/KitronikLtd/pxt-kitronik-accessbit",
  "cardType": "package"
}, {
  "name": "Kitronik Fischertechnik interface",
  "url":"/pkg/KitronikLtd/pxt-kitronik-fischertechnik",
  "cardType": "package"
}, {
  "name": "Keigan Motor",
  "url": "/pkg/keigan-motor/pxt-KeiganMotor",
  "cardType": "package"
}, {
  "name": "TCEA Nexus:bit and Nexusbot",
  "url":"/pkg/beyond-coding-tw/pxt-nexusbot",
  "cardType": "package"
}, {
  "name": "Kitronik Klip Motor",
  "url":"/pkg/KitronikLtd/pxt-kitronik-klip-motor",
  "cardType": "package"
}, {
  "name": "Keyestudio Robot Car",
  "url":"/pkg/Veilkrand/pxt-RobotCar",
  "cardType": "package"  
}, {
  "name": "TinkerTanker Stepper Motor",
  "url":"/pkg/Tinkertanker/pxt-stepper-motor",
  "cardType": "package"
}, {
  "name": "ALS Robot Keyboard",
  "url":"/pkg/alsrobot-microbit-makecode-packages/ALSRobotKeyboard",
  "cardType": "package"
}, {
    "name": "Elecfreaks NeZha",
    "url": "/pkg/elecfreaks/pxt-nezha",
    "cardType": "package"
}, {
    "name": "Elecfreaks NeZha V2",
    "url": "/pkg/elecfreaks/pxt-nezha2",
    "cardType": "package"
}]
```

## Sensor boards

```codecard
[{
    "name": "Joy IT RFID Module MFRC-522",
    "url": "/pkg/joy-it/pxt-rfid-mfrc522",
    "cardType": "package"
}, {
  "name": "Joy-IT ADS1115",
  "url":"/pkg/joy-it/pxt-ads1115",
    "cardType": "package"
}, {
  "name": "DFRobot Environment Science Board ",
  "url":"/pkg/DFRobot/pxt-DFRobot_Environment_Science",
  "cardType": "package"
}, {
  "name": "PT-BOT KidsBIT",
  "url":"/pkg/iBuilds/pxt-PTKidsBIT-IoT",
  "cardType": "package"
}, {
  "name": "Kitronik Air Quality & Environmental Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-air-quality",
  "cardType": "package"
}, {
  "name": "DFRobot Natural Science Board",
  "url":"/pkg/DFRobot/pxt-DFRobot-NaturalScience",
  "cardType": "package"
}, {
  "name": "Kitronik Klimate Board",
  "url":"/pkg/KitronikLtd/pxt-kitronik-klimate",
  "cardType": "package"
}, {
  "name": "Kitronik Smart Greenhouse",
  "url":"/pkg/KitronikLtd/pxt-kitronik-smart-greenhouse",
  "cardType": "package"
}, {
  "name": "Make&Learn micro:shield",
  "url":"/pkg/MakeAndLearn/pxt-microshield",
  "cardType": "package"
}, {
  "name": "Sparkfun Weather:bit",
  "url":"/pkg/sparkfun/pxt-weather-bit",
  "cardType": "package"
}, {
  "name": "Sparkfun gator:environment",
  "url":"/pkg/sparkfun/pxt-gator-environment",
  "cardType": "package"
}, {
  "name": "XinaBox SW01 Advanced Weather Sensor",
  "url":"/pkg/xinabox/pxt-SW01",
  "cardType": "package"
}, {
  "name": "Cytron Edubit",
  "url":"/pkg/CytronTechnologies/pxt-edubit",
  "cardType": "package"
}, {
  "name": "Cytron Rekabit",
  "url":"/pkg/CytronTechnologies/pxt-rekabit",
  "cardType": "package"
}, {
  "name": "Cytron Rekabit RBT Project Kit",
  "url":"/pkg/CytronTechnologies/pxt-rekabit-rbt-project-kit",
  "cardType": "package"
}, {
  "name": "Imagimaker Magisheild",
  "url":"/pkg/Imagimaker/pxt-imagimaker",
  "cardType": "package"
}, {
  "name": "Kitronik clip detector",
  "url": "/pkg/KitronikLtd/pxt-kitronik-clip-detector",
  "cardType": "package"  
}, {
  "name": "Pimoroni Envirobit",
  "url": "/pkg/pimoroni/pxt-envirobit",
  "cardType": "package"
}, {
  "name": "Pimoroni Automationbit",
  "url":"/pkg/pimoroni/pxt-automationbit",
  "cardType": "package"
}, {
  "name": "51bit Smart Tools",
  "url": "/pkg/51bit/SmartTools",
  "cardType": "package"
}, {
  "name": "MakerBit",
  "url": "/pkg/1010Technologies/pxt-makerbit",
  "cardType": "package"
}, {
  "name": "MakerBit Pins",
  "url": "/pkg/1010Technologies/pxt-makerbit-pins",
  "cardType": "package"
}, {
  "name": "Elecfreaks Wukon",
  "url": "/pkg/elecfreaks/pxt-wukong",
  "cardType": "package"
}, {
  "name": "Elite Longanbit",
  "url": "/pkg/longan-link/pxt-longanbit",
  "cardType": "package"
}, {
  "name": "Adafruit Crickit",
  "url": "/pkg/adafruit/pxt-crickit",
  "cardType": "package"
}, {
  "name": "Adafruit Seesaw",
  "url": "/pkg/adafruit/pxt-seesaw",
  "cardType": "package"
}]
```

## Sound

```codecard
[{
  "name": "Sonification",
  "url":"/pkg/davidnsousa/sonification",
  "cardType": "package"
}, {
  "name": "Kitronik Klef Piano",
  "url":"/pkg/KitronikLtd/pxt-kitronik-klef-piano",
  "cardType": "package"
}, {
  "name": "Catalex Serial MP3 Player v1.0",
  "url": "/pkg/1010Technologies/pxt-makerbit-mp3",
  "cardType": "package"
}, {
  "name": "51bit DFPlayer mini",
  "url":"/pkg/51bit/dfplayermini",
  "cardType": "package" 
}]
```

## Wearables

```codecard
[{
  "name": "4tronix EggBit",
  "url":"/pkg/4tronix/EggBit",
  "cardType": "package"
}, {
  "name": "Bright Wearables Bright Board",
  "url":"/pkg/BrightWearables/pxt-microbit-brightboard",
  "cardType": "package"
}]
```

## Utilities
```codecard
[{
  "name": "States",
  "url": "/pkg/hovavo/pxt-states",
  "cardType": "package"
}, {
  "name": "Hebrew",
  "url": "/pkg/shahart/heb-microbit",
  "cardType": "package"
}, {
  "name": "Faces",
  "url": "/pkg/GrandpaBond/pxt-faces",
  "cardType": "package"
}, {
  "name": "Makey Makey Code-a-Key",
  "url": "/pkg/joylabz/code-a-key-extension",
  "cardType": "package"
}, {
  "name": "FlexFX",
  "url": "/pkg/GrandpaBond/pxt-flexfx",
  "cardType": "package"
}, {
  "name": "Meter",
  "url": "/pkg/GrandpaBond/pxt-meter",
  "cardType": "package"
}, {
  "name": "Morse Code",
  "url": "/pkg/bsiever/pxt-morse",
  "cardType": "package"
}, {
  "name": "Button clicks",
  "url": "/pkg/bsiever/microbit-pxt-clicks",
  "cardType": "package"
}, {
  "name": "Rotate Display",
  "url":"/pkg/bsiever/microbit-pxt-rotate",
  "cardType": "package"
}, {
  "name": "Bluetooth HID",
  "url":"/pkg/bsiever/microbit-pxt-blehid",
  "cardType": "package"
}, {
  "name": "Soroban abacus",
  "url":"/pkg/aorczyk/soroban",
  "cardType": "package"
}, {  
  "name": "Lego PF recorder",
  "url":"/pkg/aorczyk/pf-recorder",
  "cardType": "package"
}, {
  "name": "Lego PF transmitter",
  "url":"/pkg/aorczyk/lego-pf-transmitter",
  "cardType": "package"
}, {
  "name": "Lego PF receiver",
  "url":"/pkg/aorczyk/lego-pf-receiver",
  "cardType": "package"
}, {
  "name": "Kodely dot",
  "url":"/pkg/Kodely-io/dot",
  "cardType": "package"
}, {
  "name": "Wait until...",
  "url":"/pkg/TeacherPinky/Wait-Until-Blocks",
  "cardType": "package"
}, {
  "name": "micro:bit power saving",
  "url":"/pkg/microbit-foundation/pxt-microbit-v2-power",
  "cardType": "package"
}, {
  "name": "DS3231 Real Time Clock",
  "url":"/pkg/AlexandreFrolov/DS3231",
  "cardType": "package"
}, {
  "name": "Time & Date",
  "url":"/pkg/bsiever/microbit-pxt-timeanddate",
  "cardType": "package"
}, {
  "name": "Kitronik Realtime Clock",
  "url":"/pkg/KitronikLtd/pxt-kitronik-rtc",
  "cardType": "package"
}, {
  "name": "Code Dojo Olney",
  "url":"/pkg/CoderDojoOlney/pxt-olney",
  "cardType": "package"
}, {
  "name": "Inventura textbook",
  "url":"/pkg/assirati/pxt-inventura",
  "cardType": "package"
}, {
  "name": "micro:turtle",
  "url":"/pkg/microsoft/pxt-microturtle",
  "cardType": "package"
}, {
  "name": "MIDI",
  "url":"/pkg/microsoft/pxt-midi",
  "cardType": "package"
}, {
  "name": "Bluetooth MIDI",
  "url":"/pkg/microsoft/pxt-bluetooth-midi",
  "cardType": "package"
}, {
  "name": "BlockyTalkyBLE",
  "url":"/pkg/LaboratoryForPlayfulComputation/pxt-BlockyTalkyBLE",
  "cardType": "package"
}, {
  "name": "Katakana",
  "url":"/pkg/mbitfun/pxt-katakana",
  "cardType": "package"
}, {
  "name": "LINE BLE beacon",
  "url":"/pkg/pizayanz/pxt-linebeacon",
  "cardType": "package"
}, {
  "name": "Pimoroni Scrollbit",
  "url":"/pkg/pimoroni/pxt-scrollbit",
  "cardType": "package"
}, {
  "name": "SBRICK",
  "url":"/pkg/vengit/pxt-sbrick",
  "cardType": "package"
}, {
  "name": "Annikken Andee",
  "url":"/pkg/Annikken/pxt-Andee",
  "cardType": "package"
}, {
  "name": "Proportional Font",
  "url":"/pkg/lwchkg/pxt-proportional-font",
  "cardType": "package"
}]
```
