# micro:bit v2

The [micro:bit v2](https://microbit.org/new-microbit/) introduces a microphone, speaker, and capacitive touch input on the board's logo. The new blocks designed for the micro:bit v2 will not work with the micro:bit v1.

Let's learn how this works in MakeCode...

## v2 Blocks

![works with micro:bit v2 only image](/static/v2/v2-only.png)
<br/>

The following blocks require the micro:bit v2 hardware to run.

```block
let pressed = input.logoIsPressed()
let level = input.soundLevel()
soundExpression.giggle.play()
soundExpression.giggle.playUntilDone()
music.setBuiltInSpeakerEnabled(false)
input.setSoundThreshold(SoundThreshold.Loud, 128)
pins.touchSetMode(TouchTarget.P0, TouchTargetMode.Capacitive)
input.onSound(DetectedSound.Loud, function () {})
input.onLogoEvent(TouchButtonEvent.Pressed, function () {})
```

If your program tries to run any of these blocks on a micro:bit v1 board, you will see the ``927`` error code scroll across your screen.

```sim
basic.forever(function() {
    basic.showNumber(927)
    basic.pause(2000)
})
```

### New blocks reference

The reference information for the new blocks introduced for micro:bit v2:

```cards
input.onSound(DetectedSound.Loud, function () {})
input.onLogoEvent(TouchButtonEvent.Pressed, function () {})
input.logoIsPressed()
input.soundLevel()
soundExpression.giggle.playUntilDone()
soundExpression.giggle.play()
music.setBuiltInSpeakerEnabled(false)
pins.touchSetMode(TouchTarget.P0, TouchTargetMode.Capacitive)
```

## How to recognize the micro:bit v2?

The first thing to know is whether you have a micro:bit v1 or micro:bit v2 at hand. You can recognize the v2 boards visually with these differences...

* notches in the bottom edge connector
* gold plated logo on the front, instead of a colored one
* tiny hole near the top right of the screen for the microphone LED

![micro:bit v1 and micro:bit v2 front side by side](/static/v2/front.jpg)

* red power LED next to the USB connect
* large black speaker component centrally located in the back and rotated by 45 degrees
* slanted radio antenna

![micro:bit v1 and micro:bit v2 back side by side](/static/v2/back.jpg)

## v2 simulator

If your program uses any of the micro:bit v2 specific blocks, the simulator will automatically change to a micro:bit v2 with notches in the connector and a gold plated logo. You will also see a "v2" symbol on the lower right of the board.

![micro:bit v2 simulator](/static/v2/simulator.png)

## I see 927 scrolling on my board?

If your program tries to use any of the micro:bit v2 blocks on a micro:bit v1 board, you will see the **927** [error code](/device/error-codes) scroll on the micro:bit screen.
