# Resources

## CSTA Standards

Computer Science Teachers Association (CSTA) Standards 2017.

http://www.csteachers.org/page/standards.

### Level 2 (Grades 6-8)

#### Computing Systems

* 02 — Design projects that combine hardware and software components to collect and exchange data.
* 03 — Systematically identify and fix problems with computing devices and their components.

#### Networks & the Internet

* 04 — Model the role of protocols in transmitting data across networks and the Internet.

#### Data & Analysis

* 07 — Represent data using multiple encoding schemes.
* 08 — Collect data using computational tools and transform the data to make it more useful and reliable.
* 09  — Refine computational models based on the data they have generated.

#### Algorithms & Programming

* 11 — Create clearly named variables that represent different data types and perform operations on their values.
* 12 — Design and iteratively develop programs that combine control structures, including nested loops and compound conditionals.
* 13 — Decompose problems and subproblems into parts to facilitate the design, implementation, and review of programs.
* 17 — Systematically test and refine programs using a range of test cases.
* 19 — Document programs in order to make them easier to follow, test, and debug. 

## Utah Science with Engineering Education (SEEd)

* [Utah Science Website](https://schools.utah.gov/curr/science)
* [Utah Grades 6-8 SEEd Standards](https://schools.utah.gov/file/265a0b53-b6a7-48fb-b253-b6a5f38ffe19)
* [Sixth grade OER Science text](https://eq.uen.org/emedia/items/dae58176-b839-4b26-87e4-09ca5ed98875/1/Grade6RS.pdf)
* [Seventh grade OER Science text](https://eq.uen.org/emedia/items/afd89ff1-054c-4ac5-a712-67f4c6029644/1/Grade7RS.pdf)
* [Eighth grade OER Science text](https://eq.uen.org/emedia/items/e5219302-32b9-4c2f-ad65-38f303da6654/1/Grade8RS.pdf)

## NGSS - Utah SEEd

### Strand 6.3: Earth’s Weather Patterns and Climate

All Earth processes are the result of energy flowing and matter cycling within and among the planet’s systems. Heat energy from the Sun, transmitted by radiation, is the primary source of energy that affects Earth’s weather and drives the water cycle. Uneven heating across Earth’s surface causes changes in density, which result in convection currents in water and air, creating patterns of atmospheric and oceanic circulation that determine regional and global climates.

* Standard 6.3.2

>Investigate the interactions between air masses that cause changes in weather conditions. Collect and analyze weather data to provide evidence for how air masses flow from regions ... Examples of data collection could include field observations, laboratory experiments, weather maps, or diagrams.

* Standard 6.3.3

>Develop and use a model to show how unequal heating of the Earth’s systems causes patterns of atmospheric and oceanic circulation that determine regional climates. Emphasize how warm water and air move from the equator toward the poles. Examples of models could include Utah regional weather patterns such as lake-effect snow and wintertime temperature inversions.

### Strand 8.4: Interactions with Natural Systems and Resources

* Standard 8.4.4

>Analyze and interpret data on the factors that change global temperatures and their effects on regional climates. Examples of factors could include agricultural activity, changes in solar radiation, fossil fuel use, and volcanic activity. Examples of data could include graphs of ... global and regional temperatures.

## micro:bit

* [Microbit.org](http://microbit.org)
* [MakeCode.com](https://makecode.com)
* [Utah Coding Project](http://utahcoding.org)
* [Blog entry on Windows 10 MakeCode app](https://sites.google.com/view/utahcodingproject/blog/2018-jan-makecode-app)

<br/>
Adapted from "[Temperature Data](https://drive.google.com/open?id=1X6FeANka2qcMC2ZFQgSSxEoHxsQc--6a0Pk9xxMOwE8)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)

