# Overview

## Science Concept

### Temperature and Climate

```sim
basic.forever(() => {
led.plotBarGraph(
	input.temperature(), 50
	)
})
```

When heat flows into an object, its thermal energy increases and so does its temperature. The amount of temperature increase depends on three things:

1. how much heat was added
2. the size of the object
3. the material of which the object is made.

Thermal energy and temperature are closely related. Both reflect the amount of moving particles of matter as energy. However, temperature is the average measure of that energy, whereas thermal energy is the total energy within a system. Does this mean that matter with a lower temperature has less thermal energy than matter with a higher temperature? Not necessarily ([ck12.org - Thermal Energy](https://www.ck12.org/book/CK-12-Physical-Science-Concepts-For-Middle-School/section/5.10/))...various processes work to moderate Earth's temperature across the globe. Atmospheric circulation brings warm air towards the poles and cold polar air towards the Equator. If the Earth’s atmosphere didn’t move the temperature differences would be much greater ([ck12.org - Effect of Atmospheric Circulation on Climate](https://www.ck12.org/book/CK-12-Earth-Science-Concepts-For-Middle-School/section/8.18/)).

## Project Goal

Give students real world experience with coding, collecting temperature data, analyzing data, and reporting results using MakeCode’s block programming and a microbit with its sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a micro:bit using MakeCode. 

## Student Outcomes

Students will:

* Create experiments to collect data using microbits and the temperature sensor on them. 
* Setup different experiments to observe temperature in different environments.
* Code the microbits to collect data remotely over the microbit radios.
* Analyze the data collected.

## Materials Needed

* 2 microbits with batteries connected
* A longer USB microbit cable
* Spreadsheet for data analysis and a word processor for reporting the findings

## ~button /courses/ucp-science/temperature/setup-procedure
NEXT: Setup an Procedure
## ~

<br/>
Adapted from "[Temperature Data](https://drive.google.com/open?id=1X6FeANka2qcMC2ZFQgSSxEoHxsQc--6a0Pk9xxMOwE8)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)