# Overview

## Science concept

The micro:bit can measure movement through an accelerometer located on the back of the micro:bit - allowing it to detect if you shake, tilt or move the micro:bit in any direction. Many modern electronic devices have accelerometers built-in - including mobile phones, game controllers, and car sensors.

![micro:bit accelerometer](/static/courses/ucp-science/spoon-race/microbit-accelerometer.png)

Acceleration is the change in speed over a given amount of time - for example, it may take a sports car 3 seconds to accelerate from 0 to 60 miles-per-hour. The micro:bit can measure acceleration in any direction using a capacitor which stores and measures electrical energy.

The micro:bit measures Acceleration along 3 dimensions:

* X-axis (tilting left and right)
* Y-axis (tilting forward and backward)
* Z-axis (moving up and down)

![micro:bit axis diagram](/static/courses/ucp-science/spoon-race/microbit-axis.png)

The acceleration is measured in MakeCode with values between -1023 and +1023. When the micro:bit is laying flat:

* X = 0
* Y = 0
* Z = -1023

![Simulator with XYZ forces](/static/courses/ucp-science/spoon-race/simulator-xyz-accel.png)

Move your mouse cursor over the micro:bit simulator to see how the X, Y and Z values change.

## Project Goal

Provide a fun way for students to learn about motion sensing, data collection and analysis using MakeCode’s block programming and a micro:bit with sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a micro:bit using MakeCode.

## Student Outcomes

The objective of the spoon race is to carry an object quickly but with minimal movement. Students will measure the amount of movement of their micro:bits during the race. The student with the fastest time and the least amount of movement wins the race.

Students will:

* Understand what acceleration is, and how accelerometers are used to measure motion.
* Code a micro:bit to measure acceleration values.
* Run a micro:bit spoon race to collect data.
* Analyze the results of the data to determine a winner.

## Materials Needed

* A micro:bit v2, micro-USB cable and battery pack
* A computer with internet access
* A spoon
* Optional - tape or empty plastic egg shell to enclose micro:bit during race

## ~button /courses/ucp-science/spoon-race/setup-procedure
NEXT: Setup an Procedure
## ~