# Overview

## Science Concept

### Soil, Moisture, Ecosystems, Electricity, and Analog vs Digital

Water also moves through the living organisms. Plants soak up large amounts of water through their roots. The water then moves up the plant and evaporates from the leaves in a process called transpiration. Another name for transpiration is evapotranspiration. The process of transpiration, like evaporation, returns water back into the atmosphere ([ck12.org - Processes of the Water Cycle](https://www.ck12.org/book/CK-12-Earth-Science-Concepts-For-Middle-School/section/6.3/)). This project uses electricity to measure how dry soil has become because of evaporation and transpiration.

![Moisture meter testing soil](/static/courses/ucp-science/soil-moisture/moisture-meter-plant.jpg)

## Project Goal

Give students real world experience with coding, collecting data, analyzing data, and reporting results using [MakeCode’s](https://makecode.com) block programming and a [micro:bit](http://microbit.org) with its sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a micro:bit using MakeCode.

## Student Outcomes

Students will:

* create experiments to collect data using microbits and reading the voltage on pin(0). 
* setup different experiments to observe the moisture in soil.
* analyze the data collected.
* report on the experiment and the data collected.  

## Materials Needed

* 1 @boardname@ with batteries connected
* Wires to make or connect to soil probes
* Spreadsheet for data analysis
* Word processor for reporting results

## ~button /courses/ucp-science/soil-moisture/setup-procedure
NEXT: Setup and Procedure
## ~

<br/>
Adapted from "[Soil Moisture Tester](https://drive.google.com/open?id=1Rv4oPoxrggbokczbroQUl-10py3_5fQjVxOvwHR_5I4)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
