# Overview

## Science Concept

### Gravity and Inertia

Develop and use a model to describe the role of gravity and inertia in orbital motions of objects
in our solar system. As you read, focus on systems, an organized group of related objects. In this
section, it is important to examine how the objects in our solar system are affected by gravity and inertia. Most of the objects that are part of our solar system are constantly orbiting the Sun, the star of our solar system. Mass is a measure of the amount of matter in an object. Everything that has mass also has gravity. Gravity is the attraction of one particle or body to another. You have gravity. Your pencil has gravity. Larger masses have a stronger gravitational force, or the measurement of the pull of gravity, than smaller masses. 

![Force arrow pushing down on the earth](/static/courses/ucp-science/gravity/push-down.jpg)

The greater the mass of an object, the greater the gravitational pull it has on other objects ([ck12.org - Sixth Grade Science, Gravity and Inertia, p 26](https://eq.uen.org/emedia/items/dae58176-b839-4b26-87e4-09ca5ed98875/1/Grade6RS.pdf)).

## Project Goal

Give students real world experience with coding, collecting data, analyzing data, and reporting results using MakeCode’s block programming and a @boardname@ with its sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a @boardname@ using MakeCode.

## Student Outcomes

Students will:

* Create experiments to collect data using @boardname@s and the acceleration sensor on them. 
* Setup different experiments to observe the gravity effect.
* Code the @boardname@s to collect data remotely over the @boardname@ radios.
* Analyze the data collected.

## Materials Needed

* 2 @boardname@s with batteries connected

![Two micro:bit showing 0 and 6](/static/courses/ucp-science/gravity/06.png)

* A longer USB @boardname@ cable
* Spreadsheet for data analysis
* Padding for one @boardname@ for gravity testing

## ~button /courses/ucp-science/gravity/setup-procedure
NEXT: Setup an Procedure
## ~

<br/>
Adapted from "[Gravity, Motion, and Waves](https://drive.google.com/open?id=1Z8S-W3n1jX6drC8ALj8Wh1Rjc0CyP0Afs3acnIjDYes)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
