# Setup and procedure

## Setup

**1.** Plan and design the experiments.<br/>
**2.** Connect the wires to the micro:bit with connections at pin **0** and the ground pin. The pin **0** will connect to the positive ( + ) end of the battery. The **GND** will connect to the negative ( - ) end of the battery.<br/>
**3.** Sample data from batteries with a voltmeter. This gives a way to “calibrate” the micro:bit’s program.

![Connect a the test battery to the micro:bit](/static/courses/ucp-science/electricity/battery-tester-connect.jpg)

### ~hint

When the voltage is read using the 3V pin and the ground readings are around 1020. The analog voltage reading is converted to digital reading with 3 volts approaching the 1023 upper limit. A 1.5 volt reading should return a reading around 512 on the micro:bit when it is converted from analog to digital. If no wires are connected it can give a reading of about 250.

### ~

You can tabulate your readings like this:

>| voltage (voltmeter) | | micro:bit reading (0-1023) |
|-|-|-|
| 0 | | 276 |
| 0 | | 286 |
| 1.27 | | 441 |
| 1.47 | | 509 |
| 1.00 | | 391 |
| 1.45 | | 506 |

**4.** Plan and design data collection documents.<br/>
**5.** Program the micro:bit.<br/>
**6.** When the battery is connected to the micro:bit. buttton **A** will give a reading. Button **B** will give a reading in millivolts converted from the digital reading on pin **0**.<br/>
**7.** Experiment with different batteries. Use good batteries and some older batteries.<br/>
**8.** Report on the findings and observations in the experiments.

## Code

This project will use a micro:bit to read the voltage of an old battery to see if it is a good battery or needs to be thrown away.

### MakeCode Programming Environment

1. Open the MakeCode micro:bit editor in a browser at: @homeurl@.
2. Or download and use the [Windows 10 MakeCode](https://www.microsoft.com/store/apps/9PJC7SV48LCX) app.

### on Start event

1. Name the project, “Battery Tester”.
2. The ``||basic:on start||`` event will display the title and purpose of the micro:bit in all caps, `"BATTERY TESTER"`. The text is put in the ``||basic:show string||`` block (The title is put in the ``||basic:on start||`` event so when the micro:bit is started up it will show what it is programmed to do. It is done in all CAPS because it is easier to read as it is displayed in the LED display).

```blocks
basic.showString("BATTERY TESTER");
```

### on Button “A” Pressed event

1. The “on button “A” pressed event will be used to read the voltage between the GND and pin0 and display it on micro:bit LED display.
2. The micro:bit will then pause for 2 seconds.

```blocks
input.onButtonPressed(Button.A, () => {
    basic.showNumber(pins.analogReadPin(AnalogPin.P0))
    basic.pause(2000)
})
```

### on Button “B” Pressed event

1. The code for on button **B** pressed is designed to return a converted value for the battery’s voltage in millivolts (1.5 volt = 1500 millivolts).
2. The beginning of the first statement a variable ``reading`` is created and given a value of the reading from the analog reading of pin **0**. The ``reading`` variable is then multiplied by 1000 and divided by 340 and stored in ``voltage``.
3. If 3 volts gives a reading of about 1023 then 1 volt should read around 340 (340 = 1024 / 3). Using this ratio and multiplying the number by 1000 should convert the number to millivolts (micro:bits only do integer math so the voltage is multiplied by 1000 before doing the division by 340).

```block
input.onButtonPressed(Button.B, () => {
   let reading = pins.analogReadPin(AnalogPin.P0)
   let voltage = reading * 1000 / 340
   basic.showNumber(voltage)
})
```

#### Go to the JavaScript

4. Switching to JavaScript instead of working in the block environment makes it easier to do the math. Once the math is done in JavaScript it can be switched back to blocks. 
5. The last line displays the value converted millivolts on the LED display.

```typescript
// Convert analog reading to millivolts
input.onButtonPressed(Button.B, () => {
   let reading = pins.analogReadPin(AnalogPin.P0)
   let voltage = reading * 1000 / 340
   basic.showNumber(voltage)
})
```

## Extensions

### Add battery status

Set up the experiment to use an ``A+B`` button press to check some conditions to display the status of the battery. The algorithm is shown below:

```
if (condition 1)
    action “good”
else if (condition 2)
    action “weak”
else
    action “poor”
```

### Moving a magnet through copper wires

Set up an experiment using a loop of copper wires and see if the micro:bit can detect electricity being generated by moving the magnet in the loop.

## Data Collection

Log each battery tested to make decision on which of the batteries are good and which ones need to be disposed of.

## ~button /courses/ucp-science/electricity/resources
NEXT: Resources
## ~

<br/>
Adapted from "[Electricity - Battery Tester](https://drive.google.com/open?id=15Xry9jFsIzHHG7RpaIomLodl9pBjTiKDvtjkd227b7Y)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
