# Overview

## Science concept

When an object is dropped from a height, it follows Newton's Laws of Motion and is pulled down by the earth’s gravitational force. When the egg hits the ground, it is a collision between the Earth and the Egg.

Let’s review Newton’s 3 Laws of Motion as they relate to our Egg Drop experiment.

**Newton’s 1st Law of Motion**: A body in motion remains in motion, or a body at rest remains at rest, unless acted upon by a force. This implies that once we drop the egg, if there was no ground to stop it, the egg would fall forever.

![Newton's First Law](/static/courses/ucp-science/egg-drop/newton-1st-law.png)

**Newton’s 2nd Law of Motion**: Force equals mass times acceleration: F = m * a. Using this equation, we can calculate the Earth’s gravitational force to be equal to the mass of the egg times acceleration of gravity, which is a constant of approximately 9.8 meters per second squared.

![Newton's Second Law](/static/courses/ucp-science/egg-drop/newton-2nd-law.png)

**Newton’s 3rd Law of Motion**: For every action, there is an equal and opposite reaction. In this case, the egg will be exerting force downwards, so when it comes in contact with the ground, it will experience the ground exerting force upwards. The two objects (the egg and the earth) will collide and both will experience equal and opposite forces. However, since the earth is so much bigger than the egg, the force on the earth will be minimal, while the force on the egg will be very strong and may cause the shell of the egg to crack and break.

![Newton's Third Law](/static/courses/ucp-science/egg-drop/newton-3rd-law.png)

## Project Goal

Give students real world experience with coding, collecting data, analyzing data, and reporting results using MakeCode’s block programming and a micro:bit with its sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a micro:bit using MakeCode.

## Student Outcomes

The objective of the egg drop experiment is to keep the egg from breaking as it decelerates. It becomes clear from Newton's Laws of Motion that in order to minimize the force experienced by the egg at impact, students designing the egg carriers must increase the time over which the egg is brought to rest or decrease the egg's velocity at the time of the crash.

Students will:

* Understand the Laws of Motion and Gravitational Force.
* Design a carrier for their egg that will minimize the force exerted on the egg when colliding with the ground.
* Code the micro:bit to test the strength of the force.
* Iterate on their designs based on the results of the micro:bit data.

## Materials Needed

* A micro:bit, micro-USB cable and battery pack
* A computer with internet access
* Crafting materials to use for the egg carrier – these may include cardboard cups/boxes, cotton, plastic bags or bottles, string, straws, popsicle sticks, tissue paper, bubble wrap, glue, tape
* An uncooked egg

## ~button /courses/ucp-science/egg-drop/setup-procedure
NEXT: Setup an Procedure
## ~