# Overview

## Science concept

Science is a way of knowing, a process for gaining knowledge and understanding of the natural world. Engineering combines the fields of science, technology, and mathematics to provide solutions to real-world problems. Students should be active learners who demonstrate their scientific understanding by using it. It is not enough for students to read about science; they must participate in the three dimensions of science. They should observe, inquire, question, formulate and test hypotheses, analyze data, report, and evaluate findings. The students, as scientists, should have hands-on, active experiences throughout the instruction of the science curriculum. These standards help students find value in developing novel solutions as they engage with complex problems. 

![@boardname@ display side view](/static/courses/ucp-science/data-collection/mb-display-side.jpg)

## Project goal

To use a variety of methods to collect science experiment data using @boardname@s and its sensors. The micro:bit is the result of companies and communities all around the world working together to help people learn to code, and become confident and creative with technology. The BBC’s Microbit is a small programmable device created in the UK and is given to all 7th graders to help them learn coding, to see the relationship between hardware and software, and how to use it in an innovative way.

![@boardname@ front side view](/static/courses/ucp-science/data-collection/mb-front-side.jpg)

## micro:bit features

The micro:bit has these features:

* 25 individually-programmable LEDs
* 2 programmable buttons
* Physical connection pins (GPIO)
* Light and temperature sensors
* Motion sensors (accelerometer and compass)
* Wireless Communication, via Radio and Bluetooth
* USB interface

Read about what the micro:bit can do at the [micro:bit features](http://microbit.org/guide/features/) page.

## Prior knowledge

Students need:

* a basic knowledge of how to code using block style programming (Scratch, Code.org, etc.) 
* some knowledge file management skills in Windows.
* to know how to download a program and copy it to a micro:bit.

See [Using a micro:bit in 5 easy steps](http://microbit.org/guide/quick/) for a quick introduction to using the micro:bit.

## Student outcomes

Students will:

* create experiments to collect data using @boardname@s and its sensors. 
* setup different experiments to observe the effects.
* code a @boardname@ to collect data by observing the data displayed on the LED screen.
* code a @boardname@ to collect data, graph it, and download it using a USB cable and a serial write value command.
* code the @boardname@s to collect data remotely over the @boardname@ radios.
* analyze the data collected.

## Materials Needed

* A @boardname@ with a longer USB cable
* 2 @boardname@s with batteries connected
* A longer USB @boardname@ cable
* Spreadsheet program for data analysis

## ~button /courses/ucp-science/data-collection/setup-procedure
NEXT: Setup an Procedure
## ~

<br/>
Adapted from "[Microbit Data Collection Methods](https://drive.google.com/open?id=13Mi6caoelyzgch6tUj-wlw0bmgS7ikGEwYR2a37mEww)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)
