# Overview

## Science Concept

### The Nervous System Communicates with Muscles through Electrical Waves

Electrical impulses from the brain to the muscles can be observed, measured, and recorded as waves to show that there is a relationship between the circulatory, respiratory, muscular, and nervous systems of the human body.

#### Sample micro:bit body electrical data graph

![Graph of body electrical waves](/static/courses/ucp-science/body-electrical/body-electrical-waves.jpg)

## Project Goal

Give students real world experience with coding, collecting data, analyzing data, and reporting results using [MakeCode’s](https://makecode.com) block programming and a [micro:bit](http://microbit.org) with its sensors.

## Prior Knowledge

Students need to have a basic knowledge of how to code using block style programming and download a program to a @boardname@.

## Student Outcomes

Students will:

* Create experiments to collect data using @boardname@s and measure voltage in the human body. 
* Setup different experiments to observe the bodies electrical effect.
* Code the @boardname@s to collect data remotely over the @boardname@ radios.
* Analyze the data collected.
* Report on the findings of the experiments.

## Materials Needed

* 2 @boardname@s with batteries connected

![Two micro:bits together](/static/courses/ucp-science/body-electrical/two-microbits.jpg)

* A longer USB microbit cable
* Spreadsheet for data analysis
* 2 long (36-48” or 100-130 cm) thin wires for electrical body sensors (wire from an old network cable works quite well).
* Painters tape to tape the wires to the skin on the body.

## ~button /courses/ucp-science/body-electrical/setup-procedure
NEXT: Setup an Procedure
## ~

<br/>
Adapted from "[Body Electrical & Waves](https://drive.google.com/open?id=1KofuOt0v1lmQhQyJux1XWDVoCDeslcjDFysjStFmo1w)" by [C Lyman](http://utahcoding.org) [![CC BY-NC-SA](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)](https://creativecommons.org/licenses/by-nc-sa/4.0/)