## Project: Mini-Project

This project takes approximately a week to complete.  Most of that time is spent working on the project in a makerspace or art classroom.

The mini-project is an opportunity for students to design a project that serves a purpose by solving a problem or filling a need. It is also an opportunity to do two things:

* Show what you know
* Learn something new
	
Ideally, there should be a maker component to this project.  This is a real world component that works with the code on the micro:bit to do something unique.

Students are asked to each propose an original independent project.  Students are allowed to work on the same idea, but they cannot turn in the same code.  They can, and should work collaboratively, solving the same kinds of problems together, but the projects they turn in should be unique and original.

## Showcasing student work 

Students will be showing their work regularly to each other in informal ways.  Think about also organizing a day or an evening when parents, administrators, or others from the community are invited to come and view the students' projects. 

We find that a "science fair" type of setup works well here, with students stationed at their own tables, showing off and demonstrating their project. An event like this works well for these reasons:

* A real world audience for the work students have done can be very motivating
* It is a chance for people who are not familiar with the micro:bit to appreciate the finished product
* It provides good feedback to students about how someone interacts with their product
* It is a chance to have real conversations with the people behind the product, rather than just viewing the product on display by itself
* Finally, and most importantly, it is a chance to bring the community together to celebrate the great work all of your students have done!

## Assignment

* Create an original project using the micro:bit.
* Incorporate a physical component to the project.
* Demonstrate the use of one of the following concepts:

>* Input / Processing / Output
* Variables
* Simple Circuits
* Iteration/Loops
* Conditional Statements
	
## Project ideas

* Make a “New and Improved” Fidget Cube
* Make a Moving Monster
* Make a musical instrument
* Fishing Game
* Make an Air Guitar (uses while loop to do tempo and pitch)
* Screensaver
* Screensaver that uses other inputs to draw
* Interactive book
* Binary Clock or some other way to represent numbers visually

View projects at the following sites for inspiration:

* http://make.techwillsaveus.com/bbc-microbit
* http://microbit.org/ideas/
* https://twitter.com/MicroMonstersUK
* [Projects](/projects)

## Examples

![Toss the ball project](/static/courses/csintro/miniproject/toss-the-ball.jpg)
Toss the Ball

This is a skill game in which an aluminum foil ball is thrown into a plastic cup. Copper tape lining the sides and bottom of the cup completes the circuit when the ball touches it.

[**micro:bit Bullseye Project**](https://youtu.be/NZUpoSixf4E)
https://youtu.be/NZUpoSixf4E

This is a skill game in which tennis balls are thrown underhand at one of the three rings, which are lined with aluminum foil so they complete a circuit underneath when the ball makes contact with the ring.

[**micro:bit Storybook**](https://youtu.be/yg1NNLMqa9c)
https://youtu.be/yg1NNLMqa9c

This is a prototype of a storybook that could use the micro:bit to display animations for part of the story. Copper tape is used on the underside of the paper flaps to make contact between the GND pin and each of the other pins in sequence.

## Work logs

Because students are working on the projects in class, and much of the benefit comes from working together to solve problems, they should account for the work they are doing by writing a work log. 

A work log is a short, bullet point list of what they worked on, and how long it took. Stick to the facts. It shouldn’t take more than thirty seconds or so to write up a work log. Students should do one for every class. A shared Microsoft OneNote notebook is a great way to keep a work log that students can update regularly. Alternately, you might use a collaborative shared document, or your classroom management system, or even e-mail.

### Sample Work Log
>**_April 11_**<br/>
_20 min. Created code that reacts when pins P0 and P1 are pressed._<br/>
_0 min. Talked with Mr. Kiang about how to attach wires so they won’t fall off_<br/>
_20 min. Put target back together with pins_<br/>
_10 min. Helped Cody with attaching his scoreboard_

## Reflection

At the end of the week, students should compose a final reflection that summarizes the process of their learning over the course of the week. They should go back through their work logs and talk about the following:

* Talk about one challenge you faced in creating this project, either a challenge in coding or in making the artifact. How did you overcome this challenge?
* What did you demonstrate that you already knew?
* What was the new thing you learned in order to make this? How did you learn about it?
* Who in the class provided help to you along the way? How?
* Describe one specific thing you are proud of in this project.
* What would you do differently next time?
* If you had another week to work on this project, what might you add or improve?

Sample Reflection (excerpt)
>_“I spent this week finishing up little details with my program, making it work better and more user friendly. The part that surprised me the most was the little things that kept popping into my head, little suggestions that could potentially be good to add, but might not be necessary or even useful. At the beginning of the assignment, I just added them as quickly as I thought of them, but as the project neared the midpoint and conclusion, I find myself considering if I actually need them (as previous additions have been since quickly deleted). Another thing that I find interesting about this is that it is a rather specialized project. Not many people would use it except for me. However, this is supposed to be easily used by other people, so I have to take them into consideration as I design the project. I also realized that I had, at some point, broken part of my code without realizing it, so I now have to fix part of it. The reason that it is a problem is because I added a lot of code at once without deleting it, which is unfortunate. Next time I will add small amounts of code and test it first.”_

## Assessment

**Competency scores**: 4, 3, 2, 1

### Code - Show what you know

**4 =** Code very effectively demonstrates the use of previous concept(s). Variable names are unique and clearly describe what information values the variables hold. Code is highly efficient.<br/>
**3 =** Code only partially demonstrates previous concepts, and/or is not efficient.<br/>
**2 =** Code only partially demonstrates previous concepts, and/or is not efficient, variable names not clear.<br/>
**1 =** Code does not demonstrate previous concepts, is not efficient, variable names not clear.

### Code - Show something new

**4 =** Code very effectively demonstrates the use of new concept(s). Variable names are unique and clearly describe what information values the variables hold. Code is highly efficient.<br/>
**3 =** Code only minimally demonstrates new concepts, and/or is not efficient.<br/>
**2 =** Code only minimally demonstrates new concepts, and/or is not efficient, variable names not clear.<br/>
**1 =** Code does not demonstrate new concepts, is not efficient, variable names not clear.<br/>

### Maker component

**4 =** Tangible component is tightly integrated with the micro:bit and each relies heavily on the other to make the project complete.<br/>
**3 =**Tangible component is somewhat integrated with the micro:bit but is not essential.<br/>
**2 =** Tangible component does not add to the functionality of the program.<br/>
**1 =** No tangible component.

### Work Logs

**4 =** All work logs submitted on time, and accurate.<br/>
**3 =** One late or missing work log and/or work logs not accurate nor sufficiently detailed.<br/>
**2 =** Two late or missing work logs and/or work logs not accurate nor sufficiently detailed.<br/>
**1 =** More than two late or missing work logs and/or not accurate nor sufficiently detailed.

### Reflection

**4 =** Reflection piece describes:<br/>
`*` Development Process<br/>
`*` Something new<br/>
`*` Something proud of<br/>
`*` Future mods<br/>
**3 =** Reflection piece lacks 1 of the required elements.<br/>
**3 =** Reflection piece lacks 2 of the required elements.<br/>
**1 =** Reflection piece lacks 3 of the required elements.
 
## Notes

We actually split the grading of code between "show what you know" and "show something new." If a student uses variables incorrectly or uses bad variable names, we generally would take off points in both places. Sometimes it is difficult to distinguish between what is old and new if the student's reflection is less than clear; in those cases, we have to use some discretion in terms of where we take points off. Another option would be to break out the Variables category into its own row. 

As always, these rubrics are just a starting point and you should certainly feel free to adjust them as appropriate for your own classroom or learning environment.
