# Project: micro:pet

## Project

This project is an opportunity for students to create a micro:pet for the partner they interviewed in the Unplugged activity. They should review their notes and try to summarize what their partner finds appealing in a pet. Then, they should use whatever materials are available to create a prototype of a pet their partner would like.

We often ask students to sketch a few designs on paper first, then consult with their partner to see which aspects of those designs they find most appealing. The purpose of prototyping is to gather more feedback to help you in your final design (“I like this part from Idea A, and I like this part from Idea B…”)

Build a micro:pet that:
* Matches your partner’s needs
* Supports the micro:bit and its battery pack
* Allows you to easily access the micro:bit to turn it on and off

Your design should use whatever materials are available to support the micro:bit so that its face is showing. You can be creative and decide how to mount the board, and how to decorate your critter.

Think about the following questions when you construct it:
* Will it be an animal? A plant? A robot? A bug?
* Will it have any moving parts?
* If it moves, how can you hold the micro:bit securely?

Some photos of sample micro:pets below!

## Ideas for Mods

* Find a way to make part of the animal move.
* Give your animal a natural habitat.
* Create a way to carry your animal.
* Create an animal that reacts when you pet it or move it (find a way to detect when the micro:bit is moved or when its position changes in a certain way.)

## Reflection
Have students write a reflection of about 150–300 words, addressing the following points:
* Summarize the feedback you got from your partner on your idea. How would you revise your design, if you were to go back and create another version?
* What was it like to have someone designing a pet for you? Was it a pet you would have enjoyed? Why or why not? What advice did you give them that might help them redesign?
* What was it like to interview your partner? What was it like to be listened to?
* What was something that was surprising to you about the process of designing the micro:pet?
* Describe a difficult point in the process of designing the micro:pet, and explain how you resolved it.

## Rubric
For creative projects such as these, we normally don’t use a qualitative rubric to grade the creativity or the match with their partner’s needs. We just check to make sure that the micro:pet meets the required specifications:
* Program properly downloaded to micro:bit
* micro:bit supported so the face is showing
* micro:bit can be turned on and off without taking critter apart
* Turned in notes on interview process
* Written reflection (prompt is above)

## micro:pet Examples

![A dog micro:pet](/static/courses/csintro/making/micropet-dog.jpg)
Dog

https://youtu.be/2ZCDB-a_uRY
micro:pet Fish Tank 


![A piggy bank micro:pet](/static/courses/csintro/making/micropet-piggy-bank.jpg)
Pink Piggy

![A ladybug micro:pet](/static/courses/csintro/making/micropet-ladybug.jpg)
Ladybug

![A caterpiller micro:pet](/static/courses/csintro/making/micropet-caterpillar.jpg)
Caterpillar

![A fox micro:pet](/static/courses/csintro/making/micropet-fox.jpg)
Fox

![A robot micro:pet](/static/courses/csintro/making/micropet-robot.jpg)
Robot

