# Project: Get loopy!

![Birthday Card Project](/static/courses/csintro/iteration/birthday-card.jpg)

There are many different ways to use the three types of loop blocks.

Recall the different common repetitive actions you thought of back at the beginning of this lesson.
* How will you use loops to create something useful, entertaining, or interesting?
* What might you make?

Here are some suggestions:
* Create an animated gif (looping image that changes) and add music that matches.
* Create animation that repeats for one of the melodies included in Make Code  (like Happy Birthday).
* Create different animations that run when different buttons are pressed.
* Create an alarm that includes sound and images. What will set the alarm off? What will make the alarm stop sounding?
* Use servo motors to create a creature that dances and changes its expression while a song plays.

## Example

![Hat Man](/static/courses/csintro/iteration/hatman.png)
Hat Man Project

### Hat Man Videos

[**micro:bit Hat Man**](https://youtu.be/Xvybu_T5IL8)
https://youtu.be/Xvybu_T5IL8
<br/>

[**micro:bit Hat Man - inside view**](https://youtu.be/ZfKgFQjygQQ)
https://youtu.be/ZfKgFQjygQQ
<br/>
This project uses the micro:bit light sensor to display a happy face when it is sunny, and a frowning face when it is dark. The micro:bit is connected to a servo mounted on the inside of the container, and the smile and frown are attached to plastic coffee stirrers with tape and hot glue.

## Reflection

Have students write a reflection of about 150–300 words, addressing the following points:
* Explain how you decided on your particular "loopy" idea. What brainstorming ideas did you come up with?
* What type of loop did you use? For, While, or Repeat 
* What was something that was surprising to you about the process of creating this program?
* Describe a difficult point in the process of designing this program, and explain how you resolved it.
* What feedback did your beta testers give you? How did that help you improve your loop demo?

## Assessment

**Competency scores**: 4, 3, 2, 1

### Loops

**4 =** At least 3 different loops are implemented in a meaningful way.<br/>
**3 =** At least 2 loops are implemented in a meaningful way.<br/>
**2 =** At least 1 loop is implemented in a meaningful way.<br/>
**1 =** No variables are implemented.

### Variables (parameters)

**4 =** All variable names are unique and clearly describe what information values the variables hold<br/>
**3 =** The majority of variable names are unique and clearly describe what information values the variables hold.<br/>
**2 =** Few variable names are unique or clearly describe what information values the variables hold.<br/>
**1 =** None of the variable names clearly describe what information values the variables hold.

### Sound, display, and motion

**4 =** Uses sound, display, and motion in a way that is integral to the program.<br/>
**3 =** Uses only two of the required elements in a way that is integral to the program.<br/>
**2 =** Uses only one of the required elements in a way that is integral to the program.<br/>
**1 =** None of the required elements are used.

### micro:bit program
**4 =** micro:bit program:<br/>
`*` Uses loops in a way that is integral to the program<br/>
`*` Compiles and runs as intended<br/>
`*` Meaningful comments in code<br/>
**3 =** micro:bit program lacks 1 of the required elements.<br/>
**2 =** micro:bit program lacks 2 of the required elements.<br/>
**1 =** micro:bit program lacks 3 or more of the required elements.

### Collaboration reflection
**4 =** Reflection piece includes:<br/>
`*` Brainstorming ideas<br/>
`*` Construction<br/>
`*` Programming<br/>
`*` Beta testing<br/>
**3 =** Reflection piece lacks 1 of the required elements.<br/>
**2 =** Reflection piece lacks 2 of the required elements.<br/>
**1 =** Reflection piece lacks 3 of the required elements.

