# Introduction

In computer programming, iteration is the repetition of a sequence of code. A loop is a form of iteration. A loop repeats code until a certain condition is met. 

## Questions to think about:
* Do you use shampoo to wash your hair?
* Have you ever read the instructions on a bottle of shampoo?
	
Most of us have never read the instructions on a bottle of shampoo, because we already know how to use shampoo.

What algorithm could you write for shampooing your hair?
Example:
1. Wet hair.
2. Apply shampoo to wet hair
3. Scrub shampoo into hair
4. Rinse shampoo out of hair
		
If you did read the instructions on a bottle of shampoo, you may read similar instructions as the ones you just wrote with one added step at the end: ‘Lather. Rinse. Repeat.’
How does this one extra step affect the algorithm?

![Shampoo flowchart](/static/courses/csintro/iteration/shampoo-flowchart.png)

In computer programming, this is known as the ‘shampoo algorithm’ and is an example of a loop. It is also an example of an ‘infinite’ or ‘endless’ loop as the algorithm keeps repeating with no condition that ends the looping.

![Iteration cartoon](/static/courses/csintro/iteration/iteration-cartoon.png)
DBwebsolutions.com

‘Rinse. Repeat.’ has even become a meme and made its way into modern song lyrics.
What other common activities involve repetitive actions? _Examples: Singing (choruses repeat), dancing, school cheers, walking and running, exercise routines..._

## Optional
Read the history of ‘Lather, Rinse, Repeat.’ below.

Lather, Rinse, Repeat: Hygiene Tip or Marketing Ploy
By Lauren Goldstein
October 11, 1999
http://archive.fortune.com/magazines/fortune/fortune_archive/1999/10/11/267035/index.htm
(FORTUNE Magazine) – In Benjamin Cheever's novel The Plagiarist, a marketing executive becomes an industry legend by adding one word to shampoo bottles: REPEAT. He doubles shampoo sales overnight.

This bit of fiction reflects a small yet significant eddy of U.S. consumer angst: If we REPEAT, are we or are we not playing into the hands of some marketing scheme? It turns out that in real life there's a reason you should repeat, or at least there used to be. In the 1950s, when shampoos began to be mass-marketed, we didn't wash our hair all that often--once or twice a week, as opposed to five times a week as most of us do now. Also, we used a lot more goop in our hair. It was the age of Brylcream and antimacassars, remember. Paul Wallace, the director of hair-care research and development for Clairol, says that when cleaning agents in shampoo came up against that amount of oil and goop, "it depressed the lather." A second application was needed to get the suds that consumers expected. Lots of suds mean that hair is already clean. Maybe too clean (there's no oil to break through), but consumers like it.

FORTUNE asked Frederic Fekkai, the noted and notably expensive New York City hairdresser, what he thought about the double lather. He says, "Yesterday I put oil on my hair for a different look and went to a restaurant where the smoke was horrible. This morning I realized I had to do two shampoos."

At any rate, Wallace says advances in shampoo technology mean that only one application of, for instance, Clairol's Herbal Essences is sufficient to break through the oiliest hair. The company has stricken the use of both REPEAT and REPEAT IF DESIRED from all Clairol products. Yet a lot of brands, like Suave by Unilever and L'Oreal, still say REPEAT. Others, like Unilever's Finesse and Revlon's Flex, opt for the less imperative REPEAT IF DESIRED. Procter & Gamble uses REPEAT IF NECESSARY on Pantene.

Getting consumers to wash twice can, of course, increase sales--in ways one might not imagine. Double sudsing leads to dry hair, Fekkai points out, and that means more beauty products! "When you do two shampoos, even if you don't usually use a conditioner, you have to use a little," he says. "The conditioner becomes very important." REPEAT. FOLLOW WITH CONDITIONER. Words Cheever's marketer could have retired on.
--Lauren Goldstein

![Shampoo bottle](/static/courses/csintro/iteration/shampoo.png)

From Wikipedia (https://en.wikipedia.org/wiki/Lather,_rinse,_repeat):
Lather, rinse, repeat (sometimes wash, rinse, repeat) is an idiom roughly quoting the instructions found on many brands of shampoo. It is also used as a humorous way of pointing out that such instructions if taken literally would result in an endless loop of repeating the same steps, at least until one runs out of shampoo. It is also a sarcastic metaphor for following instructions or procedures slavishly without critical thought.

