# Final project

The final project is a chance for you to use all of the skills you have been learning throughout the semester to create something that is original, and that solves a problem or serves a purpose.

## Possible ideas
* Create a game
* Create something that helps somebody by solving a problem
* Create something beautiful
* Create a musical instrument

In addition, your project code must do each of the following things:

## Show something you already know
You should demonstrate your knowledge of one or more concepts we have covered in these lessons.

## Show something new
You should demonstrate a technique, efficiency, or block that you went out and learned how to do on your own, either from the documentation, or from another classmate.

## Incorporate a maker component
You should not create a project that exists solely and independently on the micro:bit. Your project should work together with tangible components such as servos, real buttons, switches, to do something unique.

## Timeframe
Three weeks of in-class work and activities

Due each week:
* 2–3 work logs
* 1 Record of Thinking

Due in three weeks:
* Beta testing period
* Final Narrative
* Final Project Code
* Final project showcase and celebration at the end

Assessment:
* 50% Process (initial proposal, work logs, records of thinking, final narrative)
* 50% Product (project code and maker component)

Teacher Note: This form of assessment places just as much weight on documenting the process of designing the project, as it does on the finished product itself. This is because in my classroom I want to prioritize "sustained effort over an extended period of time" over a project that might have resulted from three all-nighters in the final week it is due.

However, you may decide to assign more or less weight to each of these pieces, and you should certainly feel free to scale up or down the documentation piece as appropriate for your classroom, grade level, and teaching priorities.
 
## While working on the project
The expectation is that you are working steadily on your independent project for three weeks, testing out ideas, trying things out, getting stuck, and getting yourself unstuck. Because everyone is working on a different project, we can't assign the same homework to everybody so besides the project work itself, you are also responsible for documenting the work you are doing on the project using work logs, and reflecting on the process of your learning in a record of thinking. Here are more details on these.

## Work logs
A work log is a short, bullet point list of what you worked on, and how long it took. Stick to just the facts. It shouldn’t take more than thirty seconds or so to write up a work log. Students should do one for every class, several times a week. A shared Microsoft OneNote notebook is a great way to keep a work log that students can update regularly. Alternately, you might use a collaborative shared document, or your classroom management system, or even e-mail.

Sample Work Log:

>_Flappy Dino Project<br/>
3/31: 45 min. Worked on attaching cardboard arm to servo and mounting servo to inside<br/>
4/1: 30 min. Looked up documentation on talking to NeoPixel strip, worked through demos<br/>
4/3: 45 min. Hot glued NeoPixel strip to outside of dinosaur, finished painting<br/>
4/4: 30 min. Coded lighting patterns in MakeCode._

**Teacher note:** We generally don't accept late work logs. If a student simply didn't have time to do any work on the project, he should still file a work log, and report that no work got done. Work logs are worth a few points each, so missing one or two isn't a problem, but if it happens a lot it's usually time to do a check-in with that student and see where she is with the project.

## Record of thinking
A Record of Thinking is like a journal entry (or like the reflection that you did for the mini-project) that tells the story of your learning throughout the past week. Go through your work logs for the week and look at what you did, where you got stuck, and how you figured it out.

Then write a 150- to 300-word Record of Thinking addressing the following:
* Describe something that surprised you this week as you worked on your project.
* Describe a moment where you go stuck. How did you get unstuck?
* Did anyone help you this week? Who and how?
* Choose an adjective that describes how you are feeling about your project this week. Explain why you chose this word.
* What are you working on next week? (for weeks 1 and 2)
* If you had more time to work on this project, what would you add? (for week 3)
	
Sample Record of Thinking Excerpt:

>_Week of April 6<br/>
I guess I would choose the word "elated" because that's what I am feeling right now. After Mr. Kiang helped me figure out why my code wasn't working I was able to see it working exactly how I pictured it last week! That was a great moment. I was surprised how hard writing code that works is. I planned out the steps I wanted it to do but I didn't realize that the loops had to be nested one inside the other so I was stuck for a while. It always seems more simple than it is, that's one thought I will take into next week. Now I have the head attached to the body and the jaws work. I'm going to keep trying to get the lights working._

Teacher Note: A Record of Thinking is not an expanded work log!  Students will sometimes just write a more detailed list of all of the tasks they completed over the week, and that's not the point of the Record of Thinking.  The Work Logs are to show WHAT you did. The Record of Thinking is to show HOW you learned how to do it. Unlike Work Logs, I will accept late Records of Thinking as long as they come no later than the due date for the next week’s Record of Thinking. It is an important form of documentation of the learning process.

## Turning in the final project
When you turn in the final project, you should turn in your code, and a final narrative.
To turn in your code, you can Share the code by clicking the Share button at the top of the MakeCode window (next to Projects).

![Share project button](/static/courses/csintro/finalproject/share-button.png)

You acknowledge that you have consented to sharing your code by clicking Publish project.

![Publish project dialog](/static/courses/csintro/finalproject/publish-dialog.png)

You can then copy the URL, paste it into a OneNote page, or send it to your teacher.

![Share project dialog](/static/courses/csintro/finalproject/share-dialog.png)

You also need to create a written final narrative to accompany your code.
 
You have worked for the past three weeks to propose, design, and test an original micro:bit independent project. I am looking for an honest, accurate assessment of your work over this time.
 
Please go back and read through all of your Work Logs, Records of Thinking, Beta Testing feedback, and any notes from teacher conferences. 
 
Then, compose a comprehensive narrative that tells the story of the development of this app, and your progress toward your goals along the way.  How you tell the story is up to you, but you might consider following most, if not all, of the following questions:
* How did you start the process of designing the product/meeting your goals?
* What did you hope to learn?
* What challenges did you face? How did you overcome them?
* What was the outcome?
* What did you learn in the end?
* Who in the class provided help to you along the way? How?
* What were you proud of?
* What would you do differently next time?
 
Throughout your narrative, you must cite evidence from your work logs and records of thinking (e.g., Record of Thinking 4/17, Work Log #3, Conference notes, etc.)  You may use footnotes for this or add it in parentheses after the material you are citing.
 
I will read this carefully and grade it along with your final project code and average it with the total of your work logs and records of thinking to come up with your final grade for the project.
 
Sample Final Narrative:

> _It’s clear to me now that in the second week, I was a little lost and confused with the direction my project was taking. I can see now that in my chats with Mr. Kiang and with classmates (Conference Notes 4/3) I was not being very precise in my questions, and I didn’t totally understand what he was explaining._
 
>_Looking back, one of my goals was to meet more regularly with my table mates. Hopefully I would be a lot less confused and at least this time when I got stuck, we would be able to solve it together. I wrote about this in my Record of Thinking (Record of Thinking #2) but I am surprised that things cleared up for me so quickly once we did start meeting together. This allowed me to get past something that was really bothering me, specifically adding and removing things from an array, and I was able to complete that in less than a day after having been stuck for more than a week (Work Log #4)._
	 
>_Once I started to get a little more clear on what to do, I was able to get more effective help from my classmates. Specifically, Jordan helped me a lot with figuring out how to get an image to display properly on the screen. He also showed me how to search through the online documentation more effectively. I think if I could do this over again, I would have scheduled more time earlier to meet with Mr. Kiang and/or found a better way to share the different online sites with my table mates because we all found different places to go. I didn’t even find out until the end that you could jump into JavaScript to make changes to the code, and it makes it all with the right blocks when you go back! (Beta Testing notes) That would have saved me a lot of time._

## Beta testing
Beta testing is an important part of testing the final projects to uncover bugs or design issues that could make the projects difficult to use. One way to test the projects is to ask all students to come in to class on a specific day with the projects ready to test. This is not the final deadline, but projects should be "feature-complete" i.e., all features need to be incorporated into the micro:bit, and the construction of the real world elements of the project need to be done or almost done.

Students can take turns presenting their projects to the entire class, or they can work in pairs to take turns trying their partner's project out and offering feedback. Students who are being critiqued should take beta testing feedback notes and turn them in as part of their final project narrative.

## Final showcase
Have a celebration of your students' hard work and hold an event at your school for parents, administrators, and other community members to appreciate all of the hard work that went into making each of the final projects.

We have found that a "science fair" format works nicely, with students sitting at tables where they can demonstrate their projects and answer questions. Some schools do a "shark tank" type of event where students take turns "pitching" their project ideas to a panel composed of local software developers, entrepreneurs, and investors. Either way, a little public recognition of all of your students' hard work goes a long way!


## Assessment

**Competency scores**: 4, 3, 2, 1

### Code - Show what you know

**4 =** Code very effectively demonstrates the use of previous concept(s). All variable names are unique and clearly describe what information values the variables hold. Code is highly efficient.<br/>
**3 =** Code effectively demonstrates the use of previous concept(s). Most variable names are unique and/or clearly describe what information values the variables hold. Code is mostly efficient.<br/>
**2 =** Code somewhat effectively demonstrates the use of previous concept(s). Only some variable names are unique and/or clearly describe what information values the variables hold. Code is somewhat efficient.<br/>
**1 =** Code demonstrates the use of previous concept(s), yet is not effective. Few or no variable names are unique and/or clearly describe what information values the variables hold. Code is not efficient.

### Code - Show something new

**4 =** Code very effectively demonstrates the use of new concept(s). All variable names are unique and clearly describe what information values the variables hold. Code is highly efficient.<br/>
**3 =** Code effectively demonstrates the use of new concept(s). Most variable names are unique and/or clearly describe what information values the variables hold. Code is mostly efficient.<br/>
**2 =** Code somewhat effectively demonstrates the use of new concept(s). Only some variable names are unique and/or clearly describe what information values the variables hold. Code is somewhat efficient.<br/>
**1 =** Code demonstrates the use of new concept(s), yet is not effective. Few or no variable names are unique and/or clearly describe what information values the variables hold. Code is not efficient.

### Variable names

**4 =** All variable names are unique and clearly describe what information values the variables hold.<br/>
**3 =** Most variable names are unique and/or clearly describe what information values the variables hold.<br/>
**2 =** Only some variable names are unique and/or clearly describe what information values the variables hold.<br/>
**1 =** Few or no variable names are unique and/or clearly describe what information values the variables hold.<br/>

### Maker component

**4 =** Tangible component is tightly integrated with the micro:bit and each relies heavily on the other to make the project complete. <br/>
**3 =** Tangible component is somewhat integrated with the micro:bit but is not essential.<br/>
**2 =** Tangible component does not add to the functionality of the program.<br/>
**1 =** No tangible component.


### Work Logs

**4 =** All work logs submitted on time, and accurate.<br/>
**3 =** Two late or missing work log and/or work logs not accurate nor sufficiently detailed.<br/>
**2 =** Four late or missing work logs and/or work logs not accurate nor sufficiently detailed.<br/>
**1 =** More than four late or missing work logs and/or not accurate nor sufficiently detailed.<br/>

### Final narrative

**4 =** Narrative piece is thoughtful and detailed and contains all required elements.<br/>
**3 =** Reflection piece is mostly thoughtful and/or lacks 1 of the required elements.<br/>
**2 =** Reflection piece is superficial and lacks 2 of the required elements.<br/>
**4 =** Reflection piece is trivial and lacks 3 of the required elements. 

As always, these rubrics are just a starting point and you should certainly feel free to adjust them as appropriate for your own classroom or learning environment.