# Introduction

Through math class, most middle school students are already familiar with coordinate grids and mapping x and y coordinates on a plane. To review some terms:

## Axes
* The basic coordinate grid a student learns has two axes,

>* an x-axis which runs horizontally and 
* a y-axis which runs vertically.
	
## Origin
* These two axes meet at a point called the origin where both the x and the y values are zero.
* On this basic coordinate grid, the origin is in the lower left corner of the grid and has the coordinates (0,0).
	
## Coordinate pair
* The first value in a coordinate pair is the x value and the second value in a coordinate pair is the y value.
* A simple way to remember which value comes first is to remember their order in the alphabet. The letter x comes before the letter y in the alphabet and the x coordinate comes before the y coordinate in a coordinate pair.
	
## Coordinate value changes
* On a basic coordinate grid,

>* the value of the x coordinate increases left to right and is a measure of how many units a point is horizontally from the origin
* the value of the y coordinate increases bottom to top and is a measure of how many units a point is vertically from the origin
	
![Math coordinates](/static/courses/csintro/coordinates/math-coords.png)

## Coordinate grid and JavaScript and the micro:bit

The 5 x 5 grid of LEDs on the micro:bit represent a coordinate grid with a horizontal x-axis and a vertical y-axis. It has an origin and you can refer to the position of the LEDs with coordinate pairs.
 
It is important however that the students understand the two major differences between the micro:bit LED grid and the coordinate grid that they are used to using in math class:
* the origin (0,0) is in the top left corner.
* the values of the y coordinates range from 0 through four and increase from top to bottom.
	
Note:
* The values of the x coordinates range from 0 through four and increase from left to right just as they do in the coordinate grids used in math class.

![micro:bit LED coordinates](/static/courses/csintro/coordinates/microbit-led-coords.png)

## Sidebar material

![Rene Descartes](/static/courses/csintro/coordinates/rene-descartes.jpg)
(image credit: Wikipedia Commons)

René Descartes (1596-1650), was a French philosopher and mathematician who developed the coordinate system we use today. A story goes that while lying in bed, he noticed a fly on the ceiling. In wondering how he could describe the fly’s exact position on the ceiling, he decided to use a corner of the ceiling as a reference point and then describe the fly’s position as a measure of how far away from the reference point one would need to travel horizontally and then vertically to reach the fly. His coordinate system proved useful in many ways including creating an important link between the studies of algebra and geometry. Geometric shapes could now be described by points on a coordinate plane.
