# Unplugged: Red light, green light

![Red and green stoplight](/static/courses/csintro/conditionals/traffic-light.png)

## Objective
To reinforce the programming of basic conditionals by having students experience conditionals through acting them out in real life.

## Activity overview
Students will line up at one end of the classroom with the goal of reaching the other side of the classroom. The teacher, and then the students themselves will call out conditionals and all the students will advance or not depending on the specific conditional statement.

**Note:** As the teacher you will need to keep an eye out for any ‘errors’ that occur during the running of the program.

## Materials
* Pencils and lined paper (if doing this activity seated). Students can advance across the paper instead of the room with one inch line equal to one step.

## Process

* Have the students line up at one side of the room.
* Explain the rules:
>* The object of the game is to get across the room first.
>* For `if...then` conditionals:  If the condition called out is `true` for you, then perform the action described in the `then`. If the condition called out is `false` for you, then do nothing.
>* For `if...then...else` conditionals, listen carefully to the whole condition, as the `else` may apply to you.
	
## Example conditional statements

* If you are wearing something green, then take a step forward.
* If you have the letter ‘e’ in your first name, then take two giant steps forward.
* If you are wearing sneakers, then take a step forward, else take 2 steps forward.
* If your birthday is this month, then take a giant hop forward.
The conditionals you use will depend on your individual class.

After the students get the idea of the game, allow them to make up and call out conditionals (that meet teacher approval).

They will need to be observant, as a conditional that moves them forward, will also move their competition forward!

## Tips
* SAFETY FIRST! Students, especially younger ones, can get quite silly with this and while it is meant to be fun and even funny, safety first!
* Student conditionals need to apply to at least two people in the class.

## Reflections
How did they do?  Were there any ‘run-time errors’? Did a student miss a conditional being met or fail to correctly carry out the THEN or ELSE action?  Were there some conditions that could be evaluated as something other than True or False (maybe, sometimes)?

## Extensions/Variations 
* Add AND, OR, AND/OR statements to the conditionals.
>Example: If you have brown hair AND brown eyes, then...
* Create nested IF’s
>Example: If you are wearing sneakers, then... if you are also wearing white socks, take three steps forward.
* Let students create their own conditionals for future program runs with the class. (A very popular activity, though all conditionals should be run by the teacher first for approval.)
* Relate this activity to a system and have the students create the conditionals that would end in a product of some kind or the completion of some task, like writing a sentence or setting a table or constructing a simple structure.

