# Project: Fidget Cube

![Sample fidget cube](/static/courses/csintro/algorithms/fidgetcube.jpg)

A fidget cube is a little cube with something different that you can manipulate on each surface. There are buttons, switches, and dials, and people who like to “fidget” find it relaxing to push, pull, press, and play with it. In this project, students are challenged to turn the micro:bit into their very own “fidget cube”. 

Show students some examples of fidget cubes:
* Original Kickstarter Fidget Cube - [Fidget Cube: A Vinyl Desk Toy](https://www.kickstarter.com/projects/antsylabs/fidget-cube-a-vinyl-desk-toy) (there is a funny video showing the fidget cube in action).

## Discussion questions

* Do any of your students fidget? 
* What kinds of things do they fidget with? Spinning pens, fidget spinners, rings, coins? 
* There are many different versions of fidget cubes available now. Do any students have any? 
* Have they seen them before? 
* What are the types of fidget activities? 
* If students could add or modify features of the fidget cube, what would they choose to do? 
* What would make the ultimate fidget cube?

Remind students that a computing device has a number of inputs, and a number of outputs. The code that we write processes input by telling the micro:bit what to do when various events occur.

## Project

Make a fidget cube out of the micro:bit, create a unique output for each of the following inputs:
* on button A pressed
* on button B pressed
* on button A+B pressed
* on shake

See if you can combine a maker element similar to what you created in Lesson 1 by providing a holder for the micro:bit that holds it securely when you press one of the buttons.

![](/static/courses/csintro/algorithms/fidget-cube.jpg)
Sample fidget cube designs

## Project mod 
* Add more inputs and more outputs - use more than 4 different types of input. Try to use other types of output (other than LEDs) such as sound!

## Assessment

**Competency scores**: 4, 3, 2, 1

### Inputs

**4 =** At least 4 different inputs are successfully implemented.<br/>
**3 =** At least 3 different inputs are successfully implemented.<br/>
**2 =** At least 2 different inputs are successfully implemented.<br/>
**1 =** Fewer than 2 different inputs are successfully implemented.

### Outputs

**4 =** At least 4 different outputs are successfully implemented.<br/>
**3 =** At least 3 different outputs are successfully implemented.<br/>
**2 =** At least 2 different outputs are successfully implemented.<br/>
**1 =** Fewer than 2 different outputs are successfully implemented.

### micro:bit program

**4 =** micro:bit program:<br/>
`*` uses event handlers in a way that is integral to the program<br/>
`*` compiles and runs as intended<br/>
`*` includes meaningful comments<br/>
**3 =** micro:bit program lacks 1 of the required elements<br/>
**2 =** micro:bit program lacks 2 of the required elements<br/>
**1 =** micro:bit program lacks all of the required elements.

### Collaboration reflection

**4 =** Reflection piece includes:<br/>
`*` brainstorming ideas<br/>
`*` construction<br/>
`*` programming<br/>
`*` beta testing<br/>
**3 =** Reflection piece lacks 1 of the required elements.<br/>
**2 =** Reflection piece lacks 2 of the required elements.<br/>
**1 =** Reflection piece lacks 3 of the required elements.
