# Introduction

What is a micro:bit?
The micro:bit was created in 2015 in the UK by the BBC to teach computer science to students. The BBC gave away a micro:bit to every Year 7 student in the UK. You can think of a micro:bit as a mini computer.
http://microbit.org

![BBC micro:bit](/static/courses/csintro/algorithms/bbc-microbit.jpg)

## What is a computer?
There are 4 main components that make up any computer:

![Computer components](/static/courses/csintro/algorithms/cpu.png)

1. The Processor – this is usually a small chip inside the computer, and it’s how the computer processes and transforms information. Has anyone heard of the term “CPU”?  CPU stands for Central Processing Unit. You can think of the processor as the Brains of the computer - the faster the processor, the more quickly the computer can think.

2. The Memory – this is how the computer remembers things. There are two types of memory:
>* RAM (random access memory) - you can think of this as the computer’s short-term memory
>* Storage (also referred to as the “hard drive”) - this is the computer’s long-term memory, where it can store information even when power is turned off

3. Inputs – this is how a computer takes in information from the world.  On humans, our input comes in through our senses, such as our ears and eyes. What are some Computer Inputs?  Keyboard, Mouse, Touchscreen, Camera, Microphone, Game Controller, Scanner

4. Outputs – this is how a computer displays or communicates information.  On humans, we communicate information by using our mouths when we talk. What are some examples of communication that don't involve talking?  Blushing, sign language. What are some examples of Computer outputs?  Monitor/Screen, Headphones/Speakers, Printer

Now, let’s look at our micro:bit:

![micro:bit hardware](/static/courses/csintro/algorithms/microbit-hardware.png)

* Use the [features page on the microbit website](http://microbit.org/guide/features/) as a visual aid
* Can you find the Processor?
* How much memory does the micro:bit have? 16K, which is smaller than many files on your computer!
* Can you locate the following Inputs?  Buttons (on board), Pins (at base), Accelerometer / Compass.
>Note: Though not pictured, the Light Sensor is located on the LED lights
* Where are the Outputs?  LED lights, Pins

All computers need electricity to power them.  There are 3 ways to power your micro:bit:
* Through the USB port at the top
* By connecting a battery pack to the battery connector
* Through the 3V Pin at the bottom (not the recommended way to power your micro:bit)

On the top left corner you may notice that your micro:bit has a Bluetooth antenna.  This means your micro:bit can communicate and send information to other micro:bits.  We will learn more about this feature in the Radio Lesson.

