# Intro to CS

## A 14 week Introduction to Computer Science course.

This course is targeted to middle school grades 6-8 (ages 11-14 years).  It is also written for teachers who may not have a Computer Science background, or who may be teaching an "Intro to Computer Science" course for the first time.

This course takes approximately 14 weeks to complete, spending about 1 week on each of the first 11 lessons, and 3 weeks for students to complete the final project at the end.  Of course, teachers should feel free to customize the curriculum to meet individual school or district resources and timeframe.

![Space race image](/static/courses/csintro.jpg)

### ~ hint
**Download it**

The entire course is also available as a download or as a book. Choose any of these formats:

|||
|-|-|
| [![](/static/courses/csintro/icons/html-24x24.png)](/--docs#book:/courses/csintro/SUMMARY) | [- **HTML** - The entire course in a single HTML page that you can print to PDF or paper](/--docs#book:/courses/csintro/SUMMARY) |
| [![](/static/courses/csintro/icons/microsoft-onenote-24x24.png)](https://aka.ms/MakeCodeforMicroBitNotebook) | [- **OneNote** - Intro to CS with MakeCode for micro:bit](https://aka.ms/MakeCodeforMicroBitNotebook) |
| [![](/static/courses/csintro/icons/adobe-pdf-file-icon-24x24.png)](https://1drv.ms/b/s!AqsgsTyHBmRBgQ1Fjzm5y5wKG75M) | [- **PDF** - Intro to CS with MakeCode for micro:bit](https://1drv.ms/b/s!AqsgsTyHBmRBgQ1Fjzm5y5wKG75M) |
| [![](/static/courses/csintro/icons/apple-itunes-ibook-24x24.png)](https://itunes.apple.com/us/book/making-with-micro-bit/id1255260221?mt=11) | [- **iBooks** - Making with micro:bit](https://itunes.apple.com/us/book/making-with-micro-bit/id1255260221?mt=11) |
| [![](/static/courses/csintro/icons/paperback-book-24x24.png)](http://www.lulu.com/shop/mary-douglas-kiang/making-with-makecode-microbit/paperback/product-23457217.html) | [- **Paperback** - Making with MakeCode and Micro:bit](http://www.lulu.com/shop/mary-douglas-kiang/making-with-makecode-microbit/paperback/product-23457217.html) |

**Educators**: For educators, there's an separate edition of this course containing downloadable materials for teaching the course in a classroom setting:

* **[Intro to Computer Science - Educator edition](/courses/csintro-educator)**

### ~

### Lesson structure

Each of the 12 lessons is structured in this format:
* Topic Introduction
* Unplugged Activity (30 min) - An offline game or activity that demonstrates the concept/topic
* micro:bit Activity (45-60 min) - An activity that everyone makes on their micro:bit that teaches the skills learned in this lesson.
* Project (60-120 min) - A prompt for an original project that each student will create to demonstrate their understanding of the skills and concepts covered in this lesson.
* Project Mods - Examples of additional things students can do to extend the project.
* Assessment - A project rubric and guidance for grading the project.
* Standards - A list of CSTA K-12 Computer Science Standards and/or concepts covered by this lesson.

### Course on Flipgrid

Flipcode for the **Intro to CS** course grid: **[csintromicrobit](https://flipgrid.com/csintromicrobit)**

## Course contents

* [About](/courses/csintro/about)
* [Introduction](/courses/csintro/introduction)
* [References](/courses/csintro/references)
* [Acknowledgements](/courses/csintro/acknowledgements)

### Lessons

1. [Making](/courses/csintro/making)
2. [Algorithms](/courses/csintro/algorithms) 
3. [Variables](/courses/csintro/variables) 
4. [Conditionals](/courses/csintro/conditionals)
5. [Iteration](/courses/csintro/iteration) 
6. [Review/Mini-Project](/courses/csintro/miniproject)
7. [Coordinate grid system](/courses/csintro/coordinates)
8. [Booleans](/courses/csintro/booleans)
9. [Bits, bytes, and binary](/courses/csintro/binary)
10. [Radio](/courses/csintro/radio)
11. [Arrays](/courses/csintro/arrays)
12. [Independent final project](/courses/csintro/finalproject) 
