# Intro to CS - Educator edition

## A 14 week Introduction to Computer Science course.

This course is targeted to middle school grades 6-8 (ages 11-14 years).  It is also written for teachers who may not have a Computer Science background, or who may be teaching an "Intro to Computer Science" course for the first time.

This course takes approximately 14 weeks to complete, spending about 1 week on each of the first 11 lessons, and 3 weeks for students to complete the final project at the end.  Of course, teachers should feel free to customize the curriculum to meet individual school or district resources and timeframe.

![CSIntro banner image](/static/courses/csintro-educator/csintro-educator.jpg)

The **Educator edition** is available as a set of resource materials for teaching the course in the classroom. The course materials contain the overview guides, assessment and standards guides, and the individual lesson units. The course material is provided as single complete download or the guides and lesson units can be downloaded individually. Take a look at this brief **[preview](/courses/csintro-educator/preview)** of what's included in the materials.

### ~ reminder

#### **Professional Development Opportunities - 2024**

Douglas and Mary Kiang, the authors of this curriculum, are hosting a 3-webinar series for educators walking through the scope and sequence of the curriculum, and sharing tips and strategies for engaging students in learning to code with MakeCode and the micro:bit. They're also hosting a full-day in-person workshop on July 16th in Las Vegas as part of the [CSTA 2024 Annual Conference](https://conference.csteachers.org/event/f0c0e0a8-5ac1-4333-90c9-2eab9723af76/summary). These are free workshops with limited capacity, so secure your place by registering using the links below:

* **[Webinar 1](https://msit.events.teams.microsoft.com/event/40f9ed5f-8d72-4494-bbe2-42005441f4e6@72f988bf-86f1-41af-91ab-2d7cd011db47)** : 📅 Tuesday April 30, 3 - 4 PM Pacific | 4 - 5 PM Mountain | 5 - 6 PM Central | 6 - 7 PM Eastern
* **[Webinar 2](https://msit.events.teams.microsoft.com/event/762cfe3c-ef1a-40ec-87fd-73eacc6f1a77@72f988bf-86f1-41af-91ab-2d7cd011db47)** : 📅 Tuesday May 14, 3 - 4 PM Pacific | 4 - 5 PM Mountain | 5 - 6 PM Central | 6 - 7 PM Eastern
* **[Webinar 3](https://msit.events.teams.microsoft.com/event/52ef14cd-07de-41be-83bc-c664d4a98aa5@72f988bf-86f1-41af-91ab-2d7cd011db47)** : 📅 Tuesday May 28, 3 - 4 PM Pacific | 4 - 5 PM Mountain | 5 - 6 PM Central | 6 - 7 PM Eastern
* **[CSTA Preconference Workshop](https://aka.ms/CSTA24reg)**: In-person as part of the CSTA 2024 Annual Conference in Las Vegas, NV on 📅 Tuesday July 16, 9 AM - 4 PM

### ~

## Complete course pack

The entire set of course materials is bundled together to download as one complete package, get it here:

**[``|Complete course package|``](https://1drv.ms/u/s!AqsgsTyHBmRBhFofN7NDsaf1Y2DZ)**

## Individual materials

Any of the individual course material items are also available as a separate download. All of the guides, assessments, and lesson materials are listed here:

### [Course overview](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&id=416406873CB120AB%21520&cid=416406873CB120AB)

* [Course overview booklet](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3747&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690655374&OR=ItemsView)
* [Course overview booklet (PDF)](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%213746&parId=416406873CB120AB%21520&o=OneUp)
* [Curriculum overview guide](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3749&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690921127&OR=ItemsView)
* [Curriculum overview guide (PDF)](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%213748&parId=416406873CB120AB%21520&o=OneUp)
* [Educator preparation video](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%21526&parId=416406873CB120AB%21520&o=OneUp)
* [Educator preparation video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3750&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690587199&OR=ItemsView)

### [Standards and assessments](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&id=416406873CB120AB%21521&cid=416406873CB120AB)

* [Assessment guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!528&parId=416406873CB120AB!521&authkey=!ALunv1kXkaA0RLg&app=Word)
* [Assesment guide (PDF)](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%213751&parId=416406873CB120AB%21521&o=OneUp)
* [Standards alignment guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!527&parId=416406873CB120AB!521&authkey=!ALunv1kXkaA0RLg&app=Word)
* [Standards alignment guide (PDF)](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%213752&parId=416406873CB120AB%21521&o=OneUp)


### [Unit materials](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&id=416406873CB120AB%21522&cid=416406873CB120AB)

#### [Unit 1 - Making](https://1drv.ms/f/s!AqsgsTyHBmRBhB7OK55chVCPrD_W)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!556&parId=416406873CB120AB!542&authkey=!AM4rnlyFUI-sP9Y&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!554&parId=416406873CB120AB!542&authkey=!AM4rnlyFUI-sP9Y&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!555&parId=416406873CB120AB!542&authkey=!AM4rnlyFUI-sP9Y&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AM4rnlyFUI%2DsP9Y&cid=416406873CB120AB&id=416406873CB120AB%21557&parId=416406873CB120AB%21542&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3753&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690011517&OR=ItemsView)

#### [Unit 2 - Algorithms](https://1drv.ms/f/s!AqsgsTyHBmRBhB9mHogz24TrrXvd)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!560&parId=416406873CB120AB!543&authkey=!AGYeiDPbhOute90&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!558&parId=416406873CB120AB!543&authkey=!AGYeiDPbhOute90&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!559&parId=416406873CB120AB!543&authkey=!AGYeiDPbhOute90&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AGYeiDPbhOute90&cid=416406873CB120AB&id=416406873CB120AB%21561&parId=416406873CB120AB%21543&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3755&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690051176&OR=ItemsView)

#### [Unit 3 - Variables](https://1drv.ms/f/s!AqsgsTyHBmRBhCA3Amk-zPfMl-7q)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!564&parId=416406873CB120AB!544&authkey=!ADcCaT7M98yX7uo&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!562&parId=416406873CB120AB!544&authkey=!ADcCaT7M98yX7uo&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!563&parId=416406873CB120AB!544&authkey=!ADcCaT7M98yX7uo&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21ADcCaT7M98yX7uo&cid=416406873CB120AB&id=416406873CB120AB%21565&parId=416406873CB120AB%21544&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3756&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690101309&OR=ItemsView)

#### [Unit 4 - Conditionals](https://1drv.ms/f/s!AqsgsTyHBmRBhCEhD98j9NcTVsYj)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!568&parId=416406873CB120AB!545&authkey=!ACEP3yP01xNWxiM&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!566&parId=416406873CB120AB!545&authkey=!ACEP3yP01xNWxiM&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!567&parId=416406873CB120AB!545&authkey=!ACEP3yP01xNWxiM&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21ACEP3yP01xNWxiM&cid=416406873CB120AB&id=416406873CB120AB%21569&parId=416406873CB120AB%21545&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3757&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690162923&OR=ItemsView)

#### [Unit 5 - Iteration](https://1drv.ms/f/s!AqsgsTyHBmRBhCKvf1jSYdQITB2h)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!572&parId=416406873CB120AB!546&authkey=!AK9_WNJh1AhMHaE&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!570&parId=416406873CB120AB!546&authkey=!AK9_WNJh1AhMHaE&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!571&parId=416406873CB120AB!546&authkey=!AK9_WNJh1AhMHaE&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AK9%5FWNJh1AhMHaE&cid=416406873CB120AB&id=416406873CB120AB%21573&parId=416406873CB120AB%21546&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3758&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690193781&OR=ItemsView)

#### [Unit 6 - Mini Project](https://1drv.ms/f/s!AqsgsTyHBmRBhCNesBFAojwe-bor)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!576&parId=416406873CB120AB!547&authkey=!AF6wEUCiPB75uis&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!574&parId=416406873CB120AB!547&authkey=!AF6wEUCiPB75uis&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!575&parId=416406873CB120AB!547&authkey=!AF6wEUCiPB75uis&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AF6wEUCiPB75uis&cid=416406873CB120AB&id=416406873CB120AB%21577&parId=416406873CB120AB%21547&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3759&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690265627&OR=ItemsView)

#### [Unit 7 - Coordinates](https://1drv.ms/f/s!AqsgsTyHBmRBhCTASW4OemOKnMEv)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!580&parId=416406873CB120AB!548&authkey=!AMBJbg56Y4qcwS8&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!578&parId=416406873CB120AB!548&authkey=!AMBJbg56Y4qcwS8&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!579&parId=416406873CB120AB!548&authkey=!AMBJbg56Y4qcwS8&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AMBJbg56Y4qcwS8&cid=416406873CB120AB&id=416406873CB120AB%21581&parId=416406873CB120AB%21548&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3760&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690325195&OR=ItemsView)

#### [Unit 8 - Booleans](https://1drv.ms/f/s!AqsgsTyHBmRBhCVCoNzaW1aTHQzm)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!584&parId=416406873CB120AB!549&authkey=!AEKg3NpbVpMdDOY&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!582&parId=416406873CB120AB!549&authkey=!AEKg3NpbVpMdDOY&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!583&parId=416406873CB120AB!549&authkey=!AEKg3NpbVpMdDOY&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AEKg3NpbVpMdDOY&cid=416406873CB120AB&id=416406873CB120AB%21585&parId=416406873CB120AB%21549&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3761&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690357689&OR=ItemsView)

#### [Unit 9 - Binary](https://1drv.ms/f/s!AqsgsTyHBmRBhCaJTPDfFM9PABs1)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!588&parId=416406873CB120AB!550&authkey=!AIlM8N8Uz08AGzU&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!586&parId=416406873CB120AB!550&authkey=!AIlM8N8Uz08AGzU&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!587&parId=416406873CB120AB!550&authkey=!AIlM8N8Uz08AGzU&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AIlM8N8Uz08AGzU&cid=416406873CB120AB&id=416406873CB120AB%21589&parId=416406873CB120AB%21550&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3763&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690413779&OR=ItemsView)

#### [Unit 10 - Radio](https://1drv.ms/f/s!AqsgsTyHBmRBhCeq5h3BbHNmCpGA)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!592&parId=416406873CB120AB!551&authkey=!AKrmHcFsc2YKkYA&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!590&parId=416406873CB120AB!551&authkey=!AKrmHcFsc2YKkYA&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!591&parId=416406873CB120AB!551&authkey=!AKrmHcFsc2YKkYA&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AKrmHcFsc2YKkYA&cid=416406873CB120AB&id=416406873CB120AB%21593&parId=416406873CB120AB%21551&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3764&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690445091&OR=ItemsView)

#### [Unit 11 - Arrays](https://1drv.ms/f/s!AqsgsTyHBmRBhChTGr9RP7MXejC-)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!596&parId=416406873CB120AB!552&authkey=!AFMav1E_sxd6ML4&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!594&parId=416406873CB120AB!552&authkey=!AFMav1E_sxd6ML4&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!595&parId=416406873CB120AB!552&authkey=!AFMav1E_sxd6ML4&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AFMav1E%5Fsxd6ML4&cid=416406873CB120AB&id=416406873CB120AB%21597&parId=416406873CB120AB%21552&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3766&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686690475716&OR=ItemsView)

#### [Unit 12 - Accelerometer](https://1drv.ms/f/s!AqsgsTyHBmRBnTe7p79ZF5GgNES4)

* [Classroom presentation](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3772&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686689659525&OR=ItemsView)
* [Educator Guide](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3768&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686689325290&OR=ItemsView)
* [Student workbook](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3770&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686689682662&OR=ItemsView)
* [Quick start video](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&cid=416406873CB120AB&id=416406873CB120AB%213771&parId=416406873CB120AB%213767&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3769&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686689610440&OR=ItemsView)

#### [Unit 13 - Final Project](https://1drv.ms/f/s!AqsgsTyHBmRBhCl9zNQJnUEuOSX7)

* [Classroom presentation](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!600&parId=416406873CB120AB!553&authkey=!AH3M1AmdQS45Jfs&app=PowerPoint)
* [Educator Guide](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!598&parId=416406873CB120AB!553&authkey=!AH3M1AmdQS45Jfs&app=Word)
* [Student workbook](https://onedrive.live.com/view.aspx?cid=416406873cb120ab&page=view&resid=416406873CB120AB!599&parId=416406873CB120AB!553&authkey=!AH3M1AmdQS45Jfs&app=Word)
* [Quick start video](https://onedrive.live.com/?authkey=%21AH3M1AmdQS45Jfs&cid=416406873CB120AB&id=416406873CB120AB%21601&parId=416406873CB120AB%21553&o=OneUp)
* [Quick start video (PowerPoint)](https://onedrive.live.com/view.aspx?resid=416406873CB120AB!3773&cid=416406873cb120ab&authkey=!ALunv1kXkaA0RLg&CT=1686689876705&OR=ItemsView)

## Localization scripts

* [Video scripts](https://onedrive.live.com/?authkey=%21ALunv1kXkaA0RLg&id=416406873CB120AB%21523&cid=416406873CB120AB)
