# Writing Code

## ~ avatar

The syntax of JavaScript may seem daunting at first, but we've got help to get you through it.

## ~

Programming languages are quite picky with _syntax_ (the format of the code text), a single character can prevent your program from working! Let's review a few tools available in MakeCode to make your coding experience better.

## JavaScript toolbox

Just like the blocks toolbox, you can drag and drop snippets of JavaScript. It's a great way to discover how the syntax works.

![JavaScript toolbox](/static/courses/blocks-to-javascript/jstoolbox.gif)

## Suggestions and auto-completion

When you start typing, you will quickly notice a menu of suggestions popping up right under the cursor. The editor is giving you possible snippets of code based on what you've just written (this is something that professional developer uses every day!).

When you see the option for what you were trying to type, press **Enter** to insert it... rather than typing it entirely.

![Auto completion with the keyboard](/static/courses/blocks-to-javascript/jsautocompletion.gif)

## Pairing brackets

Brackets and parenthesis always come in pairs, an opening one and a closing one. However, with so many brackets and parenthesis all over the place, it's challenging to match both of them up.

**Place your cursor on a bracket or parenthesis** and the editor will highlight the matching pair! Nice, thanks editor!

![Bracket matching](/static/courses/blocks-to-javascript/jsbracketmatch.gif)

## Indentation lines

After a while you might have many nested loops and if statements, it can be difficult to see which "level"
you are in. Code inside the loops and if statements is indented to show that it belongs in there. This helps your eye keep track of where things are.

Check the **indentation lines** to find your way back to the higher code "levels". Also, when loops or if statements are inside of each other, this is called "nesting".

![Indentation](/static/courses/blocks-to-javascript/jsscope.png)

## Error squiggles

When the editor detects a syntax error, it puts red squiggles where it thinks the error is.

Place your mouse over the squiggle to get a detailed error message to help you fix the problem.

![A squiggle message](/static/courses/blocks-to-javascript/jssquiggles.gif)

### ~ hint

**Pro tip**: always look at the first error and fix that one. The other errors could be due to that one.

### ~

## Auto-formatting

Does your code look shifted badly or isn't showing the levels properly? Press ``Shift + Alt + F`` to auto-format your code and keep it tidy.

![Reformat the code](/static/courses/blocks-to-javascript/jsreformat.gif)
