# Courses

A collection of courses and tutorials built for the @boardname@.

## First lessons with MakeCode and the micro:bit

A sequence of six beginner lessons, ideal for getting started with the micro:bit. Students will learn core computing concepts by making and coding engaging projects.

```codecard
[{
  "name": "First Lessons",
  "description": "A sequence of lessons from the Micro:bit Educational Foundation that provide a pathway through six projects, ideal for getting started with the micro:bit",
  "url":"https://microbit.org/teach/lessons/first-lessons-with-makecode-and-the-microbit",
  "imageUrl": "/static/courses/first-lessons.png"
}]
```

## Intro to Computer Science

MakeCode's course for learning Computer Science with the micro:bit. This is a 14 week computer science course for middle school grades 6-8.

```codecard
[{
  "name": "Intro to CS Online",
  "description": "Online edition of the Intro to Computer Science course",
  "url":"/courses/csintro",
  "imageUrl": "/static/courses/csintro.jpg"
}, {
  "name": "Intro to CS Classroom",
  "description": "Educator edition of the Intro to Computer Science course for the classroom, including complete downloadable materials",
  "url":"/courses/csintro-educator",
  "imageUrl": "/static/courses/csintro-educator.jpg"
}]
```

## Classroom

Courses contributed by educators to teach computing, science, and technology in the classroom.

```codecard
[{
  "name": "Science Experiments",
  "description": "Science experiment lessons with measurements and data analysis activities",
  "url":"/courses/ucp-science",
  "imageUrl": "/static/courses/ucp-science.jpg"
}, {
  "name": "Cyber Arcade: Programming and Making with micro:bit",
  "description": "A fun and creative introduction to computer science and hands-on making for makers in elementary (ages 9–12) and middle (ages 12–14) grade levels with little to no experience in programming and 3D design.",
  "url":"https://makered.org/resources/cyber-arcade-programming-and-making-with-microbit/",
  "imageUrl": "/static/courses/maker-ed-cyber-arcade.png"
}, {
  "name": "Learn All About micro:bit",
  "description": "Projects and integration notes for a student-led workshop from the Beacon Hill School",
  "url": "https://goo.gl/XTPYpP",
  "imageUrl": "/static/courses/beaconhill.jpg"
}, {
  "name": "Coding and Innovation",
  "description": "An 8 week \"Coding and Innovation using micro:bits\" computer science course.",
  "url": "https://sites.google.com/view/utahcodingproject/microbits/coding-innovation",
  "imageUrl": "/static/courses/coding-innovation.jpg"
}]
```

## Mr. Morrison Lessons

Lessons aimed at P4-7 (Yr 3-6, aged 7-12) but could be adapted for use with older or younger learners. Regardless of age, if your learners have not used micro:bits before the best place to start is the 'Starter Lessons' followed by the 'Beyond Basics' Lessons.

```codecard
[{
  "name": "micro:bit Starter Lessons",
  "description": "Learn to create code, make programs to read inputs and write to outputs.",
  "url": "https://mrmorrison.co.uk/microbit/starter/",
  "imageUrl": "/static/courses/mr-morrison/starter-lessons.png"
}, {
  "name": "micro:bit Beyond Basics",
  "description": "Take a step past the basics and learn to use logic with inputs and outputs.",
  "url": "https://mrmorrison.co.uk/microbit/beyondbasics/",
  "imageUrl": "/static/courses/mr-morrison/beyond-basics.png"
}, {
  "name": "micro:bit Data and Sustainability",
  "description": "Learn to record and analyse data using the micro:bit, then learn to design and build a smart sustainable home.",
  "url": "https://mrmorrison.co.uk/microbit/datasustainability/",
  "imageUrl": "/static/courses/mr-morrison/data-sustainability.png"
}]
```

## Computers and programming

Tutorials, lessons, and mini-courses about programming and computing.

```codecard
[{
  "name": "First Steps",
  "description": "Learn how to get the micro:bit working, program its features and create your first projects.",
  "url": "https://microbit.org/get-started/first-steps/introduction/",
  "imageUrl": "/static/courses/first-steps.png"
}, {
  "name": "Make it: code it",
  "description": "Quick projects to suit all ages, searchable by computing topic, level, coding language and micro:bit feature.",
  "url": "https://microbit.org/projects/make-it-code-it/",
  "imageUrl": "/static/courses/make-it-code-it.png"
}, {
  "name": "Networking with the micro:bit",
  "description": "A series of activities to teach the basics of computer networks.",
  "url": "https://www.digitaltechnologieshub.edu.au/search/networking-with-the-micro-bit/",
  "imageUrl": "/static/courses/networking-book.png"  
}, {
  "name": "SparkFun Videos",
  "description": "YouTube video tutorials produced by the SparkFun team!",
  "url": "https://youtu.be/kaNtg1HGXbY?list=PLBcrWxTa5CS0mWJrytvii8aG5KUqMXvSk",
  "imageUrl": "https://i.ytimg.com/vi/kaNtg1HGXbY/hqdefault.jpg"
}, {
  "name": "Logic Lab",
  "description": "Learn the basics of logic and conditional expressions.",
  "url":"/courses/logic-lab",
  "imageUrl":"/static/courses/logic-lab.png"
}, {
  "name": "CodeJoy Remote Robotics",
  "description": "Interactive remote robotics and& coding classes for students and educators",
  "url": "https://www.codejoyeducation.com",
  "imageUrl": "/static/courses/codejoy.png"
}]
```

## Experimenting

Fun project courses - make and experiment while learning about science and programming.

```codecard
[{
  "name": "Blocks to JavaScript",
  "description": "Learn to code using JavaScript",
  "url": "/courses/blocks-to-javascript",
  "imageUrl": "/static/courses/blocks-to-javascript.png"
}, {
  "name": "SparkFun Inventor's Kit",
  "description": "Your map for navigating the waters of beginning embedded electronics, robotics and citizen science using the micro:bit.",
  "url": "https://learn.sparkfun.com/tutorials/sparkfun-inventors-kit-for-microbit-experiment-guide/introduction-to-the-sparkfun-inventors-kit-for-microbit",
  "imageUrl": "/static/courses/sparkfun-inventors-kit.png"
}, {
  "name": "Kitronik Inventor Kit",
  "description": "11 experiments based on the Kitronik Inventor Kit",
  "url": "https://www.kitronik.co.uk/blog/inventors-kit-experiment-1-help",
  "imageUrl": "/static/courses/kitronik-inventor-kit.png"
}, {
  "name": "micro:bit of Things",
  "description": "A hands-on course about the micro:bit and what you can do with it.",
  "url":"https://sites.google.com/view/microbitofthings",
  "imageUrl": "/static/courses/microbit-of-things.jpg"
}, {
  "name": "ARM University - micro:course",
  "description": "Introduce learners to the world of making and programming through a series of real-world challenges that feature the micro:bit.",
  "url": "https://github.com/arm-university/micro-course",
  "imageUrl": "/static/courses/armu-micro-course.png"
}, {
  "name": "A-Z Robotics",
  "description": "Absolute beginner's guide to learning coding, electronics and robotics on the micro:bit",
  "url":"https://tinkerspark.teachable.com/",
  "imageUrl": "/static/courses/tinkerspark.jpg"
}]
```

## See Also

[Intro to CS](/courses/csintro)
