# @extends

## #support

* [Support](https://support.microbit.org/)

## #projects

* [Projects](/projects)
    * [Flashing Heart](/projects/flashing-heart)
    * [Smiley Buttons](/projects/smiley-buttons)
    * [Love Meter](/projects/love-meter)
    * [Rock Paper Scissors](/projects/rock-paper-scissors)
    * [Magic Button Trick](/projects/magic-button-trick)
    * [Coin Flipper](/projects/coin-flipper)
    * [Salute!](/projects/salute)
    * [Hack Your Headphones](/projects/hack-your-headphones)
    * [Banana Keyboard](/projects/banana-keyboard)
    * [Guitar](/projects/guitar)
    * [Duct Tape Wallet](/projects/wallet)
    * [Watch](/projects/watch)
    * [Soil Moisture](/projects/soil-moisture)
    * [Plant Watering](/projects/plant-watering)
    * [Reaction Time](/projects/reaction-time)
    * [States of Matter](/projects/states-of-matter)
    * [Mood Radio](/projects/mood-radio)
    * [Tele-Potato](/projects/tele-potato)
    * [Hot or Cold](/projects/hot-or-cold)
    * [Voting Machine](/projects/voting-machine)
    * [Infection](/projects/infection)
    * [Fireflies](/projects/fireflies)
    * [Rock Paper Scissors Teams](/projects/rps-teams)
    * [Inchworm](/projects/inchworm)
    * [Milk Carton Robot](/projects/milk-carton-robot)
    * [Milk Monster](/projects/milky-monster)
    * [RC Car](/projects/rc-car)
    * [Timing Gates](/projects/timing-gates)
    * [Compass](/projects/compass)
    * [Telegraph](/projects/telegraph)
    * [Railway Crossing](/projects/railway-crossing)
    * [Karel](/projects/karel)
    * [Stopwatch](/projects/stopwatch)
    * [Name Tag](/projects/name-tag)
    * [Step counter](/projects/step-counter)
    * [Servo calibrator](/projects/servo-calibrator)
    * [Analog Pin Tester](/projects/analog-pin-tester)
    * [Light Level Meter](/projects/light-level-meter)
    * [Radio bridge](/projects/radio-bridge)
    * [Snap the dot](/projects/snap-the-dot)
    * [Red light green light](/projects/red-light-green-light)
    * [Name Badge](/projects/name-badge)

## #examples

## #courses

* [Courses](/courses)
    * [CS Intro](/courses/csintro)
        * [About](/courses/csintro/about)
        * [Introduction](/courses/csintro/introduction)
        * [References](/courses/csintro/references)
        * [Acknowledgements](/courses/csintro/acknowledgements)
        * [Making](/courses/csintro/making)
            * [Introduction](/courses/csintro/making/introduction)
            * [Unplugged](/courses/csintro/making/unplugged)
            * [Walkthrough](/courses/csintro/making/activity)
            * [Project](/courses/csintro/making/project)
            * [Standards](/courses/csintro/making/standards)
        * [Algorithms](/courses/csintro/algorithms)
            * [Overview](/courses/csintro/algorithms/overview)
            * [Unplugged](/courses/csintro/algorithms/unplugged)
            * [Activity](/courses/csintro/algorithms/activity)
            * [Project](/courses/csintro/algorithms/project)
            * [Standards](/courses/csintro/algorithms/standards)
        * [Variables](/courses/csintro/variables)
            * [Overview](/courses/csintro/variables/overview)
            * [Unplugged](/courses/csintro/variables/unplugged)
            * [Activity](/courses/csintro/variables/activity)
            * [Project](/courses/csintro/variables/project)
            * [Standards](/courses/csintro/variables/standards)
        * [Conditionals](/courses/csintro/conditionals)
            * [Overview](/courses/csintro/conditionals/overview)
            * [Unplugged](/courses/csintro/conditionals/unplugged)
            * [Activity](/courses/csintro/conditionals/activity)
            * [Project](/courses/csintro/conditionals/project)
            * [Standards](/courses/csintro/conditionals/standards)
        * [Iteration](/courses/csintro/iteration)
            * [Overview](/courses/csintro/iteration/overview)
            * [Unplugged](/courses/csintro/iteration/unplugged)
            * [Activity](/courses/csintro/iteration/activity)
            * [Project](/courses/csintro/iteration/project)
            * [Standards](/courses/csintro/iteration/standards)
        * [Mini-project](/courses/csintro/miniproject)
            * [Review](/courses/csintro/miniproject/review)
            * [Activity](/courses/csintro/miniproject/activity)
            * [Project](/courses/csintro/miniproject/project)
            * [Standards](/courses/csintro/miniproject/standards)
        * [Coordinates](/courses/csintro/coordinates)
            * [Overview](/courses/csintro/coordinates/overview)
            * [Unplugged](/courses/csintro/coordinates/unplugged)
            * [Activity](/courses/csintro/coordinates/activity)
            * [Project](/courses/csintro/coordinates/project)
            * [Standards](/courses/csintro/coordinates/standards)
        * [Booleans](/courses/csintro/booleans)
            * [Overview](/courses/csintro/booleans/overview)
            * [Unplugged](/courses/csintro/booleans/unplugged)
            * [Activity](/courses/csintro/booleans/activity)
            * [Project](/courses/csintro/booleans/project)
            * [Standards](/courses/csintro/booleans/standards)
        * [Binary](/courses/csintro/binary)
            * [Overview](/courses/csintro/binary/overview)
            * [Unplugged](/courses/csintro/binary/unplugged)
            * [Activity](/courses/csintro/binary/activity)
            * [Project](/courses/csintro/binary/project)
            * [Standards](/courses/csintro/binary/standards)
        * [Radio](/courses/csintro/radio)
            * [Overview](/courses/csintro/radio/overview)
            * [Unplugged](/courses/csintro/radio/unplugged)
            * [Activity](/courses/csintro/radio/activity)
            * [Project](/courses/csintro/radio/project)
            * [Standards](/courses/csintro/radio/standards)
        * [Arrays](/courses/csintro/arrays)
            * [Overview](/courses/csintro/arrays/overview)
            * [Unplugged](/courses/csintro/arrays/unplugged)
            * [Activity](/courses/csintro/arrays/activity)
            * [Project](/courses/csintro/arrays/project)
            * [Standards](/courses/csintro/arrays/standards)
        * [Final Project](/courses/csintro/finalproject)
            * [Review](/courses/csintro/finalproject/review)
            * [Project](/courses/csintro/finalproject/project)
            * [Examples](/courses/csintro/finalproject/examples)
            * [Standards](/courses/csintro/finalproject/standards)
    * [Blocks to JavaScript](/courses/blocks-to-javascript)
        * [Hello JavaScript](/courses/blocks-to-javascript/hello-javascript)
        * [Starter Blocks](/courses/blocks-to-javascript/starter-blocks)
        * [Writing Code](/courses/blocks-to-javascript/writing-code)
        * [Conditional Loops](/courses/blocks-to-javascript/conditional-loops)
        * [Writing Functions](/courses/blocks-to-javascript/writing-functions)
    * [Science experiments](/courses/ucp-science)
        * [Data collection](/courses/ucp-science/data-collection)
            * [Overview](/courses/ucp-science/data-collection/overview)
            * [Setup and procedure](/courses/ucp-science/data-collection/setup-procedure)
            * [Resources](/courses/ucp-science/data-collection/resources)
        * [Population Traits](/courses/ucp-science/population)
            * [Overview](/courses/ucp-science/population/overview)
            * [Setup and procedure](/courses/ucp-science/population/setup-procedure)
            * [Resources](/courses/ucp-science/population/resources)
        * [Temperature](/courses/ucp-science/temperature)
            * [Overview](/courses/ucp-science/temperature/overview)
            * [Setup and procedure](/courses/ucp-science/temperature/setup-procedure)
            * [Resources](/courses/ucp-science/temperature/resources)
        * [Soil Moisture](/courses/ucp-science/soil-moisture)
            * [Overview](/courses/ucp-science/soil-moisture/overview)
            * [Setup and procedure](/courses/ucp-science/soil-moisture/setup-procedure)
            * [Resources](/courses/ucp-science/soil-moisture/resources)
        * [Gravity, Motion and Waves](/courses/ucp-science/gravity)
            * [Overview](/courses/ucp-science/gravity/overview)
            * [Setup and procedure](/courses/ucp-science/gravity/setup-procedure)
            * [Resources](/courses/ucp-science/gravity/resources)
        * [Body Electrical and Waves](/courses/ucp-science/body-electrical)
            * [Overview](/courses/ucp-science/body-electrical/overview)
            * [Setup and procedure](/courses/ucp-science/body-electrical/setup-procedure)
            * [Resources](/courses/ucp-science/body-electrical/resources)
        * [Electricity](/courses/ucp-science/electricity)
            * [Overview](/courses/ucp-science/electricity/overview)
            * [Setup and procedure](/courses/ucp-science/electricity/setup-procedure)
            * [Resources](/courses/ucp-science/electricity/resources)
        * [Rocket Acceleration](/courses/ucp-science/rocket-acceleration)
            * [Overview](/courses/ucp-science/rocket-acceleration/overview)
            * [Build](/courses/ucp-science/rocket-acceleration/build)
            * [Setup and procedure](/courses/ucp-science/rocket-acceleration/setup-procedure)
            * [Resources](/courses/ucp-science/rocket-acceleration/resources)
    * [Logic Lab](/courses/logic-lab)
        * [Logic and Expressions](/courses/logic-lab/expressions)
        * [Boolean Elements](/courses/logic-lab/elements)
        * [Logic Explorer](/courses/logic-lab/explorer)
        * [Logic Gates](/courses/logic-lab/logic-gates)
        * [Programmable Logic](/courses/logic-lab/programmable)

## #reference

* [Reference](/reference)
    * [Basic](/reference/basic)
        * [show number](/reference/basic/show-number)
        * [show icon](/reference/basic/show-icon)
        * [show leds](/reference/basic/show-leds)
        * [show string](/reference/basic/show-string)
        * [clear screen](/reference/basic/clear-screen)
        * [forever](/reference/basic/forever)
        * [pause](/reference/basic/pause)
        * [show arrow](/reference/basic/show-arrow)
    * [Input](/reference/input)
        * [on button pressed](/reference/input/on-button-pressed)
        * [on gesture](/reference/input/on-gesture)
        * [on pin pressed](/reference/input/on-pin-pressed)
        * [button is pressed](/reference/input/button-is-pressed)
        * [compass heading](/reference/input/compass-heading)
        * [pin is pressed](/reference/input/pin-is-pressed)
        * [temperature](/reference/input/temperature)
        * [acceleration](/reference/input/acceleration)
        * [light level](/reference/input/light-level)
        * [rotation](/reference/input/rotation)
        * [magnetic force](/reference/input/magnetic-force)
        * [running time](/reference/input/running-time)
        * [set accelerometer range](/reference/input/set-accelerometer-range)
    * [Music](/reference/music)
        * [play tone](/reference/music/play-tone)
        * [ring tone](/reference/music/ring-tone)
        * [rest](/reference/music/rest)
        * [beat](/reference/music/beat)
        * [tempo](/reference/music/tempo)
        * [change tempo by](/reference/music/change-tempo-by)
        * [set tempo](/reference/music/set-tempo)
    * [Led](/reference/led)
        * [plot](/reference/led/plot)
        * [unplot](/reference/led/unplot)
        * [point](/reference/led/point)
        * [toggle](/reference/led/toggle)
        * [brightness](/reference/led/brightness)
        * [set brightness](/reference/led/set-brightness)
        * [stop animation](/reference/led/stop-animation)
        * [plot bar graph](/reference/led/plot-bar-graph)
        * [enable](/reference/led/enable)
    * [Radio](/reference/radio)
        * [send number](/reference/radio/send-number)
        * [send value](/reference/radio/send-value)
        * [send string](/reference/radio/send-string)
        * [on received number](/reference/radio/on-received-number)
        * [on received string](/reference/radio/on-received-string)
        * [on received buffer](/reference/radio/on-received-buffer)
        * [received packet](/reference/radio/received-packet)
        * [set group](/reference/radio/set-group)
        * [set transmit power](/reference/radio/set-transmit-power)
        * [set transmit serial number](/reference/radio/set-transmit-serial-number)
        * [on data packet received](/reference/radio/on-data-packet-received)
        * [write received packet to serial](/reference/radio/write-received-packet-to-serial)
    * [Game](/reference/game)
        * [create sprite](/reference/game/create-sprite)
        * [delete](/reference/game/delete)
        * [move](/reference/game/move)
        * [turn](/reference/game/turn)
        * [if on edge bounce](/reference/game/if-on-edge-bounce)
        * [get](/reference/game/get)
        * [set](/reference/game/set)
        * [change](/reference/game/change)
        * [is touching](/reference/game/is-touching)
        * [is touching edge](/reference/game/is-touching-edge)
        * [add score](/reference/game/add-score)
        * [score](/reference/game/score)
        * [set score](/reference/game/set-score)
        * [set life](/reference/game/set-life)
        * [add life](/reference/game/add-life)
        * [remove life](/reference/game/remove-life)
        * [start countdown](/reference/game/start-countdown)
        * [game over](/reference/game/game-over)
        * [pause](/reference/game/pause)
        * [resume](/reference/game/resume)
    * [Images](/reference/images)
        * [create image](/reference/images/create-image)
        * [create big image](/reference/images/create-big-image)
        * [show image](/reference/images/show-image)
        * [scroll image](/reference/images/scroll-image)
        * [arrow image](/reference/images/arrow-image)
        * [icon image](/reference/images/icon-image)
        * [arrow number](/reference/images/arrow-number)
    * [Pins](/reference/pins)
        * [digital read pin](/reference/pins/digital-read-pin)
        * [digital write pin](/reference/pins/digital-write-pin)
        * [analog read pin](/reference/pins/analog-read-pin)
        * [analog write pin](/reference/pins/analog-write-pin)
        * [analog set period](/reference/pins/analog-set-period)
        * [map](/reference/pins/map)
        * [on pulsed](/reference/pins/on-pulsed)
        * [pulse duration](/reference/pins/pulse-duration)
        * [pulse in](/reference/pins/pulse-in)
        * [servo write pin](/reference/pins/servo-write-pin)
        * [servo set pulse](/reference/pins/servo-set-pulse)
        * [i2c read number](/reference/pins/i2c-read-number)
        * [i2c write number](/reference/pins/i2c-write-number)
        * [set pull](/reference/pins/set-pull)
        * [analog pitch](/reference/pins/analog-pitch)
        * [analog set pitch pin](/reference/pins/analog-set-pitch-pin)
        * [spi write](/reference/pins/spi-write)
        * [spi Pins](/reference/pins/spi-pins)
        * [spi format](/reference/pins/spi-format)
        * [spi frequency](/reference/pins/spi-frequency)
    * [Serial](/reference/serial)
        * [write line](/reference/serial/write-line)
        * [write number](/reference/serial/write-number)
        * [write value](/reference/serial/write-value)
        * [write string](/reference/serial/write-string)
        * [read until](/reference/serial/read-until)
        * [read line](/reference/serial/read-line)
        * [read string](/reference/serial/read-string)
        * [on data received](/reference/serial/on-data-received)
        * [redirect](/reference/serial/redirect)
        * [redirect to usb](/reference/serial/redirect-to-usb)
        * [set baud rate](/reference/serial/set-baud-rate)
        * [set write line padding](/reference/serial/set-write-line-padding)
        * [write buffer](/reference/serial/write-buffer)
        * [read buffer](/reference/serial/read-buffer)
    * [Control](/reference/control)
        * [in background](/reference/control/in-background)
        * [reset](/reference/control/reset)
        * [wait micros](/reference/control/wait-micros)
        * [on event](/reference/control/on-event)
        * [raise event](/reference/control/raise-event)
        * [event timestamp](/reference/control/event-timestamp)
        * [event value](/reference/control/event-value)
    * [Bluetooth](/reference/bluetooth)
        * [About](/reference/bluetooth/about-bluetooth)
        * [Pairing](/reference/bluetooth/bluetooth-pairing)
        * [on bluetooth connected](/reference/bluetooth/on-bluetooth-connected)
        * [on bluetooth disconnected](/reference/bluetooth/on-bluetooth-disconnected)
        * [start accelerometer service](/reference/bluetooth/start-accelerometer-service)
        * [start button service](/reference/bluetooth/start-button-service)
        * [start io pin service](/reference/bluetooth/start-io-pin-service)
        * [start led service](/reference/bluetooth/start-led-service)
        * [start magnetometer service](/reference/bluetooth/start-magnetometer-service)
        * [start temperature service](/reference/bluetooth/start-temperature-service)
        * [start uart service](/reference/bluetooth/start-uart-service)
        * [uart read until](/reference/bluetooth/uart-read-until)
        * [uart write string](/reference/bluetooth/uart-write-string)
        * [uart write number](/reference/bluetooth/uart-write-number)
        * [uart write value](/reference/bluetooth/uart-write-value)
        * [advertise url](/reference/bluetooth/advertise-url)
        * [stop advertising](/reference/bluetooth/stop-advertising)
        * [advertise uid](/reference/bluetooth/advertise-uid)
        * [advertise-uid-buffer](/reference/bluetooth/advertise-uid-buffer)

## #packages

* [Extensions](/extensions)

## #types

* [Types](/types)
    * [Number](/types/number)
    * [String](/types/string)
    * [Boolean](/types/boolean)
    * [Array](/types/array)
    * [Function](/types/function)
    * [Buffer](/types/buffer)
        * [Using buffers](/types/buffer/using-buffers)
        * [Number format](/types/buffer/number-format)

## #other

* [Blocks Gallery](/block-gallery)

## Miscellaneous #misc

* Miscellaneous
    * [About](/about)
    * [Support](/support)
    * [Translate](/translate)
    * [Sharing projects](/share)
    * [Offline support](/offline)
    * [Save](/save)    
    * [Sign In](/identity/sign-in)
    * [Cloud Sync](/identity/cloud-sync)
    * [Home Page Content](/homepage-content)

* [Hardware](/device)
    * [Data Analysis](/device/data-analysis)
        * [Plotting with LEDs](/device/data-analysis/led-plotting)
        * [Viewing Data](/device/data-analysis/viewing)
        * [Writing Data](/device/data-analysis/writing)
        * [Generating Data](/device/data-analysis/generating)
        * [Analyzing Data](/device/data-analysis/analyze)
        * [Remote Data](/device/data-analysis/remote)
    * [Error codes](/device/error-codes)
    * [Foil circuits](/device/foil-circuits)
    * [Incompatible Hardware](/device/incompatible)
    * [MES events](/device/mes-events)
    * [Pins](/device/pins)
    * [Reactive](/device/reactive)
    * [Screen](/device/screen)
    * [Serial](/device/serial)
    * [Servo](/device/servo)
    * [Simulator](/device/simulator)
    * [USB](/device/usb)
    * [WebUSB](/device/usb/webusb)
        * [WebUSB Troubleshoot](/device/usb/webusb/troubleshoot)
    * [Flashing via HID (CMSIS-DAP)](/hidflash)
