# Semantic Versioning
> NOTE: Support for `setuptools_scm` is currently removed due to a known [issue](https://github.com/pypa/setuptools_scm/issues/357) with the way pip installations restrict access to certain SCM metadata during package installation. Support will be restored when `setuptools_scm` and `pip` developers fix this with a patch.

This library is configured to use
[setuptools_scm](https://github.com/pypa/setuptools_scm/) to automatically get package version from git commit histories.

**There shouldn't be any references to manually coded versions**.

Verify what git tag to use by running:

```bash
python setup.py --version
```
It should look something like `0.1.0.dev4+gdfedba7.d20190209`

Using the information above the master branch, after a merge commit, can be _**Tagged**_ with the above semantic version `0.1.0` (ignoring the `dev4+gdfedba7.d20190209`)  

For example: 

    git tag v0.1.0  

Now verify the semantic version for the package:

    python setup.py --version


All new merged commit on master must have a
   [Semantic Versioning](https://semver.org/) release version with an
   accompanying tag.  TL;DR:
   * `major.minor.patch`
   * Patch is for bugfix
   * Minor is for new features
   * Major is for backwards-incompatible changes
   * tags should be of the form `v0.1.2`  

Installing this library into another clean git repository with a tag version, you should get a nice version like `0.2.1`.  

However, if you inspect the `__version__` in this repo,
you'll get a nice **'dirty'** version number like `'0.2.1.dev0+g850a76d.d20180908'`.  

This is useful for debugging, building sphinx docs in dev and so on.   

You should never have to specify a version manually except just tagging your commit from the tag calculation generated by running  

    python setup.py --version 

