# Notebooks

We present a complete list of the notebooks available in FarmVibes.AI with a short summary for each of them. Besides their description, we also include the expected disk space and running time required per notebook, considering the recommended VM size.

<br>

---------------


## Summary

We organize available notebooks in the following topics:

<details>
<summary> Getting Started </summary>

- [`Hello World` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/helloworld.ipynb)

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb)


</details>
<details>
<summary> ADMAg - Microsoft Azure Data Manager for Agriculture </summary>

- [`Carbon sequestration evaluation with Microsoft Azure Data Manager for Agriculture (ADMAg) and COMET-Farm API` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_and_comet_farm_api_example.ipynb)

- [`Integration with ADMAg to compute NDVI summary` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_example.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)


</details>
<details>
<summary> BingMaps </summary>

- [`Automatic Segmentation of BingMaps basemaps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_automatic_segmentation.ipynb)

- [`Segment Anything Model Workflow (BingMaps basemap)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_segmentation.ipynb)


</details>
<details>
<summary> Crop Analysis </summary>

- [`Harvest and germination periods` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/harvest_period/ndvi_summary.ipynb)

- [`Integration with ADMAg to compute NDVI summary` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_example.ipynb)


</details>
<details>
<summary> Crop Land Segmentation </summary>

- [`Crop land segmentation (1/4) - dataset generation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/01_dataset_generation.ipynb)

- [`Crop land segmentation (2/4) - dataset visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/02_visualize_dataset.ipynb)

- [`Crop land segmentation (3/4) - local model training` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_local_training.ipynb)

- [`Crop land segmentation (3/4) - model training on Azure Machine Learning ` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_aml_training.ipynb)

- [`Crop land segmentation (4/4) - inference` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/04_inference.ipynb)


</details>
<details>
<summary> Deforestation </summary>

- [`Detecting Forest Changes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/forest_change_detection.ipynb)

- [`Download ALOS forest extent maps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_alos_forest_map.ipynb)

- [`Download Glad Forest Map` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_glad_forest_map.ipynb)

- [`Download Global Forest Change (Hansen) maps.` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_hansen_forest_map.ipynb)


</details>
<details>
<summary> Index Computation </summary>

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb)

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb)

- [`Harvest and germination periods` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/harvest_period/ndvi_summary.ipynb)

- [`Irrigation classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/irrigation_classification.ipynb)

- [`Land degradation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/land_degradation/land_degradation.ipynb)

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb)

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb)

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb)

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb)

- [`Timelapse visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/timelapse_visualization.ipynb)


</details>
<details>
<summary> Landsat </summary>

- [`Irrigation classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/irrigation_classification.ipynb)

- [`Land degradation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/land_degradation/land_degradation.ipynb)


</details>
<details>
<summary> Model Training </summary>

- [`Crop land segmentation (1/4) - dataset generation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/01_dataset_generation.ipynb)

- [`Crop land segmentation (3/4) - local model training` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_local_training.ipynb)

- [`Crop land segmentation (3/4) - model training on Azure Machine Learning ` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_aml_training.ipynb)

- [`Micro climate prediction` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/deepmc/mc_forecast.ipynb)

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb)

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb)

- [`Weed detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/weed_detection/weed_detection.ipynb)


</details>
<details>
<summary> ONNX Integration </summary>

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb)

- [`Crop land segmentation (3/4) - local model training` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_local_training.ipynb)

- [`Crop land segmentation (3/4) - model training on Azure Machine Learning ` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_aml_training.ipynb)

- [`Crop land segmentation (4/4) - inference` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/04_inference.ipynb)


</details>
<details>
<summary> Remote Sensing </summary>

- [`Automatic Segmentation of BingMaps basemaps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_automatic_segmentation.ipynb)

- [`Automatic Segmentation of Sentinel-2` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_automatic_segmentation.ipynb)

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb)

- [`Crop land segmentation (1/4) - dataset generation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/01_dataset_generation.ipynb)

- [`Crop land segmentation (2/4) - dataset visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/02_visualize_dataset.ipynb)

- [`Crop land segmentation (3/4) - local model training` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_local_training.ipynb)

- [`Crop land segmentation (3/4) - model training on Azure Machine Learning ` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_aml_training.ipynb)

- [`Crop land segmentation (4/4) - inference` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/04_inference.ipynb)

- [`Detecting Forest Changes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/forest_change_detection.ipynb)

- [`Download ALOS forest extent maps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_alos_forest_map.ipynb)

- [`Download Glad Forest Map` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_glad_forest_map.ipynb)

- [`Download Global Forest Change (Hansen) maps.` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_hansen_forest_map.ipynb)

- [`Field boundary segmentation (SAM exploration)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sam_exploration.ipynb)

- [`Field-level Irrigation Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/field_level_irrigation_classification.ipynb)

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb)

- [`Harvest and germination periods` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/harvest_period/ndvi_summary.ipynb)

- [`Investigating Amazon Rainforest deforestation with SpaceEye` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/sentinel_spaceeye.ipynb)

- [`Irrigation classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/irrigation_classification.ipynb)

- [`Land degradation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/land_degradation/land_degradation.ipynb)

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb)

- [`Segment Anything Model Workflow (BingMaps basemap)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_segmentation.ipynb)

- [`Segment Anything Model Workflow (Sentinel-2)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_segmentation.ipynb)

- [`Spectral Extension` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/spectral_extension/spectral_extension.ipynb)

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb)

- [`Timelapse visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/timelapse_visualization.ipynb)

- [`Weed detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/weed_detection/weed_detection.ipynb)


</details>
<details>
<summary> Segment Anything Model </summary>

- [`Automatic Segmentation of BingMaps basemaps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_automatic_segmentation.ipynb)

- [`Automatic Segmentation of Sentinel-2` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_automatic_segmentation.ipynb)

- [`Field boundary segmentation (SAM exploration)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sam_exploration.ipynb)

- [`Field-level Irrigation Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/field_level_irrigation_classification.ipynb)

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb)

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb)

- [`Segment Anything Model Workflow (BingMaps basemap)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_segmentation.ipynb)

- [`Segment Anything Model Workflow (Sentinel-2)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_segmentation.ipynb)


</details>
<details>
<summary> Sentinel </summary>

- [`Automatic Segmentation of Sentinel-2` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_automatic_segmentation.ipynb)

- [`Field boundary segmentation (SAM exploration)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sam_exploration.ipynb)

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb)

- [`Investigating Amazon Rainforest deforestation with SpaceEye` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/sentinel_spaceeye.ipynb)

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb)

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb)

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb)

- [`Segment Anything Model Workflow (Sentinel-2)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_segmentation.ipynb)

- [`Spectral Extension` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/spectral_extension/spectral_extension.ipynb)

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb)


</details>
<details>
<summary> SpaceEye </summary>

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb)

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb)

- [`Investigating Amazon Rainforest deforestation with SpaceEye` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/sentinel_spaceeye.ipynb)

- [`Timelapse visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/timelapse_visualization.ipynb)


</details>
<details>
<summary> Sustainability </summary>

- [`Carbon sequestration evaluation with Microsoft Azure Data Manager for Agriculture (ADMAg) and COMET-Farm API` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_and_comet_farm_api_example.ipynb)

- [`Detecting Forest Changes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/forest_change_detection.ipynb)

- [`Download ALOS forest extent maps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_alos_forest_map.ipynb)

- [`Download Glad Forest Map` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_glad_forest_map.ipynb)

- [`Download Global Forest Change (Hansen) maps.` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_hansen_forest_map.ipynb)

- [`Green House Gas fluxes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/ghg_fluxes/ghg_fluxes.ipynb)

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb)

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb)

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb)

- [`What-if analysis of carbon sequestration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/carbon/whatif.ipynb)


</details>
<details>
<summary> Time Series </summary>

- [`Harvest and germination periods` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/harvest_period/ndvi_summary.ipynb)


</details>
<details>
<summary> Water Management </summary>

- [`Field-level Irrigation Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/field_level_irrigation_classification.ipynb)

- [`Irrigation classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/irrigation_classification.ipynb)


</details>
<details>
<summary> Weather </summary>

- [`Land degradation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/land_degradation/land_degradation.ipynb)

- [`Micro climate prediction` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/deepmc/mc_forecast.ipynb)


</details>
<details>
<summary> What-if Analysis </summary>

- [`Carbon sequestration evaluation with Microsoft Azure Data Manager for Agriculture (ADMAg) and COMET-Farm API` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_and_comet_farm_api_example.ipynb)

- [`Green House Gas fluxes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/ghg_fluxes/ghg_fluxes.ipynb)

- [`What-if analysis of carbon sequestration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/carbon/whatif.ipynb)


</details>
<details>
<summary> Working with Custom Workflows </summary>

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb)

- [`Crop land segmentation (1/4) - dataset generation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/01_dataset_generation.ipynb)

- [`Crop land segmentation (2/4) - dataset visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/02_visualize_dataset.ipynb)

- [`Integration with ADMAg to compute NDVI summary` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_example.ipynb)

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb)

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb)

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb)

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb)

- [`Timelapse visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/timelapse_visualization.ipynb)


</details>




<br>

---------------


## Notebooks description

- [`Automatic Segmentation of BingMaps basemaps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_automatic_segmentation.ipynb) : Automatically segment BingMaps basemaps with SAM workflow.

- [`Automatic Segmentation of Sentinel-2` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_automatic_segmentation.ipynb) : Automatically segment Sentinel-2 imagery with SAM workflow.

- [`Carbon sequestration evaluation with Microsoft Azure Data Manager for Agriculture (ADMAg) and COMET-Farm API` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_and_comet_farm_api_example.ipynb) : Derive carbon sequestration information with COMET-Farm API for agricultural fields, using Azure Data Manager for Agriculture to retrieve farming data.

- [`Crop cycle detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_cycles/crop_cycles.ipynb) : Run time-series analysis over NDVI data to detect the number of crop cycles in a year for a certain region.

- [`Crop land segmentation (1/4) - dataset generation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/01_dataset_generation.ipynb) : Generate a dataset based on NDVI and CDL rasters to train a crop land segmentation model.

- [`Crop land segmentation (2/4) - dataset visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/02_visualize_dataset.ipynb) : Visual exploration of the crop land segmentation dataset.

- [`Crop land segmentation (3/4) - local model training` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_local_training.ipynb) : Train a crop land segmentation model locally.

- [`Crop land segmentation (3/4) - model training on Azure Machine Learning ` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/03_aml_training.ipynb) : Train a crop land segmentation model on Azure Machine Learning.

- [`Crop land segmentation (4/4) - inference` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/crop_segmentation/04_inference.ipynb) : Infer crop land segmentation for new regions with a trained model.

- [`Detecting Forest Changes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/forest_change_detection.ipynb) : Helps users to detect forest changes

- [`Download ALOS forest extent maps` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_alos_forest_map.ipynb) : This notebook downloads the ALOS (Advanced Land Observing Satellite) forest extent maps

- [`Download Glad Forest Map` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_glad_forest_map.ipynb) : This notebook downloads the Global Land Analysis (GLAD) forest extent maps.

- [`Download Global Forest Change (Hansen) maps.` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/forest/download_hansen_forest_map.ipynb) : This notebook contains functions to download and process the Global Forest Change (Hansen) maps.

- [`Field boundary segmentation (SAM exploration)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sam_exploration.ipynb) : Segment Anything Model exploration over FarmVibes.AI data to segment crop field boundaries.

- [`Field-level Irrigation Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/field_level_irrigation_classification.ipynb) : Estimate an irrigation probability map over crop fields segmented with Segment Anything Model.

- [`Field-level spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/field_level_spectral_indices.ipynb) : Compute and visualize spectral indices over crop fields segmented from Sentinel-2 and SpaceEye imagery.

- [`Green House Gas fluxes` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/ghg_fluxes/ghg_fluxes.ipynb)  (30s) : Compute GHG emissions and sequestration for a given crop, location and time range.

- [`Harvest and germination periods` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/harvest_period/ndvi_summary.ipynb) : Infer harvest and germination periods from NDVI time series.

- [`Hello World` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/helloworld.ipynb) : Simple example of how to instantiate a client and run a workflow.

- [`Integration with ADMAg to compute NDVI summary` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/admag/azure_data_manager_for_agriculture_example.ipynb) : Connecting FarmVibes.AI and Microsoft Azure Data Manager for Agriculture (ADMAg)

- [`Investigating Amazon Rainforest deforestation with SpaceEye` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/sentinel_spaceeye.ipynb) : Download and preprocess Sentinel data to obtain cloud-free images using SpaceEye over the Amazon Rainforest.

- [`Irrigation classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/irrigation/irrigation_classification.ipynb) : Generate irrigation probability map by running workflow that uses Landsat8 image and DEM data

- [`Land degradation` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/land_degradation/land_degradation.ipynb) : Compute NDVI trends on Landsat images and analyse precipitation data to detect land degradation.

- [`Micro climate prediction` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/deepmc/mc_forecast.ipynb) : Train a model to predict micro climate parameters given global weather information and local weather station data.

- [`Nutrient Heatmap Estimation - Classification` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification.ipynb) : Using soil samples from a farm, train a Random Forest model to estimate a heatmap of soil nutrients.

- [`Nutrient Heatmap Estimation - Neighbors` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_neighbors.ipynb) : Estimate a heatmap of soil nutrients based on neighboring soil samples with location suggested by an optimal sensor placement workflow.

- [`Nutrient Heatmap Estimation with ADMAg integration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/heatmaps/nutrients_using_classification_admag.ipynb)  (~1GB, <1 minute) : Using soil samples from a farm retrieved with ADMAg, train a Random Forest model to estimate a heatmap of soil nutrients.

- [`Optimal Sensor Placement` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations.ipynb) : Helps to find optimal sensor placement location using satellite imagery. The optimal locations identified can be used to collect soil properties by installing sensors or performing other manual operations

- [`Optimal Sensor Placement over Segmented Crop Field` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sensor/optimal_locations_segmentation.ipynb) : Segment a field with Segment Anything Model over Sentinel-2 imagery and estimate optimal sensor placement for the segmented region.

- [`Segment Anything Model Workflow (BingMaps basemap)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/basemap_segmentation.ipynb) : Segment BingMaps basemaps with SAM workflow.

- [`Segment Anything Model Workflow (Sentinel-2)` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/segment_anything/sentinel2_segmentation.ipynb) : Segment Sentinel-2 imagery with SAM workflow.

- [`Spectral Extension` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/spectral_extension/spectral_extension.ipynb)  (~10 minutes) : Generate high-resolution multispectral data by combining high-resolution drone imagery and multispectral Sentinel-2 data.

- [`Spectral indices` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/spectral_indices.ipynb) : Compute and visualize spectral indices from Sentinel-2 imagery.

- [`Timelapse visualization` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/sentinel/timelapse_visualization.ipynb) : Generate a timelapse of SpaceEye and NDVI rasters.

- [`Weed detection` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/weed_detection/weed_detection.ipynb) : Train a Gaussian Mixture Model to group similar regions in a raster image affected by weed.

- [`What-if analysis of carbon sequestration` 📓](https://github.com/microsoft/farmvibes-ai/blob/main/notebooks/carbon/whatif.ipynb) : Derive carbon sequestration information with COMET-Farm API for agricultural fields.


