@description('The friendly name for the workbook that is used in the Gallery or Saved List.  This name must be unique within a resource group.')
param workbookDisplayName string = 'Azure Arc-enabled resources inventory'

@description('The gallery that the workbook will been shown under. Supported values include workbook, tsg, etc. Usually, this is \'workbook\'')
param workbookType string = 'workbook'

@description('The id of resource instance to which the workbook will be associated')
param workbookSourceId string = 'azure monitor'

@description('The unique guid for this workbook instance')
param workbookId string = 'c5c6a9e5-74fc-465a-9f11-1dd10aad501b'

@description('The location to deploy the workbook to')
param location string = resourceGroup().location

resource workbookId_resource 'microsoft.insights/workbooks@2022-04-01' = {
  name: workbookId
  location: location
  kind: 'shared'
  properties: {
    displayName: workbookDisplayName
    serializedData: '{"version":"Notebook/1.0","items":[{"type":9,"content":{"version":"KqlParameterItem/1.0","parameters":[{"id":"d8a4990e-5fd5-4c61-92a2-d07d04736a00","version":"KqlParameterItem/1.0","name":"Subscription","type":6,"isRequired":true,"typeSettings":{"additionalResourceOptions":[],"includeAll":false},"timeContext":{"durationMs":86400000},"value":"/subscriptions/00000000-0000-0000-0000-000000000000"},{"id":"b616a3a3-4271-4208-b1a9-a92a78efed08","version":"KqlParameterItem/1.0","name":"ResourceGroup","label":"Resource group","type":2,"isRequired":true,"query":"resourcecontainers \\r\\n| where type =~ \'microsoft.resources/subscriptions/resourcegroups\' \\r\\n| project name","crossComponentResources":["{Subscription}"],"typeSettings":{"additionalResourceOptions":[],"showDefault":false},"queryType":1,"resourceType":"microsoft.resourcegraph/resources","value":"rg-placeholder"},{"id":"05578175-fbe8-4dd2-9c6a-dec2f503d6cf","version":"KqlParameterItem/1.0","name":"Location","type":8,"isRequired":true,"multiSelect":true,"quote":"\'","delimiter":",","value":["value::all"],"typeSettings":{"additionalResourceOptions":["value::all"],"includeAll":true},"defaultValue":"value::all"},{"id":"3f095357-8b61-4bd5-bb16-bb03da10f44c","version":"KqlParameterItem/1.0","name":"ResourceType","type":7,"isRequired":true,"multiSelect":true,"quote":"\'","delimiter":",","value":["microsoft.hybridcompute/machines","microsoft.compute/virtualmachines"],"typeSettings":{"additionalResourceOptions":[],"showDefault":false},"jsonData":" [\\r\\n     { \\"value\\": \\"microsoft.compute/virtualmachines\\", \\"label\\": \\"Azure Virtual Machine\\", \\"selected\\":true}, \\r\\n     \\r\\n     { \\"value\\": \\"microsoft.hybridcompute/machines\\", \\"label\\": \\"Arc enabled server\\", \\"selected\\":true }]"}],"style":"pills","queryType":0,"resourceType":"microsoft.operationalinsights/workspaces"},"name":"parameters - 4"},{"type":1,"content":{"json":"# Azure Arc-enabled resources inventory\\n"},"name":"text - 1"},{"type":12,"content":{"version":"NotebookGroup/1.0","groupType":"editable","title":"Machines overall status & configurations","expandable":true,"expanded":true,"items":[{"type":3,"content":{"version":"KqlItem/1.0","query":"resources \\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| extend osType = coalesce(tostring(properties.osName), tostring(properties.osType), tostring(properties.storageProfile.osDisk.osType))\\r\\n| summarize\\r\\nazureLinux = countif(type =~ \\"microsoft.compute/virtualmachines\\" and  osType =~ \\"Linux\\"),\\r\\narcLinux = countif(type =~ \\"microsoft.hybridcompute/machines\\" and osType =~ \\"Linux\\"),\\r\\nazureWindows = countif(type =~ \\"microsoft.compute/virtualmachines\\" and  osType =~ \\"Windows\\"),\\r\\narcWindows = countif(type =~ \\"microsoft.hybridcompute/machines\\" and osType =~ \\"Windows\\")\\r\\n| project machinePack = pack(\\"Azure virtual machines-Linux\\", azureLinux, \\"Arc enabled servers-Linux\\", arcLinux, \\"Azure virtual machines-Windows\\", azureWindows, \\"Arc enabled servers-Windows\\", arcWindows)\\r\\n| mv-expand machinePack\\r\\n| extend machine = tostring(bag_keys(machinePack)[0])\\r\\n| extend count_ = tolong(machinePack[machine])\\r\\n| project machine, count_ ","size":3,"title":"Total machines","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"piechart","tileSettings":{"showBorder":false},"graphSettings":{"type":0},"mapSettings":{"locInfo":"LatLong","sizeSettings":"azureLinux","sizeAggregation":"Sum","legendMetric":"azureLinux","legendAggregation":"Sum","itemColorSettings":{"type":"heatmap","colorAggregation":"Sum","nodeColorField":"azureLinux","heatmapPalette":"greenRed"}}},"customWidth":"50","name":"query - 0","styleSettings":{"maxWidth":"50%"}},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| where type in~ ({ResourceType})\\r\\n| where location in~ ({Location})\\r\\n| extend statuso = iff(isnull(properties.extended.instanceView.powerState.displayStatus), (properties.status), (properties.extended.instanceView.powerState.displayStatus))\\r\\n| where isnotnull(statuso)\\r\\n| summarize count() by tostring(statuso)","size":0,"title":"Status of machines","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"tiles","tileSettings":{"titleContent":{"columnMatch":"statuso","formatter":1},"leftContent":{"columnMatch":"count_","formatter":12,"formatOptions":{"palette":"auto"},"numberFormat":{"unit":17,"options":{"maximumSignificantDigits":3,"maximumFractionDigits":2}}},"showBorder":false,"sortCriteriaField":"statuso","sortOrderField":2}},"customWidth":"50","name":"query - 7","styleSettings":{"maxWidth":"50%"}}]},"name":"confGroup","styleSettings":{"showBorder":true}},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| where type =~ \'microsoft.hybridcompute/machines\'\\r\\n| extend id = tolower(id)\\r\\n| join(policyresources\\r\\n| extend ComplianceState = tostring(properties[\'complianceState\'])\\r\\n| extend id = tolower(properties[\'resourceId\'])) on id\\r\\n| summarize compliantCount = countif(ComplianceState == \\"Compliant\\"), nonCompliantCount = countif(ComplianceState == \\"NonCompliant\\") by name, type, id\\r\\n| project id, name, type, compliantCount, nonCompliantCount\\r\\n| sort by name asc\\r\\n| join (\\r\\nresources\\r\\n| where resourceGroup =~ \'{ResourceGroup}\'\\r\\n| where type =~ \'microsoft.hybridcompute/machines\'\\r\\n| extend id = tolower(id)\\r\\n| extend state = properties.status\\r\\n| extend status = case(\\r\\n    state =~ \'Connected\', \'Connected\',\\r\\n    state =~ \'Disconnected\', \'Offline\',\\r\\n    state =~ \'Error\', \'Error\',\\r\\n    state =~ \'Expired\', \'Expired\',\\r\\n    \'\')\\r\\n| extend agentVersion = properties.agentVersion\\r\\n| extend Application = tags.Application\\r\\n| extend operatingSystem = properties.osSku\\r\\n| extend resourceGroup = strcat(\\"/subscriptions/\\", subscriptionId, \\"/resourceGroups/\\", resourceGroup)\\r\\n| extend majorVersion = tostring(split(agentVersion, \'.\')[0])\\r\\n| extend minorVersion = tostring(split(agentVersion, \'.\')[1])\\r\\n| extend agentVersion = strcat(majorVersion, \'.\', minorVersion)\\r\\n| project id, status, agentVersion, operatingSystem, location, Application) on id\\r\\n| project id, status, agentVersion, operatingSystem, location, Application, CompliantPolicies=compliantCount, NonCompliantPolicies=nonCompliantCount\\r\\n","size":1,"title":"Azure Arc-enabled servers inventory","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["value::all"],"gridSettings":{"formatters":[{"columnMatch":"status","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"==","thresholdValue":"Connected","representation":"success","text":"{0}{1}"},{"operator":"Default","thresholdValue":null,"representation":"warning","text":"{0}{1}"}]}},{"columnMatch":"CompliantPolicies","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"Default","thresholdValue":null,"representation":"success","text":"{0}{1}"}]}},{"columnMatch":"NonCompliantPolicies","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"Default","thresholdValue":null,"representation":"3","text":"{0}{1}"}]}},{"columnMatch":"resourceGroup","formatter":14,"formatOptions":{"linkTarget":null,"showIcon":true}},{"columnMatch":"subscriptionId","formatter":15,"formatOptions":{"linkTarget":null,"showIcon":true}}]}},"name":"query - 0"},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| where type =~ \'microsoft.kubernetes/connectedclusters\'\\r\\n| extend id = tolower(id)\\r\\n| join(policyresources\\r\\n| extend ComplianceState = tostring(properties[\'complianceState\'])\\r\\n| extend id = tolower(properties[\'resourceId\'])) on id\\r\\n| summarize compliantCount = countif(ComplianceState == \\"Compliant\\"), nonCompliantCount = countif(ComplianceState == \\"NonCompliant\\") by name, type, id\\r\\n| project id, name, type, compliantCount, nonCompliantCount\\r\\n| sort by name asc\\r\\n| join (\\r\\nresources\\r\\n| where resourceGroup =~ \'{ResourceGroup}\'\\r\\n| where type =~ \'microsoft.kubernetes/connectedclusters\'\\r\\n| extend id = tolower(id)\\r\\n| extend state = properties.connectivityStatus\\r\\n| extend status = case(\\r\\n    state =~ \'Connected\', \'Connected\',\\r\\n    state =~ \'Disconnected\', \'Offline\',\\r\\n    state =~ \'Error\', \'Error\',\\r\\n    state =~ \'Expired\', \'Expired\',\\r\\n    \'\')\\r\\n| extend resourceGroup = strcat(\\"/subscriptions/\\", subscriptionId, \\"/resourceGroups/\\", resourceGroup)\\r\\n| extend  kubernetesVersion = properties.kubernetesVersion\\r\\n| project id, status, kubernetesVersion) on id\\r\\n| project id, status,kubernetesVersion,CompliantPolicies=compliantCount, NonCompliantPolicies=nonCompliantCount\\r\\n\\r\\n\\r\\n","size":1,"title":"Azure Arc-enabled Kubernetes clusters inventory","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["value::all"],"gridSettings":{"formatters":[{"columnMatch":"status","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"==","thresholdValue":"Connected","representation":"success","text":"{0}{1}"},{"operator":"Default","thresholdValue":null,"representation":"warning","text":"{0}{1}"}]}},{"columnMatch":"CompliantPolicies","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"Default","thresholdValue":null,"representation":"success","text":"{0}{1}"}]}},{"columnMatch":"NonCompliantPolicies","formatter":18,"formatOptions":{"thresholdsOptions":"icons","thresholdsGrid":[{"operator":"Default","thresholdValue":null,"representation":"3","text":"{0}{1}"}]}},{"columnMatch":"resourceGroup","formatter":14,"formatOptions":{"linkTarget":null,"showIcon":true}},{"columnMatch":"subscriptionId","formatter":15,"formatOptions":{"linkTarget":null,"showIcon":true}}]}},"name":"query - 0 - Copy"},{"type":12,"content":{"version":"NotebookGroup/1.0","groupType":"editable","title":"Updates Data Overview","expandable":true,"expanded":true,"items":[{"type":3,"content":{"version":"KqlItem/1.0","query":"\\r\\n(resources //join of virtual machines, you can play with params as you see fit.\\r\\n| where type in~ ({ResourceType}\\r\\n)\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| where location in ({Location})\\r\\n| extend os = iff(type =~ \\"microsoft.compute/virtualmachines\\", tolower(tostring(properties.storageProfile.osDisk.osType)), tolower(coalesce(tostring(properties.osName), tostring(properties.osType))))\\r\\n| extend id=tolower(id)\\r\\n| extend status=iff(type =~ \\"microsoft.compute/virtualmachines\\", properties.extended.instanceView.powerState.displayStatus, properties.status)\\r\\n| project id, name, os, status, resourceProperties=properties)\\r\\n| join kind=leftouter //finally, making a left outer join to fetch updates details from patchassessment\\r\\n((patchassessmentresources\\r\\n| where type in~ (\\"microsoft.compute/virtualmachines/patchassessmentresults\\", \\"microsoft.hybridcompute/machines/patchassessmentresults\\")\\r\\n| where location in ({Location})\\r\\n| where properties.status == \\"Succeeded\\"\\r\\n| parse id with resourceId \\"/patchAssessmentResults\\" *\\r\\n| extend resourceId=tolower(resourceId)\\r\\n| project resourceId, assessProperties=properties))\\r\\non $left.id == $right.resourceId //join on resources id & patchassessment id that is parsed.\\r\\n| summarize\\r\\ntotal = countif(1 == 1),\\r\\nnodata = countif(isnull(assessProperties) == true),\\r\\npendingReboot = countif(isnotnull(assessProperties) and assessProperties.rebootPending == \\"true\\"),\\r\\n//pendingUpdates - when any classification has > 0 updates\\r\\npendingUpdatesWindows = countif(isnotnull(assessProperties) and assessProperties.osType =~ \\"Windows\\" and (assessProperties.availablePatchCountByClassification.critical>0 or assessProperties.availablePatchCountByClassification.security>0 or assessProperties.availablePatchCountByClassification.updateRollup>0 or assessProperties.availablePatchCountByClassification.featurePack>0 or assessProperties.availablePatchCountByClassification.servicePack>0 or assessProperties.availablePatchCountByClassification.definition>0 or assessProperties.availablePatchCountByClassification.tools>0 or assessProperties.availablePatchCountByClassification.updates>0)),\\r\\npendingUpdatesLinux = countif(isnotnull(assessProperties) and assessProperties.osType =~ \\"Linux\\" and (assessProperties.availablePatchCountByClassification.security>0 or assessProperties.availablePatchCountByClassification.other>0)),\\r\\n//noPendingUpdates - when all classifications has 0 updates\\r\\nnoPendingUpdatesWindows = countif(isnotnull(assessProperties) and assessProperties.osType =~ \\"Windows\\" and (assessProperties.availablePatchCountByClassification.critical==0 and assessProperties.availablePatchCountByClassification.security==0 and assessProperties.availablePatchCountByClassification.updateRollup==0 and assessProperties.availablePatchCountByClassification.featurePack==0 and assessProperties.availablePatchCountByClassification.servicePack==0 and assessProperties.availablePatchCountByClassification.definition==0 and assessProperties.availablePatchCountByClassification.tools==0 and assessProperties.availablePatchCountByClassification.updates==0)),\\r\\nnoPendingUpdatesLinux = countif(isnotnull(assessProperties) and assessProperties.osType =~ \\"Linux\\" and (assessProperties.availablePatchCountByClassification.security==0 and assessProperties.availablePatchCountByClassification.other==0))\\r\\n| project machinePack = pack(\\"No updates available - Linux\\", noPendingUpdatesLinux,  \\"No updates available - Windows\\", noPendingUpdatesWindows,  \\"Updates available - Linux\\", pendingUpdatesLinux,  \\"Updates available - Windows\\", pendingUpdatesWindows, \\"Reboot required\\", pendingReboot,  \\"No updates data\\", nodata, \\"Total machines\\", total)\\r\\n| mv-expand machinePack\\r\\n| extend machine = tostring(bag_keys(machinePack)[0])\\r\\n| extend count_ = tolong(machinePack[machine])\\r\\n| project machine, count_ \\r\\n","size":4,"title":"Updates status of machines","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"tiles","tileSettings":{"titleContent":{"columnMatch":"machine","formatter":1},"leftContent":{"columnMatch":"count_","formatter":12,"formatOptions":{"palette":"auto"},"numberFormat":{"unit":17,"options":{"maximumSignificantDigits":3,"maximumFractionDigits":2}}},"showBorder":false,"sortCriteriaField":"count_","sortOrderField":2,"size":"auto"},"graphSettings":{"type":0,"topContent":{"columnMatch":"machine","formatter":1},"centerContent":{"columnMatch":"count_","formatter":1,"numberFormat":{"unit":17,"options":{"maximumSignificantDigits":3,"maximumFractionDigits":2}}}},"mapSettings":{"locInfo":"LatLong","sizeSettings":"count_","sizeAggregation":"Sum","legendMetric":"count_","legendAggregation":"Sum","itemColorSettings":{"type":"heatmap","colorAggregation":"Sum","nodeColorField":"count_","heatmapPalette":"greenRed"}}},"name":"query - 5"},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where type in~ ({ResourceType})\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| extend joinId = tolower(id)\\r\\n| project joinId\\r\\n| join kind=leftouter\\r\\n(\\r\\npatchassessmentresources\\r\\n| where type in~ (\\"microsoft.compute/virtualmachines/patchassessmentresults\\", \\"microsoft.hybridcompute/machines/patchassessmentresults\\")\\r\\n| extend assessment = properties.availablePatchCountByClassification\\r\\n| where isnotnull(assessment)\\r\\n| parse id with resourceId \\"/patchAssessmentResults\\" *\\r\\n| extend joinId=tolower(resourceId)\\r\\n) on $left.joinId == $right.joinId\\r\\n| summarize\\r\\ntotal = 0,\\r\\nsecurityWindowsUpdates = sumif(toint(assessment.security), (isnotnull(properties) and properties.osType =~ \\"Windows\\" and (assessment.security>0))),\\r\\ncriticalWindowsUpdates = sumif(toint(assessment.critical), (isnotnull(properties) and properties.osType =~ \\"Windows\\" and (assessment.critical>0))),\\r\\nsecurityLinuxUpdates = sumif(toint(assessment.security), (isnotnull(properties) and properties.osType =~ \\"Linux\\" and (assessment.security>0))),\\r\\notherLinuxUpdates = sumif(toint(assessment.other), (isnotnull(properties) and properties.osType =~ \\"Linux\\" and (assessment.other>0))),\\r\\notherWindowsUpdates = sumif(toint(assessment.updateRollup) + toint(assessment.featurePack) + toint(assessment.servicePack) + toint(assessment.definition) +\\r\\ntoint(assessment.tools) + toint(assessment.updates), isnotnull(properties) and properties.osType =~ \\"Windows\\" and\\r\\n(assessment.updateRollup>0 or assessment.featurePack>0 or assessment.servicePack>0 or assessment.definition>0 or assessment.tools>0 or assessment.updates>0))","size":0,"title":"Pending Windows and Linux updates by classification ","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"unstackedbar","tileSettings":{"showBorder":false},"chartSettings":{"seriesLabelSettings":[{"seriesName":"criticalWindowsUpdates","label":"Critical updates - Windows","color":"orange"},{"seriesName":"securityLinuxUpdates","label":"Security updates - Linux","color":"redBright"},{"seriesName":"otherLinuxUpdates","label":"Other updates - Linux","color":"turquoise"},{"seriesName":"otherWindowsUpdates","label":"Other updates - Windows","color":"gray"},{"seriesName":"securityWindowsUpdates","label":"Security updates - Windows","color":"redBright"}]}},"customWidth":"50","name":"query - 4","styleSettings":{"maxWidth":"50%"}},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where type in~ ({ResourceType})\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| extend joinId = tolower(id)\\r\\n| project joinId\\r\\n| join kind=leftouter\\r\\n(\\r\\npatchassessmentresources\\r\\n| where type in~ (\\"microsoft.compute/virtualmachines/patchassessmentresults\\", \\"microsoft.hybridcompute/machines/patchassessmentresults\\")\\r\\n| extend assessment = properties.availablePatchCountByClassification\\r\\n| where isnotnull(assessment)\\r\\n| parse id with resourceId \\"/patchAssessmentResults\\" *\\r\\n| extend joinId=tolower(resourceId)\\r\\n) on $left.joinId == $right.joinId\\r\\n| summarize\\r\\ntotal = 0,\\r\\nsecurityWindowsMachines = countif(isnotnull(properties) and properties.osType =~ \\"Windows\\" and (assessment.security>0)),\\r\\ncriticalWindowsMachines = countif(isnotnull(properties) and properties.osType =~ \\"Windows\\" and (assessment.critical>0)),\\r\\notherWindowsMachines = countif(isnotnull(properties) and properties.osType =~ \\"Windows\\" and (assessment.updateRollup>0 or assessment.featurePack>0 or assessment.servicePack>0 or assessment.definition>0 or assessment.tools>0 or assessment.updates>0)),\\r\\nsecurityLinuxMachines = countif(isnotnull(properties) and properties.osType =~ \\"Linux\\" and (assessment.security>0)),\\r\\notherLinuxMachines = countif(isnotnull(properties) and properties.osType =~ \\"Linux\\" and (assessment.other>0))\\r\\n","size":0,"title":"Machines with Pending Updates by classification","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"unstackedbar","chartSettings":{"seriesLabelSettings":[{"seriesName":"criticalWindowsMachines","label":"Critical - Windows","color":"orange"},{"seriesName":"otherWindowsMachines","label":"Other - Windows","color":"turquoise"},{"seriesName":"securityLinuxMachines","label":"Security - Linux","color":"redBright"},{"seriesName":"otherLinuxMachines","label":"Other - Linux","color":"turquoise"},{"seriesName":"securityWindowsMachines","label":"Security - Windows","color":"redBright"}]}},"customWidth":"50","name":"query - 3","styleSettings":{"maxWidth":"50%"}},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where type in~ ({ResourceType})\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| extend joinId = tolower(id)\\r\\n| project joinId\\r\\n| join kind=inner \\r\\n(\\r\\npatchassessmentresources\\r\\n| where type in~ (\\"microsoft.compute/virtualmachines/patchassessmentresults/softwarepatches\\", \\"microsoft.hybridcompute/machines/patchassessmentresults/softwarepatches\\")\\r\\n| extend id = tolower(id)\\r\\n| parse id with resourceId \\"/patchassessmentresults\\" *\\r\\n| extend joinId=tolower(resourceId)\\r\\n| where isnotnull(properties.kbId)\\r\\n| extend MissingUpdate = tostring(properties.patchName)\\r\\n| extend Classification = tostring(properties.classifications[0])\\r\\n| project joinId, MissingUpdate, Classification\\r\\n) \\r\\non $left.joinId == $right.joinId\\r\\n| summarize Machines = count() by MissingUpdate, Classification\\r\\n| order by Machines desc\\r\\n| take 10\\r\\n","size":0,"title":"Top 10 Pending Windows Updates (by machine count)","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"table","gridSettings":{"sortBy":[{"itemKey":"Classification","sortOrder":2}],"labelSettings":[{"columnId":"MissingUpdate","label":"Missing update"}]},"sortBy":[{"itemKey":"Classification","sortOrder":2}],"tileSettings":{"showBorder":false,"titleContent":{"columnMatch":"properties_patchName","formatter":1},"leftContent":{"columnMatch":"count_","formatter":12,"formatOptions":{"palette":"auto"},"numberFormat":{"unit":17,"options":{"maximumSignificantDigits":3,"maximumFractionDigits":2}}}},"graphSettings":{"type":0,"topContent":{"columnMatch":"properties_patchName","formatter":1},"centerContent":{"columnMatch":"count_","formatter":1,"numberFormat":{"unit":17,"options":{"maximumSignificantDigits":3,"maximumFractionDigits":2}}},"nodeIdField":"properties_patchName","sourceIdField":"properties_patchName","targetIdField":"count_","graphOrientation":3,"showOrientationToggles":false,"nodeSize":null,"staticNodeSize":100,"colorSettings":null,"hivesMargin":5},"mapSettings":{"locInfo":"LatLong","sizeSettings":"count_","sizeAggregation":"Sum","legendMetric":"count_","legendAggregation":"Sum","itemColorSettings":{"type":"heatmap","colorAggregation":"Sum","nodeColorField":"count_","heatmapPalette":"greenRed"}}},"customWidth":"50","name":"query - 9","styleSettings":{"maxWidth":"50%"}},{"type":3,"content":{"version":"KqlItem/1.0","query":"resources\\r\\n| where type in~ ({ResourceType})\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| extend joinId = tolower(id)\\r\\n| project joinId\\r\\n| join kind=inner \\r\\n(\\r\\npatchassessmentresources\\r\\n| where type in~ (\\"microsoft.compute/virtualmachines/patchassessmentresults/softwarepatches\\", \\"microsoft.hybridcompute/machines/patchassessmentresults/softwarepatches\\")\\r\\n| extend id = tolower(id)\\r\\n| parse id with resourceId \\"/patchassessmentresults\\" *\\r\\n| extend joinId=tolower(resourceId)\\r\\n| where isnull(properties.kbId)\\r\\n| extend MissingUpdate = tostring(properties.patchName)\\r\\n| extend Classification = tostring(properties.classifications[0])\\r\\n| project joinId, MissingUpdate, Classification\\r\\n) \\r\\non $left.joinId == $right.joinId\\r\\n| summarize Machines = count() by MissingUpdate, Classification\\r\\n| order by Machines desc\\r\\n| take 10","size":0,"title":"Top 10 Pending Linux Updates (by machine count)","queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"visualization":"table","gridSettings":{"sortBy":[{"itemKey":"Machines","sortOrder":2}],"labelSettings":[{"columnId":"MissingUpdate","label":"Missing update"}]},"sortBy":[{"itemKey":"Machines","sortOrder":2}]},"customWidth":"50","name":"query - 10","styleSettings":{"maxWidth":"50%"}}]},"name":"updatesGroup","styleSettings":{"showBorder":true}},{"type":3,"content":{"version":"KqlItem/1.0","query":"securityresources\\r\\n| where type == \\"microsoft.security/locations/alerts\\"\\r\\n| where subscriptionId == \'{Subscription:subscriptionid}\' and resourceGroup == tolower(\'{ResourceGroup}\')\\r\\n| project-rename P= properties\\r\\n| extend Details = parse_json(P)\\r\\n| extend IsIncident = Details.[\\"IsIncident\\"]\\r\\n| extend AlertDisplayName = Details.[\\"AlertDisplayName\\"]\\r\\n| extend SystemAlertId = Details.[\\"SystemAlertId\\"]\\r\\n| extend Severity = tostring(Details.[\\"Severity\\"])\\r\\n| where Severity == \\"High\\"\\r\\n| extend AlertUri = Details.[\\"AlertUri\\"]\\r\\n| extend Status = tostring(Details.[\\"Status\\"])\\r\\n| extend Tactics = tostring(Details.[\\"Intent\\"])\\r\\n| extend ResourceIdentifiers = Details.[\\"ResourceIdentifiers\\"]\\r\\n| mv-expand ResourceIdentifiers\\r\\n| extend ResourceId = parse_json(ResourceIdentifiers).[\\"AzureResourceId\\"]\\r\\n| where Status == \\"Active\\"\\r\\n| extend SeverityRank = case(\\r\\n    Severity == \'High\', 3,\\r\\n    Severity == \'Medium\', 2,\\r\\n    Severity == \'Low\', 1,\\r\\n    0\\r\\n    )\\r\\n| parse AlertUri with * \'/subscriptionId/\'  SubscriptionId  \'/\' *\\r\\n| parse AlertUri with * \'/resourceGroup/\'  ResourceGroup  \'/\' *\\r\\n| parse AlertUri with * \'/location/\'  Location  \\r\\n| project\\r\\n    Severity,\\r\\n    SystemAlertId,\\r\\n    AlertDisplayName,\\r\\n    IsIncident = iif(IsIncident == \\"true\\", \\"Incident\\", \\"Alert\\"),\\r\\n    AlertUri,\\r\\n    Tactics,\\r\\n    SeverityRank,\\r\\n    SubscriptionId,\\r\\n    ResourceGroup,\\r\\n    Location,\\r\\n    ResourceId\\r\\n| sort by SeverityRank","size":0,"title":"Defender for Cloud {$rowCount} Active Alerts ","noDataMessage":"No active alerts","noDataMessageStyle":3,"exportedParameters":[{"fieldName":"ResourceId","parameterName":"Resource","parameterType":1},{"fieldName":"AlertUri","parameterName":"AlertUri","parameterType":1},{"fieldName":"SystemAlertId","parameterName":"SystemAlertId","parameterType":1},{"fieldName":"SubscriptionId","parameterName":"SubscriptionId","parameterType":1},{"fieldName":"ResourceGroup","parameterName":"ResourceGroup","parameterType":1},{"fieldName":"Location","parameterName":"Location","parameterType":1}],"queryType":1,"resourceType":"microsoft.resourcegraph/resources","crossComponentResources":["{Subscription}"],"gridSettings":{"formatters":[{"columnMatch":"Severity","formatter":18,"formatOptions":{"thresholdsOptions":"colors","thresholdsGrid":[{"operator":"contains","thresholdValue":"High","representation":"redBright","text":"{0}{1}"},{"operator":"contains","thresholdValue":"Medium","representation":"orange","text":"{0}{1}"},{"operator":"contains","thresholdValue":"Low","representation":"yellow","text":"{0}{1}"},{"operator":"contains","thresholdValue":"Informational ","representation":"gray","text":"{0}{1}"},{"operator":"Default","thresholdValue":null,"representation":null,"text":"{0}{1}"}]}},{"columnMatch":"SystemAlertId","formatter":5},{"columnMatch":"AlertDisplayName","formatter":1,"formatOptions":{"linkTarget":"OpenBlade","bladeOpenContext":{"bladeName":"AlertBlade","extensionName":"Microsoft_Azure_Security","bladeParameters":[{"name":"alertId","source":"column","value":"SystemAlertId"},{"name":"subscriptionId","source":"column","value":"SubscriptionId"},{"name":"resourceGroup","source":"column","value":"ResourceGroup"},{"name":"referencedFrom","source":"static","value":"activeAlertsWorkbook"},{"name":"location","source":"column","value":"Location"}]}}},{"columnMatch":"IsIncident","formatter":1},{"columnMatch":"AlertUri","formatter":5},{"columnMatch":"Tactics","formatter":1},{"columnMatch":"SubscriptionId","formatter":15,"formatOptions":{"linkTarget":"Resource","showIcon":true}},{"columnMatch":"Location","formatter":17},{"columnMatch":"ResourceId","formatter":13,"formatOptions":{"linkTarget":"Resource","showIcon":true}},{"columnMatch":"TenantId","formatter":5},{"columnMatch":"AlertName","formatter":5},{"columnMatch":"Description","formatter":5},{"columnMatch":"ProviderName","formatter":5},{"columnMatch":"VendorName","formatter":5},{"columnMatch":"VendorOriginalId","formatter":5},{"columnMatch":"SourceComputerId","formatter":5},{"columnMatch":"AlertType","formatter":5},{"columnMatch":"ConfidenceLevel","formatter":5},{"columnMatch":"ConfidenceScore","formatter":5},{"columnMatch":"StartTime","formatter":5},{"columnMatch":"EndTime","formatter":5},{"columnMatch":"ProcessingEndTime","formatter":5},{"columnMatch":"RemediationSteps","formatter":5},{"columnMatch":"ExtendedProperties","formatter":5},{"columnMatch":"Entities","formatter":5},{"columnMatch":"SourceSystem","formatter":5},{"columnMatch":"WorkspaceSubscriptionId","formatter":5},{"columnMatch":"WorkspaceResourceGroup","formatter":5},{"columnMatch":"ExtendedLinks","formatter":5},{"columnMatch":"ProductName","formatter":5},{"columnMatch":"ProductComponentName","formatter":5},{"columnMatch":"AlertLink","formatter":7,"formatOptions":{"linkTarget":"Url"}},{"columnMatch":"SystemIncidentId","formatter":5},{"columnMatch":"SystemAlertId1","formatter":5}],"labelSettings":[{"columnId":"SystemAlertId","label":"Alert ID"},{"columnId":"AlertDisplayName","label":"Alert name"},{"columnId":"IsIncident","label":"Incident/alert"},{"columnId":"SeverityRank","label":"Severity"},{"columnId":"SubscriptionId","label":"Subscription"},{"columnId":"ResourceGroup","label":"Resource group"},{"columnId":"ResourceId","label":"Resource"}]},"sortBy":[]},"showPin":true,"name":"SecurityIncidents - FilterbyResourceId","styleSettings":{"showBorder":true}}],"isLocked":false,"fallbackResourceIds":["azure monitor"]}'
    version: '1.0'
    sourceId: workbookSourceId
    category: workbookType
  }
  dependsOn: []
}

output workbookId string = workbookId_resource.id
