--
-- PostgreSQL database dump
--

-- Dumped from database version 12.3 (Debian 12.3-1.pgdg100+1)
-- Dumped by pg_dump version 12.3 (Debian 12.3-1.pgdg100+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: hr; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA hr;


ALTER SCHEMA hr OWNER TO postgres;

--
-- Name: humanresources; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA humanresources;


ALTER SCHEMA humanresources OWNER TO postgres;

--
-- Name: SCHEMA humanresources; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA humanresources IS 'Contains objects related to employees and departments.';


--
-- Name: pe; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA pe;


ALTER SCHEMA pe OWNER TO postgres;

--
-- Name: person; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA person;


ALTER SCHEMA person OWNER TO postgres;

--
-- Name: SCHEMA person; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA person IS 'Contains objects related to names and addresses of customers, vendors, and employees';


--
-- Name: pr; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA pr;


ALTER SCHEMA pr OWNER TO postgres;

--
-- Name: production; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA production;


ALTER SCHEMA production OWNER TO postgres;

--
-- Name: SCHEMA production; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA production IS 'Contains objects related to products, inventory, and manufacturing.';


--
-- Name: pu; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA pu;


ALTER SCHEMA pu OWNER TO postgres;

--
-- Name: purchasing; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA purchasing;


ALTER SCHEMA purchasing OWNER TO postgres;

--
-- Name: SCHEMA purchasing; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA purchasing IS 'Contains objects related to vendors and purchase orders.';


--
-- Name: sa; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA sa;


ALTER SCHEMA sa OWNER TO postgres;

--
-- Name: sales; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA sales;


ALTER SCHEMA sales OWNER TO postgres;

--
-- Name: SCHEMA sales; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA sales IS 'Contains objects related to customers, sales orders, and sales territories.';


--
-- Name: tablefunc; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS tablefunc WITH SCHEMA public;


--
-- Name: EXTENSION tablefunc; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION tablefunc IS 'functions that manipulate whole tables, including crosstab';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


--
-- Name: AccountNumber; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."AccountNumber" AS character varying(15);


ALTER DOMAIN public."AccountNumber" OWNER TO postgres;

--
-- Name: Flag; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."Flag" AS boolean NOT NULL;


ALTER DOMAIN public."Flag" OWNER TO postgres;

--
-- Name: Name; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."Name" AS character varying(50);


ALTER DOMAIN public."Name" OWNER TO postgres;

--
-- Name: NameStyle; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."NameStyle" AS boolean NOT NULL;


ALTER DOMAIN public."NameStyle" OWNER TO postgres;

--
-- Name: OrderNumber; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."OrderNumber" AS character varying(25);


ALTER DOMAIN public."OrderNumber" OWNER TO postgres;

--
-- Name: Phone; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN public."Phone" AS character varying(25);


ALTER DOMAIN public."Phone" OWNER TO postgres;

--
-- Name: arc_controller_endpoints(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.arc_controller_endpoints() RETURNS json
    LANGUAGE c
    AS '$libdir/dusky.so', 'arc_controller_endpoints';


ALTER FUNCTION public.arc_controller_endpoints() OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: department; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.department (
    departmentid integer NOT NULL,
    name public."Name" NOT NULL,
    groupname public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE humanresources.department OWNER TO postgres;

--
-- Name: TABLE department; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.department IS 'Lookup table containing the departments within the Adventure Works Cycles company.';


--
-- Name: COLUMN department.departmentid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.department.departmentid IS 'Primary key for Department records.';


--
-- Name: COLUMN department.name; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.department.name IS 'Name of the department.';


--
-- Name: COLUMN department.groupname; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.department.groupname IS 'Name of the group to which the department belongs.';


--
-- Name: d; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.d AS
 SELECT department.departmentid AS id,
    department.departmentid,
    department.name,
    department.groupname,
    department.modifieddate
   FROM humanresources.department;


ALTER TABLE hr.d OWNER TO postgres;

--
-- Name: employee; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.employee (
    businessentityid integer NOT NULL,
    nationalidnumber character varying(15) NOT NULL,
    loginid character varying(256) NOT NULL,
    jobtitle character varying(50) NOT NULL,
    birthdate date NOT NULL,
    maritalstatus character(1) NOT NULL,
    gender character(1) NOT NULL,
    hiredate date NOT NULL,
    salariedflag public."Flag" DEFAULT true NOT NULL,
    vacationhours smallint DEFAULT 0 NOT NULL,
    sickleavehours smallint DEFAULT 0 NOT NULL,
    currentflag public."Flag" DEFAULT true NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    organizationnode character varying DEFAULT '/'::character varying,
    CONSTRAINT "CK_Employee_BirthDate" CHECK (((birthdate >= '1930-01-01'::date) AND (birthdate <= (now() - '18 years'::interval)))),
    CONSTRAINT "CK_Employee_Gender" CHECK ((upper((gender)::text) = ANY (ARRAY['M'::text, 'F'::text]))),
    CONSTRAINT "CK_Employee_HireDate" CHECK (((hiredate >= '1996-07-01'::date) AND (hiredate <= (now() + '1 day'::interval)))),
    CONSTRAINT "CK_Employee_MaritalStatus" CHECK ((upper((maritalstatus)::text) = ANY (ARRAY['M'::text, 'S'::text]))),
    CONSTRAINT "CK_Employee_SickLeaveHours" CHECK (((sickleavehours >= 0) AND (sickleavehours <= 120))),
    CONSTRAINT "CK_Employee_VacationHours" CHECK (((vacationhours >= '-40'::integer) AND (vacationhours <= 240)))
);


ALTER TABLE humanresources.employee OWNER TO postgres;

--
-- Name: TABLE employee; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.employee IS 'Employee information such as salary, department, and title.';


--
-- Name: COLUMN employee.businessentityid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.businessentityid IS 'Primary key for Employee records.  Foreign key to BusinessEntity.BusinessEntityID.';


--
-- Name: COLUMN employee.nationalidnumber; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.nationalidnumber IS 'Unique national identification number such as a social security number.';


--
-- Name: COLUMN employee.loginid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.loginid IS 'Network login.';


--
-- Name: COLUMN employee.jobtitle; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.jobtitle IS 'Work title such as Buyer or Sales Representative.';


--
-- Name: COLUMN employee.birthdate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.birthdate IS 'Date of birth.';


--
-- Name: COLUMN employee.maritalstatus; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.maritalstatus IS 'M = Married, S = Single';


--
-- Name: COLUMN employee.gender; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.gender IS 'M = Male, F = Female';


--
-- Name: COLUMN employee.hiredate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.hiredate IS 'Employee hired on this date.';


--
-- Name: COLUMN employee.salariedflag; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.salariedflag IS 'Job classification. 0 = Hourly, not exempt from collective bargaining. 1 = Salaried, exempt from collective bargaining.';


--
-- Name: COLUMN employee.vacationhours; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.vacationhours IS 'Number of available vacation hours.';


--
-- Name: COLUMN employee.sickleavehours; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.sickleavehours IS 'Number of available sick leave hours.';


--
-- Name: COLUMN employee.currentflag; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.currentflag IS '0 = Inactive, 1 = Active';


--
-- Name: COLUMN employee.organizationnode; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employee.organizationnode IS 'Where the employee is located in corporate hierarchy.';


--
-- Name: e; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.e AS
 SELECT employee.businessentityid AS id,
    employee.businessentityid,
    employee.nationalidnumber,
    employee.loginid,
    employee.jobtitle,
    employee.birthdate,
    employee.maritalstatus,
    employee.gender,
    employee.hiredate,
    employee.salariedflag,
    employee.vacationhours,
    employee.sickleavehours,
    employee.currentflag,
    employee.rowguid,
    employee.modifieddate,
    employee.organizationnode
   FROM humanresources.employee;


ALTER TABLE hr.e OWNER TO postgres;

--
-- Name: employeedepartmenthistory; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.employeedepartmenthistory (
    businessentityid integer NOT NULL,
    departmentid smallint NOT NULL,
    shiftid smallint NOT NULL,
    startdate date NOT NULL,
    enddate date,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_EmployeeDepartmentHistory_EndDate" CHECK (((enddate >= startdate) OR (enddate IS NULL)))
);


ALTER TABLE humanresources.employeedepartmenthistory OWNER TO postgres;

--
-- Name: TABLE employeedepartmenthistory; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.employeedepartmenthistory IS 'Employee department transfers.';


--
-- Name: COLUMN employeedepartmenthistory.businessentityid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeedepartmenthistory.businessentityid IS 'Employee identification number. Foreign key to Employee.BusinessEntityID.';


--
-- Name: COLUMN employeedepartmenthistory.departmentid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeedepartmenthistory.departmentid IS 'Department in which the employee worked including currently. Foreign key to Department.DepartmentID.';


--
-- Name: COLUMN employeedepartmenthistory.shiftid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeedepartmenthistory.shiftid IS 'Identifies which 8-hour shift the employee works. Foreign key to Shift.Shift.ID.';


--
-- Name: COLUMN employeedepartmenthistory.startdate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeedepartmenthistory.startdate IS 'Date the employee started work in the department.';


--
-- Name: COLUMN employeedepartmenthistory.enddate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeedepartmenthistory.enddate IS 'Date the employee left the department. NULL = Current department.';


--
-- Name: edh; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.edh AS
 SELECT employeedepartmenthistory.businessentityid AS id,
    employeedepartmenthistory.businessentityid,
    employeedepartmenthistory.departmentid,
    employeedepartmenthistory.shiftid,
    employeedepartmenthistory.startdate,
    employeedepartmenthistory.enddate,
    employeedepartmenthistory.modifieddate
   FROM humanresources.employeedepartmenthistory;


ALTER TABLE hr.edh OWNER TO postgres;

--
-- Name: employeepayhistory; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.employeepayhistory (
    businessentityid integer NOT NULL,
    ratechangedate timestamp without time zone NOT NULL,
    rate numeric NOT NULL,
    payfrequency smallint NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_EmployeePayHistory_PayFrequency" CHECK ((payfrequency = ANY (ARRAY[1, 2]))),
    CONSTRAINT "CK_EmployeePayHistory_Rate" CHECK (((rate >= 6.50) AND (rate <= 200.00)))
);


ALTER TABLE humanresources.employeepayhistory OWNER TO postgres;

--
-- Name: TABLE employeepayhistory; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.employeepayhistory IS 'Employee pay history.';


--
-- Name: COLUMN employeepayhistory.businessentityid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeepayhistory.businessentityid IS 'Employee identification number. Foreign key to Employee.BusinessEntityID.';


--
-- Name: COLUMN employeepayhistory.ratechangedate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeepayhistory.ratechangedate IS 'Date the change in pay is effective';


--
-- Name: COLUMN employeepayhistory.rate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeepayhistory.rate IS 'Salary hourly rate.';


--
-- Name: COLUMN employeepayhistory.payfrequency; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.employeepayhistory.payfrequency IS '1 = Salary received monthly, 2 = Salary received biweekly';


--
-- Name: eph; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.eph AS
 SELECT employeepayhistory.businessentityid AS id,
    employeepayhistory.businessentityid,
    employeepayhistory.ratechangedate,
    employeepayhistory.rate,
    employeepayhistory.payfrequency,
    employeepayhistory.modifieddate
   FROM humanresources.employeepayhistory;


ALTER TABLE hr.eph OWNER TO postgres;

--
-- Name: jobcandidate; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.jobcandidate (
    jobcandidateid integer NOT NULL,
    businessentityid integer,
    resume xml,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE humanresources.jobcandidate OWNER TO postgres;

--
-- Name: TABLE jobcandidate; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.jobcandidate IS 'RÃ©sumÃ©s submitted to Human Resources by job applicants.';


--
-- Name: COLUMN jobcandidate.jobcandidateid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.jobcandidate.jobcandidateid IS 'Primary key for JobCandidate records.';


--
-- Name: COLUMN jobcandidate.businessentityid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.jobcandidate.businessentityid IS 'Employee identification number if applicant was hired. Foreign key to Employee.BusinessEntityID.';


--
-- Name: COLUMN jobcandidate.resume; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.jobcandidate.resume IS 'RÃ©sumÃ© in XML format.';


--
-- Name: jc; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.jc AS
 SELECT jobcandidate.jobcandidateid AS id,
    jobcandidate.jobcandidateid,
    jobcandidate.businessentityid,
    jobcandidate.resume,
    jobcandidate.modifieddate
   FROM humanresources.jobcandidate;


ALTER TABLE hr.jc OWNER TO postgres;

--
-- Name: shift; Type: TABLE; Schema: humanresources; Owner: postgres
--

CREATE TABLE humanresources.shift (
    shiftid integer NOT NULL,
    name public."Name" NOT NULL,
    starttime time without time zone NOT NULL,
    endtime time without time zone NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE humanresources.shift OWNER TO postgres;

--
-- Name: TABLE shift; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON TABLE humanresources.shift IS 'Work shift lookup table.';


--
-- Name: COLUMN shift.shiftid; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.shift.shiftid IS 'Primary key for Shift records.';


--
-- Name: COLUMN shift.name; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.shift.name IS 'Shift description.';


--
-- Name: COLUMN shift.starttime; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.shift.starttime IS 'Shift start time.';


--
-- Name: COLUMN shift.endtime; Type: COMMENT; Schema: humanresources; Owner: postgres
--

COMMENT ON COLUMN humanresources.shift.endtime IS 'Shift end time.';


--
-- Name: s; Type: VIEW; Schema: hr; Owner: postgres
--

CREATE VIEW hr.s AS
 SELECT shift.shiftid AS id,
    shift.shiftid,
    shift.name,
    shift.starttime,
    shift.endtime,
    shift.modifieddate
   FROM humanresources.shift;


ALTER TABLE hr.s OWNER TO postgres;

--
-- Name: department_departmentid_seq; Type: SEQUENCE; Schema: humanresources; Owner: postgres
--

CREATE SEQUENCE humanresources.department_departmentid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE humanresources.department_departmentid_seq OWNER TO postgres;

--
-- Name: department_departmentid_seq; Type: SEQUENCE OWNED BY; Schema: humanresources; Owner: postgres
--

ALTER SEQUENCE humanresources.department_departmentid_seq OWNED BY humanresources.department.departmentid;


--
-- Name: jobcandidate_jobcandidateid_seq; Type: SEQUENCE; Schema: humanresources; Owner: postgres
--

CREATE SEQUENCE humanresources.jobcandidate_jobcandidateid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE humanresources.jobcandidate_jobcandidateid_seq OWNER TO postgres;

--
-- Name: jobcandidate_jobcandidateid_seq; Type: SEQUENCE OWNED BY; Schema: humanresources; Owner: postgres
--

ALTER SEQUENCE humanresources.jobcandidate_jobcandidateid_seq OWNED BY humanresources.jobcandidate.jobcandidateid;


--
-- Name: shift_shiftid_seq; Type: SEQUENCE; Schema: humanresources; Owner: postgres
--

CREATE SEQUENCE humanresources.shift_shiftid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE humanresources.shift_shiftid_seq OWNER TO postgres;

--
-- Name: shift_shiftid_seq; Type: SEQUENCE OWNED BY; Schema: humanresources; Owner: postgres
--

ALTER SEQUENCE humanresources.shift_shiftid_seq OWNED BY humanresources.shift.shiftid;


--
-- Name: address; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.address (
    addressid integer NOT NULL,
    addressline1 character varying(60) NOT NULL,
    addressline2 character varying(60),
    city character varying(30) NOT NULL,
    stateprovinceid integer NOT NULL,
    postalcode character varying(15) NOT NULL,
    spatiallocation character varying(44),
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.address OWNER TO postgres;

--
-- Name: TABLE address; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.address IS 'Street address information for customers, employees, and vendors.';


--
-- Name: COLUMN address.addressid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.addressid IS 'Primary key for Address records.';


--
-- Name: COLUMN address.addressline1; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.addressline1 IS 'First street address line.';


--
-- Name: COLUMN address.addressline2; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.addressline2 IS 'Second street address line.';


--
-- Name: COLUMN address.city; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.city IS 'Name of the city.';


--
-- Name: COLUMN address.stateprovinceid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.stateprovinceid IS 'Unique identification number for the state or province. Foreign key to StateProvince table.';


--
-- Name: COLUMN address.postalcode; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.postalcode IS 'Postal code for the street address.';


--
-- Name: COLUMN address.spatiallocation; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.address.spatiallocation IS 'Latitude and longitude of this address.';


--
-- Name: businessentityaddress; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.businessentityaddress (
    businessentityid integer NOT NULL,
    addressid integer NOT NULL,
    addresstypeid integer NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.businessentityaddress OWNER TO postgres;

--
-- Name: TABLE businessentityaddress; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.businessentityaddress IS 'Cross-reference table mapping customers, vendors, and employees to their addresses.';


--
-- Name: COLUMN businessentityaddress.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentityaddress.businessentityid IS 'Primary key. Foreign key to BusinessEntity.BusinessEntityID.';


--
-- Name: COLUMN businessentityaddress.addressid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentityaddress.addressid IS 'Primary key. Foreign key to Address.AddressID.';


--
-- Name: COLUMN businessentityaddress.addresstypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentityaddress.addresstypeid IS 'Primary key. Foreign key to AddressType.AddressTypeID.';


--
-- Name: countryregion; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.countryregion (
    countryregioncode character varying(3) NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.countryregion OWNER TO postgres;

--
-- Name: TABLE countryregion; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.countryregion IS 'Lookup table containing the ISO standard codes for countries and regions.';


--
-- Name: COLUMN countryregion.countryregioncode; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.countryregion.countryregioncode IS 'ISO standard code for countries and regions.';


--
-- Name: COLUMN countryregion.name; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.countryregion.name IS 'Country or region name.';


--
-- Name: emailaddress; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.emailaddress (
    businessentityid integer NOT NULL,
    emailaddressid integer NOT NULL,
    emailaddress character varying(50),
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.emailaddress OWNER TO postgres;

--
-- Name: TABLE emailaddress; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.emailaddress IS 'Where to send a person email.';


--
-- Name: COLUMN emailaddress.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.emailaddress.businessentityid IS 'Primary key. Person associated with this email address.  Foreign key to Person.BusinessEntityID';


--
-- Name: COLUMN emailaddress.emailaddressid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.emailaddress.emailaddressid IS 'Primary key. ID of this email address.';


--
-- Name: COLUMN emailaddress.emailaddress; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.emailaddress.emailaddress IS 'E-mail address for the person.';


--
-- Name: person; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.person (
    businessentityid integer NOT NULL,
    persontype character(2) NOT NULL,
    namestyle public."NameStyle" DEFAULT false NOT NULL,
    title character varying(8),
    firstname public."Name" NOT NULL,
    middlename public."Name",
    lastname public."Name" NOT NULL,
    suffix character varying(10),
    emailpromotion integer DEFAULT 0 NOT NULL,
    additionalcontactinfo xml,
    demographics xml,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_Person_EmailPromotion" CHECK (((emailpromotion >= 0) AND (emailpromotion <= 2))),
    CONSTRAINT "CK_Person_PersonType" CHECK (((persontype IS NULL) OR (upper((persontype)::text) = ANY (ARRAY['SC'::text, 'VC'::text, 'IN'::text, 'EM'::text, 'SP'::text, 'GC'::text]))))
);


ALTER TABLE person.person OWNER TO postgres;

--
-- Name: TABLE person; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.person IS 'Human beings involved with AdventureWorks: employees, customer contacts, and vendor contacts.';


--
-- Name: COLUMN person.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.businessentityid IS 'Primary key for Person records.';


--
-- Name: COLUMN person.persontype; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.persontype IS 'Primary type of person: SC = Store Contact, IN = Individual (retail) customer, SP = Sales person, EM = Employee (non-sales), VC = Vendor contact, GC = General contact';


--
-- Name: COLUMN person.namestyle; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.namestyle IS '0 = The data in FirstName and LastName are stored in western style (first name, last name) order.  1 = Eastern style (last name, first name) order.';


--
-- Name: COLUMN person.title; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.title IS 'A courtesy title. For example, Mr. or Ms.';


--
-- Name: COLUMN person.firstname; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.firstname IS 'First name of the person.';


--
-- Name: COLUMN person.middlename; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.middlename IS 'Middle name or middle initial of the person.';


--
-- Name: COLUMN person.lastname; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.lastname IS 'Last name of the person.';


--
-- Name: COLUMN person.suffix; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.suffix IS 'Surname suffix. For example, Sr. or Jr.';


--
-- Name: COLUMN person.emailpromotion; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.emailpromotion IS '0 = Contact does not wish to receive e-mail promotions, 1 = Contact does wish to receive e-mail promotions from AdventureWorks, 2 = Contact does wish to receive e-mail promotions from AdventureWorks and selected partners.';


--
-- Name: COLUMN person.additionalcontactinfo; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.additionalcontactinfo IS 'Additional contact information about the person stored in xml format.';


--
-- Name: COLUMN person.demographics; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.person.demographics IS 'Personal information such as hobbies, and income collected from online shoppers. Used for sales analysis.';


--
-- Name: personphone; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.personphone (
    businessentityid integer NOT NULL,
    phonenumber public."Phone" NOT NULL,
    phonenumbertypeid integer NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.personphone OWNER TO postgres;

--
-- Name: TABLE personphone; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.personphone IS 'Telephone number and type of a person.';


--
-- Name: COLUMN personphone.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.personphone.businessentityid IS 'Business entity identification number. Foreign key to Person.BusinessEntityID.';


--
-- Name: COLUMN personphone.phonenumber; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.personphone.phonenumber IS 'Telephone number identification number.';


--
-- Name: COLUMN personphone.phonenumbertypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.personphone.phonenumbertypeid IS 'Kind of phone number. Foreign key to PhoneNumberType.PhoneNumberTypeID.';


--
-- Name: phonenumbertype; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.phonenumbertype (
    phonenumbertypeid integer NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.phonenumbertype OWNER TO postgres;

--
-- Name: TABLE phonenumbertype; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.phonenumbertype IS 'Type of phone number of a person.';


--
-- Name: COLUMN phonenumbertype.phonenumbertypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.phonenumbertype.phonenumbertypeid IS 'Primary key for telephone number type records.';


--
-- Name: COLUMN phonenumbertype.name; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.phonenumbertype.name IS 'Name of the telephone number type';


--
-- Name: stateprovince; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.stateprovince (
    stateprovinceid integer NOT NULL,
    stateprovincecode character(3) NOT NULL,
    countryregioncode character varying(3) NOT NULL,
    isonlystateprovinceflag public."Flag" DEFAULT true NOT NULL,
    name public."Name" NOT NULL,
    territoryid integer NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.stateprovince OWNER TO postgres;

--
-- Name: TABLE stateprovince; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.stateprovince IS 'State and province lookup table.';


--
-- Name: COLUMN stateprovince.stateprovinceid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.stateprovinceid IS 'Primary key for StateProvince records.';


--
-- Name: COLUMN stateprovince.stateprovincecode; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.stateprovincecode IS 'ISO standard state or province code.';


--
-- Name: COLUMN stateprovince.countryregioncode; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.countryregioncode IS 'ISO standard country or region code. Foreign key to CountryRegion.CountryRegionCode.';


--
-- Name: COLUMN stateprovince.isonlystateprovinceflag; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.isonlystateprovinceflag IS '0 = StateProvinceCode exists. 1 = StateProvinceCode unavailable, using CountryRegionCode.';


--
-- Name: COLUMN stateprovince.name; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.name IS 'State or province description.';


--
-- Name: COLUMN stateprovince.territoryid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.stateprovince.territoryid IS 'ID of the territory in which the state or province is located. Foreign key to SalesTerritory.SalesTerritoryID.';


--
-- Name: vemployee; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vemployee AS
 SELECT e.businessentityid,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    e.jobtitle,
    pp.phonenumber,
    pnt.name AS phonenumbertype,
    ea.emailaddress,
    p.emailpromotion,
    a.addressline1,
    a.addressline2,
    a.city,
    sp.name AS stateprovincename,
    a.postalcode,
    cr.name AS countryregionname,
    p.additionalcontactinfo
   FROM ((((((((humanresources.employee e
     JOIN person.person p ON ((p.businessentityid = e.businessentityid)))
     JOIN person.businessentityaddress bea ON ((bea.businessentityid = e.businessentityid)))
     JOIN person.address a ON ((a.addressid = bea.addressid)))
     JOIN person.stateprovince sp ON ((sp.stateprovinceid = a.stateprovinceid)))
     JOIN person.countryregion cr ON (((cr.countryregioncode)::text = (sp.countryregioncode)::text)))
     LEFT JOIN person.personphone pp ON ((pp.businessentityid = p.businessentityid)))
     LEFT JOIN person.phonenumbertype pnt ON ((pp.phonenumbertypeid = pnt.phonenumbertypeid)))
     LEFT JOIN person.emailaddress ea ON ((p.businessentityid = ea.businessentityid)));


ALTER TABLE humanresources.vemployee OWNER TO postgres;

--
-- Name: vemployeedepartment; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vemployeedepartment AS
 SELECT e.businessentityid,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    e.jobtitle,
    d.name AS department,
    d.groupname,
    edh.startdate
   FROM (((humanresources.employee e
     JOIN person.person p ON ((p.businessentityid = e.businessentityid)))
     JOIN humanresources.employeedepartmenthistory edh ON ((e.businessentityid = edh.businessentityid)))
     JOIN humanresources.department d ON ((edh.departmentid = d.departmentid)))
  WHERE (edh.enddate IS NULL);


ALTER TABLE humanresources.vemployeedepartment OWNER TO postgres;

--
-- Name: vemployeedepartmenthistory; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vemployeedepartmenthistory AS
 SELECT e.businessentityid,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    s.name AS shift,
    d.name AS department,
    d.groupname,
    edh.startdate,
    edh.enddate
   FROM ((((humanresources.employee e
     JOIN person.person p ON ((p.businessentityid = e.businessentityid)))
     JOIN humanresources.employeedepartmenthistory edh ON ((e.businessentityid = edh.businessentityid)))
     JOIN humanresources.department d ON ((edh.departmentid = d.departmentid)))
     JOIN humanresources.shift s ON ((s.shiftid = edh.shiftid)));


ALTER TABLE humanresources.vemployeedepartmenthistory OWNER TO postgres;

--
-- Name: vjobcandidate; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vjobcandidate AS
 SELECT jobcandidate.jobcandidateid,
    jobcandidate.businessentityid,
    ((xpath('/n:Resume/n:Name/n:Name.Prefix/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Name.Prefix",
    ((xpath('/n:Resume/n:Name/n:Name.First/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Name.First",
    ((xpath('/n:Resume/n:Name/n:Name.Middle/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Name.Middle",
    ((xpath('/n:Resume/n:Name/n:Name.Last/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Name.Last",
    ((xpath('/n:Resume/n:Name/n:Name.Suffix/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Name.Suffix",
    ((xpath('/n:Resume/n:Skills/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying AS "Skills",
    ((xpath('n:Address/n:Addr.Type/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(30) AS "Addr.Type",
    ((xpath('n:Address/n:Addr.Location/n:Location/n:Loc.CountryRegion/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(100) AS "Addr.Loc.CountryRegion",
    ((xpath('n:Address/n:Addr.Location/n:Location/n:Loc.State/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(100) AS "Addr.Loc.State",
    ((xpath('n:Address/n:Addr.Location/n:Location/n:Loc.City/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(100) AS "Addr.Loc.City",
    ((xpath('n:Address/n:Addr.PostalCode/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying(20) AS "Addr.PostalCode",
    ((xpath('/n:Resume/n:EMail/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying AS "EMail",
    ((xpath('/n:Resume/n:WebSite/text()'::text, jobcandidate.resume, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[]))[1])::character varying AS "WebSite",
    jobcandidate.modifieddate
   FROM humanresources.jobcandidate;


ALTER TABLE humanresources.vjobcandidate OWNER TO postgres;

--
-- Name: vjobcandidateeducation; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vjobcandidateeducation AS
 SELECT jc.jobcandidateid,
    ((xpath('/root/ns:Education/ns:Edu.Level/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(50) AS "Edu.Level",
    (((xpath('/root/ns:Education/ns:Edu.StartDate/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(20))::date AS "Edu.StartDate",
    (((xpath('/root/ns:Education/ns:Edu.EndDate/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(20))::date AS "Edu.EndDate",
    ((xpath('/root/ns:Education/ns:Edu.Degree/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(50) AS "Edu.Degree",
    ((xpath('/root/ns:Education/ns:Edu.Major/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(50) AS "Edu.Major",
    ((xpath('/root/ns:Education/ns:Edu.Minor/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(50) AS "Edu.Minor",
    ((xpath('/root/ns:Education/ns:Edu.GPA/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(5) AS "Edu.GPA",
    ((xpath('/root/ns:Education/ns:Edu.GPAScale/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(5) AS "Edu.GPAScale",
    ((xpath('/root/ns:Education/ns:Edu.School/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(100) AS "Edu.School",
    ((xpath('/root/ns:Education/ns:Edu.Location/ns:Location/ns:Loc.CountryRegion/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(100) AS "Edu.Loc.CountryRegion",
    ((xpath('/root/ns:Education/ns:Edu.Location/ns:Location/ns:Loc.State/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(100) AS "Edu.Loc.State",
    ((xpath('/root/ns:Education/ns:Edu.Location/ns:Location/ns:Loc.City/text()'::text, jc.doc, '{{ns,http://adventureworks.com}}'::text[]))[1])::character varying(100) AS "Edu.Loc.City"
   FROM ( SELECT unnesting.jobcandidateid,
            ((('<root xmlns:ns="http://adventureworks.com">'::text || ((unnesting.education)::character varying)::text) || '</root>'::text))::xml AS doc
           FROM ( SELECT jobcandidate.jobcandidateid,
                    unnest(xpath('/ns:Resume/ns:Education'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])) AS education
                   FROM humanresources.jobcandidate) unnesting) jc;


ALTER TABLE humanresources.vjobcandidateeducation OWNER TO postgres;

--
-- Name: vjobcandidateemployment; Type: VIEW; Schema: humanresources; Owner: postgres
--

CREATE VIEW humanresources.vjobcandidateemployment AS
 SELECT jobcandidate.jobcandidateid,
    ((unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.StartDate/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying(20))::date AS "Emp.StartDate",
    ((unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.EndDate/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying(20))::date AS "Emp.EndDate",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.OrgName/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying(100) AS "Emp.OrgName",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.JobTitle/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying(100) AS "Emp.JobTitle",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.Responsibility/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.Responsibility",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.FunctionCategory/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.FunctionCategory",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.IndustryCategory/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.IndustryCategory",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.Location/ns:Location/ns:Loc.CountryRegion/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.Loc.CountryRegion",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.Location/ns:Location/ns:Loc.State/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.Loc.State",
    (unnest(xpath('/ns:Resume/ns:Employment/ns:Emp.Location/ns:Location/ns:Loc.City/text()'::text, jobcandidate.resume, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume}}'::text[])))::character varying AS "Emp.Loc.City"
   FROM humanresources.jobcandidate;


ALTER TABLE humanresources.vjobcandidateemployment OWNER TO postgres;

--
-- Name: a; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.a AS
 SELECT address.addressid AS id,
    address.addressid,
    address.addressline1,
    address.addressline2,
    address.city,
    address.stateprovinceid,
    address.postalcode,
    address.spatiallocation,
    address.rowguid,
    address.modifieddate
   FROM person.address;


ALTER TABLE pe.a OWNER TO postgres;

--
-- Name: addresstype; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.addresstype (
    addresstypeid integer NOT NULL,
    name public."Name" NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.addresstype OWNER TO postgres;

--
-- Name: TABLE addresstype; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.addresstype IS 'Types of addresses stored in the Address table.';


--
-- Name: COLUMN addresstype.addresstypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.addresstype.addresstypeid IS 'Primary key for AddressType records.';


--
-- Name: COLUMN addresstype.name; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.addresstype.name IS 'Address type description. For example, Billing, Home, or Shipping.';


--
-- Name: at; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.at AS
 SELECT addresstype.addresstypeid AS id,
    addresstype.addresstypeid,
    addresstype.name,
    addresstype.rowguid,
    addresstype.modifieddate
   FROM person.addresstype;


ALTER TABLE pe.at OWNER TO postgres;

--
-- Name: businessentity; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.businessentity (
    businessentityid integer NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.businessentity OWNER TO postgres;

--
-- Name: TABLE businessentity; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.businessentity IS 'Source of the ID that connects vendors, customers, and employees with address and contact information.';


--
-- Name: COLUMN businessentity.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentity.businessentityid IS 'Primary key for all customers, vendors, and employees.';


--
-- Name: be; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.be AS
 SELECT businessentity.businessentityid AS id,
    businessentity.businessentityid,
    businessentity.rowguid,
    businessentity.modifieddate
   FROM person.businessentity;


ALTER TABLE pe.be OWNER TO postgres;

--
-- Name: bea; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.bea AS
 SELECT businessentityaddress.businessentityid AS id,
    businessentityaddress.businessentityid,
    businessentityaddress.addressid,
    businessentityaddress.addresstypeid,
    businessentityaddress.rowguid,
    businessentityaddress.modifieddate
   FROM person.businessentityaddress;


ALTER TABLE pe.bea OWNER TO postgres;

--
-- Name: businessentitycontact; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.businessentitycontact (
    businessentityid integer NOT NULL,
    personid integer NOT NULL,
    contacttypeid integer NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.businessentitycontact OWNER TO postgres;

--
-- Name: TABLE businessentitycontact; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.businessentitycontact IS 'Cross-reference table mapping stores, vendors, and employees to people';


--
-- Name: COLUMN businessentitycontact.businessentityid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentitycontact.businessentityid IS 'Primary key. Foreign key to BusinessEntity.BusinessEntityID.';


--
-- Name: COLUMN businessentitycontact.personid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentitycontact.personid IS 'Primary key. Foreign key to Person.BusinessEntityID.';


--
-- Name: COLUMN businessentitycontact.contacttypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.businessentitycontact.contacttypeid IS 'Primary key.  Foreign key to ContactType.ContactTypeID.';


--
-- Name: bec; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.bec AS
 SELECT businessentitycontact.businessentityid AS id,
    businessentitycontact.businessentityid,
    businessentitycontact.personid,
    businessentitycontact.contacttypeid,
    businessentitycontact.rowguid,
    businessentitycontact.modifieddate
   FROM person.businessentitycontact;


ALTER TABLE pe.bec OWNER TO postgres;

--
-- Name: cr; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.cr AS
 SELECT countryregion.countryregioncode,
    countryregion.name,
    countryregion.modifieddate
   FROM person.countryregion;


ALTER TABLE pe.cr OWNER TO postgres;

--
-- Name: contacttype; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.contacttype (
    contacttypeid integer NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.contacttype OWNER TO postgres;

--
-- Name: TABLE contacttype; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.contacttype IS 'Lookup table containing the types of business entity contacts.';


--
-- Name: COLUMN contacttype.contacttypeid; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.contacttype.contacttypeid IS 'Primary key for ContactType records.';


--
-- Name: COLUMN contacttype.name; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.contacttype.name IS 'Contact type description.';


--
-- Name: ct; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.ct AS
 SELECT contacttype.contacttypeid AS id,
    contacttype.contacttypeid,
    contacttype.name,
    contacttype.modifieddate
   FROM person.contacttype;


ALTER TABLE pe.ct OWNER TO postgres;

--
-- Name: e; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.e AS
 SELECT emailaddress.emailaddressid AS id,
    emailaddress.businessentityid,
    emailaddress.emailaddressid,
    emailaddress.emailaddress,
    emailaddress.rowguid,
    emailaddress.modifieddate
   FROM person.emailaddress;


ALTER TABLE pe.e OWNER TO postgres;

--
-- Name: p; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.p AS
 SELECT person.businessentityid AS id,
    person.businessentityid,
    person.persontype,
    person.namestyle,
    person.title,
    person.firstname,
    person.middlename,
    person.lastname,
    person.suffix,
    person.emailpromotion,
    person.additionalcontactinfo,
    person.demographics,
    person.rowguid,
    person.modifieddate
   FROM person.person;


ALTER TABLE pe.p OWNER TO postgres;

--
-- Name: password; Type: TABLE; Schema: person; Owner: postgres
--

CREATE TABLE person.password (
    businessentityid integer NOT NULL,
    passwordhash character varying(128) NOT NULL,
    passwordsalt character varying(10) NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE person.password OWNER TO postgres;

--
-- Name: TABLE password; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON TABLE person.password IS 'One way hashed authentication information';


--
-- Name: COLUMN password.passwordhash; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.password.passwordhash IS 'Password for the e-mail account.';


--
-- Name: COLUMN password.passwordsalt; Type: COMMENT; Schema: person; Owner: postgres
--

COMMENT ON COLUMN person.password.passwordsalt IS 'Random value concatenated with the password string before the password is hashed.';


--
-- Name: pa; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.pa AS
 SELECT password.businessentityid AS id,
    password.businessentityid,
    password.passwordhash,
    password.passwordsalt,
    password.rowguid,
    password.modifieddate
   FROM person.password;


ALTER TABLE pe.pa OWNER TO postgres;

--
-- Name: pnt; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.pnt AS
 SELECT phonenumbertype.phonenumbertypeid AS id,
    phonenumbertype.phonenumbertypeid,
    phonenumbertype.name,
    phonenumbertype.modifieddate
   FROM person.phonenumbertype;


ALTER TABLE pe.pnt OWNER TO postgres;

--
-- Name: pp; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.pp AS
 SELECT personphone.businessentityid AS id,
    personphone.businessentityid,
    personphone.phonenumber,
    personphone.phonenumbertypeid,
    personphone.modifieddate
   FROM person.personphone;


ALTER TABLE pe.pp OWNER TO postgres;

--
-- Name: sp; Type: VIEW; Schema: pe; Owner: postgres
--

CREATE VIEW pe.sp AS
 SELECT stateprovince.stateprovinceid AS id,
    stateprovince.stateprovinceid,
    stateprovince.stateprovincecode,
    stateprovince.countryregioncode,
    stateprovince.isonlystateprovinceflag,
    stateprovince.name,
    stateprovince.territoryid,
    stateprovince.rowguid,
    stateprovince.modifieddate
   FROM person.stateprovince;


ALTER TABLE pe.sp OWNER TO postgres;

--
-- Name: address_addressid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.address_addressid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.address_addressid_seq OWNER TO postgres;

--
-- Name: address_addressid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.address_addressid_seq OWNED BY person.address.addressid;


--
-- Name: addresstype_addresstypeid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.addresstype_addresstypeid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.addresstype_addresstypeid_seq OWNER TO postgres;

--
-- Name: addresstype_addresstypeid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.addresstype_addresstypeid_seq OWNED BY person.addresstype.addresstypeid;


--
-- Name: businessentity_businessentityid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.businessentity_businessentityid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.businessentity_businessentityid_seq OWNER TO postgres;

--
-- Name: businessentity_businessentityid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.businessentity_businessentityid_seq OWNED BY person.businessentity.businessentityid;


--
-- Name: contacttype_contacttypeid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.contacttype_contacttypeid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.contacttype_contacttypeid_seq OWNER TO postgres;

--
-- Name: contacttype_contacttypeid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.contacttype_contacttypeid_seq OWNED BY person.contacttype.contacttypeid;


--
-- Name: emailaddress_emailaddressid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.emailaddress_emailaddressid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.emailaddress_emailaddressid_seq OWNER TO postgres;

--
-- Name: emailaddress_emailaddressid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.emailaddress_emailaddressid_seq OWNED BY person.emailaddress.emailaddressid;


--
-- Name: phonenumbertype_phonenumbertypeid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.phonenumbertype_phonenumbertypeid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.phonenumbertype_phonenumbertypeid_seq OWNER TO postgres;

--
-- Name: phonenumbertype_phonenumbertypeid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.phonenumbertype_phonenumbertypeid_seq OWNED BY person.phonenumbertype.phonenumbertypeid;


--
-- Name: stateprovince_stateprovinceid_seq; Type: SEQUENCE; Schema: person; Owner: postgres
--

CREATE SEQUENCE person.stateprovince_stateprovinceid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE person.stateprovince_stateprovinceid_seq OWNER TO postgres;

--
-- Name: stateprovince_stateprovinceid_seq; Type: SEQUENCE OWNED BY; Schema: person; Owner: postgres
--

ALTER SEQUENCE person.stateprovince_stateprovinceid_seq OWNED BY person.stateprovince.stateprovinceid;


--
-- Name: vadditionalcontactinfo; Type: VIEW; Schema: person; Owner: postgres
--

CREATE VIEW person.vadditionalcontactinfo AS
 SELECT p.businessentityid,
    p.firstname,
    p.middlename,
    p.lastname,
    (xpath('(act:telephoneNumber)[1]/act:number/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS telephonenumber,
    btrim((((xpath('(act:telephoneNumber)[1]/act:SpecialInstructions/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1])::character varying)::text) AS telephonespecialinstructions,
    (xpath('(act:homePostalAddress)[1]/act:Street/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS street,
    (xpath('(act:homePostalAddress)[1]/act:City/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS city,
    (xpath('(act:homePostalAddress)[1]/act:StateProvince/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS stateprovince,
    (xpath('(act:homePostalAddress)[1]/act:PostalCode/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS postalcode,
    (xpath('(act:homePostalAddress)[1]/act:CountryRegion/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS countryregion,
    (xpath('(act:homePostalAddress)[1]/act:SpecialInstructions/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS homeaddressspecialinstructions,
    (xpath('(act:eMail)[1]/act:eMailAddress/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS emailaddress,
    btrim((((xpath('(act:eMail)[1]/act:SpecialInstructions/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1])::character varying)::text) AS emailspecialinstructions,
    (xpath('((act:eMail)[1]/act:SpecialInstructions/act:telephoneNumber)[1]/act:number/text()'::text, additional.node, '{{act,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactTypes}}'::text[]))[1] AS emailtelephonenumber,
    p.rowguid,
    p.modifieddate
   FROM (person.person p
     LEFT JOIN ( SELECT person.businessentityid,
            unnest(xpath('/ci:AdditionalContactInfo'::text, person.additionalcontactinfo, '{{ci,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ContactInfo}}'::text[])) AS node
           FROM person.person
          WHERE (person.additionalcontactinfo IS NOT NULL)) additional ON ((p.businessentityid = additional.businessentityid)));


ALTER TABLE person.vadditionalcontactinfo OWNER TO postgres;

--
-- Name: vstateprovincecountryregion; Type: MATERIALIZED VIEW; Schema: person; Owner: postgres
--

CREATE MATERIALIZED VIEW person.vstateprovincecountryregion AS
 SELECT sp.stateprovinceid,
    sp.stateprovincecode,
    sp.isonlystateprovinceflag,
    sp.name AS stateprovincename,
    sp.territoryid,
    cr.countryregioncode,
    cr.name AS countryregionname
   FROM (person.stateprovince sp
     JOIN person.countryregion cr ON (((sp.countryregioncode)::text = (cr.countryregioncode)::text)))
  WITH NO DATA;


ALTER TABLE person.vstateprovincecountryregion OWNER TO postgres;

--
-- Name: billofmaterials; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.billofmaterials (
    billofmaterialsid integer NOT NULL,
    productassemblyid integer,
    componentid integer NOT NULL,
    startdate timestamp without time zone DEFAULT now() NOT NULL,
    enddate timestamp without time zone,
    unitmeasurecode character(3) NOT NULL,
    bomlevel smallint NOT NULL,
    perassemblyqty numeric(8,2) DEFAULT 1.00 NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_BillOfMaterials_BOMLevel" CHECK ((((productassemblyid IS NULL) AND (bomlevel = 0) AND (perassemblyqty = 1.00)) OR ((productassemblyid IS NOT NULL) AND (bomlevel >= 1)))),
    CONSTRAINT "CK_BillOfMaterials_EndDate" CHECK (((enddate > startdate) OR (enddate IS NULL))),
    CONSTRAINT "CK_BillOfMaterials_PerAssemblyQty" CHECK ((perassemblyqty >= 1.00)),
    CONSTRAINT "CK_BillOfMaterials_ProductAssemblyID" CHECK ((productassemblyid <> componentid))
);


ALTER TABLE production.billofmaterials OWNER TO postgres;

--
-- Name: TABLE billofmaterials; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.billofmaterials IS 'Items required to make bicycles and bicycle subassemblies. It identifies the heirarchical relationship between a parent product and its components.';


--
-- Name: COLUMN billofmaterials.billofmaterialsid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.billofmaterialsid IS 'Primary key for BillOfMaterials records.';


--
-- Name: COLUMN billofmaterials.productassemblyid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.productassemblyid IS 'Parent product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN billofmaterials.componentid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.componentid IS 'Component identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN billofmaterials.startdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.startdate IS 'Date the component started being used in the assembly item.';


--
-- Name: COLUMN billofmaterials.enddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.enddate IS 'Date the component stopped being used in the assembly item.';


--
-- Name: COLUMN billofmaterials.unitmeasurecode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.unitmeasurecode IS 'Standard code identifying the unit of measure for the quantity.';


--
-- Name: COLUMN billofmaterials.bomlevel; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.bomlevel IS 'Indicates the depth the component is from its parent (AssemblyID).';


--
-- Name: COLUMN billofmaterials.perassemblyqty; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.billofmaterials.perassemblyqty IS 'Quantity of the component needed to create the assembly.';


--
-- Name: bom; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.bom AS
 SELECT billofmaterials.billofmaterialsid AS id,
    billofmaterials.billofmaterialsid,
    billofmaterials.productassemblyid,
    billofmaterials.componentid,
    billofmaterials.startdate,
    billofmaterials.enddate,
    billofmaterials.unitmeasurecode,
    billofmaterials.bomlevel,
    billofmaterials.perassemblyqty,
    billofmaterials.modifieddate
   FROM production.billofmaterials;


ALTER TABLE pr.bom OWNER TO postgres;

--
-- Name: culture; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.culture (
    cultureid character(6) NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.culture OWNER TO postgres;

--
-- Name: TABLE culture; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.culture IS 'Lookup table containing the languages in which some AdventureWorks data is stored.';


--
-- Name: COLUMN culture.cultureid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.culture.cultureid IS 'Primary key for Culture records.';


--
-- Name: COLUMN culture.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.culture.name IS 'Culture description.';


--
-- Name: c; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.c AS
 SELECT culture.cultureid AS id,
    culture.cultureid,
    culture.name,
    culture.modifieddate
   FROM production.culture;


ALTER TABLE pr.c OWNER TO postgres;

--
-- Name: document; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.document (
    title character varying(50) NOT NULL,
    owner integer NOT NULL,
    folderflag public."Flag" DEFAULT false NOT NULL,
    filename character varying(400) NOT NULL,
    fileextension character varying(8),
    revision character(5) NOT NULL,
    changenumber integer DEFAULT 0 NOT NULL,
    status smallint NOT NULL,
    documentsummary text,
    document bytea,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    documentnode character varying DEFAULT '/'::character varying NOT NULL,
    CONSTRAINT "CK_Document_Status" CHECK (((status >= 1) AND (status <= 3)))
);


ALTER TABLE production.document OWNER TO postgres;

--
-- Name: TABLE document; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.document IS 'Product maintenance documents.';


--
-- Name: COLUMN document.title; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.title IS 'Title of the document.';


--
-- Name: COLUMN document.owner; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.owner IS 'Employee who controls the document.  Foreign key to Employee.BusinessEntityID';


--
-- Name: COLUMN document.folderflag; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.folderflag IS '0 = This is a folder, 1 = This is a document.';


--
-- Name: COLUMN document.filename; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.filename IS 'File name of the document';


--
-- Name: COLUMN document.fileextension; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.fileextension IS 'File extension indicating the document type. For example, .doc or .txt.';


--
-- Name: COLUMN document.revision; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.revision IS 'Revision number of the document.';


--
-- Name: COLUMN document.changenumber; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.changenumber IS 'Engineering change approval number.';


--
-- Name: COLUMN document.status; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.status IS '1 = Pending approval, 2 = Approved, 3 = Obsolete';


--
-- Name: COLUMN document.documentsummary; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.documentsummary IS 'Document abstract.';


--
-- Name: COLUMN document.document; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.document IS 'Complete document.';


--
-- Name: COLUMN document.rowguid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.rowguid IS 'ROWGUIDCOL number uniquely identifying the record. Required for FileStream.';


--
-- Name: COLUMN document.documentnode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.document.documentnode IS 'Primary key for Document records.';


--
-- Name: d; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.d AS
 SELECT document.title,
    document.owner,
    document.folderflag,
    document.filename,
    document.fileextension,
    document.revision,
    document.changenumber,
    document.status,
    document.documentsummary,
    document.document,
    document.rowguid,
    document.modifieddate,
    document.documentnode
   FROM production.document;


ALTER TABLE pr.d OWNER TO postgres;

--
-- Name: illustration; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.illustration (
    illustrationid integer NOT NULL,
    diagram xml,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.illustration OWNER TO postgres;

--
-- Name: TABLE illustration; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.illustration IS 'Bicycle assembly diagrams.';


--
-- Name: COLUMN illustration.illustrationid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.illustration.illustrationid IS 'Primary key for Illustration records.';


--
-- Name: COLUMN illustration.diagram; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.illustration.diagram IS 'Illustrations used in manufacturing instructions. Stored as XML.';


--
-- Name: i; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.i AS
 SELECT illustration.illustrationid AS id,
    illustration.illustrationid,
    illustration.diagram,
    illustration.modifieddate
   FROM production.illustration;


ALTER TABLE pr.i OWNER TO postgres;

--
-- Name: location; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.location (
    locationid integer NOT NULL,
    name public."Name" NOT NULL,
    costrate numeric DEFAULT 0.00 NOT NULL,
    availability numeric(8,2) DEFAULT 0.00 NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_Location_Availability" CHECK ((availability >= 0.00)),
    CONSTRAINT "CK_Location_CostRate" CHECK ((costrate >= 0.00))
);


ALTER TABLE production.location OWNER TO postgres;

--
-- Name: TABLE location; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.location IS 'Product inventory and manufacturing locations.';


--
-- Name: COLUMN location.locationid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.location.locationid IS 'Primary key for Location records.';


--
-- Name: COLUMN location.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.location.name IS 'Location description.';


--
-- Name: COLUMN location.costrate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.location.costrate IS 'Standard hourly cost of the manufacturing location.';


--
-- Name: COLUMN location.availability; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.location.availability IS 'Work capacity (in hours) of the manufacturing location.';


--
-- Name: l; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.l AS
 SELECT location.locationid AS id,
    location.locationid,
    location.name,
    location.costrate,
    location.availability,
    location.modifieddate
   FROM production.location;


ALTER TABLE pr.l OWNER TO postgres;

--
-- Name: product; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.product (
    productid integer NOT NULL,
    name public."Name" NOT NULL,
    productnumber character varying(25) NOT NULL,
    makeflag public."Flag" DEFAULT true NOT NULL,
    finishedgoodsflag public."Flag" DEFAULT true NOT NULL,
    color character varying(15),
    safetystocklevel smallint NOT NULL,
    reorderpoint smallint NOT NULL,
    standardcost numeric NOT NULL,
    listprice numeric NOT NULL,
    size character varying(5),
    sizeunitmeasurecode character(3),
    weightunitmeasurecode character(3),
    weight numeric(8,2),
    daystomanufacture integer NOT NULL,
    productline character(2),
    class character(2),
    style character(2),
    productsubcategoryid integer,
    productmodelid integer,
    sellstartdate timestamp without time zone NOT NULL,
    sellenddate timestamp without time zone,
    discontinueddate timestamp without time zone,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_Product_Class" CHECK (((upper((class)::text) = ANY (ARRAY['L'::text, 'M'::text, 'H'::text])) OR (class IS NULL))),
    CONSTRAINT "CK_Product_DaysToManufacture" CHECK ((daystomanufacture >= 0)),
    CONSTRAINT "CK_Product_ListPrice" CHECK ((listprice >= 0.00)),
    CONSTRAINT "CK_Product_ProductLine" CHECK (((upper((productline)::text) = ANY (ARRAY['S'::text, 'T'::text, 'M'::text, 'R'::text])) OR (productline IS NULL))),
    CONSTRAINT "CK_Product_ReorderPoint" CHECK ((reorderpoint > 0)),
    CONSTRAINT "CK_Product_SafetyStockLevel" CHECK ((safetystocklevel > 0)),
    CONSTRAINT "CK_Product_SellEndDate" CHECK (((sellenddate >= sellstartdate) OR (sellenddate IS NULL))),
    CONSTRAINT "CK_Product_StandardCost" CHECK ((standardcost >= 0.00)),
    CONSTRAINT "CK_Product_Style" CHECK (((upper((style)::text) = ANY (ARRAY['W'::text, 'M'::text, 'U'::text])) OR (style IS NULL))),
    CONSTRAINT "CK_Product_Weight" CHECK ((weight > 0.00))
);


ALTER TABLE production.product OWNER TO postgres;

--
-- Name: TABLE product; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.product IS 'Products sold or used in the manfacturing of sold products.';


--
-- Name: COLUMN product.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.productid IS 'Primary key for Product records.';


--
-- Name: COLUMN product.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.name IS 'Name of the product.';


--
-- Name: COLUMN product.productnumber; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.productnumber IS 'Unique product identification number.';


--
-- Name: COLUMN product.makeflag; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.makeflag IS '0 = Product is purchased, 1 = Product is manufactured in-house.';


--
-- Name: COLUMN product.finishedgoodsflag; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.finishedgoodsflag IS '0 = Product is not a salable item. 1 = Product is salable.';


--
-- Name: COLUMN product.color; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.color IS 'Product color.';


--
-- Name: COLUMN product.safetystocklevel; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.safetystocklevel IS 'Minimum inventory quantity.';


--
-- Name: COLUMN product.reorderpoint; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.reorderpoint IS 'Inventory level that triggers a purchase order or work order.';


--
-- Name: COLUMN product.standardcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.standardcost IS 'Standard cost of the product.';


--
-- Name: COLUMN product.listprice; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.listprice IS 'Selling price.';


--
-- Name: COLUMN product.size; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.size IS 'Product size.';


--
-- Name: COLUMN product.sizeunitmeasurecode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.sizeunitmeasurecode IS 'Unit of measure for Size column.';


--
-- Name: COLUMN product.weightunitmeasurecode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.weightunitmeasurecode IS 'Unit of measure for Weight column.';


--
-- Name: COLUMN product.weight; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.weight IS 'Product weight.';


--
-- Name: COLUMN product.daystomanufacture; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.daystomanufacture IS 'Number of days required to manufacture the product.';


--
-- Name: COLUMN product.productline; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.productline IS 'R = Road, M = Mountain, T = Touring, S = Standard';


--
-- Name: COLUMN product.class; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.class IS 'H = High, M = Medium, L = Low';


--
-- Name: COLUMN product.style; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.style IS 'W = Womens, M = Mens, U = Universal';


--
-- Name: COLUMN product.productsubcategoryid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.productsubcategoryid IS 'Product is a member of this product subcategory. Foreign key to ProductSubCategory.ProductSubCategoryID.';


--
-- Name: COLUMN product.productmodelid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.productmodelid IS 'Product is a member of this product model. Foreign key to ProductModel.ProductModelID.';


--
-- Name: COLUMN product.sellstartdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.sellstartdate IS 'Date the product was available for sale.';


--
-- Name: COLUMN product.sellenddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.sellenddate IS 'Date the product was no longer available for sale.';


--
-- Name: COLUMN product.discontinueddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.product.discontinueddate IS 'Date the product was discontinued.';


--
-- Name: p; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.p AS
 SELECT product.productid AS id,
    product.productid,
    product.name,
    product.productnumber,
    product.makeflag,
    product.finishedgoodsflag,
    product.color,
    product.safetystocklevel,
    product.reorderpoint,
    product.standardcost,
    product.listprice,
    product.size,
    product.sizeunitmeasurecode,
    product.weightunitmeasurecode,
    product.weight,
    product.daystomanufacture,
    product.productline,
    product.class,
    product.style,
    product.productsubcategoryid,
    product.productmodelid,
    product.sellstartdate,
    product.sellenddate,
    product.discontinueddate,
    product.rowguid,
    product.modifieddate
   FROM production.product;


ALTER TABLE pr.p OWNER TO postgres;

--
-- Name: productcategory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productcategory (
    productcategoryid integer NOT NULL,
    name public."Name" NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productcategory OWNER TO postgres;

--
-- Name: TABLE productcategory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productcategory IS 'High-level product categorization.';


--
-- Name: COLUMN productcategory.productcategoryid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcategory.productcategoryid IS 'Primary key for ProductCategory records.';


--
-- Name: COLUMN productcategory.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcategory.name IS 'Category description.';


--
-- Name: pc; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pc AS
 SELECT productcategory.productcategoryid AS id,
    productcategory.productcategoryid,
    productcategory.name,
    productcategory.rowguid,
    productcategory.modifieddate
   FROM production.productcategory;


ALTER TABLE pr.pc OWNER TO postgres;

--
-- Name: productcosthistory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productcosthistory (
    productid integer NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone,
    standardcost numeric NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ProductCostHistory_EndDate" CHECK (((enddate >= startdate) OR (enddate IS NULL))),
    CONSTRAINT "CK_ProductCostHistory_StandardCost" CHECK ((standardcost >= 0.00))
);


ALTER TABLE production.productcosthistory OWNER TO postgres;

--
-- Name: TABLE productcosthistory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productcosthistory IS 'Changes in the cost of a product over time.';


--
-- Name: COLUMN productcosthistory.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcosthistory.productid IS 'Product identification number. Foreign key to Product.ProductID';


--
-- Name: COLUMN productcosthistory.startdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcosthistory.startdate IS 'Product cost start date.';


--
-- Name: COLUMN productcosthistory.enddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcosthistory.enddate IS 'Product cost end date.';


--
-- Name: COLUMN productcosthistory.standardcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productcosthistory.standardcost IS 'Standard cost of the product.';


--
-- Name: pch; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pch AS
 SELECT productcosthistory.productid AS id,
    productcosthistory.productid,
    productcosthistory.startdate,
    productcosthistory.enddate,
    productcosthistory.standardcost,
    productcosthistory.modifieddate
   FROM production.productcosthistory;


ALTER TABLE pr.pch OWNER TO postgres;

--
-- Name: productdescription; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productdescription (
    productdescriptionid integer NOT NULL,
    description character varying(400) NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productdescription OWNER TO postgres;

--
-- Name: TABLE productdescription; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productdescription IS 'Product descriptions in several languages.';


--
-- Name: COLUMN productdescription.productdescriptionid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productdescription.productdescriptionid IS 'Primary key for ProductDescription records.';


--
-- Name: COLUMN productdescription.description; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productdescription.description IS 'Description of the product.';


--
-- Name: pd; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pd AS
 SELECT productdescription.productdescriptionid AS id,
    productdescription.productdescriptionid,
    productdescription.description,
    productdescription.rowguid,
    productdescription.modifieddate
   FROM production.productdescription;


ALTER TABLE pr.pd OWNER TO postgres;

--
-- Name: productdocument; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productdocument (
    productid integer NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    documentnode character varying DEFAULT '/'::character varying NOT NULL
);


ALTER TABLE production.productdocument OWNER TO postgres;

--
-- Name: TABLE productdocument; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productdocument IS 'Cross-reference table mapping products to related product documents.';


--
-- Name: COLUMN productdocument.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productdocument.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN productdocument.documentnode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productdocument.documentnode IS 'Document identification number. Foreign key to Document.DocumentNode.';


--
-- Name: pdoc; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pdoc AS
 SELECT productdocument.productid AS id,
    productdocument.productid,
    productdocument.modifieddate,
    productdocument.documentnode
   FROM production.productdocument;


ALTER TABLE pr.pdoc OWNER TO postgres;

--
-- Name: productinventory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productinventory (
    productid integer NOT NULL,
    locationid smallint NOT NULL,
    shelf character varying(10) NOT NULL,
    bin smallint NOT NULL,
    quantity smallint DEFAULT 0 NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ProductInventory_Bin" CHECK (((bin >= 0) AND (bin <= 100)))
);


ALTER TABLE production.productinventory OWNER TO postgres;

--
-- Name: TABLE productinventory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productinventory IS 'Product inventory information.';


--
-- Name: COLUMN productinventory.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productinventory.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN productinventory.locationid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productinventory.locationid IS 'Inventory location identification number. Foreign key to Location.LocationID.';


--
-- Name: COLUMN productinventory.shelf; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productinventory.shelf IS 'Storage compartment within an inventory location.';


--
-- Name: COLUMN productinventory.bin; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productinventory.bin IS 'Storage container on a shelf in an inventory location.';


--
-- Name: COLUMN productinventory.quantity; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productinventory.quantity IS 'Quantity of products in the inventory location.';


--
-- Name: pi; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pi AS
 SELECT productinventory.productid AS id,
    productinventory.productid,
    productinventory.locationid,
    productinventory.shelf,
    productinventory.bin,
    productinventory.quantity,
    productinventory.rowguid,
    productinventory.modifieddate
   FROM production.productinventory;


ALTER TABLE pr.pi OWNER TO postgres;

--
-- Name: productlistpricehistory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productlistpricehistory (
    productid integer NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone,
    listprice numeric NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ProductListPriceHistory_EndDate" CHECK (((enddate >= startdate) OR (enddate IS NULL))),
    CONSTRAINT "CK_ProductListPriceHistory_ListPrice" CHECK ((listprice > 0.00))
);


ALTER TABLE production.productlistpricehistory OWNER TO postgres;

--
-- Name: TABLE productlistpricehistory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productlistpricehistory IS 'Changes in the list price of a product over time.';


--
-- Name: COLUMN productlistpricehistory.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productlistpricehistory.productid IS 'Product identification number. Foreign key to Product.ProductID';


--
-- Name: COLUMN productlistpricehistory.startdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productlistpricehistory.startdate IS 'List price start date.';


--
-- Name: COLUMN productlistpricehistory.enddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productlistpricehistory.enddate IS 'List price end date';


--
-- Name: COLUMN productlistpricehistory.listprice; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productlistpricehistory.listprice IS 'Product list price.';


--
-- Name: plph; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.plph AS
 SELECT productlistpricehistory.productid AS id,
    productlistpricehistory.productid,
    productlistpricehistory.startdate,
    productlistpricehistory.enddate,
    productlistpricehistory.listprice,
    productlistpricehistory.modifieddate
   FROM production.productlistpricehistory;


ALTER TABLE pr.plph OWNER TO postgres;

--
-- Name: productmodel; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productmodel (
    productmodelid integer NOT NULL,
    name public."Name" NOT NULL,
    catalogdescription xml,
    instructions xml,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productmodel OWNER TO postgres;

--
-- Name: TABLE productmodel; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productmodel IS 'Product model classification.';


--
-- Name: COLUMN productmodel.productmodelid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodel.productmodelid IS 'Primary key for ProductModel records.';


--
-- Name: COLUMN productmodel.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodel.name IS 'Product model description.';


--
-- Name: COLUMN productmodel.catalogdescription; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodel.catalogdescription IS 'Detailed product catalog information in xml format.';


--
-- Name: COLUMN productmodel.instructions; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodel.instructions IS 'Manufacturing instructions in xml format.';


--
-- Name: pm; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pm AS
 SELECT productmodel.productmodelid AS id,
    productmodel.productmodelid,
    productmodel.name,
    productmodel.catalogdescription,
    productmodel.instructions,
    productmodel.rowguid,
    productmodel.modifieddate
   FROM production.productmodel;


ALTER TABLE pr.pm OWNER TO postgres;

--
-- Name: productmodelillustration; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productmodelillustration (
    productmodelid integer NOT NULL,
    illustrationid integer NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productmodelillustration OWNER TO postgres;

--
-- Name: TABLE productmodelillustration; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productmodelillustration IS 'Cross-reference table mapping product models and illustrations.';


--
-- Name: COLUMN productmodelillustration.productmodelid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodelillustration.productmodelid IS 'Primary key. Foreign key to ProductModel.ProductModelID.';


--
-- Name: COLUMN productmodelillustration.illustrationid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodelillustration.illustrationid IS 'Primary key. Foreign key to Illustration.IllustrationID.';


--
-- Name: pmi; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pmi AS
 SELECT productmodelillustration.productmodelid,
    productmodelillustration.illustrationid,
    productmodelillustration.modifieddate
   FROM production.productmodelillustration;


ALTER TABLE pr.pmi OWNER TO postgres;

--
-- Name: productmodelproductdescriptionculture; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productmodelproductdescriptionculture (
    productmodelid integer NOT NULL,
    productdescriptionid integer NOT NULL,
    cultureid character(6) NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productmodelproductdescriptionculture OWNER TO postgres;

--
-- Name: TABLE productmodelproductdescriptionculture; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productmodelproductdescriptionculture IS 'Cross-reference table mapping product descriptions and the language the description is written in.';


--
-- Name: COLUMN productmodelproductdescriptionculture.productmodelid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodelproductdescriptionculture.productmodelid IS 'Primary key. Foreign key to ProductModel.ProductModelID.';


--
-- Name: COLUMN productmodelproductdescriptionculture.productdescriptionid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodelproductdescriptionculture.productdescriptionid IS 'Primary key. Foreign key to ProductDescription.ProductDescriptionID.';


--
-- Name: COLUMN productmodelproductdescriptionculture.cultureid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productmodelproductdescriptionculture.cultureid IS 'Culture identification number. Foreign key to Culture.CultureID.';


--
-- Name: pmpdc; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pmpdc AS
 SELECT productmodelproductdescriptionculture.productmodelid,
    productmodelproductdescriptionculture.productdescriptionid,
    productmodelproductdescriptionculture.cultureid,
    productmodelproductdescriptionculture.modifieddate
   FROM production.productmodelproductdescriptionculture;


ALTER TABLE pr.pmpdc OWNER TO postgres;

--
-- Name: productphoto; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productphoto (
    productphotoid integer NOT NULL,
    thumbnailphoto bytea,
    thumbnailphotofilename character varying(50),
    largephoto bytea,
    largephotofilename character varying(50),
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productphoto OWNER TO postgres;

--
-- Name: TABLE productphoto; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productphoto IS 'Product images.';


--
-- Name: COLUMN productphoto.productphotoid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productphoto.productphotoid IS 'Primary key for ProductPhoto records.';


--
-- Name: COLUMN productphoto.thumbnailphoto; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productphoto.thumbnailphoto IS 'Small image of the product.';


--
-- Name: COLUMN productphoto.thumbnailphotofilename; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productphoto.thumbnailphotofilename IS 'Small image file name.';


--
-- Name: COLUMN productphoto.largephoto; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productphoto.largephoto IS 'Large image of the product.';


--
-- Name: COLUMN productphoto.largephotofilename; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productphoto.largephotofilename IS 'Large image file name.';


--
-- Name: pp; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pp AS
 SELECT productphoto.productphotoid AS id,
    productphoto.productphotoid,
    productphoto.thumbnailphoto,
    productphoto.thumbnailphotofilename,
    productphoto.largephoto,
    productphoto.largephotofilename,
    productphoto.modifieddate
   FROM production.productphoto;


ALTER TABLE pr.pp OWNER TO postgres;

--
-- Name: productproductphoto; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productproductphoto (
    productid integer NOT NULL,
    productphotoid integer NOT NULL,
    "primary" public."Flag" DEFAULT false NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productproductphoto OWNER TO postgres;

--
-- Name: TABLE productproductphoto; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productproductphoto IS 'Cross-reference table mapping products and product photos.';


--
-- Name: COLUMN productproductphoto.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productproductphoto.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN productproductphoto.productphotoid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productproductphoto.productphotoid IS 'Product photo identification number. Foreign key to ProductPhoto.ProductPhotoID.';


--
-- Name: COLUMN productproductphoto."primary"; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productproductphoto."primary" IS '0 = Photo is not the principal image. 1 = Photo is the principal image.';


--
-- Name: ppp; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.ppp AS
 SELECT productproductphoto.productid,
    productproductphoto.productphotoid,
    productproductphoto."primary",
    productproductphoto.modifieddate
   FROM production.productproductphoto;


ALTER TABLE pr.ppp OWNER TO postgres;

--
-- Name: productreview; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productreview (
    productreviewid integer NOT NULL,
    productid integer NOT NULL,
    reviewername public."Name" NOT NULL,
    reviewdate timestamp without time zone DEFAULT now() NOT NULL,
    emailaddress character varying(50) NOT NULL,
    rating integer NOT NULL,
    comments character varying(3850),
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ProductReview_Rating" CHECK (((rating >= 1) AND (rating <= 5)))
);


ALTER TABLE production.productreview OWNER TO postgres;

--
-- Name: TABLE productreview; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productreview IS 'Customer reviews of products they have purchased.';


--
-- Name: COLUMN productreview.productreviewid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.productreviewid IS 'Primary key for ProductReview records.';


--
-- Name: COLUMN productreview.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN productreview.reviewername; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.reviewername IS 'Name of the reviewer.';


--
-- Name: COLUMN productreview.reviewdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.reviewdate IS 'Date review was submitted.';


--
-- Name: COLUMN productreview.emailaddress; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.emailaddress IS 'Reviewer''s e-mail address.';


--
-- Name: COLUMN productreview.rating; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.rating IS 'Product rating given by the reviewer. Scale is 1 to 5 with 5 as the highest rating.';


--
-- Name: COLUMN productreview.comments; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productreview.comments IS 'Reviewer''s comments';


--
-- Name: pr; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.pr AS
 SELECT productreview.productreviewid AS id,
    productreview.productreviewid,
    productreview.productid,
    productreview.reviewername,
    productreview.reviewdate,
    productreview.emailaddress,
    productreview.rating,
    productreview.comments,
    productreview.modifieddate
   FROM production.productreview;


ALTER TABLE pr.pr OWNER TO postgres;

--
-- Name: productsubcategory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.productsubcategory (
    productsubcategoryid integer NOT NULL,
    productcategoryid integer NOT NULL,
    name public."Name" NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.productsubcategory OWNER TO postgres;

--
-- Name: TABLE productsubcategory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.productsubcategory IS 'Product subcategories. See ProductCategory table.';


--
-- Name: COLUMN productsubcategory.productsubcategoryid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productsubcategory.productsubcategoryid IS 'Primary key for ProductSubcategory records.';


--
-- Name: COLUMN productsubcategory.productcategoryid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productsubcategory.productcategoryid IS 'Product category identification number. Foreign key to ProductCategory.ProductCategoryID.';


--
-- Name: COLUMN productsubcategory.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.productsubcategory.name IS 'Subcategory description.';


--
-- Name: psc; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.psc AS
 SELECT productsubcategory.productsubcategoryid AS id,
    productsubcategory.productsubcategoryid,
    productsubcategory.productcategoryid,
    productsubcategory.name,
    productsubcategory.rowguid,
    productsubcategory.modifieddate
   FROM production.productsubcategory;


ALTER TABLE pr.psc OWNER TO postgres;

--
-- Name: scrapreason; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.scrapreason (
    scrapreasonid integer NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.scrapreason OWNER TO postgres;

--
-- Name: TABLE scrapreason; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.scrapreason IS 'Manufacturing failure reasons lookup table.';


--
-- Name: COLUMN scrapreason.scrapreasonid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.scrapreason.scrapreasonid IS 'Primary key for ScrapReason records.';


--
-- Name: COLUMN scrapreason.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.scrapreason.name IS 'Failure description.';


--
-- Name: sr; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.sr AS
 SELECT scrapreason.scrapreasonid AS id,
    scrapreason.scrapreasonid,
    scrapreason.name,
    scrapreason.modifieddate
   FROM production.scrapreason;


ALTER TABLE pr.sr OWNER TO postgres;

--
-- Name: transactionhistory; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.transactionhistory (
    transactionid integer NOT NULL,
    productid integer NOT NULL,
    referenceorderid integer NOT NULL,
    referenceorderlineid integer DEFAULT 0 NOT NULL,
    transactiondate timestamp without time zone DEFAULT now() NOT NULL,
    transactiontype character(1) NOT NULL,
    quantity integer NOT NULL,
    actualcost numeric NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_TransactionHistory_TransactionType" CHECK ((upper((transactiontype)::text) = ANY (ARRAY['W'::text, 'S'::text, 'P'::text])))
);


ALTER TABLE production.transactionhistory OWNER TO postgres;

--
-- Name: TABLE transactionhistory; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.transactionhistory IS 'Record of each purchase order, sales order, or work order transaction year to date.';


--
-- Name: COLUMN transactionhistory.transactionid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.transactionid IS 'Primary key for TransactionHistory records.';


--
-- Name: COLUMN transactionhistory.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN transactionhistory.referenceorderid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.referenceorderid IS 'Purchase order, sales order, or work order identification number.';


--
-- Name: COLUMN transactionhistory.referenceorderlineid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.referenceorderlineid IS 'Line number associated with the purchase order, sales order, or work order.';


--
-- Name: COLUMN transactionhistory.transactiondate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.transactiondate IS 'Date and time of the transaction.';


--
-- Name: COLUMN transactionhistory.transactiontype; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.transactiontype IS 'W = WorkOrder, S = SalesOrder, P = PurchaseOrder';


--
-- Name: COLUMN transactionhistory.quantity; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.quantity IS 'Product quantity.';


--
-- Name: COLUMN transactionhistory.actualcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistory.actualcost IS 'Product cost.';


--
-- Name: th; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.th AS
 SELECT transactionhistory.transactionid AS id,
    transactionhistory.transactionid,
    transactionhistory.productid,
    transactionhistory.referenceorderid,
    transactionhistory.referenceorderlineid,
    transactionhistory.transactiondate,
    transactionhistory.transactiontype,
    transactionhistory.quantity,
    transactionhistory.actualcost,
    transactionhistory.modifieddate
   FROM production.transactionhistory;


ALTER TABLE pr.th OWNER TO postgres;

--
-- Name: transactionhistoryarchive; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.transactionhistoryarchive (
    transactionid integer NOT NULL,
    productid integer NOT NULL,
    referenceorderid integer NOT NULL,
    referenceorderlineid integer DEFAULT 0 NOT NULL,
    transactiondate timestamp without time zone DEFAULT now() NOT NULL,
    transactiontype character(1) NOT NULL,
    quantity integer NOT NULL,
    actualcost numeric NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_TransactionHistoryArchive_TransactionType" CHECK ((upper((transactiontype)::text) = ANY (ARRAY['W'::text, 'S'::text, 'P'::text])))
);


ALTER TABLE production.transactionhistoryarchive OWNER TO postgres;

--
-- Name: TABLE transactionhistoryarchive; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.transactionhistoryarchive IS 'Transactions for previous years.';


--
-- Name: COLUMN transactionhistoryarchive.transactionid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.transactionid IS 'Primary key for TransactionHistoryArchive records.';


--
-- Name: COLUMN transactionhistoryarchive.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN transactionhistoryarchive.referenceorderid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.referenceorderid IS 'Purchase order, sales order, or work order identification number.';


--
-- Name: COLUMN transactionhistoryarchive.referenceorderlineid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.referenceorderlineid IS 'Line number associated with the purchase order, sales order, or work order.';


--
-- Name: COLUMN transactionhistoryarchive.transactiondate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.transactiondate IS 'Date and time of the transaction.';


--
-- Name: COLUMN transactionhistoryarchive.transactiontype; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.transactiontype IS 'W = Work Order, S = Sales Order, P = Purchase Order';


--
-- Name: COLUMN transactionhistoryarchive.quantity; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.quantity IS 'Product quantity.';


--
-- Name: COLUMN transactionhistoryarchive.actualcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.transactionhistoryarchive.actualcost IS 'Product cost.';


--
-- Name: tha; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.tha AS
 SELECT transactionhistoryarchive.transactionid AS id,
    transactionhistoryarchive.transactionid,
    transactionhistoryarchive.productid,
    transactionhistoryarchive.referenceorderid,
    transactionhistoryarchive.referenceorderlineid,
    transactionhistoryarchive.transactiondate,
    transactionhistoryarchive.transactiontype,
    transactionhistoryarchive.quantity,
    transactionhistoryarchive.actualcost,
    transactionhistoryarchive.modifieddate
   FROM production.transactionhistoryarchive;


ALTER TABLE pr.tha OWNER TO postgres;

--
-- Name: unitmeasure; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.unitmeasure (
    unitmeasurecode character(3) NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE production.unitmeasure OWNER TO postgres;

--
-- Name: TABLE unitmeasure; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.unitmeasure IS 'Unit of measure lookup table.';


--
-- Name: COLUMN unitmeasure.unitmeasurecode; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.unitmeasure.unitmeasurecode IS 'Primary key.';


--
-- Name: COLUMN unitmeasure.name; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.unitmeasure.name IS 'Unit of measure description.';


--
-- Name: um; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.um AS
 SELECT unitmeasure.unitmeasurecode AS id,
    unitmeasure.unitmeasurecode,
    unitmeasure.name,
    unitmeasure.modifieddate
   FROM production.unitmeasure;


ALTER TABLE pr.um OWNER TO postgres;

--
-- Name: workorder; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.workorder (
    workorderid integer NOT NULL,
    productid integer NOT NULL,
    orderqty integer NOT NULL,
    scrappedqty smallint NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone,
    duedate timestamp without time zone NOT NULL,
    scrapreasonid smallint,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_WorkOrder_EndDate" CHECK (((enddate >= startdate) OR (enddate IS NULL))),
    CONSTRAINT "CK_WorkOrder_OrderQty" CHECK ((orderqty > 0)),
    CONSTRAINT "CK_WorkOrder_ScrappedQty" CHECK ((scrappedqty >= 0))
);


ALTER TABLE production.workorder OWNER TO postgres;

--
-- Name: TABLE workorder; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.workorder IS 'Manufacturing work orders.';


--
-- Name: COLUMN workorder.workorderid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.workorderid IS 'Primary key for WorkOrder records.';


--
-- Name: COLUMN workorder.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN workorder.orderqty; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.orderqty IS 'Product quantity to build.';


--
-- Name: COLUMN workorder.scrappedqty; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.scrappedqty IS 'Quantity that failed inspection.';


--
-- Name: COLUMN workorder.startdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.startdate IS 'Work order start date.';


--
-- Name: COLUMN workorder.enddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.enddate IS 'Work order end date.';


--
-- Name: COLUMN workorder.duedate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.duedate IS 'Work order due date.';


--
-- Name: COLUMN workorder.scrapreasonid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorder.scrapreasonid IS 'Reason for inspection failure.';


--
-- Name: w; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.w AS
 SELECT workorder.workorderid AS id,
    workorder.workorderid,
    workorder.productid,
    workorder.orderqty,
    workorder.scrappedqty,
    workorder.startdate,
    workorder.enddate,
    workorder.duedate,
    workorder.scrapreasonid,
    workorder.modifieddate
   FROM production.workorder;


ALTER TABLE pr.w OWNER TO postgres;

--
-- Name: workorderrouting; Type: TABLE; Schema: production; Owner: postgres
--

CREATE TABLE production.workorderrouting (
    workorderid integer NOT NULL,
    productid integer NOT NULL,
    operationsequence smallint NOT NULL,
    locationid smallint NOT NULL,
    scheduledstartdate timestamp without time zone NOT NULL,
    scheduledenddate timestamp without time zone NOT NULL,
    actualstartdate timestamp without time zone,
    actualenddate timestamp without time zone,
    actualresourcehrs numeric(9,4),
    plannedcost numeric NOT NULL,
    actualcost numeric,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_WorkOrderRouting_ActualCost" CHECK ((actualcost > 0.00)),
    CONSTRAINT "CK_WorkOrderRouting_ActualEndDate" CHECK (((actualenddate >= actualstartdate) OR (actualenddate IS NULL) OR (actualstartdate IS NULL))),
    CONSTRAINT "CK_WorkOrderRouting_ActualResourceHrs" CHECK ((actualresourcehrs >= 0.0000)),
    CONSTRAINT "CK_WorkOrderRouting_PlannedCost" CHECK ((plannedcost > 0.00)),
    CONSTRAINT "CK_WorkOrderRouting_ScheduledEndDate" CHECK ((scheduledenddate >= scheduledstartdate))
);


ALTER TABLE production.workorderrouting OWNER TO postgres;

--
-- Name: TABLE workorderrouting; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON TABLE production.workorderrouting IS 'Work order details.';


--
-- Name: COLUMN workorderrouting.workorderid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.workorderid IS 'Primary key. Foreign key to WorkOrder.WorkOrderID.';


--
-- Name: COLUMN workorderrouting.productid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.productid IS 'Primary key. Foreign key to Product.ProductID.';


--
-- Name: COLUMN workorderrouting.operationsequence; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.operationsequence IS 'Primary key. Indicates the manufacturing process sequence.';


--
-- Name: COLUMN workorderrouting.locationid; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.locationid IS 'Manufacturing location where the part is processed. Foreign key to Location.LocationID.';


--
-- Name: COLUMN workorderrouting.scheduledstartdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.scheduledstartdate IS 'Planned manufacturing start date.';


--
-- Name: COLUMN workorderrouting.scheduledenddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.scheduledenddate IS 'Planned manufacturing end date.';


--
-- Name: COLUMN workorderrouting.actualstartdate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.actualstartdate IS 'Actual start date.';


--
-- Name: COLUMN workorderrouting.actualenddate; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.actualenddate IS 'Actual end date.';


--
-- Name: COLUMN workorderrouting.actualresourcehrs; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.actualresourcehrs IS 'Number of manufacturing hours used.';


--
-- Name: COLUMN workorderrouting.plannedcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.plannedcost IS 'Estimated manufacturing cost.';


--
-- Name: COLUMN workorderrouting.actualcost; Type: COMMENT; Schema: production; Owner: postgres
--

COMMENT ON COLUMN production.workorderrouting.actualcost IS 'Actual manufacturing cost.';


--
-- Name: wr; Type: VIEW; Schema: pr; Owner: postgres
--

CREATE VIEW pr.wr AS
 SELECT workorderrouting.workorderid AS id,
    workorderrouting.workorderid,
    workorderrouting.productid,
    workorderrouting.operationsequence,
    workorderrouting.locationid,
    workorderrouting.scheduledstartdate,
    workorderrouting.scheduledenddate,
    workorderrouting.actualstartdate,
    workorderrouting.actualenddate,
    workorderrouting.actualresourcehrs,
    workorderrouting.plannedcost,
    workorderrouting.actualcost,
    workorderrouting.modifieddate
   FROM production.workorderrouting;


ALTER TABLE pr.wr OWNER TO postgres;

--
-- Name: billofmaterials_billofmaterialsid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.billofmaterials_billofmaterialsid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.billofmaterials_billofmaterialsid_seq OWNER TO postgres;

--
-- Name: billofmaterials_billofmaterialsid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.billofmaterials_billofmaterialsid_seq OWNED BY production.billofmaterials.billofmaterialsid;


--
-- Name: illustration_illustrationid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.illustration_illustrationid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.illustration_illustrationid_seq OWNER TO postgres;

--
-- Name: illustration_illustrationid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.illustration_illustrationid_seq OWNED BY production.illustration.illustrationid;


--
-- Name: location_locationid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.location_locationid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.location_locationid_seq OWNER TO postgres;

--
-- Name: location_locationid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.location_locationid_seq OWNED BY production.location.locationid;


--
-- Name: product_productid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.product_productid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.product_productid_seq OWNER TO postgres;

--
-- Name: product_productid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.product_productid_seq OWNED BY production.product.productid;


--
-- Name: productcategory_productcategoryid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productcategory_productcategoryid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productcategory_productcategoryid_seq OWNER TO postgres;

--
-- Name: productcategory_productcategoryid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productcategory_productcategoryid_seq OWNED BY production.productcategory.productcategoryid;


--
-- Name: productdescription_productdescriptionid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productdescription_productdescriptionid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productdescription_productdescriptionid_seq OWNER TO postgres;

--
-- Name: productdescription_productdescriptionid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productdescription_productdescriptionid_seq OWNED BY production.productdescription.productdescriptionid;


--
-- Name: productmodel_productmodelid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productmodel_productmodelid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productmodel_productmodelid_seq OWNER TO postgres;

--
-- Name: productmodel_productmodelid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productmodel_productmodelid_seq OWNED BY production.productmodel.productmodelid;


--
-- Name: productphoto_productphotoid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productphoto_productphotoid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productphoto_productphotoid_seq OWNER TO postgres;

--
-- Name: productphoto_productphotoid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productphoto_productphotoid_seq OWNED BY production.productphoto.productphotoid;


--
-- Name: productreview_productreviewid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productreview_productreviewid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productreview_productreviewid_seq OWNER TO postgres;

--
-- Name: productreview_productreviewid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productreview_productreviewid_seq OWNED BY production.productreview.productreviewid;


--
-- Name: productsubcategory_productsubcategoryid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.productsubcategory_productsubcategoryid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.productsubcategory_productsubcategoryid_seq OWNER TO postgres;

--
-- Name: productsubcategory_productsubcategoryid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.productsubcategory_productsubcategoryid_seq OWNED BY production.productsubcategory.productsubcategoryid;


--
-- Name: scrapreason_scrapreasonid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.scrapreason_scrapreasonid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.scrapreason_scrapreasonid_seq OWNER TO postgres;

--
-- Name: scrapreason_scrapreasonid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.scrapreason_scrapreasonid_seq OWNED BY production.scrapreason.scrapreasonid;


--
-- Name: transactionhistory_transactionid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.transactionhistory_transactionid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.transactionhistory_transactionid_seq OWNER TO postgres;

--
-- Name: transactionhistory_transactionid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.transactionhistory_transactionid_seq OWNED BY production.transactionhistory.transactionid;


--
-- Name: vproductanddescription; Type: MATERIALIZED VIEW; Schema: production; Owner: postgres
--

CREATE MATERIALIZED VIEW production.vproductanddescription AS
 SELECT p.productid,
    p.name,
    pm.name AS productmodel,
    pmx.cultureid,
    pd.description
   FROM (((production.product p
     JOIN production.productmodel pm ON ((p.productmodelid = pm.productmodelid)))
     JOIN production.productmodelproductdescriptionculture pmx ON ((pm.productmodelid = pmx.productmodelid)))
     JOIN production.productdescription pd ON ((pmx.productdescriptionid = pd.productdescriptionid)))
  WITH NO DATA;


ALTER TABLE production.vproductanddescription OWNER TO postgres;

--
-- Name: vproductmodelcatalogdescription; Type: VIEW; Schema: production; Owner: postgres
--

CREATE VIEW production.vproductmodelcatalogdescription AS
 SELECT productmodel.productmodelid,
    productmodel.name,
    ((xpath('/p1:ProductDescription/p1:Summary/html:p/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{html,http://www.w3.org/1999/xhtml}}'::text[]))[1])::character varying AS "Summary",
    ((xpath('/p1:ProductDescription/p1:Manufacturer/p1:Name/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying AS manufacturer,
    ((xpath('/p1:ProductDescription/p1:Manufacturer/p1:Copyright/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(30) AS copyright,
    ((xpath('/p1:ProductDescription/p1:Manufacturer/p1:ProductURL/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS producturl,
    ((xpath('/p1:ProductDescription/p1:Features/wm:Warranty/wm:WarrantyPeriod/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wm,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelWarrAndMain}}'::text[]))[1])::character varying(256) AS warrantyperiod,
    ((xpath('/p1:ProductDescription/p1:Features/wm:Warranty/wm:Description/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wm,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelWarrAndMain}}'::text[]))[1])::character varying(256) AS warrantydescription,
    ((xpath('/p1:ProductDescription/p1:Features/wm:Maintenance/wm:NoOfYears/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wm,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelWarrAndMain}}'::text[]))[1])::character varying(256) AS noofyears,
    ((xpath('/p1:ProductDescription/p1:Features/wm:Maintenance/wm:Description/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wm,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelWarrAndMain}}'::text[]))[1])::character varying(256) AS maintenancedescription,
    ((xpath('/p1:ProductDescription/p1:Features/wf:wheel/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wf,http://www.adventure-works.com/schemas/OtherFeatures}}'::text[]))[1])::character varying(256) AS wheel,
    ((xpath('/p1:ProductDescription/p1:Features/wf:saddle/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wf,http://www.adventure-works.com/schemas/OtherFeatures}}'::text[]))[1])::character varying(256) AS saddle,
    ((xpath('/p1:ProductDescription/p1:Features/wf:pedal/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wf,http://www.adventure-works.com/schemas/OtherFeatures}}'::text[]))[1])::character varying(256) AS pedal,
    ((xpath('/p1:ProductDescription/p1:Features/wf:BikeFrame/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wf,http://www.adventure-works.com/schemas/OtherFeatures}}'::text[]))[1])::character varying AS bikeframe,
    ((xpath('/p1:ProductDescription/p1:Features/wf:crankset/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription},{wf,http://www.adventure-works.com/schemas/OtherFeatures}}'::text[]))[1])::character varying(256) AS crankset,
    ((xpath('/p1:ProductDescription/p1:Picture/p1:Angle/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS pictureangle,
    ((xpath('/p1:ProductDescription/p1:Picture/p1:Size/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS picturesize,
    ((xpath('/p1:ProductDescription/p1:Picture/p1:ProductPhotoID/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS productphotoid,
    ((xpath('/p1:ProductDescription/p1:Specifications/Material/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS material,
    ((xpath('/p1:ProductDescription/p1:Specifications/Color/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS color,
    ((xpath('/p1:ProductDescription/p1:Specifications/ProductLine/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS productline,
    ((xpath('/p1:ProductDescription/p1:Specifications/Style/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(256) AS style,
    ((xpath('/p1:ProductDescription/p1:Specifications/RiderExperience/text()'::text, productmodel.catalogdescription, '{{p1,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelDescription}}'::text[]))[1])::character varying(1024) AS riderexperience,
    productmodel.rowguid,
    productmodel.modifieddate
   FROM production.productmodel
  WHERE (productmodel.catalogdescription IS NOT NULL);


ALTER TABLE production.vproductmodelcatalogdescription OWNER TO postgres;

--
-- Name: vproductmodelinstructions; Type: VIEW; Schema: production; Owner: postgres
--

CREATE VIEW production.vproductmodelinstructions AS
 SELECT pm.productmodelid,
    pm.name,
    ((xpath('/ns:root/text()'::text, pm.instructions, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions}}'::text[]))[1])::character varying AS instructions,
    (((xpath('@LocationID'::text, pm.mfginstructions))[1])::character varying)::integer AS "LocationID",
    (((xpath('@SetupHours'::text, pm.mfginstructions))[1])::character varying)::numeric(9,4) AS "SetupHours",
    (((xpath('@MachineHours'::text, pm.mfginstructions))[1])::character varying)::numeric(9,4) AS "MachineHours",
    (((xpath('@LaborHours'::text, pm.mfginstructions))[1])::character varying)::numeric(9,4) AS "LaborHours",
    (((xpath('@LotSize'::text, pm.mfginstructions))[1])::character varying)::integer AS "LotSize",
    ((xpath('/step/text()'::text, pm.step))[1])::character varying(1024) AS "Step",
    pm.rowguid,
    pm.modifieddate
   FROM ( SELECT locations.productmodelid,
            locations.name,
            locations.rowguid,
            locations.modifieddate,
            locations.instructions,
            locations.mfginstructions,
            unnest(xpath('step'::text, locations.mfginstructions)) AS step
           FROM ( SELECT productmodel.productmodelid,
                    productmodel.name,
                    productmodel.rowguid,
                    productmodel.modifieddate,
                    productmodel.instructions,
                    unnest(xpath('/ns:root/ns:Location'::text, productmodel.instructions, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/ProductModelManuInstructions}}'::text[])) AS mfginstructions
                   FROM production.productmodel) locations) pm;


ALTER TABLE production.vproductmodelinstructions OWNER TO postgres;

--
-- Name: workorder_workorderid_seq; Type: SEQUENCE; Schema: production; Owner: postgres
--

CREATE SEQUENCE production.workorder_workorderid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE production.workorder_workorderid_seq OWNER TO postgres;

--
-- Name: workorder_workorderid_seq; Type: SEQUENCE OWNED BY; Schema: production; Owner: postgres
--

ALTER SEQUENCE production.workorder_workorderid_seq OWNED BY production.workorder.workorderid;


--
-- Name: purchaseorderdetail; Type: TABLE; Schema: purchasing; Owner: postgres
--

CREATE TABLE purchasing.purchaseorderdetail (
    purchaseorderid integer NOT NULL,
    purchaseorderdetailid integer NOT NULL,
    duedate timestamp without time zone NOT NULL,
    orderqty smallint NOT NULL,
    productid integer NOT NULL,
    unitprice numeric NOT NULL,
    receivedqty numeric(8,2) NOT NULL,
    rejectedqty numeric(8,2) NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_PurchaseOrderDetail_OrderQty" CHECK ((orderqty > 0)),
    CONSTRAINT "CK_PurchaseOrderDetail_ReceivedQty" CHECK ((receivedqty >= 0.00)),
    CONSTRAINT "CK_PurchaseOrderDetail_RejectedQty" CHECK ((rejectedqty >= 0.00)),
    CONSTRAINT "CK_PurchaseOrderDetail_UnitPrice" CHECK ((unitprice >= 0.00))
);


ALTER TABLE purchasing.purchaseorderdetail OWNER TO postgres;

--
-- Name: TABLE purchaseorderdetail; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON TABLE purchasing.purchaseorderdetail IS 'Individual products associated with a specific purchase order. See PurchaseOrderHeader.';


--
-- Name: COLUMN purchaseorderdetail.purchaseorderid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.purchaseorderid IS 'Primary key. Foreign key to PurchaseOrderHeader.PurchaseOrderID.';


--
-- Name: COLUMN purchaseorderdetail.purchaseorderdetailid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.purchaseorderdetailid IS 'Primary key. One line number per purchased product.';


--
-- Name: COLUMN purchaseorderdetail.duedate; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.duedate IS 'Date the product is expected to be received.';


--
-- Name: COLUMN purchaseorderdetail.orderqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.orderqty IS 'Quantity ordered.';


--
-- Name: COLUMN purchaseorderdetail.productid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: COLUMN purchaseorderdetail.unitprice; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.unitprice IS 'Vendor''s selling price of a single product.';


--
-- Name: COLUMN purchaseorderdetail.receivedqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.receivedqty IS 'Quantity actually received from the vendor.';


--
-- Name: COLUMN purchaseorderdetail.rejectedqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderdetail.rejectedqty IS 'Quantity rejected during inspection.';


--
-- Name: pod; Type: VIEW; Schema: pu; Owner: postgres
--

CREATE VIEW pu.pod AS
 SELECT purchaseorderdetail.purchaseorderdetailid AS id,
    purchaseorderdetail.purchaseorderid,
    purchaseorderdetail.purchaseorderdetailid,
    purchaseorderdetail.duedate,
    purchaseorderdetail.orderqty,
    purchaseorderdetail.productid,
    purchaseorderdetail.unitprice,
    purchaseorderdetail.receivedqty,
    purchaseorderdetail.rejectedqty,
    purchaseorderdetail.modifieddate
   FROM purchasing.purchaseorderdetail;


ALTER TABLE pu.pod OWNER TO postgres;

--
-- Name: purchaseorderheader; Type: TABLE; Schema: purchasing; Owner: postgres
--

CREATE TABLE purchasing.purchaseorderheader (
    purchaseorderid integer NOT NULL,
    revisionnumber smallint DEFAULT 0 NOT NULL,
    status smallint DEFAULT 1 NOT NULL,
    employeeid integer NOT NULL,
    vendorid integer NOT NULL,
    shipmethodid integer NOT NULL,
    orderdate timestamp without time zone DEFAULT now() NOT NULL,
    shipdate timestamp without time zone,
    subtotal numeric DEFAULT 0.00 NOT NULL,
    taxamt numeric DEFAULT 0.00 NOT NULL,
    freight numeric DEFAULT 0.00 NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_PurchaseOrderHeader_Freight" CHECK ((freight >= 0.00)),
    CONSTRAINT "CK_PurchaseOrderHeader_ShipDate" CHECK (((shipdate >= orderdate) OR (shipdate IS NULL))),
    CONSTRAINT "CK_PurchaseOrderHeader_Status" CHECK (((status >= 1) AND (status <= 4))),
    CONSTRAINT "CK_PurchaseOrderHeader_SubTotal" CHECK ((subtotal >= 0.00)),
    CONSTRAINT "CK_PurchaseOrderHeader_TaxAmt" CHECK ((taxamt >= 0.00))
);


ALTER TABLE purchasing.purchaseorderheader OWNER TO postgres;

--
-- Name: TABLE purchaseorderheader; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON TABLE purchasing.purchaseorderheader IS 'General purchase order information. See PurchaseOrderDetail.';


--
-- Name: COLUMN purchaseorderheader.purchaseorderid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.purchaseorderid IS 'Primary key.';


--
-- Name: COLUMN purchaseorderheader.revisionnumber; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.revisionnumber IS 'Incremental number to track changes to the purchase order over time.';


--
-- Name: COLUMN purchaseorderheader.status; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.status IS 'Order current status. 1 = Pending; 2 = Approved; 3 = Rejected; 4 = Complete';


--
-- Name: COLUMN purchaseorderheader.employeeid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.employeeid IS 'Employee who created the purchase order. Foreign key to Employee.BusinessEntityID.';


--
-- Name: COLUMN purchaseorderheader.vendorid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.vendorid IS 'Vendor with whom the purchase order is placed. Foreign key to Vendor.BusinessEntityID.';


--
-- Name: COLUMN purchaseorderheader.shipmethodid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.shipmethodid IS 'Shipping method. Foreign key to ShipMethod.ShipMethodID.';


--
-- Name: COLUMN purchaseorderheader.orderdate; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.orderdate IS 'Purchase order creation date.';


--
-- Name: COLUMN purchaseorderheader.shipdate; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.shipdate IS 'Estimated shipment date from the vendor.';


--
-- Name: COLUMN purchaseorderheader.subtotal; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.subtotal IS 'Purchase order subtotal. Computed as SUM(PurchaseOrderDetail.LineTotal)for the appropriate PurchaseOrderID.';


--
-- Name: COLUMN purchaseorderheader.taxamt; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.taxamt IS 'Tax amount.';


--
-- Name: COLUMN purchaseorderheader.freight; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.purchaseorderheader.freight IS 'Shipping cost.';


--
-- Name: poh; Type: VIEW; Schema: pu; Owner: postgres
--

CREATE VIEW pu.poh AS
 SELECT purchaseorderheader.purchaseorderid AS id,
    purchaseorderheader.purchaseorderid,
    purchaseorderheader.revisionnumber,
    purchaseorderheader.status,
    purchaseorderheader.employeeid,
    purchaseorderheader.vendorid,
    purchaseorderheader.shipmethodid,
    purchaseorderheader.orderdate,
    purchaseorderheader.shipdate,
    purchaseorderheader.subtotal,
    purchaseorderheader.taxamt,
    purchaseorderheader.freight,
    purchaseorderheader.modifieddate
   FROM purchasing.purchaseorderheader;


ALTER TABLE pu.poh OWNER TO postgres;

--
-- Name: productvendor; Type: TABLE; Schema: purchasing; Owner: postgres
--

CREATE TABLE purchasing.productvendor (
    productid integer NOT NULL,
    businessentityid integer NOT NULL,
    averageleadtime integer NOT NULL,
    standardprice numeric NOT NULL,
    lastreceiptcost numeric,
    lastreceiptdate timestamp without time zone,
    minorderqty integer NOT NULL,
    maxorderqty integer NOT NULL,
    onorderqty integer,
    unitmeasurecode character(3) NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ProductVendor_AverageLeadTime" CHECK ((averageleadtime >= 1)),
    CONSTRAINT "CK_ProductVendor_LastReceiptCost" CHECK ((lastreceiptcost > 0.00)),
    CONSTRAINT "CK_ProductVendor_MaxOrderQty" CHECK ((maxorderqty >= 1)),
    CONSTRAINT "CK_ProductVendor_MinOrderQty" CHECK ((minorderqty >= 1)),
    CONSTRAINT "CK_ProductVendor_OnOrderQty" CHECK ((onorderqty >= 0)),
    CONSTRAINT "CK_ProductVendor_StandardPrice" CHECK ((standardprice > 0.00))
);


ALTER TABLE purchasing.productvendor OWNER TO postgres;

--
-- Name: TABLE productvendor; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON TABLE purchasing.productvendor IS 'Cross-reference table mapping vendors with the products they supply.';


--
-- Name: COLUMN productvendor.productid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.productid IS 'Primary key. Foreign key to Product.ProductID.';


--
-- Name: COLUMN productvendor.businessentityid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.businessentityid IS 'Primary key. Foreign key to Vendor.BusinessEntityID.';


--
-- Name: COLUMN productvendor.averageleadtime; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.averageleadtime IS 'The average span of time (in days) between placing an order with the vendor and receiving the purchased product.';


--
-- Name: COLUMN productvendor.standardprice; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.standardprice IS 'The vendor''s usual selling price.';


--
-- Name: COLUMN productvendor.lastreceiptcost; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.lastreceiptcost IS 'The selling price when last purchased.';


--
-- Name: COLUMN productvendor.lastreceiptdate; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.lastreceiptdate IS 'Date the product was last received by the vendor.';


--
-- Name: COLUMN productvendor.minorderqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.minorderqty IS 'The maximum quantity that should be ordered.';


--
-- Name: COLUMN productvendor.maxorderqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.maxorderqty IS 'The minimum quantity that should be ordered.';


--
-- Name: COLUMN productvendor.onorderqty; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.onorderqty IS 'The quantity currently on order.';


--
-- Name: COLUMN productvendor.unitmeasurecode; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.productvendor.unitmeasurecode IS 'The product''s unit of measure.';


--
-- Name: pv; Type: VIEW; Schema: pu; Owner: postgres
--

CREATE VIEW pu.pv AS
 SELECT productvendor.productid AS id,
    productvendor.productid,
    productvendor.businessentityid,
    productvendor.averageleadtime,
    productvendor.standardprice,
    productvendor.lastreceiptcost,
    productvendor.lastreceiptdate,
    productvendor.minorderqty,
    productvendor.maxorderqty,
    productvendor.onorderqty,
    productvendor.unitmeasurecode,
    productvendor.modifieddate
   FROM purchasing.productvendor;


ALTER TABLE pu.pv OWNER TO postgres;

--
-- Name: shipmethod; Type: TABLE; Schema: purchasing; Owner: postgres
--

CREATE TABLE purchasing.shipmethod (
    shipmethodid integer NOT NULL,
    name public."Name" NOT NULL,
    shipbase numeric DEFAULT 0.00 NOT NULL,
    shiprate numeric DEFAULT 0.00 NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ShipMethod_ShipBase" CHECK ((shipbase > 0.00)),
    CONSTRAINT "CK_ShipMethod_ShipRate" CHECK ((shiprate > 0.00))
);


ALTER TABLE purchasing.shipmethod OWNER TO postgres;

--
-- Name: TABLE shipmethod; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON TABLE purchasing.shipmethod IS 'Shipping company lookup table.';


--
-- Name: COLUMN shipmethod.shipmethodid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.shipmethod.shipmethodid IS 'Primary key for ShipMethod records.';


--
-- Name: COLUMN shipmethod.name; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.shipmethod.name IS 'Shipping company name.';


--
-- Name: COLUMN shipmethod.shipbase; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.shipmethod.shipbase IS 'Minimum shipping charge.';


--
-- Name: COLUMN shipmethod.shiprate; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.shipmethod.shiprate IS 'Shipping charge per pound.';


--
-- Name: sm; Type: VIEW; Schema: pu; Owner: postgres
--

CREATE VIEW pu.sm AS
 SELECT shipmethod.shipmethodid AS id,
    shipmethod.shipmethodid,
    shipmethod.name,
    shipmethod.shipbase,
    shipmethod.shiprate,
    shipmethod.rowguid,
    shipmethod.modifieddate
   FROM purchasing.shipmethod;


ALTER TABLE pu.sm OWNER TO postgres;

--
-- Name: vendor; Type: TABLE; Schema: purchasing; Owner: postgres
--

CREATE TABLE purchasing.vendor (
    businessentityid integer NOT NULL,
    accountnumber public."AccountNumber" NOT NULL,
    name public."Name" NOT NULL,
    creditrating smallint NOT NULL,
    preferredvendorstatus public."Flag" DEFAULT true NOT NULL,
    activeflag public."Flag" DEFAULT true NOT NULL,
    purchasingwebserviceurl character varying(1024),
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_Vendor_CreditRating" CHECK (((creditrating >= 1) AND (creditrating <= 5)))
);


ALTER TABLE purchasing.vendor OWNER TO postgres;

--
-- Name: TABLE vendor; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON TABLE purchasing.vendor IS 'Companies from whom Adventure Works Cycles purchases parts or other goods.';


--
-- Name: COLUMN vendor.businessentityid; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.businessentityid IS 'Primary key for Vendor records.  Foreign key to BusinessEntity.BusinessEntityID';


--
-- Name: COLUMN vendor.accountnumber; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.accountnumber IS 'Vendor account (identification) number.';


--
-- Name: COLUMN vendor.name; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.name IS 'Company name.';


--
-- Name: COLUMN vendor.creditrating; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.creditrating IS '1 = Superior, 2 = Excellent, 3 = Above average, 4 = Average, 5 = Below average';


--
-- Name: COLUMN vendor.preferredvendorstatus; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.preferredvendorstatus IS '0 = Do not use if another vendor is available. 1 = Preferred over other vendors supplying the same product.';


--
-- Name: COLUMN vendor.activeflag; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.activeflag IS '0 = Vendor no longer used. 1 = Vendor is actively used.';


--
-- Name: COLUMN vendor.purchasingwebserviceurl; Type: COMMENT; Schema: purchasing; Owner: postgres
--

COMMENT ON COLUMN purchasing.vendor.purchasingwebserviceurl IS 'Vendor URL.';


--
-- Name: v; Type: VIEW; Schema: pu; Owner: postgres
--

CREATE VIEW pu.v AS
 SELECT vendor.businessentityid AS id,
    vendor.businessentityid,
    vendor.accountnumber,
    vendor.name,
    vendor.creditrating,
    vendor.preferredvendorstatus,
    vendor.activeflag,
    vendor.purchasingwebserviceurl,
    vendor.modifieddate
   FROM purchasing.vendor;


ALTER TABLE pu.v OWNER TO postgres;

--
-- Name: purchaseorderdetail_purchaseorderdetailid_seq; Type: SEQUENCE; Schema: purchasing; Owner: postgres
--

CREATE SEQUENCE purchasing.purchaseorderdetail_purchaseorderdetailid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE purchasing.purchaseorderdetail_purchaseorderdetailid_seq OWNER TO postgres;

--
-- Name: purchaseorderdetail_purchaseorderdetailid_seq; Type: SEQUENCE OWNED BY; Schema: purchasing; Owner: postgres
--

ALTER SEQUENCE purchasing.purchaseorderdetail_purchaseorderdetailid_seq OWNED BY purchasing.purchaseorderdetail.purchaseorderdetailid;


--
-- Name: purchaseorderheader_purchaseorderid_seq; Type: SEQUENCE; Schema: purchasing; Owner: postgres
--

CREATE SEQUENCE purchasing.purchaseorderheader_purchaseorderid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE purchasing.purchaseorderheader_purchaseorderid_seq OWNER TO postgres;

--
-- Name: purchaseorderheader_purchaseorderid_seq; Type: SEQUENCE OWNED BY; Schema: purchasing; Owner: postgres
--

ALTER SEQUENCE purchasing.purchaseorderheader_purchaseorderid_seq OWNED BY purchasing.purchaseorderheader.purchaseorderid;


--
-- Name: shipmethod_shipmethodid_seq; Type: SEQUENCE; Schema: purchasing; Owner: postgres
--

CREATE SEQUENCE purchasing.shipmethod_shipmethodid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE purchasing.shipmethod_shipmethodid_seq OWNER TO postgres;

--
-- Name: shipmethod_shipmethodid_seq; Type: SEQUENCE OWNED BY; Schema: purchasing; Owner: postgres
--

ALTER SEQUENCE purchasing.shipmethod_shipmethodid_seq OWNED BY purchasing.shipmethod.shipmethodid;


--
-- Name: vvendorwithaddresses; Type: VIEW; Schema: purchasing; Owner: postgres
--

CREATE VIEW purchasing.vvendorwithaddresses AS
 SELECT v.businessentityid,
    v.name,
    at.name AS addresstype,
    a.addressline1,
    a.addressline2,
    a.city,
    sp.name AS stateprovincename,
    a.postalcode,
    cr.name AS countryregionname
   FROM (((((purchasing.vendor v
     JOIN person.businessentityaddress bea ON ((bea.businessentityid = v.businessentityid)))
     JOIN person.address a ON ((a.addressid = bea.addressid)))
     JOIN person.stateprovince sp ON ((sp.stateprovinceid = a.stateprovinceid)))
     JOIN person.countryregion cr ON (((cr.countryregioncode)::text = (sp.countryregioncode)::text)))
     JOIN person.addresstype at ON ((at.addresstypeid = bea.addresstypeid)));


ALTER TABLE purchasing.vvendorwithaddresses OWNER TO postgres;

--
-- Name: vvendorwithcontacts; Type: VIEW; Schema: purchasing; Owner: postgres
--

CREATE VIEW purchasing.vvendorwithcontacts AS
 SELECT v.businessentityid,
    v.name,
    ct.name AS contacttype,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    pp.phonenumber,
    pnt.name AS phonenumbertype,
    ea.emailaddress,
    p.emailpromotion
   FROM ((((((purchasing.vendor v
     JOIN person.businessentitycontact bec ON ((bec.businessentityid = v.businessentityid)))
     JOIN person.contacttype ct ON ((ct.contacttypeid = bec.contacttypeid)))
     JOIN person.person p ON ((p.businessentityid = bec.personid)))
     LEFT JOIN person.emailaddress ea ON ((ea.businessentityid = p.businessentityid)))
     LEFT JOIN person.personphone pp ON ((pp.businessentityid = p.businessentityid)))
     LEFT JOIN person.phonenumbertype pnt ON ((pnt.phonenumbertypeid = pp.phonenumbertypeid)));


ALTER TABLE purchasing.vvendorwithcontacts OWNER TO postgres;

--
-- Name: customer; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.customer (
    customerid integer NOT NULL,
    personid integer,
    storeid integer,
    territoryid integer,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.customer OWNER TO postgres;

--
-- Name: TABLE customer; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.customer IS 'Current customer information. Also see the Person and Store tables.';


--
-- Name: COLUMN customer.customerid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.customer.customerid IS 'Primary key.';


--
-- Name: COLUMN customer.personid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.customer.personid IS 'Foreign key to Person.BusinessEntityID';


--
-- Name: COLUMN customer.storeid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.customer.storeid IS 'Foreign key to Store.BusinessEntityID';


--
-- Name: COLUMN customer.territoryid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.customer.territoryid IS 'ID of the territory in which the customer is located. Foreign key to SalesTerritory.SalesTerritoryID.';


--
-- Name: c; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.c AS
 SELECT customer.customerid AS id,
    customer.customerid,
    customer.personid,
    customer.storeid,
    customer.territoryid,
    customer.rowguid,
    customer.modifieddate
   FROM sales.customer;


ALTER TABLE sa.c OWNER TO postgres;

--
-- Name: creditcard; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.creditcard (
    creditcardid integer NOT NULL,
    cardtype character varying(50) NOT NULL,
    cardnumber character varying(25) NOT NULL,
    expmonth smallint NOT NULL,
    expyear smallint NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.creditcard OWNER TO postgres;

--
-- Name: TABLE creditcard; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.creditcard IS 'Customer credit card information.';


--
-- Name: COLUMN creditcard.creditcardid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.creditcard.creditcardid IS 'Primary key for CreditCard records.';


--
-- Name: COLUMN creditcard.cardtype; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.creditcard.cardtype IS 'Credit card name.';


--
-- Name: COLUMN creditcard.cardnumber; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.creditcard.cardnumber IS 'Credit card number.';


--
-- Name: COLUMN creditcard.expmonth; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.creditcard.expmonth IS 'Credit card expiration month.';


--
-- Name: COLUMN creditcard.expyear; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.creditcard.expyear IS 'Credit card expiration year.';


--
-- Name: cc; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.cc AS
 SELECT creditcard.creditcardid AS id,
    creditcard.creditcardid,
    creditcard.cardtype,
    creditcard.cardnumber,
    creditcard.expmonth,
    creditcard.expyear,
    creditcard.modifieddate
   FROM sales.creditcard;


ALTER TABLE sa.cc OWNER TO postgres;

--
-- Name: currencyrate; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.currencyrate (
    currencyrateid integer NOT NULL,
    currencyratedate timestamp without time zone NOT NULL,
    fromcurrencycode character(3) NOT NULL,
    tocurrencycode character(3) NOT NULL,
    averagerate numeric NOT NULL,
    endofdayrate numeric NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.currencyrate OWNER TO postgres;

--
-- Name: TABLE currencyrate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.currencyrate IS 'Currency exchange rates.';


--
-- Name: COLUMN currencyrate.currencyrateid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.currencyrateid IS 'Primary key for CurrencyRate records.';


--
-- Name: COLUMN currencyrate.currencyratedate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.currencyratedate IS 'Date and time the exchange rate was obtained.';


--
-- Name: COLUMN currencyrate.fromcurrencycode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.fromcurrencycode IS 'Exchange rate was converted from this currency code.';


--
-- Name: COLUMN currencyrate.tocurrencycode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.tocurrencycode IS 'Exchange rate was converted to this currency code.';


--
-- Name: COLUMN currencyrate.averagerate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.averagerate IS 'Average exchange rate for the day.';


--
-- Name: COLUMN currencyrate.endofdayrate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currencyrate.endofdayrate IS 'Final exchange rate for the day.';


--
-- Name: cr; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.cr AS
 SELECT currencyrate.currencyrateid,
    currencyrate.currencyratedate,
    currencyrate.fromcurrencycode,
    currencyrate.tocurrencycode,
    currencyrate.averagerate,
    currencyrate.endofdayrate,
    currencyrate.modifieddate
   FROM sales.currencyrate;


ALTER TABLE sa.cr OWNER TO postgres;

--
-- Name: countryregioncurrency; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.countryregioncurrency (
    countryregioncode character varying(3) NOT NULL,
    currencycode character(3) NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.countryregioncurrency OWNER TO postgres;

--
-- Name: TABLE countryregioncurrency; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.countryregioncurrency IS 'Cross-reference table mapping ISO currency codes to a country or region.';


--
-- Name: COLUMN countryregioncurrency.countryregioncode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.countryregioncurrency.countryregioncode IS 'ISO code for countries and regions. Foreign key to CountryRegion.CountryRegionCode.';


--
-- Name: COLUMN countryregioncurrency.currencycode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.countryregioncurrency.currencycode IS 'ISO standard currency code. Foreign key to Currency.CurrencyCode.';


--
-- Name: crc; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.crc AS
 SELECT countryregioncurrency.countryregioncode,
    countryregioncurrency.currencycode,
    countryregioncurrency.modifieddate
   FROM sales.countryregioncurrency;


ALTER TABLE sa.crc OWNER TO postgres;

--
-- Name: currency; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.currency (
    currencycode character(3) NOT NULL,
    name public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.currency OWNER TO postgres;

--
-- Name: TABLE currency; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.currency IS 'Lookup table containing standard ISO currencies.';


--
-- Name: COLUMN currency.currencycode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currency.currencycode IS 'The ISO code for the Currency.';


--
-- Name: COLUMN currency.name; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.currency.name IS 'Currency name.';


--
-- Name: cu; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.cu AS
 SELECT currency.currencycode AS id,
    currency.currencycode,
    currency.name,
    currency.modifieddate
   FROM sales.currency;


ALTER TABLE sa.cu OWNER TO postgres;

--
-- Name: personcreditcard; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.personcreditcard (
    businessentityid integer NOT NULL,
    creditcardid integer NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.personcreditcard OWNER TO postgres;

--
-- Name: TABLE personcreditcard; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.personcreditcard IS 'Cross-reference table mapping people to their credit card information in the CreditCard table.';


--
-- Name: COLUMN personcreditcard.businessentityid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.personcreditcard.businessentityid IS 'Business entity identification number. Foreign key to Person.BusinessEntityID.';


--
-- Name: COLUMN personcreditcard.creditcardid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.personcreditcard.creditcardid IS 'Credit card identification number. Foreign key to CreditCard.CreditCardID.';


--
-- Name: pcc; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.pcc AS
 SELECT personcreditcard.businessentityid AS id,
    personcreditcard.businessentityid,
    personcreditcard.creditcardid,
    personcreditcard.modifieddate
   FROM sales.personcreditcard;


ALTER TABLE sa.pcc OWNER TO postgres;

--
-- Name: store; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.store (
    businessentityid integer NOT NULL,
    name public."Name" NOT NULL,
    salespersonid integer,
    demographics xml,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.store OWNER TO postgres;

--
-- Name: TABLE store; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.store IS 'Customers (resellers) of Adventure Works products.';


--
-- Name: COLUMN store.businessentityid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.store.businessentityid IS 'Primary key. Foreign key to Customer.BusinessEntityID.';


--
-- Name: COLUMN store.name; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.store.name IS 'Name of the store.';


--
-- Name: COLUMN store.salespersonid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.store.salespersonid IS 'ID of the sales person assigned to the customer. Foreign key to SalesPerson.BusinessEntityID.';


--
-- Name: COLUMN store.demographics; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.store.demographics IS 'Demographic informationg about the store such as the number of employees, annual sales and store type.';


--
-- Name: s; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.s AS
 SELECT store.businessentityid AS id,
    store.businessentityid,
    store.name,
    store.salespersonid,
    store.demographics,
    store.rowguid,
    store.modifieddate
   FROM sales.store;


ALTER TABLE sa.s OWNER TO postgres;

--
-- Name: shoppingcartitem; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.shoppingcartitem (
    shoppingcartitemid integer NOT NULL,
    shoppingcartid character varying(50) NOT NULL,
    quantity integer DEFAULT 1 NOT NULL,
    productid integer NOT NULL,
    datecreated timestamp without time zone DEFAULT now() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_ShoppingCartItem_Quantity" CHECK ((quantity >= 1))
);


ALTER TABLE sales.shoppingcartitem OWNER TO postgres;

--
-- Name: TABLE shoppingcartitem; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.shoppingcartitem IS 'Contains online customer orders until the order is submitted or cancelled.';


--
-- Name: COLUMN shoppingcartitem.shoppingcartitemid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.shoppingcartitem.shoppingcartitemid IS 'Primary key for ShoppingCartItem records.';


--
-- Name: COLUMN shoppingcartitem.shoppingcartid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.shoppingcartitem.shoppingcartid IS 'Shopping cart identification number.';


--
-- Name: COLUMN shoppingcartitem.quantity; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.shoppingcartitem.quantity IS 'Product quantity ordered.';


--
-- Name: COLUMN shoppingcartitem.productid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.shoppingcartitem.productid IS 'Product ordered. Foreign key to Product.ProductID.';


--
-- Name: COLUMN shoppingcartitem.datecreated; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.shoppingcartitem.datecreated IS 'Date the time the record was created.';


--
-- Name: sci; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sci AS
 SELECT shoppingcartitem.shoppingcartitemid AS id,
    shoppingcartitem.shoppingcartitemid,
    shoppingcartitem.shoppingcartid,
    shoppingcartitem.quantity,
    shoppingcartitem.productid,
    shoppingcartitem.datecreated,
    shoppingcartitem.modifieddate
   FROM sales.shoppingcartitem;


ALTER TABLE sa.sci OWNER TO postgres;

--
-- Name: specialoffer; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.specialoffer (
    specialofferid integer NOT NULL,
    description character varying(255) NOT NULL,
    discountpct numeric DEFAULT 0.00 NOT NULL,
    type character varying(50) NOT NULL,
    category character varying(50) NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone NOT NULL,
    minqty integer DEFAULT 0 NOT NULL,
    maxqty integer,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SpecialOffer_DiscountPct" CHECK ((discountpct >= 0.00)),
    CONSTRAINT "CK_SpecialOffer_EndDate" CHECK ((enddate >= startdate)),
    CONSTRAINT "CK_SpecialOffer_MaxQty" CHECK ((maxqty >= 0)),
    CONSTRAINT "CK_SpecialOffer_MinQty" CHECK ((minqty >= 0))
);


ALTER TABLE sales.specialoffer OWNER TO postgres;

--
-- Name: TABLE specialoffer; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.specialoffer IS 'Sale discounts lookup table.';


--
-- Name: COLUMN specialoffer.specialofferid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.specialofferid IS 'Primary key for SpecialOffer records.';


--
-- Name: COLUMN specialoffer.description; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.description IS 'Discount description.';


--
-- Name: COLUMN specialoffer.discountpct; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.discountpct IS 'Discount precentage.';


--
-- Name: COLUMN specialoffer.type; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.type IS 'Discount type category.';


--
-- Name: COLUMN specialoffer.category; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.category IS 'Group the discount applies to such as Reseller or Customer.';


--
-- Name: COLUMN specialoffer.startdate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.startdate IS 'Discount start date.';


--
-- Name: COLUMN specialoffer.enddate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.enddate IS 'Discount end date.';


--
-- Name: COLUMN specialoffer.minqty; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.minqty IS 'Minimum discount percent allowed.';


--
-- Name: COLUMN specialoffer.maxqty; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialoffer.maxqty IS 'Maximum discount percent allowed.';


--
-- Name: so; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.so AS
 SELECT specialoffer.specialofferid AS id,
    specialoffer.specialofferid,
    specialoffer.description,
    specialoffer.discountpct,
    specialoffer.type,
    specialoffer.category,
    specialoffer.startdate,
    specialoffer.enddate,
    specialoffer.minqty,
    specialoffer.maxqty,
    specialoffer.rowguid,
    specialoffer.modifieddate
   FROM sales.specialoffer;


ALTER TABLE sa.so OWNER TO postgres;

--
-- Name: salesorderdetail; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesorderdetail (
    salesorderid integer NOT NULL,
    salesorderdetailid integer NOT NULL,
    carriertrackingnumber character varying(25),
    orderqty smallint NOT NULL,
    productid integer NOT NULL,
    specialofferid integer NOT NULL,
    unitprice numeric NOT NULL,
    unitpricediscount numeric DEFAULT 0.0 NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesOrderDetail_OrderQty" CHECK ((orderqty > 0)),
    CONSTRAINT "CK_SalesOrderDetail_UnitPrice" CHECK ((unitprice >= 0.00)),
    CONSTRAINT "CK_SalesOrderDetail_UnitPriceDiscount" CHECK ((unitpricediscount >= 0.00))
);


ALTER TABLE sales.salesorderdetail OWNER TO postgres;

--
-- Name: TABLE salesorderdetail; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesorderdetail IS 'Individual products associated with a specific sales order. See SalesOrderHeader.';


--
-- Name: COLUMN salesorderdetail.salesorderid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.salesorderid IS 'Primary key. Foreign key to SalesOrderHeader.SalesOrderID.';


--
-- Name: COLUMN salesorderdetail.salesorderdetailid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.salesorderdetailid IS 'Primary key. One incremental unique number per product sold.';


--
-- Name: COLUMN salesorderdetail.carriertrackingnumber; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.carriertrackingnumber IS 'Shipment tracking number supplied by the shipper.';


--
-- Name: COLUMN salesorderdetail.orderqty; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.orderqty IS 'Quantity ordered per product.';


--
-- Name: COLUMN salesorderdetail.productid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.productid IS 'Product sold to customer. Foreign key to Product.ProductID.';


--
-- Name: COLUMN salesorderdetail.specialofferid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.specialofferid IS 'Promotional code. Foreign key to SpecialOffer.SpecialOfferID.';


--
-- Name: COLUMN salesorderdetail.unitprice; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.unitprice IS 'Selling price of a single product.';


--
-- Name: COLUMN salesorderdetail.unitpricediscount; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderdetail.unitpricediscount IS 'Discount amount.';


--
-- Name: sod; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sod AS
 SELECT salesorderdetail.salesorderdetailid AS id,
    salesorderdetail.salesorderid,
    salesorderdetail.salesorderdetailid,
    salesorderdetail.carriertrackingnumber,
    salesorderdetail.orderqty,
    salesorderdetail.productid,
    salesorderdetail.specialofferid,
    salesorderdetail.unitprice,
    salesorderdetail.unitpricediscount,
    salesorderdetail.rowguid,
    salesorderdetail.modifieddate
   FROM sales.salesorderdetail;


ALTER TABLE sa.sod OWNER TO postgres;

--
-- Name: salesorderheader; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesorderheader (
    salesorderid integer NOT NULL,
    revisionnumber smallint DEFAULT 0 NOT NULL,
    orderdate timestamp without time zone DEFAULT now() NOT NULL,
    duedate timestamp without time zone NOT NULL,
    shipdate timestamp without time zone,
    status smallint DEFAULT 1 NOT NULL,
    onlineorderflag public."Flag" DEFAULT true NOT NULL,
    purchaseordernumber public."OrderNumber",
    accountnumber public."AccountNumber",
    customerid integer NOT NULL,
    salespersonid integer,
    territoryid integer,
    billtoaddressid integer NOT NULL,
    shiptoaddressid integer NOT NULL,
    shipmethodid integer NOT NULL,
    creditcardid integer,
    creditcardapprovalcode character varying(15),
    currencyrateid integer,
    subtotal numeric DEFAULT 0.00 NOT NULL,
    taxamt numeric DEFAULT 0.00 NOT NULL,
    freight numeric DEFAULT 0.00 NOT NULL,
    totaldue numeric,
    comment character varying(128),
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesOrderHeader_DueDate" CHECK ((duedate >= orderdate)),
    CONSTRAINT "CK_SalesOrderHeader_Freight" CHECK ((freight >= 0.00)),
    CONSTRAINT "CK_SalesOrderHeader_ShipDate" CHECK (((shipdate >= orderdate) OR (shipdate IS NULL))),
    CONSTRAINT "CK_SalesOrderHeader_Status" CHECK (((status >= 0) AND (status <= 8))),
    CONSTRAINT "CK_SalesOrderHeader_SubTotal" CHECK ((subtotal >= 0.00)),
    CONSTRAINT "CK_SalesOrderHeader_TaxAmt" CHECK ((taxamt >= 0.00))
);


ALTER TABLE sales.salesorderheader OWNER TO postgres;

--
-- Name: TABLE salesorderheader; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesorderheader IS 'General sales order information.';


--
-- Name: COLUMN salesorderheader.salesorderid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.salesorderid IS 'Primary key.';


--
-- Name: COLUMN salesorderheader.revisionnumber; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.revisionnumber IS 'Incremental number to track changes to the sales order over time.';


--
-- Name: COLUMN salesorderheader.orderdate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.orderdate IS 'Dates the sales order was created.';


--
-- Name: COLUMN salesorderheader.duedate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.duedate IS 'Date the order is due to the customer.';


--
-- Name: COLUMN salesorderheader.shipdate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.shipdate IS 'Date the order was shipped to the customer.';


--
-- Name: COLUMN salesorderheader.status; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.status IS 'Order current status. 1 = In process; 2 = Approved; 3 = Backordered; 4 = Rejected; 5 = Shipped; 6 = Cancelled';


--
-- Name: COLUMN salesorderheader.onlineorderflag; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.onlineorderflag IS '0 = Order placed by sales person. 1 = Order placed online by customer.';


--
-- Name: COLUMN salesorderheader.purchaseordernumber; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.purchaseordernumber IS 'Customer purchase order number reference.';


--
-- Name: COLUMN salesorderheader.accountnumber; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.accountnumber IS 'Financial accounting number reference.';


--
-- Name: COLUMN salesorderheader.customerid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.customerid IS 'Customer identification number. Foreign key to Customer.BusinessEntityID.';


--
-- Name: COLUMN salesorderheader.salespersonid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.salespersonid IS 'Sales person who created the sales order. Foreign key to SalesPerson.BusinessEntityID.';


--
-- Name: COLUMN salesorderheader.territoryid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.territoryid IS 'Territory in which the sale was made. Foreign key to SalesTerritory.SalesTerritoryID.';


--
-- Name: COLUMN salesorderheader.billtoaddressid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.billtoaddressid IS 'Customer billing address. Foreign key to Address.AddressID.';


--
-- Name: COLUMN salesorderheader.shiptoaddressid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.shiptoaddressid IS 'Customer shipping address. Foreign key to Address.AddressID.';


--
-- Name: COLUMN salesorderheader.shipmethodid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.shipmethodid IS 'Shipping method. Foreign key to ShipMethod.ShipMethodID.';


--
-- Name: COLUMN salesorderheader.creditcardid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.creditcardid IS 'Credit card identification number. Foreign key to CreditCard.CreditCardID.';


--
-- Name: COLUMN salesorderheader.creditcardapprovalcode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.creditcardapprovalcode IS 'Approval code provided by the credit card company.';


--
-- Name: COLUMN salesorderheader.currencyrateid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.currencyrateid IS 'Currency exchange rate used. Foreign key to CurrencyRate.CurrencyRateID.';


--
-- Name: COLUMN salesorderheader.subtotal; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.subtotal IS 'Sales subtotal. Computed as SUM(SalesOrderDetail.LineTotal)for the appropriate SalesOrderID.';


--
-- Name: COLUMN salesorderheader.taxamt; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.taxamt IS 'Tax amount.';


--
-- Name: COLUMN salesorderheader.freight; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.freight IS 'Shipping cost.';


--
-- Name: COLUMN salesorderheader.totaldue; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.totaldue IS 'Total due from customer. Computed as Subtotal + TaxAmt + Freight.';


--
-- Name: COLUMN salesorderheader.comment; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheader.comment IS 'Sales representative comments.';


--
-- Name: soh; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.soh AS
 SELECT salesorderheader.salesorderid AS id,
    salesorderheader.salesorderid,
    salesorderheader.revisionnumber,
    salesorderheader.orderdate,
    salesorderheader.duedate,
    salesorderheader.shipdate,
    salesorderheader.status,
    salesorderheader.onlineorderflag,
    salesorderheader.purchaseordernumber,
    salesorderheader.accountnumber,
    salesorderheader.customerid,
    salesorderheader.salespersonid,
    salesorderheader.territoryid,
    salesorderheader.billtoaddressid,
    salesorderheader.shiptoaddressid,
    salesorderheader.shipmethodid,
    salesorderheader.creditcardid,
    salesorderheader.creditcardapprovalcode,
    salesorderheader.currencyrateid,
    salesorderheader.subtotal,
    salesorderheader.taxamt,
    salesorderheader.freight,
    salesorderheader.totaldue,
    salesorderheader.comment,
    salesorderheader.rowguid,
    salesorderheader.modifieddate
   FROM sales.salesorderheader;


ALTER TABLE sa.soh OWNER TO postgres;

--
-- Name: salesorderheadersalesreason; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesorderheadersalesreason (
    salesorderid integer NOT NULL,
    salesreasonid integer NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.salesorderheadersalesreason OWNER TO postgres;

--
-- Name: TABLE salesorderheadersalesreason; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesorderheadersalesreason IS 'Cross-reference table mapping sales orders to sales reason codes.';


--
-- Name: COLUMN salesorderheadersalesreason.salesorderid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheadersalesreason.salesorderid IS 'Primary key. Foreign key to SalesOrderHeader.SalesOrderID.';


--
-- Name: COLUMN salesorderheadersalesreason.salesreasonid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesorderheadersalesreason.salesreasonid IS 'Primary key. Foreign key to SalesReason.SalesReasonID.';


--
-- Name: sohsr; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sohsr AS
 SELECT salesorderheadersalesreason.salesorderid,
    salesorderheadersalesreason.salesreasonid,
    salesorderheadersalesreason.modifieddate
   FROM sales.salesorderheadersalesreason;


ALTER TABLE sa.sohsr OWNER TO postgres;

--
-- Name: specialofferproduct; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.specialofferproduct (
    specialofferid integer NOT NULL,
    productid integer NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.specialofferproduct OWNER TO postgres;

--
-- Name: TABLE specialofferproduct; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.specialofferproduct IS 'Cross-reference table mapping products to special offer discounts.';


--
-- Name: COLUMN specialofferproduct.specialofferid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialofferproduct.specialofferid IS 'Primary key for SpecialOfferProduct records.';


--
-- Name: COLUMN specialofferproduct.productid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.specialofferproduct.productid IS 'Product identification number. Foreign key to Product.ProductID.';


--
-- Name: sop; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sop AS
 SELECT specialofferproduct.specialofferid AS id,
    specialofferproduct.specialofferid,
    specialofferproduct.productid,
    specialofferproduct.rowguid,
    specialofferproduct.modifieddate
   FROM sales.specialofferproduct;


ALTER TABLE sa.sop OWNER TO postgres;

--
-- Name: salesperson; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesperson (
    businessentityid integer NOT NULL,
    territoryid integer,
    salesquota numeric,
    bonus numeric DEFAULT 0.00 NOT NULL,
    commissionpct numeric DEFAULT 0.00 NOT NULL,
    salesytd numeric DEFAULT 0.00 NOT NULL,
    saleslastyear numeric DEFAULT 0.00 NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesPerson_Bonus" CHECK ((bonus >= 0.00)),
    CONSTRAINT "CK_SalesPerson_CommissionPct" CHECK ((commissionpct >= 0.00)),
    CONSTRAINT "CK_SalesPerson_SalesLastYear" CHECK ((saleslastyear >= 0.00)),
    CONSTRAINT "CK_SalesPerson_SalesQuota" CHECK ((salesquota > 0.00)),
    CONSTRAINT "CK_SalesPerson_SalesYTD" CHECK ((salesytd >= 0.00))
);


ALTER TABLE sales.salesperson OWNER TO postgres;

--
-- Name: TABLE salesperson; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesperson IS 'Sales representative current information.';


--
-- Name: COLUMN salesperson.businessentityid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.businessentityid IS 'Primary key for SalesPerson records. Foreign key to Employee.BusinessEntityID';


--
-- Name: COLUMN salesperson.territoryid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.territoryid IS 'Territory currently assigned to. Foreign key to SalesTerritory.SalesTerritoryID.';


--
-- Name: COLUMN salesperson.salesquota; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.salesquota IS 'Projected yearly sales.';


--
-- Name: COLUMN salesperson.bonus; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.bonus IS 'Bonus due if quota is met.';


--
-- Name: COLUMN salesperson.commissionpct; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.commissionpct IS 'Commision percent received per sale.';


--
-- Name: COLUMN salesperson.salesytd; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.salesytd IS 'Sales total year to date.';


--
-- Name: COLUMN salesperson.saleslastyear; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesperson.saleslastyear IS 'Sales total of previous year.';


--
-- Name: sp; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sp AS
 SELECT salesperson.businessentityid AS id,
    salesperson.businessentityid,
    salesperson.territoryid,
    salesperson.salesquota,
    salesperson.bonus,
    salesperson.commissionpct,
    salesperson.salesytd,
    salesperson.saleslastyear,
    salesperson.rowguid,
    salesperson.modifieddate
   FROM sales.salesperson;


ALTER TABLE sa.sp OWNER TO postgres;

--
-- Name: salespersonquotahistory; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salespersonquotahistory (
    businessentityid integer NOT NULL,
    quotadate timestamp without time zone NOT NULL,
    salesquota numeric NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesPersonQuotaHistory_SalesQuota" CHECK ((salesquota > 0.00))
);


ALTER TABLE sales.salespersonquotahistory OWNER TO postgres;

--
-- Name: TABLE salespersonquotahistory; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salespersonquotahistory IS 'Sales performance tracking.';


--
-- Name: COLUMN salespersonquotahistory.businessentityid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salespersonquotahistory.businessentityid IS 'Sales person identification number. Foreign key to SalesPerson.BusinessEntityID.';


--
-- Name: COLUMN salespersonquotahistory.quotadate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salespersonquotahistory.quotadate IS 'Sales quota date.';


--
-- Name: COLUMN salespersonquotahistory.salesquota; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salespersonquotahistory.salesquota IS 'Sales quota amount.';


--
-- Name: spqh; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.spqh AS
 SELECT salespersonquotahistory.businessentityid AS id,
    salespersonquotahistory.businessentityid,
    salespersonquotahistory.quotadate,
    salespersonquotahistory.salesquota,
    salespersonquotahistory.rowguid,
    salespersonquotahistory.modifieddate
   FROM sales.salespersonquotahistory;


ALTER TABLE sa.spqh OWNER TO postgres;

--
-- Name: salesreason; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesreason (
    salesreasonid integer NOT NULL,
    name public."Name" NOT NULL,
    reasontype public."Name" NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE sales.salesreason OWNER TO postgres;

--
-- Name: TABLE salesreason; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesreason IS 'Lookup table of customer purchase reasons.';


--
-- Name: COLUMN salesreason.salesreasonid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesreason.salesreasonid IS 'Primary key for SalesReason records.';


--
-- Name: COLUMN salesreason.name; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesreason.name IS 'Sales reason description.';


--
-- Name: COLUMN salesreason.reasontype; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesreason.reasontype IS 'Category the sales reason belongs to.';


--
-- Name: sr; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sr AS
 SELECT salesreason.salesreasonid AS id,
    salesreason.salesreasonid,
    salesreason.name,
    salesreason.reasontype,
    salesreason.modifieddate
   FROM sales.salesreason;


ALTER TABLE sa.sr OWNER TO postgres;

--
-- Name: salesterritory; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesterritory (
    territoryid integer NOT NULL,
    name public."Name" NOT NULL,
    countryregioncode character varying(3) NOT NULL,
    "group" character varying(50) NOT NULL,
    salesytd numeric DEFAULT 0.00 NOT NULL,
    saleslastyear numeric DEFAULT 0.00 NOT NULL,
    costytd numeric DEFAULT 0.00 NOT NULL,
    costlastyear numeric DEFAULT 0.00 NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesTerritory_CostLastYear" CHECK ((costlastyear >= 0.00)),
    CONSTRAINT "CK_SalesTerritory_CostYTD" CHECK ((costytd >= 0.00)),
    CONSTRAINT "CK_SalesTerritory_SalesLastYear" CHECK ((saleslastyear >= 0.00)),
    CONSTRAINT "CK_SalesTerritory_SalesYTD" CHECK ((salesytd >= 0.00))
);


ALTER TABLE sales.salesterritory OWNER TO postgres;

--
-- Name: TABLE salesterritory; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesterritory IS 'Sales territory lookup table.';


--
-- Name: COLUMN salesterritory.territoryid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.territoryid IS 'Primary key for SalesTerritory records.';


--
-- Name: COLUMN salesterritory.name; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.name IS 'Sales territory description';


--
-- Name: COLUMN salesterritory.countryregioncode; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.countryregioncode IS 'ISO standard country or region code. Foreign key to CountryRegion.CountryRegionCode.';


--
-- Name: COLUMN salesterritory."group"; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory."group" IS 'Geographic area to which the sales territory belong.';


--
-- Name: COLUMN salesterritory.salesytd; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.salesytd IS 'Sales in the territory year to date.';


--
-- Name: COLUMN salesterritory.saleslastyear; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.saleslastyear IS 'Sales in the territory the previous year.';


--
-- Name: COLUMN salesterritory.costytd; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.costytd IS 'Business costs in the territory year to date.';


--
-- Name: COLUMN salesterritory.costlastyear; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritory.costlastyear IS 'Business costs in the territory the previous year.';


--
-- Name: st; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.st AS
 SELECT salesterritory.territoryid AS id,
    salesterritory.territoryid,
    salesterritory.name,
    salesterritory.countryregioncode,
    salesterritory."group",
    salesterritory.salesytd,
    salesterritory.saleslastyear,
    salesterritory.costytd,
    salesterritory.costlastyear,
    salesterritory.rowguid,
    salesterritory.modifieddate
   FROM sales.salesterritory;


ALTER TABLE sa.st OWNER TO postgres;

--
-- Name: salesterritoryhistory; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salesterritoryhistory (
    businessentityid integer NOT NULL,
    territoryid integer NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesTerritoryHistory_EndDate" CHECK (((enddate >= startdate) OR (enddate IS NULL)))
);


ALTER TABLE sales.salesterritoryhistory OWNER TO postgres;

--
-- Name: TABLE salesterritoryhistory; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salesterritoryhistory IS 'Sales representative transfers to other sales territories.';


--
-- Name: COLUMN salesterritoryhistory.businessentityid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritoryhistory.businessentityid IS 'Primary key. The sales rep.  Foreign key to SalesPerson.BusinessEntityID.';


--
-- Name: COLUMN salesterritoryhistory.territoryid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritoryhistory.territoryid IS 'Primary key. Territory identification number. Foreign key to SalesTerritory.SalesTerritoryID.';


--
-- Name: COLUMN salesterritoryhistory.startdate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritoryhistory.startdate IS 'Primary key. Date the sales representive started work in the territory.';


--
-- Name: COLUMN salesterritoryhistory.enddate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salesterritoryhistory.enddate IS 'Date the sales representative left work in the territory.';


--
-- Name: sth; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.sth AS
 SELECT salesterritoryhistory.territoryid AS id,
    salesterritoryhistory.businessentityid,
    salesterritoryhistory.territoryid,
    salesterritoryhistory.startdate,
    salesterritoryhistory.enddate,
    salesterritoryhistory.rowguid,
    salesterritoryhistory.modifieddate
   FROM sales.salesterritoryhistory;


ALTER TABLE sa.sth OWNER TO postgres;

--
-- Name: salestaxrate; Type: TABLE; Schema: sales; Owner: postgres
--

CREATE TABLE sales.salestaxrate (
    salestaxrateid integer NOT NULL,
    stateprovinceid integer NOT NULL,
    taxtype smallint NOT NULL,
    taxrate numeric DEFAULT 0.00 NOT NULL,
    name public."Name" NOT NULL,
    rowguid uuid DEFAULT public.uuid_generate_v1() NOT NULL,
    modifieddate timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT "CK_SalesTaxRate_TaxType" CHECK (((taxtype >= 1) AND (taxtype <= 3)))
);


ALTER TABLE sales.salestaxrate OWNER TO postgres;

--
-- Name: TABLE salestaxrate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON TABLE sales.salestaxrate IS 'Tax rate lookup table.';


--
-- Name: COLUMN salestaxrate.salestaxrateid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salestaxrate.salestaxrateid IS 'Primary key for SalesTaxRate records.';


--
-- Name: COLUMN salestaxrate.stateprovinceid; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salestaxrate.stateprovinceid IS 'State, province, or country/region the sales tax applies to.';


--
-- Name: COLUMN salestaxrate.taxtype; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salestaxrate.taxtype IS '1 = Tax applied to retail transactions, 2 = Tax applied to wholesale transactions, 3 = Tax applied to all sales (retail and wholesale) transactions.';


--
-- Name: COLUMN salestaxrate.taxrate; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salestaxrate.taxrate IS 'Tax rate amount.';


--
-- Name: COLUMN salestaxrate.name; Type: COMMENT; Schema: sales; Owner: postgres
--

COMMENT ON COLUMN sales.salestaxrate.name IS 'Tax rate description.';


--
-- Name: tr; Type: VIEW; Schema: sa; Owner: postgres
--

CREATE VIEW sa.tr AS
 SELECT salestaxrate.salestaxrateid AS id,
    salestaxrate.salestaxrateid,
    salestaxrate.stateprovinceid,
    salestaxrate.taxtype,
    salestaxrate.taxrate,
    salestaxrate.name,
    salestaxrate.rowguid,
    salestaxrate.modifieddate
   FROM sales.salestaxrate;


ALTER TABLE sa.tr OWNER TO postgres;

--
-- Name: creditcard_creditcardid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.creditcard_creditcardid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.creditcard_creditcardid_seq OWNER TO postgres;

--
-- Name: creditcard_creditcardid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.creditcard_creditcardid_seq OWNED BY sales.creditcard.creditcardid;


--
-- Name: currencyrate_currencyrateid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.currencyrate_currencyrateid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.currencyrate_currencyrateid_seq OWNER TO postgres;

--
-- Name: currencyrate_currencyrateid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.currencyrate_currencyrateid_seq OWNED BY sales.currencyrate.currencyrateid;


--
-- Name: customer_customerid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.customer_customerid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.customer_customerid_seq OWNER TO postgres;

--
-- Name: customer_customerid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.customer_customerid_seq OWNED BY sales.customer.customerid;


--
-- Name: salesorderdetail_salesorderdetailid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.salesorderdetail_salesorderdetailid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.salesorderdetail_salesorderdetailid_seq OWNER TO postgres;

--
-- Name: salesorderdetail_salesorderdetailid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.salesorderdetail_salesorderdetailid_seq OWNED BY sales.salesorderdetail.salesorderdetailid;


--
-- Name: salesorderheader_salesorderid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.salesorderheader_salesorderid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.salesorderheader_salesorderid_seq OWNER TO postgres;

--
-- Name: salesorderheader_salesorderid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.salesorderheader_salesorderid_seq OWNED BY sales.salesorderheader.salesorderid;


--
-- Name: salesreason_salesreasonid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.salesreason_salesreasonid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.salesreason_salesreasonid_seq OWNER TO postgres;

--
-- Name: salesreason_salesreasonid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.salesreason_salesreasonid_seq OWNED BY sales.salesreason.salesreasonid;


--
-- Name: salestaxrate_salestaxrateid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.salestaxrate_salestaxrateid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.salestaxrate_salestaxrateid_seq OWNER TO postgres;

--
-- Name: salestaxrate_salestaxrateid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.salestaxrate_salestaxrateid_seq OWNED BY sales.salestaxrate.salestaxrateid;


--
-- Name: salesterritory_territoryid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.salesterritory_territoryid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.salesterritory_territoryid_seq OWNER TO postgres;

--
-- Name: salesterritory_territoryid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.salesterritory_territoryid_seq OWNED BY sales.salesterritory.territoryid;


--
-- Name: shoppingcartitem_shoppingcartitemid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.shoppingcartitem_shoppingcartitemid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.shoppingcartitem_shoppingcartitemid_seq OWNER TO postgres;

--
-- Name: shoppingcartitem_shoppingcartitemid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.shoppingcartitem_shoppingcartitemid_seq OWNED BY sales.shoppingcartitem.shoppingcartitemid;


--
-- Name: specialoffer_specialofferid_seq; Type: SEQUENCE; Schema: sales; Owner: postgres
--

CREATE SEQUENCE sales.specialoffer_specialofferid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sales.specialoffer_specialofferid_seq OWNER TO postgres;

--
-- Name: specialoffer_specialofferid_seq; Type: SEQUENCE OWNED BY; Schema: sales; Owner: postgres
--

ALTER SEQUENCE sales.specialoffer_specialofferid_seq OWNED BY sales.specialoffer.specialofferid;


--
-- Name: vindividualcustomer; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vindividualcustomer AS
 SELECT p.businessentityid,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    pp.phonenumber,
    pnt.name AS phonenumbertype,
    ea.emailaddress,
    p.emailpromotion,
    at.name AS addresstype,
    a.addressline1,
    a.addressline2,
    a.city,
    sp.name AS stateprovincename,
    a.postalcode,
    cr.name AS countryregionname,
    p.demographics
   FROM (((((((((person.person p
     JOIN person.businessentityaddress bea ON ((bea.businessentityid = p.businessentityid)))
     JOIN person.address a ON ((a.addressid = bea.addressid)))
     JOIN person.stateprovince sp ON ((sp.stateprovinceid = a.stateprovinceid)))
     JOIN person.countryregion cr ON (((cr.countryregioncode)::text = (sp.countryregioncode)::text)))
     JOIN person.addresstype at ON ((at.addresstypeid = bea.addresstypeid)))
     JOIN sales.customer c ON ((c.personid = p.businessentityid)))
     LEFT JOIN person.emailaddress ea ON ((ea.businessentityid = p.businessentityid)))
     LEFT JOIN person.personphone pp ON ((pp.businessentityid = p.businessentityid)))
     LEFT JOIN person.phonenumbertype pnt ON ((pnt.phonenumbertypeid = pp.phonenumbertypeid)))
  WHERE (c.storeid IS NULL);


ALTER TABLE sales.vindividualcustomer OWNER TO postgres;

--
-- Name: vpersondemographics; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vpersondemographics AS
 SELECT person.businessentityid,
    (((xpath('n:TotalPurchaseYTD/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::money AS totalpurchaseytd,
    (((xpath('n:DateFirstPurchase/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::date AS datefirstpurchase,
    (((xpath('n:BirthDate/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::date AS birthdate,
    ((xpath('n:MaritalStatus/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying(1) AS maritalstatus,
    ((xpath('n:YearlyIncome/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying(30) AS yearlyincome,
    ((xpath('n:Gender/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying(1) AS gender,
    (((xpath('n:TotalChildren/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::integer AS totalchildren,
    (((xpath('n:NumberChildrenAtHome/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::integer AS numberchildrenathome,
    ((xpath('n:Education/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying(30) AS education,
    ((xpath('n:Occupation/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying(30) AS occupation,
    (((xpath('n:HomeOwnerFlag/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::boolean AS homeownerflag,
    (((xpath('n:NumberCarsOwned/text()'::text, person.demographics, '{{n,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/IndividualSurvey}}'::text[]))[1])::character varying)::integer AS numbercarsowned
   FROM person.person
  WHERE (person.demographics IS NOT NULL);


ALTER TABLE sales.vpersondemographics OWNER TO postgres;

--
-- Name: vsalesperson; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vsalesperson AS
 SELECT s.businessentityid,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    e.jobtitle,
    pp.phonenumber,
    pnt.name AS phonenumbertype,
    ea.emailaddress,
    p.emailpromotion,
    a.addressline1,
    a.addressline2,
    a.city,
    sp.name AS stateprovincename,
    a.postalcode,
    cr.name AS countryregionname,
    st.name AS territoryname,
    st."group" AS territorygroup,
    s.salesquota,
    s.salesytd,
    s.saleslastyear
   FROM ((((((((((sales.salesperson s
     JOIN humanresources.employee e ON ((e.businessentityid = s.businessentityid)))
     JOIN person.person p ON ((p.businessentityid = s.businessentityid)))
     JOIN person.businessentityaddress bea ON ((bea.businessentityid = s.businessentityid)))
     JOIN person.address a ON ((a.addressid = bea.addressid)))
     JOIN person.stateprovince sp ON ((sp.stateprovinceid = a.stateprovinceid)))
     JOIN person.countryregion cr ON (((cr.countryregioncode)::text = (sp.countryregioncode)::text)))
     LEFT JOIN sales.salesterritory st ON ((st.territoryid = s.territoryid)))
     LEFT JOIN person.emailaddress ea ON ((ea.businessentityid = p.businessentityid)))
     LEFT JOIN person.personphone pp ON ((pp.businessentityid = p.businessentityid)))
     LEFT JOIN person.phonenumbertype pnt ON ((pnt.phonenumbertypeid = pp.phonenumbertypeid)));


ALTER TABLE sales.vsalesperson OWNER TO postgres;

--
-- Name: vsalespersonsalesbyfiscalyears; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vsalespersonsalesbyfiscalyears AS
 SELECT salestotal."SalesPersonID",
    salestotal."FullName",
    salestotal."JobTitle",
    salestotal."SalesTerritory",
    salestotal."2012",
    salestotal."2013",
    salestotal."2014"
   FROM public.crosstab('SELECT
    SalesPersonID
    ,FullName
    ,JobTitle
    ,SalesTerritory
    ,FiscalYear
    ,SalesTotal
FROM Sales.vSalesPersonSalesByFiscalYearsData
ORDER BY 2,4'::text, 'SELECT unnest(''{2012,2013,2014}''::text[])'::text) salestotal("SalesPersonID" integer, "FullName" text, "JobTitle" text, "SalesTerritory" text, "2012" numeric(12,4), "2013" numeric(12,4), "2014" numeric(12,4));


ALTER TABLE sales.vsalespersonsalesbyfiscalyears OWNER TO postgres;

--
-- Name: vsalespersonsalesbyfiscalyearsdata; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vsalespersonsalesbyfiscalyearsdata AS
 SELECT granular.salespersonid,
    granular.fullname,
    granular.jobtitle,
    granular.salesterritory,
    sum(granular.subtotal) AS salestotal,
    granular.fiscalyear
   FROM ( SELECT soh.salespersonid,
            ((((p.firstname)::text || ' '::text) || COALESCE(((p.middlename)::text || ' '::text), ''::text)) || (p.lastname)::text) AS fullname,
            e.jobtitle,
            st.name AS salesterritory,
            soh.subtotal,
            date_part('year'::text, (soh.orderdate + '6 mons'::interval)) AS fiscalyear
           FROM ((((sales.salesperson sp
             JOIN sales.salesorderheader soh ON ((sp.businessentityid = soh.salespersonid)))
             JOIN sales.salesterritory st ON ((sp.territoryid = st.territoryid)))
             JOIN humanresources.employee e ON ((soh.salespersonid = e.businessentityid)))
             JOIN person.person p ON ((p.businessentityid = sp.businessentityid)))) granular
  GROUP BY granular.salespersonid, granular.fullname, granular.jobtitle, granular.salesterritory, granular.fiscalyear;


ALTER TABLE sales.vsalespersonsalesbyfiscalyearsdata OWNER TO postgres;

--
-- Name: vstorewithaddresses; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vstorewithaddresses AS
 SELECT s.businessentityid,
    s.name,
    at.name AS addresstype,
    a.addressline1,
    a.addressline2,
    a.city,
    sp.name AS stateprovincename,
    a.postalcode,
    cr.name AS countryregionname
   FROM (((((sales.store s
     JOIN person.businessentityaddress bea ON ((bea.businessentityid = s.businessentityid)))
     JOIN person.address a ON ((a.addressid = bea.addressid)))
     JOIN person.stateprovince sp ON ((sp.stateprovinceid = a.stateprovinceid)))
     JOIN person.countryregion cr ON (((cr.countryregioncode)::text = (sp.countryregioncode)::text)))
     JOIN person.addresstype at ON ((at.addresstypeid = bea.addresstypeid)));


ALTER TABLE sales.vstorewithaddresses OWNER TO postgres;

--
-- Name: vstorewithcontacts; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vstorewithcontacts AS
 SELECT s.businessentityid,
    s.name,
    ct.name AS contacttype,
    p.title,
    p.firstname,
    p.middlename,
    p.lastname,
    p.suffix,
    pp.phonenumber,
    pnt.name AS phonenumbertype,
    ea.emailaddress,
    p.emailpromotion
   FROM ((((((sales.store s
     JOIN person.businessentitycontact bec ON ((bec.businessentityid = s.businessentityid)))
     JOIN person.contacttype ct ON ((ct.contacttypeid = bec.contacttypeid)))
     JOIN person.person p ON ((p.businessentityid = bec.personid)))
     LEFT JOIN person.emailaddress ea ON ((ea.businessentityid = p.businessentityid)))
     LEFT JOIN person.personphone pp ON ((pp.businessentityid = p.businessentityid)))
     LEFT JOIN person.phonenumbertype pnt ON ((pnt.phonenumbertypeid = pp.phonenumbertypeid)));


ALTER TABLE sales.vstorewithcontacts OWNER TO postgres;

--
-- Name: vstorewithdemographics; Type: VIEW; Schema: sales; Owner: postgres
--

CREATE VIEW sales.vstorewithdemographics AS
 SELECT store.businessentityid,
    store.name,
    ((unnest(xpath('/ns:StoreSurvey/ns:AnnualSales/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying)::money AS "AnnualSales",
    ((unnest(xpath('/ns:StoreSurvey/ns:AnnualRevenue/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying)::money AS "AnnualRevenue",
    (unnest(xpath('/ns:StoreSurvey/ns:BankName/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying(50) AS "BankName",
    (unnest(xpath('/ns:StoreSurvey/ns:BusinessType/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying(5) AS "BusinessType",
    ((unnest(xpath('/ns:StoreSurvey/ns:YearOpened/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying)::integer AS "YearOpened",
    (unnest(xpath('/ns:StoreSurvey/ns:Specialty/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying(50) AS "Specialty",
    ((unnest(xpath('/ns:StoreSurvey/ns:SquareFeet/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying)::integer AS "SquareFeet",
    (unnest(xpath('/ns:StoreSurvey/ns:Brands/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying(30) AS "Brands",
    (unnest(xpath('/ns:StoreSurvey/ns:Internet/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying(30) AS "Internet",
    ((unnest(xpath('/ns:StoreSurvey/ns:NumberEmployees/text()'::text, store.demographics, '{{ns,http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/StoreSurvey}}'::text[])))::character varying)::integer AS "NumberEmployees"
   FROM sales.store;


ALTER TABLE sales.vstorewithdemographics OWNER TO postgres;

--
-- Name: department departmentid; Type: DEFAULT; Schema: humanresources; Owner: postgres
--

ALTER TABLE ONLY humanresources.department ALTER COLUMN departmentid SET DEFAULT nextval('humanresources.department_departmentid_seq'::regclass);


--
-- Name: jobcandidate jobcandidateid; Type: DEFAULT; Schema: humanresources; Owner: postgres
--

ALTER TABLE ONLY humanresources.jobcandidate ALTER COLUMN jobcandidateid SET DEFAULT nextval('humanresources.jobcandidate_jobcandidateid_seq'::regclass);


--
-- Name: shift shiftid; Type: DEFAULT; Schema: humanresources; Owner: postgres
--

ALTER TABLE ONLY humanresources.shift ALTER COLUMN shiftid SET DEFAULT nextval('humanresources.shift_shiftid_seq'::regclass);


--
-- Name: address addressid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.address ALTER COLUMN addressid SET DEFAULT nextval('person.address_addressid_seq'::regclass);


--
-- Name: addresstype addresstypeid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.addresstype ALTER COLUMN addresstypeid SET DEFAULT nextval('person.addresstype_addresstypeid_seq'::regclass);


--
-- Name: businessentity businessentityid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.businessentity ALTER COLUMN businessentityid SET DEFAULT nextval('person.businessentity_businessentityid_seq'::regclass);


--
-- Name: contacttype contacttypeid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.contacttype ALTER COLUMN contacttypeid SET DEFAULT nextval('person.contacttype_contacttypeid_seq'::regclass);


--
-- Name: emailaddress emailaddressid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.emailaddress ALTER COLUMN emailaddressid SET DEFAULT nextval('person.emailaddress_emailaddressid_seq'::regclass);


--
-- Name: phonenumbertype phonenumbertypeid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.phonenumbertype ALTER COLUMN phonenumbertypeid SET DEFAULT nextval('person.phonenumbertype_phonenumbertypeid_seq'::regclass);


--
-- Name: stateprovince stateprovinceid; Type: DEFAULT; Schema: person; Owner: postgres
--

ALTER TABLE ONLY person.stateprovince ALTER COLUMN stateprovinceid SET DEFAULT nextval('person.stateprovince_stateprovinceid_seq'::regclass);


--
-- Name: billofmaterials billofmaterialsid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.billofmaterials ALTER COLUMN billofmaterialsid SET DEFAULT nextval('production.billofmaterials_billofmaterialsid_seq'::regclass);


--
-- Name: illustration illustrationid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.illustration ALTER COLUMN illustrationid SET DEFAULT nextval('production.illustration_illustrationid_seq'::regclass);


--
-- Name: location locationid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.location ALTER COLUMN locationid SET DEFAULT nextval('production.location_locationid_seq'::regclass);


--
-- Name: product productid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.product ALTER COLUMN productid SET DEFAULT nextval('production.product_productid_seq'::regclass);


--
-- Name: productcategory productcategoryid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productcategory ALTER COLUMN productcategoryid SET DEFAULT nextval('production.productcategory_productcategoryid_seq'::regclass);


--
-- Name: productdescription productdescriptionid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productdescription ALTER COLUMN productdescriptionid SET DEFAULT nextval('production.productdescription_productdescriptionid_seq'::regclass);


--
-- Name: productmodel productmodelid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productmodel ALTER COLUMN productmodelid SET DEFAULT nextval('production.productmodel_productmodelid_seq'::regclass);


--
-- Name: productphoto productphotoid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productphoto ALTER COLUMN productphotoid SET DEFAULT nextval('production.productphoto_productphotoid_seq'::regclass);


--
-- Name: productreview productreviewid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productreview ALTER COLUMN productreviewid SET DEFAULT nextval('production.productreview_productreviewid_seq'::regclass);


--
-- Name: productsubcategory productsubcategoryid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.productsubcategory ALTER COLUMN productsubcategoryid SET DEFAULT nextval('production.productsubcategory_productsubcategoryid_seq'::regclass);


--
-- Name: scrapreason scrapreasonid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.scrapreason ALTER COLUMN scrapreasonid SET DEFAULT nextval('production.scrapreason_scrapreasonid_seq'::regclass);


--
-- Name: transactionhistory transactionid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.transactionhistory ALTER COLUMN transactionid SET DEFAULT nextval('production.transactionhistory_transactionid_seq'::regclass);


--
-- Name: workorder workorderid; Type: DEFAULT; Schema: production; Owner: postgres
--

ALTER TABLE ONLY production.workorder ALTER COLUMN workorderid SET DEFAULT nextval('production.workorder_workorderid_seq'::regclass);


--
-- Name: purchaseorderdetail purchaseorderdetailid; Type: DEFAULT; Schema: purchasing; Owner: postgres
--

ALTER TABLE ONLY purchasing.purchaseorderdetail ALTER COLUMN purchaseorderdetailid SET DEFAULT nextval('purchasing.purchaseorderdetail_purchaseorderdetailid_seq'::regclass);


--
-- Name: purchaseorderheader purchaseorderid; Type: DEFAULT; Schema: purchasing; Owner: postgres
--

ALTER TABLE ONLY purchasing.purchaseorderheader ALTER COLUMN purchaseorderid SET DEFAULT nextval('purchasing.purchaseorderheader_purchaseorderid_seq'::regclass);


--
-- Name: shipmethod shipmethodid; Type: DEFAULT; Schema: purchasing; Owner: postgres
--

ALTER TABLE ONLY purchasing.shipmethod ALTER COLUMN shipmethodid SET DEFAULT nextval('purchasing.shipmethod_shipmethodid_seq'::regclass);


--
-- Name: creditcard creditcardid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.creditcard ALTER COLUMN creditcardid SET DEFAULT nextval('sales.creditcard_creditcardid_seq'::regclass);


--
-- Name: currencyrate currencyrateid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.currencyrate ALTER COLUMN currencyrateid SET DEFAULT nextval('sales.currencyrate_currencyrateid_seq'::regclass);


--
-- Name: customer customerid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.customer ALTER COLUMN customerid SET DEFAULT nextval('sales.customer_customerid_seq'::regclass);


--
-- Name: salesorderdetail salesorderdetailid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.salesorderdetail ALTER COLUMN salesorderdetailid SET DEFAULT nextval('sales.salesorderdetail_salesorderdetailid_seq'::regclass);


--
-- Name: salesorderheader salesorderid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.salesorderheader ALTER COLUMN salesorderid SET DEFAULT nextval('sales.salesorderheader_salesorderid_seq'::regclass);


--
-- Name: salesreason salesreasonid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.salesreason ALTER COLUMN salesreasonid SET DEFAULT nextval('sales.salesreason_salesreasonid_seq'::regclass);


--
-- Name: salestaxrate salestaxrateid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.salestaxrate ALTER COLUMN salestaxrateid SET DEFAULT nextval('sales.salestaxrate_salestaxrateid_seq'::regclass);


--
-- Name: salesterritory territoryid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.salesterritory ALTER COLUMN territoryid SET DEFAULT nextval('sales.salesterritory_territoryid_seq'::regclass);


--
-- Name: shoppingcartitem shoppingcartitemid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.shoppingcartitem ALTER COLUMN shoppingcartitemid SET DEFAULT nextval('sales.shoppingcartitem_shoppingcartitemid_seq'::regclass);


--
-- Name: specialoffer specialofferid; Type: DEFAULT; Schema: sales; Owner: postgres
--

ALTER TABLE ONLY sales.specialoffer ALTER COLUMN specialofferid SET DEFAULT nextval('sales.specialoffer_specialofferid_seq'::regclass);


--
-- Data for Name: department; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.department (departmentid, name, groupname, modifieddate) FROM stdin;
1	Engineering	Research and Development	2008-04-30 00:00:00
2	Tool Design	Research and Development	2008-04-30 00:00:00
3	Sales	Sales and Marketing	2008-04-30 00:00:00
4	Marketing	Sales and Marketing	2008-04-30 00:00:00
5	Purchasing	Inventory Management	2008-04-30 00:00:00
6	Research and Development	Research and Development	2008-04-30 00:00:00
7	Production	Manufacturing	2008-04-30 00:00:00
8	Production Control	Manufacturing	2008-04-30 00:00:00
9	Human Resources	Executive General and Administration	2008-04-30 00:00:00
10	Finance	Executive General and Administration	2008-04-30 00:00:00
11	Information Services	Executive General and Administration	2008-04-30 00:00:00
12	Document Control	Quality Assurance	2008-04-30 00:00:00
13	Quality Assurance	Quality Assurance	2008-04-30 00:00:00
14	Facilities and Maintenance	Executive General and Administration	2008-04-30 00:00:00
15	Shipping and Receiving	Inventory Management	2008-04-30 00:00:00
16	Executive	Executive General and Administration	2008-04-30 00:00:00
\.


--
-- Data for Name: employee; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.employee (businessentityid, nationalidnumber, loginid, jobtitle, birthdate, maritalstatus, gender, hiredate, salariedflag, vacationhours, sickleavehours, currentflag, rowguid, modifieddate, organizationnode) FROM stdin;
1	295847284	adventure-works\\ken0	Chief Executive Officer	1969-01-29	S	M	2009-01-14	t	99	69	t	f01251e5-96a3-448d-981e-0f99d789110d	2014-06-30 00:00:00	/
2	245797967	adventure-works\\terri0	Vice President of Engineering	1971-08-01	S	F	2008-01-31	t	1	20	t	45e8f437-670d-4409-93cb-f9424a40d6ee	2014-06-30 00:00:00	/1/
3	509647174	adventure-works\\roberto0	Engineering Manager	1974-11-12	M	M	2007-11-11	t	2	21	t	9bbbfb2c-efbb-4217-9ab7-f97689328841	2014-06-30 00:00:00	/1/1/
4	112457891	adventure-works\\rob0	Senior Tool Designer	1974-12-23	S	M	2007-12-05	f	48	80	t	59747955-87b8-443f-8ed4-f8ad3afdf3a9	2014-06-30 00:00:00	/1/1/1/
5	695256908	adventure-works\\gail0	Design Engineer	1952-09-27	M	F	2008-01-06	t	5	22	t	ec84ae09-f9b8-4a15-b4a9-6ccbab919b08	2014-06-30 00:00:00	/1/1/2/
6	998320692	adventure-works\\jossef0	Design Engineer	1959-03-11	M	M	2008-01-24	t	6	23	t	e39056f1-9cd5-478d-8945-14aca7fbdcdd	2014-06-30 00:00:00	/1/1/3/
7	134969118	adventure-works\\dylan0	Research and Development Manager	1987-02-24	M	M	2009-02-08	t	61	50	t	4f46deca-ef01-41fd-9829-0adab368e431	2014-06-30 00:00:00	/1/1/4/
8	811994146	adventure-works\\diane1	Research and Development Engineer	1986-06-05	S	F	2008-12-29	t	62	51	t	31112635-663b-4018-b4a2-a685c0bf48a4	2014-06-30 00:00:00	/1/1/4/1/
9	658797903	adventure-works\\gigi0	Research and Development Engineer	1979-01-21	M	F	2009-01-16	t	63	51	t	50b6cdc6-7570-47ef-9570-48a64b5f2ecf	2014-06-30 00:00:00	/1/1/4/2/
10	879342154	adventure-works\\michael6	Research and Development Manager	1984-11-30	M	M	2009-05-03	t	16	64	t	eaa43680-5571-40cb-ab1a-3bf68f04459e	2014-06-30 00:00:00	/1/1/4/3/
11	974026903	adventure-works\\ovidiu0	Senior Tool Designer	1978-01-17	S	M	2010-12-05	f	7	23	t	f68c7c19-fac1-438c-9bb7-ac33fcc341c3	2014-06-30 00:00:00	/1/1/5/
12	480168528	adventure-works\\thierry0	Tool Designer	1959-07-29	M	M	2007-12-11	f	9	24	t	1d955171-e773-4fad-8382-40fd898d5d4d	2014-06-30 00:00:00	/1/1/5/1/
13	486228782	adventure-works\\janice0	Tool Designer	1989-05-28	M	F	2010-12-23	f	8	24	t	954b91b6-5aa7-48c2-8685-6e11c6e5c49a	2014-06-30 00:00:00	/1/1/5/2/
14	42487730	adventure-works\\michael8	Senior Design Engineer	1979-06-16	S	M	2010-12-30	t	3	21	t	46286ca4-46dd-4ddb-9128-85b67e98d1a9	2014-06-30 00:00:00	/1/1/6/
15	56920285	adventure-works\\sharon0	Design Engineer	1961-05-02	M	F	2011-01-18	t	4	22	t	54f2fdc0-87c4-4065-a7a8-9ac8ea624235	2014-06-30 00:00:00	/1/1/7/
16	24756624	adventure-works\\david0	Marketing Manager	1975-03-19	S	M	2007-12-20	t	40	40	t	e87029aa-2cba-4c03-b948-d83af0313e28	2014-06-30 00:00:00	/2/
17	253022876	adventure-works\\kevin0	Marketing Assistant	1987-05-03	S	M	2007-01-26	f	42	41	t	1b480240-95c0-410f-a717-eb29943c8886	2014-06-30 00:00:00	/2/1/
18	222969461	adventure-works\\john5	Marketing Specialist	1978-03-06	S	M	2011-02-07	f	48	44	t	64730415-1f58-4e5b-8fa8-5e4daeba53b4	2014-06-30 00:00:00	/2/2/
19	52541318	adventure-works\\mary2	Marketing Assistant	1978-01-29	S	F	2011-02-14	f	43	41	t	1f6da901-c7f7-48a8-8eef-d81868d72b52	2014-06-30 00:00:00	/2/3/
20	323403273	adventure-works\\wanida0	Marketing Assistant	1975-03-17	M	F	2011-01-07	f	41	40	t	43cca446-da1c-454c-8530-873ad2923e1b	2014-06-30 00:00:00	/2/4/
21	243322160	adventure-works\\terry0	Marketing Specialist	1986-02-04	M	M	2009-03-02	f	44	42	t	ad0d7626-4506-45c4-898f-9d7a0e13aabd	2014-06-30 00:00:00	/2/5/
22	95958330	adventure-works\\sariya0	Marketing Specialist	1987-05-21	S	M	2008-12-12	f	45	42	t	af21f1b7-0691-48ad-b325-b8f2d7b2268a	2014-06-30 00:00:00	/2/6/
23	767955365	adventure-works\\mary0	Marketing Specialist	1962-09-13	M	F	2009-01-12	f	46	43	t	90899830-127e-4876-85ca-7f6e03025281	2014-06-30 00:00:00	/2/7/
24	72636981	adventure-works\\jill0	Marketing Specialist	1979-06-18	M	F	2009-01-18	f	47	43	t	53575c58-fba1-4c1a-b8ff-95e050b44393	2014-06-30 00:00:00	/2/8/
25	519899904	adventure-works\\james1	Vice President of Production	1983-01-07	S	M	2009-02-03	t	64	52	t	d7314f24-2af1-429c-9bbb-4038f45f3e6c	2014-06-30 00:00:00	/3/
26	277173473	adventure-works\\peter0	Production Control Manager	1982-11-03	M	M	2008-12-01	t	43	41	t	69d5d162-e817-45e7-9dec-5d9b8310e7b1	2014-12-26 09:17:08.637	/3/1/
27	446466105	adventure-works\\jo0	Production Supervisor - WC60	1956-10-08	S	F	2008-02-27	f	80	60	t	83ffaac6-b895-481f-b897-14f965d4da47	2014-06-30 00:00:00	/3/1/1/
28	14417807	adventure-works\\guy1	Production Technician - WC60	1988-03-13	M	M	2006-06-30	f	21	30	t	aae1d04a-c237-4974-b4d5-935247737718	2014-06-30 00:00:00	/3/1/1/1/
29	948320468	adventure-works\\mark1	Production Technician - WC60	1979-09-25	S	M	2009-01-23	f	19	29	t	cdb2c6df-93e5-4558-91c8-424d5e7c658b	2014-06-30 00:00:00	/3/1/1/2/
30	410742000	adventure-works\\britta0	Production Technician - WC60	1989-09-28	M	F	2009-01-29	f	14	27	t	fc12677f-42f8-4790-ad69-685088ed7e5f	2014-06-30 00:00:00	/3/1/1/3/
31	750246141	adventure-works\\margie0	Production Technician - WC60	1986-05-20	M	F	2009-01-04	f	18	29	t	352d6e2f-655b-49a2-9fec-efd7d8cd0d30	2014-06-30 00:00:00	/3/1/1/4/
32	330211482	adventure-works\\rebecca0	Production Technician - WC60	1977-07-10	M	F	2008-12-29	f	23	31	t	bdadeb5c-a596-4da1-88ba-842c7a0cc10f	2014-06-30 00:00:00	/3/1/1/5/
33	801758002	adventure-works\\annik0	Production Technician - WC60	1976-12-26	M	M	2008-12-17	f	17	28	t	51fde6ac-bd50-467c-90e5-10ca7310455c	2014-06-30 00:00:00	/3/1/1/6/
34	754372876	adventure-works\\suchitra0	Production Technician - WC60	1987-06-10	M	F	2009-02-16	f	15	27	t	6adbd932-0da5-4f5c-af67-8e3a53630896	2014-06-30 00:00:00	/3/1/1/7/
35	999440576	adventure-works\\brandon0	Production Technician - WC60	1977-01-10	M	M	2009-02-08	f	22	31	t	ca5d1935-44e2-4c45-93bb-809e59f56796	2014-06-30 00:00:00	/3/1/1/8/
36	788456780	adventure-works\\jose0	Production Technician - WC60	1984-07-31	M	M	2009-02-10	f	20	30	t	9e912556-88ba-41ee-b946-cb84ab4c1102	2014-06-30 00:00:00	/3/1/1/9/
37	442121106	adventure-works\\chris2	Production Technician - WC60	1986-08-07	S	M	2009-03-07	f	16	28	t	77b384c7-affb-4816-992b-f5b3034ee4ff	2014-06-30 00:00:00	/3/1/1/10/
38	6298838	adventure-works\\kim1	Production Technician - WC60	1966-12-14	M	F	2010-01-16	f	24	32	t	891c27f4-28cc-44bb-bea3-da5ea7fbe957	2014-06-30 00:00:00	/3/1/1/11/
39	461786517	adventure-works\\ed0	Production Technician - WC60	1971-09-11	S	M	2010-02-05	f	25	32	t	8ef22fb3-af37-4b44-8862-d60a7cb09d82	2014-06-30 00:00:00	/3/1/1/12/
40	309738752	adventure-works\\jolynn0	Production Supervisor - WC60	1956-01-16	S	F	2007-12-26	f	82	61	t	2cc71b96-f421-485e-9832-8723337749bb	2014-06-30 00:00:00	/3/1/2/
41	458159238	adventure-works\\bryan0	Production Technician - WC60	1973-08-27	S	M	2009-01-21	f	35	37	t	4652d4e4-6a27-47ed-9f51-c377e293da28	2014-06-30 00:00:00	/3/1/2/1/
42	339712426	adventure-works\\james0	Production Technician - WC60	1984-07-25	M	M	2008-12-27	f	39	39	t	82e52d5a-165b-4c6d-9773-c3a6b6332ecd	2014-06-30 00:00:00	/3/1/2/2/
43	693325305	adventure-works\\nancy0	Production Technician - WC60	1988-11-19	M	F	2009-01-02	f	34	37	t	6b7eb306-9a00-496a-98a9-4e94fe72f77c	2014-06-30 00:00:00	/3/1/2/3/
44	276751903	adventure-works\\simon0	Production Technician - WC60	1990-05-17	S	M	2008-12-08	f	38	39	t	f734d38a-56b5-471e-8ded-a682e958a9b3	2014-06-30 00:00:00	/3/1/2/4/
45	500412746	adventure-works\\thomas0	Production Technician - WC60	1986-01-10	M	M	2009-02-26	f	37	38	t	8ff3af67-32f2-4a08-98c3-a40f842d41a3	2014-06-30 00:00:00	/3/1/2/5/
46	66073987	adventure-works\\eugene1	Production Technician - WC60	1976-02-10	S	M	2009-02-08	f	36	38	t	33543b35-77da-4600-a41b-1eafea0ad643	2014-06-30 00:00:00	/3/1/2/6/
47	33237992	adventure-works\\andrew0	Production Supervisor - WC10	1988-09-06	S	M	2009-02-22	f	65	52	t	08365b05-c143-4260-a93c-6b69418b1946	2014-06-30 00:00:00	/3/1/3/
48	690627818	adventure-works\\ruth0	Production Technician - WC10	1956-06-04	M	F	2008-01-06	f	83	61	t	3e3b6905-209e-442e-b8a8-9a0980241c6a	2014-06-30 00:00:00	/3/1/3/1/
49	912265825	adventure-works\\barry0	Production Technician - WC10	1956-03-26	S	M	2008-01-07	f	88	64	t	756a60ae-378f-43d8-9f93-1e821d1eaf52	2014-06-30 00:00:00	/3/1/3/2/
50	844973625	adventure-works\\sidney0	Production Technician - WC10	1956-08-30	M	M	2008-02-02	f	84	62	t	40d603d9-7f99-48b7-a580-b17cf429bed2	2014-06-30 00:00:00	/3/1/3/3/
51	132674823	adventure-works\\jeffrey0	Production Technician - WC10	1956-07-11	S	M	2008-02-20	f	85	62	t	6e086f41-b81d-4bdc-9f13-0eec488dc43e	2014-06-30 00:00:00	/3/1/3/4/
52	565090917	adventure-works\\doris0	Production Technician - WC10	1956-04-04	M	F	2008-03-10	f	86	63	t	692b8826-03b4-4c3b-82fc-1fc6f1409689	2014-06-30 00:00:00	/3/1/3/5/
53	9659517	adventure-works\\diane0	Production Technician - WC10	1956-03-29	M	F	2008-03-28	f	87	63	t	c334b2d2-0c56-4906-9095-f1d07a98cbec	2014-06-30 00:00:00	/3/1/3/6/
54	109272464	adventure-works\\bonnie0	Production Technician - WC10	1986-09-10	M	F	2010-01-01	f	89	64	t	e950a52a-df61-4fec-9063-545664d65b89	2014-06-30 00:00:00	/3/1/3/7/
55	233069302	adventure-works\\taylor0	Production Supervisor - WC50	1956-04-01	M	M	2008-02-08	f	79	59	t	28f7ef89-2793-4989-b67d-25046543c1e3	2014-06-30 00:00:00	/3/1/4/
56	652535724	adventure-works\\denise0	Production Technician - WC50	1988-07-06	M	F	2009-02-05	f	9	24	t	77878c43-f16e-437d-892f-3cfcc0715a0a	2014-06-30 00:00:00	/3/1/4/1/
57	10708100	adventure-works\\frank1	Production Technician - WC50	1971-07-24	S	M	2009-02-23	f	10	25	t	b395cd84-77ba-4d3c-a49d-d9e8d6cf100b	2014-06-30 00:00:00	/3/1/4/2/
58	571658797	adventure-works\\kendall0	Production Technician - WC50	1986-05-30	M	M	2008-12-05	f	11	25	t	65207627-5521-4a8e-ad3c-b2f1b5226b85	2014-06-30 00:00:00	/3/1/4/3/
59	843479922	adventure-works\\bob0	Production Technician - WC50	1979-08-16	S	M	2008-12-24	f	12	26	t	68616aea-81e5-4940-a7e4-6fba882bccf6	2014-06-30 00:00:00	/3/1/4/4/
60	827686041	adventure-works\\pete0	Production Technician - WC50	1977-02-03	S	M	2009-01-11	f	13	26	t	1f1d813d-3edc-4274-8e9b-4519d71685b6	2014-06-30 00:00:00	/3/1/4/5/
61	92096924	adventure-works\\diane2	Production Technician - WC50	1989-08-09	S	F	2009-01-18	f	8	24	t	721a2921-c415-46de-9111-13f25f428b8b	2014-06-30 00:00:00	/3/1/4/6/
62	494170342	adventure-works\\john0	Production Supervisor - WC60	1956-08-07	M	M	2008-03-17	f	81	60	t	d4ed1f78-7c28-479b-bfef-a73228ba2aaa	2014-06-30 00:00:00	/3/1/5/
63	414476027	adventure-works\\maciej0	Production Technician - WC60	1955-01-30	S	M	2010-01-29	f	30	35	t	3229d93f-6a14-4bac-abc5-a91b9ecfb4d3	2014-06-30 00:00:00	/3/1/5/1/
64	582347317	adventure-works\\michael7	Production Technician - WC60	1973-09-05	S	M	2010-02-23	f	26	33	t	492b24bd-bde9-4371-b96e-ccd72264b91f	2014-06-30 00:00:00	/3/1/5/2/
65	8066363	adventure-works\\randy0	Production Technician - WC60	1970-04-28	M	M	2010-02-23	f	29	34	t	9a08108d-e039-4862-8f93-55f18017ad72	2014-06-30 00:00:00	/3/1/5/3/
66	834186596	adventure-works\\karan0	Production Technician - WC60	1970-03-07	S	M	2009-12-22	f	28	34	t	08b1ba74-dd80-4fda-8327-93268b84977b	2014-06-30 00:00:00	/3/1/5/4/
67	63179277	adventure-works\\jay0	Production Technician - WC60	1976-02-11	S	M	2009-03-05	f	32	36	t	18187809-5294-474f-85a1-d5be6bd518d6	2014-06-30 00:00:00	/3/1/5/5/
68	537092325	adventure-works\\charles0	Production Technician - WC60	1971-09-02	S	M	2009-12-03	f	27	33	t	cdc11292-df74-4fb0-8676-5b2aa4687142	2014-06-30 00:00:00	/3/1/5/6/
69	752513276	adventure-works\\steve0	Production Technician - WC60	1991-04-06	S	M	2009-02-15	f	31	35	t	12f678d7-ead3-4cf4-8518-a19aacf2a6d4	2014-06-30 00:00:00	/3/1/5/7/
70	36151748	adventure-works\\david2	Production Technician - WC60	1984-12-29	M	M	2008-12-15	f	33	36	t	fc617bb8-d2a3-4374-873c-8ef38d80127d	2014-06-30 00:00:00	/3/1/5/8/
71	578935259	adventure-works\\michael3	Production Supervisor - WC30	1989-01-29	S	M	2009-02-15	f	70	55	t	1ad772d7-7b4a-4a7b-8676-49dd7608cb94	2014-06-30 00:00:00	/3/1/6/
72	443968955	adventure-works\\steven0	Production Technician - WC30	1977-05-14	M	M	2008-12-01	f	41	40	t	0a8937c9-68aa-4d48-ba4e-b40493d764aa	2014-06-30 00:00:00	/3/1/6/1/
73	138280935	adventure-works\\carole0	Production Technician - WC30	1983-10-19	M	F	2008-12-19	f	42	41	t	c76a41f1-a390-4ae4-a82a-2a87764c6391	2014-06-30 00:00:00	/3/1/6/2/
74	420023788	adventure-works\\bjorn0	Production Technician - WC30	1989-11-06	S	M	2009-01-07	f	43	41	t	a942e1e0-2d5e-4858-97c0-947020e96860	2014-06-30 00:00:00	/3/1/6/3/
75	363996959	adventure-works\\michiko0	Production Technician - WC30	1982-06-27	S	M	2009-01-26	f	44	42	t	f359f5b6-5e18-4c62-8531-14d951911ce5	2014-06-30 00:00:00	/3/1/6/4/
76	227319668	adventure-works\\carol0	Production Technician - WC30	1988-10-17	M	F	2009-02-12	f	45	42	t	8d0182a3-5b59-4eea-9b3c-c7f05da9a2ce	2014-06-30 00:00:00	/3/1/6/5/
77	301435199	adventure-works\\merav0	Production Technician - WC30	1983-05-13	M	F	2009-03-03	f	46	43	t	2ee7914a-62d3-473b-a0e1-e4e55341ec4e	2014-06-30 00:00:00	/3/1/6/6/
78	370989364	adventure-works\\reuben0	Production Supervisor - WC40	1987-08-27	M	M	2008-12-15	f	72	56	t	71eee2a6-b9b3-4bf4-8949-01239df7c901	2014-06-30 00:00:00	/3/1/7/
79	697712387	adventure-works\\eric1	Production Technician - WC40	1966-12-08	M	M	2010-01-24	f	60	50	t	55f62e38-9457-46c8-a824-e46a3117a935	2014-06-30 00:00:00	/3/1/7/1/
80	943170460	adventure-works\\sandeep0	Production Technician - WC40	1970-12-03	S	M	2010-01-17	f	65	52	t	606c21e2-3ec0-48a6-a9fe-6bc8123ac786	2014-06-30 00:00:00	/3/1/7/2/
81	413787783	adventure-works\\mihail0	Production Technician - WC40	1971-03-09	S	M	2009-12-29	f	64	52	t	03a9ba14-0d5b-4671-b851-2c1721efbf01	2014-06-30 00:00:00	/3/1/7/3/
82	58791499	adventure-works\\jack1	Production Technician - WC40	1973-08-29	S	M	2010-03-03	f	62	51	t	d308d387-f7f3-4b5f-abda-faf5574245cd	2014-06-30 00:00:00	/3/1/7/4/
83	988315686	adventure-works\\patrick1	Production Technician - WC40	1973-12-23	M	M	2010-02-12	f	61	50	t	296c52ae-169f-4292-975d-c508476dcecf	2014-06-30 00:00:00	/3/1/7/5/
84	947029962	adventure-works\\frank3	Production Technician - WC40	1952-03-02	M	M	2010-02-05	f	66	53	t	9af24acc-ea3e-4efe-b5e3-4762c496d57c	2014-06-30 00:00:00	/3/1/7/6/
85	1662732	adventure-works\\brian2	Production Technician - WC40	1970-12-23	S	M	2009-12-11	f	63	51	t	c294f676-caaf-4924-9730-bc81ae408be1	2014-06-30 00:00:00	/3/1/7/7/
86	769680433	adventure-works\\ryan0	Production Technician - WC40	1972-06-13	M	M	2009-01-05	f	59	49	t	10e5bd6f-2b9c-4192-a94d-6a2d50ea1adb	2014-06-30 00:00:00	/3/1/7/8/
87	7201901	adventure-works\\cristian0	Production Supervisor - WC10	1984-04-11	M	M	2008-12-22	f	67	53	t	5be16416-8570-417d-9e54-047db468b5e9	2014-06-30 00:00:00	/3/1/8/
88	294148271	adventure-works\\betsy0	Production Technician - WC10	1966-12-17	S	F	2009-12-18	f	99	69	t	ebcdba1c-6c1d-4d36-90f7-1893755c85e3	2014-06-30 00:00:00	/3/1/8/1/
89	90888098	adventure-works\\patrick0	Production Technician - WC10	1986-09-10	S	M	2010-02-01	f	96	68	t	d5fbe9e6-b8c5-484c-b4b8-48059e0ef267	2014-06-30 00:00:00	/3/1/8/2/
90	82638150	adventure-works\\danielle0	Production Technician - WC10	1986-09-07	S	F	2010-02-20	f	97	68	t	bb886159-1400-4264-b7c9-a3769beb1274	2014-06-30 00:00:00	/3/1/8/3/
91	390124815	adventure-works\\kimberly0	Production Technician - WC10	1986-09-13	S	F	2010-01-12	f	95	67	t	ce256b6c-1eee-43ed-9969-7cac480ff4d7	2014-06-30 00:00:00	/3/1/8/4/
92	826454897	adventure-works\\tom0	Production Technician - WC10	1986-10-01	M	M	2010-03-10	f	98	69	t	b3bf7fc5-2014-48ce-b7bb-76124fa8446c	2014-06-30 00:00:00	/3/1/8/5/
93	778552911	adventure-works\\kok-ho0	Production Supervisor - WC50	1980-04-28	S	M	2008-12-27	f	78	59	t	57fb2c0f-b105-49f0-967a-88f3d743cb3f	2014-06-30 00:00:00	/3/1/9/
94	718299860	adventure-works\\russell0	Production Technician - WC50	1972-11-25	M	M	2008-12-12	f	6	23	t	6b10192f-d570-47c4-82c9-3d979b1efdc1	2014-06-30 00:00:00	/3/1/9/1/
95	674171828	adventure-works\\jim0	Production Technician - WC50	1986-09-08	M	M	2008-12-19	f	1	20	t	6175876e-8fcc-4917-be06-fc358515e6df	2014-06-30 00:00:00	/3/1/9/2/
96	912141525	adventure-works\\elizabeth0	Production Technician - WC50	1990-01-25	M	F	2009-03-02	f	5	22	t	62a9f73f-6443-4f2f-b864-18186614bfb6	2014-06-30 00:00:00	/3/1/9/3/
97	370581729	adventure-works\\mandar0	Production Technician - WC50	1986-03-21	S	M	2009-02-10	f	0	20	t	1f0e068a-48c5-40bf-8190-565150efdadd	2014-06-30 00:00:00	/3/1/9/4/
98	152085091	adventure-works\\sameer0	Production Technician - WC50	1978-06-26	M	M	2009-02-11	f	4	22	t	a703169f-1563-488e-914d-d784fd07f29a	2014-06-30 00:00:00	/3/1/9/5/
99	431859843	adventure-works\\nuan0	Production Technician - WC50	1979-03-29	S	M	2009-01-06	f	2	21	t	a6089357-2f2f-48cc-ab3c-d9b75a3c09d7	2014-06-30 00:00:00	/3/1/9/6/
100	204035155	adventure-works\\lolan0	Production Technician - WC50	1973-01-24	M	M	2009-01-12	f	7	23	t	9b9b768d-7cc1-4dce-87cb-765ab73a6aff	2014-06-30 00:00:00	/3/1/9/7/
101	153288994	adventure-works\\houman0	Production Technician - WC50	1971-08-30	M	M	2009-01-25	f	3	21	t	9ce8b2e8-9944-4ba5-97de-441d8314f161	2014-06-30 00:00:00	/3/1/9/8/
102	360868122	adventure-works\\zheng0	Production Supervisor - WC10	1983-10-26	S	M	2008-12-03	f	66	53	t	c75f2740-ace3-4ebf-91c5-7ab352e1095f	2014-06-30 00:00:00	/3/1/10/
103	455563743	adventure-works\\ebru0	Production Technician - WC10	1986-09-22	S	M	2009-12-06	f	93	66	t	6c25a32b-88b5-4f84-a129-f7f688dfa588	2014-06-30 00:00:00	/3/1/10/1/
104	717889520	adventure-works\\mary1	Production Technician - WC10	1986-09-19	M	F	2009-12-25	f	94	67	t	6dc9f7d0-5664-4e4a-90f5-7ab85ebb02e6	2014-06-30 00:00:00	/3/1/10/2/
105	801365500	adventure-works\\kevin2	Production Technician - WC10	1986-09-19	S	M	2009-12-25	f	90	65	t	8b21e53d-e705-479a-b32e-6e63ac2f4bcd	2014-06-30 00:00:00	/3/1/10/3/
106	561196580	adventure-works\\john4	Production Technician - WC10	1986-09-28	S	M	2010-02-27	f	92	66	t	d4cf23d9-21b6-45e4-827c-22890df0373b	2014-06-30 00:00:00	/3/1/10/4/
107	393421437	adventure-works\\christopher0	Production Technician - WC10	1986-10-01	M	M	2010-02-08	f	91	65	t	f71c6055-557b-4660-86ff-8c0fa14b24e6	2014-06-30 00:00:00	/3/1/10/5/
108	630184120	adventure-works\\jinghao0	Production Supervisor - WC50	1989-02-05	S	M	2008-12-08	f	77	58	t	2bca07d3-f2ac-4406-904f-e09156f3eb3e	2014-06-30 00:00:00	/3/1/11/
109	113695504	adventure-works\\alice0	Production Technician - WC50	1978-01-26	M	F	2008-12-07	f	95	67	t	7e632b21-0d11-4bba-8a68-8cae14c20ae6	2014-06-30 00:00:00	/3/1/11/1/
110	857651804	adventure-works\\jun0	Production Technician - WC50	1979-07-06	S	M	2008-12-14	f	90	65	t	9c5f84d1-fb96-4d82-92a1-f932903deaad	2014-06-30 00:00:00	/3/1/11/2/
111	415823523	adventure-works\\suroor0	Production Technician - WC50	1978-02-25	S	M	2008-12-17	f	93	66	t	14010b0e-c101-4e41-b788-21923399e512	2014-06-30 00:00:00	/3/1/11/3/
112	981597097	adventure-works\\john1	Production Technician - WC50	1978-05-31	S	M	2009-01-01	f	91	65	t	b6998410-ee0f-4307-9e6e-fe348f11012d	2014-06-30 00:00:00	/3/1/11/4/
113	54759846	adventure-works\\linda0	Production Technician - WC50	1987-07-17	M	F	2008-12-25	f	96	68	t	fb84759c-b687-43b2-8727-125efe0f5e13	2014-06-30 00:00:00	/3/1/11/5/
114	342607223	adventure-works\\mindaugas0	Production Technician - WC50	1978-05-07	M	M	2009-01-13	f	97	68	t	1d784088-dacb-4185-9f60-3d2db4925ba5	2014-06-30 00:00:00	/3/1/11/6/
115	563680513	adventure-works\\angela0	Production Technician - WC50	1991-05-31	S	F	2009-01-20	f	92	66	t	4958e1c3-c872-4222-954e-09d2060ea7ef	2014-06-30 00:00:00	/3/1/11/7/
116	398737566	adventure-works\\michael2	Production Technician - WC50	1974-05-03	S	M	2009-01-31	f	98	69	t	c6eb2566-cf28-4602-9a25-5b91c8728838	2014-06-30 00:00:00	/3/1/11/8/
117	599942664	adventure-works\\chad0	Production Technician - WC50	1990-08-04	M	M	2009-02-18	f	99	69	t	83a32d4c-4725-478f-9997-91739bb957ba	2014-06-30 00:00:00	/3/1/11/9/
118	222400012	adventure-works\\don0	Production Technician - WC50	1971-06-13	M	M	2009-02-13	f	88	64	t	e720053d-922e-4c91-b81a-a1ca4ef8bb0e	2014-06-30 00:00:00	/3/1/11/10/
119	334834274	adventure-works\\michael4	Production Technician - WC50	1989-06-15	S	M	2009-02-25	f	94	67	t	eb27c026-9470-4450-8d5e-1f38a41793b5	2014-06-30 00:00:00	/3/1/11/11/
120	211789056	adventure-works\\kitti0	Production Technician - WC50	1987-06-06	S	F	2009-03-04	f	89	64	t	49a05524-fa34-45b1-95bc-489901dc5b50	2014-06-30 00:00:00	/3/1/11/12/
121	521265716	adventure-works\\pilar0	Shipping and Receiving Supervisor	1972-09-09	S	M	2009-01-02	t	93	66	t	01bcce22-d63a-4c3f-9ba8-d3d5a4c3bd52	2014-06-30 00:00:00	/3/1/12/
122	586486572	adventure-works\\susan0	Stocker	1978-02-17	S	F	2008-12-07	f	97	68	t	923ecfd6-e202-429a-9141-6cb183531439	2014-06-30 00:00:00	/3/1/12/1/
123	337752649	adventure-works\\vamsi0	Shipping and Receiving Clerk	1977-03-18	M	M	2008-12-07	f	95	67	t	a8838ab2-99de-415c-8675-d82ebf1c4752	2014-06-30 00:00:00	/3/1/12/2/
124	420776180	adventure-works\\kim0	Stocker	1984-04-30	S	F	2008-12-26	f	98	69	t	6150f197-7923-40d4-84f2-936207d468ab	2014-06-30 00:00:00	/3/1/12/3/
125	584205124	adventure-works\\matthias0	Shipping and Receiving Clerk	1973-11-11	M	M	2009-01-20	f	94	67	t	54ed63dc-c62c-4cc7-89c2-015df49c49a5	2014-06-30 00:00:00	/3/1/12/4/
126	652779496	adventure-works\\jimmy0	Stocker	1985-05-04	M	M	2009-02-26	f	96	68	t	96442787-9520-4955-a457-38afddb6ff13	2014-06-30 00:00:00	/3/1/12/5/
127	750905084	adventure-works\\david4	Production Supervisor - WC40	1983-07-02	S	M	2009-01-03	f	73	56	t	516538e8-115b-44f4-aa7b-e6c1d9f8adfc	2014-06-30 00:00:00	/3/1/13/
128	384162788	adventure-works\\paul0	Production Technician - WC40	1980-11-13	S	M	2008-12-04	f	68	54	t	0217049e-1566-42b6-8027-41b751e2b00b	2014-06-30 00:00:00	/3/1/13/1/
129	502058701	adventure-works\\gary0	Production Technician - WC40	1988-05-16	S	M	2008-12-22	f	69	54	t	a03d6052-1f85-4ebe-aac9-b67cfdcd91a6	2014-06-30 00:00:00	/3/1/13/2/
130	578953538	adventure-works\\rob1	Production Technician - WC40	1973-08-04	S	M	2009-02-13	f	71	55	t	54fda597-6822-42b4-b128-63eca03071f2	2014-06-30 00:00:00	/3/1/13/3/
131	273260055	adventure-works\\baris0	Production Technician - WC40	1990-10-07	S	M	2009-02-15	f	72	56	t	232d68bf-df58-48f9-9235-53bd4b009b4b	2014-06-30 00:00:00	/3/1/13/4/
132	1300049	adventure-works\\nicole0	Production Technician - WC40	1986-04-09	M	F	2009-02-22	f	67	53	t	15671e3b-016f-41fd-840b-5a9f7d776d9a	2014-06-30 00:00:00	/3/1/13/5/
133	830150469	adventure-works\\michael1	Production Technician - WC40	1991-01-04	S	M	2009-01-10	f	70	55	t	416bf905-7d6c-4692-8fd6-40f6c4f9ecc4	2014-06-30 00:00:00	/3/1/13/6/
134	45615666	adventure-works\\eric0	Production Supervisor - WC20	1985-01-19	M	M	2009-01-14	f	40	40	t	2abcf39b-88d7-49fa-820a-83d223322ba5	2014-06-30 00:00:00	/3/1/14/
135	964089218	adventure-works\\ivo0	Production Technician - WC20	1982-01-03	M	M	2008-12-04	f	9	24	t	d83a26f3-7ea7-477b-a5bb-7eaadfc13a09	2014-06-30 00:00:00	/3/1/14/1/
136	701156975	adventure-works\\sylvester0	Production Technician - WC20	1970-11-12	M	M	2009-12-11	f	4	22	t	d9c43d08-3882-4e5c-bdf0-f6bd7004cd04	2014-06-30 00:00:00	/3/1/14/2/
137	63761469	adventure-works\\anibal0	Production Technician - WC20	1974-09-05	S	F	2009-02-23	f	8	24	t	bc18a829-f0ce-4eaf-9785-2d84c86f925a	2014-06-30 00:00:00	/3/1/14/3/
138	25011600	adventure-works\\samantha0	Production Technician - WC20	1987-11-22	M	F	2009-02-04	f	7	23	t	1629eddd-d0ae-4cb9-a59c-3a175f7027e5	2014-06-30 00:00:00	/3/1/14/4/
139	113393530	adventure-works\\hung-fu0	Production Technician - WC20	1971-10-23	S	M	2010-01-06	f	0	20	t	065d8d5f-9504-4ffe-98dc-e69677f19f15	2014-06-30 00:00:00	/3/1/14/5/
140	339233463	adventure-works\\prasanna0	Production Technician - WC20	1953-04-30	M	M	2010-01-22	f	5	22	t	72ed240a-0fd8-4423-8a49-9078ba6bcf6c	2014-06-30 00:00:00	/3/1/14/6/
141	872923042	adventure-works\\min0	Production Technician - WC20	1974-09-10	M	M	2010-01-24	f	1	20	t	cc75c35d-1566-43fa-b2e9-d1e508efdcd1	2014-06-30 00:00:00	/3/1/14/7/
142	163347032	adventure-works\\olinda0	Production Technician - WC20	1970-04-04	S	F	2010-03-04	f	3	21	t	6456cec3-9b1e-4ebc-9fd8-732b93363f65	2014-06-30 00:00:00	/3/1/14/8/
143	56772045	adventure-works\\krishna0	Production Technician - WC20	1971-09-05	S	M	2010-02-13	f	2	21	t	42a506a5-0ac0-4148-b702-bb7b804ef98c	2014-06-30 00:00:00	/3/1/14/9/
144	886023130	adventure-works\\paul1	Production Technician - WC20	1990-11-04	M	M	2009-01-17	f	6	23	t	dc5ba622-b860-41ee-af92-5feb4779b589	2014-06-30 00:00:00	/3/1/14/10/
145	386315192	adventure-works\\cynthia0	Production Supervisor - WC30	1981-08-18	S	F	2009-01-27	f	69	54	t	f9e1dc46-0d03-4a8a-b693-1a964bc13e6c	2014-06-30 00:00:00	/3/1/15/
146	160739235	adventure-works\\jianshuo0	Production Technician - WC30	1989-06-25	S	M	2008-12-07	f	36	38	t	6fff136a-9664-4eb9-9243-fac76e21b9dd	2014-06-30 00:00:00	/3/1/15/1/
147	604664374	adventure-works\\sandra0	Production Technician - WC30	1975-11-05	M	F	2008-12-26	f	37	38	t	f69f3ff9-e1e0-4419-a6bf-f705e1556160	2014-06-30 00:00:00	/3/1/15/2/
148	733022683	adventure-works\\jason0	Production Technician - WC30	1988-12-07	S	M	2009-01-14	f	38	39	t	c16c501d-942d-4eb0-b5c4-ef8119fbeba2	2014-06-30 00:00:00	/3/1/15/3/
149	764853868	adventure-works\\andy0	Production Technician - WC30	1983-10-20	M	M	2009-01-31	f	39	39	t	615a6bfe-3046-4037-9764-238535f725be	2014-06-30 00:00:00	/3/1/15/4/
150	878395493	adventure-works\\michael5	Production Technician - WC30	1982-09-18	M	M	2009-02-26	f	35	37	t	2b0876d4-8996-4e71-a613-be2e98e7accf	2014-06-30 00:00:00	/3/1/15/5/
151	993310268	adventure-works\\rostislav0	Production Technician - WC30	1977-09-13	M	M	2009-02-19	f	40	40	t	00027a8c-c2f8-4a31-aba8-8a203638b8f1	2014-06-30 00:00:00	/3/1/15/6/
152	319472946	adventure-works\\yuhong0	Production Supervisor - WC20	1977-04-06	M	M	2009-02-01	f	41	40	t	f1a684f4-02db-4b22-8977-6d8d3a21100e	2014-06-30 00:00:00	/3/1/16/
153	568596888	adventure-works\\hanying0	Production Technician - WC20	1974-10-16	S	M	2008-12-16	f	15	27	t	618b71bc-6e8c-492d-8862-b9efb7a4e06a	2014-06-30 00:00:00	/3/1/16/1/
154	97728960	adventure-works\\raymond0	Production Technician - WC20	1967-03-02	M	M	2008-12-23	f	10	25	t	9f01e1fb-b893-40cc-9f5c-aaf89f9b7af5	2014-06-30 00:00:00	/3/1/16/2/
155	212801092	adventure-works\\fadi0	Production Technician - WC20	1989-02-15	S	M	2009-01-04	f	16	28	t	9923376f-26d0-4845-9d99-cc3d696caeb8	2014-06-30 00:00:00	/3/1/16/3/
156	322160340	adventure-works\\lane0	Production Technician - WC20	1974-09-23	M	M	2009-01-11	f	11	25	t	042427b8-3883-4a87-a6a3-724ee1690f49	2014-06-30 00:00:00	/3/1/16/4/
157	812797414	adventure-works\\linda1	Production Technician - WC20	1977-10-05	S	F	2009-02-03	f	12	26	t	f963f913-449e-4ebb-bfda-fc0c3010db65	2014-06-30 00:00:00	/3/1/16/5/
158	300946911	adventure-works\\shelley0	Production Technician - WC20	1986-12-08	S	F	2009-03-07	f	14	27	t	13942056-2930-4490-83ce-af2386d5a5e7	2014-06-30 00:00:00	/3/1/16/6/
159	404159499	adventure-works\\terrence0	Production Technician - WC20	1984-12-08	S	M	2009-02-16	f	13	26	t	4da76442-5eef-41fb-ae19-16c55714f9ad	2014-06-30 00:00:00	/3/1/16/7/
160	712885347	adventure-works\\jeff0	Production Supervisor - WC45	1977-01-15	M	M	2009-01-21	f	74	57	t	7c7d459e-1f49-427d-9bd5-de31880c85dc	2014-06-30 00:00:00	/3/1/17/
161	275962311	adventure-works\\kirk0	Production Technician - WC45	1985-02-06	S	M	2008-12-15	f	74	57	t	08d25baa-167b-499c-8b51-31dcc856a8cf	2014-06-30 00:00:00	/3/1/17/1/
162	514829225	adventure-works\\laura0	Production Technician - WC45	1980-12-25	S	F	2009-01-03	f	75	57	t	fccd65ba-2702-4409-ae56-75af1710ac78	2014-06-30 00:00:00	/3/1/17/2/
163	377784364	adventure-works\\alex0	Production Technician - WC45	1990-04-13	M	M	2009-02-08	f	77	58	t	b96bc9c2-5a25-4a9b-887a-c7c10e47b80c	2014-06-30 00:00:00	/3/1/17/3/
164	65848458	adventure-works\\andrew1	Production Technician - WC45	1988-09-24	S	M	2009-03-06	f	73	56	t	a2a2cf20-4e5c-45f7-a7bd-1b94f0c3a43a	2014-06-30 00:00:00	/3/1/17/4/
165	539490372	adventure-works\\chris0	Production Technician - WC45	1988-12-16	M	M	2009-01-22	f	76	58	t	300223f3-5587-4230-909b-d9c4afd6d683	2014-06-30 00:00:00	/3/1/17/5/
166	60114406	adventure-works\\jack0	Production Supervisor - WC30	1983-06-22	S	M	2009-02-21	f	68	54	t	69a47230-70ee-48fd-ac15-c39f3712ff14	2014-06-30 00:00:00	/3/1/18/
167	498138869	adventure-works\\david1	Production Technician - WC30	1979-11-02	S	M	2008-12-02	f	25	32	t	ed7ee92e-a9d0-4e3a-8dee-4b143e459f7e	2014-06-30 00:00:00	/3/1/18/1/
168	271438431	adventure-works\\garrett0	Production Technician - WC30	1984-08-25	S	M	2008-12-07	f	34	37	t	a6f5f72f-aa03-41b7-8b6e-b123bd360753	2014-06-30 00:00:00	/3/1/18/2/
169	351069889	adventure-works\\susan1	Production Technician - WC30	1983-04-02	S	F	2008-12-14	f	31	35	t	f73d75d5-b47b-46ee-ad11-7bf13dd6c55d	2014-06-30 00:00:00	/3/1/18/3/
170	476115505	adventure-works\\george0	Production Technician - WC30	1977-04-16	M	M	2008-12-21	f	26	33	t	01b119a2-2af3-4775-818e-b421fecb07a7	2014-06-30 00:00:00	/3/1/18/4/
171	746373306	adventure-works\\david3	Production Technician - WC30	1981-08-03	S	M	2009-01-02	f	32	36	t	84c358d4-2493-452c-b7d6-b212c893a009	2014-06-30 00:00:00	/3/1/18/5/
172	364818297	adventure-works\\marc0	Production Technician - WC30	1986-10-24	M	M	2009-01-16	f	22	31	t	1f151abc-db4a-431a-8a5d-15f46c5b8ffc	2014-06-30 00:00:00	/3/1/18/6/
173	87268837	adventure-works\\eugene0	Production Technician - WC30	1987-07-15	S	M	2009-01-21	f	33	36	t	1ba1d374-18ae-48ed-938f-6f5d2eec4d4d	2014-06-30 00:00:00	/3/1/18/7/
174	585408256	adventure-works\\benjamin0	Production Technician - WC30	1986-01-05	S	M	2009-01-27	f	28	34	t	f1a6f824-895b-4a0f-af1b-05fba703e69f	2014-06-30 00:00:00	/3/1/18/8/
175	259388196	adventure-works\\reed0	Production Technician - WC30	1989-01-08	M	M	2009-02-02	f	23	31	t	b3967c00-7014-4960-af15-b1a6d3094f6f	2014-06-30 00:00:00	/3/1/18/9/
176	860123571	adventure-works\\david7	Production Technician - WC30	1985-09-23	M	M	2009-02-14	f	29	34	t	85afb689-7eab-41a8-b154-9446195d5bde	2014-06-30 00:00:00	/3/1/18/10/
177	551346974	adventure-works\\russell1	Production Technician - WC30	1982-02-11	M	M	2009-02-21	f	24	32	t	d54c7989-2675-4ef3-b392-370a8d264b2b	2014-06-30 00:00:00	/3/1/18/11/
178	568626529	adventure-works\\john3	Production Technician - WC30	1982-03-24	S	M	2009-03-03	f	27	33	t	96c7eab1-6dea-4c59-afd8-923f0e8de1f6	2014-06-30 00:00:00	/3/1/18/12/
179	587567941	adventure-works\\jan0	Production Technician - WC30	1974-11-15	S	M	2009-03-05	f	30	35	t	975f827d-be71-4eb1-8dbf-e6c451d1fad5	2014-06-30 00:00:00	/3/1/18/13/
180	862951447	adventure-works\\katie0	Production Supervisor - WC20	1984-11-18	S	F	2009-02-20	f	42	41	t	5be8b211-cbe5-45d8-84fd-23f36a881473	2014-06-30 00:00:00	/3/1/19/
181	545337468	adventure-works\\michael0	Production Technician - WC20	1984-11-17	S	M	2008-12-09	f	20	30	t	4fd6fe82-535a-4dd1-beb1-154a8b5e42f0	2014-06-30 00:00:00	/3/1/19/1/
182	368920189	adventure-works\\nitin0	Production Technician - WC20	1986-12-01	S	M	2008-12-28	f	21	30	t	ebbc6787-3f2d-4f6b-9ea3-4def02ef382e	2014-06-30 00:00:00	/3/1/19/2/
183	969985265	adventure-works\\barbara0	Production Technician - WC20	1979-07-02	M	F	2009-01-22	f	17	28	t	045c9cbb-3448-4599-9fa9-6c7a9f82f832	2014-06-30 00:00:00	/3/1/19/3/
184	305522471	adventure-works\\john2	Production Technician - WC20	1986-04-05	M	M	2009-02-09	f	18	29	t	bab69951-28ad-4bca-b5ac-032746d0cc6f	2014-06-30 00:00:00	/3/1/19/4/
185	621932914	adventure-works\\stefen0	Production Technician - WC20	1975-12-21	S	M	2009-02-28	f	19	29	t	b9eebf9f-f694-4bc2-98ec-9b4fb0379edf	2014-06-30 00:00:00	/3/1/19/5/
186	551834634	adventure-works\\shane0	Production Supervisor - WC45	1990-05-24	S	M	2009-02-08	f	75	57	t	2625c358-672a-4000-ad67-b8cd3f318285	2014-06-30 00:00:00	/3/1/20/
187	713403643	adventure-works\\yvonne0	Production Technician - WC45	1989-04-15	M	F	2008-12-09	f	79	59	t	83c6dabf-fd7d-4f5b-bb22-eb7eebb9a772	2014-06-30 00:00:00	/3/1/20/1/
188	435234965	adventure-works\\douglas0	Production Technician - WC45	1985-11-24	M	M	2008-12-27	f	80	60	t	1ab0edeb-7558-4734-8423-5a11b44dca35	2014-06-30 00:00:00	/3/1/20/2/
189	187369436	adventure-works\\janeth0	Production Technician - WC45	1972-07-24	S	F	2009-01-15	f	81	60	t	8261b8cb-bc3f-4bce-b364-86035d870263	2014-06-30 00:00:00	/3/1/20/3/
190	456839592	adventure-works\\robert0	Production Technician - WC45	1985-02-28	S	M	2009-02-02	f	82	61	t	2203154e-5ebd-4aca-99be-d835a3309d03	2014-06-30 00:00:00	/3/1/20/4/
191	399658727	adventure-works\\lionel0	Production Technician - WC45	1988-03-14	S	M	2009-02-26	f	78	59	t	231b1798-f67b-45c1-9688-265180f93d28	2014-06-30 00:00:00	/3/1/20/5/
192	634335025	adventure-works\\brenda0	Production Supervisor - WC40	1983-02-28	M	F	2009-03-05	f	71	55	t	714d519b-375e-4c5a-8491-c758d00cf95f	2014-06-30 00:00:00	/3/1/21/
193	761597760	adventure-works\\alejandro0	Production Technician - WC40	1988-12-05	S	M	2008-12-06	f	52	46	t	8c7321d2-2c64-4902-9d64-8f5c1eb7f747	2014-06-30 00:00:00	/3/1/21/1/
194	295971920	adventure-works\\fred0	Production Technician - WC40	1989-06-25	S	M	2008-12-12	f	47	43	t	45358ae8-0b0e-4c11-90bb-dac3ec0d5c82	2014-06-30 00:00:00	/3/1/21/2/
195	918737118	adventure-works\\kevin1	Production Technician - WC40	1985-12-25	S	M	2008-12-17	f	58	49	t	dc7e95ff-275e-41c2-8ed3-686864f0540a	2014-06-30 00:00:00	/3/1/21/3/
196	370487086	adventure-works\\shammi0	Production Technician - WC40	1980-10-04	M	M	2008-12-24	f	53	46	t	9bef0c94-7969-4905-9a42-ce469c754800	2014-06-30 00:00:00	/3/1/21/4/
197	632092621	adventure-works\\rajesh0	Production Technician - WC40	1977-10-04	M	M	2008-12-31	f	48	44	t	aca7b40c-7ac0-4daa-b4c7-1051d850d7d9	2014-06-30 00:00:00	/3/1/21/5/
198	19312190	adventure-works\\lorraine0	Production Technician - WC40	1988-11-26	M	F	2009-01-04	f	49	44	t	a63966b6-9ad6-40bc-afd4-a83745879f4d	2014-06-30 00:00:00	/3/1/21/6/
199	992874797	adventure-works\\paula1	Production Technician - WC40	1987-02-10	M	F	2009-01-12	f	54	47	t	5dd2be46-204f-4af3-91f5-5ef082f6d6a6	2014-06-30 00:00:00	/3/1/21/7/
200	749211824	adventure-works\\frank0	Production Technician - WC40	1987-09-06	M	M	2009-01-17	f	56	48	t	dd9ad278-ed17-40cf-8619-baf1bb9d1cf2	2014-06-30 00:00:00	/3/1/21/8/
201	746201340	adventure-works\\brian0	Production Technician - WC40	1977-02-10	S	M	2009-01-29	f	55	47	t	18d594a8-b4ed-43c0-9c43-6033feaadf4e	2014-06-30 00:00:00	/3/1/21/9/
202	436757988	adventure-works\\tawana0	Production Technician - WC40	1989-11-10	S	M	2009-02-05	f	50	45	t	bb4a3e50-232e-4212-9faf-e67429febc7d	2014-06-30 00:00:00	/3/1/21/10/
203	693168613	adventure-works\\ken1	Production Technician - WC40	1981-05-28	M	M	2009-02-24	f	51	45	t	699c00d8-c4ab-4cd2-a48f-37cbcb5bfcca	2014-06-30 00:00:00	/3/1/21/11/
204	440379437	adventure-works\\gabe0	Production Technician - WC40	1988-05-10	M	M	2009-03-08	f	57	48	t	790c9a7c-264c-4d48-a9d3-e2571a8011d8	2014-06-30 00:00:00	/3/1/21/12/
205	332349500	adventure-works\\lori0	Production Supervisor - WC45	1980-07-18	S	F	2009-02-26	f	76	58	t	23d436fc-08f7-4988-8b4d-490aa4e8b7e7	2014-06-30 00:00:00	/3/1/22/
206	835460180	adventure-works\\stuart0	Production Technician - WC45	1962-09-13	S	M	2008-12-02	f	84	62	t	4f361b4f-7920-4037-9a0a-46d616f9b9c7	2014-06-30 00:00:00	/3/1/22/1/
207	687685941	adventure-works\\greg0	Production Technician - WC45	1970-10-18	S	M	2008-12-02	f	85	62	t	a36b5d6b-72a5-47f8-9f6b-5d922130e760	2014-06-30 00:00:00	/3/1/22/2/
208	199546871	adventure-works\\scott0	Production Technician - WC45	1987-02-10	M	M	2009-01-08	f	86	63	t	e35da50a-bb51-4e08-8b8d-87ef4650247a	2014-06-30 00:00:00	/3/1/22/3/
209	167554340	adventure-works\\kathie0	Production Technician - WC45	1990-11-01	M	F	2009-01-27	f	87	63	t	25fc84d7-e013-44b8-82cd-63cd4723af81	2014-06-30 00:00:00	/3/1/22/4/
210	20244403	adventure-works\\belinda0	Production Technician - WC45	1969-09-17	S	F	2009-02-20	f	83	61	t	f714b5ec-ca7c-4e6e-a812-2c5a119f4c30	2014-06-30 00:00:00	/3/1/22/5/
211	398223854	adventure-works\\hazem0	Quality Assurance Manager	1977-10-26	S	M	2009-02-28	t	80	60	t	05c84608-f445-4f9d-bb5c-0828c309c29d	2014-12-26 09:17:08.637	/3/2/
212	885055826	adventure-works\\peng0	Quality Assurance Supervisor	1976-03-18	M	M	2008-12-09	t	81	60	t	e249d613-36c9-4544-9b6f-6ce50e5e0da5	2014-06-30 00:00:00	/3/2/1/
213	343861179	adventure-works\\sootha0	Quality Assurance Technician	1966-12-05	M	M	2010-02-23	f	85	62	t	a3dadf19-27f0-460a-9888-ce6caa9e3583	2014-06-30 00:00:00	/3/2/1/1/
214	131471224	adventure-works\\andreas0	Quality Assurance Technician	1989-03-28	M	M	2009-02-02	f	84	62	t	f4ddd64f-dffe-4df3-aa17-d6bea1924818	2014-06-30 00:00:00	/3/2/1/2/
215	381772114	adventure-works\\mark0	Quality Assurance Technician	1986-04-30	S	M	2009-01-15	f	83	61	t	6b63ef27-2c55-4f4c-be29-fce8b694dc4a	2014-06-30 00:00:00	/3/2/1/3/
216	403414852	adventure-works\\sean0	Quality Assurance Technician	1976-03-06	S	M	2008-12-28	f	82	61	t	34e128cf-d904-4327-8014-9df0d5de7d08	2014-06-30 00:00:00	/3/2/1/4/
217	345106466	adventure-works\\zainal0	Document Control Manager	1976-01-30	M	M	2009-01-04	f	77	58	t	dc60eeed-9f9f-4435-8666-4de4fafde9c3	2014-06-30 00:00:00	/3/2/2/
218	540688287	adventure-works\\tengiz0	Control Specialist	1990-04-28	S	M	2008-12-16	f	76	58	t	c609b3b2-7969-410c-934c-62c34b63c4ee	2014-06-30 00:00:00	/3/2/2/1/
219	242381745	adventure-works\\sean1	Document Control Assistant	1987-03-12	S	M	2009-01-22	f	78	59	t	f78657a9-83ef-4b4d-9809-3c4c6d1a7bb4	2014-06-30 00:00:00	/3/2/2/2/
220	260770918	adventure-works\\karen0	Document Control Assistant	1975-12-25	M	F	2009-02-09	f	79	59	t	8a41ed23-7ae2-4c15-aa5d-9496e721f848	2014-06-30 00:00:00	/3/2/2/3/
221	260805477	adventure-works\\chris1	Control Specialist	1987-05-26	M	M	2009-03-06	f	75	57	t	45c358fb-9c7f-4d36-8ec7-3d89e9fd07f4	2014-06-30 00:00:00	/3/2/2/4/
222	685233686	adventure-works\\ascott0	Master Scheduler	1968-09-17	S	M	2008-12-12	f	44	42	t	13909262-4136-492f-bca3-0b0e3773b03e	2014-12-26 09:17:08.637	/3/3/
223	981495526	adventure-works\\sairaj0	Scheduling Assistant	1987-12-22	M	M	2009-01-26	f	46	43	t	4d36a720-ce32-4c47-866a-db7844449309	2014-06-30 00:00:00	/3/3/1/
224	621209647	adventure-works\\william0	Scheduling Assistant	1981-11-06	M	M	2009-01-07	f	45	42	t	1a68cd62-6fe9-4613-90d4-2cd178e4e54a	2014-06-30 00:00:00	/3/3/2/
225	470689086	adventure-works\\alan0	Scheduling Assistant	1984-03-29	M	M	2009-02-13	f	47	43	t	de321854-b076-4d59-bb7b-42152031b108	2014-06-30 00:00:00	/3/3/3/
226	368691270	adventure-works\\brian1	Scheduling Assistant	1984-08-11	M	M	2009-03-03	f	48	44	t	dfa02733-c26e-4e31-99d8-9167e4e5131d	2014-06-30 00:00:00	/3/3/4/
227	141165819	adventure-works\\gary1	Facilities Manager	1971-02-18	M	M	2009-12-02	t	86	63	t	62f6ec59-5635-44f3-9cc1-2d8eeaf90a05	2014-06-30 00:00:00	/3/4/
228	553069203	adventure-works\\christian0	Maintenance Supervisor	1976-01-18	M	M	2008-12-14	t	92	66	t	4611c7c5-90a0-407f-b054-93bd51533609	2014-06-30 00:00:00	/3/4/1/
229	879334904	adventure-works\\lori1	Janitor	1970-07-31	M	F	2010-02-16	f	90	65	t	929fe187-ee24-4f5f-af2a-f96324f09423	2014-06-30 00:00:00	/3/4/1/1/
230	28414965	adventure-works\\stuart1	Janitor	1971-12-17	M	M	2010-03-05	f	88	64	t	cc2791e6-7629-49c5-922a-81445afdf033	2014-06-30 00:00:00	/3/4/1/2/
231	153479919	adventure-works\\jo1	Janitor	1954-04-24	M	F	2010-03-07	f	91	65	t	39af5cca-9b52-41e5-b510-72901d2578f6	2014-06-30 00:00:00	/3/4/1/3/
232	646304055	adventure-works\\pat0	Janitor	1970-12-03	S	M	2010-01-27	f	89	64	t	49238447-30ee-4009-993f-0b6c756ab436	2014-06-30 00:00:00	/3/4/1/4/
233	552560652	adventure-works\\magnus0	Facilities Administrative Assistant	1971-08-27	M	M	2009-12-21	f	87	63	t	0a4bcc09-ace5-4481-9067-8b9ed70eca18	2014-06-30 00:00:00	/3/4/2/
234	184188301	adventure-works\\laura1	Chief Financial Officer	1976-01-06	M	F	2009-01-31	t	0	20	t	d5e315a6-bd65-4d67-9d5f-81ef5c4ef8a6	2014-06-30 00:00:00	/4/
235	535145551	adventure-works\\paula0	Human Resources Manager	1976-02-11	M	F	2008-12-06	t	54	47	t	65028f15-4149-4de5-b203-9d7ec86baf87	2014-06-30 00:00:00	/4/1/
236	476980013	adventure-works\\grant0	Human Resources Administrative Assistant	1976-04-16	S	M	2009-02-25	f	53	46	t	4511abba-7f34-400e-907b-a663c20e1a41	2014-06-30 00:00:00	/4/1/1/
237	416679555	adventure-works\\hao0	Human Resources Administrative Assistant	1977-04-17	S	M	2009-02-06	f	52	46	t	fd53c4c8-b34e-460f-9ee5-747b07fe98b3	2014-06-30 00:00:00	/4/1/2/
238	264306399	adventure-works\\vidur0	Recruiter	1984-08-01	S	M	2009-01-01	f	50	45	t	47e76b59-b137-4572-ad55-6b3e68c13bd3	2014-06-30 00:00:00	/4/1/3/
239	619308550	adventure-works\\mindy0	Benefits Specialist	1984-11-20	M	F	2008-12-25	f	51	45	t	834d7ab6-06e6-4944-b42f-028cd4bd388e	2014-06-30 00:00:00	/4/1/4/
240	332040978	adventure-works\\willis0	Recruiter	1978-07-18	S	M	2008-12-13	f	49	44	t	a1d86ecc-ea17-4b1b-8369-f1d07ab0a469	2014-06-30 00:00:00	/4/1/5/
241	30845	adventure-works\\david6	Accounts Manager	1983-07-08	M	M	2009-01-30	t	57	48	t	2dc9d534-f5d1-4a14-8282-0a2a0eb6fd4d	2014-06-30 00:00:00	/4/2/
242	363923697	adventure-works\\deborah0	Accounts Receivable Specialist	1976-03-06	M	F	2008-12-18	f	60	50	t	09f75454-028c-46ca-bc08-0147bd0220d7	2014-06-30 00:00:00	/4/2/1/
243	60517918	adventure-works\\candy0	Accounts Receivable Specialist	1976-02-23	S	F	2009-01-06	f	61	50	t	9e9f713b-707c-4f7e-9504-de188052a045	2014-06-30 00:00:00	/4/2/2/
244	931190412	adventure-works\\bryan1	Accounts Receivable Specialist	1984-09-20	S	M	2009-01-24	f	62	51	t	cb3e71ec-a381-4716-87df-d3841ab9795a	2014-06-30 00:00:00	/4/2/3/
245	363910111	adventure-works\\barbara1	Accountant	1976-01-04	M	F	2009-02-18	t	58	49	t	3ffba84e-8e97-4649-a5e1-859649d83aae	2014-06-30 00:00:00	/4/2/4/
246	663843431	adventure-works\\dragan0	Accounts Payable Specialist	1977-02-14	M	M	2009-02-11	f	63	51	t	51c54d34-064b-44f7-a6b1-7702bd491980	2014-06-30 00:00:00	/4/2/5/
247	519756660	adventure-works\\janet0	Accounts Payable Specialist	1979-03-09	M	F	2009-03-01	f	64	52	t	0c641d77-8675-493f-9947-8c65136559cd	2014-06-30 00:00:00	/4/2/6/
248	480951955	adventure-works\\mike0	Accountant	1979-07-01	S	M	2009-03-08	t	59	49	t	ac35337d-7c75-4dee-bb11-6564f257fe18	2014-06-30 00:00:00	/4/2/7/
249	121491555	adventure-works\\wendy0	Finance Manager	1984-10-11	S	F	2008-12-25	t	55	47	t	8f410408-4aa8-4d67-886d-530bfe4ebe3b	2014-06-30 00:00:00	/4/3/
250	895209680	adventure-works\\sheela0	Purchasing Manager	1978-02-10	S	F	2011-02-25	t	49	44	t	7d6b0155-0191-4599-8394-378ebde63c9a	2014-06-30 00:00:00	/4/3/1/
251	603686790	adventure-works\\mikael0	Buyer	1984-08-17	S	M	2009-02-10	f	59	49	t	d0fd55ff-42fa-491e-8b3b-ab3316018909	2014-06-30 00:00:00	/4/3/1/1/
252	792847334	adventure-works\\arvind0	Buyer	1974-08-21	M	M	2009-02-28	f	60	50	t	51de26f0-6ed9-4a70-b689-88eb882674b6	2014-06-30 00:00:00	/4/3/1/2/
253	407505660	adventure-works\\linda2	Buyer	1970-11-30	M	F	2009-12-17	f	56	48	t	ed06f9f4-2123-4c44-89d7-e43e1e1abc2f	2014-06-30 00:00:00	/4/3/1/3/
254	482810518	adventure-works\\fukiko0	Buyer	1970-11-24	M	M	2010-01-04	f	57	48	t	36cd6636-c657-4fc7-9bfa-cc1bfa9102a2	2014-06-30 00:00:00	/4/3/1/4/
255	466142721	adventure-works\\gordon0	Buyer	1966-11-29	M	M	2010-01-11	f	52	46	t	2cb2d5c3-c437-49b1-9ffd-faa096f6126f	2014-06-30 00:00:00	/4/3/1/5/
256	367453993	adventure-works\\frank2	Buyer	1952-05-12	M	M	2010-01-23	f	58	49	t	0423d8d0-1b14-4718-8c17-85e2f98d222f	2014-06-30 00:00:00	/4/3/1/6/
257	381073001	adventure-works\\eric2	Buyer	1972-09-17	S	M	2010-01-27	f	54	47	t	a28ab377-06f5-417a-a5e2-59f459088699	2014-06-30 00:00:00	/4/3/1/7/
258	785853949	adventure-works\\erin0	Buyer	1971-01-04	S	F	2010-01-31	f	53	46	t	b60712a9-50a5-4296-b892-69c4701834b0	2014-06-30 00:00:00	/4/3/1/8/
259	20269531	adventure-works\\ben0	Buyer	1973-06-03	M	M	2010-03-09	f	55	47	t	b9641cae-765c-4662-b760-c167a1f2b8b5	2014-06-30 00:00:00	/4/3/1/9/
260	437296311	adventure-works\\annette0	Purchasing Assistant	1978-01-29	M	F	2010-12-06	f	50	45	t	9e03395f-4d5d-4a53-880e-174bd8c1db59	2014-06-30 00:00:00	/4/3/1/10/
261	280633567	adventure-works\\reinout0	Purchasing Assistant	1978-01-17	M	M	2010-12-25	f	51	45	t	9825eb00-8e36-4506-93a2-6ddcdc0b13c3	2014-06-30 00:00:00	/4/3/1/11/
262	231203233	adventure-works\\david5	Assistant to the Chief Financial Officer	1964-06-21	S	M	2009-01-12	f	56	48	t	be81fd77-428c-449f-ab79-48b1cdf53d6a	2014-06-30 00:00:00	/4/4/
263	441044382	adventure-works\\jean0	Information Services Manager	1975-12-13	S	F	2008-12-11	t	65	52	t	794a0b1f-c46a-401c-984d-008996fc7092	2014-06-30 00:00:00	/5/
264	858323870	adventure-works\\stephanie0	Network Manager	1984-03-25	S	F	2009-02-04	t	68	54	t	221cbb7b-8bae-452b-a16f-a67ebb3873c8	2014-06-30 00:00:00	/5/1/
265	749389530	adventure-works\\ashvini0	Network Administrator	1977-03-27	S	M	2008-12-04	f	70	55	t	2e680c1c-7c02-4343-9626-6f97273414c0	2014-06-30 00:00:00	/5/1/1/
266	672243793	adventure-works\\peter1	Network Administrator	1980-05-28	S	M	2009-02-23	f	69	54	t	86601e6a-6955-40fc-bb4a-1053a843ce99	2014-06-30 00:00:00	/5/1/2/
267	58317344	adventure-works\\karen1	Application Specialist	1978-05-19	S	F	2009-02-16	t	74	57	t	45c3d0f5-3332-419d-ad40-a98996bb5531	2014-06-30 00:00:00	/5/2/
268	314747499	adventure-works\\ramesh0	Application Specialist	1988-03-13	S	M	2009-02-03	t	73	56	t	be190269-4003-4d7f-809e-7b3fdc235da8	2014-06-30 00:00:00	/5/3/
269	671089628	adventure-works\\dan0	Application Specialist	1987-05-26	M	M	2009-01-11	t	72	56	t	71b0d010-5ac5-4e91-8efa-c311c1372a73	2014-06-30 00:00:00	/5/4/
270	643805155	adventure-works\\françois0	Database Administrator	1975-05-17	S	M	2009-01-17	t	67	53	t	0c7f025d-8d56-48ef-86c0-f09db63d0182	2014-06-30 00:00:00	/5/5/
271	929666391	adventure-works\\dan1	Database Administrator	1976-01-06	M	M	2009-01-22	t	66	53	t	2474e1a9-902d-466c-b0b2-6dcac927f753	2014-06-30 00:00:00	/5/6/
272	525932996	adventure-works\\janaina0	Application Specialist	1985-01-30	M	F	2008-12-23	t	71	55	t	241535c7-7a31-4a6a-9e0d-a83c30c2edda	2014-06-30 00:00:00	/5/7/
273	112432117	adventure-works\\brian3	Vice President of Sales	1977-06-06	S	M	2011-02-15	t	10	25	t	f3ec557c-8b41-4ee6-bb0c-e3b93aff81e5	2014-06-30 00:00:00	/6/
274	502097814	adventure-works\\stephen0	North American Sales Manager	1951-10-17	M	M	2011-01-04	t	14	27	t	86d5fa9e-4bc0-48c8-91dc-1ec467418d11	2014-06-30 00:00:00	/6/1/
275	841560125	adventure-works\\michael9	Sales Representative	1968-12-25	S	M	2011-05-31	t	38	39	t	e19f8de2-0f40-418c-84a2-db48b98dc6a2	2014-06-30 00:00:00	/6/1/1/
276	191644724	adventure-works\\linda3	Sales Representative	1980-02-27	M	F	2011-05-31	t	27	33	t	4509f387-d73a-43dc-a502-b1c27aa1dc9e	2014-06-30 00:00:00	/6/1/2/
277	615389812	adventure-works\\jillian0	Sales Representative	1962-08-29	S	F	2011-05-31	t	24	32	t	a011c97b-081c-4739-996f-c1cac4532f8d	2014-06-30 00:00:00	/6/1/3/
278	234474252	adventure-works\\garrett1	Sales Representative	1975-02-04	M	M	2011-05-31	t	33	36	t	50eecc16-0d0d-43a9-9649-016c06de8d78	2014-06-30 00:00:00	/6/1/4/
279	716374314	adventure-works\\tsvi0	Sales Representative	1974-01-18	M	M	2011-05-31	t	29	34	t	bb510fce-0105-4306-b591-6450d9ebf401	2014-06-30 00:00:00	/6/1/5/
280	61161660	adventure-works\\pamela0	Sales Representative	1974-12-06	S	F	2011-05-31	t	22	31	t	7627b9d6-0707-4706-9ad9-0d37506b08ae	2014-06-30 00:00:00	/6/1/6/
281	139397894	adventure-works\\shu0	Sales Representative	1968-03-09	M	M	2011-05-31	t	26	33	t	4103c891-37e8-4dfc-aeac-b55e2bc1be1c	2014-06-30 00:00:00	/6/1/7/
282	399771412	adventure-works\\josé1	Sales Representative	1963-12-11	M	M	2011-05-31	t	31	35	t	fd3992fb-3067-451d-a09d-73bd53c0feca	2014-06-30 00:00:00	/6/1/8/
283	987554265	adventure-works\\david8	Sales Representative	1974-02-11	S	M	2011-05-31	t	23	31	t	1e8f9e91-508f-4d49-acd2-775c836030ed	2014-06-30 00:00:00	/6/1/9/
284	90836195	adventure-works\\tete0	Sales Representative	1978-01-05	M	M	2012-09-30	t	39	39	t	0c67ce00-de78-4712-908f-06939a2c58d5	2014-06-30 00:00:00	/6/1/10/
285	481044938	adventure-works\\syed0	Pacific Sales Manager	1975-01-11	M	M	2013-03-14	t	20	30	t	86f292db-b73c-429d-9912-800994d809fb	2014-06-30 00:00:00	/6/2/
286	758596752	adventure-works\\lynn0	Sales Representative	1977-02-14	S	F	2013-05-30	t	36	38	t	4a9a8407-a680-4a6b-8d03-511cb58f9a8a	2014-06-30 00:00:00	/6/2/1/
287	982310417	adventure-works\\amy0	European Sales Manager	1957-09-20	M	F	2012-04-16	t	21	30	t	66d66445-ee78-4676-9e66-0e22d6109a92	2014-06-30 00:00:00	/6/3/
288	954276278	adventure-works\\rachel0	Sales Representative	1975-07-09	S	F	2013-05-30	t	35	37	t	b9bf7741-e0ca-4f37-acde-a4f78c6d03e9	2014-06-30 00:00:00	/6/3/1/
289	668991357	adventure-works\\jae0	Sales Representative	1968-03-17	M	F	2012-05-30	t	37	38	t	723a5921-d8a1-4659-9bc4-13c4cf7c9c91	2014-06-30 00:00:00	/6/3/2/
290	134219713	adventure-works\\ranjit0	Sales Representative	1975-09-30	S	M	2012-05-30	t	34	37	t	604213f9-dd0f-43b4-bdd2-c96e93d3f4bf	2014-06-30 00:00:00	/6/3/3/
\.


--
-- Data for Name: employeedepartmenthistory; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.employeedepartmenthistory (businessentityid, departmentid, shiftid, startdate, enddate, modifieddate) FROM stdin;
1	16	1	2009-01-14	\N	2009-01-13 00:00:00
2	1	1	2008-01-31	\N	2008-01-30 00:00:00
3	1	1	2007-11-11	\N	2007-11-10 00:00:00
4	1	1	2007-12-05	2010-05-30	2010-05-28 00:00:00
4	2	1	2010-05-31	\N	2010-05-30 00:00:00
5	1	1	2008-01-06	\N	2008-01-05 00:00:00
6	1	1	2008-01-24	\N	2008-01-23 00:00:00
7	6	1	2009-02-08	\N	2009-02-07 00:00:00
8	6	1	2008-12-29	\N	2008-12-28 00:00:00
9	6	1	2009-01-16	\N	2009-01-15 00:00:00
10	6	1	2009-05-03	\N	2009-05-02 00:00:00
11	2	1	2010-12-05	\N	2010-12-04 00:00:00
12	2	1	2007-12-11	\N	2007-12-10 00:00:00
13	2	1	2010-12-23	\N	2010-12-22 00:00:00
14	1	1	2010-12-30	\N	2010-12-29 00:00:00
15	1	1	2011-01-18	\N	2011-01-17 00:00:00
16	5	1	2007-12-20	2009-07-14	2009-07-12 00:00:00
16	4	1	2009-07-15	\N	2009-07-14 00:00:00
17	4	1	2007-01-26	\N	2007-01-25 00:00:00
18	4	1	2011-02-07	\N	2011-02-06 00:00:00
19	4	1	2011-02-14	\N	2011-02-13 00:00:00
20	4	1	2011-01-07	\N	2011-01-06 00:00:00
21	4	1	2009-03-02	\N	2009-03-01 00:00:00
22	4	1	2008-12-12	\N	2008-12-11 00:00:00
23	4	1	2009-01-12	\N	2009-01-11 00:00:00
24	4	1	2009-01-18	\N	2009-01-17 00:00:00
25	7	1	2009-02-03	\N	2009-02-02 00:00:00
26	8	1	2008-12-01	\N	2008-11-30 00:00:00
27	7	1	2008-02-27	\N	2008-02-26 00:00:00
28	7	1	2006-06-30	\N	2006-06-29 00:00:00
29	7	1	2009-01-23	\N	2009-01-22 00:00:00
30	7	1	2009-01-29	\N	2009-01-28 00:00:00
31	7	1	2009-01-04	\N	2009-01-03 00:00:00
32	7	1	2008-12-29	\N	2008-12-28 00:00:00
33	7	1	2008-12-17	\N	2008-12-16 00:00:00
34	7	1	2009-02-16	\N	2009-02-15 00:00:00
35	7	1	2009-02-08	\N	2009-02-07 00:00:00
36	7	1	2009-02-10	\N	2009-02-09 00:00:00
37	7	1	2009-03-07	\N	2009-03-06 00:00:00
38	7	1	2010-01-16	\N	2010-01-15 00:00:00
39	7	1	2010-02-05	\N	2010-02-04 00:00:00
40	7	3	2007-12-26	\N	2007-12-25 00:00:00
41	7	3	2009-01-21	\N	2009-01-20 00:00:00
42	7	3	2008-12-27	\N	2008-12-26 00:00:00
43	7	3	2009-01-02	\N	2009-01-01 00:00:00
44	7	3	2008-12-08	\N	2008-12-07 00:00:00
45	7	3	2009-02-26	\N	2009-02-25 00:00:00
46	7	3	2009-02-08	\N	2009-02-07 00:00:00
47	7	1	2009-02-22	\N	2009-02-21 00:00:00
48	7	1	2008-01-06	\N	2008-01-05 00:00:00
49	7	1	2008-01-07	\N	2008-01-06 00:00:00
50	7	1	2008-02-02	\N	2008-02-01 00:00:00
51	7	1	2008-02-20	\N	2008-02-19 00:00:00
52	7	1	2008-03-10	\N	2008-03-09 00:00:00
53	7	1	2008-03-28	\N	2008-03-27 00:00:00
54	7	1	2010-01-01	\N	2009-12-31 00:00:00
55	7	3	2008-02-08	\N	2008-02-07 00:00:00
56	7	3	2009-02-05	\N	2009-02-04 00:00:00
57	7	3	2009-02-23	\N	2009-02-22 00:00:00
58	7	3	2008-12-05	\N	2008-12-04 00:00:00
59	7	3	2008-12-24	\N	2008-12-23 00:00:00
60	7	3	2009-01-11	\N	2009-01-10 00:00:00
61	7	3	2009-01-18	\N	2009-01-17 00:00:00
62	7	2	2008-03-17	\N	2008-03-16 00:00:00
63	7	2	2010-01-29	\N	2010-01-28 00:00:00
64	7	2	2010-02-23	\N	2010-02-22 00:00:00
65	7	2	2010-02-23	\N	2010-02-22 00:00:00
66	7	2	2009-12-22	\N	2009-12-21 00:00:00
67	7	2	2009-03-05	\N	2009-03-04 00:00:00
68	7	2	2009-12-03	\N	2009-12-02 00:00:00
69	7	2	2009-02-15	\N	2009-02-14 00:00:00
70	7	2	2008-12-15	\N	2008-12-14 00:00:00
71	7	3	2009-02-15	\N	2009-02-14 00:00:00
72	7	3	2008-12-01	\N	2008-11-30 00:00:00
73	7	3	2008-12-19	\N	2008-12-18 00:00:00
74	7	3	2009-01-07	\N	2009-01-06 00:00:00
75	7	3	2009-01-26	\N	2009-01-25 00:00:00
76	7	3	2009-02-12	\N	2009-02-11 00:00:00
77	7	3	2009-03-03	\N	2009-03-02 00:00:00
78	7	2	2008-12-15	\N	2008-12-14 00:00:00
79	7	2	2010-01-24	\N	2010-01-23 00:00:00
80	7	2	2010-01-17	\N	2010-01-16 00:00:00
81	7	2	2009-12-29	\N	2009-12-28 00:00:00
82	7	2	2010-03-03	\N	2010-03-02 00:00:00
83	7	2	2010-02-12	\N	2010-02-11 00:00:00
84	7	2	2010-02-05	\N	2010-02-04 00:00:00
85	7	2	2009-12-11	\N	2009-12-10 00:00:00
86	7	2	2009-01-05	\N	2009-01-04 00:00:00
87	7	3	2008-12-22	\N	2008-12-21 00:00:00
88	7	3	2009-12-18	\N	2009-12-17 00:00:00
89	7	3	2010-02-01	\N	2010-01-31 00:00:00
90	7	3	2010-02-20	\N	2010-02-19 00:00:00
91	7	3	2010-01-12	\N	2010-01-11 00:00:00
92	7	3	2010-03-10	\N	2010-03-09 00:00:00
93	7	2	2008-12-27	\N	2008-12-26 00:00:00
94	7	2	2008-12-12	\N	2008-12-11 00:00:00
95	7	2	2008-12-19	\N	2008-12-18 00:00:00
96	7	2	2009-03-02	\N	2009-03-01 00:00:00
97	7	2	2009-02-10	\N	2009-02-09 00:00:00
98	7	2	2009-02-11	\N	2009-02-10 00:00:00
99	7	2	2009-01-06	\N	2009-01-05 00:00:00
100	7	2	2009-01-12	\N	2009-01-11 00:00:00
101	7	2	2009-01-25	\N	2009-01-24 00:00:00
102	7	2	2008-12-03	\N	2008-12-02 00:00:00
103	7	2	2009-12-06	\N	2009-12-05 00:00:00
104	7	2	2009-12-25	\N	2009-12-24 00:00:00
105	7	2	2009-12-25	\N	2009-12-24 00:00:00
106	7	2	2010-02-27	\N	2010-02-26 00:00:00
107	7	2	2010-02-08	\N	2010-02-07 00:00:00
108	7	1	2008-12-08	\N	2008-12-07 00:00:00
109	7	1	2008-12-07	\N	2008-12-06 00:00:00
110	7	1	2008-12-14	\N	2008-12-13 00:00:00
111	7	1	2008-12-17	\N	2008-12-16 00:00:00
112	7	1	2009-01-01	\N	2008-12-31 00:00:00
113	7	1	2008-12-25	\N	2008-12-24 00:00:00
114	7	1	2009-01-13	\N	2009-01-12 00:00:00
115	7	1	2009-01-20	\N	2009-01-19 00:00:00
116	7	1	2009-01-31	\N	2009-01-30 00:00:00
117	7	1	2009-02-18	\N	2009-02-17 00:00:00
118	7	1	2009-02-13	\N	2009-02-12 00:00:00
119	7	1	2009-02-25	\N	2009-02-24 00:00:00
120	7	1	2009-03-04	\N	2009-03-03 00:00:00
121	15	1	2009-01-02	\N	2009-01-01 00:00:00
122	15	2	2008-12-07	\N	2008-12-06 00:00:00
123	15	2	2008-12-07	\N	2008-12-06 00:00:00
124	15	3	2008-12-26	\N	2008-12-25 00:00:00
125	15	1	2009-01-20	\N	2009-01-19 00:00:00
126	15	1	2009-02-26	\N	2009-02-25 00:00:00
127	7	3	2009-01-03	\N	2009-01-02 00:00:00
128	7	3	2008-12-04	\N	2008-12-03 00:00:00
129	7	3	2008-12-22	\N	2008-12-21 00:00:00
130	7	3	2009-02-13	\N	2009-02-12 00:00:00
131	7	3	2009-02-15	\N	2009-02-14 00:00:00
132	7	3	2009-02-22	\N	2009-02-21 00:00:00
133	7	3	2009-01-10	\N	2009-01-09 00:00:00
134	7	1	2009-01-14	\N	2009-01-13 00:00:00
135	7	1	2008-12-04	\N	2008-12-03 00:00:00
136	7	1	2009-12-11	\N	2009-12-10 00:00:00
137	7	1	2009-02-23	\N	2009-02-22 00:00:00
138	7	1	2009-02-04	\N	2009-02-03 00:00:00
139	7	1	2010-01-06	\N	2010-01-05 00:00:00
140	7	1	2010-01-22	\N	2010-01-21 00:00:00
141	7	1	2010-01-24	\N	2010-01-23 00:00:00
142	7	1	2010-03-04	\N	2010-03-03 00:00:00
143	7	1	2010-02-13	\N	2010-02-12 00:00:00
144	7	1	2009-01-17	\N	2009-01-16 00:00:00
145	7	2	2009-01-27	\N	2009-01-26 00:00:00
146	7	2	2008-12-07	\N	2008-12-06 00:00:00
147	7	2	2008-12-26	\N	2008-12-25 00:00:00
148	7	2	2009-01-14	\N	2009-01-13 00:00:00
149	7	2	2009-01-31	\N	2009-01-30 00:00:00
150	7	2	2009-02-26	\N	2009-02-25 00:00:00
151	7	2	2009-02-19	\N	2009-02-18 00:00:00
152	7	2	2009-02-01	\N	2009-01-31 00:00:00
153	7	2	2008-12-16	\N	2008-12-15 00:00:00
154	7	2	2008-12-23	\N	2008-12-22 00:00:00
155	7	2	2009-01-04	\N	2009-01-03 00:00:00
156	7	2	2009-01-11	\N	2009-01-10 00:00:00
157	7	2	2009-02-03	\N	2009-02-02 00:00:00
158	7	2	2009-03-07	\N	2009-03-06 00:00:00
159	7	2	2009-02-16	\N	2009-02-15 00:00:00
160	7	1	2009-01-21	\N	2009-01-20 00:00:00
161	7	1	2008-12-15	\N	2008-12-14 00:00:00
162	7	1	2009-01-03	\N	2009-01-02 00:00:00
163	7	1	2009-02-08	\N	2009-02-07 00:00:00
164	7	1	2009-03-06	\N	2009-03-05 00:00:00
165	7	1	2009-01-22	\N	2009-01-21 00:00:00
166	7	1	2009-02-21	\N	2009-02-20 00:00:00
167	7	1	2008-12-02	\N	2008-12-01 00:00:00
168	7	1	2008-12-07	\N	2008-12-06 00:00:00
169	7	1	2008-12-14	\N	2008-12-13 00:00:00
170	7	1	2008-12-21	\N	2008-12-20 00:00:00
171	7	1	2009-01-02	\N	2009-01-01 00:00:00
172	7	1	2009-01-16	\N	2009-01-15 00:00:00
173	7	1	2009-01-21	\N	2009-01-20 00:00:00
174	7	1	2009-01-27	\N	2009-01-26 00:00:00
175	7	1	2009-02-02	\N	2009-02-01 00:00:00
176	7	1	2009-02-14	\N	2009-02-13 00:00:00
177	7	1	2009-02-21	\N	2009-02-20 00:00:00
178	7	1	2009-03-03	\N	2009-03-02 00:00:00
179	7	1	2009-03-05	\N	2009-03-04 00:00:00
180	7	3	2009-02-20	\N	2009-02-19 00:00:00
181	7	3	2008-12-09	\N	2008-12-08 00:00:00
182	7	3	2008-12-28	\N	2008-12-27 00:00:00
183	7	3	2009-01-22	\N	2009-01-21 00:00:00
184	7	3	2009-02-09	\N	2009-02-08 00:00:00
185	7	3	2009-02-28	\N	2009-02-27 00:00:00
186	7	2	2009-02-08	\N	2009-02-07 00:00:00
187	7	2	2008-12-09	\N	2008-12-08 00:00:00
188	7	2	2008-12-27	\N	2008-12-26 00:00:00
189	7	2	2009-01-15	\N	2009-01-14 00:00:00
190	7	2	2009-02-02	\N	2009-02-01 00:00:00
191	7	2	2009-02-26	\N	2009-02-25 00:00:00
192	7	1	2009-03-05	\N	2009-03-04 00:00:00
193	7	1	2008-12-06	\N	2008-12-05 00:00:00
194	7	1	2008-12-12	\N	2008-12-11 00:00:00
195	7	1	2008-12-17	\N	2008-12-16 00:00:00
196	7	1	2008-12-24	\N	2008-12-23 00:00:00
197	7	1	2008-12-31	\N	2008-12-30 00:00:00
198	7	1	2009-01-04	\N	2009-01-03 00:00:00
199	7	1	2009-01-12	\N	2009-01-11 00:00:00
200	7	1	2009-01-17	\N	2009-01-16 00:00:00
201	7	1	2009-01-29	\N	2009-01-28 00:00:00
202	7	1	2009-02-05	\N	2009-02-04 00:00:00
203	7	1	2009-02-24	\N	2009-02-23 00:00:00
204	7	1	2009-03-08	\N	2009-03-07 00:00:00
205	7	3	2009-02-26	\N	2009-02-25 00:00:00
206	7	3	2008-12-02	\N	2008-12-01 00:00:00
207	7	3	2008-12-02	\N	2008-12-01 00:00:00
208	7	3	2009-01-08	\N	2009-01-07 00:00:00
209	7	3	2009-01-27	\N	2009-01-26 00:00:00
210	7	3	2009-02-20	\N	2009-02-19 00:00:00
211	13	1	2009-02-28	\N	2009-02-27 00:00:00
212	13	1	2008-12-09	\N	2008-12-08 00:00:00
213	13	3	2010-02-23	\N	2010-02-22 00:00:00
214	13	2	2009-02-02	\N	2009-02-01 00:00:00
215	13	1	2009-01-15	\N	2009-01-14 00:00:00
216	13	1	2008-12-28	\N	2008-12-27 00:00:00
217	12	1	2009-01-04	\N	2009-01-03 00:00:00
218	12	3	2008-12-16	\N	2008-12-15 00:00:00
219	12	1	2009-01-22	\N	2009-01-21 00:00:00
220	12	1	2009-02-09	\N	2009-02-08 00:00:00
221	12	2	2009-03-06	\N	2009-03-05 00:00:00
222	8	1	2008-12-12	\N	2008-12-11 00:00:00
223	8	1	2009-01-26	\N	2009-01-25 00:00:00
224	7	1	2009-01-07	2011-08-31	2011-08-29 00:00:00
224	8	1	2011-09-01	\N	2011-08-31 00:00:00
225	8	2	2009-02-13	\N	2009-02-12 00:00:00
226	8	3	2009-03-03	\N	2009-03-02 00:00:00
227	14	1	2009-12-02	\N	2009-12-01 00:00:00
228	14	1	2008-12-14	\N	2008-12-13 00:00:00
229	14	3	2010-02-16	\N	2010-02-15 00:00:00
230	14	2	2010-03-05	\N	2010-03-04 00:00:00
231	14	3	2010-03-07	\N	2010-03-06 00:00:00
232	14	2	2010-01-27	\N	2010-01-26 00:00:00
233	14	1	2009-12-21	\N	2009-12-20 00:00:00
234	10	1	2009-01-31	2013-11-13	2013-11-11 00:00:00
234	16	1	2013-11-14	\N	2013-11-13 00:00:00
235	9	1	2008-12-06	\N	2008-12-05 00:00:00
236	9	1	2009-02-25	\N	2009-02-24 00:00:00
237	9	1	2009-02-06	\N	2009-02-05 00:00:00
238	9	1	2009-01-01	\N	2008-12-31 00:00:00
239	9	1	2008-12-25	\N	2008-12-24 00:00:00
240	9	1	2008-12-13	\N	2008-12-12 00:00:00
241	10	1	2009-01-30	\N	2009-01-29 00:00:00
242	10	1	2008-12-18	\N	2008-12-17 00:00:00
243	10	1	2009-01-06	\N	2009-01-05 00:00:00
244	10	1	2009-01-24	\N	2009-01-23 00:00:00
245	10	1	2009-02-18	\N	2009-02-17 00:00:00
246	10	1	2009-02-11	\N	2009-02-10 00:00:00
247	10	1	2009-03-01	\N	2009-02-28 00:00:00
248	10	1	2009-03-08	\N	2009-03-07 00:00:00
249	10	1	2008-12-25	\N	2008-12-24 00:00:00
250	4	1	2011-02-25	2011-07-30	2011-07-28 00:00:00
250	13	1	2011-07-31	2012-07-14	2012-07-12 00:00:00
250	5	1	2012-07-15	\N	2012-07-14 00:00:00
251	5	1	2009-02-10	\N	2009-02-09 00:00:00
252	5	1	2009-02-28	\N	2009-02-27 00:00:00
253	5	1	2009-12-17	\N	2009-12-16 00:00:00
254	5	1	2010-01-04	\N	2010-01-03 00:00:00
255	5	1	2010-01-11	\N	2010-01-10 00:00:00
256	5	1	2010-01-23	\N	2010-01-22 00:00:00
257	5	1	2010-01-27	\N	2010-01-26 00:00:00
258	5	1	2010-01-31	\N	2010-01-30 00:00:00
259	5	1	2010-03-09	\N	2010-03-08 00:00:00
260	5	1	2010-12-06	\N	2010-12-05 00:00:00
261	5	1	2010-12-25	\N	2010-12-24 00:00:00
262	10	1	2009-01-12	\N	2009-01-11 00:00:00
263	11	1	2008-12-11	\N	2008-12-10 00:00:00
264	11	1	2009-02-04	\N	2009-02-03 00:00:00
265	11	2	2008-12-04	\N	2008-12-03 00:00:00
266	11	1	2009-02-23	\N	2009-02-22 00:00:00
267	11	1	2009-02-16	\N	2009-02-15 00:00:00
268	11	1	2009-02-03	\N	2009-02-02 00:00:00
269	11	1	2009-01-11	\N	2009-01-10 00:00:00
270	11	1	2009-01-17	\N	2009-01-16 00:00:00
271	11	1	2009-01-22	\N	2009-01-21 00:00:00
272	11	1	2008-12-23	\N	2008-12-22 00:00:00
273	3	1	2011-02-15	\N	2011-02-14 00:00:00
274	3	1	2011-01-04	\N	2011-01-03 00:00:00
275	3	1	2011-05-31	\N	2011-05-30 00:00:00
276	3	1	2011-05-31	\N	2011-05-30 00:00:00
277	3	1	2011-05-31	\N	2011-05-30 00:00:00
278	3	1	2011-05-31	\N	2011-05-30 00:00:00
279	3	1	2011-05-31	\N	2011-05-30 00:00:00
280	3	1	2011-05-31	\N	2011-05-30 00:00:00
281	3	1	2011-05-31	\N	2011-05-30 00:00:00
282	3	1	2011-05-31	\N	2011-05-30 00:00:00
283	3	1	2011-05-31	\N	2011-05-30 00:00:00
284	3	1	2012-09-30	\N	2012-09-29 00:00:00
285	3	1	2013-03-14	\N	2013-03-13 00:00:00
286	3	1	2013-05-30	\N	2013-05-29 00:00:00
287	3	1	2012-04-16	\N	2012-04-15 00:00:00
288	3	1	2013-05-30	\N	2013-05-29 00:00:00
289	3	1	2012-05-30	\N	2012-05-29 00:00:00
290	3	1	2012-05-30	\N	2012-05-29 00:00:00
\.


--
-- Data for Name: employeepayhistory; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.employeepayhistory (businessentityid, ratechangedate, rate, payfrequency, modifieddate) FROM stdin;
1	2009-01-14 00:00:00	125.5	2	2014-06-30 00:00:00
2	2008-01-31 00:00:00	63.4615	2	2014-06-30 00:00:00
3	2007-11-11 00:00:00	43.2692	2	2014-06-30 00:00:00
4	2007-12-05 00:00:00	8.62	2	2007-11-21 00:00:00
4	2010-05-31 00:00:00	23.72	2	2010-05-16 00:00:00
4	2011-12-15 00:00:00	29.8462	2	2011-12-01 00:00:00
5	2008-01-06 00:00:00	32.6923	2	2014-06-30 00:00:00
6	2008-01-24 00:00:00	32.6923	2	2014-06-30 00:00:00
7	2009-02-08 00:00:00	50.4808	2	2014-06-30 00:00:00
8	2008-12-29 00:00:00	40.8654	2	2014-06-30 00:00:00
9	2009-01-16 00:00:00	40.8654	2	2014-06-30 00:00:00
10	2009-05-03 00:00:00	42.4808	2	2014-06-30 00:00:00
11	2010-12-05 00:00:00	28.8462	2	2014-06-30 00:00:00
12	2007-12-11 00:00:00	25	2	2014-06-30 00:00:00
13	2010-12-23 00:00:00	25	2	2014-06-30 00:00:00
14	2010-12-30 00:00:00	36.0577	2	2014-06-30 00:00:00
15	2011-01-18 00:00:00	32.6923	2	2014-06-30 00:00:00
16	2007-12-20 00:00:00	24	2	2007-12-06 00:00:00
16	2009-07-15 00:00:00	28.75	2	2009-07-01 00:00:00
16	2012-04-30 00:00:00	37.5	2	2012-04-16 00:00:00
17	2007-01-26 00:00:00	13.4615	2	2014-06-30 00:00:00
18	2011-02-07 00:00:00	14.4231	2	2014-06-30 00:00:00
19	2011-02-14 00:00:00	13.4615	2	2014-06-30 00:00:00
20	2011-01-07 00:00:00	13.4615	2	2014-06-30 00:00:00
21	2009-03-02 00:00:00	14.4231	2	2014-06-30 00:00:00
22	2008-12-12 00:00:00	14.4231	2	2014-06-30 00:00:00
23	2009-01-12 00:00:00	14.4231	2	2014-06-30 00:00:00
24	2009-01-18 00:00:00	14.4231	2	2014-06-30 00:00:00
25	2009-02-03 00:00:00	84.1346	2	2014-06-30 00:00:00
26	2008-12-01 00:00:00	24.5192	2	2014-06-30 00:00:00
27	2008-02-27 00:00:00	25	2	2014-06-30 00:00:00
28	2006-06-30 00:00:00	12.45	1	2014-06-30 00:00:00
29	2009-01-23 00:00:00	12.45	1	2014-06-30 00:00:00
30	2009-01-29 00:00:00	12.45	1	2014-06-30 00:00:00
31	2009-01-04 00:00:00	12.45	1	2014-06-30 00:00:00
32	2008-12-29 00:00:00	12.45	1	2014-06-30 00:00:00
33	2008-12-17 00:00:00	12.45	1	2014-06-30 00:00:00
34	2009-02-16 00:00:00	12.45	1	2014-06-30 00:00:00
35	2009-02-08 00:00:00	12.45	1	2014-06-30 00:00:00
36	2009-02-10 00:00:00	12.45	1	2014-06-30 00:00:00
37	2009-03-07 00:00:00	12.45	1	2014-06-30 00:00:00
38	2010-01-16 00:00:00	12.45	1	2014-06-30 00:00:00
39	2010-02-05 00:00:00	12.45	1	2014-06-30 00:00:00
40	2007-12-26 00:00:00	25	2	2014-06-30 00:00:00
41	2009-01-21 00:00:00	12.45	1	2014-06-30 00:00:00
42	2008-12-27 00:00:00	12.45	1	2014-06-30 00:00:00
43	2009-01-02 00:00:00	12.45	1	2014-06-30 00:00:00
44	2008-12-08 00:00:00	12.45	1	2014-06-30 00:00:00
45	2009-02-26 00:00:00	12.45	1	2014-06-30 00:00:00
46	2009-02-08 00:00:00	12.45	1	2014-06-30 00:00:00
47	2009-02-22 00:00:00	25	2	2014-06-30 00:00:00
48	2008-01-06 00:00:00	13.45	1	2014-06-30 00:00:00
49	2008-01-07 00:00:00	13.45	1	2014-06-30 00:00:00
50	2008-02-02 00:00:00	13.45	1	2014-06-30 00:00:00
51	2008-02-20 00:00:00	13.45	1	2014-06-30 00:00:00
52	2008-03-10 00:00:00	13.45	1	2014-06-30 00:00:00
53	2008-03-28 00:00:00	13.45	1	2014-06-30 00:00:00
54	2010-01-01 00:00:00	13.45	1	2014-06-30 00:00:00
55	2008-02-08 00:00:00	25	2	2014-06-30 00:00:00
56	2009-02-05 00:00:00	11	1	2014-06-30 00:00:00
57	2009-02-23 00:00:00	11	1	2014-06-30 00:00:00
58	2008-12-05 00:00:00	11	1	2014-06-30 00:00:00
59	2008-12-24 00:00:00	11	1	2014-06-30 00:00:00
60	2009-01-11 00:00:00	11	1	2014-06-30 00:00:00
61	2009-01-18 00:00:00	11	1	2014-06-30 00:00:00
62	2008-03-17 00:00:00	25	2	2014-06-30 00:00:00
63	2010-01-29 00:00:00	12.45	1	2014-06-30 00:00:00
64	2010-02-23 00:00:00	12.45	1	2014-06-30 00:00:00
65	2010-02-23 00:00:00	12.45	1	2014-06-30 00:00:00
66	2009-12-22 00:00:00	12.45	1	2014-06-30 00:00:00
67	2009-03-05 00:00:00	12.45	1	2014-06-30 00:00:00
68	2009-12-03 00:00:00	12.45	1	2014-06-30 00:00:00
69	2009-02-15 00:00:00	12.45	1	2014-06-30 00:00:00
70	2008-12-15 00:00:00	12.45	1	2014-06-30 00:00:00
71	2009-02-15 00:00:00	25	2	2014-06-30 00:00:00
72	2008-12-01 00:00:00	9.5	1	2014-06-30 00:00:00
73	2008-12-19 00:00:00	9.5	1	2014-06-30 00:00:00
74	2009-01-07 00:00:00	9.5	1	2014-06-30 00:00:00
75	2009-01-26 00:00:00	9.5	1	2014-06-30 00:00:00
76	2009-02-12 00:00:00	9.5	1	2014-06-30 00:00:00
77	2009-03-03 00:00:00	9.5	1	2014-06-30 00:00:00
78	2008-12-15 00:00:00	25	2	2014-06-30 00:00:00
79	2010-01-24 00:00:00	15	1	2014-06-30 00:00:00
80	2010-01-17 00:00:00	15	1	2014-06-30 00:00:00
81	2009-12-29 00:00:00	15	1	2014-06-30 00:00:00
82	2010-03-03 00:00:00	15	1	2014-06-30 00:00:00
83	2010-02-12 00:00:00	15	1	2014-06-30 00:00:00
84	2010-02-05 00:00:00	15	1	2014-06-30 00:00:00
85	2009-12-11 00:00:00	15	1	2014-06-30 00:00:00
86	2009-01-05 00:00:00	15	1	2014-06-30 00:00:00
87	2008-12-22 00:00:00	25	2	2014-06-30 00:00:00
88	2009-12-18 00:00:00	13.45	1	2014-06-30 00:00:00
89	2010-02-01 00:00:00	13.45	1	2014-06-30 00:00:00
90	2010-02-20 00:00:00	13.45	1	2014-06-30 00:00:00
91	2010-01-12 00:00:00	13.45	1	2014-06-30 00:00:00
92	2010-03-10 00:00:00	13.45	1	2014-06-30 00:00:00
93	2008-12-27 00:00:00	25	2	2014-06-30 00:00:00
94	2008-12-12 00:00:00	11	1	2014-06-30 00:00:00
95	2008-12-19 00:00:00	11	1	2014-06-30 00:00:00
96	2009-03-02 00:00:00	11	1	2014-06-30 00:00:00
97	2009-02-10 00:00:00	11	1	2014-06-30 00:00:00
98	2009-02-11 00:00:00	11	1	2014-06-30 00:00:00
99	2009-01-06 00:00:00	11	1	2014-06-30 00:00:00
100	2009-01-12 00:00:00	11	1	2014-06-30 00:00:00
101	2009-01-25 00:00:00	11	1	2014-06-30 00:00:00
102	2008-12-03 00:00:00	25	2	2014-06-30 00:00:00
103	2009-12-06 00:00:00	13.45	1	2014-06-30 00:00:00
104	2009-12-25 00:00:00	13.45	1	2014-06-30 00:00:00
105	2009-12-25 00:00:00	13.45	1	2014-06-30 00:00:00
106	2010-02-27 00:00:00	13.45	1	2014-06-30 00:00:00
107	2010-02-08 00:00:00	13.45	1	2014-06-30 00:00:00
108	2008-12-08 00:00:00	25	2	2014-06-30 00:00:00
109	2008-12-07 00:00:00	11	1	2014-06-30 00:00:00
110	2008-12-14 00:00:00	11	1	2014-06-30 00:00:00
111	2008-12-17 00:00:00	11	1	2014-06-30 00:00:00
112	2009-01-01 00:00:00	11	1	2014-06-30 00:00:00
113	2008-12-25 00:00:00	11	1	2014-06-30 00:00:00
114	2009-01-13 00:00:00	11	1	2014-06-30 00:00:00
115	2009-01-20 00:00:00	11	1	2014-06-30 00:00:00
116	2009-01-31 00:00:00	11	1	2014-06-30 00:00:00
117	2009-02-18 00:00:00	11	1	2014-06-30 00:00:00
118	2009-02-13 00:00:00	11	1	2014-06-30 00:00:00
119	2009-02-25 00:00:00	11	1	2014-06-30 00:00:00
120	2009-03-04 00:00:00	11	1	2014-06-30 00:00:00
121	2009-01-02 00:00:00	19.2308	2	2014-06-30 00:00:00
122	2008-12-07 00:00:00	9	1	2014-06-30 00:00:00
123	2008-12-07 00:00:00	9.5	2	2014-06-30 00:00:00
124	2008-12-26 00:00:00	9	1	2014-06-30 00:00:00
125	2009-01-20 00:00:00	9.5	2	2014-06-30 00:00:00
126	2009-02-26 00:00:00	9	1	2014-06-30 00:00:00
127	2009-01-03 00:00:00	25	2	2014-06-30 00:00:00
128	2008-12-04 00:00:00	15	1	2014-06-30 00:00:00
129	2008-12-22 00:00:00	15	1	2014-06-30 00:00:00
130	2009-02-13 00:00:00	15	1	2014-06-30 00:00:00
131	2009-02-15 00:00:00	15	1	2014-06-30 00:00:00
132	2009-02-22 00:00:00	15	1	2014-06-30 00:00:00
133	2009-01-10 00:00:00	15	1	2014-06-30 00:00:00
134	2009-01-14 00:00:00	25	2	2014-06-30 00:00:00
135	2008-12-04 00:00:00	14	1	2014-06-30 00:00:00
136	2009-12-11 00:00:00	14	1	2014-06-30 00:00:00
137	2009-02-23 00:00:00	14	1	2014-06-30 00:00:00
138	2009-02-04 00:00:00	14	1	2014-06-30 00:00:00
139	2010-01-06 00:00:00	14	1	2014-06-30 00:00:00
140	2010-01-22 00:00:00	14	1	2014-06-30 00:00:00
141	2010-01-24 00:00:00	14	1	2014-06-30 00:00:00
142	2010-03-04 00:00:00	14	1	2014-06-30 00:00:00
143	2010-02-13 00:00:00	14	1	2014-06-30 00:00:00
144	2009-01-17 00:00:00	14	1	2014-06-30 00:00:00
145	2009-01-27 00:00:00	25	2	2014-06-30 00:00:00
146	2008-12-07 00:00:00	9.5	1	2014-06-30 00:00:00
147	2008-12-26 00:00:00	9.5	1	2014-06-30 00:00:00
148	2009-01-14 00:00:00	9.5	1	2014-06-30 00:00:00
149	2009-01-31 00:00:00	9.5	1	2014-06-30 00:00:00
150	2009-02-26 00:00:00	9.5	1	2014-06-30 00:00:00
151	2009-02-19 00:00:00	9.5	1	2014-06-30 00:00:00
152	2009-02-01 00:00:00	25	2	2014-06-30 00:00:00
153	2008-12-16 00:00:00	14	1	2014-06-30 00:00:00
154	2008-12-23 00:00:00	14	1	2014-06-30 00:00:00
155	2009-01-04 00:00:00	14	1	2014-06-30 00:00:00
156	2009-01-11 00:00:00	14	1	2014-06-30 00:00:00
157	2009-02-03 00:00:00	14	1	2014-06-30 00:00:00
158	2009-03-07 00:00:00	14	1	2014-06-30 00:00:00
159	2009-02-16 00:00:00	14	1	2014-06-30 00:00:00
160	2009-01-21 00:00:00	25	2	2014-06-30 00:00:00
161	2008-12-15 00:00:00	10	1	2014-06-30 00:00:00
162	2009-01-03 00:00:00	10	1	2014-06-30 00:00:00
163	2009-02-08 00:00:00	10	1	2014-06-30 00:00:00
164	2009-03-06 00:00:00	10	1	2014-06-30 00:00:00
165	2009-01-22 00:00:00	10	1	2014-06-30 00:00:00
166	2009-02-21 00:00:00	25	2	2014-06-30 00:00:00
167	2008-12-02 00:00:00	6.5	1	2008-11-18 00:00:00
167	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
167	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
168	2008-12-07 00:00:00	9.5	1	2014-06-30 00:00:00
169	2008-12-14 00:00:00	9.5	1	2014-06-30 00:00:00
170	2008-12-21 00:00:00	6.5	1	2008-12-07 00:00:00
170	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
170	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
171	2009-01-02 00:00:00	9.5	1	2014-06-30 00:00:00
172	2009-01-16 00:00:00	6.5	1	2009-01-02 00:00:00
172	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
172	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
173	2009-01-21 00:00:00	9.5	1	2014-06-30 00:00:00
174	2009-01-27 00:00:00	6.75	1	2009-01-13 00:00:00
174	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
174	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
175	2009-02-02 00:00:00	6.5	1	2009-01-19 00:00:00
175	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
175	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
176	2009-02-14 00:00:00	6.5	1	2009-01-31 00:00:00
176	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
176	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
177	2009-02-21 00:00:00	6.5	1	2009-02-07 00:00:00
177	2011-12-01 00:00:00	7.25	1	2011-11-17 00:00:00
177	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
178	2009-03-03 00:00:00	6.5	1	2009-02-17 00:00:00
178	2011-12-01 00:00:00	7	1	2011-11-17 00:00:00
178	2013-07-14 00:00:00	9.5	1	2013-06-30 00:00:00
179	2009-03-05 00:00:00	9.5	1	2014-06-30 00:00:00
180	2009-02-20 00:00:00	25	2	2014-06-30 00:00:00
181	2008-12-09 00:00:00	14	1	2014-06-30 00:00:00
182	2008-12-28 00:00:00	14	1	2014-06-30 00:00:00
183	2009-01-22 00:00:00	14	1	2014-06-30 00:00:00
184	2009-02-09 00:00:00	14	1	2014-06-30 00:00:00
185	2009-02-28 00:00:00	14	1	2014-06-30 00:00:00
186	2009-02-08 00:00:00	25	2	2014-06-30 00:00:00
187	2008-12-09 00:00:00	10	1	2014-06-30 00:00:00
188	2008-12-27 00:00:00	10	1	2014-06-30 00:00:00
189	2009-01-15 00:00:00	10	1	2014-06-30 00:00:00
190	2009-02-02 00:00:00	10	1	2014-06-30 00:00:00
191	2009-02-26 00:00:00	10	1	2014-06-30 00:00:00
192	2009-03-05 00:00:00	25	2	2014-06-30 00:00:00
193	2008-12-06 00:00:00	15	1	2014-06-30 00:00:00
194	2008-12-12 00:00:00	15	1	2014-06-30 00:00:00
195	2008-12-17 00:00:00	15	1	2014-06-30 00:00:00
196	2008-12-24 00:00:00	15	1	2014-06-30 00:00:00
197	2008-12-31 00:00:00	15	1	2014-06-30 00:00:00
198	2009-01-04 00:00:00	15	1	2014-06-30 00:00:00
199	2009-01-12 00:00:00	15	1	2014-06-30 00:00:00
200	2009-01-17 00:00:00	15	1	2014-06-30 00:00:00
201	2009-01-29 00:00:00	15	1	2014-06-30 00:00:00
202	2009-02-05 00:00:00	15	1	2014-06-30 00:00:00
203	2009-02-24 00:00:00	15	1	2014-06-30 00:00:00
204	2009-03-08 00:00:00	15	1	2014-06-30 00:00:00
205	2009-02-26 00:00:00	25	2	2014-06-30 00:00:00
206	2008-12-02 00:00:00	10	1	2014-06-30 00:00:00
207	2008-12-02 00:00:00	10	1	2014-06-30 00:00:00
208	2009-01-08 00:00:00	10	1	2014-06-30 00:00:00
209	2009-01-27 00:00:00	10	1	2014-06-30 00:00:00
210	2009-02-20 00:00:00	10	1	2014-06-30 00:00:00
211	2009-02-28 00:00:00	28.8462	2	2014-06-30 00:00:00
212	2008-12-09 00:00:00	21.6346	2	2014-06-30 00:00:00
213	2010-02-23 00:00:00	10.5769	2	2014-06-30 00:00:00
214	2009-02-02 00:00:00	10.5769	2	2014-06-30 00:00:00
215	2009-01-15 00:00:00	10.5769	2	2014-06-30 00:00:00
216	2008-12-28 00:00:00	10.5769	2	2014-06-30 00:00:00
217	2009-01-04 00:00:00	17.7885	2	2014-06-30 00:00:00
218	2008-12-16 00:00:00	16.8269	2	2014-06-30 00:00:00
219	2009-01-22 00:00:00	10.25	2	2014-06-30 00:00:00
220	2009-02-09 00:00:00	10.25	2	2014-06-30 00:00:00
221	2009-03-06 00:00:00	16.8269	2	2014-06-30 00:00:00
222	2008-12-12 00:00:00	23.5577	2	2014-06-30 00:00:00
223	2009-01-26 00:00:00	16	2	2014-06-30 00:00:00
224	2008-01-08 00:00:00	8.62	2	2007-12-25 00:00:00
224	2011-08-31 00:00:00	13.5	2	2011-08-17 00:00:00
224	2012-01-01 00:00:00	16	2	2011-12-18 00:00:00
225	2009-02-13 00:00:00	16	2	2014-06-30 00:00:00
226	2009-03-03 00:00:00	16	2	2014-06-30 00:00:00
227	2009-12-02 00:00:00	24.0385	2	2014-06-30 00:00:00
228	2008-12-14 00:00:00	20.4327	2	2014-06-30 00:00:00
229	2010-02-16 00:00:00	9.25	1	2014-06-30 00:00:00
230	2010-03-05 00:00:00	9.25	1	2014-06-30 00:00:00
231	2010-03-07 00:00:00	9.25	1	2014-06-30 00:00:00
232	2010-01-27 00:00:00	9.25	1	2014-06-30 00:00:00
233	2009-12-21 00:00:00	9.75	2	2014-06-30 00:00:00
234	2009-01-31 00:00:00	39.06	2	2009-01-17 00:00:00
234	2011-11-14 00:00:00	48.5577	2	2011-10-31 00:00:00
234	2012-01-29 00:00:00	60.0962	2	2012-01-15 00:00:00
235	2008-12-06 00:00:00	27.1394	2	2014-06-30 00:00:00
236	2009-02-25 00:00:00	13.9423	2	2014-06-30 00:00:00
237	2009-02-06 00:00:00	13.9423	2	2014-06-30 00:00:00
238	2009-01-01 00:00:00	18.2692	2	2014-06-30 00:00:00
239	2008-12-25 00:00:00	16.5865	2	2014-06-30 00:00:00
240	2008-12-13 00:00:00	18.2692	2	2014-06-30 00:00:00
241	2009-01-30 00:00:00	34.7356	2	2014-06-30 00:00:00
242	2008-12-18 00:00:00	19	2	2014-06-30 00:00:00
243	2009-01-06 00:00:00	19	2	2014-06-30 00:00:00
244	2009-01-24 00:00:00	19	2	2014-06-30 00:00:00
245	2009-02-18 00:00:00	26.4423	2	2014-06-30 00:00:00
246	2009-02-11 00:00:00	19	2	2014-06-30 00:00:00
247	2009-03-01 00:00:00	19	2	2014-06-30 00:00:00
248	2009-03-08 00:00:00	26.4423	2	2014-06-30 00:00:00
249	2008-12-25 00:00:00	43.2692	2	2014-06-30 00:00:00
250	2011-02-21 00:00:00	9.86	2	2011-02-07 00:00:00
250	2011-07-30 00:00:00	22.5	2	2011-07-16 00:00:00
250	2012-07-14 00:00:00	30	2	2012-06-30 00:00:00
251	2009-02-10 00:00:00	18.2692	2	2014-06-30 00:00:00
252	2009-02-28 00:00:00	18.2692	2	2014-06-30 00:00:00
253	2009-12-17 00:00:00	18.2692	2	2014-06-30 00:00:00
254	2010-01-04 00:00:00	18.2692	2	2014-06-30 00:00:00
255	2010-01-11 00:00:00	18.2692	2	2014-06-30 00:00:00
256	2010-01-23 00:00:00	18.2692	2	2014-06-30 00:00:00
257	2010-01-27 00:00:00	18.2692	2	2014-06-30 00:00:00
258	2010-01-31 00:00:00	18.2692	2	2014-06-30 00:00:00
259	2010-03-09 00:00:00	18.2692	2	2014-06-30 00:00:00
260	2010-12-06 00:00:00	12.75	2	2014-06-30 00:00:00
261	2010-12-25 00:00:00	12.75	2	2014-06-30 00:00:00
262	2009-01-12 00:00:00	13.4615	2	2014-06-30 00:00:00
263	2008-12-11 00:00:00	50.4808	2	2014-06-30 00:00:00
264	2009-02-04 00:00:00	39.6635	2	2014-06-30 00:00:00
265	2008-12-04 00:00:00	32.4519	2	2014-06-30 00:00:00
266	2009-02-23 00:00:00	32.4519	2	2014-06-30 00:00:00
267	2009-02-16 00:00:00	27.4038	2	2014-06-30 00:00:00
268	2009-02-03 00:00:00	27.4038	2	2014-06-30 00:00:00
269	2009-01-11 00:00:00	27.4038	2	2014-06-30 00:00:00
270	2009-01-17 00:00:00	38.4615	2	2014-06-30 00:00:00
271	2009-01-22 00:00:00	38.4615	2	2014-06-30 00:00:00
272	2008-12-23 00:00:00	27.4038	2	2014-06-30 00:00:00
273	2011-02-15 00:00:00	72.1154	2	2014-06-30 00:00:00
274	2011-01-04 00:00:00	48.101	2	2014-06-30 00:00:00
275	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
276	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
277	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
278	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
279	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
280	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
281	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
282	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
283	2011-05-31 00:00:00	23.0769	2	2014-06-30 00:00:00
284	2012-09-30 00:00:00	23.0769	2	2014-06-30 00:00:00
285	2013-03-14 00:00:00	48.101	2	2014-06-30 00:00:00
286	2013-05-30 00:00:00	23.0769	2	2014-06-30 00:00:00
287	2012-04-16 00:00:00	48.101	2	2014-06-30 00:00:00
288	2013-05-30 00:00:00	23.0769	2	2014-06-30 00:00:00
289	2012-05-30 00:00:00	23.0769	2	2014-06-30 00:00:00
290	2012-05-30 00:00:00	23.0769	2	2014-06-30 00:00:00
\.


--
-- Data for Name: jobcandidate; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.jobcandidate (jobcandidateid, businessentityid, resume, modifieddate) FROM stdin;
1	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix/><ns:Name.First>Shai</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Bassli</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>\\nI am an experienced and versatile machinist who can operate a range of machinery personally as well as supervise the work of other machinists. I specialize in diagnostics and precision inspection, have expertise in reading blueprints, and am able to call on strong interpersonal and communication skills to guide the work of other production machinists whose work I am called upon to inspect. \\nMy degree in mechanical engineering affords me a better theoretical understanding and mathematical background than many other candidates in the machinist trade.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>2000-06-01Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-09-30Z</ns:Emp.EndDate><ns:Emp.OrgName>Wingtip Toys</ns:Emp.OrgName><ns:Emp.JobTitle>Lead Machinist</ns:Emp.JobTitle><ns:Emp.Responsibility> Supervised work of staff of four machinists. Coordinated all complex assembly and tooling activities, including production of tricycles and wagons.\\nDeveloped parts fabrication from sample parts, drawings and verbal orders.Worked with ISO9000 implementation.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Manufacturing</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>MI </ns:Loc.State><ns:Loc.City>Saginaw</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1996-11-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2000-05-01Z</ns:Emp.EndDate><ns:Emp.OrgName>Blue Yonder Airlines</ns:Emp.OrgName><ns:Emp.JobTitle>Machinist</ns:Emp.JobTitle><ns:Emp.Responsibility>Repaired and maintained a variety of production and fabrication machine tools.\\nSet up and operated machines to close tolerances. Used and wrote CNC machine programs. Trained extensively in computer-aided manufacturing.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Manufacturing</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IL </ns:Loc.State><ns:Loc.City>Chicago</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1994-06-10Z</ns:Emp.StartDate><ns:Emp.EndDate>1996-07-22Z</ns:Emp.EndDate><ns:Emp.OrgName>City Power and Light</ns:Emp.OrgName><ns:Emp.JobTitle>Assistant Machinist</ns:Emp.JobTitle><ns:Emp.Responsibility>Performed centerless grinding. Received training in manual mill and lathe machines, as well as micrometers and calipers.\\nOwned complete toolset.Worked extensive overtime on request. </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Manufacturing</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IA </ns:Loc.State><ns:Loc.City>Des Moines</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>Bachelor</ns:Edu.Level><ns:Edu.StartDate>1990-09-15Z</ns:Edu.StartDate><ns:Edu.EndDate>1994-05-10Z</ns:Edu.EndDate><ns:Edu.Degree>Bachelor of Science</ns:Edu.Degree><ns:Edu.Major>Mechanical Engineering</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.2</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Midwest State University</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IA </ns:Loc.State><ns:Loc.City>Ames</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>567 3rd Ave</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>MI </ns:Loc.State><ns:Loc.City>Saginaw</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>53900</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>276</ns:Tel.AreaCode><ns:Tel.Number>555-0114</ns:Tel.Number></ns:Telephone><ns:Telephone><ns:Tel.Type>Fax</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>276</ns:Tel.AreaCode><ns:Tel.Number>555-0132</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail>Shai@Example.com</ns:EMail><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
2	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>Mr.</ns:Name.Prefix><ns:Name.First>Max</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Benson</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>3 years recent experience as a go-cart production line manager. Responsibilities included planning the production line budget, ordering parts, and overseeing all quality assurance procedures.\\nPrior to production management, worked 5 years on go-cart production lines (3 years while in college and for 2 years after), with increasing responsibilities over time. Responsibilities started with basic assembly and grew to quality assurance lead for brake systems.\\nLed an ISO 9000 certification process. Passed state exams for chemical and industrial safety. Recently recertified in basic first aid.\\nAvid cycler, placing in the top five in two Orlando-area races.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1994-06-15Z</ns:Emp.StartDate><ns:Emp.OrgName>Wingtip Toys</ns:Emp.OrgName><ns:Emp.JobTitle>Production Manager</ns:Emp.JobTitle><ns:Emp.Responsibility>Production manager Quality assurance lead Safety representative ISO 9000 certification lead\\nProduction line worker\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Manufacturing</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>Bachelor</ns:Edu.Level><ns:Edu.StartDate>1993-09-04Z</ns:Edu.StartDate><ns:Edu.EndDate>1997-06-03Z</ns:Edu.EndDate><ns:Edu.Degree>Bachelor of Science</ns:Edu.Degree><ns:Edu.Major>Industrial Engineering</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.4</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Everglades State College</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Tampa Bay</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Education><ns:Edu.Level>High School</ns:Edu.Level><ns:Edu.StartDate>1989-08-27Z</ns:Edu.StartDate><ns:Edu.EndDate>1993-06-12Z</ns:Edu.EndDate><ns:Edu.Degree>Diploma</ns:Edu.Degree><ns:Edu.Major/><ns:Edu.Minor/><ns:Edu.GPA>3.8</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Evergreen High School</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>12345 Cypress Drive</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>37811</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>407</ns:Tel.AreaCode><ns:Tel.Number>555-0101</ns:Tel.Number></ns:Telephone><ns:Telephone><ns:Tel.Type>Pager</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>407</ns:Tel.AreaCode><ns:Tel.Number>555-0122</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail>Max@Wingtiptoys.com</ns:EMail><ns:WebSite>http://www.Wingtiptoys.com</ns:WebSite></ns:Resume>	2007-06-23 00:00:00
3	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>Mr.</ns:Name.Prefix><ns:Name.First>Krishna</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Sunkammurali</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills> Expert in C# and Visual Basic 6.0. 7 years experience in object-oriented programming. Familiar with ASP.Net and the .NET Framework. Design experience with both Windows and Web user interfaces.\\n5 years experience in programming against MS SQL Server 7.0 and 2000. Familiar with ODBC, OLE DB, ADO, and ADO.NET. Conversant with T-SQL, skilled at writing stored procedures.\\nExcellent organizational, interpersonal, written and verbal communication skills.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1998-08-31Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-12-28Z</ns:Emp.EndDate><ns:Emp.OrgName>Trey Research</ns:Emp.OrgName><ns:Emp.JobTitle>Senior Developer</ns:Emp.JobTitle><ns:Emp.Responsibility> Used C# and ASP.NET to create several intranet applications. These included an application to analyze research data using SQL Server Analysis Services, and another to publish sales and financial reports for use by field offices.\\nWrote C# and Visual Basic 6.0 DLLs to encapsulate the business logic for all new internal applications. Updated existing client-server system, moved all business logic to the middle tier to improve performance and scalability. Used Visual Basic 6.0. \\nAssist in the database design and stored procedure creation for all new applications. Use both SQL Server 7.0 and SQL Server 2000.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Technology</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Market Research</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Renton</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1995-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1998-08-01Z</ns:Emp.EndDate><ns:Emp.OrgName>Contoso Pharmaceuticals</ns:Emp.OrgName><ns:Emp.JobTitle>Windows Programmer</ns:Emp.JobTitle><ns:Emp.Responsibility>Wrote Visual Basic 5.0 ActiveX DLLs to encapsulate the business logic for all internal applications. Designed and implemented a Windows application to consolidate and display business information from several different sources, including Access, Excel And SQL Server. Used Visual Basic 5.0 and Crystal Reports. Assisted in the database design for a new product quality assurance application. Wrote all stored procedures required for data retrieval by the front-end application. Used SQL Server 7.0.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Technology</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Pharmaceuticals</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Bellevue</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1993-05-10Z</ns:Emp.StartDate><ns:Emp.EndDate>1995-06-01Z</ns:Emp.EndDate><ns:Emp.OrgName>Southridge Video</ns:Emp.OrgName><ns:Emp.JobTitle>Purchasing Manager</ns:Emp.JobTitle><ns:Emp.Responsibility>Tracked inventory in regional stores. Placed all necessary orders, managed vendor relationships. Built an Access 2.0 database, migrated inventory tracking from Excel to Access. Built a user interface for the Access inventory database using Visual Basic 4.0.\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Purchasing</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Entertainment</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Kent</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>Bachelor</ns:Edu.Level><ns:Edu.StartDate>1989-09-15Z</ns:Edu.StartDate><ns:Edu.EndDate>1993-06-10Z</ns:Edu.EndDate><ns:Edu.Degree>Bachelor of Science</ns:Edu.Degree><ns:Edu.Major>Business</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.6</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Western University</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Seattle</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>1234 3rd Ave S.</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Issaquah</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>89027</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>425</ns:Tel.AreaCode><ns:Tel.Number>555-0111</ns:Tel.Number></ns:Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>206</ns:Tel.AreaCode><ns:Tel.Number>555-0198</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>6789 80th Ave SE</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Mercer Island</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>98240</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>206</ns:Tel.AreaCode><ns:Tel.Number>555-0153</ns:Tel.Number></ns:Telephone><ns:Telephone><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>206</ns:Tel.AreaCode><ns:Tel.Number>3217342</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:Address><ns:Addr.Type>Permanent</ns:Addr.Type><ns:Addr.Street>789 Elm Street</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Redmond</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>98052</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>425</ns:Tel.AreaCode><ns:Tel.Number>555-0155</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:Telephone><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>425</ns:Tel.AreaCode><ns:Tel.Number>555-0177</ns:Tel.Number></ns:Telephone><ns:EMail>Krishna@TreyResearch.net</ns:EMail><ns:WebSite>http://www.TreyResearch.net</ns:WebSite></ns:Resume>	2007-06-23 00:00:00
4	274	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>Mr.</ns:Name.Prefix><ns:Name.First>Stephen</ns:Name.First><ns:Name.Middle>Y </ns:Name.Middle><ns:Name.Last>Jiang</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills> Considerable expertise in all areas of the sales cycle. 13 years of achievement in increasing organization revenue. Experience in sales planning and forecasting, customer development, and multiple selling techniques. 5 years of experience in sales management, including lead generation, sales force leadership, and territory management. Leverage management style and technical ability to effectively manage and communicate with a distributed sales force composed of field representatives, product demonstrators, and vendors.\\nExcellent communication and presentation skills.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1998-03-01Z</ns:Emp.StartDate><ns:Emp.EndDate>2000-12-30Z</ns:Emp.EndDate><ns:Emp.OrgName>Wide World Imports</ns:Emp.OrgName><ns:Emp.JobTitle>Sales Manager</ns:Emp.JobTitle><ns:Emp.Responsibility> Managed a sales force of 20 sales representatives and 5 support staff distributed across 5 states. Also managed relationships with vendors for lead generation.\\nLead the effort to leverage IT capabilities to improve communication with the field. Improved lead-to-contact turnaround by 15 percent. Did all sales planning and forecasting. Re-mapped territory assignments for maximum sales force productivity. Worked with marketing to map product placement to sales strategy and goals. \\nUnder my management, sales increased 10% per year at a minimum.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Sales</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Import/Export</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Renton</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1992-06-14Z</ns:Emp.StartDate><ns:Emp.EndDate>1998-06-01Z</ns:Emp.EndDate><ns:Emp.OrgName>Fourth Coffee</ns:Emp.OrgName><ns:Emp.JobTitle>Sales Associater</ns:Emp.JobTitle><ns:Emp.Responsibility>Selling product to supermarkets and cafes. Worked heavily with value-add techniques to increase sales volume, provide exposure to secondary products.\\nSkilled at order development. Observed and built relationships with buyers that allowed me to identify opportunities for increased traffic.\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Sales</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Food and Beverage</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Spokane</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>Bachelor</ns:Edu.Level><ns:Edu.StartDate>1986-09-15Z</ns:Edu.StartDate><ns:Edu.EndDate>1990-05-20Z</ns:Edu.EndDate><ns:Edu.Degree>Bachelor of Arts and Science</ns:Edu.Degree><ns:Edu.Major>Business</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.3</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Louisiana Business College of New Orleans</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>LA</ns:Loc.State><ns:Loc.City>New Orleans</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>30 151st Place SE</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Redmond</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>98052</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>425</ns:Tel.AreaCode><ns:Tel.Number>555-1119</ns:Tel.Number></ns:Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>425</ns:Tel.AreaCode><ns:Tel.Number>555-1981</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail>Stephen@example.com</ns:EMail><ns:WebSite/></ns:Resume>	2013-12-22 18:32:21.313
5	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>M.</ns:Name.Prefix><ns:Name.First>Thierry</ns:Name.First><ns:Name.Middle/><ns:Name.Last>D'Hers</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>Connaissances approfondies de tous les secteurs du cycle des ventes. 13 annÃ©es d'expÃ©rience consacrÃ©es Ã  l'augmentation du chiffre d'affaires de diffÃ©rentes entreprises. ExpÃ©rience en planification et en prÃ©vision des ventes, en dÃ©veloppement de la clientÃ¨le et en diverses techniques de vente. 5 annÃ©es d'expÃ©rience en gestion des ventes, notamment en gÃ©nÃ©ration de prospects, direction de l'Ã©quipe de vente et gestion de zones gÃ©ographiques. Style de gestion avec effet de levier et aptitude technique Ã  gÃ©rer et Ã  communiquer efficacement avec une Ã©quipe de vente rÃ©partie dans plusieurs agences et composÃ©e de reprÃ©sentants commerciaux, de dÃ©monstrateurs de produits et de vendeurs.\\nExcellentes compÃ©tences en matiÃ¨re de communication et de prÃ©sentation.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1998-03-31Z</ns:Emp.StartDate><ns:Emp.OrgName>Importations Internationales</ns:Emp.OrgName><ns:Emp.JobTitle>Directeur commercial</ns:Emp.JobTitle><ns:Emp.Responsibility>Gestion d'une Ã©quipe de vente composÃ©e de 20 reprÃ©sentants et de 5 assistants rÃ©partis dans cinq dÃ©partements. Gestion des relations avec les vendeurs dans l'optique de la gÃ©nÃ©ration de prospects.\\nOptimisation du systÃ¨me informatique dans le but d'amÃ©liorer les communications avec les reprÃ©sentants sur le terrain. AmÃ©lioration de 15 % du cycle prospect-contact.\\nRÃ©alisation de toutes les opÃ©rations de planification et de prÃ©vision. RedÃ©finition des affectations gÃ©ographiques afin d'optimiser la productivitÃ© de l'Ã©quipe de vente. Collaboration avec le service Marketing pour faire correspondre le positionnement des produits avec la stratÃ©gie et les objectifs de ventes. \\nSous ma direction, les ventes ont augmentÃ© de 10 % par an au minimum.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Ventes</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Import/Export</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Bouches-du-RhÃ´ne</ns:Loc.State><ns:Loc.City>Martigues</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1992-03-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1998-03-31Z</ns:Emp.EndDate><ns:Emp.OrgName>Producteurs AssociÃ©s</ns:Emp.OrgName><ns:Emp.JobTitle>IngÃ©nieur commercial senior</ns:Emp.JobTitle><ns:Emp.Responsibility>Vente de produits aux dÃ©taillants et aux restaurants. Collaboration Ã©troite avec les acheteurs pour dÃ©velopper les relations. Principal responsable commercial au sein de l'entreprise entre 1996 et 1998.\\nIntroduction de la commercialisation croisÃ©e de produits associÃ©s. Notre campagne de collaboration menÃ©e avec une sociÃ©tÃ© locale de chocolats fut l'une des plus rÃ©ussies de l'histoire de l'entreprise. L'augmentation du chiffre d'affaires attribuÃ© Ã  la campagne fut de 18 %.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Ventes</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Agro-alimentaire</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Bouches-du-RhÃ´ne</ns:Loc.State><ns:Loc.City>Aubagne</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1990-06-10Z</ns:Emp.StartDate><ns:Emp.EndDate>1992-03-31Z</ns:Emp.EndDate><ns:Emp.OrgName>CafÃ© Plus</ns:Emp.OrgName><ns:Emp.JobTitle>IngÃ©nieur commercial</ns:Emp.JobTitle><ns:Emp.Responsibility>Vente de produits aux supermarchÃ©s et aux cafÃ©s. Utilisation intensive de techniques Ã  valeur ajoutÃ©e destinÃ©es Ã  augmenter le volume des ventes et Ã  proposer des produits secondaires.\\nExpÃ©rience de l'augmentation des commandes. Observation et Ã©tablissement de relations avec les acheteurs dans le but d'identifier les opportunitÃ©s d'augmentation des ventes.\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Ventes</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Agro-alimentaire</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Bouches-du-RhÃ´ne</ns:Loc.State><ns:Loc.City>Aix-en-Provence</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>MaÃ®trise</ns:Edu.Level><ns:Edu.StartDate>1986-09-15Z</ns:Edu.StartDate><ns:Edu.EndDate>1990-05-10Z</ns:Edu.EndDate><ns:Edu.Degree>BaccalaurÃ©at professionnel vente reprÃ©sentation</ns:Edu.Degree><ns:Edu.Major>Force de vente</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>Mention Bien</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>UniversitÃ© d'Aix-Marseille</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Bouches-du-RhÃ´ne</ns:Loc.State><ns:Loc.City>Marseille</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>12, rue des Acacias</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Bouches-du-RhÃ´ne</ns:Loc.State><ns:Loc.City>Marseille</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>13000</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>4</ns:Tel.AreaCode><ns:Tel.Number>04 02 04 05 04</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
6	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>M.</ns:Name.Prefix><ns:Name.First>Christian</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Kleinerman</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>3 annÃ©es d'expÃ©rience rÃ©cente en tant que responsable d'une ligne de production de karts. Mes responsabilitÃ©s comprenaient la planification du budget de la ligne de production, la commande des piÃ¨ces et la supervision de toutes les procÃ©dures d'assurance qualitÃ©.\\nAvant la gestion de la production, j'ai travaillÃ© pendant 5 ans sur des lignes de production de karts (3 ans pendant mes Ã©tudes et 2 ans ensuite). Mes responsabilitÃ©s se sont Ã©largies progressivement. J'ai commencÃ© par le simple montage de piÃ¨ces avant d'accÃ©der au poste de responsable de la qualitÃ© des systÃ¨mes de freinage.\\nMise en place d'un processus de certification ISO 9000. DiplÃ´mes d'Ã©tat dans le domaine de la sÃ©curitÃ© chimique et industrielle. DiplÃ´me rÃ©cent de secouriste.\\nPassionnÃ© de cyclisme, je me suis classÃ© dans les cinq premiers dans deux courses rÃ©gionales.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1994-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-08-11Z</ns:Emp.EndDate><ns:Emp.OrgName>Jouets en folie</ns:Emp.OrgName><ns:Emp.JobTitle>Directeur de la production</ns:Emp.JobTitle><ns:Emp.Responsibility>Directeur de la production. Responsable de l'assurance qualite. Responsable des procÃ©dures de sÃ©curitÃ©. Responsable de la certification ISO 9000.\\nConducteur de ligne de production.\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Fabrication</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>PyrÃ©nÃ©es-Orientales</ns:Loc.State><ns:Loc.City>Perpignan</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>MaÃ®trise</ns:Edu.Level><ns:Edu.StartDate>1993-04-09Z</ns:Edu.StartDate><ns:Edu.EndDate>1997-03-06Z</ns:Edu.EndDate><ns:Edu.Degree>MaÃ®trise de sciences et techniques</ns:Edu.Degree><ns:Edu.Major>IngÃ©nierie industrielle</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>Mention Bien</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>UniversitÃ© de Perpignan</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>PyrÃ©nÃ©es-Orientales</ns:Loc.State><ns:Loc.City>Perpignan</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Education><ns:Edu.Level>MaÃ®trise</ns:Edu.Level><ns:Edu.StartDate>1989-08-27Z</ns:Edu.StartDate><ns:Edu.EndDate>1993-12-06Z</ns:Edu.EndDate><ns:Edu.Degree>BaccalaurÃ©at sciences et technologies industrielles</ns:Edu.Degree><ns:Edu.Major>GÃ©nie mÃ©canique</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>Mention Bien</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>LycÃ©e technique Ãmile Zola</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>PyrÃ©nÃ©es-Orientales</ns:Loc.State><ns:Loc.City>Perpignan</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>63, rue de Frontfroide</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>PyrÃ©nÃ©es-Orientales</ns:Loc.State><ns:Loc.City>Perpignan</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>66870</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>5</ns:Tel.AreaCode><ns:Tel.Number>05 02 05 02 05</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
7	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>M.</ns:Name.Prefix><ns:Name.First>Lionel</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Penuchot</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>MÃ©canicien expÃ©rimentÃ© et polyvalent qui peut utiliser diverses machines ou superviser le travail d'autres mÃ©caniciens. Je suis spÃ©cialisÃ© dans les diagnostics et l'inspection de prÃ©cision. Je sais lire des plans et peux faire appel Ã  mes compÃ©tences en matiÃ¨re de communication pour guider le travail d'autres mÃ©caniciens de production dont je suis amenÃ© Ã  inspecter le travail. \\nMon diplÃ´me en ingÃ©nierie mÃ©canique me confÃ¨re des connaissances thÃ©oriques et mathÃ©matiques particuliÃ¨rement utiles dans mon travail.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>2000-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-09-11Z</ns:Emp.EndDate><ns:Emp.OrgName>Jouets en folie</ns:Emp.OrgName><ns:Emp.JobTitle>Chef mÃ©canicien</ns:Emp.JobTitle><ns:Emp.Responsibility>Supervision du travail d'une Ã©quipe de quatre mÃ©caniciens. Coordination de toutes les activitÃ©s complexes de montage et d'outillage, notamment la production de tricycles et de wagons. DÃ©veloppement de la fabrication de piÃ¨ces Ã  partir d'Ã©chantillons, de plans et de commandes orales. Participation Ã  la mise en Åuvre ISO9000.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Fabrication</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Var</ns:Loc.State><ns:Loc.City>Bandol</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1996-11-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2000-05-11Z</ns:Emp.EndDate><ns:Emp.OrgName>AÃ©roports sans frontiÃ¨res</ns:Emp.OrgName><ns:Emp.JobTitle>MÃ©canicien</ns:Emp.JobTitle><ns:Emp.Responsibility>RÃ©paration et maintenance de diverses machines-outils de production et de fabrication. Optimisation du rÃ©glage et de l'utilisation des machines.Utilisation et Ã©criture de programmes d'automatisation des machines. Formation intensive dans le domaine de la fabrication assistÃ©e par ordinateur.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Fabrication</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>RhÃ´ne</ns:Loc.State><ns:Loc.City>Lyon</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1994-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1996-06-11Z</ns:Emp.EndDate><ns:Emp.OrgName>LumiÃ¨res citadines</ns:Emp.OrgName><ns:Emp.JobTitle>Aide-mÃ©canicien</ns:Emp.JobTitle><ns:Emp.Responsibility>RÃ©alisation de rectifications en plongÃ©e sans centres. Formation sur fraiseuse manuelle et tour, mais aussi sur des appareils de mesure Ã  vis micromÃ©trique.\\nPropriÃ©taire d'une caisse Ã  outils complÃ¨te. Effectue des heures supplÃ©mentaires si nÃ©cessaire.\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>Production</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>Fabrication</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Loire</ns:Loc.State><ns:Loc.City>Saint-Ãtienne</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>DUT</ns:Edu.Level><ns:Edu.StartDate>1992-09-09Z</ns:Edu.StartDate><ns:Edu.EndDate>1994-05-06Z</ns:Edu.EndDate><ns:Edu.Degree>DUT GÃ©nie mÃ©canique et Productique</ns:Edu.Degree><ns:Edu.Major>IngÃ©nierie mÃ©canique</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>Mention Bien</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>UniversitÃ© de Lyon</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>RhÃ´ne</ns:Loc.State><ns:Loc.City>Lyon</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>Home</ns:Addr.Type><ns:Addr.Street>67, cours Mirabeau</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>France</ns:Loc.CountryRegion><ns:Loc.State>Var</ns:Loc.State><ns:Loc.City>Bandol</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>83150</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>Voice</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>4</ns:Tel.AreaCode><ns:Tel.Number>04 02 03 04 05</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
8	212	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix/><ns:Name.First>Peng</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Wu</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>çæææéå®ç¯èï¼ä¸ä¸ç¥è¯ä¸°å¯ã13 å¹´æ¥ï¼ä¸ºæé«å¬å¸æ¶å¥æç»©åèãå¨è®¡ååé¢æµéå®ãåå±å®¢æ·ä»¥åè¿ç¨å¤ç§éå®æå·§æ¹é¢å·æä¸å®ç»éªã\\nå·æäºå¹´çéå®ç®¡çç»éªï¼åæ¬å®¢æ·çº¿ç´¢çæãéå®äººåç®¡çä»¥åéå®åºåç®¡çãå¨ç®¡çç±ç°åºéå®ä»£è¡¨ãäº§åæ¼ç¤ºäººååä¾åºåç»æçåå¸å¼éå®ç½ç»è¿ç¨ä¸­ï¼è½å¤å©ç¨åç§ç®¡çé£æ ¼åä¸ä¸æè½æ¥è¿è¡ææç®¡çåæ²éã\\næä½³çæ²éåè¡¨è¾¾è½å\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1998-03-31Z</ns:Emp.StartDate><ns:Emp.OrgName>Wide World Imports</ns:Emp.OrgName><ns:Emp.JobTitle>éå®ç»ç</ns:Emp.JobTitle><ns:Emp.Responsibility>è´è´£ç®¡çç± 20 åéå®ä»£è¡¨å 5 åæ¯æäººåç»æçè·¨ 5 ä¸ªå·çéå®ç½ç»ãå¦å¤ï¼è¿è´è´£åè°ä¸ä¾åºåçå³ç³»ä»¥è·å¾å®¢æ·çº¿ç´¢. å¸¦é¢å¢éå©ç¨ IT ææ¯æ¹åä¸éå®äººåçå¾æ¥éä¿¡æåµãå°ä»å®¢æ·çº¿ç´¢åä¸ºèç³»å®¢æ·çæ¶é´å¨æç¼©ç­ 15%. è®¡ååé¢æµææéå®æ´»å¨ãè°æ´éå®åºååéï¼æå¤§éåº¦æé«ææéå®äººåçæçãä¸è¥éé¨é¨å¯ååä½å°äº§åè¯ç¨è½¬åä¸ºå·ä½çéå®æç¥åç®æ . å¨æçç®¡çä¹ä¸ï¼éå®é¢æ¯å¹´è³å°å¢é¿ 10%.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>éå®</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>è¿åºå£</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Renton</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1992-03-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1998-03-31Z</ns:Emp.EndDate><ns:Emp.OrgName>Coho Winery</ns:Emp.OrgName><ns:Emp.JobTitle>é«çº§éå®å©ç</ns:Emp.JobTitle><ns:Emp.Responsibility>åé¶å®ååé¥­åºæ¨éäº§åãä¸å®¢æ·å¯åèç³»ä»¥æå±ä¸å¡ã1996 è³ 1998 å¹´é´ä»»å¬å¸éå®ä¸»ç®¡. é¦åäº§åæ­åæ¹æ¡ãä¸å½å°å·§ååå¬å¸èæä¸¾åçæ´»å¨æ¯å¬å¸åå²ä¸ææåçä¿éæ´»å¨ãè¯¥æ´»å¨ä½¿å¬å¸æ¶å¥å¢å  18%.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>éå®</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>é£ååé¥®æ</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Bellevue</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1990-06-10Z</ns:Emp.StartDate><ns:Emp.EndDate>1992-03-31Z</ns:Emp.EndDate><ns:Emp.OrgName>Fourth Coffee</ns:Emp.OrgName><ns:Emp.JobTitle>éå®å©ç</ns:Emp.JobTitle><ns:Emp.Responsibility>åè¶å¸ååå¡é¦æ¨éäº§åãä¸»è¦ä½¿ç¨å¢å¼æ³æ¥æé«ééï¼ä¸ºå¯äº§ååé å¸åº. æé¿æè®¢åãä¸å®¢æ·ä¿æè¯å¥½å³ç³»ï¼åäºå¤æ­å¹¶ææ¡æºä¼æ¥æé«éé\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>éå®</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>é£ååé¥®æ</ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Kent</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>å­¦å£«</ns:Edu.Level><ns:Edu.StartDate>1986-09-15Z</ns:Edu.StartDate><ns:Edu.EndDate>1990-05-15Z</ns:Edu.EndDate><ns:Edu.Degree>Bachelor of Science</ns:Edu.Degree><ns:Edu.Major>è´¸æ</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.3</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Western University</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Seattle</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>å®¶åº­</ns:Addr.Type><ns:Addr.Street>50 West 5th Street</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>WA </ns:Loc.State><ns:Loc.City>Federal Way</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>98003</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>å®¶åº­</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>253</ns:Tel.AreaCode><ns:Tel.Number>555-1444</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2013-12-22 18:32:21.267
9	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix/><ns:Name.First>Shengda</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Yang </ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>æè¿ä¸å¹´ä»»èå©´å¿è½¦çäº§çº¿ç»çãè´è´£è®¡åçäº§çº¿é¢ç®ãè®¢è´­é¶é¨ä»¶ä»¥åçç£ææè´¨ä¿ç¯è. å¨ä»äºçäº§ç®¡çä¹åï¼æ¾å¨å©´å¿è½¦çäº§çº¿ä¸å·¥ä½äºå¹´(ä¸å¹´æ¯æ±å­¦æé´å¼èï¼æ¯ä¸åä¸¤å¹´å¨è)ï¼å¨æ­¤æé´ï¼ä¸æ­å¾å°æåãåå¼å§æ¯ä»äºåºæ¬ç»è£ï¼ååä¸ºå¹è½¦ç³»ç»è´¨ä¿ä¸»ç®¡. å¸¦é¢å¢ééè¿ ISO 9000 è®¤è¯. éè¿å·ä¸¾åçåå­¦åå·¥ä¸å®å¨èè¯ãæè¿åéè¿åè®¤è¯è·å¾åºæ¬æ¥æè¯ä¹¦. ç±å¥½èªè¡è½¦ï¼å¨å¥¥å°å¤å°åºä¸¾åçä¸¤æ¬¡èªè¡è½¦æ¯èµä¸­æååäº.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1994-09-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-01-08Z</ns:Emp.EndDate><ns:Emp.OrgName>Wingtip Toys</ns:Emp.OrgName><ns:Emp.JobTitle>çäº§ç»ç</ns:Emp.JobTitle><ns:Emp.Responsibility>çäº§ç»ç. è´¨ä¿ä¸»ç®¡. å®å¨ä»£è¡¨. ISO 9000 è®¤è¯ä¸»ç®¡.çäº§çº¿å·¥äºº\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>çäº§</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>å¶é </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>å­¦å£«</ns:Edu.Level><ns:Edu.StartDate>1992-09-04Z</ns:Edu.StartDate><ns:Edu.EndDate>1996-06-03Z</ns:Edu.EndDate><ns:Edu.Degree>çå­¦å£«</ns:Edu.Degree><ns:Edu.Major>å·¥ä¸å·¥ç¨</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.4</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Soutern State College</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Tampa Bay</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Education><ns:Edu.Level>High School</ns:Edu.Level><ns:Edu.StartDate>1988-08-27Z</ns:Edu.StartDate><ns:Edu.EndDate>1992-06-12Z</ns:Edu.EndDate><ns:Edu.Degree>é«ä¸­</ns:Edu.Degree><ns:Edu.Major/><ns:Edu.Minor/><ns:Edu.GPA>3.8</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Evergreen High School</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>å®¶åº­</ns:Addr.Type><ns:Addr.Street>1234 Palm Street</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>FL </ns:Loc.State><ns:Loc.City>Orlando</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>37812</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>å®¶åº­</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>407</ns:Tel.AreaCode><ns:Tel.Number>555-0101</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address></ns:Resume>	2007-06-23 00:00:00
10	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix/><ns:Name.First>Tai</ns:Name.First><ns:Name.Middle/><ns:Name.Last>Yee</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>ææ¯ä¸åç»éªä¸°å¯çæºæ¢°å¸ï¼ææ¯å¨é¢ï¼ä¸ä»åç¬æä½åç§æºæ¢°è®¾å¤ï¼è¿ç®¡çå¶ä»æºæ¢°å¸çå·¥ä½ãæä¸æ»è¯æ­åç²¾åº¦æ£æµï¼å¯ä»¥è¯»æè®¾è®¡å¾ï¼è½å¤å¦¥åå¤çåæ¹é¢çäººéå³ç³»å¹¶å·å¤è¯å¥½çæ²éè½åæ¥æå¯¼æç®¡è¾çæºæ¢°å¸çå·¥ä½. ä¸å¶ä»åéèç¸æ¯ï¼ææ¥æçæºæ¢°å·¥ç¨å­¦ä½ä½¿æå¯¹æºæ¢°å¸è¡ä¸å¨çè®ºæ¹é¢å·ææ´æ·±å»çäºè§£ï¼æ°å­¦èæ¯ç¥è¯ä¹æ´æ·±å.\\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>2000-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-09-18Z</ns:Emp.EndDate><ns:Emp.OrgName>Wingtip Toys</ns:Emp.OrgName><ns:Emp.JobTitle>æºæ¢°å¸ä¸»ç®¡</ns:Emp.JobTitle><ns:Emp.Responsibility>ç®¡çååæºæ¢°å¸çå·¥ä½. åè°ææå¤æçç»è£åå·¥å·ä½¿ç¨ï¼åæ¬ä¸è½®è½¦ååè½®è½¦ççäº§. æ ¹æ®æ ·ä»¶ãå¾çº¸åå£å¤´æè¿°è¿è¡é¶é¨ä»¶ç»è£. åä¸å¬å¸éè¿ ISO9000 è´¨éè®¤è¯çå·¥ä½.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>çäº§</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>å¶é </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>CO </ns:Loc.State><ns:Loc.City>Denver</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1996-11-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2000-05-11Z</ns:Emp.EndDate><ns:Emp.OrgName>Blue Yonder Airlines</ns:Emp.OrgName><ns:Emp.JobTitle>æºæ¢°å¸</ns:Emp.JobTitle><ns:Emp.Responsibility>ä¿®çåç»´æ¤åç§çäº§åç»è£ç¨æºæ¢°å·¥å·. è°æ´å¹¶æä½æºå¨ä»¥å®ç°é«ç²¾åº¦. ä½¿ç¨å¹¶ç¼å CNC æºå¨ç¨åº. å¨è®¡ç®æºè¾å©å¶é æ¹é¢åè¿å¹¿æ³çå¹è®­.\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>çäº§</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>å¶é </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IL </ns:Loc.State><ns:Loc.City>Chicago</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1994-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1996-07-13Z</ns:Emp.EndDate><ns:Emp.OrgName>City Power and Light</ns:Emp.OrgName><ns:Emp.JobTitle>å©çæºæ¢°å¸</ns:Emp.JobTitle><ns:Emp.Responsibility>è¿è¡æ å¿ç£¨å. å¨äººå·¥ç£¨ååè½¦åºè®¾å¤ä»¥åååå°ºåå¡é³æ¹é¢æ¥åè¿å¹è®­. ç®¡çå¨å¥å·¥å·. æè¦æ±ç»å¸¸å ç­.ã\\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>çäº§</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>å¶é </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IA </ns:Loc.State><ns:Loc.City>Des Moines</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>å­¦å£«</ns:Edu.Level><ns:Edu.StartDate>1990-09-05Z</ns:Edu.StartDate><ns:Edu.EndDate>1994-05-22Z</ns:Edu.EndDate><ns:Edu.Degree>çå­¦å£«</ns:Edu.Degree><ns:Edu.Major>æºæ¢°å·¥ç¨</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.2</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>Midwest State University</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>IA </ns:Loc.State><ns:Loc.City>Des Moines</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>å®¶åº­</ns:Addr.Type><ns:Addr.Street>15 Main Street</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>US </ns:Loc.CountryRegion><ns:Loc.State>CO </ns:Loc.State><ns:Loc.City>Denver</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>80521</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>å®¶åº­</ns:Tel.Type><ns:Tel.IntlCode>1</ns:Tel.IntlCode><ns:Tel.AreaCode>303</ns:Tel.AreaCode><ns:Tel.Number>555-0114</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail>Tai@Example.com</ns:EMail><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
11	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>à¸à¸²à¸¢</ns:Name.Prefix><ns:Name.First>à¸ªà¸¸à¸à¸±à¸¨à¸</ns:Name.First><ns:Name.Middle/><ns:Name.Last>à¸à¸à¸²à¸à¸¥</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>à¸¡à¸µà¸à¸§à¸²à¸¡à¸à¸³à¸à¸²à¸à¹à¸à¸ªà¸²à¸¢à¸à¸²à¸à¸à¸²à¸¢à¸­à¸¢à¹à¸²à¸à¸¡à¸²à¸  à¸à¸£à¸°à¸ªà¸à¸à¸§à¸²à¸¡à¸ªà¸³à¹à¸£à¹à¸à¸à¸¥à¸­à¸ 13 à¸à¸µà¹à¸à¸à¸²à¸£à¹à¸à¸´à¹à¸¡à¸£à¸²à¸¢à¹à¸à¹à¹à¸«à¹à¸à¸±à¸à¸­à¸à¸à¹à¸à¸£ à¸¡à¸µà¸à¸£à¸°à¸ªà¸à¸à¸²à¸£à¸à¹à¹à¸à¸à¸²à¸£à¸§à¸²à¸à¹à¸à¸à¸à¸²à¸à¸à¸²à¸¢ à¹à¸¥à¸°à¸à¸²à¸£à¸à¸£à¸°à¸¡à¸²à¸à¸à¸²à¸£ à¸à¸²à¸£à¸à¸±à¸à¸à¸²à¸à¸¸à¸£à¸à¸´à¸ à¹à¸¥à¸°à¹à¸à¸à¸à¸´à¸à¸à¸²à¸£à¸à¸²à¸¢à¸«à¸¥à¸²à¸à¸«à¸¥à¸²à¸¢à¸à¸£à¸°à¹à¸ à¸ \\nà¸à¸£à¸°à¸ªà¸à¸à¸²à¸£à¸à¹ 5 à¸à¸µà¹à¸à¸à¸²à¸£à¸à¸£à¸´à¸«à¸²à¸£à¸à¸²à¸à¸à¸²à¸¢ à¸£à¸§à¸¡à¸à¸¶à¸à¸à¸²à¸£à¸ªà¸£à¹à¸²à¸à¹à¸­à¸à¸²à¸ªà¸à¸²à¸à¸à¸²à¸£à¸à¸²à¸¢ à¸à¸²à¸£à¸à¸³à¸à¸µà¸¡à¸à¸²à¸¢ à¹à¸¥à¸°à¸à¸²à¸£à¸à¸±à¸à¸à¸²à¸£à¸à¸·à¹à¸à¸à¸µà¹  à¸à¸³à¸§à¸´à¸à¸µà¸à¸£à¸´à¸«à¸²à¸£à¹à¸¥à¸°à¸à¸§à¸²à¸¡à¸£à¸¹à¹à¸à¹à¸²à¸à¹à¸à¸à¸à¸´à¸à¸¡à¸²à¹à¸à¹à¹à¸à¸à¸²à¸£à¸à¸±à¸à¸à¸²à¸£à¹à¸¥à¸°à¸à¸²à¸£à¸ªà¸·à¹à¸­à¸ªà¸²à¸£à¸à¸±à¸à¸à¸µà¸¡à¸à¸²à¸¢à¸à¸±à¹à¸§à¸à¸·à¹à¸à¸à¸µà¹ à¸à¸¶à¹à¸à¸à¸£à¸°à¸à¸­à¸à¸à¹à¸§à¸¢à¸à¸±à¸§à¹à¸à¸à¸à¸²à¸¢à¹à¸à¸à¸·à¹à¸à¸à¸µà¹ à¸à¸¹à¹à¸ªà¸²à¸à¸´à¸à¸à¸¥à¸´à¸à¸ à¸±à¸à¸à¹ à¹à¸¥à¸°à¸à¸¹à¹à¸à¸²à¸¢à¹à¸à¹à¸­à¸¢à¹à¸²à¸à¸¡à¸µà¸à¸£à¸°à¸ªà¸´à¸à¸à¸´à¸ à¸²à¸ \\nà¸¡à¸µà¸à¸±à¸à¸©à¸°à¹à¸à¸à¸²à¸£à¸ªà¸·à¹à¸­à¸ªà¸²à¸£à¹à¸¥à¸°à¸à¸²à¸£à¸à¸³à¹à¸ªà¸à¸­à¹à¸à¹à¸à¹à¸¥à¸´à¸¨ \\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1998-03-31Z</ns:Emp.StartDate><ns:Emp.EndDate>2004-05-15Z</ns:Emp.EndDate><ns:Emp.OrgName>à¹à¸§à¸´à¸¥à¸à¹à¸§à¸²à¸¢à¸à¹à¸­à¸´à¸¡à¸à¸­à¸£à¹à¸ à¸à¸³à¸à¸±à¸ </ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¸¹à¹à¸à¸±à¸à¸à¸²à¸£à¸à¹à¸²à¸¢à¸à¸²à¸¢ </ns:Emp.JobTitle><ns:Emp.Responsibility>à¸à¸±à¸à¸à¸²à¸£à¸à¸µà¸¡à¸à¸²à¸¢à¸à¸µà¹à¸à¸£à¸°à¸à¸­à¸à¸à¹à¸§à¸¢à¸à¸±à¸§à¹à¸à¸à¸à¸²à¸¢ 20 à¸à¸ à¹à¸¥à¸°à¹à¸à¹à¸²à¸«à¸à¹à¸²à¸à¸µà¹à¸ªà¸à¸±à¸à¸ªà¸à¸¸à¸ 5 à¸à¸  à¸à¸£à¸°à¸à¸²à¸¢à¹à¸ 5 à¸à¸±à¸à¸«à¸§à¸±à¸  à¸à¸¹à¹à¸¥à¸à¸²à¸£à¸à¸£à¸°à¸ªà¸²à¸à¸à¸²à¸à¸à¸±à¸à¸à¸¹à¹à¸à¹à¸² à¸ªà¸³à¸«à¸£à¸±à¸à¸à¸²à¸£à¸ªà¸£à¹à¸²à¸à¹à¸­à¸à¸²à¸ªà¸à¸²à¸à¸à¸²à¸£à¸à¸²à¸¢ \\nà¹à¸à¹à¸à¸à¸¹à¹à¸à¸³à¹à¸à¸à¸²à¸£à¹à¸à¹à¹à¸à¸à¹à¸à¹à¸¥à¸¢à¸µà¸ªà¸²à¸£à¸ªà¸à¹à¸à¸¨à¹à¸à¸·à¹à¸­à¸à¸±à¸à¸à¸²à¸£à¸°à¸à¸à¸ªà¸·à¹à¸­à¸ªà¸²à¸£à¹à¸à¸à¸·à¹à¸à¸à¸µà¹à¸à¸²à¸¢  à¹à¸à¸´à¹à¸¡à¸à¸§à¸²à¸¡à¸ªà¸³à¹à¸£à¹à¸à¹à¸à¸à¸²à¸£à¸à¸´à¸à¸à¸²à¸¡à¹à¸­à¸à¸²à¸ªà¸à¸²à¸à¸à¸²à¸£à¸à¸²à¸¢ 15 à¹à¸à¸­à¸£à¹à¹à¸à¹à¸à¸\\nà¸§à¸²à¸à¹à¸à¸à¹à¸¥à¸°à¸à¸£à¸°à¸¡à¸²à¸à¸à¸²à¸£à¸à¸²à¸¢à¸à¸±à¹à¸à¸«à¸¡à¸  à¸à¸±à¸à¸à¸²à¸£à¸¡à¸­à¸à¸«à¸¡à¸²à¸¢à¹à¸à¸à¸à¸²à¸£à¸à¸²à¸¢à¹à¸«à¸¡à¹ à¹à¸à¸·à¹à¸­à¹à¸«à¹à¹à¸à¹à¸à¸£à¸°à¸ªà¸´à¸à¸à¸´à¸à¸¥à¸ªà¸¹à¸à¸ªà¸¸à¸  à¸à¸£à¸°à¸ªà¸²à¸à¸à¸²à¸à¸à¸±à¸à¸à¹à¸²à¸¢à¸à¸²à¸£à¸à¸¥à¸²à¸à¹à¸à¸·à¹à¸­à¸§à¸²à¸à¹à¸à¸à¸à¸³à¹à¸«à¸à¹à¸à¸à¸­à¸à¸à¸¥à¸´à¸à¸ à¸±à¸à¸à¹à¹à¸«à¹à¹à¸à¹à¸²à¸à¸±à¸à¸à¸¥à¸¢à¸¸à¸à¸à¹à¹à¸¥à¸°à¹à¸à¹à¸²à¸«à¸¡à¸²à¸¢à¹à¸à¸à¸²à¸£à¸à¸²à¸¢  à¸¡à¸µà¸à¸¥à¸à¸²à¸à¸à¸²à¸£à¸à¸£à¸´à¸«à¸²à¸£ à¸à¸³à¹à¸«à¹à¸¢à¸­à¸à¸à¸²à¸¢à¹à¸à¸´à¹à¸¡à¸à¸¶à¹à¸à¸­à¸¢à¹à¸²à¸à¸à¹à¸­à¸¢ 10% à¸à¹à¸­à¸à¸µ \\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸²à¸¢</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸à¸³à¹à¸à¹à¸²/à¸ªà¹à¸à¸­à¸­à¸ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢</ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸ªà¸²à¸à¸£  </ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1992-04-01Z</ns:Emp.StartDate><ns:Emp.EndDate>1997-03-01Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸ªà¸¸à¸à¸¸à¸¡à¸§à¸´à¸à¹à¸§à¹à¸à¸­à¸£</ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¸à¸±à¸à¸à¸²à¸à¸à¸²à¸¢à¸­à¸²à¸§à¸¸à¹à¸ª </ns:Emp.JobTitle><ns:Emp.Responsibility>à¸à¸²à¸¢à¸à¸¥à¸´à¸à¸ à¸±à¸à¸à¹à¹à¸«à¹à¸à¸±à¸à¸à¸¹à¹à¸à¹à¸²à¸à¸¥à¸µà¸à¹à¸¥à¸°à¸ à¸±à¸à¸à¸²à¸à¸²à¸£  à¸à¸³à¸à¸²à¸à¸£à¹à¸§à¸¡à¸à¸±à¸à¸à¹à¸²à¸¢à¸à¸±à¸à¸à¸·à¹à¸­à¸­à¸¢à¹à¸²à¸à¹à¸à¸¥à¹à¸à¸´à¸ à¹à¸à¸·à¹à¸­à¸à¸±à¸à¸à¸²à¸à¸²à¸£à¸à¸£à¸°à¸ªà¸²à¸à¸à¸²à¸ à¸«à¸±à¸§à¸«à¸à¹à¸²à¸à¸±à¸§à¹à¸à¸à¸à¸²à¸¢à¸ªà¸³à¸«à¸£à¸±à¸à¸­à¸à¸à¹à¸à¸£ à¸£à¸°à¸«à¸§à¹à¸²à¸à¸à¸µ 2539 - 2541 \\nà¸£à¸´à¹à¸£à¸´à¹à¸¡à¹à¸à¹à¸à¸¥à¸¢à¸¸à¸à¸à¹à¸à¸¹à¸à¸ªà¸´à¸à¸à¹à¸²à¸à¸µà¹à¹à¸à¸µà¹à¸¢à¸§à¸à¹à¸­à¸à¸à¸±à¸ à¸£à¸´à¹à¸£à¸´à¹à¸¡à¹à¸à¹à¸à¸£à¸²à¸ªà¸´à¸à¸à¹à¸²à¸£à¹à¸§à¸¡à¸à¸±à¸à¸à¸£à¸´à¸©à¸±à¸à¸à¹à¸­à¸à¹à¸à¸à¸£à¸°à¹à¸à¸¨  à¹à¸à¹à¸à¹à¸à¸¡à¹à¸à¸à¸à¸µà¹à¹à¸à¹à¸£à¸±à¸à¸à¸§à¸²à¸¡à¸ªà¸³à¹à¸£à¹à¸à¸ªà¸¹à¸à¸ªà¸¸à¸à¹à¸à¸à¸£à¸°à¸§à¸±à¸à¸´à¸à¸²à¸£à¸à¸³à¹à¸à¸´à¸à¸à¸¸à¸£à¸à¸´à¸à¸à¸­à¸à¸­à¸à¸à¹à¸à¸£  à¹à¸à¸¡à¹à¸à¸à¸à¸±à¸à¸à¸¥à¹à¸²à¸§à¸à¸³à¹à¸«à¹à¸¡à¸µà¸¢à¸­à¸à¸à¸²à¸¢à¹à¸à¸´à¹à¸¡à¸à¸¶à¹à¸à¸à¸¶à¸ 18% \\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸²à¸¢ </ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸²à¸«à¸²à¸£à¹à¸¥à¸°à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸·à¹à¸¡ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸à¸£à¸°à¹à¸à¸à¸</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1990-08-04Z</ns:Emp.StartDate><ns:Emp.EndDate>1992-02-01Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸à¸²à¹à¸à¸­à¸²à¹à¸£à¸¡à¸²</ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¸à¸±à¸à¸à¸²à¸à¸à¸²à¸¢ </ns:Emp.JobTitle><ns:Emp.Responsibility> à¸à¸²à¸¢à¸à¸¥à¸´à¸à¸ à¸±à¸à¸à¹à¹à¸«à¹à¸à¸±à¸à¸à¸¹à¹à¸à¸­à¸£à¹à¸¡à¸²à¹à¸à¹à¸à¹à¸¥à¸°à¸£à¹à¸²à¸à¸à¸²à¹à¸  à¸à¸³à¸à¸²à¸à¸­à¸¢à¹à¸²à¸à¸à¸¸à¹à¸¡à¹à¸à¹à¸¥à¸°à¸à¸£à¸´à¸à¸à¸±à¸ à¸à¸£à¹à¸­à¸¡à¸à¸±à¹à¸à¹à¸à¹à¹à¸à¸à¸à¸´à¸à¸à¸²à¸£à¸à¸²à¸¢à¹à¸à¸´à¹à¸¡à¹à¸à¸´à¸¡ à¹à¸à¸·à¹à¸­à¹à¸à¸´à¹à¸¡à¸¢à¸­à¸à¸à¸²à¸¢ à¹à¸«à¹à¸à¸²à¸£à¹à¸à¸°à¸à¸³à¸à¸¥à¸´à¸à¸ à¸±à¸à¸à¹à¸£à¸­à¸ \\nà¸¡à¸µà¸à¸§à¸²à¸¡à¸à¸³à¸à¸²à¸à¹à¸à¸à¸²à¸£à¸à¸¢à¸²à¸¢à¸¢à¸­à¸à¸ªà¸±à¹à¸à¸à¸·à¹à¸­ à¸à¸´à¸à¸à¸²à¸¡à¹à¸¥à¸°à¸ªà¸£à¹à¸²à¸à¸ªà¸±à¸¡à¸à¸±à¸à¸à¸ à¸²à¸à¸à¸µà¹à¸à¸µà¸à¸±à¸à¸¥à¸¹à¸à¸à¹à¸² à¹à¸à¸·à¹à¸­à¹à¸à¸´à¹à¸¡à¹à¸­à¸à¸²à¸ªà¹à¸à¸à¸²à¸£à¸à¸²à¸¢ \t \\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸²à¸¢ </ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸²à¸«à¸²à¸£à¹à¸¥à¸°à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸·à¹à¸¡ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£ </ns:Loc.State><ns:Loc.City>à¸à¸¥à¸­à¸à¹à¸à¸¢ </ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>à¸à¸£à¸´à¸à¸à¸²à¸à¸£</ns:Edu.Level><ns:Edu.StartDate>1986-09-03Z</ns:Edu.StartDate><ns:Edu.EndDate>1990-05-10Z</ns:Edu.EndDate><ns:Edu.Degree>à¸à¸à¸</ns:Edu.Degree><ns:Edu.Major>à¸à¸£à¸´à¸«à¸²à¸£à¸à¸¸à¸£à¸à¸´à¸ </ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.6</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>à¸¡à¸«à¸²à¸§à¸´à¸à¸¢à¸²à¸¥à¸±à¸¢à¸£à¸²à¸¡à¸à¸³à¹à¸«à¸</ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸£à¸²à¸¡à¸à¸³à¹à¸«à¸</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>à¸à¹à¸²à¸ </ns:Addr.Type><ns:Addr.Street>25/48 à¸à¸­à¸¢à¹à¸à¸à¸£à¸à¸£à¸°à¸à¸±à¸</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£ </ns:Loc.State><ns:Loc.City>à¸£à¸²à¸à¹à¸à¸§</ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>10400</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>à¸à¹à¸²à¸ </ns:Tel.Type><ns:Tel.IntlCode>2</ns:Tel.IntlCode><ns:Tel.Number>555-0181</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
12	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix>à¸à¸²à¸¢ </ns:Name.Prefix><ns:Name.First>à¸ªà¸²à¸¡à¸²à¸£à¸</ns:Name.First><ns:Name.Middle/><ns:Name.Last>à¹à¸à¸à¸à¸¨à¸£</ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills>à¸à¸£à¸°à¸ªà¸à¸à¸²à¸£à¸à¹à¸¥à¹à¸²à¸ªà¸¸à¸à¸à¸§à¹à¸² 3 à¸à¸µà¹à¸à¸à¸³à¹à¸«à¸à¹à¸à¸à¸¹à¹à¸à¸±à¸à¸à¸²à¸£à¸ªà¸²à¸¢à¸à¸²à¸£à¸à¸¥à¸´à¸à¸£à¸à¹à¸à¸à¸²à¸£à¹à¸  à¸à¸§à¸²à¸¡à¸£à¸±à¸à¸à¸´à¸à¸à¸­à¸ à¸à¸£à¸°à¸à¸­à¸à¸à¹à¸§à¸¢à¸à¸²à¸£à¸§à¸²à¸à¹à¸à¸à¸à¸à¸à¸£à¸°à¸¡à¸²à¸à¸à¸­à¸à¸ªà¸²à¸¢à¸à¸²à¸£à¸à¸¥à¸´à¸ à¸à¸²à¸£à¸ªà¸±à¹à¸à¸à¸·à¹à¸­à¸­à¸°à¹à¸«à¸¥à¹ à¹à¸¥à¸°à¸à¸§à¸à¸à¸¸à¸¡à¸à¸£à¸°à¸à¸§à¸à¸à¸²à¸£à¸à¸£à¸°à¸à¸±à¸à¸à¸¸à¸à¸ à¸²à¸ \\nà¸à¹à¸­à¸à¸£à¸±à¸à¸à¸³à¹à¸«à¸à¹à¸à¸à¸£à¸´à¸«à¸²à¸£à¸à¸²à¸£à¸à¸¥à¸´à¸ à¹à¸à¹à¸à¸³à¸à¸²à¸à¹à¸à¸ªà¸²à¸¢à¸à¸²à¸£à¸à¸¥à¸´à¸à¸£à¸à¹à¸à¸à¸²à¸£à¹à¸à¸à¸§à¹à¸² 5 à¸à¸µ (3 à¸à¸µà¸à¸à¸°à¸¨à¸¶à¸à¸©à¸² à¹à¸¥à¸° 2 à¸à¸µ à¸«à¸¥à¸±à¸à¸à¸à¸à¸²à¸£à¸¨à¸¶à¸à¸©à¸²) à¹à¸à¸¢à¸¡à¸µà¸à¸§à¸²à¸¡à¸£à¸±à¸à¸à¸´à¸à¸à¸­à¸à¹à¸à¸´à¹à¸¡à¸à¸¶à¹à¸à¸à¸²à¸¡à¸¥à¸³à¸à¸±à¸  à¹à¸£à¸´à¹à¸¡à¸à¹à¸à¸à¸²à¸à¸à¸²à¸£à¸£à¸±à¸à¸à¸´à¸à¸à¸­à¸à¸à¸²à¸à¸à¸£à¸°à¸à¸­à¸à¸à¸±à¹à¸à¸à¸·à¹à¸à¸à¸²à¸ à¹à¸¥à¸°à¸à¹à¸­à¸¡à¸²à¹à¸à¹à¸à¸à¸¹à¹à¸à¸³à¸à¸£à¸°à¸à¸§à¸à¸à¸²à¸£à¸à¸£à¸°à¸à¸±à¸à¸à¸¸à¸à¸ à¸²à¸à¸ªà¸³à¸«à¸£à¸±à¸à¸£à¸°à¸à¸à¹à¸à¸£à¸ \\nà¹à¸à¹à¸à¸à¸¹à¹à¸à¸³à¸à¸²à¸£à¸£à¸±à¸à¸£à¸­à¸à¸à¸²à¸¡à¸¡à¸²à¸à¸£à¸à¸²à¸ ISO 9000 \\nà¸à¹à¸²à¸à¸à¸²à¸£à¸ªà¸­à¸à¸à¸£à¸°à¹à¸¡à¸´à¸à¸à¸¥à¸à¹à¸²à¸à¸à¸§à¸²à¸¡à¸à¸¥à¸­à¸à¸ à¸±à¸¢à¸à¸²à¸à¹à¸à¸¡à¸µà¹à¸¥à¸°à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡ à¸à¸²à¸à¸à¸£à¸°à¸à¸£à¸§à¸à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡  à¹à¸à¹à¸£à¸±à¸à¹à¸à¸à¸£à¸°à¸à¸²à¸¨à¸à¸µà¸¢à¸à¸±à¸à¸£à¸à¹à¸²à¸à¸à¸²à¸£à¸à¸à¸¡à¸à¸¢à¸²à¸à¸²à¸¥à¸à¸²à¸à¸à¸£à¸°à¸à¸£à¸§à¸à¹à¸£à¸à¸à¸²à¸à¹à¸¥à¸°à¸ªà¸§à¸±à¸ªà¸à¸´à¸à¸²à¸£à¸ªà¸±à¸à¸à¸¡ \\nà¹à¸à¹à¸à¸à¸±à¸à¸à¸±à¹à¸à¸à¸±à¸à¸£à¸¢à¸²à¸ à¸­à¸¢à¸¹à¹à¹à¸à¸«à¹à¸²à¸­à¸±à¸à¸à¸±à¸à¹à¸£à¸à¸à¸­à¸à¸à¸²à¸£à¹à¸à¹à¸à¹à¸à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£à¸ªà¸­à¸à¸à¸£à¸±à¹à¸  \\n    </ns:Skills><ns:Employment><ns:Emp.StartDate>1994-07-01Z</ns:Emp.StartDate><ns:Emp.EndDate>2003-09-26Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸à¸£à¸´à¸©à¸±à¸ à¹à¸¡à¸à¸´à¸ à¸à¸­à¸¢à¸ªà¹ </ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¸¹à¹à¸à¸±à¸à¸à¸²à¸£à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸ </ns:Emp.JobTitle><ns:Emp.Responsibility>à¸à¸¹à¹à¸à¸±à¸à¸à¸²à¸£à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸ à¸«à¸±à¸§à¸«à¸à¹à¸²à¸à¸²à¸à¸à¸£à¸°à¸à¸±à¸à¸à¸¸à¸à¸ à¸²à¸  à¸à¸±à¸§à¹à¸à¸à¸à¹à¸²à¸à¸à¸§à¸²à¸¡à¸à¸¥à¸­à¸à¸ à¸±à¸¢  à¸à¸¹à¹à¸à¸³à¸à¸²à¸£à¸£à¸±à¸à¸£à¸­à¸à¸à¸²à¸¡à¸¡à¸²à¸à¸£à¸à¸²à¸ ISO 9000à¸à¸à¸±à¸à¸à¸²à¸à¸ªà¸²à¸¢à¸à¸²à¸£à¸à¸¥à¸´à¸ \\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸ </ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡à¸à¸²à¸£à¸à¸¥à¸´à¸ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£ </ns:Loc.State><ns:Loc.City>à¸à¸¸à¸ªà¸´à¸ </ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>à¸à¸£à¸´à¸à¸à¸²à¸à¸£à¸µ </ns:Edu.Level><ns:Edu.StartDate>1989-09-01Z</ns:Edu.StartDate><ns:Edu.EndDate>1994-06-01Z</ns:Edu.EndDate><ns:Edu.Degree>à¸§à¸´à¸à¸¢à¸²à¸¨à¸²à¸ªà¸à¸£à¸à¸±à¸à¸à¸´à¸ </ns:Edu.Degree><ns:Edu.Major>à¸§à¸´à¸¨à¸§à¸à¸£à¸£à¸¡à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸²à¸£</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.4</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>à¸¡à¸«à¸²à¸§à¸´à¸à¸¢à¸²à¸¥à¸±à¸¢à¸¡à¸«à¸´à¸à¸¥ </ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢</ns:Loc.CountryRegion><ns:Loc.State>à¸à¸à¸£à¸à¸à¸¡  </ns:Loc.State><ns:Loc.City>à¸ªà¸²à¸¡à¸à¸£à¸²à¸ </ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>à¸à¹à¸²à¸ </ns:Addr.Type><ns:Addr.Street>141/25 à¸à¸­à¸¢ à¸à¸³à¸£à¸²à¸¡à¹à¸§à¸ 6</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸à¸¸à¸ªà¸´à¸ </ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>10300</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>à¸à¹à¸²à¸ </ns:Tel.Type><ns:Tel.IntlCode>2</ns:Tel.IntlCode><ns:Tel.Number>555-0101</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
13	\N	<ns:Resume xmlns:ns="http://schemas.microsoft.com/sqlserver/2004/07/adventure-works/Resume"><ns:Name><ns:Name.Prefix/><ns:Name.First>à¸à¸²à¸¢ </ns:Name.First><ns:Name.Middle/><ns:Name.Last>à¸à¸²à¸à¸ªà¸¸à¸à¸¨à¸£à¸µ </ns:Name.Last><ns:Name.Suffix/></ns:Name><ns:Skills/><ns:Employment><ns:Emp.StartDate>2000-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2002-09-11Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸à¸£à¸´à¸©à¸±à¸ à¹à¸¡à¸à¸´à¸ à¸à¸­à¸¢à¸ªà¹ </ns:Emp.OrgName><ns:Emp.JobTitle>à¸«à¸±à¸§à¸«à¸à¹à¸²à¸à¹à¸²à¸à¸¢à¸à¸à¹</ns:Emp.JobTitle><ns:Emp.Responsibility>à¸à¸¹à¹à¸¥à¸à¸²à¸à¸à¸­à¸à¸à¸¥à¸¸à¹à¸¡à¸à¹à¸²à¸à¸ªà¸µà¹à¸à¸ \\nà¸à¸£à¸°à¸ªà¸²à¸à¸à¸²à¸à¸à¸£à¸°à¸à¸­à¸à¸à¸µà¹à¸¡à¸µà¸à¸§à¸²à¸¡à¸à¸±à¸à¸à¹à¸­à¸ à¹à¸¥à¸°à¸à¸²à¸£à¹à¸à¹à¹à¸à¸£à¸·à¹à¸­à¸à¸¡à¸·à¸­à¸«à¸à¸±à¸ à¸£à¸§à¸¡à¸à¸¶à¸à¸à¸²à¸£à¸à¸¥à¸´à¸à¸à¸±à¸à¸£à¸¢à¸²à¸à¸ªà¸²à¸¡à¸¥à¹à¸­à¹à¸¥à¸°à¸£à¸à¹à¸à¹à¸ \\nà¸à¸±à¸à¸à¸²à¸à¸²à¸£à¸à¸¥à¸´à¸à¸­à¸°à¹à¸«à¸¥à¹à¸à¸²à¸à¸à¸´à¹à¸à¸ªà¹à¸§à¸à¸à¸±à¸§à¸­à¸¢à¹à¸²à¸ à¸ à¸²à¸à¸£à¹à¸²à¸ à¹à¸¥à¸°à¸à¸³à¸ªà¸±à¹à¸à¸à¸²à¸à¸§à¸²à¸à¸² \\nà¸¡à¸µà¸à¸£à¸°à¸ªà¸à¸à¸²à¸£à¸à¹à¸à¸³à¸à¸²à¸à¸à¹à¸²à¸ISO9000\\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸</ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡à¸à¸²à¸£à¸à¸¥à¸´à¸ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢</ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸à¸¥à¸´à¹à¸à¸à¸±à¸</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1996-11-15Z</ns:Emp.StartDate><ns:Emp.EndDate>2000-05-11Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸ªà¸²à¸¢à¸à¸²à¸£à¸à¸´à¸à¸à¹à¸²à¸à¸£à¸²à¸¡ </ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¹à¸²à¸à¸¢à¸à¸à¹ </ns:Emp.JobTitle><ns:Emp.Responsibility>à¸à¹à¸­à¸¡à¸à¸³à¸£à¸¸à¸à¹à¸à¸£à¸·à¹à¸­à¸à¸¡à¸·à¸­à¸«à¸à¸±à¸à¹à¸à¸à¸²à¸£à¸à¸¥à¸´à¸à¸«à¸¥à¸²à¸¢à¸à¸£à¸°à¹à¸ à¸  à¸à¸±à¸à¸à¸±à¹à¸à¹à¸¥à¸°à¹à¸à¹à¸à¸²à¸à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸±à¸à¸£à¸à¸µà¹à¸à¹à¸­à¸à¸à¸²à¸£à¸à¸§à¸²à¸¡à¹à¸¡à¹à¸à¸¢à¸³à¸ªà¸¹à¸  à¹à¸à¹à¹à¸¥à¸°à¹à¸à¸µà¸¢à¸à¹à¸à¸£à¹à¸à¸£à¸¡ CNC à¸ªà¸³à¸«à¸£à¸±à¸à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸±à¸à¸£ \\nà¹à¸à¹à¸£à¸±à¸à¸à¸²à¸£à¸à¸¶à¸à¸­à¸à¸£à¸¡à¸à¹à¸²à¸à¸à¸²à¸£à¸à¸¥à¸´à¸à¹à¸à¸¢à¹à¸à¹à¸à¸­à¸¡à¸à¸´à¸§à¹à¸à¸­à¸£à¹à¸­à¸¢à¹à¸²à¸à¸¥à¸°à¹à¸­à¸µà¸¢à¸ \\n        </ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸  </ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡à¸à¸²à¸£à¸à¸¥à¸´à¸ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£ </ns:Loc.State><ns:Loc.City>à¸ªà¸µà¸¥à¸¡ </ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Employment><ns:Emp.StartDate>1994-06-15Z</ns:Emp.StartDate><ns:Emp.EndDate>1996-06-11Z</ns:Emp.EndDate><ns:Emp.OrgName>à¸à¸£à¸´à¸©à¸±à¸à¹à¸ªà¸à¹à¸à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡ à¸à¸³à¸à¸±à¸  </ns:Emp.OrgName><ns:Emp.JobTitle>à¸à¸¹à¹à¸à¹à¸§à¸¢à¸à¹à¸²à¸à¸¢à¸à¸à¹ </ns:Emp.JobTitle><ns:Emp.Responsibility>à¸£à¸±à¸à¸à¸´à¸à¸à¸­à¸à¸à¸²à¸à¸à¸à¹à¸à¸¢à¹à¸¡à¹à¸­à¸²à¸¨à¸±à¸¢à¸¨à¸¹à¸à¸¢à¹à¸à¸¥à¸²à¸ à¹à¸à¹à¸£à¸±à¸à¸à¸²à¸£à¸à¸¶à¸à¸­à¸à¸£à¸¡à¹à¸à¸µà¹à¸¢à¸§à¸à¸±à¸à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸¥à¸¶à¸à¹à¸¥à¸°à¹à¸à¸£à¸·à¹à¸­à¸à¹à¸¡à¹à¸à¸µà¹à¸à¸§à¸à¸à¸¸à¸¡à¸à¹à¸§à¸¢à¸¡à¸·à¸­ à¸à¸£à¹à¸­à¸¡à¸à¹à¸§à¸¢à¸à¸²à¸£à¹à¸à¹à¹à¸¡à¹à¸à¸£à¸¡à¸´à¹à¸à¸­à¸£à¹à¹à¸¥à¸°à¸à¸²à¸¥à¸´à¹à¸à¸­à¸£à¹  à¸¡à¸µà¹à¸à¸£à¸·à¹à¸­à¸à¸¡à¸·à¸­à¸à¸£à¸à¸à¸¸à¸ à¸à¸³à¸à¸²à¸à¸¥à¹à¸§à¸à¹à¸§à¸¥à¸²à¹à¸à¹  \\n</ns:Emp.Responsibility><ns:Emp.FunctionCategory>à¸à¹à¸²à¸¢à¸à¸¥à¸´à¸ </ns:Emp.FunctionCategory><ns:Emp.IndustryCategory>à¸­à¸¸à¸à¸ªà¸²à¸«à¸à¸£à¸£à¸¡à¸à¸²à¸£à¸à¸¥à¸´à¸ </ns:Emp.IndustryCategory><ns:Emp.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢</ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£ </ns:Loc.State><ns:Loc.City>à¸à¸¥à¸´à¹à¸à¸à¸±à¸</ns:Loc.City></ns:Location></ns:Emp.Location></ns:Employment><ns:Education><ns:Edu.Level>à¸à¸£à¸´à¸à¸à¸²à¸à¸£à¸µ </ns:Edu.Level><ns:Edu.StartDate>1992-09-09Z</ns:Edu.StartDate><ns:Edu.EndDate>1994-05-06Z</ns:Edu.EndDate><ns:Edu.Degree>à¸§à¸´à¸à¸¢à¸²à¸¨à¸²à¸ªà¸à¸£à¸à¸±à¸à¸à¸´à¸</ns:Edu.Degree><ns:Edu.Major>Ià¸§à¸´à¸¨à¸§à¸à¸£à¸£à¸¡à¹à¸à¸£à¸·à¹à¸­à¸à¸à¸¥</ns:Edu.Major><ns:Edu.Minor/><ns:Edu.GPA>3.2</ns:Edu.GPA><ns:Edu.GPAScale>4</ns:Edu.GPAScale><ns:Edu.School>à¸¡à¸«à¸²à¸§à¸´à¸à¸¢à¸²à¸¥à¸±à¸¢à¸ªà¸²à¸à¸¥ </ns:Edu.School><ns:Edu.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸</ns:Loc.CountryRegion><ns:Loc.State>à¸à¸à¸¸à¸¡à¸à¸²à¸à¸µ  </ns:Loc.State><ns:Loc.City>à¸£à¸±à¸à¸ªà¸´à¸</ns:Loc.City></ns:Location></ns:Edu.Location></ns:Education><ns:Address><ns:Addr.Type>à¸à¹à¸²à¸ </ns:Addr.Type><ns:Addr.Street>512/4 à¸à¸­à¸¢ 21</ns:Addr.Street><ns:Addr.Location><ns:Location><ns:Loc.CountryRegion>à¸à¸£à¸°à¹à¸à¸¨à¹à¸à¸¢ </ns:Loc.CountryRegion><ns:Loc.State>à¸à¸£à¸¸à¸à¹à¸à¸à¸¡à¸«à¸²à¸à¸à¸£</ns:Loc.State><ns:Loc.City>à¸à¸¥à¸´à¹à¸à¸à¸±à¸ </ns:Loc.City></ns:Location></ns:Addr.Location><ns:Addr.PostalCode>10170</ns:Addr.PostalCode><ns:Addr.Telephone><ns:Telephone><ns:Tel.Type>à¸à¹à¸²à¸ </ns:Tel.Type><ns:Tel.IntlCode>2</ns:Tel.IntlCode><ns:Tel.Number>555-0114</ns:Tel.Number></ns:Telephone></ns:Addr.Telephone></ns:Address><ns:EMail/><ns:WebSite/></ns:Resume>	2007-06-23 00:00:00
\.


--
-- Data for Name: shift; Type: TABLE DATA; Schema: humanresources; Owner: postgres
--

COPY humanresources.shift (shiftid, name, starttime, endtime, modifieddate) FROM stdin;
1	Day	07:00:00	15:00:00	2008-04-30 00:00:00
2	Evening	15:00:00	23:00:00	2008-04-30 00:00:00
3	Night	23:00:00	07:00:00	2008-04-30 00:00:00
\.


--
-- Data for Name: address; Type: TABLE DATA; Schema: person; Owner: postgres
--

COPY person.address (addressid, addressline1, addressline2, city, stateprovinceid, postalcode, spatiallocation, rowguid, modifieddate) FROM stdin;
1	1970 Napa Ct.	\N	Bothell	79	98011	E6100000010CAE8BFC28BCE4474067A89189898A5EC0	9aadcb0d-36cf-483f-84d8-585c2d4ec6e9	2007-12-04 00:00:00
2	9833 Mt. Dias Blv.	\N	Bothell	79	98011	E6100000010CD6FA851AE6D74740BC262A0A03905EC0	32a54b9e-e034-4bfb-b573-a71cde60d8c0	2008-11-30 00:00:00
3	7484 Roundtree Drive	\N	Bothell	79	98011	E6100000010C18E304C4ADE14740DA930C7893915EC0	4c506923-6d1b-452c-a07c-baa6f5b142a4	2013-03-07 00:00:00
4	9539 Glenside Dr	\N	Bothell	79	98011	E6100000010C813A0D5F9FDE474011A5C28A7C955EC0	e5946c78-4bcc-477f-9fa1-cc09de16a880	2009-02-03 00:00:00
5	1226 Shoe St.	\N	Bothell	79	98011	E6100000010C61C64D8ABBD94740C460EA3FD8855EC0	fbaff937-4a97-4af0-81fd-b849900e9bb0	2008-12-19 00:00:00
6	1399 Firestone Drive	\N	Bothell	79	98011	E6100000010CE0B4E50458DA47402F12A5F80C975EC0	febf8191-9804-44c8-877a-33fde94f0075	2009-02-13 00:00:00
7	5672 Hale Dr.	\N	Bothell	79	98011	E6100000010C18E304C4ADE1474011A5C28A7C955EC0	0175a174-6c34-4d41-b3c1-4419cd6a0446	2009-12-11 00:00:00
8	6387 Scenic Avenue	\N	Bothell	79	98011	E6100000010C0029A5D93BDF4740E248962FD5975EC0	3715e813-4dca-49e0-8f1c-31857d21f269	2008-12-17 00:00:00
9	8713 Yosemite Ct.	\N	Bothell	79	98011	E6100000010C6A80AD742DDC4740851574F7198C5EC0	268af621-76d7-4c78-9441-144fd139821a	2012-05-30 00:00:00
10	250 Race Court	\N	Bothell	79	98011	E6100000010C219D64AE1FE4474040862564B7825EC0	0b6b739d-8eb6-4378-8d55-fe196af34c04	2008-12-02 00:00:00
11	1318 Lasalle Street	\N	Bothell	79	98011	E6100000010CCEFFBBFD9FE9474057B9479C728E5EC0	981b3303-aca2-49c7-9a96-fb670785b269	2013-02-28 00:00:00
12	5415 San Gabriel Dr.	\N	Bothell	79	98011	E6100000010C6A80AD742DDC474011A5C28A7C955EC0	1c2c9cfe-ab9f-4f96-8e1f-d9666b6f7f22	2013-01-05 00:00:00
13	9265 La Paz	\N	Bothell	79	98011	E6100000010CC3228C0867E84740F3BC169B7F835EC0	e0ba2f52-c907-4553-a0db-67fc67d28ae4	2013-12-14 00:00:00
14	8157 W. Book	\N	Bothell	79	98011	E6100000010C219D64AE1FE4474067A89189898A5EC0	a1c658ae-c553-4a9d-a081-a550d39b64df	2009-12-04 00:00:00
15	4912 La Vuelta	\N	Bothell	79	98011	E6100000010C219D64AE1FE447405E6ED153B4945EC0	f397e64a-a9d8-4e57-9e7c-b10928acadd6	2013-11-18 00:00:00
16	40 Ellis St.	\N	Bothell	79	98011	E6100000010CF76E45EFC9DC474067A89189898A5EC0	0312b65f-cb60-4396-9ec7-a78b2eac1a1b	2012-11-09 00:00:00
17	6696 Anchor Drive	\N	Bothell	79	98011	E6100000010C034C75E402DE4740BC262A0A03905EC0	ce9b3b47-9267-4727-bcd2-687c47482c06	2013-11-08 00:00:00
18	1873 Lion Circle	\N	Bothell	79	98011	E6100000010C219D64AE1FE447405FF307D247845EC0	963854f7-e3cb-46a1-a3db-1b05f71d6473	2013-11-30 00:00:00
19	3148 Rose Street	\N	Bothell	79	98011	E6100000010C813A0D5F9FDE47407DDBB3C144965EC0	6b7acb0f-cdbf-44fd-ba14-eb08a56c1582	2014-04-03 00:00:00
20	6872 Thornwood Dr.	\N	Bothell	79	98011	E6100000010C034C75E402DE4740483BAF1BF9885EC0	4b1f1ed4-97a4-43fd-bb1e-9e05817718e8	2009-02-05 00:00:00
21	5747 Shirley Drive	\N	Bothell	79	98011	E6100000010CEB9115FA90DB47408E4F342DEF815EC0	d83299d7-a0f4-4055-9bd5-5908e245d757	2009-02-11 00:00:00
22	636 Vine Hill Way	\N	Portland	58	97205	E6100000010CB55B852318C34640DD7A52C8D3A75EC0	7f641525-2704-4f73-9d8a-eb062cfbfa3c	2011-05-24 00:00:00
23	6657 Sand Pointe Lane	\N	Seattle	79	98104	E6100000010C9F07FD5862DD47409F583A2EE9975EC0	b991568f-5096-4a92-b25c-1a3e4d2acc66	2009-01-15 00:00:00
24	80 Sunview Terrace	\N	Duluth	36	55802	E6100000010C04554A7DD566474059F1E1D0B30457C0	be07d3c8-6e58-4670-9da9-151ab6d3d620	2011-05-24 00:00:00
25	9178 Jumping St.	\N	Dallas	73	75201	E6100000010C10A810D1886240403A0F0653663158C0	c8df3bd9-48f0-4654-a8dd-14a67a84d3c6	2012-07-31 00:00:00
26	5725 Glaze Drive	\N	San Francisco	9	94109	E6100000010CFE3883FD5AE14240E38A86B1249A5EC0	77415959-a4ee-4da6-86f9-70c097560005	2011-05-24 00:00:00
27	2487 Riverside Drive	\N	Nevada	74	84407	E6100000010C50ECC7344CA044400C0B98AB57FA5BC0	c1d0f3b0-6b2a-4388-8861-48f44d8270a1	2011-05-24 00:00:00
28	9228 Via Del Sol	\N	Phoenix	6	85004	E6100000010CCEEAD68894D440404D9D2EDC020E5CC0	12ae5ee1-fc3e-468b-9b92-3b970b169774	2011-08-01 00:00:00
29	8291 Crossbow Way	\N	Memphis	72	38103	E6100000010C7AED632C1D9641401C8388AE3C8A56C0	7cc794ad-1822-412b-ab94-337a89a1d0c9	2011-05-24 00:00:00
30	9707 Coldwater Drive	\N	Orlando	15	32804	E6100000010C90C10F63019F3C4089A0F6721C5254C0	7431591f-36c1-4a65-b722-0e006db73557	2011-07-01 00:00:00
31	9100 Sheppard Avenue North	\N	Ottawa	57	K4B 1T7	E6100000010CFE790DE102A84640715F3BDE74D652C0	644dea26-e6fd-4019-85e6-35364ddab0cc	2011-05-24 00:00:00
32	26910 Indela Road	\N	Montreal	63	H1Y 2H5	E6100000010C30D3FD464FCA4640CD2A07B90E6152C0	84a95f62-3ae8-4e7e-bbd5-5a6f00cd982d	2012-06-30 00:00:00
33	10203 Acorn Avenue	\N	Calgary	1	T2P 2G8	E6100000010CB2F2FC2E338E4940BA61B7D381795CC0	237986d3-0f02-4d59-9b2e-6b1a6b5a6185	2011-05-24 00:00:00
34	94, rue Descartes	\N	Bordeaux	119	33000	E6100000010C1F9AACD1B8624640606323101251E3BF	57f25eed-0f07-43ba-83b4-5a4b398f4bf2	2013-12-21 10:09:29.423
35	Pascalstr 951	\N	Berlin	20	14111	E6100000010C078D021125484A408AD730111F9C2A40	2985cf68-8155-45a3-b086-7b08bd4d46ef	2013-05-23 00:00:00
36	34 Waterloo Road	\N	Melbourne	77	3000	E6100000010C17C9C9D093E642C035B63CBED31E6240	18e590a6-a500-48b5-b092-9e0b59816436	2013-05-23 00:00:00
37	Downshire Way	\N	Cambridge	14	BA5 3HX	E6100000010CFD6ECF37749849406E2CA98C0AF704C0	7f80f9ce-50f1-404b-8c18-7c95ee35a6ee	2012-05-23 00:00:00
38	8154 Via Mexico	\N	Detroit	35	48226	E6100000010C3D5A41438330454086E592457FC954C0	bd54f2ad-157a-4491-9f05-cc1d5a492cf1	2011-05-24 00:00:00
39	3997 Via De Luna	\N	Cambridge	30	02139	E6100000010C74132705E72B4540E64A71E28ACB51C0	a5a9ac6d-5488-4a15-a932-f6fa651093f7	2012-09-23 00:00:00
40	1902 Santa Cruz	\N	Bothell	79	98011	E6100000010C96D19C3E4AE2474057B9479C728E5EC0	5a0c5c47-18be-420b-89ba-d39878160d80	2010-02-01 00:00:00
41	793 Crawford Street	\N	Kenmore	79	98028	E6100000010CF89D8A7846E84740D1680C2DC38A5EC0	58f28ffb-be74-47f9-aec0-d5771026ed8f	2014-03-25 00:00:00
42	463 H Stagecoach Rd.	\N	Kenmore	79	98028	E6100000010C1BF06593F0E047402DCB06C6D9865EC0	782c540d-3ead-4d15-b170-e60616cf125b	2009-01-20 00:00:00
43	5203 Virginia Lane	\N	Kenmore	79	98028	E6100000010C20D3DF97B7DF47402990709D32895EC0	e210a601-42b9-4313-979d-4bcca6144343	2010-02-13 00:00:00
44	4095 Cooper Dr.	\N	Kenmore	79	98028	E6100000010C150DEC8E29E24740146981D2EE945EC0	e6a218ae-516c-4cd6-a0a9-105fcd46994b	2008-12-27 00:00:00
45	6697 Ridge Park Drive	\N	Kenmore	79	98028	E6100000010C4225BBB261D84740146981D2EE945EC0	95a73034-bd61-4349-b337-02d647c88cdd	2008-11-25 00:00:00
46	5669 Ironwood Way	\N	Kenmore	79	98028	E6100000010C76AC4DF6E2E84740C9F2DFDB748F5EC0	8fd29f31-eb25-4ec7-9258-fef7160119c0	2009-01-29 00:00:00
47	8192 Seagull Court	\N	Kenmore	79	98028	E6100000010C04647E81D4E547407941A8BC538C5EC0	3de1bde3-ff37-4992-b50e-e12d5e247132	2009-01-11 00:00:00
48	5553 Cash Avenue	\N	Kenmore	79	98028	E6100000010CC0337E30FED8474075061294AC8E5EC0	1875165e-d9e4-414f-8fcb-6a8720625443	2014-01-31 00:00:00
49	7048 Laurel	\N	Kenmore	79	98028	E6100000010C1BF06593F0E04740C9F2DFDB748F5EC0	c172e367-e6e6-4200-8865-12902022b891	2009-02-01 00:00:00
50	25 95th Ave NE	\N	Kenmore	79	98028	E6100000010C0947F8859BE44740BC411D627F965EC0	8ad42881-a81b-4a4d-95c2-6d34a55f3bc9	2009-02-06 00:00:00
51	3280 Pheasant Circle	\N	Snohomish	79	98296	E6100000010CE394E9D501E2474014B8B3D8FE915EC0	d40aa5ff-462b-4322-9c67-c7b5f468e6e3	2008-11-30 00:00:00
52	4231 Spar Court	\N	Snohomish	79	98296	E6100000010C182C38B72BE047407D89EAD8CD805EC0	19801401-913f-45fa-a7d3-8573f35202e7	2009-01-20 00:00:00
53	1285 Greenbrier Street	\N	Snohomish	79	98296	E6100000010C39DB74CBB2F0474003CACBFB25835EC0	d08e2b94-ffc3-44f6-b926-ecd76f0360f6	2008-12-28 00:00:00
54	5724 Victory Lane	\N	Snohomish	79	98296	E6100000010C39DB74CBB2F04740890AAD1E7E855EC0	aeb2271b-a9e9-454e-b04b-8a3b91014463	2010-01-29 00:00:00
55	591 Merriewood Drive	\N	Snohomish	79	98296	E6100000010C1040A96179EF47407261B07BBE8B5EC0	ab314668-eacd-4440-9832-cccf2b187078	2009-02-16 00:00:00
56	3114 Notre Dame Ave.	\N	Snohomish	79	98296	E6100000010C1040A96179EF4740720828931D7C5EC0	e7a29ce5-7ec6-4e64-9480-0c166297b6a5	2013-11-29 00:00:00
57	7230 Vine Maple Street	\N	Snohomish	79	98296	E6100000010CA50D8F1616F047407261B07BBE8B5EC0	2c5fe85e-796e-4666-b449-9cfdfa870058	2009-01-22 00:00:00
58	2601 Cambridge Drive	\N	Snohomish	79	98296	E6100000010C43CFFD3184E747408E77D2B5A68F5EC0	44668102-3c93-4005-baab-e14d351d1522	2008-12-05 00:00:00
59	2115 Passing	\N	Snohomish	79	98296	E6100000010CDAA4DDF73FEE474077754D2A46865EC0	77923f90-fccd-40ae-8c51-52a2267a5a61	2008-11-30 00:00:00
60	4852 Chaparral Court	\N	Snohomish	79	98296	E6100000010C78664C13AEE54740E6B3A9C13D7F5EC0	5457d27a-52b3-4150-87ea-96b42645ab01	2009-12-25 00:00:00
61	7726 Driftwood Drive	\N	Monroe	79	98272	E6100000010CC440A386ACE847406C86CCD635785EC0	07373e01-bd99-405a-996a-ab68984423c3	2006-06-23 00:00:00
62	3841 Silver Oaks Place	\N	Monroe	79	98272	E6100000010CC56E23CC68EF4740949BC704EA835EC0	851aa003-2d0f-4165-a54b-a13d9b86924a	2008-11-27 00:00:00
63	9652 Los Angeles	\N	Monroe	79	98272	E6100000010CC440A386ACE8474044786554C5795EC0	e031cc1e-3e82-4338-b590-5fe91242deff	2009-01-27 00:00:00
64	4566 La Jolla	\N	Monroe	79	98272	E6100000010C827F23CEDBF14740BBA92E875A825EC0	39efcf68-25ca-4b41-9882-a91f8fc2ec62	2009-01-08 00:00:00
65	1356 Grove Way	\N	Monroe	79	98272	E6100000010C8151A3881FEB474036062D4141865EC0	c9ed93ad-fe56-4a9e-86d0-e53db70db0cc	2009-02-14 00:00:00
66	4775 Kentucky Dr.	Unit E	Monroe	79	98272	E6100000010C9C3C23C60FE84740E5DB36E5D86E5EC0	462876dd-b30c-4e9b-a0ad-67a0e14986c6	2014-05-27 00:00:00
67	4734 Sycamore Court	\N	Monroe	79	98272	E6100000010C4B7BA30D3FF147406D8D608279855EC0	f6a0bc36-9c6e-4395-a7d5-8f31ad3775f4	2008-12-20 00:00:00
68	896 Southdale	\N	Monroe	79	98272	E6100000010CFA16A3018DE24740D669FED1547B5EC0	bff6c765-a8ea-4f40-9c87-43c8829eb396	2009-02-26 00:00:00
69	2275 Valley Blvd.	\N	Monroe	79	98272	E6100000010C594D23C882EA474078D4630EAC7D5EC0	192987fc-ca4b-421a-8ea9-52ed8eed3d32	2009-01-14 00:00:00
70	1792 Belmont Rd.	\N	Monroe	79	98272	E6100000010CAA83A38E78F247406C86CCD635785EC0	5f659de9-3a31-41d5-bb92-ea0d34486c83	2008-12-02 00:00:00
71	5734 Ashford Court	\N	Monroe	79	98272	E6100000010C0730A38439E6474093943359A6765EC0	5cd0edd1-7841-49c9-aebb-69ed1cd2989c	2008-02-13 00:00:00
72	5030 Blue Ridge Dr.	\N	Monroe	79	98272	E6100000010C2377234DA2F04740CB22FB4522835EC0	51711cd3-947c-4666-882f-a50943e12339	2009-02-06 00:00:00
73	158 Walnut Ave	\N	Monroe	79	98272	E6100000010C6638A30573E74740A20D00186E775EC0	2ad59424-b8fc-4957-82f7-62c11dd89235	2009-02-07 00:00:00
74	8310 Ridge Circle	\N	Monroe	79	98272	E6100000010C3E9023D04EF447405F38359FBF725EC0	82780fdb-8df5-4334-9994-2d306ecc73e1	2008-11-30 00:00:00
75	3747 W. Landing Avenue	\N	Monroe	79	98272	E6100000010C221B23C229E34740F23062C892815EC0	05524ab0-4696-4670-8d2f-580b6a5df760	2009-02-28 00:00:00
76	2598 La Vista Circle	\N	Duvall	79	98019	E6100000010CB0EA3DB968E347402CE232B5ED685EC0	3661f140-8de9-4c81-a54e-661e6c61a801	2009-02-03 00:00:00
77	9693 Mellowood Street	\N	Duvall	79	98019	E6100000010C2D6899BAAFE747407520D45948725EC0	c83b3a62-3561-4378-b307-540451ac23bd	2008-02-20 00:00:00
78	1825 Corte Del Prado	\N	Duvall	79	98019	E6100000010C1B709E483EDA4740D1D0ABB0F16F5EC0	86f8d7ea-af62-4a35-8fc6-4278bca608f1	2008-12-27 00:00:00
79	5086 Nottingham Place	\N	Duvall	79	98019	E6100000010C39F1E4FE68D847402D8183079B6D5EC0	83393058-231c-4d1e-863a-88385d126810	2010-01-17 00:00:00
80	3977 Central Avenue	\N	Duvall	79	98019	E6100000010C0BEF579213DC474076BF24ACF5765EC0	30a7ad1e-78f0-4f04-83ee-2cd1c37d59a5	2009-02-02 00:00:00
81	8209 Green View Court	\N	Duvall	79	98019	E6100000010C8F71FC90CCD74740A0FCEA42B5695EC0	41ae4c8a-1922-427a-b66f-3779639b0f42	2010-02-20 00:00:00
82	8463 Vista Avenue	\N	Duvall	79	98019	E6100000010CA069F7023EE5474062AE9DA7F97D5EC0	c2ae1ea5-4f3c-413c-8810-4185ee46bb96	2009-02-21 00:00:00
83	5379 Treasure Island Way	# 14	Duvall	79	98019	E6100000010C2D6899BAAFE747408E2905E3137A5EC0	f229a37b-c8d9-4e4a-99bb-4d12715a2f5e	2009-02-04 00:00:00
84	3421 Bouncing Road	\N	Duvall	79	98019	E6100000010CA069F7023EE5474032792D8C6A7C5EC0	83b10347-08dc-4e5e-8a94-60deb34d92a7	2008-12-01 00:00:00
85	991 Vista Verde	\N	Duvall	79	98019	E6100000010CE5F1132330D74740A5F494C784785EC0	8eab0498-eb64-4f80-aede-ca3735d4c097	2009-02-01 00:00:00
86	390 Ridgewood Ct.	\N	Carnation	79	98014	E6100000010C8B773FA1AFDD4740ED29E16761775EC0	dafbd136-5ac2-4f16-8d82-2bfffd60b7a7	2008-12-20 00:00:00
87	1411 Ranch Drive	\N	Carnation	79	98014	E6100000010C866A60EF3EDB4740D4329D84B8795EC0	b7ad6512-9b80-4fdb-8ebb-b9934b211cea	2009-02-06 00:00:00
88	9666 Northridge Ct.	\N	Carnation	79	98014	E6100000010CBCEC7CA2A7CF4740370FAD115C705EC0	fd316d3a-10f5-41d7-8cd9-7b1eaa851223	2008-12-01 00:00:00
89	3074 Arbor Drive	\N	Carnation	79	98014	E6100000010C8A50A28B5DD647408A4DD1DABD805EC0	bf8e2fbe-1bc0-4643-9764-2903c86438ec	2008-12-14 00:00:00
90	9752 Jeanne Circle	\N	Carnation	79	98014	E6100000010C8F5D813DCED84740BC3B59A10F7C5EC0	5582d57f-9e56-4d15-8633-633206d2a182	2010-01-09 00:00:00
91	7166 Brock Lane	\N	Seattle	79	98104	E6100000010C8726B9B50FCF47409A9689D608995EC0	219725c5-2537-45db-879d-ce160729eece	2008-12-15 00:00:00
92	7126 Ending Ct.	\N	Seattle	79	98104	E6100000010C9A77BCE123C747406282BA744A8D5EC0	dedcaecb-19b4-4441-9bbb-bc758329f406	2007-12-19 00:00:00
93	4598 Manila Avenue	\N	Seattle	79	98104	E6100000010C76957EBCD7CD4740789E0F64BB9D5EC0	058435df-1143-4921-a47e-fd02e7f05ea7	2010-01-29 00:00:00
94	5666 Hazelnut Lane	\N	Seattle	79	98104	E6100000010C76957EBCD7CD47409A9689D608995EC0	1033ef53-1246-4830-878c-516d4697ed8b	2009-02-24 00:00:00
95	1220 Bradford Way	\N	Seattle	79	98104	E6100000010C019EE4EB4FC547405F3EB2FC77975EC0	ef7470d7-d3ce-4e30-ae81-6e1f7752134e	2008-12-08 00:00:00
96	5375 Clearland Circle	\N	Seattle	79	98104	E6100000010CA8482EA87FD147408346388A2A9C5EC0	ef57ea2b-15fd-4887-90dc-77ec79ae67e9	2009-01-04 00:00:00
97	2639 Anchor Court	\N	Seattle	79	98104	E6100000010CDAFBDD9327D5474067D6CE07828C5EC0	9c3d0b0d-e3b3-4696-b0eb-a90356cb8acc	2014-02-07 00:00:00
98	502 Alexander Pl.	\N	Seattle	79	98104	E6100000010C52B340978BD44740703AEFB51E955EC0	b3d67582-a180-42ad-be0d-e8fac4080354	2009-01-25 00:00:00
99	5802 Ampersand Drive	\N	Seattle	79	98104	E6100000010C63447B90C3D54740789E0F64BB9D5EC0	137cc1ba-089a-4e2d-91bf-7480802a7e00	2008-12-31 00:00:00
100	5125 Cotton Ct.	\N	Seattle	79	98104	E6100000010CEB8C188D5FD647406492C68FAF965EC0	ab6bcc20-67d3-4a26-ba02-cdc917c2dee4	2009-02-03 00:00:00
101	3243 Buckingham Dr.	# 207	Seattle	79	98104	E6100000010C3091CBA41BD24740703AEFB51E955EC0	0f1f79ab-54a1-4c6c-beb7-e476e8521599	2009-02-15 00:00:00
102	3029 Pastime Dr	# 2	Seattle	79	98104	E6100000010C0F6F56B2ABCF4740B84AFBD0839E5EC0	5e77ca8d-72d4-4572-8f88-1a1a5a7969f0	2009-01-04 00:00:00
103	9537 Ridgewood Drive	\N	Seattle	79	98104	E6100000010CAB08F7DA5BC847405F3EB2FC77975EC0	906f7b49-e609-42cb-9bf5-ed5c043d166c	2010-02-05 00:00:00
104	9964 North Ridge Drive	\N	Seattle	79	98104	E6100000010C0F6F56B2ABCF4740868A4002FD915EC0	3b560935-ad49-458d-9c58-3d09c4b1ec3e	2009-01-29 00:00:00
105	1619 Stillman Court	\N	Seattle	79	98104	E6100000010CDAFBDD9327D547406AE6DA22E7955EC0	3a7baabe-a265-43de-86e1-cfe6ea60e3b0	2008-12-19 00:00:00
106	2144 San Rafael	\N	Seattle	79	98104	E6100000010C97B7F3AE47D04740868A4002FD915EC0	e0d82a90-fae8-43a9-a98d-4f6512e57709	2009-01-05 00:00:00
107	7403 N. Broadway	\N	Seattle	79	98104	E6100000010CEB8C188D5FD647407BE217DC8D935EC0	c9fe9dd9-6867-44fc-9c5a-07dbc9ca6f7f	2009-01-01 00:00:00
108	7842 Ygnacio Valley Road	\N	Seattle	79	98104	E6100000010CAB08F7DA5BC8474056DA914EDB8E5EC0	6600064e-0b21-405d-85c4-6a5e1e41771d	2008-12-10 00:00:00
109	874 Olivera Road	\N	Seattle	79	98104	E6100000010CB9D968A1B7D24740703AEFB51E955EC0	f868aae1-dacb-4606-88c4-eb07f4492629	2010-02-24 00:00:00
110	1064 Slow Creek Road	\N	Seattle	79	98104	E6100000010CEB8C188D5FD647407DF223F7F29C5EC0	184ad4a1-45b8-4910-a2b2-a9e2a658b07c	2008-12-08 00:00:00
111	77 Birchwood	\N	Seattle	79	98104	E6100000010C22C059DEBFC7474051867DBBA38F5EC0	c27e3b42-1548-404c-b104-f765cf42c068	2009-01-27 00:00:00
112	7765 Sunsine Drive	\N	Seattle	79	98104	E6100000010CEB8C188D5FD6474045DE549534915EC0	40e9167a-db5b-4d4b-9b57-f5030a37ea4c	2009-02-19 00:00:00
113	1102 Ravenwood	\N	Seattle	79	98104	E6100000010CDAFBDD9327D547409A9689D608995EC0	8a12573d-d7c2-4c04-bbb1-a2f050626670	2009-12-15 00:00:00
114	1398 Yorba Linda	\N	Seattle	79	98104	E6100000010C4122069E53D347408EEE60B0999A5EC0	c32ca551-349e-42fd-ab0b-6170e7f0b516	2009-02-08 00:00:00
115	4948 West 4th St	\N	Seattle	79	98104	E6100000010C200091ABE3D0474056DA914EDB8E5EC0	e7cbd421-ffd2-4a42-a143-67da8558cc03	2009-02-13 00:00:00
116	8290 Margaret Ct.	\N	Seattle	79	98104	E6100000010CCC2A6CCDCBCA47406AE6DA22E7955EC0	db4fab47-ed99-45b0-9064-3aa30f94d74d	2009-01-10 00:00:00
117	426 San Rafael	\N	Seattle	79	98104	E6100000010C650444C39FCC474045DE549534915EC0	5c85508e-c13b-49f2-a260-0a0825ed9b81	2009-02-08 00:00:00
118	136 Balboa Court	\N	Seattle	79	98104	E6100000010CB9D968A1B7D247408346388A2A9C5EC0	e8d35bfa-25ae-422e-b9e9-1d4f4aea18cc	2008-12-25 00:00:00
119	7439 Laguna Niguel	\N	Seattle	79	98104	E6100000010C122F1FE587C64740789E0F64BB9D5EC0	e09b80e3-dd7f-4dd5-a930-3f1dee324f48	2008-11-28 00:00:00
120	6498 Mining Rd.	\N	Seattle	79	98104	E6100000010CEE4CE1BF3BCD47404B3269286C905EC0	fb839852-9026-4c74-a7f2-e53030b7a434	2009-02-08 00:00:00
121	6578 Woodhaven Ln.	\N	Seattle	79	98104	E6100000010CCC2A6CCDCBCA47404B3269286C905EC0	84eaaa89-fdb6-492b-ad96-76793872c81b	2008-11-26 00:00:00
122	2354 Frame Ln.	\N	Seattle	79	98104	E6100000010C8726B9B50FCF47404B3269286C905EC0	28b00d11-67b0-4818-8b3a-1cfd2ff6169d	2009-12-18 00:00:00
123	6843 San Simeon Dr.	\N	Seattle	79	98104	E6100000010CCC2A6CCDCBCA47407DF223F7F29C5EC0	27ce20f5-6770-4dcc-9b57-ec895a745553	2009-01-26 00:00:00
124	7616 Honey Court	\N	Seattle	79	98104	E6100000010C8726B9B50FCF47409FEA9D6940985EC0	6a85821b-1e54-41e7-bb10-25feaf5a63e8	2008-12-05 00:00:00
125	931 Corte De Luna	\N	Seattle	79	98104	E6100000010CDAFBDD9327D5474045DE549534915EC0	2c9d61c7-2185-45c3-b20e-04ab9cadff7a	2008-12-08 00:00:00
126	7594 Alexander Pl.	\N	Seattle	79	98104	E6100000010CDDBBA6C603CC47405F3EB2FC77975EC0	fad17750-d933-4352-9c7c-2fc1378ed1a6	2008-12-10 00:00:00
127	7127 Los Gatos Court	\N	Seattle	79	98104	E6100000010C63447B90C3D5474032D20BC1288A5EC0	5648b48c-4a83-491e-a4c1-edcbb199c0fd	2008-11-29 00:00:00
128	8656 Lakespring Place	\N	Seattle	79	98104	E6100000010CA8482EA87FD14740703AEFB51E955EC0	e7889d2b-ae5e-4b37-ab7b-cf28187a3114	2010-01-05 00:00:00
129	5025 Holiday Hills	\N	Seattle	79	98104	E6100000010CA8482EA87FD147404B3269286C905EC0	94d5bd03-6949-405d-b0df-7ac5f278081f	2008-12-26 00:00:00
130	5376 Catanzaro Way	\N	Seattle	79	98104	E6100000010C44E2CED02FCA47405C2EA6E1128E5EC0	ad7c7f01-b283-41f1-b8f1-3aebfe50fd18	2009-02-25 00:00:00
131	504 O St.	\N	Edmonds	79	98020	E6100000010C3CD75BF523E247402BB340BB358C5EC0	e858bee0-02ad-4bab-bc2b-6a66dd046e7b	2013-12-31 00:00:00
132	6870 D Bel Air Drive	\N	Edmonds	79	98020	E6100000010C26216AA9C3ED47400C6A2F30399E5EC0	ab316a30-9d6b-4b6f-915c-616f6abd7092	2010-02-06 00:00:00
133	8152 Claudia Dr.	\N	Edmonds	79	98020	E6100000010CA2F03A1E42E84740ADC92531A89C5EC0	7bbac738-c1b1-411b-b308-2054a5e1f55f	2009-01-05 00:00:00
134	6057 Hill Street	\N	Edmonds	79	98020	E6100000010C0E926BCEF9E347401747FF3464965EC0	b0f69a8c-1c4e-4a41-a710-0bb1865d85aa	2008-12-15 00:00:00
135	2812 Mazatlan	\N	Edmonds	79	98020	E6100000010CA8788CA5DBDD474056AB422E5BA15EC0	e55266a9-fb17-419f-970d-f96ee2e91f7b	2009-02-19 00:00:00
136	172 Turning Dr.	\N	Edmonds	79	98020	E6100000010CA8788CA5DBDD474020D670B60A945EC0	37c96b81-2e9c-4d4d-beae-44aba1854c47	2008-12-12 00:00:00
137	9784 Mt Etna Drive	\N	Edmonds	79	98020	E6100000010C5B05FCB9EAE047407E83C53AFE8C5EC0	e6266748-6e05-416c-8ff9-beb5c8b15323	2008-12-16 00:00:00
138	2059 Clay Rd	\N	Edmonds	79	98020	E6100000010C74AB4AF717EA47407E83C53AFE8C5EC0	a158113b-ac84-4a89-8903-a6dd5f10ce82	2008-12-28 00:00:00
139	2687 Ridge Road	\N	Edmonds	79	98020	E6100000010CE04C7BA7CFE547405AF9A0B1DF9B5EC0	25b072ab-17f7-4c1c-a13a-acd309bbaa61	2009-01-13 00:00:00
140	371 Apple Dr.	\N	Edmonds	79	98020	E6100000010C364F0A6E8AEC4740D1534ABAC68D5EC0	88fa21d3-2523-4cf1-bcfd-151e734f8961	2009-01-07 00:00:00
141	3281 Hillview Dr.	\N	Edmonds	79	98020	E6100000010C79339C7EB1DF4740CD05EC3642935EC0	ace0c24a-95b6-4f08-b223-1a39c64e9051	2008-12-10 00:00:00
142	2080 Sycamore Drive	\N	Edmonds	79	98020	E6100000010C4BEEAB5787E147401747FF3464965EC0	8541e00d-8da8-429b-912e-b7e854747a00	2008-12-28 00:00:00
143	7511 Cooper Dr.	\N	Edmonds	79	98020	E6100000010C3CD75BF523E247407E83C53AFE8C5EC0	a6d5094a-e523-45a8-abe5-0afc2e7b6fc1	2010-02-16 00:00:00
144	9825 Coralie Drive	\N	Edmonds	79	98020	E6100000010C160A1A4760EE474072A6F535D3945EC0	716cf949-c005-4255-ae10-a36a0e905fa2	2009-01-06 00:00:00
145	8411 Mt. Orange Place	\N	Edmonds	79	98020	E6100000010CEF63CB0933E547406E65E237B1915EC0	f7053382-c9f1-45bf-a0bd-878fe976208f	2008-12-12 00:00:00
146	207 Berry Court	\N	Edmonds	79	98020	E6100000010CE04C7BA7CFE547406288123386995EC0	b374fea1-c3b5-4737-a1a4-190997e961df	2009-01-03 00:00:00
147	1061 Buskrik Avenue	\N	Edmonds	79	98020	E6100000010CFE7A1B6C96E447406A1784B42C975EC0	69b366b3-533e-4f15-9d75-588789548dd0	2009-03-01 00:00:00
148	3632 Bank Way	\N	Edmonds	79	98020	E6100000010C1DA9BB305DE347405AF9A0B1DF9B5EC0	0f7b8ac1-a660-447e-aad4-a0048da3cd47	2010-02-16 00:00:00
149	3026 Anchor Drive	\N	Edmonds	79	98020	E6100000010CEF63CB0933E54740B55897B24E9A5EC0	0bfeb74b-804d-4a03-b94d-5812f3df69a8	2010-01-22 00:00:00
150	7338 Green St.	\N	Edmonds	79	98020	E6100000010CEF63CB0933E54740FF99AAB0709D5EC0	a1d9a607-d8e3-4402-9c5c-03d1131ed99b	2009-02-19 00:00:00
151	2038 Encino Drive	\N	Edmonds	79	98020	E6100000010C93D9EABBDEE84740A97BC7AD23A25EC0	08ca24af-10d0-4ac6-8e70-a6387ecdb91b	2009-01-24 00:00:00
152	2466 Clearland Circle	\N	Edmonds	79	98020	E6100000010C46665AD0EDEB4740A97BC7AD23A25EC0	1494ad94-c1fe-4a28-ad63-a59370718785	2009-12-22 00:00:00
153	9277 Country View Lane	\N	Edmonds	79	98020	E6100000010C364F0A6E8AEC47400C6A2F30399E5EC0	7d7da7be-b880-411d-88d2-521b5ccf8d25	2008-01-26 00:00:00
154	5423 Champion Rd.	\N	Edmonds	79	98020	E6100000010C0E926BCEF9E347407A3567B779925EC0	2e5b2953-bee0-4568-a6f0-5ab41abbcf63	2008-12-24 00:00:00
155	2046 Las Palmas	\N	Edmonds	79	98020	E6100000010C2CC00B93C0E247405AF9A0B1DF9B5EC0	6f00fb01-941a-48ac-852b-363829c2451b	2009-01-22 00:00:00
156	8684 Military East	\N	Bellevue	79	98004	E6100000010CBB371CDB6CD247403B6970E153815EC0	5a51864d-a250-4fec-8fb5-cebe85c124b7	2008-11-25 00:00:00
157	7270 Pepper Way	\N	Bellevue	79	98004	E6100000010CE3F71C9BC4CE47404BCA784AEE895EC0	cc0bca82-aec9-4c7a-bb9f-14f6db055c62	2008-11-27 00:00:00
158	6058 Hill Street	# 4	Bellevue	79	98004	E6100000010CE3F71C9BC4CE4740A04EE193A9955EC0	cacf831d-22dd-4e2b-a377-e11a89d2d526	2009-12-18 00:00:00
159	1648 Eastgate Lane	\N	Bellevue	79	98004	E6100000010C2902C625B1D647400BD39082B68A5EC0	fbdb3c4b-7596-4d25-b9a8-0c935c1781e2	2009-01-28 00:00:00
160	3454 Bel Air Drive	\N	Bellevue	79	98004	E6100000010CACB2994108D7474014CE6E2D93875EC0	f5c14ae9-edcf-49e4-9e4d-8f24731c64aa	2008-12-30 00:00:00
161	3067 Maya	\N	Bellevue	79	98004	E6100000010C85771B1B15D6474095195143F8905EC0	fe628a3e-e504-49ee-a556-9634c06cc432	2010-01-25 00:00:00
162	3197 Thornhill Place	\N	Bellevue	79	98004	E6100000010C71171B3BE9D7474006A7186ACD865EC0	c2f65ea2-3bd2-4a3e-9752-ce92bab74bd7	2008-12-22 00:00:00
163	3919 Pinto Road	\N	Bellevue	79	98004	E6100000010C7322C7C534D147403B6970E153815EC0	037683a3-2356-42b3-bb38-bc14cb9ded9c	2009-02-14 00:00:00
164	7396 Stratton Circle	\N	Bellevue	79	98004	E6100000010C8782C7A560CF47405B2B81B388925EC0	72186098-a652-4df8-91d1-9cfe115ffb7a	2010-01-17 00:00:00
165	9745 Bonita Ct.	\N	Bellevue	79	98004	E6100000010C2902C625B1D647403B6970E153815EC0	7cf4fdfd-4b09-4466-a3d3-84ec32ed4163	2009-02-01 00:00:00
166	3670 All Ways Drive	\N	Bellevue	79	98004	E6100000010C17AD71D0D0D14740009E003205865EC0	89270ef3-86e4-41e9-b3d3-86149f08cf05	2008-11-24 00:00:00
167	7221 Peachwillow Street	\N	Bellevue	79	98004	E6100000010C898D7330ACC84740D610390B30905EC0	29024b91-f4e4-40b1-81be-7f2b23a24ff5	2010-02-25 00:00:00
168	1343 Prospect St	\N	Bellevue	79	98004	E6100000010CE1EC701079D54740C5AF30A295875EC0	386d3617-769d-40d1-ab18-301e4e40b920	2009-01-10 00:00:00
169	6448 Castle Court	\N	Bellevue	79	98004	E6100000010C85771B1B15D6474085B848DA5D885EC0	1bb6c40a-9fdf-4c9e-ac1f-8e0f2df2414a	2008-11-25 00:00:00
170	7902 Grammercy Lane	Unit A	Bellevue	79	98004	E6100000010C3D62C605DDD44740CADBA8BA7E8B5EC0	5c44745c-d11a-4f11-b9bc-345d4e064780	2009-12-04 00:00:00
171	8668 Via Neruda	\N	Bellevue	79	98004	E6100000010C71171B3BE9D7474085B848DA5D885EC0	f84f334a-19e9-4a44-952e-a857d027e9c6	2009-02-23 00:00:00
172	4777 Rockne Drive	\N	Bellevue	79	98004	E6100000010C898D7330ACC84740213DB12319945EC0	ffdaf6bd-c84a-4082-9a70-7f0cc6fbbe82	2009-01-24 00:00:00
173	620 Woodside Ct.	\N	Bellevue	79	98004	E6100000010CE3F71C9BC4CE47403B6970E153815EC0	b6172e5e-cd95-4b38-8aa6-f826a6eef24c	2010-12-18 00:00:00
174	6307 Greenbelt Way	\N	Bellevue	79	98004	E6100000010CE502C92510C847403B6970E153815EC0	0ae0d184-cb75-42ce-ab20-c2fc57db45b5	2011-02-07 00:00:00
175	3284 S. Blank Avenue	\N	Bellevue	79	98004	E6100000010C034D71F0A4D34740160821D3678F5EC0	c23064b1-cffb-41d6-aba5-bafa076c70c7	2008-12-18 00:00:00
176	8751 Norse Drive	\N	Bellevue	79	98004	E6100000010C0BB81D5B1CCB47405B2B81B388925EC0	a313e877-ebd4-4a8c-8f0a-ed20a645a6ed	2009-12-28 00:00:00
177	6968 Wren Ave.	\N	Bellevue	79	98004	E6100000010CCF971CBB98D047400BD39082B68A5EC0	d3d9fde3-c704-4126-ba36-377aedf42fbb	2009-02-09 00:00:00
178	4311 Clay Rd	\N	Bellevue	79	98004	E6100000010C71171B3BE9D747405B2B81B388925EC0	464f6ebc-6151-47e1-ac79-24b705342d51	2008-11-29 00:00:00
179	771 Northridge Drive	# 495	Bellevue	79	98004	E6100000010C0BB81D5B1CCB4740C5AF30A295875EC0	335645f3-b5d5-4b96-bac1-22267cddf8d2	2012-06-07 00:00:00
180	2947 Vine Lane	\N	Bellevue	79	98004	E6100000010C3D62C605DDD4474056FF089B9F8E5EC0	7635d2da-ad3f-47f8-afe0-6a5a25127d03	2010-01-24 00:00:00
181	9320 Teakwood Dr.	\N	Bellevue	79	98004	E6100000010C2902C625B1D64740808CD0C174845EC0	78153c31-9b7b-414b-9a68-51e892fb993c	2009-01-07 00:00:00
182	3711 Rollingwood Dr	\N	Bellevue	79	98004	E6100000010C898D7330ACC8474095195143F8905EC0	9600fb56-13a7-40d1-81fc-cbe8df0bb498	2009-02-12 00:00:00
183	6118 Grasswood Circle	\N	Bellevue	79	98004	E6100000010C672D735080CA47401B3499EB50935EC0	d9bd7258-d9d0-420c-b0c9-b55a7ef46b8c	2009-12-10 00:00:00
184	5678 Clear Court	\N	Bellevue	79	98004	E6100000010C034D71F0A4D34740213DB12319945EC0	6b78a1a0-5821-43e1-ae51-547ad9b4c996	2009-02-09 00:00:00
185	2681 Eagle Peak	\N	Bellevue	79	98004	E6100000010C3F6D729028CE47402669293C02985EC0	7bccf442-2268-46cc-8472-14c44c14e98c	2012-07-31 00:00:00
186	332 Laguna Niguel	\N	Bellevue	79	98004	E6100000010C9DED7310D8C647400BD39082B68A5EC0	8915b11c-8a2d-44ee-b2a9-7c6982739bfe	2008-12-17 00:00:00
187	7808 Brown St.	\N	Bellevue	79	98004	E6100000010C53CD727054CC4740CADBA8BA7E8B5EC0	1ccd2f45-1bee-4f78-ba59-a6f969c7da71	2009-01-09 00:00:00
188	6774 Bonanza	\N	Bellevue	79	98004	E6100000010C2902C625B1D64740666011043A975EC0	00770ccc-e264-4115-9e0c-d31734f70360	2008-12-31 00:00:00
189	3708 Montana	\N	Bellevue	79	98004	E6100000010CBB371CDB6CD2474006A7186ACD865EC0	a081a4fc-9c3c-4ce7-a27f-94830fff15e5	2008-12-20 00:00:00
190	9435 Breck Court	\N	Bellevue	79	98004	E6100000010C2D181E3B48C94740E145C95BE1945EC0	eb974caf-85e9-4424-bf5e-637c0942ef04	2007-12-30 00:00:00
191	6951 Harmony Way	\N	Sammamish	79	98074	E6100000010CBFDCCE386DD64740AF1F90A8E87D5EC0	1da32259-efad-4485-8f64-8b9b444cb3a4	2010-12-31 00:00:00
192	6871 Thornwood Dr.	\N	Sammamish	79	98074	E6100000010CF068F66C03C94740BB6603CE907B5EC0	a2b7146f-22a2-4f15-875b-4484a5473673	2009-02-22 00:00:00
193	9104 Mt. Sequoia Ct.	\N	Sammamish	79	98074	E6100000010CC32433E5FCD34740D1FAD3E0678A5EC0	954c009c-f506-42ba-ac97-a0f98b9e31b7	2008-12-07 00:00:00
194	2095 Sierra Drive	\N	Sammamish	79	98074	E6100000010CC2121AFA98D44740A488BA2BB8855EC0	2812a3ab-3eaa-4898-a176-36b6c5953d1c	2013-10-14 00:00:00
195	4444 Pepper Way	\N	Sammamish	79	98074	E6100000010CBFDCCE386DD647404AA487C1587C5EC0	5fd563b6-9349-4aa4-813b-72d96714ec7d	2009-02-27 00:00:00
196	4525 Benedict Ct.	\N	Sammamish	79	98074	E6100000010CD9C6142980CE474053F1E4AE878D5EC0	d52a20ab-b134-4205-b5e2-25b700bb5722	2008-12-18 00:00:00
197	7820 Bird Drive	\N	Sammamish	79	98074	E6100000010CBFDCCE386DD64740C5B360BBBF8C5EC0	70d9d17b-3a40-43ed-b4d1-c9a52a8f44ed	2008-12-26 00:00:00
198	1962 Ferndale Lane	\N	Sammamish	79	98074	E6100000010CC100010F35D547404D54256AD0815EC0	cf902968-4c87-4492-8c3b-bf12f42def75	2009-01-19 00:00:00
199	5263 Etcheverry Dr	\N	Sammamish	79	98074	E6100000010CD2364CD060D34740E6287FDAC87A5EC0	01c701de-ba78-4b2c-bc7e-2cf8922c7771	2009-11-26 00:00:00
200	2473 Orchard Way	\N	Sammamish	79	98074	E6100000010CEB0E79D50FCC4740D1FAD3E0678A5EC0	6d1b4fa9-5d00-4481-9561-0aea008915f7	2009-01-09 00:00:00
201	6202 Seeno St.	\N	Sammamish	79	98074	E6100000010CE9EA46FF47CD4740A488BA2BB8855EC0	ad2b250d-5dd9-4ba4-ac59-8ce487d4a77f	2013-09-05 00:00:00
202	4096 San Remo	\N	Sammamish	79	98074	E6100000010CAC8251A179D9474082AD76F338795EC0	494a6c49-3ea7-4a3d-bff8-f727f565e393	2008-12-21 00:00:00
203	7086 O St.	\N	Sammamish	79	98074	E6100000010CE9EA46FF47CD4740139B988F787F5EC0	5a272060-cdb3-4d4a-be2f-af143f4e72d4	2009-12-30 00:00:00
204	4310 Kenston Dr.	\N	Sammamish	79	98074	E6100000010CEAFC5FEAABCC4740E6287FDAC87A5EC0	7e585905-3991-42bf-8c51-1f0e40f48d28	2010-01-10 00:00:00
205	7939 Bayview Court	\N	Sammamish	79	98074	E6100000010CBB946A8CDDD84740D1FAD3E0678A5EC0	a47cbd73-36a5-4051-bd64-65e93630e6df	2009-01-14 00:00:00
206	6097 Mt. McKinley Ct.	\N	Redmond	79	98052	E6100000010C994748ED8DD84740F1B11F511B825EC0	114fdfca-275a-4b9b-a51e-6edd038644d3	2013-09-25 00:00:00
207	3066 Wallace Dr.	\N	Redmond	79	98052	E6100000010C4263FA4502D0474006124B65E3825EC0	577f79c7-3ce4-409d-baf4-043b14389780	2009-02-19 00:00:00
208	9006 Woodside Way	\N	Redmond	79	98052	E6100000010CCADDAA6755D74740AEB07AF25B885EC0	82094057-24a1-482c-adca-b44d40c1483a	2008-03-21 00:00:00
209	9906 Oak Grove Road	\N	Redmond	79	98052	E6100000010C3A0D2ACC44DF4740E7D246EC327E5EC0	8d9cf02a-a88a-4af4-ad3a-219ae0de0539	2011-01-31 00:00:00
210	2383 Pepper Drive	\N	Redmond	79	98052	E6100000010CF6CF513B9BDB4740E92F28437C8B5EC0	d5caa1d5-cb10-4cf3-91b7-0ff37611aedb	2008-12-04 00:00:00
211	6369 Ellis Street	\N	Redmond	79	98052	E6100000010C73FC16302AD947404191F8B503865EC0	d531ff9a-06e2-431f-9d2c-c13dcf82ca77	2010-11-29 00:00:00
212	8000 Crane Court	\N	Redmond	79	98052	E6100000010C5BB1E572C6D947407231CDA13B855EC0	7c1fac02-5589-4f51-9ee4-30aeee079cb7	2009-02-01 00:00:00
213	9322 Driving Drive	\N	Redmond	79	98052	E6100000010C3A0D2ACC44DF4740F1B11F511B825EC0	7a2c4361-7da9-45d8-8cef-59f730a9abca	2010-01-15 00:00:00
214	3768 Door Way	\N	Redmond	79	98052	E6100000010C4263FA4502D047403A0F01A8648F5EC0	8c938507-c67c-4e5c-963c-a93fe707980f	2007-12-13 00:00:00
215	101 Candy Rd.	\N	Redmond	79	98052	E6100000010C86A0D2D6ABD347407AB3C4AFDA7B5EC0	b27d7d52-bd02-4de4-b0e6-ac825f98b60d	2010-03-02 00:00:00
216	2427 Notre Dame Ave.	\N	Redmond	79	98052	E6100000010C470A705CE4D447407231CDA13B855EC0	0b20a74b-912a-47c2-9758-0791bfaa4daa	2010-12-28 00:00:00
217	1960 Via Catanzaro	\N	Redmond	79	98052	E6100000010C73FC16302AD94740B88F5357448C5EC0	63373680-a60f-48b8-9c38-3b4861d14229	2013-10-13 00:00:00
218	9863 Ridge Place	\N	Redmond	79	98052	E6100000010CE32B969419E1474044EED90C4D935EC0	3b6bca53-fa0f-47d6-8e7a-c2cce2a90bb2	2009-01-16 00:00:00
219	3397 Rancho View Drive	\N	Redmond	79	98052	E6100000010C60585B89A8DE4740F1B11F511B825EC0	da96e22b-ce18-4fdb-9ffe-4dc094ce0a42	2010-12-16 00:00:00
220	4909 Poco Lane	\N	Redmond	79	98052	E6100000010CC536355173D24740D5717679AB835EC0	5c0cac7c-fd6c-44ae-8c34-cc64ec495034	2008-12-07 00:00:00
221	7297 RisingView	\N	Redmond	79	98052	E6100000010C73FC16302AD94740DF504FDE93875EC0	0d34f4af-0e68-472e-b33f-4bd11ae3d91f	2008-12-09 00:00:00
222	7723 Firestone Drive	\N	Redmond	79	98052	E6100000010C60585B89A8DE4740A4D1A18D73845EC0	268ac7d8-73da-44b8-866b-0452af1f844b	2013-06-14 00:00:00
223	1275 West Street	\N	Redmond	79	98052	E6100000010CF028DC24B9D64740B88F5357448C5EC0	bc3a7f68-b60a-4a60-be8b-951fb29f646b	2009-01-26 00:00:00
224	2137 Birchwood Dr	\N	Redmond	79	98052	E6100000010CEB81660ED7D14740A62E83E4BC915EC0	7f9bc8a0-3972-490c-b888-c4b5efc9d021	2007-11-04 00:00:00
225	249 Alexander Pl.	\N	Redmond	79	98052	E6100000010C3466B4B562DA4740A4D1A18D73845EC0	6df4b0d5-634c-46f3-b1a3-ac487240a124	2014-06-23 00:00:00
226	2482 Buckingham Dr.	\N	Redmond	79	98052	E6100000010CCADDAA6755D7474053F2C8288B805EC0	1bf14f43-c05b-4841-a9ff-b42785b7bc1f	2009-02-18 00:00:00
227	8467 Clifford Court	\N	Redmond	79	98052	E6100000010CEB81660ED7D147409C4FAA7FD48D5EC0	722a9d6e-07bc-4867-94d7-3b44ece308bd	2009-02-28 00:00:00
228	9241 St George Dr.	\N	Everett	79	98201	E6100000010CEC4E58628708484068859E58578B5EC0	91ee89fc-37ec-4121-a9d5-94ec64f4b3f0	2009-01-20 00:00:00
229	3928 San Francisco	\N	Everett	79	98201	E6100000010C80E0F2F6FF024840AA1CA5EDB9945EC0	7716ef76-94aa-47e9-bddb-102bbfd59bbb	2009-01-05 00:00:00
230	475 Santa Maria	\N	Everett	79	98201	E6100000010C12A255DB53F74740965705D7DD855EC0	ca464447-6aaf-406a-bc38-846389d8aefa	2008-12-22 00:00:00
231	181 Gaining Drive	\N	Everett	79	98201	E6100000010C521D4E6DC50148401EEF0B6C408F5EC0	128d138d-3a13-4b00-81e3-5b2ce1ae782b	2008-11-24 00:00:00
232	3385 Crestview Drive	\N	Everett	79	98201	E6100000010C12A255DB53F7474078FD467C36885EC0	4a551ff0-ca85-4d1c-8fe7-318d01a49c27	2009-01-14 00:00:00
233	1185 Dallas Drive	\N	Everett	79	98201	E6100000010C521D4E6DC5014840CE75EF9F15855EC0	085e131e-5c9e-460c-bfcd-775d21b97842	2008-12-05 00:00:00
234	7883 Missing Canyon Court	\N	Everett	79	98201	E6100000010CE896045A50FF4740B3B1C33185835EC0	00cbe469-f60b-424f-9a72-e58a32be138c	2007-01-19 00:00:00
235	5452 Corte Gilberto	\N	Everett	79	98201	E6100000010C7FF8D69EEDFF474068859E58578B5EC0	1b75056d-34e4-4612-98ab-3d4ab8482495	2008-12-06 00:00:00
236	9008 Creekside Drive	\N	Everett	79	98201	E6100000010C165AA9E38A0048401EEF0B6C408F5EC0	ec244535-a4b0-46fc-b35a-42ec1f8d471e	2013-03-23 00:00:00
237	5242 Marvelle Ln.	\N	Everett	79	98201	E6100000010C138A713366FA4740110DF634788E5EC0	25318a45-fcd1-4fe6-b20c-a397c72c334e	2010-03-03 00:00:00
238	4098 Woodcrest Dr.	\N	Everett	79	98201	E6100000010C138A713366FA47404CC172EAC6895EC0	9d179a61-a9e7-4802-8099-764227043d94	2013-08-03 00:00:00
239	8624 Pepper Way	\N	Everett	79	98201	E6100000010CEA663C0A750548403C49CAC6E78C5EC0	f2a2d98b-2337-4748-9191-fe421d057df1	2009-02-26 00:00:00
240	2176 Apollo Way	\N	Everett	79	98201	E6100000010CE6AEE8013EFC47404CC172EAC6895EC0	1dccf2c8-b08d-42c1-836f-c1ee9ccfff6f	2007-12-30 00:00:00
241	1962 Cotton Ct.	\N	Everett	79	98201	E6100000010CE97E20B26202484078FD467C36885EC0	478aa4fd-3c98-4c71-88a1-7a6b4164c6fa	2008-12-02 00:00:00
242	1362 Somerset Place	\N	Everett	79	98201	E6100000010C55ED851DEA074840AA1CA5EDB9945EC0	ce971ec5-a2e1-43e2-ac74-97f5bb1d8679	2009-02-17 00:00:00
243	3238 Laguna Circle	\N	Everett	79	98201	E6100000010C0025586221F647406C8CB8CE82905EC0	0bd3bd41-0b6e-46f1-8cbf-978552ee8e77	2009-01-11 00:00:00
244	3665 Oak Creek Ct.	\N	Everett	79	98201	E6100000010CBBBB7B28280148405AA388218F8A5EC0	683ff6c4-ee9f-4a7c-b80b-c6e1a60891e4	2009-02-24 00:00:00
245	7640 First Ave.	\N	Everett	79	98201	E6100000010C649000024B0048401E5413FBBE955EC0	5fd72a8b-9d97-4309-bdf0-cd7a7bb02bb8	2008-12-11 00:00:00
246	6629 Polson Circle	\N	Everett	79	98201	E6100000010C272AE193AF064840D558797F29935EC0	4f964a2e-3ab9-4c66-9d8c-65c7c3479cf8	2009-02-15 00:00:00
247	2294 West 39th St.	\N	Everett	79	98201	E6100000010C521D4E6DC5014840F3B237DAD0905EC0	369ef5bb-af9d-4493-99b5-b9a1ac61e985	2009-02-24 00:00:00
248	1400 Gate Drive	\N	Newport Hills	79	98006	E6100000010CDCE89913F2C2474089F340CF9A885EC0	20f99909-adf9-4500-a697-1b6dfe3881e9	2009-02-01 00:00:00
249	4350 Minute Dr.	\N	Newport Hills	79	98006	E6100000010C0B5D7B65AFCC474006758A4FFC915EC0	a120e049-aeca-4a01-8f05-b36301016b7c	2009-01-07 00:00:00
250	9297 Kenston Dr.	\N	Newport Hills	79	98006	E6100000010CF4A28ABCD0C747401DB2038FC9805EC0	2ed694b4-9069-4daf-95eb-ab1c7b969a80	2008-12-05 00:00:00
251	8967 Hamilton Ave.	\N	Newport Hills	79	98006	E6100000010C36BAA8916CC84740A71478EFA38F5EC0	f2ef65aa-28b6-4b04-853d-d50f4dc62ec2	2009-01-05 00:00:00
252	9687 Shakespeare Drive	\N	Newport Hills	79	98006	E6100000010CF4A28ABCD0C74740921347EF62895EC0	8ca15be4-c0b3-4a92-aed3-b65b9b1fad92	2008-12-18 00:00:00
253	1397 Paradise Ct.	\N	Newport Hills	79	98006	E6100000010C8EE82F6456D0474050D46BAF138E5EC0	ba60c467-f3e4-4202-8b43-dbf9c81b6420	2009-01-17 00:00:00
254	3030 Blackburn Ct.	\N	Newport Hills	79	98006	E6100000010C6217D6BD29C447402A932E6F42865EC0	004f9226-e61f-4eef-bbad-8276b1be3562	2008-12-25 00:00:00
255	7469 Paradise Ct.	\N	Newport Hills	79	98006	E6100000010CDF8B21BF82C04740C671F74E397F5EC0	6d421aa1-a9fb-4799-9058-28272e6af110	2014-03-02 00:00:00
256	9605 Pheasant Circle	\N	Gold Bar	79	98251	E6100000010C321DD720AEEC47403114D243FC695EC0	a0bc68db-f094-4066-b3b7-9b65128371b9	2009-01-23 00:00:00
257	2425 Notre Dame Ave	\N	Gold Bar	79	98251	E6100000010C924596C374EB47407840D75DA5605EC0	446344a5-9afe-4597-bfee-b0e597d8f5e5	2010-01-20 00:00:00
258	8036 Summit View Dr.	\N	Gold Bar	79	98251	E6100000010C97B04E7C70E047406D590220DE5F5EC0	55ac181f-dbbc-49b1-bbdc-26bf67c13b69	2008-12-07 00:00:00
259	213 Stonewood Drive	\N	Gold Bar	79	98251	E6100000010C642A745A65E8474090A48366885D5EC0	8faee71d-bb98-46d2-a47a-112b30513e21	2009-02-18 00:00:00
260	3884 Beauty Street	# 14	Gold Bar	79	98251	E6100000010C93BED3ABC8E747401AB0253B196D5EC0	9f9d6796-675a-4619-8f37-eda885db931e	2009-02-04 00:00:00
261	1748 Bird Drive	\N	Index	79	98256	E6100000010CF71DAED9B8E7474048952922746A5EC0	fdd3e025-386a-4124-9002-d53d8984f261	2010-02-28 00:00:00
262	310 Winter Lane	\N	Index	79	98256	E6100000010C266161F08EE9474094FEF9BE56595EC0	e619e04d-544e-4675-8ddb-db282bb01238	2008-12-30 00:00:00
263	3514 Sunshine	\N	Index	79	98256	E6100000010C7315D047D3E247408B057E8457675EC0	09051ab3-eb32-4551-981d-29f7b311587d	2010-02-09 00:00:00
264	1245 Clay Road	\N	Index	79	98256	E6100000010CF71DAED9B8E74740C1ECAA0E1F6F5EC0	ab87f9e7-412b-486c-863f-3a237f1adff9	2009-03-01 00:00:00
265	3127 El Camino Drive	\N	Index	79	98256	E6100000010C7A268C6B9EEC474048952922746A5EC0	2a9be420-6d00-4ce8-bbe4-00a73b78a587	2009-02-02 00:00:00
266	7691 Benedict Ct.	# 141	Issaquah	79	98027	E6100000010C690ED8A0C9BD4740DEB397C07F865EC0	980f8c50-ddc1-414c-9230-4f0ceca16db3	2009-01-30 00:00:00
267	1144 Paradise Ct.	\N	Issaquah	79	98027	E6100000010CD502374A92BC4740C397EF6C597C5EC0	e315154c-70d1-44ef-b123-0a85c6be3246	2009-01-10 00:00:00
268	7435 Ricardo	\N	Issaquah	79	98027	E6100000010C9D251A4E38C047407BC58AE1B7855EC0	8c29a5e8-62d1-4437-8df5-eb221442164c	2009-01-28 00:00:00
269	9530 Vine Lane	\N	Issaquah	79	98027	E6100000010C10B70B500BC24740D3D67D02F0845EC0	c8156f7e-005e-42f4-b4b8-bc0ab784e9bf	2009-02-16 00:00:00
270	6580 Poor Ridge Court	\N	Issaquah	79	98027	E6100000010C690ED8A0C9BD47404AEFAE1172785EC0	7ab40626-3d83-4073-a8fc-e82d788ec400	2008-11-27 00:00:00
271	5979 El Pueblo	\N	Issaquah	79	98027	E6100000010CA3C2ACA642C347404AEFAE1172785EC0	f1fa084f-ae3e-41b9-af15-c5eba80e8325	2008-12-16 00:00:00
272	1921 Ranch Road	\N	Issaquah	79	98027	E6100000010CD502374A92BC4740DEB397C07F865EC0	c87b38f6-a249-4c3b-a507-1306bde99b1d	2009-01-04 00:00:00
273	3848 East 39th Street	\N	Issaquah	79	98027	E6100000010C34F795F35ABB47404C7FBE5DD7885EC0	e7cbe0c1-996e-47fe-8a48-e6b003d1e5f7	2009-01-27 00:00:00
274	5256 Chickpea Ct.	\N	Issaquah	79	98027	E6100000010CFFDF5346ECB847407BC58AE1B7855EC0	ca7ee010-ddf2-47cb-8abd-bb56b956e79a	2009-02-09 00:00:00
275	989 Crown Ct	\N	Issaquah	79	98027	E6100000010C3994284C65BE4740650B576598825EC0	8a882a09-430e-4d6d-878c-ec281147ebe4	2009-02-27 00:00:00
276	3333 Madhatter Circle	\N	Issaquah	79	98027	E6100000010C6EAB6AF9D3C04740BA4AE5FA2E8B5EC0	4d1b4626-e935-49dd-8a9c-a73a8d06101a	2008-12-09 00:00:00
277	342 San Simeon	\N	Issaquah	79	98027	E6100000010C2E5A039B50B84740F73F30C840805EC0	a1a8f159-2953-4a4e-896d-c0511fe0bb01	2008-12-28 00:00:00
278	9314 Icicle Way	\N	Issaquah	79	98027	E6100000010C6EAB6AF9D3C047404C7FBE5DD7885EC0	cc95a37b-31a6-4c3e-9e84-c806e16b10ab	2009-01-15 00:00:00
279	7772 Golden Meadow	\N	Issaquah	79	98027	E6100000010C3F31BBA46FC147406E5861D7C2735EC0	3a217c61-aa3c-4d7f-8ccb-0d9ac4dd2691	2011-02-08 00:00:00
280	8585 Los Gatos Ct.	\N	Issaquah	79	98027	E6100000010CA95F3FFF4CC64740AF6DCB3C9F895EC0	3d6bdbc8-b41e-4456-a5ae-bc2e1adff557	2009-01-08 00:00:00
281	7985 Center Street	\N	Renton	79	98055	E6100000010C2D4F32F5A3B6474090A2BD57D5855EC0	3e779d84-0a84-4ba3-b62e-b3de594481a3	2008-12-21 00:00:00
282	5980 Icicle Circle	Unit H	Renton	79	98055	E6100000010CA21BC37408B6474090A2BD57D5855EC0	f32eb450-1220-461a-9cc5-3366ed213517	2010-01-16 00:00:00
283	1378 String Dr	\N	Renton	79	98055	E6100000010C9E89517E65C347407FD0C18E90915EC0	0f36c3ca-e736-4bce-ba20-9f0aff19e850	2010-01-20 00:00:00
284	9495 Limewood Place	\N	Renton	79	98055	E6100000010C151F1B791BBC4740AF81F2A0868A5EC0	e9f9e451-8e14-4403-a628-bd05a6fe11cd	2009-02-21 00:00:00
285	2598 Breck Court	\N	Renton	79	98055	E6100000010C1356E2FDC9C24740B4C79B8E9D865EC0	5c9aa419-ad00-4031-974d-077f13101ab3	2009-11-25 00:00:00
286	5670 Bel Air Dr.	\N	Renton	79	98055	E6100000010CFF8075F335B447401FED79C565875EC0	74e8bf7f-4d0e-43ab-8937-81944dd8bd4e	2013-12-16 00:00:00
287	7165 Brock Lane	\N	Renton	79	98055	E6100000010CD0E97F7676B847406C7DDF200D855EC0	e6873ef7-439c-4285-a911-85c9dff752b4	2011-01-11 00:00:00
288	2736 Scramble Rd	\N	Renton	79	98055	E6100000010CFF8075F335B44740A93B49B36F8E5EC0	736df003-f793-4ae5-ba30-dc75c59aa51b	2008-11-30 00:00:00
289	2266 Greenwood Circle	\N	Renton	79	98055	E6100000010C5B1DEFF611B947403786052100905EC0	e26fac51-2b7a-4d66-926b-419622c3ce0d	2010-02-26 00:00:00
290	5297 Algiers Drive	\N	Renton	79	98055	E6100000010C5954B67BC0BF4740485801EA44845EC0	8d5152a1-c841-4b1a-8b1e-5df6968ce4a3	2014-05-27 00:00:00
291	9533 Working Drive	\N	Renton	79	98055	E6100000010CA21BC37408B647403DCCAE0E178C5EC0	68cf4292-6615-498d-ab04-cab6bdf279b3	2009-12-14 00:00:00
292	1803 Olive Hill	\N	Renton	79	98055	E6100000010CCE2047FB24BF47401FED79C565875EC0	32be31c0-1174-4353-abdf-eed36445bc9d	2009-01-26 00:00:00
293	7559 Worth Ct.	\N	Renton	79	98055	E6100000010C8722737D2EC247403786052100905EC0	f9e3e4d2-d3b9-465a-b91a-9656ed0f98ab	2008-01-24 00:00:00
294	3770 Viewpoint Ct	\N	Renton	79	98055	E6100000010CB7B968FAEDBD474085166B7CA78D5EC0	03a588db-f934-434b-ba4d-f8a525e41eb3	2013-08-04 00:00:00
295	6510 Hacienda Drive	\N	Renton	79	98055	E6100000010CE81997F2FEB247403786052100905EC0	50c82d57-9603-4520-a57f-b4a15ea3c7b4	2010-12-23 00:00:00
296	6937 E. 42nd Street	\N	Renton	79	98055	E6100000010C5B1DEFF611B94740B4C79B8E9D865EC0	a3f0fae3-cc62-4bd2-94af-772932e73a26	2009-01-24 00:00:00
297	7943 Walnut Ave	\N	Renton	79	98055	E6100000010C2D4F32F5A3B647409EAFF6D741965EC0	52410da4-2778-4b1d-a599-95746625ce6d	2012-06-30 00:00:00
298	2176 Brown Street	\N	Renton	79	98055	E6100000010C151F1B791BBC47405BABE357C8905EC0	d3eeda71-936e-4bcb-8bc6-0039c6bba849	2009-02-19 00:00:00
299	4312 Cambridge Drive	\N	Renton	79	98055	E6100000010C5954B67BC0BF474061F18C45DF8C5EC0	3aa8ed20-e86f-48c6-b033-e3b8e32d2eb3	2009-01-13 00:00:00
300	5009 Orange Street	\N	Renton	79	98055	E6100000010C89EBABF87FBB47403DCCAE0E178C5EC0	85710ccd-79e2-4667-a36a-6c808bc59a18	2012-04-09 00:00:00
301	4405 Balboa Court	\N	Santa Cruz	9	95062	E6100000010C89A6C1C2EB774240D6E1783227765EC0	4334bcda-3f16-4576-ad9a-8a01871518f5	2011-04-25 00:00:00
302	7995 Edwards Ave.	\N	Lynnwood	79	98036	E6100000010CBA1C396470E747400510C64A58945EC0	98486715-ff2e-4e76-9ac7-dff3fca41691	2011-04-25 00:00:00
303	4659 Montoya	\N	Altadena	9	91001	E6100000010C8A5296E6A7144140768CB5A9CB7F5DC0	293da436-24c4-49a2-892e-de18df7612df	2011-04-25 00:00:00
304	1667 Warren Street	\N	West Covina	9	91791	E6100000010CFD9DD78953084140E8BB2AE8B2805DC0	ce39ee50-e632-4996-9b7f-314fc82e7c05	2011-04-25 00:00:00
305	7179 Montana	\N	Torrance	9	90505	E6100000010C2AA09145C8ED4040A03BF4F56A905DC0	36c666a9-afef-42be-a4ee-ef8002677f1f	2011-05-09 00:00:00
306	9 Guadalupe Dr.	\N	Burbank	9	91502	E6100000010CBAEFFDB54514414027ACC38FE89C5DC0	01ce5956-15fd-4243-896e-9c61637dd27c	2011-05-09 00:00:00
307	50 Big Canyon Road	\N	Lebanon	58	97355	E6100000010C1DDE9479E73D4640B97142B4ABBB5EC0	54a28138-aadc-46b3-b866-1c3a0d0a6147	2011-05-09 00:00:00
308	65 Park Glen Court	\N	Port Orchard	79	98366	E6100000010C32F7239868BA47407B60B66C5FA45EC0	2fe2d15c-af6f-4c42-ab8d-b718eabcc889	2011-05-09 00:00:00
309	28 San Marino Ct.	\N	Bellingham	79	98225	E6100000010C4FE3B459955348409F41C938948B5EC0	a9cbe446-82ed-476b-8991-027c7167f9c6	2011-12-23 00:00:00
310	2472 Alexander Place	\N	West Covina	23	83301	E6100000010C97959C7BED2945400F59C19EB9A15CC0	482a0800-62f7-4f19-966d-db43140ca308	2011-12-23 00:00:00
311	9830 May Way	\N	Mill Valley	40	59715	E6100000010C4C080DF888DB4640932FA6938DBB5BC0	26f279a4-0f7c-446d-8488-8f14b8bcd1b2	2011-12-23 00:00:00
312	1286 Cincerto Circle	\N	Lake Oswego	58	97034	E6100000010CD5B2949DABB146403FF5A7610BAA5EC0	87b54fff-aae5-4a50-9b05-7d51a8916c5a	2011-12-23 00:00:00
313	2141 Delaware Ct.	\N	Downey	72	37501	E6100000010CBF2D9C1A888B41400ABC8796C27856C0	87cd888d-4b41-42d2-b172-1f0e51ee9428	2011-12-23 00:00:00
314	218 Fall Creek Road	\N	West Covina	9	91791	E6100000010C7259AB6A25064140426FC3AF78845DC0	a0e6b964-00f2-4086-83d4-42c6f06d0fa4	2011-12-23 00:00:00
315	5807 Churchill Dr.	\N	Corvallis	58	97330	E6100000010C3289A4956A4B46406F87C3418FD15EC0	9de9e224-f974-4319-880b-d2ea6a99be28	2011-12-23 00:00:00
316	6061 St. Paul Way	\N	Everett	40	98201	E6100000010C521D4E6DC50148405AA388218F8A5EC0	297d0f3e-701d-44e1-b524-df07a9fc4470	2011-12-23 00:00:00
317	628 Muir Road	\N	Los Angeles	9	90012	E6100000010C5731EBED610B41402FB0C0E5CE835DC0	cde833ab-2f67-44ad-9808-a746cb857147	2011-12-24 00:00:00
318	2313 B Southampton Rd	\N	Missoula	40	59801	E6100000010CC69BDAE232654740C25736DB767E5CC0	04cb8657-ab4a-4ae3-966a-e69d0eee743e	2011-12-24 00:00:00
319	137 Lancelot Dr	\N	Phoenix	6	85004	E6100000010C3CA2F7C398BB4040B971466EB8FC5BC0	cead54d8-d6b8-4261-8ca1-9cc3599903d1	2012-01-25 00:00:00
320	3 Gehringer Drive	\N	Daly City	9	94015	E6100000010CF565E78A3DD14240D29AA7B63EA55EC0	d792d26a-df82-4ef1-acea-3811b1f0396c	2011-12-24 00:00:00
321	15 Pear Dr.	\N	Newport Beach	9	92625	E6100000010C3CB3C3168ED240400C200EA392805DC0	6cb92106-0de3-404c-80b4-f612942e27e4	2011-12-24 00:00:00
322	1 Mt. Dell Drive	\N	Portland	58	97205	E6100000010C26E942721AC24640FF9126E528B65EC0	50f4b496-0610-48bd-b905-2874f13f0b4e	2011-12-24 00:00:00
323	7651 Smiling Tree Court	Space 55	Los Angeles	9	90012	E6100000010C28507CA8820A4140A899F25E9E8A5DC0	2ddf992e-b883-4476-956a-ef44ae9f020c	2011-12-24 00:00:00
324	50 Via Del Sol	\N	Lynnwood	79	98036	E6100000010C6D8B22A02BEE474010B051BF2B9C5EC0	89e1d63e-3921-48cc-a913-5fe25083e72e	2011-12-24 00:00:00
325	9491 Toyon Dr	\N	Dallas	73	75201	E6100000010C4346160AA26440406340F0E64F3B58C0	567e6863-fcff-47a8-9913-ef8bf3e38932	2011-12-24 00:00:00
326	4151 Olivera	\N	Atlanta	17	30308	E6100000010CA3F12B5896DC40400375815DBB1255C0	7bd71eeb-6e0e-4402-8bdc-44b8f47aa4c3	2011-12-24 00:00:00
327	3 Chablis Court	\N	Torrance	9	90505	E6100000010C16008FEF7BEC40401E920CDE2C915DC0	ef4b0ef8-0e38-42cc-9151-9918a5274248	2011-12-24 00:00:00
328	2 Lion Circle	\N	Long Beach	9	90802	E6100000010C1E7E67A9DEDF40407A34BFDD9E8D5DC0	06de5166-e8c4-43ae-87f0-78144da01790	2011-12-24 00:00:00
329	9056 Mount Dr	\N	Chicago	24	60610	E6100000010C221C780A43F84440D28F571981E155C0	3d0fd607-f63a-4964-b0bb-c9e9f8e29433	2011-12-24 00:00:00
330	67 Monetary Way	\N	Berkeley	9	94704	E6100000010C17B91D9518F74240F2453631FF8E5EC0	33439525-0987-4b44-a1df-66efb071324a	2012-01-17 00:00:00
331	419 River Ash Court	#9	Lakewood	37	63301	E6100000010CDE666930FE6D4340AA627CC6E49656C0	69783e0b-5d79-41c6-af1a-9a7f750a1779	2012-01-17 00:00:00
332	4823 Stonewood Ct.	\N	Walla Walla	79	99362	E6100000010C779F49D4B30A47407B858DECE5995DC0	2fc63299-7b60-4ac5-aba2-b12ebd0f7d2f	2011-12-24 00:00:00
333	50 Edward Ave	\N	Concord	9	94519	E6100000010CB2C5E85603F84240AB61676BDE8D5EC0	ebe095f2-e14f-429d-829c-922e807b6d65	2012-01-17 00:00:00
334	8157 Tweed Lane	\N	Anacortes	79	98221	E6100000010CE954EE4EB7334840E249FA0415AE5EC0	2b1a42e2-4899-491f-a4e2-c2d7c29cdf1a	2012-02-02 00:00:00
335	8547 Catherine Way	\N	Tacoma	79	98403	E6100000010CD42E8E445DA047406E8B8154BA975EC0	466ba133-7750-48bb-a806-84883dfce525	2012-01-17 00:00:00
336	8892 Columbia River Ct.	\N	Santa Cruz	9	95062	E6100000010C88D929FB8D75424062B5C46454875EC0	fb50f09a-6c79-4d3a-abaf-f9d2cce2abb0	2012-01-25 00:00:00
337	2909 Toyon Dr.	\N	Burlingame	9	94010	E6100000010C30B217DF8CC84240A0A0F3236C985EC0	c25205ca-9625-4ffc-9d68-23e7c652c57d	2012-01-25 00:00:00
338	8127 Otter Dr.	\N	Boise	23	83702	E6100000010CE96A874C3ED845409BD6A2D4D1095DC0	a0f2c6be-9b9a-4a02-aab9-e379b37bf2f2	2012-01-25 00:00:00
339	7053 Laurel Dr.	\N	La Mesa	48	88044	E6100000010CD7E34768F40040405CF7A4A782C45AC0	3b9911d6-2fd0-4cc6-afc1-a44bccd86139	2012-01-25 00:00:00
340	8629 Pepper Place	\N	Bellevue	79	98004	E6100000010CA7D71BFB40D44740E6714174CA985EC0	a39725ec-1d66-4b02-bf8f-a210e1d4f1af	2012-02-03 00:00:00
341	8981 Carmel Drive	\N	W. Linn	52	89701	E6100000010C1A82D861D596434053BA708267F15DC0	2346e75d-6548-472a-abb9-52b55bcd94c6	2011-12-24 00:00:00
342	8513 Hurlstone Ct.	\N	Altadena	9	91001	E6100000010C1CF5B998781941402661407493835DC0	2a98d19f-fb9f-4466-a568-fd3e69cf3563	2012-01-25 00:00:00
343	50 Breck Court	\N	Bremerton	79	98312	E6100000010C021466F601CF4740D320C07AC8BC5EC0	6dd859ca-0773-4516-83a7-c5cd53cea966	2011-05-09 00:00:00
344	2342 Peachwillow	\N	Denver	10	80203	E6100000010C3C5DB4F6FADF43403D0189E1F0465AC0	8acc30fd-e803-4e11-8a6f-3c344959a181	2012-01-29 00:00:00
345	6441 Co Road	\N	Lemon Grove	6	85252	E6100000010CD42F158283BA40402EBA15288B045CC0	cc525920-52fa-48de-995c-7194acd4c5af	2012-01-25 00:00:00
346	2596 Big Canyon Road	\N	New York	54	10007	E6100000010C4BF44966C1554440A3FD3323498652C0	2d51a47b-7dbb-4eef-95ab-62fb5fea34b8	2011-12-24 00:00:00
347	87 Pheasant Circle	\N	Oakland	9	94611	E6100000010C49FA775732E242401A17AF75CF8C5EC0	55cc0858-881f-4d76-bd63-668abdba6608	2012-01-25 00:00:00
348	3664 Colt Ct.	\N	Richmond	9	94801	E6100000010C37FF899595F64240033919BE9A8C5EC0	f734e7ce-67e6-4f40-94e0-92383ac4101a	2012-01-25 00:00:00
349	3294 Buena Vista	\N	Lemon Grove	6	85284	E6100000010C480254FB29A640400E9CFA5741015CC0	0d5e88bc-5fec-4e1b-ac81-f13d2ca01bc0	2012-02-03 00:00:00
350	6959 Lakewood Court	\N	Daly City	9	94015	E6100000010CF565E78A3DD14240215C2B429F9C5EC0	fc9d212f-2dc8-446d-8703-7ec202157520	2012-01-25 00:00:00
351	1192 Parkway Drive	\N	Mill Valley	44	68601	E6100000010CC7C6B4EBA6B344408CD5DA00AC5F58C0	4c30d787-50b7-489d-b920-76151d46c391	2011-12-23 00:00:00
352	3195 RiverRock Dr.	\N	Burlingame	9	94010	E6100000010C41D360EB00D042407F4088B1D0A35EC0	aa8237a8-8f37-462d-b3cc-8116d7d56bd8	2012-02-03 00:00:00
353	9620 Laurel Drive	\N	Novato	82	82070	E6100000010C4F4FE3CB52934440B1CB612220765AC0	59d8a2e0-f483-49aa-9f6f-2e4fe40fcef2	2012-02-02 00:00:00
354	5 Madrid	\N	Concord	9	94519	E6100000010CCC7D0EF73CFA4240D5FDF2C454815EC0	c13f0ab3-2847-4718-9ddd-0b1d73228c33	2012-01-25 00:00:00
355	102 Silverado Drive	\N	W. Linn	58	97068	E6100000010C84B93D74B5B44640F137FA7399A85EC0	feadc5bb-e316-41fb-8705-0a6357690dce	2012-01-25 00:00:00
356	75 Q St.	\N	Chula Vista	9	91910	E6100000010C9C1B78BD604E4040F0409A3A9E425DC0	2f0e5c9e-59da-49fb-913b-bd070e57d09c	2012-01-17 00:00:00
357	683 Larch Ct.	\N	Salt Lake City	74	84101	E6100000010C9683D5A842594440C7485C1A92F95BC0	b870f6ac-d9a3-4909-a176-7b934a1785d9	2012-01-25 00:00:00
358	20 Rambling Rose Ave.	# 103	West Covina	9	91791	E6100000010C8B6DA9AB8703414010C1EC5FF6825DC0	d30222df-3d9f-42f6-87b5-68d75e15a305	2012-01-25 00:00:00
359	6119 11th	\N	Salt Lake City	74	84101	E6100000010C57C53E3D5B69444079778B9822FF5BC0	e16ab1f6-c0c6-40ea-884f-c80c09bb2ec9	2012-01-25 00:00:00
360	8844 Garcia	\N	West Covina	9	91791	E6100000010C23B2D5CAB505414098B1A6F82B7C5DC0	f0c54ebe-b640-4064-adf8-ecd7e4d0b9f4	2011-12-24 00:00:00
361	32 East 87th Street	\N	Long Beach	9	90802	E6100000010C8A9C51B292DE40404DE88F9B84815DC0	41c0b5ec-a29d-49e2-ba42-2ee8f4aede1d	2012-01-25 00:00:00
362	31 Bridgeview St	\N	Glendale	9	91203	E6100000010C96F423A29E0F4140CA76E0C2A5855DC0	6e1a11ae-b2a5-4017-9b82-cc1f5ce91f3d	2011-12-24 00:00:00
363	1874 Valley Blvd.	\N	Palo Alto	9	94303	E6100000010CE947BE6EACB14240F146990419905EC0	4c98650b-3a0a-4ce1-98ed-34e1d4344ccf	2012-01-25 00:00:00
364	3253 La Jolla	\N	Salem	58	97301	E6100000010CD8387F525B774640CFB7FF07D4BD5EC0	6cdc666c-db33-4034-a6a2-d0950fb2fe20	2012-01-29 00:00:00
365	6030 Winter Drive	# 4d	Imperial Beach	9	91932	E6100000010C9F0822C32B4D40402B2D2EFED3495DC0	bd7e7be7-2b74-493a-aef3-1809d72248b0	2012-01-29 00:00:00
366	1619 Mills Dr.	\N	Albany	58	97321	E6100000010C128B69C2B55B4640910864B2FAC35EC0	a61b581d-a6db-4c28-a5a2-fa3fe369bae3	2012-01-29 00:00:00
367	978 Mozden Lane	\N	San Francisco	9	94109	E6100000010C484B03267BEC4240116668900F9E5EC0	f1409c59-da83-4782-ab5a-fa0e9d2bbb84	2012-02-02 00:00:00
368	298 Sunnybrook Drive	\N	Spring Valley	9	91977	E6100000010C8A8A62DD745740404434FF9944465DC0	a21b4793-2492-4085-b175-a89af72d4c10	2011-12-23 00:00:00
369	9151 Napa C.	\N	Lebanon	58	97355	E6100000010C69478162793E46406946D2D206B35EC0	614136ba-2603-4c57-bb48-a3e36d73bb77	2012-01-29 00:00:00
370	24 Bohon Circle	\N	Burlingame	9	94010	E6100000010C5704D728CAC84240323FA82B3C905EC0	b16feddf-75c3-4594-b801-265e55794f9b	2012-01-25 00:00:00
371	7 B Way	\N	Woodburn	58	97071	E6100000010CBBA4E17D0F9546408ED209FB67B25EC0	ae253684-0d47-418b-b938-859581d7ad34	2012-02-03 00:00:00
372	7 Mayda Way	\N	Bremerton	79	98312	E6100000010C7490D115CACD4740F4E9BC8E48AC5EC0	30fbe769-8d17-4fe5-a2ef-db848aec20b2	2012-02-03 00:00:00
373	60 Oakgrove Rd.	\N	Lebanon	58	97355	E6100000010CF5170DAC4D4946402BBA9DC598A95EC0	8c16444f-ba42-4994-800b-149269d6202f	2012-01-29 00:00:00
374	594 Tossing Way	\N	Detroit	35	48226	E6100000010CFDE4E28962284540688C799835BC54C0	148aa0e0-9a1a-4610-9ff4-86a6fc2f1963	2012-02-02 00:00:00
375	7562 Daylight Place	\N	Everett	79	98201	E6100000010CBBBB7B28280148405AA388218F8A5EC0	b8b5241c-3ddb-4bb3-b114-e99e8f4ec35c	2012-02-02 00:00:00
376	9098 Story Lane	\N	Albany	54	12210	E6100000010C525A3CE36852454094FAB5CD486952C0	4dda7288-7870-4369-a67b-18cc99deebdf	2012-02-02 00:00:00
377	8 Rogers Ave.	\N	Everett	79	98201	E6100000010CEA663C0A75054840965705D7DD855EC0	f5521355-41a3-4660-91cf-20028a1d6de7	2012-02-02 00:00:00
378	90 Trujillo	\N	Sedro Woolley	79	98284	E6100000010C3331C4E4BF4448406B22302DC9855EC0	a94b63e4-390d-46a6-86ac-26ba8713f4b9	2012-02-02 00:00:00
379	68 Filling Ave.	\N	Beaverton	58	97005	E6100000010C53174EFEDEBA464027BCC78F8EA75EC0	ad8083bc-139f-46a1-b1d4-fc8e5cc9ba16	2012-02-02 00:00:00
380	3427 C Del Rio Ln	\N	Anacortes	79	98221	E6100000010C8502A8A1A43D48401903248028AA5EC0	41c17e5a-9456-4023-aefc-9679d5f7d05d	2012-02-02 00:00:00
381	7682 Fern Leaf Lane	\N	Boston	30	02113	E6100000010CD03D1B157D2B454023759882FFBE51C0	de9ce982-c43c-45f6-b656-e220192bd36e	2012-02-02 00:00:00
382	6360 Sand Pointe Lane	\N	Coronado	9	92118	E6100000010C2E7700E23F5C4040C0CDD24F2C465DC0	fe0dd957-0bd5-4bf5-a845-782848eb2e7a	2012-02-02 00:00:00
383	20 Smiling Tree Court	\N	Burbank	9	91502	E6100000010C147490AC651A414027ACC38FE89C5DC0	63825336-d51e-44ae-af3e-c12fc653a639	2012-02-02 00:00:00
384	35 Buckthorn Court	# 1	Kirkland	79	98033	E6100000010CC24197288ED04740D89F0AC1928D5EC0	99a6bde2-5600-4ebf-abc0-5ef42b97183b	2012-02-02 00:00:00
385	207 Concerto Circle	\N	Salem	58	97301	E6100000010C3D4BB649DE7246403C75E5DFEAC05EC0	44184abf-c2a1-434e-b995-1cf6be436c11	2012-02-02 00:00:00
386	5514 Grant Street	\N	Ballard	79	98107	E6100000010C042A946ECAD94740E5D29C5B1BA15EC0	0ae2a97e-05f4-4994-bae9-3ddce653031d	2012-02-02 00:00:00
387	50 Kim Court	\N	Coronado	9	92118	E6100000010CEE1F036DCF564040D712F55E2C435DC0	864c858d-0d9e-48a8-9381-180a223d2b7f	2012-02-02 00:00:00
388	2834 Clifford Court	#9	Anacortes	79	98221	E6100000010CCDCC50F7663C4840742EA1F1629E5EC0	858a588d-f483-460d-93d7-a4a45edb71ef	2012-02-02 00:00:00
389	80 Edward Ave	\N	Burien	79	98168	E6100000010CB4492FE5DAB64740B172F68DAB8C5EC0	9c3e154a-708e-4c92-99a6-54fb957b7a87	2012-02-02 00:00:00
390	8671 Westwood Lane	\N	Palo Alto	9	94303	E6100000010CB25EC1D3A1B242407F344AB6CF825EC0	f4af9bc9-5d65-4dc3-9e7e-23bcc95c87a8	2012-02-02 00:00:00
391	2014 Delta Road	\N	Burien	79	98168	E6100000010C82611C8E6CB4474024996434C29A5EC0	f0f71f1c-8a08-42b4-a879-daa711e63ccd	2012-01-25 00:00:00
392	87 S. Rising Ave	\N	Lynnwood	79	98036	E6100000010CD38F3E2FDFDE4740AC693A70BC9D5EC0	62225abf-4897-4f10-b761-a9ae90732231	2012-02-03 00:00:00
393	9443 Oaxaca	\N	Lakewood	9	90712	E6100000010C9220F9F014E640405AD9DE779B885DC0	212c5d85-931f-4267-b3d3-79dc26a96c6b	2012-02-03 00:00:00
394	581 Roundtree Place	\N	Spokane	79	99202	E6100000010C4AE9DA19B6D6474042E552FDC45C5DC0	2a6b4ac5-dedc-45ba-8f2f-e430199d2b20	2012-02-03 00:00:00
395	3681 South St.	\N	St. Louis	37	63103	E6100000010C241BF097E0474340B55CA2F5BC9C56C0	a8a47b69-90a2-4568-95fe-02d7ea5eb538	2012-02-03 00:00:00
396	6 Dancing Road	\N	Burien	79	98168	E6100000010C82611C8E6CB447406B2E9982EE925EC0	cc2ec849-7fd9-43d7-8b84-60e579629fed	2012-02-03 00:00:00
397	90 Sunny Ave	\N	Berkeley	9	94704	E6100000010CFF92400A78F14240D6C57387B48A5EC0	fa070bc0-3313-4500-ac3e-f8ce67cf85cb	2012-02-03 00:00:00
398	81 Ana Mile	\N	Spokane	79	99202	E6100000010CC784A499E1D4474017C48BF7BF505DC0	2cc7156b-264a-4b32-85c8-ca570f18b92f	2012-02-18 00:00:00
399	3459 Tri-state Ave	\N	Issaquah	79	98027	E6100000010C690ED8A0C9BD4740945123E9787F5EC0	8d4bed91-23cb-436e-85e8-f7b5b63a6cf4	2012-02-18 00:00:00
400	40 Panorama Drive	\N	Glendale	9	91203	E6100000010CE3AD4EC0FD1341409AD306C15A9C5DC0	32f3d65c-6d79-4021-8196-10cedd35d6d0	2012-02-18 00:00:00
401	8197 Hermosa	\N	Salem	58	97301	E6100000010CC91FBB0AC5804640E9876B6CB6B85EC0	8e79ad83-799b-4434-b970-b7bf603bee1a	2012-02-18 00:00:00
402	7786 Olive St	\N	Olympia	79	98501	E6100000010C7DA1CB9A4980474005C50D1A68C15EC0	3c59b1a3-4e8a-40dc-80d2-376373c8f44f	2012-02-18 00:00:00
403	8040 Erie Dr	6 Monteira	Houston	73	77003	E6100000010CFECE4B0DC1B23D408FE4BC9B20CE57C0	213a7a5b-3782-4e40-991b-325a2b93f770	2012-02-18 00:00:00
404	7824 Frame Ln	\N	Philadelphia	59	19107	E6100000010C5904F7409D00444002D849DBBEC852C0	03536a19-8127-41bb-bd8b-3dddced5e87d	2012-02-18 00:00:00
405	25 Epping Road	\N	Lavender Bay	50	2060	E6100000010C16105219BFF140C0811CAC8C2BE16240	4fb2169a-840f-4f81-9b47-507479ce3199	2013-07-31 00:00:00
406	Ctrcrt Bus Pk/995-27 Paul St N	\N	Lavender Bay	50	2060	E6100000010C25C928E63FEB40C00BCE20AFAFE06240	0bd58a41-eaef-42ca-a464-d360ebfd7c7e	2013-07-31 00:00:00
407	2-252 Beauchamp Road	Botany Bay Industrial Estate	Cloverdale	66	6105	E6100000010CC3D1BC676CFF3FC060201EF76EF55C40	313665ab-b448-4814-a474-2f317094b969	2013-07-31 00:00:00
408	65 Epping Rd	\N	Lavender Bay	50	2060	E6100000010CDE996219EBE640C0DEC933EFF9E66240	f7aeb695-0083-4d06-89f2-e933fe3d070b	2013-07-31 00:00:00
409	99 - 6 Orion Road	\N	Lane Cove	50	1597	E6100000010C5A0F164CF9E640C07983192EB8EA6240	606f80fe-47ad-4d89-bfb4-ecb7be9546bf	2013-06-30 00:00:00
410	2565-175 Mitchell Road	\N	Alexandria	50	2015	E6100000010C24559C4BD2EC40C0AF79D20108ED6240	1154ed96-cf5c-4ca1-b2c2-f3bbe9ef0bd7	2013-07-31 00:00:00
411	Chabbell Park	\N	North Ryde	50	2113	E6100000010C4637F3B7C3E940C02B1DA0E7BAE46240	afd85414-9131-49ca-8ba8-a49a37dcf59b	2013-05-30 00:00:00
412	2520b Underwood Street	\N	Lavender Bay	50	2060	E6100000010CE68646942FE540C093417B9B8EE46240	cbaed57b-5240-4b61-8a01-84524b66be31	2013-06-30 00:00:00
413	65 Epping Road	\N	North Ryde	50	2113	E6100000010CE4FE573754DF40C075507AD3BFDE6240	4315440c-1b9a-48b8-a3c3-722a37a7948b	2013-06-30 00:00:00
414	5525 Glenferrie Road	\N	Hawthorne	64	4171	E6100000010C755F5E32E16B3BC073B1A25E211F6340	216c83a8-b942-4458-805c-dae1d90c2533	2013-05-30 00:00:00
415	2253 Miller Street	\N	North Sydney	50	2055	E6100000010C99A5D05A93EF40C04EC400FE0BE96240	c9ea299c-b1e9-4602-a4ba-a73943e8514d	2013-07-31 00:00:00
416	Level 100	77 Southbank Boulevard	South Melbourne	77	3205	E6100000010CDF4977A446E542C07E69107C151A6240	a3fa418e-bf34-47a7-9078-ceac938192fc	2013-06-30 00:00:00
417	Rosebery	\N	Lavender Bay	50	2060	E6100000010CE6CD6FC7AEEB40C0967F95D133E06240	e60dddf7-8d7f-4adf-bf0e-c1d0fe544768	2013-05-30 00:00:00
418	Licensing Account	\N	Seaford	77	3198	E6100000010CFF17C89C991143C069250EDF0F246240	37dc36ca-8da2-4023-95ba-753c565074be	2013-07-31 00:00:00
419	Level 99	12 South 10th Avenue	Melbourne	77	3000	E6100000010CEA53B44A28E442C01D2C417F4A1F6240	cb4eccce-4a3a-4160-a6a2-365b09efc624	2013-07-31 00:00:00
420	Ctrcrt Bus Pk/995-27 Paul St N	\N	North Ryde	50	2113	E6100000010C1FAF2256DFE540C02825869988EA6240	0e10be22-8472-4c7c-9fd1-67ed3ae02966	2013-07-31 00:00:00
421	2501 Miller Street	\N	North Sydney	50	2055	E6100000010CB1DA77FF0BE640C03B75B877FBEA6240	8e088d36-2fc4-4e44-a728-57cac5040fdc	2013-07-31 00:00:00
422	6 Lord Street	\N	Matraville	50	2036	E6100000010C7724F09F1D0041C07CAEF1C7E9EC6240	a90a98a7-f86d-46dc-a89c-e2961966c211	2013-06-30 00:00:00
423	Level 6	538 Climbing Street	Matraville	50	2036	E6100000010C7F109E98C4FB40C03735A84523E66240	eeb124ca-c5fc-480d-b8e4-51e3a454278b	2013-06-30 00:00:00
424	P.O. Box 990032	\N	Findon	66	5023	E6100000010C7BA64EA8226D41C059306DD0484C6140	db947d96-044d-4a41-8b75-c574107670c9	2013-06-30 00:00:00
425	P O Box 72569	\N	East Brisbane	64	4169	E6100000010CB7E52208E6733BC0CF0FAE704E226340	caa03fc3-0618-4114-b499-613fb03e7a3d	2013-07-31 00:00:00
426	2nd Floor	55 Lavender Street	Milsons Point	50	2061	E6100000010C549D002418EB40C036421586C5E86240	624bc238-c952-4fd5-adbf-d1b0b6b2a53b	2013-06-30 00:00:00
427	258 Berry Street	\N	North Sydney	50	2055	E6100000010C3CE6C2506AE940C0DD76B891F1E86240	c0fb6269-8089-4abc-b106-01209acb38cd	2013-06-30 00:00:00
428	85 Egerton Street	\N	Silverwater	50	2264	E6100000010CBAD7056D8DE740C06554ACC7E3E16240	bfb2c060-cd27-4543-970c-9fa9bf6b2a65	2013-05-30 00:00:00
429	Po Box 25484	\N	Springwood	50	2777	E6100000010C8BF6CB3566D240C0C6EC6E6ADDDA6240	63854033-efa4-4ca7-b7bb-f4d9723d3692	2013-06-30 00:00:00
430	Orwith Center	39 Herbert Street	St. Leonards	50	2065	E6100000010CB6B439F7E7EE40C06CABB31EB7E66240	2631c7e7-1d67-491e-b2c3-69f65756c1ca	2013-07-31 00:00:00
431	Level 7	114 Albert Road	Rhodes	50	2138	E6100000010C0A235BA9C2F240C00F8550E2BBE46240	1aace780-e2ca-4f90-b02d-979a5e6d7fe9	2013-07-31 00:00:00
432	254a James Street Botany	\N	Malabar	50	2036	E6100000010C4BE5BECE81FD40C04DFF2F7C2BE56240	cbeed2d7-9613-4ed1-8185-88677ce71b37	2014-05-01 00:00:00
433	Level 25	96 Lytton Rd.	Melbourne	77	3000	E6100000010C9D280A63D6ED42C0FF7C1D77941B6240	3b0d2653-ff4c-46da-ab57-1a46dee02c75	2013-06-30 00:00:00
434	Level 25	538 Climbing Street	Rhodes	50	2138	E6100000010C9DBB3B9A6DEE40C0CF7E0ABD26E76240	a05d693b-4d07-4aaf-9f3e-2e2207a03a07	2013-07-31 00:00:00
435	2253-217 Palmer Street	\N	Darlinghurst	50	2010	E6100000010C9FFB0329A2EE40C092CEF02706E46240	8ec24e8c-c114-4240-80d5-ce7e4bdae4d1	2013-07-31 00:00:00
436	4250 Concord Road	\N	Rhodes	50	2138	E6100000010C57D7364B8BE940C0CAFE20AE50E46240	064e2036-faaf-4649-99ce-329eb153a7ab	2013-07-31 00:00:00
437	Level 992	56 Pitt Street	Melbourne	77	3000	E6100000010CD2E42BE917E642C035B63CBED31E6240	04f64d7d-2e01-4c5f-98b5-b7303099ba1c	2013-05-30 00:00:00
438	Level 7	201 Sussex Street	Matraville	50	2036	E6100000010CAA4FCF6960FE40C04DFF2F7C2BE56240	50aaa76e-f879-43d4-aec1-d0be284ae49e	2013-07-31 00:00:00
439	Level 5	157 Liverpool Street	Rhodes	50	2138	E6100000010CBB9871C153F240C0CBF634F261E06240	a60b24c2-7c96-4931-8e77-0b0f42925567	2013-05-30 00:00:00
440	No. 6	Millenium Court	Perth	66	6006	E6100000010C6C9C7DB022E83FC078357EAF8EEB5C40	2e602e0a-26a7-4aa0-9874-443dc8c8dad7	2013-07-31 00:00:00
441	Level 59	\N	Alexandria	50	2015	E6100000010C697AD82969F040C08D5B3B3E52E06240	b9dd0011-99d8-4e95-bbef-4376233ce74f	2013-06-30 00:00:00
442	45671 Queens Road Ct.	\N	Melbourne	77	3000	E6100000010CF5EAB80D73EA42C0A0542F7B6F1D6240	99d1c4f8-d318-4d6c-9583-5f13ab84af26	2013-05-30 00:00:00
443	Level 7	80 Arthur Street	Newcastle	50	2300	E6100000010C2FBAC8430B7140C0D485208F14F46240	5fc64170-ad5f-4196-b732-dedc02d292dc	2013-07-31 00:00:00
444	254a Baker Street	Botany	Sydney	50	1002	E6100000010CC5413C3897F140C0CDD4A93D56E06240	3e77893c-0831-4a1a-9b6c-df6a01d9d206	2013-07-31 00:00:00
445	6388 Lake City Way	\N	Burnaby	7	V5A 3A6	E6100000010CF2B5E0E45C98484097C9C1F8DFB85EC0	53572f25-9133-4a8b-a065-102ff35416ee	2012-07-31 00:00:00
446	52560 Free Street	\N	Toronto	57	M4B 1V7	E6100000010C01192A3A42D845401D13034F29D853C0	801a1dfc-5125-486b-aa84-ccbd2ec57ca4	2011-07-01 00:00:00
447	22580 Free Street	\N	Toronto	57	M4B 1V7	E6100000010C86F999D3E6D445405B588FA188CF53C0	88cee379-dbb8-433b-b84e-a35e09435500	2012-06-30 00:00:00
448	2575 Bloor Street East	\N	Toronto	57	M4B 1V6	E6100000010C7BA6F8AFDCD1454068852A98ECDD53C0	2df6d0ad-0926-4f34-a450-9b1083150cbf	2013-06-30 00:00:00
449	Station E	\N	Chalk Riber	57	K0J 1J0	E6100000010C81ECB5A20C0847402BE5FCFBAB5B53C0	8b5a7729-cb75-4303-a607-7f9793b4d94f	2011-07-01 00:00:00
450	575 Rue St Amable	\N	Quebec	63	G1R	E6100000010C09F032C346674740A1AED40468C951C0	5f3c345a-6475-41d5-b17b-db8d27733bb1	2012-07-31 00:00:00
451	2512-4th Ave Sw	\N	Calgary	1	T2P 2G8	E6100000010C78555C828A7E49403C3C7112FC855CC0	49644f1e-6f90-46d9-8dbb-9db15f0ef7ec	2012-10-30 00:00:00
452	55 Lakeshore Blvd East	\N	Toronto	57	M4B 1V6	E6100000010CA880A8690BCE4540D4D3878E4AD053C0	a358652f-0e00-49e6-b6b0-de1099c43506	2011-08-01 00:00:00
453	6333 Cote Vertu	\N	Montreal	63	H1Y 2H7	E6100000010C1ADBD7A70DB54640AAB5C74C7E7052C0	355681f2-4d9d-4522-bfa0-105be64394d8	2013-07-31 00:00:00
454	3255 Front Street West	\N	Toronto	57	M4B 1V6	E6100000010C09A5840DC2D44540CA19344F35DD53C0	ef4dc57d-8b8b-4074-b5f0-acbef65dbec1	2013-06-30 00:00:00
455	2550 Signet Drive	\N	Weston	57	M9V 4W3	E6100000010CEB71673CC8DC4540F265E4C3FBED53C0	43d582cf-e95f-4861-ba60-2dc7121410a6	2012-06-30 00:00:00
456	6777 Kingsway	\N	Burnaby	7	V5H 3Z7	E6100000010CC7F63778C8A4484006A9A99F16C75EC0	2f3b383e-08a5-407d-ab1b-a1390e87a888	2012-06-30 00:00:00
457	5250-505 Burning St	\N	Vancouver	7	V7L 4J4	E6100000010C56FE4E12F7A748404C0E542E55C35EC0	93f02c61-783d-4f04-8a57-416f25817aba	2012-05-30 00:00:00
458	600 Slater Street	\N	Ottawa	57	K4B 1S2	E6100000010C26D11A95B17A46404EC01708CDDF52C0	49f4ee42-e20b-4e66-b43c-a28e9fc63ca0	2011-05-31 00:00:00
459	25575 The Queensway	\N	Etobicoke	57	M9W 3P3	E6100000010CF2688B9365DE45402D4A770929E153C0	616235ea-dc36-4c39-bf91-ffe12bb676e0	2011-07-01 00:00:00
460	2521 McPherson Street	\N	Markham	57	L3S 3K2	E6100000010CAC8A354CB0EB4540DB75B1EDE0CF53C0	7d6f03ac-5d55-422e-850e-b8743fac81b2	2013-06-30 00:00:00
461	2560 Bay Street	\N	Toronto	57	M4B 1V7	E6100000010C380C514997D145401B0F5F188ED253C0	726819a8-1b02-4efd-aeb9-3fd801d9f153	2012-06-30 00:00:00
462	630 University Avenue	\N	Toronto	57	M4B 1V7	E6100000010C1D4A454718D345402390FE1FEFD753C0	27d5bdad-647d-4a56-859a-bc6a82af7dcd	2011-07-01 00:00:00
463	992 St Clair Ave East	\N	Toronto	57	M4B 1V7	E6100000010C87D094DF5AD14540EBD7098BE8D753C0	d6ed51fa-6dd1-460c-99e0-64ba90f035ae	2011-08-01 00:00:00
464	99, Rue Saint-pierre	\N	Pnot-Rouge	63	J1E 2T7	E6100000010C4EC5D3B623B14640C7251C03ECF851C0	c4a1ee36-8149-46b7-a313-a63010987a8e	2011-05-31 00:00:00
465	25245 Rue Sherbrooke Ouest	\N	Montreal	63	H1Y 2H5	E6100000010CCB57355AA4CC46407A070453016A52C0	10ee8c14-2792-4f02-b83d-92511d20470f	2013-05-30 00:00:00
466	655-4th Ave S.W.	\N	Calgary	1	T2P 2G8	E6100000010CB65B063BD98E494028D0DBC5387E5CC0	09c5f0ba-7128-4455-832d-0df587248a5a	2011-07-01 00:00:00
467	25900-700-9th Ave S.W.	\N	Calgary	1	T2P 2G8	E6100000010C9E9E1B0C9E7C49404D2F3147E4845CC0	13560188-ce4a-470d-9913-49903047d459	2011-10-01 00:00:00
468	Po Box 83270	\N	Vancouver	7	V7L 4J4	E6100000010C84AB97D4DBA948409A541165E1B95EC0	c00a5dff-b134-4900-9561-e67eeb425f9f	2013-06-30 00:00:00
469	400-25155 West Pender St	\N	Vancouver	7	V7L 4J4	E6100000010CDBF3C39B84AA4840BDF54CB405C45EC0	b81768f9-3b05-43dc-8dde-85ffca00d4de	2013-07-31 00:00:00
470	2511 Baker Road	\N	Toronto	57	M4B 1V7	E6100000010C6BA95C0F76D5454064ADFC3D12D253C0	6e934d97-69b9-4fcf-9e4e-56bf94e52986	2011-08-01 00:00:00
471	770 Notre Datme Quest Bureau 800	\N	Montreal	63	H1Y 2H7	E6100000010C963E83260DCF4640B63DE4EF0F6352C0	5eda011d-31d1-4dfb-a78c-397b6335f85b	2011-08-01 00:00:00
472	250551 Shellbridge Way	\N	Richmond	7	V6B 3P7	E6100000010C571C59C251924840F3475256CCCD5EC0	1a6a1a7b-e208-473d-a8f4-14a89d06fad2	2011-08-01 00:00:00
473	595 Burning Street	\N	Vancouver	7	V7L 4J4	E6100000010CE1052959A5AD4840AC342B5FA2C95EC0	0ec83a85-137e-4cf3-b13d-3926277698b2	2011-08-01 00:00:00
474	252345 8810th Avenue	\N	Surrey	7	V3T 4W3	E6100000010C25F14B50889D4840CC27457EB4B65EC0	447ca097-077d-4980-a431-8fafad156ced	2011-08-01 00:00:00
475	2512-410th Avenue S.W.	\N	Calgary	1	T2P 2G8	E6100000010C7B13D1B5BE8349409AE0900CBA835CC0	ec6c99b9-61e2-4400-8180-208f5a6c7eff	2013-07-31 00:00:00
476	258 King Street East	\N	Toronto	57	M4B 1V7	E6100000010C3E8F8E01D2CD45401EC0A7F86AD453C0	90c770a5-a474-43d1-9a67-0f5de336f9dc	2011-07-01 00:00:00
477	6th Floor Ferguson Block	\N	Toronto	57	M4B 1V7	E6100000010C86F999D3E6D445400569281616D353C0	39f3b067-2263-4591-abf9-d5210da4f783	2011-07-01 00:00:00
478	2545 King Street West	\N	Toronto	57	M4B 1V7	E6100000010CC93203B238DB454064FDA040CEDA53C0	2817a0b7-8985-4527-bb7b-b75f55f4d8de	2011-07-01 00:00:00
479	2550 Middlefield Road	\N	Scarborough	57	M1V 4M2	E6100000010C16575E0473F14540880DAD498AD053C0	e60801bf-cfb3-4606-a738-8aa0eb587afb	2011-07-01 00:00:00
480	25 First Canadian Place	\N	Toronto	57	M4B 1V5	E6100000010C080FA2839CD74540977ACBB4CCD553C0	07a009b2-1421-4597-ab85-22bce3c82b2c	2011-07-01 00:00:00
481	65 Gamelin Street	\N	Hull	63	8Y	E6100000010C7724BA0A07B54640218C2EB21CE952C0	f35e73ba-678f-4a0f-80bc-6385a7a6cb24	2012-06-30 00:00:00
482	2500 University Avenue	\N	Toronto	57	M4B 1V5	E6100000010C19DA2A5F00DA45401ED929512AD353C0	197a1735-e89e-4f15-a5f7-feb98b369094	2011-05-31 00:00:00
483	955 Green Valley Crescent	\N	Ottawa	57	K4B 1S1	E6100000010CCE72E7A6AAB64640D9EF76490CEF52C0	c6b743c3-f830-43e4-ba58-dd36fc451d14	2013-07-31 00:00:00
484	2510 Crew Court	\N	Montreal	63	H1Y 2H8	E6100000010CA68B6647CBC14640024A3484CD6352C0	1f41edc1-7144-4d6b-9cbd-4318c2358fa1	2014-05-01 00:00:00
485	9900-6400 Boul, Taschereau	\N	Brossard	63	J4Z 1R4	E6100000010C4CF76DA17FBC4640A9CC69062A5752C0	7c46d2fc-e31e-402f-a093-4cf18f7f6e54	2012-05-30 00:00:00
486	600 Boul. Rene-levesque Ouest	\N	Montreal	63	H1Y 2H7	E6100000010C042358BC63C3464043CAAF79116B52C0	112049e4-64d5-4305-9545-933e89b74f6e	2012-05-30 00:00:00
487	9259 - 1110th Avenue Sw	\N	Calgary	1	T2P 2G8	E6100000010CB95DF34F7A804940899FE724AD8E5CC0	275ac976-0d23-4d97-9f58-bb186d1cc089	2012-07-31 00:00:00
488	45259 Canada Way	\N	Burnaby	7	V5G 4S4	E6100000010C41FA564D99974840586ED904A9C15EC0	6d2d6846-3f17-474e-8d31-ad3a59c0ceb0	2013-06-30 00:00:00
489	9960 King Street E.	\N	Toronto	57	M4B 1V5	E6100000010C0D6D761A7FCD4540210F3EE50BD053C0	eb632e56-4299-4714-9e91-224319bdcb62	2013-06-30 00:00:00
490	9979 Bayview Drive	\N	Barrie	57	L4N	E6100000010C78601F0C963446402AD91221C3EC53C0	85d72a98-f631-457c-8fff-04faec508f5d	2012-06-30 00:00:00
491	20225 Lansing Ave	\N	Montreal	63	H1Y 2H7	E6100000010C270CF6468EC44640DCE9F498026C52C0	a9b5a261-2463-4489-9951-eacfa29a8231	2013-07-31 00:00:00
492	99954 Boul. Laurier, Local 060, Place	\N	Sainte-Foy	63	G1W	E6100000010C3A1AA10CBA634740E442322AF4D451C0	541cde7c-3f3a-435f-a7b5-f30055dfbc68	2013-07-31 00:00:00
493	6th Floor 5250 Main Street	\N	Winnipeg	31	R3	E6100000010C3C12FBAA4DEF48409558BDEC684358C0	ac0e73d8-ff0a-42bd-8502-e19ebac7343f	2013-07-31 00:00:00
494	Box 99354 300 Union Street	\N	Saint John	41	E2P 1E3	E6100000010C0F54094FE7A64640D53DA2C4E08350C0	21ff77a8-39dc-44d8-917c-fdd645dbf9eb	2012-05-30 00:00:00
495	Suite 800 2530 Slater Street	\N	Ottawa	57	K4B 1T7	E6100000010CAB09A4E723B64640455191B047F152C0	c6633ad5-006d-4967-b97e-7919dd48a700	2012-07-31 00:00:00
496	Suite 500 995 W. 11th Avenue	\N	Mississauga	57	L5A 1H6	E6100000010C481C5D94E8C54540D4A5E8A11DE453C0	496c1ad3-2925-4322-8811-890ab6107f67	2013-06-30 00:00:00
497	#9900 2700 Production Way	\N	Burnaby	7	V5A 4X1	E6100000010C78E09E12D0AA484044C70100AFB25EC0	aa651b28-0a51-4084-8444-a70cc71bce65	2011-07-01 00:00:00
498	25537 Hillside Avenue	\N	Victoria	7	V8V	E6100000010C3A698D5BCC37484029E04047DBCB5EC0	385c24e0-e20c-40c9-bac9-95d70d5b6900	2011-07-01 00:00:00
499	Suite 2502 410 Albert Street	\N	Waterloo	57	N2V	E6100000010CFDCD996B86B745404C2CB89E082754C0	44099b0e-03f3-447c-83bf-be4baa010a83	2012-06-30 00:00:00
500	5700 Explorer Drive	\N	Mississauga	57	L4W 5J3	E6100000010CA00F15314CD64540210B3194ECE953C0	f6fed7fa-39d9-4a60-a1f5-1622489e55fd	2011-07-01 00:00:00
501	965 De La Gauchetiere West	\N	Montreal	63	H1Y 2H8	E6100000010CC4B0BCC574CD4640A99EC6449F5E52C0	acb9c033-18c6-4f02-975e-9c5226b96b72	2011-07-01 00:00:00
502	No. 25400 10665 Jasper Avenue	\N	Edmonton	1	T5	E6100000010C07EC7A0365CB4A40058911951B605CC0	51180ca2-6614-46a5-b89c-ef7b0421c847	2012-06-30 00:00:00
503	P.O. Box 44000	\N	Winnipeg	31	R3	E6100000010C9D76A4387FF24840EAE5BE90FA4D58C0	c4f3e274-13e1-4a99-8fd3-2c7d3d1ee5a1	2011-07-01 00:00:00
504	Suite 99320 255 - 510th Avenue S.W.	\N	Calgary	1	T2P 2G8	E6100000010CB95DF34F7A80494082A134B33C7A5CC0	cff7437f-6830-4797-875b-d9a54ea38975	2011-07-01 00:00:00
505	6400, 888 - 3rd Avenue	\N	Calgary	1	T2P 2G8	E6100000010C1C208911138B4940C5B256A36E845CC0	a6eff2b6-3b11-47ef-ab7e-701e5041c71c	2011-07-01 00:00:00
506	255117 - 101 Avenue	\N	Surrey	7	V3T 4W3	E6100000010CC9D94A38089448406D372033DAB25EC0	22895b47-6086-4550-b437-a75dbedfe1d9	2011-07-01 00:00:00
507	975 Princess Street	\N	Kingston	57	7L	E6100000010C799EC1A44D21464006B17E13811C53C0	d7849f5f-c042-4fce-8f6b-ba5cd8708e10	2013-07-31 00:00:00
508	2900 - 25055 Dunning Street	\N	Vancouver	7	V7L 4J4	E6100000010C80308D61EAA248400FF36ED41EC45EC0	4ee0334f-027c-4036-880f-6e9104e21533	2012-10-30 00:00:00
509	Suite 25800 3401 - 10810th Avenue	\N	Surrey	7	V3T 4W3	E6100000010C3B07A3230DA0484057657834B6C15EC0	28c52717-7117-41b6-a5c7-fda60d566163	2011-07-01 00:00:00
510	750 Philip Street	\N	Waterloo	57	N2V	E6100000010C903B2D5B2EBF45403836A153C71F54C0	f2b96299-187a-4e52-96de-fe9d1c8ab33f	2011-10-01 00:00:00
511	Bureau 9900 825, Avenue Querbes	\N	Outremont	63	H1Y 2G5	E6100000010C4F44187F24BE464045555E31C06752C0	ef10cf20-a540-4d5c-befd-1b48b7d48402	2012-10-30 00:00:00
512	700 Bureau Road	\N	Montreal	63	H1Y 2H7	E6100000010C6C2E0977CEC246404E5D290F016452C0	963f514b-7752-46e8-9742-1fd40a68ea33	2013-07-31 00:00:00
513	253711 Mayfield Place, Unit 150	\N	Richmond	7	V6B 3P7	E6100000010C515904B09DA14840DA088CDF72BE5EC0	c418c2f4-6b32-4404-aab1-e0bec3958c11	2013-07-31 00:00:00
514	63 West Beaver Creek	\N	Richmond Hill	57	L4E 3M5	E6100000010CF01C05D909EE45407814D6EA8CD353C0	ad60dba9-3b01-47e9-bb5e-df94d0579f14	2012-07-31 00:00:00
515	9900 Ronson Drive	\N	Etobicoke	57	M9W 3P3	E6100000010C05EB2A023ED845403E6793820CE253C0	42242712-6dd2-423f-9b89-c953454e3b09	2012-05-30 00:00:00
516	251 Indell Lane	\N	Brampton	57	L6W 2T7	E6100000010C8EA2CEB941D3454018B7E62853E853C0	a1f36994-b5b3-4646-87ea-692a513395ea	2012-06-30 00:00:00
517	2573 Dufferin Street	\N	Toronto	57	M4B 1V5	E6100000010C436EC1ECC3E14540661B4641F0DC53C0	97605c5c-8309-44f2-9a98-c5a5709497ff	2011-05-31 00:00:00
518	995 Crescent	\N	Richmond Hill	57	L4E 3M5	E6100000010C70D66444E9FB45400C6393865FDC53C0	0b49022d-8b49-4cf6-b0a3-46231cd48441	2013-07-31 00:00:00
519	2500-622 5th Ave Sw	\N	Calgary	1	T2P 2G8	E6100000010C946079A9DB8149409D01CB543C835CC0	13754965-6a09-4343-968c-8699c27fdfaa	2012-06-30 00:00:00
520	6700 Boul Taschereau	\N	Brossard	63	J4Z 1C5	E6100000010C37720703D6C44640EFEF368F785D52C0	b730eaff-5828-4c8c-86c1-9137f50fca48	2011-08-01 00:00:00
521	55 Standish Court	\N	Mississauga	57	L5B 3V4	E6100000010C06568DD243CD4540DE01044E9BE453C0	97c329e2-fa67-4478-aa7b-78a8deecf7ca	2012-07-31 00:00:00
522	43251 Viking Way, Unit 130	\N	Richmond	7	V6B 3P7	E6100000010CA31D2E114A8F484009946D7F5BCD5EC0	842bcbe5-9da5-42d5-a4bb-4197db5b69c7	2012-12-31 00:00:00
523	46990 Viking Way	\N	Richmond	7	V6B 3P7	E6100000010C2CA98801669E4840BCE1096AAAB95EC0	85c88cd6-682c-4358-9f8c-5a24f4ccfd98	2011-07-01 00:00:00
524	9693 Louis H Lafontaine	\N	Ville De'anjou	63	J1G 2R3	E6100000010CD292B94117BB4640E314F62D6CFD51C0	acc21bd9-fb1b-4764-941b-2fb98aa4eb27	2012-06-30 00:00:00
525	69251 Creditview Road	\N	Mississauga	57	L5B 3V4	E6100000010CAAB3114F73CF4540C6387FC012ED53C0	2ca11975-213a-46fb-a0be-2529003074cc	2011-05-31 00:00:00
526	251420a 170th Street	\N	Edmonton	1	T5	E6100000010C61DC6B0C04C64A400EEF11D86B5F5CC0	476d80ae-69a0-480d-9df3-8fd0c1095a21	2012-05-30 00:00:00
527	252851 Rowan Place	\N	Richmond	7	V6B 3P7	E6100000010CF02748B48DA84840B8F65A3E06C05EC0	11eaee50-8a14-4b81-951e-86701b6f60c0	2012-07-31 00:00:00
528	5990 Avebury Road	\N	Mississauga	57	L5B 3V4	E6100000010CF00AFF0C08D74540C4A84B29BCEE53C0	d9928ccc-fc35-435a-8a0f-6887813e0e06	2011-08-01 00:00:00
529	254480 River Rd	\N	Richmond	7	V6B 3P7	E6100000010C90FAE96C339E48409A1281BA18CD5EC0	034076fd-cd0e-4ead-864e-8ce7f47d6612	2011-05-31 00:00:00
530	Suite #9902	\N	North York	57	M4C 4K6	E6100000010C5AAF68F398DB4540617A8EC086CD53C0	fe36e0c8-ad8a-4d2c-bc53-5d69be5a9ce7	2011-05-31 00:00:00
531	5th Floor, 79 Place D'armes	\N	Kingston	57	7L	E6100000010CAEC69B404B234640F5583D26461A53C0	f6fb5f79-c5fa-4a7c-8d75-6e9243360308	2012-09-30 00:00:00
532	#500-75 O'Connor Street	\N	Ottawa	57	K4B 1S2	E6100000010C6D0C5BE69DB3464067E36C852BE652C0	1b58b9bc-a691-4927-bf17-569e4be822f3	2011-10-31 00:00:00
533	4400 March Road	\N	Kanata	57	K2L 1H5	E6100000010CDEAA586E56A846402A07F3BDA2FD52C0	43484cd9-ad5b-41f4-a9cc-ddfbac4b5aa5	2011-10-01 00:00:00
534	Depot 80	\N	Sillery	63	G1T	E6100000010C56B66CFFBF6C4740EE0DBB4F3FD151C0	3178440d-5c3a-48f2-af6b-0a607774e265	2011-07-01 00:00:00
535	250 Kingsbridge Garden Circle	\N	Mississauga	57	L5B 3V4	E6100000010C280E88D6E2D24540B11739C852E553C0	9771494e-9053-40f2-84a5-e0d108deefed	2011-10-01 00:00:00
536	No. 2000-25080 Beaver Hall Hill	\N	Quebec	63	G1R	E6100000010C4A075627D36C47405A6C26B5DFD451C0	0c38c439-4562-4e37-8f23-aff2c9005c38	2012-07-31 00:00:00
537	No. 25800-130 King Street West	\N	Toronto	57	M4B 1V5	E6100000010C7581430D7ED64540453AF395B5CF53C0	c2bcdaec-366c-489c-bf43-8cc2881179f3	2011-08-01 00:00:00
538	25 Danger Street West	Floor 7	Toronto	57	M4B 1V5	E6100000010CDF55D1BE2BD845400BBA0D2CA6CB53C0	10b2404c-f0af-409c-af5d-0218beb03d0d	2013-06-30 00:00:00
539	6th Floor, 25st Canadian Place	\N	Toronto	57	M4B 1V5	E6100000010C080FA2839CD74540826A15ED46D453C0	d51784c0-cc77-48c2-8fa6-75405f3e35b9	2011-07-01 00:00:00
540	254 Colonnade Road	\N	Nepean	57	K2J 2W5	E6100000010CB4666C27CBA44640C9D9174B07F152C0	1c97f465-f2af-4d34-be8c-7afdad119425	2011-07-01 00:00:00
541	25981 College Street	\N	Montreal	63	H1Y 2H5	E6100000010C81C0BA7904C24640849D3AD5126952C0	af56d631-eb1c-4716-a89b-88bc4ae04b93	2012-06-30 00:00:00
542	5 place Ville-Marie	\N	Montreal	63	H1Y 2H7	E6100000010C1F3557B4F9B746401D8239D9D05F52C0	b242b256-254b-4624-b3af-bf0058bb0b7b	2012-07-31 00:00:00
543	6030 Conroy Road	\N	Ottawa	57	K4B 1S3	E6100000010CEA232D5E2CA74640C6C8087C74E352C0	aa8f3ecb-c454-448b-b774-ff9cdf01e629	2012-07-31 00:00:00
544	30025 Wayburne Drive, Suite 275	\N	Burnaby	7	V5G 4W1	E6100000010C99511CE0B4A048401505F03A2ABB5EC0	4c65a591-c6b0-43d8-8faf-f4b1cb9953e1	2011-08-01 00:00:00
545	999 West Georgia St.	\N	Vancouver	57	V5T 1Y9	E6100000010CB30F1188B5A448408FB353C733BD5EC0	9d35f3c2-966e-4b3b-8d29-0e6ab8def01b	2012-07-31 00:00:00
546	250333 Southport Road, S.W.	\N	Calgary	1	T2P 2G8	E6100000010C56526943A0784940F8716985567D5CC0	11d29e3f-d9b2-4e24-ac01-eeba72da4ddf	2013-06-30 00:00:00
547	7000 Victoria Park Avenue	\N	Toronto	57	M4B 1V4	E6100000010C1DD196D496D24540BF31399A0DCE53C0	28125ec3-fdc2-45d8-93b3-cd7db2113424	2013-07-31 00:00:00
548	63 Free St.	\N	Toronto	57	M4B 1V4	E6100000010CB58343D8D3D94540D67CBA3E5BDA53C0	5649c5d8-1798-4622-95bf-dc7e581284a0	2011-08-01 00:00:00
549	609 Evans Avenue	\N	Toronto	57	M4B 1V4	E6100000010C76E7D27569C645405E03B54C89E453C0	dcf9c9b5-a7b6-4383-9480-1f84130b5f8b	2012-07-31 00:00:00
550	2520 Flanders Road	\N	Toronto	57	M4B 1V4	E6100000010CDC1AA465E6DA4540FAC2119219D553C0	a1d478e6-76da-445f-a924-0b5dee3c7cbb	2012-06-30 00:00:00
551	32605 West 252 Mile Road, Suite 250	\N	Aurora	57	L4G 7N6	E6100000010CC090BF1BD3004640C26ACCA7D4D853C0	e7567a62-3acf-4f0b-b202-e28b92de689a	2012-07-31 00:00:00
552	25730, boul. St-Régis	\N	Dorval	63	H9P 1H1	E6100000010C791D615290BE4640675EC807007352C0	6832a3bd-56ec-42fe-8b4c-6bfd09f89eb4	2014-05-01 00:00:00
553	253131 Lake Frasier Drive, Office No. 2	\N	Calgary	1	T2P 2G8	E6100000010C9B2CB505299049408CA0132DFF825CC0	ef7b5bd3-3a04-4a09-a0d2-02b98e3333dc	2011-07-01 00:00:00
554	9984 Wellington Street	\N	Ottawa	57	K4B 1S2	E6100000010CB19C3FFC168F46406A55C6163DF052C0	6e0797c9-fd43-418f-a5fe-8683292b95fe	2012-06-30 00:00:00
555	9950 Ferrand Drive, 9th Floor	\N	Toronto	57	M4B 1V4	E6100000010C74345118A7DC4540DBF7CCE8A1CD53C0	32890831-931e-44ad-801b-41b1ad862eca	2011-08-01 00:00:00
556	990th Floor 700 De La GauchetiSre Ou	\N	Montreal	63	H1Y 2H3	E6100000010C35F1E2A308C94640D0EE03D3ED6752C0	87846d7c-ab01-41c6-a4cc-fad06d74d11b	2011-05-31 00:00:00
557	660 Saint-Jacques, Bureau 400	\N	Montreal	63	H1Y 2H8	E6100000010CE722915B13B9464001AE467F8F6952C0	dce88c1f-8bfe-4306-ba02-50446466c5e5	2012-07-31 00:00:00
558	67255 - 8th Street N.E., Suite 350	\N	Calgary	1	T2P 2G8	E6100000010CB95DF34F7A8049403FE1A610E37D5CC0	da596abb-b3af-48ec-a082-9e94cd870a5f	2012-10-30 00:00:00
559	12345 Sterling Avenue	\N	Irving	73	75061	E6100000010C0E0FFF01E8664040D2687834393B58C0	0d39391c-a319-486b-ac9e-5863795d6675	2011-08-01 00:00:00
560	800 Interchange Blvd.	Suite 2501	Austin	73	78701	E6100000010CB79C60EAEC413E40188A3E72166858C0	5790365c-da3c-43bc-93d3-99104c038b71	2012-05-30 00:00:00
561	90025 Sterling St	\N	Irving	73	75061	E6100000010CF6FEFD6EC37B40407C65B87A324458C0	c1ca3287-f642-44da-bba1-8ab47e1907dd	2012-07-31 00:00:00
562	2505 Gateway Drive	\N	North Sioux City	68	57049	E6100000010C7FA5E1FBB43B4540D61DE522021A58C0	57a5e455-526c-402a-bc5d-ee613bf58372	2011-07-01 00:00:00
563	74400 France Avenue South	\N	Edina	36	55436	E6100000010C3850C3D938744640064AF205174F57C0	a1841d05-cabd-4453-96e4-9b1e95ca2bc2	2012-07-31 00:00:00
564	509 Nafta Boulevard	\N	Laredo	73	78040	E6100000010CD4BE69C48C923B402B1A5D0C03DD58C0	f9a8a87a-152f-4204-b5d2-dbcb8da1c13b	2011-07-01 00:00:00
565	25149 Howard Dr	\N	West Chicago	24	60185	E6100000010C4DBB14A0AEEF44409C1A3FD4A80C56C0	f4915606-499d-477d-8309-e8f92e9d8fe3	2011-08-01 00:00:00
566	63 W Monroe	\N	Chicago	24	60610	E6100000010C0060FAF8F2F34440FF0EA4AAC8EC55C0	61113716-53e4-4faa-a5a2-247b03f0f9c6	2011-10-01 00:00:00
567	Corporate Office	\N	Garland	73	75040	E6100000010CD90A0D92047B4040FCB4B329601E58C0	10cc0938-b0af-42e0-9176-564321c68787	2011-08-01 00:00:00
568	25269 N. Wood Dale Rd	\N	Wood Dale	24	60191	E6100000010C196D3955F60645401393B98CF0F755C0	e863927d-49fb-47ab-9ca6-a5f36d082b66	2011-08-01 00:00:00
569	Sapp Road West	\N	Round Rock	73	78664	E6100000010C20E441E0C88A3E4069CAC387616458C0	b7ea2783-866e-4ad9-945c-914b674ad2cd	2011-08-01 00:00:00
570	52500 Liberty Way	\N	Fort Worth	73	76102	E6100000010C30593711AF764040BB01840D784C58C0	f5a1147f-761f-4577-bb48-bbef73b4a27f	2012-05-30 00:00:00
571	25550 Executive Dr	\N	Elgin	24	60120	E6100000010C27C5AD283C044540AEA8758DA31B56C0	8caf52b2-d3e2-4a5f-a704-874768007f38	2011-10-31 00:00:00
572	P.O. Box 6256916	\N	Dallas	73	75201	E6100000010C8044A1422D5F4040F66D784F983758C0	206e0ff7-e120-4845-acb4-a4443ebf6429	2013-07-31 00:00:00
573	25269 Wood Dale Rd.	\N	Wood Dale	24	60191	E6100000010C2D9B6B8880054540FFE4F38E560456C0	e4c1153e-6c1a-45df-addb-80fac429fa3f	2011-10-01 00:00:00
574	Po Box 8259024	\N	Dallas	73	75201	E6100000010CAA5BBD5FAB69404087866D198D3C58C0	9794b438-2e91-4699-85df-5fcf98210ac1	2012-07-31 00:00:00
575	42500 W 76th St	\N	Chicago	24	60610	E6100000010C2B535433FCDB444063E84C8FCBE555C0	cd335652-0913-40ea-9ae0-323066fc04f0	2012-07-31 00:00:00
576	4255 East Lies Road	\N	Carol Stream	24	60188	E6100000010CAD26D77D1BFA4440C1399A61ED0E56C0	c1a9793e-50b5-431c-82dd-8b36acc9ac4e	2011-10-01 00:00:00
577	2500 North Stemmons Freeway	\N	Dallas	73	75201	E6100000010C4DD260393369404026C0A31BF73458C0	c91ed16c-4407-4eed-a241-c8327e5e50c2	2012-07-31 00:00:00
578	220 Mercy Drive	\N	Garland	73	75040	E6100000010C4BE8E841CD7640400FE794AB772158C0	791e9c8d-6c3a-4cfd-9f0a-c4a99424c268	2011-05-31 00:00:00
579	25 N State St	\N	Chicago	24	60610	E6100000010C612DB55CC1ED44403DAE80B492E255C0	02d95901-41c1-4479-a04f-9ffb5a2675e3	2012-05-30 00:00:00
580	2509 W. Frankford	\N	Carrollton	73	75006	E6100000010C62359F9E5C7A404008529942A83458C0	a0dbc338-cf0e-4962-9fbf-63220aeca66e	2012-05-30 00:00:00
581	Po Box 8035996	\N	Dallas	73	75201	E6100000010C8E345943826A4040839B00B8E03358C0	cc8321ba-c938-4765-8175-9126d432957f	2013-07-31 00:00:00
582	5700 Legacy Dr	\N	Plano	73	75074	E6100000010C20FF21FDF6894040FB0DEB8EF83958C0	08ebf5a9-2171-433e-85b8-56fff949d041	2013-07-31 00:00:00
583	625 W Jackson Blvd. Unit 2502	\N	Chicago	24	60610	E6100000010C44426666E3F7444069A68EA595E855C0	a35c7ac7-5ae8-43d9-92e7-180d78a9a7b8	2013-01-28 00:00:00
584	250880 Baur Blvd	\N	Saint Louis	37	63103	E6100000010C0EEE0359AD53434013516ED4BC9056C0	ed1ee7da-5087-4e7a-b019-7782742bc451	2013-05-30 00:00:00
585	Noah Lane	\N	Chicago	24	60610	E6100000010CCA0AF5919BEE4440C8B82E89ACE755C0	e9408fbb-1c28-4923-9d85-2dfadb3b4b6b	2012-06-30 00:00:00
586	6030 Robinson Road	\N	Jefferson City	37	65101	E6100000010C114D5347733A4340F4F8D509AA0D57C0	35b2fb0c-60ea-48f2-814a-f6813242858e	2011-08-01 00:00:00
587	25500 Old Spanish Trail	\N	Houston	73	77003	E6100000010CAB09BB3434BA3D403DB1D6E250DD57C0	9a71e3c4-caea-4c5c-a146-5b85a513d82f	2011-07-01 00:00:00
588	99828 Routh Street, Suite 825	\N	Dallas	73	75201	E6100000010C107E16DAAD6540403DA892EAD52C58C0	180f5a76-930d-4b70-9d70-7aa3e49bb71e	2011-07-01 00:00:00
589	One Dancing, Rr No. 25	Box 8033	Round Rock	73	78664	E6100000010CC9447E64A8873E4060399036E17058C0	a514f151-6b2d-452c-a983-d68aed9e112e	2011-08-01 00:00:00
590	9995 West Central Entrance	\N	Duluth	36	55802	E6100000010C7B1AB284206A47406EDED48CD10C57C0	86553e06-3bf8-4c21-8e40-ae95309c4b3e	2012-05-30 00:00:00
591	48255 I-10 E. @ Eastpoint Blvd.	\N	Baytown	73	77520	E6100000010C9FE9F7E0DAC53D4073177236E1BC57C0	8d604ca1-2f01-46c1-9041-39915144b446	2012-07-31 00:00:00
592	9903 Highway 6 South	\N	Houston	73	77003	E6100000010C20FDE1D749BC3D4091F6DB0029E657C0	ce585616-c47c-4bd4-8d71-1755b6417770	2011-05-31 00:00:00
593	2345 North Freeway	\N	Houston	73	77003	E6100000010C6BE0C0B4C4CD3D408377EDC35BE057C0	74e5959f-4c5f-4bda-abcf-429762e1670d	2011-07-01 00:00:00
594	123 W. Lake Ave.	\N	Peoria	24	61606	E6100000010C19A99C9BDB634440BAD5B95E556C56C0	c9f2b21e-3edb-4315-aa03-8adde7d8a598	2012-06-30 00:00:00
595	660 Lindbergh	\N	Saint Louis	37	63103	E6100000010C61FDF3790B574340D58D2492FF9D56C0	012d17ba-c426-40c2-a9fd-85093e2ceb8a	2012-07-31 00:00:00
596	72540 Blanco Rd.	\N	San Antonio	73	78204	E6100000010C4949469476783D403DF949AD759B58C0	5ec50e4c-3026-4bd5-9a15-00776ad22eec	2011-07-01 00:00:00
597	99450 Highway 59 North	\N	Humble	73	77338	E6100000010C9C52240C0AFB3D40757B27DF0BDA57C0	3bd8466e-2a52-4661-8460-50736409ee8a	2012-06-30 00:00:00
598	455 256th St.	\N	Moline	24	61265	E6100000010CD54379677BC4444054052995289F56C0	fbedd917-c269-4e36-a791-58b35f34b107	2011-07-01 00:00:00
599	70 N.W. Plaza	\N	Saint Ann	37	63074	E6100000010CC3B6F4510E5943405BBE71979A9A56C0	4735a716-33c4-4366-bcc0-410bceef3e2c	2013-06-30 00:00:00
600	25095 W. Florissant	\N	Ferguson	37	63135	E6100000010CFFD3D3324B5C4340D60EE721CE8C56C0	1a51283c-12bb-462e-a1b8-a0039c18e6d8	2011-07-01 00:00:00
601	6996 South Lindbergh	\N	Saint Louis	37	63103	E6100000010C9BF22BD12E444340E0F604895D9256C0	a8f4d544-a137-4775-b6c9-7c85a12a4ddc	2012-06-30 00:00:00
602	6425 Nw Loop 410	\N	San Antonio	73	78204	E6100000010C0936AE7FD7813D40D644CAA272AB58C0	6241806c-c9cc-46aa-a91f-b663c7e0c8bb	2012-07-31 00:00:00
603	9500b E. Central Texas Expressway	\N	Killeen	73	76541	E6100000010CC4EC722C58223F40CA2B06159A6A58C0	0e6e9e86-a637-4fd5-a945-ac342bfd715b	2013-06-30 00:00:00
604	1200 First Ave.	\N	Joliet	24	60433	E6100000010CEE82A38DBDC14440E24A7EE2190656C0	79972b72-7d84-4a33-ae27-44a5efaef39d	2013-07-31 00:00:00
605	7760 N. Pan Am Expwy	\N	San Antonio	73	78204	E6100000010CD8E6178563803D400C483DCFA59C58C0	6c3da38c-887d-410c-b022-8f2bf2db3339	2011-08-01 00:00:00
606	99433 S. Greenbay Rd.	\N	Racine	80	53182	E6100000010CC2BB92351F564540E3E778B4BFF855C0	48f98b9b-cf62-4a87-95e8-44da6aac6f97	2011-08-01 00:00:00
607	25220 Airline Road	\N	Corpus Christi	73	78404	E6100000010C368A68F22EB13B403C871812FB5F58C0	6e7fe435-895a-4e65-913b-2ad21cf4ce6d	2012-06-30 00:00:00
608	25306 Harvey Rd.	\N	College Station	73	77840	E6100000010CAD7D7036549A3E4076A27872911A58C0	49d7554e-852f-4d68-81b5-44c7a615f117	2012-06-30 00:00:00
609	3900 S. 997th St.	\N	Milwaukee	80	53202	E6100000010C086A94985A814540DFD8A8A8AFFA55C0	7394624a-5ca8-4adc-923c-235d971514b8	2011-08-01 00:00:00
610	44025 W. Empire	\N	Denby	68	57716	E6100000010C3BED293A0B91454054221589E48459C0	8afb400f-1fe5-460d-bc56-4a7bf801b41b	2013-07-31 00:00:00
611	23025 S.W. Military Rd.	\N	San Antonio	73	78204	E6100000010CEDE5615B376C3D40D037A4EAF5A458C0	76ed2669-d8a8-4468-943d-7319a9b18fe3	2011-07-01 00:00:00
612	Ring Plaza	\N	Norridge	24	60706	E6100000010CE9FF4792C7F74440D0FCD69CD0FB55C0	60ab96a4-26f6-439c-9f32-238bd16b293f	2012-07-31 00:00:00
613	Lakeline Mall	\N	Cedar Park	73	78613	E6100000010C08E969C8EB753E40D186357A367558C0	d26f02d6-326a-4088-b9ee-d441dfdfa1df	2012-07-31 00:00:00
614	Town East Center	\N	Mesquite	73	75149	E6100000010C59417F2B686340407DCAAC499E2758C0	7ba1af96-5a8e-4259-835c-da67db296a5e	2012-07-31 00:00:00
615	Fountains On The Lake	\N	Stafford	73	77477	E6100000010C3C654C183A9F3D408DA1F2E090DF57C0	bc2d6156-bcf7-47f7-a409-31122653f701	2011-05-31 00:00:00
616	Southwest Outlet	\N	Hillsboro	73	76645	E6100000010C53AF1A33D90440401A336F977B4158C0	47f987f7-44ff-4372-aaf5-4cc7b7f64216	2011-05-31 00:00:00
617	Johnson Creek	\N	Johnson Creek	80	53038	E6100000010CCB922696A590454037600A84BC2F56C0	aca53503-0920-446d-9c54-b83d7949d019	2013-04-30 00:00:00
618	Blue Ridge Mall	\N	Kansas City	37	64106	E6100000010CE119187734884340502D1DC9A6AA57C0	8612fbad-3ce1-435b-be0b-5a48ddbd2b62	2012-10-30 00:00:00
619	First Colony Mall	\N	Sugar Land	73	77478	E6100000010C9E612621E6A23D40429DA68B4BE557C0	da205e92-2867-48a9-bf18-4558a31272ae	2011-10-31 00:00:00
620	Horizon Outlet	\N	Woodbury	36	55125	E6100000010C314CFCF0B7724640A41EC9051A3457C0	70080b27-59bd-4ba1-84d2-68204b304d70	2011-08-01 00:00:00
621	Tanger Factory	\N	Branch	36	55056	E6100000010CD6150500C3C04640F237139CAE3D57C0	75d18db1-c9ef-4dad-bbd2-697ff73faf6c	2011-08-01 00:00:00
622	Management Mall	\N	San Antonio	73	78204	E6100000010C72DF4249AB5E3D40D037A4EAF5A458C0	e82d1276-e19a-4fad-90f5-7e19af94ea64	2012-01-29 00:00:00
623	Ohms Road	\N	Houston	73	77003	E6100000010CDA6EE882ECCA3D40397973625FCD57C0	d4688e5c-2d2d-4925-b58a-356c117728d8	2013-05-30 00:00:00
624	Factory Merchants	\N	Branson	37	65616	E6100000010C6BE528ADAE544240CEF364EB145857C0	dc707744-912b-4e7a-945a-1b959168dc94	2012-12-31 00:00:00
625	Cedar Creek Stores	\N	Mosinee	80	54455	E6100000010C5BEE4F63ED6B4640B1DB7587576556C0	2e6e124e-bb43-4d40-8515-82dda7994bd4	2013-06-30 00:00:00
626	Lone Star Factory	\N	La Marque	73	77568	E6100000010C9A8319CAF85C3D40C290787EE0C757C0	5f33b654-e091-4b2f-b5bd-ac5ac6d47ee6	2013-06-30 00:00:00
627	Sports Stores @ Tuscola	\N	Tuscola	24	61953	E6100000010C60AF750553E04340A955887A271656C0	808efdc0-ea1b-437d-88c0-a3b6a8864b7f	2012-05-30 00:00:00
628	City Center	\N	Minneapolis	36	55402	E6100000010C9E47E9C26F75464088D56D21704E57C0	b80975d1-ab6e-42f1-b328-5db1d445e2c9	2011-07-01 00:00:00
629	St. Louis Marketplace	\N	Saint Louis	37	63103	E6100000010CF48E40D3C64A4340BD0A527BA78856C0	163fde0a-2148-44bc-9fc1-a7390650127c	2011-05-31 00:00:00
630	Lincoln Square	\N	Arlington	73	76010	E6100000010C40866E66E9604040497A9F03DE4F58C0	734de48f-7f95-4386-986e-f8ab86c194a0	2011-08-01 00:00:00
631	Kansas City Factory Outlet	\N	Odessa	37	64076	E6100000010CCF5ABD36E080434043FF2B89CD7A57C0	bcd46b97-395d-4eef-a712-245ba629621f	2011-05-31 00:00:00
632	Fiesta Trail Shopping Center	\N	San Antonio	73	78204	E6100000010CFAEBE4EEE75A3D40146D44248CA058C0	f79532d7-38e9-42ec-8ea4-c9d7e1c13c12	2011-05-31 00:00:00
633	Medford Outlet Center	\N	Medford	36	55049	E6100000010C31392BB0FB17464097B58DE87B4757C0	7cda3069-3b49-4205-b853-40744d7d875f	2012-06-30 00:00:00
634	Ward Parkway Center	\N	Kansas City	37	64106	E6100000010C9A41AA51B48743402CF20CA077AC57C0	3f2aa425-7d02-461a-a9c4-222ae41e3fe5	2012-07-31 00:00:00
635	93-2501, Blackfriars Road,	\N	London	14	SE1 8HL	E6100000010CDA3EEA36ECBC494031028FC542C9BABF	00e75f99-488c-462d-a0bc-ac3c08a9db77	2012-07-31 00:00:00
636	Science Park South, Birchwood	Stanford House	Warrington	14	WA3 7BH	E6100000010CDF0729F796BE4A40207CB352C53904C0	c0fc2d5b-88e7-4b60-8447-bb3522bd79e5	2013-05-30 00:00:00
637	Phoenix Way, Cirencester	\N	Gloucestershire	14	GL7 1RY	E6100000010CC0E3D7DA75DC4940CCC266534C8AFFBF	10a3d496-881e-4042-bbd0-5802cf73a872	2013-07-31 00:00:00
638	255 Irving Street	\N	London	14	C2H 7AU	E6100000010C23CA436B45BF49402EC7DB156D6AC0BF	d8a77424-94ae-43ab-a011-1a9ebb3852e7	2013-06-30 00:00:00
639	Garamonde Drive, Wymbush	PO Box 4023	Milton Keynes	14	MK8 8ZD	E6100000010C8EF10B5C14004A4063305E87BE51E7BF	8f34cedd-fb6e-4814-b509-9965a31bc2e5	2013-07-31 00:00:00
640	251 The Metro Center	\N	Wokingham	14	RG41 1QW	E6100000010CCC84E69C7FB34940C99B31B3D22BEBBF	0e4ac5bb-be0d-4a96-a58e-064daec08e1a	2013-07-31 00:00:00
641	Bradford	\N	W. York	14	BD1 4SJ	E6100000010CA9E76F98D0E64A402D5C090F1FFFFBBF	f7b99541-1ce1-4ab6-ae0d-548e8ff4abcd	2012-06-30 00:00:00
642	Galashiels	\N	Liverpool	14	L4 4HB	E6100000010CB91EA40127B14A40E9781CC312CA07C0	3593cdf3-38ec-4847-ad42-157220e68f32	2013-07-31 00:00:00
643	Banbury	\N	Oxon	14	OX16 8RS	E6100000010C00000000000000000000000000000000	99ff4c64-b405-4ac1-85ed-49e4e60ef87f	2012-07-31 00:00:00
644	Bradford	Raven House, Kingsgate	W. York	14	BD1 4SJ	E6100000010CE7E14B3331E84A40381E6D952A09FCBF	65684e2e-d39c-4ef7-80d8-86c2f576c3c2	2013-06-30 00:00:00
645	Garamonde Drive, Wymbush	P.O. Box 803	Milton Keynes	14	MK8 8ZD	E6100000010C62F2142366094A4017058B1FCD48E7BF	6ef999e7-5510-4b02-b89e-ddcf51ae3864	2013-05-30 00:00:00
646	Butterfield Hse, 7-251 Chapel St	\N	Lancaster	14	LA1 1LN	E6100000010C981B22B679054B4061297062C36606C0	bce1f4b3-a9c0-413e-ac8d-4c07a960e26c	2012-06-30 00:00:00
647	Wade Road	\N	Basingstoke Hants	14	RG24 8PL	E6100000010C44D8096D80994940E109E7D69E10F1BF	578c2529-f11c-4bf3-8084-6b505461e1cc	2013-05-30 00:00:00
648	586 Fulham Road,	\N	London	14	SW6 SBY	E6100000010CEA83C3052EBC49401B40D54C6B4AC9BF	0da65673-2a35-4e6a-a607-a6cc2d134ea8	2013-06-30 00:00:00
649	Knaves Beech Ind.	\N	High Wycombe	14	HP10 9QY	E6100000010C04D93FDB3FC84940D36F4D779F3AE6BF	11fcff74-5c80-4b37-a842-45c765d96029	2013-07-31 00:00:00
650	Elmhurst Road, Goring	\N	Reading	14	RG7 5H7	E6100000010C3FA9EA9B69B74940455815FF85D2EEBF	e4c0c239-182f-45b7-a6bb-b7e142ff0657	2012-05-30 00:00:00
651	New Millhouse, 2583 Milton Park	\N	Abingdon	14	OX14 4SE	E6100000010CA30E22D348C74940997460FF5E81F4BF	e844b847-b0b3-491d-a4f1-0b78f56e4424	2013-07-31 00:00:00
652	Wymbush	\N	Milton Keynes	14	MK8 8DF	E6100000010CB313FA52BC0C4A40C66B4969957EE9BF	54e20963-b0e9-41cf-ab7e-d50459a3325c	2012-07-31 00:00:00
653	Burgess Hill	Edward Way	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	38cc8647-b4bb-4669-b21d-c7497e76478d	2012-07-31 00:00:00
654	308-3250 Casting Road	\N	York	14	Y024 1GF	E6100000010C2E99193B6EF24A406C844826A654F1BF	9d67c322-8698-440a-8f3e-5e1e30edbd0d	2013-06-30 00:00:00
655	Wharfdale Road	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	d0e03fcb-116e-4ad2-8b17-5c2f9fd3e8b0	2012-06-30 00:00:00
656	7 Pioneer Business Park	\N	York	14	Y03 4TN	E6100000010CEC04E0C7FCFF4A4041BD09E628A8F1BF	48865e15-033a-40ff-8327-18723d4a8846	2013-06-30 00:00:00
657	Unit 99a Battery Retail Pk	\N	Birmingham	14	B29 6SL	E6100000010C83B7681D852D4A4060DDAEA2EE14FFBF	371a70e0-5802-4df9-bb28-5b6bdf202283	2012-06-30 00:00:00
658	Ellesfield Ave	\N	Bracknell	14	RG12 8TB	E6100000010C58EAB630A3B5494085EF597020C7E8BF	bc28152f-8005-4c0e-98ff-51bf77a4a667	2012-06-30 00:00:00
659	Warrington Ldc Unit 25/2	\N	Woolston	14	WA1 4SY	E6100000010C66A9BB7260AB4A401ECAA8F1972C04C0	f44a7d0d-9bc5-427e-b3ae-f638dd5804b0	2013-07-31 00:00:00
660	6 The Farm, Liberty Road	\N	Maidenhead	14	SL67RJ	E6100000010C07ECD3E766BF494045B5B83BB17EE7BF	e22d616b-ea06-48e9-a00f-b1c4bb02f595	2013-07-31 00:00:00
661	725a The Arches	\N	Berks	14	SL4 1RH	E6100000010C48ED4E9627BB49409135C8A72D84E3BF	38f5f598-e9bb-499c-b90d-088b2cd1b5bd	2012-06-30 00:00:00
662	Paramount House	\N	London	14	W1N 9FA	E6100000010C0BB896C32BBE4940C4CFCC87D142C0BF	e50d1077-d135-41cc-a0b1-c53395f94541	2012-07-31 00:00:00
663	2524 Barlby Road	\N	London	14	W10 6BL	E6100000010C4D6BE5061EBB4940E0E81CFFFDD0CBBF	d8e96eba-258c-4f6c-83bb-4ccb2235bbf7	2013-06-30 00:00:00
664	99-3 Forest Works	\N	London	14	E17 6JF	E6100000010CB3A9F0BCDBD14940DF90BA0228D8A5BF	eb46af5a-ec2b-41ff-914e-ddae8ec1f476	2012-05-30 00:00:00
665	46-44 Albemarle Street	\N	London	14	W1X3SE	E6100000010C293388946ABC49402DCEE5B3F70DC2BF	1b01b172-96ce-4601-ad19-f545dcdfd62f	2013-06-30 00:00:00
666	399 Clearing Green	\N	London	14	EC1R 0DU	E6100000010C8C39A29586C949403CC37F9C7C20BBBF	bab4b0a1-055a-4581-a93f-e00c65c54fb6	2012-06-30 00:00:00
667	997b Tradescant Road	\N	London	14	SW8 1XD	E6100000010C938EE7ED3FB5494066B2F0AB2497BFBF	0a318015-4fbe-479a-b2da-eee21df430af	2012-06-30 00:00:00
668	2574 Milton Park	\N	Oxford	14	OX14 4SE	E6100000010CF33F629284D24940F5F948AD457FF4BF	62d0c689-cf44-4ab3-9c3e-6142f4e0101c	2013-06-30 00:00:00
669	Internet House, 3399 Science Park	\N	Cambridge	14	CB4 4BZ	E6100000010CFD3E660C00124A406D98B1B59A6ABC3F	56baec2a-5cc5-4a90-bef9-ee57e82f2e69	2012-10-30 00:00:00
670	7 Garden House Cloisters, 8 Batters	\N	London	14	SW8 4BG	E6100000010C50D8CDEE32B74940957297F487BDC2BF	333daff8-f22f-488c-928c-e6eccf65452b	2012-05-30 00:00:00
671	25 Hartfield Road, Wimbledon	\N	London	14	SW19 3RU	E6100000010CA3AB705D58BE49407375A6963E84CABF	00fd96bc-6ee6-4d2c-a88c-07bc1cae6efe	2013-12-31 00:00:00
672	99 Dean Street, Soho	\N	London	14	W1V 5RN	E6100000010CB8FADFBA09CA4940E818FBD72646C0BF	ecebd4b1-11c3-4681-a6da-2f73148fb63e	2012-07-31 00:00:00
673	Park House-4th Floor, 2516 Park St.	\N	London	14	W1Y 3RA	E6100000010C04773FF460C94940F218AA8B5140C0BF	2506679e-041b-4d52-b9a9-07a0d5e88eea	2012-06-30 00:00:00
674	67 Vincent Square, Victoria	\N	London	14	SW1P 2NU	E6100000010C66F58EE400C94940AFDAD5A91B91C1BF	1a398c1b-2085-4f6d-a6eb-56493855c5d1	2013-07-31 00:00:00
675	7033, rue de Longchamp	\N	Les Ulis	177	91940	E6100000010C20575233F95B4840AFB0837C38540140	052b7d72-ab05-4a78-8b3b-4cf25e6eec70	2013-12-21 10:09:29.423
676	21105, rue de Varenne	\N	Paris	161	75013	E6100000010C1E3FBF66F26B48404227EF0631980240	5964df6a-c654-4ddc-af09-e98deb96d3f7	2013-12-21 10:09:29.423
677	69, boulevard Tremblay	\N	Roncq	145	59223	E6100000010C11B64B69CD594940852025AF0DEC0840	640c449b-8de4-48d1-9c3e-13f4a151d584	2013-12-21 10:09:29.423
678	12, rue des Grands Champs	\N	Verrieres Le Buisson	177	91370	E6100000010CECBC3F27105B4840174D1754D1050240	4874cc07-5792-4996-a2c8-76c565fa0157	2013-12-21 10:09:29.423
679	121, rue de Varenne	\N	Courbevoie	178	92400	E6100000010C5A9E2FFB207B48403421972801050240	79f2b0e2-2e99-4c31-b104-6b9ec56487dd	2013-12-21 10:09:29.423
680	22, rue du Départ	\N	Pantin	179	93500	E6100000010C70D8A19881754840743C904E95450340	8342b42b-97a8-4221-a102-bf39f9193818	2013-12-21 10:09:29.423
681	6, rue des Pyrenees	\N	Saint Ouen	127	41100	E6100000010C74FC8DB1D4ED4740BB0EC07E1759F13F	a65472ae-c316-43cc-8798-80a775f9c3f5	2013-12-21 10:09:29.423
682	5, place de la Concorde	\N	Colombes	178	92700	E6100000010C7D0616567A7548400E690BD7F4F80140	cf7909c6-b930-4bda-88fe-2a26391e9095	2013-12-21 10:09:29.423
683	36, avenue de la Gare	\N	Paris	161	75019	E6100000010C341672AA0C7948406C72AE983E0E0340	047e3869-cdbb-45bc-bf6a-7e1b1760307e	2013-12-21 10:09:29.423
684	26, rue Saint Denis	\N	Orleans	131	45000	E6100000010C0287A08EF8F647409244661045DDFE3F	d6acbfa9-ff74-4dcd-ac29-8b0d03e4dea6	2013-12-21 10:09:29.423
685	68081, place du Tertre	\N	Colomiers	117	31770	E6100000010C9F64447067CF45400B2CF676193EF53F	26cf7d61-8130-49dd-9a55-a2e2ab0b622a	2013-12-21 10:09:29.423
686	98, rue de Terre Neuve	\N	Lieusaint	163	77127	E6100000010CCED3BB4D275548408D345F46A0690440	f9a291d1-38f7-4e01-a41f-0621c84c41e2	2013-12-21 10:09:29.423
687	21801, rue Léo Delibes	\N	Colombes	178	92700	E6100000010C14BA7BDB777048408DDF33B0B7FB0140	3edd768f-ab44-463f-a91a-ebd5fe63fe81	2013-12-21 10:09:29.423
688	2111, rue de Linois	\N	Orly	180	94310	E6100000010C2C6A75EAD65D48408C0895D7B5290340	0c24e975-94cb-4a0d-81c9-05bf53151f36	2013-12-21 10:09:29.423
689	39, route de Marseille	\N	Paris	161	75016	E6100000010CC6AF77CB64754840FD118189D50A0240	2ebe23df-c98a-406b-864c-b6b702b518a8	2013-12-21 10:09:29.423
690	57, rue des Vendangeurs	\N	Roissy en Brie	163	77680	E6100000010C0141D63F5861484074C237016F4D0540	73e19c1f-23f6-4ff9-a2f3-7322b7566783	2013-12-21 10:09:29.423
691	98, rue Montcalm	\N	Paris	161	75019	E6100000010C5420214FC46C48409A270BC2A7B80240	613b3119-88c9-4ba3-abf7-8f28cd03b715	2013-12-21 10:09:29.423
692	3387, rue Marbeuf	\N	Bobigny	179	93000	E6100000010C1A6679ABCA7948406BECD8D4E3860340	f0650815-da7e-4870-8cc6-d1eff364968f	2013-12-21 10:09:29.423
693	39, avenue des Laurentides	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	c2de0595-46ee-4491-b687-b0300784a186	2013-12-21 10:09:29.423
694	3101, avenue de Malakoff	\N	Paris	161	75003	E6100000010C30B53A84267548402A63C2A8FA440240	df71b16e-de94-4b3d-9c2b-6b775d0636ee	2013-12-21 10:09:29.423
695	61, rue Henri Gagnon	\N	Les Ulis	177	91940	E6100000010C8421492FB65F48407DC786B6FC590140	ec012663-981f-4ff6-a764-ac02d38d1dda	2013-12-21 10:09:29.423
696	9005, rue des Bouchers	\N	Paris	161	75005	E6100000010CA8826D09F66D48401A2FCAFBFDD40240	0f35e0cd-11b1-43ca-9267-86f0eb8713ad	2013-12-21 10:09:29.423
697	18, rue de l´Esplanade	\N	Aujan Mournede	118	32300	E6100000010C055077EFE2BD4540634EE821CF12DC3F	66a9a7ae-b8d1-44e3-bf35-bbeefb7bd751	2013-12-21 10:09:29.423
698	7551, avenue Foch	\N	Paris	161	75010	E6100000010CFD5F9B416765484038383A35F7890340	b1e85633-08c8-4c17-b207-e1e8672acaee	2013-12-21 10:09:29.423
699	22, rue Lafayette	\N	Pantin	179	93500	E6100000010C9E7BA3379D69484060A6230E814B0340	979f4d35-4dc4-4e15-a1d6-ebedd0811f0b	2013-12-21 10:09:29.423
700	215, avenue Reille	\N	Les Ulis	177	91940	E6100000010C2355F5AF165F48404796E225914D0140	a7003679-b499-4a76-958a-89c0c8bcfa27	2013-12-21 10:09:29.423
701	54, avenue des Ternes	\N	Saint Ouen	127	41100	E6100000010CF15EAD4F71EE4740673BCA913460F13F	5b88b6f3-dde7-444c-9223-00bc53b8df0d	2013-12-21 10:09:29.423
702	510, avenue de Villiers	\N	Orleans	131	45000	E6100000010C0775C6529AF44740108C3D278096FE3F	6fc66b89-238a-4eca-923e-4e586088244a	2013-12-21 10:09:29.423
703	30, avenue de l´ Union Centrale	\N	Les Ulis	177	91940	E6100000010C8421492FB65F4840819BCFD0E54E0140	d2b6ec7e-c106-4f45-824b-aa18b3b5beea	2013-12-21 10:09:29.423
704	33, rue Georges-Clémenceau	\N	Cergy	181	95000	E6100000010C7DFC0CDD80804840EC2912D962850040	9de1ef92-20b7-48a1-8028-d74667f8719c	2013-12-21 10:09:29.423
705	699bis, rue des Peupliers	\N	Paris	161	75008	E6100000010CBD44F4E2BB604840C77503371BD70240	4a40f30c-51cd-4208-9f8c-02a11b2439d6	2013-12-21 10:09:29.423
706	3639, rue des Grands Champs	\N	Boulogne-sur-Mer	148	62200	E6100000010C9F738A211F664940B3E3451CA8B7F93F	4fb34af0-b6a8-4991-b9a9-55b58579435e	2013-12-21 10:09:29.423
707	3833, boulevard Beau Marchais	\N	Paris	161	75009	E6100000010CC2A97086426B4840DACB3BD7B9AF0240	377974f6-d307-42f9-b657-8685f38cf104	2013-12-21 10:09:29.423
708	1, place de la République	\N	Paris	161	75017	E6100000010C48FA7D53AA7248403214FDD423EB0240	521dd524-70e5-4330-a2f3-e5665cb1cf67	2013-12-21 10:09:29.423
709	12, rue Lafayette	\N	Morangis	177	91420	E6100000010C23F7520B725C4840719A76D2B7B40240	983552bd-c89f-46f1-989f-002a161fd687	2013-12-21 10:09:29.423
710	88, avenue de l´ Union Centrale	\N	Paris	161	75012	E6100000010C4BF382AE407448400415C84C6E590340	765c246c-a31a-4b4a-9219-ada7db25e47b	2013-12-21 10:09:29.423
711	3383, rue Lamarck	\N	Paris	161	75007	E6100000010C069ACAEF62794840411B2A8B91BC0240	a510a220-7abc-4b57-97bf-bfbdc6ae7d89	2013-12-21 10:09:29.423
712	28, avenue des Champs-Elysées	\N	Croix	145	59170	E6100000010C9C402717995549402059CF73D4340940	1f334496-e920-4d81-bf03-4b10c79b6a93	2013-12-21 10:09:29.423
713	21, avenue de la Gare	\N	Sèvres	178	92310	E6100000010C386FF08CF26A48405A75E43B59AF0140	a427d0cc-3cc6-4702-ba43-f35106ed5c28	2013-12-21 10:09:29.423
714	62, route de Marseille	\N	Suresnes	178	92150	E6100000010C6584AE6F7B68484058F5174172C40140	688be726-33c1-4148-b9d9-8271147b52a6	2013-12-21 10:09:29.423
715	Karl Liebknecht str 299	\N	Frankfurt am Main	70	60075	E6100000010C00000000000000000000000000000000	0d676aa0-f9d8-40a4-934c-dc3f092ab2d2	2013-07-31 00:00:00
716	Roßstr 2248	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	326385ae-865b-4db0-bb12-7146abd74da4	2013-06-30 00:00:00
717	Bundesallee 9571	Rechnungsstelle - C 035	Berlin	85	14197	E6100000010CF6DFE07B43434A40D156C46595972A40	516ca9d3-e4d9-42b4-8f71-1f1db32e140d	2013-08-30 00:00:00
718	Auf Der Steige 29	\N	Muehlheim	20	63151	E6100000010C00000000000000000000000000000000	7253872e-25b7-4405-a5c7-ff6010bf97df	2013-06-30 00:00:00
719	Hellweg 4934	\N	Essen	20	45001	E6100000010CD2D2A991DBC2494046B2FE26A6551C40	ad1d792b-0958-4730-ae14-795d6e78351f	2013-05-30 00:00:00
720	Kurfürstenstr 9	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	48c19b74-55dc-4116-b464-cb1f5c873196	2013-07-31 00:00:00
721	Postfach 11 09 00	\N	Berlin	19	14111	E6100000010C00000000000000000000000000000000	cf10d5aa-5bcc-4e22-a983-d8f1160bebfd	2013-07-31 00:00:00
722	Haberstr 29	\N	Bonn	20	53131	E6100000010C0CE378D025554940F18DF26C5D2C1C40	dc577387-7b12-4d08-a4fb-d2856f653b41	2012-05-30 00:00:00
723	Auf der Krone 53	\N	Bonn	53	53131	E6100000010C899F46BE30594940E413481FDE701C40	2689b36d-bc77-41ff-8b63-662f6ab1f253	2012-06-30 00:00:00
724	Winterfeldtstr 5557	Kreditorenbuchhaltung	Münster	70	48001	E6100000010C00000000000000000000000000000000	1c11586b-2fe5-4f83-aa6f-47fad4e6afee	2013-07-31 00:00:00
725	Alte Landstr 776	\N	München	20	80074	E6100000010C00000000000000000000000000000000	1a0c711f-5c49-4ac1-90da-2c3ef1d80c02	2013-06-30 00:00:00
726	Kurfürstenstr 574	\N	München	19	80074	E6100000010C7BF907AFC4184840328312D748222740	b80edac6-7658-4e4e-8319-c484a97dab56	2013-07-31 00:00:00
727	Königsteiner Straße 9	\N	Bad Soden	19	65800	E6100000010C08E34468920C4940E20858F4C0072140	28eee379-560f-4c02-9258-b7d7a36a91f3	2013-06-30 00:00:00
728	Werftstr 4400	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	d7b3a4f3-c400-4f3c-8017-f4ab40505756	2013-08-30 00:00:00
729	Hans-Rosenthal-Platz 4223	\N	Grevenbroich	8	41485	E6100000010C00000000000000000000000000000000	05863153-6870-4d19-b201-5d24ef261eb6	2013-06-30 00:00:00
730	Nonnendamm 63	\N	Berlin	53	14197	E6100000010CB62E2CC3BF404A40AD15848316832A40	e24ad592-7a61-4ef1-9739-bb001646f2fd	2013-07-31 00:00:00
731	Berliner Platz 45	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	3df8e408-6dee-4610-9184-6a9a2718749f	2013-05-30 00:00:00
732	Brunnenstr 422	\N	Frankfurt am Main	20	60082	E6100000010C18013E0D3A034940CD7A4B3561792140	504016f6-c53b-4749-99f3-36913a55e7a7	2013-05-30 00:00:00
733	Rotthäuser Weg 511	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	f7252b89-f4b0-45b0-944c-ec9cba370e72	2013-07-31 00:00:00
734	Am Karlshof 8200	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	602788d5-9f1e-4817-9b2e-5a31bf1a710e	2012-05-30 00:00:00
735	Holzstr 6444	\N	Salzgitter	19	38231	E6100000010C00000000000000000000000000000000	e91bf8f1-1707-4295-a556-9778207130e9	2013-07-31 00:00:00
736	Am Grossen Dern 982	\N	Hamburg	20	20354	E6100000010CBB6270920BCD4A4036064463EEFD2340	ab628f86-4f66-4ba4-b3fd-37bdc5478d4f	2013-05-30 00:00:00
737	Conesweg 49	\N	Kiel	70	24044	E6100000010C00000000000000000000000000000000	54d6a33f-9a4c-4c8e-9aaf-28dca5348900	2013-06-30 00:00:00
738	Krönerweg 9249	\N	Hannover	53	30601	E6100000010C00000000000000000000000000000000	03a6179f-3cd9-4dc4-aec9-d16430456a25	2013-07-31 00:00:00
739	Auf Der Steige 1000	\N	Berlin	20	14111	E6100000010C00000000000000000000000000000000	49ef5e23-bb43-4888-832c-cbed8fcf9f0b	2013-06-30 00:00:00
740	Wallstr 244	\N	Saarbrücken	70	66001	E6100000010C515FB6CC849F4840DF4F0403D1061C40	a33afdef-51b8-4f3e-bc57-92c00b70074c	2013-07-31 00:00:00
741	Roßstr 9938	Verkaufsabteilung	Eilenburg	85	04838	E6100000010C88C661A552C149408A7334C77D542940	3d26058c-6a4b-40e1-a826-4dcf058a7f28	2013-05-30 00:00:00
742	Pappelallee 19	\N	Dresden	19	01071	E6100000010C00000000000000000000000000000000	3d692ac6-eeeb-437b-b9fe-a592eb161260	2012-07-31 00:00:00
743	Karl Liebknecht str 399	Leiter der Abteilung	Berlin	19	14111	E6100000010C00000000000000000000000000000000	2b49e000-8a79-4996-be90-a960c9935d06	2013-10-30 00:00:00
744	Brunnenstr 9511	\N	Berlin	70	14197	E6100000010C04954D86153D4A40A595B61179CC2A40	7f600594-a6f6-4b92-8d4b-74c1bb0b166c	2013-07-31 00:00:00
745	Knaackstr 7	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	954fcabe-4e8c-4def-af3d-0e8e044f37e4	2013-06-30 00:00:00
746	Alderstr 1849	\N	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	6e11e024-fc2a-4f11-b582-6295fa8c3b4a	2013-05-30 00:00:00
747	Kurfürstenstr 74	\N	Poing	70	66041	E6100000010C00000000000000000000000000000000	f7d6ab55-2f4f-4f11-a9f4-a8c5fcbd4b05	2013-05-30 00:00:00
748	Königsteiner Straße 449	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	73f13b53-24ee-4647-8fcd-8d4ffec02235	2013-06-30 00:00:00
749	Buergermeister-ulrich-str 3000	Buchhaltung	Augsburg	8	86150	E6100000010C583255CA31344840D1FA4C10B7C82540	7ae0617b-717d-466c-8c64-46aa3b21cab2	2013-07-31 00:00:00
750	Postfach 55 00 00	\N	Frankfurt	8	91480	E6100000010C83EE92EF8CD248406064117096162540	e8d5700c-a722-4d67-9ac0-caf2ec6c019a	2013-05-30 00:00:00
751	Helsenbergbogen 6	\N	Ascheim	20	86171	E6100000010C00000000000000000000000000000000	025d5b50-6f16-428a-8999-2d07413e8ef1	2013-06-30 00:00:00
752	Buergermeister-ulrich-str 9500	\N	Augsburg	20	86171	E6100000010C00000000000000000000000000000000	6b2aa06b-dd76-4a86-a637-0efe4d066ae3	2013-06-30 00:00:00
753	Erftplatz 22	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	275df185-8920-48d8-a434-0bc105678369	2013-06-30 00:00:00
754	Viktoria-Luise-Platz 475	\N	München	53	80074	E6100000010C00000000000000000000000000000000	e38ce484-ccf7-42bb-a5d6-690b2faf8846	2013-06-30 00:00:00
755	9920 Picketts Line Road	\N	Newport News	75	23607	E6100000010CDECAACE6569842401D0DEE42C21F53C0	b143c876-1461-4cd6-aa26-07e30ab6787f	2011-05-31 00:00:00
756	855 East Main Avenue	\N	Zeeland	35	49464	E6100000010C42D725F64E60454037C31168948355C0	7cc420b7-b43c-4e40-98ed-6c10cec91c54	2011-07-01 00:00:00
757	2532 Fairgrounds Road	\N	West Kingston	65	02892	E6100000010C61232339C0C14440BEBC91358EE351C0	3a55e848-b10e-4cc4-9e5f-d20be0ea650d	2013-05-30 00:00:00
758	6900 William Richardson Ct.	\N	South Bend	25	46601	E6100000010C4B4D6D545CE2444041E0EC71F48D55C0	4b243132-3e76-478f-972e-ddd813404423	2011-07-01 00:00:00
759	99 Edgewater Drive	\N	Norwood	30	02062	E6100000010C9B35145994134540950FB574FBC751C0	6ac61d51-9179-4866-a397-eef974f60cb1	2013-07-31 00:00:00
760	Attn: Accounts Payable	44 Main Place	Melville	54	11747	E6100000010CE8C3FD41856644409E27CA72B25552C0	a184be58-0e1d-4022-ba9b-7e30e41860bb	2011-08-01 00:00:00
761	225 Hyde Rd	\N	Farmington	11	06032	E6100000010C90CD0AE185E044407D4C0501C93B52C0	73e14c8f-86ab-420c-baaa-de965946f79e	2013-06-30 00:00:00
762	6 Cotton Road	\N	Nashua	46	03064	E6100000010C89FB3ABA525E454045AB5318CDE251C0	3109472c-d076-4c5e-820c-ba592408be8f	2012-07-31 00:00:00
763	5998 E Lorain	\N	Oberlin	55	44074	E6100000010C0027A7678CAD4440E3020C2C979154C0	2015b82d-d8da-4320-99bc-b13d47235348	2012-06-30 00:00:00
764	Corporate Ofc A/p	123 Fourth Ave	Chantilly	75	20151	E6100000010CA3EA4F1C7276434008162169FA6353C0	2a1343c7-52c5-4487-9a65-a8d27df73672	2012-07-31 00:00:00
765	58 Teed Drive	\N	Randolph	30	02368	E6100000010C56CE17A1F61A454053FFC0FBA7BE51C0	64f8feca-be6e-4b56-b08e-0b07535a09fa	2011-07-01 00:00:00
766	63 Badgers Island West	\N	Kittery	33	03904	E6100000010CA8F2D7D2A586454001EE75B35FAF51C0	05fe719d-d454-4c1a-bde6-c5a674d93a39	2012-06-30 00:00:00
767	9963 Tresser Blvd.	\N	Stamford	11	06901	E6100000010C8531887BEB82444045D2C97A2D5C52C0	9c27c691-ece2-4a66-bc73-abb7ec5400da	2012-05-30 00:00:00
768	P.O. Box 9005	\N	Endicott	54	13760	E6100000010CA416AD50E20545400491459AF80753C0	3b35ecd1-0a60-49a7-bce9-c7ea83dbd21b	2011-10-31 00:00:00
769	Saltonstall Parkway	\N	East Haven	11	06512	E6100000010CDCD586FBD09F44406B91358E113E52C0	25b7eb6a-caf8-45e5-9a89-9dc8877b9a90	2011-08-01 00:00:00
770	123 Union Square South	\N	New York	54	10007	E6100000010CEF85DA7D4558444099FB5F7FFC8552C0	cec2ad79-89d2-43a7-ba8c-fb2b11bdc170	2011-07-01 00:00:00
771	42522 Northrupp	\N	Fort Wayne	25	46807	E6100000010C83C390334F8044409772840A4F5155C0	851c4fae-9d9b-4fc5-8c02-3f454ac4ed9a	2011-05-31 00:00:00
772	675 East Ave.	\N	Warwick	65	02889	E6100000010C1F331F72A4DB444018B450AE09DB51C0	748e4869-44f2-4f85-812e-d2669156910f	2011-10-01 00:00:00
773	77993 Mentor Ave.	\N	Mentor	55	44060	E6100000010CC3D4DEFFF2D844408B901ACFAC5854C0	d85f173e-633e-46ba-8d8d-6c65396d641a	2013-07-31 00:00:00
774	9920 North Telegraph Rd.	\N	Pontiac	35	48342	E6100000010CAB823BB17E53454059033662A5D954C0	7bc77b2e-ed84-443a-bd50-f67718dea95d	2011-08-01 00:00:00
775	46460 West Oaks Drive	\N	Novi	35	48375	E6100000010CA570908D823945403D649BAD71D854C0	d0614a62-08e0-4f83-ac72-51f58170b653	2012-07-31 00:00:00
776	997000 Telegraph Rd.	\N	Southfield	35	48034	E6100000010C6A0088E0C643454001E6734558D354C0	f0159341-8cdb-4587-bc74-95ffb9e7d662	2011-10-01 00:00:00
777	25850 Post Road	\N	Westport	11	06880	E6100000010C58A220B2FC904440335EC8C78D5D52C0	5e1b60ba-83b6-4f8a-bb44-6b22e989ed25	2011-08-31 00:00:00
778	9975 Union St.	\N	Waterbury	11	06710	E6100000010C90A592F014C0444033F9EDE0274252C0	38bd6640-3a4b-4966-8d15-6c8eba063400	2011-08-01 00:00:00
779	7505 Commercial Dr.	\N	New Hartford	54	13413	E6100000010C9E4B1C4EEE924540A839B55DDADB52C0	06ff4c5a-5027-400e-9ce9-de60c1d5a61b	2012-06-30 00:00:00
780	89950 Castleton Corner	\N	Indianapolis	25	46204	E6100000010C500047D926F243406B0D230CE38555C0	a172a445-427f-4e6c-a2b4-1368e9d41dc3	2012-05-30 00:00:00
781	99200 Dixwell Ave.	\N	Hamden	11	06518	E6100000010C6F0F475B3DB54440BE0A0351713F52C0	6aa2aa5e-5eec-4c33-a266-81dd88289a6d	2013-06-30 00:00:00
782	630 Oldgate Lane	\N	Milford	11	06460	E6100000010C9339CC4DBB964440DCDB76E6504052C0	6965b855-f95c-4c78-847d-df52bc211cf8	2011-08-31 00:00:00
783	25264 E. 260th	\N	Euclid	55	44119	E6100000010C9700C74CF1C54440AB2180BCFD5C54C0	5a5a7901-e353-4fe2-b385-e559ed273db1	2011-05-31 00:00:00
784	225200 Miles Ave.	\N	North Randall	55	44128	E6100000010C05D2B321E2B54440EC347254D55E54C0	96c48808-811d-4450-a166-2be3be7c2fdf	2011-07-01 00:00:00
785	399700 John R. Rd.	\N	Madison Heights	35	48071	E6100000010C401042DA13474540792BCF2AA9C354C0	7b234147-cd95-45e8-a1d5-711fe6a33dac	2011-07-01 00:00:00
786	6789 Warren Road	\N	Westland	35	48185	E6100000010CBFBF8D3C902B4540E07D6269E5D254C0	90b0cf86-70e1-45d8-b6fd-0e1804a734c2	2012-10-30 00:00:00
787	42500 South Franklin Street	\N	Michigan City	25	46360	E6100000010C33B2C78717D54440D2A5160565BC55C0	5a400073-5ee4-4c94-bd37-213026441e4b	2013-05-30 00:00:00
788	2533 Eureka Rd.	\N	Southgate	35	48195	E6100000010C0B1474E00B13454079CCE47DF2C954C0	7ef698fa-908e-42bb-8a2d-c62f5106323a	2012-07-31 00:00:00
789	250000 Eight Mile Road	\N	Detroit	35	48226	E6100000010C3E38AA1A82234540E206C1EFD6C654C0	66255753-b1b9-49c0-ab1d-1de8217d5142	2012-06-30 00:00:00
790	6405 Erie Blvd. Hills Plaza	\N	De Witt	54	13214	E6100000010C05F5931F798845405B58423D010A53C0	3d4337e6-bc3a-435d-9660-4dc681b20f20	2012-06-30 00:00:00
791	Great Northern Mall Hwy4 & Rt. 31	\N	Clay	54	13041	E6100000010C55BBA22E7CA145405C4612CAD30C53C0	373e90a8-5447-4d2b-89eb-3a0750ec7684	2012-07-31 00:00:00
792	250 E. County Line Rd.	\N	Indianapolis	25	46204	E6100000010C79E008F76FD34340AA10A13A6B8755C0	b8850148-8a3d-47c0-b7bd-7b8c7f9fa599	2011-07-01 00:00:00
793	6225 Glenway Ave.	\N	Cincinnati	55	45202	E6100000010C6D73637A229043409284EA8E182355C0	b8f8e86f-120d-4440-b284-e6c594c08924	2012-06-30 00:00:00
794	998 Forest Road	\N	Saginaw	35	48601	E6100000010C03A716C84EB345400C220E4915FF54C0	01094c1b-2d79-402d-8106-9e80fbd57dc8	2013-06-30 00:00:00
795	99800 Tittabawasee Rd.	\N	Saginaw	35	48601	E6100000010CA90440675FB245402F41F5BECEFC54C0	34d6d2d5-feec-40b8-97b5-cceb89164305	2012-06-30 00:00:00
796	25192 Princeton Rd.	\N	Springdale	55	45246	E6100000010C78E201B413A54340BEDA4313CE1A55C0	ae16485f-193b-4078-9435-f78364625f39	2013-06-30 00:00:00
797	678 Eastman Ave.	\N	Midland	35	48640	E6100000010C33DC2516BDCF454012E2467D7A0955C0	986de66f-74e6-4830-a2ad-9212efb77b76	2012-07-31 00:00:00
798	New Castle Plaza	\N	New Castle	25	47362	E6100000010CE80354C739F4434067144276FB5655C0	9084606d-ae76-4d2f-8685-5334cb744041	2012-06-30 00:00:00
799	Woodbury Commons	\N	Central Valley	54	10917	E6100000010CD10A044518A14440A6E68F19A08952C0	aafcd8d8-c0ce-4706-9b82-b1caaccc4f8f	2012-06-30 00:00:00
800	Indiana Factory Shops	\N	Daleville	25	47334	E6100000010C7AF4D3A1861044403623AEB0D16955C0	f48e6000-6190-4cab-be01-d433436fd581	2012-05-30 00:00:00
801	Horizon Outlet Center	\N	Holland	35	49423	E6100000010CB8D04B86A66545408D6E3555CE8755C0	dc15ba52-b66c-4c5f-bdaf-1713e8c54b46	2011-05-31 00:00:00
802	Washington Square Ii	\N	Indianapolis	25	46204	E6100000010CB04D1DF32EE843401DC3C5EB118655C0	24929526-597b-49c2-b5ae-7dff9b67c0b7	2011-07-01 00:00:00
803	Regency Hilltop Shopping Cntr	\N	Virginia Beach	75	23451	E6100000010C82375E0F81744240532E5532500053C0	c1b1cdba-1b94-445a-aeb6-f904106223e7	2012-06-30 00:00:00
804	Ames Plaza	\N	Saugus	30	01906	E6100000010C2909DF0AB7394540A0737F5995BA51C0	ca7868dd-0d16-4963-afdb-0980626a600e	2012-06-30 00:00:00
805	The Corner Shopping Center	\N	Falls Church	75	22046	E6100000010CAB283BCD026B4340424F2FE1F24F53C0	ad131e7d-820b-406c-ac02-4d8e43bdd03a	2013-10-30 00:00:00
806	Horizon Outlet Center	\N	Monroe	35	98272	E6100000010CFA16A3018DE24740E5DB36E5D86E5EC0	a986c31b-4b63-4925-aafd-b95260d5d586	2012-06-30 00:00:00
807	Leesburg Premium Outlet Centre	\N	Leesburg	75	20176	E6100000010CAD7FE3C237984340CDBADB63456553C0	54f6fa82-5762-4c27-b0fe-5a30e06c57b2	2011-05-31 00:00:00
808	Tree Plaza	\N	Braintree	30	02184	E6100000010C9383E673FF1F45407E9C85C04EBD51C0	aa3194ab-00cd-4959-90f8-bdde84be54a3	2011-05-31 00:00:00
809	Granite State Marketplace	\N	Hooksett	46	03106	E6100000010C2B2AFFB9348D45401E4A715A38DD51C0	a269f785-065e-40f1-ac78-63019070fd5e	2011-08-01 00:00:00
810	Redford Plaza	\N	Redford	35	48239	E6100000010C1EF2332098384540B1D167D96FCC54C0	43e988f4-b82d-4424-a59f-43dd81f9016b	2011-05-31 00:00:00
811	Walnut Hill Plaza	\N	Woonsocket	65	02895	E6100000010CDC8FD36FCEFE4440088EA34CE4E251C0	e9d3fa39-e1bc-437b-812e-f953319a620b	2013-06-30 00:00:00
812	Consumer Square	\N	Cheektowaga	54	14227	E6100000010C7062F4EEBB704540C3D259034CAA53C0	38790622-a0bc-4a81-bfce-e1b113c2bc81	2013-06-30 00:00:00
813	Adirondack Factory Outlet	\N	Lake George	54	12845	E6100000010C2B4DFBD513BA454087CD7EDC036852C0	2c491b06-b290-4b1c-85af-54750edd4be0	2013-07-31 00:00:00
814	Buckeye Factory Shops	\N	Burbank	55	44214	E6100000010C513C0CEF9A804440CC9C1537EF7854C0	0474cc61-17d1-451f-ad12-de16bf2d8eb0	2012-06-30 00:00:00
815	Wrentham Village	\N	Wrentham	30	02093	E6100000010CAF859A3AA8034540F600A45BB6D951C0	90aa8532-8956-4e3b-95a3-5b4f0455957e	2013-07-31 00:00:00
816	Lake Region Factory Outlet	\N	Tilton	46	03276	E6100000010C112E9E0C92B0454079C8B447BEE851C0	c1a76c6b-f358-4731-9214-ad74a6c6819e	2011-07-01 00:00:00
817	Cherry Grove Plaza	\N	Cincinnati	55	45202	E6100000010CE4BF048FD490434097FB7DE3191E55C0	65666ea2-d3e4-4a45-b61e-d500b63c7c09	2011-08-01 00:00:00
818	Johnny Appleseed Shop.center	\N	Mansfield	55	44903	E6100000010CEE8327A77B5F44404A86B6F9919A54C0	0f678ec5-be45-4cd1-b529-63d24a9705af	2011-08-01 00:00:00
819	Spring Meadows Place	\N	Holland	55	43528	E6100000010C7AEC0B56EFCE44408E76DAA69BF354C0	5a34e393-2622-4da0-bd94-2161bfd25cca	2013-09-30 00:00:00
820	Westside Plaza	\N	Nashua	46	03064	E6100000010C46A14B67B56445402DA0CF70ABDA51C0	227614f2-c18f-41a9-8b84-d8d76371c6fb	2012-05-30 00:00:00
821	Stateline Plaza	\N	Plaistow	46	03865	E6100000010C0DAFE4EE986F4540D6F6BC5C0EC451C0	e89c0bbf-369b-44ec-8643-aaf9392913bb	2011-05-31 00:00:00
822	Pyramid Mall	\N	Ithaca	54	14850	E6100000010CB1410417E83F4540874AD476A72453C0	3de89bd2-6a57-465f-9598-451582add8c1	2011-05-31 00:00:00
823	Logansport Mall	\N	Logansport	25	46947	E6100000010C8769A1C6B6614440CFE39D1D929155C0	aceeff3a-cb3f-407f-bbfc-e0a2b30657e6	2012-07-31 00:00:00
824	Dansk Square	\N	Kittery	33	03904	E6100000010C49BC38690B8D4540C13096D566B551C0	f720e7ab-46af-4e74-aae8-de217854994c	2012-06-30 00:00:00
825	Port Huron	\N	Port Huron	35	48060	E6100000010C21001822427A4540339B93A2EFA454C0	a1cadf47-c018-40cc-8381-6cc940de46c8	2011-08-31 00:00:00
826	Kensington Valley Shops	\N	Howell	35	48843	E6100000010C433A0877B75145403CFCC3A61F0155C0	c2d04d48-ef2b-4349-877b-ea6df9895079	2012-05-30 00:00:00
827	Polaris Town Center	\N	Columbus	55	43215	E6100000010CE75CF6E7E2FC434092163DFDB6C554C0	04595a6d-4825-4035-8e2e-3e9dd6c52911	2012-06-30 00:00:00
828	Green Acres Mall	\N	Valley Stream	54	11580	E6100000010C1FD3B7F1034E444047F4CD30CC6F52C0	bc852cf2-a05f-4973-bad1-c3a12b912c01	2012-06-30 00:00:00
829	Connecticut Post Mall	\N	Milford	11	06460	E6100000010C1DA7454B1B9B44403E5D73E1FA3D52C0	b9acc80f-4795-49fc-affb-4f178ee73958	2011-07-01 00:00:00
830	Indian Mound Mall	\N	Heath	55	43056	E6100000010C9D84A5E4E20944401AB5D59EE78F54C0	92d50980-2a3b-4f09-b966-cefede1cbe84	2012-10-30 00:00:00
831	Amity Plaza	\N	New Haven	11	06510	E6100000010CEAC69CCAF1AD4440B10C6D041F3D52C0	9b0d186c-61e0-453b-9f37-7a8e03194f6b	2013-05-30 00:00:00
832	2251 Elliot Avenue	\N	Seattle	79	98104	E6100000010C82807A086AD4474058EDD9F4299A5EC0	6d6a8e1a-ffd8-4d2d-a70d-88467049a880	2011-07-01 00:00:00
833	3207 S Grady Way	\N	Renton	79	98055	E6100000010C11342614DFC24740F0C5FBC04F975EC0	4e670a74-8ace-44c8-91ed-76cba7190bc2	2012-06-30 00:00:00
834	99300 223rd Southeast	\N	Bothell	79	98011	E6100000010C5755A5215CEE4740A21F841102935EC0	d505aea8-b89a-41ed-90a9-44d4179eff77	2013-02-28 00:00:00
835	259826 Russell Rd. South	\N	Kent	79	98031	E6100000010C796ACFF06AAF47404E44C45C30955EC0	5d3832b3-72dd-4a9b-a596-8293d4037c18	2011-08-01 00:00:00
836	35525-9th Street Sw	\N	Puyallup	79	98371	E6100000010C17B35F9F1B994740821DFB9A1A955EC0	77232d41-48bb-4c8d-8323-5581753e9531	2012-07-31 00:00:00
837	640 South 994th St. W.	\N	Billings	40	59101	E6100000010CBEA486C2B6CA46409D45A0F5350E5BC0	4e75ad15-557e-4c4d-9aeb-68a9718b412a	2013-07-31 00:00:00
838	25300 Biddle Road	\N	Medford	58	97504	E6100000010CDC8E3DA7A62A4540A9D7907BAFAC5EC0	349cbab0-e4e3-40b2-ac50-3ea087110f8b	2013-07-31 00:00:00
839	Gateway	\N	Portland	58	97205	E6100000010C2D3F2FCBC5BF4640D412FDB672B15EC0	3a56b180-70cd-42fe-a19c-f62b5037aa3a	2012-06-30 00:00:00
840	Great Northwestern	\N	North Bend	79	98045	E6100000010C5DBC5EFDE2C24740F633B51448605EC0	1ef6e60f-3582-4298-a7ad-195be59ba7b7	2011-07-01 00:00:00
841	Washington Square	\N	Portland	58	97205	E6100000010C0EC5AD2F0AC14640805BACCCB6B55EC0	7b5ae329-fb7c-4a2c-b33c-827920acacdc	2011-10-01 00:00:00
842	258101 Nw Evergreen Parkway	\N	Beaverton	58	97005	E6100000010C92B6C884B1C04640E901D6C145AC5EC0	eb5a214a-15a1-4e25-b405-dc0ef9907874	2011-08-01 00:00:00
843	253950 N.E. 178th Place	\N	Woodinville	79	98072	E6100000010C0B288D1BF0D84740A9CFC2D0A28F5EC0	e75a2222-d636-4494-a314-2125ee2336f8	2011-08-01 00:00:00
844	755 Nw Grandstand	\N	Issaquah	79	98027	E6100000010C988887F52DBD4740F73F30C840805EC0	0e8578f8-21f7-482d-8dd8-8aa52f68f70a	2013-07-31 00:00:00
845	22571 South 2500 East	\N	Idaho Falls	23	83402	E6100000010C018AFF2220BF4540FDC1918867185CC0	1e5743c8-b8f7-4a65-b812-0302ffcb9d0e	2013-05-30 00:00:00
846	257700 Ne 76th Street	\N	Redmond	79	98052	E6100000010C305B9FEEFBCF4740D959197930905EC0	e606ad23-f6d4-4aa5-b177-7d03d62b0187	2012-06-30 00:00:00
847	25102 Springwater	\N	Wenatchee	79	98801	E6100000010CB2224AB3A1BE47401BE511BED0185EC0	f84f402f-9bd5-432e-a1d6-f284a6dffa29	2012-04-30 00:00:00
848	Bldg. 9n/99298	\N	Redmond	79	98052	E6100000010CEB81660ED7D147404191F8B503865EC0	f8ef420d-b3c8-48b1-a237-4a7d2dad987e	2011-07-01 00:00:00
849	4251 First Avenue	\N	Seattle	79	98104	E6100000010CC9EADE0A09D0474089B8852362915EC0	a077368b-26bf-41b7-b35f-fc380092e6b9	2011-05-31 00:00:00
850	558 S 6th St	\N	Klamath Falls	58	97601	E6100000010C7B9A85C996204540397719D0FB6C5EC0	329894ab-0142-4d9b-9851-2da2f6dc95e3	2013-07-31 00:00:00
851	994 Sw Cherry Park Rd	\N	Troutdale	58	97060	E6100000010C927517AC61C146400ABA76CFA5985EC0	fcde15ff-85d3-4136-9fb6-ea493f39605e	2011-07-01 00:00:00
852	25718 Se Sunnyside Rd	\N	Clackamas	58	97015-6403	E6100000010CB920E161CCBE4640348811236BA85EC0	e85ac59f-59b6-4ed2-9436-fcdb78959b80	2013-06-30 00:00:00
853	567 Sw Mcloughlin Blvd	\N	Milwaukie	58	97222	E6100000010CA4309BD3D1B146408CD3822F81AD5EC0	055b060a-7da2-455c-bcb3-a8dcea4c5156	2013-07-31 00:00:00
854	490 Ne 4th St	\N	Renton	79	98055	E6100000010C02DBD1D82BBA47404893A76671985EC0	471190d7-86c1-48cd-985a-7046b1b89c3c	2013-06-30 00:00:00
855	15 East Main	\N	Port Orchard	79	98366	E6100000010CFB13955629CA474008D0F7260EA25EC0	09926325-7f83-427b-83d6-817df7d70ce9	2011-05-31 00:00:00
856	3025 E Waterway Blvd	\N	Shelton	79	98584	E6100000010CBFAE8B22EF914740904FC0E5ACD45EC0	779d4f7d-c90c-4a8a-bf29-41613e8907ef	2012-09-30 00:00:00
857	7990 Ocean Beach Hwy.	\N	Longview	79	98632	E6100000010C4B14ACF9421C474071A7F454EEBA5EC0	873d03b3-e2ef-4b8b-add8-f237fdc7fe31	2011-07-01 00:00:00
858	2345 West Spencer Road	\N	Lynnwood	79	98036	E6100000010C2EC20579EEE14740264380C3D2875EC0	68aeb59d-0f79-4a0d-92ef-4d0c2beb5821	2012-07-31 00:00:00
859	1050 Oak Street	\N	Seattle	79	98104	E6100000010CDDBBA6C603CC47406D2AE39AB98B5EC0	8caaf6be-9c88-466d-862c-ae7673e3d0f0	2012-06-30 00:00:00
860	4927 S Meridian Ave Ste D	\N	Puyallup	79	98371	E6100000010CBC9747031B9B4740441040E915895EC0	ff2be5e9-7d22-4c1c-acf8-199148e957ab	2012-05-30 00:00:00
861	25915 140th Ave Ne	\N	Bellevue	79	98004	E6100000010C7739B48E11C94740A891C16025855EC0	0d46f203-cdb6-4495-83f5-a97ff0cec174	2012-07-31 00:00:00
862	3307 Evergreen Blvd	Ste 1071	Washougal	79	98671	E6100000010CE3A67FAA81C646402857491B07905EC0	0c81cbd2-96d3-40c1-97d4-056d776b7676	2011-10-01 00:00:00
863	2507 Pacific Ave S	\N	Tacoma	79	98403	E6100000010CEA7089E7B9964740D8967D77E4905EC0	fbac273f-934e-474f-9ccb-f96ca9ae889d	2011-08-01 00:00:00
864	67 Rainer Ave S	\N	Renton	79	98055	E6100000010C12B32419A1C447408BB525E584845EC0	a2fc2f01-c6be-4af4-b718-2a86eb782e5f	2011-07-01 00:00:00
865	750 Lakeway Dr	\N	Bellingham	79	98225	E6100000010C56016CB8376648403F9DF5A0B5A15EC0	243020ec-84c3-417a-b34d-f7760ff130d1	2012-05-30 00:00:00
866	2528 Meridian E	\N	Puyallup	79	98371	E6100000010C0660A4D4DCA5474016A96114DC995EC0	5668e02c-16fa-4331-8603-29ee11417843	2013-06-30 00:00:00
867	48995 Evergreen Wy.	\N	Everett	79	98201	E6100000010CF750D90272004840278CDC64C1955EC0	6cd4e374-0ef8-4cee-ac60-9dbf1f4e0007	2013-07-31 00:00:00
868	25111 228th St Sw	\N	Bothell	79	98011	E6100000010C6552336E16ED4740CA269230D0955EC0	40100c97-5097-43be-9f44-abd881220e8f	2012-05-30 00:00:00
869	2583 Se 272nd St	\N	Kent	79	98031	E6100000010CFE5BB687B1B54740698A688A1C975EC0	e13c4f18-990a-4b7d-9fc9-afd0ea943b13	2011-07-01 00:00:00
870	409 S. Main Ste. 25	\N	Ellensburg	79	98926	E6100000010C340A40D16C864740E9CE1B4052225EC0	955e88ea-083d-446e-a856-42cb0692826a	2012-06-30 00:00:00
871	2502 Evergreen Ste E	\N	Everett	79	98201	E6100000010CAEC975B3DAF747408E1846767F8F5EC0	3ae9003f-f806-41ad-98a5-3c4a86514bc3	2011-05-31 00:00:00
872	755 W Washington Ave Ste D	\N	Sequim	79	98382	E6100000010CF6A03EC3EA0B484076043F6E9FCA5EC0	932514a1-04e4-4e95-b97c-0ad4c06b890e	2013-06-30 00:00:00
873	44606 N Division St	\N	Spokane	79	99202	E6100000010C07DE97EA4DD247400C34DCC0525D5DC0	3438afb3-390c-48d5-8ccf-5438278d981d	2013-06-30 00:00:00
874	2550 Ne Sandy Blvd	\N	Portland	58	97205	E6100000010C6AA9F9371AC046405A679FB7CFA55EC0	14d5dde7-c771-4819-9ff1-a4faa66f0e7a	2012-07-31 00:00:00
875	2540 Dell Range Blvd	\N	Cheyenne	82	82001	E6100000010CBE6FB7BD489044403C1A366A7F2A5AC0	3ac8958a-76ee-41ca-8a88-2b783ea18acc	2012-05-30 00:00:00
876	765 Delridge Way Sw	\N	Seattle	79	98104	E6100000010C45F1F18074C04740F91CF10E179B5EC0	cb1392f5-fcb9-4cf5-b4c9-33fafb876c3d	2011-05-31 00:00:00
877	4781 Highway 95	\N	Sandpoint	23	83864	E6100000010C4215CEA7822D4840C8042CECC72C5DC0	49f0b458-40cd-4852-a936-8576070fcb96	2012-05-30 00:00:00
878	4210 E Sprague Ave	\N	Spokane	79	99202	E6100000010CD81CBE0174DB4740A6FAAF22CC4E5DC0	7c04cf1b-ad79-44d4-9611-381b2f094f96	2012-05-30 00:00:00
879	Valley Mall	\N	Union Gap	79	98903	E6100000010CB7A3E7EBBC464740190567B78D165EC0	860cb49b-5774-441f-b8c5-753ca50fa5e1	2012-05-30 00:00:00
880	S Sound Ctr Suite 25300	\N	Lacey	79	98503	E6100000010C1DBFE61D13884740521184EF1CBF5EC0	3a400497-1000-4d9f-bb8d-d9cbf00c2822	2011-07-01 00:00:00
881	Southgate Mall	\N	Missoula	40	59801	E6100000010CF3AA51A7716D47408436ABD7C8865CC0	3ded7f59-79a9-4034-98f9-f2a0b045d7ae	2012-08-30 00:00:00
882	Medford	\N	Medford	58	97504	E6100000010C3F4C842E382F454038D6D78C35B65EC0	dbc16bdd-c86d-4d5f-91f5-79fa000716fb	2013-05-30 00:00:00
883	Heritage Mall	\N	Albany	58	97321	E6100000010C128B69C2B55B464008C4035A5FD15EC0	cf9c1921-d741-4576-9d32-849e62d57698	2013-05-30 00:00:00
884	Lewis County Mall	\N	Chehalis	79	98532	E6100000010C8D2C9E4A264C47409110B6C115CB5EC0	2f91410b-2988-4e8f-bf01-8009c2f9abba	2011-07-01 00:00:00
885	755 Columbia Ctr Blvd	\N	Kennewick	79	99337	E6100000010CAA0DDDCB012347406B90D5EFBAC35DC0	f3b58620-4857-44a0-9c48-51f21c1ca0c8	2013-07-31 00:00:00
886	Lancaster Mall	\N	Salem	58	97301	E6100000010C68FAA6C3CB7B4640AC5B585AFCC35EC0	3513c4cd-96af-4e5f-b3ff-32d268fb5f54	2012-06-30 00:00:00
887	Lewiston Mall	\N	Lewiston	23	83501	E6100000010CA7BB8B33DB2147402C8B777C86355DC0	4ddbacc9-7898-403e-856a-128e34245424	2012-07-31 00:00:00
888	Three Rivers Mall	\N	Kelso	79	98626	E6100000010C026E3E05F20F4740D2BA7326B9B65EC0	834ae73a-01a9-4850-9f8c-6db5d1344aad	2013-05-30 00:00:00
889	Eastridge Mall	\N	Casper	82	82601	E6100000010C163D1573408A4540C19DFB31F3965AC0	6d5c5880-2c83-4df1-b8ce-46cfe9a9ffac	2011-05-31 00:00:00
890	Holiday Village Mall	\N	Great Falls	40	59401	E6100000010C1952F466BFBB474061C1B4AD71D65BC0	5fe7c888-bb21-421e-9b8b-38da8da10085	2011-10-01 00:00:00
891	2526a Tri-Lake Blvd Ne	\N	Kirkland	79	98033	E6100000010CB5EA123F1DCE47409398F47B9C945EC0	ec34e865-d130-403f-a437-d92d7ef02f05	2011-10-31 00:00:00
892	Frontier Mall	\N	Cheyenne	82	82001	E6100000010C925530B3AB904440F99DFA8D4C355AC0	cb0a8223-fd82-4d26-b7c7-0c120e4eafc5	2011-07-01 00:00:00
893	White Mountain Mall	\N	Rock Springs	82	82901	E6100000010C8A096D9CBCD14440E5F1E6CBE14B5BC0	9308a21d-aae2-42e2-889d-2cd802072d36	2013-05-30 00:00:00
894	3390 South 23rd St.	\N	Tacoma	79	98403	E6100000010CDB482D2277954740183BCAD2E1A15EC0	e7979fa4-253c-41fd-b74f-2feec966a6b5	2011-12-01 00:00:00
895	3250 South Meridian	\N	Puyallup	79	98371	E6100000010CE80FE622998C474077ED243C07995EC0	3b2e6107-040b-4f60-8901-a950bf0562d4	2011-05-31 00:00:00
896	2255 254th Avenue Se	\N	Albany	58	97321	E6100000010C9C923D96B253464062C467118EC55EC0	77d18072-b99b-4b1e-a9b9-948fa927efbb	2013-07-31 00:00:00
897	705 SE Mall Parkway	\N	Everett	79	98201	E6100000010C55ED851DEA074840F3B237DAD0905EC0	77a34652-5d9b-40b6-a15a-56d7ee4056f4	2012-06-30 00:00:00
898	700 Se Sunnyside Road	\N	Clackamas	58	97015	E6100000010CBACC682F59BE46404C86C1C3D5B05EC0	d88449db-7116-427b-bfaf-cae7c08de084	2013-07-31 00:00:00
899	North 93270 Newport Highway	\N	Spokane	79	99202	E6100000010CED90C7539ADE4740ECA75D37555D5DC0	8ae1c168-958e-41da-92d8-7a3a0765f744	2013-06-30 00:00:00
900	25708 Dell Range Blvd.	\N	Cheyenne	82	82001	E6100000010C99B077BF138D4440F55F71D0602F5AC0	9b10fe3a-a1fb-497e-8bc2-e84e8c2a77da	2011-05-31 00:00:00
901	No. 60 Bellis Fair Parkway	\N	Bellingham	79	98225	E6100000010C115B2259B85C484075155AEF9A9A5EC0	8135b5dc-f7e9-401c-992c-93a058ada079	2013-07-31 00:00:00
902	950 Gateway Street	\N	Springfield	58	97477	E6100000010C48C1BFA803054640595E75E719C15EC0	e8beecaf-8668-4d53-97e8-405bc6978def	2012-07-31 00:00:00
903	250775 SW Hillsdale Hwy	\N	Beaverton	58	97005	E6100000010C53FFB51819C74640EDF507F1C6BC5EC0	ac8f33f8-4dc4-467d-b459-788d84749c5d	2012-06-30 00:00:00
904	9905 Three Rivers Drive	\N	Kelso	79	98626	E6100000010C467458C1E50C4740C1FFD13EE5B15EC0	01a85112-6ee1-4f2c-9212-1c2abc612e67	2012-05-30 00:00:00
905	225 South 314th Street	\N	Federal Way	79	98003	E6100000010C1E7E081AC3A1474078A7EE523A995EC0	d305d73c-d595-4961-b870-0dcecb7c6ea9	2012-09-30 00:00:00
906	7009 Sw Hall Blvd.	\N	Tigard	58	97223	E6100000010C43537B796FB74640F42D1AD3B9B25EC0	b8efdbfa-3ba9-45d8-9c09-646dd0c8af93	2012-07-31 00:00:00
907	99295 S.e. Tualatin Valley_hwy.	\N	Hillsboro	58	97123	E6100000010C650D7587D7BD46408EC379BB71B95EC0	a0e88130-6262-4484-815e-e5c485bf3eac	2013-06-30 00:00:00
908	79945 Corporate Center Drive	\N	Miami	15	33127	E6100000010C873E4BE23DCB3940576DF5B4490F54C0	a599f6f7-d81b-4303-bbc4-fcc68833ab3a	2013-06-30 00:00:00
909	3333 Micro Drive	\N	Millington	72	38054	E6100000010CA43431D336AE414060BDEB70C27356C0	ccc2d053-3c58-40dd-8ad2-8175f180a80b	2012-09-30 00:00:00
910	1 Corporate Center Drive	\N	Miami	15	33127	E6100000010C50B21549DDC9394026B469DE881954C0	401f5bb3-08c3-49b2-a3d0-e92ef3e3f294	2011-10-31 00:00:00
911	100 Fifth Drive	\N	Millington	72	38054	E6100000010C13E040CACCAF4140B1AD46C0557E56C0	dc3b445a-4cfe-476d-a299-0abd7cc12827	2011-05-31 00:00:00
912	2525 Electrics Blvd.	\N	Huntsville	3	35801	E6100000010C81A75BBCD45C414036C6FAAE20A755C0	b921d1cf-ac62-4b78-9774-99ff67c59f90	2013-07-31 00:00:00
913	2550 High Street	\N	La Vergne	72	37086	E6100000010C12D0557469034240E726F4B30C9E55C0	30d28ffe-ef33-4b08-8189-299101f88c55	2011-07-01 00:00:00
914	Po Box 08050	\N	Nashville	72	37203	E6100000010C7B6A430B610F4240032F350897AB55C0	21b2e745-c20b-413c-9f81-fa30b5c8c091	2012-06-30 00:00:00
915	Po Box 2257	\N	Greensboro	42	27412	E6100000010CB8C18455E507424016FBCBEEC9F353C0	c0e2a948-4316-45b5-a590-ba7c412ceb2c	2011-07-01 00:00:00
916	One Equinox Way	\N	Sunrise	15	33322	E6100000010C560C59C1152C3A4036E971B99C0B54C0	c4843ba6-7f17-42cc-8e3a-c6bd15bb9fe7	2013-06-30 00:00:00
917	2561 Nw 8410th Avenue	\N	Miami	15	33127	E6100000010CE17B771152CA3940AD2ACD8FA00B54C0	34c2634e-451d-45bc-8edb-1972d4da535a	2012-05-30 00:00:00
918	8525 Nw 17th St.	\N	Miami	15	33127	E6100000010C0F7DA18602DB3940D594B9D4841154C0	5d1fc852-129a-4a23-a098-570e89f38bbc	2012-07-31 00:00:00
919	9876 Fruitville Rd	\N	Sarasota	15	34236	E6100000010C3D3561E263573B40846C595142A054C0	95cbbf6e-2f31-43cc-ad22-4d37a79fa15f	2011-07-01 00:00:00
920	42500 West Park Drive	\N	Atlanta	17	30308	E6100000010C3C43307ED3E74040EFC863425F1B55C0	f6c5c9e5-3e2b-4401-8297-0075db41e136	2011-08-01 00:00:00
921	6055 Shawnee Industrial Way	\N	Suwanee	17	30024	E6100000010C95E11AEFBF08414066805607660655C0	7cb36a4e-f5c3-4b22-878f-fe1884c78d11	2011-05-31 00:00:00
922	Tom Morris	\N	Millington	72	38054	E6100000010C1139B186D2AA4140B74E32BA8E7456C0	336ce923-0826-4d98-bd11-a4fc3c2828d6	2013-06-30 00:00:00
923	C/O Arrow Electronics	\N	Memphis	72	38103	E6100000010C27C80B5DDD934140444B0824A98956C0	bafe7905-9f48-49ff-a7ef-ca030609dd2a	2012-06-30 00:00:00
924	Park North Business Center	\N	Clarkston	17	30021	E6100000010C16F7E0DAD8E3404025D5C8EEA50B55C0	680e4390-4877-4b5f-9392-daebc67a353d	2012-06-30 00:00:00
925	23456 Calumet St	\N	Clearwater	15	33755	E6100000010CB7A9CD4A44FB3B4052580FEDB8BA54C0	0b60e995-e3fa-47aa-8c31-2b4944bf8877	2013-08-30 00:00:00
926	6555 Quince Road, Suite 2025	\N	Memphis	72	38103	E6100000010C10DD1F6F7A834140C00F95464C7056C0	41b6e0e8-1e12-47e3-b92a-6326dd6cbd2b	2011-08-01 00:00:00
927	2025 Greenwood Ct	\N	Mcdonough	17	30253	E6100000010C8D1D0EE77CAC4040D65EF375651055C0	efa9bc47-3fb3-4601-9646-c7b601bc247f	2013-07-31 00:00:00
928	83995 South Dixie Highway	\N	Miami	15	33127	E6100000010C51A8CFC22BBD39408B79CED1B31354C0	84591068-ff34-47ed-adbb-9fd8c9e6bce5	2011-08-01 00:00:00
929	39950 Airport Blvd.	\N	Mobile	3	36602	E6100000010C3F0A848B7DB73E4079636E90A91556C0	6551aa8a-60ba-40ef-827c-1575afeb389c	2011-08-01 00:00:00
930	3990 Silas Creek Parkway	\N	Winston-Salem	42	27104	E6100000010C6FACCE1D8507424004AD9AA5F51954C0	5f689962-d8d3-419b-903c-5cf2f6d9286d	2011-07-01 00:00:00
931	956k North Wesleyan Blvd.	\N	Rocky Mount	42	27803	E6100000010C71759F9BB2F541409ED32CD0EE7353C0	6c1db41e-33b3-4c11-8fcd-8d2e7bb3d380	2012-06-30 00:00:00
932	656 Cox Creek Pkwy.	\N	Florence	3	35630	E6100000010C8E8E0B4DE96C4140A51B8460A5EF55C0	4aab7ccf-b2d5-499e-9006-595ad3258473	2012-06-30 00:00:00
933	25050 S. Columbia Ave	\N	Campbellsville	27	42718	E6100000010C179061F147A94240638C7711315655C0	56527411-9a83-40c5-b49f-9a76c782d60c	2012-07-31 00:00:00
934	2545 N.W. 107th Ave.	\N	Miami	15	33127	E6100000010C6310CAA66ECB3940D5653D88121654C0	ccd37df1-ef66-4ac7-bad5-655a5237d0bf	2012-05-30 00:00:00
935	8789 S.W. 2517 Ave.	\N	Kendall	15	33143	E6100000010CD042F26869A939401E3445EBF30D54C0	f2748334-6f22-41fc-aaa9-8a3b292983ef	2013-04-30 00:00:00
936	825 Coral Way	\N	Miami	15	33127	E6100000010C96CFF23CB8BF39400C42D1454D0D54C0	7e52eec4-454e-4851-82e1-d80a15bb0448	2013-06-30 00:00:00
937	650 E Altamonte Dr	\N	Altamonte Springs	15	32701	E6100000010C5D47DB0374A83C402A3590F2E05354C0	73df8296-cc10-47ca-b61c-ec37730a6360	2013-06-30 00:00:00
938	25631 Florida Mall Ave.	\N	Orlando	15	32804	E6100000010CA21B56C358773C40787D062DEF6054C0	73cc973f-d03f-438e-a9e0-0de090bdf5f1	2011-07-01 00:00:00
939	770 South Point Dr	\N	Memphis	72	38103	E6100000010C27C80B5DDD934140FC33876FC78656C0	2f4a10b8-650e-4c17-aed9-f9b3357d36d5	2011-08-01 00:00:00
940	7725 Luddington Lane	\N	Birmingham	3	35203	E6100000010CD6949EC8D7BF4040FF1111D0D6AB55C0	0dd614cc-e758-41b7-a155-0a7e4dec1569	2012-06-30 00:00:00
941	790 Shelbyville Road	\N	Saint Matthews	27	40207	E6100000010CA43E67AD26194340DB2EADBBDB6955C0	97109b89-a727-483f-97be-cd5ae7c360d4	2013-07-31 00:00:00
942	4496 Barnes Crossing Rd.	\N	Tupelo	39	38804	E6100000010C2F64A09F392D4140BEF9422D983556C0	9abda420-3f7b-4607-8faf-fe80f3e4f60e	2012-04-30 00:00:00
943	78025 E. Mercy Island Cswy	\N	Merritt Island	15	32952	E6100000010CF28E77F068503C40B85A93DCDB3054C0	7bbc18f2-bba9-41bf-bd22-e6c59243bfe1	2011-05-31 00:00:00
944	574 Atlanta Highway	\N	Montgomery	3	36104	E6100000010CBE4C6520562C40400FE62C53289055C0	3cea0bb0-41ab-4cc3-bab1-004c833343d9	2013-05-30 00:00:00
945	5230a Hwy. 2553	\N	Hixson	72	37343	E6100000010C2E551E90499741402F8DE9F8945555C0	d528a24f-33de-4275-b6e1-283ced474aa6	2013-05-30 00:00:00
946	25800 Gallitin Rd.	\N	Nashville	72	37203	E6100000010C3E1D3194EA0E4240C2EB501025B155C0	26bc269f-b8b1-4245-9839-637dac2f554c	2012-09-30 00:00:00
947	830 Highway 499 So	\N	Mcdonough	17	30253	E6100000010C68C29DBFD6BB404091F13FDE9C0355C0	fec017c0-16d9-4ae0-a7ea-afe0a040030d	2013-07-31 00:00:00
948	99842 White Mill East	\N	Decatur	17	30030	E6100000010C3DDD43426ADD4040BEFF26F69C1055C0	59850126-c7f4-401f-a8a6-e0601e011da8	2011-08-01 00:00:00
949	Turfway Retail Center	\N	Florence	27	41042	E6100000010C62D9766E048243401D4BEFEDEE2E55C0	06a74130-d1de-4697-a2bf-7c0f9caa662e	2011-08-01 00:00:00
950	25 Myrtle Beach	\N	Myrtle Beach	67	29577	E6100000010C4BDB3A566EC9404091E3E3DF7BBD53C0	cfc509ff-a2fb-43cc-98fd-f6dccf4ddc9b	2011-08-01 00:00:00
951	Parkway City Mall	\N	Huntsville	3	35801	E6100000010C5A40A63CD4584140412DBD3EB2A255C0	22c05101-33da-42ed-a94b-07d89b10d521	2012-05-30 00:00:00
952	Factory Stores Of America	\N	Crossville	72	38555	E6100000010C5ABAC66F02F1414073374E966F4055C0	49839bfc-1e1a-4d0c-a831-ea9eee4835fc	2012-05-30 00:00:00
953	Fort Henry Mall	\N	Kingsport	72	37660	E6100000010C26EE20DA0143424048C8F9963C9D54C0	7f715ef4-9ff7-425d-8df9-78777ab27245	2012-05-30 00:00:00
954	Carolina Factory Shops	\N	Gaffney	67	29340	E6100000010C09EA4632557C4140167D7E62236554C0	bcd96a95-d36a-4622-bf99-3eb054c31a4c	2011-07-01 00:00:00
955	Edgewater Mall	\N	Biloxi	39	39530	E6100000010C2EBCFBF2BA663E4017520F6D1E3A56C0	95ed46e7-f8df-4dc1-911a-fa09b82233c3	2011-05-31 00:00:00
956	Highland Lakes Shopping Ctr.	\N	Orlando	15	32804	E6100000010CC23B240F469E3C4078771DD4A75F54C0	52af06e8-92a0-4e62-b861-07c1066ddabe	2012-05-30 00:00:00
957	Grand Central Place	\N	Somerset	27	42501	E6100000010C08642E24448B4240A0949AA6461655C0	f60f965b-d0b5-43eb-bfa7-5dea3c419a6e	2013-06-30 00:00:00
958	Silver Sands Factory Outlet	\N	Destin	15	32541	E6100000010C7EFE017D5D6D3E40AE7D6C5962A055C0	fa38b84c-6ab5-4a2d-adab-dd7165d63d11	2011-05-31 00:00:00
959	West Georgia Commons	\N	La Grange	17	30240	E6100000010C6C9ABD37B48640402EED6AB69F4F55C0	c9af9be1-e888-476c-8265-dd666c51ed87	2013-08-30 00:00:00
960	Peachtree Mall	\N	Columbus	17	31901	E6100000010CCB5F2ABABD3F404062DC20688E3D55C0	1f7801ba-c6f1-4405-85ee-da246e707d6c	2012-06-30 00:00:00
961	University Plaza	\N	Tampa	15	33602	E6100000010C2181867C70ED3B40BD79C0E441A054C0	ac5bdaf5-6800-49a4-92ae-f3f61a14f87d	2013-07-31 00:00:00
962	Flagler Park Plaza	\N	Miami	15	33127	E6100000010C19E73B468ED53940B215AAB2531354C0	b8353617-efd1-44b6-9ddd-33d40d5d4ae0	2012-05-30 00:00:00
963	Market Square Shopping Center	\N	Lakeland	15	33801	E6100000010CBF248C32A4113C40084EE551937854C0	4aafeb7a-81eb-47ea-88cb-96624890b9f9	2011-10-01 00:00:00
964	Fsa Outlet Center	\N	Nashville	72	37203	E6100000010C94A7FA347C1A42407AA86C18B3B655C0	e9562dd7-6524-4235-a214-d6fe049cc9b5	2012-06-30 00:00:00
965	Newport Shopping Center	\N	Newport	27	41071	E6100000010CECB160FD898C4340972212BA611E55C0	548396e4-22a7-4ac6-9222-06f2e6685801	2012-06-30 00:00:00
966	Factory Stores Of America	\N	Smithfield	42	27577	E6100000010C9C52769B49BE414061FFAC152A9653C0	e2860d23-07db-4dc8-952f-0067affece6e	2012-06-30 00:00:00
967	Peach Festival Outlet	\N	Byron	17	31008	E6100000010C66342B393A5740407FBE368A2BF554C0	9eda0d1b-1da7-4cff-b688-47907197a0fd	2011-10-31 00:00:00
968	Belz Factory Outlet	\N	Orlando	15	32804	E6100000010CEE01F1C7F4963C40A207B562925D54C0	8721a49d-c7b9-4b30-87d7-23186d656b60	2012-05-30 00:00:00
969	Horizon Outlet Center	\N	Vero Beach	15	32960	E6100000010CEE207F3A719A3B40AF035E14381754C0	17165186-67e6-4122-b206-ffbc133e3f39	2011-10-01 00:00:00
970	Hilton Head Factory Outlets No. 25	\N	Bluffton	67	29910	E6100000010CFCB492D15D244040C077F643583B54C0	11f4e4e8-caba-4b5a-991a-909abcff61af	2011-07-01 00:00:00
971	Bay Area Outlet Mall	\N	Clearwater	15	33755	E6100000010C45CAF16ED2033C405035AA5F0EB354C0	1cedf0c5-ccb0-4408-a7a6-e1687f969e69	2011-05-31 00:00:00
972	Gulfport Factory Shops	\N	Gulfport	39	39501	E6100000010CC42AA5C221653E40D7F99957CB4856C0	8a517d32-6a42-43c2-ab09-2a968c748b30	2011-07-01 00:00:00
973	Belz Factory Outlet	\N	Pigeon Forge	72	37863	E6100000010C563DC7DB5DE541404695927A02E054C0	5d6f1a8e-6822-448b-babd-262c323f3d14	2011-08-01 00:00:00
974	Savannah Festival Outlet	\N	Savannah	17	31401	E6100000010C89F9552A110F40401BBD6575AA4C54C0	fd10d567-f690-44ee-bf26-de9c57568c07	2011-07-01 00:00:00
975	Mall Of Memphis	\N	Memphis	72	38103	E6100000010CBC8EEBCCD883414063FCFEDFE57256C0	34b12e29-bd89-4b14-836f-4d81479e06b8	2011-08-01 00:00:00
976	Foothills Mall	\N	Maryville	72	37801	E6100000010C9268F6E0DEDA41409CEA0A1E400155C0	560538c6-c09f-4656-b86f-bdd24e67120d	2011-08-01 00:00:00
977	Dadeland Mall, Space 25090	\N	Miami	15	33127	E6100000010CC8E7E7B0FFC83940B3EDDE6C380F54C0	b92e36dd-566b-4c53-a111-6b834b568967	2011-05-31 00:00:00
978	DeSouth Square	\N	Bradenton	15	34205	E6100000010CAA4CDD69007D3B401C3471D19FAA54C0	5273463e-6e4c-4848-871e-0e798fe07165	2013-07-31 00:00:00
979	32525 Hollywood Blvd.	\N	Hollywood	15	33021	E6100000010CA2D47F06940C3A40FD7FD5B5950554C0	c6af7b50-00b0-42e1-9e1c-436305796097	2011-07-01 00:00:00
980	7700 Green Road	\N	Raleigh	42	27603	E6100000010C38D7ECFBC3D241405A8CC255E8B153C0	f39aaa6e-b578-405e-9020-48d645fb3156	2013-07-31 00:00:00
981	20500 S.W. 2512th Ave	\N	Miami	15	33127	E6100000010C4A6EDE02A0CD3940AE02024A850754C0	f4747936-94f3-4df4-a6b6-486dea627893	2012-05-30 00:00:00
982	9935 Robert C Daniel Jr Parkway	\N	Augusta	17	30901	E6100000010CB2C02F539BBE40409A8A8980BB8954C0	d8221d9d-6fa4-4a6b-b771-7ccc24b71342	2012-07-31 00:00:00
983	99535 Dallas Highway	\N	Marietta	17	30060	E6100000010CA317CD7482F2404003F6D939882655C0	7bd788aa-b00c-436f-bee8-79249cac4d57	2012-07-31 00:00:00
984	254075 Biscayne Blvd.	\N	North Miami Beach	15	33162	E6100000010CC4548082B1F439401EC6BF595C0654C0	9f5fe462-34d0-47ec-b953-f7843b172214	2011-08-01 00:00:00
985	42525 Austell Road	\N	Austell	17	30106	E6100000010CF2E33C8EEBE940403C9D64CABF2355C0	55cd3096-be2a-45d7-a2f6-0028a3c020b9	2011-05-31 00:00:00
986	6333 Cloverleaf Parkway	\N	Kannapolis	42	28081	E6100000010CA51745310FB54140009B21BC582354C0	4245cd10-5265-4cbf-9545-3fe6284d1267	2014-01-29 00:00:00
987	8520 University City Blvd	\N	Charlotte	42	28202	E6100000010C38D8C9BFE3A64140C6AC9D581B3554C0	f5692923-acb0-41ca-9e70-1e774cadbc2b	2013-06-30 00:00:00
988	482505 Warm Springs Blvd.	\N	Fremont	9	94536	E6100000010CC3BC5ECDC9C142404F450CC71F7F5EC0	cd6d22b0-d941-4928-b6f7-1508021e6539	2012-07-31 00:00:00
989	39933 Mission Oaks Blvd	\N	Camarillo	9	93010	E6100000010CC77ED6EFF71F4140A6C1C5E095C65DC0	8b1241ca-1db6-4f9d-861e-1d6cc3796443	2013-07-31 00:00:00
990	5420 West 22500 South	\N	Salt Lake City	74	84101	E6100000010CE4044F72DE5B444009D232232A025CC0	7612c47a-e24a-4bd8-9b8b-3aed15af64f9	2012-05-30 00:00:00
991	60025 Bollinger Canyon Road	\N	San Ramon	9	94583	E6100000010C32173233D7E44240B212AED2B5785EC0	962a4d00-c5aa-41cc-b7bc-2afbe2fa65b8	2012-07-31 00:00:00
992	9992 Whipple Rd	\N	Union City	9	94587	E6100000010C31B38A6068C742403DF6D1C1F08E5EC0	88258a1b-b50f-440f-93b9-5d7af831d5fc	2012-07-31 00:00:00
993	Corporate Office	\N	El Segundo	9	90245	E6100000010C29D2BF38D8EF40405B775976239B5DC0	6cccc74f-6389-4d08-8ed1-9079b42cf7ae	2012-07-31 00:00:00
994	25001 Montague Expressway	\N	Milpitas	9	95035	E6100000010C77B548400FB84240D6679C74AB765EC0	89901b2a-fda8-4926-b22c-dd5d583681a6	2012-05-30 00:00:00
995	4460 Newport Center Drive	\N	Newport Beach	9	92625	E6100000010C5866AC9C35C84040BCAD963D3D785DC0	d6b9e9e9-f288-4590-be12-8ddbb5e53bc2	2012-05-30 00:00:00
996	2575 West 2700 South	\N	Salt Lake City	74	84101	E6100000010C6E9ADC36AF544440AC180B5B4CF85BC0	708fc1dd-4994-4aa5-80a5-8c977c37aa15	2012-06-30 00:00:00
997	70259 West Sunnyview Ave	\N	Visalia	9	93291	E6100000010C4497C3A5F12542406CD48C5685D35DC0	7c2e0511-de61-4761-80ea-6a7b2f39e524	2013-07-31 00:00:00
998	60750 San Clemente	\N	Hayward	9	94541	E6100000010CB2747D1801C94240124DA15E0D885EC0	822dc2be-aac2-4283-93a6-5027cfb6a7df	2013-07-31 00:00:00
999	Receiving	\N	Fullerton	9	92831	E6100000010C47CB4845F2EA404079A10C358C7F5DC0	93d3c32f-cc26-4f27-b91f-35a804554976	2012-07-31 00:00:00
1000	22555 Paseo De Las Americas	\N	San Diego	9	92102	E6100000010CA43F3589854540402D8AD214E8385DC0	982bdcc2-6429-4725-a6df-4faf032ec908	2012-06-30 00:00:00
1001	Incom Sports Center	\N	Ontario	9	91764	E6100000010CF394FC4D2D034140E8F958CDD7645DC0	079e5de8-169f-4eb6-be75-813b40a0143e	2011-07-01 00:00:00
1002	C/O Starpak, Inc.	\N	Greeley	10	80631	E6100000010C7DA8C98DF33144405F902BC655255AC0	512bd07c-7ed7-421b-923f-d41999bd5bd7	2012-06-30 00:00:00
1003	5967 W Las Positas Blvd	\N	Pleasanton	9	94566	E6100000010CE6BFB78D28DD424061BFF79C937D5EC0	6b26292f-1ebe-41ce-9a3e-ff42d3c10a44	2013-05-30 00:00:00
1004	25600 E St Andrews Pl	\N	Santa Ana	9	92701	E6100000010C492143ED9DD64040D666B9CD6A805DC0	489390e0-48c0-4bb4-a5dc-38c4b39ea833	2011-08-01 00:00:00
1005	6756 Mowry	\N	Newark	9	94560	E6100000010CADFBC74274C242400D51EBD86D7A5EC0	cfb5ed2a-43fe-4102-8413-73c74dacc79e	2012-06-30 00:00:00
1006	25472 Marlay Ave	\N	Fontana	9	92335	E6100000010C72319223FFFF40405A850500E5685DC0	90c5f983-b302-4f6c-9d8a-bfb9e1bff406	2013-07-31 00:00:00
1007	77 Beale Street	Room 99767c	San Francisco	9	94109	E6100000010C5DBF125F5CE342402FB2102166A05EC0	5122f535-c03e-4244-90c8-5d360c0c4cc4	2011-08-01 00:00:00
1008	910 Main Street.	\N	Sparks	52	89431	E6100000010C456A225096CD4340DFECD5532EEA5DC0	f12c6f58-6095-47d4-9fa0-21a639b90db9	2012-06-30 00:00:00
1009	2500 N Serene Blvd	19th Floor	El Segundo	9	90245	E6100000010C6EF0205D47F0404016EDFCAA038F5DC0	7619e3bd-780b-45b1-a477-8fc3e0948352	2013-06-30 00:00:00
1010	5650 West 88th Ave.	\N	Westminster	10	80030	E6100000010C7C33024ABCF343402A8D956A78465AC0	bd7fa7a0-4cbe-442a-a5e5-e5e2b79214ec	2013-06-30 00:00:00
1011	9700 Sisk Road	\N	Modesto	9	95354	E6100000010C3F86942F2DDB4240682B15B59A485EC0	fb563347-c157-43b3-a7e4-a851495df874	2012-07-31 00:00:00
1012	789 West Alameda	\N	Westminster	10	80030	E6100000010CE6BEC51026E243409638D9A3233F5AC0	73bf97f3-e4e3-402d-8609-7839aebaa947	2012-07-31 00:00:00
1013	54254 Pacific Ave.	\N	Stockton	9	95202	E6100000010C3F93201D1CFC4240C1FE28F4485F5EC0	7b82a39f-d175-4543-8f6f-ae6fe9c34a99	2012-06-30 00:00:00
1014	25136 Jefferson Blvd.	\N	Culver City	9	90232	E6100000010C494E98EC02FE40406724360561A15DC0	05196d3f-f726-4ab9-a66b-af87500846ad	2012-07-31 00:00:00
1015	99000 S. Avalon Blvd. Suite 750	\N	Carson	9	90746	E6100000010C4027581E55E7404046A5C8E022915DC0	206163d9-0324-476d-909e-607fe07b2a2a	2011-07-01 00:00:00
1016	72502 Eastern Ave.	\N	Bell Gardens	9	90201	E6100000010C0B614838DEF94040280ACBDB978D5DC0	06431d74-4caf-442c-870e-efc20f9d45b8	2012-07-31 00:00:00
1017	2560 E. Newlands Dr	\N	Fernley	52	89408	E6100000010CD27160006BC74340F1813A8FFBD75DC0	5d07c55b-9e6a-49de-8f49-04f28ad2f36a	2011-08-01 00:00:00
1018	630 N. Capitol Ave.	\N	San Jose	9	95112	E6100000010C5CD2BE197BB4424085650C2D1B705EC0	aceb7a03-c8e6-43f6-94f2-266e571bd413	2013-05-30 00:00:00
1019	4660 Rodeo Road	\N	Santa Fe	48	87501	E6100000010C6F4EB1D9AAD7414004B5C2CCB7865AC0	4fe824c1-f1bc-48b6-a4fd-6b866d0d07c8	2013-07-31 00:00:00
1020	251340 E. South St.	\N	Cerritos	9	90703	E6100000010CF64BDF5CD1F240404D5166634C805DC0	ba72737a-0827-46a8-af5b-971fd8464a87	2011-08-01 00:00:00
1021	440 West Huntington Dr.	\N	Monrovia	9	91016	E6100000010C8BCFC06F531641400C0DE208447E5DC0	2ae4d8c2-6d11-4945-a032-430dc8ce5b1b	2011-05-31 00:00:00
1022	99235 Hawthorne Blvd.	\N	Torrance	9	90505	E6100000010CF0DBB5BE31E140401DA4D6AD079E5DC0	52724cd9-1dc9-4d28-9b89-c404692c0b73	2011-05-31 00:00:00
1023	870 N. 54th Ave.	\N	Chandler	6	85225	E6100000010C652DD18E38A240405E0CCCA7AAF45BC0	26d3a3ec-3d51-493e-a541-a0cc80b54f35	2013-05-30 00:00:00
1024	9952 E. Lohman Ave.	\N	Las Cruces	48	88001	E6100000010C546B0D3C402340408285D3DAACB85AC0	42af4b56-ece2-4595-929d-fb60db1392d9	2011-05-31 00:00:00
1025	2530 South Colorado Blvd.	\N	Denver	10	80203	E6100000010C4024873DE9D34340C7EB346825345AC0	012ef479-5dad-4009-b456-24e47ca1f472	2011-08-01 00:00:00
1026	955 E. County Line Rd.	\N	Englewood	10	80110	E6100000010CDDDBB74C06CD43401CEF2B62DA3A5AC0	17a96f13-8658-4f02-a557-2bc4463ade21	2013-07-31 00:00:00
1027	409 Santa Monica Blvd.	\N	Santa Monica	9	90401	E6100000010C03C8DB91FB024140AE82AFDFC0A55DC0	58d58e3e-bf3e-4e0c-8f96-1717821e3516	2012-07-31 00:00:00
1028	Mall Of Orange	\N	Orange	9	92867	E6100000010CDBAC066121EB4040C8E21A3A34745DC0	8d9b75cc-90c4-4e15-b69c-891126386ba6	2011-07-01 00:00:00
1029	Topanga Plaza	\N	Canoga Park	9	91303	E6100000010CD72EF8AA3F174140088D74D7E89E5DC0	0b945127-9c6f-47a1-80e4-2fb0e057fa55	2013-05-30 00:00:00
1030	Escondido	\N	Escondido	9	92025	E6100000010C95A1D5813B8F4040217A01A6113D5DC0	e5b6618d-a92b-4da1-ba99-316babfff7db	2012-06-30 00:00:00
1031	Natomas Marketplace	\N	Sacramento	9	95814	E6100000010C1AD8DC071C454340134E13D83B595EC0	27af5ed8-d33a-4fb2-9c55-d5cdd5017cd4	2012-06-30 00:00:00
1032	Simi @ The Plaza	\N	Simi Valley	9	93065	E6100000010C37913C6EA1214140FE3D5444FCBB5DC0	8e4a379f-f6d6-4995-aa19-6db50325d0fe	2011-07-01 00:00:00
1033	Lakewood Mall	\N	Lakewood	9	90712	E6100000010CD34FFE72A5F240405E89CF7850835DC0	d28c7fef-9ea3-458f-a2b9-11964c3cc60b	2013-05-30 00:00:00
1034	Oxnard Outlet	\N	Oxnard	9	93030	E6100000010C840507FFE02041403CAF2C079DD65DC0	300d2a6e-67b4-417b-83a9-2026818a21c6	2013-07-31 00:00:00
1035	Vista Marketplace	\N	Alhambra	9	91801	E6100000010CBA3233219A0A4140EF84DC7439875DC0	7795fcdf-76c3-4627-86b2-0291398868de	2012-07-31 00:00:00
1036	Sports Store At Park City	\N	Park City	74	84098	E6100000010CC918E594BD5A44405A3FA24930DE5BC0	a04ec332-1120-4ac3-837e-97efc40636b2	2011-08-01 00:00:00
1037	North County Square	\N	Vista	9	92084	E6100000010CD3673CDD4B9F4040FAF57A1DA44F5DC0	5a794553-877e-4977-8e76-de38aa064ebd	2011-08-01 00:00:00
1038	123 Camelia Avenue	\N	Oxnard	9	93030	E6100000010C87481188CE164140EF5AE23353D45DC0	a86c8140-ad7d-4caa-9b40-4006bd9998e2	2013-07-31 00:00:00
1039	Mountain Square	\N	Upland	9	91786	E6100000010C96AC788C270841406D59500B9A625DC0	8f1bdc33-0bfb-41d0-bb85-71aafe6126e7	2012-07-31 00:00:00
1040	Fox Hills	\N	Culver City	9	90232	E6100000010C791386D62400414005C1C0D2E1965DC0	5042b0a9-d10a-4f99-9f6f-50f96defa226	2011-07-01 00:00:00
1041	Parkway Plaza	\N	El Cajon	9	92020	E6100000010CB00174D8036B404092C2B09028405DC0	c0fdc154-d2b5-480d-a5da-4e0d6b5d750c	2011-10-01 00:00:00
1042	Stonewood Mall	\N	Downey	9	90241	E6100000010C8B904B210DFF40409228791E40895DC0	d1d79211-aec3-424d-a279-af1d01da3ec2	2011-07-01 00:00:00
1043	Hanford Mall	\N	Hanford	9	93230	E6100000010C33945A17B22D4240A681BEF47BEE5DC0	f4f57d92-1839-49f4-a491-63f43215aaf1	2011-10-31 00:00:00
1044	Ontario Mills	\N	Ontario	9	91764	E6100000010C8829685D6A0A414025D104AFEE6B5DC0	c66b86d8-bdfc-4161-9cbf-9a46d5f57b91	2013-05-30 00:00:00
1045	Nut Tree Factory	\N	Vacaville	9	95688	E6100000010C38C4D028323D4340679DCD78138B5EC0	eb58eebb-3f55-45d1-9702-eddaccd687e2	2011-07-01 00:00:00
1046	Rocky Mountain Pines Outlet	\N	Loveland	10	80537	E6100000010CC0723409F734444064DB26736C515AC0	518e7219-193f-4d72-90c9-e82f201afbe4	2011-07-01 00:00:00
1047	Stevens Creek Shopping Center	\N	San Jose	9	95112	E6100000010C1B82490DF8A94240525D6416EA705EC0	0e6f74f0-9128-4688-9007-6395d6c6f4c4	2012-07-31 00:00:00
1048	Factory Merchants	\N	Barstow	9	92311	E6100000010C319F71948E6D41402DC8F948574C5DC0	470574f9-6a06-43dc-a4b9-de3c8d88b0e6	2011-08-01 00:00:00
1049	The Citadel Commerce Plaza	\N	City Of Commerce	9	90040	E6100000010C25D0413462FA4040C5749EF30E905DC0	42cd575b-22a1-42e0-93bb-d8ee998e4fb7	2011-08-01 00:00:00
1050	University Town Center	\N	San Diego	9	92102	E6100000010C85160B6DC85F4040B509448B31455DC0	6d9ebb03-5c5a-4a20-8910-12d894591727	2011-08-01 00:00:00
1051	Pavillion @ Redlands	\N	Redlands	9	92373	E6100000010C95AC302D30FD404093C6B2D6A5465DC0	b2f0f099-ddd2-4ab6-90af-972d72186937	2011-08-31 00:00:00
1052	San Diego Factory	\N	San Ysidro	9	92173	E6100000010C0AF9B618684B40402D8DCF5785475DC0	8c3cff8c-3a5d-419a-8dd8-3349c29aa3fd	2011-07-01 00:00:00
1053	Pacific West Outlet	\N	Gilroy	9	95020	E6100000010CD032871FED88424075830FC3185A5EC0	de6463d5-42d9-4d34-ac99-4aaa19fab3ca	2011-07-01 00:00:00
1054	Belz Factory Outlet	\N	Las Vegas	52	89106	E6100000010C20D8981A0D174240B263CB3D82C95CC0	0e75e01f-76d4-4420-beb7-0033f16dea62	2011-07-01 00:00:00
1055	Camarillo Athletic Stores	\N	Camarillo	9	93010	E6100000010CB7705E0D0E174140EFBC59D0F2CE5DC0	30e691f7-1d06-4df7-aedf-627ad911a770	2011-07-01 00:00:00
1056	Lake Elisnor Place	\N	Lake Elsinore	9	92530	E6100000010CB33C94BB87D04040AE654748F6585DC0	596345c5-0be2-444d-ba93-d109713bc0b6	2011-07-01 00:00:00
1057	Norwalk Square	\N	Norwalk	9	90650	E6100000010C9FB618F002FA4040B1E063F2AA845DC0	ccce93be-ab0b-4211-8407-5be45034534c	2011-08-01 00:00:00
1058	Riverside	\N	Sherman Oaks	9	91403	E6100000010CA22AE48DAE104140C17E594E509B5DC0	a26100f0-511f-45a2-879a-ff365794fcf5	2013-07-31 00:00:00
1059	The Quad @ WestView	\N	Whittier	9	90605	E6100000010C73C7CFBB1FFA404064BF48294B795DC0	2215f750-1863-4aff-926d-de309c298de9	2013-05-30 00:00:00
1060	Arcadia Crossing	\N	Phoenix	6	85004	E6100000010CDDC165FBB8B64040C49CABAB8EFC5BC0	cc91297c-567b-4186-96c8-2ba6f0875e73	2012-05-30 00:00:00
1061	Eastern Beltway Center	\N	Las Vegas	52	89106	E6100000010CA27DB0AB831742409F974B7E59C45CC0	84603598-f6d4-4e26-9b9e-6a468365d4d8	2011-10-31 00:00:00
1062	Factory Stores/tucson	\N	Tucson	6	85701	E6100000010C25FBC08F201E4040E22AD19FC6BE5BC0	c15eca9a-6054-40e4-8d09-d4341aabce2d	2011-08-01 00:00:00
1063	Viejas Outlet Center	\N	Alpine	9	91901	E6100000010C052913C94D6C4040B8C29A4861295DC0	4f8ec2c2-71d6-4b7f-bcc7-808e17696373	2013-07-31 00:00:00
1064	West Park Plaza	\N	Irvine	9	92614	E6100000010CCE10254929DA404097EF2007F0805DC0	365914ce-cbb2-429b-a2d8-24638fcf17fc	2011-12-01 00:00:00
1065	Factory Stores Of America	\N	Mesa	6	85201	E6100000010CBE7945F40FBC4040E99084DA94FC5BC0	1b96d3a3-ed06-482f-a813-7136e5aaa57d	2012-07-31 00:00:00
1066	Prime Outlets	\N	Phoenix	6	85004	E6100000010CF09358796FB84040AFF0981EC0085CC0	bd687691-297f-4b72-9465-c8dbd0f8e2ee	2011-08-01 00:00:00
1067	Bayshore Mall	\N	Eureka	9	95501	E6100000010CBF986EA1C46B444042CFBA13E0015FC0	001d1a67-585c-44b2-aac6-1199afd7425f	2012-07-31 00:00:00
1068	7709 West Virginia Avenue	\N	Phoenix	6	85004	E6100000010C01FD51B84AB94040AFF0981EC0085CC0	b8184c93-a8de-4321-b381-1babc7088d60	2012-05-30 00:00:00
1069	6900 Sisk Road	\N	Modesto	9	95354	E6100000010C7D119F6A5AD64240A24D51226F3B5EC0	60110399-edf3-4c06-ac87-1d9856e9d2e3	2011-05-31 00:00:00
1070	3250 Baldwin Park Blvd	\N	Baldwin Park	9	91706	E6100000010CBE6CF24D97034140845739164E855DC0	957ec59c-7a7d-438e-9014-20fbeb807e99	2011-07-01 00:00:00
1071	5867 Sunrise Boulevard	\N	Citrus Heights	9	95610	E6100000010CBCFB2ADC15534340621D13557B545EC0	a64fc10b-61f7-4102-b076-e9cb77e9ec8f	2012-09-30 00:00:00
1072	6500 East Grant Road	\N	Tucson	6	85701	E6100000010C04D5FCB55323404098E0E3327FC05BC0	b9265d45-3fed-4b7d-aeea-00d0e54b3cc7	2013-07-31 00:00:00
1073	3065 Santa Margarita Parkway	\N	Trabuco Canyon	9	92679	E6100000010C73CD44D3A5D040403F8E0C7D21655DC0	c5c0801f-f124-4a5e-b8ba-0ace3bf0f993	2011-05-31 00:00:00
1074	9920 Bridgepointe Parkway	\N	San Mateo	9	94404	E6100000010C408CB157C6C0424000BA5C286E9B5EC0	c346981b-2093-474a-9bc0-54ce2e0e4a94	2011-05-31 00:00:00
1075	5525 South Hover Road	\N	Longmont	10	80501	E6100000010C68EBA59FD61444401C05E78D51425AC0	e5fa71b3-685a-4d11-bc0c-e4aa69cd4ded	2012-05-30 00:00:00
1076	8525 South Parker Road	\N	Parker	10	80138	E6100000010C38CAA5029BC9434058EAE6AB813B5AC0	d4f4ab28-5f27-4f89-a0d6-5fcea394bb47	2011-07-01 00:00:00
1077	7505 Laguna Boulevard	\N	Elk Grove	9	95624	E6100000010C6A69DAFC393443406492FC05355C5EC0	b6213e39-9da3-4423-8756-0b195ed95fb4	2011-10-01 00:00:00
1078	9909 W. Ventura Boulevard	\N	Camarillo	9	93010	E6100000010CF41568E4E3174140A65F8DB830C15DC0	0a911f46-295e-4485-a9d8-90dfcc0c9223	2012-06-30 00:00:00
1079	25150 El Camino Real	\N	San Bruno	9	94066	E6100000010CF810FDE81ACE42403E745F42659F5EC0	9f1bc24e-66f2-41e2-94a2-d1001c050bb4	2011-08-01 00:00:00
1080	2575 Rocky Mountain Ave.	\N	Loveland	10	80537	E6100000010C92CDE8562E3044405C79D5BBB2405AC0	bcc0867e-cb4e-4852-994e-03abed8c95ab	2012-06-30 00:00:00
1081	25871 North Main Street	\N	Walnut Creek	9	94596	E6100000010C47127BB761F24240E7AAE0EAB6805EC0	a00218d5-482d-44c2-8cd0-6f65af8642d3	2012-06-30 00:00:00
1082	2551 East Warner Road	\N	Gilbert	6	85233	E6100000010C15BECD64D1B24040773FEC782AEE5BC0	d88afbda-b59b-496e-ba6d-b3b2356574ff	2013-06-30 00:00:00
1083	22589 West Craig Road	\N	North Las Vegas	52	89030	E6100000010C0AC1CB5B271E4240D2F66D15AFC15CC0	a4c2efe6-17e5-4dd5-9bed-6743405627e7	2013-03-30 00:00:00
1084	25751 University Drive	\N	Vista	9	92084	E6100000010C421918D400974040AA9F0E08604E5DC0	bd3035f6-4018-4e4c-8d70-6dd3f4fe8eb4	2013-03-30 00:00:00
1085	49925 Crestview Drive N.E.	\N	Rio Rancho	48	87124	E6100000010CFB8C29AA31A64140AD1B4E7A56B15AC0	3a1f16cf-6889-40b2-b067-7d044a8c7d42	2011-08-01 00:00:00
1086	57251 Serene Blvd	\N	Van Nuys	9	91411	E6100000010CA5EA309A961241400682EDBEEA9E5DC0	7df3a412-f2b3-4abb-88e1-21d4677f1311	2013-07-31 00:00:00
1087	253731 West Bell Road	\N	Surprise	6	85374	E6100000010C6725EB066DD34040AFA085469C175CC0	4ba77e6a-4a47-4bfe-8aeb-dbfea179795d	2012-06-30 00:00:00
1088	99040 California Avenue	\N	Sand City	9	93955	E6100000010CDDD10CF9A15342409B4B428A9F725EC0	a18799a1-342a-4b6c-a63c-8e4e2c07f734	2013-05-30 00:00:00
1089	25620 Firestone Boulevard	\N	Norwalk	9	90650	E6100000010CAE608166A4F2404035E4E931817F5DC0	31a07731-18ff-4100-8319-b4704f414497	2013-05-30 00:00:00
1090	25130 South State Street	\N	Sandy	74	84070	E6100000010CC95CCCCE1F4B4440650A52F0B7F45BC0	cf3ae92a-3e66-4af0-b683-731826e89cd1	2013-07-31 00:00:00
1091	5500 Grossmont Center Drive	\N	La Mesa	9	91941	E6100000010CB07FB10F325F40407AF0CB12DD3C5DC0	24f1dbc4-7fdc-4edb-b3cb-640f9fb72534	2011-08-01 00:00:00
1092	99700 Bell Road	\N	Auburn	9	95603	E6100000010C248267981E7243403B85DE3227445EC0	79cdd89c-3c91-48db-8277-46d04aad7251	2012-07-31 00:00:00
1093	7750 E Marching Rd	\N	Scottsdale	6	85257	E6100000010CEFCF6C4FABB44040ABA48C954EF65BC0	f181458a-b5a3-4944-b7b1-73dcad67c14e	2013-06-30 00:00:00
1094	25250 N 90th St	\N	Scottsdale	6	85257	E6100000010CE75D196D78DE404093193DA8DCFA5BC0	3e024d96-b7d3-4622-ab9b-0724b91b7832	2011-08-01 00:00:00
1095	9980 S Alma School Road	\N	Chandler	6	85225	E6100000010C32D7E7B357A24040DEDF948942FB5BC0	b09b3f8e-89f2-4528-9578-53cbcf805b4a	2012-12-31 00:00:00
1096	6753 Howard Hughes Parkway	\N	Las Vegas	52	89106	E6100000010CD6D0723A4E0942409806CD9343C45CC0	30c83112-a09f-4e26-9ad7-4fd6c10fec4e	2012-08-30 00:00:00
1097	Corp Ofc Accts Payable	\N	El Segundo	9	90245	E6100000010C508A797DD4F94040028CCC8659975DC0	5f6d242f-dda3-462c-bec1-097c63913176	2011-08-01 00:00:00
1098	Po Box 252525	\N	Santa Ana	9	92701	E6100000010C453D95B9D6E540409A92C3C1E8705DC0	7d2bd572-f8ab-435a-a47b-3a534d7d9cdc	2012-07-31 00:00:00
1099	62500 Neil Road	\N	Reno	52	89502	E6100000010C706AD11791B7434039244EB501F55DC0	be51f10f-1a66-46e6-8154-9fe01597769c	2011-07-01 00:00:00
1100	4635 S. Harrison Blvd.	\N	Ogden	74	84401	E6100000010C0593F2C5A4914440865872D6DDF45BC0	be4dfeef-cb1c-4af8-b517-3214c7c1f311	2013-07-31 00:00:00
1101	825 W 500 S	\N	Bountiful	74	84010	E6100000010CC297B75CD86944403975CB40F0EF5BC0	2e6d7491-e0a8-4c79-98ce-bac61a07fb25	2012-08-30 00:00:00
1102	603 Gellert Blvd	\N	Daly City	9	94015	E6100000010CE886400B50D242409C192FEC98975EC0	a8dcad62-8678-458c-87eb-e2c2e550ff80	2011-10-31 00:00:00
1103	2564 S. Redwood Rd.	\N	Riverton	74	84065	E6100000010C8691A87F353F4440E3C4ADFF3D035CC0	e299e96d-63cb-4acc-9bfd-5f0c23ae5820	2011-10-01 00:00:00
1104	9927 N. Main St.	\N	Tooele	74	84074	E6100000010CD38FF0F4194844403E7071F633105CC0	ce0fa600-8761-402c-a6c0-84fb6244984b	2011-07-01 00:00:00
1105	566 S. Main	\N	Cedar City	74	84720	E6100000010C474532D853D442409827D882CC445CC0	c16f92ab-817f-42d1-a560-bc0f86fe2783	2012-05-30 00:00:00
11380	165 North Main	\N	Austin	73	78701	E6100000010C94212031DB3A3E4020A10CBA196658C0	412e3088-1fb8-4a1f-b3a8-abb23a4f01c1	2012-05-30 00:00:00
11381	2000 300th Street	\N	Denver	10	80203	E6100000010C0EBDF5297DE04340645015D4303C5AC0	a9dbb460-a624-4e6a-aa22-311ee18f6746	2011-08-01 00:00:00
11382	99 Front Street	\N	Minneapolis	36	55402	E6100000010C262059C70A7A46405E4DFA05965857C0	878660a8-a9fe-4ef8-8d2d-53c614c6f042	2011-07-01 00:00:00
11383	1010 Maple	\N	Baltimore	32	21201	E6100000010C59FA019DC4AD434017695CBF421A53C0	6d3e3068-8792-4567-8d57-018b062d924b	2014-04-06 00:00:00
11384	500 35th Ave NE	\N	Los Angeles	9	90012	E6100000010CC3F3C878200D4140097E6848F1925DC0	35df6920-d4e9-47cb-9851-6e0aa1b4ed6e	2013-03-14 00:00:00
11385	9 Olive Way	\N	Seattle	79	98104	E6100000010CA50BCE4D94C54740B91032204A9C5EC0	abbe790a-4971-498b-94f0-a3db85e22984	2013-11-13 00:00:00
11386	1234 Seaside Way	\N	San Francisco	9	94109	E6100000010CD112C650FFEB424070AFA4D239965EC0	260e72a0-bf75-4377-bf47-8bd12cf34eb5	2009-04-26 00:00:00
11387	5678 Lakeview Blvd.	\N	Minneapolis	36	55402	E6100000010CF6DA1C0F1A824640736C8F63645757C0	fdf8fe8a-10cb-410d-8607-1acbfddd9f73	2007-11-28 00:00:00
11400	Marienplatz 50	\N	Hof	8	95010	E6100000010C4C157CBE0A2449405F9ED73540CD2740	930320c6-76b6-4797-ad7c-ca5e317016d3	2014-06-28 00:00:00
11401	8, rue de l´Avenir	\N	Drancy	179	93700	E6100000010C8C702A1C587E484025CAAC9F908B0340	7f668dd6-61a7-492d-8b7c-2c0fe4aa1a53	2013-12-21 10:09:29.423
11402	2356 Shady Ln.	\N	Burbank	9	91502	E6100000010CBAEFFDB5451441409EA2E0C9C38D5DC0	83ad0418-0248-459f-b222-23bba46dd218	2014-02-11 00:00:00
11403	76bis, boulevard du Montparnasse	\N	Orly	180	94310	E6100000010C26C29826D9584840CBFC56F941270340	d3ce354f-14b6-4ede-ba34-628c5ce8da9c	2013-12-21 10:09:29.423
11404	Auf Der Steige 6	\N	Neunkirchen	70	66578	E6100000010CE2D7F17683A548406F9FF8D45A711C40	d6da2fd7-e7a0-48f0-af23-451d6a0b7a3e	2013-01-21 00:00:00
11405	5, rue des Bouchers	\N	Orleans	131	45000	E6100000010C6343FE2DFDFA4740A079AB31A39CFE3F	9da8dbce-f036-473d-a5fc-ce3b8abbeb93	2013-12-21 10:09:29.423
11406	4006 Sunny Ave.	\N	Hervey Bay	64	4655	E6100000010C7B220390905539C0B8A37E3CEC1C6340	74a56ef0-63e7-45c3-abff-bf19fee5904a	2014-05-14 00:00:00
11407	Winter der Böck 254	\N	Salzgitter	19	38231	E6100000010C00000000000000000000000000000000	727bbb08-545a-45cb-ab51-a6d8ae573871	2011-10-13 00:00:00
11408	9965 V. Street	\N	Oxford	14	OX1	E6100000010CE31492B5CEE04940126B186B5D24F4BF	59ed32d4-e558-45df-b772-dfa8c8497998	2013-01-20 00:00:00
11409	5840 Delta Fair Blvd.	\N	Colma	9	94014	E6100000010CA3FACA0D16DE4240CD3A3A44CC955EC0	6241b5cb-6f55-4f3f-830b-7c584f59bc14	2013-09-04 00:00:00
11410	Buergermeister-ulrich-str 90	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	95dab278-c23a-4236-a234-1467e6175815	2012-11-17 00:00:00
11411	4746 Clear Court	# 61	Matraville	50	2036	E6100000010CBA272B5BAEF540C02C50642A9FE66240	efe97386-ff0f-4267-a4d1-416c277fe63b	2012-04-20 00:00:00
11412	3708 Montana	\N	Cheltenham	14	GL50	E6100000010CF3B479C3FBEA4940E76C0BB6C3A500C0	ecbb66f4-922e-4487-b9ae-cc5711a9f4a0	2013-04-01 00:00:00
11413	3378 Coldwater Drive	\N	Matraville	50	2036	E6100000010C7724F09F1D0041C05BFF25765DEE6240	72f397a0-e828-4d10-88d7-58fb484300f1	2011-12-16 00:00:00
11414	6463 Landover Ln	\N	Hervey Bay	64	4655	E6100000010C30B0CA2CF85239C0C37DF1ED1E146340	80b3d090-3c6c-4465-9841-22b03b47e34e	2012-07-20 00:00:00
11415	Dunckerstr 55	\N	Paderborn	53	33098	E6100000010CADDA2D8DE6DC49403967B71477822140	f4114109-9bbf-4380-9489-7c399237fec4	2013-05-13 00:00:00
11416	8206 Green Valley Road	\N	East Brisbane	64	4169	E6100000010CF08FDEB1C9713BC0E5B7D3D6E01E6340	0d6568fc-3af7-4c67-9a24-31131704c280	2013-08-20 00:00:00
11417	4304 Dos Rios Drive	\N	Ballard	79	98107	E6100000010C82282E5B32CE47404E5EA0DEE3A15EC0	9cceff27-0e52-4d95-b2de-d8ecb608485f	2013-10-06 00:00:00
11418	8138 Golf Club Road	\N	London	14	SW1P 2NU	E6100000010CBCD21F2D22C14940C563C7706D93C1BF	dd59cc88-539d-4150-80d6-b353461b24e6	2012-07-17 00:00:00
11419	673 Noah Court	\N	Port Orchard	79	98366	E6100000010C3383540E9EC947400547B9D092AE5EC0	712bc70f-4df4-4012-82db-a0d271b54851	2011-11-27 00:00:00
11420	9621 Alamo Court	\N	High Wycombe	14	HP10 9QY	E6100000010CB6EB6B667ED049402331B682AB43E6BF	04bbe237-76b9-4941-bbe2-e48ebb4c3eb4	2013-12-05 00:00:00
11421	82 Mt. Dell Dr.	\N	Silverwater	50	2264	E6100000010CB23159C9C68B40C04552A23210EE6240	5b743336-cbf8-42af-ae45-11344edac6cc	2014-05-15 00:00:00
11422	Zimmerstr 466	\N	Saarlouis	70	66740	E6100000010C4DB0E2740FB0484084ADEFD699071B40	3a0fff76-3a9f-490d-89dc-f04d5f57544c	2012-03-26 00:00:00
11423	6432 Maywood Ln.	\N	Goulburn	50	2580	E6100000010C3D36E302BA5141C09AAD84708CB66240	3f132cfd-c759-4196-8b94-253527598cb5	2013-05-19 00:00:00
11424	5287 Race Road	\N	Brisbane	64	4000	E6100000010C68424B8CCF733BC0B90648A22C226340	db78ac68-b6ad-4c2f-96fe-ec9b79269dc9	2012-07-12 00:00:00
11425	6828 Benedict Court	\N	Burlingame	9	94010	E6100000010C3464E964C0C942405FD9012E11985EC0	fc167225-348c-4e49-81b1-4dc77dab6af8	2014-06-05 00:00:00
11426	4787 R St.	\N	Bellingham	79	98225	E6100000010CBC5B5AA87F624840904BE602E3955EC0	4de53e10-143f-420a-8d7c-28d884754b60	2013-11-12 00:00:00
11427	Postfach 90 92 92	\N	Hamburg	20	20354	E6100000010CF225920447BD4A406D576D6F06022440	dc9e33b2-cb25-42d8-993a-1fce6cee23c2	2014-05-22 00:00:00
11428	1955 Montgomery Ave	\N	National City	9	91950	E6100000010C662017C8F25940408E6C7C019E3A5DC0	61e643d9-91a3-4d4f-8ddf-3dbbe61227c7	2013-09-18 00:00:00
11429	4428 Jones Rd.	\N	North Ryde	50	2113	E6100000010CDC761CB362DF40C02825869988EA6240	9cd7a5ec-2d4e-4b50-a372-15714ba941e8	2011-07-21 00:00:00
11430	8502 Diver Way	\N	Chula Vista	9	91910	E6100000010CB5AB5156B851404096AD0E8E1F3E5DC0	b2198ed6-2e16-4621-93ee-c1bd49090c1a	2011-12-28 00:00:00
11431	8, rue des Vendangeurs	\N	Paris	161	75012	E6100000010C8DA79E52406A48402B52494DDA620340	ca34d46e-4e83-4d5f-80eb-36db88afebc4	2013-12-21 10:09:29.423
11432	6868 Firestone	\N	Victoria	7	V8V	E6100000010CF88483DCC42E4840A8687585DACD5EC0	a9a12797-5593-4093-909c-3ba70164145e	2013-07-31 00:00:00
11433	2530 Seeno St	\N	Wokingham	14	RG41 1QW	E6100000010C225D81E2B6BC4940862CD7FCDE34EBBF	a2e442fd-8b6b-4f03-a02d-154f789e7cfc	2014-02-16 00:00:00
11434	6400 St. John Lane	\N	Port Hammond	7	V6B 3P7	E6100000010C25D9C89DD0A94840C3B8D7A191D05EC0	e51a6205-e301-4fce-9fe9-87562c1679af	2014-01-21 00:00:00
11435	109, avenue des Ternes	\N	Les Ulis	177	91940	E6100000010CA12B1AC02250484056A45A981D510140	9e7d8d46-453b-4fe9-a467-603884eeeb85	2013-12-21 10:09:29.423
11436	Curieweg 3991	\N	Bonn	53	53131	E6100000010CD2419443E4574940979C174924601C40	59c7e622-1a26-440a-a742-29d12b961a61	2014-03-28 00:00:00
11437	3852 Northridge Dr.	\N	Geelong	77	3220	E6100000010CA534AC5BBE1243C0ED00CCEE10056240	02d57a39-4a03-46fd-9c97-53d0eca6c08d	2014-03-02 00:00:00
11438	4310 Chickpea Ct.	\N	Burbank	9	91502	E6100000010CFB53AAB6D5134140D1E5BCA810935DC0	740ccb68-86ed-45b6-86f4-2b9570b21c74	2014-06-28 00:00:00
11439	7549 Longview Rd.	\N	Beverly Hills	9	90210	E6100000010CB8D86C3AD70941403870848AC1A35DC0	c7c00a7b-fa5c-4ae2-ba4e-36cc752ee514	2013-11-18 00:00:00
11440	9762 Alvecedo	\N	North Ryde	50	2113	E6100000010C2C87BD762BE740C0B46F53ACCBE26240	86110239-a4f7-4e8d-b950-997c97ae21ca	2013-01-16 00:00:00
11441	8426 Easley Dr.	\N	Melton	77	3337	E6100000010C62F1D781E8D142C0342ACACBBB0E6240	7f688d5e-6adc-4236-99ca-1c6eebae1df6	2013-10-02 00:00:00
11442	4893 Crane Court	\N	Runcorn	14	TY31	E6100000010C206E2FC61FB14A40ED2122F742AD05C0	7587b28b-7b56-49f1-bee0-691ec14c6f9d	2013-03-12 00:00:00
11443	9739 Benedict Court	\N	Milton Keynes	14	MK8 8DF	E6100000010C4AA6EF0013064A4061652817A26DE9BF	56f0eea3-e85f-4fb3-8f81-f8cf00323790	2013-09-18 00:00:00
11444	Carlsplatz 45	\N	Ingolstadt	8	85049	E6100000010C4AC52D1A8A5E48404E1E761B7DA62640	4e5e2165-dd17-43f1-a3a4-0be284a86424	2014-04-04 00:00:00
11445	491 Cali	\N	Burlingame	9	94010	E6100000010CC0E49F74E7C5424045ED2F2BAB8E5EC0	5fae432a-2ec7-4587-9a49-c418bafd14a6	2013-10-19 00:00:00
11446	70, rue Georges-Clémenceau	\N	Roissy en Brie	163	77680	E6100000010C2BA0AB1FF8614840B518C0E1E4460540	20ee174b-ec09-4696-9365-615bc5815195	2013-12-21 10:09:29.423
11447	8634 Lake Meadow Circle	\N	Runcorn	14	TY31	E6100000010C660695BFA9AB4A4032E0DE075FAE05C0	59f8420a-a0c4-43ee-b0c3-f861ec396c04	2013-12-19 00:00:00
11448	Höhenstr 7477	\N	München	20	80074	E6100000010C00000000000000000000000000000000	4e82a124-3b8a-4233-a68e-088427fb807c	2014-05-17 00:00:00
11449	3359 Northwood Dr	\N	Woolston	14	WA1 4SY	E6100000010C4515935694B34A404FA4DF45572404C0	63dce7db-8e9a-44e2-812d-b464ccaf6276	2012-01-09 00:00:00
11450	3326 Icicle Ct.	\N	North Sydney	50	2055	E6100000010C1B5AE58EFEE940C03D6B1831CDE06240	1dedb58c-6c76-4ce4-8ace-6c3382019b79	2014-03-12 00:00:00
11451	Auf den Kuhlen Straße 2	\N	Hamburg	20	20354	E6100000010C0739618655BF4A404C0C0651CAF72340	c677da3f-f9aa-4306-b962-b6ad2418baa7	2014-03-12 00:00:00
11452	639 Bird Drive	\N	Burlingame	9	94010	E6100000010CED230EDDACCB42408B735B30E69F5EC0	bf259dbb-48e0-453e-b73d-9c5212f9c5b8	2013-07-28 00:00:00
11453	7464 Mozden Lane	\N	Wollongong	50	2500	E6100000010C4DE2B9B1933941C076E3510BCADC6240	46f68d5b-1f9e-4f2c-b00d-887b7d071732	2014-04-15 00:00:00
11454	8360 Frisbie Court	\N	Newcastle upon Tyne	14	NT20	E6100000010C394481B6F4784B40802AB93F2FD0F9BF	2e8a92d9-fdbb-47ec-b51f-abef568fa2ef	2011-08-30 00:00:00
11455	7489 Relief Valley Ct	\N	Kirkby	14	KB9	E6100000010C391E4DE56CC54A40FE00D8233C2707C0	bd731e71-5f74-40d6-afe7-d627af414aff	2013-12-16 00:00:00
11456	102, rue de Berri	\N	Les Ulis	177	91940	E6100000010CA12B1AC022504840819BCFD0E54E0140	d4dcd630-3140-4add-ac86-d4df8b0d7f8e	2013-12-21 10:09:29.423
11457	Midi-Couleurs	\N	Courbevoie	178	92400	E6100000010C135E91609C6E484019A62A96B40E0240	6fa0425f-06d0-41de-bde2-5e98bc5fefca	2013-12-21 10:09:29.423
11458	267 Aspen Drive	\N	Burlingame	9	94010	E6100000010C49955FA289C242403F35112DEF945EC0	2a3ce5cc-ea5c-46f7-8e34-7bc9d7cc75dc	2012-12-14 00:00:00
11459	4, rue de la Comédie	\N	Dunkerque	145	59140	E6100000010CB8A7E166EC7E4940733E0F5EADCB0240	56a5955d-89c9-4124-9387-9ad066054118	2013-12-21 10:09:29.423
11460	9759 Dover Way	\N	Peterborough	14	PB12	E6100000010CA854825E054A4A40B6C87C89DF03D0BF	e14e28d9-8162-4c7b-895a-24f17400b98b	2013-07-18 00:00:00
11461	Heideweg 1459	\N	Essen	20	45001	E6100000010CAF66CEAF8D634A40A71FEB6406AC1F40	5d3a5f15-4bdc-4d34-8798-733a5e9bb745	2014-03-03 00:00:00
11462	7041 Notre Dame Avenue	\N	Cambridge	14	CB4 4BZ	E6100000010C70FE451F0B244A40741F27056C68BC3F	467b2eb6-4f60-414c-89b5-03e72b670c6e	2012-08-02 00:00:00
11463	2111 Freedom Court	\N	Sunbury	77	3429	E6100000010CBA8BA412ABC642C099F7C324D41C6240	2ced8061-cf85-4edc-b384-53f1b25f5201	2011-11-04 00:00:00
11464	312 Via Del Verdes	\N	Colma	9	94014	E6100000010C59F49F3128DC424073EBEC40119C5EC0	531f4a92-ee0c-4d27-b504-9782057717d2	2013-09-02 00:00:00
11465	5435 Jacobsen Street	\N	Malabar	50	2036	E6100000010CAD5978ED8C0041C0F6D610A20AE96240	f58f3621-14ed-46ff-9ba3-8699e2f0f2ba	2014-05-20 00:00:00
11466	2062 Woodruff Lane	\N	Peterborough	14	PB12	E6100000010CC5C50D1959494A4056853A945CF7CFBF	377bf174-abb8-4813-bac9-4831b02dade0	2014-05-06 00:00:00
11467	910, place de la Concorde	\N	Les Ulis	177	91940	E6100000010C5EBEAA34BA5A4840DAA7F8B400520140	c1929a68-a705-4823-8951-cf53f3e22072	2013-12-21 10:09:29.423
11468	2192 Pacifica Ave	\N	Cloverdale	66	6105	E6100000010C1314BB6925F33FC092685CDC66F85C40	656227a8-ee6e-4b2b-8a62-8f2523513e93	2013-12-13 00:00:00
11469	2423 Brookview Dr.	\N	London	14	SE1 8HL	E6100000010CE7A8721C53BC49402D7B7775A6DFBABF	c384997a-1a93-4147-8077-26b8cfa2edf8	2012-07-01 00:00:00
11470	9761 Fox Way	\N	Townsville	64	4810	E6100000010C361308B9E83D33C06063BEE927546240	9866c9e2-1fe5-465c-a223-857dc096f820	2014-02-15 00:00:00
11471	2807 Charlotte Court	\N	Rockhampton	64	4700	E6100000010C2E13EC86E26937C0A344B2084BCA6240	9af8fe41-5b3c-48bf-a710-a79b2a7ee810	2013-12-03 00:00:00
11472	1354 Catnip Court	\N	Tacoma	79	98403	E6100000010CF0F84993FEA34740F937C0E63D925EC0	1a2e2d23-d1ab-4802-a70c-325535824133	2014-05-07 00:00:00
11473	Bundesallee 44	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	54950817-b818-4c8d-b0d3-dcb9c92f6f02	2013-03-17 00:00:00
11474	2665 B Wildbrook Ct	\N	Warrnambool	77	3280	E6100000010C7793CD37D70A43C0EF5B2F1B95CC6140	29b04bf3-c6aa-4505-85f9-b05665e4708f	2012-07-07 00:00:00
11475	4556 Rolling Green Circle	\N	Findon	66	5023	E6100000010CA35F7D70F67641C07AD0CDC05D576140	e8593a43-65aa-4397-a422-877d37ba8a4f	2013-12-23 00:00:00
11476	5957 Pacifica Ave.	\N	East Brisbane	64	4169	E6100000010CB7E52208E6733BC0DC67880ABC256340	5486bc3f-9f11-4091-96cd-9a1d13e66045	2012-06-28 00:00:00
11477	9431 College Blvd	\N	Puyallup	79	98371	E6100000010C983CCD4B509C4740D89D702ED4945EC0	c83e37be-aca4-440a-98c5-f699eb6d0987	2013-10-13 00:00:00
11478	Alderweg 4518	\N	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	352a8161-ba73-40f3-aa0e-f97856ac9177	2014-05-03 00:00:00
11479	1240 Dayton Court	\N	Townsville	64	4810	E6100000010C156B74C8E03F33C045E6ABA67C5E6240	466b35e5-281b-49e2-8a2c-fe2a58809d00	2012-09-13 00:00:00
11480	3213 Glenside Dr	\N	Beverly Hills	9	90210	E6100000010CD57B12AF631041408A46E671739E5DC0	9a9c55a9-40ea-43a8-9302-4535ab30c895	2013-08-07 00:00:00
11481	9471 Shell Dr.	\N	Bremerton	79	98312	E6100000010CB5475E64BECA47401F2CFAD5DAAD5EC0	7cbaaec7-fd72-4f8d-b73a-a4e6f97e3720	2013-02-17 00:00:00
11482	5636 Barcelona	\N	Cranbourne	77	3977	E6100000010C9C8F284FCE0C43C044B3527DE22B6240	ed6a961e-3f21-4c9e-9b23-3c4c195ca01c	2012-03-02 00:00:00
11483	7046 Slow Creek Road	\N	Colma	9	94014	E6100000010CA3FACA0D16DE42409EE4A3A403955EC0	7d316ae5-a5af-4f49-9ef6-58b6b1a14cd2	2012-06-16 00:00:00
11484	1706 Valley Blvd.	\N	Palo Alto	9	94303	E6100000010C6670E68F22BE4240B5FE472C80875EC0	eb392077-cd7c-42c8-b94d-cb1b9018d8e1	2013-11-21 00:00:00
11485	2000 Thornwood Dr.	\N	Portland	58	97205	E6100000010C993C2C7CEFB546400C2CD51DD1B15EC0	bd043ea4-d538-479a-b8d7-159a0ad5fed0	2014-05-20 00:00:00
11486	2104 Grading Way	\N	Brisbane	64	4000	E6100000010C7FF56F46C37F3BC06A4B790E22246340	d0f3bea7-a024-46e9-afff-d8dca69a379c	2013-08-06 00:00:00
11487	3022 Adobe St	\N	Milsons Point	50	2061	E6100000010CC656AC3AE5E540C060FF0FE530EB6240	a9d80c8e-3b52-4b14-b0b6-ac2ad15f0ebd	2014-06-03 00:00:00
11488	2256 Regency Dr.	\N	Cheltenham	14	GL50	E6100000010C83E103E24FEC49406EFE77AE30A600C0	455cb83c-80e7-46cb-a443-cff435329dce	2013-11-07 00:00:00
11489	5339 Cashew Street	\N	Burlingame	9	94010	E6100000010C0255841A76C442407F7DF22E339B5EC0	c07bb5b0-a02e-4043-9db6-d09d9bebdc3a	2012-05-24 00:00:00
11490	6270 North Star Dr.	\N	Concord	9	94519	E6100000010C9C8EA4607A0343403887548EB38A5EC0	e7061dd0-1f9c-4b0d-8f31-3d5088ce7664	2013-12-17 00:00:00
11491	5648 Roland Ct.	\N	Wollongong	50	2500	E6100000010C6FC2B0274A3441C0E995102F83D66240	747b2f88-81b6-4639-9b8e-00771108a7f1	2012-09-12 00:00:00
11492	3241 West Slough Rd.	\N	Port Macquarie	50	2444	E6100000010C3E66EDE68C5E3FC08AA5DD1940196340	fa68fb5d-8c16-42d1-8805-53e3ffd670cd	2011-08-23 00:00:00
11493	793 Crawford Street	\N	South Melbourne	77	3205	E6100000010C51F56D953EE642C00E23657DF01B6240	d7ee73c5-3fa8-41aa-903a-21b2783348cd	2011-11-10 00:00:00
11494	1289 Pine St	\N	Perth	66	6006	E6100000010C67AA896F0CE43FC0EE876465BFF05C40	9fff12b3-17f3-4493-8109-c715ae937eb4	2013-10-18 00:00:00
11495	3691 Macaroon Drive	\N	Townsville	64	4810	E6100000010C644D54967A3933C06536577FCA596240	0dac94d3-c388-4487-b38e-bfb7139bb2b2	2013-10-10 00:00:00
11496	Auf Der Steige 2	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	ee3bda9a-d4fd-4993-b80a-2775012933da	2014-06-21 00:00:00
11497	9142 All Ways Drive	\N	Colma	9	94014	E6100000010C3213BE6D07D24240BF4A8F5B41A65EC0	0ca8740a-3671-483c-a88a-c93ad491cc23	2013-08-14 00:00:00
11498	11802, rue Surcouf	\N	Colombes	178	92700	E6100000010CD2932E9EF66D48408EF2E2FD31F60140	d5a99881-cef3-4fd4-b3a4-08bee3171185	2013-12-21 10:09:29.423
11499	240 Rapallo Lane	\N	London	14	SW19 3RU	E6100000010CE24F435AA9BF4940A8A39A65A387CABF	1c08c6cf-437d-4968-be98-07cfcc357ca9	2012-06-09 00:00:00
11500	Attaché de Presse	\N	Paris	161	75016	E6100000010C3BDDBE9AA26748405698B554EA0F0240	5ed5c170-44bd-498e-95a4-b607dce3dc28	2013-12-21 10:09:29.423
11501	48 Lacanda Ct.	\N	Townsville	64	4810	E6100000010C70DF0C83043733C0710B14D6CE516240	b591d768-20b6-43d2-b4b6-87624b2cc045	2012-09-27 00:00:00
11502	3629 Warren St.	\N	Beverly Hills	9	90210	E6100000010C300CA407721341403A0AD5636B9B5DC0	70abd1d6-aa82-4dd1-9b1c-cb0554a0d662	2013-09-21 00:00:00
11503	9577 Santa Fe	\N	London	14	C2H 7AU	E6100000010CAD16F2C73CB84940C4CFCC87D142C0BF	f1f99c02-b1dc-4417-8aeb-8e0d0c8e50c4	2014-03-06 00:00:00
11504	7291 Summerfield Dr.	\N	Coffs Harbour	50	2450	E6100000010C6DABCB9DD71D3EC0AD3E0755001D6340	434fc054-c356-4209-b789-d2092f681097	2014-01-15 00:00:00
11505	212 Pheasant Circle	\N	Oxford	14	OX14 4SE	E6100000010CD558CF70E4CD49406DE39F5D997BF4BF	081daa0c-9c1e-4754-90ae-c82cd79482f8	2012-10-27 00:00:00
11506	7141 Second Ave.	\N	Malabar	50	2036	E6100000010C84F2A20D3FF540C05BFF25765DEE6240	44a850f7-ae30-44c7-b24a-0714738fe0af	2012-08-19 00:00:00
11507	424 Yosemite Dr.	\N	North Ryde	50	2113	E6100000010C8669A568D1DF40C01C9733A260E06240	6b82a1fb-9aa3-401e-be22-d9be330e9b1e	2013-04-20 00:00:00
11508	1433 Manila Avenue	\N	Cloverdale	66	6105	E6100000010C23F3862699EC3FC0DF1BA56A04055D40	f395fa81-b87b-4eac-9579-2478b98121f5	2013-07-03 00:00:00
11509	2110321, boulevard Beau Marchais	\N	Les Ulis	177	91940	E6100000010C05F610BCDF534840059F6DEDC84F0140	4eb6c637-6796-4b16-9d82-df2cdec35176	2013-12-21 10:09:29.423
11510	Buergermeister-ulrich-str 433	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	bdbd9c61-c0e4-4904-9145-bfc7528ea920	2013-09-06 00:00:00
11511	7403 N. Broadway	\N	North Ryde	50	2113	E6100000010C74BC99A070E540C08F50596804EB6240	07eaaf7d-e277-46b7-83a3-b235f2311d68	2013-10-04 00:00:00
11512	Am Gallberg 46	Einkaufsabteilung	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	be1f5928-c3d7-4366-bbce-7e64a379f2d4	2012-06-28 00:00:00
11513	5308 Logan Court	\N	Watford	14	WA3	E6100000010C369BD5E6B9DC49401B77DFF8CB03D9BF	f53a273b-d52b-4ff9-b392-ebb698599736	2012-08-03 00:00:00
11514	26, rue Saint Denis	\N	Pantin	179	93500	E6100000010C0E54A1FA42794840CA8008FEFB4C0340	be3ae115-49cb-4fbc-b7f1-8ab9ded52261	2013-12-21 10:09:29.423
11515	Lindenalle 24	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	2680b31e-5b5f-466c-b77f-3c9a2d68cb97	2014-05-15 00:00:00
11516	9549 Roxbury Drive	\N	Bendigo	77	3550	E6100000010C4A5592DB145F42C0CB00F8BC230C6240	a96eec6f-994e-4a7c-8b2d-fe7cc797dcce	2013-03-14 00:00:00
11517	593 Willow Pass Road	\N	Melbourne	77	3000	E6100000010C17C9C9D093E642C00151694877236240	fbaf426a-07ad-4af1-b9c3-54b9448a5a07	2013-05-13 00:00:00
11518	Am Kreuz 123	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	422998b5-27da-4b79-80b0-10e15607b49f	2013-11-08 00:00:00
11519	1354 Helene Court	\N	Malabar	50	2036	E6100000010CE6665C2C4AF840C066E46991E1ED6240	af19f45d-3a1b-426e-9377-0bc778b5e99b	2014-01-29 00:00:00
11520	4752 Willow Creek Ct.	\N	Coffs Harbour	50	2450	E6100000010C48184AE13E233EC04C96E1181B186340	943a8630-3e91-4377-a8ed-0d1e0ac9e0a6	2013-07-26 00:00:00
11521	3723 Mt. Sequoia Ct.	\N	Barstow	9	92311	E6100000010CE2EF2600A56441403EE28A4E193E5DC0	e5efb993-2dc0-4109-9ded-4299c9ed6444	2011-10-16 00:00:00
11522	6445 Cashew Street	\N	Marysville	79	98270	E6100000010CBBD4DC0DD4FF4740E7B8547B988C5EC0	aa669527-0282-4c3e-b457-7f0ad7341089	2013-10-02 00:00:00
11523	8224 Georgia Street	\N	Cliffside	7	V8Y 1L1	E6100000010C03290C5E0E45484049B0CCE2E8D25EC0	80a23dfe-30fa-4407-8d5d-ce4b63b31a94	2012-07-05 00:00:00
11524	131, boulevard Beau Marchais	\N	Metz	143	57000	E6100000010CC3CFCD788F8C4840EC26935DCDB71840	dcb9d5c5-dccd-45a7-aa1f-2cc8a0120a0b	2013-12-21 10:09:29.423
11525	Am Karlshof 8	\N	Kassel	19	34117	E6100000010C051C37F5B9AD4940FE18285BBCFB2240	0e53537e-55e0-4b26-b405-7ef60f4f4d8f	2014-05-01 00:00:00
11526	Kulmer Straße 765	\N	München	70	48001	E6100000010CC34476579C14484067984CBDD0432740	0268c2d9-9adb-4cbc-ac77-1974f50dd084	2013-09-08 00:00:00
11527	579 Meager Dr.	# 1	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	b632c66f-1375-48e8-aebc-800e081a4b6a	2012-12-19 00:00:00
11528	7232 Mulberry	\N	Newcastle	50	2300	E6100000010CE37319C7267340C0219B07A647FE6240	edaec48c-d01b-4014-8760-a13bd97d52c1	2013-09-02 00:00:00
11529	6521 D Bel Air Dr	\N	Bellflower	9	90706	E6100000010C04789095EDF54040D24754934E8A5DC0	16fe84a9-3c1d-42de-822e-93cdd805cb03	2014-02-23 00:00:00
11530	935 Vista Oak Dr	\N	Bendigo	77	3550	E6100000010C776981C6416442C03FE80FB185076240	4b9082ae-190a-46b6-b0b2-510ff6419154	2013-05-23 00:00:00
11531	280, rue Lamarck	\N	Tremblay-en-France	179	93290	E6100000010CA208C13FD9734840B1A16CB2B1690440	6e70cf3a-64e9-4978-9739-0791d031414b	2013-12-21 10:09:29.423
11532	9456 Bell Dr.	\N	Burlingame	9	94010	E6100000010CCA832019A3CC42403F727BAA518C5EC0	8c2c8afc-0f60-41a5-a5bb-3cfa1fc793f7	2012-05-21 00:00:00
11533	8537 Partridge Dr.	\N	Bremerton	79	98312	E6100000010C75827F93EAC847401F2CFAD5DAAD5EC0	729b8cb2-aa42-4176-aadf-82b9ffb7f01b	2013-08-24 00:00:00
11534	99, rue du Départ	\N	Paris	161	75013	E6100000010C04743ECC3871484037AF028E918C0240	b0ce1e7d-86a9-460e-8e08-4e12ee79eff0	2013-12-21 10:09:29.423
11535	8452 Dewing Avenue	\N	Bremerton	79	98312	E6100000010CB44E87252ECD47402A18CB5D7FB65EC0	81a5db82-9a9e-4cdb-bd0c-e3753dc79525	2012-04-24 00:00:00
11536	4619 Mount Orange Ct	\N	Lavender Bay	50	2060	E6100000010C919EA9FA59E740C0F42C1D3402E66240	870ac21c-534f-452a-879f-ecebe12e393a	2013-05-09 00:00:00
11537	6049 Dalis Dr.	\N	Brisbane	64	4000	E6100000010CF24C2F8883743BC0C1700ADBB91F6340	b66e5f89-ffab-4327-a383-6ea75de2f163	2012-02-22 00:00:00
11538	7, place Beaubernard	\N	Drancy	179	93700	E6100000010C8C702A1C587E4840EA04397912910340	a5cf1914-21f8-4254-af01-233a7f96fc2a	2013-12-21 10:09:29.423
11539	7941 Cristobal	\N	Grossmont	9	91941	E6100000010CDC2E821DEC5F40401142846648405DC0	9181646a-2ddc-4162-997b-7bd5a5cf8281	2013-11-26 00:00:00
11540	8005 Ranchhand Court	\N	Bellingham	79	98225	E6100000010C85AFCB93815D4840C27C7E0337A35EC0	762ad093-8696-46c8-a652-ebebeb2f36bd	2013-10-30 00:00:00
11541	7330 Saddlehill Lane	\N	Sunbury	77	3429	E6100000010C7AAC23C961C142C04219EED8BB176240	18f8284f-8840-4508-82bc-d4924cece3ff	2011-06-14 00:00:00
11542	4055 Leonard Ct.	\N	Warrnambool	77	3280	E6100000010C7F43862C970143C0BD9973834DCA6140	03c13280-a991-4487-b057-0980357d69b2	2014-02-27 00:00:00
11543	2715 Euclid Ave.	\N	Hervey Bay	64	4655	E6100000010C55EBE41CF25F39C00C2A96C9631E6340	445c1729-e350-497e-9e6a-93a579d1c160	2014-05-31 00:00:00
11544	154 Kentucky Dr.	\N	Hervey Bay	64	4655	E6100000010C003E92C95F5039C06A8A20080E176340	c0488de7-6538-4e12-b329-9797835e63b2	2014-02-02 00:00:00
11545	5243 Harmony Way	\N	Clearwater	15	33755	E6100000010CEE42EBE339FB3B4072001DB749AE54C0	88c08c23-eb51-4247-9e74-85d34f1e0c2b	2012-11-30 00:00:00
11546	4185 Keywood Ct.	\N	Woolston	14	WA1 4SY	E6100000010C3DA7E151F2B44A40081373D10B2B04C0	2cb4e065-f9e0-4df4-9386-c1dcf8072644	2011-08-17 00:00:00
11547	8404 Houston Ct.	\N	Goulburn	50	2580	E6100000010C04F306FCDD4841C0238D5112DCBA6240	a3ce2208-2803-4b49-8f13-852d990dc6de	2012-04-15 00:00:00
11548	4679 Duke Way	\N	Burbank	9	91502	E6100000010C3927A5B425154140332B60E2649B5DC0	356bf2f7-e087-4c0d-b3b3-b3e8cc2a4270	2012-01-31 00:00:00
11549	1619 Stillman Court	\N	North Sydney	50	2055	E6100000010C49E60F27D4E740C02E96012AEEEB6240	c3e82234-3265-4fab-9f04-742230dd3831	2013-04-01 00:00:00
11550	Hauptstr 2929	\N	Frankfurt am Main	70	60075	E6100000010C00000000000000000000000000000000	92eec5fe-56c5-4f8a-a5de-6e6c86af067e	2014-03-18 00:00:00
11551	29, rue Saint Denis	\N	Metz	143	57000	E6100000010C6C85403479934840699D6462AAC01840	5a6b6b48-cd93-4945-9889-220e4c5aad1e	2013-12-21 10:09:29.423
11552	5805 Churchill Dr.	\N	Concord	9	94519	E6100000010C0EB10ED25FFC4240E42A27CC21755EC0	5b7a0606-da07-43bb-89c4-b500d9018cc7	2012-12-21 00:00:00
11553	2173 Heartwood Drive	\N	Brisbane	64	4000	E6100000010CBC966B6B6F793BC0D1F382F1561A6340	a2a512a4-5c6e-4393-a208-de01debd1802	2014-04-12 00:00:00
11554	Welt Platz 99	\N	Eilenburg	85	04838	E6100000010CEDCC96569EC44940EBBE67103B5E2940	6e15c64d-ad8f-49b1-a4d3-e69f1d54c378	2013-09-10 00:00:00
11555	Platz des Landtags 404	\N	Solingen	53	42651	E6100000010C520B20E1249949401EED39F6D86D1C40	45cdeb46-aafd-497a-8a16-d23d4fba186f	2014-02-25 00:00:00
11556	1415 Edwards Ave	\N	Silverwater	50	2264	E6100000010CEC42A603719040C0E09AF3D6A3EB6240	f315bedf-f1b2-41ad-be86-cd602b5217f2	2014-01-05 00:00:00
11557	6969 Lancaster	\N	Warrington	14	WA3 7BH	E6100000010C76BF063328BE4A40D9FDC5F5C0A604C0	1c54d8b4-a554-4bd5-99f8-65d05d02d056	2013-10-25 00:00:00
11558	2602 Glenside Court	\N	Brisbane	64	4000	E6100000010CCF0DD7A04B703BC0C1700ADBB91F6340	4e91954d-c198-4c32-a0e3-157538d93ce5	2012-05-08 00:00:00
11559	6, rue des Vendangeurs	\N	Cergy	181	95000	E6100000010C2FC0AEB5EA894840EC2912D962850040	de81ba21-d054-435e-b14e-10d04bfb092f	2013-12-21 10:09:29.423
11560	8368 Birchwood	\N	Seattle	79	98104	E6100000010C122F1FE587C647409FEA9D6940985EC0	7908cd48-291e-4d83-b68d-e5bd3f92013c	2013-09-17 00:00:00
11561	7772 Golden Meadow	\N	Colma	9	94014	E6100000010C4F4B881A9ECF4240278C4A26E1915EC0	19ae7fb8-18f6-477e-a0d7-ad75ccc4341c	2013-05-29 00:00:00
11562	7445 Meaham Drive	\N	Metz	143	57000	E6100000010C2EB03BBEFC9548407E219DF2DDBC1840	25d24cf8-1788-4990-b345-268d6c30c34a	2013-12-21 10:09:29.423
11563	9277 Ridgewood Court	\N	Coronado	9	92118	E6100000010C7E4178FCE6584040C7B2C52DEC4C5DC0	d2d806c0-b85a-428d-b974-c4349fab9585	2013-05-09 00:00:00
11564	276, chaussée de Tournai	\N	Orly	180	94310	E6100000010C37FFF0A2765E48401D8BC3B9982F0340	1d0ba81e-dd3e-40c2-92f4-6b3277ff9142	2013-12-21 10:09:29.423
11565	4430 Ardilla Road	\N	North Ryde	50	2113	E6100000010C8F6CCFE108E840C00B15BA35EDDE6240	72362ac3-feb6-4265-ad38-32b13150613d	2013-07-22 00:00:00
11566	Hauptstr 6039	\N	Berlin	19	14111	E6100000010CAB96DB1E9D374A40C4AE12B106FE2A40	0a1479b3-2bf5-4fcd-a630-3a7ca017f089	2012-02-12 00:00:00
11567	7596 Valley View Road	\N	Sunbury	77	3429	E6100000010C392CDEE34DC342C04219EED8BB176240	5a063829-541a-40fb-ad34-1f3cfc48ab7e	2013-01-17 00:00:00
11568	674 Woodchuck Pl.	\N	Port Macquarie	50	2444	E6100000010C7D2A871BED583FC051E8F34819206340	0a787405-1719-4e60-b8c6-a16e10ac9d39	2014-01-17 00:00:00
11569	21, rue des Rosiers	\N	Burbank	9	91502	E6100000010C55D83CADF51941400C61CB457E8B5DC0	cc1edd0b-4d00-4870-a06d-8af8c7cd16b6	2014-05-25 00:00:00
11570	Auf dem Ufer 2	\N	Hamburg	20	20354	E6100000010C8216348BD1C44A40F6B7FB4DC4F62340	1172dafe-fcd9-4616-8c3f-f27635fefcbc	2013-04-25 00:00:00
11571	4627 Lakefield Place	\N	Burien	79	98168	E6100000010C755E046DCBC14740C892A71869985EC0	dd89e546-71c0-4a1e-8ebe-e11268fe4721	2013-12-08 00:00:00
11572	8185 Sol Street	\N	Liverpool	14	L4 4HB	E6100000010C32CCDC36BABA4A4039660744C4C207C0	9e5d3154-94d8-449e-8b52-b7092f1164ba	2012-01-22 00:00:00
11573	5469 Poor Ridge Court	\N	Gold Coast	64	4217	E6100000010CD5ADE7DD2A043CC0C331A85C802F6340	d3e8ead3-d4b6-4d84-8fc4-e45ce303cc37	2014-04-18 00:00:00
11574	3947 Vista Valley Rd	\N	Hobart	71	7001	E6100000010C4A3E7B53796245C0966C1CC0E96B6240	1a9cd6b7-ba97-4930-aa86-b6d19f14cca4	2013-12-15 00:00:00
11575	3556 High Maple Court	\N	Beverly Hills	9	90210	E6100000010C28851CBD22124140725959672D9C5DC0	40d55a87-bcf6-4f12-b6df-21ce9690458d	2013-11-25 00:00:00
11576	5402 Panorama Drive	\N	North Sydney	50	2055	E6100000010C1B5AE58EFEE940C090AAB44B72EB6240	de5db30f-bf8f-4ca1-ba0f-5a45c07eb1c1	2011-08-24 00:00:00
11577	68011, rue Malar	\N	Colombes	178	92700	E6100000010C6D095D81DC794840CE2D776A93F70140	bb01b5de-4384-456a-9943-c2bfb9ad7577	2013-12-21 10:09:29.423
11578	1725 La Salle Ave.	\N	Wollongong	50	2500	E6100000010C6FC2B0274A3441C0827AA4647AD76240	bc35e5d7-6197-4318-b346-cc0ce00fe66f	2011-06-22 00:00:00
11579	7496 Sunset Meadows	\N	High Wycombe	14	HP10 9QY	E6100000010CCF1626D243C549403308B65D443CE6BF	b47c757a-4adc-44bf-ab8c-f0b297f18324	2014-05-14 00:00:00
11580	3193 Mehaffey Way	\N	Springwood	50	2777	E6100000010CCD10435FB1D340C0E25C8251E3CC6240	fded5318-2f1b-4cfb-b10f-b457a1f339a8	2011-06-21 00:00:00
11581	3068 All Ways	\N	Palo Alto	9	94303	E6100000010CC542E0C537BC4240F146990419905EC0	5880b29f-8830-4051-9427-f1262469dfe3	2013-10-31 00:00:00
11582	4262 Monterey Ave.	\N	Darlinghurst	50	2010	E6100000010CCC53FA6E88EC40C0111B90C52AEC6240	5a1692a8-4a46-44af-8706-7f8d473afadc	2011-11-07 00:00:00
11583	Postfach 22 99 99	\N	Frankfurt am Main	70	60075	E6100000010C00000000000000000000000000000000	a9b2a406-2329-410c-94b2-9da9e42b874e	2013-09-30 00:00:00
11584	39, route de Marseille	\N	Paris	161	75009	E6100000010C62245C1745754840BC73507642BA0240	b6e99d97-1a32-4d58-9974-6fae27f4265c	2013-12-21 10:09:29.423
11585	9105 Santa Fe	\N	Perth	66	6006	E6100000010C551628EF69E23FC09892C3A8B6F35C40	750b0ed9-a882-40e6-b562-ee9049be936a	2012-12-09 00:00:00
11586	6999 Salem St.	\N	Berkeley	9	94704	E6100000010C6DD6A7F4FBF042408546695039975EC0	8fab4209-f2d0-4afc-b41a-4e2b829a0439	2012-11-12 00:00:00
11587	211bis, rue des Peupliers	\N	Versailles	164	78000	E6100000010C276DC5E56F6548400B27C4DB60EC0040	b9dd6beb-1bb8-4b44-be02-2276450cf755	2013-12-21 10:09:29.423
11588	2292 Springlake Drive	\N	Bellflower	9	90706	E6100000010C32AC41CCA9F740404A16AD213C815DC0	0465ba46-9904-4f6b-aab0-bbc470cd5a72	2013-09-03 00:00:00
11589	5553 Cash Avenue	\N	Gold Coast	64	4217	E6100000010C5FA9EAE1DDFF3BC0F330BAB0022F6340	3c6d62c4-981b-48a3-9c92-8e43b293b034	2012-02-12 00:00:00
11590	7792 Woodruff Lane	\N	Springwood	50	2777	E6100000010CD812D03E01D840C0B7E03FFF42D06240	b587d775-3880-4ff5-af97-9013c573797f	2013-04-18 00:00:00
11591	9420 Fillet Ave	\N	Milsons Point	50	2061	E6100000010CD985E4805CE940C0960A256983E16240	371bc3a4-7806-44bc-a271-a2b858ab039e	2011-09-11 00:00:00
11592	1084 Meadow Glen Way	\N	Oxford	14	OX14 4SE	E6100000010C1027F5B324D74940631BC358BF7EF4BF	d90419e3-0c3b-4c5c-af18-50c8d20be76b	2013-11-03 00:00:00
11593	8920 Corte Poquito	\N	Ballard	79	98107	E6100000010C62941892CECE47404E5EA0DEE3A15EC0	bfb38b4a-77e7-457c-92fb-28e889074c90	2014-02-24 00:00:00
11594	9343 Ironwood Way	\N	Lavender Bay	50	2060	E6100000010CCFE08B4C6AED40C0F66A376AA7E16240	5d030705-b9cd-48e9-8741-c6f6012d8c23	2012-05-06 00:00:00
11595	36, avenue de la Gare	\N	Paris	161	75007	E6100000010C6E951C54D6644840F2FE9EC094850240	c5d242c3-1a75-43da-a674-8a9f74ebf676	2013-12-21 10:09:29.423
11596	8827 Ward Court	\N	High Wycombe	14	HP10 9QY	E6100000010CCF1626D243C5494093207B4A3D44E6BF	dea0cb67-c4b7-4bee-b0cd-9132cd9ce3bd	2013-08-08 00:00:00
11597	932 Acardia Pl.	\N	Oak Bay	7	V8P	E6100000010CAF5E6F59743848409CA572ED42D85EC0	a8fdf872-4a8c-4329-be2a-890a225d68d2	2013-10-01 00:00:00
11598	5324 Horseshoe Circle	\N	Melbourne	77	3000	E6100000010C6F8B787B30E342C01D2C417F4A1F6240	13690047-af1c-440b-8055-883e9bf3de89	2011-11-20 00:00:00
11599	9995 All Ways Drive	\N	Hobart	71	7001	E6100000010C4BDE421CE46C45C05342D74AFE726240	1eb1f380-a191-4d84-8262-d37dfa4671ba	2014-06-01 00:00:00
11600	88, avenue de l´ Union Centrale	\N	Paris	161	75008	E6100000010CD592B666B5744840836DFDE8CF850240	527a5645-0603-427f-a289-2f6fea895c7f	2013-12-21 10:09:29.423
11601	5055 Quiz St.	\N	Burlingame	9	94010	E6100000010C53A357CD85CF42408B735B30E69F5EC0	ba8e9ca3-1d2a-4097-8cab-b9dcff48a074	2012-06-05 00:00:00
11602	5061 Athecton Circle	\N	Cambridge	14	CB4 4BZ	E6100000010C91859C0B60234A40683E632B0F6CBC3F	0f7490f2-b0b7-49f3-981f-3c4a39cd9f3e	2013-12-20 00:00:00
11603	Am Grossen Dern 82	\N	Kassel	19	34117	E6100000010C74A30B8337A34940C1C136FEADFD2240	fc029b40-19ad-44db-8ff9-5c422b477973	2013-07-14 00:00:00
11604	7781 Santa Barbara Rd	\N	London	14	SW6 SBY	E6100000010CA7D59AF871C34940D098237E1149C0BF	d36b956a-fdce-4b3b-96e1-2b6a4910e24d	2013-08-30 00:00:00
11605	6437 Brookview Dr.	\N	York	14	Y03 4TN	E6100000010CF550E61D3E004B40817CD68EA458F1BF	0ad71d3b-a5b8-4821-89dd-0d73f7c6c100	2013-10-27 00:00:00
11606	5048 Hawthorne Dr	\N	Bellflower	9	90706	E6100000010C2212E9B0CBF64040D24754934E8A5DC0	0cbcc4bf-b9a7-4c0f-b797-da524f85f1b7	2014-03-16 00:00:00
11607	2801 San Ramon Road	\N	Newcastle	50	2300	E6100000010C53DFD82A777140C05DF0DA8B9FF26240	dbbd3aab-3c30-4c85-af5c-bbeffbfdc0ff	2012-04-13 00:00:00
11608	3628 Mt. McKinley Ct.	\N	National City	9	91950	E6100000010C41C8754D2F564040CA4BAF63DA4B5DC0	a1ba430a-4215-4148-87fd-086abc9b35b0	2013-10-25 00:00:00
11609	3445 Fine Drive	\N	Cranbourne	77	3977	E6100000010C26E09043AA1243C0884CDD6CD7256240	4d043b6a-564c-44e9-8bbc-49d3ac656a6e	2014-04-28 00:00:00
11610	1960 Fernando Court	\N	Leeds	14	LE18	E6100000010CE4E249E4A4EE4A402B19C401FFC4F8BF	191a8d65-01e9-477f-8acb-6354e12db7f8	2012-12-14 00:00:00
11611	3492 Broadway Street	\N	Lane Cove	50	1597	E6100000010C80B8321014E340C0FE611C7BD9E66240	7c7dcb00-35a7-4f74-8782-92d4774a7798	2012-07-17 00:00:00
11612	4024 Calhoun Court	\N	Paris	161	75016	E6100000010C05B02E1AC36A4840E2B1C858C3110240	8dfb7eaf-1814-493c-9cc4-0ff57d77434e	2013-12-21 10:09:29.423
11613	3539, rue des Grands Champs	\N	Saint Germain en Laye	164	78100	E6100000010C589F1B0E3A7C48408BE2D01AE1CC0040	afd9fb3f-f584-4ce3-b3fc-de54b2cc18da	2013-12-21 10:09:29.423
11614	3491 Cook Street	\N	Silverwater	50	2264	E6100000010C78ED485A338C40C04F2EA7A0F8F06240	384667a0-fcb7-4411-bf1f-8035d50bde65	2014-01-26 00:00:00
11615	9261 S Royal Links Circle	\N	Beaverton	58	97005	E6100000010C9409AE9FDBC146409185DF8D6AAF5EC0	b450afff-b690-49ba-8c78-c9e69710e337	2012-07-20 00:00:00
11616	4910 Melinda Court	\N	Long Beach	9	90802	E6100000010CE5EF22D5EBE540405729E281608E5DC0	0d0be865-ae9e-48f6-9657-1646b983f1f0	2014-05-05 00:00:00
11617	5844 Miguel Drive	\N	Hobart	71	7001	E6100000010CF45A871C376545C06E25DE918D696240	d2e81cea-4e34-432d-a7f2-8312976cd758	2013-10-04 00:00:00
11618	2489 Teakwood Drive	\N	Sunbury	77	3429	E6100000010CEBAB98FE39C542C05409A01F1A136240	e2920e90-0ecc-4074-9817-847d40a326e2	2012-12-22 00:00:00
11619	Midi-Couleurs	\N	Orleans	131	45000	E6100000010C7AE2645C4FF047406997A9C0B795FE3F	29d10b43-1510-4f6e-9aff-d9ff01d46392	2013-12-21 10:09:29.423
11620	3505 Graham St.	\N	Chula Vista	9	91910	E6100000010CC5D7F4083A5440408AD906025E435DC0	b5c9de7f-9204-4259-ab27-91a2efdbf882	2014-02-19 00:00:00
11621	3495 Virginia Lane	\N	Tacoma	79	98403	E6100000010C178D1962C29F4740DC4AF27344A45EC0	b1cecfa8-89e6-4f68-ab33-18fc617aeb3a	2014-01-18 00:00:00
11622	1680 I St.	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	813d88c6-4793-4906-a43e-5d44f5371b3d	2013-09-12 00:00:00
11623	5617 Landing Dr	\N	Darlinghurst	50	2010	E6100000010CE86E68BE2BF240C0D3C7B46801E26240	94c2b275-bbfa-422f-8561-ba87f88b6698	2012-11-10 00:00:00
11624	2260 Clear Court	\N	East Brisbane	64	4169	E6100000010C479445BAC8843BC0FA90189CF01B6340	3ae34335-dbec-4b5d-b3e5-9fccb1062f11	2012-07-17 00:00:00
11625	Kampstr 5855	\N	Bottrop	53	46236	E6100000010CE2D8CCDB73C349402B93F32DE4C31B40	ace50077-9412-437f-a8fd-1789c6d82764	2013-08-06 00:00:00
11626	4055 Leonard Ct.	\N	Beaverton	58	97005	E6100000010CC3025EF059C54640CF3FD15BB3AA5EC0	17769ed4-452c-4ef4-b28d-d29f044e02e6	2014-01-10 00:00:00
11627	6595 Trailview Circle	\N	Burnaby	7	V3J 6Z3	E6100000010C1462E798ADA5484074EAAE8482AC5EC0	7430ee6a-9084-43fb-b225-eb059b29948d	2013-08-01 00:00:00
11628	2639 Tea Lane	\N	Coffs Harbour	50	2450	E6100000010C1EFD90F8F62A3EC075BB3F2F58246340	0f36b2ca-5321-46f2-bb33-6688ce54013f	2014-05-15 00:00:00
11629	Hochstr 8111	\N	Braunschweig	53	38001	E6100000010C009A90C992214A40B292322BB21A2540	07661d65-046e-4cec-9b71-039e446ed524	2011-11-15 00:00:00
11630	3004 Carob Way	\N	London	14	SW8 1XD	E6100000010CDFBA2EE930C549400B63E4E51B38BFBF	fcca7609-8bc9-4538-92a8-d87bac3b81e6	2014-05-06 00:00:00
11631	Conesweg 180	\N	Bonn	20	53131	E6100000010C00000000000000000000000000000000	026215e6-a3ee-40b4-83c2-e0ea15143ba8	2013-07-24 00:00:00
11632	9343 Seaview Avenue	\N	Cloverdale	66	6105	E6100000010CC02C229C0EF83FC0FFD439B4DAFC5C40	5822ef2c-14e0-4f73-9d9d-12d2f6e8b7ab	2013-03-07 00:00:00
11633	Am Grossen Dern 45	\N	Darmstadt	19	64283	E6100000010CC3E74BE053F148400965A8D667502140	8aa78d9e-a199-40fe-9025-cee7afadf4b5	2014-05-29 00:00:00
11634	7815 Driftwood Drive	\N	Hawthorne	64	4171	E6100000010CE533AFAE34723BC0FE0F8A1A8F226340	58071b73-4d10-4797-ad65-27eab3cb63dd	2011-12-26 00:00:00
11635	2775 Robinson Ave.	\N	Sunbury	77	3429	E6100000010C5BAB0D3412C942C031293C925D1C6240	18162ed5-4384-48d4-b40c-e8a8e470af1b	2011-11-18 00:00:00
11636	89, avenue des Ternes	\N	Paris	161	75007	E6100000010C82C81F9B88774840C96B1A9CB3470240	e586a411-8ae6-4e3a-bda0-b029f92abb49	2013-12-21 10:09:29.423
11637	4, rue Georges-Clémenceau	\N	Roubaix	145	59100	E6100000010C288B27C174574940F6CE2D82A4720940	de1e9a41-3847-4db4-ad48-50096aec92d2	2013-12-21 10:09:29.423
11638	Wertheimer Straße 854	\N	Erlangen	8	91054	E6100000010C37441AE882CC48404964DE51A9142640	96d172c1-4c1e-4721-a8ac-db3563eda1a2	2013-11-28 00:00:00
11639	7726 N Jackson Way	\N	Kirkby	14	KB9	E6100000010C4506AE4E1AB94A402DFB4BA1A42607C0	148c9b43-a6a9-4885-960d-23565869cc38	2013-06-18 00:00:00
11640	9278 San Francisco	\N	Hervey Bay	64	4655	E6100000010C55E8277F6D4E39C00C2A96C9631E6340	2890489c-25e6-47bf-b72c-8e6cce0f0fe7	2014-03-31 00:00:00
11641	34, route de Marseille	\N	Dunkerque	145	59140	E6100000010C20DBD67AC38649407BB57CF2A3CC0240	df765f3e-9ed6-41bf-bf38-9cdacaa2c9b6	2013-12-21 10:09:29.423
11642	2804 Alderwood Lane	\N	Chula Vista	9	91910	E6100000010CEC67CEA191574040F0409A3A9E425DC0	a09d0db5-045e-43ac-923a-3b7fd2e3c777	2014-03-08 00:00:00
11643	1872 Chance Drive	\N	Cliffside	7	V8Y 1L1	E6100000010CBE2B327DFB3C4840ED377FDB97CC5EC0	5787da70-4b38-4562-8613-3f0a7d5b5132	2014-02-04 00:00:00
11644	Reiherweg 4164	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	dcb381a6-ab88-4e3d-969b-c4051ba21a19	2014-01-19 00:00:00
11645	27, place de Brazaville	\N	Pantin	179	93500	E6100000010CED27A170837A48401894CF1E21420340	8ce843a9-aa0d-4de9-b09f-62b2494fbd2e	2013-12-21 10:09:29.423
11646	4286 NE 3rd Court	\N	Cliffside	7	V8Y 1L1	E6100000010C0EF1FC81BD3B4840BD6C736611D65EC0	b57fe1a6-22c3-4f26-8efb-c7d24eb175db	2013-08-01 00:00:00
11647	Knaackstr 756	\N	München	20	80074	E6100000010C00000000000000000000000000000000	5043e954-0514-4c0b-b727-a23f5a37d274	2013-02-13 00:00:00
11648	135, boulevard du Montparnasse	\N	Les Ulis	177	91940	E6100000010C69C007B89C5748406EB90E4470560140	bcc437be-24fb-4a4d-985e-d84eecd9ca43	2013-12-21 10:09:29.423
11649	1624 Carlisle Way	\N	York	14	YO15	E6100000010C2E99193B6EF24A4070CCDF294E5BF1BF	462aca3d-c6a0-4043-9606-499788e4568d	2013-10-06 00:00:00
11650	6, rue de Cambrai	\N	Pantin	179	93500	E6100000010CCDFBA0E6C37B48402DDF053F2B3F0340	86780e5e-bad1-499c-a950-b6c471263653	2013-12-21 10:09:29.423
11651	7339 Eureka Lane	\N	Gold Coast	64	4217	E6100000010C105197E4FFFC3BC06E2D02010C2D6340	36fddf8f-104f-499e-997f-76566257c086	2011-10-14 00:00:00
11652	1275 West Street	\N	Beaverton	58	97005	E6100000010CC3025EF059C54640E901D6C145AC5EC0	24b4ea0e-23d2-4e80-8f54-b37abd512154	2012-06-28 00:00:00
11653	9355 Slow Creek Road	\N	Peterborough	14	PB12	E6100000010CFEA7248E00484A406548EA3375FBCFBF	baa03983-a489-4071-8bcd-7899537e368d	2014-03-04 00:00:00
11654	5024 Euclid Avenue	\N	Warrington	14	WA3 7BH	E6100000010CC0FC2678AFA54A40DBC72492455E04C0	0cb1a5d7-e5f5-47ad-a004-0b2a86d2f444	2014-02-11 00:00:00
11655	4890 Heron Ct	\N	Darlinghurst	50	2010	E6100000010C29E465F512F640C0B2D3410875E36240	7dafe52e-149d-49e5-808c-99c09cbc64bd	2014-02-16 00:00:00
11656	486 Pacifica Avenue	\N	Seaford	77	3198	E6100000010C720EC39EC50A43C0317E6CC586246240	bc173c3f-d02a-4381-bb17-a3609a2465dc	2012-11-25 00:00:00
11657	6287 Strasbourg Lane	\N	Wollongong	50	2500	E6100000010C061536B85F3741C057510235EDD86240	7c93d120-64ab-4c43-9708-701fa51a48ca	2013-05-07 00:00:00
11658	Dunckerstr 7255	\N	München	19	80074	E6100000010C00000000000000000000000000000000	7d3e79e0-3892-492f-bf60-c0b3ba4a8809	2013-12-05 00:00:00
11659	Rykestr 5	\N	Dresden	19	01071	E6100000010C00000000000000000000000000000000	2b638644-851e-4e06-a9b4-6f1c57b7ab96	2014-01-23 00:00:00
11660	4849 C Olivera Rd	\N	London	14	SW6 SBY	E6100000010C1CDDDB85C3C44940A24F467A914BC0BF	bf20386d-38a6-4e82-8422-bac6cb4fd7df	2013-09-07 00:00:00
11661	Zeiter Weg 6664	\N	Saarlouis	70	66740	E6100000010C0F3550098BA14840F800A78BDFF21A40	568043da-133d-4a10-a44a-3003d29a6f80	2013-12-31 00:00:00
11662	51, rue Henri Gagnon	\N	Sèvres	178	92310	E6100000010C4BAA17E89261484098C69C9271AE0140	38fc9c57-9b99-4ada-a1a7-bc20bcfe5c7b	2013-12-21 10:09:29.423
11663	98, place de la Concorde	\N	Paris	161	75010	E6100000010C7046E4BF787648409D7D088B82950240	e9382b42-b18f-4214-a232-9d886ac5285f	2013-12-21 10:09:29.423
11664	9021 Santa Monica Drive	\N	London	14	SE1 8HL	E6100000010C8AC29B98D9C84940E77FA88996D2BABF	8da845f6-82a3-45da-b425-18bd7545dd6b	2012-12-21 00:00:00
11665	6228 RaceCourt	\N	Milton Keynes	14	MK8 8DF	E6100000010C440CCB73660F4A406FD204C8966FE9BF	59a1ab98-fd05-4ab1-9c6c-faf1a303121f	2011-11-01 00:00:00
11666	11, rue Henri Gagnon	\N	Roissy en Brie	163	77680	E6100000010CEE1C019F77644840B63B1B74B54A0540	4181c656-024c-4cda-b43e-4ba0f36b4618	2013-12-21 10:09:29.423
11667	3bis, boulevard Saint Germain	\N	Les Ulis	177	91940	E6100000010C2C59AFB6DB58484033B421991B550140	7e95692b-83d5-44f0-b697-d28d7c2d1188	2013-12-21 10:09:29.423
11668	77, quai de l´ Iton	\N	Drancy	179	93700	E6100000010C77AC30CCB77D4840AB0AA074108B0340	27cbde36-5939-43b4-aa9f-c60c0e97b88a	2013-12-21 10:09:29.423
11669	851 Summerfield Drive	\N	Cheltenham	14	GL50	E6100000010C1572AA95FDE849406A31693E1A9E00C0	733b4650-4b0c-41f5-8fcb-864ebca0e8cf	2014-04-16 00:00:00
11670	224, boulevard Beau Marchais	\N	Saint Ouen	127	41100	E6100000010C9CFC5DA2ECDD4740FB244508A65CF13F	7f33df63-d2d5-42a3-9f54-55caa853e75b	2013-12-21 10:09:29.423
11671	4309 Cambridge Drive	\N	Langley	7	V3A 4R2	E6100000010CDA937E796089484059049EA40DA95EC0	deda3a25-8edf-4cb2-a1be-3bffc886e3cb	2012-01-26 00:00:00
11672	3237 Meager Dr	\N	Lavender Bay	50	2060	E6100000010C16105219BFF140C02714D20CC0ED6240	86aa879b-17ac-4259-8d69-69b2acf76a07	2013-07-29 00:00:00
11673	851 Summerfield Drive	\N	Lavender Bay	50	2060	E6100000010CEE017D7572F040C03356D9021BE36240	e4518876-2bf9-49e0-b6cc-4e5e92578f12	2013-09-01 00:00:00
11674	5, rue Malar	\N	Les Ulis	177	91940	E6100000010C67C2643B7F5448405EAB96D1E3520140	020e26e0-99c4-4375-a0b4-f1a172b9a090	2013-12-21 10:09:29.423
11675	3711 Rollingwood Dr	\N	Matraville	50	2036	E6100000010CE18457B7CFFE40C091AEFBCDB7E36240	d9b74e90-96d5-49c0-9c66-3074e51f56be	2012-12-22 00:00:00
11676	6404 Del Mar Ave	\N	Burien	79	98168	E6100000010C938C522E9EC347406B2E9982EE925EC0	d09d1a6f-d35f-4c89-99d8-f5d7a601cc1e	2012-01-07 00:00:00
11677	22, rue Léo Delibes	\N	Saint-Denis	179	93400	E6100000010C08F18DC42F7D48407DA137258AAB0240	c2ef90df-cfe0-4890-82cf-2dcf4cea19c4	2013-12-21 10:09:29.423
11678	8714 St. Paul Way	\N	Torrance	9	90505	E6100000010C03608C992FEB40402956F3FF52A05DC0	fdb81463-8f28-4eee-8517-d44888bc1192	2013-05-12 00:00:00
11679	3403 Rapallo Lane	\N	Wollongong	50	2500	E6100000010C660A338A9C3541C0F4676B7C22E16240	3b11d285-8c7b-4fd8-8aa6-a1b938e41297	2012-06-08 00:00:00
11680	2807 10th Avenue	\N	Burlingame	9	94010	E6100000010CCA832019A3CC424052A62EAFFB9B5EC0	fa5b58f7-e564-46e5-b4fb-31203abcb8c8	2014-04-24 00:00:00
11681	2427 Pastime Dr	\N	Victoria	7	V8V	E6100000010C190EC7D4D3364840FCB66C9146DB5EC0	21d8e51c-0d1a-4fd7-8d03-479b88a38901	2013-07-20 00:00:00
11682	3794 Francine Court	\N	Clarkston	17	30021	E6100000010C3836443D5EED4040E347263DBC1355C0	31b26580-2587-4bce-8060-55804a489c30	2013-09-13 00:00:00
11683	Marketplatz 775	\N	Paderborn	53	33098	E6100000010C2261E6FE8FDD49408F840A8C4A882140	385faa27-67d4-41c1-ad65-1405e9056611	2012-11-16 00:00:00
11684	386, rue de Varenne	\N	Paris	161	75003	E6100000010C3E9AE127126A48409973993795A40240	539bc6ad-6875-436e-bd36-b803bac0d50b	2013-12-21 10:09:29.423
11685	6885 Amending Drive	\N	North Sydney	50	2055	E6100000010CFBB7ED63F6E640C03105998838E36240	9ad1711b-42da-4965-8501-c2f5193f2547	2013-09-06 00:00:00
11686	9069 Muir Road	\N	Bellflower	9	90706	E6100000010C91C2811A06F240409E1508D103855DC0	1bbdd5fc-38b5-4d98-a4f1-f9685a17ff4a	2014-01-18 00:00:00
11687	7086 C Wharton Way	\N	Santa Cruz	9	95062	E6100000010C7B21833A57794240976BD911EF765EC0	58b44df3-1637-4c8a-881f-a1f851fbd93f	2014-01-28 00:00:00
11688	8811, rue de Longchamp	\N	Courbevoie	178	92400	E6100000010C4CBE99995F7748409A08D99E8D100240	9e0f7457-0299-4956-ac64-ea780ee6813f	2013-12-21 10:09:29.423
11689	593 Chatworth	\N	Darlinghurst	50	2010	E6100000010CABBA49EFA3F540C067768E487DE26240	91b04025-2036-4fc2-8a26-275f920894c3	2013-09-12 00:00:00
11690	8868, avenue de Villiers	\N	Paris	161	75019	E6100000010C3C5B9F0EDE7848406C002173BF5B0240	74738957-d34a-4827-b1e3-19b309ae1f5b	2013-12-21 10:09:29.423
11691	Westheimer Straße 92	\N	Ingolstadt	8	85049	E6100000010C79066342C6694840871F37B5BFB62640	ac36403b-820b-4a6b-b31a-2fa2ebb2cc9b	2013-05-05 00:00:00
11692	7604 Icicle Way	\N	Rockhampton	64	4700	E6100000010CCA727695AD6E37C00AA7975D25CE6240	adcd29fd-14d6-403c-b0f6-a4bcf9f1562f	2012-10-26 00:00:00
11693	4011, rue de Longchamp	\N	Villeneuve-d'Ascq	145	59491	E6100000010C919950E2654C4940AAEE135C4E260940	ee131dd7-8067-499d-8d94-879990b7dea0	2013-12-21 10:09:29.423
11694	3549 Peachwillow St.	\N	Goulburn	50	2580	E6100000010C9B7D586B625441C07E4D1E51FCB76240	512f8b4c-7520-4c80-8d4e-4f79e6f477f4	2011-06-15 00:00:00
11695	5444 Bellord Ct.	\N	Cliffside	7	V8Y 1L1	E6100000010CB1DBD16EB5404840545FB603B3D35EC0	80dbd3d6-1ddc-432c-b7ef-ac45d1a88c9c	2014-05-05 00:00:00
11696	3608 Sinclair Avenue	# 701	Warrnambool	77	3280	E6100000010C309A9425F20643C01B6A0643F3CD6140	4e6b7a8c-6c0b-4419-bcf0-1aa506b43d74	2013-09-30 00:00:00
11697	8459 Patricia	\N	Peterborough	14	PB12	E6100000010C0F1397D745414A4056853A945CF7CFBF	afdd3320-46e2-4587-9c0b-d19b01f6a47c	2013-10-07 00:00:00
11698	1721 Driving	\N	North Sydney	50	2055	E6100000010CFE6FB22131EF40C062A8319659DF6240	0abcd2f4-d363-4f2d-bda9-6d65c340f2cb	2012-03-30 00:00:00
11699	4594 Rose Dr.	\N	Geelong	77	3220	E6100000010C5081EAB4111A43C04ECABF643A0F6240	1f1a16bd-92f5-4f0f-bdee-a2d7f1828661	2012-04-23 00:00:00
11700	5336 Roberts Ct	\N	Chula Vista	9	91910	E6100000010CAD15007D77504040CBDEE71C9F3F5DC0	29acc17e-6f83-4a5b-9281-b3100d9e8278	2013-06-07 00:00:00
11701	386, avenue de Malakoff	\N	Paris	161	75010	E6100000010C50B85425A77748400737849EFE4B0240	4d573c16-2b1a-4bd1-8132-9e98b6a4e40d	2013-12-21 10:09:29.423
11702	8401 Carson Street	#e	Les Ulis	177	91940	E6100000010CAD2D7743054D4840059F6DEDC84F0140	8a32df46-6503-4276-ae71-437363ab35cd	2013-12-21 10:09:29.423
11703	3159 C Wharton Way	\N	Spring Valley	9	91977	E6100000010C9D51CC9AB65840407CBBA7B5493A5DC0	82acd0f7-80d2-4b04-a6d9-cb93f979ee70	2014-05-19 00:00:00
11704	838, rue de Berri	\N	Paris	161	75013	E6100000010C8B0778C909784840E21C786426760240	395e86f1-3794-4343-80f2-b20c57cedc14	2013-12-21 10:09:29.423
11705	2946 Frame Ct	\N	Corvallis	58	97330	E6100000010C706EB773B45946404496F5F43CDA5EC0	c6f5d5bf-6379-4d5f-bee7-c1cffd961ebe	2011-07-29 00:00:00
11706	1023 Hawkins Street	\N	Lebanon	58	97355	E6100000010C1DDE9479E73D4640BCED300587B85EC0	e6e99ba2-d833-4bd4-a6f4-ac4c92014048	2014-03-15 00:00:00
11707	Charlottenstr 35818	\N	Bonn	20	53131	E6100000010C00000000000000000000000000000000	39f2a4a5-f517-46a9-89c4-601928232c71	2012-02-01 00:00:00
11708	1064 William Way	\N	Woodland Hills	9	91364	E6100000010C5979397AAA0F41405E78024512A15DC0	179f0f26-0b1a-4e05-9a08-a78cc64ca10e	2012-03-11 00:00:00
11709	19, rue Surcouf	\N	Matraville	50	2036	E6100000010CBA272B5BAEF540C02C50642A9FE66240	db12419f-fb3d-4bc0-a3af-1b71b5aa1349	2013-10-13 00:00:00
11710	9394 Poor Ridge Court	\N	Caloundra	64	4551	E6100000010C70C17D403EC53AC0F9DB968304206340	87ab7367-43d4-4430-adc2-76886271da49	2013-11-25 00:00:00
11711	22 Geary	\N	Burien	79	98168	E6100000010CBEBDB81012B847406B211F4B3C8E5EC0	e083334f-3266-46ef-b92c-131fb2d40d44	2012-06-06 00:00:00
11712	2345 Yorba Linda	\N	Coronado	9	92118	E6100000010CBF3AC7DF7B584040E8A3BD626C425DC0	936c6a49-5608-48c9-8a44-c79e3acf1eb0	2013-11-09 00:00:00
11713	88, avenue de l´ Union Centrale	\N	Suresnes	178	92150	E6100000010C44961298DE76484058F5174172C40140	5dfcf6c1-4690-4769-8181-38d6e922e0c5	2013-12-21 10:09:29.423
11714	3586 Everett Court	\N	Redwood City	9	94063	E6100000010C386BC5EDFBBA424024AC52E128875EC0	5abf76ac-a773-47a9-b227-006594e002bb	2014-02-25 00:00:00
11715	5, rue des Vendangeurs	\N	Roubaix	145	59100	E6100000010C2DB5EDFEE35F4940EC717042206C0940	9a34ed95-2092-466b-92ed-0c9338ca8cb3	2013-12-21 10:09:29.423
11716	6790 Loma Linda	\N	Oregon City	58	97045	E6100000010C4584305064AB4640BF1BF8DE6AAA5EC0	2c0296f0-764f-4faa-be28-919b4d2b0d51	2013-07-02 00:00:00
11717	21, rue des Ecoles	\N	Les Ulis	177	91940	E6100000010CFAF3B338FD564840CB998042744E0140	9b512f91-000c-42a5-bf27-ff9bd2ef9e12	2013-12-21 10:09:29.423
11718	8286 Willow St.	\N	Oregon City	58	97045	E6100000010C27AB542D74AF46400586C554D9A85EC0	0234ecca-23fd-441e-b0dc-baa65ad036ff	2014-02-15 00:00:00
11719	1745 Marina Pkwy.	\N	Glendale	9	91203	E6100000010C18185727AA104140C81A65657A975DC0	606fdf00-cc51-4bbc-8663-09fa16b8a311	2013-11-14 00:00:00
11720	6150 San Antonio	\N	Grossmont	9	91941	E6100000010CE6A4A155D35D4040746191E606445DC0	30db6d96-139b-4b3c-9d69-ec479aac457b	2014-05-26 00:00:00
11721	27, place Beaubernard	\N	Pantin	179	93500	E6100000010CD25CA236C071484090A0D8CEA2410340	c6cd3696-e4be-470b-a6a8-56f52f17387a	2013-12-21 10:09:29.423
11722	2518 Cashew Street	\N	Lynnwood	79	98036	E6100000010C79957D48C8EE4740AC693A70BC9D5EC0	adf151fc-1100-421c-8f73-72f89f7da067	2013-10-19 00:00:00
11723	7177 Santa Rosa	\N	Haney	7	V2W 1W2	E6100000010C8D1ADEB1BE9D4840E13B247F7CAD5EC0	cfdee3c1-d9c8-482e-99e8-c01228b7d7ff	2013-07-02 00:00:00
11724	3800 Breck Court	# 60	Victoria	7	V8V	E6100000010C86303AA92A3B48407DA8BE0003D15EC0	b14684af-b40a-43e4-a84c-cdac7d87d240	2014-02-04 00:00:00
11725	9649 Sequoia Woods Pl.	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	cad16965-61af-4b20-9878-48e3d655e004	2013-10-20 00:00:00
11726	1907 Grand Ct.	\N	Oxon	14	OX16 8RS	E6100000010C00000000000000000000000000000000	0576bcdf-5bcb-4338-8dd4-ae9d02ce2af4	2013-08-09 00:00:00
11727	1640 Windmill Way	\N	Townsville	64	4810	E6100000010CB22F3464143333C0DF519CB2AF536240	e650f81a-fbd5-4ef9-a53f-145f2490360d	2012-05-22 00:00:00
11728	8713 Book Street	\N	Marysville	79	98270	E6100000010C182A9146BF0C4840A4AEA410BE7D5EC0	d3b794ea-0861-43cd-a730-312ee58d898e	2014-01-02 00:00:00
11729	8245 Heartwood Drive	\N	W. Linn	58	97068	E6100000010CC65F768532A64640A86C0B64BDAB5EC0	27604fed-2dab-4816-b83f-a280bea6a486	2013-03-06 00:00:00
11730	3413 Sequoia Woods Pl.	\N	Newcastle upon Tyne	14	NT20	E6100000010C9308B88866814B40C65701FA8ACDF9BF	aa69fd3a-57b3-4298-a76d-e5ce5e2011b1	2011-09-20 00:00:00
11731	3200 Wren Ave.	#107	San Gabriel	9	91776	E6100000010C4FE1F8656D0B4140F8D5EAD5DF8A5DC0	f4f3ff6b-ad74-415b-ad7d-3e8b18453f2c	2014-05-19 00:00:00
11732	1277 Army Dr.	\N	Glendale	9	91203	E6100000010CE3AD4EC0FD134140CC6E00EC91985DC0	16f15f76-5ece-45e2-b522-ea65b66e1bc3	2014-04-04 00:00:00
11733	1318 Nottingham Pl.	\N	Lebanon	58	97355	E6100000010CEC38E3D59F3B46405C9F73A086AD5EC0	f7b3c471-936c-450b-8546-def80f577d68	2013-11-07 00:00:00
11734	3535 Hillview Dr.	\N	Gloucestershire	14	GL7 1RY	E6100000010CFFAA5B3499F049409E2D4C10BA8901C0	4d9eee83-a00b-45f6-b91d-25b5299eb25b	2013-08-02 00:00:00
11735	111, boulevard du Montparnasse	\N	Colombes	178	92700	E6100000010CF352B0D07C7A48400E1A9B9B1DF70140	2736eda3-2369-4059-bbac-c1c5a673c3f9	2013-12-21 10:09:29.423
11736	2305 Glaze Drive	\N	Mill Valley	9	94941	E6100000010CF2496A2453F34240FCB36617089B5EC0	117fb112-29eb-4d57-9ee6-c44126adf5c9	2014-06-14 00:00:00
11737	6501 West Way	\N	Redmond	79	98052	E6100000010CB739EFC0D3DC474006124B65E3825EC0	6ebfbaf9-7399-44c3-ae1b-70dd5592fc1e	2013-09-08 00:00:00
11738	7874 Jones Lane	\N	St. Leonards	50	2065	E6100000010C3DC7451CA6E340C0EC91098EA6E86240	586be51a-2966-4c71-97e7-1c1987f5ae93	2013-12-04 00:00:00
11739	3187 Westwood Court	#71	East Brisbane	64	4169	E6100000010CF08FDEB1C9713BC078D42AED43246340	b65ecc54-fc70-4a09-a7b1-633cac39dc61	2012-12-19 00:00:00
11740	Kalkweg 4	\N	Bottrop	53	46236	E6100000010C65160CBF39BB494066ED737AD1AB1B40	1829f675-e837-4d2e-aadb-5ba4b065ed85	2014-03-01 00:00:00
11741	Winter der Böck 8456	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	1b46859d-9408-4986-8a16-8b752e5c2aa7	2014-01-09 00:00:00
11742	6863 Shakespeare Dr	\N	Malabar	50	2036	E6100000010C4EEF6752AEFF40C091AEFBCDB7E36240	7958ea75-cde3-4b62-a1b0-c8bfd63982f1	2011-12-15 00:00:00
11743	7650 Northridge Drive	\N	Palo Alto	9	94303	E6100000010C7B75C43897B342404530F17AA08A5EC0	4d46e054-cecf-4a47-8b74-4b3c9b2914f7	2014-05-11 00:00:00
11744	4019 Shadow Lane	\N	Port Hammond	7	V6B 3P7	E6100000010C1A63450E82A348402FA455D115BC5EC0	eb421673-d484-4809-b326-7b3664285c36	2013-10-10 00:00:00
11745	2128, place du Tertre	\N	Saint-Denis	179	93400	E6100000010C437D0319896D4840150B83DDEDAD0240	604980cc-4b0f-4b2a-a031-9a1d5d02b6c3	2013-12-21 10:09:29.423
11746	Marketplatz 5193	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	c6dfa463-3311-4045-90c8-d0626150d2ea	2012-11-22 00:00:00
11747	5485 Wee Donegal	# 77	Bellflower	9	90706	E6100000010C8975D50C97F1404092AD36B9548D5DC0	c290d7a6-76ce-4a89-8c20-f3eec7333652	2014-05-28 00:00:00
11748	5300 Turning Dr.	\N	Redwood City	9	94063	E6100000010CED73D27905C6424060B9C1C274945EC0	2f69c1db-b88e-4f44-a576-8cd5223ba4bf	2013-11-08 00:00:00
11749	214 Via Del Sol	\N	Chula Vista	9	91910	E6100000010C7EEFD40ADF4B404049D425E71C475DC0	eefb03ff-c0fa-4ff3-8831-9226834cf967	2013-12-22 00:00:00
11750	9746 Valley Blvd.	\N	Shawnee	7	V9B 2C3	E6100000010C2C1C036C043748401BF2107944DA5EC0	6595e1c4-c92e-4e9e-9879-b695a47d3879	2014-01-14 00:00:00
11751	9466 Morning Glory Dr.	\N	Concord	9	94519	E6100000010CF2DFA37E2BFF4240C574794EC4795EC0	77d191ab-b53b-41e6-a061-2c3e148978f9	2012-02-25 00:00:00
11752	7569 Mt. Everest Court	\N	Berkeley	9	94704	E6100000010C527706B758F5424029360D8587925EC0	333a2e24-683a-4eec-85b0-8bb0d918979c	2012-11-22 00:00:00
11753	9080, quai de Grenelle	\N	Boulogne-sur-Mer	148	62200	E6100000010C80B26D94936149409EC59FC3CAADF93F	11d4f5c4-7e18-4910-b6b3-9aad5e912a62	2013-12-21 10:09:29.423
11754	7355 San Benito	\N	Westminster	7	V3L 1E7	E6100000010C08572D4E8A9F48406B1879085AB15EC0	75858369-75c4-4034-a61d-b78be2a69572	2013-09-29 00:00:00
11755	872 Patterson Blvd.	\N	Bremerton	79	98312	E6100000010CC16302697DD44740A9DE823336BB5EC0	f155dbab-5c7e-4c01-95fa-10364e9d8e38	2014-02-18 00:00:00
11756	2777 Spring Hill Drive	\N	Haney	7	V2W 1W2	E6100000010C57FA215C8F954840500180D3DBA45EC0	4a6c33c7-b27f-4cb3-a655-b79bb7d5d6e9	2014-04-07 00:00:00
11757	5473 Hillridge Way	\N	Los Angeles	9	90012	E6100000010C9745EF606F0E4140129CD0A6DC895DC0	342a229d-18cc-4761-8a27-b812eca7d8e9	2012-09-20 00:00:00
11758	4082 Roslyn Road	\N	Bellingham	79	98225	E6100000010C86889E045D694840A476B72191A55EC0	36d1325b-a2aa-4064-b4f6-81f63a192c8e	2014-02-04 00:00:00
11759	3805 Brushcreek Court	\N	Port Orchard	79	98366	E6100000010CD50E794571CB47401541A671EDB05EC0	4c1c4214-887c-4cfd-97ac-9fdbbc61722f	2013-12-19 00:00:00
11760	36, avenue Reille	\N	Paris	161	75007	E6100000010CCD407A8104714840E277EE70CFB30240	5b9ed652-4d4a-4d5e-b329-34f6a3965770	2013-12-21 10:09:29.423
11761	Königstr 387	\N	Berlin	53	14197	E6100000010CB670F22B7C424A40C8F63A2B74B92A40	e2505fdd-1a0f-4087-bacc-b733192b7546	2013-12-31 00:00:00
11762	13, rue de Terre Neuve	\N	Tremblay-en-France	179	93290	E6100000010C1B64E913E58248405512E447F96F0440	100b8731-c0c7-4e4c-9a20-c46402d62d3b	2013-12-21 10:09:29.423
11763	118, rue Marbeuf	\N	Villeneuve-d'Ascq	145	59491	E6100000010CE7C307E10B4D4940B1E0424C98270940	0b7627ea-804c-4b7c-baa7-6214cb0fffef	2013-12-21 10:09:29.423
11764	Hauptstr 2929	\N	Mühlheim	20	63151	E6100000010C357D0BCB580A4840351EF99A50C82140	fe5ee3b4-eb8f-4178-9301-c8198de7c4da	2013-06-27 00:00:00
11765	369 Roslyn Drive	\N	Sunbury	77	3429	E6100000010CE8EC0BA17FBE42C0DA4A664645176240	27ff86bd-a236-4603-98fb-99aae1566f7c	2013-07-30 00:00:00
11766	7996 Ronda Ct.	\N	Esher-Molesey	14	EM15	E6100000010C00000000000000000000000000000000	95145598-d62c-4e8e-815c-36c90249243c	2013-07-15 00:00:00
11767	76, rue des Berges	\N	Pantin	179	93500	E6100000010C688667A52D7148407FBBDB69884B0340	258a0669-c2b9-44bd-9bea-ed9aad987862	2013-12-21 10:09:29.423
11768	1201 Olive Hill	\N	Salem	58	97301	E6100000010C98071DD4A57C4640E052089D00C85EC0	c3f01ed5-9a4b-46bc-9e93-63bc0858fa88	2013-11-20 00:00:00
11769	2697 Hobby Court	\N	Salem	58	97301	E6100000010CC8E555054B7246402C791A5921C05EC0	9507bf61-c999-4005-8722-42543e3f67fb	2014-01-30 00:00:00
11770	6490 El Camino	\N	Goulburn	50	2580	E6100000010C6DBC48956C4841C053621E93C6BC6240	d79d657f-f087-46bd-a4fd-c1ef1da5e2e1	2012-02-22 00:00:00
11771	6155 Wilbur Drive	\N	National City	9	91950	E6100000010C10095509185440403B247A609D3D5DC0	3ddd0ec0-99e3-400b-ab36-19d6184165b4	2014-04-29 00:00:00
11772	561 Park Glenn	\N	Sedro Woolley	79	98284	E6100000010CD872BEBAF4384840F3AF87E8E8885EC0	186f740f-5271-4997-96ab-17a1c897c420	2013-11-27 00:00:00
11773	6928 N. 8th Street	\N	Peterborough	14	PB12	E6100000010C7B78845A6C514A4084F08660EAFDCFBF	7585e1f3-4d67-487b-8cc7-4be9be14766b	2013-09-03 00:00:00
11774	1, rue de la Centenaire	\N	Lille	145	59000	E6100000010CFAF63F826E4949404406E070815E0840	7843c672-b392-4a7c-8c4d-1612833b8737	2013-12-21 10:09:29.423
11775	8932 Westwood Way	\N	Kirkby	14	KB9	E6100000010CFCA823C7FEB44A40B9C65F0A512107C0	d5381891-20a1-49f4-880e-f476f12dfe5e	2014-02-26 00:00:00
11776	62, route de Marseille	\N	Courbevoie	178	92400	E6100000010C3ECECEE87E754840FAAF7600160A0240	4ed2c998-91d4-4196-b960-d502a8586408	2013-12-21 10:09:29.423
11777	8210 Mines Road	\N	Lakewood	9	90712	E6100000010C81C6FDB458F140406DFBE60BC77E5DC0	cf03b230-36b6-4cbd-85a6-19027b8ae9fc	2013-10-17 00:00:00
11778	3124 Fall Creek	\N	San Gabriel	9	91776	E6100000010C080E9A362C0D414078864272067E5DC0	3036bf7b-7dbf-4269-b02c-6eb7a9ea59c0	2013-05-27 00:00:00
11779	5935 Isabel	\N	Berkeley	9	94704	E6100000010C5E43E6DBAEEA4240A46DE43AEC895EC0	a5fb04ba-e1f6-44e2-a859-65ddec73811f	2011-08-15 00:00:00
11780	3758 Springwood Way	\N	Lynnwood	79	98036	E6100000010C54776C4FF2EC474037B351F28F935EC0	1498c46e-9586-4cb8-8a1c-680a9a1f0c88	2014-01-14 00:00:00
11781	3545 RiverRock Dr.	\N	Milwaukie	58	97222	E6100000010C5E63404CB5BB4640AEC844DADBAF5EC0	1b254224-a564-4670-abfb-5489dec58662	2013-10-28 00:00:00
11782	Attaché de Presse	\N	Roncq	145	59223	E6100000010CE4674951D864494008460BE3D2F80840	c35f8da3-5ae5-403b-8373-eb037c8cc627	2013-12-21 10:09:29.423
11783	1622 Silver Oaks Place	\N	Beaverton	58	97005	E6100000010C92B6C884B1C04640D7560A2490BD5EC0	11b45dd8-2f67-4f79-9c3b-64bf8f681269	2014-02-01 00:00:00
11784	1663 Park Glen Court	\N	Lakewood	9	90712	E6100000010C5946572343DF4040972E30AB78865DC0	b9dcc8de-09e8-495b-84cb-764ecb62675c	2013-10-27 00:00:00
11785	1234, rue Ste-Honoré	\N	Saint-Denis	179	93400	E6100000010CE9EC9DA1C96E48405277197595AA0240	0334f558-c1e9-4e19-8ab0-17e90039b1d5	2013-12-21 10:09:29.423
11786	2650 Hamlet	\N	Portland	58	97205	E6100000010CC132F70F70C34640F966B77092B25EC0	997f9262-8996-4e98-950f-562031f9705d	2013-08-07 00:00:00
11787	2944 North Main St.	\N	Los Angeles	9	90012	E6100000010CF8728D39E901414062B3E10135885DC0	26effe4d-8394-4b12-b705-398f450fe67e	2014-05-13 00:00:00
11788	10570, rue Lamarck	\N	Saint Germain en Laye	164	78100	E6100000010C2BD9BEA5B26F4840877621A951D00040	d98c70dd-901e-4161-989d-cb44bd888092	2013-12-21 10:09:29.423
11789	7390 Notre Dame Avenue	\N	Kirkland	79	98033	E6100000010C2931C3AA44D74740C9B687190C935EC0	fd044bd4-8800-4e0b-89d4-66dbf0ac1fe4	2013-12-29 00:00:00
11790	465 Falcon Place	\N	Townsville	64	4810	E6100000010C7C0BC38A003833C0DF519CB2AF536240	f7762add-7b0d-453e-bf28-14cabbeeeefa	2012-12-22 00:00:00
11791	Altendorfer Straße 570	\N	München	53	80074	E6100000010C00000000000000000000000000000000	6ff44cf2-ea97-477f-abb2-67f43485da4a	2014-03-31 00:00:00
11792	8885 Partridge Dr.	\N	Woodland Hills	9	91364	E6100000010C3101D0661A104140C743CDB86BA95DC0	3a3a5a1f-1eb5-469b-94e6-e1097c2d6e39	2012-07-02 00:00:00
11793	4999 Corte Segunda	\N	Santa Monica	9	90401	E6100000010C18B63CF72B0541404E1ED5302DA15DC0	ae944dac-8ddd-4a70-bfea-093b13e69400	2014-04-03 00:00:00
11794	Alte Landstr 799	\N	Paderborn	53	33098	E6100000010CB8A11B702EE44940046FFBE2307C2140	6fd4eddb-bb3a-4c61-844a-ada79ddc78b9	2012-04-22 00:00:00
11795	6749 Orchid Ct.	\N	Westminster	7	V3L 1E7	E6100000010CF0169D450FA24840B56E7351B9BE5EC0	7cca1aa1-5951-4b33-86b0-f398610c8f08	2014-01-06 00:00:00
11796	3117 Story Lane	\N	Woodburn	58	97071	E6100000010CF0C682F08B8D4640839FE7AD54AB5EC0	adc3d04a-c146-4c77-936e-e54a77991c8b	2012-05-24 00:00:00
11797	9896 White Dr	\N	Cliffside	7	V8Y 1L1	E6100000010C0FA19C73773F4840BA5D0E75B3E25EC0	9c725715-bf5e-4181-a5e8-d231fd13f09d	2014-05-28 00:00:00
11798	9430 La Vista Avenue	\N	Port Macquarie	50	2444	E6100000010C48DB183B036D3FC0671E1260241E6340	0d1d28d0-db9d-4747-b163-40f54866fd50	2011-10-07 00:00:00
11799	7776 Cordoba Way	\N	Burien	79	98168	E6100000010CEAEB06D2E4B947400ED7042426925EC0	410d8b74-bd16-4a52-8d0c-ec51adb03ebd	2013-09-13 00:00:00
11800	4399 Shuey Ave	\N	Newton	7	V2M1P1	E6100000010CB91168E276F44A40D56CFC5C1EAF5EC0	0fb429c6-9461-44f0-aa25-be351feb9a37	2012-12-09 00:00:00
11801	8769 Haven Drive	\N	Perth	66	6006	E6100000010C67AA896F0CE43FC078357EAF8EEB5C40	84748794-e0cf-4bbf-b353-6b6e9fc55b58	2014-05-30 00:00:00
11802	9312 Corte Del Sol	\N	Shawnee	7	V9B 2C3	E6100000010C1CB21B525140484094D59485E5D75EC0	cc7f3d92-009c-45e3-9a70-3df8be357c8b	2013-10-13 00:00:00
11803	9833, rue des Ecoles	\N	Paris	161	75016	E6100000010C77BD6E1D016F4840F33771D420D30240	9ab30137-e5af-427b-9a86-fbbec6feb65b	2013-12-21 10:09:29.423
11804	8844 Bel Aire Drive	\N	Yakima	79	98901	E6100000010C8AD46833EA4747403D2199422A215EC0	8fc22139-86c0-4aff-ad35-03bafe158788	2011-06-27 00:00:00
11805	Karl Liebknecht str 299	\N	Mühlheim	20	63151	E6100000010C00000000000000000000000000000000	7b5be3e0-793c-4dea-81c9-17946c6f1504	2013-10-06 00:00:00
11806	3799 Hilton Way	\N	Lynnwood	79	98036	E6100000010C396D11A755EC4740C2FC687463895EC0	8d97deae-2b46-44c1-90d7-1acf7019efef	2013-09-10 00:00:00
11807	1876 La Costa Ct.	\N	Bellingham	79	98225	E6100000010C3E31EC6A1F634840DF2B039AA5A15EC0	e7da6240-db6b-4452-b7aa-3f572492084e	2014-04-04 00:00:00
11808	Holzstr 6444	\N	Werne	53	59368	E6100000010CEC77D5C115E0494073117609E57E1E40	ec256b4e-0fa5-4741-9be4-cc2ad0530c86	2014-04-28 00:00:00
11809	2904 San Simeon Ct.	\N	Goulburn	50	2580	E6100000010C68252C01834F41C05E03EB6EB7B26240	8f1fc3cc-8b66-40f8-86ce-9160694cac65	2011-06-04 00:00:00
11810	8241 San Jose Drive	\N	Burien	79	98168	E6100000010C8ED28D9802C347406BD04708CD8F5EC0	6381df62-987b-4fe0-b6de-e221035d5886	2013-07-06 00:00:00
11811	882, rue Villedo	\N	Villeneuve-d'Ascq	145	59491	E6100000010CC716C1D63B524940DA211605652D0940	45b28e3f-dfdf-4542-be05-68976c052786	2013-12-21 10:09:29.423
11812	5854 Eagle Way	\N	Chula Vista	9	91910	E6100000010CD10910FCA45440408AD906025E435DC0	dbaeaad7-626d-429a-a025-da7f23bfd372	2013-09-17 00:00:00
11813	7644 Corte Segunda	\N	Langford	7	V9	E6100000010CD9FE6C5ED0384840FA3685D513E05EC0	188c50ef-57e6-4035-850d-4338e3b7c80b	2012-08-29 00:00:00
11814	386 Woodpine	\N	Renton	79	98055	E6100000010C5954B67BC0BF4740243323B37C835EC0	6ae8e49f-5d05-41f1-95b0-f48012bf0223	2014-03-19 00:00:00
11815	1402, rue Lauriston	\N	Villeneuve-d'Ascq	145	59491	E6100000010CE7C307E10B4D49409C0AB67BBA230940	8bb0b833-9fa4-44a5-8234-1ffd1c706626	2013-12-21 10:09:29.423
11816	7188 Viewpoint Ct	\N	South Melbourne	77	3205	E6100000010C264C5B772EE842C0A48166BAC3176240	7b0bb4a5-ddaa-4c50-99d5-040670fc8a90	2012-12-09 00:00:00
11817	6500 S St.	\N	Walla Walla	79	99362	E6100000010CBF043AE7E10B474024C9BD6C438C5DC0	3af6b047-bd27-434a-a414-6db48986cd49	2013-12-04 00:00:00
11818	4385 Claudia Dr.	\N	Springwood	50	2777	E6100000010C52C88481BFDC40C0A4EB81A6E6D96240	becb7882-3509-46c8-b086-99a179e1f803	2012-12-25 00:00:00
11819	8249 La Jolla	\N	Oakland	9	94611	E6100000010CA8AD4CB285E7424049BE92C9A1945EC0	e4c42c25-3429-494c-b976-608a9ce85d3e	2011-10-19 00:00:00
11820	2499 Greendell Pl	\N	Beaverton	58	97005	E6100000010C3459EBE2C4C44640E9D200586BBA5EC0	71e3a153-8a42-4041-b68b-215d02421122	2013-08-03 00:00:00
11821	4618 Olive Hill	\N	Newton	7	V2M1P1	E6100000010C390DD08D27F54A40E4E372D942A75EC0	c17636eb-b198-4893-94ee-5f7f554765df	2011-11-27 00:00:00
11822	9277 Ridgewood Court	\N	Issaquah	79	98027	E6100000010CDE7681ACBBC847406E5861D7C2735EC0	79d33183-80bc-4a3c-abfa-aa008ba509f9	2012-11-20 00:00:00
11823	5899 Mt. Wilson Place	\N	Novato	9	94947	E6100000010C019F1B786B0A43409A9522D173A75EC0	6c78922d-b713-4521-b258-e1a67338ed39	2014-01-26 00:00:00
11824	1103, rue Lamarck	\N	Paris	161	75019	E6100000010CF7B355E7DE6C48405607898556B60240	906287fe-117d-417c-8fcf-6797516ac423	2013-12-21 10:09:29.423
11825	3469 Fish Ct.	\N	Lincoln Acres	9	91950	E6100000010CC77B353259554040D06F30B45A4A5DC0	53eee993-b141-4850-b570-f59b3cedbcea	2013-09-19 00:00:00
11826	346 Sutcliffe Pl.	\N	Langford	7	V9	E6100000010CF89EEB79BC424840F01E1F488BDA5EC0	e26edd5b-d522-4dc0-bf23-8dacd3e51e76	2013-07-02 00:00:00
11827	2, cours Mirabeau	\N	Paris	161	75013	E6100000010C3A529053976F484022AF0FB21B2C0240	f95ee43b-13d4-4b61-8092-e35b50d326bb	2013-12-21 10:09:29.423
11828	8168 Eaker Way	\N	La Jolla	9	92806	E6100000010C7FA48F6CBAEF404029B54CC386705DC0	96cbbe5a-5c00-4c93-8541-45305dc52268	2014-03-01 00:00:00
11829	7955 Cleveland Rd.	\N	Walla Walla	79	99362	E6100000010C076A2AFA0F0D4740167EDDC1699B5DC0	3a5d4b49-6256-419a-bfec-7ce1ec2164f0	2014-03-04 00:00:00
11830	5782 Ringing Court	\N	Melbourne	77	3000	E6100000010C66446C7B5AED42C0CA174A0138206240	e8629289-7c58-4bae-b6ee-8d8f30ff2c89	2014-05-15 00:00:00
11831	27, place de Brazaville	\N	Metz	143	57000	E6100000010C5425C48C969148401B5EC34F08C01840	cc0cce19-f5e5-4bfc-be5c-ed5659ef5411	2013-12-21 10:09:29.423
11832	101, avenue des Champs-Elysées	\N	Colombes	178	92700	E6100000010C6A9F4A4B7F7F4840CE7CE7A56AF90140	0ebf9aa0-3443-4a67-91ad-a464a090b401	2013-12-21 10:09:29.423
11833	4404 Mildred Avenue	\N	Redwood City	9	94063	E6100000010C7B17B7D3B3C14240708F3256B9885EC0	dde9261f-db66-4811-84fb-26ead14f0e6c	2013-10-26 00:00:00
11834	7354 Scramble Rd	\N	Rockhampton	64	4700	E6100000010C6DFF32DAB06537C07ABFC5BC5ED56240	d741d249-64f3-400d-9f5b-a29537a9fd24	2012-08-30 00:00:00
11835	4475 Terra Calitina	\N	London	14	SW6 SBY	E6100000010CF351FA31C9C2494016AB062CFC46C0BF	01fedcae-d027-43a9-a3de-5f483352de91	2013-07-10 00:00:00
11836	8595 Central Avenue	# 778	Shawnee	7	V9B 2C3	E6100000010C04A3F755AD324840409C9C9E27D35EC0	1732dee7-84ec-4c7c-bb83-80e46232e5f6	2013-07-23 00:00:00
11837	6754 Pampered Ct.	# 19	San Diego	9	92102	E6100000010C2F9CB92CFD564040FC41656DF1455DC0	4203e8f0-504b-4bdd-a9bc-df1914ac15d9	2014-01-17 00:00:00
11838	6329 El Rancho Drive	\N	London	14	SW8 4BG	E6100000010C8F32DFA8D5B94940EAE7EDAA69C0C2BF	d3c34d74-9842-41a0-a84d-eddb236cc39c	2012-11-28 00:00:00
11839	9009 W 46th St	\N	London	14	SW8 4BG	E6100000010C4BE3741121BD49400B5BAAC189C9C2BF	f7002bf2-57ae-4bd4-bbb3-d01b14130e42	2014-03-08 00:00:00
11840	1242 Ridgewood Ct.	\N	Matraville	50	2036	E6100000010C4EEF6752AEFF40C086C9B7B233E46240	af4869ce-088b-43f2-ad45-dcbffe61f621	2012-07-06 00:00:00
11841	1160 Bella Avenue	\N	Port Orchard	79	98366	E6100000010CF9DF604973BD4740865C542DF1A55EC0	a8d02c28-a5ef-4030-aa91-4d0e61733b16	2014-04-26 00:00:00
11842	7527 Eola	\N	Stoke-on-Trent	14	AS23	E6100000010CF756A0EFA47D4A404CB3DC0E496D01C0	83059ab6-dff2-4588-bb27-71b7f5a5807f	2014-01-04 00:00:00
11843	9531 Harrison Street	\N	Colma	9	94014	E6100000010CDC6A5F6743D94240A24183E0D99C5EC0	bf88143a-cfa6-4def-bcd1-e02c81e5485b	2014-06-29 00:00:00
11844	9108 Clear	\N	Sunbury	77	3429	E6100000010CCAEBF50B30C642C0DEC54BB74A1D6240	494c08f2-28d2-4e3a-a240-7bdb7d5a1fad	2012-04-13 00:00:00
11845	8809 Diablo View Road	\N	Burbank	9	91502	E6100000010CD40FE4ABD51A4140C46C7566AA9D5DC0	e12a5503-908f-49a3-9634-93f5951a1b67	2014-06-15 00:00:00
11846	1318 Nottingham Pl.	\N	Sydney	50	1002	E6100000010CABFECF2B75F240C03C66F1D8C9E16240	d9b50890-3b8c-45a7-9888-53d359ea5e51	2013-09-19 00:00:00
11847	3723 Mt. Sequoia Ct.	\N	Santa Monica	9	90401	E6100000010C6D64D1E982FF404024468F0C6BA05DC0	dcf9179d-389b-4ba7-a327-92bc73aa3315	2014-06-25 00:00:00
11848	3255 Marsh Elder	\N	La Jolla	9	92806	E6100000010CE4B4649BE6E44040AFA8321FC16C5DC0	cf494404-25d2-4376-9200-ed9454d6a865	2014-05-22 00:00:00
11849	27 Elkwood Dr.	\N	Hawthorne	64	4171	E6100000010CE9B7A139D4773BC0509E94EE16216340	d5641fa2-5d93-4ae8-a12e-c467465bfd33	2012-01-22 00:00:00
11850	8422 W. Holly Drive	\N	Renton	79	98055	E6100000010C744D06739AB347403DCCAE0E178C5EC0	5501d644-66d6-4f95-b589-86692c57bd6f	2013-08-22 00:00:00
11851	2898 Forest Way	\N	Redmond	79	98052	E6100000010C73FC16302AD94740086F2CBC2C905EC0	414c1bc8-bc07-4bb5-a417-0cb6efb7cc90	2014-03-13 00:00:00
11852	3, rue de l'Espace De Schengen	\N	Roissy en Brie	163	77680	E6100000010CA851ACDC356D48403149548E28500540	a4d03398-d20b-4fce-82d6-94d4ee0b72a9	2013-12-21 10:09:29.423
11853	Brunnenstr 432	\N	Mühlheim	20	63151	E6100000010CFA14E1700D06494060B977D107B92140	6a806842-02cb-40ba-8489-a18de1ac18fb	2013-04-09 00:00:00
11854	975 Harris Circle	\N	Lake Oswego	58	97034	E6100000010C18734DD5E6B64640EC19AF6266AC5EC0	048c1249-0a62-41db-a48c-1aeeacffd9a5	2014-06-05 00:00:00
11855	1016 Park Avenue	\N	Burbank	9	91502	E6100000010C69FA9FB275164140DD6459FB8C915DC0	211345da-b8d9-4d4a-a54a-ae2f6094e8bf	2011-06-04 00:00:00
11856	1032 Buena Vista	\N	North Ryde	50	2113	E6100000010C67E4FE7F24E440C08F50596804EB6240	5b865afa-564a-4c70-aa5b-dfc6bd07cbf9	2012-06-08 00:00:00
11857	2003 Pinecrest Dr.	\N	Redmond	79	98052	E6100000010C73FC16302AD94740B5327200FB7E5EC0	42a8df67-611e-4973-88c9-735f3d6c2f8d	2013-10-13 00:00:00
11858	2297 Via Valencia	\N	Cranbourne	77	3977	E6100000010C26E09043AA1243C09D216382BE2D6240	fbaa4ec5-3b5f-42ac-a742-e9e01f4b9b88	2012-11-22 00:00:00
11859	Husemann Straße 7574	\N	München	20	80074	E6100000010C00000000000000000000000000000000	8177bc49-dea0-48d7-8e8c-4bc62a4a5351	2013-07-23 00:00:00
11860	92, rue des Pyrenees	\N	Metz	143	57000	E6100000010C2450BF161A9448409EE7F14A2BB71840	517a1a99-1089-4a3b-8ba3-06b3887b672a	2013-12-21 10:09:29.423
11861	3538 Esperanza Drive	\N	Coronado	9	92118	E6100000010CBE987571575E404028F06357AC445DC0	d4d0bf13-802d-4d6e-a3a0-a901b80f11cb	2014-01-27 00:00:00
11862	6742 Clover Road	\N	West Covina	9	91791	E6100000010C70CE05681F0D4140C0B668706F7E5DC0	ed20e8b9-08f4-4dae-8318-e9a775d4da6e	2013-11-14 00:00:00
11863	6395 Deermeadow Way	\N	Lancaster	14	LA1 1LN	E6100000010CDB867072510A4B40C17C8F68F87306C0	c038c1ae-6a0d-4061-bfcc-e4fff7e8e753	2013-09-08 00:00:00
11864	7783 Limewood Pl	\N	Rockhampton	64	4700	E6100000010C6DFF32DAB06537C001F14E53C6CA6240	670e833c-84f1-4a67-9316-5bb50afe98f6	2012-03-06 00:00:00
11865	3123 Bonita Ave	\N	Townsville	64	4810	E6100000010CFCAC05D45A4133C04BE8CF67DE506240	7bb2a660-c8b7-4f65-b50e-1ff36ab87a15	2013-03-01 00:00:00
11866	8238 D Crane Ct.	\N	Newport Beach	9	92625	E6100000010C3CB3C3168ED2404037F9CEEC41755DC0	db03c584-85df-4658-9b0e-61dd49d088d5	2014-03-21 00:00:00
11867	3114 Notre Dame Ave.	\N	Silverwater	50	2264	E6100000010C73DC079EE58D40C03A769DC427EB6240	3903c6e2-7352-4dad-9672-513c26bee965	2013-12-14 00:00:00
11868	4352 Marclair Dr.	\N	Concord	9	94519	E6100000010C7F6E868684FC4240506B6F1D28755EC0	eeab48d7-7455-405c-aaf4-2737ac12c44c	2014-01-20 00:00:00
11869	6102 Corte Poquito	\N	Walla Walla	79	99362	E6100000010C7CCC733C3111474002ABFDC152925DC0	bc993249-a71b-4d9f-bdb6-84fb2daf94b5	2013-10-04 00:00:00
11870	2470 Icicle Circle	\N	W. Linn	58	97068	E6100000010CEF631BE984A846403254185818AE5EC0	d54e259b-a0f0-4dd9-84ee-2fb9dd2e4679	2014-01-13 00:00:00
11871	2115 White Dr.	\N	Bendigo	77	3550	E6100000010CB0AEACF6235E42C02F08245A860D6240	cbaa6d73-c4a1-4067-9fce-f46013a8d4cb	2013-05-20 00:00:00
11872	8665 Brown Street	\N	West Covina	9	91791	E6100000010C4C45AD29C30841406603D0A8A97A5DC0	56d8c7e1-04f9-4390-8d3a-63987b6fbc61	2014-04-24 00:00:00
11873	8197 Haviland Place	\N	Puyallup	79	98371	E6100000010C310431E14596474066759732399E5EC0	d3d233af-ebc1-4de7-8ccc-ccd70c7d9db1	2012-11-08 00:00:00
11874	319 Dale Pl.	\N	Newcastle	50	2300	E6100000010C6F0CCBB4C97740C025DB369CE8F96240	f328fd4e-cdd7-4e96-ae95-d37778c70af7	2013-04-10 00:00:00
11875	3365 Atherton Circle	# 11	Grossmont	9	91941	E6100000010CDC2E821DEC5F40401142846648405DC0	41bac15a-7d00-4d99-9284-103d05149ee9	2014-01-29 00:00:00
11876	3152 Woodcrest Drive	\N	Lebanon	58	97355	E6100000010C69478162793E46402E368C1674A65EC0	a26422ea-dc4f-44e8-8e61-89da04bf28d6	2013-09-16 00:00:00
11877	8211 Leeds Ct.	\N	Goulburn	50	2580	E6100000010C294B3366BD4D41C07E4D1E51FCB76240	cde63fee-777e-42f6-823f-57aa2278edb3	2011-06-25 00:00:00
11878	1229 Apollo Way	\N	Lynnwood	79	98036	E6100000010C3ACC60218BE24740D83C805D0A995EC0	df15cf3a-76cd-42ce-9a51-7c06814f285f	2013-07-27 00:00:00
11879	3925 North 39th Street	\N	Haney	7	V2W 1W2	E6100000010C1CA431D2AB9348405C1F5BB5B3AC5EC0	e5385a88-a975-4866-b3b4-7d6576d0d483	2013-09-26 00:00:00
11880	2257 Gate Drive	\N	Downey	9	90241	E6100000010CBB8778BA5CF64040F5BB6237C38A5DC0	c41903b4-e914-4b29-aa38-8d6a0411e215	2012-09-02 00:00:00
11881	5207 Minute Dr.	\N	Lincoln Acres	9	91950	E6100000010C662017C8F259404080B96E3B9A4C5DC0	447ec4fb-42c8-433e-b719-0559a263a757	2013-10-04 00:00:00
11882	3792 Westwood Ct.	\N	Beverly Hills	9	90210	E6100000010CCDF48A64140F4140D2E0364B1D965DC0	16c0c39b-2405-4487-85cc-20d1ec683634	2013-12-19 00:00:00
11883	9652 Steven Drive	\N	Corvallis	58	97330	E6100000010C61C767656B5B464064ACA37209CC5EC0	0f781dc9-a48d-47a5-b336-3af210f5d357	2014-03-15 00:00:00
11884	5923 Hazelwood Lane	\N	Bremerton	79	98312	E6100000010C75827F93EAC847401F2CFAD5DAAD5EC0	841b16e9-4e27-4da5-b6ee-9188c414bd89	2014-05-24 00:00:00
11885	1358 Palmer Rd	\N	Billericay	14	CM11	E6100000010CAB0E97CAAFCA4940AC06541E42B3DA3F	3446f5b7-628c-4669-8122-88985177d37b	2013-11-11 00:00:00
11886	1148 Thornwood Drive	\N	Corvallis	58	97330	E6100000010C492886FD6A53464065D5DE174BD65EC0	18c1d44c-4f87-4970-986b-6143748d0dd6	2013-01-04 00:00:00
11887	4606 Charming Court	\N	Torrance	9	90505	E6100000010C0315D8086DE64040EDAC0BE814A15DC0	78a6a9f9-36f2-4cb7-b777-3fd319837a11	2014-06-10 00:00:00
11888	9011 Tank Drive	\N	Redmond	79	98052	E6100000010C3A0D2ACC44DF4740D7CE57D0F4905EC0	ae68dfd9-73fb-4c26-a5d8-91af2e3f9d7b	2013-08-23 00:00:00
11889	3971 Confir Court	\N	Bendigo	77	3550	E6100000010C2ACFEA327E6042C067F9CB1FC10A6240	a5f14adc-82d4-4118-b9b4-6ae9c283de0e	2012-12-20 00:00:00
11890	8629 English Court	\N	Redwood City	9	94063	E6100000010CDC0A726DC8BF4240DE39D2B46A8D5EC0	4250d20b-cf9a-486e-986d-e0e211e72454	2013-10-29 00:00:00
11891	5977 C Wharton Way	\N	Melton	77	3337	E6100000010C6BF7BA00F2D042C0A5855986AC156240	d4445eff-0d4f-447f-9c9c-89421e040cfb	2013-07-04 00:00:00
11892	8784 Detroit Ave.	\N	Milsons Point	50	2061	E6100000010C4A01389975F240C01306836762E56240	8d029394-d97d-4337-87cf-95fb802fe3d2	2013-12-07 00:00:00
11893	5252 Santa Fe	\N	W. Linn	58	97068	E6100000010C84B93D74B5B44640E98829483CB15EC0	4cd4267e-a5bc-4620-b494-422640a285c5	2013-07-24 00:00:00
11894	88, impasse Notre-Dame	\N	Drancy	179	93700	E6100000010C3B6043DCD67B484064C445A492910340	ea42d742-7c5b-4a68-bcfd-e1f3320ebec7	2013-12-21 10:09:29.423
11895	2822 Valmar Dr	\N	Fremont	9	94536	E6100000010C828AB84550C54240AB87BE0284755EC0	28809e3b-e11e-4753-ba38-9cc4b39d4f84	2013-12-06 00:00:00
11896	4082 Virginia Hills	\N	London	14	EC1R 0DU	E6100000010C18D6044DF9BE49403D32FA0FE021BBBF	1b08c428-170e-42c6-b237-54b42c7d79b6	2013-12-22 00:00:00
11897	9930 Clinton Dr	\N	Townsville	64	4810	E6100000010C899D7B778A3533C045E6ABA67C5E6240	44ace11c-f430-4070-8c1b-e1dbc990e43a	2013-10-28 00:00:00
11898	9697 Central Ave	\N	Seattle	79	98104	E6100000010CEE4CE1BF3BCD47404B3269286C905EC0	10834580-20bd-4b8d-885e-5db08157d12c	2014-04-22 00:00:00
11899	7521 Mount Aire Parkway	\N	Torrance	9	90505	E6100000010C176A26CEF6E2404066A130BF439A5DC0	d81eb264-3ad3-4fbc-9458-4c0c6a29f2f8	2013-12-28 00:00:00
11900	Auf den Kuhlen Straße 122	\N	Ingolstadt	8	85049	E6100000010C964F742B6B5B4840177A16C04BAC2640	ea11e44c-c956-45b8-9ff3-fa9dd96fe3bb	2014-01-06 00:00:00
11901	5071 Almaden Dr.	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	56b06cfb-840d-4419-875e-93ab05330d4a	2012-01-09 00:00:00
11902	7307 Corte Segundo	\N	Billericay	14	CM11	E6100000010C2577B66E4BD14940E3DAF451B2A9DA3F	ccb286c3-5252-4f59-b0e3-2500ab659dca	2014-04-11 00:00:00
11903	5385 Sony Hill Circle	\N	Victoria	7	V8V	E6100000010C001F3C125934484004C9D04746CC5EC0	c98a9701-f8d6-4e83-afa1-65a649c21021	2013-08-25 00:00:00
11904	5425 Highland Circle	\N	Cliffside	7	V8Y 1L1	E6100000010C0301DC56EB464840B1BD894547D55EC0	46842d6c-e9dc-4dba-bc5a-263742386f39	2014-01-19 00:00:00
11905	5980 Icicle Circle	Unit H	Townsville	64	4810	E6100000010CF4C2E0D7D84133C0710B14D6CE516240	5cd17ad6-82c9-4151-9b6a-5d457f48140c	2013-07-11 00:00:00
11906	3757 Brook Hollow Ct	# 101	Woodburn	58	97071	E6100000010C27BBF60AD08B4640CD0B726C8BAA5EC0	1292bc6b-0e22-467d-8131-454548fd3d25	2014-02-28 00:00:00
11907	1105 N. 48th St	\N	London	14	E17 6JF	E6100000010CC2D6919037CF49400104F73E8BCDA5BF	5bccb9de-e7a7-408d-9fe2-a0736b9ccd0a	2014-04-15 00:00:00
11908	1120 Curtis Drive	\N	High Wycombe	14	HP10 9QY	E6100000010CCA78CE8A48C349403308B65D443CE6BF	65557309-1ca2-471c-a6ab-843e6175fe0b	2013-11-29 00:00:00
11909	7948 Rambling Lane	\N	Puyallup	79	98371	E6100000010CF74D3C72B0984740D2E766ED7A925EC0	5c63c531-d9ac-43f2-ac3b-ca2653c58480	2011-12-14 00:00:00
11910	1153 Loma Linda	\N	Bendigo	77	3550	E6100000010CF0BAFB47515B42C0CB00F8BC230C6240	d072ded7-47a0-4b00-be07-189419dd0e96	2014-05-24 00:00:00
11911	4302 Oakleaf Ct.	\N	Hobart	71	7001	E6100000010C4BDE421CE46C45C0B0B0D1BB14696240	88ec3d35-1138-4a77-a479-5c118e2f8ba7	2014-01-31 00:00:00
11912	2648 Hillcrest	\N	El Cajon	9	92020	E6100000010C4F02CDE79A6640403B289A2F9F3B5DC0	977ecddd-4c81-458f-ad0e-054f92759896	2013-10-22 00:00:00
11913	Parise Straße 1551	\N	Frankfurt	8	91480	E6100000010C5B31C1DF5DD64840FBC424C5721B2540	681bc46d-e409-4b2e-8dcc-bcba1a22468a	2012-09-10 00:00:00
11914	88, avenue de l´ Union Centrale	\N	Tremblay-en-France	179	93290	E6100000010CD921C78A078648409D393CE6BA750440	dc4e090c-1d08-4bdb-9082-a2061efde145	2013-12-21 10:09:29.423
11915	4159 Apple Drive	\N	Findon	66	5023	E6100000010C11D02A51487441C01B4A875D26556140	46311644-8a2a-461c-93fd-ae0fbd362d7b	2014-01-27 00:00:00
11916	512 Palms Dr	\N	Renton	79	98055	E6100000010C8722737D2EC2474032405C33E9935EC0	b407642d-a4df-4d33-b8d8-69a51247d753	2014-05-08 00:00:00
11917	6880 N Lanky Lane	\N	Salem	58	97301	E6100000010CA3CDBFB2AC804640528C23B731BC5EC0	a60e4732-02e3-4b6d-9269-ce5ee0bc7e0c	2014-01-06 00:00:00
11918	7179 Golden Rain	\N	Chula Vista	9	91910	E6100000010C81BDB917744B4040A367B1939B4B5DC0	1826e6ef-ce41-4b71-99ac-c93c43b5568d	2013-12-06 00:00:00
11919	5592 Byers Rd.	\N	Colma	9	94014	E6100000010CD41F1426E3D54240143DFD2226985EC0	53abc9ed-8b78-4b47-ad32-ce6acf0a21f2	2011-11-01 00:00:00
11920	7265 Mt. Dell Dr.	\N	Melton	77	3337	E6100000010C781B0DFA2ACB42C0B34E89C4FC176240	8ff05a2b-4c51-43ab-872d-293217099eb4	2012-04-09 00:00:00
11921	5966 Krueger Dr.	\N	Sydney	50	1002	E6100000010C9617328F85EB40C0E473CF805EDF6240	50ddb003-1b58-49fc-905d-1ce412a6bb38	2014-05-12 00:00:00
11922	9816 Ban Bridge Pl.	\N	Findon	66	5023	E6100000010C0C36A1C7D06F41C0A275FF7F7D526140	992445b8-0a51-4231-b854-92dba85d283d	2013-03-11 00:00:00
11923	Postfach 99 92 92	\N	Ingolstadt	8	85049	E6100000010C666F6BCF8B594840CE9E56689EAE2640	d2224cab-788d-4d2e-8659-df36ff7a18d8	2012-04-06 00:00:00
11924	3bis, boulevard Saint Germain	\N	Paris	161	75012	E6100000010C9F9BCB91207148404D3E2E68DC610340	1805a501-b2f7-4b95-81e9-7a74341d5b6e	2013-12-21 10:09:29.423
11925	8162 Milden Road	\N	Santa Monica	9	90401	E6100000010CFE824EA3FE024140DA4C03358F965DC0	80571ec5-c4c1-48c5-8f24-cc3f4d72be3e	2013-08-10 00:00:00
11926	3076 Mount Dr	\N	Grossmont	9	91941	E6100000010C695A1652B263404092036A66CB385DC0	8aa217e9-c17b-4830-a740-92ecd265c147	2013-10-26 00:00:00
11927	4364 Chelsea	\N	Lavender Bay	50	2060	E6100000010CEFBA5342F3E940C08A3D8EDBD8EA6240	80b28e3e-d788-443d-87ce-ea6645b51b1c	2013-07-16 00:00:00
11928	Parise Straße 644	\N	Solingen	53	42651	E6100000010C5911F12BF98F494053BAF624936E1C40	d89f05a2-b89e-4b6b-9c31-9168b08051b8	2013-08-03 00:00:00
11929	7775 San Ysidro Court	\N	Oregon City	58	97045	E6100000010C477121CB96A54640C0D830034D9C5EC0	d79d124f-7a7e-4de6-a7d3-969883941932	2014-03-02 00:00:00
11930	2599 Amaranth Way	\N	Sunbury	77	3429	E6100000010C1B2BC84EFECA42C099F7C324D41C6240	d09ebff9-a528-41cb-94e2-cd38676c0813	2012-04-09 00:00:00
11931	7561 Humphrey Drive	\N	Newton	7	V2M1P1	E6100000010C3A28608903F14A409AA2CCEF79BC5EC0	626f4559-7ca0-4e2e-ace7-1dd5bf080ebe	2011-12-12 00:00:00
11932	9145 Paso Del Rio Way	\N	Warrington	14	WA1	E6100000010CF1F2E09A0BAA4A404D5D660E059104C0	727452d9-02f7-4600-9d58-092b1b277ccf	2014-05-20 00:00:00
11933	Hans-Rosenthal-Platz 4108	\N	Berlin	70	14197	E6100000010CD3944D3A1F3C4A40B5EF0DBF07B42A40	fad60cc7-8597-42af-b144-e089656fd76d	2013-12-17 00:00:00
11934	1355 Sequoia Drive	\N	Melbourne	77	3000	E6100000010CA69792C4E6EB42C0837957449C216240	0563867d-4cac-4689-913a-03595ee1174f	2012-07-22 00:00:00
11935	5639 Lee Lane	\N	N. Vancouver	7	V7L 4J4	E6100000010C56FE4E12F7A748400FF36ED41EC45EC0	7f543a47-5666-470e-b987-2f4f3dea6e4d	2013-08-28 00:00:00
11936	5679 Attic Lane	Unit A	San Diego	9	92102	E6100000010C61BA8C6068574040DB65B5F1323C5DC0	26af1fa6-8137-4f7e-a931-50f922f4c03e	2014-05-01 00:00:00
11937	39, rue Descartes	\N	Paris	161	75013	E6100000010C49ADA73BB7734840E1A4B6C356C70240	f81da2b5-e0d1-456f-a22f-6860fb978da0	2013-12-21 10:09:29.423
11938	7657 H St.	\N	Malabar	50	2036	E6100000010C20A68DFDE5FA40C091AEFBCDB7E36240	99e191d7-f8ed-4a72-80f1-c6486741e612	2011-11-13 00:00:00
11939	7820 S. Rising Ave	\N	Sydney	50	1002	E6100000010C3820063206F240C05BDC7C2414E86240	3a0298e5-3d56-4150-859f-66366cc78584	2012-05-09 00:00:00
11940	2602 Hale Dr	\N	Burlingame	9	94010	E6100000010C4D8578245ECA42407911D5F3688D5EC0	1bce8a89-48b3-4890-a633-e80e4a5babd2	2013-12-14 00:00:00
11941	Rykestr 2605	\N	Paderborn	53	33098	E6100000010C6B66348EFCD04940F4F3CF5CF2862140	881c1bf0-706d-4586-88f4-02d92f7d236b	2014-02-23 00:00:00
11942	36, rue Maillard	\N	Courbevoie	178	92400	E6100000010C4C6EAB5EBF764840046B87A766120240	9c06eff3-0cac-41e0-aefe-72698827868c	2013-12-21 10:09:29.423
11943	4137 E St.	\N	Colma	9	94014	E6100000010C1ACEEA5526D2424030D4D9F1B2995EC0	cee4e895-9c23-49b6-b525-17dba4bc985c	2014-03-09 00:00:00
11944	7341 46th St.	\N	Tacoma	79	98403	E6100000010C1ACD8069879E4740F4EBF3064B975EC0	7e1b6c17-e5cd-489e-87f4-ba7309a92ed1	2013-08-12 00:00:00
11945	8837 Paris Lane	\N	Bellflower	9	90706	E6100000010C732829FF27F140405A79FB0461935DC0	9e706e00-312f-493d-86ef-3584b13ab1a8	2014-03-29 00:00:00
11946	64, route de Marseille	\N	Cergy	181	95000	E6100000010C187FC1441C7C4840CB86EC10CF850040	47a301ff-dfd2-47c2-b706-6c28ededd9fe	2013-12-21 10:09:29.423
11947	Wasserstr 64	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	72a8361a-c23d-4b56-b993-5a8694f66518	2013-09-20 00:00:00
11948	234, quai Paul Doumer	\N	Lille	145	59000	E6100000010C8C86BB54434F49409809E51C625B0840	064f12a9-1205-4ff1-ba95-2a99a7d3870f	2013-12-21 10:09:29.423
11949	4657 Roundhouse Place	\N	Melton	77	3337	E6100000010C5DE51184D5D342C0A005C41AF50B6240	c571b183-3736-46f6-96fc-dccbb0dd0fb4	2014-01-11 00:00:00
11950	Wallstr 844	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	53dd95ad-32ed-4495-ab9e-cc8fc0a43773	2013-01-21 00:00:00
11951	3069 Yolanda	\N	Woodland Hills	9	91364	E6100000010C489E92E2D8184140E0C11C18E7A75DC0	dfc26988-37ad-404a-9d1e-e665ac7b16af	2013-12-25 00:00:00
11952	7728 Condor Place	\N	Hobart	71	7001	E6100000010C64CDB7402E7045C02C5C47D13D776240	4441e38c-3623-44f4-a589-d7b996f9e7d5	2013-11-20 00:00:00
11953	4351 Shenandoah Dr.	\N	National City	9	91950	E6100000010CAFAD369FB1584040040135F65B445DC0	a38072ae-cb10-483f-8d61-68b37bce0b60	2013-07-13 00:00:00
11954	9264 Slow Creek Road	\N	Olympia	79	98501	E6100000010C9BF569667F844740D001FCF82EB75EC0	6116a9c2-bd9d-4bc6-8da7-182624ffbec6	2013-12-23 00:00:00
11955	8796 Bayview Court	\N	Woodburn	58	97071	E6100000010C8A47848FE79346402EEFBDB379AE5EC0	29cf2135-436b-476d-b3f3-eef3010006fa	2012-05-11 00:00:00
11956	Hüttenstr 6114	\N	Salzgitter	19	38231	E6100000010CC47B548D10194A40326AA4EC4AD12440	a1c0e9e9-d1c7-4037-b47f-6581305e395c	2014-05-08 00:00:00
11957	6620 Leonard Ct.	\N	Chula Vista	9	91910	E6100000010CD6D17CC8505640404215A2C65F3D5DC0	6fddfaa6-ad69-4611-9f86-f989c80bc637	2014-05-11 00:00:00
11958	6406 Pepper Way	\N	Oregon City	58	97045	E6100000010CEDE58D62C6B146400643FE78BB9A5EC0	130d662c-29a9-4aef-9f97-5f884c2e0e39	2014-04-05 00:00:00
11959	4524 Ferndale Lane	\N	Yakima	79	98901	E6100000010C75D83D75BE554740534A96E07E0B5EC0	2b443eda-50c3-4e65-bf31-dc588c46bec4	2013-11-12 00:00:00
11960	2856 Third Ave East	\N	Glendale	9	91203	E6100000010CE3AD4EC0FD13414086E934B053995DC0	1625c53e-045d-49ea-93b3-f10657020698	2014-01-25 00:00:00
11961	5806 West Slough Rd	\N	Victoria	7	V8V	E6100000010C86303AA92A3B48403A98355D61D35EC0	d0c4cbea-2b21-4248-9c6e-4e3637d24b6a	2012-01-06 00:00:00
11962	7047 Poncho St	\N	Burlingame	9	94010	E6100000010C99E3325599CD42404C2B7A2EA2995EC0	de924590-6e51-4a6a-872c-82758d358a48	2014-05-07 00:00:00
11963	6104 North Civic Drive	\N	Warrington	14	WA1	E6100000010C522C1B45EEB24A406DACFDDB588304C0	dd66ac86-e9e8-4e23-8bb8-9f8b91e4639e	2014-01-03 00:00:00
11964	Nonnendamm 22	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	866690d1-d075-4842-8139-6417a3676654	2013-11-26 00:00:00
11965	252 Meadowbrook Drive	\N	W. Linn	58	97068	E6100000010C6F376B428CB34640B01BDC8F1AA35EC0	47c75e68-0ca1-474b-b0c5-a552630c4999	2013-11-28 00:00:00
11966	1289 Quiz St.	\N	Sunbury	77	3429	E6100000010C9ACB0120A1C742C031293C925D1C6240	78b33f0e-9b46-4b4a-a867-555247ebab31	2012-12-14 00:00:00
11967	1747 Corte Segundo	\N	W. Linn	58	97068	E6100000010CE5223250F0A746402634CF9BBFA05EC0	1d55cc77-d005-484c-9da7-eeec088fee39	2014-01-11 00:00:00
11968	5205 Sunview Terrace	\N	Burbank	9	91502	E6100000010CA6CD9AB0C517414000E8830318965DC0	6445dcc4-4051-4981-923d-ad1d5a451c10	2013-10-09 00:00:00
11969	1417 Roosevelt Avenue	\N	Beaverton	58	97005	E6100000010C53FFB51819C746402BB0F9BE0FB85EC0	8d861552-4d9c-4dd6-aa15-0e8947738e5e	2014-03-16 00:00:00
11970	9610 Moccasin Ct	\N	Spring Valley	9	91977	E6100000010C7F3E6A4AAC604040DB54D7AA0A385DC0	881a2c52-8a80-4a46-ac82-92d46f5191a9	2013-07-17 00:00:00
11971	5979 Lynwood Drive	\N	Renton	79	98055	E6100000010C8722737D2EC2474067373633F6885EC0	a1d1c479-cb26-41d5-9472-6df07b9537c5	2013-09-08 00:00:00
11972	9228 Via Del Sol	\N	Imperial Beach	9	91932	E6100000010CEF4EB83FAC4F40406923D459D5405DC0	2892011d-95f0-4fbb-ad0e-3f0a94716bc6	2012-09-28 00:00:00
11973	8937 Two Bay Road	\N	North Sydney	50	2055	E6100000010CDECDBAF628EC40C0A74435A3DDED6240	b8d24683-8d7b-418b-9fb9-6da2c0074535	2014-06-07 00:00:00
11974	3366, rue Ste-Honoré	\N	Paris	161	75007	E6100000010CBFC33804B66F48401019ABB5189B0240	13f9ca36-d6e5-45df-bc11-56585116b14a	2013-12-21 10:09:29.423
11975	101 Adobe Dr	\N	Coffs Harbour	50	2450	E6100000010C35F246680D2E3EC0001D66AF051C6340	21be4e72-64c9-46f2-8946-6095baab013a	2013-09-18 00:00:00
11976	3421 Gehringer Drive	\N	Daly City	9	94015	E6100000010CE6C6829A46D042405C172ED659965EC0	cbfec1f0-0c93-4fa3-9efe-2f9beecc10d9	2014-04-01 00:00:00
11977	Pappelallee 667	\N	Paderborn	53	33098	E6100000010C544F9D3208DB4940A3B85B14A4572140	1c5e13d5-517d-46fb-b978-a7bdcf6218ce	2014-05-26 00:00:00
11978	28, avenue de la Gare	\N	Croix	145	59170	E6100000010C65556B233F564940D709B06B5A390940	ec499834-780e-4098-b106-a5a595faf52a	2013-12-21 10:09:29.423
11979	8 Sunnybrook Drive	\N	Spring Valley	9	91977	E6100000010CE447F746596240403BFF7B434C345DC0	cdeadcb3-9132-44cb-8e5f-67dd33b1ce86	2014-04-24 00:00:00
11980	8120 E Lane	\N	Glendale	9	91203	E6100000010C6E5EF965BD154140CA76E0C2A5855DC0	a3e54f1b-ecf4-43f3-a22f-890b718a3dfb	2014-03-19 00:00:00
11981	7836 Roux Court	\N	Burien	79	98168	E6100000010CAC00DC59D5C4474025488DF1529C5EC0	fcce0aeb-e3bd-4646-84af-98889e6ab6e5	2014-05-20 00:00:00
11982	7906 Clayburn Road	\N	San Francisco	9	94109	E6100000010C706DE75131E6424091323E958BA35EC0	cd035bbc-7f2d-4222-aba2-fef59078e612	2013-12-18 00:00:00
11983	5265 Evergreen Ct	\N	Cambridge	14	CB4 4BZ	E6100000010CAEAABD4FAB234A40DCE2FD8671D1C23F	72d8ab43-5a3f-49a4-bf6e-d3c264d68b2b	2014-03-02 00:00:00
11984	Erftplatz 654	\N	Erlangen	8	91054	E6100000010C9FBC3710CCC64840AEE828EA5E092640	b0207214-4dd6-4efd-a6a3-db51558f1f66	2013-01-02 00:00:00
11985	Königstr 282	\N	Grevenbroich	8	41485	E6100000010C22A3A6E9D586494078FE277F10441A40	9c81686c-4935-4fdc-b8b9-b23bcb33ed5d	2014-01-07 00:00:00
11986	Hauptstr 6057	\N	Neunkirchen	70	66578	E6100000010CA0289E6CDAAE48400258FE3B3D811C40	f4dedb70-afbc-4216-a0ef-4f90dc7d8c12	2012-06-03 00:00:00
11987	6024 Bluetail	\N	Sooke	7	V0	E6100000010CF8164A74D83548405C908FBD4DF85EC0	1bb9d2f0-a949-4d99-8ca3-bdcff6cf2396	2013-11-23 00:00:00
11988	Marketplatz 75	\N	München	20	80074	E6100000010C00000000000000000000000000000000	e9463781-433f-4547-9f9b-c7fdc7494237	2013-10-30 00:00:00
11989	Hochstr 8444	\N	Hof	8	95010	E6100000010CC887D6DCE42E4940694F9E41BAC92740	ceed7296-10cc-4696-82c8-52dbbc91b146	2013-11-16 00:00:00
11990	7012 Silverado Drive	\N	W. Linn	58	97068	E6100000010C4CB1F3AC10B04640CA99C6A32D9F5EC0	58499b54-537a-4e11-92c0-3eedffbcdbc5	2014-02-13 00:00:00
11991	2938 Woodsworth Lane	\N	Darlinghurst	50	2010	E6100000010C29E465F512F640C067768E487DE26240	0b6d4998-4810-4668-bb47-911f85f35890	2013-10-11 00:00:00
11992	7306 Pastime Drive	\N	Long Beach	9	90802	E6100000010CE6B0ED62B5DD4040064B79951B8C5DC0	9d59281c-3193-4554-8f82-ca4a652d407d	2011-08-18 00:00:00
11993	47 Catherine Way	\N	Tacoma	79	98403	E6100000010C829A16A71A99474052D34B206E9C5EC0	7093c83e-cee2-47f6-a043-bb863dcf437a	2013-09-22 00:00:00
11994	1752 Attic Lane	\N	Sunbury	77	3429	E6100000010CEBAB98FE39C542C06E01F942C9106240	7f002570-21aa-4d18-b6fb-d8e8416646be	2012-06-20 00:00:00
11995	3248 Birdhaven Court	# 1	Chula Vista	9	91910	E6100000010CC973BE2264534040724B5C70203B5DC0	9067df51-009c-42d1-b6bb-4be95f3ac2b5	2012-11-30 00:00:00
11996	Rykestr 2605	\N	München	53	80074	E6100000010C00000000000000000000000000000000	e553a6b1-427d-44dc-b704-5d97b16cbae0	2013-05-13 00:00:00
11997	9361 Corte Del Sol	\N	Warrnambool	77	3280	E6100000010CBFA7220128FF42C01B6A0643F3CD6140	e7395d70-a635-474f-9e14-3e10dcf036e0	2013-02-10 00:00:00
11998	1111 Bayview Cr	\N	Palo Alto	9	94303	E6100000010C5AB75E13BDBB424079B6F653E77E5EC0	c4138105-aac3-44fd-af6c-3d6019d85e32	2014-05-02 00:00:00
11999	9011 Blackburn Ct.	\N	Gateshead	14	GA10	E6100000010C4B457A2828844B4023D632298EA8F9BF	aab14ebd-146d-4f14-b251-efe12b4f3950	2013-11-17 00:00:00
12000	4525 El Pueblo Pl.	#6	Burien	79	98168	E6100000010C994617C439C44740B172F68DAB8C5EC0	37f5193e-3580-4cbb-8f20-d9a2d9e8a188	2013-10-27 00:00:00
12001	7479 Ellis Street	\N	Redmond	79	98052	E6100000010CB29279AAF1D747402252F43C53815EC0	13880c49-20a8-4bac-9f6b-7fa109989c1d	2013-09-12 00:00:00
12002	7902 Hudson Ave.	\N	Wokingham	14	RG41 1QW	E6100000010CAC3C5D7B01C0494013533038BE39EBBF	d290a831-4501-433e-b925-c423162fa5bd	2014-04-21 00:00:00
12003	2139 Birdwatch Ave.	\N	Peterborough	14	PB12	E6100000010CB45A9BCF13504A40EDBA607AA3FACFBF	bf3eae8d-9994-43bf-9e1d-fae47c3f2c07	2013-05-16 00:00:00
12004	8761 Dancing Court	\N	Redwood City	9	94063	E6100000010CA9C7E0934DBF4240CF63612126995EC0	c542f254-de4c-44ed-9738-a18faecf665b	2013-11-26 00:00:00
12005	255 Mt. Orange Ct.	\N	Coronado	9	92118	E6100000010CD18A3D5D2154404010EA94DA9A525DC0	272149a4-330e-46f3-9cbf-712fa328bcb2	2013-08-10 00:00:00
12006	3675 Q St.	\N	Chula Vista	9	91910	E6100000010CEA99E994FC57404008CF44CCDB4A5DC0	7aaa4025-afc9-4ba3-9276-aa2d7d76ae63	2013-11-10 00:00:00
12007	3207 Mario Way	\N	Shawnee	7	V9B 2C3	E6100000010CC2F10CC8BC3A4840A10E8D6CA3DC5EC0	b2b94827-c18e-4644-a814-db0da87bedd3	2014-05-28 00:00:00
12008	8374 Vista Del Diablo	\N	Oakland	9	94611	E6100000010C90DE4085F9E842407B33625DC5855EC0	b64ba3aa-2f71-498a-a5fa-f18de38ce6ba	2013-05-11 00:00:00
12009	3744 Dalis Drive	\N	Burlingame	9	94010	E6100000010C53A357CD85CF424085F8A6AF8C9D5EC0	82f4cb80-de18-45e1-a1e6-318b6647f254	2013-09-29 00:00:00
12010	8160 Star Tree Court	\N	Westminster	7	V3L 1E7	E6100000010C45D74D5F809A4840B5681E6723B25EC0	2b5e683f-7224-4331-ad3e-21351e2352dd	2013-07-06 00:00:00
12011	6238 Valleymanor	\N	Langley	7	V3A 4R2	E6100000010C953075C67D874840600EB81142B35EC0	6aab7491-957d-4d65-9c20-ebdb5c0ee106	2013-11-08 00:00:00
12012	2338 Mozden Lane	Unit B	East Brisbane	64	4169	E6100000010C9CE8BC0D90803BC01BC237FB6D1C6340	d8009743-3710-4d31-a46b-99a9b08fa7c6	2013-08-21 00:00:00
12013	Hans-Rosenthal-Platz 209	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	8ccd51a4-c146-4777-abdc-f218f0b1473b	2013-12-19 00:00:00
12014	7266 Corcoran Road	\N	Santa Cruz	9	95062	E6100000010C7B21833A577942404D08FBAF46795EC0	8c819f6c-728b-4e4d-9da0-3f3c17d98fea	2012-11-03 00:00:00
12015	1948 O Avenue	\N	Watford	14	WA3	E6100000010CDB6EB50DE0CA49402A8BDBA4F4FFD8BF	db2b69a5-00a0-412a-976b-d7dfa253cada	2012-05-25 00:00:00
12016	217 Ram Circle	\N	Sooke	7	V0	E6100000010C16ECB39C45304840BCC526DFE1E65EC0	c606aa06-05c9-482f-8557-7c501167f1b6	2013-09-07 00:00:00
12017	Erftplatz 6	\N	Saarlouis	70	66740	E6100000010C2D0A651F89AD484041EB0B729EFE1A40	9abb1105-a279-4f66-8734-c12b000487e8	2012-12-06 00:00:00
12018	9187 Vista Del Sol	\N	Everett	79	98201	E6100000010C272AE193AF064840AA1CA5EDB9945EC0	3ec69cd8-d1ca-4338-8e3b-6803029e33c0	2013-08-03 00:00:00
12019	683 Larch Ct.	\N	San Gabriel	9	91776	E6100000010C1FD18B6FCA0F41403CCF944DA78E5DC0	4acd1229-5554-4292-9ec6-85d447eeedbe	2013-09-14 00:00:00
12020	Lindenalle 7384	\N	Berlin	19	14111	E6100000010C00000000000000000000000000000000	77d52bc1-b137-4af3-b028-dfa55c781fa4	2013-09-01 00:00:00
12021	6797 Almondtree Circle	\N	Oregon City	58	97045	E6100000010C27AB542D74AF4640D717996498975EC0	27825312-10a6-477f-860f-bf9a99f96ab4	2013-11-24 00:00:00
12022	4915 Pear Dr.	\N	Newport Beach	9	92625	E6100000010CD1F1D6FEF3C94040096F1B9CC8795DC0	8788fdf2-3bf1-4107-84bb-748c0d8b02a6	2014-03-13 00:00:00
12023	3538 Olivewood Ct.	\N	Baytown	73	77520	E6100000010C673015E40AC23D40F8A272B8C6B357C0	91c1597b-87e0-4dc7-92df-827fce67999a	2014-01-20 00:00:00
12024	Wertheimer Straße 266	\N	Saarlouis	70	66740	E6100000010C6E27C9091EA9484074CFCE3587051B40	54c0e12e-8742-4eba-8ffd-27d6572f1e60	2013-07-30 00:00:00
12025	9573 Royal Oak Rd.	\N	Haney	7	V2W 1W2	E6100000010C8BFFC397E4A04840AC8E5BACB8A15EC0	def461ba-cdad-4d57-91d6-078ea8de6bb2	2014-03-20 00:00:00
12026	6196 Nottingham Place	#313	Victoria	7	V8V	E6100000010C20740E9F3F3148405817C853B2D95EC0	05f3cbfd-ac5d-4a6c-a11e-c911ae620695	2013-11-19 00:00:00
12027	9986 Pinto	\N	Burlingame	9	94010	E6100000010C2294F2823BCA42405F166CAB738F5EC0	ca501460-2648-48dd-bd13-f0cd457306a1	2013-12-30 00:00:00
12028	3766 Gumwood Dr.	\N	Marysville	79	98270	E6100000010C3673AD83AC014840D9BA94FDB88F5EC0	6114f12d-056c-409d-b609-5073f9df4061	2013-04-29 00:00:00
12029	664 Book Pl	\N	Cincinnati	55	45202	E6100000010C98AD585E55934340BD81E8F3F72255C0	1209be7f-be88-4a28-a060-f2435134c27c	2013-11-09 00:00:00
12030	643 Tri-state Ave.	\N	W. Linn	58	97068	E6100000010C68B5981063B246403903E98375A55EC0	1b1b4587-f8c6-48bd-a1f4-ccf954e32bd8	2013-05-28 00:00:00
12031	8465 F Mt Hood Circle	\N	Lincoln Acres	9	91950	E6100000010CE06C57E3C85A4040EEFFF80F1D3F5DC0	20a3f3cb-0fa5-42fe-b0ae-19696936ed25	2012-09-08 00:00:00
12032	8251 N. 447th St.	\N	Milwaukie	58	97222	E6100000010C5DDFA501A8B04640CEEC68F602A85EC0	3195b4be-9122-4c2a-8c6e-213d06777470	2012-10-11 00:00:00
12033	6329 El Rancho Drive	\N	Oregon City	58	97045	E6100000010CBAE79908B0A24640BF1BF8DE6AAA5EC0	50bb40c0-6e38-455f-882b-09830ab3b380	2012-08-19 00:00:00
12034	7407 Spring Water St.	\N	Chula Vista	9	91910	E6100000010CA4B1C996A14F40400110C1AB1E415DC0	d6e16d04-00fe-4de9-b8c2-54ef4b985b80	2014-05-17 00:00:00
12035	6369 Sunhill Lane	\N	Puyallup	79	98371	E6100000010CCACB94763B904740084D4354DE895EC0	8858dc2b-68da-41a8-bd6f-aa5da0a303c7	2014-02-20 00:00:00
12036	4701 Mt. Dell Drive	\N	Portland	58	97205	E6100000010C34951B2471BD4640203D60C604B35EC0	ed6e345c-96ca-4e34-873d-18959b4e5952	2012-04-21 00:00:00
12037	1 Smiling Tree Court	Space 55	Los Angeles	9	90012	E6100000010CE608E3074705414016AB045652855DC0	049e37b1-731d-495b-9411-7a7300b71c47	2012-05-22 00:00:00
12038	2 Columbia River Ct.	\N	Santa Cruz	9	95062	E6100000010C5555E258CE82424049A51C4E9E7B5EC0	18118b44-be00-495f-92e3-002d3094a9d2	2013-07-20 00:00:00
12039	4352 Olive Ave.	\N	Bury	14	PE17	E6100000010C665CF5363BCE4A4050C4ECC9316602C0	bf62e77c-c203-4fe5-bb6a-85fd77f03230	2013-10-17 00:00:00
12040	2097 Bluetail	\N	Kirkland	79	98033	E6100000010C1E4CB1A133DF4740C14551E843925EC0	93abd715-ef05-4133-bb71-491db8b27571	2013-12-29 00:00:00
12041	3593 Buckthorn Court	# 1	Kirkland	79	98033	E6100000010CC24197288ED04740E58FA3AD0F815EC0	298ab048-9e3c-4baf-9ba6-2baf7a6c5cc9	2012-06-23 00:00:00
12042	3862 Citrus Avenue	\N	East Brisbane	64	4169	E6100000010C621FEA976A773BC0BB3669AB3E256340	6aca09e0-a870-46ec-9691-cb30fa6ef298	2013-12-28 00:00:00
12043	1456 Bouncing Road	\N	Lemon Grove	9	91945	E6100000010C3CC4C788735D4040D9779DC244395DC0	747996ae-3a1a-47a7-8b05-6e22140d89d4	2013-06-03 00:00:00
12044	5950 Coldwater Drive	\N	Bracknell	14	RG12 8TB	E6100000010C73C5B44997AF4940DA6C9411F13FE8BF	d520bb59-a1bb-4fea-a72f-65602bf4e94a	2014-05-20 00:00:00
12045	7824 Frame Ln	\N	Corvallis	58	97330	E6100000010CCDFFE4D7B34D46405A23FAED06DB5EC0	d4e7e55c-fd46-4012-a1e6-c3621763b91f	2013-11-20 00:00:00
12046	9828 Hook Court	\N	Lynnwood	79	98036	E6100000010C6081C7F78EED4740C8CCAE2E4D8D5EC0	0ed5a8be-e45b-41e5-bb28-c7daa8f7d3fe	2013-10-25 00:00:00
12047	9106 Edwards Ave.	\N	Newport Beach	9	92625	E6100000010CB94B066AACCB4040EC4D9F68107F5DC0	0ee2bd0e-09bc-45d4-856f-b5004a106b0b	2011-07-09 00:00:00
12048	4020 Alum Rock Drive	\N	Bellflower	9	90706	E6100000010CD23E694D84EB404092AD36B9548D5DC0	3a56552a-a168-4e4b-acf8-e8648f64fce8	2014-05-08 00:00:00
12049	6705 Tweed Lane	\N	Coffs Harbour	50	2450	E6100000010C109B5C4579223EC0E8AD3602831C6340	f9d116c6-a2ae-427a-88f7-9ed92288272a	2013-01-28 00:00:00
12050	3711 Third Ave East	\N	London	14	SW19 3RU	E6100000010C53D2807072B649406018A459EC84CABF	0292d98f-e34a-452a-a9ba-e3017ee59625	2013-09-10 00:00:00
12051	141, rue Jean Mermoz	\N	Bobigny	179	93000	E6100000010CE79AF2C466704840E9A85726E4840340	b25121c9-f8b5-4d76-8b5b-affa191c7dbc	2013-12-21 10:09:29.423
12052	5699 Alpha Way	\N	Chula Vista	9	91910	E6100000010CEA99E994FC574040667754E45E405DC0	ccdc98aa-59d1-4237-b5d9-31431095433c	2014-05-20 00:00:00
12053	2929 Marie Dr.	\N	Cloverdale	66	6105	E6100000010CC3D1BC676CFF3FC092685CDC66F85C40	97c59c24-7b65-4706-902a-24533cbe0e50	2014-04-30 00:00:00
12054	15, avenue de la Gare	\N	Boulogne-sur-Mer	148	62200	E6100000010C9F738A211F66494084B6002EA1B9F93F	211c022a-56d2-4839-be91-599926455300	2013-12-21 10:09:29.423
12055	8719 Wilbur Drive	\N	Bellingham	79	98225	E6100000010C4B5819FA43574840151F75D659A65EC0	0e6a38b7-455e-400f-8157-ce7d0ebe54e4	2013-07-16 00:00:00
12056	3770 Viewpoint Ct	\N	Beverly Hills	9	90210	E6100000010C1469FE92E50C414031CEC35563985DC0	98340e27-bac6-4c90-9859-67596048437a	2014-04-06 00:00:00
12057	9752 Monterrey	\N	Goulburn	50	2580	E6100000010C921475FF4B4D41C01EA3844F27B46240	f291e7ed-8d1c-4bb5-9117-70c85b0a35d8	2014-06-24 00:00:00
12058	7829 Baldwin Dr.	\N	Caloundra	64	4551	E6100000010CB6B3415645D23AC002D0CE2AFA216340	04f4ff15-aaea-49d1-b9d1-a776b12a2999	2013-04-14 00:00:00
12059	8172 N. Ranchford	\N	Warrnambool	77	3280	E6100000010C5B243F8A1A0143C077E0A64A24D16140	6b79cc3c-868c-4881-b14c-c08d94703177	2012-06-14 00:00:00
12060	7870 Orangewood Dr.	\N	Grossmont	9	91941	E6100000010CEF1AC18DBA5B4040368E5B3347435DC0	5974717d-28ea-47ad-835b-0c012a078c2b	2014-02-19 00:00:00
12061	8857 Sunshine	\N	Wollongong	50	2500	E6100000010CD86F2B97343141C09243CCCF68D96240	ce435e1b-9769-4de1-86ae-0bd868549851	2013-09-18 00:00:00
12062	10 Napa Ct.	\N	Lebanon	58	97355	E6100000010CD074A890553D46404D7C261D2BAB5EC0	ec8e4793-28e6-4133-b99c-9bd2d812692d	2013-07-16 00:00:00
12063	15, rue de Terre Neuve	\N	Saint Ouen	127	41100	E6100000010C981872A7A5ED47406A62B4B7C136F23F	722a16a8-13db-4900-a99c-c841f9363da7	2013-12-21 10:09:29.423
12064	2328 Elk Dr	\N	Cliffside	7	V8Y 1L1	E6100000010CBE2B327DFB3C4840D4CA46A8A5D75EC0	12f110f6-011d-4946-8456-12a24512aefb	2013-07-18 00:00:00
12065	3598 Teakwood Drive	\N	Peterborough	14	PB12	E6100000010C46FBC6BDFB454A40AA12C44D2EF8CFBF	6f7bf3e1-ace5-4597-8e49-8c6b3c04a3e9	2013-11-16 00:00:00
12066	9474 Old Mt. View Drive	\N	London	14	SW8 1XD	E6100000010C4DFDFECB3CC149409FEFB1228046BFBF	f50d39bd-53ad-49c6-a0aa-8c73eeeca2a2	2013-07-29 00:00:00
12067	3986 Spring Hill Road	\N	Silverwater	50	2264	E6100000010CAD20180D798D40C0EB76F8448CEE6240	107d97c4-2b98-4ea1-9fdd-75962582035b	2012-05-04 00:00:00
12068	5093 V. Street	\N	Salem	58	97301	E6100000010C3D4BB649DE724640F769467447C35EC0	3afa6e80-f9bb-4b79-9f99-86f0bfbc96d0	2014-05-14 00:00:00
12069	5603 S. Rising Ave	\N	Darlinghurst	50	2010	E6100000010CE4AD8956CCEA40C0320F0326B7EA6240	4746a0a4-7ae0-43d1-b7cf-2bac54f50c44	2014-02-14 00:00:00
12070	1207 Concerto Circle	\N	Salem	58	97301	E6100000010C1A1677D20474464013A79607AFB65EC0	4c046641-02bb-4221-88d8-a3ba60b1d4ba	2013-08-02 00:00:00
12071	157, rue de l´Esplanade	\N	Paris	161	75008	E6100000010C31B174A0D26848401C105C379A800240	b6760f22-c9c1-4b4f-b06d-2c1964cd7a9e	2013-12-21 10:09:29.423
12072	328 Shell Dr.	\N	Burlingame	9	94010	E6100000010C14257BFCFAC342405F166CAB738F5EC0	a4737ab8-ddc6-4c67-a827-28927dfc41e7	2014-05-25 00:00:00
12073	Königstr 527	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	852d0a06-213c-4e93-a4cc-28bdbb50c8f4	2014-03-31 00:00:00
12074	2957 Tri-state Avenue	\N	Milwaukie	58	97222	E6100000010C97B4351EDFBC464056F0D2123AA75EC0	85fd532c-539d-4a39-93e6-e5979acb5483	2013-08-18 00:00:00
12075	9324 Bohon Circle	\N	Burlingame	9	94010	E6100000010CD1B496566CC542405F9C97B0AEA05EC0	4c6355ab-096b-4d04-bb44-61102420825c	2013-06-21 00:00:00
12076	2901 Sunny Ave	\N	Rockhampton	64	4700	E6100000010CD09FA8CBE56037C03E132972E3D46240	75d6711f-97cc-46e2-b6b2-b7c2622622fe	2013-08-18 00:00:00
12077	3984 San Francisco	\N	Santa Monica	9	90401	E6100000010C058D5AC2C8074140AE7EECC135A45DC0	e26c97ba-f48b-45ac-8c19-e4c23356b96d	2013-12-01 00:00:00
12078	607 B Way	\N	Woodburn	58	97071	E6100000010CBF692502648C464061A4D853C5BF5EC0	73347e8b-74a4-4c8d-b9d7-eb2966ea48e9	2014-01-29 00:00:00
12079	5520 Sierra Ridge	\N	Oakland	9	94611	E6100000010C35FF3867F1E942405F43BD4BE6885EC0	8bbf1996-e056-4620-b827-6761eb6d8248	2013-05-07 00:00:00
12080	5052 Bannock Ct.	\N	Issaquah	79	98027	E6100000010C690ED8A0C9BD474079357B9552755EC0	dee64b88-1635-4e3b-8a2d-711c3beafebf	2011-11-30 00:00:00
12081	Am Kreuz 555	\N	Kassel	19	34117	E6100000010C50C580E696A04940E1C8BFDA63F62240	db6cd589-4de3-42ec-8197-4eb91c1ff65a	2014-03-07 00:00:00
12082	220 Rambling Rose Ave.	# 103	West Covina	9	91791	E6100000010C4FD0522CC9014140426FC3AF78845DC0	3855de75-e212-466d-8d60-de1926b3311e	2013-09-26 00:00:00
12083	5155 Centennial Way	\N	Hobart	71	7001	E6100000010C981C659C0D6945C0AC2BF0F6EF736240	69006e4a-153c-4ee4-aefb-f641a807ec39	2013-09-20 00:00:00
12084	7 Pastel Drive	\N	San Diego	9	92102	E6100000010C0FAC25FFC15A40409C60E0E4F1425DC0	40e2e416-e5a1-4287-94fe-dff7e7cf75e2	2012-10-14 00:00:00
12085	159, avenue du Québec	\N	Paris	161	75012	E6100000010C46EC5C58E06A4840B7DAA6EEE65C0340	6a540f13-e517-4d26-bcaa-f58ba26a170b	2013-12-21 10:09:29.423
12086	8083 Ridgewood Drive	\N	Lincoln Acres	9	91950	E6100000010C72879691465840409E4937975C415DC0	ed701f6b-9b61-4bdb-960e-64a17bac6830	2014-05-19 00:00:00
12087	780 F Mt Hood Circle	\N	Peterborough	14	PB12	E6100000010CFEA7248E00484A4056853A945CF7CFBF	0ee3ef6b-1f88-4b96-b245-66e20427343a	2013-08-13 00:00:00
12088	5545 Green Road	\N	Beaverton	58	97005	E6100000010C241E9EAD60B74640696AEB8C58B35EC0	82ae23c7-c88f-466d-8028-1283c5a37bf2	2014-04-24 00:00:00
12089	9111 Almondwood Drive	\N	Sooke	7	V0	E6100000010CF6B2EB27D7284840542F52F8F7F15EC0	27157df6-e531-4a72-a2d2-28bee8346f02	2014-02-11 00:00:00
12090	2062 Dos Encinas	\N	El Cajon	9	92020	E6100000010CAC5CD9BF2561404050241BADD8495DC0	a96792e1-cac4-4ddb-8c60-d51f3bcdb9c7	2013-11-12 00:00:00
12091	648 Los Angeles	\N	Burbank	9	91502	E6100000010C55D83CADF5194140B5A0196FBC8A5DC0	6ba360c9-3ac3-40a8-91b3-d5e13e7dfa7f	2014-02-19 00:00:00
12092	6507 Mayda Way	\N	Bremerton	79	98312	E6100000010C021466F601CF4740E17F2157FFBB5EC0	bc9db4b3-3f5c-42cb-a320-32552f728290	2014-05-30 00:00:00
12093	8002 Morgan Territory Road	\N	Bremerton	79	98312	E6100000010C34D21B0666CE474011CD98F9A3AE5EC0	d2c0574a-8016-46be-a4ab-b249987cfb28	2013-07-17 00:00:00
12094	1462 Summit View Dr.	\N	Woodland Hills	9	91364	E6100000010C202629CF4819414062B5F953CB9E5DC0	1b417970-8460-49d9-80ab-d236dca470e4	2013-10-23 00:00:00
12095	1940 Detroit Ave.	\N	Concord	9	94519	E6100000010C949085145BF34240B0D2460F157D5EC0	993406d9-07ac-4184-aa9e-e992806756cc	2014-05-24 00:00:00
12096	5866 Military E	\N	Townsville	64	4810	E6100000010C253FBEC0E43E33C08686025818556240	e024babb-ec55-4650-9e4e-162e1c3803f8	2013-04-11 00:00:00
12097	5514 Grant Street	\N	Edmonds	79	98020	E6100000010CA8788CA5DBDD47406288123386995EC0	f8a7f8e0-6f20-4421-acaf-5668d74d6c7b	2013-08-28 00:00:00
12098	755 Palm Dr.	\N	Rhodes	50	2138	E6100000010C449295FAB1EC40C02249BB471EE86240	91917d8d-d4d1-4e34-84d0-917eddc32f93	2013-08-25 00:00:00
12099	174 Kim Court	\N	Coronado	9	92118	E6100000010C3EEA7A8776534040EF88B0402C495DC0	5613e21f-146c-4d7f-b85e-147bac7303a7	2012-05-14 00:00:00
12100	167, rue de la Comédie	\N	Versailles	164	78000	E6100000010C9F699A740E704840DC1093D182EB0040	9bac8437-6b35-4b46-a5b6-0c7c4987f7ad	2013-12-21 10:09:29.423
12101	19, rue de l´Esplanade	\N	Orly	180	94310	E6100000010C245714DF7859484077BB3F8850240340	89912244-fbd2-4fc7-8325-3cd68b16a1fe	2013-12-21 10:09:29.423
12102	1931, boulevard Beau Marchais	\N	Cergy	181	95000	E6100000010C4EE3D9556D8C484000705D698A840040	c230d980-862b-4e73-b05b-663a4186e99d	2013-12-21 10:09:29.423
12103	12, cours Mirabeau	\N	Paris	161	75012	E6100000010C544C717EE664484099F0D8EA592F0240	0c214ebd-522c-4f73-bc6d-c7b2f0208aef	2013-12-21 10:09:29.423
12104	4365 B Eagle Peak Rd.	\N	Shawnee	7	V9B 2C3	E6100000010C2C1C036C04374840906DB6BD6DDD5EC0	fb852986-b79a-45b8-ab19-01afc1217d79	2012-06-03 00:00:00
12105	1242 Frame Lane	\N	Yakima	79	98901	E6100000010C2783344F5756474097462B9FD5215EC0	783a3ee1-d1d0-4e5f-a8ba-cc1033e3ad22	2014-02-10 00:00:00
12106	9064 La Paz	\N	Ballard	79	98107	E6100000010C8187811214D34740B3EE551F71915EC0	56c5e70b-52b4-49af-9c1f-3de512bf5b62	2013-09-11 00:00:00
12107	8850 Via Del Sol	\N	Lynnwood	79	98036	E6100000010CED3A4A5D46E947403D8397AC79975EC0	092cc54f-8800-4c94-99b0-d6f5080d1baf	2013-11-03 00:00:00
12108	Pappelallee 665	\N	München	19	80074	E6100000010CE03960710512484036D5E09A32002740	cff4177f-1671-4b17-b5d8-2d387f700b5b	2012-05-29 00:00:00
12109	6928 Woodland Drive	\N	Westminster	7	V3L 1E7	E6100000010CADB746FDAE914840FD50538971C35EC0	3b7df810-7e4c-458d-a541-bea7dca08340	2013-03-25 00:00:00
12110	6968 Mildred Ln.	\N	Sedro Woolley	79	98284	E6100000010CAB21CD57703B48408B7929FB697C5EC0	899effd0-2a1e-477c-a308-333edfb8bf91	2014-01-28 00:00:00
12111	5300 East 88th Street	\N	Concord	9	94519	E6100000010CB985706C9DFE42403788562F66765EC0	1f1f95c0-eea3-411a-afe8-8ee23325ceec	2014-02-06 00:00:00
12112	Postfach 44 11 11	\N	Solingen	53	42651	E6100000010C5B55197ED597494032EFE9DF7B711C40	b12b3f03-5479-4c6c-9859-0dde7e1ca811	2014-02-01 00:00:00
12113	8250 11th Avenue	\N	Port Macquarie	50	2444	E6100000010C879FB26F63673FC000C768B1AC1C6340	26a07aed-2871-45da-80a0-fb8dade3404d	2011-08-14 00:00:00
12114	2, route de Marseille	\N	Bobigny	179	93000	E6100000010CEA156182C66F484004305A83E3880340	dff2c65b-aef5-4067-8cdb-e895269baa69	2013-12-21 10:09:29.423
12115	9491 Toyon Dr	\N	Kirkland	79	98033	E6100000010C7772E65919D94740CF35EAD4C0855EC0	766cb31b-2e7b-4c6c-ade8-1f84744fd588	2013-10-26 00:00:00
12116	6820 Willow Pass Dr	\N	Gloucestershire	14	GL7 1RY	E6100000010CC0E3D7DA75DC4940931481B8868DFFBF	086ce93e-5a7f-42e9-9d2e-3a197bda9e5f	2013-03-17 00:00:00
12117	2696 Santa Rita Dr.	\N	Spokane	79	99202	E6100000010C3157011964CF47408770B6D941555DC0	72547b86-b76e-48c7-85c8-f5a8a98e384a	2014-03-15 00:00:00
12118	4192 Mines Road	\N	Puyallup	79	98371	E6100000010C8F15A007A6924740CFB856D6908E5EC0	a4b796cc-5dd4-4e10-87c5-7f6663a60959	2013-09-16 00:00:00
12119	2964 Holbrook Dr	\N	St. Leonards	50	2065	E6100000010CD813D8A1F2E440C0A57EDCF46CE06240	1607dbbd-3738-47a3-a052-5ec11eb28e49	2014-01-13 00:00:00
12120	7650 Bonita Ave.	\N	Renton	79	98055	E6100000010C8BB4E473D1B4474061F18C45DF8C5EC0	310af276-54eb-4c15-9a99-e81de18741f1	2013-10-15 00:00:00
12121	2056 Otter Dr.	\N	Berkeley	9	94704	E6100000010CFF92400A78F142405C8E9CD14F935EC0	961b2124-e1ed-4d4f-bbfb-bcab3a564310	2013-07-22 00:00:00
12122	8423 Roundtree Court	\N	Haney	7	V2W 1W2	E6100000010C57FA215C8F954840500180D3DBA45EC0	e10a60b7-4c06-4c6b-8f5f-de7d80c08ee0	2014-04-12 00:00:00
12123	28, rue Henri Gagnon	\N	Croix	145	59170	E6100000010C86ED16E600534940FF8841072F340940	df355da8-18f9-40b7-bb2e-d7a48fdbbca0	2013-12-21 10:09:29.423
12124	3083 Boatwright Dr.	#6	Port Hammond	7	V6B 3P7	E6100000010C25D9C89DD0A94840BCD2F8FB2CC35EC0	c48961c7-b241-4597-8732-ea42b004b2d1	2012-07-14 00:00:00
12125	4635 Woodside Court	\N	London	14	SW8 4BG	E6100000010C3CB1A2A21BB849408B02F912F4DFCABF	cab728db-1935-40c9-85dd-040812ceb69d	2013-11-28 00:00:00
12126	4619 Ricardo Drive	# 233	Salem	58	97301	E6100000010C17DC19B10B784640789F2C1542B85EC0	062b5102-15e6-4008-b160-f778c7bbe108	2012-06-17 00:00:00
12127	8162 Zacatecas	\N	Townsville	64	4810	E6100000010C644D54967A3933C0D47CDF5BAB5B6240	1005d36c-8f72-47f1-b830-cc268a9e3f20	2012-10-06 00:00:00
12128	4151 Olivera	\N	San Diego	9	92102	E6100000010CECC8F50BC57B4040DDDD1DD7784E5DC0	61005c97-ef5b-406d-8dfa-229cbfd391de	2013-11-18 00:00:00
12129	1348 Montego	\N	Cliffside	7	V8Y 1L1	E6100000010C0E192D89E039484049B0CCE2E8D25EC0	c33b7ca8-7589-432a-aa2b-4073155a391b	2014-03-18 00:00:00
12130	9318 Hawkridge Terrace	\N	Lynnwood	79	98036	E6100000010C07AE4F28B5E04740D83C805D0A995EC0	8a532b0e-8443-4f7d-aa03-a3ce860b5aaf	2014-05-07 00:00:00
12131	Alte Landstr 9	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	971f08b8-939b-4c92-8032-0c96a46c0091	2013-08-13 00:00:00
12132	201, avenue de la Gare	\N	Roubaix	145	59100	E6100000010C97695F178A60494042585A554B730940	5fc59c87-68d9-49d0-a899-cc9a824036fc	2013-12-21 10:09:29.423
12133	9105 Santa Fe	\N	Sooke	7	V0	E6100000010CF6B2EB27D72848403C83AA3F2DF15EC0	96aeb864-aec3-4754-932a-b501b8dc273c	2013-10-23 00:00:00
12134	7182 Olive Hill	\N	Cliffside	7	V8Y 1L1	E6100000010CB26341594C46484010453C3EF6CE5EC0	afe1d082-5a06-4463-abd0-d504ccc4f459	2013-11-10 00:00:00
12135	6316 Glaze Ct.	\N	Milton Keynes	14	MK8 8ZD	E6100000010CD94C1C1F15FE4940D2BBE3275752E7BF	1a89dc70-e9c0-4ea0-bcb0-776e52ecc263	2012-06-21 00:00:00
12136	7223 Cortez	\N	Chula Vista	9	91910	E6100000010CE035B3AE26574040D39D6B3D5C495DC0	15c4d0c0-6163-4b5f-a22e-3e24ee7c22d0	2013-06-20 00:00:00
12137	7214 Peachwillow	\N	Sydney	50	1002	E6100000010C83BB631F53F340C00E28A652B9E36240	a8bfe3cd-5877-4870-b4b8-670400010bca	2014-03-22 00:00:00
12138	10, avenue du Président-Kennedy	\N	Paris	161	75019	E6100000010C9C93B32D9C6A4840A103FD93124A0240	a785994c-f477-4d69-981a-9b5bd6de303e	2013-12-21 10:09:29.423
12139	5346 Clayburn Road	\N	Rockhampton	64	4700	E6100000010CE58E0270E16C37C0D86B6207DAD56240	18301eb5-86d3-4f14-b4ac-73fc71e0b1eb	2012-07-03 00:00:00
12140	9456 Bell Dr.	\N	Spokane	79	99202	E6100000010C8E7E0445FBDA4740BA89BD65FE4C5DC0	c73a5f76-6332-4cdb-a95a-71bea65f2425	2013-09-28 00:00:00
12141	3236 Wicker Ave.	\N	Cloverdale	66	6105	E6100000010C3DC1224626FC3FC0D9ADF463C2055D40	385ac30e-3d2b-43a6-86ad-caab9d61bbfd	2012-04-01 00:00:00
12142	2407 Erie Dr.	\N	Oregon City	58	97045	E6100000010C8E22D33D02A546401C7A14F15BA35EC0	fa35ff80-8d44-43b0-a752-8ab69c18bedf	2013-07-20 00:00:00
12143	993 Piedmont Dr.	\N	Bremerton	79	98312	E6100000010CE9F09830D3C24740496E371D6DAF5EC0	f29a2672-9c38-436f-9283-ecc290716a1b	2014-02-04 00:00:00
12144	7243 St. George Dr.	\N	City Of Commerce	9	90040	E6100000010C847B94A0850341400ED69CF9C38A5DC0	7264bd4e-d398-4dbd-be51-e5e817d21078	2013-06-20 00:00:00
12145	5692 Fish Drive	\N	Oak Bay	7	V8P	E6100000010C90C9C216282F4840847686F80CD95EC0	044efd56-21a4-4ca9-abeb-9c7c86071ee0	2012-07-18 00:00:00
12146	Holzstr 1333	\N	Essen	20	45001	E6100000010C4587E8F6D4B24940081275AC9E191C40	d9e460bd-cf8b-4573-a79c-db022031372a	2013-08-29 00:00:00
12147	1807 Trafalgar Circle	\N	Victoria	7	V8V	E6100000010C32C9E02B262E48402248633E97D25EC0	5b38b19a-7bc6-494f-94a9-71d8db9075a5	2012-09-18 00:00:00
12148	1023 Riviera Way	\N	Oxford	14	OX1	E6100000010C953DE1BB7EDD4940A941CE12C921F4BF	cff1d259-6a1a-4eba-a245-d73a8a0d4b94	2013-10-10 00:00:00
12149	41 Third Ave East	\N	Warrington	14	WA1	E6100000010C61C1EB16B7B74A40FD366CBAEC8404C0	26c1c570-9063-44a5-aa28-1fb689483c90	2013-12-27 00:00:00
12150	8967 Hamilton Ave.	\N	Billericay	14	CM11	E6100000010C8397CFBE94D64940950F1B9735B1DA3F	42ee4535-657c-49f2-a1fd-bfed93cad95b	2013-03-04 00:00:00
12151	9236 Hanson Lane	\N	Sydney	50	1002	E6100000010C210B815DFDEE40C0B4CE9E7C7FEA6240	a542d42d-e33e-4f0b-9d10-053fd975d978	2012-11-02 00:00:00
12152	3556 Mt. Tri-state Court	\N	Woodland Hills	9	91364	E6100000010C0D4084CB99134140B43F6C7762A65DC0	0fd1212e-6284-42d6-a0d2-215ae9c5068b	2013-11-14 00:00:00
12153	22, rue Philibert-Delorme	\N	Lille	145	59000	E6100000010C011D35A1AF5749409DFFD518C0640840	cb42f88e-cc51-48f6-9fbb-226b5ce22ae5	2013-12-21 10:09:29.423
12154	1297 Zulu Court	\N	Goulburn	50	2580	E6100000010C8C29C5624F4941C09AAD84708CB66240	3eaf9646-1540-46f2-b35a-8b9f26626328	2013-02-26 00:00:00
12155	8254 North Ridge Drive	\N	Lane Cove	50	1597	E6100000010C27C42583B4E840C0ED6F38B12BEC6240	e1ea863c-61df-48fb-9820-1c2d10e93e5f	2011-11-14 00:00:00
12156	4583 Turning View	\N	Redwood City	9	94063	E6100000010C85844FBAD2BE4240AC9CA13705965EC0	3eb7b158-cbef-4940-981f-9dbb535069e2	2014-03-02 00:00:00
12157	1206 Limewood Place	\N	W. Linn	58	97068	E6100000010C4CB1F3AC10B04640A86C0B64BDAB5EC0	fc811f8b-1ed7-49a6-b973-371b37eb25e5	2014-03-25 00:00:00
12158	6119 11th	\N	Fremont	9	94536	E6100000010C1B38C5EDDEC34240DDAC7EB78A7C5EC0	ddb4bba6-2289-4f03-8235-bfed423d6dee	2013-06-25 00:00:00
12159	Berliner Platz 994	Einkaufsabteilung	Berlin	19	14111	E6100000010C00000000000000000000000000000000	ceae45e2-dbe5-4cde-9a00-f686cfdbcf9c	2013-07-14 00:00:00
12160	5651 San Benito Drive	\N	Seattle	79	98104	E6100000010CEE4CE1BF3BCD47409FEA9D6940985EC0	263a07ac-39e4-4e1a-b491-74c94c76f957	2013-09-07 00:00:00
12161	Hüttenstr 9005	\N	Frankfurt	19	60323	E6100000010C1D5EB0EDC02D4A40DC955B1CB11A2D40	b562a75b-a1fc-4ad8-9260-4523edd15e4f	2012-01-24 00:00:00
12162	Karl Liebknecht str 577	\N	Neunkirchen	70	66578	E6100000010C7D151D9891AA4840F422503F2F771C40	6897f00f-7d91-45f0-ba8f-d0761fa3c78d	2014-05-27 00:00:00
12163	3475 Chablis Court	\N	Torrance	9	90505	E6100000010CBACA38280DEC4040E146CF1E3C975DC0	c22ef3d0-208b-4855-aaa7-568add071869	2014-02-14 00:00:00
12164	Am Gallberg 6786	\N	Berlin	53	14197	E6100000010CD11F915047454A4063183CC85A9C2A40	23d94458-5b31-4797-ad26-7cd88bf48f21	2014-05-29 00:00:00
12165	3261 Vista Bonita	\N	Sydney	50	1002	E6100000010C8D02ADBA7CE840C025C7CB95C1E26240	e78bd799-8dfb-4a0e-bfef-cef6dd3ca55a	2013-07-13 00:00:00
12166	8682 Hungry Rd	\N	Victoria	7	V8V	E6100000010C4CECDC59C93B484004C9D04746CC5EC0	fe9b894a-66d4-4e84-9861-04de16caaf5d	2014-03-30 00:00:00
12167	1944 Serene Court	\N	Concord	9	94519	E6100000010CF883CC6EA4FD42404BD6685D74845EC0	90ab530b-d9b7-49ae-97aa-a4dc510a90a5	2014-02-20 00:00:00
12168	1379 T St.	\N	Cheltenham	14	GL50	E6100000010C579F691399F94940AB139882459A00C0	269bd4c2-a58c-49a3-b5be-9aeb7f14de79	2014-02-15 00:00:00
12169	9710 Valley Blvd.	\N	Port Hammond	7	V6B 3P7	E6100000010CE7F602DD179F484006DD39E46ACD5EC0	04868706-54d8-42b1-a108-f67db41bf18c	2011-12-24 00:00:00
12170	74, rue Descartes	\N	Les Ulis	177	91940	E6100000010C8D2503367B5948400DA6A9268F510140	3dae9b4d-387a-4012-beaf-981f9fc9f121	2013-12-21 10:09:29.423
12171	2467 Clearland Circle	\N	Berks	14	SL4 1RH	E6100000010C6C1FE7CA84B8494017CAE6712D89E3BF	f7aa2b16-705c-4dc3-8594-a79b81d05eb6	2012-07-19 00:00:00
12172	4678 Cardinal Dr.	\N	Beverly Hills	9	90210	E6100000010C898E26CBE11341403870848AC1A35DC0	aaa8db21-d907-4ae4-b4c7-c096c6cba23e	2014-02-11 00:00:00
12173	3902 Gary Drive	\N	Puyallup	79	98371	E6100000010C8AA22612C0A147406346871B4F9A5EC0	faf0cc12-f35f-48c8-b18d-5c30f12177c5	2013-02-01 00:00:00
12174	7106 Cynthia Drive	\N	Renton	79	98055	E6100000010C467F49712CB14740AF81F2A0868A5EC0	2767abcd-bfc0-428b-a2ad-84adbf703836	2013-12-30 00:00:00
12175	Werftstr 154	\N	Erlangen	8	91054	E6100000010CD292FB996EC74840C51DADC0DA042640	7c82de6a-41cd-4b0b-a515-2941f9e5b01b	2013-08-31 00:00:00
12176	8601 Oakgrove Rd.	\N	Lebanon	58	97355	E6100000010C09FBD0929A434640ACCAE3812BB65EC0	d815a0f1-be88-4a05-bcf7-dee7c0dbe397	2014-04-27 00:00:00
12177	Herzogstr 3998	\N	Berlin	19	14111	E6100000010C00000000000000000000000000000000	c02d6cdc-415f-4a64-ae88-56057cc18ef7	2012-12-15 00:00:00
12178	2061 Matchstick Drive	\N	Newport Beach	9	92625	E6100000010CDD443FC917C9404044B11303396F5DC0	59fa33db-f220-4843-9f80-eeff90b6c0fb	2013-07-23 00:00:00
12179	6465 Detroit Ave.	\N	Portland	58	97205	E6100000010C694C711E14D146407B9BCFD846B65EC0	f45394b5-292c-428c-aad6-ade2ce39ae61	2013-12-29 00:00:00
12180	280 Plymouth Dr.	\N	Coffs Harbour	50	2450	E6100000010C85A0810DEE203EC05B60A8FAFA1D6340	37293cbb-2b35-4f87-b87b-591ee290d910	2011-11-29 00:00:00
12181	879 Megan Dr	\N	Courbevoie	178	92400	E6100000010C046EC6AFBB6C4840441C717350070240	11f2a116-b90e-40f9-b599-1cfef0d83308	2013-12-21 10:09:29.423
12182	4837 Melrose Place	# 1	Tacoma	79	98403	E6100000010C35A8638970A94740C75BA5CC97945EC0	5ff56745-948b-4498-94e2-2f3b30b78ada	2014-05-06 00:00:00
12183	4116 Candelero Place	\N	Shawnee	7	V9B 2C3	E6100000010C7C0E1A98B23F4840ACDFA68BE9E65EC0	4bfc84ad-befc-4c62-820c-1b154536fcff	2013-12-25 00:00:00
12184	3718 Greenway Drive	\N	Langford	7	V9	E6100000010CD814B59C31384840430943C066E65EC0	ae17e2a0-5c79-4008-a597-b5354fc90380	2014-03-01 00:00:00
12185	594 Tossing Way	\N	Puyallup	79	98371	E6100000010CE9B39538209E47404DF55941598F5EC0	ec476931-de6a-486e-9248-b251792b496e	2014-03-09 00:00:00
12186	8417 Estudello St.	\N	Grossmont	9	91941	E6100000010CB175FB0BAA5E4040C6260ACD44495DC0	e4f935dc-649e-4691-ba73-e29188650b83	2013-03-26 00:00:00
12187	6358 Parkview Court	\N	Lane Cove	50	1597	E6100000010CA1408123BCEB40C0093B5A81C0E96240	9db2d3db-135b-48df-a2ce-e7c8bb8abd16	2013-12-01 00:00:00
12188	8203 Courtland Drive	\N	Lebanon	58	97355	E6100000010C1DDE9479E73D46406946D2D206B35EC0	9e44a65f-f498-412d-a1c2-13c86ef45692	2012-05-27 00:00:00
12189	6281 Edward Ave	\N	Burien	79	98168	E6100000010CEAEB06D2E4B94740C8E37E5BD8965EC0	585694ad-2152-45cb-80fd-5d82df076a9b	2014-01-26 00:00:00
12190	6321 Maya	\N	Port Orchard	79	98366	E6100000010C359A913DE2BF4740AA4E7D4F6FAB5EC0	b5172c4a-2e43-4d1d-8a88-85dfbf888ebc	2013-10-20 00:00:00
12191	27, place Beaubernard	\N	Paris	161	75016	E6100000010CB964B8CDE2684840C39E8A0BC20B0240	1b8aeada-8039-4e0f-b480-ea58f5bef3f7	2013-12-21 10:09:29.423
12192	7308 Star Tree Court	\N	Burlingame	9	94010	E6100000010C88133C7314CE42407287892D80965EC0	251f3fbc-25fd-425e-8492-e6734a1b41c1	2014-01-17 00:00:00
12193	Pflugstr 24	\N	Solingen	53	42651	E6100000010C5911F12BF98F4940A789633DF0721C40	1ed6d9aa-2ed7-4e2c-8f2b-80d793d2e971	2013-07-10 00:00:00
12194	44 Garcia	\N	West Covina	9	91791	E6100000010CD9147F4BF7034140D0F84BB922765DC0	4e5833c6-a584-4cfe-94a2-abb4a17e093e	2014-04-07 00:00:00
12195	2049 Benedict Court	# 11	Tacoma	79	98403	E6100000010C35A8638970A9474020F73006C89E5EC0	b7f8c4cd-c829-4478-83b8-c6cf3d5403c6	2014-04-15 00:00:00
12196	3544 Brush Creek Drive	\N	Edmonds	79	98020	E6100000010C79339C7EB1DF474076F453B9578F5EC0	a23d0a45-6573-4cac-beed-831101af6a37	2011-11-25 00:00:00
12197	9658 Guadalupe Dr.	\N	Corvallis	58	97330	E6100000010CD5F776316B5746408FC6AC649DCD5EC0	574c0f82-9378-4565-be11-bb1374c169f4	2013-07-11 00:00:00
12198	Carlsplatz 4	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	d27bd588-9642-40c3-9e83-160ea49623a4	2013-09-30 00:00:00
12199	90, route de Marseille	\N	Paris	161	75007	E6100000010C69AD1F89D8734840BE11A507E67F0240	a1c6c42b-7f0e-4e76-81ac-35645f6172c0	2013-12-21 10:09:29.423
12200	6541 Central Ave.	\N	Cranbourne	77	3977	E6100000010CA31A6E47B61043C02FDECC67FB236240	a89e28d8-5b14-4b49-945e-3dad510e2eb5	2013-09-18 00:00:00
12201	2436 Pheasant Cr.	\N	Newton	7	V2M1P1	E6100000010CB9083839D8F54A405DA8379B30AB5EC0	1961137d-47c5-47f0-838f-e55ee00673d2	2013-10-10 00:00:00
12202	9058 East 23rd Street	\N	Coronado	9	92118	E6100000010C0D92C454EC5D4040A0DCDA1AAC505DC0	03094e7c-b597-4f89-858c-1a94c762e19e	2014-04-21 00:00:00
12203	7154 Broadway	\N	Gold Coast	64	4217	E6100000010C6A764569FBF73BC0E9294A51152B6340	f6d88b04-94b1-4124-901d-16ff2df217f4	2011-08-06 00:00:00
12204	Altendorfer Straße 390	\N	Berlin	19	14111	E6100000010C00000000000000000000000000000000	662044ca-1bca-4bd5-a752-342944041a37	2013-05-18 00:00:00
12205	3972 Almond Drive	\N	Tacoma	79	98403	E6100000010C35A8638970A947403DAF663A149A5EC0	cd29142b-46e7-4d5e-bfbb-184a00e72d0d	2014-03-13 00:00:00
12206	8914 Elkwood Dr.	\N	Concord	9	94519	E6100000010C3B837882340143409857791AD1785EC0	67f2f5b5-4eb3-4d63-b923-0f4ec311acf5	2013-11-03 00:00:00
12207	3, allée des Princes	\N	Villeneuve-d'Ascq	145	59491	E6100000010C54BEE8C9B7584940A4919E8315230940	dd9a470e-ec46-4fc3-a29f-353faacab170	2013-12-21 10:09:29.423
12208	71 Westwood Lane	\N	Palo Alto	9	94303	E6100000010CF89DEC590DC042401066F304F0855EC0	d03b5088-c3f9-4996-8a0b-abd7389d4417	2013-02-16 00:00:00
12209	5420 Thornwood Drive	\N	Lane Cove	50	1597	E6100000010C50CB6E42A5E240C05B9CBFF17EE26240	628e0fb8-b874-4f55-8bf9-076a096fc424	2012-04-25 00:00:00
12210	8457 Teak Court	\N	Warrington	14	WA1	E6100000010CF674EEF521BB4A401D2FEC6E7E9004C0	b9dcb87f-f7c0-40ed-bb48-c4fdff928377	2013-11-10 00:00:00
12211	6535 Warmcastle Ct.	\N	Oak Bay	7	V8P	E6100000010C1916C566503A4840B3D45EE278D75EC0	49efbe0c-e224-49e1-b398-c776cf362ba7	2014-01-26 00:00:00
12212	Brunnenstr 6675	\N	Neunkirchen	70	66578	E6100000010C500401CC81A44840986AD3D05E5D1C40	a5c0f0d4-2301-41a3-a780-3deb49634b17	2012-06-01 00:00:00
12213	9231 Santa Ana Drive	\N	National City	9	91950	E6100000010C8A559524EE544040EEFFF80F1D3F5DC0	001d49b4-dce6-4da2-bca3-4f4fd6fd0dff	2014-04-10 00:00:00
12214	310, rue des Rosiers	\N	Colomiers	117	31770	E6100000010C05B425698BD54540F4F00AB2AF32F53F	e1b63395-7608-4f70-af9a-3412ea279464	2013-12-21 10:09:29.423
12215	7562 Daylight Place	\N	Marysville	79	98270	E6100000010C908797B5D20F484011BDD47FD9925EC0	3d3b90a4-ab5e-4278-8f28-57367099dc82	2014-02-22 00:00:00
12216	Auf dem Ufer 424	\N	Kassel	19	34117	E6100000010C29FAC1915AB049409317739531FD2240	61ae59db-1506-4458-8a24-823a170a8911	2013-12-26 00:00:00
12217	514 Rambling Lane	\N	Cheltenham	14	GL50	E6100000010CFF505D2EA2EF49407C21519F0AA700C0	bce88dd9-a061-4d13-ba27-92a1633998e9	2014-01-09 00:00:00
12218	Knaackstr 956	Leiter der Abteilung	Berlin	70	14197	E6100000010C3FF5706DEF434A409D92F30894A62A40	553b258f-6bbd-4dbd-af4c-e2af7d1c0842	2013-10-28 00:00:00
12219	2303 Rosebuck Way	\N	Spring Valley	9	91977	E6100000010C5D77008D6A5F4040E59ACFA483485DC0	5dd6e175-3fe1-4beb-9f9e-e46514479e4e	2013-01-27 00:00:00
12220	6793 Longview Road	\N	Beverly Hills	9	90210	E6100000010C0BE27648960B414083A4253D15935DC0	a586fc39-1a9b-4090-8141-4f16959cfb8d	2013-11-27 00:00:00
12221	9955 Terra Grand	\N	Rhodes	50	2138	E6100000010C79A08C03EEE740C076136CD215E96240	cf4c4336-e468-4b13-9509-43cd8f5ba4cc	2013-09-17 00:00:00
12222	5045 Vancouver Way	# 133	Langley	7	V3A 4R2	E6100000010C2197FC2B8C9148402B7C048E9FAA5EC0	7dae1870-6014-4b6c-a170-72bc020aebcf	2013-07-01 00:00:00
12223	3944 Kingsford Dr	\N	Seaford	77	3198	E6100000010CED130F79AC0E43C0193A4445D9266240	f0a635cb-670c-41b3-85f3-52c41dddc903	2013-08-01 00:00:00
12224	9682 Morello Court	\N	Lavender Bay	50	2060	E6100000010C99D2B6A81DEC40C014EF02FE5CEA6240	afc76dd4-23df-4b59-b8eb-610aa968b511	2014-03-23 00:00:00
12225	1159 LaCrosse Ave	\N	San Francisco	9	94109	E6100000010CB61E51D3EFDE42403DA89E6502975EC0	193972c1-7c6c-4678-a601-6fbecb3d29f9	2013-07-19 00:00:00
12226	90 Toyon Dr.	\N	Burlingame	9	94010	E6100000010C8A28351E49CF4240D322A8F8CE8F5EC0	d07a94ba-7319-45ce-bf0a-c54deaca036c	2013-10-28 00:00:00
12227	3320 North 5th St	\N	Colma	9	94014	E6100000010C74CE9D0895D0424056E2E0C5A9925EC0	b94513c2-9983-4e72-811d-4d0df6dd39bc	2013-09-13 00:00:00
12228	9276 Blackwood Drive	\N	Sooke	7	V0	E6100000010C25CBC08715374840EC1D765077E85EC0	7174f35d-7bbe-4377-9334-78efb49fbc93	2014-01-24 00:00:00
12229	3936 Cleveland Rd.	\N	Woodburn	58	97071	E6100000010CF82F6CC46F9046407F335DEF1DAC5EC0	15e087a9-c9ff-4abf-86d6-7c017f9ca4e4	2013-09-04 00:00:00
12230	8117 Green View Court	\N	Perth	66	6006	E6100000010C8758A2310AED3FC0CA17734A32F55C40	334e2f42-f872-45a1-aba9-03b711b6a2ad	2013-09-08 00:00:00
12231	39, rue de l'Espace De Schengen	\N	Chatou	164	78400	E6100000010C210157DBFC694840D93D9F75873A0140	f01625ac-c280-4328-813c-e26c2c7ea20f	2013-12-21 10:09:29.423
12232	8435 Kenmore	B105	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	39c7b1c0-9c31-4843-9a86-f5070ad39f57	2014-02-01 00:00:00
12233	8127 Otter Dr.	\N	Downey	9	90241	E6100000010C3DC0905E93FB4040AF211670AA7E5DC0	b3f73c4c-700a-4d2f-ba11-ba682007db77	2013-07-01 00:00:00
12234	5004 Mazatlan	\N	Novato	9	94947	E6100000010C373A219FEE094340A18AE78DDEB05EC0	4f627b3b-d4ce-405c-89a3-746b381d82e2	2014-04-08 00:00:00
12235	2828 Rogers Ave.	\N	Everett	79	98201	E6100000010CACA7216D2DF947403C41AEE15D835EC0	5de9bfe8-1ff7-4bdb-9bca-e718841f324d	2014-02-20 00:00:00
12236	2614 Park Glen Ct.	\N	Hobart	71	7001	E6100000010C712DF077C36545C06E868C4629706240	5787007c-e5cf-4323-b190-03965d14860b	2014-03-11 00:00:00
12237	Husemann Straße 7574	\N	Paderborn	53	33098	E6100000010CD7C04BC640DA4940D9F7F143CF832140	25d1c39a-0bb9-43b6-b7a7-2c77d8899da9	2012-10-13 00:00:00
12238	9440 First Ave.	\N	W. York	14	BD1 4SJ	E6100000010C8FD371B6A2EB4A407154BEDC4B06FCBF	3fbc9280-3228-4116-a372-21fc82ed535d	2013-09-13 00:00:00
12239	732 East 87th Street	\N	Long Beach	9	90802	E6100000010CC269CBF8BBE0404085FC6D1267915DC0	7778a6d5-5c24-433c-80fa-5d1388478c5f	2013-11-22 00:00:00
12240	2286 Sunset Way	\N	Cliffside	7	V8Y 1L1	E6100000010CA53B115229484840BA5D0E75B3E25EC0	abf87245-023a-49e2-9bc0-e69d7ea5b33c	2013-12-08 00:00:00
12241	34, rue des Rosiers	\N	Paris	161	75003	E6100000010CF3EB6FC11D7748400F1C27B433DF0240	27fd8a8c-6fe4-47e8-94f7-0fba4349a352	2013-12-21 10:09:29.423
12242	7887 Twinview Place	\N	Burien	79	98168	E6100000010C2648A3548ABD47400EBD10B5C1885EC0	c636b09d-6c4d-4d6a-93cc-a9cf2d0656ba	2013-11-13 00:00:00
12243	44bis, boulevard Saint Germain	\N	Pantin	179	93500	E6100000010C70D8A198817548405274FF4D7A4D0340	24e2cffd-0745-4e02-b40c-ab79373cd2a6	2013-12-21 10:09:29.423
12244	8228 Seal Way	\N	Coffs Harbour	50	2450	E6100000010C1EFD90F8F62A3EC096CFD7A77D1D6340	c7e744f9-01a6-4010-b9dc-0da8449f0863	2012-07-06 00:00:00
12245	Marienplatz 313	\N	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	f358f748-3869-4426-b098-434c6dc9e242	2013-08-31 00:00:00
12246	9063 Vista Aven.	\N	Haney	7	V2W 1W2	E6100000010C8BFFC397E4A04840AD58ED4845AE5EC0	f7870c95-9da1-4adb-a221-3a7edfb4b292	2013-06-30 00:00:00
12247	14 Delta Road	\N	Burien	79	98168	E6100000010CF55F90FD1BBB4740C8F0F8928A9B5EC0	05dd1195-a3e3-4cd5-a834-3cef1338351f	2014-04-04 00:00:00
12248	3, rue Surcouf	\N	Chatou	164	78400	E6100000010C6B05AF149D6A48405EE22DAE3C350140	a142e16b-2d49-4ab6-b048-352ecbfd80e3	2013-12-21 10:09:29.423
12249	7954 Monument Blvd	\N	Oregon City	58	97045	E6100000010CAA0EBEE5BFA64640D7CC7F9FCF965EC0	42e0ae47-5e72-4c7b-bdb7-4ddceda511f4	2012-01-06 00:00:00
12250	7886 Burwood Way	\N	Cranbourne	77	3977	E6100000010C8406544A3F0F43C0C683656FC5266240	eadb8b61-b6c5-4913-8a2e-0577978a3a3d	2013-09-01 00:00:00
12251	1413 Bridgeview St	\N	Glendale	9	91203	E6100000010CFA0EA40B7D1741402CFF629F4C965DC0	88009c11-59e8-4a7c-8846-e49718a60073	2013-08-04 00:00:00
12252	5818 San Rafael	\N	Grossmont	9	91941	E6100000010C7D4655C2805F40401142846648405DC0	1d7ab375-c7db-4563-a9bf-b38ada8cd12e	2013-12-13 00:00:00
12253	40, rue de la Centenaire	\N	Les Ulis	177	91940	E6100000010CD68EB8BA1E554840819BCFD0E54E0140	b7ecae2b-02b6-4f4a-812f-af6ddd90aeee	2013-12-21 10:09:29.423
12254	Wasserstr 63	\N	Eilenburg	85	04838	E6100000010CCA904C2B01C04940945EAF1763582940	515b76bc-6395-4c94-a5f5-5940acfb902f	2014-05-15 00:00:00
12255	2187 S. Rising Ave	\N	Lynnwood	79	98036	E6100000010CC785E38642DE474074F6680E9B9A5EC0	9e923f84-54fe-415f-b4e8-7e533358cb5b	2012-06-15 00:00:00
12256	4190 Trujillo	\N	Sedro Woolley	79	98284	E6100000010C898580FD204448406B22302DC9855EC0	ea7312a5-6dcb-4efa-995f-b72e755933d2	2013-08-03 00:00:00
12257	3469 Relief Valley Ct.	# 22	Royal Oak	7	V8X	E6100000010CA8426E87D53C484030527F3306D75EC0	0ecd8da4-b3bd-40c9-8f95-6cea1045d640	2014-01-28 00:00:00
12258	8381 Lake Place	\N	N. Vancouver	7	V7L 4J4	E6100000010CCF717F3E3AA948400FF36ED41EC45EC0	5f3ae077-5aa2-41a0-8761-82f49fef1eaa	2014-02-24 00:00:00
12259	7914 H St.	#9	Everett	79	98201	E6100000010CE4DEB05119F6474085DF5CB3FE885EC0	77f9de31-8675-4ba5-be5e-ba9366c09f8d	2014-03-18 00:00:00
12260	5345 Willow Avenue	\N	Rhodes	50	2138	E6100000010CF1A668CA8FED40C0738B960751E26240	f2996603-8422-48b2-8b61-57c40a3ab5aa	2013-09-18 00:00:00
12261	3082 Heritage Oaks	\N	Lemon Grove	9	91945	E6100000010C67ABB39E205F4040E43D8043C33D5DC0	63a022a6-d128-4a0f-a59b-b8e4e303b328	2013-08-30 00:00:00
12262	2868 Filling Ave.	\N	Beaverton	58	97005	E6100000010CB3AF78D52FC44640EDF507F1C6BC5EC0	e6c5f547-6af2-43d5-ae87-10a323c21a18	2014-03-10 00:00:00
12263	3543 Lori Dr.	Apt 110c	Malabar	50	2036	E6100000010CDE7AAE33A3FC40C066E46991E1ED6240	5ff28f8e-26e2-48ae-89ef-e65dfa7b9420	2011-11-16 00:00:00
12264	946 Hanson Lane	\N	Corvallis	58	97330	E6100000010C23E25487214D46408FC6AC649DCD5EC0	50ee5e02-01bc-42f9-a406-a129f2ed6aa5	2011-11-10 00:00:00
12265	6920 Merriewood Drive	\N	Newport Beach	9	92625	E6100000010C6A6E73AEA9C840400C200EA392805DC0	8b369bbe-91c5-4e71-978a-5811ed754b0a	2014-01-14 00:00:00
12266	39, avenue des Laurentides	\N	Dunkerque	145	59140	E6100000010C4B3035EA3A804940C3281FE0D3D40240	3d0e8d7b-b8b9-4ac3-9b84-a7c8254ca71d	2013-12-21 10:09:29.423
12267	8202 Lion Circle	\N	Long Beach	9	90802	E6100000010CC6E5D47C5AE64040CB1228CAE38F5DC0	6f8f9c3c-4a36-48eb-838b-dcbe1afd642f	2013-06-19 00:00:00
12268	3 Oaxaca	\N	Lakewood	9	90712	E6100000010C0822FE8836F24040005E2C9C1E8A5DC0	b9835e6c-adcb-4a72-8ec3-173b119f85b2	2012-10-06 00:00:00
12269	5, route de Marseille	\N	Paris	161	75010	E6100000010C7AE4034BA46D48403220FFD8C5E40240	9f42c81a-0444-48af-a5b2-5c3ba1199016	2013-12-21 10:09:29.423
12270	3302 Trujillo	# 112	Bellflower	9	90706	E6100000010C8975D50C97F14040D24754934E8A5DC0	4cfe6e5c-a3ca-4ca9-a352-d95fcad7254d	2013-02-08 00:00:00
12271	2989 Pepper Way	\N	Milsons Point	50	2061	E6100000010C92623A0CC3E640C0B33D7384A4EC6240	051dde23-2e2e-4446-a752-0f04d9a8b06a	2013-03-26 00:00:00
12272	534, rue des Grands Champs	\N	Paris	161	75007	E6100000010CEE8F1D01C1664840F4E406A4D9420340	added9d2-96fe-4366-b526-1f1cb7ab6fb2	2013-12-21 10:09:29.423
12273	Dunckerstr 7835	\N	Berlin	70	14197	E6100000010C49282B50854A4A409331ABEBACE02A40	b0ee808a-25d8-4743-9558-48ca69f577c7	2014-02-10 00:00:00
12274	258 Bluejay Dr.	Unit A	Newton	7	V2M1P1	E6100000010C28E0DF3F0EFC4A40CB783B3655AE5EC0	24a390d8-9295-4461-855d-e0e1f643b1b5	2013-07-30 00:00:00
12275	2007 Shady Ln.	\N	Townsville	64	4810	E6100000010C53790A9E763A33C0F0F9F19E56516240	a6240215-cd5e-4425-b6be-45fea859e545	2011-08-08 00:00:00
12276	8, rue de l´Esplanade	\N	Dunkerque	145	59140	E6100000010CAF0586327F8349404A6DE89558D40240	654790f5-8cb6-4d14-b4f5-4741192af726	2013-12-21 10:09:29.423
12277	8375 Ambush Dr..	\N	San Diego	9	92102	E6100000010C41CAF8322D5B404049ADD224304E5DC0	6a0d2272-ba4d-40d9-97eb-5d5fbf2284d0	2013-12-08 00:00:00
12278	3035 Blackfield Dr.	\N	Lemon Grove	9	91945	E6100000010C78087F8CD75840404332FAC440455DC0	23605dbf-d8ad-4bc9-a647-38a87272f228	2014-04-29 00:00:00
12279	712 Sweetwater Drive	\N	Concord	9	94519	E6100000010C0B8B5C65880143403887548EB38A5EC0	aa5b4b33-6e3c-4702-8143-543eb02ed73b	2014-05-12 00:00:00
12280	9657 Santa Maria	\N	La Jolla	9	92806	E6100000010C19F01E3021ED404020E986745E805DC0	bd01a38d-8569-4f25-bb0b-c3687ec30e8b	2013-08-17 00:00:00
12281	Westheimer Straße 9292	\N	Hamburg	20	20354	E6100000010C5CAB3B91ACCB4A406933AA5B5FFB2340	2ecacebf-7221-4359-b2e6-572e7fe7cd73	2013-01-15 00:00:00
12282	951, rue Villedo	\N	Metz	143	57000	E6100000010CD1E4D99F46864840AC9AE9AC32C31840	121fdd79-83e3-41eb-b57e-e8bb755877b4	2013-12-21 10:09:29.423
12283	4103 Valley Blvd.	\N	Haney	7	V2W 1W2	E6100000010C266EFD9DF7994840C9FF6DBBCC9D5EC0	4c620e9d-6e6f-4b6a-8a38-891e48e9677d	2013-12-21 00:00:00
12284	9270 Via Pablo Neruda	\N	Hobart	71	7001	E6100000010CDEB5B5651E6445C0E1B35AEE456E6240	b1121dd9-edc9-41b1-ba11-d34de9d49219	2012-07-03 00:00:00
12285	Werftstr 44	\N	Saarbrücken	70	66001	E6100000010C0B59945CE99A4840EB02DB6407B41B40	af6f8eb2-c257-402f-bc9b-b6566006a9fe	2013-08-04 00:00:00
12286	9056 Mount Dr	\N	Chula Vista	9	91910	E6100000010CC7A5D915CF534040E881161AE1385DC0	08614d4d-32f4-4696-b6e4-8bc2bbc45e5e	2013-12-29 00:00:00
12287	7134 Oakwood Cir	\N	Spring Valley	9	91977	E6100000010C8464E693105C4040D94362078A395DC0	acc43136-c20f-44a2-a1d2-678c77d0bfdf	2013-08-24 00:00:00
12288	4751 Grant Street	\N	Springwood	50	2777	E6100000010CBA8F7C6F89D140C0136B8B446BD96240	4115b4fb-b122-414d-b7a5-7e89c6841dde	2013-07-22 00:00:00
12289	7058 Crestwood Circle	\N	Billericay	14	CM11	E6100000010C7BA28D4CB4C84940BF7024387AAEDA3F	ab7f38c3-1c54-429d-a9b0-8d7deb63fa07	2013-12-27 00:00:00
12290	9830 Corcoran Road	\N	La Jolla	9	92806	E6100000010CBE1C30EA75F140403CCBAEEA50775DC0	7868cdf5-dc8a-428a-8776-7917e9feff9d	2011-06-22 00:00:00
12291	P. O. Box # 9257	\N	Beverly Hills	9	90210	E6100000010CB051E5EF870841408A46E671739E5DC0	b761827d-3f63-49fd-9f76-a72c7015b45b	2014-05-14 00:00:00
12292	3543 Hilton Way	\N	Sydney	50	1002	E6100000010CC5413C3897F140C00E28A652B9E36240	c82d3ec4-3879-48ad-ba53-28cd100ca452	2013-04-20 00:00:00
12293	1773 Royal Palm Lane	\N	Gold Coast	64	4217	E6100000010CC2D7925E73033CC078347260F9306340	e03a3b48-57fd-4190-a94b-22bcf94be598	2011-08-09 00:00:00
12294	Carlsplatz 1	\N	Kassel	19	34117	E6100000010C1E8B7C430AAF4940DE119F7E06032340	1bb5c8da-785a-498c-aadc-a0165389f04f	2012-11-17 00:00:00
12295	689, rue Maillard	\N	Versailles	164	78000	E6100000010C92A97CFBCF644840F40AA10948F00040	aec8f759-7fb6-43d2-a938-d5b1ddcdbf78	2013-12-21 10:09:29.423
12296	6535 Warmcastle Ct.	\N	Ballard	79	98107	E6100000010C24BEA9372ED94740BFA767AE5B955EC0	f5d3fb96-a240-489d-98eb-7eef185e7622	2013-07-26 00:00:00
12297	1113 Catherine Way	\N	Newport Beach	9	92625	E6100000010C30605B4C6AD340405A766DABF56C5DC0	39c83531-6efa-4ccf-b1ab-fa1a7833a625	2013-12-05 00:00:00
12298	9697 Sunshine	\N	Coffs Harbour	50	2450	E6100000010C567A7E94BC2B3EC022DDE0D452256340	83d7b049-42ae-4da7-bb66-78034820bc0b	2011-09-01 00:00:00
12299	Wallstr 8834	\N	Erlangen	8	91054	E6100000010C5115473756C94840AEE828EA5E092640	dff6f575-f3db-44c7-8a63-6b36a9d4ca57	2014-01-11 00:00:00
12300	7053 Laurel Dr.	\N	York	14	YO15	E6100000010C332C8AF07AFD4A4060E435F0524FF1BF	aad1553d-e87d-4710-814f-9a2e91ef1bb4	2013-09-18 00:00:00
12301	512 Salvio St.	\N	Shawnee	7	V9B 2C3	E6100000010CFAD4FFF7C635484010BA7521DDEA5EC0	e02a87a4-329b-4c10-b204-9eb4cee6e5cf	2013-09-02 00:00:00
12302	4917 Lacanda Ct.	\N	Oregon City	58	97045	E6100000010C52701BF821AD4640EE039617709F5EC0	bababb94-2e58-4dcf-a4d5-9cad53cdee35	2013-11-14 00:00:00
12303	14, allée des Princes	\N	Les Ulis	177	91940	E6100000010CDF9272C1E34E48403BBB5DD2E1560140	59031eeb-5583-46b9-9bed-cdc1fc24d5dc	2013-12-21 10:09:29.423
12304	8629 Pepper Place	\N	Seattle	79	98104	E6100000010C335194D7F7C847409FEA9D6940985EC0	1b7bab0a-f720-428e-b818-42d072d0df38	2013-08-05 00:00:00
12305	Charlottenstr 123	\N	Kiel	70	24044	E6100000010C00000000000000000000000000000000	c62306c2-c3a9-478b-8d08-f5fc5a3b9998	2011-11-27 00:00:00
12306	1158 Roundtree Place	\N	Spokane	79	99202	E6100000010CFD19CEC426D94740CDFB19B6BE4D5DC0	db579d4a-fc33-43cb-a40e-ed91da289fe9	2014-02-01 00:00:00
12307	7959 Driving Drive	\N	Malabar	50	2036	E6100000010C4EEF6752AEFF40C001BC54BD8EE86240	d6f49587-7e43-48c3-bfbf-72fa627cf35a	2012-06-06 00:00:00
12308	8727 Logan Court	\N	Bellflower	9	90706	E6100000010CFC2AE4877EF54040E6AC91681C915DC0	ab455726-0820-4a9c-bf8e-73c079d7f698	2013-10-29 00:00:00
12309	4392 Ahneita Dr.	\N	Brisbane	64	4000	E6100000010C7D57138437753BC08632C33012276340	373f3f07-0439-4cb5-8bcc-6b2bb3731f11	2014-05-22 00:00:00
12310	5603 S. Rising Ave	\N	Gold Coast	64	4217	E6100000010C2FF446EBD4F53BC03B364EB8F4316340	77300af9-25b7-49df-9408-7c9c39f04e0d	2013-12-18 00:00:00
12311	2496 Greendell Pl.	\N	Warrington	14	WA1	E6100000010CD7B57C80C7AC4A40DD0432F52E8A04C0	d41e81db-a619-40a6-a3af-d0330297417b	2014-03-28 00:00:00
12312	7950 H Pine Creek Way	#3	High Wycombe	14	HP10 9QY	E6100000010CCE271BF574D44940FA7B53E74738E6BF	00cb32c0-05f9-4a15-bc5f-7b7d4da2c0f2	2012-06-10 00:00:00
12313	Kapellstr 4561	\N	Bottrop	53	46236	E6100000010C83757EC22EBF49407175158DB5BA1B40	ac4cc075-37f8-43a1-b16a-3a57d39e3674	2014-01-23 00:00:00
12314	161, rue de Cambrai	\N	Dunkerque	145	59140	E6100000010C7100442842834940FBAF65A9C2440340	b628b9f2-f7ec-48f8-8c2f-f5cc2fc75864	2013-12-21 10:09:29.423
12315	4210 Band Court	\N	Springwood	50	2777	E6100000010CA4F85815B6D640C0A4EB81A6E6D96240	bc3a000f-e3df-49d1-a758-20b4c6c20696	2012-05-13 00:00:00
12316	1331 H St.	\N	Grossmont	9	91941	E6100000010C60E4F619CB6540408853D41985485DC0	0fac78b0-7182-4621-8239-ee0fe2209b7f	2013-07-19 00:00:00
12317	9662 Red Leaf	\N	Westminster	7	V3L 1E7	E6100000010CB6C76ABF0D914840B56E7351B9BE5EC0	b615a29f-eb7b-4642-889f-3487680b91de	2013-09-06 00:00:00
12318	2613 West I St.	\N	Lebanon	58	97355	E6100000010C4D83461D2F404640ACCAE3812BB65EC0	8b6c5ec8-5564-4c42-903e-5c4e7c1fd20f	2013-03-25 00:00:00
12319	3854 Galindo St.	\N	Caloundra	64	4551	E6100000010C666E23D84CC73AC0EBB40CE362266340	13321610-2552-4a21-a3cb-f02b64408e5a	2014-06-16 00:00:00
12320	7239 Green Leaf Drive	\N	Burnaby	7	V3J 6Z3	E6100000010CB22E5C4DE5A1484070B2BEB8E0B95EC0	b24a3c7b-806c-4622-b595-3f9ed9127606	2012-10-02 00:00:00
12321	Welt Platz 2	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	f470c373-774b-4d9c-8bef-db0864355b4d	2013-04-28 00:00:00
12322	8553 R St.	\N	Salem	58	97301	E6100000010C1A1677D204744640BA3FFF3EF0CB5EC0	55d92b10-9fa4-404c-8158-6c75897a66b0	2014-04-25 00:00:00
12323	2752 Northridge Road	\N	Rhodes	50	2138	E6100000010C26B55FD3CBE840C0DFBA9F57C4E36240	12953d43-9ff9-44ee-b570-543273e29af5	2012-08-02 00:00:00
12324	2012 Melody Dr	\N	San Gabriel	9	91776	E6100000010C080E9A362C0D4140E14D976B0C815DC0	9a747048-a10a-435c-bf32-53ed54b49593	2014-06-27 00:00:00
12325	872 Mark Twain Dr	\N	Goulburn	50	2580	E6100000010C3D36E302BA5141C03218EBB081B76240	15a8e556-df65-4110-942c-32e543e96354	2013-08-26 00:00:00
12326	6417 Del Rey St	\N	Spring Valley	9	91977	E6100000010CF86D7390BD5D4040A4DEA33286425DC0	1627963d-8e94-431a-9410-ab6387a06c96	2014-03-09 00:00:00
12327	2786 Class Avenue	\N	Lebanon	58	97355	E6100000010C09FBD0929A434640C9948F3707BE5EC0	9a45cdfb-a30d-4956-b7f8-b2013d384a32	2013-12-04 00:00:00
12328	7445 Meaham Drive	\N	Port Orchard	79	98366	E6100000010CAA6B858046BF47407662678C96A35EC0	c3ff9f70-d7b9-4b86-ae3d-1433b7e2f905	2013-05-15 00:00:00
12329	23, rue de Linois	\N	Sèvres	178	92310	E6100000010CC04B3F56927048401479BB73C0A60140	c1cb06b3-9eb3-4811-a912-f351b4bedd7a	2013-12-21 10:09:29.423
12330	4068 Camelback Road	\N	Port Hammond	7	V6B 3P7	E6100000010CC731891272AA48409BC0C75AC0C45EC0	5fb4e41a-b224-438a-ad85-9fb857e414a7	2011-11-20 00:00:00
12331	8981 Carmel Drive	\N	W. Linn	58	97068	E6100000010CECA4048219A9464082CED79351A25EC0	139d12ac-48ac-4d92-b754-e91ed4d3658d	2014-02-22 00:00:00
12332	3681 South St.	\N	Lincoln Acres	9	91950	E6100000010CECD3D6AC1C5940403003ADC2D94E5DC0	47d320ab-6ecf-4a91-b9dc-6d47a441f493	2014-01-20 00:00:00
12333	3467 Monetary Way	\N	Berkeley	9	94704	E6100000010C0579B01C23EC42407A3EBB6AE0945EC0	67a5a653-abd7-4840-b240-d30f382edeb1	2012-10-22 00:00:00
12334	16, rue de Linois	\N	Suresnes	178	92150	E6100000010C5E3A6B1F9C6B484058F5174172C40140	1c2aad3a-fb36-44d7-afb8-1d96ba1e2911	2013-12-21 10:09:29.423
12335	1585 Pacific Avenue	\N	Torrance	9	90505	E6100000010C868A337C74E9404021438666F6945DC0	a54eb21a-d9a8-4407-92cd-5b625e73297e	2014-02-25 00:00:00
12336	2572 H Street	\N	Portland	58	97205	E6100000010C27AE452C5EBB464055CEA6508AB15EC0	81e59331-4979-47fe-b865-c515e63a4a53	2011-12-19 00:00:00
12337	4682 Sunset Meadows Ln	\N	Newcastle	50	2300	E6100000010C4FE3497C6A7440C08D3718EC7AF76240	1e2e6d6c-a5e7-4c3a-a824-283e30d2259e	2011-11-24 00:00:00
12338	5522 Grading Way	\N	Los Angeles	9	90012	E6100000010C51CBC092050741403679ACB874945DC0	ee3bdce5-ab82-4002-bb36-db011da5b289	2012-11-01 00:00:00
12339	9265 Village Road	\N	Matraville	50	2036	E6100000010C84F2A20D3FF540C0927879FEF1EB6240	ba3ff3c5-9bea-4d6d-b4f2-8fd54bfcc822	2013-07-25 00:00:00
12340	3337 Northpoint Ct	\N	Burbank	9	91502	E6100000010CBAEFFDB5451441409EA2E0C9C38D5DC0	75fedaba-0569-445d-90f2-29aace97deb9	2013-11-06 00:00:00
12341	4480 Las Trampas Road	\N	Bremerton	79	98312	E6100000010C28B67701A7C4474068C4A3DC5AA85EC0	55cdf117-ecd7-4008-b1a1-5e7ebe2bd0cc	2012-07-18 00:00:00
12342	4108 Yukon Street	\N	Burbank	9	91502	E6100000010CA6CD9AB0C5174140DD6459FB8C915DC0	b7c50065-89c2-43b6-8486-884d4b35c2f7	2014-03-23 00:00:00
12343	1955 Glaze Dr.	\N	Shawnee	7	V9B 2C3	E6100000010CA446F90F4C33484094D59485E5D75EC0	c656a12d-6b85-4759-8694-0a04b16786e8	2012-04-03 00:00:00
12344	3450 Breck Court	\N	Bremerton	79	98312	E6100000010CC255B0E69DCF4740CAA77F47B6AA5EC0	bf5fe5c7-4355-4837-8d45-f82f0131604d	2013-10-11 00:00:00
12345	9564 Pennsylvania Blvd.	\N	Westminster	7	V3L 1E7	E6100000010CEB26C1076EA148406B1879085AB15EC0	38028627-842a-426f-9fab-9f7fa23be8a2	2014-01-09 00:00:00
12346	6488 Dublin Blvd.	\N	North Sydney	50	2055	E6100000010CB7B62915BAEB40C06EDC324530E46240	3fd73a3b-7051-4ea3-bfb1-2f9bbd4a2bd2	2012-02-12 00:00:00
12347	Nonnendamm 6500	\N	Neunkirchen	70	66578	E6100000010C347D425C33AB48404D808EEFCF721C40	00dbd2d9-eb69-4927-ad63-e03e2b578570	2014-01-18 00:00:00
12348	7720 Breaker Dr.	\N	Lane Cove	50	1597	E6100000010C6353BD554DEB40C012F85F1B03E26240	410ec272-feb3-4913-9f5b-4c36a0956c3e	2014-02-17 00:00:00
12349	7682 Fern Leaf Lane	\N	Edmonds	79	98020	E6100000010C46665AD0EDEB4740B10A392FCA9F5EC0	db4ab754-604b-49cc-8c04-c2c254c64e27	2014-05-31 00:00:00
12350	2342 Peachwillow	\N	National City	9	91950	E6100000010C599674E0D65240402D716C9A994F5DC0	9a92dbe1-a77c-4523-81f6-22af7241b20b	2013-11-25 00:00:00
12351	477, rue des Ecoles	\N	Tremblay-en-France	179	93290	E6100000010C111446BABA754840B1A16CB2B1690440	37032deb-8c79-4744-92fa-1e40340019b3	2013-12-21 10:09:29.423
12352	7367 Wests Way	\N	Darlinghurst	50	2010	E6100000010C61D7A55C3BEB40C0498EA88764E56240	f15a2ce6-2b3b-493c-94f7-d2497dbe832f	2012-09-05 00:00:00
12353	54, rue de Courtaboeuf	\N	Metz	143	57000	E6100000010C01BADE15C38348400CABCBED00B41840	795907e2-99f3-4032-b350-b8fca9c95318	2013-12-21 10:09:29.423
12354	5275 Whitehall Drive	\N	Concord	9	94519	E6100000010CCC8C006381024340AD60CCC785795EC0	20e63cf2-99ef-4b1c-bfb0-267dd991f4c4	2013-11-01 00:00:00
12355	543 Northwood Drive	\N	Bendigo	77	3550	E6100000010CD6FB77C0056042C067F9CB1FC10A6240	233a13ee-72e0-4d80-bfb8-52348dfb4040	2014-01-31 00:00:00
12356	3410 Meadowbrook Dr.	\N	Yakima	79	98901	E6100000010C062DD3D5304C47404896756C10215EC0	4e76bcdc-80b1-47db-88a4-29c3c1dc5652	2013-11-30 00:00:00
12357	Am Gallberg 6726	\N	München	19	80074	E6100000010C00000000000000000000000000000000	77c8def2-6d40-4365-bf9a-5bdefb338d00	2013-05-10 00:00:00
12358	1233 Vista Bonita	\N	Issaquah	79	98027	E6100000010C92EBF49C23BA474085129553E2765EC0	5c326404-5bab-4120-a229-7f74a33fb7b1	2014-03-23 00:00:00
12359	1020 Book Road	\N	Bremerton	79	98312	E6100000010CB44E87252ECD47403E826695C8A65EC0	f8f82c84-b2a0-4696-9b2e-415e7633a246	2014-02-26 00:00:00
12360	4284 Boynton Avenue	\N	Lavender Bay	50	2060	E6100000010C3BB60C6184E940C0967F95D133E06240	755c4f46-469e-4150-a8b7-08bb51b9a14a	2013-09-04 00:00:00
12361	6441 Co Road	\N	Lemon Grove	9	91945	E6100000010C4302FAD142594040305B4E86FE4B5DC0	f8a2db68-a3fb-462e-aae1-1cbd91e66a42	2012-04-01 00:00:00
12362	9137 San Remo Ct.	\N	Warrington	14	WA1	E6100000010C0F1D823E9DB34A401D2FEC6E7E9004C0	e198f7de-4e14-4409-9127-7aa18f4e3088	2012-07-14 00:00:00
12363	7468 Lindley Ct.	#8a	Metchosin	7	V9	E6100000010C8F6E6BE2EC2948406262C03EF1D75EC0	cddb8563-0860-4497-97d5-e2ad22b0880a	2013-09-04 00:00:00
12364	419 River Ash Court	#9	Lakewood	9	90712	E6100000010C720FFD0C9DEF404047B7D6E36F925DC0	cecd0e2c-413b-4492-bf58-d584f11ae9ba	2011-08-14 00:00:00
12365	1661 Beauty St.	\N	Haney	7	V2W 1W2	E6100000010CBB8BE8557C9C4840E13B247F7CAD5EC0	d8a756c6-edf3-437b-8bae-b13278fef851	2011-06-18 00:00:00
12366	482 ViewPoint Court	\N	Bellingham	79	98225	E6100000010C71598489025B484022C16BA97CA95EC0	36c76843-d4c8-4ebf-b62a-93032c1699b5	2013-09-21 00:00:00
12367	4865 A St.	# 260	Coronado	9	92118	E6100000010CDF7DB1FEAA5C4040AF3C0A4CEC465DC0	2c132a4b-8dc1-4cc9-b38a-7f282d4c0ae4	2014-05-06 00:00:00
12368	36 Sand Pointe Lane	\N	Coronado	9	92118	E6100000010CBF3AC7DF7B584040E028810FEC525DC0	a4373247-3136-493c-8124-ad54fbf859fa	2013-10-23 00:00:00
12369	9076 Inverness Drive	\N	Perth	66	6006	E6100000010C7E30DF30C5E93FC054C58C9401F05C40	542f9df5-7e9d-443f-bf22-8b5d9e25f5b0	2011-09-09 00:00:00
12370	Viktoria-Luise-Platz 576	\N	Poing	70	66041	E6100000010C00000000000000000000000000000000	a1eb66f1-ff59-4a66-b406-a92cb10919a3	2013-10-18 00:00:00
12371	9818 Frisbie Court	\N	Langford	7	V9	E6100000010CF7B433B81D42484084C39A1D31E75EC0	6737eddf-0b59-4521-8f21-584f40dee262	2011-07-22 00:00:00
12372	4224 Almond Avve	\N	Milwaukie	58	97222	E6100000010CB3BA456320BB464078E594BD94A95EC0	02fc3df8-8b9c-43e7-95a7-62962a60370d	2014-05-17 00:00:00
12373	3768 Door Way	\N	Gateshead	14	GA10	E6100000010C65BB05E8027B4B40C706293396A6F9BF	c2810b2d-3e9f-4f2d-acb4-7ea2ec861244	2011-09-19 00:00:00
12374	593 Willow Pass Road	\N	Spring Valley	9	91977	E6100000010CBF183658F85940401E33ED63093B5DC0	9481f17c-a871-4bef-97f8-6766b6fb1a5f	2014-04-19 00:00:00
12375	7957 Hermosa	\N	Port Macquarie	50	2444	E6100000010C0E9D112D9A6A3FC0F9E1F73CB21B6340	ad92a5bc-a856-41f3-a430-11ec9f12357e	2013-08-11 00:00:00
12376	501, rue Henri Gagnon	\N	Saint Ouen	127	41100	E6100000010C0B5F7D4089DE47405997B0BDA664F13F	f0fee76d-3ba3-40bd-91a0-d5710e99672f	2013-12-21 10:09:29.423
12377	74 Valley Blvd.	\N	Palo Alto	9	94303	E6100000010C1CA3CA0282B54240D0E34667D8895EC0	92f926e8-dcdf-4d78-b7b5-60dfd96b903c	2012-08-11 00:00:00
12378	9595 Burning Barn Dr.	\N	Matraville	50	2036	E6100000010C1A923BF68CF640C0927879FEF1EB6240	1ec74225-654f-43be-89e7-8cce3951cead	2014-02-26 00:00:00
12379	6787 Pheasant Circle	\N	Oakland	9	94611	E6100000010C59711DFE54ED42407B33625DC5855EC0	3a1b5a61-855f-4148-a2e5-a4a90e303c0a	2012-06-15 00:00:00
12380	3664 Colt Ct.	\N	Hervey Bay	64	4655	E6100000010C003E92C95F5039C0651D67AF741B6340	5fa4c964-3478-45c4-af3e-a7ed5d750a98	2013-09-13 00:00:00
12381	4173 Rockledge Lane	\N	Colma	9	94014	E6100000010CF9A22914DAD64240E94346BF339F5EC0	69ac40db-92b9-4068-9ecf-77020a04f12c	2014-01-05 00:00:00
12382	1488 Guadalupe Dr.	\N	Burien	79	98168	E6100000010C938C522E9EC347400E1B622FE38B5EC0	74f726ed-812b-4ebf-aa87-d5019f7fd592	2014-06-23 00:00:00
12383	9618 San Rafael	\N	Seaford	77	3198	E6100000010CFF17C89C991143C0CCEB0012C7276240	16c994be-cad5-4cbc-a45c-b973c1479427	2012-09-28 00:00:00
12384	1274 Marlboro Court	\N	Issaquah	79	98027	E6100000010CD23C5CFBA6C2474055CCC8CF017A5EC0	f6edd2f0-dd19-4e56-a8ce-940b472bec8a	2013-04-09 00:00:00
12385	25 La Jolla	\N	Salem	58	97301	E6100000010C73ED9C054B8246409FB7FFDD27CF5EC0	391a7997-1a62-4f3a-921f-78a856a3e3b0	2013-12-25 00:00:00
12386	8, rue des Ecoles	\N	Suresnes	178	92150	E6100000010C60BE1FD95B6A4840CBE94AC6CEBB0140	e876f59d-520b-463e-9e19-a8ac89397362	2013-12-21 10:09:29.423
12387	3294 Buena Vista	\N	Lemon Grove	9	91945	E6100000010CB3670A369960404094895B0531425DC0	f38c5dfa-80f0-4c21-9917-c33bf925eff2	2013-11-05 00:00:00
12388	6445 Cashew Street	\N	Rockhampton	64	4700	E6100000010CADCFED524B6337C0CFFAFA12AACD6240	b4d1e60c-3b71-4f1c-9453-feba29b329fd	2014-04-22 00:00:00
12389	4281 Meaham Drive	\N	Puyallup	79	98371	E6100000010C310431E14596474023FC905CA89C5EC0	30543fce-77a4-40bf-b858-d441ca78a29a	2011-10-04 00:00:00
12390	Celler Weg 304	\N	Bonn	53	53131	E6100000010C6D57D610A5544940E413481FDE701C40	226c74f1-faa0-4d20-a458-a2b8a0cd06ef	2013-07-17 00:00:00
12391	4575 Sandiago Drive	\N	Beaverton	58	97005	E6100000010CA45C93BA05C346407BE6E1C033B05EC0	2e994239-6676-4724-b84b-4d17929ff16c	2014-03-09 00:00:00
12392	48, boulevard Tremblay	\N	Lieusaint	163	77127	E6100000010CE84E164F165048400B10B7E5C3650440	6c2d2a0d-6131-4598-a9cd-8a591fbbcf86	2013-12-21 10:09:29.423
12393	2657 Honey Trail Lane	\N	Burlingame	9	94010	E6100000010C68D4CD0A4FC8424085F8A6AF8C9D5EC0	d2581070-4f9c-473e-bdbd-28a93fe115cd	2012-10-10 00:00:00
12394	5007 Castle Rock Rd.	\N	Hawthorne	64	4171	E6100000010C6C840DA0E8723BC073B1A25E211F6340	611d487c-5eb5-427e-9908-653e17ce05ab	2014-05-05 00:00:00
12395	5816 Camacho	\N	Cliffside	7	V8Y 1L1	E6100000010CBE5362841E3B4840D4CA46A8A5D75EC0	5fe5b322-7d2e-4a89-8237-7db5e84a8a51	2014-03-06 00:00:00
12396	75, rue du Départ	\N	Orleans	131	45000	E6100000010C1C41C84782F9474023154E581B8DFE3F	c36b87e3-3bc4-4be8-930e-bc0ee8c224f3	2013-12-21 10:09:29.423
12397	9021 Santa Monica Drive	\N	Redmond	79	98052	E6100000010CF028DC24B9D6474018731BD86A7D5EC0	0ca5889a-2a65-41e9-a13d-7d92c5e5817b	2014-05-10 00:00:00
12398	2444 North Ranchford	\N	Melton	77	3337	E6100000010C781B0DFA2ACB42C038AA5F3773186240	3ecf9dd6-4875-43db-a768-a051af7b4cb0	2014-01-09 00:00:00
12399	517 South St.	\N	Seattle	79	98104	E6100000010C7867283F40DB474081F90730559E5EC0	5140de54-f08f-4c32-a147-31b8ad03eb52	2014-06-07 00:00:00
12400	7015 F Mt Hood Circle	\N	Bendigo	77	3550	E6100000010CD6FB77C0056042C0C6FB2F54370B6240	db13a3c9-2a14-424a-a0c7-582fe980bc3a	2013-05-29 00:00:00
12401	6630 Ham Court	\N	Vancouver	7	V7L 4J4	E6100000010C5283449F05A14840906FF6BE17B95EC0	08006447-10fe-40db-b336-8be3ba8affb3	2014-05-23 00:00:00
12402	8380 Sheppard Way	\N	Beverly Hills	9	90210	E6100000010CA7CA5DA5380741408A46E671739E5DC0	a71def3f-8e94-4d0f-9be5-1d2cbf3d2de7	2013-08-12 00:00:00
12403	8614 Lagoon Court	\N	Warrington	14	WA1	E6100000010CAEE34794BAAA4A40ED0072CFF78F04C0	c0d2e271-c4bd-420c-8282-beea1f472507	2013-09-10 00:00:00
12404	9407 H Street	\N	Sooke	7	V0	E6100000010CE8373D89082F4840FBDFF0DA22F55EC0	01b995ae-2a0b-4430-942f-a39dd2ea7dfb	2013-12-04 00:00:00
12405	Altendorfer Straße 57	\N	Paderborn	53	33098	E6100000010CB8A11B702EE449401E6BD9FB537F2140	0e452331-bd82-4d3d-b55e-7d25a085ddef	2013-03-14 00:00:00
12406	306 Winter Drive	# 4d	Imperial Beach	9	91932	E6100000010C96A7B303C14C404061AC261B14495DC0	adf0f62d-68fd-4e10-876f-8e9887d1ead9	2012-11-15 00:00:00
12407	37, avenue de Norvege	\N	Saint-Denis	179	93400	E6100000010C0AA2BE2A6E794840BECB55D57EAC0240	c1c3f76d-1cd4-45be-96c9-3fd8173fd725	2013-12-21 10:09:29.423
12408	206 Stonewood Ct.	\N	Rockhampton	64	4700	E6100000010C492F7861166837C0689815BECFC96240	379f5e3a-51b8-489b-badb-97bfafbb89a5	2011-08-15 00:00:00
12409	5623 Detroit Ave.	\N	Newcastle	50	2300	E6100000010C1ECA8C89D87C40C03562A3F264FA6240	4439274a-001a-46f8-8e1c-55c94784e4aa	2013-09-04 00:00:00
12410	476 Dancing Road	\N	Burien	79	98168	E6100000010C2B0268EA25BE47400ECA8AEC738D5EC0	bbcd89ec-3396-4ecd-bf89-55ca3189348b	2014-01-23 00:00:00
12411	31, place de Fontenoy	\N	Les Ulis	177	91940	E6100000010CD68EB8BA1E55484033B421991B550140	07b1ff05-4619-4ded-b82c-714b4d58d62e	2013-12-21 10:09:29.423
12412	Berliner Platz 774	\N	München	20	80074	E6100000010C00000000000000000000000000000000	300d2da7-bdb4-4863-837f-11a31261fd5f	2012-12-08 00:00:00
12413	5643 Palms Dr.	\N	Vancouver	7	V7L 4J4	E6100000010CE1052959A5AD4840FFC796F7C8CC5EC0	e5b3b9c2-78b3-44ab-9ced-f70ffc7fda31	2014-06-26 00:00:00
12414	Kampstr 590	\N	Hamburg	19	22001	E6100000010C437A7F35DFC94A40C829A92AE0F42340	797173ba-93b3-445e-ad54-aad192b084ee	2013-12-28 00:00:00
12415	5430 Ranch Dr.	\N	West Covina	9	91791	E6100000010CBF75DB078F0D41401A6A013835825DC0	1aee246e-5526-4b0c-bac9-c9e74047aa1f	2014-01-11 00:00:00
12416	3507 Olive Dr.	\N	Woodland Hills	9	91364	E6100000010C218A25023C154140BD30B44439AC5DC0	e8850253-e7c5-4a48-be77-acce7aa09551	2013-04-06 00:00:00
12417	9bis, rue des Peupliers	\N	Chatou	164	78400	E6100000010C5C417F37607348406B42348B7F3E0140	ce00ad04-007d-42b5-bf9b-1887a049ade6	2013-12-21 10:09:29.423
12418	6203 Laurel Drive	\N	Everett	79	98201	E6100000010C1BA967C34D004840E1E52DAD18925EC0	19b12ebf-f56a-4730-b031-2df992e17b56	2012-02-01 00:00:00
12419	Herzogstr 5772	\N	München	53	80074	E6100000010C405F7EDD791D4840E6FE8D86041F2740	1d3d1d0b-753e-4857-bc8f-ae35bdcec925	2013-11-16 00:00:00
12420	1119 Elderwood Dr.	#3	Birmingham	14	B29 6SL	E6100000010C6FBF1DEA92354A40844A98BDF310FFBF	eb34025c-f368-4b80-bd91-0666d66a88fc	2011-06-08 00:00:00
12421	4535 Walnut Blvd.	\N	Concord	9	94519	E6100000010CB985706C9DFE424010EA2D91E4825EC0	fc411013-b7ce-437a-b643-22e25677b587	2014-01-25 00:00:00
12422	75, quai de Grenelle	\N	Versailles	164	78000	E6100000010C198D36A9D05F4840DD7F8804D9EF0040	03cf4fc9-11bc-4883-a805-c1d94cf91bb0	2013-12-21 10:09:29.423
12423	6071 Mi Casa Court	\N	Rockhampton	64	4700	E6100000010CA41BBFB4E46337C001F14E53C6CA6240	c8b04858-d369-4ed1-996f-bbdab450b5df	2011-06-11 00:00:00
12424	6588 St George Dr	\N	Newcastle upon Tyne	14	NT20	E6100000010CB6C0C278797C4B400E0D22E3F9C2F9BF	65f2e5b1-26d3-4704-9916-9fa5d6a1d5c3	2014-01-03 00:00:00
12425	9275 Keller Ridge Dr.	\N	Royal Oak	7	V8X	E6100000010C264F6D4FBB394840CEFDC596DDD35EC0	2131023f-c4e7-4f8c-8568-56269f435c5e	2012-02-13 00:00:00
12426	8079 Precipice Drive	\N	London	14	E17 6JF	E6100000010C967C4FE97FD44940D8319A2503D2A5BF	c172c319-d59f-4f24-a9a9-0a67b163cfae	2014-03-12 00:00:00
12427	6885 Amending Drive	\N	Spokane	79	99202	E6100000010C4AE9DA19B6D647403DA8449840525DC0	f770aea8-2587-42c1-b123-5ddcdb6594d0	2013-03-16 00:00:00
12428	8634 Lake Meadow Circle	\N	Issaquah	79	98027	E6100000010C047DE69EF6BB4740E700A232AA775EC0	00eb799d-6031-4291-9974-c4df5440dfab	2013-11-16 00:00:00
12429	4423 Bayview Circle	\N	Port Macquarie	50	2444	E6100000010C959A70EAD06D3FC0F2FC86C8B71A6340	f258434e-707c-4325-8d79-92ab311f314f	2012-05-22 00:00:00
12430	5003 Pheasant Drive	\N	Bellingham	79	98225	E6100000010CF22E164CA25B4840C73E583F979A5EC0	49da02a7-1997-4ee0-9ee1-a94fdb2bd02d	2013-07-10 00:00:00
12431	7986 Southdale	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	6039da43-c68f-45fa-a8bc-3c642d3349c5	2013-11-29 00:00:00
12432	9563 Wicker Ave.	\N	Peterborough	14	PB12	E6100000010CE23699D3AC484A402FE7A439D301D0BF	5a45a0ef-89d2-4e2c-bbbc-123b951db10d	2013-08-13 00:00:00
12433	7132 Rainier Dr.	\N	Sooke	7	V0	E6100000010C25CBC08715374840E333492258F45EC0	1e74dec1-3345-4268-971d-918e41fc7717	2013-09-15 00:00:00
12434	4009 San Ysidro Court	\N	Olympia	79	98501	E6100000010C1EF6DC7CB182474060A2BDC89EC05EC0	c785bef6-300f-49ec-9837-8c941be061c4	2013-10-18 00:00:00
12435	1833 Olympic Drive	\N	El Cajon	9	92020	E6100000010C383C9F46BA6040405487718EA0385DC0	ce415710-0d0d-463d-b9e2-3462b07b0392	2014-02-06 00:00:00
12436	2098 Crown Ct	# 235	Matraville	50	2036	E6100000010C87FC4B916BF740C001BC54BD8EE86240	5004d8ca-a223-4284-85a1-88170e76de50	2012-08-31 00:00:00
12437	9695 Notre Dame Avenue	\N	Renton	79	98055	E6100000010C89EBABF87FBB47403DCCAE0E178C5EC0	129f608d-c611-4907-9a3e-61abea5fefcf	2012-04-11 00:00:00
12438	Westheimer Straße 9292	\N	Kassel	19	34117	E6100000010C37A8FE94D0A74940B31EFC71E7F52240	094fa4bd-0db3-435c-ae8f-b3e77d5c26e2	2013-12-26 00:00:00
12439	3697 Lane Way	\N	Silverwater	50	2264	E6100000010C78BA85254A9140C03A769DC427EB6240	79666641-14f1-497a-8295-1d63fc45a025	2013-04-28 00:00:00
12440	Husemann Straße 9574	\N	Berlin	19	14111	E6100000010C07D44BA0CC4E4A4096CC28C3B6D72A40	ce4a4746-6ce6-415b-8766-2a0cbeec8409	2012-11-22 00:00:00
12441	9736 Colorado Dr.	\N	Westminster	7	V3L 1E7	E6100000010CE7067983B0A2484092EB485C6EB85EC0	3121526f-2683-4ae2-b552-e98e4e70a4b4	2013-07-06 00:00:00
12442	8068 Villageoaks Dr.	\N	Port Hammond	7	V6B 3P7	E6100000010C5014C6F7C4A44840AA5B914C63C25EC0	296322d8-9904-45ad-8a17-7a6d277dd052	2012-07-04 00:00:00
12443	Kapellstr 4924	\N	Hannover	53	30601	E6100000010C00000000000000000000000000000000	0e8a29d4-4d57-4b68-adb7-15e90db86450	2014-02-05 00:00:00
12444	1019 Chance Drive	\N	Sedro Woolley	79	98284	E6100000010C182EF92EE342484099EA56A551805EC0	fb49a51d-ca6f-4c8a-b8dc-a1a26d86cff1	2012-03-28 00:00:00
12445	74, rue Jean Mermoz	\N	Les Ulis	177	91940	E6100000010C405FC640834F484076C04A7D36580140	3b2ac862-b0e4-4964-a134-1b11c6a5048f	2013-12-21 10:09:29.423
12446	2260 Clear Court	\N	Coronado	9	92118	E6100000010C7FE3C96A0B5340407021FD29AC4D5DC0	b0fbce4b-a7d7-47f2-b182-b50e046f0430	2013-12-10 00:00:00
12447	21, rue de Bas Marin	\N	Colombes	178	92700	E6100000010C63736FB739744840CE7CE7A56AF90140	362672df-b879-4ff6-b7fb-f23053e58db8	2013-12-21 10:09:29.423
12448	5464 Janin Pl.	\N	Colma	9	94014	E6100000010C5796D35BFED242403146099E8DA15EC0	16711b03-1593-498b-bc18-38d03bc0ccd2	2014-03-16 00:00:00
12449	1874 Valley Blvd.	\N	Melton	77	3337	E6100000010C6BF7BA00F2D042C0EA174773580D6240	9ddeeee6-c365-4b0e-8942-ddba6d798d33	2012-11-07 00:00:00
12450	59 Lakewood Court	\N	Daly City	9	94015	E6100000010CB30DE7D058D84240C24C8DE722995EC0	daf21413-91bf-4279-a707-6b89f420925d	2014-05-21 00:00:00
12451	7539 Santa Fe Court	\N	East Brisbane	64	4169	E6100000010C6322849D14843BC0835D24E62E286340	f63ca52a-2464-4b5c-aea9-c3b92ab776a1	2013-11-01 00:00:00
12452	418 Alfred Avenue	\N	Seattle	79	98104	E6100000010C4122069E53D347409FEA9D6940985EC0	a155d5bd-6c86-454e-b651-f351cf9e9343	2012-02-21 00:00:00
12453	Winterfeldtstr 3539	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	f794fbbd-96c1-41e1-9bba-ba146030df37	2013-07-11 00:00:00
12454	23 Stonewood Ct.	\N	Walla Walla	79	99362	E6100000010C779F49D4B30A47407B858DECE5995DC0	f4b24b76-6f6f-4935-80c2-8278aaf49bc1	2013-10-18 00:00:00
12455	1192 Parkway Drive	\N	Mill Valley	9	94941	E6100000010CA5A7193CE6F04240739EC7CF26A95EC0	234567bd-c92f-4d45-a78a-c1e624088dba	2012-08-01 00:00:00
12456	87, rue de la Comédie	\N	Villeneuve-d'Ascq	145	59491	E6100000010CD544E2E4194B4940B7D2713CE2280940	8f3c392a-a794-4ff4-b023-4bc251a155d3	2013-12-21 10:09:29.423
12457	95 RiverRock Dr.	\N	Burlingame	9	94010	E6100000010C764345918FCE424092EE0FB13FA25EC0	787c0ccd-59b8-424c-bf04-1146fb9a8d3e	2013-10-11 00:00:00
12458	2473 San Rafael	\N	Lake Oswego	58	97034	E6100000010CD1DD9AA27BB74640373EEA5EC3A35EC0	8ca4ee3e-aa00-45e0-8c5b-d1c8fd7b5995	2014-03-01 00:00:00
12459	Zimmerstr 461	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	8253fc75-a214-45b7-9e84-7a138ee5efc0	2013-11-29 00:00:00
12460	7386 Greenview Court	\N	Gateshead	14	GA10	E6100000010C3DB237C091724B40EF167B36EEA5F9BF	5aa4267e-394c-4f1a-a54c-7c7f6452fcf6	2013-09-19 00:00:00
12461	1805 Gallagher Circle	\N	Burlingame	9	94010	E6100000010C10C4FBA0B6CA42405821E32F559E5EC0	e1514327-a1dd-4148-bb47-38bada4e8a67	2014-04-03 00:00:00
12462	6919 Tosca Way	\N	Redwood City	9	94063	E6100000010C4E678D131AC4424060B9C1C274945EC0	6add86e7-fee3-4f12-be91-76768ee622e6	2014-05-16 00:00:00
12463	5033 Kentucky Dr.	\N	St. Leonards	50	2065	E6100000010C87F0082079EE40C057D88A4801ED6240	c7452c25-c7c2-4780-80e1-18fc2ebb43da	2012-12-19 00:00:00
12464	2087 Plaza Del Rio	\N	N. Vancouver	7	V7L 4J4	E6100000010C963F41EF46AE4840FFC796F7C8CC5EC0	6f5d754e-33c4-484c-aa9d-55fdfd468bf3	2013-02-06 00:00:00
12465	5486 Olivera Road	\N	Brisbane	64	4000	E6100000010C1BD962B5C76C3BC07ACEF124BF1E6340	2e9aece6-8b63-4508-ba6c-5b09b214849b	2013-09-21 00:00:00
12466	4617 Sheppard Way	\N	Saint Germain en Laye	164	78100	E6100000010C202A33C29371484083959BDA23C50040	9c80226e-4d99-440d-a1ff-de5dbe980066	2013-12-21 10:09:29.423
12467	128, avenue des Champs-Elysées	\N	San Carlos	9	94070	E6100000010CA1B48271E6BC4240CE9EBB978E8B5EC0	2f3b6715-2537-4891-a101-c3a279f3fc21	2014-06-26 00:00:00
12468	Pappelallee 619	\N	Berlin	19	14111	E6100000010CE0A386182E3D4A40A81983A7B6DA2A40	76d5a760-d645-4b14-bb9b-49f2c864c2a2	2013-12-09 00:00:00
12469	9950 Edward Ave	\N	Concord	9	94519	E6100000010C90E78D5439024340D9B1DA8AFF775EC0	8ef10679-1e28-40de-add0-e91150d2c88a	2013-11-08 00:00:00
12470	Celler Weg 123	\N	Kiel	70	24044	E6100000010C00000000000000000000000000000000	dde4e283-f28c-4740-8679-8986fe801896	2013-05-26 00:00:00
12471	6812 Sands Circle	# 163	Colma	9	94014	E6100000010CE90C939119D042406E8E0D053B945EC0	0cd13747-fd50-43f4-af01-3691686acd0a	2014-04-11 00:00:00
12472	9990 Sunny Ave	\N	Berkeley	9	94704	E6100000010C9DAE7A5D97ED424067964AB7A8955EC0	4d0b05ec-4e40-440f-afdd-50542ffeb712	2012-09-02 00:00:00
12473	5613 East Narrows Drive	\N	Berkeley	9	94704	E6100000010C824FD91FF4F142405B05F92272845EC0	e1b1ff33-a4ce-4d58-94c9-05262fb83090	2012-08-23 00:00:00
12474	80 Mozden Lane	\N	San Francisco	9	94109	E6100000010C17C42FD2BDE4424036E3CECDBD905EC0	01386b1e-1a15-4dfb-bea3-760b2e5bfebe	2012-03-14 00:00:00
12475	Pascalstr 7	\N	Neunkirchen	70	66578	E6100000010C58B4B2A818AD4840BD70D97C8A731C40	f4a806e4-a9dd-41e5-9ad8-f840f92cae6a	2014-01-11 00:00:00
12476	6416 Co Road	\N	Port Hammond	7	V6B 3P7	E6100000010C25D9C89DD0A948400AB6867282BA5EC0	5f6e704d-4a7e-411a-8336-3a59109ad5f0	2013-10-17 00:00:00
12477	182, avenue des Laurentides	\N	Paris	161	75017	E6100000010C10AF8F8413744840E9EEA59962700240	0eaeb3a4-bba6-4918-a8e3-3f3b06c8e64b	2013-12-21 10:09:29.423
12478	9620 Laurel Drive	\N	Novato	9	94947	E6100000010CFC57D8A34510434012CD3C4A779C5EC0	d308cac1-f746-4fbb-89b4-4baf3123e816	2014-03-18 00:00:00
12479	2118 Court Lane	\N	London	14	W10 6BL	E6100000010CD03C136C32CC4940233ED6BEDC0DCCBF	57f4648a-d71b-434c-879f-cd6f3d6681f1	2013-11-11 00:00:00
12480	2575 Garcia	\N	Warrington	14	WA3 7BH	E6100000010C5FE889B6E9B04A40CD2D347C804004C0	52229f2a-9554-4b77-a6b5-d155f75694b4	2013-12-09 00:00:00
12481	8398 Kathryn Drive	\N	Beaverton	58	97005	E6100000010C546A331909BC4640B9A0D38E7CAB5EC0	18437e4e-f458-4c24-892f-04e551a961a3	2011-08-27 00:00:00
12482	4188 Lodge Dr.	\N	Springwood	50	2777	E6100000010CAA791F05DED840C0B7E03FFF42D06240	550718e3-9cbc-4c5f-883b-e20f530a7d9d	2013-02-16 00:00:00
12483	52, route de Marseille	\N	Colombes	178	92700	E6100000010C4C4ADB4E566D48404FB74E91D0F40140	6cd80746-ba05-4153-b6ee-7bc19044c7b0	2013-12-21 10:09:29.423
12484	9585 Carob Way	\N	Findon	66	5023	E6100000010C1603668C0C7241C0DBB6B333804E6140	58342c18-84de-4454-8cb8-632afaab9639	2013-03-17 00:00:00
12485	Bundesallee 7567	\N	Neunkirchen	70	66578	E6100000010CE2D7F17683A5484063139BCCE9771C40	4e5d8f69-220d-4760-8440-7be7ce74374f	2013-12-20 00:00:00
12486	6984 Wardlow Lane	# 116	Beverly Hills	9	90210	E6100000010CE110A98E511441405B061D3691915DC0	adc30c94-c7bd-4176-afe4-c2a968a32884	2012-01-08 00:00:00
12487	480 W. Holly Drive	\N	Springwood	50	2777	E6100000010CA4F85815B6D640C03EE7CD960BD66240	afca1c4a-585f-4c5e-9ddc-bb9e35b9db0b	2012-07-17 00:00:00
12488	5134 Oak Park Blvd	\N	Novato	9	94947	E6100000010CB929E918CF0E4340FD2B12ECAAA65EC0	a39526df-0d32-4572-935c-bd1adfdea7e3	2014-05-18 00:00:00
12489	8084 Sunnyvale Avenue	\N	Cliffside	7	V8Y 1L1	E6100000010CA6EBB043E34B48409850511255E05EC0	388a94e8-600d-4392-83fa-faccd6cd5f80	2013-07-02 00:00:00
12490	Waldstr 66	\N	Solingen	53	42651	E6100000010CEAE5470D7F8C49403870D396BEA21C40	66e1e63b-fed8-41bc-b7d3-cf657ed2b892	2014-05-21 00:00:00
12491	6670 Del Rey St	\N	Daly City	9	94015	E6100000010C65EC07675EDB42402CA128AEE4A25EC0	7cda778a-c627-4635-9ee9-6fd5bf67a74a	2011-06-21 00:00:00
12492	2530 C Del Rio Circle	\N	Bellflower	9	90706	E6100000010C638ED0E349F04040BDE216BE80835DC0	0e093ee0-5e50-41e6-84bc-366a570bacf8	2013-07-23 00:00:00
12493	3327 Rockridge Dr.	\N	York	14	YO15	E6100000010C6E35E1BB2BFE4A402A0FA48D6C56F1BF	72bb6d01-86e4-4581-92b3-caf8b541a194	2012-05-09 00:00:00
12494	4025 Cherokee Drive	\N	Glendale	9	91203	E6100000010CB4B6CE389D164140FF09FA16C9945DC0	12e6038d-f819-407a-95e8-2e88c5c6dfcb	2014-01-20 00:00:00
12495	2749 Greenbush Drive	\N	North Ryde	50	2113	E6100000010C944140891DE140C01A9B267B47E36240	4bd35644-ac4c-4434-9f73-1b343f96379f	2013-11-16 00:00:00
12496	7484 Lacanda Ct.	\N	Glendale	9	91203	E6100000010CCA1724841C1A4140F9636974159A5DC0	3ad2d248-a1d0-47fa-b593-415af0a2a9b7	2013-11-16 00:00:00
12497	1889 Carmel Dr	\N	Grossmont	9	91941	E6100000010C9E89BC9BDB624040AE2277E6893C5DC0	7857eb21-9e5f-4d30-8173-a45bc6483463	2013-10-19 00:00:00
12498	Lindenalle 42	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	5b1814a4-03d9-483a-92f4-c72705367b45	2014-02-14 00:00:00
12499	5602 Greer Ave	\N	Lynnwood	79	98036	E6100000010C6081C7F78EED474074F6680E9B9A5EC0	ab079372-872d-443c-a1b0-3a825078d2d8	2014-03-12 00:00:00
12500	261 La Orinda Pl	\N	Port Macquarie	50	2444	E6100000010CA5DDB97DCC693FC00E181654BD196340	404d6d74-d8e3-4e53-90fb-a7f9b472dd49	2012-09-10 00:00:00
12501	4696 Silver Oaks Place	\N	Springwood	50	2777	E6100000010CFBA9F398D4D240C0AD66D73490D56240	efab9dda-ade7-44db-ae82-74a4e6b9b8c3	2013-05-22 00:00:00
12502	6883 Freda Drive	\N	Issaquah	79	98027	E6100000010CCD9FC9A29CBF47404C7FBE5DD7885EC0	6c118a5d-37af-4177-9592-c81e3d39d556	2013-11-27 00:00:00
12503	4453 Bannock Ct.	\N	N. Vancouver	7	V7L 4J4	E6100000010C84AB97D4DBA94840FFC796F7C8CC5EC0	0d0364e5-7e23-47fd-b5f2-e3166e697edd	2013-10-17 00:00:00
12504	2846 Veronica Ct.	\N	London	14	W1N 9FA	E6100000010C96B05536DABC494009E2AF35BC40C0BF	3efa452c-8631-4aa6-8f8e-0ae75318f73a	2012-08-10 00:00:00
12505	1329 San Jose	\N	Everett	79	98201	E6100000010C4E65FA648EF84740D558797F29935EC0	007fc636-9063-4649-bc83-f5e4add831d4	2013-05-08 00:00:00
12506	9152 Rogers Ave.	\N	Lemon Grove	9	91945	E6100000010CA3EF6AA2845A4040788F28C63E4B5DC0	29d33a87-5af1-4579-ae1b-0aa62a218d65	2013-06-23 00:00:00
12507	6469 Apple Drive	\N	Wokingham	14	RG41 1QW	E6100000010C40B7ACC4C3B84940FB1D0AB1A737EBBF	e29698bb-8f05-40c5-9f8a-6ee40b6f3d9f	2013-10-30 00:00:00
12508	8938 Violet Ct.	\N	Beaverton	58	97005	E6100000010C2888EB7C11B646402582791356B35EC0	e319fccd-7760-4558-a5db-f6e74f574ecb	2013-09-26 00:00:00
12509	4283 Meaham Drive	\N	Burbank	9	91502	E6100000010C8DADB4BA351141406227D22C56955DC0	0aba98f2-23e2-4c04-991b-e49e2f0f359a	2012-03-30 00:00:00
12510	9088 Almaden Dr	\N	St. Leonards	50	2065	E6100000010C0793B33D71EB40C034F8B1D0E8E06240	b3a4d56b-50ff-402b-bbd0-e1d19b32f1a1	2014-02-03 00:00:00
12511	9048 Youngsdale Drive	# 202	Corvallis	58	97330	E6100000010CB7A9D714D95A46409A78918EE1C85EC0	22e2caa0-9440-42d3-8766-27f8f003b131	2014-01-21 00:00:00
12512	3936 Cedar Point Loop	\N	Port Macquarie	50	2444	E6100000010C0E9D112D9A6A3FC03CB2D5310E226340	d622bc9f-133e-4a73-a64d-8bfeefd424de	2011-10-14 00:00:00
12513	9089 San Jose Ave	\N	Newport Beach	9	92625	E6100000010C57062CE1B1D140402DECB95A7C715DC0	62c2dde3-4268-4e98-b32f-8263ddd77c77	2014-02-15 00:00:00
12514	7420 Lilac Circle	\N	Cranbourne	77	3977	E6100000010CAAA5B33F9E1443C00F061F81472D6240	d1b42fdd-2e74-46d8-88cd-195c873637a1	2013-04-20 00:00:00
12515	611, rue de Longchamp	\N	Roissy en Brie	163	77680	E6100000010C4BB7D6BDD66848400FD85979CC4B0540	3c774715-7fc0-49c8-aff1-f88d914cf0a8	2013-12-21 10:09:29.423
12516	79, rue de la Comédie	\N	Chatou	164	78400	E6100000010C000E5F87DD6B484032390A608F360140	ffea46f1-a2c6-47e7-92e9-5216e3ee2f16	2013-12-21 10:09:29.423
12517	371 Ridge Place	\N	Bremerton	79	98312	E6100000010CE8FEEAB2B2C7474000D68D16EDB45EC0	fd91f595-fee1-49e3-b9cf-ec02742d0d84	2014-04-06 00:00:00
12518	7390 Discovery Bay	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	2b677c94-6d27-4fe0-9e06-d9f63577a310	2013-08-15 00:00:00
12519	1613 Santa Maria	\N	Vancouver	7	V7L 4J4	E6100000010C3AE5AF6A7DAA48403696CDEF64BF5EC0	142ec7f9-95d6-43e6-b7d6-e2abc94e372b	2013-07-05 00:00:00
12520	9595 Zion Avenue	\N	Rockhampton	64	4700	E6100000010CD953D7694C6037C0AD7038E74BD76240	75f590fd-453e-46b0-917e-4d0c8f7b3974	2012-12-21 00:00:00
12521	4817 July Loop	\N	Watford	14	WA3	E6100000010CA160E7A510DC49407B8E85C150FFD8BF	fa7714ce-0a5a-40e9-b760-81dd1d0401da	2013-03-16 00:00:00
12522	6312 San Ramon Road	\N	Warrnambool	77	3280	E6100000010C22553FF3DD0943C0B7E58E1364C96140	4e860e5e-c132-4ce9-add8-aef1902f4e46	2013-09-23 00:00:00
12523	9770 Fraga Court	#91	Imperial Beach	9	91932	E6100000010CBECAFE41014E4040CCAA175594475DC0	b0dd528f-1008-47d8-a6ca-d6470186e088	2014-05-30 00:00:00
12524	Berliner Platz 77	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	88f65096-b4cc-405b-8b10-4369ca4ba821	2014-03-14 00:00:00
12525	4176 Alexander Pl	\N	Olympia	79	98501	E6100000010C1EF6DC7CB1824740F576BBB309B45EC0	bccce33b-2841-486f-b627-ebf6d9fbbd45	2013-12-13 00:00:00
12526	33bis, rue des Peupliers	\N	Drancy	179	93700	E6100000010C13D84F3C967A4840960C6DC80F890340	03d4ed8a-bf57-4f0e-8994-b30a6293a0f1	2013-12-21 10:09:29.423
12527	352 Margo Dr.	\N	Port Macquarie	50	2444	E6100000010C959A70EAD06D3FC0D55A2C8396206340	48e6a5f7-9a04-4752-945e-ff8c4ffa9445	2013-09-06 00:00:00
12528	5203 Foothill Way	\N	Santa Cruz	9	95062	E6100000010C7BCFACEA647842404D08FBAF46795EC0	a938fdf3-e38b-41c6-ab04-5317e76ca5a2	2013-09-19 00:00:00
12529	1826 Village Road	\N	Bury	14	PE17	E6100000010C855EABD8C6D54A40D2A557C4CA6C02C0	47b76c9e-b5d7-4e91-bccf-addc070ee741	2014-04-11 00:00:00
12530	91, rue Pierre-Demoulin	\N	Les Ulis	177	91940	E6100000010C67C2643B7F54484076C04A7D36580140	ddcf8f86-aa9d-4977-ba3b-2b1cdf87d2b7	2013-12-21 10:09:29.423
12531	6271 Crow Street	\N	Chula Vista	9	91910	E6100000010C948526E41F4D40400110C1AB1E415DC0	8346e7b8-9d00-4cfd-8760-2cec8a6e43fa	2014-05-06 00:00:00
12532	4285 South Street	\N	W. York	14	BD1 4SJ	E6100000010CAE12FE0E7CDC4A408D35F09F510BFCBF	96f2fcc7-a16d-4333-90e5-a91f2c733f02	2013-04-10 00:00:00
12533	3407 Oak Brook Place	\N	Cranbourne	77	3977	E6100000010C0E57BC3E1B1543C044B3527DE22B6240	79c7751f-7788-4c73-92fe-a36d6df77972	2013-09-07 00:00:00
12534	8042 StandingView Dr.	\N	Coffs Harbour	50	2450	E6100000010CCA7FA35C312A3EC0F777FDE362226340	78c6cc8e-7c87-494f-8d9a-207dced952c6	2013-07-27 00:00:00
12535	1439 N. Canyon Road	\N	Sedro Woolley	79	98284	E6100000010C5A186C36DA3548400121B592D08C5EC0	34228e6d-11ab-4498-a460-9fce67c2523a	2014-02-03 00:00:00
12536	Am Gallberg 2667	\N	Paderborn	53	33098	E6100000010C41801655A2D3494048B9296E4B7B2140	017bc01d-ccd7-42b6-a97c-dd2f2a900802	2013-10-05 00:00:00
12537	5296 Covington Court	\N	Bellflower	9	90706	E6100000010C4D4124D6DAEF40407E48F9E386865DC0	d79a182d-5fbd-465b-b514-8502f4f241a5	2013-12-14 00:00:00
12538	9302 Veracruz	\N	Spring Valley	9	91977	E6100000010C37E92C12E75C404061008E79873F5DC0	e294b06e-c442-4a3f-b639-36eb952b3489	2012-03-11 00:00:00
12539	9343 Ironwood Way	\N	La Jolla	9	92806	E6100000010CF3B34E7143EC4040AFA8321FC16C5DC0	3f0d7ac8-2d5d-45ae-986e-33116a867ffe	2013-07-13 00:00:00
12540	331 Muy Verde	\N	Oxford	14	OX1	E6100000010C5A438391DBD8494092A198BA2A2EF4BF	6450fec2-a29c-4352-b6d2-f112b654103c	2013-05-02 00:00:00
12541	65, boulevard Tremblay	\N	Pantin	179	93500	E6100000010CBA46A271607248406ED847CE87490340	f33d9528-0504-43ff-8bd6-4953dbbe27dc	2013-12-21 10:09:29.423
12542	3281 Ana Mile	\N	Spokane	79	99202	E6100000010C405A514357CC4740F2DFD2563F4F5DC0	773fa622-fff9-4625-97b2-f4cfb2232b3e	2014-03-06 00:00:00
12543	1867 Sahara Drive	\N	Newton	7	V2M1P1	E6100000010C37F23F924BF94A4030557EAAB0B05EC0	e9c2bd25-4ac9-49f7-ab96-a9cd16b9029d	2012-01-11 00:00:00
12544	6060 Sanford Street	\N	Caloundra	64	4551	E6100000010C1530F62080C23AC0EFC6386872236340	16b0752b-238e-4071-8ea7-e52ac902b651	2013-08-13 00:00:00
12545	699 Hummingbird Ct.	\N	Lane Cove	50	1597	E6100000010CA1408123BCEB40C0E296FAAA44E96240	2309e906-88e3-4495-83bb-f36d1d3287aa	2013-11-25 00:00:00
12546	Herzogstr 5772	\N	Paderborn	53	33098	E6100000010C6D018137DFE04940151967A27F862140	078ca841-bde6-4b76-8fe4-d0c7408a6116	2012-02-04 00:00:00
12547	6566 Jamie Way	\N	Lincoln Acres	9	91950	E6100000010CECD3D6AC1C594040E3DE2B7259505DC0	9b4ddbb7-41c1-465a-b6d6-f9e19796b7d6	2014-02-16 00:00:00
12548	2681 Woodside Way	\N	York	14	YO15	E6100000010C22E42289B70F4B403E49A5E8A193F1BF	4870cdf6-70c7-4508-a849-5cb2879f8449	2012-10-31 00:00:00
12549	8206 H Street	\N	Gold Coast	64	4217	E6100000010C9122EF676AF93BC09525A4F5A0286340	99b8932e-3333-4c41-9e10-aa2037ea503b	2013-01-24 00:00:00
12550	4430 Ana Cortez	\N	Beaverton	58	97005	E6100000010C53FFB51819C74640A724DD5AA1AE5EC0	e9db155f-f064-4c7c-9510-e7d3e038fd44	2014-03-16 00:00:00
12551	799 Northwood Drive	\N	Grossmont	9	91941	E6100000010C60E4F619CB6540406C34C799C6445DC0	56e40f5e-a808-42a4-9ac6-0600067dbdb5	2013-03-04 00:00:00
12552	2080 Mountain View Dr.	\N	Lebanon	58	97355	E6100000010C4309EC061A3E4640978C63247BB95EC0	b6481afb-b2e6-4877-8cc7-914e96d720f7	2014-03-10 00:00:00
12553	9061 Isabel	\N	Port Macquarie	50	2444	E6100000010CC5634CA4C3613FC01C69C3F6CD166340	f7229cff-d26a-4276-9a60-f2bef5888c83	2012-02-10 00:00:00
12554	896 Mt. Washington Way	\N	Los Angeles	9	90012	E6100000010C6AC42441F80F4140BF79EE176C935DC0	519122d0-fa78-4526-bddf-a52d3722c9cd	2014-03-05 00:00:00
12555	428 Delaware Court	\N	Langley	7	V3A 4R2	E6100000010C37BA1CE0DC86484059049EA40DA95EC0	949d21c1-2072-4c34-8646-51b8ac229e30	2013-08-05 00:00:00
12556	Räuscherweg 664	\N	Solingen	53	42651	E6100000010C5911F12BF98F4940ECE8D92293661C40	97a201ae-68b9-49c8-9c1d-c361e1f08f46	2013-08-01 00:00:00
12557	8251 Vista Del Sol	\N	Watford	14	WA3	E6100000010C61A9A34E89CB4940BB5F39304708D9BF	56e418af-96d7-4308-b4f5-ee582ea6cb07	2014-02-18 00:00:00
12558	8037 Fruitwood St.	\N	Everett	79	98201	E6100000010C7B408396B6F647402F67B48F1F8C5EC0	052ac8bf-a6ca-4132-be35-17f6b41abe89	2014-02-24 00:00:00
12559	3459 Tri-state Ave	\N	Edmonds	79	98020	E6100000010C0E926BCEF9E34740D1534ABAC68D5EC0	97a8eca4-477e-4327-86bd-bf55a7cb5310	2012-03-16 00:00:00
12560	6155 Larch Ct.	\N	Sooke	7	V0	E6100000010C0692F812A72F4840FBDFF0DA22F55EC0	a34e7e95-ce92-47f4-9fe7-5a008671749f	2013-04-02 00:00:00
12561	3272 Corrie Lane	\N	Matraville	50	2036	E6100000010C7C06F51498F940C07CAEF1C7E9EC6240	64529b1b-4db0-42b9-a44e-7c8b396dd241	2013-07-08 00:00:00
12562	4487 Coldwater Drive	\N	W. Linn	58	97068	E6100000010C5333C6DE39B14640FC574330F2B55EC0	0d08f918-d538-452d-a7f7-a3bd64739f1f	2013-09-02 00:00:00
12563	7437 Jason Ct	\N	Redmond	79	98052	E6100000010C2A18C9889ED047402252F43C53815EC0	66965a5d-1cb7-4e04-982e-ffc535f23679	2014-02-19 00:00:00
12564	9081 Texas Way	\N	W. York	14	BD1 4SJ	E6100000010CAE12FE0E7CDC4A4067925A5640FCFBBF	5fc811fb-9223-43ec-8bd1-6416d3a039a4	2013-02-20 00:00:00
12565	2023 Flame Drive	\N	London	14	W1X3SE	E6100000010C6B7E8081B2CA49400BAB5778D14CC0BF	d82e7eeb-983d-459e-8345-ee71c70b922c	2011-06-14 00:00:00
12566	4185 River Ash Court	\N	York	14	YO15	E6100000010CC8478F528DFF4A40CF918D5D315CF1BF	ee04b2c6-3794-4214-b05b-b1347f6343ce	2014-01-22 00:00:00
12567	8678 Sierra Drive	\N	Bellflower	9	90706	E6100000010C00731A8440ED4040D24754934E8A5DC0	b7371446-7fb8-4f21-b9e3-4d385d7a908c	2012-11-25 00:00:00
12568	2328 California Street	\N	Maidenhead	14	SL67RJ	E6100000010CDD71D1670AC24940EF75DBD2598EE7BF	b82b2d69-0b99-499d-89be-89c7382bb24e	2012-06-11 00:00:00
12569	3378 Muy Verde	\N	Bellingham	79	98225	E6100000010C60AE6004C35948404432CA7B4B9F5EC0	c4bb9a75-5e7c-4a6f-bf95-c7cdf41ee82b	2013-08-06 00:00:00
12570	9355 Armstrong Road	\N	York	14	YO15	E6100000010C1CC7CC33E2F54A4026C70C8AC44FF1BF	680c4591-b107-474c-97fc-d6020813e5fe	2012-11-20 00:00:00
12571	6836 Alum Rock Drive	\N	Milwaukie	58	97222	E6100000010C0951107DF1C04640CC1BCB67CF9D5EC0	0fe4a0fc-255d-415e-aa39-8476b12ac590	2012-06-28 00:00:00
12572	28, quai de Grenelle	\N	Morangis	177	91420	E6100000010C50540D2736564840A815683E81B90240	b6ca3f92-a176-45fb-ad45-f48dcc8aaa37	2013-12-21 10:09:29.423
12573	1242 Ridgewood Ct.	\N	Cheltenham	14	GL50	E6100000010C5688EFA4A7E94940E76C0BB6C3A500C0	3907d4f0-2df1-43e0-9b53-7d32e242281e	2013-10-19 00:00:00
12574	7610 Pepper Pl.	\N	Redmond	79	98052	E6100000010C73FC16302AD94740086F2CBC2C905EC0	d4fa6dde-0cea-4532-b429-992f7d2c2f2e	2013-06-17 00:00:00
12575	9613 Camino Royale	\N	Oxford	14	OX1	E6100000010C0A329D10C5E64940B471B3E6F927F4BF	521f6ef1-9add-45ac-9093-efe9998045d1	2013-12-12 00:00:00
12576	8892 Oak Grove Road	\N	Redwood City	9	94063	E6100000010C985E808710B94240B601B38277825EC0	278085f1-31cb-4b82-a4fa-6bc07e10f3f8	2013-12-17 00:00:00
12577	Lindenalle 7524	\N	München	19	80074	E6100000010C00000000000000000000000000000000	7ec11311-533b-45d1-8777-0a7f1b4b7ee2	2013-08-02 00:00:00
12578	3805 Halfmoon Court	\N	Novato	9	94947	E6100000010CB8BCD27CC210434098EEE03C50A45EC0	f2cd3b56-0a43-4142-87ef-033fa30c3e18	2014-01-16 00:00:00
12579	Postfach 66 07 00	\N	Neunkirchen	70	66578	E6100000010C61C128526AB34840640CECF7406C1C40	02f9b6ea-e7bc-4c5e-8099-6e683f636c48	2013-11-02 00:00:00
12580	Erlenweg 9194	\N	Erlangen	8	91054	E6100000010CD292FB996EC74840F2893B508C062640	aa71af70-830c-43c0-8fe2-87897c51d801	2013-11-28 00:00:00
12581	8505 Fall Creek	\N	Milwaukie	58	97222	E6100000010C4F1E6B040EB7464011064FBD84A25EC0	22be9c64-37fc-43ed-83a4-183a6ba736ee	2013-08-22 00:00:00
12582	71, avenue Reille	\N	Versailles	164	78000	E6100000010C0BA6518A6E6F4840C7636532C0F30040	2cd7452c-e3fc-4276-a3d5-01b9087adf09	2013-12-21 10:09:29.423
12583	8291 Crossbow Way	\N	Lemon Grove	9	91945	E6100000010C616D8155516340406DC94545C0465DC0	9f7cf79e-ad91-4886-bd5e-c390916bed2e	2014-06-03 00:00:00
12584	Am Gallberg 67	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	36545303-d973-46a0-8da8-6e96f2faa269	2013-10-16 00:00:00
12585	6369 Ellis Street	\N	Imperial Beach	9	91932	E6100000010C031B870AC04740400EA6EA0215435DC0	43fcbfc0-cf44-4685-b181-efe102cc085f	2013-07-23 00:00:00
12586	238 Montego	\N	Coffs Harbour	50	2450	E6100000010CA9F76B30822C3EC0DF08CE36E0226340	8d422580-2d9c-49ad-b17e-c5d7b61578ab	2014-03-31 00:00:00
12587	6409 Buckthorn Court	\N	Watford	14	WA3	E6100000010C6D8C759EC6D649408AA2816D79FBD8BF	34afde80-46aa-47b6-ae9e-8a0f839a380c	2013-10-22 00:00:00
12588	Alderweg 20	\N	Hof	8	95010	E6100000010C4484700F1C22494039ED1087E5DB2740	ae81032c-35d3-435d-86f9-3cd1382984cc	2014-04-11 00:00:00
12589	7396 Stratton Circle	\N	Port Orchard	79	98366	E6100000010C82F72FD7CAC747406C66C9CB04A25EC0	7803291b-152b-434d-a999-52427edc9265	2012-02-10 00:00:00
12590	7691 Benedict Ct.	\N	Downey	9	90241	E6100000010C726B6C68C1F3404067F2EDAA018A5DC0	da6eca13-5802-4158-953c-c8ddfe39046b	2013-12-22 00:00:00
12591	973 MarvelLane	\N	Springwood	50	2777	E6100000010CB47BACE42DDD40C0696310E9ABD26240	8969473e-71ab-4495-a6c6-531eda7fd9ae	2013-04-30 00:00:00
12592	4683 Joseph Ave	\N	Chula Vista	9	91910	E6100000010CBD41A32FF9524040831A83E1A0395DC0	cc3ec7c6-b97f-4f98-b382-0ac6663e578d	2013-09-23 00:00:00
12593	8932 Condor Place	\N	Newton	7	V2M1P1	E6100000010C3804A0E488F64A40D56CFC5C1EAF5EC0	54ddedda-a6c0-4daf-801f-c2f3ef6f0d0f	2013-07-10 00:00:00
12594	2137 Birchwood Dr	\N	San Gabriel	9	91776	E6100000010C7D2C211ADD0B41400079966195855DC0	23b490e1-aa06-4814-9694-5234023b487a	2012-08-17 00:00:00
12595	8181 Landing Dr.	\N	Silverwater	50	2264	E6100000010C3554F33D1B9540C038C0A46984EF6240	801570c8-786f-437b-88c7-2747304ea06a	2013-11-27 00:00:00
12596	3632 Bank Way	\N	San Gabriel	9	91776	E6100000010C66692FE13E09414071E396E650835DC0	8094452d-cfcc-421f-9fc8-fe7afe55f654	2014-03-22 00:00:00
12597	3026 Anchor Drive	\N	Mill Valley	9	94941	E6100000010C1A63786B0CEC42403729977317A25EC0	ad385bde-034d-457f-b2e9-7c514cd79e75	2011-11-14 00:00:00
12598	2516 Beauty St.	\N	Sunbury	77	3429	E6100000010C392CDEE34DC342C0846C90FA2C126240	4c727a3a-6dfb-463a-82aa-f46e5f94be1e	2011-09-11 00:00:00
12599	4775 Kentucky Dr.	Unit E	Sedro Woolley	79	98284	E6100000010CFD2A2E79064148403E252662BA775EC0	9467851b-8246-4d20-bd7c-9a48e9ea7980	2013-09-24 00:00:00
12600	Hansaallee 59	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	3ee7ccfe-5a09-4c33-ba14-8c7b3dc58955	2013-11-25 00:00:00
12601	1144 Paradise Ct.	\N	Newport Beach	9	92625	E6100000010C08299925AFCE40403D55F1773D725DC0	277fb272-3461-496e-9e82-aec53a83d740	2011-08-23 00:00:00
12602	5802 Ampersand Drive	\N	Lake Oswego	58	97034	E6100000010C40F31DA563BA4640A53E1C6640B45EC0	272db93d-ea50-4cb2-9b90-557e0604a854	2013-10-18 00:00:00
12603	4480 N. Lanky Lane	\N	Lane Cove	50	1597	E6100000010CDDCF18F654EE40C0CF88DE74F2E36240	e15f6dd9-d63f-44b5-8723-19a26d92da8f	2014-03-25 00:00:00
12604	2425 Notre Dame Ave	\N	Olympia	79	98501	E6100000010C06A324DEDF7A4740E0F42C32B0BC5EC0	0c8d05b5-5941-46b5-aa08-4788ca8ad2a1	2014-05-23 00:00:00
12605	7338 Green St.	\N	Burbank	9	91502	E6100000010C3BB856B765134140F56292A0858E5DC0	639eaa4d-e7b4-49f1-9e4a-512fe4498750	2014-02-20 00:00:00
12606	5253 Big Canyon Rd.	\N	Birmingham	14	B29 6SL	E6100000010C6D7DF0768F334A4070449B16811AFFBF	b177e268-9e22-4505-97d4-d4219112f73d	2012-12-04 00:00:00
12607	6871 Thornwood Dr.	\N	Oakland	9	94611	E6100000010CDC7406717EEF42405360C75760975EC0	4d3393cc-d766-4e28-9fd7-152fe482a3e9	2013-06-02 00:00:00
12608	2038 Encino Drive	\N	Bremerton	79	98312	E6100000010C41E06D8845D34740E17F2157FFBB5EC0	c97a34e2-66c9-46c1-af6b-965bab6838dd	2014-01-25 00:00:00
12609	1825 Corte Del Prado	\N	Salem	58	97301	E6100000010CD3ABF8E351764640066611FB10C45EC0	27f1ff59-9b2a-4010-983d-98af6993cfb6	2013-07-18 00:00:00
12610	Postfach 8 66 22	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	3e3d6b2b-4f77-4439-aa63-dd9e89f1782a	2013-09-23 00:00:00
12611	9901 East Lake Court	\N	Warrnambool	77	3280	E6100000010C309A9425F20643C07486B492AFD06140	6357e189-6977-4a46-9443-4c528e0ae169	2013-02-06 00:00:00
12612	2598 Breck Court	\N	Downey	9	90241	E6100000010C7CC5C3A030F440401202A6EC39865DC0	c1703c0d-a33f-42e8-a5ab-164257997b3a	2012-10-14 00:00:00
12613	253, rue Lamarck	\N	Bobigny	179	93000	E6100000010C1B7ABFB54B7C484018DFB99763880340	2648163f-f9fd-4a22-8c13-65a2d1529d0e	2013-12-21 10:09:29.423
12614	3880 95th	\N	Tacoma	79	98403	E6100000010C6DF50131899C4740C20450F530A95EC0	0985744d-2877-43e0-964c-b27563edbff0	2013-09-02 00:00:00
12615	5165 Cambridge Drive	\N	Bendigo	77	3550	E6100000010CF6811F699C5E42C091CF27A5E7026240	52f9ed79-00e9-42d6-a01e-de1b821d82de	2012-01-24 00:00:00
12616	2466 Clearland Circle	\N	Chula Vista	9	91910	E6100000010CA1E3E4890C5040408AD906025E435DC0	3e4eda2c-0927-416d-8ae8-27b259829aaf	2013-09-23 00:00:00
12617	Pascalstr 2	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	0511a083-ffaf-4504-ad95-c7cdaa5e3b81	2013-02-16 00:00:00
12618	5670 Bel Air Dr.	\N	Milwaukie	58	97222	E6100000010C0951107DF1C04640E0C4DABDA4B05EC0	48211b9a-1282-47ec-bc93-5503844cec1c	2013-05-30 00:00:00
12619	7165 Brock Lane	\N	Berkeley	9	94704	E6100000010C2885A36068F342405B05F92272845EC0	6b3c8f82-556b-48f2-b9ab-a99fe86ad47f	2013-08-23 00:00:00
12620	3627 Warren Street	\N	High Wycombe	14	HP10 9QY	E6100000010CE2B47D193FC74940C362672BF641E6BF	6543da05-8f3f-4e3e-8aae-c19436b0cf91	2014-02-05 00:00:00
12621	Buergermeister-ulrich-str 888	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	24bfe345-d6cb-4243-ac96-979e716b4189	2014-05-18 00:00:00
12622	5029 Blue Ridge	\N	Haney	7	V2W 1W2	E6100000010C8BFFC397E4A048404F1C3785959E5EC0	ca0c348a-8427-47a9-ac5b-7c9f71ed5bec	2013-11-23 00:00:00
12623	Residenz Straße 944	\N	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	c3b7a2ad-e6c2-46a2-8391-cc699b98fb94	2013-12-14 00:00:00
12624	1398 Yorba Linda	\N	Burlingame	9	94010	E6100000010CFFF304BF31CB42406554B6AE6A9A5EC0	b17c3a77-3804-445a-ac3f-02374146772a	2012-10-30 00:00:00
12625	6057 Hill Street	\N	Bremerton	79	98312	E6100000010C28B67701A7C4474005E1C771FFA55EC0	d96f22e2-b29a-40b4-b799-b8ccbb8284d9	2013-01-14 00:00:00
12626	2679 Eagle Peak	#7	N. Vancouver	7	V7L 4J4	E6100000010C23D6FBDC209F484015401D36B9D05EC0	172adad0-1894-4049-a43f-0a7bca3a8956	2013-01-05 00:00:00
12627	249 Alexander Pl.	\N	Milwaukie	58	97222	E6100000010C41D995BC66B24640CC1BCB67CF9D5EC0	552c8397-d611-4e0b-9e00-c5fbe91a4676	2013-12-14 00:00:00
12628	8001 Pinetree Court	\N	Newcastle	50	2300	E6100000010CB25A5CD4947B40C07DB0AB95FEF66240	be6e509d-a918-4dbc-b55d-ab81b1f84174	2013-08-16 00:00:00
12629	4948 West 4th St	\N	Salem	58	97301	E6100000010C3D4BB649DE72464013A79607AFB65EC0	3888e1ca-f6f7-4e75-8f3b-63862b7be460	2014-05-07 00:00:00
12630	3310 Harvey Way	\N	Newcastle	50	2300	E6100000010C27C2AAE6F17640C09DBE8442F7F76240	a39a56e3-8865-48db-b792-620bda86a587	2013-03-12 00:00:00
12631	4734 Sycamore Court	\N	Bellingham	79	98225	E6100000010C7404A80E425C4840DA69295E45AA5EC0	d9407bba-c841-4ecf-8e7e-80dfa8cc704e	2014-04-12 00:00:00
12632	2812 Mazatlan	\N	Everett	79	98201	E6100000010CE5C6CCA92BF94740B7FEBA2482955EC0	b443d191-dee3-4056-b4ec-261ae73ef583	2013-04-04 00:00:00
12633	2850 D Bel Air Dr	\N	Sunbury	77	3429	E6100000010C4B4BBC3A8DC942C0DEC54BB74A1D6240	c8021bd9-be32-4b03-a52b-abbf1ec7bcb7	2014-03-03 00:00:00
12634	2852 Magda Way	\N	Oak Bay	7	V8P	E6100000010CFA847081083E4840F7E8C1196BDB5EC0	73a4edcc-20d0-434e-89b3-c99bf0293ffd	2013-08-06 00:00:00
12635	34, rue des Pyrenees	\N	Tremblay-en-France	179	93290	E6100000010C4AA3614C656F4840989882D438B00440	eb8fec2e-8776-4777-82e6-faff864601d0	2013-12-21 10:09:29.423
12636	Hans-Rosenthal-Platz 502	\N	München	19	80074	E6100000010C00000000000000000000000000000000	dd4dd23a-6c91-497f-9d58-1a1bdc13d69e	2013-09-08 00:00:00
12637	8036 Summit View Dr.	\N	El Cajon	9	92020	E6100000010C54E563388B694040B3E648EDA1355DC0	af9b6d77-ba4f-4418-a0f3-4ad93c568129	2013-12-27 00:00:00
12638	9277 Country View Lane	\N	Burbank	9	91502	E6100000010C55D83CADF5194140F468E7B09B975DC0	6bf1bc2d-da89-4016-beac-1870e270af92	2014-01-14 00:00:00
12639	7836 Mt. Washington	\N	Silverwater	50	2264	E6100000010C3554F33D1B9540C088754244C3E76240	7c7cdd8e-4246-4321-9003-600046433d00	2013-09-21 00:00:00
12640	2482 Buckingham Dr.	\N	Bremerton	79	98312	E6100000010CF50C3D3592CC47407F9C45ECA3B95EC0	994734e9-992b-4a0e-8f81-64d88a68f486	2014-04-17 00:00:00
12641	1979 Driving Drive	\N	London	14	SE1 8HL	E6100000010CD5011C4FDFC649401E49688556D5BABF	b30ad492-acdf-42f0-89db-8ea272ffd653	2014-04-13 00:00:00
12642	3977 Central Avenue	\N	Bremerton	79	98312	E6100000010C4C82428409D247401F667C8E89AF5EC0	dd360883-efa2-4b3c-8c9d-923d9f0afac4	2014-01-16 00:00:00
12643	26 Plymouth Dr.	\N	Bremerton	79	98312	E6100000010CA932E3206FC34740CAA77F47B6AA5EC0	1a9e4a1d-2187-42d0-a1bf-e3d12dc8c06e	2014-05-08 00:00:00
12644	188, avenue de la Gare	\N	Dunkerque	145	59140	E6100000010CD2D275D0418F4940CB9F8C74CAD50240	c889f9ef-006a-4017-9efb-76a56380682b	2013-12-21 10:09:29.423
12645	7435 Ricardo	\N	Kirkland	79	98033	E6100000010C9DAE7C4C9BD34740EEF9C399E1885EC0	5d5303bb-5ea6-46b5-bae2-b1e9d1b2ffb7	2014-05-30 00:00:00
12646	74, rue de Terre Neuve	\N	Les Ulis	177	91940	E6100000010C879F25324356484047E6B5CE059F0140	6ef65497-abca-4255-8ddb-7b827ef1aa51	2013-12-21 10:09:29.423
12647	1841 Cape Cod Way	\N	Goulburn	50	2580	E6100000010CE5D91D370E5341C096C3B7ADD7AF6240	3bf43177-4efb-4fc9-8481-78dbdfa90a07	2012-06-12 00:00:00
12648	6220 Boxer Blvd	\N	Bellingham	79	98225	E6100000010C3B86C8E5DF614840A476B72191A55EC0	89025445-894c-42e9-80fe-d1cfa8443005	2013-04-12 00:00:00
12649	8209 Green View Court	\N	Edmonds	79	98020	E6100000010C364F0A6E8AEC47405AF9A0B1DF9B5EC0	ec8f9f83-c376-41c6-9bf8-a29344a1342e	2013-04-25 00:00:00
12650	105 Woodruff Ln.	\N	Bellingham	79	98225	E6100000010C075E30C7FC69484004BBA4C7D6AB5EC0	2c0ec967-f70c-4b52-9c67-c0c73475553f	2013-08-15 00:00:00
12651	213 Stonewood Drive	\N	Portland	58	97205	E6100000010C90272FEA58C74640577FF8523DA75EC0	57184c25-b572-46e9-9455-49adcd98b553	2014-03-31 00:00:00
12652	9491 Fountain Road	\N	Burlingame	9	94010	E6100000010CD1B496566CC542406591202CCD915EC0	7c0661f4-780a-4cff-8e4d-d34e198a1bae	2014-04-04 00:00:00
12653	5786 St. George Drive	\N	Chalk Riber	57	K0J 1J0	E6100000010C0469D12980FA46408A96610C385653C0	80612abe-11fd-442e-93b2-2727aec5f382	2013-07-07 00:00:00
12654	44 Balboa Court	\N	Santa Cruz	9	95062	E6100000010C7C73598A497A42409DC88523E4885EC0	682f904a-b3b1-4f5a-995c-82d8ea5383ec	2014-02-08 00:00:00
12655	8114 Riviera Way	\N	Perth	66	6006	E6100000010C7E30DF30C5E93FC0D7F967E5D5FE5C40	3241ef31-7b41-401d-aa82-e6ce0cca7f35	2013-10-22 00:00:00
12656	Kappellweg 613	\N	Bottrop	53	46236	E6100000010CF74B3B13E8B94940506F5D1D5DAF1B40	db2fb5d4-47e5-491e-b247-0c27fc904ba5	2013-11-11 00:00:00
12657	9104 Mt. Sequoia Ct.	\N	Kirkland	79	98033	E6100000010C84C96A438ADB4740AAF2AD54EB8F5EC0	d75c1de3-efb5-47dc-afa7-eb9051d7fbf9	2014-03-30 00:00:00
12658	1819 Lilac Court	\N	Cliffside	7	V8Y 1L1	E6100000010CB26341594C464840EB281AEA39D95EC0	9389fbd9-adf8-4f9f-9237-96fa28941a3e	2012-06-03 00:00:00
12659	8890 Viera Avenue	\N	Lincoln Acres	9	91950	E6100000010C04A2D53FC45540408BDA3BD95D3B5DC0	f75198d2-dbef-4540-b941-b6108df2f09c	2013-06-30 00:00:00
12660	3929 Fern Street	\N	Townsville	64	4810	E6100000010C4B8FE5A1F43A33C0C3D4896F045E6240	a24bc404-6603-48ec-ac15-e32cfcdc9863	2012-09-18 00:00:00
12661	6968 Wren Ave.	\N	Lemon Grove	9	91945	E6100000010CDCD656B8315C40404332FAC440455DC0	b78a48d5-bc52-4a03-8925-0f51ceefddcb	2014-03-17 00:00:00
12662	Hauptstr 6057	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	37b310b6-f843-470d-8223-3ba1ed977b13	2013-12-18 00:00:00
12663	43, rue Jean Mermoz	\N	Croix	145	59170	E6100000010C86ED16E6005349402D4AE71DF03B0940	14335e9d-6a11-410e-a384-aaaee330bfcd	2013-12-21 10:09:29.423
12664	7008 Mines Road	\N	San Francisco	9	94109	E6100000010C79690ED18BEA4240E9B6AA3F71955EC0	d872f830-9d15-4e92-89d9-b8ae1134581e	2014-01-19 00:00:00
12665	5 Edwards Ave.	\N	Lynnwood	79	98036	E6100000010C54776C4FF2EC4740FA6F3AD6848C5EC0	32e32cec-3b7b-4822-a1e9-a01cc753e772	2014-06-15 00:00:00
12666	19, avenue de la Gare	\N	Les Ulis	177	91940	E6100000010C405FC640834F4840819BCFD0E54E0140	cb370a7d-dd8a-497d-a6a2-5992f1f24f36	2013-12-21 10:09:29.423
12667	8290 Margaret Ct.	\N	Lakewood	9	90712	E6100000010C3D3DFDF60BF040404F70622D2B905DC0	de9fada1-073d-46ef-b0df-e8146f83bc00	2013-12-04 00:00:00
12668	9531 Tri-state Ave	\N	Lake Oswego	58	97034	E6100000010CD5B2949DABB14640061A7B6764B75EC0	5eba62c0-b4c4-43da-9fe1-22e0b7ca8a95	2014-04-21 00:00:00
12669	2368 Olivera Rd	\N	Hobart	71	7001	E6100000010C61E34C0A926345C089CA4142546D6240	68dc3b1c-b340-4808-8eea-a1b5e3cb3098	2014-06-02 00:00:00
12670	2736 Scramble Rd	\N	Coronado	9	92118	E6100000010CBE699EA8695B40403F358666AC415DC0	79d8fa55-0653-4e22-8faf-66dead85158b	2014-05-22 00:00:00
12671	346 Sunshine	\N	Berkeley	9	94704	E6100000010CDB864DC632EA4240E1CD216D0D8D5EC0	bcb8405f-0690-45e7-8e7b-b244e28c0209	2013-07-17 00:00:00
12672	5095 Chablis Way	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	d8098044-bbb9-4235-80c3-c39e8adc1a5d	2012-10-25 00:00:00
12673	2095 Sierra Drive	\N	Bellingham	79	98225	E6100000010C6D6086D1936048408D37FCE558A55EC0	fcbfea5d-a835-43ed-9c8c-b1fa05c63649	2013-12-08 00:00:00
12674	4409 North Ranchford	\N	Hervey Bay	64	4655	E6100000010C004010880D5C39C0651D67AF741B6340	e8f7abbd-af93-48c4-8f3e-f693dbc3dff4	2011-06-26 00:00:00
12675	8463 Vista Avenue	\N	Lakewood	9	90712	E6100000010CDCFCFB9003ED40400467C7E4248D5DC0	fca908bf-00c6-4f75-a0d1-d4dcca15fc57	2014-03-23 00:00:00
12676	3123 Bonita Ave	\N	Brisbane	64	4000	E6100000010CA5E346B17B6D3BC0C989C0B8C91C6340	7fc1b095-7c42-42a9-8832-00acf895271c	2012-03-22 00:00:00
12677	2556 Rivewview	\N	Malabar	50	2036	E6100000010CBA272B5BAEF540C0E00C896B02EA6240	346696ce-cc44-420a-bb02-c6c0556f9952	2013-12-25 00:00:00
12678	9745 Bonita Ct.	\N	Marysville	79	98270	E6100000010CA40D55DE70084840E9B344568F855EC0	8885fdf9-c5dd-4ef7-9ac8-c31871763f53	2013-02-15 00:00:00
12679	805 Willow Lane	\N	Beaverton	58	97005	E6100000010CA933E46BD7C14640A1EA0EDC12B95EC0	9c7d0d7f-efd5-4435-8855-9863800f7dc4	2013-01-19 00:00:00
12680	2467 Green St.	\N	Cliffside	7	V8Y 1L1	E6100000010C6DB6C7867F3A4840B1BD894547D55EC0	4ed68c40-3273-419c-87c5-29dc6e63e1e6	2014-03-06 00:00:00
12681	4191 Yosemite Dr	\N	Fremont	9	94536	E6100000010C4C9DE36A1FCA424097CA37B478875EC0	c5788999-61b3-4c4b-aa7f-92a100a8e1a1	2014-05-27 00:00:00
12682	3884 Beauty Street	\N	Renton	79	98055	E6100000010CE58725FC5BC0474032405C33E9935EC0	aeb2256d-cb88-4c16-b71e-50ca43b38a0a	2011-07-13 00:00:00
12683	7572 Easley Drive	\N	Bendigo	77	3550	E6100000010C97EF286FD86242C074141860D50F6240	7d6798dc-69ff-41e1-8eff-0ed38b47fa67	2012-10-26 00:00:00
12684	7119 Iowa Drive	\N	Milsons Point	50	2061	E6100000010C3607FF81E4F240C0E303B2E651E76240	faf4008c-a9c8-4195-9046-eb1db1558589	2012-01-17 00:00:00
12685	2060 Hill Dr	# 108	Perth	66	6006	E6100000010CA3D0EB33D9F63FC02240DDF285EE5C40	8023df3c-4d67-4ec8-98bd-2ef9eaeb9c45	2013-03-31 00:00:00
12686	1748 Bird Drive	\N	Salem	58	97301	E6100000010C02A7DA393279464013A79607AFB65EC0	b8a8a14f-8ebe-4da6-8037-7c65054594fe	2014-01-05 00:00:00
12687	4444 Pepper Way	\N	Palo Alto	9	94303	E6100000010C2F87E9F417BF4240036A4C401F7E5EC0	0a099d8a-be6c-4d47-b2f1-601631587c0a	2013-12-30 00:00:00
12688	2775 Heather Leaf Ln.	\N	Victoria	7	V8V	E6100000010CD96322BB063D484075965A4A03E05EC0	8a9fd1d7-631d-439a-9a27-26813f2b6c78	2013-07-29 00:00:00
12689	Königstr 57	\N	München	20	80074	E6100000010C00000000000000000000000000000000	e6e0f763-dfff-4d62-a0e5-3a840f7e4fb7	2013-05-05 00:00:00
12690	5725 Oak Grove Road	\N	Cheltenham	14	GL50	E6100000010C9A19CBB79CF549407854422FF49E00C0	c7ed23da-f99c-4731-a91c-41becbc3666e	2013-11-29 00:00:00
12691	4311 Clay Rd	\N	Oakland	9	94611	E6100000010C402B6C2AA6E342402ECEEDB7C2975EC0	1c96fd67-1944-44e4-b8c2-2b694c04b1e0	2012-09-11 00:00:00
12692	421, rue de Terre Neuve	\N	Roubaix	145	59100	E6100000010C3B4C0ACE975E4940707D0CA2E6750940	5dc4cd0b-b424-4cfd-b436-ae7de25c1fea	2013-12-21 10:09:29.423
12693	172 Turning Dr.	\N	Cranbourne	77	3977	E6100000010C8406544A3F0F43C0BCF9106972246240	f6a00421-16e7-42ea-a027-73c8d045bdd9	2013-10-24 00:00:00
12694	67 Warren Street	\N	West Covina	9	91791	E6100000010C393B2E09120A4140D0F84BB922765DC0	d0e9ac8e-8d5f-4250-a005-3bb33b8c72c3	2013-07-04 00:00:00
12695	5125 Cotton Ct.	\N	Beverly Hills	9	90210	E6100000010CB8D86C3AD709414099F7616EB19D5DC0	7539c9c6-562b-4ee4-ac5d-acea77ff74bd	2014-03-25 00:00:00
12696	78, rue de l´Esplanade	\N	Bobigny	179	93000	E6100000010CE1F7F7F2046C4840D5F9F71164850340	f2bfe5ce-711b-4432-8c2d-bbf5de8bd9bc	2013-12-21 10:09:29.423
12697	9530 Vine Lane	\N	National City	9	91950	E6100000010C29FA76BA875940405125B646DC425DC0	2f3d4b9a-3f8c-4e3c-8fb7-6f8f61fad0b9	2013-03-31 00:00:00
12698	Räuscherweg 193	\N	Frankfurt	19	60323	E6100000010CA081E50EF90D4940FCFC56F1F2572140	ad6529af-77cf-454c-8419-6223c051e21d	2014-02-18 00:00:00
12699	3243 Buckingham Dr.	# 207	Beaverton	58	97005	E6100000010C337183C88AB84640FF71FE24A2B95EC0	73e1bcb8-08e7-49fd-b7b2-c0b7e1998424	2014-02-22 00:00:00
12700	7902 Crescent Avenue	\N	Sooke	7	V0	E6100000010C077105FE76364840542F52F8F7F15EC0	ecec06d3-7d36-49b8-8f77-23f50f62f985	2014-04-07 00:00:00
12701	4525 Benedict Ct.	\N	Imperial Beach	9	91932	E6100000010C6523FA05164B4040D926F2E5D4435DC0	1761fa6b-c1ec-403c-b0f9-5fb756cb24ee	2013-07-23 00:00:00
12702	853 Serpentine	\N	Gold Coast	64	4217	E6100000010CFC7A426548FC3BC03E2EF0AC892D6340	40876d4a-1aab-4d8c-a698-8e8a38a51f63	2013-11-27 00:00:00
12703	2094 Fruitwood	\N	Leeds	14	LE18	E6100000010CF20C2B3A5DDB4A40BE47DBD3F5B8F8BF	63a3ad3e-203d-45e5-9c75-df139490573b	2014-01-26 00:00:00
12704	Curieweg 29	\N	Hamburg	20	20354	E6100000010C55986C0F9EC94A40DAAB77720C032440	1e388899-cf36-401e-a43b-7ba8b3b2eb2e	2012-02-05 00:00:00
12705	8970 Birchwood	\N	Burien	79	98168	E6100000010C938C522E9EC347400E28DC6695905EC0	be48c481-4311-409c-8b18-c1e8b7aa3764	2014-04-28 00:00:00
12706	6793 Longview Road	\N	Vancouver	7	V7L 4J4	E6100000010C56FE4E12F7A748403BE37B51FFCB5EC0	ea321ea1-a9ed-4f0d-982f-de36bb64de82	2013-11-20 00:00:00
12707	7744 Lacorso Drive	\N	Runcorn	14	TY31	E6100000010C1055A9082CB34A406F8E9A79F0A405C0	0ea8a1ef-bee0-4b40-acb3-387e46d39051	2014-02-26 00:00:00
12708	3981 Bell Drive	\N	Bremerton	79	98312	E6100000010CA8390CE2DEC54740E17F2157FFBB5EC0	67094edc-8d48-4aaf-a0a4-2899a5136470	2011-06-06 00:00:00
12709	6580 Poor Ridge Court	\N	Burien	79	98168	E6100000010C3FBC2C80C1BE4740C8F0F8928A9B5EC0	632bbf84-6b67-4e17-b14c-7de9df938d3b	2013-12-15 00:00:00
12710	4657 Roundhouse Place	\N	Bremerton	79	98312	E6100000010CE8FEEAB2B2C7474000D68D16EDB45EC0	271dcd5f-ac3d-4319-b618-e53e53fe8f72	2013-07-18 00:00:00
12711	4698 G Street	\N	Milwaukie	58	97222	E6100000010C5E63404CB5BB4640E0C4DABDA4B05EC0	d54073e9-d782-4fee-91a1-a5e521712cc3	2011-12-08 00:00:00
12712	3029 Pastime Dr	# 2	Daly City	9	94015	E6100000010CA1C9353843DE4240D2BFAD8322975EC0	4ae8d19e-4286-47d7-a21a-f70e3d851327	2014-02-18 00:00:00
12713	6133 Kenston Dr.	\N	Runcorn	14	TY31	E6100000010CC05127F884A54A406C3F3D10EDAE05C0	ed297a6a-4160-4585-9247-a9f49ebba2b4	2012-11-10 00:00:00
12714	5979 El Pueblo	\N	Lemon Grove	9	91945	E6100000010C6B8C1AFA38614040A90363C441425DC0	301cc885-1a97-4f2c-8c6a-f431742908af	2013-10-08 00:00:00
12715	7221 Peachwillow Street	\N	Long Beach	9	90802	E6100000010C33C58913D8DC4040F0A461740E865DC0	00ac4593-4835-4e1f-979b-a3eb33035e79	2013-07-11 00:00:00
12716	426 San Rafael	\N	Lebanon	58	97355	E6100000010CA8AE20C3BB484640CB107E88E2BA5EC0	cd424564-31b2-4fdd-9bb8-0bf462aadba5	2013-10-25 00:00:00
12717	7895 Arlington Way	\N	Coronado	9	92118	E6100000010C2E7700E23F5C404050C64E6AEC405DC0	fd26f1b0-d6b7-485d-b17e-641ed01434b2	2013-07-18 00:00:00
12718	6126 Virgil Street	\N	Warrington	14	WA1	E6100000010C1F4723E22EBD4A403D7E833CD28204C0	b4139432-0d69-42d8-8839-6515983ccef0	2012-01-01 00:00:00
12719	5379 Treasure Island Way	Bldg 14	Downey	9	90241	E6100000010C8B904B210DFF4040938E2C57277D5DC0	0acf5bf0-0f97-4c8c-82ec-de9910925bc8	2012-04-18 00:00:00
12720	6158 May Way	\N	York	14	Y024 1GF	E6100000010CF550E61D3E004B4070CCDF294E5BF1BF	29b7d161-c118-4d38-88c9-57f1d139fa96	2014-06-06 00:00:00
12721	7399 Pacific	\N	Bellingham	79	98225	E6100000010CC41FB89C0F62484021F0516C0F975EC0	56f3cd02-38b8-4af1-a5ad-6cee4019e3c9	2014-05-24 00:00:00
12722	59 Clay Rd	\N	Edmonds	79	98020	E6100000010C364F0A6E8AEC4740C5767AB59B955EC0	d1269f8f-68aa-4961-8810-72eb2b84b900	2013-08-07 00:00:00
12723	539, avenue du Québec	\N	Dunkerque	145	59140	E6100000010C241F8EE39D7D49405EA3571B91CE0240	31997203-f148-4461-b0ae-e48580975f11	2013-12-21 10:09:29.423
12724	8680 Newell Ave.	\N	Metchosin	7	V9	E6100000010C7108717F123548406535F5A4BBD85EC0	10ad3559-6cd1-4865-bb3a-939a80b1d9e6	2012-07-17 00:00:00
12725	1456 La Mar Ct.	\N	Malabar	50	2036	E6100000010C18BADF043FFF40C0B22745507EEA6240	af5dc8f9-98e1-46ad-be8b-0e87766342ec	2011-09-08 00:00:00
12726	9192 High Maple Court	\N	York	14	Y03 4TN	E6100000010CC8478F528DFF4A403E0732F66A5AF1BF	7f95b4ed-e80c-4501-8581-08f64ea2c6be	2013-10-22 00:00:00
12727	2544 Ashley Way	\N	Newcastle	50	2300	E6100000010CB25A5CD4947B40C0DE8C2EF94EFD6240	d317b693-0a97-4b37-981e-06847116ab67	2012-04-02 00:00:00
12728	3594 Vista Del Sol	\N	Cheltenham	14	GL50	E6100000010CC872DFF444F849406EFE77AE30A600C0	017cc406-0fba-45c9-a933-4a35ae98b198	2014-02-06 00:00:00
12729	3127 Terrace	\N	Redmond	79	98052	E6100000010C22C2F80EE1DF474044EED90C4D935EC0	27a17830-2f69-480b-9ae5-2a434e302288	2013-12-17 00:00:00
12730	8294 El Rancho Drive	\N	Spokane	79	99202	E6100000010C11E33AC5CFDC47403DA8449840525DC0	9671818e-e15c-4cce-b154-b3e183f75dee	2014-03-18 00:00:00
12731	8071 Daylight Place	\N	Chula Vista	9	91910	E6100000010C92B741D78A4D404096AD0E8E1F3E5DC0	ce432dac-0b1f-4868-9d08-5065ae371b36	2013-07-05 00:00:00
12732	8080 Lancelot Dr.	\N	Vancouver	7	V7L 4J4	E6100000010CB258E096C0AB48406F1946056CCA5EC0	abac30ef-7836-4e45-a937-9523e85dca26	2013-10-08 00:00:00
12733	27, rue de la Comédie	\N	Colomiers	117	31770	E6100000010C204ABFE0C0D2454003954463E741F53F	559d7724-ff9a-4ded-82ba-4dfa92ae7be7	2013-12-21 10:09:29.423
12734	6158 May Way	\N	San Diego	9	92102	E6100000010C7C7FEB69B05D404029D122A971445DC0	491ababe-217c-4359-928f-2e25abc6a8fa	2013-11-24 00:00:00
12735	Haberstr 8	\N	Hamburg	20	20354	E6100000010C55986C0F9EC94A40612A077795042440	55072054-ca3f-4602-9519-24a8cfbcd36e	2014-04-29 00:00:00
12736	8162 Olympic Dr.	\N	North Ryde	50	2113	E6100000010C79910A4885DE40C060C20671DCE06240	c004795e-dcdf-49df-a0d4-162c1ca03031	2012-05-05 00:00:00
12737	7185 St George Dr	\N	Oak Bay	7	V8P	E6100000010C0D5CDFC5C62F4840456849476CCC5EC0	477ce386-6c6d-40f9-9c00-91d6f05e024d	2013-12-12 00:00:00
12738	136 Balboa Court	\N	Sedro Woolley	79	98284	E6100000010CC724980D4D3D48408B7929FB697C5EC0	922fd850-1a67-46d2-8bd9-ec5acb678d2b	2013-11-06 00:00:00
12739	6137 Freya Way	\N	Bendigo	77	3550	E6100000010C97EF286FD86242C048FE9388AD0B6240	10cca843-8c8b-4bf8-a8b8-268e170a5ed8	2013-02-24 00:00:00
12740	4634 St. Paul Way	\N	South Melbourne	77	3205	E6100000010C2FFD8BF769F042C055AE64BE541D6240	c28273ee-0f8d-497c-8c2b-b403a693991f	2012-07-16 00:00:00
12741	8721 Nahua	\N	Walla Walla	79	99362	E6100000010C023D0092920647403DB605020D905DC0	d076bcdd-b4ad-4958-9365-25f30ca2327b	2013-02-16 00:00:00
12742	1926 Fish Dr.	\N	Colma	9	94014	E6100000010C5796D35BFED242403E36B48618915EC0	13cb814b-bdc5-4f0f-b62d-a39b9eaa4ede	2013-11-13 00:00:00
12743	3421 Bouncing Road	\N	Los Angeles	9	90012	E6100000010C91DFC405130A4140B88046902F925DC0	f6c74e04-0007-4587-9763-5e9889142965	2013-08-01 00:00:00
12744	9535 Pear Dr.	\N	Seattle	79	98104	E6100000010CB9D968A1B7D247409FEA9D6940985EC0	0ff7971f-8da2-4b26-b78c-da8f5004e8f3	2013-07-25 00:00:00
12745	1285 Greenbrier Street	\N	Renton	79	98055	E6100000010C70BB947CF7C0474061F18C45DF8C5EC0	a4e4c49d-6a49-478c-82b2-2766059d5a80	2013-11-15 00:00:00
12746	7653 Fall Creek Road	\N	Salem	58	97301	E6100000010C1A1677D204744640ED938DA99EBA5EC0	e747ff44-4c70-479b-9c6c-710e886fc988	2014-03-17 00:00:00
12747	2313 Pastel Drive	\N	Torrance	9	90505	E6100000010CCE6A3B7E59ED40401BE19255638D5DC0	7d6bb1ec-78c6-4554-b6fc-2ff1195432e5	2014-04-20 00:00:00
12748	76, rue de l´Esplanade	\N	Paris	161	75017	E6100000010C1DC081F7116F4840DCBCEE89DB700240	678288a3-4208-40a1-9402-27db82665d85	2013-12-21 10:09:29.423
12749	8934 Dublin	\N	Bellingham	79	98225	E6100000010CF307E9BC7D67484087C7328B22A75EC0	f9c199c6-44bb-4cd1-8e48-a31273d89272	2013-10-22 00:00:00
12750	3848 East 39th Street	\N	Concord	9	94519	E6100000010CA18642EB19FF4240E84C0794157B5EC0	71e92b02-0545-4df1-8e19-6e9938eb4046	2014-03-02 00:00:00
12751	Rykestr 8105	\N	Berlin	70	14197	E6100000010CA7DC4DAB5C3A4A40B75FAF9C30DE2A40	c660faf0-c4b0-4ddb-92ab-d234bc9e6fa5	2013-07-08 00:00:00
12752	3381 Pastel Drive	\N	Kirkby	14	KB9	E6100000010CCCA9C9620EC44A4074EF339C752507C0	40c62dad-9853-4079-8533-36a254e9beaf	2013-11-09 00:00:00
12753	1, boulevard Beau Marchais	\N	Sèvres	178	92310	E6100000010CE4EFC8CF12644840B491696B2EAC0140	d9713d64-4d14-4730-8c1f-0a09fb6a275b	2013-12-21 10:09:29.423
12754	Carlsplatz 89	\N	Bonn	20	53131	E6100000010C00000000000000000000000000000000	26491d7a-9b7c-4ff4-9b66-f1b1eb37d002	2013-08-31 00:00:00
12755	1204 Weber Blvd.	\N	Woodburn	58	97071	E6100000010CBF692502648C4640D177FC2AC2A95EC0	1628ed45-6585-4b6a-86c0-d519217877c4	2013-08-15 00:00:00
12756	991 Vista Verde	\N	El Cajon	9	92020	E6100000010CDBE1926E2F664040FAA07828DE3D5DC0	a56d8060-9187-4222-ac7c-d42845f84901	2013-10-16 00:00:00
12757	4550 Glenellen Court	\N	Townsville	64	4810	E6100000010CB22F3464143333C01FC367388C5D6240	0583b9c9-52aa-475e-ace3-7ad1373339e2	2014-01-20 00:00:00
12758	6412 Clifford Court	\N	Seattle	79	98104	E6100000010CDAFBDD9327D54740B3F6E63D4C9F5EC0	b20d3ffe-5fdf-43c0-9237-8622778f46f8	2013-08-12 00:00:00
12759	359 Pleasant Hill Rd	\N	Burbank	9	91502	E6100000010CD6A095AE15194140DC6AAE0BA39A5DC0	995f05a1-2d5a-4b97-8408-9a6aff627905	2012-04-07 00:00:00
12760	9108 San Miguel Drive	\N	Berkeley	9	94704	E6100000010CD5A0DDB387EF424029360D8587925EC0	a57195e3-1b99-483f-b7ee-86983265f003	2013-11-27 00:00:00
12761	7439 Laguna Niguel	\N	San Francisco	9	94109	E6100000010C79690ED18BEA424064575CB6A09F5EC0	4641486b-e5d8-42ee-9f65-f8125816d4d0	2014-06-05 00:00:00
12762	9233 Pepper Way	\N	South Melbourne	77	3205	E6100000010C35A52C2C06ED42C0BC370D43D3236240	dda5f30e-0d30-462a-b2cc-2783bf97076c	2014-01-04 00:00:00
12763	390 Ridgewood Ct.	\N	Woodland Hills	9	91364	E6100000010CC798932C6A114140397040C2FF9A5DC0	c75dec98-79f3-4fcb-a11f-d6059a1879ef	2013-05-18 00:00:00
12764	9183 Via Del Sol	\N	Billericay	14	CM11	E6100000010C2577B66E4BD14940CBE3BBCAA5A7DA3F	5e78da19-d8b1-47b1-973e-5663b14bea60	2013-09-12 00:00:00
12765	1631 Via Cordona	\N	Port Hammond	7	V6B 3P7	E6100000010CB24582F3D49D4840DDE4299D99C15EC0	60de25ac-bd62-484e-a5a8-2649530a32f8	2014-06-15 00:00:00
12766	771 Northridge Drive	# 495	Downey	9	90241	E6100000010C78DC9CB02EFE404092DBD2BA33835DC0	3401f475-7ba0-4057-b1d2-f5d2ce820459	2013-07-09 00:00:00
12767	2266 Greenwood Circle	\N	Torrance	9	90505	E6100000010C5F4A2ED0DBE640406852AA470D9E5DC0	eb65ad00-90a7-4026-99f5-43656a92976a	2014-03-09 00:00:00
12768	2374 Turning Way	\N	North Ryde	50	2113	E6100000010C5A0C645FD8E240C0D477395E99E86240	e51104ee-8e8e-47e8-876d-4c4eed577464	2012-08-16 00:00:00
12769	5724 Victory Lane	\N	San Carlos	9	94070	E6100000010C1737619042C04240046851E0AF8E5EC0	69fa1b41-7012-45bb-bed5-d22310e780ca	2014-01-28 00:00:00
12770	130 North Main St.	\N	San Diego	9	92102	E6100000010CCB5F13C526564040E29801C7B1435DC0	c3610893-5abc-408b-b179-4215d469163d	2013-10-29 00:00:00
12771	6498 Mining Rd.	\N	Lake Oswego	58	97034	E6100000010C7B48E86F10B846408F87F86079A85EC0	27e8593e-dca4-49ba-8164-5381d52f1b57	2013-12-29 00:00:00
12772	Räuscherweg 3456	\N	Eilenburg	85	04838	E6100000010CB6E2A25A75B5494029DBC34F09592940	2e004436-f2f5-4ebe-b9fe-5dec9e207388	2013-01-02 00:00:00
12773	8501 Boatwright Ln.	\N	Woodburn	58	97071	E6100000010C5BBCF94887984640923E94B99EB15EC0	baf3286c-9850-4c6d-ac8b-a548e21a6203	2014-05-22 00:00:00
12774	6114 North Park Court	# 12	Rhodes	50	2138	E6100000010C4AD00E6A4BEF40C00F8550E2BBE46240	3d4326b7-4e24-4aa6-b357-4c0118a65bd5	2012-11-03 00:00:00
12775	31, cours Mirabeau	\N	Chatou	164	78400	E6100000010CD01A6733BE6D4840391C167A1E360140	0ef333ec-1088-4ee8-8333-64bff7f4f6de	2013-12-21 10:09:29.423
12776	2693 Dance Court	\N	Spokane	79	99202	E6100000010CEDC1D7ED1ECB47409AE2122A02565DC0	f60d878a-d6b4-4531-8b93-722f30ac2267	2013-07-22 00:00:00
12777	371 Westwood Court	\N	Burbank	55	44214	E6100000010C9CEFBD3AEF7C4440FBAFC0FBB47E54C0	5d07aced-e649-4fc5-9cee-a2ead04d1eb7	2013-07-05 00:00:00
12778	6447 Ranch Road	\N	Geelong	77	3220	E6100000010C4C08C64FC41143C08B9299AB4C086240	00beb8d7-fee1-41f5-b304-1aabe7876857	2013-10-11 00:00:00
12779	7392 Coach Place	\N	Gateshead	14	GA10	E6100000010CD446C75990854B4025D9535E0E9EF9BF	a7d0f37d-6e26-471a-92a5-ee76f442c18a	2011-10-27 00:00:00
12780	79 Montana	\N	Torrance	9	90505	E6100000010C16008FEF7BEC40401BE19255638D5DC0	76682316-8df2-42ed-9fa4-b3d5e35c6d14	2011-10-04 00:00:00
12781	Conesweg 89	\N	Hamburg	20	20354	E6100000010C6D036509C3C24A403903636C00012440	53ceb604-fb62-41ab-8502-b4342a26a579	2013-12-29 00:00:00
12782	5256 Chickpea Ct.	\N	Newport Beach	9	92625	E6100000010C04EB0F5E5FC740401C8945C053815DC0	346aea34-7039-4564-a220-f76652332e13	2014-04-16 00:00:00
12783	5297 Algiers Drive	\N	Woodland Hills	9	91364	E6100000010C9F202A19DA1141408E37AAF44FA05DC0	4e0617f8-05f2-4206-8fd1-3fd92bddb059	2014-03-31 00:00:00
12784	6284 Romero Circle	\N	Townsville	64	4810	E6100000010CA25BEA6B103433C0F4CC8A34F9566240	ac5de7d6-5989-45b7-b5ab-ceced0e9d9af	2012-01-22 00:00:00
12785	6578 Woodhaven Ln.	\N	Coronado	9	92118	E6100000010CBF3AC7DF7B58404050C64E6AEC405DC0	6721cc32-cfb4-4c99-9181-f8dac5273d77	2013-07-27 00:00:00
12786	7820 Bird Drive	\N	Redwood City	9	94063	E6100000010C4E678D131AC44240DE39D2B46A8D5EC0	3cfdd39b-04cc-42fc-b09e-baf3f3c6bd9c	2014-03-13 00:00:00
12787	1025 Yosemite Dr.	\N	Oregon City	58	97045	E6100000010CF1BF6F582BA6464005D1DE19A2A95EC0	83431ad7-c9c0-4626-9519-36930bfead10	2014-01-05 00:00:00
12788	37, route de Marseille	\N	Verrieres Le Buisson	177	91370	E6100000010CBA9EFAD72C634840AE48A8445A0B0240	1f8e0f9d-a1dd-4f99-a59d-de4413382ed1	2013-12-21 10:09:29.423
12789	82, rue Henri Gagnon	\N	Colomiers	117	31770	E6100000010C4976F2CF2BCD4540F63AB898A43EF53F	48008c59-7427-480f-a8ec-f0df2fc63ef4	2013-12-21 10:09:29.423
12790	2520 Almond Street	\N	Oregon City	58	97045	E6100000010CD6D384B06DA446404BADCBEE29995EC0	41b32fee-4b0b-47e3-bcae-997ef95b3544	2012-12-15 00:00:00
12791	8634 Sunshine	\N	Bellflower	9	90706	E6100000010CF0D8C16862EC40406AE3BB0EB97F5DC0	178bb451-9b96-49a7-98d4-47df8b6bb375	2013-09-22 00:00:00
12792	384 Price Lane	\N	N. Vancouver	7	V7L 4J4	E6100000010C6E9CE3467F9E4840AC342B5FA2C95EC0	b1f4ee2d-e6a2-4433-8b14-d8ae34196d61	2014-04-19 00:00:00
12793	3717 Via Cordona	\N	Port Macquarie	50	2444	E6100000010C00A253B22C643FC01C69C3F6CD166340	e653395c-0ef0-49b3-8bbe-403cba2acc00	2013-10-03 00:00:00
12794	8826 D Anchor	\N	Hervey Bay	64	4655	E6100000010CDA04F697134F39C09B528E9AE61D6340	d8e7df83-ba8e-4fca-a6d2-ee3936384abb	2012-12-27 00:00:00
12795	6752 Covington Court	\N	Lynnwood	79	98036	E6100000010CD38F3E2FDFDE47406956DD99C7925EC0	7fe20319-4158-44e4-a66c-752b9ce331f2	2013-04-19 00:00:00
12796	8434 Kenmore	\N	Birmingham	14	B29 6SL	E6100000010C83B7681D852D4A4046F343DB2214FFBF	c543f196-f252-45fc-8bd8-3d8b3cd9370d	2011-11-14 00:00:00
12797	1411 Ranch Drive	\N	Sedro Woolley	79	98284	E6100000010CBD6FF3041837484032935DD7B0895EC0	632bc801-1f58-4f5f-9f9b-fce67fefb5e5	2012-11-10 00:00:00
12798	8033 Chaucer Drive	\N	Sooke	7	V0	E6100000010CC9FE74149A2748402B38404CB8F65EC0	a958c282-37be-4214-a882-cafcde499717	2013-08-21 00:00:00
12799	9808 Deerfield Dr.	\N	Chula Vista	9	91910	E6100000010CE20398BBBB564040E46C92AEDC475DC0	63e3c770-f053-4e60-a725-63f7576b2754	2014-02-17 00:00:00
12800	7393 Jacaranda Dr.	\N	Burbank	9	91502	E6100000010C147490AC651A41406227D22C56955DC0	3d5773b1-88d6-4add-af82-696be1a8d8b2	2012-04-22 00:00:00
12801	2947 Vine Lane	\N	Woodburn	58	97071	E6100000010CBF692502648C4640052D17CB0DBB5EC0	aeef4653-7b7e-42e5-b218-3c15d9226b13	2013-11-03 00:00:00
12802	2479 Killdeer Court	# 120	Spring Valley	9	91977	E6100000010C9205D407EE61404061008E79873F5DC0	28c40752-9ce9-4e84-a9eb-e928db2ba3c2	2013-08-11 00:00:00
12803	7646 Strasbourg Lane	\N	Glendale	9	91203	E6100000010CE1970E136F0D4140FF09FA16C9945DC0	2d8f0169-8dd8-4909-8f14-af6743d38cbe	2013-08-04 00:00:00
12804	7433 San Simeon Ct.	\N	San Francisco	9	94109	E6100000010CF0A14BA607EB424036E3CECDBD905EC0	29b8208c-359e-46b5-9894-5d8e0607ea6d	2013-11-02 00:00:00
12805	Hellweg 4244	\N	Werne	53	59368	E6100000010C88F818BD19DE4940D1A8219F6D791E40	cfd032c3-fc61-4525-bb38-19548cd695f3	2013-12-23 00:00:00
12806	3831 Golden Gate Way	# 203	Colma	9	94014	E6100000010CA3FACA0D16DE4240609C9F3D56A25EC0	87ed5176-a0cc-4ed0-aede-1bca8028c658	2013-12-28 00:00:00
12807	9453 Sharon Dr.	\N	Portland	58	97205	E6100000010C0712F413EEC74640F5BD36984EAE5EC0	6be5139d-3039-4c38-8295-c52e1e7a7623	2013-08-22 00:00:00
12808	7784 Door Way	\N	Newton	7	V2M1P1	E6100000010C28D7AF966FFD4A40A4968D1643BD5EC0	6f205c1c-5315-40db-8f0e-45bdb96e1ff3	2011-12-16 00:00:00
12809	4844 Spring Water St	\N	Berkeley	9	94704	E6100000010C2E6B137313EE42405C8E9CD14F935EC0	2a37fbe7-32f3-4a9d-9935-de74599d7123	2013-12-17 00:00:00
12810	735 S. 39th Street	\N	Long Beach	9	90802	E6100000010CAD22A98EC2E340401CF190B628925DC0	8cfcc19d-777a-49a5-b63a-201316bb4363	2013-11-16 00:00:00
12811	9320 Teakwood Dr.	\N	Tacoma	79	98403	E6100000010CD42E8E445DA04740AB6ED7599EA65EC0	1f07cc0d-e0b3-42a0-a43f-a1d492425731	2014-05-16 00:00:00
12812	2525 San Miguel Court	\N	Caloundra	64	4551	E6100000010CB6B3415645D23AC0E7A2E05D53296340	0be0a156-d887-4794-a88f-bb0461fb8f24	2012-07-14 00:00:00
12813	Auf der Krone 9249	\N	Hamburg	20	20354	E6100000010C235FFF8972C34A40E0B13960E8FC2340	200d20c5-9de0-4785-85c5-70bba04c14b7	2014-01-17 00:00:00
12814	8982 Ricardo Drive	\N	Geelong	77	3220	E6100000010CD9562D20DC0D43C0F068832C60076240	5922f44d-874c-401b-9e21-8b0b5ec9bcb6	2012-06-09 00:00:00
12815	135 Grant Street	\N	Imperial Beach	9	91932	E6100000010C8D464544564C4040022A1072D4465DC0	52a4e995-9205-46b1-a8e3-96d8a5d420ab	2012-06-25 00:00:00
12816	1884 Scramble Road	\N	Lakewood	9	90712	E6100000010C907DFE5C14F340405220532EE08A5DC0	7cafb47a-012a-4610-be84-d5060d56a06b	2012-06-15 00:00:00
12817	8252 Northridge Drive	\N	Victoria	7	V8V	E6100000010C33FD51974E3948409B2751F753D75EC0	d1b3394a-4885-4bd2-b4e1-067bf3a3546f	2014-05-06 00:00:00
12818	295, avenue de la Gare	\N	Paris	161	75009	E6100000010C0ADC6A40E5754840F1820C9C37BB0240	b778fc01-7127-4175-a68a-9b8cffa43a42	2013-12-21 10:09:29.423
12819	2912 Guadalupe Dr.	\N	Burbank	9	91502	E6100000010CFB53AAB6D513414000E8830318965DC0	2c3e5dee-118a-4559-8422-3ff213fbed90	2011-11-04 00:00:00
12820	9533 Working Drive	\N	Burien	79	98168	E6100000010CEAEB06D2E4B94740C841D0D5F9995EC0	fb5a5af2-17a1-4b8a-af37-6a3b2d5f94bf	2013-06-24 00:00:00
12821	6973 Elena	\N	Concord	9	94519	E6100000010C4A89B8678F0043403788562F66765EC0	a617c4d0-cac7-4274-977d-5bb810c24887	2013-10-04 00:00:00
12822	776, avenue du Président-Kennedy	\N	Les Ulis	177	91940	E6100000010C0EFACAC2A44D4840FD9731B4024E0140	52257ebc-cae3-43a7-af55-9228cf3e3dab	2013-12-21 10:09:29.423
12823	2624 Pome Court	\N	Cambridge	14	CB4 4BZ	E6100000010C34294DA908204A407979758FF766BC3F	48a9f2a8-9702-43b3-8b6c-61ef9ea21185	2013-12-27 00:00:00
12824	7103 Quiet Place Drive	\N	Novato	9	94947	E6100000010C7C423D627E07434096479FA82CA15EC0	821d9462-994f-4b7c-b409-702ca6dd3ec2	2014-04-19 00:00:00
12825	3980 Bridge	\N	Leeds	14	LE18	E6100000010CC07B5344C9F14A408E959390FC76F5BF	48e99314-df51-4b6f-8b09-f94c81432999	2013-08-05 00:00:00
12826	1803 Olive Hill	\N	Milwaukie	58	97222	E6100000010C0951107DF1C04640632609BD749B5EC0	3c753d20-a496-424c-a535-58259eedad02	2013-11-18 00:00:00
12827	6350 Plumas Court	\N	Calgary	1	T2P 2G8	E6100000010CA76E22BE818F49403FE1A610E37D5CC0	fc6c8867-b154-4282-9efa-9067c211d12d	2014-03-10 00:00:00
12828	1590 Mildred Ln.	#35	Lemon Grove	9	91945	E6100000010CCF5AF22593644040962CB785FF485DC0	662e6084-4275-484c-8d75-0ccded5fb8a3	2014-01-12 00:00:00
12829	6306 Knollview Court	\N	Goulburn	50	2580	E6100000010CEA703ACBF74B41C06FC284B256BB6240	193199a2-703c-476c-b7a6-c6aa02e8f0a5	2011-09-17 00:00:00
12830	9666 Northridge Ct.	\N	Imperial Beach	9	91932	E6100000010C0B7CF5C92A4840404020B6CDD53D5DC0	ec3bd9cd-2eec-495e-b45e-730aef9ffeee	2013-07-12 00:00:00
12831	6387 Scenic Avenue	\N	Sydney	50	1002	E6100000010C10DD9925E4F240C0661AC8AA24E66240	1b66054c-13fc-4d0c-b8bd-be2666ba516a	2013-04-05 00:00:00
12832	9707 Coldwater Drive	\N	Colma	9	94014	E6100000010C5796D35BFED242403E36B48618915EC0	c8ce0bd5-0cc7-4a60-b2f5-ef6b56db99f0	2013-10-16 00:00:00
12833	4217 Fairlane Place	\N	Cranbourne	77	3977	E6100000010CDAB75C49BC0F43C0638B006496226240	118cac09-2d6e-43a9-b737-624c5aec0f8c	2012-03-28 00:00:00
12834	8038 La Paz	\N	Port Orchard	79	98366	E6100000010C7F54C23151C24740AA4E7D4F6FAB5EC0	ff3daafa-c05d-40e6-b342-96c17a054065	2014-04-13 00:00:00
12835	989 Crown Ct	\N	Downey	9	90241	E6100000010C99D3C9497EF540408438316078855DC0	75f2d4f8-4a02-491a-a862-3e9d5eb3e6a9	2013-11-14 00:00:00
12836	54, rue Philibert-Delorme	\N	Roubaix	145	59100	E6100000010C0D1C84195E5A49405D1D66B3A5660940	414ff153-5820-43e4-b6d2-acfeb6b6a381	2013-12-21 10:09:29.423
12837	2230 May Way	\N	Newton	7	V2M1P1	E6100000010CB8F6D7E69AF84A40CB783B3655AE5EC0	e34e019f-dc80-4c36-91ee-bf968eb26ecd	2014-06-04 00:00:00
12838	639 Treasure Drive	\N	Milsons Point	50	2061	E6100000010C03DE8D24DCEF40C09C8B8DA98BE06240	b664b44f-127e-4d53-8e1b-17969748a112	2011-10-06 00:00:00
12839	5435 Jacobsen Street	\N	Lincoln Acres	9	91950	E6100000010CECD3D6AC1C594040E3DE2B7259505DC0	d916129f-740a-43c4-b9b0-cf7ebc6d4647	2014-02-14 00:00:00
12840	6930 Lake Place	\N	Lincoln Acres	9	91950	E6100000010CE06C57E3C85A40401D94B104DB485DC0	cdb1bdd7-82c6-4cd0-b745-0e8e1a9c4fd3	2013-08-03 00:00:00
12841	Marketplatz 5793	Buchhaltung	Berlin	19	14129	E6100000010C1CBE7EB4A63E4A4013E95DDD0E592A40	3e0c0306-46f8-456e-9451-35c6b90a3c0e	2014-02-14 00:00:00
12842	5473 Olive Hill	\N	Matraville	50	2036	E6100000010C84F2A20D3FF540C0EBF1CC8686E96240	7f43ae70-3e62-41b8-ab4f-1497e3976176	2013-08-31 00:00:00
12843	389 Alamo Way	\N	Beaverton	58	97005	E6100000010C64BD183433BD4640E9D200586BBA5EC0	5ef3481f-f67f-4b2c-b7c2-1723177b98da	2014-05-02 00:00:00
12844	4794 Kim Court	\N	Bendigo	77	3550	E6100000010C70A25DA5F66042C0CB00F8BC230C6240	dcb08f4f-4f74-48ab-9de3-44a126f5b22e	2013-01-17 00:00:00
12845	9120 Springfield Drive	\N	London	14	E17 6JF	E6100000010CFD30D437EFC949404DFD421F21D3A5BF	960eb23d-0abf-4c10-9b5f-dab701c0e1af	2014-06-27 00:00:00
12846	1162 Park Glenn	\N	Walla Walla	79	99362	E6100000010C023D009292064740CA63752CB7A05DC0	a0ed54d0-74a4-427c-806c-d2ac3d6e4531	2012-10-18 00:00:00
12847	774, rue Descartes	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	694b2dca-8ed6-42d6-8a1e-d5312506ea14	2013-12-21 10:09:29.423
12848	3166 Rosemarie Place	\N	Haney	7	V2W 1W2	E6100000010C835012E67297484084C9FF5759AA5EC0	46785c62-44eb-4274-8c95-e827b3339ea0	2013-08-08 00:00:00
12849	2444 North Ranchford	\N	Vancouver	7	V7L 4J4	E6100000010CAEDDD523CFA4484096BCA420B2C55EC0	c6487897-06c2-4717-b286-ae1a84cba6a9	2012-04-16 00:00:00
12850	1547 Larkwood Ct.	\N	London	14	SE1 8HL	E6100000010C8C2773895EB84940A6648887F6D3BABF	7be753d0-8ea2-4fb8-9216-c9637246c2f5	2013-12-05 00:00:00
12851	1197 Santa Barbara	\N	North Ryde	50	2113	E6100000010CDC761CB362DF40C0C3F5BFF125E76240	96ba693d-f44a-4560-b7d8-d7dbb27db9a0	2012-12-01 00:00:00
12852	1578 Grand Drive	\N	Langley	7	V3A 4R2	E6100000010C124742AC678E48408B6BD160C3AD5EC0	611352de-01f8-4f43-b3ee-810951d86329	2013-05-19 00:00:00
12853	6745 Salem St	\N	York	14	YO15	E6100000010CC8478F528DFF4A4074DCC3585153F1BF	a58d39db-9fea-4ce3-a280-cc7807209e78	2013-10-24 00:00:00
12854	6532 Pinecrest Rd	#508	Sedro Woolley	79	98284	E6100000010CA4884BB3FD454840F3AF87E8E8885EC0	67c329f4-b326-4176-9750-b902e650c3fe	2013-07-21 00:00:00
12855	8049 Jefferson Street	\N	Rhodes	50	2138	E6100000010C931C7FE220ED40C0738B960751E26240	a765b8ca-7fc3-4adb-893c-93a52768aec2	2012-09-01 00:00:00
12856	4609 Rosebrook Ct.	\N	Marysville	79	98270	E6100000010C1FAC2554490A4840F5BBB43E49915EC0	8a0f133e-c63b-4096-becb-a205822f6727	2013-07-31 00:00:00
12857	2669 Clark Creek Rd.	\N	London	14	W1V 5RN	E6100000010C1CDDDB85C3C44940673D1280D147C0BF	6ea150db-0501-4f7f-8871-63c3f2a304a7	2014-04-12 00:00:00
12858	4650 Big Canyon Road	\N	Lebanon	58	97355	E6100000010CC4725B080647464078691F5662B55EC0	15839ca2-092e-4ad4-b7d9-c7b1bba54a37	2011-09-26 00:00:00
12859	4325 Polson Court	\N	North Ryde	50	2113	E6100000010CAEF175CAB5E340C01A9B267B47E36240	a2320c76-b129-4042-8bb6-7507cc644717	2013-02-25 00:00:00
12860	8778 So. Silver Spring	\N	London	14	SW8 1XD	E6100000010CB5C46F7460B54940517394238332BFBF	956ce3f8-562b-4209-9a3d-9eabfc075787	2013-09-23 00:00:00
12861	5637 Arbor Drive	\N	Oakland	9	94611	E6100000010C067A267B7CED42408411E9963D855EC0	49c66248-4c4d-46b6-b58f-156d0c25a7db	2012-10-06 00:00:00
12862	9182 Newcastle Road	\N	Milsons Point	50	2061	E6100000010C6BFB70B006F240C0194B598907E16240	57570897-0d0f-48d3-9e7a-7a48935714e0	2012-03-14 00:00:00
12863	6665 Homestead Ave.	\N	Darlinghurst	50	2010	E6100000010C61D7A55C3BEB40C06A821BE8F0E36240	761fa626-e2e2-4b0a-995a-001767743460	2011-10-17 00:00:00
12864	444, chaussée de Tournai	\N	Paris	161	75010	E6100000010C818F1490C266484093206537DFE10240	08ef72ec-ed16-4d07-beeb-457874059c5a	2013-12-21 10:09:29.423
12865	5931 San Carlos	\N	Colma	9	94014	E6100000010C7E77B51F1FDD42403146099E8DA15EC0	526dbce9-328d-4655-8246-81bb881ae041	2012-03-31 00:00:00
12866	9699 Gilardy Drive	\N	Cliffside	7	V8Y 1L1	E6100000010C0FC9CC7A9A3D48408DA167F18ADF5EC0	ed094749-0e5e-457a-9b0b-0bd1f1ef192e	2012-05-27 00:00:00
12867	7172 Parkway Drive	\N	Santa Cruz	9	95062	E6100000010C882B004B80764240BFCB9ECBBD7E5EC0	ce8785d2-7986-464f-b518-1d196217358e	2013-07-12 00:00:00
12868	1226 Canyon Creek Drive	\N	Warrnambool	77	3280	E6100000010C85D8226AEB0743C0D356475255D46140	1b225ffe-c3ca-4630-a266-9053b67533a7	2014-03-22 00:00:00
12869	1873 Mt. Whitney Dr	\N	Westminster	7	V3L 1E7	E6100000010CF536E5C9CCA048406EFA584012B65EC0	cdef611a-5e36-4839-909f-21a9e947b92a	2013-08-14 00:00:00
12870	297, place Beaubernard	\N	Roissy en Brie	163	77680	E6100000010C43E85561B95B484094ED7BF1294A0540	21213389-a529-451e-a5df-a7112217cc72	2013-12-21 10:09:29.423
12871	7986 Terra Calitina	\N	Bellingham	79	98225	E6100000010CCD2DABBCE35748404C12E7120EAB5EC0	899f0651-c57a-4406-a72b-e36ec98c130e	2014-06-14 00:00:00
12872	74, place Beaubernard	\N	Paris	161	75003	E6100000010C3F97B639497548402F100DF1ADE40240	eafd0729-71e5-4ee6-a1de-dcc4ae1106c9	2013-12-21 10:09:29.423
12873	1800 Honey Court	\N	Cliffside	7	V8Y 1L1	E6100000010C03290C5E0E454840A60EA0247DD45EC0	2cd59f9d-9957-47eb-b1d8-2c0bdea4b7d4	2013-07-08 00:00:00
12874	9443 Oaxaca	\N	Wokingham	14	RG41 1QW	E6100000010C6B237A675FBD49409E61FD83F536EBBF	5191c00a-d50c-43a1-8d3e-dfaae844eec4	2013-11-05 00:00:00
12875	9736 Montana	\N	Lemon Grove	9	91945	E6100000010C4CDA0D991D5F4040CE2ABD53D9445DC0	941d0bfa-cd64-423e-90f2-2e89ab9ad0d0	2013-09-30 00:00:00
12876	6104 Santa Maria Ct.	\N	Port Hammond	7	V6B 3P7	E6100000010C25D9C89DD0A94840FB1ABD80DFBC5EC0	655c490a-a856-4aa8-99a1-34e9645d39d3	2013-09-06 00:00:00
12877	7106 Cynthia Drive	\N	Darlinghurst	50	2010	E6100000010CBE6711E3C5F440C0DD3C8267E0E56240	8acd120f-01c8-4408-a794-b8920449b872	2014-04-04 00:00:00
12878	764 Teak Court	\N	Cliffside	7	V8Y 1L1	E6100000010CB1B3A167924248405FE5C06D62DC5EC0	138f2297-9e48-45a7-8b6e-b153c3038577	2013-04-23 00:00:00
12879	8510 G St.	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	b6ab4ca9-fdc7-4d49-bb00-37cbd977e07a	2013-07-15 00:00:00
12880	7386 Rolph Park Drive	\N	El Cajon	9	92020	E6100000010C2560AA8981644040096AEB719C415DC0	bef0d4f0-8ab9-4d2c-8c13-7d28abe36862	2013-10-09 00:00:00
12881	2893 Vera	\N	W. York	14	BD1 4SJ	E6100000010CDBCD4D5103ED4A408D35F09F510BFCBF	d6ee1ea2-e6cb-4b09-ae02-43d2e82eec49	2013-09-10 00:00:00
12882	600, route de Marseille	\N	Roncq	145	59223	E6100000010CE9ECFE95F2604940F1A91EFC3EEF0840	81ae6e6a-5a9a-4e55-9736-a53208e991c4	2013-12-21 10:09:29.423
12883	1832 RiverRock Dr	\N	Bremerton	79	98312	E6100000010C29AF4E4037C24740D320C07AC8BC5EC0	d25c3004-1d19-49fc-b823-227e50226de4	2014-02-26 00:00:00
12884	6850 Monument Blvd.	\N	Wollongong	50	2500	E6100000010C28F52C2E163241C0827AA4647AD76240	c7653319-af57-422c-ace0-eed99efab02f	2013-08-07 00:00:00
12885	5565 Logan Court	\N	Hawthorne	64	4171	E6100000010CE0DC50A7DB7E3BC0A119915294216340	c6e4bb05-c3c7-47f3-a6c8-1356da305d9d	2014-04-01 00:00:00
12886	6999 Icicle Ct.	\N	San Diego	9	92102	E6100000010C41CAF8322D5B4040F0C6788FEF515DC0	3994d866-c907-47a0-ab18-d145d65fb599	2012-08-15 00:00:00
12887	8168 Eaker Way	\N	Hervey Bay	64	4655	E6100000010C55E9665E445439C0826E57517A1A6340	07feb53b-a19c-4512-a664-f44dead849bd	2014-02-19 00:00:00
12888	Hans-Rosenthal-Platz 2	\N	Paderborn	53	33098	E6100000010C580EF21A32E249405A8C4E5A04822140	39e22669-c620-475f-8546-c442e54261ed	2013-10-15 00:00:00
12889	5985 Valmar Dr.	\N	Cheltenham	14	GL50	E6100000010C6DC0B67AF4F24940A2BDCD0182A100C0	bf5fe828-78a5-4a00-a818-6b7cc634d54b	2014-05-13 00:00:00
12890	7559 Worth Ct.	\N	Concord	9	94519	E6100000010C238A8AE60B014340CBD6E9AD4D7A5EC0	6cc77bf5-a349-4530-8d7c-e9bd7dbf8350	2013-06-30 00:00:00
12891	5891 Quail Court	Unit C	Sydney	50	1002	E6100000010CC5413C3897F140C05BDC7C2414E86240	f0a0e708-adcf-4c4d-995d-f7677f481fbc	2011-06-25 00:00:00
12892	Kulmer Straße 6	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	2a47340d-f373-4663-a8bc-87f5f30a5df4	2012-12-21 00:00:00
12893	7426 Forest Way	\N	Rockhampton	64	4700	E6100000010C07BC34A6195F37C0ACB519FD7AD26240	45c4ada5-b665-483e-8d31-09531650d519	2013-11-30 00:00:00
12894	6675 Andrea Lane	\N	Cloverdale	66	6105	E6100000010C391C887AC8F43FC0D43F445D80065D40	01825d99-14a6-45a7-8667-1fb2682af713	2013-07-29 00:00:00
12895	4861 Via Valencia	\N	Concord	9	94519	E6100000010CF883CC6EA4FD42408FEAAEE1BD785EC0	0612910c-f55e-4ba4-8b03-33d686f31529	2011-09-27 00:00:00
12896	3287 Corte Poquito	# 2	Salem	58	97301	E6100000010CDF719BC2587A464069A3618E78B75EC0	19e460c6-60a4-4421-93c3-320edfbab9f2	2014-03-16 00:00:00
12897	8523 Rose Drive	C	Cranbourne	77	3977	E6100000010CDAB75C49BC0F43C0884CDD6CD7256240	1d38ca71-8224-490f-a125-adf5067d6ae2	2013-07-30 00:00:00
12898	4782 Dewing Avenue	\N	Salem	58	97301	E6100000010C46D7FB06EC7A4640B784B9C4C4BD5EC0	799e4675-cfe4-4830-be6c-04553546b194	2013-10-27 00:00:00
12899	8240 Clear Court	\N	Lincoln Acres	9	91950	E6100000010CEBB0B38E54504040CDDDEF8B1A4B5DC0	17eafb98-7bd0-449c-9a28-eff3c9ffc237	2013-11-09 00:00:00
12900	4524 P St.	\N	York	14	Y024 1GF	E6100000010C6E35E1BB2BFE4A40151716256E52F1BF	ba588730-ff8e-4381-a8b1-15b64ba132f8	2013-11-04 00:00:00
12901	2756 Eastgate Ave.	\N	Cranbourne	77	3977	E6100000010CF6CDE7398C1743C0638B006496226240	d799f745-ae07-4529-8c40-03e2f348e564	2013-09-22 00:00:00
12902	3893 San Francisco	\N	Sedro Woolley	79	98284	E6100000010C9AD3A6AAC83F48406B22302DC9855EC0	2eefc239-eb7c-4b9c-bc9e-0f798d92806a	2013-07-15 00:00:00
12903	1461 Dent Way	\N	Wollongong	50	2500	E6100000010CE127A934E22F41C0D5D51BA645DD6240	c7bcf7e1-3e8e-4749-ac23-dfb9a0930e2c	2014-01-29 00:00:00
12904	63, allée des Princes	\N	Chatou	164	78400	E6100000010C7E34778B7F71484097EB57D92C3D0140	afa88afb-7a58-400f-9477-2e540e7e98ee	2013-12-21 10:09:29.423
12905	2265 Park Glen Court	\N	Port Orchard	79	98366	E6100000010C5AF7A9B719C14740955641CE4BA85EC0	1665eb34-f93c-454c-8ab7-ce0cb77b54a3	2014-01-18 00:00:00
12906	8886 Marsh Drive	\N	Port Hammond	7	V6B 3P7	E6100000010C271E0756A9A648406A13CDC7B0C85EC0	75d4d57a-89d6-47ab-8466-8677334949f2	2014-01-08 00:00:00
12907	6456 Eagle Way	\N	W. Linn	58	97068	E6100000010C266C65B029AD464060A11C54E1AE5EC0	a411dbbf-8606-4a7f-ab76-4227054b2b37	2013-06-17 00:00:00
12908	4268 Shadow Court	\N	Beaverton	58	97005	E6100000010C7310FE4E5DBE464057EEF4587DB65EC0	d4e58b4d-0765-4ba2-a35c-54e1a712f9dd	2014-06-17 00:00:00
12909	942 Brook Street	\N	Warrnambool	77	3280	E6100000010C457486955A0A43C077E0A64A24D16140	ca8a4392-255d-449e-8218-45bb78dc3f9c	2011-06-11 00:00:00
12910	1156 Corte Poquito	\N	Yakima	79	98901	E6100000010C7782C089624D47408101A73E97185EC0	1a6c0cc8-7e54-474c-b661-a77854ca0e8f	2014-03-13 00:00:00
12911	942 Brook Street	\N	Berkeley	9	94704	E6100000010CC1BA6DA1DCF442405C8E9CD14F935EC0	1f68883d-d252-4927-a4a5-c0cf1a1e3bf3	2012-03-18 00:00:00
12912	1450 A St.	\N	Burlingame	9	94010	E6100000010C99E3325599CD424052A62EAFFB9B5EC0	01a25613-0bc1-46eb-b02f-d39f68939463	2014-06-22 00:00:00
12913	8810, rue des Rosiers	\N	Paris	161	75005	E6100000010CAC000D28D4694840867F0DB956E70240	0ea91a8f-0c91-4c71-86f4-3bb2ad959927	2013-12-21 10:09:29.423
12914	9019 Class Avenue	\N	Mill Valley	9	94941	E6100000010C339CF85125F94240CE5B9D5A6DAF5EC0	6f9d4c0a-32d0-495f-9473-0e2f1d1bc1af	2012-06-17 00:00:00
12915	Königstr 27	\N	Paderborn	53	33098	E6100000010C5A73638056D94940B9CE2225F37D2140	e9d1992a-9bdc-4af3-998c-6e3b3d307701	2013-11-13 00:00:00
12916	313, rue de l'Espace De Schengen	\N	Sèvres	178	92310	E6100000010C6E357AB79266484053BAC596BAAB0140	a67431a7-22ea-4ad4-b185-9b74bcb6905a	2013-12-21 10:09:29.423
12917	7391 Leslie Avenue	\N	Sooke	7	V0	E6100000010C70D9F224F1384840FBDFF0DA22F55EC0	0e793e93-fb35-48b3-8324-f5af1025a0fe	2013-09-13 00:00:00
12918	342 San Simeon	\N	Marysville	79	98270	E6100000010C15E9C63FFA0D484014B32415FF835EC0	3f8f7574-301f-4164-b71d-4c6cf25fefb5	2013-06-15 00:00:00
12919	1583 Blackridge Drive	\N	Melbourne	77	3000	E6100000010C929105A08BE742C0B7DE2ABAF81C6240	10cfec4d-3809-402f-b518-d146f9f86b39	2011-08-19 00:00:00
12920	4787 R St.	\N	Fremont	9	94536	E6100000010CE54AF012AEC8424064A577FF71805EC0	aef01fbb-5c20-46d2-b48f-5bfa5395e134	2013-10-31 00:00:00
12921	3917 Fern Leaf Lane	\N	Burlingame	9	94010	E6100000010CF1848D38F1C44240724A1FB01D9F5EC0	8331a76a-16ec-4a6e-ad6c-821d34458e41	2014-03-15 00:00:00
12922	6283 San Marino Ct.	\N	Bellingham	79	98225	E6100000010C3E31EC6A1F63484067FA6A9951945EC0	5af1cd6b-95aa-48b0-89ea-6841776bc982	2013-12-27 00:00:00
12923	9741 Forte Way	\N	Lake Oswego	58	97034	E6100000010CF0F27C056AB34640DAAB335DD69F5EC0	9d389f3a-01b3-4275-bfbc-dd5b3fb1b05c	2014-05-09 00:00:00
12924	4147 Alamo Court	\N	Wollongong	50	2500	E6100000010C8032AC62A53141C0CD35966AE4D96240	52877756-6fdb-498a-bc55-f561f0ac282e	2011-10-15 00:00:00
12925	5951 Balance Ct.	\N	Warrnambool	77	3280	E6100000010CA9F7690C680843C0A3EE7D7282D26140	0d15dd7d-a7c2-4a71-b286-ce7be8ba16c8	2014-02-01 00:00:00
12926	515 Wiget Lane	\N	Olympia	79	98501	E6100000010C00A23EB17B7E47402A3ACDD442BE5EC0	8e5f0861-d400-4fbb-ba4a-c55cdfdc1b01	2013-12-24 00:00:00
12927	5174 Filling Drive	\N	Warrington	14	WA1	E6100000010C295AE658E1B04A406D8FA0D3C28B04C0	c9c52e20-f23d-4713-b35b-43e6abac31c1	2013-03-01 00:00:00
12928	1797 Victory Lane	\N	York	14	YO15	E6100000010CF0BD756831F54A40C7015F56E14EF1BF	b01c74e4-3c2c-47a2-8481-cf08c0b6a323	2014-03-30 00:00:00
12929	8939 Monetary Way	\N	Hawthorne	64	4171	E6100000010CE3F135E9646F3BC008525C2EED286340	83b5a7a1-8b6a-4862-8d44-19b5ad039d36	2012-10-24 00:00:00
12930	6242 Cleveland Avenue	\N	Woodland Hills	9	91364	E6100000010CD1E175B45A0E41400A07D6A9B2AB5DC0	1c0ad900-736f-44f4-bfca-7978966be9e0	2011-08-05 00:00:00
12931	1410 N Ranchford Court	\N	Portland	58	97205	E6100000010C0B3D6AC0C3C6464092FC74DD5FB55EC0	586e228e-59ae-4b0c-8a63-a00c19a16c1d	2014-04-02 00:00:00
12932	4144 Tahoe Place	\N	Beaverton	58	97005	E6100000010CD3C0C00B74BB4640FF71FE24A2B95EC0	33745ead-7d0f-4708-89c1-fbf78cb59f3d	2014-04-13 00:00:00
12933	1197 Santa Barbara	\N	Santa Monica	9	90401	E6100000010CF778428434FE4040BB2E780ABAA55DC0	cc54f096-4ca9-4514-beb8-d648ac0b4ead	2013-09-07 00:00:00
12934	523, rue de l'Espace De Schengen	\N	Pantin	179	93500	E6100000010C9004A2224174484097B9EA2EA6400340	561defd0-8ca1-4be0-8f9b-a3f5d1eded90	2013-12-21 10:09:29.423
12935	9314 Icicle Way	\N	Woodburn	58	97071	E6100000010CF82F6CC46F90464040FAF47DFAB35EC0	34096160-90c6-4363-89f1-e7632a19f06e	2014-05-12 00:00:00
12936	7068 Rock Drive	\N	Lavender Bay	50	2060	E6100000010C82E5D22DD9ED40C021310AF4B7DF6240	a773e3a7-0b08-4571-becf-b92a040c27c9	2012-11-17 00:00:00
12937	302 Camelback Ct.	\N	Long Beach	9	90802	E6100000010C1E7E67A9DEDF40405729E281608E5DC0	0eb6c7de-d0d1-4e13-a1ca-4322ed3ae4c6	2014-02-24 00:00:00
12938	7710 Pine St	\N	Burlingame	9	94010	E6100000010C88133C7314CE42407287892D80965EC0	9574aa67-4056-4e0f-980c-108cb3d0afef	2013-06-24 00:00:00
12939	7107 Vista Valley Rd.	\N	Brisbane	64	4000	E6100000010C68424B8CCF733BC08A516A3B5C196340	b2b6d9cb-49a6-4bc9-9c7a-5aceb665e46d	2014-04-27 00:00:00
12940	821, rue des Rosiers	\N	Roubaix	145	59100	E6100000010C2DB5EDFEE35F4940D96AB3FB98740940	639c09a7-5c93-49d0-a4cf-62ceeec257c1	2013-12-21 10:09:29.423
12941	3968 Beauty	\N	Newcastle upon Tyne	14	NT20	E6100000010C9E16B27F53734B406AF6FD054CC4F9BF	fd8d0c44-d65b-460e-8200-cb27152fb9f1	2013-05-25 00:00:00
12942	1362 Somerset Place	\N	Bremerton	79	98312	E6100000010CE8FEEAB2B2C74740F2762C3AB6B55EC0	72cb6453-5f51-43ea-b90c-aa0ddb4222a1	2014-05-22 00:00:00
12943	7772 Golden Meadow	\N	Oakland	9	94611	E6100000010C1E302D3A65EB4240B2E79DAA6C835EC0	2f516d8a-4d63-4f28-8e32-48701fee70c6	2014-04-11 00:00:00
12944	977 Delta View Ln.	\N	Yakima	79	98901	E6100000010C048350C18C5447409DA03BD90C175EC0	482a015b-1518-4007-8ba2-1af579db0e7c	2014-03-23 00:00:00
12945	2472 Alexander Place	\N	West Covina	9	91791	E6100000010C0E1DB1A7FE0D41401C921A2A976E5DC0	8f2d6927-81f0-48d0-92bd-64bc3c8c201e	2013-12-15 00:00:00
12946	8500 Byers Rd.	\N	Port Macquarie	50	2444	E6100000010C5EEC7F0D84563FC00733A5DFC2186340	a70ad6b1-99c4-4005-8837-45bdab270176	2012-10-29 00:00:00
12947	8625 Woodcrest Drive	\N	Beverly Hills	9	90210	E6100000010CC46D031AC50D4140DA82F77F7BA15DC0	c17d5f46-92ac-49ae-b783-b126d280df3b	2014-04-17 00:00:00
12948	623 Lakespring Place	\N	Springwood	50	2777	E6100000010C06AC807824D740C0696310E9ABD26240	a8fc4f11-4370-45c1-94b2-52a60e163453	2013-07-04 00:00:00
12949	8585 Los Gatos Ct.	\N	Lynnwood	79	98036	E6100000010CFA44A505E3E9474074F6680E9B9A5EC0	e084a851-d085-405e-9b6f-a5f7f7867895	2014-02-20 00:00:00
12950	336 E Eagle Peak Rd.	\N	National City	9	91950	E6100000010CEBB0B38E54504040BA6EF4CD1B455DC0	c7f504ed-4b93-4069-931b-dd651e06a8e6	2014-03-15 00:00:00
12951	6703 Corte Poquito	\N	Beaverton	58	97005	E6100000010C13603B9246C14640E5DECE28EAA95EC0	ff2d4952-8f64-489d-ac65-17870273de5e	2014-04-01 00:00:00
12952	9854 Martindale Drive	\N	Berkeley	9	94704	E6100000010C34518385BEE842408546695039975EC0	fd61dd67-fde3-4e63-8470-3f577278bd4e	2012-05-26 00:00:00
12953	1363 Mount Circle	\N	Royal Oak	7	V8X	E6100000010C11BD6CC7DE37484030527F3306D75EC0	5fcd0795-3b43-4d68-af4f-b0f40a3a9faf	2012-05-11 00:00:00
12954	65bis, boulevard Saint Germain	\N	Saint Ouen	127	41100	E6100000010C534B1A5798E14740E3F568EF505FF13F	ea1e7b5f-fdf7-4c70-a55c-dbdf5b58f5a1	2013-12-21 10:09:29.423
12955	7985 Center Street	\N	Chula Vista	9	91910	E6100000010CB67DBA493C4E4040A36C05128F4F5DC0	10746821-4b00-4103-9ff9-2682e31f07df	2013-09-26 00:00:00
12956	3748 Bellwood Dr.	\N	Newcastle	50	2300	E6100000010C039D9AFF857640C09DBE8442F7F76240	70d12bc9-b6bf-4d30-a49d-0d6e0f5ea21b	2012-08-13 00:00:00
12957	2899 Cimarron Drive	\N	Yakima	79	98901	E6100000010C98D82103895747409A73333C711C5EC0	239af39c-5471-4cdf-8bad-56997715fff8	2013-11-09 00:00:00
12958	5979 Lynwood Drive	\N	London	14	W1X3SE	E6100000010CE22CB56F31BC494039F4347C514AC0BF	d5c9604d-b604-41d0-9f37-20b5886c342b	2013-05-11 00:00:00
12959	2431 Keith Court	\N	Renton	79	98055	E6100000010C5B1DEFF611B94740243323B37C835EC0	50d656ca-ff81-459f-9e8f-5ce52ac2c191	2013-05-14 00:00:00
12960	84, rue de la Centenaire	\N	Villeneuve-d'Ascq	145	59491	E6100000010CD544E2E4194B4940E99A2DFD092E0940	332a1ddc-a2f8-4135-9106-199c48ddba4a	2013-12-21 10:09:29.423
12961	Zollstr 62	\N	Saarlouis	70	66740	E6100000010CF08ED2B3049F48401E9B096F17F91A40	7ad4c566-e176-4439-a787-44e5bab58d0e	2014-02-21 00:00:00
12962	41 Third Ave East	\N	Portland	58	97205	E6100000010CA429F4F45AC0464036D4BE7161AA5EC0	753412b8-9004-4b57-b6ce-788090d592b3	2014-05-22 00:00:00
12963	46, rue Surcouf	\N	Orly	180	94310	E6100000010C3DA7CD6674634840ECB45E6EA22D0340	502432ef-3bb1-4ff8-bb74-2fceb71bcfce	2013-12-21 10:09:29.423
12964	9704 Pineknoll	\N	Melbourne	77	3000	E6100000010C433EDF56FFE842C0992F07B242196240	b1e8945e-b2b9-4625-8105-2352286c3290	2013-08-13 00:00:00
12965	Am Gallberg 94	\N	Hof	8	95010	E6100000010C4B5F74F4C0224940EBE00AFA9FD72740	806bf1c1-c77c-4b8a-ae5c-f49491259d0c	2012-05-22 00:00:00
12966	5462 Patricia	\N	Melbourne	77	3000	E6100000010CD30CA84A52EE42C018DB648700236240	10c09d79-ad10-440a-a5dd-f63b0ec0904f	2013-02-21 00:00:00
12967	8158 Pheasant Court	\N	Novato	9	94947	E6100000010CBD031651E80A434079B1AF8DF5A15EC0	4b4e464c-7ea3-4776-9ce4-17219480e378	2014-03-18 00:00:00
12968	9610 Moccasin Ct	\N	Bellingham	79	98225	E6100000010C608733759E6548407A253CB8FFA35EC0	bb1f526d-0788-4dc7-9e9a-316fae155a1f	2011-12-13 00:00:00
12969	6490 El Camino	\N	Coronado	9	92118	E6100000010C0E63ED8BFE5A404030D556356C4B5DC0	666fe684-fca1-4477-b163-790a6b5224a0	2012-03-30 00:00:00
12970	3594 Vista Del Sol	\N	Newcastle upon Tyne	14	NT20	E6100000010C1E85F94AEB844B40BB354B2E86CFF9BF	58af3409-6851-46eb-9e5b-9db87eec9ab4	2013-10-05 00:00:00
12971	9440 Oakshire Place	\N	Oregon City	58	97045	E6100000010C8A48F1479DB04640D7CC7F9FCF965EC0	920d355f-0667-424c-83ab-82928159e48b	2013-04-14 00:00:00
12972	682 Ambush Dr..	\N	Shawnee	7	V9B 2C3	E6100000010CF438103CFA3B48409B3ED0DCB3E75EC0	d68854c7-712b-404e-97f8-28614673e89f	2014-05-31 00:00:00
12973	3429 Fourth Street	\N	Oxon	14	OX16 8RS	E6100000010C00000000000000000000000000000000	a50d7458-5278-4ae7-be2e-2fbb2426e18c	2013-03-05 00:00:00
12974	3886 Valencia Place	\N	Ballard	79	98107	E6100000010C24BEA9372ED94740561C642B93945EC0	7d7e310f-7225-4a55-a75b-66affd43bb76	2014-04-18 00:00:00
12975	8840 D Crane Ct	\N	Victoria	7	V8V	E6100000010C12A87F0A683C48403279FE287CCB5EC0	6a84fc86-a5c3-4ae4-bc9a-2c7a473ac329	2013-09-22 00:00:00
12976	3245 Vista Oak Dr.	\N	Port Orchard	79	98366	E6100000010C1E3D79C3AABE4740116E8D4AE19E5EC0	3499a501-4b10-4487-9312-383ca58fcd7f	2013-07-07 00:00:00
12977	1617 Crossbow Way	\N	Colma	9	94014	E6100000010C9364348B55D74240D1971980A29D5EC0	c6b756b2-df8b-47ec-8e51-b034e607667d	2012-03-16 00:00:00
12978	7008 Mines Road	\N	Newcastle upon Tyne	14	NT20	E6100000010CC57150ED957E4B402EDBBAB9CED4F9BF	6e169129-221e-498d-a2d3-935d790d62df	2014-04-04 00:00:00
12979	896 Southdale	\N	Beaverton	58	97005	E6100000010C546A331909BC4640EDF507F1C6BC5EC0	051044c9-7841-41dc-b8eb-8cba007c5b8e	2012-11-17 00:00:00
12980	3585 Holly Oak Dr.	\N	Goulburn	50	2580	E6100000010C4E4FCCC7894741C016B88491F1B86240	de61d269-9e71-4fef-9817-e1eb1e874819	2012-11-15 00:00:00
12981	5809 Mount Aire Parkway	\N	Lake Oswego	58	97034	E6100000010C669D119BC3AE464098194960E7A65EC0	a8dcbab0-f693-4bf8-adba-ebc73d710705	2013-11-08 00:00:00
12982	2685 Blackburn Ct	\N	Long Beach	9	90802	E6100000010C2841939776E24040BEAD628FB2965DC0	cc829a6b-0ac2-41ec-92ec-1deafb7133a6	2013-05-31 00:00:00
12983	509 Lynwood Drive	\N	Spokane	79	99202	E6100000010CD8224D8D6FDE47409C7768F1675E5DC0	bdd559d9-4788-473c-b8f6-53e8a05a64ac	2013-09-11 00:00:00
12984	1502 Marion Ct.	\N	Coffs Harbour	50	2450	E6100000010C4CE7FCD723313EC0F0121AF3721F6340	c4ccc017-1b4d-40ec-b548-21847d5c35c7	2013-03-23 00:00:00
12985	4197 Ironwood Drive	# 1	Fremont	9	94536	E6100000010C13E7B0CAE4CF42402C78B092527D5EC0	916662aa-71f3-4cff-82e6-b288eeb05849	2014-05-28 00:00:00
12986	356, avenue des Laurentides	\N	Les Ulis	177	91940	E6100000010C8D2503367B594840CB998042744E0140	c8126875-6ddc-4c79-ab94-1e0c105f7dbd	2013-12-21 10:09:29.423
12987	2275 Valley Blvd.	\N	Berkeley	9	94704	E6100000010C3DFED48B60F44240E1CD216D0D8D5EC0	2cf017a6-8d17-4a07-b4ef-81ec3cccb830	2013-04-29 00:00:00
12988	3788 Gordon Ct.	\N	Cliffside	7	V8Y 1L1	E6100000010CB0030276D83E4840D4CA46A8A5D75EC0	9a00f8d9-9914-4b82-b311-58dc0bf6e633	2014-05-28 00:00:00
12989	99, route de Marseille	\N	Saint Germain en Laye	164	78100	E6100000010CA40FED6CDA7C48407F29EC6894C80040	976b379b-3579-4609-9edb-fab2f541d7e2	2013-12-21 10:09:29.423
12990	3302 Trujillo	# 112	Oak Bay	7	V8P	E6100000010C0D5CDFC5C62F4840897CAC7E5ED05EC0	5f01ac9f-5a84-4793-a772-a6b74f35697a	2014-01-25 00:00:00
12991	3753 Shenandoah Drive	\N	Oxford	14	OX14 4SE	E6100000010CFBC3DA3729D549402C53E653E581F4BF	884c1947-6c68-4409-904e-301a15b47ec2	2013-09-18 00:00:00
12992	2082 Satin Court	\N	South Melbourne	77	3205	E6100000010C2DF4FBABCAE442C00B0B0F3F421E6240	7ec13e93-b7f7-45f6-a4e8-ab153647440b	2011-10-16 00:00:00
12993	3597 Pine St.	\N	Sedro Woolley	79	98284	E6100000010C3331C4E4BF444840105DFFE9317D5EC0	105f0e7d-441e-4baa-9150-2fe6c7c7570a	2014-03-11 00:00:00
12994	4838 Second Street	\N	Coronado	9	92118	E6100000010C9F4458CDE158404056C178226D3F5DC0	b2e43a46-f517-4202-9cb8-15e0ae44ca39	2012-10-30 00:00:00
12995	835, avenue des Laurentides	\N	Paris	161	75019	E6100000010C0ED3DCDBAC7948408EA3FD74F11A0340	b2f4d0fc-289a-419b-a38a-b045be4894c7	2013-12-21 10:09:29.423
12996	8042 Placer Dr.	\N	Colma	9	94014	E6100000010C7E77B51F1FDD4240BF4A8F5B41A65EC0	f7767be6-7d30-4b47-8916-3e9be0b95f94	2014-03-09 00:00:00
12997	9537 Ridgewood Drive	\N	Daly City	9	94015	E6100000010C127A03C0C7DD4240BEB92C8C7C995EC0	6174a5ce-8958-4da1-890f-672c435d3cc9	2014-03-04 00:00:00
12998	5652 East View Place	\N	West Covina	9	91791	E6100000010C88E203A9810A41405C5ABBD06A7B5DC0	6ce2fc06-4d6a-42be-9e6f-45cd703577a4	2014-02-18 00:00:00
12999	7401 Las Palmas	\N	Langford	7	V9	E6100000010CF4F60B73414048403AF1DC32DEE05EC0	cf523b81-a6cb-45b2-9701-198021567d07	2013-11-09 00:00:00
13000	3770 Viewpoint Ct	\N	Everett	79	98201	E6100000010CBBBB7B282801484001954D1199915EC0	e9e8e213-b6ff-4bef-a34f-ee32e343c972	2014-01-14 00:00:00
13001	4091 Hill Meadow Pl.	\N	Newcastle	50	2300	E6100000010C23C61B38E57940C05DF0DA8B9FF26240	cadd765c-2779-467a-9fb8-532c09707aae	2011-07-24 00:00:00
13002	8429 East Narrows Drive	\N	Puyallup	79	98371	E6100000010C8F15A007A69247401A17770465965EC0	1dd88586-1fad-4809-8556-290dddd43cdd	2013-11-08 00:00:00
13003	9860 Brookview Drive	\N	East Brisbane	64	4169	E6100000010C2959B127EF7A3BC007E9F2355E1F6340	5395b838-14dc-4e3e-89c3-83089f8543a1	2012-03-17 00:00:00
13004	5051 Teakwood Dr	\N	Port Macquarie	50	2444	E6100000010C581E62CEFE683FC04B0383D41E1F6340	7ff6f83a-654d-4111-a849-5403bcaa8c93	2013-02-22 00:00:00
13005	2119 Little Dr	\N	Beaverton	58	97005	E6100000010C64BD183433BD4640AB180F8A22BF5EC0	039ed3cc-243e-4128-92a9-55729fde6e9c	2013-07-09 00:00:00
13006	9964 North Ridge Drive	\N	Burien	79	98168	E6100000010C5DEA7A4194C047400E6C3972528A5EC0	7c38eebe-3597-45fc-8bca-7eeadff53fb5	2013-11-05 00:00:00
13007	9497 Candelero Place	\N	Downey	9	90241	E6100000010CF5A3840CF8F84040F508099BCF905DC0	f8fa6871-843a-48ca-8ac0-0a64d8135fc1	2014-01-07 00:00:00
13008	4665 Military Way E.	\N	Port Hammond	7	V6B 3P7	E6100000010C515904B09DA148402FA455D115BC5EC0	e9a36433-7760-4489-aae4-9f3e9d296b88	2014-05-05 00:00:00
13009	1828 Robinson Ave.	\N	Concord	9	94519	E6100000010CB304A9ADFCFE4240E17B8317BB7B5EC0	0e114a29-6cba-4ddf-8ce9-3698bd2cbcd9	2014-03-18 00:00:00
13010	3448 Sun View Terr.	\N	Colma	9	94014	E6100000010CF9A22914DAD6424073EBEC40119C5EC0	cb9c52fe-ca8b-44e1-95c6-2fa357bded1d	2013-11-19 00:00:00
13011	4451 Larkin Dr.	\N	San Carlos	9	94070	E6100000010C594D9A2E8AC54240BBA30C7B99925EC0	05eb8dd2-dbab-40ad-a22c-6a730feecb5d	2011-10-11 00:00:00
13012	4222 San Jose Dr.	\N	North Sydney	50	2055	E6100000010CB041905E53EE40C0FE24E7158BE86240	eba75cc0-69e8-4ca7-adf5-b46355e24a68	2012-05-09 00:00:00
13013	Waldstr 21	\N	Stuttgart	70	70511	E6100000010CADC1A19A7A604840CAFB907B385C2240	30bb8a61-e50a-4e5c-be0b-0550529016d1	2013-08-24 00:00:00
13014	2529 Clear Court	\N	Beverly Hills	9	90210	E6100000010C6364F90B060C4140E291B2475B955DC0	e860edab-13d1-4ded-8d0f-bb02fb3cfd83	2013-08-18 00:00:00
13015	5225 Harbor View Dr	\N	Milwaukie	58	97222	E6100000010CA4309BD3D1B1464058C170A16DB15EC0	b17468af-ccdc-4207-a7f0-12fdf2a77327	2013-09-06 00:00:00
13016	Wertheimer Straße 822	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	e4e27372-c309-4d96-93c2-0eeeeafb8c55	2014-05-27 00:00:00
13017	Am Grossen Dern 9824	\N	Ingolstadt	8	85049	E6100000010CAB241306EC584840AA30966FA6A72640	ff52bfe5-ea31-44ce-a1cc-4da33968fee7	2014-04-16 00:00:00
13018	Heiderplatz 918	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	5813b6f4-a438-4b45-b52d-d3a917f750ed	2013-01-20 00:00:00
13019	93, impasse Ste-Madeleine	\N	Paris	161	75007	E6100000010CC1C9913C36644840A5C2511F017E0240	6c7014bf-d626-4657-aa6d-4a9997464881	2013-12-21 10:09:29.423
13020	5092 Crane Court	\N	Watford	14	WA3	E6100000010CC0F9D88B8DC949406D7A89152803D9BF	2425cc7e-2f94-41b6-95b0-7fc072b0ebb4	2012-12-22 00:00:00
13021	8296 Glen Court	\N	Vancouver	7	V7L 4J4	E6100000010C446AA5F78BA34840201E47B174BB5EC0	17a211ba-aa4d-40f0-a688-e22378235e30	2014-01-27 00:00:00
13022	345, rue des Grands Champs	\N	Saint Ouen	127	41100	E6100000010C8238BEDF40E8474092FD1E3CFDE9F23F	3059dd52-7052-4521-9f32-bae46989d815	2013-12-21 10:09:29.423
13023	9791 Harvard Court	# 4	Tacoma	79	98403	E6100000010C6A2191FF04A7474002EB3964FF9D5EC0	45a7c5fa-7313-4d13-bc54-906b9ce3beff	2014-02-18 00:00:00
13024	5906 Walnut Place	\N	Royal Oak	7	V8X	E6100000010CFC2A6C3F0236484092A638D02EDA5EC0	d36ccf65-3157-4730-8c23-8b8a29823d87	2014-03-25 00:00:00
13025	7655 Greer Ave	\N	Fremont	9	94536	E6100000010C390B28E00BCC42404134D4FDE8855EC0	0f4344cd-2cc3-4455-81f7-806dbb5cd4e8	2013-12-27 00:00:00
13026	2228 Ashford Court	\N	Lavender Bay	50	2060	E6100000010CCFE08B4C6AED40C0F66A376AA7E16240	d31b1874-5129-4290-adeb-aab4bc06c938	2011-11-23 00:00:00
13027	4024 Montana	# 113	Westminster	7	V3L 1E7	E6100000010CF0169D450FA24840489BA3FDA4B75EC0	f1b8f7ae-f466-4eca-9983-cb59fb4ffbdb	2014-05-14 00:00:00
13028	7430 Ravenwood	\N	North Ryde	50	2113	E6100000010CE351E14CE6E840C00A19AD0ED4E16240	7394faba-cfee-4aa9-b2be-b99069ec76e3	2013-05-29 00:00:00
13029	8683 San Antonio	\N	Grossmont	9	91941	E6100000010C0B72E9F6466340405BDA320046465DC0	67a1e4d5-885e-43dc-9af5-8d6af05b263a	2014-05-30 00:00:00
13030	9830 May Way	\N	Mill Valley	9	94941	E6100000010C5805C95379EE4240AA92D15C2B9E5EC0	16d368fd-8c4b-4346-a984-a344fcf96436	2014-03-30 00:00:00
13031	7400 Robinson Street	\N	Victoria	7	V8V	E6100000010CE62FB14FDE314840A346882B39DF5EC0	9e2ed636-fdaa-4efd-bc04-d0acb67cb08d	2013-11-12 00:00:00
13032	Bundesallee 4424	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	54664e83-1570-48ad-b660-40a5a4e16f44	2013-02-06 00:00:00
13033	4277 La Cruz	\N	Port Hammond	7	V6B 3P7	E6100000010CF02748B48DA848406A13CDC7B0C85EC0	416ab203-5cd8-41da-9dc9-2cd5c057f11f	2014-02-02 00:00:00
13034	8874 Dallas Drive	\N	London	14	W10 6BL	E6100000010CFE37C89A94C74940AD997A7FA5FCCBBF	6719314e-326d-4e20-861e-c685e69e3497	2013-07-13 00:00:00
13035	1887 Mt. Diablo St	\N	Seattle	79	98104	E6100000010C52B340978BD4474056DA914EDB8E5EC0	9a509bc4-0178-464a-aa48-ec1c2db09652	2014-01-05 00:00:00
13036	9963 Pacific	\N	Ballard	79	98107	E6100000010CC40169DC02DB4740BFA767AE5B955EC0	68a3edc3-116c-450c-970f-d374b71d4ce7	2011-06-11 00:00:00
13037	8222 Northridge Road	\N	London	14	SW6 SBY	E6100000010C3668BDD9BDC64940F218AA8B5140C0BF	3e678960-3153-4d94-a2a8-efefad28a16b	2013-04-30 00:00:00
13038	7499 Yolanda Circle	\N	London	14	EC1R 0DU	E6100000010C18D6044DF9BE49403EA174834323BBBF	ac114564-f921-4764-9c89-a165802cc15f	2013-07-07 00:00:00
13039	2288 Gingham Way	\N	Beaverton	58	97005	E6100000010C43C468E3B4B946409185DF8D6AAF5EC0	3ef8c6b1-2191-49f6-beed-da5e741a1a34	2012-12-08 00:00:00
13040	5 Curletto Dr.	\N	Mill Valley	9	94941	E6100000010C995757814BF44240AE13F82B36B05EC0	c528de36-c024-4610-ad47-d3b507b7410e	2013-05-19 00:00:00
13041	2823 Pheasant Court	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	7365e3c1-895a-4cb3-a62f-f7e8cbf48c2d	2013-07-14 00:00:00
13042	8335 West Hook Road	\N	Edmonds	79	98020	E6100000010C07F3C9E4FCEE474076F453B9578F5EC0	b4129260-1918-462b-8a3a-6c9f12638067	2013-12-19 00:00:00
13043	321 Concerto Circle	\N	Lake Oswego	58	97034	E6100000010C33B3353DA5B846408F87F86079A85EC0	01214e97-6af0-4230-aff7-5dcc3675c94a	2013-11-22 00:00:00
13044	2527 Mohawk Drive	\N	Sooke	7	V0	E6100000010CDABC8EEA39354840BCC526DFE1E65EC0	f7452537-1978-439f-a860-261cf858a4f8	2013-08-15 00:00:00
13045	8306 Sun Tree Lane	\N	Silverwater	50	2264	E6100000010CED0FE3CE879540C0929B4E5708EF6240	10d9f14b-66cb-4bf4-a1b7-f43426961373	2013-07-13 00:00:00
13046	2487 Riverside Drive	\N	Melbourne	77	3000	E6100000010CF5EAB80D73EA42C06BEF5B0513226240	b232fcd0-6dfd-4d2b-852a-c446a7c993f1	2013-09-29 00:00:00
13047	5731 La Mar Ct.	\N	El Cajon	9	92020	E6100000010CDBE1926E2F664040E141A1C9DC405DC0	daf6ac4b-1811-4465-9ece-7d95547d1c40	2014-05-03 00:00:00
13048	7227 Landing Terrace	\N	El Cajon	9	92020	E6100000010CE4A7C00F106C4040721957211D405DC0	307a7a51-7edc-4a0c-97f5-6a4fb69ba737	2014-05-24 00:00:00
13049	686 Argonne Drive	\N	Geelong	77	3220	E6100000010CA534AC5BBE1243C035A724EBC2086240	64f5e52b-4b52-4958-99ac-58128526aca1	2011-10-05 00:00:00
13050	5091 Laurel Dr.	\N	Renton	79	98055	E6100000010C44B610F6DAB74740B4C79B8E9D865EC0	5f653ba9-36b1-4706-8400-9bc093933e31	2013-08-26 00:00:00
13051	Am Kreuz 4065	\N	Darmstadt	19	64283	E6100000010C71744DA5C0E7484079649199134F2140	ac58267a-9e27-460b-a0bb-4eaac98a4726	2012-12-20 00:00:00
13052	1459 Placer Dr.	\N	Salem	58	97301	E6100000010C0E50D4F3FD6F4640BA3FFF3EF0CB5EC0	e4901b5a-b025-46d5-ae79-c81a8bc43fb7	2012-05-14 00:00:00
13053	Kalkweg 25	\N	Hamburg	20	20354	E6100000010C66F09587B4C04A408F5D2F5DE2FB2340	ca348675-ba2c-477b-8ed7-72064746c13f	2014-04-22 00:00:00
13054	1977 Sun Rise Drive	\N	Hervey Bay	64	4655	E6100000010CDA053577EA5439C0297B866B691D6340	407557d3-5b96-47be-a68b-9ca824f0b128	2012-11-29 00:00:00
13055	2741 Orangewood Dr.	\N	Long Beach	9	90802	E6100000010CF0B24EC383E84040295656F1598B5DC0	7f92c186-1bdd-4d45-9570-afbcde16a911	2014-04-21 00:00:00
13056	7859 Green Valley Road	\N	London	14	W1V 5RN	E6100000010CC8A1D31B37BA49405B74BB899141C0BF	c7f3377b-be45-4f04-8379-d8dd229ed416	2014-02-17 00:00:00
13057	7654 Heather Pl.	\N	Walla Walla	79	99362	E6100000010CBAD70F7F6405474067B2ADECCE905DC0	28b0ae36-453b-4810-8e4e-b4fc264dee5e	2013-08-26 00:00:00
13058	7186 View Dr.	\N	Lebanon	58	97355	E6100000010CD8551FEF524146404FF8146E06A85EC0	9bc1dc9e-2d67-4382-ad88-53c90d36223a	2012-07-24 00:00:00
13059	2354 Frame Ln.	\N	Los Angeles	9	90012	E6100000010C51CBC09205074140C8679AC1C0995DC0	47c82bba-7e05-438c-9dc8-5fd9a930b0ce	2014-05-25 00:00:00
13060	2141 Delaware Ct.	\N	Downey	9	90241	E6100000010C0858337DD6F94040AF211670AA7E5DC0	a1a34b3d-e3a0-4372-a2c3-1395d73e45ca	2013-07-13 00:00:00
13061	9218 Old Mt. View Drive	\N	Hobart	71	7001	E6100000010CB766080A3F6B45C06E25DE918D696240	e2428abc-e4b1-4a89-a133-144c5cc1c758	2011-12-15 00:00:00
13062	3704 Panoramic Drive	\N	London	14	W1X3SE	E6100000010CBE3B378AD4BE494016AB062CFC46C0BF	bd61b335-8555-474d-8916-45d894206234	2013-11-16 00:00:00
13063	3880 95th St.	\N	Beaverton	58	97005	E6100000010C64BD183433BD464053CBEDBF21B45EC0	ef1445b1-8736-4646-bbe9-a7628a71d10b	2014-03-28 00:00:00
13064	9996 Solano Drive	\N	Burlingame	9	94010	E6100000010CCA832019A3CC424039BA5CAC95925EC0	b9bdf572-3c8e-4290-80ad-a1b1b44844ab	2013-12-14 00:00:00
13065	8521 Knewal Rd	\N	Matraville	50	2036	E6100000010C7724F09F1D0041C091AEFBCDB7E36240	4a11b600-2a32-4f05-9019-0f4c5c4f87f6	2012-01-24 00:00:00
13066	782 West Way	\N	York	14	YO15	E6100000010CD371CD7D58124B40ADD245A0954BF2BF	8a383c75-69ee-4086-ac83-08ba3f5710a1	2013-09-01 00:00:00
13067	2 Fall Creek Road	\N	West Covina	9	91791	E6100000010C5F4F2C4A7407414098B1A6F82B7C5DC0	ae87b298-6135-40c1-815a-f776367c29ac	2013-12-02 00:00:00
13068	259 True Drive	\N	Santa Monica	9	90401	E6100000010C746EDD084D0441401B8F8F9BC2A85DC0	6bbdbf54-d14b-4e22-b134-e3ee63beec3c	2014-05-22 00:00:00
13069	1246 Newport Drive	\N	Spring Valley	9	91977	E6100000010C1EFC460B416040401E33ED63093B5DC0	c1dd03b0-083e-4fb0-b7ca-71398645d514	2014-03-20 00:00:00
13070	2, route de Marseille	\N	Roncq	145	59223	E6100000010CC223B2C2176849406FC0A881E8F60840	86700b0e-9191-45a0-a84c-0c4e7838ded3	2013-12-21 10:09:29.423
13071	1540 St. Raphael Drive	\N	Metchosin	7	V9	E6100000010C9D6E098E052D4840EEF9667044DE5EC0	31757276-a05f-46ee-bd9f-6a0cdcaf1594	2013-08-21 00:00:00
13072	2781 Cresent Dr.	\N	Versailles	164	78000	E6100000010C5C7BE88EEF6748406B311156C9F60040	27dcab2c-d699-4f90-ba4c-16beca22b348	2013-12-21 10:09:29.423
13073	Postfach 2 66 66	\N	Solingen	53	42651	E6100000010C50D2B0586B9C4940ECE8D92293661C40	3d327668-5650-4d3f-ba68-ba9d28c155c7	2012-12-28 00:00:00
13074	5985 Bouncing Road	\N	Lakewood	9	90712	E6100000010C0822FE8836F24040F9FD4A9AB4945DC0	5a1fd931-6c03-43bb-b4d5-836b01c347cc	2014-03-15 00:00:00
13075	8309 Colonial Way	\N	Lane Cove	50	1597	E6100000010CC58B71EC00EA40C08D195DCEE1E56240	faa9cd14-6a1c-4adc-8a72-fb5048ac881d	2014-01-12 00:00:00
13076	7481 Crown Ct.	\N	Bellflower	9	90706	E6100000010C04789095EDF54040C6DF827B9F925DC0	c1f4ed1c-d5dc-4076-a416-fb747cfd5371	2013-07-16 00:00:00
13077	Alte Landstr 991	\N	Berlin	19	14129	E6100000010C5696768AE22F4A4080C71AA837652A40	436d48f9-917e-484a-bc52-bf29692a3538	2011-12-28 00:00:00
13078	3595 Santa Fe	\N	Novato	9	94947	E6100000010C3C19B192AF1343401E10852F29AC5EC0	385ae9d1-734a-43d7-a985-9b49e4b39b0b	2013-09-17 00:00:00
13079	081, boulevard du Montparnasse	\N	Seattle	79	98104	E6100000010C3091CBA41BD247409FEA9D6940985EC0	ee51d99c-8ee2-442c-8141-33d7553b0414	2013-12-06 00:00:00
13080	11, rue Descartes	\N	Versailles	164	78000	E6100000010C0BC6C24DCF69484097DE3EF58BEE0040	0bf3e1a2-89bd-4281-91a1-38d66c36f0fe	2013-12-21 10:09:29.423
13081	Am Karlshof 6883	\N	Darmstadt	19	64283	E6100000010C2562D04335F74840AE20DB130E502140	a76d10f1-5bd8-4e44-9ac0-3f20fb0ce03d	2014-05-27 00:00:00
13082	Heideweg 1442	\N	Werne	53	59368	E6100000010CB8782F6670DD4940A4C1B2DE74801E40	aa7ed078-570a-44e6-97c7-9dde0aebebe3	2013-04-11 00:00:00
13083	5615 Rock Oak Road	\N	Metchosin	7	V9	E6100000010CF46E813C6839484068082A0B86D95EC0	bde27ab2-8ee9-4465-8196-34a4b82a2855	2013-10-17 00:00:00
13084	275 South Ranchford Ct	\N	Melbourne	77	3000	E6100000010C2BA7DA93B4E242C0306560C689226240	7dd74116-18a6-4084-af9c-a313bc6e6d77	2011-11-07 00:00:00
13085	7611 Kim Court	\N	London	14	EC1R 0DU	E6100000010CFEE5B53ED8CA49403BE58AB5B51DBBBF	40992eb9-6a3f-46f8-b667-39972c831f04	2013-07-21 00:00:00
13086	6897 Pome Court	\N	Portland	58	97205	E6100000010CE24716DFD9C04640C7F9EEE151AF5EC0	89fa9a90-d6d9-4503-b54d-61134eae9c80	2013-08-20 00:00:00
13087	1811 Cashew Lane	\N	Port Hammond	7	V6B 3P7	E6100000010C85C546E107A64840C3B8D7A191D05EC0	8d89f993-fb93-4fa5-b43e-e19c35e703ed	2013-08-23 00:00:00
13088	135 Grant Street	\N	Townsville	64	4810	E6100000010C70DF0C83043733C0F4CC8A34F9566240	3c0cb102-74fc-4a9f-9393-a883533e5415	2013-09-20 00:00:00
13089	1343 Prospect St	\N	Marysville	79	98270	E6100000010C1C6B5B4D840B4840AFB614F977895EC0	a1d79dd8-9384-4a0e-96b6-7f6ac2f9e2c8	2013-11-02 00:00:00
13090	6510 Hacienda Drive	\N	Imperial Beach	9	91932	E6100000010C1D3ED248004940402F325B50534E5DC0	0010f44c-98e9-411c-a12b-c8eb0731f50e	2014-04-11 00:00:00
13091	1288 Vista Del Rio	\N	Coffs Harbour	50	2450	E6100000010CD3122519CA243EC0C8999E895D236340	7b576702-542f-4abf-960d-2af3ef857ee9	2013-07-09 00:00:00
13092	Am Karlshof 75	\N	Ingolstadt	8	85049	E6100000010CC590A953A7664840E10307B701B52640	310dfba2-9982-439f-80ca-80702d2e2f90	2012-10-29 00:00:00
13093	6296 Elmonte Drive	\N	Oregon City	58	97045	E6100000010C52701BF821AD464033FC432EC5AC5EC0	818753b6-dc78-46e9-8c59-9f2519142421	2012-06-27 00:00:00
13094	Zeiter Weg 2264	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	edec0fbf-58b1-49b2-8418-24a74fd1d832	2013-09-22 00:00:00
13095	7070 W. Watson Court	\N	Yakima	79	98901	E6100000010CE1826C33C25247409A73333C711C5EC0	76c2c6fb-1f63-40ea-ae4d-ef4ce1ff0640	2013-12-10 00:00:00
13096	Herzogstr 5772	\N	Offenbach	70	63009	E6100000010C19D1BD0F5D044940929C13F8B6862140	a35f049b-0f3a-4bdb-bcf3-d649047f8c55	2012-11-10 00:00:00
13097	5402 Panorama Drive	\N	Glendale	9	91203	E6100000010C980A644F2D16414086E934B053995DC0	facca100-a111-4715-89e0-299430f1e78e	2013-09-12 00:00:00
13098	2279 Pineview Lane	\N	Bellingham	79	98225	E6100000010C183081DB605F48407A253CB8FFA35EC0	b04f2725-6fe3-4b6a-9af7-645763ab3b7a	2014-05-17 00:00:00
13099	7644 Browning Place	\N	Newcastle upon Tyne	14	NT20	E6100000010C9308B88866814B40A50190F4A2C3F9BF	571c7141-8d41-488b-81c7-16126d1bf709	2013-08-31 00:00:00
13100	8352 Turning View Cricle Drive	\N	San Diego	9	92102	E6100000010CAE9DBE9D1B5E4040D61D15E9AF4F5DC0	4da36744-ce87-48a1-90c3-6ebbae465481	2014-01-17 00:00:00
13101	Postenweg 4642	\N	Solingen	53	42651	E6100000010C5A4A60B4B28C4940965010AFC1681C40	443c1883-4d14-4ebb-92ac-ae2133777679	2014-02-18 00:00:00
13102	70, rue de l´Esplanade	\N	Tremblay-en-France	179	93290	E6100000010CAC58649903814840F8825BDD40760440	bf221243-65c8-4fcf-a2d6-64002bfff941	2013-12-21 10:09:29.423
13103	4010 Willow Pass Road	\N	Goulburn	50	2580	E6100000010C236083C9C04941C03FEDB7316CB96240	467ad1c3-a5ac-4636-9f12-81d5338f54b8	2012-06-18 00:00:00
13104	6937 E. 42nd Street	\N	Downey	9	90241	E6100000010C12B28AB545FA4040752FDCCCD5935DC0	255d5add-7dc1-4f5f-83b1-7b362952e4b8	2014-05-08 00:00:00
13105	Kurfürstenstr 5094	\N	Berlin	20	14111	E6100000010CC92DC855823E4A4044AD2BDF65BE2A40	37e56977-39fa-4980-8c2c-6365c8573e9c	2013-08-22 00:00:00
13106	2798 Castlewood	\N	Marysville	79	98270	E6100000010C0E67323270104840BBBE84E131955EC0	3ad6f70f-dc9e-47c0-abe4-c8b141b4e9d5	2011-11-02 00:00:00
13107	4293 Concord Ct.	\N	Everett	79	98201	E6100000010C4F4D16BDA0FB4740CE75EF9F15855EC0	9bfa94b4-bb31-487f-b85a-1b266dfd4023	2013-11-08 00:00:00
13108	Klara Straße 8463	\N	Bottrop	53	46236	E6100000010C65160CBF39BB49401070542BC8B01B40	48911ddb-4f84-459d-b9ee-c7e17c032494	2013-04-30 00:00:00
13109	7751 Lunar Lane	\N	Oregon City	58	97045	E6100000010CD1F9A2BA08B04640796611A433AB5EC0	ef7af851-9c89-4777-a40d-bad6a16f2b34	2013-10-06 00:00:00
13110	2157 Clark Creek Lane	\N	Daly City	9	94015	E6100000010C748B6C5755DC42404AECA611D0A65EC0	0fec675a-68a0-485f-9dff-a499a5b7fa8c	2013-09-02 00:00:00
13111	5869 Heights Avenue	\N	Walla Walla	79	99362	E6100000010C023D009292064740B3CC1582818B5DC0	a6f5eba5-8ec2-4639-b10a-eb0ebb00bf45	2013-12-26 00:00:00
13112	3356 Eastgate Ave.	\N	Colma	9	94014	E6100000010CB7E749794CD84240D1971980A29D5EC0	6d0385d6-f9c8-49a9-842a-526a3f587712	2014-02-28 00:00:00
13113	529 Leewood Place	\N	Imperial Beach	9	91932	E6100000010C6523FA05164B40408AAF44A7134C5DC0	4d4be9c0-6149-415c-a6af-f66adfce88f7	2013-06-09 00:00:00
13114	9494 Buena Vista	\N	East Brisbane	64	4169	E6100000010C63B0C28060833BC06B7C5053D6206340	1851ee93-a705-4aee-95b6-b743f4135f47	2014-01-24 00:00:00
13115	7151 Corte Bonita	\N	Kirkby	14	KB9	E6100000010C33636508AEB54A40B9C65F0A512107C0	1ac97bd6-7e8c-48ec-8a10-49e919700869	2014-04-20 00:00:00
13116	Wasserstr 64	\N	Saarbrücken	70	66001	E6100000010CEEF7BE54CE94484039467F8E19061C40	f37289ed-4d9c-462e-96c8-213e95242207	2013-07-10 00:00:00
13117	Pascalstr 756	\N	München	53	80074	E6100000010C00000000000000000000000000000000	0c7e8e39-ff0c-44c5-9983-2e144308b048	2012-05-17 00:00:00
13118	Viktoria-Luise-Platz 473	Verkaufsabteilung	Berlin	70	14197	E6100000010C8C60BF7F2C374A405FAD9B9588A42A40	46a34b4f-08a9-400a-8b68-4dea920befef	2013-07-20 00:00:00
13119	2515 Beauty St	\N	Hobart	71	7001	E6100000010C88D2C12EDC6645C06E868C4629706240	8dfcb488-6590-489d-94d5-16a0b29d5bd6	2013-11-20 00:00:00
13120	4720 Black Pine Lane	\N	Los Angeles	9	90012	E6100000010CFFD437BEFF0D41409B6C56513D985DC0	33e21d62-1517-4229-8690-08e941b0958d	2014-04-08 00:00:00
13121	311, rue Villedo	\N	Bobigny	179	93000	E6100000010C0134CA11887348406765D677E4820340	49a78cf9-6fd5-4c2a-9127-1d15c47c2d0c	2013-12-21 10:09:29.423
13122	9568 Gold Crest Ct.	\N	Hobart	71	7001	E6100000010CE7FA4EE5A16F45C0B0B0D1BB14696240	95b13987-b406-4ac5-8dc7-d227a80ff05a	2013-03-28 00:00:00
13123	1597 Vista Del Sol	\N	Newton	7	V2M1P1	E6100000010C28CE7FEDD0FE4A40DAEFB1B279A65EC0	458f7ad0-ba9e-4360-b236-6124d5e93e00	2013-12-28 00:00:00
13124	511, rue Villedo	\N	Dunkerque	145	59140	E6100000010CAF0586327F8349406008A0D874D10240	91ff7556-d77b-46b5-bff3-f525af7017c4	2013-12-21 10:09:29.423
13125	9206 West Rd.	\N	Everett	79	98201	E6100000010C2542C53B9D034840B7FEBA2482955EC0	48b4f45c-0f8e-45c7-9236-abb0e291da7c	2013-02-22 00:00:00
13126	7284 Adobe Dr.	\N	Edmonds	79	98020	E6100000010C2738BA0B27ED47401B955DB8E8905EC0	c26a5f09-4f17-4669-a916-3b798c16958d	2014-02-25 00:00:00
13127	9903 East Lane	\N	Beaverton	58	97005	E6100000010C43C468E3B4B9464057EEF4587DB65EC0	145eb4df-b8a2-4e8c-86eb-81cd961dc6aa	2013-07-27 00:00:00
13128	7324 Mt. Tri-state Ct.	\N	San Diego	9	92102	E6100000010CCF8D52CB565A404090E5F306F04E5DC0	64e38423-17d4-4be7-af15-1355ecaa62fc	2014-06-20 00:00:00
13129	5656 Via Delaware	\N	Sedro Woolley	79	98284	E6100000010C04C4AF1D793648407C3DDFA3088C5EC0	c4cc3355-10d5-4136-9a00-4f78f6d31128	2011-06-28 00:00:00
13130	215, avenue de la Gare	\N	Saint Germain en Laye	164	78100	E6100000010C2BD9BEA5B26F48408298A8D328CB0040	256af51f-60a3-4dc8-8294-37c88b95999c	2013-12-21 10:09:29.423
13131	6, rue des Vendangeurs	\N	Croix	145	59170	E6100000010C5A10D091155C4940998A1ED0853E0940	bad076ac-97c5-4ee4-8d2b-afbd9a4d7eaa	2013-12-21 10:09:29.423
13132	3244 E Eagle Peak Rd.	\N	Port Hammond	7	V6B 3P7	E6100000010CE7F602DD179F4840B8F65A3E06C05EC0	e30dce1e-beaf-4cce-a971-9ea0db51b509	2014-01-13 00:00:00
13133	219, rue Descartes	\N	Les Ulis	177	91940	E6100000010C72C4C1BE61514840DAA7F8B400520140	e427916e-b360-43c5-9314-f3de93e8430f	2013-12-21 10:09:29.423
13134	6448 Castle Court	\N	Chula Vista	9	91910	E6100000010CA4B1C996A14F40406E36D8041C4A5DC0	d2af90ca-cc24-42b7-b4ab-99cabc1e1738	2014-04-27 00:00:00
13135	5278 Tanager Court	\N	London	14	SE1 8HL	E6100000010C6797461288C749409F36277016E3BABF	fd682ca1-4bc1-4037-938c-97f3b646041f	2013-10-04 00:00:00
13136	7943 Walnut Ave	\N	Chula Vista	9	91910	E6100000010C732F7975484C40407C0AA703E9405DC0	f08ed6c5-3070-480c-8788-f3bab4e31eeb	2012-06-25 00:00:00
13137	26, rue de l´Esplanade	\N	Chatou	164	78400	E6100000010C0379F720837B484014ADDAF752380140	e968cf0c-5e30-4532-b809-4e892305952b	2013-12-21 10:09:29.423
13138	7 Churchill Dr.	\N	Corvallis	58	97330	E6100000010C771D7528464E464065D5DE174BD65EC0	16d230d4-f5ae-42a5-803a-aeba80b59569	2013-12-26 00:00:00
13139	476 Bay Drive	\N	Hobart	71	7001	E6100000010CFDFF58D34F6645C039FE214FD3756240	d280a720-7b6e-484f-93fe-56e13057282e	2014-02-02 00:00:00
13140	7725 Camel Pl.	\N	Townsville	64	4810	E6100000010C644D54967A3933C04BE8CF67DE506240	5eded7ad-8660-4bfc-aa1d-377ecab73bc5	2014-01-28 00:00:00
13141	6834 Violetta	\N	York	14	YO15	E6100000010CDEEB2861A5F84A4074DCC3585153F1BF	a0e01f64-1fbd-4d6e-b63a-c70d4395a6c6	2013-12-06 00:00:00
13142	8612 Pembrook Court	\N	Perth	66	6006	E6100000010C8322D371DBED3FC08204C728CD015D40	c78027e6-ac7a-40a8-aafb-e4e0d14a46b2	2013-05-20 00:00:00
13143	3457 Bel Air Drive	\N	Redwood City	9	94063	E6100000010C1D95CCFA9FB74240ED0F4348AF815EC0	8e6f8bc8-23f0-412b-a7e4-671c52fd9dfd	2013-12-05 00:00:00
13144	8370 Birchwood Dr	\N	Imperial Beach	9	91932	E6100000010C3C00AFC7D5494040CCAA175594475DC0	18710a60-79f2-4144-89ca-16b310a1592a	2014-05-04 00:00:00
13145	2257 Gate Drive	\N	Silverwater	50	2264	E6100000010CB2CBD25FF49540C038C0A46984EF6240	b8feb99b-11ce-4cca-8899-b7412dfaa652	2012-08-02 00:00:00
13146	Hauptstr 6057	\N	München	53	80074	E6100000010C00000000000000000000000000000000	927a18e4-6e9d-4db7-84f8-4ed6f2291910	2013-08-29 00:00:00
13147	7902 Grammercy Lane	Unit C	Santa Cruz	9	95062	E6100000010C6EC52FDA3B7B424049A51C4E9E7B5EC0	e5af4ce0-d122-4986-98c2-33be04651e8a	2013-05-09 00:00:00
13148	3070 Sahara Drive	\N	Gold Coast	64	4217	E6100000010C105197E4FFFC3BC0DC2A38FD922B6340	34908eb7-f31f-4825-9f22-53e6fc8bd408	2013-07-01 00:00:00
13149	934 Acardia Pl	\N	Watford	14	WA3	E6100000010C1A26F96467DB4940B4553BDA320AD9BF	6d1c330c-deef-4dee-9e51-dfb22a58e1ef	2014-01-30 00:00:00
13150	975 Madrid	\N	Concord	9	94519	E6100000010C5D90485E73044340B787D5DE8C805EC0	029ff8e0-6abd-46ef-8e66-e9d38c163d92	2014-05-14 00:00:00
13151	494 Crown Court	\N	Bendigo	77	3550	E6100000010C97EF286FD86242C074141860D50F6240	9c415e91-5133-4920-8acd-b4f3a87d96e8	2013-10-30 00:00:00
13152	1962 Ferndale Lane	\N	Lemon Grove	9	91945	E6100000010CCB798BCA7A6240405AF299067E4D5DC0	09c5985e-84f1-4545-8618-8b9e60d5d0fe	2011-12-05 00:00:00
13153	4912 Mellowood Street	\N	Sooke	7	V0	E6100000010C16ECB39C45304840138C9893EDF55EC0	25baddb5-8a41-4e0f-9534-68a6ed8f84ae	2013-10-09 00:00:00
13154	8361 Flora Ave.	\N	Runcorn	14	TY31	E6100000010CA238A13A91A74A4032E0DE075FAE05C0	6d9ba44b-6245-4f38-97a1-c35fc0ad96d1	2014-03-23 00:00:00
13155	Zimmerstr 11	\N	Erlangen	8	91054	E6100000010CF2A65784ABD648406099622825102640	7d233ec9-6c21-41d5-acd3-fb2707ce55bd	2012-03-19 00:00:00
13156	6702 Smiling Tree Court	\N	Burbank	9	91502	E6100000010CBD80AFB885124140D0EB11B9269C5DC0	c4f053f2-c5d6-48d9-b30c-e4d8aaa75a6f	2014-06-16 00:00:00
13157	97 Hermosa	\N	Salem	58	97301	E6100000010CA657B940E47D464072FD68743DC95EC0	c18462f1-ae3a-4c98-b928-d366f855057a	2011-10-08 00:00:00
13158	Bundesallee 7576	\N	München	53	80074	E6100000010C00000000000000000000000000000000	5b0df73c-3807-453a-9079-f6ef75047beb	2014-01-05 00:00:00
13159	4312 Cambridge Drive	\N	Billericay	14	CM11	E6100000010C7BA28D4CB4C84940C4FD8CA54EB5DA3F	2abaa781-6dd6-40a2-a4d4-7c79687b9a82	2013-08-08 00:00:00
13160	6061 St. Paul Way	\N	Everett	79	98201	E6100000010C81C80E4F120648401EEF0B6C408F5EC0	f3d9e9a9-dc2f-4323-bc3e-fdce3b4ea85b	2011-11-18 00:00:00
13161	6307 Greenbelt Way	\N	London	14	W1Y 3RA	E6100000010C1CDDDB85C3C44940B9184C24FC4BC0BF	5a22130f-284d-48bd-ac53-350c11860919	2014-05-25 00:00:00
13162	8065 Sand Point Road	\N	Matraville	50	2036	E6100000010CBA272B5BAEF540C0927879FEF1EB6240	8ee517bc-5858-49b1-9914-d20120aa7d92	2013-07-04 00:00:00
13163	2430 Santa Lucia	\N	Lebanon	58	97355	E6100000010CC4725B08064746404D7C261D2BAB5EC0	5d2c89aa-9fde-4ec9-b8a0-046fcb53597e	2014-03-19 00:00:00
13164	80, avenue des Champs-Elysées	\N	Villeneuve-d'Ascq	145	59491	E6100000010C7F1A2BE6734A4940BF595A443D280940	d1b2b44f-b676-4d5c-b2b3-2b93149c497c	2013-12-21 10:09:29.423
13165	3711 Rollingwood Dr	\N	Redmond	79	98052	E6100000010C81F95CC0C9CE4740DF504FDE93875EC0	df75d543-526a-40f6-8e5a-bb0ee94d3449	2014-05-07 00:00:00
13166	8624 Valley Blvd.	\N	Newton	7	V2M1P1	E6100000010CB91168E276F44A40BD01C5B930B65EC0	59d58022-512b-48b7-8c60-d6da4bf06ad6	2013-12-30 00:00:00
13167	7614 Heron Ct	\N	Gold Coast	64	4217	E6100000010C737F3F6195003CC0F330BAB0022F6340	6206c059-e192-43fb-8180-4899659b68fb	2013-09-19 00:00:00
13168	5980 Icicle Circle	Unit H	Lincoln Acres	9	91950	E6100000010CC77B3532595540400793751E9C435DC0	93606df6-1a5a-48da-bd65-ec617131a5f3	2014-05-21 00:00:00
13169	4500 Willow Dr.	\N	Oxford	14	OX14 4SE	E6100000010CBCB3F8A196CA494062AC83FA8484F4BF	d8a7cc7e-5275-4b48-aba3-4171d93c90f0	2011-08-20 00:00:00
13170	5766 Newcastle Road	\N	Milwaukie	58	97222	E6100000010C0888A0EA3CB14640BECF18134AAE5EC0	57b8d5fa-b578-412f-8abd-c3aaf67f8d8d	2013-05-27 00:00:00
13171	7869 Sea Point Way	\N	Newcastle upon Tyne	14	NT20	E6100000010C66A69C9F2D7D4B40F7C8B54BF0C6F9BF	78d94fc2-3b28-4570-b3a1-75f3cc13b3dc	2013-12-18 00:00:00
13172	Welt Platz 6	\N	Saarbrücken	70	66001	E6100000010C8F5B269E5397484013630EEC3F081C40	19c398c5-32b3-4ab7-87b2-0e18e61fd8a5	2012-11-10 00:00:00
13173	5090 Pepper Way	\N	Beaverton	58	97005	E6100000010C320606C89AC34640FB7DCCF520A95EC0	8bbb3ff5-8a02-439f-bddc-abfe475c9515	2011-12-11 00:00:00
13174	7 Olive St	\N	Olympia	79	98501	E6100000010C2BF8A8D6797B4740C00ECBBFADB15EC0	7cc63303-608a-4b10-b3a6-aa7065d43a91	2014-04-26 00:00:00
13175	10bis, rue des Peupliers	\N	Les Ulis	177	91940	E6100000010CCB8C5B373C584840D2A0BC7B3A500140	771fa182-e04a-49a2-947e-7a501de64a24	2013-12-21 10:09:29.423
13176	8869 C Olivera Rd	\N	Leeds	14	LE18	E6100000010CD71427C950E44A40E26EE1D4C2BCF8BF	e3644340-9cdc-4a07-9d85-266db4d8762e	2012-09-26 00:00:00
13177	9068 Muir Road	\N	Los Angeles	9	90012	E6100000010C5A64801B900D41409F7B8A00B3935DC0	5623192d-5345-42d6-8667-c4af9cf67f04	2011-10-07 00:00:00
13178	211bis, rue des Peupliers	\N	Saint-Denis	179	93400	E6100000010CEB9DCE07086B48403AA48204CEA50240	64748be4-b13d-4022-bc8b-162a336abce7	2013-12-21 10:09:29.423
13179	3514 Sunshine	\N	Kirkland	79	98033	E6100000010CC24197288ED04740D02ED48FCA8C5EC0	868a5834-1d2c-4b0c-81a9-34e9c419b818	2014-04-22 00:00:00
13180	2578 South Creek Drive	\N	Findon	66	5023	E6100000010C0D9DEF15847641C0548B3B1129516140	5237bb6d-02a4-4416-ad5e-1e2678b45f98	2013-09-14 00:00:00
13181	5009 Orange Street	\N	Bremerton	79	98312	E6100000010CE8FEEAB2B2C74740C834EFF223B45EC0	9db5da4e-6c8c-4655-a75d-307913565793	2013-07-13 00:00:00
13182	2538 Stafford Ave	\N	Sunbury	77	3429	E6100000010C1BCC8CEAC8C342C0727CDEB3CE166240	10d40e44-4792-4115-ba26-6d310f455fa7	2013-11-04 00:00:00
13183	8467 Clifford Court	\N	Kirkland	79	98033	E6100000010CDCEF9FFB6FD54740BF537D7230845EC0	68f58b0d-78a8-40aa-b51d-b1b9088dac77	2013-08-20 00:00:00
13184	Pflugstr 8515	\N	Frankfurt	19	60323	E6100000010C1848DA9904184940CF3EFD5CC1522140	87b4348e-c5a4-49cd-9b8a-b4cdacd936b5	2014-03-17 00:00:00
13185	4461 Centennial Way	\N	Burlingame	9	94010	E6100000010CDC5317FB27CC42405F166CAB738F5EC0	d3d231a7-74b3-4515-b342-a1b17ce6193e	2012-03-29 00:00:00
13186	9241 St George Dr.	\N	Edmonds	79	98020	E6100000010C6A1C4C1C4EE04740BDE70834F5975EC0	67ef2963-4000-4fe5-8426-44deab54cf53	2013-11-02 00:00:00
13187	Höhenstr 9479	\N	Berlin	70	14197	E6100000010C434B2F8E80364A40E64D8CE143982A40	8c66a3a7-d7ce-4659-b5f1-49ded245566b	2013-07-20 00:00:00
13188	5165 Wintergreen Court	\N	Orleans	131	45000	E6100000010CF41B055BECF04740032C268B8A8BFE3F	6fb03631-ccff-44c4-97b1-16e2f1f82f79	2013-12-21 10:09:29.423
13189	1245 Clay Road	\N	Walla Walla	79	99362	E6100000010CD63FA7629F034740B1762D97ED9C5DC0	dc1a9495-afdf-4e7f-ad39-e4c9751e1a9c	2013-12-04 00:00:00
13190	524 Sea Point Way	\N	Leeds	14	LE18	E6100000010C18D351C6BDDC4A4016902E7EB1B7F8BF	44c9fe44-c62e-4e64-8d07-d51043e8483e	2013-01-03 00:00:00
13191	55, avenue de l´ Union Centrale	\N	Saint Ouen	127	41100	E6100000010C059A6E1338ED47408583FD395057F13F	85d6fc76-40cc-473a-a0a3-862a2912d1d0	2013-12-21 10:09:29.423
13192	5436 Clear	# 101	Wollongong	50	2500	E6100000010CE127A934E22F41C0E49E431134DF6240	f8151e48-a704-4320-814e-8e2de9015301	2011-09-21 00:00:00
13193	2313 B Southampton Rd	\N	Yakima	79	98901	E6100000010CDFD8E91E1E5B4740B2E5BF394B205EC0	d578f924-526d-4272-a543-7ff7348f2084	2011-12-26 00:00:00
13194	600, avenue des Laurentides	\N	Tremblay-en-France	179	93290	E6100000010CD921C78A0786484023EB8BA9376A0440	8393324c-9493-4a83-b013-73636fa6f034	2013-12-21 10:09:29.423
13195	137 Lancelot Dr	\N	Issaquah	79	98027	E6100000010C0DF1300120C847402686FC4B217D5EC0	c81904b2-0e42-4ed7-8d19-862547701ebf	2011-11-11 00:00:00
13196	Klara Straße 22	\N	Hannover	53	30601	E6100000010C00000000000000000000000000000000	cb906673-dd5e-46ff-8109-545490452578	2013-09-01 00:00:00
13197	1870 Holland Circle	\N	Cloverdale	66	6105	E6100000010C934D56DF9AFE3FC02A6A2F0B35F35C40	d747ce24-e569-4f43-83dc-f801008898e4	2013-03-04 00:00:00
13198	9922 Hawthorne Dr	\N	Bremerton	79	98312	E6100000010CB44E87252ECD4740E68A5BB211AD5EC0	9df159a6-9fc5-457f-ab7d-c6be0ea4834d	2014-06-08 00:00:00
13199	6834 Violetta	\N	Sydney	50	1002	E6100000010C65BF40AE5AE940C0CDD4A93D56E06240	f15d709a-a79a-457f-ba20-58fcac82f3da	2014-01-29 00:00:00
13200	8000 Crane Court	\N	Bellingham	79	98225	E6100000010C71598489025B4840DA69295E45AA5EC0	b5d0d2d5-9c6c-4c14-a75a-b7c85ea557f0	2013-11-06 00:00:00
13201	5636 Mt. Whitney Dr.	\N	Berkeley	9	94704	E6100000010C2E6B137313EE4240E156C51BEB9B5EC0	843c4487-e936-4456-bf6d-c34a660dc87d	2012-06-29 00:00:00
13202	1584 S. Forest Hill	\N	Roncq	145	59223	E6100000010C15A2755664694940A2CB6D44BDFA0840	a2526fd8-8534-47e4-9c02-44919b2ffbb3	2013-12-21 10:09:29.423
13203	8040 Erie Dr	6 Monteira	Beaverton	58	97005	E6100000010C3459EBE2C4C44640696AEB8C58B35EC0	3e46bf4d-c7a3-45d3-83b5-daffb602d4d6	2013-09-28 00:00:00
13204	9027 Alan Dr	\N	Cliffside	7	V8Y 1L1	E6100000010CF6B07B48A54A48400187ED2BCEDA5EC0	e4ebe7e6-5972-4589-996a-bdd2aeb67b27	2013-11-06 00:00:00
13205	Pascalstr 4	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	4aa85a3c-da35-4f28-9b7c-ef3086824cd5	2012-08-07 00:00:00
13206	9322 Driving Drive	\N	Olympia	79	98501	E6100000010CE14DA0E5457A47401BEC7A6EE4B05EC0	c5d33ee0-ebf5-4b91-99f5-6464467e13e6	2013-09-22 00:00:00
13207	564 Greenwood Place	\N	Chula Vista	9	91910	E6100000010CDA6D46E27A554040831A83E1A0395DC0	4a5238b6-83e5-4eb4-835e-7c006ce11dbc	2013-11-10 00:00:00
13208	3768 Door Way	\N	Oakland	9	94611	E6100000010C7DE30195B8F04240A56FCB21FD845EC0	e2904e08-1643-4702-ad48-93dd39b08a92	2014-06-14 00:00:00
13209	Am Kreuz 999	\N	Ingolstadt	8	85049	E6100000010CDC2854D038654840476B782F34D92640	313bb243-551a-4d02-8971-cd22b1fe68fa	2014-01-03 00:00:00
13210	5263 Etcheverry Dr	\N	Berkeley	9	94704	E6100000010CEA190FDF7FF0424048E62B1E18945EC0	3dd03bea-0cd3-455e-9ddc-cc5e7185c331	2014-03-08 00:00:00
13211	1378 String Dr	\N	Salem	58	97301	E6100000010C98071DD4A57C464003ABCB80E5B55EC0	ffeb8433-29cb-4b89-bfda-d22aab428002	2014-01-08 00:00:00
13212	3127 El Camino Drive	\N	Milwaukie	58	97222	E6100000010C25D3857725B44640AEC844DADBAF5EC0	394d90eb-7b55-4a04-906d-88caa6ea7066	2013-10-08 00:00:00
13213	9495 Limewood Place	\N	Burlingame	9	94010	E6100000010C14257BFCFAC342405821E32F559E5EC0	5b43dc1e-e4c6-4354-bf81-0b79ba500c90	2013-10-14 00:00:00
13214	4155 Star Dr	\N	Long Beach	9	90802	E6100000010CDB2CF7E653E34040064B79951B8C5DC0	1dd04cdf-5989-4626-b063-004d0b19c7d3	2013-08-11 00:00:00
13215	Auf den Kuhlen Straße 765	\N	Kassel	19	34117	E6100000010CA3F0DB6D28A7494051CA74A0EEF42240	d8a02fb6-0462-489e-895d-4d0f5dc98583	2014-04-12 00:00:00
13216	Heiderweg 4983	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	67b6944f-6bc1-415a-91d7-4c566bdbabcd	2012-11-01 00:00:00
13217	778 Kingsford Dr	\N	Woodburn	58	97071	E6100000010CC13BF8A92B9246400899A18944BA5EC0	bf5888c1-6f6f-44d0-92e5-41decaa14380	2013-10-23 00:00:00
13218	5691 Coldwater Drive	\N	Oakland	9	94611	E6100000010C790F35586DEA4240658229056A955EC0	c8fe1b5d-f512-4304-931a-6948a230c41d	2014-03-21 00:00:00
13219	7255 Virginia Hills Drive	\N	Issaquah	79	98027	E6100000010C3994284C65BE4740021D4A86D0815EC0	463d77e4-427f-4731-8674-29b2d8d7cd4f	2013-10-08 00:00:00
13220	2423 Garland Drive	\N	Burien	79	98168	E6100000010CB1BAA0EF70C54740B172F68DAB8C5EC0	64ac66c7-2ea3-440c-bd5a-7eb21b90cf3a	2013-08-07 00:00:00
13221	287 Firestone Drive	\N	Salem	58	97301	E6100000010C0E50D4F3FD6F46406288EE3DFBBC5EC0	72d1fb27-4b90-49bf-850c-2075b6c9bd8b	2013-11-15 00:00:00
13222	Kulmer Straße 3646	\N	Berlin	70	14197	E6100000010C96AFE98832384A40F4068455BABA2A40	86cd18d6-4ea9-44b0-8872-2534d7e797fb	2013-07-11 00:00:00
13223	2983 Carlisle Way	\N	Palo Alto	9	94303	E6100000010CFAE464DDA7BD42408178425339935EC0	8bd765d6-1ba2-47cd-a696-b659772f449c	2013-10-25 00:00:00
13224	1315 Norse Drive	\N	Victoria	7	V8V	E6100000010CDFC9698572374840A346882B39DF5EC0	594ead9c-33e8-4822-a0e0-95549630c114	2013-11-07 00:00:00
13225	6473 Clay Way	\N	Peterborough	14	PB12	E6100000010C0AAE3DFF0E4E4A4094742EF3A402D0BF	683f3cf2-0b03-4a21-b0ca-9c2c0dd074a9	2013-07-07 00:00:00
13226	111, rue Maillard	\N	Versailles	164	78000	E6100000010C5B5B77CB8E6D48402590C7467CF50040	27c80cf4-2bbd-494b-914a-47f54c0d4a16	2013-12-21 10:09:29.423
13227	4265 Boxwood Dr	\N	Beaverton	58	97005	E6100000010CD3C0C00B74BB4640414FF78B46B75EC0	c3da592a-8a77-4613-aac9-92cea8f424ca	2014-05-20 00:00:00
13228	2850 D Bel Air Dr	\N	Cliffside	7	V8Y 1L1	E6100000010CBE5362841E3B4840ED377FDB97CC5EC0	4a24553b-1386-491d-9159-01c5e8e3ac94	2013-09-26 00:00:00
13229	6055 Broadway Street	\N	Beverly Hills	9	90210	E6100000010CFF4CE068A8074140515D119507A65DC0	e0f7c1df-d876-4f23-be54-140939d29ba7	2014-04-18 00:00:00
13230	7550 Carzino Ct	# 1	Seattle	79	98104	E6100000010CCC2A6CCDCBCA474080362C6FC5925EC0	e5c88f87-e736-4643-abb4-fe968b69fd8e	2013-09-04 00:00:00
13231	3664 Ravenwood	\N	La Jolla	9	92806	E6100000010C97E05F2B98F040403AB0A881046F5DC0	508914df-a989-4a7d-bda0-3110d7370d2e	2014-02-17 00:00:00
13232	5414 Camel Place	\N	Lynnwood	79	98036	E6100000010CE130EFB4A9E8474010B051BF2B9C5EC0	4819e83b-d7a0-4b0f-a716-4d0e8847adcf	2012-06-25 00:00:00
13233	Platz des Landtags 33	\N	Frankfurt	19	60323	E6100000010C0ACFCD0B8A104940A6CF759B68502140	07820c0e-8383-4708-a0cc-ae881f7d593d	2013-04-08 00:00:00
13234	1880 Birchwood	\N	Matraville	50	2036	E6100000010CDE7AAE33A3FC40C0C7274F564CE16240	234dc106-997d-47e2-9912-82ddbf872112	2013-08-07 00:00:00
13235	2110 Elm St.	\N	Malabar	50	2036	E6100000010C20A68DFDE5FA40C09C5DBD1976EB6240	242e2bdc-c11f-4f6a-90e2-dbcedc056a50	2013-07-24 00:00:00
13236	Potsdamer Straße 939	\N	Frankfurt	19	60323	E6100000010CA2B5EB0970304A4053EA4774E50B2D40	d040a79e-caf7-4fdb-a634-3ce411963739	2014-03-06 00:00:00
13237	7350 Pine	\N	Lane Cove	50	1597	E6100000010CC58B71EC00EA40C05B9CBFF17EE26240	d591b558-ae4e-454e-a37c-ed98587c210e	2013-10-05 00:00:00
13238	740, allée des Princes	\N	Cergy	181	95000	E6100000010CDB658EBD08884840DEB746930B7F0040	13f91485-0f3d-46b3-b188-6d265ce3f9fd	2013-12-21 10:09:29.423
13239	6441 Kathleen Drive	\N	Portland	58	97205	E6100000010CF3823C947BCD464040F323105EAC5EC0	fe682001-e4c4-4c11-b7af-a98b248463f0	2012-10-15 00:00:00
13240	3064 Fern Leaf Lane	\N	Burlingame	9	94010	E6100000010C2294F2823BCA42407F4088B1D0A35EC0	735a09da-ba85-4163-84c4-dcf7fcc42d6a	2013-08-08 00:00:00
13241	7833 Cook Pkwy	\N	London	14	W1V 5RN	E6100000010C0BB896C32BBE49408B8640D0264BC0BF	364e54ae-c842-4e35-bb53-3ca82aba2c46	2013-06-20 00:00:00
13242	1971 Cleveland Ave.	\N	Bendigo	77	3550	E6100000010CD103185A056842C08E0A888EFC0D6240	0923b7b9-4da3-452a-be14-2870130c5a20	2013-03-08 00:00:00
13243	188, rue de Cambrai	\N	Versailles	164	78000	E6100000010CF01EC0B52E6E48403A3DF5E53EED0040	65c4ddf0-9843-4916-bd78-e3b618e6f285	2013-12-21 10:09:29.423
13244	7509 San Cristobal	\N	Cliffside	7	V8Y 1L1	E6100000010C603E377116404840D4CA46A8A5D75EC0	16a9bc2c-0417-47e7-876d-1d17e64ad6c9	2013-09-24 00:00:00
13245	5333 D St.	\N	Fremont	9	94536	E6100000010C4C5E769ABEC24240C2F7922AD5805EC0	a56537e2-21ab-4212-ae7d-8cd8b4b59571	2012-08-26 00:00:00
13246	70, allée des Princes	\N	Boulogne-sur-Mer	148	62200	E6100000010C5242BE0830574940BACA4CAF06B5F93F	b8c09f8c-cef3-4b39-a294-5fcd2ed82b58	2013-12-21 10:09:29.423
13247	5119 Valley Run	\N	Yakima	79	98901	E6100000010C0CD891CB5E504740842EAFDB32135EC0	3aa2d49f-53eb-46f7-a37c-00e760c0107a	2013-08-26 00:00:00
13248	3197 Winterglenn Way	\N	Westminster	7	V3L 1E7	E6100000010C82576E7076954840B6DC3878CABA5EC0	2188cb19-f856-4ef9-b2ad-aa12c2d604e4	2013-08-26 00:00:00
13249	3237 Meager Dr	\N	San Francisco	9	94109	E6100000010C0F31D1FB0FEA4240E2F1DAA72C8F5EC0	8c90a390-d24a-432b-a664-99c89f367289	2013-03-19 00:00:00
13250	1569 Eagle Ct	\N	Concord	9	94519	E6100000010C758F76DFF6034340FD9A19C223895EC0	cde77d62-2161-4f87-a89c-bd17ae643354	2014-04-30 00:00:00
13251	333, rue de Linois	\N	Orleans	131	45000	E6100000010CA6EDA84359FB4740F65221286A9AFE3F	675c2931-af4e-4b39-8840-b912b5f363e8	2013-12-21 10:09:29.423
13252	4519 Lydia Lane	\N	Stoke-on-Trent	14	AS23	E6100000010CA2C94E5692794A40FDDAB9D49C6A01C0	b8210ac4-57f5-4fd0-a459-6d6b60a797a1	2012-06-11 00:00:00
13253	5760 Las Palmas	\N	Kirkland	79	98033	E6100000010C37884794B5D94740DE17573751875EC0	11d539d7-99c6-43b6-be56-c958fee42692	2014-03-26 00:00:00
13254	47, rue de Linois	\N	Les Ulis	177	91940	E6100000010C0EFACAC2A44D48404E9D1E5F574F0140	da00d854-38ff-4513-bfb9-c7d72d05ee20	2013-12-21 10:09:29.423
13255	8964 Sanford St	\N	Royal Oak	7	V8X	E6100000010C68EC705785454840B9A5C3458DDC5EC0	a70356fd-d3e2-4799-8bec-d8976f6f38be	2014-03-30 00:00:00
13256	243 Pine Dr	\N	Matraville	50	2036	E6100000010C48DB154B55FB40C0421AEC60A7E56240	fce11c28-ab1a-4b96-be28-d0f173c6ed31	2013-07-27 00:00:00
13257	460 Skyline Dr	\N	Royal Oak	7	V8X	E6100000010C31686BDF86334840EA4F209421DE5EC0	9b2fe137-9cf7-4403-93bf-79ff84388bb6	2013-09-28 00:00:00
13258	6306 Manila Ave.	\N	Hobart	71	7001	E6100000010C5C28E689156F45C061830314F86A6240	3a90443f-2a22-4c3e-a234-206c84a8181c	2014-01-16 00:00:00
13259	Zeiter Weg 9963	\N	Erlangen	8	91054	E6100000010C5C1ADE7125CD4840BA7C9A5AAD072640	afcbbf3c-4f09-4745-98a8-eb4421994e32	2012-08-13 00:00:00
13260	7820 S. Rising Ave	\N	Spokane	79	99202	E6100000010C5323BE4300D04740B2917DDF46615DC0	7b793706-9091-48bf-a4e4-aafd11880e92	2014-04-25 00:00:00
13261	879, rue des Ecoles	\N	Pantin	179	93500	E6100000010CD25CA236C0714840D1991A5EFF4B0340	ca5e5e8b-457a-4e34-8d9d-721941888fdf	2013-12-21 10:09:29.423
13262	45, avenue de la Gare	\N	Les Ulis	177	91940	E6100000010C9023A6B2985C484089A20B0AAC500140	77b106d6-648e-4f62-bf4a-4fb0a876cbd8	2013-12-21 10:09:29.423
13263	6076 Citrus Ave	\N	Brisbane	64	4000	E6100000010C6AE0A74E5B7E3BC0AEA27696D9196340	5e029a5b-0815-4728-bcd7-7c363b6b7233	2013-11-22 00:00:00
13264	2226 Cleveland Avenue	\N	Santa Monica	9	90401	E6100000010CFE824EA3FE0241405BCE6079B1A25DC0	c9f262dd-9fdc-4217-a48d-4385bd4b319f	2011-06-02 00:00:00
13265	3249 E Lane	\N	Hervey Bay	64	4655	E6100000010CD1CE16044C5F39C01604097B96156340	bc7b2d67-e588-4416-873c-c627979d7647	2012-11-05 00:00:00
13266	8594 Veracruz	\N	Esher-Molesey	14	EM15	E6100000010C00000000000000000000000000000000	7dbac6fa-8fb9-4fb7-9e27-516a1b170577	2013-08-19 00:00:00
13267	2962 Ana Mile	\N	Brisbane	64	4000	E6100000010C328C876FBB783BC09E1FFE7F3C1F6340	3555b11a-02c6-4b24-ace3-fb233fb073a1	2014-05-09 00:00:00
13268	7870 Orangewood Dr.	\N	Bracknell	14	RG12 8TB	E6100000010CC73E085EA4AB49406B324EE16635E8BF	6cf5a689-2955-4c22-8f7c-ca564b10a2a0	2014-05-12 00:00:00
13269	Brunnenstr 75	\N	Paderborn	20	33041	E6100000010CF71AAE3DA1E4494005DA7F3FC8AB2140	68e9a291-ead2-4db3-a74e-bd39d11be03b	2013-10-17 00:00:00
13270	598 Limeridge Drive	\N	Rockhampton	64	4700	E6100000010C07BC34A6195F37C0CE3FDC28D9C86240	ec88505d-5f40-4fcd-aa4f-fef49fec3d46	2011-11-24 00:00:00
13271	9875 Grant St	\N	Coffs Harbour	50	2450	E6100000010C109B5C4579223EC085C58BEBEA206340	578d48b0-1a29-43d7-997f-687bdfefa525	2012-11-12 00:00:00
13272	Heidestieg Straße 8664	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	ca0c6ee2-c8b0-4ef5-91d9-be4e1afbc322	2013-04-25 00:00:00
13273	995, rue de Courtaboeuf	\N	Boulogne-sur-Mer	148	62200	E6100000010C80B26D94936149403070C2D2F8B8F93F	e6048b12-f6b6-4b30-95c0-ffaa78de1cab	2013-12-21 10:09:29.423
13274	4789 Estrada	\N	Portland	58	97205	E6100000010C89D14291ADC94640E5BFE33BE2A45EC0	530d7130-625b-4ed1-8ed1-240bdbf8c619	2014-03-28 00:00:00
13275	4322 Cobblestone Ct	\N	Vancouver	7	V7L 4J4	E6100000010C2BCC10C303AD48406286DA6C45C75EC0	962289e1-e6dc-4bdc-b096-d4d42cf1f827	2013-07-27 00:00:00
13276	9489 Anderson Way	\N	Redwood City	9	94063	E6100000010C25919420BEC0424048E592F707845EC0	4016f6ea-3019-4d33-9e1b-6e1e7fbabdd9	2012-09-15 00:00:00
13277	9275 Westwood Way	\N	Royal Oak	7	V8X	E6100000010C31686BDF86334840B9A5C3458DDC5EC0	154493f8-49bd-4db8-bc2e-840bea4ce44a	2013-11-05 00:00:00
13278	Husemann Straße 9514	\N	Dresden	19	01071	E6100000010C00000000000000000000000000000000	f8107d58-e01e-4f3b-ab20-0ea077ecef36	2012-08-20 00:00:00
13279	2313 Santa Cruz Drive	\N	Darlinghurst	50	2010	E6100000010C2523878DB3EE40C0D3C7B46801E26240	4f7df008-f786-407a-81a2-fd64272cc664	2014-01-18 00:00:00
13280	7353 Algiers Drive	\N	Langford	7	V9	E6100000010CBE06CE495F31484031D976A555DB5EC0	7afb91ff-767e-4235-a348-14e6d1aeda27	2013-06-13 00:00:00
13281	Winterfeldtstr 3539	\N	Berlin	70	14197	E6100000010C6A12F9F066394A40042DF6DD8AAD2A40	b2128a80-0037-4d28-8397-88668c2b3bcb	2013-11-08 00:00:00
13282	3884 Bates Court	\N	Maidenhead	14	SL67RJ	E6100000010CD441D8C7C8BA4940640EACC3BC8AE7BF	a47bf1ba-8207-4d7b-b37d-74f8f80409d1	2013-07-27 00:00:00
13283	7393 N Ranchford Court	\N	Westminster	7	V3L 1E7	E6100000010C6107BAA59C984840223CEEBA37B95EC0	2dd81f76-fd6e-4df7-a8f1-d17b476f439e	2013-10-14 00:00:00
13284	851, rue Henri Gagnon	\N	Paris	161	75012	E6100000010C39FF556F606D48404D3E2E68DC610340	36d6509f-a525-43f2-b088-d8131d209567	2013-12-21 10:09:29.423
13285	8380 Forte Way	\N	Sooke	7	V0	E6100000010CE758309E3828484074C12FB581E45EC0	1452439b-4243-4ba6-bf3c-b952f19c3d7c	2012-08-27 00:00:00
13286	8675 Mildred Avenue	\N	Marysville	79	98270	E6100000010CB1117EF9840348404BBA04DDF08E5EC0	7ba0ea48-7072-492a-8551-063e2d75689f	2014-01-20 00:00:00
13287	663, rue des Ecoles	\N	Courbevoie	178	92400	E6100000010C3D7EE0ADDE7448409A08D99E8D100240	2a64f853-4501-4c5a-b96d-13de89db042a	2013-12-21 10:09:29.423
13288	9916 Walnut Blvd.	\N	Yakima	79	98901	E6100000010C94D7E521FF4A4740A3FA4B13440C5EC0	37359ff7-f8cd-417e-ab69-1ae7c14d3868	2012-08-13 00:00:00
13289	3121 Spar Court	#511	Fremont	9	94536	E6100000010C1D0123B3E8C24240C02529712C735EC0	cd94245d-290f-4824-aca7-90a870cb3668	2014-04-05 00:00:00
13290	2680 Claudia Drive	\N	Melton	77	3337	E6100000010C740F47FC17CD42C06F731DE6CE0D6240	ff914c1d-b09f-486f-8330-27f3235e7bd1	2014-02-25 00:00:00
13291	4616 Sutcliffe Pl	\N	La Jolla	9	92806	E6100000010CC75916D3F6EA4040AAF0FCD6A1825DC0	90e416b7-95af-428d-9cd0-66ad3aca004b	2013-12-25 00:00:00
13292	5842 Standing Grove Dr.	\N	Geelong	77	3220	E6100000010C802A4714E20C43C09DE5C5A9250A6240	c27a85f1-716f-4feb-a205-1ddbeb673bf2	2011-08-18 00:00:00
13293	2480 Stillwater Court	\N	Woodland Hills	9	91364	E6100000010CC798932C6A11414075B95A95D4A15DC0	b90f1cdf-5ce3-4832-80ea-b16096cbdd07	2013-08-06 00:00:00
13294	8848 Auburn	\N	Santa Cruz	9	95062	E6100000010C8B65CF8A8A72424000945197B8855EC0	9a7e5834-3934-4bc8-be82-e415da972c35	2013-08-11 00:00:00
13295	1728 Village Oaks Dr.	\N	Milton Keynes	14	MK8 8DF	E6100000010CFAC3AB7D6AFB4940BDCD0B9E477DE9BF	0af4d281-86b4-450f-a43e-a50feda76754	2014-01-13 00:00:00
13296	3508 Canning Road	\N	Redwood City	9	94063	E6100000010CB334797A6CBC424048E592F707845EC0	af341405-fe3b-4295-b0ed-173ef0cac61d	2012-03-04 00:00:00
13297	5050 Mt. Diablo St.	\N	Maidenhead	14	SL67RJ	E6100000010C5F03CAE7F4C94940898BB51DB481E7BF	af3f4d45-25a0-4056-b5af-8339d347d16f	2013-07-24 00:00:00
13298	130 Alamo Court	\N	W. Linn	58	97068	E6100000010C1C2B7C1795AC4640DE68E08BE3A35EC0	c389aa8c-5801-4386-ac3f-6dff0a2555db	2014-02-06 00:00:00
13299	5043 San Antonio	\N	Fremont	9	94536	E6100000010C80C15A8046C642404FE95394DB775EC0	987b7e7f-bfdb-416c-befa-25e6f7ca7128	2013-09-01 00:00:00
13300	4576 Almond Street	\N	Seattle	79	98104	E6100000010CB9D968A1B7D247406D2AE39AB98B5EC0	fe798bf8-23ab-483c-802d-8b142db00525	2014-03-28 00:00:00
13301	9696 Brentwood Circle	\N	Milsons Point	50	2061	E6100000010CCEE91BF6B9F040C036421586C5E86240	99dab9e0-9373-468a-8f38-1fa4a8e3caf6	2013-09-28 00:00:00
13302	9529 North Park Court	\N	Grossmont	9	91941	E6100000010C538DCEB03E5E404092036A66CB385DC0	f8118751-056b-4177-8ba5-37023a93b5ac	2014-04-10 00:00:00
13303	7607 Pine Hollow Road	\N	Ballard	79	98107	E6100000010C13CB40B7E8D447404E5EA0DEE3A15EC0	67682eef-83be-4a46-8189-06a28deaee77	2013-06-27 00:00:00
13304	304 Diver Way	\N	Mill Valley	9	94941	E6100000010C1A63786B0CEC42404B50A7E771A45EC0	08baa94c-67a5-4abd-911a-b72ce5daa8c9	2013-11-17 00:00:00
13305	7651 Smiling Tree Court	Space 55	Burien	79	98168	E6100000010CF55F90FD1BBB4740B172F68DAB8C5EC0	de3648f5-5159-4d7f-a20a-3520e3a175e1	2014-05-27 00:00:00
13306	8634 Valley Blvd.	\N	Los Angeles	9	90012	E6100000010CDB61A6942F0C41409152BA5705825DC0	14e352af-d5cb-4e75-ae24-dd2de2cf0bf9	2014-01-04 00:00:00
13307	9161 Medina Dr.	\N	London	14	SW8 4BG	E6100000010C94273886E7B349401B5D44614BC3C2BF	4bb9c012-076f-488f-b490-c646b9b1a4a9	2013-12-04 00:00:00
13308	3664 Colt Ct.	\N	Springwood	50	2777	E6100000010C344531B247D640C073DD78B35ECD6240	1cd0ed50-f451-4257-9094-5cd3fe577cad	2011-10-12 00:00:00
13309	6613 Thornhill Place	\N	Lavender Bay	50	2060	E6100000010C5BD7FD898CEC40C014EF02FE5CEA6240	5fbdceb4-f767-41bb-8347-a4e85860781e	2011-10-10 00:00:00
13310	1585 Larkspur	\N	Lake Oswego	58	97034	E6100000010C9688D0D7CEB94640AED06C65AEB25EC0	11d6fd84-ce3a-41c0-a5c1-52ee1f71aa86	2013-11-19 00:00:00
13311	3450 Villageoaks Dr.	\N	Royal Oak	7	V8X	E6100000010C8FC96B8FC434484061FCDB819AD85EC0	21822225-b987-4e91-af08-84613ba374e7	2011-07-31 00:00:00
13312	9309 Silver Oak Pl	\N	El Cajon	9	92020	E6100000010C2560AA898164404044BEFE44E2345DC0	ac97bbe1-3cff-4687-9aee-bbdc0b4c9a3a	2013-08-10 00:00:00
13313	805 Stonyhill Circle	#67	Spring Valley	9	91977	E6100000010C5D77008D6A5F40404434FF9944465DC0	4da33d99-7be9-4356-a525-1ae8724725b0	2013-09-01 00:00:00
13314	Reiherweg 5014	\N	Eilenburg	85	04838	E6100000010CAC02ACD0EFC5494029DBC34F09592940	a1145b74-f8ad-48f4-aea6-053dea40fc76	2012-07-13 00:00:00
13315	4264 C Street	\N	Brisbane	64	4000	E6100000010C1D77BF7753773BC0F83E9E1F9A256340	cb02ebc4-ab66-4ff2-b6f9-d57b4fb16289	2013-10-01 00:00:00
13316	8668 St. Celestine Court	\N	Lebanon	58	97355	E6100000010CED36964D504546407E61FCF718AF5EC0	261107b5-8d77-4fc0-8fc3-91a53759d0e0	2013-06-06 00:00:00
13317	8934 Roundtree Court	\N	High Wycombe	14	HP10 9QY	E6100000010C17CB337E27D14940D33967068F3AE6BF	85fa8cb5-fbe9-42fc-890b-607977a8ec96	2014-05-08 00:00:00
13318	2382 Arbor Drive	\N	Portland	58	97205	E6100000010C0B3D6AC0C3C6464087E899A7E0AF5EC0	e35662de-4647-43d1-995d-b8b91c65b24c	2014-04-17 00:00:00
13319	2587 Windmill Way	\N	Perth	66	6006	E6100000010C7E30DF30C5E93FC09892C3A8B6F35C40	7d4a551c-d809-4210-bbc7-787ac8418394	2013-02-13 00:00:00
13320	7040 Bush Avenue	\N	Redmond	79	98052	E6100000010C5BB1E572C6D94740CDEF7E6B0C8D5EC0	2db6a508-792b-438b-b56f-b8e1345cf761	2014-01-19 00:00:00
13321	3663 A St.	\N	Warrington	14	WA1	E6100000010C43974A7325AE4A409DBD1A73498C04C0	83a2d8d2-1c7c-4259-8440-2d3e17e102b0	2014-05-23 00:00:00
13322	Rotthäuser Weg 11	\N	Eilenburg	85	04838	E6100000010CC567A11347C54940945EAF1763582940	a2c0d686-04a8-4c8e-9ea8-4c5361905909	2014-04-25 00:00:00
13323	1233 RiverRock Dr.	\N	Coronado	9	92118	E6100000010C9F26B4893A574040C7B2C52DEC4C5DC0	f56b79ba-1108-441f-b8be-4178754450c2	2014-01-13 00:00:00
13324	8108 Abbey Court	\N	Oak Bay	7	V8P	E6100000010C5982E0ED5A35484068CE385C27E05EC0	a60f4f0e-0e73-405d-987d-8db4dab41143	2011-07-23 00:00:00
13325	6416 Honey Court	\N	Lancaster	14	LA1 1LN	E6100000010CEF51BA1453014B40D6A1D3688B7406C0	fec6892b-f6a1-4b64-a405-5df10a222b8f	2013-10-21 00:00:00
13326	5932 Houston Ct.	\N	Daly City	9	94015	E6100000010CDE31ACC494D5424070F8A8001CA25EC0	1bc1c0c0-ca54-4a0e-8101-778561c18c3a	2012-12-08 00:00:00
13327	5718 N. Sixth Street	\N	Puyallup	79	98371	E6100000010C236A8AA7B59B47409F0984B086995EC0	8ef84e50-5fab-46be-8e04-b7a97d231829	2013-11-12 00:00:00
13328	Nonnendamm 9	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	a7862cae-da34-4ec8-8762-a6cae964c61b	2013-09-07 00:00:00
13329	Westheimer Straße 5601	\N	Bonn	53	53131	E6100000010CE700CEDBA161494037E293F423701C40	89126560-d707-4fcd-951b-3ffbbb0c9d7e	2014-03-03 00:00:00
13330	9215, rue Léo Delibes	\N	Les Ulis	177	91940	E6100000010C992760B95D5648403BBB5DD2E1560140	ed0cb3d8-1c43-4944-93f0-ff28af014343	2013-12-21 10:09:29.423
13331	3796 Peachwillow	\N	Walla Walla	79	99362	E6100000010CBF043AE7E10B4740278D3D1762985DC0	aecde425-7ba3-4490-9bff-af1403bbba94	2012-03-29 00:00:00
13332	3836 Deer Meadow Way	# 174	Port Orchard	79	98366	E6100000010CD26B0BA0F7C54740815E054D28A55EC0	2bc92f11-ffd2-4f01-8b72-37f02eaa4f57	2014-03-20 00:00:00
13333	658 Pecan Street	\N	Stoke-on-Trent	14	AS23	E6100000010C94714322CA854A40C1792EECEB5F01C0	33dabc1a-06ff-4ce1-b5af-af55bc52dea7	2014-05-11 00:00:00
13334	4587 Sunset Meadows	\N	Sydney	50	1002	E6100000010CAE2CB7638EEE40C09458133135E46240	9996a015-23b6-493f-9ffe-793a5e7d2335	2012-02-01 00:00:00
13335	3275 Corrinne Court	\N	Hervey Bay	64	4655	E6100000010CD1CDD724755939C0B8A37E3CEC1C6340	782941ea-3a2b-437b-acf0-f1d17d90d5ae	2013-09-27 00:00:00
13336	2168 Reading Drive	\N	Burlingame	9	94010	E6100000010CBE4DD81DB2CA424029EB5DDAF5995EC0	8d98f769-bc3d-4b00-95ec-0e5f807322fa	2012-01-25 00:00:00
13337	2614 Sandiago Drive	\N	Burlingame	9	94010	E6100000010C41D360EB00D042405FD9012E11985EC0	b26e08d3-744a-42b0-b363-7c14238502b7	2014-02-01 00:00:00
13338	730 Keller Ridge Dr	\N	Woolston	14	WA1 4SY	E6100000010C69601475B1AA4A4016808E7BEB2604C0	68adc455-5b9e-4909-ac7e-b8e0659ca388	2014-03-17 00:00:00
13339	5118 Colorado Dr	\N	Townsville	64	4810	E6100000010CAA450F68923333C045E6ABA67C5E6240	c7425131-6340-4cb4-80f9-92360da24c75	2013-05-25 00:00:00
13340	6359 Mozden Lane	\N	West Covina	9	91791	E6100000010C70CE05681F0D41408E089220ED7C5DC0	ecedd7bf-e721-443a-bc37-adaace68cf23	2013-12-30 00:00:00
13341	9563 Lani Kai Drive	\N	Tacoma	79	98403	E6100000010CE449D86B0BAA4740B456E9150DA55EC0	55b9026c-0e1e-4a83-939d-8a33636a5385	2014-05-23 00:00:00
13342	1059 Delta Fair Blvd.	\N	Port Hammond	7	V6B 3P7	E6100000010CBA76C7CA4AA74840AA5B914C63C25EC0	dc361ca3-4e91-4eb7-a9ea-325d21a8c832	2014-04-13 00:00:00
13343	1955 Glaze Dr.	\N	Rhodes	50	2138	E6100000010C833F49BB3AE940C0DB32CA8CFFDC6240	a255e11e-c294-46bf-9108-7cded34ca2bb	2012-10-23 00:00:00
13344	4518 Sequoia Drive	# 2	Tacoma	79	98403	E6100000010C84D00227F8A04740E6320430B3A25EC0	87fc456f-3df1-4f9c-80c7-c3713c0e72ea	2012-10-19 00:00:00
13345	8922 Lindley Ct.	\N	Beverly Hills	9	90210	E6100000010CE110A98E511441404ABB5060A99A5DC0	6e3d5435-b359-489e-8869-ca00bd37ff21	2013-08-27 00:00:00
13346	5291 Juliet Court	\N	Shawnee	7	V9B 2C3	E6100000010CAE551D0CF0404840C3503ACA0EDB5EC0	42d70790-058e-4bf2-8a03-37cc4a538351	2013-06-30 00:00:00
13347	3518 Benita Way	\N	North Sydney	50	2055	E6100000010C971432EAB1E840C0DB56650F49E16240	5c618839-c499-495d-a2e1-2b0db4a9459a	2012-11-14 00:00:00
13348	9, avenue de l´ Union Centrale	\N	Saint Germain en Laye	164	78100	E6100000010C7849900453704840073CB67A02C90040	37027e80-536c-47f4-9616-66bbfb7958d2	2013-12-21 10:09:29.423
13349	2369 Teak St.	\N	North Sydney	50	2055	E6100000010C61136E9B75ED40C0FE24E7158BE86240	c839d952-6ba8-48c3-b4f8-59304cf39c91	2013-11-04 00:00:00
13350	6573 Helene Court	\N	Portland	58	97205	E6100000010CB2D5CCA6B1BB46405C6970792AAB5EC0	933fd80d-bef1-4c74-8ef5-86fac0cc3de2	2014-01-08 00:00:00
13351	1510 Sharon Dr.	\N	London	14	W1X3SE	E6100000010C9D6FFE660FC84940C4CFCC87D142C0BF	c9b77445-6b19-4012-83b9-aca0a8a2ae2c	2014-06-07 00:00:00
13352	3450 Villageoaks Dr.	\N	Pantin	179	93500	E6100000010CED27A170837A484075F1592E8B480340	94d6552b-faa9-43aa-afe6-c7369e410251	2013-12-21 10:09:29.423
13353	1487 Santa Fe	\N	Oak Bay	7	V8P	E6100000010C32CC52AAD5374840BC53E60F7AC85EC0	cf2ba090-3dea-4a87-856a-5477e9aa577b	2013-08-25 00:00:00
13354	1019 Pennsylvania Blvd	\N	Marysville	79	98270	E6100000010CA0CC8AD7AB09484021B684D8AF885EC0	03ee9e96-1d18-4da5-98f3-3152f820bdd9	2012-04-10 00:00:00
13355	6186 Berry Court	\N	Novato	9	94947	E6100000010CB8BCD27CC210434093A05D14099E5EC0	2b354397-bc17-4a4b-877e-4e42b3172087	2014-06-07 00:00:00
13356	Höhenstr 7477	\N	Poing	70	66041	E6100000010C00000000000000000000000000000000	eff2b282-4063-4788-88d5-f291617f5fed	2014-04-27 00:00:00
13357	1299 Band Court	\N	St. Leonards	50	2065	E6100000010C4457E414E0EB40C0A57EDCF46CE06240	c8d8c0ed-042d-409d-aac5-a4d315285060	2014-06-02 00:00:00
13358	5972 Donegal Court	\N	Woodburn	58	97071	E6100000010CBF692502648C46407F335DEF1DAC5EC0	b14885a7-0431-46bd-9bce-a0002dfc702e	2013-11-09 00:00:00
13359	866, rue Basse-du-Rocher	\N	Bellflower	9	90706	E6100000010C1E0D739F1EEE404072E027CCD78E5DC0	b284aaf8-c700-445f-abf7-87834847efdc	2012-07-26 00:00:00
13360	644 North Ranchford	\N	Brisbane	64	4000	E6100000010CA781A37307783BC0A983CF8B8F276340	e52d8fa5-8a8f-4c1f-9598-f9644600c459	2013-09-03 00:00:00
13361	7992 Elm Road	\N	Yakima	79	98901	E6100000010C98D8210389574740BB6CD8101E105EC0	7cc124fc-5772-41cc-8807-336149a24e73	2014-05-23 00:00:00
13362	8979 Adams Dr.	\N	Grossmont	9	91941	E6100000010C28D4479FFC5C4040BEF93F80044A5DC0	d2286812-7f56-4cae-815d-cef4069284ef	2013-08-31 00:00:00
13363	6977 Evergreen Ct.	\N	Beverly Hills	9	90210	E6100000010CD0029AF9B2114140AB422E4499945DC0	dbb9cf3f-e22c-41c4-af3f-51e0f3658e07	2014-04-03 00:00:00
13364	7346, avenue de l´Europe	\N	Bobigny	179	93000	E6100000010CE1F7F7F2046C48408673DB31E38A0340	8258a914-f5a5-4d50-94fa-5de343ac4454	2013-12-21 10:09:29.423
13365	516 Oak Park Blvd.	\N	Victoria	7	V8V	E6100000010CA6850C361138484004C9D04746CC5EC0	e0a2f0b5-a084-4022-9c96-f20dec05365a	2011-12-01 00:00:00
13366	4546 Vista Valley Rd	\N	Warrnambool	77	3280	E6100000010CDB16B1AEE40843C0EC013D6320CC6140	b376edad-9043-4744-bd08-5ec8d69792d3	2012-07-19 00:00:00
13367	3720 Santa Maria	\N	Downey	9	90241	E6100000010CCE3B272B3BF74040589CF2B352925DC0	f60dfd07-df54-418e-a502-39cc2fce22c2	2014-04-01 00:00:00
13368	5215 Entrada Circle	\N	Hobart	71	7001	E6100000010CFDFF58D34F6645C0FBF70FEA706B6240	752117fb-2522-4d50-b3ab-ca4f95ed7f44	2014-02-13 00:00:00
13369	1330 Guadalupe Dr.	\N	San Carlos	9	94070	E6100000010C594D9A2E8AC54240176300FDA4875EC0	cc6d2130-122b-4308-9e0f-60176ddfa587	2013-11-09 00:00:00
13370	5146 Shadow Falls Drive	\N	Caloundra	64	4551	E6100000010C0BDD9BB88EC43AC0F2D864ED81206340	5ddc3d71-fa02-4a78-8c61-ea0389c1acc1	2014-02-22 00:00:00
13371	3079 Ricardo	\N	Puyallup	79	98371	E6100000010CDC451952CAA047409CA9DF5CAF9F5EC0	517e0c24-bc4d-45f9-8697-74a7dda72223	2014-02-17 00:00:00
13372	8740 Vista Way	\N	Concord	9	94519	E6100000010C6288E6E8120043402D738F5A438C5EC0	619257f3-af54-4574-a008-13c28e5b9fb2	2013-10-19 00:00:00
13373	9447 Leslie Avenue	\N	Berkeley	9	94704	E6100000010C9DAE7A5D97ED42409965365593875EC0	4bb2a0a2-6ab2-4f00-8b2b-1f2218dc4cc9	2014-01-07 00:00:00
13374	4107 St. Raphael Drive	\N	Corvallis	58	97330	E6100000010CC6502723225946407A39A86BD3CC5EC0	4f9b9d09-9350-453e-ad4a-9d6f2abe6567	2014-05-01 00:00:00
13375	6, route de Marseille	\N	Tremblay-en-France	179	93290	E6100000010C1B64E913E5824840C75B033F7F700440	f57d318d-d80f-4c9b-a7f2-21088bf86159	2013-12-21 10:09:29.423
13376	824 Gregory Drive	\N	Goulburn	50	2580	E6100000010C6E10DC9D7F5341C05E03EB6EB7B26240	40dadfc3-f875-4746-a708-c1ac2f4ada4f	2013-01-30 00:00:00
13377	5642 La Orinda Pl	\N	Newport Beach	9	92625	E6100000010CE282C89067D04040FCB6D685D17F5DC0	ecc78e15-df5d-4f6c-8944-ce3f09962ed5	2014-05-22 00:00:00
13378	5175 Reisling Court	\N	Novato	9	94947	E6100000010C35CD0A03E20B434098EEE03C50A45EC0	30103fac-8393-4c40-8a1c-68e1b81f250a	2013-12-21 00:00:00
13379	1318 Lasalle Street	\N	Bremerton	79	98312	E6100000010C819E2398A9D24740496E371D6DAF5EC0	07e0e45b-602f-4661-b3ad-4c34040c9a49	2012-10-29 00:00:00
13380	Postfach 11 00 99	Verkaufsabteilung	Berlin	53	14197	E6100000010CC48AA0B593404A40C7808300F1A72A40	2602409e-901a-4245-9729-0988cc9a0020	2013-07-12 00:00:00
13381	2998 Brook Street	\N	Marysville	79	98270	E6100000010C182A9146BF0C4840CBB7343A088B5EC0	22ebdd66-da86-403f-8edd-204ec3dfe1fc	2013-10-04 00:00:00
13382	2785 Fallbrook Road	# 10	Novato	9	94947	E6100000010CBD031651E80A434014747EDE9A9F5EC0	3f6c0035-d136-4cea-acf0-7d2a29be7dd5	2014-02-14 00:00:00
13383	2497 Hazel Drive	\N	Cranbourne	77	3977	E6100000010C4C7FF038091843C082EADA7FD02C6240	bf09347a-4c13-48b8-86c4-411f1badc914	2014-04-04 00:00:00
13384	8206 H Street	\N	San Carlos	9	94070	E6100000010C9BB93FAF9EC34240AE51ED674B975EC0	02aad0f4-9dca-4ebc-937c-85e96638337e	2013-01-24 00:00:00
13385	903 West I St	\N	Woodland Hills	9	91364	E6100000010C7B5FDE7D5915414065F2F062849C5DC0	cbea1ac5-6db7-45c9-8e07-1f37b84ff67c	2014-03-06 00:00:00
13386	2551 Damascus Loop	\N	Townsville	64	4810	E6100000010C5B632F9AF83933C01FC367388C5D6240	e033c095-808d-4531-8cbe-d0b0fbfb7a6d	2011-06-20 00:00:00
13387	9233 Pepper Way	\N	Gateshead	14	GA10	E6100000010CF2BFEC7B3B7F4B40FCC5E02536A9F9BF	3b6561fe-7ae9-4874-81b1-a7e9ea552c2a	2014-04-02 00:00:00
13388	Viktoria-Luise-Platz 4	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	07e66bef-caf0-4d38-95bb-02dd9a30fa19	2013-10-30 00:00:00
13389	2184 Valley Blvd.	\N	Walla Walla	79	99362	E6100000010CC431644F5F124740C79FF58198945DC0	2433a0ca-dbf7-487d-a032-63a4efb28075	2014-04-13 00:00:00
13390	3425 El Verano	\N	Grossmont	9	91941	E6100000010CEF1AC18DBA5B4040746191E606445DC0	56a11a48-41e9-4549-89ad-126e6474e95b	2013-09-06 00:00:00
13391	6630 Cook Pk.	\N	Santa Cruz	9	95062	E6100000010C5555E258CE824240C32E7D2D667C5EC0	43ee2dca-4849-4bfb-8da3-7e8ec0b782d6	2014-06-11 00:00:00
13392	8125 Westbury Drive	\N	Santa Cruz	9	95062	E6100000010C54DA20E1628142409BCEB77397745EC0	9ea86df9-3c8e-436a-b6cb-697b0bbbb290	2012-03-06 00:00:00
13393	Lindenalle 800	\N	Mühlheim	20	63151	E6100000010C00000000000000000000000000000000	928d6c55-0500-4a2e-9d95-8197e57cd591	2014-05-25 00:00:00
13394	Auf dem Ufer 424	\N	Ingolstadt	8	85049	E6100000010CEF3AE708A96148402B0D176196B52640	1db0550a-a77d-4a02-b2c5-ce922a2a2993	2013-12-25 00:00:00
13395	3713 Rollingwood Dr.	\N	London	14	EC1R 0DU	E6100000010C4AAC8E21A2BF49403D32FA0FE021BBBF	7c4989be-710a-4dd7-9599-a7a08df116ef	2014-03-13 00:00:00
13396	5989 Concord Ave	\N	N. Vancouver	7	V7L 4J4	E6100000010C6E9CE3467F9E484096BCA420B2C55EC0	8d2103a9-d017-43e4-b5a5-eb555d757627	2013-08-12 00:00:00
13397	2357 Madrid	\N	Beverly Hills	9	90210	E6100000010CD0029AF9B21141408A46E671739E5DC0	c89fd83a-b72d-4177-bb48-4feb4aa9ee8c	2012-03-29 00:00:00
13398	4361 Loftus Road	\N	San Gabriel	9	91776	E6100000010C41A63DA8A00641403CCF944DA78E5DC0	a5442a39-f195-48e0-b7b8-6fb66cd84b4f	2012-02-15 00:00:00
13399	Rehstr 6446	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	de31e692-cdcc-44ba-9671-15dc70994dd6	2013-07-05 00:00:00
13400	3639 Blackridge Drive	\N	Hervey Bay	64	4655	E6100000010C003E92C95F5039C02FE83FC402196340	5a5eb28d-70ab-4d80-a103-d82b3ed6b7f7	2011-12-12 00:00:00
13401	8552 Stillwater Court	\N	Colma	9	94014	E6100000010CC03295BAACDB42402CE92962B7995EC0	10f941fa-78e1-47d9-8b5f-f2839f6e9a88	2013-07-06 00:00:00
13402	4775 Imperial Dr.	\N	Les Ulis	177	91940	E6100000010CF1EFF931385D4840AFB0837C38540140	c0b2e3d2-7348-4825-8536-9e8ba1ec0d5c	2013-12-21 10:09:29.423
13403	4092 Folson Drive	\N	Peterborough	14	PB12	E6100000010CB45A9BCF13504A40DFF7B0DA8AF6CFBF	1134d82f-737a-4a3e-96b8-ecd4ab7a015f	2014-02-26 00:00:00
13404	2756 Sinclair Avenue	\N	North Ryde	50	2113	E6100000010C4C34C93E8CE140C0E4F9B2CA0CEA6240	62df2841-28f0-4962-85d6-75d1987c5a26	2013-04-26 00:00:00
13405	6675 Logan Ct	\N	El Cajon	9	92020	E6100000010CA34612A4CD6A404082E2C96ADB435DC0	2e03bfdb-dde9-42a1-9d2a-21066be45db0	2011-11-11 00:00:00
13406	4135 Kaywood Drive	\N	Lavender Bay	50	2060	E6100000010CC7AC7E9EA6E840C01EF3EFBD12E46240	c3ae58b8-e019-4a01-a34d-da007ec6734e	2014-01-19 00:00:00
13407	1646 Twinview Drive	\N	Burlingame	9	94010	E6100000010C5A6556840EC242403F35112DEF945EC0	d9790e3b-d38f-4c78-b9c0-8cbab4f03434	2014-05-21 00:00:00
13408	4499 Valley Crest	\N	Bellflower	9	90706	E6100000010C48F9EDD918F84040EBAE805AC5855DC0	1f770d9f-10dc-48ab-aede-329b05c9cda1	2013-07-20 00:00:00
13409	212, rue Marbeuf	\N	Bobigny	179	93000	E6100000010C07D7C4E3E977484004305A83E3880340	fd38e56e-ba98-449b-9d35-eabce447815b	2013-12-21 10:09:29.423
13410	1, rue Pierre-Demoulin	\N	Paris	161	75007	E6100000010C6AE7DEFB1770484058471371957C0240	c988f342-9c17-4d84-90f4-c1b18bc1c105	2013-12-21 10:09:29.423
13411	2403 Riverwood Circle	\N	Langford	7	V9	E6100000010CD814B59C31384840A835C0D261D75EC0	7e0fd096-fa45-4691-9696-d87183c573e1	2013-07-25 00:00:00
13412	8142 Longbrood Way	\N	St. Leonards	50	2065	E6100000010CAF249BFEADE640C049785FFD95EA6240	ec5432b6-879d-43b2-9962-6a0c8546e31c	2014-03-10 00:00:00
13413	3390 Candle Drive	\N	Beaverton	58	97005	E6100000010C040D56771CC04640278DF225B4B55EC0	7188f78e-adeb-4110-a340-fdeca47a9370	2013-07-20 00:00:00
13414	3685 Pleasant Hill Rd	\N	Long Beach	9	90802	E6100000010C600E0DDE9FE440404AC41C472F955DC0	5bed4e86-c0a4-4baa-a91e-48ce1b98a358	2013-10-06 00:00:00
13415	820, avenue de Malakoff	\N	Verrieres Le Buisson	177	91370	E6100000010CD5B5C10F8B6748406590AA9FAA010240	f0c33fcf-b93b-4d12-89e7-3fac19472bd8	2013-12-21 10:09:29.423
13416	4926 Sharon Dr	\N	Olympia	79	98501	E6100000010CF39F7257B38547401BEC7A6EE4B05EC0	7d50941f-3d10-42ad-83e3-0d5a18df85ee	2011-11-22 00:00:00
13417	7954 Vista Avenue	\N	Berks	14	SL4 1RH	E6100000010C8263AC4567C24940699A7FCDAD80E3BF	1af85c4e-8648-4fb6-8794-8dc2d897c078	2011-11-28 00:00:00
13418	Winter der Böck 441	\N	Werne	53	59368	E6100000010C417AE3AE25D8494087A046DF15771E40	dfe5b32d-0687-477f-9800-896616577f73	2013-09-21 00:00:00
13419	33, place de la République	\N	Bobigny	179	93000	E6100000010CF21F8407077148404CDED31AE57E0340	2f898d81-2c6b-4ace-9416-39193a36a9ba	2013-12-21 10:09:29.423
13420	7489 Relief Valley Ct	\N	Novato	9	94947	E6100000010C758EE3F14B0F43403AA6744A60AB5EC0	ee017b04-3ffb-4fae-8b44-d885f00f6de4	2012-06-01 00:00:00
13421	Roßstr 6642	\N	Saarbrücken	70	66001	E6100000010C268AECA814A748400B4CFCB877F31B40	b361fc14-753f-4c1e-9c26-bfb69e6315c5	2013-12-07 00:00:00
13422	9113 Flamingo Dr.	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	c77cd08b-0d6c-4036-b827-072fde8df711	2013-09-16 00:00:00
13423	3858 Vista Diablo	Unit C	Issaquah	79	98027	E6100000010CDE7681ACBBC847402686FC4B217D5EC0	5e030abf-238b-4f3f-aeff-6cbba5ac9853	2013-11-30 00:00:00
13424	Krönerweg 5615	\N	Bottrop	53	46236	E6100000010CDC3363C918C74940F0EE6196A7AE1B40	54c24bb5-5790-4c38-a34b-729c4aeb51c9	2013-01-14 00:00:00
13425	5139 The Trees Dr	\N	Concord	9	94519	E6100000010C07C95C71B7F44240F314AB1E35825EC0	f6189aae-78b1-4040-8f32-3c4a77bf8277	2013-11-29 00:00:00
13426	53 Odin Dr	\N	Spring Valley	9	91977	E6100000010CD1808D89176140407DCC1C59CA385DC0	f5ea533c-a158-40ee-b05f-4358c9be4d9d	2014-03-18 00:00:00
13427	5075 Reading Dr.	\N	Cranbourne	77	3977	E6100000010C9C8F284FCE0C43C0D1CE967E592C6240	7446cfee-c73f-4de3-9255-2910fea80933	2011-12-21 00:00:00
13428	4+B347533, place de la République	\N	Versailles	164	78000	E6100000010C198D36A9D05F4840DC1093D182EB0040	766936e3-d519-4b48-93c4-92f8cee4f676	2013-12-21 10:09:29.423
13429	4753 Montanya Court	\N	Mill Valley	9	94941	E6100000010CC6D0E052CFF3424010DB768B629D5EC0	cde9d180-90a2-4a64-8bcd-1d633b634dd9	2011-09-11 00:00:00
13430	4539 Leeds Ct	\N	Haney	7	V2W 1W2	E6100000010CE4685B62A28E4840D60292EBEAAB5EC0	533dd799-59f9-451b-bd9d-3b3fe7fc4f34	2011-10-18 00:00:00
13431	4804 Haynes Court	\N	Milsons Point	50	2061	E6100000010CDDB41CC7D3EC40C01306836762E56240	977f5a36-6e5e-4441-8b37-2b40b2adb64d	2013-03-03 00:00:00
13432	2617 Melody Drive	\N	Newton	7	V2M1P1	E6100000010C3A1F30E064F24A4017EA4607C3B75EC0	dcbe87bd-d6b4-4e0a-8a94-00fb32c763cf	2014-03-05 00:00:00
13433	5313 Haynes Court	\N	Vancouver	7	V7L 4J4	E6100000010C2751065012A64840FFC796F7C8CC5EC0	41c43b3a-e212-42e7-a6fd-354ef27882f8	2014-02-25 00:00:00
13434	8192 Scenic Ct	\N	Findon	66	5023	E6100000010C77DA61BB117641C00B46A961F44A6140	f4237cd7-91f8-4ea1-bc2d-f40d736d3f58	2014-04-07 00:00:00
13435	3644 Rosarita	\N	Bellingham	79	98225	E6100000010CE183F2C6625A4840C27C7E0337A35EC0	f1966f6f-0e4a-4ade-84dc-4a88f20ec529	2014-02-10 00:00:00
13436	6594 Glen Wood Drive	\N	Lynnwood	79	98036	E6100000010C2D63B6FEB8EB4740AC693A70BC9D5EC0	b2a30515-f4db-485f-834c-73306b9c2b5a	2014-06-18 00:00:00
13437	5180 Lacorso	\N	Los Angeles	9	90012	E6100000010C4C659637A90241402FB0C0E5CE835DC0	b160201a-c955-4fac-991c-cb352b04ed26	2013-07-12 00:00:00
13438	6940 Hilltop Dr	\N	Sydney	50	1002	E6100000010C83BB631F53F340C0E473CF805EDF6240	28b15150-cc60-4fcf-85f5-b55bf1805e0c	2013-05-27 00:00:00
13439	5542 Orchard View Ave	\N	Caloundra	64	4551	E6100000010C1530F62080C23AC0FEBDA2A5EA246340	5935c738-c640-46be-96e2-be7c179f8d6b	2014-05-09 00:00:00
13440	92, rue Saint-Lazare	\N	Les Ulis	177	91940	E6100000010C05F610BCDF5348404E9D1E5F574F0140	bfcb5961-ee52-4f74-9802-1c8e66ec2637	2013-12-21 10:09:29.423
13441	4176 Alexander Pl	\N	Concord	9	94519	E6100000010C238A8AE60B014340A438C10FCC865EC0	aec9191e-45e0-463a-991b-b7d049a62730	2013-08-05 00:00:00
13442	8384 Golden Rain Road	\N	Bellflower	9	90706	E6100000010C2A5F95BE3AF74040F1146380CB885DC0	4cc54a5c-a37c-4047-9724-002c09e50101	2014-04-07 00:00:00
13443	211, quai de Grenelle	\N	Les Ulis	177	91940	E6100000010C8D2503367B5948404E9D1E5F574F0140	db03f3cf-bfee-42b9-b712-6a9129b1a6b9	2013-12-21 10:09:29.423
13444	5994 El Capitan	\N	Palo Alto	9	94303	E6100000010CD43DCA1C4ABA4240FAD213D5947E5EC0	0a29ccce-694a-43dc-9ef7-d51788a822de	2011-07-12 00:00:00
13445	7743 Ham Dr	Unit 2b	Edmonds	79	98020	E6100000010C3CD75BF523E24740ADC92531A89C5EC0	eb70c79b-fa42-4daa-b624-13599263e5fc	2014-04-25 00:00:00
13446	3009 Temple Court	\N	Cheltenham	14	GL50	E6100000010C8F7DE74CF6F0494040C8DD6B8C9B00C0	158e822b-d661-4f56-ab0d-02594171a079	2013-11-03 00:00:00
13447	1293 F Street	\N	La Jolla	9	92806	E6100000010C6B86278D4BEF404019BAF00409725DC0	00360b55-dca4-46c6-a43e-7259e8d3302a	2013-08-04 00:00:00
13448	5952 Haven Drive	\N	Beaverton	58	97005	E6100000010CC46DDBF049BA4640AB47E4F3FCB05EC0	0b9ea8b0-c6cc-4c88-9539-e5b432c2b85e	2013-09-04 00:00:00
13449	3960 Temple Drive	#304	Oxford	14	OX1	E6100000010CCF373FE621E2494092A198BA2A2EF4BF	9d0ca751-90b7-45bf-bd7a-759b6364aa87	2014-01-02 00:00:00
13450	8500 Pinehurst Court	\N	Wollongong	50	2500	E6100000010C777A2EC5F73241C0B975A1E1A6E06240	4b0d402c-7b3e-4096-9ed9-b9954f72fe68	2012-11-05 00:00:00
13451	2575 Garcia	\N	Walla Walla	79	99362	E6100000010C0C9754628D134740629845571C965DC0	cddbbbf1-bc77-46b1-9bc6-aef25f0f47d3	2013-02-08 00:00:00
13452	Nollendorfplatz 5662	\N	Münster	70	48001	E6100000010C00000000000000000000000000000000	4969f7b1-cd05-44c0-8234-1cd6b283cbbc	2011-10-17 00:00:00
13453	144 Santa Monica	\N	Lakewood	9	90712	E6100000010C6C46185388E6404020827A4FA67E5DC0	8970cdfb-502a-4172-9f0e-297eee3c1f6b	2014-04-23 00:00:00
13454	7020 Mayette Avenue	\N	Santa Cruz	9	95062	E6100000010C6FBBB2C9127E4240A12B64858C865EC0	2386385b-9ebc-4272-910d-8aca119bec31	2014-03-23 00:00:00
13455	Zollstr 68	\N	Erlangen	8	91054	E6100000010CF868BF2311C84840F08BC13246112640	d32a799f-4881-4de8-9bb2-6a9e33420346	2013-11-24 00:00:00
13456	Attaché de Presse	\N	Dunkerque	145	59140	E6100000010CCD74D104AF8A4940C3281FE0D3D40240	9c873248-3ebc-430e-9bc1-671a9bca69b4	2013-12-21 10:09:29.423
13457	2707 Virgil Street	\N	Palo Alto	9	94303	E6100000010CFAE464DDA7BD4240DCDFED2BA9915EC0	42d04d23-3fd6-429c-a6bd-1015db4faf54	2013-10-21 00:00:00
13458	5666 Hazelnut Lane	\N	Darlinghurst	50	2010	E6100000010CFFC8F7A56FF040C0289A3527D8E66240	1b237e80-3d59-432f-89da-406e7733aae0	2013-12-05 00:00:00
13459	2748 Logan Court	\N	Newport Beach	9	92625	E6100000010C6FACFC75F9CF404019D852B9897A5DC0	5bfd3463-693a-4057-979d-19ca734eb5af	2014-05-09 00:00:00
13460	2851 Ward Street	\N	Milsons Point	50	2061	E6100000010CCEE91BF6B9F040C0B98249A649E86240	3129d15d-e18e-48a1-be52-b91d01a8812e	2013-05-20 00:00:00
13461	8689 St. George Court	\N	Branson	37	65616	E6100000010C38C93C668F56424082DE6081EF4D57C0	e3757df0-6b18-4e04-b2da-7041a6539dbd	2013-10-25 00:00:00
13462	1080 Crestwood Circle	\N	Metchosin	7	V9	E6100000010C3708977CC82B48403764420862E55EC0	08a67204-c554-440a-ad9a-22fb125a2cd0	2013-11-13 00:00:00
13463	6650 Contuti Avenue	# 135	Rhodes	50	2138	E6100000010C00849EF175F140C0F71FF81C40E46240	30e8b4c9-1def-47ca-a648-82c4f6a64968	2014-02-18 00:00:00
13464	4030 La Orinda Place	\N	Olympia	79	98501	E6100000010C644E13FC777847402A3ACDD442BE5EC0	cce57943-6acb-497f-ba99-c2d27ed21732	2013-10-19 00:00:00
13465	5271 St. George Court	\N	Imperial Beach	9	91932	E6100000010CE358AA8BEA46404033A4DB3C95415DC0	c249d5d5-2dde-491f-a7a8-eef02d5604c0	2014-05-27 00:00:00
13466	4851 Heights Ave.	\N	Beverly Hills	9	90210	E6100000010C58CF622C1808414029BF088E83A45DC0	88e417fa-92e3-422a-a435-f676381ef653	2012-01-30 00:00:00
13467	8475 Riverwood Circle	\N	Oakland	9	94611	E6100000010C42A211D1C8EE42402ECEEDB7C2975EC0	b4b31093-9a25-4ab7-9991-1f5438b5d0ac	2014-06-19 00:00:00
13468	Altendorfer Straße 5	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	7097f0cb-f16e-45ec-a828-8a2cf9756fcb	2013-04-11 00:00:00
13469	9970 San Miguel Rd	# 170	Oakland	9	94611	E6100000010CFABD48A301E8424073FAFB8DD9935EC0	b68a42b1-5afe-4296-8212-4d38b70adcac	2013-12-08 00:00:00
13470	3429 Fourth Street	\N	Salem	58	97301	E6100000010CE16DC5096A6C46403B548181A1BE5EC0	93c4f4fc-014e-420c-b7c5-ed0e92beda73	2013-07-17 00:00:00
13471	7834 Roux Court	\N	Langley	7	V3A 4R2	E6100000010C58FA05DF6E93484056D91DDD20A55EC0	15f4ba27-cadb-4752-a7e0-bf473da70fc8	2013-01-29 00:00:00
13472	4203 Wildcat Circle	\N	San Carlos	9	94070	E6100000010CC36AD5B1F0BB4240E41A83B06C9A5EC0	f8d4b303-24c0-4a9e-a38a-35d187a911fe	2013-10-31 00:00:00
13473	6206 Arthur Rd	\N	Santa Monica	9	90401	E6100000010C6D64D1E982FF40405EC431C848945DC0	30d2b03f-e178-4811-8127-876bde454d04	2011-07-30 00:00:00
13474	4753 Montanya Court	\N	Silverwater	50	2264	E6100000010C3554F33D1B9540C0929B4E5708EF6240	54e70757-8b25-49b8-b8f3-a281f734e2eb	2013-02-01 00:00:00
13475	5484 Viking Dr	\N	Corvallis	58	97330	E6100000010C8FBC56904656464064ACA37209CC5EC0	3eaad92a-c736-4b4c-918d-ae65c773b372	2013-01-18 00:00:00
13476	7355 San Benito	\N	Bracknell	14	RG12 8TB	E6100000010CEFC9273C39B2494059764EC4383CE8BF	83879180-8c1e-40ec-b8d7-9b2acc8b4c2f	2013-09-14 00:00:00
13477	9930 Clinton Dr	\N	Chula Vista	9	91910	E6100000010CEC67CEA191574040C7C963B19A4E5DC0	b98bc175-c77a-48dd-826f-2baa99fcb561	2014-02-12 00:00:00
13478	5098 N. Civic Dr	\N	San Gabriel	9	91776	E6100000010C3759C2EA9B0D414052B897F0C77E5DC0	36dcfdbf-c245-428e-ac62-4a7f67ba96d8	2013-07-08 00:00:00
13479	Karl Liebknecht str 577	\N	München	20	80074	E6100000010C00000000000000000000000000000000	7e808b78-ecb2-48ca-b330-8e8abc457fed	2013-07-26 00:00:00
13480	3902 Clay Rd.	\N	Wollongong	50	2500	E6100000010C0ECDB3550D3641C0F95E389A71D86240	1ce884c8-f70c-4920-963d-61a4f1165c4f	2014-03-11 00:00:00
13481	2461 Orangewood Court	\N	Warrnambool	77	3280	E6100000010C9AB214DA530B43C0E9A74AABABCB6140	4842e1af-908f-406b-9d44-072fad2e7c5a	2011-11-04 00:00:00
13482	4884 Maria Vega Court	\N	Coffs Harbour	50	2450	E6100000010CCA7FA35C312A3EC096CFD7A77D1D6340	512d09b3-43ad-4824-9a9b-8baa3b10f60f	2013-12-11 00:00:00
13483	6237 El Rancho Dr.	\N	Townsville	64	4810	E6100000010C7C0BC38A003833C040131311DA586240	32d4ca3c-19d8-4765-95a1-a5d50d5c8d66	2014-06-23 00:00:00
13484	48, rue Montcalm	\N	Tremblay-en-France	179	93290	E6100000010C52C69EB6FB764840C6159ACB4C770440	b2349edb-bad2-45d8-bf6e-c6955a829252	2013-12-21 10:09:29.423
13485	3002 Carmel Drive	\N	Oak Bay	7	V8P	E6100000010C00603723CB3C48405D97353CA2CB5EC0	ed987c4f-9fc5-4bbf-ab52-98a2805b2cb6	2014-04-04 00:00:00
13486	1531 Birchwood	\N	London	14	W1N 9FA	E6100000010C01814789F1D349404CDDDDBE2EFAC2BF	75c9d1d4-e56c-41aa-b431-0e2c46002ef5	2012-08-10 00:00:00
13487	Zur Lindung 1	\N	Erlangen	8	91054	E6100000010C99FACF7066D548406099622825102640	babcb624-f1fd-4f67-84cf-8ee0cac6c3a0	2013-10-08 00:00:00
13488	3989 Terrace Drive	#55	Lake Oswego	58	97034	E6100000010CBBB56C5E60B84640CFCF6369C9B05EC0	bdc97d9e-9d9f-440a-9572-ece1aaad1090	2013-10-21 00:00:00
13489	4284 Boynton Avenue	\N	Redwood City	9	94063	E6100000010C85844FBAD2BE42403981A29081895EC0	6c7b4b67-c83d-4303-a9ae-982825010b76	2013-11-03 00:00:00
13490	5525 Lilly Lane	\N	Burbank	9	91502	E6100000010C798B51B5B514414092234477478F5DC0	3185853f-896c-4290-81cb-fff1d92d3200	2014-01-08 00:00:00
13491	6453 Coldwater Drive	\N	Bendigo	77	3550	E6100000010CABB64C90236642C074141860D50F6240	ecffd8a9-8251-4018-bdd6-e984b99f7714	2014-03-07 00:00:00
13492	9975 Haynes Court	\N	Shawnee	7	V9B 2C3	E6100000010C7C0E1A98B23F48403C34BED6AFD85EC0	aebaaaf7-f48a-473f-8f51-1182a9b4968b	2014-04-29 00:00:00
13493	1471 Michigan Blvd.	\N	Shawnee	7	V9B 2C3	E6100000010CAE551D0CF0404840B2AF631BD9DB5EC0	3cf9a200-0313-4ff9-9254-65a3f38214be	2011-07-18 00:00:00
13494	9334 Cougar Way	\N	Bendigo	77	3550	E6100000010C4A5592DB145F42C0F211B42B5F0F6240	49ae8973-43be-4077-b5d1-dd083173ec96	2012-11-25 00:00:00
13495	5703 Rose Dr	\N	Grossmont	9	91941	E6100000010CD2B862E504624040BF7C0B800A3B5DC0	b5999c1f-40fc-45b8-9870-579c1a980dcc	2014-03-11 00:00:00
13496	9236 Woodland Drive	Unit B	High Wycombe	14	HP10 9QY	E6100000010CFF8E84EF30CD49401BE73FED673DE6BF	303e2311-cfa4-4049-8e76-3b8da4e545a3	2011-07-26 00:00:00
13497	83, rue de Fontfroide	\N	Paris	161	75017	E6100000010C049E9D1115794840C058806ACD710240	43a6433f-23fc-460e-a0e6-d2b584a3df75	2013-12-21 10:09:29.423
13498	4101 Buckthorn Court	\N	Concord	9	94519	E6100000010C2F8C6144FFF74240AB0B08683F805EC0	3719da66-320a-43ff-83de-02b970b0faef	2013-12-16 00:00:00
13499	9770 Fraga Court	#91	Concord	9	94519	E6100000010CCC8C006381024340CBD6E9AD4D7A5EC0	e01413ab-40ec-4cde-8c91-db27c05012a5	2012-06-18 00:00:00
13500	363 St Paul Way	\N	Portland	58	97205	E6100000010C01BC07BB42CA4640AE7D4BAFA9B05EC0	ed3f96e8-a005-4faa-8d59-d04e131826fa	2013-11-27 00:00:00
13501	6985 Florencia	\N	Burlingame	9	94010	E6100000010CB9B329371ECD42405821E32F559E5EC0	d52bd1d0-3677-48eb-ba15-1f2339e67fde	2012-11-05 00:00:00
13502	Postfach 99 92 92	\N	Kassel	19	34117	E6100000010CA3F0DB6D28A74940E1C8BFDA63F62240	1d34228f-3ac6-451a-9692-f230c86d7967	2013-02-18 00:00:00
13503	1431 Rancho View Drive	# 14	Cliffside	7	V8Y 1L1	E6100000010C60666778393E4840545FB603B3D35EC0	d28f39fa-027c-4b82-bd1d-592167920384	2014-05-08 00:00:00
13504	6598 Hargate Court	\N	Fremont	9	94536	E6100000010C9253160B5AC4424064A577FF71805EC0	604f415d-089f-4e08-a996-4a1f377eab5a	2014-05-15 00:00:00
13505	4256 Ashmount Way	\N	Warrington	14	WA3 7BH	E6100000010C76BBA9F6A5B34A4084472AEFFB3F04C0	28187e4b-be19-4c07-a695-2428bd440900	2013-02-13 00:00:00
13506	6384 Euclid Ave.	\N	Yakima	79	98901	E6100000010C0CD891CB5E504740D3DE640EF8135EC0	7ad15ab1-f2c7-43db-b4f4-f4545530ade6	2013-12-28 00:00:00
13507	9 Katherine Drive	\N	London	14	SW19 3RU	E6100000010CC354BE863BAD49405EE995EBFE88CABF	e6868072-01dc-46ba-ae66-913703499aef	2013-12-17 00:00:00
13508	7158 Waterview Place	\N	Stoke-on-Trent	14	AS23	E6100000010C01F6B3AA25874A408796857D9A6601C0	b815492b-85a1-4b42-ae48-082da8e2b1eb	2013-08-01 00:00:00
13509	2151 Twincreek Ct	\N	North Ryde	50	2113	E6100000010C395F589777E840C0D477395E99E86240	66c4816b-76bf-4c34-9d42-1e524ac93c71	2012-02-27 00:00:00
13510	5489 Patterson Blvd.	\N	Lynnwood	79	98036	E6100000010CE09999D77BDF47408A89971242865EC0	ed28d35f-f440-4220-8c57-b93331dea59b	2014-05-24 00:00:00
13511	8439 Teak St	\N	Gold Coast	64	4217	E6100000010C42CA9B6A8CF63BC01A295CA5972A6340	3936d94c-8436-436d-8f21-f6ef0ecac573	2011-12-25 00:00:00
13512	734 Mt. Tooth Place	\N	High Wycombe	14	HP10 9QY	E6100000010C1C698BC522D3494032522CF38742E6BF	d77b6aae-1d11-4bc1-9570-82b6084653c1	2014-01-29 00:00:00
13513	7025 Eastgate Avenue	\N	Gateshead	14	GA10	E6100000010CF2BFEC7B3B7F4B40A7B58E22DEA9F9BF	165ea6bd-77b5-423f-b53e-7a6706ec8a1b	2014-02-19 00:00:00
13514	2886 Chaparral Court	Space # 45	Issaquah	79	98027	E6100000010C9D251A4E38C04740E700A232AA775EC0	94e91a73-d8b4-44d6-ac8c-dadcd8825a83	2013-11-24 00:00:00
13515	4381 Amazonas	\N	Issaquah	79	98027	E6100000010CD23C5CFBA6C2474085129553E2765EC0	e6b02f8b-3003-45be-ab67-73b086878b9b	2014-02-25 00:00:00
13516	8533 Valley Oak Plaza	# 174	Perth	66	6006	E6100000010C7E30DF30C5E93FC0A574B8435AFD5C40	ad11cf8e-ece5-4b52-854d-ce081691a9c0	2013-11-27 00:00:00
13517	7839 Liszt Way	\N	San Diego	9	92102	E6100000010CD4F632C83E584040BC3C9060B04C5DC0	8b80abb7-a9c0-4379-96da-190e0cc17139	2014-03-24 00:00:00
13518	2245 Cloudview Dr	\N	Bellingham	79	98225	E6100000010C713257FADD66484055969A8ACE995EC0	5ad89574-74d7-417b-80de-3343d4fed94c	2014-02-28 00:00:00
13519	6327 Mi Casa Court	\N	London	14	SW19 3RU	E6100000010CE26C8FE8BCB9494093178ABA638CCABF	4667dbac-2460-4465-bb49-f2b2add8aec0	2013-04-04 00:00:00
13520	5957 Hill Drive	\N	Brisbane	64	4000	E6100000010CCF0DD7A04B703BC02C132391B4206340	03003363-6148-4e33-8843-e4d615f28449	2011-07-21 00:00:00
13521	4030 Rosina Court	\N	High Wycombe	14	HP10 9QY	E6100000010CE752D5603AC94940BA18F195B23BE6BF	c7e07245-ef6f-46ef-bf65-60743e7d6462	2014-04-04 00:00:00
13522	854, boulevard Tremblay	\N	Drancy	179	93700	E6100000010C50F3876CF3744840AB0AA074108B0340	290895cd-2d28-4868-a7c6-add54c1099f6	2013-12-21 10:09:29.423
13523	7239 Green Leaf Drive	\N	Marysville	79	98270	E6100000010CA0CC8AD7AB094840E7B8547B988C5EC0	8ab084a1-e2f0-449e-894a-fc497fc462dd	2013-12-06 00:00:00
13524	2206 Clear View Circle	\N	Concord	9	94519	E6100000010CCC8C0063810243401A1137A8EB895EC0	5e939f03-9b04-42cd-aa48-1268fa1ba8f1	2011-11-12 00:00:00
13525	1685 Greenbelt Way	\N	Fremont	9	94536	E6100000010C4C9DE36A1FCA4240822CCD45D0895EC0	48c207d9-859e-4f84-8b55-c58a4f165015	2014-04-23 00:00:00
13526	Hellweg 4644	\N	Salzgitter	19	38231	E6100000010C00000000000000000000000000000000	3d0e288b-cf4c-4107-aadb-2e5b43b9704b	2014-01-27 00:00:00
13527	9507 San Vicente Dr	\N	Renton	79	98055	E6100000010C9E89517E65C3474067373633F6885EC0	c9521605-07ad-41f0-82ae-333693e43009	2013-11-21 00:00:00
13528	5831 Mountain View Place	\N	Calgary	1	T2P 2G8	E6100000010CA0D918DFC88149408CA0132DFF825CC0	8acac442-c83d-43e5-bcdf-1ed0c17bb3b8	2013-09-16 00:00:00
13529	2546 Woodchuck Pl	# 2	Bracknell	14	RG12 8TB	E6100000010CC2DBF305C1BC4940DA6C9411F13FE8BF	3c8d0d88-c585-49a5-b168-0a08a6412a7e	2014-04-04 00:00:00
13530	7371 Cali	\N	Salem	58	97301	E6100000010CBB3C5C4B7F7B46406B5EA708A4C55EC0	8d5a2a75-d56b-4b3b-af3f-fd8bab87692c	2013-11-11 00:00:00
13531	Königstr 284	\N	Mühlheim	20	63151	E6100000010C00000000000000000000000000000000	5f0b334f-a830-4c92-869a-1d2a50dcc37c	2013-08-25 00:00:00
13532	7412 N. Civic Drive	\N	Glendale	9	91203	E6100000010C53B28E7C4D1541402CFF629F4C965DC0	27be041d-d6b1-4a76-91ae-32aebce5f149	2014-02-18 00:00:00
13533	1679 V. Street	\N	Ballard	79	98107	E6100000010C5352BF0092D84740708E8749689C5EC0	6ffe9b98-ef73-4938-ba11-b63d0d4e9187	2013-10-05 00:00:00
13534	3503 Springwood Way	\N	Beaverton	58	97005	E6100000010C43C468E3B4B94640FB7DCCF520A95EC0	56153371-8de6-4128-8dc8-1fe994de1908	2014-06-11 00:00:00
13535	4629 Candle Dr	#30	Billericay	14	CM11	E6100000010C030BADF04FCF49402AC09FE7D7AFDA3F	f6c9e615-33be-4382-91ad-bae58786ae15	2011-12-11 00:00:00
13536	5870 Matheson Road	\N	Oakland	9	94611	E6100000010CEE1A70392AE342401A17AF75CF8C5EC0	13219a0e-df0e-4480-af16-ae44f334e802	2014-01-16 00:00:00
13537	2928 Harmony Way	\N	York	14	Y03 4TN	E6100000010C96ABC7D1CFF34A402A0FA48D6C56F1BF	9ea2739a-c3d7-4ee9-a63b-26c080eaecf5	2014-05-06 00:00:00
13538	3738, chaussée de Tournai	\N	Bobigny	179	93000	E6100000010C0FE1E7682A7948405D151C09E38B0340	8fd1ef4a-5c8b-42ab-a7d0-b16dd9adb14c	2013-12-21 10:09:29.423
13539	570 Guerrero	\N	West Covina	9	91791	E6100000010C7259AB6A250641408E089220ED7C5DC0	06a48224-7593-4bec-9e1a-61395fb3b0a8	2014-01-07 00:00:00
13540	7798 Longbrood Way	\N	Caloundra	64	4551	E6100000010C70C17D403EC53AC0E5D200C17C216340	8dda8e1f-6ab7-4b17-a209-6142fad80941	2012-11-21 00:00:00
13541	4028 Rosina Court	\N	Beverly Hills	9	90210	E6100000010C08D467B3F70841409255A13953925DC0	daba52bc-924f-43c4-84b7-2e9f6124dc23	2014-05-17 00:00:00
13542	8433 Kenmore	\N	National City	9	91950	E6100000010C5AB997FE9E5B4040BA6EF4CD1B455DC0	c2657e2b-0c49-4b9a-8121-cb979a43e2e6	2014-01-04 00:00:00
13543	60bis, rue des Peupliers	\N	Colomiers	117	31770	E6100000010CBAFADDE79CCC454002F0EDEFEC3BF53F	bc4d3317-4e6a-4c1f-8482-4304ef73607d	2013-12-21 10:09:29.423
13544	4802 Haynes Court	\N	Beaverton	58	97005	E6100000010C241E9EAD60B746407BE6E1C033B05EC0	1589bee9-fbb3-41c5-afb7-734ec507fadf	2013-11-19 00:00:00
13545	9461 Rose Ave	\N	Lebanon	58	97355	E6100000010C1DDE9479E73D46402BBA9DC598A95EC0	5e63a1b9-44c6-465f-ac4e-c1f86f83d9d6	2013-06-10 00:00:00
13546	570 Guerrero	\N	Gold Coast	64	4217	E6100000010CE9833C5DE2043CC09F2C14558E2C6340	31249189-cb3d-4fb7-84df-5ab245906e4e	2013-03-31 00:00:00
13547	2391 Pepper Place	\N	Milsons Point	50	2061	E6100000010C4A01389975F240C030FD3E6420ED6240	69af7e89-eea0-4c7c-83e4-147390e50dbf	2013-04-25 00:00:00
13548	Postfach 22 99 99	\N	Leipzig	53	04139	E6100000010C00000000000000000000000000000000	ea672bb4-2ce8-41f5-bdb5-e87a509ed1f8	2013-11-24 00:00:00
13549	3978 Spring Hill Dr.	\N	Berkeley	9	94704	E6100000010C6DD6A7F4FBF04240E1CD216D0D8D5EC0	3b6d3a7c-92d6-484f-bedf-150a97980eef	2013-08-08 00:00:00
13550	6083 San Jose	\N	Haney	7	V2W 1W2	E6100000010C835012E672974840D538004F5E9F5EC0	54e08bc0-1f82-4692-9fe5-841077fe102f	2013-07-01 00:00:00
13551	5884 Madhatter Circle	\N	Lavender Bay	50	2060	E6100000010CEE017D7572F040C0697BA8117EE66240	f3916a6d-2782-4efd-bfa0-fc30dd93a0ee	2011-08-19 00:00:00
13552	997 Grasswood Ct.	\N	Watford	14	WA3	E6100000010CB1F2F1D725D249400659E5F68E09D9BF	bc3e1e29-135b-4422-8b14-c2c16f12a80c	2014-04-20 00:00:00
13553	530 Northridge Drive	\N	Spokane	79	99202	E6100000010CAB81546FEED74740F71CE1BBC3595DC0	94260b9c-93da-4576-9156-84ef70f80f1d	2013-12-26 00:00:00
13554	5697 Alovera Road	\N	Beverly Hills	9	90210	E6100000010CB35FF484260B414011D27B833DA25DC0	a2bf2515-ab10-43aa-a5e1-94462a019c28	2014-02-24 00:00:00
13555	4348 Via Romero	\N	Darlinghurst	50	2010	E6100000010C2D912DE934F540C0320F0326B7EA6240	42a8b2eb-411a-4edb-99f8-f2639df35925	2012-08-31 00:00:00
13556	5483 Cornwall Court	\N	Renton	79	98055	E6100000010CCE2047FB24BF4740A3F59FC558925EC0	72d6c8b3-0a63-471c-9f80-5d0c38b6562c	2014-03-14 00:00:00
13557	3561 East Avenue	\N	Bremerton	79	98312	E6100000010C35CBF244F6CB47401340294E36A55EC0	8823ffd2-fae1-481b-915e-a5aea52b8619	2012-06-20 00:00:00
13558	2454, rue Lamarck	\N	Saint Ouen	127	41100	E6100000010C74FC8DB1D4ED4740B43CB394505BF13F	3d13c34d-393e-4616-8926-86abe0b5367d	2013-12-21 10:09:29.423
13559	1933 Landover Lane	\N	Rhodes	50	2138	E6100000010C00849EF175F140C0B719B2F7AAE66240	7014ad28-d51c-4de5-8635-6eb337b0c0ed	2013-09-20 00:00:00
13560	3601 Stinson	#7	Langley	7	V3A 4R2	E6100000010CB4D0E9C5C68D4840E02504FFC5A25EC0	24195b26-838d-4a04-b08d-2cf3872c723b	2013-08-17 00:00:00
13561	8411 Mt. Orange Place	\N	Coffs Harbour	50	2450	E6100000010CE17459CC472D3EC096CFD7A77D1D6340	79cf05b3-f97e-44a4-be77-fc703c19ac2f	2012-03-27 00:00:00
13562	4588 Morgan Territory Road	\N	Newport Beach	9	92625	E6100000010CDD443FC917C9404010CB3D27C4765DC0	ba9dee5c-e221-4b76-a19f-f313f8ca59ce	2012-04-13 00:00:00
13563	7538 Sherry Circle	\N	Santa Cruz	9	95062	E6100000010C6EC52FDA3B7B424084B8DD0C2E7D5EC0	a525956a-df4b-464b-b736-9d53607f630c	2013-01-26 00:00:00
13564	6124 Clay Road	\N	Long Beach	9	90802	E6100000010C2841939776E240409FC6F887C9835DC0	66ca2cf1-0894-4d71-b551-71112b32f7b2	2013-08-24 00:00:00
13565	1312 Garland Dr.	\N	London	14	SW8 4BG	E6100000010C07940A7A6CC049408024B3259CBBC2BF	d314f2da-362e-4eaa-b8fd-15e3fb059434	2014-06-13 00:00:00
13566	448 Roanoke Dr.	\N	Melbourne	77	3000	E6100000010C66446C7B5AED42C07E287B4C52256240	d046aca4-97c6-4e8e-bce2-48b80ce8999d	2014-02-17 00:00:00
13567	9328 Attic Rd	\N	Royal Oak	7	V8X	E6100000010CA8426E87D53C4840EA4F209421DE5EC0	d6a0fa7d-41d6-4ecf-a1de-4005a38ccdce	2013-07-04 00:00:00
13568	Kappellweg 242	\N	Hannover	53	30601	E6100000010C00000000000000000000000000000000	4ed62a68-591f-4893-8977-5627ed959dd3	2013-12-23 00:00:00
13569	6938 Hilltop Dr	\N	Puyallup	79	98371	E6100000010CA6D67385E096474066759732399E5EC0	d68d6c68-63b2-4c7f-915f-619a6e554918	2014-04-30 00:00:00
13570	8377 St. Raphael Drive	\N	Burlingame	9	94010	E6100000010C9D44B2B0DDC64240323FA82B3C905EC0	02b2e09b-0a34-4ad5-aa6a-9227950a7108	2012-07-13 00:00:00
13571	5056 Anchor Ave	#511	Lemon Grove	9	91945	E6100000010CD4148901015840405AF299067E4D5DC0	91dfad3a-a1c4-49b2-8b56-f665fa673faf	2014-02-22 00:00:00
13572	8498 Mcneil Pl.	\N	Lieusaint	163	77127	E6100000010CF31D9A985F4748407EAB8BCDFC6A0440	a4b70a37-81b1-4543-bba4-1b1812e6b02e	2013-12-21 10:09:29.423
13573	Buergermeister-ulrich-str 2945	\N	Frankfurt am Main	70	60075	E6100000010C00000000000000000000000000000000	e1020e54-af50-494a-a559-2956752a205d	2013-10-04 00:00:00
13574	9715 San Francisco	\N	Concord	9	94519	E6100000010C37911ADDEF0443402E604B77AC835EC0	02fb4362-28fc-4952-8804-c0dd3d39e732	2014-06-16 00:00:00
13575	6337 Hill Dr	\N	W. Linn	58	97068	E6100000010C4CB1F3AC10B04640A86C0B64BDAB5EC0	07d22417-023e-471f-bc03-9ff1095774b8	2012-01-05 00:00:00
13576	4144 Show Rd.	\N	Hervey Bay	64	4655	E6100000010C30B0CA2CF85239C087DB10AA13166340	3ad1d462-2194-4bdc-aa00-cdf04120b9b9	2012-03-01 00:00:00
13577	1251 Alan Drive	\N	Warrington	14	WA1	E6100000010CF1F2E09A0BAA4A408DC1DA98808604C0	4fd4f0a8-b92f-4223-aed0-790e6070cf78	2014-02-26 00:00:00
13578	Brunnenstr 7566	Verkaufsabteilung	München	19	80074	E6100000010C00000000000000000000000000000000	5f00ade2-62c9-40d3-ba52-ac3db5a6bd29	2014-06-15 00:00:00
13579	66, avenue du Québec	\N	Burlingame	9	94010	E6100000010C5A6556840EC24240599BB72A1A8D5EC0	95e57366-093b-4929-b455-d9e1668e8fcc	2013-11-11 00:00:00
13580	2030 Hill Drive	\N	Seattle	79	98104	E6100000010C6F67AAE2B0CF4740A3727753929E5EC0	8c7803cf-006d-4879-8f80-e69049b769e2	2012-11-16 00:00:00
13581	8486 July Loop	\N	Hawthorne	64	4171	E6100000010CDC585E1C3C793BC0F3A79B261C206340	8f0b1b1d-0ae4-46ef-976c-31e7e7d64f4d	2012-09-28 00:00:00
13582	9639 M St.	\N	Burlingame	9	94010	E6100000010C7AA4C4ECD3C742403F35112DEF945EC0	31513982-90f9-4490-b7ec-679d07272e74	2014-04-02 00:00:00
13583	5010 Orange Street	\N	Chula Vista	9	91910	E6100000010CD10910FCA45440408AD906025E435DC0	cd47d95c-4c45-4550-9112-bd20b411104a	2012-11-09 00:00:00
13584	9531 Tri-state Ave	\N	Chula Vista	9	91910	E6100000010C92B741D78A4D40407F05FF759C485DC0	f58e29ed-0a40-4d25-bc7b-3dcbaee54e84	2013-07-26 00:00:00
13585	1306 B St.	\N	Malabar	50	2036	E6100000010CB23B7D6207FA40C0D20C9371D0E06240	35265469-11fe-425e-86a3-cfdc311a6779	2014-06-01 00:00:00
13586	9852 Shirley Dr	\N	Downey	9	90241	E6100000010C6E824578BFFD404084EB8AFC6B7F5DC0	d6acbcb2-5c10-457f-a1c1-fc587a0365b8	2013-08-14 00:00:00
13587	7559 Worth Ct.	\N	Bellflower	9	90706	E6100000010C2A5F95BE3AF740400A7C8F4742845DC0	0830c87e-26dd-444d-9ed4-f93c0ca50414	2012-05-18 00:00:00
13588	9639 M St.	\N	Vancouver	7	V7L 4J4	E6100000010C23D6FBDC209F4840F97AE8952EC05EC0	60baa6f2-4787-4d4d-804f-750c5123cb88	2013-10-15 00:00:00
13589	5061 Athecton Circle	\N	San Diego	9	92102	E6100000010C93D85F94D3574040CFEAC81331485DC0	91b006c2-e64d-41e0-8b5f-c170f86060eb	2014-04-15 00:00:00
13590	291 Ironwood Way	\N	Lavender Bay	50	2060	E6100000010CCFE08B4C6AED40C0697BA8117EE66240	eb09ba68-c7ea-4330-87b9-22629c5ee6c6	2013-11-22 00:00:00
13591	7757 O Ct	\N	Hobart	71	7001	E6100000010CC00BDAC0576C45C061830314F86A6240	3629f3a3-28b4-4d80-ac48-dd087ded2f51	2013-02-09 00:00:00
13592	6088 Gonzalez Court	\N	Port Hammond	7	V6B 3P7	E6100000010C25D9C89DD0A9484006DD39E46ACD5EC0	f4be93d1-42ed-4d85-b720-403ea867197f	2013-11-27 00:00:00
13593	6191 Story Lane	\N	Burnaby	7	V3J 6Z3	E6100000010C362E8090709848405972E44596B35EC0	c12fa4a4-d6ec-4d11-be58-65883444354c	2013-11-18 00:00:00
13594	281 Windsor Drive	\N	Spokane	79	99202	E6100000010CAED70C9570D44740BFC559F2335F5DC0	7dc597a6-8d0f-4bcd-a0d9-433b981b16ec	2014-03-18 00:00:00
13595	3485 Sands	\N	Seattle	79	98104	E6100000010C795547EFB3C4474080362C6FC5925EC0	c47e4149-c34e-4d9e-9fb9-19b676c00346	2014-04-25 00:00:00
13596	7591 Signal Court	\N	Townsville	64	4810	E6100000010C9187A0730C3533C0710B14D6CE516240	35854b61-d7f4-49c2-b865-57fe3627c6a7	2013-05-20 00:00:00
13597	5458 Gladstone Drive	\N	Braintree	30	02184	E6100000010CEE15C34E371C454076BF79657DBB51C0	86b52c80-5baa-4543-be12-09955a2f8daf	2013-04-07 00:00:00
13598	4980 Olivera Rd	\N	Seattle	79	98104	E6100000010CEE4CE1BF3BCD47406282BA744A8D5EC0	4228ffd7-0850-46b9-bac5-a54e9ab51a79	2014-03-28 00:00:00
13599	Auf den Kuhlen Straße 19	\N	Darmstadt	19	64283	E6100000010C2A0EF6F384F44840C166ED8D64542140	5447eb32-99f3-4cab-9f13-5434f9e98b45	2014-05-27 00:00:00
13600	99, avenue du Président-Kennedy	\N	Bobigny	179	93000	E6100000010CFB3DED96C8744840BA72F5B464810340	4f6e4082-86fa-4f0f-9a46-e634348aca33	2013-12-21 10:09:29.423
13601	3, rue de Maubeuge	\N	Paris	161	75007	E6100000010CAE92A753A96D48405AA7B1CD65B60240	6526f68a-cbbd-44cf-a278-36061c335306	2013-12-21 10:09:29.423
13602	Rehstr 1346	\N	Eilenburg	85	04838	E6100000010C376ED6C492C8494066492A68485C2940	5a7bad54-61f5-4ffe-a45c-4e8237da14a3	2013-02-13 00:00:00
13603	833 Boxwood	\N	Bellflower	9	90706	E6100000010C275A1FAD8DEE4040FF13BE2F938C5DC0	74ff4e52-f040-4865-8075-8282125380cd	2013-11-07 00:00:00
13604	2844 Barcelona	\N	Lynnwood	79	98036	E6100000010CC626940C0DE84740FF3F80906E905EC0	ed818807-71f8-46f9-a8cb-20410f70f949	2014-05-06 00:00:00
13605	Königsteiner Straße 750	\N	Neunkirchen	70	66578	E6100000010C58B4B2A818AD4840A6516F97FF741C40	ffbaafc8-a99a-42de-ac19-a4075283607d	2014-05-19 00:00:00
13606	9152 St. Patricia	\N	Cloverdale	66	6105	E6100000010C69A0EE029AF53FC09E89557146045D40	ab14cd1e-d1aa-41de-994b-c6335e667398	2013-05-23 00:00:00
13607	9063 Vista Aven.	\N	Hervey Bay	64	4655	E6100000010C55E9665E445439C087DB10AA13166340	985925f0-25ec-499e-8940-22810cb4b8dd	2011-11-12 00:00:00
13608	33, boulevard d´Albi	\N	Paris	161	75007	E6100000010C6E951C54D6644840BE509614BE790240	ef3f68dd-2bdd-45ec-816b-8064e21df4a3	2013-12-21 10:09:29.423
13609	Postfach 99 01 01	\N	Darmstadt	19	64283	E6100000010C2A0EF6F384F44840BCB7E70E344A2140	452056b9-bf78-42f3-bf8a-e0cdf420d5cd	2012-09-12 00:00:00
13610	5407 Cougar Way	\N	Beverly Hills	9	90210	E6100000010C1469FE92E50C41403A0AD5636B9B5DC0	a0906af5-2470-4c28-ae3b-9b488f5c1f9e	2013-09-23 00:00:00
13611	8713 Book Street	\N	Burlingame	9	94010	E6100000010C49955FA289C242403F727BAA518C5EC0	0de182b6-5f82-4ce8-9966-b0e4fd41fa42	2014-03-17 00:00:00
13612	2284 Azalea Avenue	\N	Daly City	9	94015	E6100000010C93547EF3AFD2424052AD2A9D309E5EC0	f07effe0-db33-4f17-b10a-aff0aaef448a	2013-10-07 00:00:00
13613	108 Lakeside Court	\N	Corvallis	58	97330	E6100000010C706EB773B45946404F48DA1E81D55EC0	e9893e8a-b863-4e70-b394-1f417e1f1a3f	2013-03-21 00:00:00
13614	5802 Ampersand Drive	\N	North Ryde	50	2113	E6100000010CC9A1AB0B4EE640C0C5F1CC183FE46240	c5acb93c-c16c-47a8-a073-f84d8a0cd63b	2013-04-10 00:00:00
13615	9893 Hastings Dr	\N	Grossmont	9	91941	E6100000010C695A1652B263404047E8EFCCC7415DC0	89839bdd-68ef-4839-b6db-96ff9693c9d4	2013-06-15 00:00:00
13616	7970 Madrid	\N	Redmond	79	98052	E6100000010C9FEEBD0370DD474010F123CACB865EC0	e8f77d4d-0097-4092-8481-15aa20bc35ca	2014-01-01 00:00:00
13617	8998 Adobe Drive	\N	Grossmont	9	91941	E6100000010CC84243AD1D64404091809E66C5475DC0	49230557-d76c-4470-9890-8153f5ff6587	2014-05-04 00:00:00
13618	Waldstr 91	\N	Frankfurt	8	91480	E6100000010CD712D8DF35344A4020D2969F06E62C40	d169a6f3-7d03-4670-829f-06d897566bc8	2014-06-30 00:00:00
13619	Zollhof 1866	\N	Erlangen	8	91054	E6100000010C0F73ED98AFCF484007C14509C20C2640	522cbd97-ab2e-4197-b27f-4cc35474a9e2	2011-11-05 00:00:00
13620	535 Greendell Pl	\N	Fremont	9	94536	E6100000010C828AB84550C54240394BE925337A5EC0	704d4f29-e17c-440c-af8b-c721ae3456e1	2013-08-10 00:00:00
13621	6587 B Way	\N	Colma	9	94014	E6100000010C7E77B51F1FDD4240E94346BF339F5EC0	f51d08b6-5e4c-412f-a2e3-6b19092f1f9d	2013-06-18 00:00:00
13622	3739 Donald Dr	\N	Downey	9	90241	E6100000010C1C0CE2EDB4FA404067F2EDAA018A5DC0	4fbc545e-e285-444e-8d53-3767c76da91b	2014-06-21 00:00:00
13623	5234 Esperanza Drive	\N	Torrance	9	90505	E6100000010C2A0A292443E4404066A130BF439A5DC0	cad433eb-8adf-4fc6-aa58-bc9393e4fb75	2013-12-14 00:00:00
13624	9396 Race Road	\N	Bendigo	77	3550	E6100000010C0F41A3F0E75942C02F08245A860D6240	b0bc2264-839b-4696-b36a-979d3f09ee8d	2011-10-30 00:00:00
13625	8859 Poncho St.	\N	Perth	66	6006	E6100000010C9572597365F43FC078357EAF8EEB5C40	e8e31476-112c-4f2c-b13a-eafcb2c46c99	2013-09-29 00:00:00
13626	1349 Steven Way	\N	San Carlos	9	94070	E6100000010C1D32A4528AB942400A11E1E9568C5EC0	7e78fd48-736c-4c96-b802-254eda2f775c	2013-09-28 00:00:00
13627	3098 Eastgate Ave	\N	Puyallup	79	98371	E6100000010CCA31EE3CAB954740C9024D95378C5EC0	39ce2824-6296-45d2-9f0f-7dfb5d520c4f	2011-12-04 00:00:00
13628	4155 Working Drive	\N	Lake Oswego	58	97034	E6100000010C149E53DAB6BC4640E7AB995F55A55EC0	a914cceb-71ac-4e00-beb8-49fa72dba6f3	2013-09-13 00:00:00
13629	8814 Fieldbrook Pl	\N	Woodburn	58	97071	E6100000010CC30DCB51F397464061A4D853C5BF5EC0	b5b8e62b-aa24-44f4-82cb-77c3fb853b67	2014-04-22 00:00:00
13630	8316 La Salle St.	\N	Burlingame	9	94010	E6100000010C30036A097CD0424092EE0FB13FA25EC0	550f1df7-de62-4190-b543-e5cd72ab4f29	2013-07-25 00:00:00
13631	8674 Marina Vill Pkwy.	\N	Hawthorne	64	4171	E6100000010C6EC68665B8753BC0685CC2DAB81A6340	a0511c6b-7c8a-4eb6-b84c-e4a1b535c3d1	2014-03-15 00:00:00
13632	5436 Via Del Verdes	\N	Leeds	14	LE18	E6100000010CB1B90F1294EC4A40E26EE1D4C2BCF8BF	3bd3189a-8f4e-4f9e-b2f0-197058c5812f	2013-11-10 00:00:00
13633	591 Merriewood Drive	\N	Lavender Bay	50	2060	E6100000010CEE017D7572F040C08A3D8EDBD8EA6240	86925da0-521f-4c1e-8d9e-bbd285de8e2d	2012-07-29 00:00:00
13634	312, rue Villedo	\N	Les Ulis	177	91940	E6100000010C8421492FB65F4840F2BCAC6053570140	4030e331-4081-4950-9b5e-c4f6ec33ce53	2013-12-21 10:09:29.423
13635	350 Pastel Drive	\N	Downey	9	90241	E6100000010C5BCE9607E1FC404004ACAAF58A8E5DC0	943581b5-6469-4ce0-a65c-7b939fe21f0e	2014-05-08 00:00:00
13636	8307 Monument Blvd.	\N	London	14	EC1R 0DU	E6100000010C045EDDC5E8C44940BB1C486F671EBBBF	e2aab8a4-c525-4228-ac13-b367349e4bfb	2014-02-06 00:00:00
13637	9882 Clay Rde	\N	Novato	9	94947	E6100000010C3C19B192AF13434012CD3C4A779C5EC0	06ba69cd-8b5b-49ab-b5da-8701d1ea7931	2013-07-03 00:00:00
13638	5050 Mt. Wilson Way	\N	Spring Valley	9	91977	E6100000010C4AB096CF285E4040BE8848CBC73E5DC0	a77857b0-6f64-4fb6-9030-255d17974023	2013-12-24 00:00:00
13639	2190 Waterfall Way	\N	Cloverdale	66	6105	E6100000010C20B3DE08C20140C0FFD439B4DAFC5C40	ac195de9-a2cc-4cca-bdb2-a6a425361715	2013-09-07 00:00:00
13640	7396 Maine Dr.	\N	Beverly Hills	9	90210	E6100000010CD88921440213414031CEC35563985DC0	2d81fc8b-23c5-4706-87b2-041ea4e3a536	2013-09-05 00:00:00
13641	16 Woodside Court	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	53dac4e3-a234-4df9-8ab8-1ce87d2a7117	2013-03-22 00:00:00
13642	4836 Marina	\N	Corvallis	58	97330	E6100000010C886B1445D84A464055CA07D964DD5EC0	44497cb4-1974-4123-80c3-b5ed7968d667	2013-10-25 00:00:00
13643	2913 Mountain Spring Road	\N	Renton	79	98055	E6100000010CFA37073E94BB4740020C56DB77825EC0	26398b5e-de39-4e65-a50c-1f828d321778	2014-01-20 00:00:00
13644	5609 Huron Dr	\N	Westminster	7	V3L 1E7	E6100000010C5D17DE67FB97484092EB485C6EB85EC0	1f59cfc1-c0b3-4f5c-8311-75c38b0fc1d3	2013-08-07 00:00:00
13645	591, rue Lauriston	\N	Les Ulis	177	91940	E6100000010C355D69BDA05248400DA6A9268F510140	4378a36e-d5df-4893-9e73-7a3b87cd4cdd	2013-12-21 10:09:29.423
13646	3941 Teakwood Dr	\N	Lakewood	9	90712	E6100000010C6358FC64E1ED404066425BC20B815DC0	f3f0645e-0db8-4a8e-ac4a-73c548d0e05b	2013-04-06 00:00:00
13647	6891 Ham Drive	\N	Coronado	9	92118	E6100000010C2F4829195259404050C64E6AEC405DC0	981bcaac-311a-48dd-8c4d-e635b6492139	2012-06-11 00:00:00
13648	5477 Limewood Place	\N	Redwood City	9	94063	E6100000010C1328341481BA42400672F1E65D985EC0	a8fa4df4-e8cc-4d47-983e-0c2ed15e27ad	2013-08-06 00:00:00
13649	11, rue Descartes	\N	Saint-Denis	179	93400	E6100000010C0AA2BE2A6E794840D4E0642DF9AC0240	3347f6fe-ef65-48a9-a4d5-2e3c5ccc2e6b	2013-12-21 10:09:29.423
13650	8681 Harvard Court	\N	N. Vancouver	7	V7L 4J4	E6100000010C5A795985E8AE484073B1B2499BBE5EC0	13d7263f-7844-4634-bfbe-2f3b211e79ae	2013-12-05 00:00:00
13651	177 11th Ave	\N	Oregon City	58	97045	E6100000010C65B79981DFA84640C784984BAAA65EC0	3bcabb9d-5e0d-41b8-a648-bb23277b1ad0	2014-05-10 00:00:00
13652	7775 San Ysidro Court	\N	Bury	14	PE17	E6100000010C8644F2672CCC4A40D2A557C4CA6C02C0	b7d29621-88d1-4e48-bc47-6478f01d95bb	2012-10-23 00:00:00
13653	6291 Winter Lane	\N	Edmonds	79	98020	E6100000010C160A1A4760EE474076F453B9578F5EC0	7fc4e42e-e5ed-4e6f-bf85-90b317b4d310	2013-07-22 00:00:00
13654	1101, rue Lauriston	\N	Sèvres	178	92310	E6100000010CE5582BEEF2604840D707A7B56BB30140	2d652161-bdb2-4dab-a0f0-71dfff88896d	2013-12-21 10:09:29.423
13655	8756 Nottingham Pl.	\N	Burien	79	98168	E6100000010C081A5593B7BB47400E28DC6695905EC0	37340e43-f535-4076-8bf8-ca3642d2782a	2013-07-28 00:00:00
13656	8040 Hill Ct	\N	Grossmont	9	91941	E6100000010C538DCEB03E5E40406307FD4C86455DC0	e14b3ba8-bbce-4d25-a5d7-404e869ebd01	2014-04-08 00:00:00
13657	4409 North Ranchford	\N	Lynnwood	79	98036	E6100000010C54776C4FF2EC4740264380C3D2875EC0	8d0f841d-3102-4e47-8fcc-22e4f6597419	2013-10-09 00:00:00
13658	9032 Santa Fe	\N	Runcorn	14	TY31	E6100000010C97D247BCEEA84A400EBCB63125B105C0	63099b71-72a7-4239-87ec-38f13844fdda	2012-08-29 00:00:00
13659	9068 Quiet Place Drive	\N	Burlingame	9	94010	E6100000010C99E3325599CD42405821E32F559E5EC0	89537297-4abe-4af7-b3f8-8d1d70d98cfe	2013-09-18 00:00:00
13660	1225 Santa Lucia	\N	Caloundra	64	4551	E6100000010CBF069CBE36D03AC0FD9C7C314E2A6340	668c51d6-75a5-4add-b42f-6e787086cedf	2012-02-21 00:00:00
13661	5690 Morgan Territory Rd	\N	Lake Oswego	58	97034	E6100000010C92F2DB6570AC4640513EB663C1AE5EC0	0ae681cb-a1e0-4b52-92f3-ec9fd73728f3	2013-11-14 00:00:00
13662	4855 James Court	\N	Roncq	145	59223	E6100000010C45E60CE524664940F1A91EFC3EEF0840	be8c6b3d-f5fa-4d88-aa01-65accf832612	2013-12-21 10:09:29.423
13663	3260 Fountainhead Court	\N	Colma	9	94014	E6100000010C60E11E9D5ED642408638776572935EC0	d4dc0970-a125-4759-9f3f-8701247d8484	2013-10-09 00:00:00
13664	8307 Medina Dr.	\N	Berks	14	SL4 1RH	E6100000010C57FF7BDCACC74940CCBC92512D8CE3BF	f6cbbcce-a366-489b-b674-ec20186792bb	2013-07-05 00:00:00
13665	137 Mazatlan	\N	El Cajon	9	92020	E6100000010C2E26D82A626A4040721957211D405DC0	26b1a0c5-07d9-4d9f-bf8a-ceef987ba8b6	2014-03-09 00:00:00
13666	7959 Driving Drive	\N	Bellflower	9	90706	E6100000010CAF5CDA35E4F240407E48F9E386865DC0	0df1fd6d-26e7-4e9a-ae57-0f8a76280941	2012-10-12 00:00:00
13667	Nollendorfplatz 5118	\N	Berlin	53	14197	E6100000010C63B9E756F53B4A4077F167C318B32A40	dc1b5108-4376-4032-bf9f-263b8be8ef4c	2012-08-01 00:00:00
13668	834, rue Mazagran	\N	Drancy	179	93700	E6100000010C13D84F3C967A48408EC0ABFC93950340	11a195d6-27c9-4ef3-970e-207ee25ddaf9	2013-12-21 10:09:29.423
13669	101, avenue de la Gare	\N	Peterborough	14	PB12	E6100000010C65663907413F4A40AA12C44D2EF8CFBF	ff7ef947-f12e-499a-ba4e-1584824cc566	2014-05-18 00:00:00
13670	5863 Sierra	\N	Portland	58	97205	E6100000010C0E68E06C99C5464071513BFC83B85EC0	46dbcc88-411a-43f3-8546-1de88b56178c	2014-06-23 00:00:00
13671	3398, avenue de l´Europe	\N	Paris	161	75003	E6100000010C5977D04EA76A4840FDF40D3F32E40240	549c117b-cfbb-447a-b3c7-19e991a3de92	2013-12-21 10:09:29.423
13672	Lützowplatz 5938	\N	Berlin	70	14197	E6100000010CC4688E8D14444A4020764280BDB32A40	29db6d34-fc0c-484c-89cf-c78f593de34d	2013-09-27 00:00:00
13673	4195 May Way	\N	Beaverton	58	97005	E6100000010CA45C93BA05C34640FF71FE24A2B95EC0	a809cf35-e883-4174-bab7-b98d72f51ee5	2013-12-15 00:00:00
13674	7145 Matchstick Drive	\N	Long Beach	9	90802	E6100000010CA35F7DA02AE14040064B79951B8C5DC0	3c506a4c-610c-404d-9049-2acd6cb6654a	2014-03-13 00:00:00
13675	8386 Candelero Place	\N	Tacoma	79	98403	E6100000010C3372770993A147405BBB5DDCDC9A5EC0	bdf79630-9ec5-4f00-ad3f-55c229ca4b44	2013-10-27 00:00:00
13676	Auf dem Ufer 164	\N	Darmstadt	19	64283	E6100000010C1E254DE4AAE948400965A8D667502140	17abfedd-2a32-4617-8db2-71c4d2ad64cc	2013-10-31 00:00:00
13677	4333 Coastal Blvd.	\N	Novato	9	94947	E6100000010C3E86C72EBC11434075632C65AE9B5EC0	a8cd8a4d-58b8-4f7d-9b49-bc36312b011d	2013-07-06 00:00:00
13678	7791 Running Springs Road	\N	Goulburn	50	2580	E6100000010C236083C9C04941C04A8E840D5DAF6240	16a3fe0d-17d0-46e1-8cba-c08aa2a2aae4	2011-11-28 00:00:00
13679	6312 Woodcrest Dr	\N	Cliffside	7	V8Y 1L1	E6100000010CF6B07B48A54A48406A94AA8E2CDD5EC0	9d5b3948-db45-4a0a-9d96-5c9f041ce7b8	2013-11-27 00:00:00
13680	2197 Clay Road	\N	Oak Bay	7	V8P	E6100000010C00603723CB3C4840C78AE92FFFDC5EC0	2ba1c536-f3db-41ec-96e7-50fbca2625bd	2014-03-28 00:00:00
13681	8564 Hickory Drive	\N	Long Beach	9	90802	E6100000010C33C58913D8DC4040D877ED0415895DC0	e1b04775-ea0b-4067-b0e9-55fc85147424	2014-05-09 00:00:00
13682	Potsdamer Straße 646	\N	Solingen	53	42651	E6100000010CE46F6EECD892494092D4EE31015B1C40	86354815-4169-4868-8aa3-16b729d6b4d7	2013-09-03 00:00:00
13683	569 Lunar Lane	\N	Burbank	9	91502	E6100000010C798B51B5B5144140AA217D1C408C5DC0	984f4a6f-39e3-421b-9ca5-20a3e29c3bd2	2012-07-06 00:00:00
13684	2639 Parkview Court	\N	Burlingame	9	94010	E6100000010CF1848D38F1C4424052E3982C5E935EC0	b80e73a5-18dd-40b0-9e44-3a965670939a	2012-10-08 00:00:00
13685	9846 Golf Club Road	\N	Burien	79	98168	E6100000010CD2777DA6ADB84740C841D0D5F9995EC0	e2f8e082-4d2c-43de-ad03-0a1864a56092	2014-06-12 00:00:00
13686	134 Peachwillow Street	\N	Findon	66	5023	E6100000010C77DA61BB117641C014F867E7824A6140	b130563e-0e6e-4613-a2e4-190e1eb3b0a0	2014-05-02 00:00:00
13687	26, rue de l´Esplanade	\N	Croix	145	59170	E6100000010C1525149EBB5C49405B0B8D34B1430940	2d7bf9b7-55f6-420c-ae1d-abd3fbc90362	2013-12-21 10:09:29.423
13688	1641 Overhill Rd	\N	Hawthorne	64	4171	E6100000010C5F25CA8250743BC009656A9EF7266340	c47afe0f-6836-4073-bcbd-6db412bdf1ce	2012-04-17 00:00:00
13689	7655 Greer Ave	\N	Berkeley	9	94704	E6100000010C585D76C903F04240AD0DA708CB865EC0	57bd141e-53e1-42fe-ae10-7c4650aeb3ac	2013-11-24 00:00:00
13690	4292 Oak Street	\N	Bellflower	9	90706	E6100000010C0E8338BF1BF24040517085ED9D875DC0	fdf26c19-a7fe-457c-ba10-39e8d04017a5	2014-01-04 00:00:00
13691	9459 Amhurst Way	\N	Langley	7	V3A 4R2	E6100000010C57AA4B5F4A904840F7E9500AFDA15EC0	97fd74f9-19d4-4d66-bb7b-104291c11d46	2013-07-24 00:00:00
13692	9295 Arcadia Pl	\N	Caloundra	64	4551	E6100000010CB7AC508F19CC3AC0F2D864ED81206340	f27b8212-4195-4292-ade9-eb8393dcc7c6	2013-01-21 00:00:00
13693	9246 Westminster Pl	\N	Palo Alto	9	94303	E6100000010CB017495007B542407BFAEEF0508F5EC0	f5aab7bb-4003-414f-bf6c-902e5f89a8ac	2013-07-19 00:00:00
13694	2341 Lindley Ct	\N	Sydney	50	1002	E6100000010C6978F71231F440C0BE0CEA0290E86240	dfe0d157-b99b-4d32-a561-84ee6cc8e2bc	2014-05-17 00:00:00
13695	7323 Alan Drive	\N	Burlingame	9	94010	E6100000010CC0E49F74E7C5424045ED2F2BAB8E5EC0	e8f0963a-f8e2-4dfe-879d-e71659c9b468	2014-03-11 00:00:00
13696	34, rue Lauriston	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	69dd1042-38c3-40d7-a4b8-c5594db24123	2013-12-21 10:09:29.423
13697	7364 Mason Dr	\N	La Jolla	9	92806	E6100000010C6B86278D4BEF40405DC166674C745DC0	8c9f06cb-0217-495e-ac53-c8917b498897	2014-01-22 00:00:00
13698	Postfach 8 11 99	\N	Frankfurt	8	91480	E6100000010C6F17D092A2DE4840F3A8E0D7C41F2540	1973762b-8c2e-4fab-8d05-f71c293459af	2013-07-23 00:00:00
13699	5, rue des Bouchers	\N	Metz	143	57000	E6100000010C7AAF5882E7864840B36B2ADB5EB31840	a2bae27d-842f-4965-9b4b-82ed4914c53c	2013-12-21 10:09:29.423
13700	8645 Michigan Blvd	\N	Langford	7	V9	E6100000010CE06474AA273D4840C47DF27AFBE75EC0	2934da91-3336-4f24-82fe-49cc84840a20	2013-09-04 00:00:00
13701	9887 W. 39th Street	# 24	San Francisco	9	94109	E6100000010CBF1A78524AE34240E9B6AA3F71955EC0	d777434b-358d-4e37-a297-3f6c64c40ea2	2013-03-15 00:00:00
13702	3092 Gabriela	\N	Glendale	9	91203	E6100000010CAC5579ED1D134140F1C5B8A8758C5DC0	48ee3d8d-e206-4561-9c10-f3282a06da1a	2014-03-19 00:00:00
13703	2957 Tri-state Avenue	\N	Cambridge	14	CB4 4BZ	E6100000010C70FE451F0B244A405F8AC616F86EBC3F	4526133e-3546-4aee-9f1a-19325fb19182	2013-08-23 00:00:00
13704	4587 Sunset Meadows	\N	Burbank	9	91502	E6100000010C0E760DBC5510414000E8830318965DC0	bf29611f-bf71-48f8-8a15-579978932017	2014-04-08 00:00:00
13705	702 Candle Dr	\N	Santa Cruz	9	95062	E6100000010C88D929FB8D754240FE413EECF57D5EC0	ae13c759-635f-4e7a-be33-03e88576d867	2013-08-22 00:00:00
13706	8866 Alpha Way	\N	Bellflower	9	90706	E6100000010C638ED0E349F04040067AA055998F5DC0	3aee471b-e58f-4d32-b655-846842272f16	2012-10-19 00:00:00
13707	5203 Foothill Way	\N	Bellflower	9	90706	E6100000010CF8256E76D1EC40407E48F9E386865DC0	284f2922-8b60-4b86-b74c-61e0ec144f63	2014-03-15 00:00:00
13708	2451 Vista Del Sol	\N	Marysville	79	98270	E6100000010C39B4778A7100484086B294F436835EC0	8fd286b4-16ea-4a3d-b691-8c797db75fc3	2014-05-01 00:00:00
13709	Galeriestr 6818	\N	Braunschweig	53	38001	E6100000010C00000000000000000000000000000000	ab1ebf31-8d34-4369-889b-abf06e53c6b6	2014-01-24 00:00:00
13710	508 Somerset Place	\N	Melbourne	77	3000	E6100000010C795AD9B569EE42C0FD5DF57F5C246240	bae8aaaf-9dfa-4d43-ab3f-36d2c203e923	2013-12-15 00:00:00
13711	8819 Camino Norte	\N	West Covina	9	91791	E6100000010C9BEC82C9320941405C5ABBD06A7B5DC0	e01a7da0-5dde-4fbf-8ea1-764a53a5590a	2014-04-08 00:00:00
13712	3478 Hillside Way	\N	Milwaukie	58	97222	E6100000010C7BAE25D99DBE464011064FBD84A25EC0	15b851be-4cd6-454a-9f8f-1517034fb00a	2013-08-01 00:00:00
13713	2304 La Canada	# 13	Silverwater	50	2264	E6100000010C2B98F72E528E40C0F708F60D18ED6240	282c1949-5920-4824-9eee-5a8700efbe59	2013-09-04 00:00:00
13714	1865 Scenic Ct.	\N	Bellingham	79	98225	E6100000010C85AFCB93815D4840BA9C616C74975EC0	d6da0343-6c56-453b-9589-77f4cc414cad	2011-10-28 00:00:00
13715	101 Adobe Dr	\N	Puyallup	79	98371	E6100000010CE9B39538209E474021CD8045BE985EC0	798abbdc-30d9-46e8-877f-cb6057fec311	2013-12-26 00:00:00
13716	5014 S. Villa Way	\N	Glendale	9	91203	E6100000010C96F423A29E0F4140D214918E45935DC0	93e0562e-f5ba-4df3-8a7a-9e3a61d4e261	2013-11-10 00:00:00
13717	4546 Vista Valley Rd	\N	Mill Valley	9	94941	E6100000010CC6D0E052CFF34240E88C56A3AD985EC0	d7fd957f-cf74-43fc-bd50-1cadf7825c36	2013-06-24 00:00:00
13718	1510 American Beauty Dr.	\N	Bremerton	79	98312	E6100000010C35C4C98386C94740F4E9BC8E48AC5EC0	8469cd5d-7dfc-4018-9ee8-0fa839dcb6a6	2013-09-06 00:00:00
13719	9713 Pome Court	\N	Port Orchard	79	98366	E6100000010C463DFFE25BC54740A5502E6FA6AA5EC0	c0359778-be30-4c78-9460-b1ce3a247b76	2014-04-23 00:00:00
13720	3570 Book Ct	\N	Hobart	71	7001	E6100000010CC8B0AB77706D45C0FBF70FEA706B6240	c192ecc6-282f-4d1b-9ffd-5611a701464c	2013-05-17 00:00:00
13721	9500 Normal Avenue	\N	Newton	7	V2M1P1	E6100000010C28E0DF3F0EFC4A40DAEFB1B279A65EC0	8234d1e8-f5aa-4893-a4ff-7dde18ef435d	2014-03-16 00:00:00
13722	6951 Harmony Way	\N	Hobart	71	7001	E6100000010CD0557D2E896E45C0966C1CC0E96B6240	3b974347-1615-4046-b89a-a640189a5d2f	2013-07-05 00:00:00
13723	7577 Camino Bonita	\N	N. Vancouver	7	V7L 4J4	E6100000010C2BCC10C303AD48404C0E542E55C35EC0	58040e9e-d582-469d-bf40-970bdfcf25df	2014-03-26 00:00:00
13724	54, avenue du Port	\N	Paris	161	75017	E6100000010C1DC081F7116F484088D39E4F4E7A0240	ce47f50c-ef4d-43a9-ae5d-5a0f1791d4d7	2013-12-21 10:09:29.423
13725	5684 San Marino Ct.	\N	Burien	79	98168	E6100000010C8ED28D9802C34740C892A71869985EC0	a1f821a5-9aaa-42b4-ba3e-f12f74e4af84	2014-01-04 00:00:00
13726	274 Diane Ct	\N	San Diego	9	92102	E6100000010C34462DB4B96E40402090077796555DC0	34789b92-dca4-4bb4-b4b8-917348e7e7ea	2014-05-22 00:00:00
13727	2139 Birdwatch Ave.	\N	Oxford	14	OX14 4SE	E6100000010CC216131E92CC4940990521A12487F4BF	9a51a449-65fe-4941-961f-0657593a8c37	2014-03-23 00:00:00
13728	6594 Bent Tree Lane	\N	York	14	Y024 1GF	E6100000010CB1E2D195F4F74A4089D451C14F57F1BF	c5544ea8-6c5f-4715-a68c-59c1c8afa5c5	2013-11-15 00:00:00
13729	4540 Wood Ranch Circle	Space 51	Everett	79	98201	E6100000010C165AA9E38A0048403C49CAC6E78C5EC0	f1f16850-6755-4160-b4cb-46186e50ce90	2014-03-31 00:00:00
13730	7490 Sharon Dr	\N	La Jolla	9	92806	E6100000010C5868BFADDCEE40408EB27AA2C56F5DC0	f9bb8873-4ca9-43ff-b6de-91c511c4bc61	2014-01-30 00:00:00
13731	1663 Park Glen Court	\N	Cliffside	7	V8Y 1L1	E6100000010C0EF1FC81BD3B48403252F9A054D15EC0	fa93a64c-1331-48cd-ae72-82f638361ee9	2014-02-15 00:00:00
13732	6076 Citrus Ave	\N	Woodburn	58	97071	E6100000010C581854F9F78C4640CD0B726C8BAA5EC0	2d8f2565-69ce-48a9-87f0-3f536e8852f8	2013-12-11 00:00:00
13733	1936 Bayberry Drive	\N	Haney	7	V2W 1W2	E6100000010CE7E1D8DF5F9E4840500180D3DBA45EC0	b0645ef1-10e5-40b9-aba4-41b1dad00fc2	2012-01-26 00:00:00
13734	66, rue Georges-Clémenceau	\N	Croix	145	59170	E6100000010CFFD1036D235A49402059CF73D4340940	f100df76-05ae-4f3d-b765-08abdffa2bfa	2013-12-21 10:09:29.423
13735	3432 NE 3rd Court	\N	Haney	7	V2W 1W2	E6100000010CF04D4148C891484032906DC4C7A85EC0	03a99c9e-91c7-45f8-9703-7bde70538961	2014-05-03 00:00:00
13736	9593 Power Ave.	\N	Lavender Bay	50	2060	E6100000010C3382FFB2C0E440C021310AF4B7DF6240	9e654ba6-03f6-43ee-8646-7b17586e3636	2013-10-07 00:00:00
13737	2111 Ringing Dr	\N	Warrnambool	77	3280	E6100000010CBFA7220128FF42C0EC013D6320CC6140	ce941502-83df-4568-8881-715598349f00	2011-10-23 00:00:00
13738	35, rue de Longchamp	\N	Les Ulis	177	91940	E6100000010C0EFACAC2A44D48405EAB96D1E3520140	27578b5b-0581-4937-9ebd-029ed08f1fa7	2013-12-21 10:09:29.423
13739	1296 Bishop Court	\N	Novato	9	94947	E6100000010CACDD1002750F4340B0B4645156A95EC0	4930ed31-6cb2-4e39-9fa7-d941f8e71be4	2013-10-15 00:00:00
13740	5008 Falls Ct	\N	Oak Bay	7	V8P	E6100000010CF4A551824132484068CE385C27E05EC0	ef8f3dfe-f2aa-434c-8dca-ab965fcc0fe5	2013-11-05 00:00:00
13741	7446 The Alameda	\N	Goulburn	50	2580	E6100000010C4EA35FD09C5241C096C3B7ADD7AF6240	e7b249c6-6df5-4862-ad23-86b632b544c1	2014-04-01 00:00:00
13742	6289 Duck Horn Court	\N	Newport Beach	9	92625	E6100000010C3CB3C3168ED24040FA05E47E07795DC0	6a83b67b-4339-45b0-9bed-c1bc5aacf2d4	2013-09-05 00:00:00
13743	9635 Rock Oak Road	\N	Bremerton	79	98312	E6100000010C021466F601CF4740D69350CF5AB35EC0	dcd12060-da08-49ae-aaba-221f52d3f34a	2013-09-11 00:00:00
13744	6920 Merriewood Drive	\N	Port Macquarie	50	2444	E6100000010C0428E6D8235C3FC0F9E1F73CB21B6340	1e6e30d5-c178-4def-a18a-d9b51a057e8e	2014-04-15 00:00:00
13745	33, avenue du Président-Kennedy	\N	Paris	161	75010	E6100000010C84A06FAF42674840067E253BBB4D0240	63e93081-a8f3-4d68-8dd7-d34e43bc01b8	2013-12-21 10:09:29.423
13746	6004 Peabody Road	\N	Hervey Bay	64	4655	E6100000010C55E8277F6D4E39C0A0BF47F37F196340	a9e205f8-6f91-4983-8335-2fc0305124d1	2013-10-23 00:00:00
13747	3859 Anyway Street	\N	Rockhampton	64	4700	E6100000010C9C0A1959E06F37C00B62B647F6D26240	1a02af56-0ed2-432e-8d42-099968f95f32	2013-01-13 00:00:00
13748	9189 Shady Ln.	\N	Cranbourne	77	3977	E6100000010CA31A6E47B61043C01FF27574A1286240	419cf5b2-12e9-4719-a5a4-d9109878e592	2011-12-03 00:00:00
13749	Zollhof 626655	\N	Saarlouis	70	66740	E6100000010CB0442DF4B2A448404E356C524FFF1A40	a843cfff-6a4a-41e0-8391-4f9fd9a959c1	2012-02-14 00:00:00
13750	1604 Crown Court	\N	Warrnambool	77	3280	E6100000010CD4811471900243C0A648702AF7D26140	6e1a9412-259e-47b0-9bf5-7966e7400b55	2012-11-25 00:00:00
13751	802, rue Descartes	\N	Colomiers	117	31770	E6100000010CE22611D707C745400D00CDD33A33F53F	b11d78f1-725b-4755-b80e-329079124f88	2013-12-21 10:09:29.423
13752	5680 Camelback Ct.	\N	Beaverton	58	97005	E6100000010C9409AE9FDBC14640278DF225B4B55EC0	d3c563dc-0831-4ee2-86a8-9564b6fdcbf6	2014-01-23 00:00:00
13753	5496 Village Pl.	\N	Burien	79	98168	E6100000010CD2777DA6ADB84740B1C3CDD01A8B5EC0	ec72690f-ce79-4735-9f7a-a5f444993a34	2013-08-17 00:00:00
13754	3576 Frigate Ct.	\N	Silverwater	50	2264	E6100000010CF664287C0C8D40C0E250EC3147E76240	9581db85-d494-4922-8190-db5a7c36341a	2012-03-31 00:00:00
13755	6422 Vista Diablo	\N	Hobart	71	7001	E6100000010C712DF077C36545C0169D739A376F6240	0528952e-35b0-44fd-a2bb-e3a00992e089	2012-07-30 00:00:00
13756	9183 J Ave	\N	Bremerton	79	98312	E6100000010CC16302697DD4474011CD98F9A3AE5EC0	f2e4e756-cee9-46b7-8399-04464eedae4f	2014-03-31 00:00:00
13757	6463 Landover Ln	\N	N. Vancouver	7	V7L 4J4	E6100000010C6892F82C62AC484080441EE2C1C15EC0	10f10295-61e1-403f-b3b7-1e8f80d3716f	2014-04-30 00:00:00
13758	4794 Curtis Drive	\N	Kirkland	79	98033	E6100000010C049EA8CE51DA4740A37A61DE2C965EC0	2da67c34-de18-44e3-b5d9-f93f96b7f26b	2014-03-07 00:00:00
13759	7102 Serrano Way	\N	Coffs Harbour	50	2450	E6100000010C9202B6C06B293EC085C58BEBEA206340	3c2b5812-fd4f-4154-a3b3-73be1e0714ed	2014-05-18 00:00:00
13760	7744 Lacorso Drive	\N	San Carlos	9	94070	E6100000010C5048DDF0D1BE4240AE51ED674B975EC0	96e449f5-cba2-4c72-bfd5-3c6641c92809	2012-05-09 00:00:00
13761	8985 Camino Segundo	\N	Sedro Woolley	79	98284	E6100000010CC724980D4D3D484032935DD7B0895EC0	139f3f73-d311-4f5d-bed1-68ec3b04d025	2012-05-24 00:00:00
13762	Galeriestr 6813	\N	Berlin	20	14111	E6100000010C00000000000000000000000000000000	bdac1783-5272-4787-854f-40fda2f2c9e1	2013-11-23 00:00:00
13763	33, place de la République	\N	Pantin	179	93500	E6100000010C9E7BA3379D694840E7E4507E09490340	05e4e808-6e12-44b8-a1c4-70e1dea88c3c	2013-12-21 10:09:29.423
13764	2190 Rock Creek Way	\N	Metchosin	7	V9	E6100000010C12D57B9F422E4840ABCC9BD60EDF5EC0	02ceca20-4fe8-4fc9-92f2-c7eb679bf52c	2014-04-06 00:00:00
13765	3558 Pebble Glen Drive	# 214	W. York	14	BD1 4SJ	E6100000010CC8E4DDE580E74A4039D8E375B502FCBF	3627895a-2d47-4683-aab6-5e203847198f	2014-05-24 00:00:00
13766	3686 Mac Court	\N	Cliffside	7	V8Y 1L1	E6100000010C549E76548A474840A60EA0247DD45EC0	3a5cb9e0-4a2a-4201-b243-5a44ffd2b5ea	2013-07-26 00:00:00
13767	22, rue Léo Delibes	\N	Versailles	164	78000	E6100000010CD6B79FA44F674840F40AA10948F00040	41d7a3d2-e86b-4c82-8706-afdca807d509	2013-12-21 10:09:29.423
13768	91, rue de Maubeuge	\N	Bobigny	179	93000	E6100000010CE30B3EFD856E4840AA4A98FDE3850340	cf1c35a1-e2ee-496f-a261-ee50d0a22109	2013-12-21 10:09:29.423
13769	7688 P St.	\N	Bendigo	77	3550	E6100000010C111067AB326542C0F5D653424A046240	652ff91f-f0e7-49ba-accc-7f8e4f6c19c0	2012-07-30 00:00:00
13770	1550 Cordoba	\N	Townsville	64	4810	E6100000010C644D54967A3933C04BE8CF67DE506240	82999709-8a03-4971-9b69-caf2b3910e6a	2013-05-05 00:00:00
13771	7917 Precipice Drive	\N	Concord	9	94519	E6100000010CDF849EED20FE4240D5FDF2C454815EC0	cb9cdebf-c3ff-4f01-8148-8d76bed96268	2014-05-17 00:00:00
13772	899 Park Blvd.	\N	Colombes	178	92700	E6100000010CF352B0D07C7A4840CF8F96F3E4F30140	bb2a8fc4-2843-4245-9bda-e47d10080e2e	2013-12-21 10:09:29.423
13773	Königsteiner Straße 449	\N	Frankfurt am Main	20	60082	E6100000010CCB938ABCAF0649407A880CF2451D2140	ff67c0f3-e0fa-44c7-aa8b-f7eb3c1f20ee	2013-09-18 00:00:00
13774	9199 Park Glenn	\N	Lebanon	58	97355	E6100000010CBC91E4A9084346402BBA9DC598A95EC0	9f199596-196e-4464-971d-44e9af3360c7	2013-01-14 00:00:00
13775	3920 Valley Run	\N	Milsons Point	50	2061	E6100000010C1FA98EF5F5EB40C0067CD62318EE6240	3a120a95-530a-4f6b-a340-4445f81c8719	2011-07-19 00:00:00
13776	4113 Pershing Dr	\N	Santa Cruz	9	95062	E6100000010C89A6C1C2EB7742402B05E2076D835EC0	ca1f5ccf-019b-41d3-b3b2-d1e6a919dcb9	2014-04-14 00:00:00
13777	Zur Lindung 6	\N	Saarlouis	70	66740	E6100000010CB0442DF4B2A4484072856E55D6041B40	a54c0b9b-051e-4a2c-b5a0-d7256fa2b2f0	2014-03-28 00:00:00
13778	8627 Shenandoah Drive	\N	North Ryde	50	2113	E6100000010C1FAF2256DFE540C0704480DD4FE26240	2e2f3ae8-cd94-484d-b158-30f0854e0076	2013-12-05 00:00:00
13779	2877, rue des Ecoles	\N	High Wycombe	14	HP10 9QY	E6100000010C2E07E30C1ED549402331B682AB43E6BF	82dfdfa4-d302-4c06-b281-8b8554f70104	2014-03-29 00:00:00
13780	9845 Oxford Place	\N	Lincoln Acres	9	91950	E6100000010C96BC14EE41534040CA4BAF63DA4B5DC0	9495f35e-a07d-4844-905f-5f3d7109d475	2012-12-12 00:00:00
13781	7922 Rancho View Drive	\N	Lemon Grove	9	91945	E6100000010C9CB13859B55E4040DE6091C53F485DC0	95a5b285-057a-4759-a5fa-4899140e5f69	2013-08-04 00:00:00
13782	7963 Elk Dr	#4	Versailles	164	78000	E6100000010CFE05A5D4905E484083BC295B38F70040	164513ec-df9a-4ba5-a89f-11ad152a1228	2013-12-21 10:09:29.423
13783	8468 Clifford Court	\N	Seaford	77	3198	E6100000010C3893C59D2F0E43C0CDB77992CF206240	92c32f56-aa5e-43e5-a593-1c6cc1b1f3ce	2011-11-19 00:00:00
13784	6580 Poor Ridge Court	\N	Rockhampton	64	4700	E6100000010C00AB8E4A156B37C0704E5EC82ECD6240	204bb3df-86f4-4308-a6e6-abceb88d8b54	2013-08-23 00:00:00
13785	8950 Olivera Rd	\N	Metchosin	7	V9	E6100000010CBA6EA7391E30484025DB5E7150DA5EC0	bb462f2b-0f5f-43a1-bda8-c020388248e2	2013-02-26 00:00:00
13786	1901 Delaware Drive	\N	Olympia	79	98501	E6100000010CF39F7257B38547401A479C9BC1B85EC0	36ed064f-f5ab-47f7-8279-e5f5aec6f51a	2014-06-13 00:00:00
13787	1660 Stonyhill Circle	\N	Coronado	9	92118	E6100000010CEE1F036DCF564040207527042C555DC0	63b52461-6391-4fef-92ab-52ad3eca99ab	2012-06-01 00:00:00
13788	37 Peachwillow Lane	\N	Beverly Hills	9	90210	E6100000010CD57B12AF6310414083A4253D15935DC0	049220d8-21b9-4c78-b773-e71036134b4a	2014-05-18 00:00:00
13789	188, rue de Linois	\N	Melbourne	77	3000	E6100000010C66446C7B5AED42C00151694877236240	64c138ec-99a1-4388-8843-ce4271602d69	2013-10-11 00:00:00
13790	98bis, boulevard du Montparnasse	\N	Paris	161	75013	E6100000010C6E68915FB6634840A94AC9B7FA990240	494ce77f-39d6-46fd-b8a5-41dd21feae0c	2013-12-21 10:09:29.423
13791	5186 Elmhurst Lane	\N	Issaquah	79	98027	E6100000010C690ED8A0C9BD474085129553E2765EC0	5c588462-3884-48a5-8389-5a9281ede38e	2014-05-25 00:00:00
13792	6061 St. Paul Way	\N	Wokingham	14	RG41 1QW	E6100000010CF9DE117F8CAF49402970CACF2C34EBBF	04bb4f67-fe2a-4d0d-a187-e66fc748b4e5	2014-01-19 00:00:00
13793	1301 Stanbridge Ct	\N	Berkeley	9	94704	E6100000010CD6339FCCD4F542409965365593875EC0	ee5360fa-207c-43e0-b218-15b1b0b08828	2014-04-07 00:00:00
13794	3050 Meadow Glen Way	\N	Bellingham	79	98225	E6100000010C3E31EC6A1F634840C27C7E0337A35EC0	4f018272-40b6-4d2e-b2fd-58c02f0f1ffe	2014-03-31 00:00:00
13795	Hans-Rosenthal-Platz 4297	\N	Mühlheim	20	63151	E6100000010C00000000000000000000000000000000	63c6bdea-df1f-4560-aa3f-cf2705391f49	2014-06-05 00:00:00
13796	4077 St. George Drive	\N	Woodland Hills	9	91364	E6100000010C5979397AAA0F4140DD8425092EAA5DC0	c8dc0b46-e987-4026-b6bf-409a68c0a5cf	2014-04-27 00:00:00
13797	5656 Via Delaware	\N	North Sydney	50	2055	E6100000010CC1E387895BF140C0E78A66BE1FE66240	c73dff03-d0ae-450d-a2e3-20b319962361	2014-02-17 00:00:00
13798	700 Oaxaca	# 17	Edmonds	79	98020	E6100000010C6A1C4C1C4EE047401747FF3464965EC0	caa5c735-61a9-422c-b9d6-7ee9e2fe5701	2014-04-20 00:00:00
13799	2457 Matterhorn Court	\N	Milton Keynes	14	MK8 8ZD	E6100000010C5296FB9813024A4001D53183F94CE7BF	969c2fca-fd01-4627-ac87-58d6ec67582a	2013-03-05 00:00:00
13800	7759 Azalea Avenue	\N	St. Leonards	50	2065	E6100000010C3DC7451CA6E340C017E5DF9009EC6240	6610b338-d9e6-4302-b1db-da9a9bfb075c	2013-07-13 00:00:00
13801	5834 Vine Circle	\N	Beverly Hills	9	90210	E6100000010CCDF48A64140F414029BF088E83A45DC0	d026c680-6c71-4f57-b908-4f413fcc6bb4	2013-10-01 00:00:00
13802	3230 Hamilton Ave	\N	Tremblay-en-France	179	93290	E6100000010CF02A50AF7D7948405512E447F96F0440	f3dd7aeb-778a-48af-ad6a-a82e79093073	2013-12-21 10:09:29.423
13803	2969 Broadmoor Avenue	\N	Burien	79	98168	E6100000010CCA2E2A1BA8C647406B2E9982EE925EC0	0b587f3a-f660-4935-bd28-5b0c17485e09	2011-12-10 00:00:00
13804	2755 Fairfield Ave	\N	Issaquah	79	98027	E6100000010C92EBF49C23BA4740F73F30C840805EC0	8a5725df-8221-4f33-8492-a0797a35f2ec	2014-05-04 00:00:00
13805	8176 Pena	\N	Langley	7	V3A 4R2	E6100000010C674AC05E93964840A45A9E33E7B05EC0	dfdaf831-2e00-4e8e-b42a-fd003151883b	2013-09-21 00:00:00
13806	1867 Sands	\N	Brisbane	64	4000	E6100000010CBC966B6B6F793BC08A516A3B5C196340	61701988-45f7-41ba-ab24-b52188868977	2014-05-10 00:00:00
13807	873 Wellington Avenue	\N	York	14	YO15	E6100000010C18F57F2C56F94A4078245B5CF959F1BF	87b41f68-a381-4124-b31a-7b2f41eebf58	2013-10-17 00:00:00
13808	9204 Pelican Loop	\N	Bellingham	79	98225	E6100000010C85AFCB93815D48402C451F213D985EC0	1ed3bb34-39e4-4298-a0ff-f7174b9e15e0	2014-01-18 00:00:00
13809	48, place de la Concorde	\N	Gateshead	14	GA10	E6100000010CC2432DF7BF824B40192AEE6EC69AF9BF	974d6f2f-b0d4-4d31-b0f4-ef0cd421589a	2014-02-27 00:00:00
13810	811 Via Cordona	\N	Springwood	50	2777	E6100000010C765FA8DB92D740C0146A9E8074D86240	ef07665c-86b6-4c09-a95e-7093d1a406cb	2013-08-30 00:00:00
13811	7207 Peabody Road	\N	Gateshead	14	GA10	E6100000010CC6B384F1F9734B40BD5AE478CE98F9BF	434f1199-980f-43c0-b519-814852223262	2014-02-22 00:00:00
13812	6058 Foothill Way	\N	Suresnes	178	92150	E6100000010C51E8BE5B3D7148408FC2D98FB7BC0140	9d10832d-c1c0-4d3f-963b-cb37b25f9ed4	2013-12-21 10:09:29.423
13813	3396 El Dorado Way	\N	Beaverton	58	97005	E6100000010CF3668B41C8BD4640E901D6C145AC5EC0	80e59ce9-a315-4f3f-992c-aedbc90b8d90	2014-02-11 00:00:00
13814	8581 Paris Lane	\N	Cloverdale	66	6105	E6100000010CE634EFACB1F93FC0301D7899D2FF5C40	ff93138c-82ef-428b-9ca7-e1e6d526bcc2	2013-10-14 00:00:00
13815	6600 Chestnut Ave	\N	Oxford	14	OX1	E6100000010C4C4D1D2EB0D74940F453B788B34EF3BF	0faa763d-c827-4c4b-ac8d-ec3a16ac4d4c	2014-05-25 00:00:00
13816	7530 Eola	\N	St. Leonards	50	2065	E6100000010CB6B439F7E7EE40C0E55160247DED6240	57b24374-aa6f-4a73-9981-a0360139f27a	2011-10-01 00:00:00
13817	Postenweg 3138	\N	Frankfurt	19	60323	E6100000010C80D3DAD53208494015960A28DA502140	1df6104b-fde0-41f1-8c70-26a11c73f326	2013-02-18 00:00:00
13818	1555 Lace Drive	\N	Bremerton	79	98312	E6100000010C28B67701A7C44740545A08A511B85EC0	089bf47a-57a4-4312-a79c-c938e0ea1818	2014-02-02 00:00:00
13819	Midi-Couleurs	\N	Goulburn	50	2580	E6100000010CEA703ACBF74B41C07A63518E47B16240	94ade5df-3ebd-425a-946f-a183073f346c	2013-08-20 00:00:00
13820	2328 California Street	\N	N. Vancouver	7	V7L 4J4	E6100000010C0B3867A898A848400FF36ED41EC45EC0	db986052-d2d0-4b70-b0f8-f89cb8bdba91	2013-07-18 00:00:00
13821	4332 Listing Ct	\N	Langford	7	V9	E6100000010CD9FE6C5ED0384840430943C066E65EC0	15da2308-73d5-4c5c-9091-50ff94d3f507	2013-09-05 00:00:00
13822	791 Monte Cresta	\N	Imperial Beach	9	91932	E6100000010CA7699082964D4040769FAEEA153D5DC0	b6e9fcd6-df1f-4414-b706-d05b98b33cce	2012-07-27 00:00:00
13823	3853 Wildcat Circle	Unit 13c12	Lavender Bay	50	2060	E6100000010C5BD7FD898CEC40C0A9A464E096E36240	61268b43-2568-42e9-b8d3-413a78c0ce01	2013-12-10 00:00:00
13824	4348 Lilac Circle	#6	Hervey Bay	64	4655	E6100000010C4CB248EBA55E39C051A6E9BEA1136340	09360edf-df53-484d-8444-c89f1f0a0da9	2012-12-27 00:00:00
13825	5704 Lost Avenue	\N	Peterborough	14	PB12	E6100000010CF2A10B1DF2414A403DAA54D9EB05D0BF	5a220a40-d732-4bce-bff6-2a230c620c81	2013-12-08 00:00:00
13826	407 Redbird Lane	\N	London	14	EC1R 0DU	E6100000010C7C8218F64AC04940B9CFD8143D1ABBBF	77063eec-04a2-4774-b788-5d0f08cf3909	2013-04-12 00:00:00
13827	2581 Browse Ct	\N	Coronado	9	92118	E6100000010CDF7DB1FEAA5C404030D556356C4B5DC0	f9484877-d2c1-43d5-83ae-d9ec0ff059d2	2014-03-17 00:00:00
13828	404 Sunshine	\N	Long Beach	9	90802	E6100000010C5710D13A5FE340400F33F6DC26945DC0	2bb2686f-bb89-41e0-a36e-198dbe7cf769	2011-09-12 00:00:00
13829	191 Trail Way	\N	Cliffside	7	V8Y 1L1	E6100000010CF6B07B48A54A4840764394AFF6DD5EC0	95101bbb-06d6-4108-9538-2a20e38faf36	2011-08-01 00:00:00
13830	8267 Lavene Way	\N	Shawnee	7	V9B 2C3	E6100000010C9A7801B265364840ACDFA68BE9E65EC0	5bb6f9ce-37d2-4c66-8fbf-522b6d1cf1c6	2014-03-14 00:00:00
13831	363, rue de la Centenaire	\N	Paris	161	75010	E6100000010CC360AE81836A48400D20CC2939E60240	e308d7f1-d7e7-4e84-a982-6389a10c0c40	2013-12-21 10:09:29.423
13832	8308 Fox Way	# 147	Langley	7	V3A 4R2	E6100000010C8E0D55122D9248408D965128B0B15EC0	a804d41c-611e-4a3a-a94c-223b8dc5e487	2013-04-27 00:00:00
13833	8458 Wiget Lane	\N	North Sydney	50	2055	E6100000010C49E60F27D4E740C0F2BE676DF6EA6240	56efb545-8c3c-421d-a433-c30ba603686c	2012-11-10 00:00:00
13834	9295 Arcadia Pl	\N	West Covina	9	91791	E6100000010C83D88488D00B414098B1A6F82B7C5DC0	54d00280-728d-4481-80d2-5a784a621dc5	2014-05-25 00:00:00
13835	3165 Willowwood Ct.	Apt 213	North Sydney	50	2055	E6100000010CB041905E53EE40C03105998838E36240	4d29a3b6-6b6b-4654-86c4-157e01f381b3	2013-07-27 00:00:00
13836	9589 Eastgate Avenue	\N	Palo Alto	9	94303	E6100000010CF07255E4DCB842404CAE44DD888E5EC0	f21a0be7-84ea-4dc5-9486-d11bb19fe441	2013-10-30 00:00:00
13837	55, rue de la Cavalerie	\N	Lieusaint	163	77127	E6100000010C098A60F6984D48403A389522AD630440	cbd54fbd-4f22-43c9-847b-e4010ee8d809	2013-12-21 10:09:29.423
13838	832 Heights Ave.	\N	Port Orchard	79	98366	E6100000010CE28248CF3BBC47400A4508B15BAF5EC0	10923018-83c7-41fd-9614-09543518ed6b	2014-03-10 00:00:00
13839	4036 Elk Dr	\N	Sooke	7	V0	E6100000010CBA83C675CB2D4840BCC526DFE1E65EC0	d2700839-f281-43f8-acd5-5a8f75c1e6d7	2013-12-08 00:00:00
13840	2745 Mt. Dias Blvd.	\N	Burlingame	9	94010	E6100000010CFFF304BF31CB42406C0CD5AC26945EC0	bea102bd-f7df-487d-8c95-adddd1876865	2012-04-15 00:00:00
13841	5531 Fremont Street	\N	Royal Oak	7	V8X	E6100000010C68EC7057854548403BFD500C3CD65EC0	321d04b1-38f2-4b59-9bd0-545ce7bb17ea	2012-01-10 00:00:00
13842	1646 Texas Way	\N	Spokane	79	99202	E6100000010C5EB2471A5FDA47409F1F218F86605DC0	e5f2e9cf-b181-4b46-b023-2de1e666f6a0	2013-10-12 00:00:00
13843	3395 Farm Bureau Rd	\N	Issaquah	79	98027	E6100000010C0A1A79F700BF4740AF6DCB3C9F895EC0	83f8f717-66c7-498c-93e7-668c0067f9df	2013-08-11 00:00:00
13844	115 Santa Fe Street	\N	Lavender Bay	50	2060	E6100000010C05A837BD37E840C0BE074E259FE26240	0e765b69-481b-49b9-a479-99af1407c8b7	2011-07-11 00:00:00
13845	7865 Mt. Diablo St	\N	Bracknell	14	RG12 8TB	E6100000010C6ACE9A2EDBB44940EA3B0894AE31E8BF	7e865595-2544-4c63-b82f-933e48be03e9	2013-09-27 00:00:00
13846	9763 Maricopa	\N	Corvallis	58	97330	E6100000010CCDFFE4D7B34D464070B0FEE6D0DB5EC0	4f12ee42-6b40-4c51-ae98-fcbbb796cd59	2014-05-09 00:00:00
13847	4422 Mariposa	\N	Lynnwood	79	98036	E6100000010C86FE276B9AE547408A89971242865EC0	7c238f7a-675a-4329-bce1-a92ef32829db	2013-07-20 00:00:00
13848	Alderstr 284	\N	Hof	8	95010	E6100000010C6134AE5F6A2C494005578F6EDCCD2740	f433edf2-805b-476c-981e-3b38c6fc9480	2013-12-16 00:00:00
13849	5958 Cross Road	\N	Lake Oswego	58	97034	E6100000010C2B4847D016B1464056ACCB66D2B55EC0	31364386-08bd-477d-b336-d1abba6cc142	2013-09-12 00:00:00
13850	5490 Reality Drive	\N	Long Beach	9	90802	E6100000010C3204BF850EE540407A34BFDD9E8D5DC0	86b2d699-6766-4e91-911f-bbc403edafb6	2013-07-18 00:00:00
13851	658 Cardinal Dr	\N	Spokane	79	99202	E6100000010C36206E190DD347409F1F218F86605DC0	4e3a3393-a388-4fb5-978c-998bbccef2f4	2013-08-08 00:00:00
13852	5149 Thistle Court	\N	Burbank	9	91502	E6100000010C3BB856B765134140DD6459FB8C915DC0	dfcd0e4d-06e7-4d8d-9fb5-317e577447c9	2011-06-26 00:00:00
13853	445 Banyan Way	\N	Fremont	9	94536	E6100000010CE54AF012AEC84240D6E14CDCC27B5EC0	dd3d7a91-fb33-4819-9933-8b95999298c2	2014-03-20 00:00:00
13854	8521 C Mt. Hood Circle	\N	Berkeley	9	94704	E6100000010CC1BA6DA1DCF44240719EF89C01985EC0	37719e45-5e8d-476b-904a-f02dae76df96	2011-06-05 00:00:00
13855	2928 Antone Court	\N	Ballard	79	98107	E6100000010C241DFDEE0FDE4740A6354490868D5EC0	83e03fb5-2a6c-4fe6-9049-da5afbb20118	2014-06-30 00:00:00
13856	1218 Woodside Court	\N	Glendale	9	91203	E6100000010C53B28E7C4D154140BE2ABF7D3E905DC0	9acc2efa-c00f-4518-a12a-7a9163790b45	2013-07-21 00:00:00
13857	6963 Grand View Avenue	\N	Rhodes	50	2138	E6100000010C931C7FE220ED40C0F71FF81C40E46240	4dcd25be-214d-4f01-93d9-49408de90bef	2012-09-08 00:00:00
13858	2500 Ward Court	\N	Sedro Woolley	79	98284	E6100000010CAB21CD57703B484002ECD13F4A795EC0	28434039-fa7f-4f81-983d-c5986719f19b	2014-03-22 00:00:00
13859	1086 Ash Lane	\N	National City	9	91950	E6100000010C96BC14EE41534040EEFFF80F1D3F5DC0	74312cda-0c7d-4a41-ae40-37a61367c208	2013-09-13 00:00:00
13860	4290 Wellington Avenue	\N	Watford	14	WA3	E6100000010C1A26F96467DB4940DCA52B8AD5FAD8BF	1a4c0a8e-7487-4b9c-8b66-02d744e5f155	2014-04-03 00:00:00
13861	5785 Ygnacio Valley Road	\N	Redwood City	9	94063	E6100000010CDC0A726DC8BF4240CF63612126995EC0	d4e7fd24-30ce-4535-ba92-5411f1f9acac	2014-02-23 00:00:00
13862	1860 Holiday Hill Dr.	\N	Sunbury	77	3429	E6100000010C9ACB0120A1C742C0F8BDA4DAF91A6240	edbf1146-5d80-43e6-b139-817c9ad7cbcd	2013-11-23 00:00:00
13863	3146 Cougar Way	\N	West Covina	9	91791	E6100000010C4C45AD29C3084140845F7D48AE7D5DC0	018ff4ef-f04f-4856-a1e4-b7614bed43aa	2014-01-04 00:00:00
13864	6182 Almond Avenue	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	a4c211a1-7262-41a5-bd29-00d5192f4f32	2013-10-16 00:00:00
13865	4895 Browse St	\N	Langford	7	V9	E6100000010CBD1C1688C0304840F2077EBDB4DD5EC0	937ee6e8-baf8-46f2-821a-5cd7e91afa2a	2013-09-24 00:00:00
13866	4315 Glenside Ct.	\N	Silverwater	50	2264	E6100000010C30A938EB9F8C40C0439CA9D76CF26240	846b5801-1972-40bf-a430-b595d3075b49	2014-04-26 00:00:00
13867	1264 Eureka Lane	\N	San Gabriel	9	91776	E6100000010CE7FD2C40891141408F0E96DCD9875DC0	37b6a352-cdce-47f4-bbff-bd9cbc643f46	2013-04-01 00:00:00
13868	7, rue de Maubeuge	\N	Drancy	179	93700	E6100000010C77AC30CCB77D4840EA04397912910340	1e1cd023-9f46-45c1-99fa-c55f1adbda73	2013-12-21 10:09:29.423
13869	5923 Hazelwood Lane	\N	Puyallup	79	98371	E6100000010CAFFDA0C98AA047402AB29A9D019F5EC0	e475c465-1c95-4306-a872-4858c2fd892c	2012-07-14 00:00:00
13870	415 Courthouse Drive	\N	Beaverton	58	97005	E6100000010CC3025EF059C546407BE6E1C033B05EC0	90f74644-a901-4acd-94c4-fb62776833c5	2014-02-13 00:00:00
13871	1416, place de la Concorde	\N	Chatou	164	78400	E6100000010C642317A6FE6E4840391C167A1E360140	5a5a02d7-43ea-4412-8bfb-8f813aea76ae	2013-12-21 10:09:29.423
13872	8568 Rolando Ave.	\N	York	14	YO15	E6100000010C6E35E1BB2BFE4A40C7015F56E14EF1BF	48845992-6ef8-4d67-95fd-e343e4b6e8f5	2013-07-17 00:00:00
13873	115 Pine Creek Way	\N	Lynnwood	79	98036	E6100000010C949FD8F064EF47408A89971242865EC0	f05e9d42-9fc1-437a-9802-dbf6376bcfb9	2013-10-31 00:00:00
13874	6991 Mauna Kea Court	\N	Newport Beach	9	92625	E6100000010CB94B066AACCB4040E6F17CDD14825DC0	51e0985d-13df-4bb0-88bd-4ddcc60f0945	2014-04-02 00:00:00
13875	7280 Greendell Pl	\N	Peterborough	14	PB12	E6100000010C2C84229299404A408520E05C6A01D0BF	d9bd63bc-32ac-4d47-bd2e-92333c4b7908	2013-07-08 00:00:00
13876	Celler Weg 2949	\N	Hamburg	20	20354	E6100000010C41C60305BEBD4A408EFA7DE5D7FF2340	621e3021-bb78-4a8c-bf32-0bf7e414db75	2014-03-28 00:00:00
13877	4814 Ward Street	\N	Port Hammond	7	V6B 3P7	E6100000010C515904B09DA1484067372F0A8AC55EC0	8dd568b5-b1b4-440f-a70d-c5fc6a28196a	2014-01-26 00:00:00
13878	4601 Sundance Drive	\N	Redwood City	9	94063	E6100000010CE1E4A23A06BA4240B601B38277825EC0	cd4d8c5a-e075-4cac-9947-ac040435c310	2013-01-20 00:00:00
13879	Räuscherweg 124	\N	Stuttgart	70	70511	E6100000010C00000000000000000000000000000000	c0a88d92-fb7b-4762-a454-bd694ebd8124	2013-09-06 00:00:00
13880	2678 Village Pl	\N	Beverly Hills	9	90210	E6100000010CA7CA5DA538074140AB422E4499945DC0	2338a414-69e6-4891-8931-9ec8181b7b58	2014-01-01 00:00:00
13881	5896 Mt. Dell	\N	Hobart	71	7001	E6100000010C64CDB7402E7045C0233F4E18CD6D6240	63cc5543-1988-49f6-aa81-9c254638f5f2	2013-01-01 00:00:00
13882	2719 Little Dr	\N	Milwaukie	58	97222	E6100000010C255720C232BF4640EE108D122AA05EC0	6ac85991-752c-4041-9aca-c97712ec89be	2014-01-14 00:00:00
13883	1050 Creed Ave	\N	Lebanon	58	97355	E6100000010C69478162793E46402BBA9DC598A95EC0	f48ee27d-1849-4370-9e02-66d50d1485ca	2011-09-22 00:00:00
13884	3338, chaussée de Tournai	\N	Colomiers	117	31770	E6100000010C1D7FC9FF0DCC4540FB583CDCBA3FF53F	afeade40-9aba-42d4-a1df-4313ba8e3687	2013-12-21 10:09:29.423
13885	775, rue de Courtaboeuf	\N	Paris	161	75013	E6100000010CD56EC296676E484022436C661AE30240	7f0a04aa-903a-4c09-99f3-d3aa09b0f399	2013-12-21 10:09:29.423
13886	4000 Krueger Drive	\N	Burbank	9	91502	E6100000010C0CE55BB9151241400C61CB457E8B5DC0	fe688ceb-4c07-479c-8960-15625c9b839c	2011-08-03 00:00:00
13887	5241 St. Andrews Way	\N	York	14	YO15	E6100000010CC8478F528DFF4A403E0732F66A5AF1BF	2cf2363e-d594-4ce5-a377-3eb876c60284	2011-08-02 00:00:00
13888	8446 San Gabriel	\N	Vancouver	7	V7L 4J4	E6100000010C8826A247CDB048409A541165E1B95EC0	16d94e32-cc2a-4566-ad06-2b85584188af	2012-09-25 00:00:00
13889	9941 Graham Ave.	\N	Vancouver	7	V7L 4J4	E6100000010C2751065012A648405D392C0BABBA5EC0	f6a05b19-b097-4a8f-b728-dd48514871fb	2012-06-13 00:00:00
13890	3400 Folson Drive	\N	Royal Oak	7	V8X	E6100000010CA8426E87D53C4840F4FAF16C57DD5EC0	1e9ec96c-40ed-40c8-816c-4756954a5eb9	2013-07-05 00:00:00
13891	8420 Dayton Court	\N	Melbourne	77	3000	E6100000010CBE061B26F7E942C0FF7C1D77941B6240	d34f29cd-a8eb-424c-a9d0-c774b024a3ab	2013-04-02 00:00:00
13892	7805 Roslyn Drive	\N	Woodland Hills	9	91364	E6100000010C9F202A19DA11414078F651A48D9F5DC0	e416b7c6-b2fa-4fa2-b984-eb1cc98aadf6	2012-10-21 00:00:00
13893	6062 Sudden Loop	\N	Newcastle	50	2300	E6100000010C9331DB9B357840C0D145F19873F86240	fa88df8a-59f3-41b2-aafa-0189673e0fea	2013-07-12 00:00:00
13894	4173 Wheel Ave.	\N	Lemon Grove	9	91945	E6100000010CD698246F626040408B66D40481445DC0	c686d3f7-bb66-40a0-8294-544a6116d795	2011-09-07 00:00:00
13895	6177 Arleda Lane	\N	Grossmont	9	91941	E6100000010C87BC74FA675D404092036A66CB385DC0	f68301c4-33e2-44e4-8fb1-01fc1ff7662f	2013-12-01 00:00:00
13896	Heideweg 6446	\N	Salzgitter	19	38231	E6100000010C00000000000000000000000000000000	a130a9ac-53f2-41a5-a681-a9428cca7165	2011-07-14 00:00:00
13897	8673 Mt. Wilson Way	\N	Warrnambool	77	3280	E6100000010C0D7B4D83750643C015B621D309CD6140	4997f0cf-a710-4057-94f3-403f69625766	2013-11-17 00:00:00
13898	5455 Via Romero	\N	Mill Valley	9	94941	E6100000010C1A63786B0CEC424062FC0B463F9A5EC0	2db4b797-9e37-4404-9330-00c34d4dd42d	2012-11-10 00:00:00
13899	Charlottenstr 29	\N	Hamburg	20	20354	E6100000010CFBADAEB4CACD4A40A6C52CA9AAE02340	78d571a9-5806-4e59-931a-b900025c3b99	2013-08-18 00:00:00
13900	369 Peabody Road	\N	Gold Coast	64	4217	E6100000010C4BD3956226FF3BC0C331A85C802F6340	2cef4f18-2cab-4d27-a882-b5b9b8f8103c	2013-09-18 00:00:00
13901	9900 Clearbrook Drive	\N	Seattle	79	98104	E6100000010C122F1FE587C64740899A4C1D629B5EC0	30a4b480-78de-4a5f-a0e5-4e18a0daac5f	2014-04-14 00:00:00
13902	3586 Orchid Ct.	\N	Sunbury	77	3429	E6100000010C9ACB0120A1C742C0846C90FA2C126240	23616c19-2432-40a8-a929-0b48adac7e29	2013-12-05 00:00:00
13903	7114 SeaView Court	\N	Sunbury	77	3429	E6100000010CAA2B531926C742C0AAE7756B32186240	c05e8a1c-f60d-45ce-b792-e8689338acb7	2012-04-07 00:00:00
13904	5068 N Francisco Way	\N	Royal Oak	7	V8X	E6100000010C8FC96B8FC43448406CA7AD5AD0D75EC0	ee3d1c8d-f4e5-4f49-9d72-539038086098	2014-06-28 00:00:00
13905	4855 James Court	\N	Beverly Hills	9	90210	E6100000010C6CEB8056550D4140AB422E4499945DC0	67b420aa-a7ae-4d6d-9e59-b2f9dc148267	2014-02-04 00:00:00
13906	Postfach 66 07 00	\N	München	20	80074	E6100000010C00000000000000000000000000000000	a88297e9-6b8e-43cc-9e56-d93fe72b72c0	2013-09-13 00:00:00
13907	2932 Manuel	\N	Santa Monica	9	90401	E6100000010CAFE983A776FC4040D19503C4E69E5DC0	a1955906-d746-4f36-b41e-996aa56926c7	2012-09-05 00:00:00
13908	2973 Cardinal Drive	\N	Mill Valley	9	94941	E6100000010C10C3F3F5D6F2424034A44289A4AE5EC0	9d158d93-ca61-4af5-8ba9-b133a0a117a3	2014-03-25 00:00:00
13909	Essener Straße 1	\N	Erlangen	8	91054	E6100000010C9FBC3710CCC64840CFB3A413E30D2640	b595b7c5-fe3e-45cd-9f5c-246d2ce54105	2013-09-11 00:00:00
13910	189 Richview Dr	\N	Haney	7	V2W 1W2	E6100000010C8D1ADEB1BE9D484078AB247681A25EC0	4452742e-f974-4b11-a2b0-25d7d68b8d9d	2013-09-05 00:00:00
13911	34, avenue des Laurentides	\N	Dunkerque	145	59140	E6100000010C39EC7D8160894940DFD5FBF902D00240	0e0a132d-8514-460b-8053-73657787ff32	2013-12-21 10:09:29.423
13912	9137 San Remo Ct.	\N	North Sydney	50	2055	E6100000010C9ACCF6A7ECF040C0DB56650F49E16240	d7f84cae-ac5b-4a71-9e2a-262d58ba0fcb	2013-03-10 00:00:00
13913	8592 Camelback Ct.	\N	Warrnambool	77	3280	E6100000010CA9F7690C680843C0A0948BBA0DD26140	4158698a-9937-4b8d-aff6-3735714bc713	2013-07-06 00:00:00
13914	5203 Foothill Way	\N	Hobart	71	7001	E6100000010C64CDB7402E7045C089CA4142546D6240	aa921753-cd89-4614-b978-c3fd2a6ef6ae	2012-04-28 00:00:00
13915	1431 Corte Bonita	\N	Sooke	7	V0	E6100000010C16ECB39C45304840D471CE97ACE75EC0	913da41b-8c0e-4f71-89ac-bc6d74f6742c	2013-12-29 00:00:00
13916	4635 Woodside Court	\N	Redwood City	9	94063	E6100000010C66BCA5CC31B742407AA0F69CB29A5EC0	4ac9eeb0-b8c6-44b1-a3f7-10e11cffa02a	2014-05-12 00:00:00
13917	6130 Alderwood Lane	\N	San Carlos	9	94070	E6100000010C7A03ED6E94C44240A8A85D5EA4995EC0	a28f2d23-bfb8-4db7-93ca-df859b298eee	2014-04-18 00:00:00
13918	4612 A St.	\N	London	14	SE1 8HL	E6100000010C0AD4C7A2A4BD4940171B076E76E4BABF	128fd0f2-b329-42ae-a404-15914ee303be	2013-07-19 00:00:00
13919	2245 Fairfield Ave	\N	Daly City	9	94015	E6100000010C7416B512C2D0424052AD2A9D309E5EC0	97777a38-eb12-4ca8-b2a1-b020e4735b36	2014-01-13 00:00:00
13920	3994 Pinecrest Court	\N	Renton	79	98055	E6100000010C151F1B791BBC474072C3880E24815EC0	84ebd54e-81db-43ac-9dbe-ad99c1b7231b	2013-08-06 00:00:00
13921	5927 Seaview Avenue	\N	Silverwater	50	2264	E6100000010CF6FEA1123A9740C04F2EA7A0F8F06240	1a8050d2-d867-410d-8873-ee9ec25292e9	2013-03-12 00:00:00
13922	5022 Euclid Ave.	\N	Lebanon	58	97355	E6100000010C38A2CFBE313C464078691F5662B55EC0	3720cc7a-38f2-443d-b6e1-f8b36794f371	2014-04-27 00:00:00
13923	6557 Rose St.	\N	West Covina	9	91791	E6100000010C10A856AA040741402413161074815DC0	d8246004-a3c8-426d-a285-f2d368f34a64	2014-05-22 00:00:00
13924	3319 North 90th St	\N	Burien	79	98168	E6100000010C82611C8E6CB447400E6C3972528A5EC0	231bd0d5-22e5-459f-aa98-9a793130c88b	2011-10-12 00:00:00
13925	6090 San Francisco	\N	San Carlos	9	94070	E6100000010C1D32A4528AB94240FDBEC1D608915EC0	1395ac3e-3758-44ba-af51-73f93cf2538a	2014-02-11 00:00:00
13926	1258 Steven Way	\N	Tacoma	79	98403	E6100000010CE5C55E78B9A7474044E9A419C8A65EC0	7b0ed74d-5e46-4f97-a093-6bcff2f3aadf	2013-07-07 00:00:00
13927	5757, avenue de l´ Union Centrale	\N	Metz	143	57000	E6100000010C0B054F96EE8B4840EC26935DCDB71840	5954dbf7-ff50-45ad-b545-7fc4f4da88c9	2013-12-21 10:09:29.423
13928	535 La Salle Street	\N	Concord	9	94519	E6100000010C1B2977795CFB424002C01324668E5EC0	f9301d47-d41a-47b1-bef8-0df3e49cee24	2011-11-14 00:00:00
13929	9120 Springfield Drive	\N	La Jolla	9	92806	E6100000010CC75916D3F6EA404019BAF00409725DC0	fba95941-7380-4053-bf38-1b0dcd602549	2012-02-23 00:00:00
13930	3463 Bel Air Dr.	\N	North Sydney	50	2055	E6100000010C70FDA00843E840C060399A370FE86240	51b2fdf0-78f1-408d-a2ee-da88164ed6df	2013-11-11 00:00:00
13931	149 Valley Blvd.	\N	El Cajon	9	92020	E6100000010C2A4341DA71674040D2782E801E3D5DC0	a860150f-29e2-4af4-adee-0ef914202c91	2013-09-30 00:00:00
13932	3099 Corte Segundo	\N	Port Orchard	79	98366	E6100000010C359A913DE2BF47400547B9D092AE5EC0	ac8e4033-0d7b-4e9d-ba49-50e5f98a0d00	2014-05-07 00:00:00
13933	4240 El Campo Ct	\N	London	14	SW1P 2NU	E6100000010C44F886601CC3494057D9A619238DC1BF	09284ec0-0183-4fd3-9282-319204935679	2014-01-28 00:00:00
13934	1685 Rose Dr.	\N	Vancouver	7	V7L 4J4	E6100000010C7217EEB970A54840E94F10B9D8C85EC0	b514878d-3868-4525-b718-fcc94c976445	2013-08-03 00:00:00
13935	9040 Pierce	\N	Cheltenham	14	GL50	E6100000010C4B0386A8F2F449406A31693E1A9E00C0	db8ae8cc-ffd5-4362-8064-6569c4dcac09	2013-12-11 00:00:00
13936	27, place de Brazaville	\N	Orleans	131	45000	E6100000010C1ACE874A48F8474063E79DF23C90FE3F	4a2b897c-bd44-4320-959f-35e4a6639f4e	2013-12-21 10:09:29.423
13937	2499 Wilke Drive	\N	Torrance	9	90505	E6100000010C2A55DDB405E9404063F0B6367A965DC0	e7f826b7-7767-4a44-bc0e-13eed6024498	2012-05-07 00:00:00
13938	8328 Melinda Court	\N	Milton Keynes	14	MK8 8ZD	E6100000010CBC16807CBC064A40EB1B9660FE49E7BF	b1e29312-aab3-49c6-8494-f6b0aa934de5	2013-08-09 00:00:00
13939	8422 Castle Rock	\N	Burbank	9	91502	E6100000010C69FA9FB27516414027ACC38FE89C5DC0	f6922af7-0d06-403a-ae95-8b77ab4ad181	2014-01-13 00:00:00
13940	617 Sweeney Road	\N	Port Orchard	79	98366	E6100000010CAA6B858046BF47400A4508B15BAF5EC0	98fff4d2-1eb1-4cc6-bef9-774f79f273e4	2014-02-07 00:00:00
13941	8387 B Way	\N	Gloucestershire	14	GL7 1RY	E6100000010C186DA1B4D3D74940603D0EEB238FFFBF	6dcfcba0-979f-42e6-86b1-9a319c0ec176	2013-09-29 00:00:00
13942	5276 Whitehall Drive	\N	Los Angeles	9	90012	E6100000010C28507CA8820A4140A48ABEAF288F5DC0	e63d190a-ea3a-434d-93cb-522c106884a9	2012-05-19 00:00:00
13943	6584 Oak Leaf Ct	\N	Matraville	50	2036	E6100000010C7F109E98C4FB40C0421AEC60A7E56240	eb27594a-3851-47a4-a205-27547895d06a	2012-09-11 00:00:00
13944	9467 Morning Glory Dr	\N	Royal Oak	7	V8X	E6100000010CA8426E87D53C48406CA7AD5AD0D75EC0	448d1482-bdce-47e8-8e2c-c689c89250ed	2014-05-27 00:00:00
13945	6344 St Paul Way	\N	Tacoma	79	98403	E6100000010C93EB4C4EA6AA47407873931029965EC0	ce8ab847-84cd-463f-890a-abfabb8c4b62	2011-10-08 00:00:00
13946	3869, rue Villedo	\N	Orly	180	94310	E6100000010C3129E813B65F484009F1181BCE240340	3739ca07-6942-445b-8009-788e95515710	2013-12-21 10:09:29.423
13947	4167 Deercreek Ln	\N	Spring Valley	9	91977	E6100000010C9205D407EE614040A4DEA33286425DC0	4885721b-c79b-4942-8e2d-1b9ac55e5aea	2013-05-27 00:00:00
13948	5536 Yolanda Circle	\N	Bendigo	77	3550	E6100000010C9BE788D5D85A42C091CF27A5E7026240	976bf251-a740-418c-8baf-020504a75458	2013-08-08 00:00:00
13949	5317 Mission Drive	\N	Corvallis	58	97330	E6100000010C23E25487214D46403F3D03E09ADC5EC0	b01bc3ec-c781-46b4-bf54-aec5c7f413b1	2011-10-02 00:00:00
13950	3394 Near Drive	\N	Lebanon	58	97355	E6100000010C69478162793E46405C9F73A086AD5EC0	bc9d63e1-e67b-4f74-bd0f-0fb843493d59	2014-04-05 00:00:00
13951	7418 Jumping St.	\N	Rockhampton	64	4700	E6100000010CFE070608B35F37C0E0668C2768D46240	9c8d9527-d7f9-42ce-a991-fb9d78fb8cb3	2011-06-02 00:00:00
13952	3435 San Simeon	\N	Woodland Hills	9	91364	E6100000010CDE3556A8281A4140A13B0B3659A35DC0	64f8b3f8-3641-4f68-80ec-c385daa0983a	2013-10-16 00:00:00
13953	8733bis, rue des Peupliers	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	3c90aceb-0c1f-49f6-9721-06cbad914ed2	2013-12-21 10:09:29.423
13954	5958 Meadow Glen Way	\N	Spokane	79	99202	E6100000010CF85061C47DD5474075FE598981545DC0	f31449c8-3bb6-4770-9edf-eb90bf34e72e	2014-01-28 00:00:00
13955	9162 Gem Court	\N	Sunbury	77	3429	E6100000010CEBAB98FE39C542C0A2DFCE8EE1156240	54870c3d-8ae1-4b2f-8284-f1eab5c1c1b1	2014-01-16 00:00:00
13956	658 Coastal Blvd	\N	Geelong	77	3220	E6100000010C3283132CD60E43C0D338F2A7FE0B6240	3d0184ec-263e-4c37-b449-f00e98d5e332	2012-05-11 00:00:00
13957	4060 Roundtree Court	\N	London	14	W1X3SE	E6100000010C83E41C1315C6494009E2AF35BC40C0BF	bb33cc52-7308-4bb2-9a06-610737404825	2013-07-01 00:00:00
13958	4116 Hummingbird Ct	\N	Warrington	14	WA1	E6100000010CBE0DE9374CB44A40DCE7D4EC989204C0	0118ad41-3875-421c-987e-8c5b2d816942	2013-06-02 00:00:00
13959	9593 Delaware Dr.	\N	Burbank	9	91502	E6100000010CC37E32A9951C41401B2D273D6C9E5DC0	9cd23e13-0bff-4357-879e-f510091defe1	2013-09-14 00:00:00
13960	9089 San Jose Ave	\N	Columbus	55	43215	E6100000010C30BCA2E265FD434029968216D7C754C0	bd646e9d-eadf-4899-91db-647d8dcf2a30	2014-04-28 00:00:00
13961	2987 Wiget Lane	\N	Goulburn	50	2580	E6100000010C6E10DC9D7F5341C02E2E1EEECCB06240	5dd64f6b-4abd-4a7a-9c8e-33c200a71a7a	2011-06-16 00:00:00
13962	8521 Knewal Rd	\N	Newport Beach	9	92625	E6100000010CCADCF7FB1FD240400313F910CD7C5DC0	22af05d8-ec53-4bf8-b7c1-45cf164969dd	2013-07-23 00:00:00
13963	6097 Mt. McKinley Ct.	\N	Bendigo	77	3550	E6100000010C0A49438AE76142C080EF3B4EE8086240	db227914-6cea-40d8-a726-12c9181e29e2	2013-07-26 00:00:00
13964	4890 Heron Ct	\N	National City	9	91950	E6100000010C599674E0D6524040CA4BAF63DA4B5DC0	db116a1e-5589-4ca5-8e97-dd1506a7b297	2014-03-16 00:00:00
13965	Auf Der Steige 6000	\N	München	53	80074	E6100000010C00000000000000000000000000000000	721089ec-049a-4da0-a341-dd5ea0dee008	2013-12-21 00:00:00
13966	Höhenstr 9419	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	aad1057e-3dd1-475b-8090-3a0122efaeea	2014-04-03 00:00:00
13967	6272 Maywood Ln	\N	Beverly Hills	9	90210	E6100000010C58CF622C180841404ABB5060A99A5DC0	5f6351fd-be66-4665-a756-c2436979b6b1	2012-09-19 00:00:00
13968	9549 Roxbury Drive	\N	Imperial Beach	9	91932	E6100000010C5CC28B46AB4A404022B680BF12525DC0	695ce62b-c69f-4843-823a-aebbcc2993e3	2013-08-16 00:00:00
13969	6171 Golf Club Rd	\N	Fremont	9	94536	E6100000010CA31C74D063C34240DDAC7EB78A7C5EC0	0a2f67fb-e02c-4d19-83cc-613b96466a9d	2013-08-15 00:00:00
13970	1085 Greenbelt Way	Unit B-105	Los Angeles	9	90012	E6100000010C8EAC2FD8E4074140C8679AC1C0995DC0	a97e4af7-9f35-42a3-8b0c-b759cd3534fc	2013-10-07 00:00:00
13971	9027 Lancelot Dr	\N	London	14	W1Y 3RA	E6100000010C0BB896C32BBE4940723DC133FC41C0BF	03d19763-f43e-4aa2-8be6-6baf72f32cf2	2013-08-03 00:00:00
13972	618 Oak Street	\N	Langley	7	V3A 4R2	E6100000010CCB43C4F93B8648402B7C048E9FAA5EC0	e1e22533-40ae-411d-8e0e-8751afda21e3	2012-12-30 00:00:00
13973	5785 American Beauty Dr	\N	Glendale	9	91203	E6100000010C509C4ECFBE0E4140CA76E0C2A5855DC0	9bd9ed88-dd32-448f-8dab-2aa1e57e7218	2013-08-02 00:00:00
13974	5571 Crawford	\N	Everett	79	98201	E6100000010CAAEB437803FB4740110DF634788E5EC0	e38404e6-d2a3-4531-a596-0c77a3842680	2012-03-26 00:00:00
13975	6827 Glaze Dr.	\N	Calgary	1	T2P 2G8	E6100000010CE4FAB110968B49403FE1A610E37D5CC0	c54207f5-5fd8-4d67-8706-f776ab140d86	2011-11-18 00:00:00
13976	3648 El Dorado	\N	Grossmont	9	91941	E6100000010C94139D63F46440405BDA320046465DC0	96ea4081-81a2-4d06-a6b5-689d3d913e4f	2013-11-04 00:00:00
13977	Postfach 66 00 77	\N	Münster	70	48001	E6100000010C00000000000000000000000000000000	d7a5f5e9-2e00-4199-ac98-0e3f82033571	2012-02-20 00:00:00
13978	9135 Rockford Dr.	\N	Goulburn	50	2580	E6100000010C04F306FCDD4841C0072DEBF24BBC6240	5c693bef-c6e3-4445-bfb4-8e17bb619d38	2012-04-14 00:00:00
13979	3689 Sun Tree Lane	\N	Bury	14	PE17	E6100000010C962A39F791C24A409F2D4512236702C0	c6fc8951-7275-4d67-98d1-1a37eae804fb	2013-08-15 00:00:00
13980	30, allée des Princes	\N	Bobigny	179	93000	E6100000010CD67266B0646B4840608D332F657E0340	88de9f59-827a-4d8c-b1e7-777fe18895f8	2013-12-21 10:09:29.423
13981	2860 Mt. Tank Circle	\N	Maidenhead	14	SL67RJ	E6100000010C3589C76798CC4940BF9253E17C7DE7BF	ec708edc-1054-4983-a222-81ce4bcacd74	2013-07-07 00:00:00
13982	1276 Quartermaster	\N	Matraville	50	2036	E6100000010CE48E003BFC0041C0B22745507EEA6240	7e45df42-778e-40cb-8ca4-d52b21dbae98	2013-01-20 00:00:00
13983	7967 Panoramic Ave.	\N	Bellingham	79	98225	E6100000010C29DBA460A0604840A476B72191A55EC0	d8b3c778-9548-4ebe-9d3e-efc2da0ee377	2014-03-29 00:00:00
13984	Krönerweg 96	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	ed0fc912-5497-4929-a764-10ca0c2762a4	2014-05-14 00:00:00
13985	6212 C Olivera Rd	\N	Port Hammond	7	V6B 3P7	E6100000010C85C546E107A64840F74170F2C7CF5EC0	dd4eb46c-02c9-4316-aaa2-35025a84364a	2014-04-12 00:00:00
13986	5673 Arlington Circle	\N	Newcastle	50	2300	E6100000010C6A103C06BD7A40C086B7B9FF38006340	1ce4029c-dee7-4fa5-9649-99c2c910fd1b	2014-03-29 00:00:00
13987	9416 Browse Ct	\N	Novato	9	94947	E6100000010C3E86C72EBC11434098EEE03C50A45EC0	e37976b7-801c-46ab-9264-7b25b50c0d6d	2012-10-31 00:00:00
13988	8160 Star Tree Court	\N	Perth	66	6006	E6100000010CA706BBF307F63FC0BB02B5C343EF5C40	97558080-4b88-4c5a-abab-5214d67534d2	2013-03-11 00:00:00
13989	912 Valley Blvd.	\N	Chula Vista	9	91910	E6100000010C90E95CCAF54D4040C00AE090DD445DC0	f91aaca5-3f04-4c35-88bf-308b3b49e4ea	2013-12-27 00:00:00
13990	7026 Trail Way	\N	Wollongong	50	2500	E6100000010C777A2EC5F73241C015BFB25E10D56240	2b73c423-9924-4f7b-b86a-95516523ef44	2013-07-29 00:00:00
13991	939 Vista Del Diablo	\N	York	14	YO15	E6100000010C5C6394B49F014B4036AFB6C3BF5BF1BF	f4ab61a4-9df0-4355-8f8e-00861c458103	2012-08-01 00:00:00
13992	544 Magda Way	\N	London	14	W1N 9FA	E6100000010C2FA914A988BB4940AD4FF52DBC45C0BF	43b1e4ee-3d3a-47ca-8c11-feb3744bb6b2	2013-03-07 00:00:00
13993	8775 Boulevard	\N	Corvallis	58	97330	E6100000010C9F0AF6ACD852464080BBD525B7D45EC0	29d34a82-d326-46e2-8023-a3b160d09f6e	2013-07-26 00:00:00
13994	5144 Via Bonita	\N	Ballard	79	98107	E6100000010CD3A2152521D647404E5EA0DEE3A15EC0	08b13744-1559-4b48-a4fd-2a138b104d43	2014-01-06 00:00:00
13995	5000 Brown Dr.	\N	London	14	SW1P 2NU	E6100000010C2362EA9233BB4940717C340D3D8CC1BF	d37b78a6-53db-4946-9b81-ec57b3660d09	2014-04-05 00:00:00
13996	9803 Holiday Hill Dr	\N	Burbank	9	91502	E6100000010C821A86A8051D414092234477478F5DC0	144a5c01-5237-445c-b7a8-6a1a521f38e8	2013-09-28 00:00:00
13997	7638 Diokmo Ct.	\N	London	14	W1N 9FA	E6100000010CC8A1D31B37BA494009E2AF35BC40C0BF	88fc7fd8-2885-46dd-aee3-ba4e09c25dfa	2013-05-01 00:00:00
13998	545 Los Gatos Court	\N	Brisbane	64	4000	E6100000010CBC966B6B6F793BC047FA6CB3A4236340	f10d1bb4-c439-45a3-b7ed-babe2f17aa81	2014-03-24 00:00:00
13999	6425 Adelia Court	\N	Burien	79	98168	E6100000010C7B18C90267C247406B211F4B3C8E5EC0	22680c4c-7ffc-407f-8ff7-e99ca05b79b9	2014-04-05 00:00:00
14000	Nollendorfplatz 5	\N	Hof	8	95010	E6100000010C70C2D451DB32494049C3E9DC10DA2740	7eda2c59-9b68-4e58-9b99-96e7b7095f4c	2014-02-20 00:00:00
14001	4487 Coldwater Drive	\N	Geelong	77	3220	E6100000010C5081EAB4111A43C0841DEC6213116240	2028d5fb-bef1-480c-a73c-69501300c761	2011-07-22 00:00:00
14002	6027 Lisa Ann Street	\N	Lakewood	9	90712	E6100000010CA1D7F998D0E740404F70622D2B905DC0	c2317f21-aae8-4ca1-92b6-8c2e8b36f763	2013-08-03 00:00:00
14003	5560 Hanover St.	\N	Santa Cruz	9	95062	E6100000010C8FF425D29B7C424045C380DB067C5EC0	ca78e938-ef7d-4089-994e-7cf2c39ae90e	2013-10-29 00:00:00
14004	3169 Estela	\N	Melbourne	77	3000	E6100000010CBEDE9EC4BCE142C0D13C72CA64246240	706c09e3-b3a1-487c-b720-c567e13f98e8	2012-10-17 00:00:00
14005	8590 High Maple Court	\N	Cranbourne	77	3977	E6100000010CC9B9CD3C151643C025547861A8216240	afcba2c3-5aef-4d94-8902-cc5c9a0aefa3	2014-05-06 00:00:00
14006	4895 Browse St	\N	Birmingham	14	B29 6SL	E6100000010C5B2D69FFED384A40565A304FB519FFBF	4d350db5-e797-49bd-899c-25f5394ad76b	2014-02-24 00:00:00
14007	1287 Youngsdale Drive	\N	Concord	9	94519	E6100000010CE0939059650643403887548EB38A5EC0	149fa427-964b-48fb-9089-34e01adada56	2013-09-28 00:00:00
14008	9618 San Rafael	\N	Melbourne	77	3000	E6100000010C79FA00DD40E142C0992F07B242196240	6686d75f-7fd3-4392-9869-1bf80e4a34e2	2011-11-25 00:00:00
14009	2569 Webster Drive	\N	Lebanon	58	97355	E6100000010CA1CDA964BE444640C9948F3707BE5EC0	2a75cea0-dec8-4a77-9f37-5b685d1c584b	2012-02-02 00:00:00
14010	9052 Madhatter Lane	\N	Hervey Bay	64	4655	E6100000010CDA053577EA5439C087DB10AA13166340	e6150530-b236-47ab-85ef-b911daa97de6	2014-01-28 00:00:00
14011	Lieblingsweg 234	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	d7e660aa-16ff-4587-a469-b1638e03ed6c	2014-02-25 00:00:00
14012	Buergermeister-ulrich-str 5	\N	Neunkirchen	70	66578	E6100000010C011CD86CBAAD4840B2DDCC9F706E1C40	f883fdb7-f892-4cc6-a728-4ca8fd26d41c	2014-02-16 00:00:00
14013	9174 Jill Ave	\N	Rhodes	50	2138	E6100000010C4AD00E6A4BEF40C02249BB471EE86240	bb6e105e-d18f-429c-bbc2-742dda11d41e	2012-02-18 00:00:00
14014	9697 Central Ave	\N	Sydney	50	1002	E6100000010CBE5A9E9BA7EA40C02D9E319E03EA6240	027bf597-686f-4ddd-9f99-6bb195655311	2013-05-06 00:00:00
14015	Unter Linden 644	\N	Saarlouis	70	66740	E6100000010C1F080F34CEA2484072856E55D6041B40	3904f683-2995-4071-b155-ac3b5fa488ac	2014-05-17 00:00:00
14016	8510 G St.	\N	Salem	58	97301	E6100000010CFF6C7D18397D46406288EE3DFBBC5EC0	f4114144-fd93-4bf6-a07d-bf83724fd08b	2012-03-30 00:00:00
14017	1161 Daffodil Dr.	\N	Milton Keynes	14	MK8 8DF	E6100000010CFAC3AB7D6AFB49406A0366E2EF6EE9BF	cdc52b38-8058-40e7-b47e-6bdacf85138c	2012-04-20 00:00:00
14018	1969 Meadowvale Court	\N	Lincoln Acres	9	91950	E6100000010C5AB997FE9E5B40401A0271DC9A495DC0	f44f6881-cdcd-4bc2-9ecd-f6fc497833d3	2014-01-26 00:00:00
14019	2391 St. Peter Court	\N	Matraville	50	2036	E6100000010C821A471CF1FD40C066E46991E1ED6240	1eb5c575-7863-49b8-8a07-18c8c1d0cb1b	2011-06-08 00:00:00
14020	6374 Las Palmas	\N	San Carlos	9	94070	E6100000010CE42028F2FABA4240F71532CD61935EC0	0ed7e09b-7918-4872-bb05-48eba543743d	2014-04-16 00:00:00
14021	3612 Vista Place	\N	Colma	9	94014	E6100000010C7C19E949F5D342407848CC7CE7A35EC0	3872078c-6d12-4732-b6f2-bab1f4ef2c8d	2012-11-21 00:00:00
14022	28, place du Tertre	\N	Les Ulis	177	91940	E6100000010C20575233F95B48405EAB96D1E3520140	47d124e1-f788-4d01-aeb2-7c4347384d7f	2013-12-21 10:09:29.423
14023	302 Camelback Ct.	\N	London	14	C2H 7AU	E6100000010C51F39E2DB8C84940A24F467A914BC0BF	7735e309-7306-4b2a-abef-83bb8016a5c8	2014-05-08 00:00:00
14024	2742 Cincerto Circle	\N	Sooke	7	V0	E6100000010C0692F812A72F4840542F52F8F7F15EC0	4ad5b8fb-3e3a-409b-b893-27ee508b1dfa	2013-10-19 00:00:00
14025	905, boulevard d´Albi	\N	Croix	145	59170	E6100000010C245C3A90764E4940FF8841072F340940	4fd944da-6473-4a45-8058-53b7310d1090	2013-12-21 10:09:29.423
14026	4746 Clear Court	# 45	Sunbury	77	3429	E6100000010C0BCB765579CB42C0F8BDA4DAF91A6240	910b2964-9bea-4cbc-ad52-af39ffcfb68c	2013-02-01 00:00:00
14027	4024 Calhoun Court	\N	Redmond	79	98052	E6100000010C6E55A11948D447401AD0FC2EB48A5EC0	193e80d5-0d6f-430d-b55c-27acf1ffc255	2013-12-01 00:00:00
14028	2674 Ridge Circle	\N	Townsville	64	4810	E6100000010CF4C2E0D7D84133C0CFA946C608566240	5a8dbfbe-d26d-4c55-8bff-11b446ed6211	2011-12-19 00:00:00
14029	8937 Two Bay Road	\N	El Cajon	9	92020	E6100000010CFBBD872B686240400337DD3D21375DC0	c813c341-796c-4e0b-819c-b98f047b29f9	2013-10-06 00:00:00
14030	Rotthäuser Weg 15	\N	Frankfurt	19	60323	E6100000010CA081E50EF90D494026DD3EB02A5A2140	5861cfce-d67a-4357-8032-5a234ca149f4	2011-11-14 00:00:00
14031	3424 Rambling Lane	\N	Langley	7	V3A 4R2	E6100000010C02A7CDAC1E88484042405199D6A95EC0	cf11936d-9d33-4fa5-9449-48a497aa024c	2013-08-23 00:00:00
14032	152 Scenic Ave.	\N	Findon	66	5023	E6100000010C11D02A51487441C0A71A313F9D4D6140	04dc63cb-9b50-4116-b963-888dc2f836ad	2013-07-29 00:00:00
14033	Hochstr 8444	\N	Kassel	19	34117	E6100000010C7F6414CE11AD4940C1C136FEADFD2240	c27dfd3d-18a6-4e7f-810f-8887d9fcf2bf	2014-01-12 00:00:00
14034	9819 Anchor Court	\N	Berkeley	9	94704	E6100000010C883549329FEC424099EED90371965EC0	825019cc-c77a-44bf-b9d7-9de169376923	2011-12-08 00:00:00
14035	8212 String Dr	\N	Bellingham	79	98225	E6100000010CE25CC5373E664840278345E5DCA05EC0	c1220c0e-f5c0-4a6f-8e90-027cba7309ec	2013-11-01 00:00:00
14036	1893 Cranberry Way	\N	Berks	14	SL4 1RH	E6100000010CBBC7DCAE21BD4940DB421CC82D81E3BF	0105e56d-e0ee-473a-8db8-067b69bc50b1	2013-05-01 00:00:00
14037	1542 Orangewood Dr	\N	Olympia	79	98501	E6100000010C06A324DEDF7A4740C00ECBBFADB15EC0	3b9bed4f-1742-4f07-8fbf-51f02336a0c4	2012-05-30 00:00:00
14038	5963 Meadow Lane	\N	Rockhampton	64	4700	E6100000010CD326A533146E37C0D7F5243338CC6240	6ff6cc69-d062-4dde-9755-d9ff38779ac8	2012-01-08 00:00:00
14039	127, rue Lauriston	\N	Colomiers	117	31770	E6100000010C2DE05858F6CF4540F21C34558E3DF53F	64b7f7f0-40fe-48f7-bd6f-8c14cf9c3a81	2013-12-21 10:09:29.423
14040	6161 Teakwood Dr.	\N	York	14	YO15	E6100000010C896CEB7F50024B407C343F8BFC51F1BF	7079b2d3-6d3f-4385-a3c7-6d17b6394104	2014-01-23 00:00:00
14041	Residenz Straße 4324	\N	Berlin	53	14197	E6100000010C8F17C7CE18444A4072DF61D64AAE2A40	6e4fc51c-ff3c-4b51-85b5-abc9ddc59407	2013-12-29 00:00:00
14042	2823 Pheasant Court	\N	Colma	9	94014	E6100000010C762C6ADEBED9424073EBEC40119C5EC0	376f4455-3378-4bc3-9b2e-92a1564a9a4b	2014-01-06 00:00:00
14043	Auf den Kuhlen Straße 3619	\N	Bonn	53	53131	E6100000010C9D5E8056EE62494067BFD51E24681C40	c8ea3a8e-c925-49a2-b010-05096580e032	2013-11-02 00:00:00
14044	4064 Regina Lane	\N	Oregon City	58	97045	E6100000010C8A48F1479DB046404BADCBEE29995EC0	26ebd0bb-e78d-47c2-908a-f56d01c4b3c2	2014-01-20 00:00:00
14045	8221 Anchor Ave.	\N	Cloverdale	66	6105	E6100000010CE634EFACB1F93FC0DF1BA56A04055D40	895d2fba-03de-450a-a7b8-a16d1b4c5525	2013-07-03 00:00:00
14046	7268 Norcross Lane	\N	Shawnee	7	V9B 2C3	E6100000010C6831FE3D283548401BF2107944DA5EC0	5fa03291-5c6d-4cfd-8084-f8aa89eed29f	2013-07-04 00:00:00
14047	Nonnendamm 6599	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	270ea628-1922-47a1-9a31-9d16fc96b1c3	2012-10-08 00:00:00
14048	8764 Pacific	\N	Shawnee	7	V9B 2C3	E6100000010CFAD4FFF7C635484039CCDF0E38DE5EC0	fd21fa03-1a4d-470d-8b4d-5a825aaf5b5a	2014-04-22 00:00:00
14049	Kappellweg 664	\N	Werne	53	59368	E6100000010C7679890ACBDA4940D571EFB304821E40	24a595a8-6ec1-4e46-acf0-dfa739d17694	2013-03-02 00:00:00
14050	Klara Straße 8463	\N	Essen	20	45001	E6100000010C39973126CDB44940100E949BC6FE1B40	0e92ac5c-b97d-4d55-b0a2-fb0f461d1451	2013-08-07 00:00:00
14051	Charlottenstr 358	\N	Darmstadt	19	64283	E6100000010CF283A0C8CBF54840DDB81589DC4C2140	9c597d2f-48ab-4c7c-900f-c28ed17ddff6	2013-06-30 00:00:00
14052	8901 Fourth Street	\N	National City	9	91950	E6100000010C9ED34CBE00594040BFF2118ABE445DC0	2486e776-25e4-4a98-ae01-d3f7589074c5	2013-10-30 00:00:00
14053	5524 Virgil St	\N	Coffs Harbour	50	2450	E6100000010C3E85C824A6283EC0001D66AF051C6340	3f5e4097-4f24-4887-bdd6-93ca5bc7a00c	2013-09-08 00:00:00
14054	Parkstr 851	\N	Bottrop	53	46236	E6100000010CC78A70A0ABC64940876D61E510AE1B40	a2eba12c-c5d3-4eba-889a-0563b83ab0ce	2012-07-30 00:00:00
14055	9969 Coldwater Drive	\N	Caloundra	64	4551	E6100000010C666E23D84CC73AC0EBB40CE362266340	9213422d-5e1a-4b6a-9988-2e05aad1aecb	2011-10-05 00:00:00
14056	7605 Mount Dr.	\N	Coffs Harbour	50	2450	E6100000010C0708DB88E0273EC06B6AF4B68D1A6340	3b84adce-6b33-4235-9940-80943417ced6	2011-07-06 00:00:00
14057	5137 Pheasant Court	\N	Issaquah	79	98027	E6100000010C9D251A4E38C04740E700A232AA775EC0	9c185ec1-2f0b-40d3-9798-8ecea3d87121	2013-06-04 00:00:00
14058	4924 Mariposa	\N	Bremerton	79	98312	E6100000010C34D21B0666CE4740CAA77F47B6AA5EC0	ce4404b3-8370-4d15-981e-a824f626cfd5	2014-05-28 00:00:00
14059	9681 VistaView Way	\N	Burbank	9	91502	E6100000010C3927A5B425154140C46C7566AA9D5DC0	dde10cb9-8491-47b5-bf58-a8fcb0862ff8	2013-10-27 00:00:00
14060	3001 Mt. Etna	\N	Bellingham	79	98225	E6100000010C04DA39D1E15C4840C27C7E0337A35EC0	ff0d8614-de1d-4a0c-b6d2-409f40f42cd0	2014-05-11 00:00:00
14061	7023 Stallion Way	\N	Brisbane	64	4000	E6100000010C40B6175F8B7B3BC0F83E9E1F9A256340	ebbe5e6b-3fb9-4eeb-a324-559028aa88e7	2013-05-24 00:00:00
14062	5741 Glen Wood Dr.	\N	Goulburn	50	2580	E6100000010C4E4FCCC7894741C02E2E1EEECCB06240	a838b4f4-beea-4393-94b6-f47ac5f53040	2013-03-06 00:00:00
14063	5697 Jacqueline Way	\N	West Covina	9	91791	E6100000010CD789D948F10A4140C0B668706F7E5DC0	1a04f098-15b9-4513-a146-f0ae2d94793f	2014-05-13 00:00:00
14064	3945 Cedar St.	\N	Rockhampton	64	4700	E6100000010CFE070608B35F37C0D86B6207DAD56240	8cb22a38-f000-4aaf-bb91-2f5944940e84	2012-01-20 00:00:00
14065	3576 Court St.	\N	Burbank	9	91502	E6100000010C55D83CADF5194140E9E3F54D09905DC0	979f4090-b67c-4771-8704-a145fae61474	2014-03-01 00:00:00
14066	Conesweg 1234	\N	Ingolstadt	8	85049	E6100000010CDB041C62CB5A4840BDC39610F1B02640	a32d5321-72cb-46df-9d4c-24a86871bcdb	2012-09-20 00:00:00
14067	6979 Harvard Drive	\N	Puyallup	79	98371	E6100000010C555FAB981095474014616DC30B945EC0	da3a598a-6309-4a20-80d0-2f0797e05212	2011-09-13 00:00:00
14068	1005 Matterhorn Ct.	\N	Cambridge	14	CB4 4BZ	E6100000010CC445A75A5C1D4A404E4FB4B20F74BC3F	02a55fe1-7221-48cd-93a6-26fa2fb70546	2013-11-03 00:00:00
14069	5565 Logan Court	\N	Imperial Beach	9	91932	E6100000010C9F0822C32B4D4040D521C593553F5DC0	633de9ea-0b1d-4356-8935-da64ddddaf1f	2013-11-30 00:00:00
14070	8769 Haven Drive	\N	W. Linn	58	97068	E6100000010C68B5981063B24640DE68E08BE3A35EC0	3df9b8ce-5a1c-4cca-80de-c5b8cc26cc5d	2011-08-31 00:00:00
14071	336, quai Paul Doumer	\N	Paris	161	75016	E6100000010CBE9191FF637048402C45A791870E0240	2251254e-075e-46ad-9f53-e899475bb853	2013-12-21 10:09:29.423
14072	265 Jeff Ct	\N	Oakland	9	94611	E6100000010C843B681B22E44240437F26101E885EC0	b48dd7a4-fbd8-4b4b-be4e-7c4ed0ce1fd4	2014-01-07 00:00:00
14073	3, rue de la Centenaire	\N	Paris	161	75003	E6100000010C8395CD67A66548408068238F99D80240	4b5ad662-33bc-41f9-a364-91f3c5e2eaca	2013-12-21 10:09:29.423
14074	6379 Yellowood Place	\N	Burbank	9	91502	E6100000010C821A86A8051D4140DD6459FB8C915DC0	d6921c07-3974-4d94-878f-02a9c98e0428	2014-06-25 00:00:00
14075	6894 Oeffler Ln.	\N	Birmingham	14	B29 6SL	E6100000010C5E6F9672F13A4A4066C11CC3471FFFBF	20c7db21-ae3e-4ccc-8fc8-a719c6535df7	2013-07-18 00:00:00
14076	8128 Honey Trail Lane	\N	Newton	7	V2M1P1	E6100000010CCA4788D92EEC4A40DAEFB1B279A65EC0	6e79dd1a-b4af-4acc-b27e-a9b73c67e1b1	2013-11-14 00:00:00
14077	4497 Near Dr	\N	San Carlos	9	94070	E6100000010C68A3061157BE42401F8DA802359B5EC0	8f691ec1-5c94-4911-b5fc-27b8c6064fe9	2012-05-19 00:00:00
14078	9155 Red Leaf	\N	Bellingham	79	98225	E6100000010C3B86C8E5DF614840ECCDF96CC8A45EC0	e4491d08-53a6-4ef6-a559-06023d048ee9	2014-03-17 00:00:00
14079	5407, rue Lauriston	\N	Boulogne-sur-Mer	148	62200	E6100000010C8DA0E305E0624940AEC0F2D78EA6F93F	ec766216-c18f-427e-a298-4280110c99ae	2013-12-21 10:09:29.423
14080	1283 Teakwood Court	\N	Wollongong	50	2500	E6100000010CC7FF2F5CD93341C0AEA3469407D66240	e51306a1-a3c3-459c-8a14-bfd6caf29433	2013-02-04 00:00:00
14081	5778 Mt Tri-state Court	\N	Oak Bay	7	V8P	E6100000010C96A8E115EF3A4840456849476CCC5EC0	fa420464-5657-4646-a276-aafef5d3ee69	2013-08-14 00:00:00
14082	3348 Galindo Street	\N	Beaverton	58	97005	E6100000010C53174EFEDEBA4640D7560A2490BD5EC0	6df296a7-d4a2-455d-8a4c-e91f4c579183	2014-05-26 00:00:00
14083	9682 Concord	\N	Springwood	50	2777	E6100000010CAA791F05DED840C083E9A71EF9D76240	d74df560-a982-4363-82d2-fbc9e80f721d	2011-09-27 00:00:00
14084	Knaackstr 756	\N	Offenbach	70	63009	E6100000010C00000000000000000000000000000000	18e121a1-804c-4cba-b97b-d9dfcd3a0474	2013-12-28 00:00:00
14085	8047 Dover Drive	\N	Cliffside	7	V8Y 1L1	E6100000010C0301DC56EB464840ED377FDB97CC5EC0	aa835835-995e-4112-9c8d-0be3d00ce811	2011-09-28 00:00:00
14086	37, place de Fontenoy	\N	Les Ulis	177	91940	E6100000010CB488A130775E48403BBB5DD2E1560140	c642e5ee-f365-42f6-814c-b969872efdb5	2013-12-21 10:09:29.423
14087	101, avenue de la Gare	\N	Roissy en Brie	163	77680	E6100000010C43E85561B95B4840512EE25942450540	6e3983c2-d8c9-4313-a3df-7d300418dca4	2013-12-21 10:09:29.423
14088	5911 Del Vista Court	\N	Burbank	9	91502	E6100000010C963CE9AD851941406EA66E7FD2935DC0	179f9840-13f0-4523-b3ad-875134d854b4	2012-11-01 00:00:00
14089	Königsteiner Straße 750	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	6a823ac9-7eaf-4ea8-ab6e-44158efac754	2013-12-19 00:00:00
14090	4283 Meaham Drive	\N	San Diego	9	92102	E6100000010CCB5F13C526564040AF0E1998723E5DC0	e9289d65-b216-4c3a-85f5-505b65fca488	2013-10-14 00:00:00
14091	7233 Leticia	\N	N. Vancouver	7	V7L 4J4	E6100000010C23D6FBDC209F48400FF36ED41EC45EC0	15a0f296-f98c-4b2b-bed4-c138e1f4049c	2014-05-04 00:00:00
14092	8474 Carmel Drive	\N	Billericay	14	CM11	E6100000010C605A87F861C74940D6675DBF86B0DA3F	d21b5699-24ee-414c-99e2-08539fce7995	2014-01-24 00:00:00
14093	7613 Orangewood Dr	\N	Long Beach	9	90802	E6100000010CD0A8006BF2E84040E33F9C39DD8C5DC0	1bd84933-eb11-4b05-b987-97e2ede09a34	2013-08-06 00:00:00
14094	5520 Sierra Ridge	\N	East Brisbane	64	4169	E6100000010CD520B79ABF7D3BC007E9F2355E1F6340	7d51d41c-1db5-42ad-b863-be8d67c2c92a	2012-12-25 00:00:00
14095	9109 Pinetree Court	\N	Long Beach	9	90802	E6100000010CC6E5D47C5AE640405729E281608E5DC0	c5f32037-4b53-4f5c-8b45-4020ca9ecc95	2014-02-08 00:00:00
14096	10, rue des Vendangeurs	\N	Saint Germain en Laye	164	78100	E6100000010C077BA7DE7473484001614A9EDEC90040	2e7c6ec0-a978-452d-b371-be203061bfbf	2013-12-21 10:09:29.423
14097	466 E St.	\N	Burbank	9	91502	E6100000010CA6CD9AB0C51741407A250BD24E925DC0	1e059067-95cb-49b7-80cb-5778c967cd15	2011-11-23 00:00:00
14098	6973 Elena	\N	Shawnee	7	V9B 2C3	E6100000010CA446F90F4C3348403C34BED6AFD85EC0	8d3b5a59-0faf-4780-8f5c-ea67d6c4ce20	2011-12-11 00:00:00
14099	3341 Teakwood Dr	\N	Bellflower	9	90706	E6100000010CDE908B6CA0F4404072E027CCD78E5DC0	3c5895d6-b3a7-49d1-8be9-3d6b1ffe6db2	2014-05-09 00:00:00
14100	5345 Willow Avenue	\N	Metchosin	7	V9	E6100000010CB4A186BF722748404074876C14EE5EC0	23601394-8963-4e74-bbb0-a2c05492b47c	2013-12-10 00:00:00
14101	4623 St. George Dr	\N	Grossmont	9	91941	E6100000010C73D0358A996140400915BA1908415DC0	af9f7ea1-ea1a-43e8-a075-54315a29da8d	2013-08-25 00:00:00
14102	7047 Poncho St	\N	Chula Vista	9	91910	E6100000010CCE3B2BEF0F5540401DB3EFA8603A5DC0	5f33e81e-4af9-4dd4-aabb-bcb7e721c6e8	2012-06-09 00:00:00
14103	9536 Mt. Hood Circle	\N	Imperial Beach	9	91932	E6100000010C1D3ED24800494040ED3688A2D2525DC0	2835a2a6-efb9-4100-a755-147776586630	2014-05-20 00:00:00
14104	9068 Bohon Circle	\N	Shawnee	7	V9B 2C3	E6100000010C72FFF59B0E324840C3503ACA0EDB5EC0	54401035-e453-4d35-aab0-7277eaeaacc9	2013-08-22 00:00:00
14105	4976 Singingwood Court	\N	Port Macquarie	50	2444	E6100000010C581E62CEFE683FC0D55A2C8396206340	4f92aa13-068c-43a3-a528-71841e040ec8	2011-06-21 00:00:00
14106	4236 Malibu Place	\N	Oakland	9	94611	E6100000010C49FA775732E242408EEAA09FB8905EC0	27dd5e3e-e67c-4753-8697-15d458ee16a9	2014-01-02 00:00:00
14107	9720 Morning Glory Dr.	\N	Findon	66	5023	E6100000010CE0B08512EC6E41C0C16872B90E4E6140	54f1a48b-8027-470a-808a-2601b369490e	2012-01-19 00:00:00
14108	4110 Hanson Lane	\N	Springwood	50	2777	E6100000010CDD93962E29DA40C0146A9E8074D86240	afea855c-2be7-4322-a814-1dcdbb57a632	2014-01-19 00:00:00
14109	Im Himmelsweg 89	\N	Frankfurt am Main	70	60075	E6100000010C00000000000000000000000000000000	bdf6560d-df27-4f34-8110-fd5c47bbf7c6	2011-08-19 00:00:00
14110	2100 Linton Terr	\N	Langley	7	V3A 4R2	E6100000010CA5802F46A28A484059049EA40DA95EC0	626178c6-d022-4a0c-83d9-8e8c3ad3b3b0	2014-05-26 00:00:00
14111	2141 Banking Road	\N	Edmonds	79	98020	E6100000010CD0352B456CE64740ADC92531A89C5EC0	f744ed6d-3950-47cf-81c1-dee832afa861	2014-01-03 00:00:00
14112	625, rue Basse-du-Rocher	\N	Colombes	178	92700	E6100000010C0EE6566FBD7B48408DDF33B0B7FB0140	48f5d1f7-4c08-4211-a063-19385212da24	2013-12-21 10:09:29.423
14113	3128 Second Street	\N	Santa Monica	9	90401	E6100000010CDEBF156B01FB4040AC825A4D8C955DC0	8ca943ca-fff0-4aa9-85fd-fbc219acd6bf	2014-05-15 00:00:00
14114	Marienplatz 52	\N	Hamburg	20	20354	E6100000010C8DE4A816D8D14A40DAAB77720C032440	8313e129-3cb7-44dd-a6fd-0c849d035ca4	2013-07-06 00:00:00
14115	363, rue Jean Mermoz	\N	Paris	161	75019	E6100000010CF4D32350827148409F6CD45044790240	3ae206d2-caa1-42b8-b491-3a60ffe6c7a3	2013-12-21 10:09:29.423
14116	4663 High Maple Court	\N	Oakland	9	94611	E6100000010C94B20DC244EF42408172CE1649925EC0	ee309b1f-1db8-47f8-a5f7-c214aecea9b2	2013-10-29 00:00:00
14117	7867 F Mt Hood Circle	\N	Esher-Molesey	14	EM15	E6100000010C00000000000000000000000000000000	3b1cf912-48ad-470a-a131-ba05d2f3dc75	2014-03-05 00:00:00
14118	84, avenue des Ternes	\N	Tremblay-en-France	179	93290	E6100000010CEE9A8622E17D484093A8D8B958780440	3525fa98-9cd4-4cc2-9c74-3e5f4e29f653	2013-12-21 10:09:29.423
14119	9363 Vista Bonita	# 123	Cliffside	7	V8Y 1L1	E6100000010C61EED662D04348408DA167F18ADF5EC0	83594fc7-7a4b-478d-94bc-d768d7ec72ac	2013-06-13 00:00:00
14120	6296 Elmonte Drive	\N	Esher-Molesey	14	EM15	E6100000010C00000000000000000000000000000000	d0634833-c9fc-4dcf-a5e4-34af66d26eb0	2012-06-28 00:00:00
14121	5477 Oak Leaf Ct	\N	Yakima	79	98901	E6100000010C3182F86DCD494740D60B6DAB930E5EC0	38557690-3f57-4a5d-88dc-2522c8a71bd7	2013-09-06 00:00:00
14122	6898 Holiday Hills	\N	Beaverton	58	97005	E6100000010C7310FE4E5DBE4640039505BEFDBB5EC0	f56ffce8-bb7a-4a2f-bd48-cb2868dcdc70	2013-08-25 00:00:00
14123	6030 Double Court	\N	South Melbourne	77	3205	E6100000010C0BFC190EF6EE42C0C5F40FBD791B6240	8115b6e4-a2c1-4832-b941-1c8b9f5a8832	2014-02-06 00:00:00
14124	7227 Frame Ln	\N	Salem	58	97301	E6100000010CFF6C7D18397D4640789F2C1542B85EC0	fdebbc88-d29e-467b-8092-040c04d2a17f	2014-02-23 00:00:00
14125	82, avenue des Ternes	\N	Metz	143	57000	E6100000010C0CF0426F37924840C11E223D66BF1840	b69a677c-9bf0-4f4d-8cbb-bf6b6fbe6fee	2013-12-21 10:09:29.423
14126	83, rue Jean Mermoz	\N	Paris	161	75003	E6100000010C81357526206848409F6CD45044790240	804f78f6-63f4-4adf-84b0-2e925fc29d02	2013-12-21 10:09:29.423
14127	8254 North Ridge Drive	\N	San Diego	9	92102	E6100000010CA5069F9A035C40400375B142704D5DC0	5f488729-73c4-4dec-9163-ba2aa1c8b558	2013-12-17 00:00:00
14128	4877 Limewood Place	\N	Hobart	71	7001	E6100000010C712DF077C36545C0E1B35AEE456E6240	01ff9398-f4ff-4598-a757-1e7169ec3315	2012-12-08 00:00:00
14129	9790 Deer Creek Lane	\N	Metchosin	7	V9	E6100000010C12D57B9F422E484025DB5E7150DA5EC0	c8c32d21-ee99-4219-8ee6-eb8b44dd89b5	2013-04-04 00:00:00
14130	9322 Sunshine	\N	Spokane	79	99202	E6100000010C7AB5974452D7474075FE598981545DC0	d9445ca6-ee8d-454c-9c70-a60914ecf68e	2013-09-10 00:00:00
14131	Kappellweg 613	\N	Essen	20	45001	E6100000010C00000000000000000000000000000000	7714c3e8-b8c6-4043-b175-daa542782f55	2014-02-08 00:00:00
14132	5323 Stanford St	\N	Rhodes	50	2138	E6100000010CCD8BB93310E740C05FC72BA2EEDE6240	a34f1233-852e-423c-8ae2-466314871a61	2013-10-02 00:00:00
14133	Wolfgangstraße 10	\N	Erlangen	8	91054	E6100000010C73240CE7C3D44840F08BC13246112640	72dfba94-802c-487c-af44-91931c495561	2014-05-18 00:00:00
14134	4490 Chablis Court	\N	Redmond	79	98052	E6100000010C2FBF3E9F80D547409C4FAA7FD48D5EC0	6fcc984f-46b6-4511-916e-dbd718e89788	2014-01-22 00:00:00
14135	Wolfgangstraße 68	\N	Sulzbach Taunus	70	66272	E6100000010C00000000000000000000000000000000	0f31a3b7-8a57-4dff-9985-850024ef4061	2013-08-12 00:00:00
14136	4277 Banana Court	\N	Burien	79	98168	E6100000010C2648A3548ABD474024EA3B7731995EC0	99985619-b8ad-4976-a57d-8dc1f4472412	2014-04-11 00:00:00
14137	2354 Crown Ct	\N	Bremerton	79	98312	E6100000010CC255B0E69DCF474046FBA6C8DAB85EC0	668b85a3-8363-41b3-977f-8df7a74a7bf7	2013-12-09 00:00:00
14138	5050 Riverside Drive	\N	Langley	7	V3A 4R2	E6100000010C6E1D2693BF88484056D91DDD20A55EC0	96df4fee-5df4-488d-a5e4-e0c874cc1aad	2014-05-06 00:00:00
14139	Buergermeister-ulrich-str 500	\N	Neunkirchen	70	66578	E6100000010CDDBA6D7D41B048403761240A45741C40	f7e71662-f0eb-4500-868e-23372ff592c5	2013-08-30 00:00:00
14140	4628 Mountain View Place	\N	Newport Beach	9	92625	E6100000010C103E782883C640401D83823DBB705DC0	2b638067-8bc3-4433-8be9-ee85ec5d12fc	2014-01-12 00:00:00
14141	7578 Sierra Road	#905	Edmonds	79	98020	E6100000010C83C29A597BE947406A1784B42C975EC0	aaa4630c-4d7e-4554-b267-c4033baf5966	2013-07-04 00:00:00
14142	783, cours Mirabeau	\N	Chatou	164	78400	E6100000010C0379F720837B484046D3F808B4400140	30227f04-9045-49e0-9583-cb9227e5437e	2013-12-21 10:09:29.423
14143	2024 Belle Dr	\N	Sydney	50	1002	E6100000010CDC56C10CA0F440C003EA5ACCA8E56240	2da3ecf5-4fc2-4b19-88e9-d1f8f48965a7	2013-07-18 00:00:00
14144	3519 Brookside Drive	\N	Fremont	9	94536	E6100000010C1D0123B3E8C2424097CA37B478875EC0	cd1ece3b-456b-4ce5-b449-3f85361d5394	2014-05-27 00:00:00
14145	8595 Central Avenue	# 228	Wollongong	50	2500	E6100000010C28F52C2E163241C0F95E389A71D86240	e9fb3dbd-4b9f-401d-8055-5c9a56957604	2012-12-07 00:00:00
14146	6978 Hoke Dr	\N	Issaquah	79	98027	E6100000010CA3C2ACA642C34740DEB397C07F865EC0	bed7d663-dc91-4754-8649-377f9ee7130c	2013-09-13 00:00:00
14147	1383 Button Court	\N	Westminster	7	V3L 1E7	E6100000010CE7067983B0A24840462DDED693BB5EC0	96cc6771-60b9-4757-9653-e3ba950a4c03	2013-06-18 00:00:00
14148	5096 Flamingo Dr	\N	Palo Alto	9	94303	E6100000010C2F87E9F417BF4240E8844D05C77B5EC0	a97e85f7-add4-4da2-a931-42593edba9d1	2013-09-17 00:00:00
14149	5423 Los Gatos Ct.	\N	North Sydney	50	2055	E6100000010C4C9ED4E40EF040C03105998838E36240	8177b4cf-6d99-4a3e-bed4-56dd43544064	2011-09-11 00:00:00
14150	Berliner Platz 1	\N	Mühlheim	20	63151	E6100000010C00000000000000000000000000000000	5fcef488-fac1-400a-a703-37fc28df4e15	2012-10-30 00:00:00
14151	9754 Hilltop Dr	\N	Lynnwood	79	98036	E6100000010C7AF4CCC2FDE44740638697DFDD8E5EC0	008a2f97-ee33-4e74-ad9e-60f27454d9f8	2013-11-01 00:00:00
14152	Pascalstr 756	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	8f6920b9-42ff-4471-be6b-fcc352b34a8a	2014-06-14 00:00:00
14153	6377 East Avenue	\N	Newton	7	V2M1P1	E6100000010CB7EDA73DFCF94A40EED733000CA85EC0	c2b75551-9a42-48ee-93eb-9ed1bf68e928	2013-07-01 00:00:00
14154	857 Alum Rock Drive	\N	Lavender Bay	50	2060	E6100000010C52A3F0DBC8E740C0967F95D133E06240	a4402adb-209c-4cb1-9447-11c586d4e817	2013-03-16 00:00:00
14155	3947 Vista Valley Rd	\N	Lake Oswego	58	97034	E6100000010CC872AC35EDAF4640373EEA5EC3A35EC0	eb9719a8-1ec4-47ed-a012-13e0728c5ccc	2014-02-25 00:00:00
14156	824 El Campo Ct	\N	Beverly Hills	9	90210	E6100000010C28851CBD22124140E291B2475B955DC0	b06aa976-460e-4cc7-9a2c-38a00de75b7d	2014-05-06 00:00:00
14157	8646 Pleasant Circle	\N	Spokane	79	99202	E6100000010CE487F4C3D4D1474005522FA7FF4F5DC0	04fd09f7-4ea1-465a-b172-9cb756b719dd	2011-11-12 00:00:00
14158	8432 Sierra Madre	#914	Beverly Hills	9	90210	E6100000010CD0029AF9B2114140E933737CB9A05DC0	a0c227ae-17b3-40d2-b1e3-faaff1cfbeac	2014-05-17 00:00:00
14159	4039 Elkwood Dr.	\N	Ballard	79	98107	E6100000010CB30E005CBDD647409E778043D79A5EC0	6210dc77-0a0e-43c5-9b0e-60d756db1927	2013-11-18 00:00:00
14160	6550 Mallard Dr	\N	Newcastle upon Tyne	14	NT20	E6100000010C66A69C9F2D7D4B40802AB93F2FD0F9BF	a09f4786-c948-4a7b-8e15-5b73637215a3	2014-05-23 00:00:00
14161	4882 Darlene Drive	\N	Goulburn	50	2580	E6100000010CE4858A2EFB4741C01EA3844F27B46240	ef37a33c-296d-413f-9694-413d6fac096e	2013-03-24 00:00:00
14162	2171 H Stagecoach Rd	#77	Burbank	9	91502	E6100000010CA95E4CB3051641403FAAFC34E1995DC0	39357f0b-ebeb-4a01-a5eb-5d51e1752640	2013-07-21 00:00:00
14163	2583 Cypress Ave.	\N	Bremerton	79	98312	E6100000010CA8390CE2DEC54740E17F2157FFBB5EC0	c5450354-d396-4f7d-b572-e4717ac75b2b	2012-12-28 00:00:00
14164	8093 Landing Court	\N	Melbourne	77	3000	E6100000010C21385232A4E442C081A50B73B9196240	3730fa7c-d2f9-4c97-bbd0-d34e83eb7e0f	2012-12-30 00:00:00
14165	5581 Stanford Street	\N	Colma	9	94014	E6100000010CDC6A5F6743D94240EEA025FB09A75EC0	589aa2b8-7a49-42ba-b1c4-5aae6116b52c	2014-05-10 00:00:00
14166	Curieweg 294	\N	Ingolstadt	8	85049	E6100000010CAA853FD248624840BC67F66B22AB2640	6d541e6c-9d10-4fda-9273-41d1eeb0b757	2013-11-02 00:00:00
14167	7832 Landing Dr	\N	Langley	7	V3A 4R2	E6100000010C5FCD6B139B8548402472EA206BA05EC0	a96219d7-5ca0-415e-bd65-4c49315911c5	2013-07-15 00:00:00
14168	6233 Serpentine	\N	Sunbury	77	3429	E6100000010C392CDEE34DC342C05D1147FC6A156240	8508a06b-decb-4212-bbfb-1666d12938a4	2013-01-17 00:00:00
14169	9073 String Drive	\N	Portland	58	97205	E6100000010C0E68E06C99C54640CF28859085AD5EC0	051a472c-6899-46bd-9258-abafae4bf5b4	2013-09-20 00:00:00
14170	2278 Rosa	\N	Concord	9	94519	E6100000010C237B987AC7F8424086C2A32904865EC0	02bb1b50-4c4d-4bb6-9d2c-8e14145cfbca	2014-02-11 00:00:00
14171	3774 Margo Drive	\N	Redwood City	9	94063	E6100000010C1D95CCFA9FB742401548627AA28C5EC0	2ad96a54-f1a8-4c78-9525-94bc4dce0ff0	2013-08-18 00:00:00
14172	7232 Bales Court	\N	Colma	9	94014	E6100000010CA3FACA0D16DE4240199ADC5EFC9F5EC0	8b9d372c-e583-4f7b-97c0-7ba1be707943	2013-09-23 00:00:00
14173	960 Pansy Dr.	\N	Seaford	77	3198	E6100000010C019AA42E101343C05C9DBDDEB4286240	7b274ccc-5a15-4d3a-8a1a-68b940419f95	2013-02-15 00:00:00
14174	1637 San Carlos Ave	\N	Langford	7	V9	E6100000010CF5E0C334E0404840B064C7EAC0D95EC0	e745d4b7-5517-41f6-8035-1f5456786862	2012-01-05 00:00:00
14175	8005 Ranchhand Court	\N	San Gabriel	9	91776	E6100000010CAC7749CE4C0C4140886BEA50248D5DC0	2b81055c-ed68-4dbc-8795-b1d702c1bc11	2013-08-27 00:00:00
14176	22, rue du Puits Dixme	\N	Pantin	179	93500	E6100000010CCDFBA0E6C37B4840034999FE16450340	5531def9-23e7-4017-bc25-ff84e51eefdc	2013-12-21 10:09:29.423
14177	2665 B Wildbrook Ct	\N	Torrance	9	90505	E6100000010CBB7F84974AE74040ABFFDA17919F5DC0	a8e02fc1-99d6-408c-a2e1-715834265313	2013-12-13 00:00:00
14178	9287 Pecan Pl	\N	Bellingham	79	98225	E6100000010C29DBA460A0604840E4EDDCD505995EC0	af7e7c3f-4588-441f-9596-9e522460c8d7	2014-02-07 00:00:00
14179	Nollendorfplatz 48	\N	Duesseldorf	19	40605	E6100000010C00000000000000000000000000000000	8afa3a6b-deb0-434e-aec2-3c3c6b1c097e	2014-04-19 00:00:00
14180	1111, rue de Longchamp	\N	Colomiers	117	31770	E6100000010C2DE05858F6CF4540E9E02BCE613BF53F	6e612fc6-8ce4-4802-81d5-9df4056f5178	2013-12-21 10:09:29.423
14181	4201 San Carlos	\N	National City	9	91950	E6100000010C29FA76BA87594040BA6EF4CD1B455DC0	b16d0341-26e5-4183-b1b4-a14cc3500819	2014-03-08 00:00:00
14182	3733 Water Street	\N	Sooke	7	V0	E6100000010C8C5D9A7F952B4840F3CB72AED2EC5EC0	a36d4c1a-3cc2-4276-aac9-d82d93bf753d	2012-01-06 00:00:00
14183	3426 Serrana Ct	\N	Geelong	77	3220	E6100000010C5414540E650C43C08B9299AB4C086240	00bc7994-e0dd-487e-a5e3-2f8179cd87ba	2013-07-15 00:00:00
14184	8675 Line Court	\N	Berkshire	14	RG11 5TP	E6100000010C00000000000000000000000000000000	de7f4610-16e8-4e45-8192-4d899ae923f9	2014-03-17 00:00:00
14185	3212 Yellowood Lane	\N	Spokane	79	99202	E6100000010C41AFF7EF6BDD474075FE598981545DC0	4c97a78e-1bf6-4c8b-b7a5-094a9b05fe3b	2014-01-29 00:00:00
14186	1290 Arguello Blvd.	\N	Yakima	79	98901	E6100000010CBBD8059153594740A0CD4376A8115EC0	615ebea8-889e-4b58-a1b3-263528efeb90	2013-07-18 00:00:00
14187	1861, boulevard Beau Marchais	\N	Chatou	164	78400	E6100000010C0379F720837B4840D25A935BF83A0140	aa4bd5c9-2a0b-41a3-b6ea-2ee89327367f	2013-12-21 10:09:29.423
14188	133 Westwood Way	\N	Rockhampton	64	4700	E6100000010C407B49C3AF6837C00B62B647F6D26240	40d4e336-eace-4318-ad52-c75cb74ef106	2012-11-05 00:00:00
14189	2317 Glen Road	\N	Renton	79	98055	E6100000010C2D4F32F5A3B647405BABE357C8905EC0	c49aa5df-b70a-4156-9768-fb7bad83bdeb	2013-06-10 00:00:00
14190	3655 Sodaro Dr.	\N	London	14	W10 6BL	E6100000010C7CBCA8FB63BA49408D835B4CD708CCBF	277fec08-399a-4e27-80b0-fc3094c10c59	2012-11-08 00:00:00
14191	5267 Mt. Tri-state Court	\N	Glendale	9	91203	E6100000010C0D5AB9A96D14414059F4CB27D0975DC0	26ee9cf8-4e14-4722-ad5d-2950298812a6	2014-03-01 00:00:00
14192	3853 Wildcat Circle	Unit 13c12	York	14	YO15	E6100000010C72072EC3B7FA4A40642CCDF3FA55F1BF	461bfba3-fdf8-4992-9295-3e1054a9119f	2012-07-29 00:00:00
14193	7057 Striped Maple Court	\N	Victoria	7	V8V	E6100000010C8C96817396354840D618A36610CD5EC0	8cf39d51-78fc-4d00-bcbf-e703940d4e52	2014-05-01 00:00:00
14194	3401 Meadow Lane	\N	Bellflower	9	90706	E6100000010C275A1FAD8DEE40405E7BEAF609885DC0	18f00f50-7520-454f-935e-c1c47501b0b7	2014-02-18 00:00:00
14195	17, rue de la Centenaire	\N	Olympia	79	98501	E6100000010CA2F64F93E38047402FC92A1D1BB05EC0	3e3c960d-2733-4495-bb07-ba64d3013625	2014-04-09 00:00:00
14196	9906 Oak Grove Road	\N	Bendigo	77	3550	E6100000010C70A25DA5F66042C09FEA73E5FB076240	b67b480d-118c-41c5-bef1-757d0b7fa473	2014-01-12 00:00:00
14197	9436 Oakmead	\N	St. Leonards	50	2065	E6100000010C4A2CD8480AEE40C0896B0AB58DEB6240	ad341311-f5fb-454c-b036-10c329b6a5f3	2011-07-29 00:00:00
14198	4667 Cook Pk	\N	Royal Oak	7	V8X	E6100000010C3EC86F47CC4148404CA4D9304AE15EC0	a562ac00-e9bf-4bfd-b355-f59b8963020e	2013-07-08 00:00:00
14199	6416 Teakwood Drive	\N	Beverly Hills	9	90210	E6100000010C898E26CBE11341409255A13953925DC0	4cddcce1-90f8-49ce-9721-88271af21166	2014-03-23 00:00:00
14200	2785 Snow Drive	\N	Shawnee	7	V9B 2C3	E6100000010C188013B0373D4840BD807D3A1FE65EC0	e94334f8-7b4c-4522-8a82-559fd0b10761	2013-07-12 00:00:00
14201	7444 Cherokee Drive	\N	Daly City	9	94015	E6100000010CF565E78A3DD142402CA128AEE4A25EC0	30e4074f-4631-420f-9153-086236df28ed	2014-04-29 00:00:00
14202	4138 Shore Rd.	\N	Roncq	145	59223	E6100000010C49752DB3735A4940BE3A4620FEF40840	1a9487c9-de79-4cc7-b8d2-277b37fd91e8	2013-12-21 10:09:29.423
14203	9039 Blocking Ct.	\N	East Brisbane	64	4169	E6100000010CF13C3461577C3BC0835D24E62E286340	546acb15-fa91-4844-9ff1-d5935f0e8fc2	2013-10-24 00:00:00
14204	8512 Arrowwood Circle	\N	Los Angeles	9	90012	E6100000010CC0C0334BF20A4140228324D86D915DC0	f8e531f3-5dba-456e-939a-c17bcdf3a76f	2014-05-28 00:00:00
14205	6336 La Orinda Pl	\N	Burlingame	9	94010	E6100000010CDC5317FB27CC4240724A1FB01D9F5EC0	073583a6-ea49-47a7-83d3-0b86576ed050	2013-11-02 00:00:00
14206	6122 Orange St	\N	Port Hammond	7	V6B 3P7	E6100000010CBA76C7CA4AA748408C25FE681DC75EC0	07e2b64f-d866-414d-8c18-d7ceff774938	2013-07-31 00:00:00
14207	7545 Stanford Way	\N	Malabar	50	2036	E6100000010C1D9CE479B9F840C0879335E36DEC6240	f06cbe32-9af8-49b9-a859-e38aa40f58d4	2013-09-01 00:00:00
14208	1544 Quiz Street	\N	Royal Oak	7	V8X	E6100000010CBDD46E0FB23E48406CA90CFAB4D05EC0	b3c957d3-8e44-4bd7-bc75-132ee3eef95c	2013-12-17 00:00:00
14209	4240 El Campo Ct	\N	Lincoln Acres	9	91950	E6100000010CA346B7D55D5A40405125B646DC425DC0	c3943583-4841-47c7-b5eb-fc7341926057	2013-12-23 00:00:00
14210	4708 Biscayne Court	\N	Melton	77	3337	E6100000010C5DE51184D5D342C01BE176B1A80F6240	1617f402-903a-41e5-9a4f-ac7b270246d0	2013-10-20 00:00:00
14211	Am Gallberg 22	\N	Grevenbroich	8	41485	E6100000010C00000000000000000000000000000000	620d35c9-fa60-4624-92d0-2f2bb8d567f7	2014-05-22 00:00:00
14212	2572 Hill Dr	# 2	Edmonds	79	98020	E6100000010C2738BA0B27ED47407E83C53AFE8C5EC0	6b67761b-2e60-43f7-bbbe-6911a43d89ac	2014-04-19 00:00:00
14213	5522 Deer Ridge Way	\N	Berkeley	9	94704	E6100000010CF0FF7EF12AEB42405C8E9CD14F935EC0	e110d678-48b2-43bf-b5c0-83b570fc1bbc	2014-04-17 00:00:00
14214	7013 Cimarron Drive	# 110	York	14	YO15	E6100000010C1CC7CC33E2F54A40DF4184C28759F1BF	5f79cdfe-0a2e-4ead-9294-d82a8d94d71c	2013-07-15 00:00:00
14215	Lieblingsweg 543	Verkaufsabteilung	Erlangen	8	91054	E6100000010CD292FB996EC74840CFB3A413E30D2640	67fba154-798f-41df-819e-6def7e8a2f1e	2012-09-09 00:00:00
14216	9967 Malibu Place	\N	Downey	9	90241	E6100000010C8136F4E89DFE40401202A6EC39865DC0	e594a9a9-a5d5-4504-b92c-a20ef9357254	2014-01-07 00:00:00
14217	1463 El Verano	\N	Downey	9	90241	E6100000010C8136F4E89DFE404075958F05BD875DC0	0b1e77d5-0ebb-44f5-bffe-d28b4a10ac7d	2011-12-25 00:00:00
14218	5800 Abbey Court	\N	Caloundra	64	4551	E6100000010C1E83508971C03AC0F8BA700F68256340	77b4b1b6-f23e-4305-8392-8aacda476fad	2013-03-16 00:00:00
14219	4921 St. Geemain Lane	\N	Redwood City	9	94063	E6100000010C1328341481BA4240AC9CA13705965EC0	11a052bf-24c9-4e2a-9ed5-d6031b127f1d	2014-04-06 00:00:00
14220	9326 Mayda Way	# 2	San Diego	9	92102	E6100000010CFD7DE6F89156404089B2A73171475DC0	4d65ea0d-9666-4226-b5d2-c3752d7c1374	2013-12-19 00:00:00
14221	Conesweg 1	\N	Darmstadt	19	64283	E6100000010CFA71A10B0DF0484015100DAA4A512140	00af6bf9-f12b-40f0-b4d1-cbd2822d9ae1	2013-12-15 00:00:00
14222	5695 Laurel Drive	\N	Milwaukie	58	97222	E6100000010C25D3857725B4464033FB1068DFA45EC0	04c73d3e-3a95-4f0c-bb0a-bdd9be42048a	2013-11-06 00:00:00
14223	3606 Bolton Circle	\N	Geelong	77	3220	E6100000010C5414540E650C43C035A724EBC2086240	6b8fadc3-a698-4e50-a6fa-a07966df2800	2013-08-12 00:00:00
14224	1601 Crown Court	\N	Corvallis	58	97330	E6100000010C3289A4956A4B464059FABE48C5D05EC0	a237ff65-f83b-4d69-a484-0f8415e9ab89	2013-09-29 00:00:00
14225	964, rue des Grands Champs	\N	Lille	145	59000	E6100000010C8020345EFB584940A9663D3B20640840	40347fa1-b262-49da-92be-3d60c023c952	2013-12-21 10:09:29.423
14226	879 South Royal Links	\N	Westminster	7	V3L 1E7	E6100000010CD4E630FFF2A348406EFA584012B65EC0	4e50311d-3f67-4802-818d-181f3d9c9512	2013-11-19 00:00:00
14227	5792 Mori Court	\N	Walla Walla	79	99362	E6100000010CA9C9CC6B24144740056F7D6C719E5DC0	45b1f6d9-0bbb-4f76-8155-61bd20ab875a	2013-08-10 00:00:00
14228	492 Loveridge Circle	\N	Los Angeles	9	90012	E6100000010C20B7BC1FF80341409F7B8A00B3935DC0	c5597569-6ff5-4290-b3a8-94c47803ed8a	2013-12-31 00:00:00
14229	279 Inverness Drive	Unit C3	Downey	9	90241	E6100000010C1C0CE2EDB4FA404004ACAAF58A8E5DC0	c0ac5fe2-a4f6-4733-afc3-28440a640794	2014-01-28 00:00:00
14230	8355 Lighthouse Way	\N	West Covina	9	91791	E6100000010C0E1DB1A7FE0D41404497DCA1DA705DC0	7e61300f-423a-4b04-b5ea-3e80827e292e	2013-11-17 00:00:00
14231	7118 Elliott Dr.	\N	Gateshead	14	GA10	E6100000010C47DBC6009C804B4090C632DB6C0FF9BF	1d2ce554-d9d0-4f1b-be17-5fd621dbb1b8	2014-05-08 00:00:00
14232	8396 Grand Ct	\N	Woodland Hills	9	91364	E6100000010CA9690CA1CA0E414019CE3FDC02B15DC0	03d08820-58e1-408f-901d-06ab8800bbf8	2014-02-21 00:00:00
14233	Bundesallee 7432	\N	Paderborn	53	33098	E6100000010C01A769FF9AD74940151967A27F862140	958d9112-3be6-4294-88fe-5ae5447797dd	2014-01-22 00:00:00
14234	8483 Wilke Drive	\N	Cliffside	7	V8Y 1L1	E6100000010CB1DBD16EB5404840764394AFF6DD5EC0	87238aed-eb97-4a93-8dfb-448db65b47c3	2013-10-23 00:00:00
14235	9677 Elkwood Dr	\N	National City	9	91950	E6100000010C41C8754D2F564040D06F30B45A4A5DC0	8c366d98-687b-466c-8e00-22a88c64a696	2014-03-19 00:00:00
14236	920 Holiday Hills Drive	\N	Redwood City	9	94063	E6100000010C0ABB9B2D62BD4240ED9DC21BF1875EC0	096dbd91-f274-4156-9f1e-13e216688b2f	2014-05-18 00:00:00
14237	4124 Escobar St	\N	Woodburn	58	97071	E6100000010C5525E31C6B9B4640F68D6ABFC3B45EC0	33910793-3bfd-4fd9-818c-238662286541	2013-07-30 00:00:00
14238	7127 Los Gatos Court	\N	Colma	9	94014	E6100000010C3213BE6D07D24240A79E621CB0A45EC0	d1343ce5-f558-41eb-b954-e26c787f96e8	2014-05-19 00:00:00
14239	5619 Gathering Court	\N	Oregon City	58	97045	E6100000010C0BBF6985B6AD46404B3BAC8F10A85EC0	880931f2-419f-4f0a-aaea-92853c55445d	2014-01-11 00:00:00
14240	4644 St. Andrews Way	\N	Townsville	64	4810	E6100000010C04972AD0DC4033C0DF519CB2AF536240	2aea2d1d-70aa-4baa-8a17-d24abee2e215	2012-09-11 00:00:00
14241	1733 Thistle Circle	\N	Bellflower	9	90706	E6100000010CBFF63251C2F34040FF13BE2F938C5DC0	5563ac3c-ab98-4987-b538-77f2d07e81d3	2014-05-12 00:00:00
14242	669, rue Philibert-Delorme	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	7aa19e0a-f2e2-407c-8e24-681dbf142c4a	2013-12-21 10:09:29.423
14243	3483 Flamingo Drive	\N	N. Vancouver	7	V7L 4J4	E6100000010CDD8A1EE6B3A64840201E47B174BB5EC0	30fc05bc-5c58-4a7f-8a3c-eed6b7e76899	2013-10-08 00:00:00
14244	9850 Martindale	\N	Lynnwood	79	98036	E6100000010CC785E38642DE47406F262354B1965EC0	9c605a05-a6af-4d60-b3cb-b5db120e009a	2014-01-31 00:00:00
14245	4510 Ten Penny Lane	\N	Sedro Woolley	79	98284	E6100000010CD1D93C1682434840A65B844F39845EC0	d8925143-21e7-415b-b7f8-7f6826fb91f3	2014-04-04 00:00:00
14246	4299 Vernal Drive	# 132	Burien	79	98168	E6100000010C82611C8E6CB44740540EE8F730875EC0	3ac4bd98-5474-4f4c-b8ce-dd564ea04c92	2014-05-21 00:00:00
14247	906, rue de l´Avenir	\N	Colombes	178	92700	E6100000010C4C4ADB4E566D4840CD693858F0FE0140	8a8714d2-dbe9-4552-b7ec-a478bcffee1c	2013-12-21 10:09:29.423
14248	1133 Leisure Lane	\N	Sooke	7	V0	E6100000010CF6B2EB27D7284840DCD20B5D02EE5EC0	30ca09c9-851f-4635-96e5-0ea077d3ffd5	2012-01-02 00:00:00
14249	2187 S. Rising Ave	\N	London	14	W1V 5RN	E6100000010CCF607C4C6CC54940E818FBD72646C0BF	d78c3791-1bd0-461f-9082-6164c953b653	2012-12-12 00:00:00
14250	6046 Dale Pl	\N	Woodburn	58	97071	E6100000010CF29855985393464061A4D853C5BF5EC0	d9de013f-4b14-4158-8c0e-48634460ca27	2014-01-01 00:00:00
14251	5578 Ruth Drive	\N	N. Vancouver	7	V7L 4J4	E6100000010C3D60BADD6EB14840256BF5120FC85EC0	aff8424d-0266-4f28-b246-0e519911a2eb	2014-02-14 00:00:00
14252	746 Cast Street	\N	Rockhampton	64	4700	E6100000010C37C71A25496937C002AC6D3D97CF6240	870f60fb-4fc5-4797-ae49-48ee0a6c2fb2	2013-01-13 00:00:00
14253	3675 Palms Dr	\N	Burbank	9	91502	E6100000010CD6A095AE15194140C11FB6C138895DC0	48ccaa66-2be6-4735-9c3d-653f45e60779	2014-04-03 00:00:00
14254	533 Beauer Lane	\N	Edmonds	79	98020	E6100000010CFE7A1B6C96E44740B55897B24E9A5EC0	a6028e21-c0a6-4a55-a6c6-de28c2da7eee	2014-06-09 00:00:00
14255	28, quai Paul Doumer	\N	Paris	161	75008	E6100000010C553991F6D4724840F27BAAF820800240	3b0d9909-4557-4704-85d4-8edf045879ec	2013-12-21 10:09:29.423
14256	530, rue des Berges	\N	Versailles	164	78000	E6100000010CA0890B386F6A484022B2DCE0CFEC0040	17ac3793-0fbf-4368-b8f5-106dcfb07609	2013-12-21 10:09:29.423
14257	8609 Camino Peral	\N	Puyallup	79	98371	E6100000010CE08C68F4759447406346871B4F9A5EC0	58ccf9b2-6084-4a94-9f26-cbcbd2d161d0	2014-03-19 00:00:00
14258	1306 B St.	\N	Metchosin	7	V9	E6100000010C27A23AC5063A4840F436776E2CE65EC0	ecb188ed-c220-4dbc-ac4e-d52af6271935	2014-05-08 00:00:00
14259	9637 Kenneth Ct	\N	Woodburn	58	97071	E6100000010C51813DCDDB8F4640E016A9360CB05EC0	a040a5f0-b91d-41c7-a5f5-4ad82c905669	2011-11-28 00:00:00
14260	7466 La Vista Ave.	\N	Matraville	50	2036	E6100000010C84F2A20D3FF540C066E46991E1ED6240	7c427424-94f5-462c-a35b-674d5390ac8d	2013-09-10 00:00:00
14261	Postfach 66 00 77	\N	Poing	70	66041	E6100000010C00000000000000000000000000000000	ccd452ff-864d-47c3-9d55-726f32df4dc3	2013-12-13 00:00:00
14262	2588 Wellington Ct	\N	Issaquah	79	98027	E6100000010C9D251A4E38C04740B8BAD5AEC97A5EC0	9194ac44-97d3-4cd9-ac02-3acf44547aee	2013-09-14 00:00:00
14263	1174 Ayers Rd	\N	Downey	9	90241	E6100000010C51743FCF71FC4040F508099BCF905DC0	c4a1154f-c275-4a9b-b181-c2d14dd2fe53	2012-08-20 00:00:00
14264	4833 Maine Dr.	Unit C4	Burlingame	9	94010	E6100000010C68D4CD0A4FC842403F727BAA518C5EC0	9e22a517-6aa2-43b4-88f9-159adc39f655	2013-09-23 00:00:00
14265	487 Ash Lane	\N	London	14	W1Y 3RA	E6100000010C04773FF460C949408B8640D0264BC0BF	959e3b9d-f4a8-4f08-9c81-0d17b5f4f45b	2013-02-08 00:00:00
14266	4378 Westminster Place	\N	Port Macquarie	50	2444	E6100000010CA5DDB97DCC693FC01C69C3F6CD166340	6165f0b6-dc4f-405e-8bf7-3c5b723ba6e3	2011-09-07 00:00:00
14267	3361 Crow Street	\N	Burbank	9	91502	E6100000010C2896F3B1E51641401B2D273D6C9E5DC0	3c659c2d-cd7e-42fe-bd47-89f74f701c47	2013-12-27 00:00:00
14268	5424 Bel Air Drive	\N	Cloverdale	66	6105	E6100000010CE634EFACB1F93FC06C41178C4E015D40	cbfc6e6e-a346-4c91-aa8a-26924052b7a1	2013-10-07 00:00:00
14269	9152 L St.	\N	Everett	79	98201	E6100000010C7FF8D69EEDFF4740B7FEBA2482955EC0	86bbac54-cc71-4e30-8581-d4fc58cd520e	2013-10-26 00:00:00
14270	2038 Encino Drive	\N	Burbank	9	91502	E6100000010C03E3DEA9251C41400C61CB457E8B5DC0	546f8666-5289-499b-b2c9-45f0ddab040e	2014-02-25 00:00:00
14271	7015 F Mt Hood Circle	\N	Watford	14	WA3	E6100000010C369BD5E6B9DC4940D49B2D34C1FCD8BF	4a0916ff-7063-43a1-b8a6-287feeef1ad6	2013-04-22 00:00:00
14272	2786 Class Avenue	\N	Coffs Harbour	50	2450	E6100000010C85A0810DEE203EC0F777FDE362226340	f0271ae6-dac2-4220-9fd2-b57ef6e015fb	2013-01-30 00:00:00
14273	3384 Malibu Place	\N	Walla Walla	79	99362	E6100000010C7CCC733C31114740B3CC1582818B5DC0	9fa5a07f-49fd-4c7b-bf45-e469bc068135	2011-11-27 00:00:00
14274	8043 Pheasant Court	\N	Brisbane	64	4000	E6100000010C7FF56F46C37F3BC0D1F382F1561A6340	e1380228-82f9-4e13-a07e-5e18b6ba1e31	2013-01-03 00:00:00
14275	4666 Lancelot Drive	\N	Long Beach	9	90802	E6100000010C8E185B3631E44040B56C10A9D6895DC0	e8e457f5-7d1a-483a-ad21-9cb4737a07ef	2014-05-01 00:00:00
14276	Marienplatz 31365	\N	Berlin	70	14197	E6100000010CC5492E22E62F4A4072161E85A5A32A40	93bd21f1-bd25-4853-abc2-026a0442ba13	2013-07-24 00:00:00
14277	2235 Craig Drive	\N	El Cajon	9	92020	E6100000010CB522076106674040FAA07828DE3D5DC0	f67288e3-419c-44a4-a9f6-8eb7af871d1a	2013-11-02 00:00:00
14278	9111 Rambling Rose Ave	\N	Runcorn	14	TY31	E6100000010CFCA17CC9DAB34A4013D0DD68D4A305C0	8dc39610-8128-41a2-af65-f29f86cfd190	2013-09-15 00:00:00
14279	6935 Candle Dr	\N	Hervey Bay	64	4655	E6100000010CAB943BF3285839C087DB10AA13166340	555ee16c-4ac7-4675-834d-bae33ace4e03	2011-07-31 00:00:00
14280	6721 Baldwin Dr	\N	Langley	7	V3A 4R2	E6100000010C31E7B6ABB0944840A45A9E33E7B05EC0	c8893071-66b3-4400-b89b-9f51f3020d10	2014-05-26 00:00:00
14281	4799 Buena Vista	\N	Gateshead	14	GA10	E6100000010CD446C75990854B40AEA85D5406A0F9BF	0250cb7e-7332-46b3-b730-3ab2069a1db9	2014-04-15 00:00:00
14282	64, rue des Grands Champs	\N	Colomiers	117	31770	E6100000010C59D7812814D1454012C3A78A4B3AF53F	325efbb5-c26b-4d15-900b-12c54a04ef67	2013-12-21 10:09:29.423
14283	4839 Ramsey Circle	\N	Victoria	7	V8V	E6100000010C93FCC83D023048408EE62C69CDE05EC0	f18deb30-e7fd-4321-b81a-0c6fdf3e91a3	2013-11-21 00:00:00
14284	4909 Vine Lane	\N	Woolston	14	WA1 4SY	E6100000010C2838C33C19BB4A40485AC5CFAA1E04C0	52bb0636-2c32-4dff-8363-f43e728eba94	2012-09-24 00:00:00
14285	6121 Pebble Glen Drive	\N	Colma	9	94014	E6100000010CA3FACA0D16DE4240BF4A8F5B41A65EC0	ea48ae2c-707d-4636-9aa4-bca9b9a22662	2014-02-23 00:00:00
14286	7362 Arguello Blvd.	\N	Woodburn	58	97071	E6100000010CB9D20ED6478F4640EEB5554256B65EC0	2078796e-b68f-460f-a66e-659f154ebe8c	2014-05-19 00:00:00
14287	9430 Thornhill Place	\N	Concord	9	94519	E6100000010C6279F47CCEF7424010EA2D91E4825EC0	cb401005-c122-4e6e-9d14-423e9f1ca11b	2014-03-11 00:00:00
14288	Buergermeister-ulrich-str 5000	\N	München	53	80074	E6100000010C00000000000000000000000000000000	7df62649-f8b0-483a-984b-0177aed333f2	2013-09-21 00:00:00
14289	2062 Woodruff Lane	\N	Glendale	9	91203	E6100000010CB2A08E8B0E104140C4D04F20F28A5DC0	9c1f9b15-1160-4e98-9d90-16d070bd6885	2014-04-26 00:00:00
14290	5520 Massolo Drive	\N	Palo Alto	9	94303	E6100000010C7B75C43897B342403FB29D18B8865EC0	6e655a89-7a27-489d-af2a-debf38e8205c	2014-01-08 00:00:00
14291	Hansaallee 5589	\N	Bottrop	53	46236	E6100000010C83757EC22EBF49407BF04FB27DB11B40	b291355e-1ad5-4815-b3a5-265bfec83686	2014-01-06 00:00:00
14292	376, rue de Terre Neuve	\N	Versailles	164	78000	E6100000010CF01EC0B52E6E48400D05AF410DF50040	03fbd077-4e5f-4523-8b74-10d556ff8baf	2013-12-21 10:09:29.423
14293	8297 Dos Encinas	\N	W. Linn	58	97068	E6100000010C72F681A9F7B24640959DF17B07A75EC0	f7fa5b35-7bd7-4bc7-9dfa-f8b4e38e7c71	2013-06-17 00:00:00
14294	3168 Limewood Pl.	\N	Chula Vista	9	91910	E6100000010C9C1B78BD604E404096AD0E8E1F3E5DC0	7d745e97-9517-4cfa-9b57-b8f5b5651de9	2014-01-14 00:00:00
14295	7575 Brown Dr	\N	Spokane	79	99202	E6100000010CB4BB379938D147402A36E84780515DC0	62a62723-f665-474c-86b5-cf06e071854e	2013-10-09 00:00:00
14296	5703 Rose Dr	\N	Berks	14	SL4 1RH	E6100000010CBBC7DCAE21BD4940699A7FCDAD80E3BF	1b82320b-fb37-4ff6-8cda-d57bf175307f	2012-10-20 00:00:00
14297	2489 Teakwood Drive	\N	Tacoma	79	98403	E6100000010C0BDEA73ACFA54740AB6ED7599EA65EC0	ce19fb5c-9687-42e6-a6fe-7f865ca91f88	2013-06-23 00:00:00
14298	8096 Mt. Washington Way	\N	Hervey Bay	64	4655	E6100000010C55E9665E445439C0B336C5E352216340	e918b382-b102-41bd-ab58-d73f5956bffe	2013-07-24 00:00:00
14299	2022 Highridge Court	\N	Oregon City	58	97045	E6100000010C0DAC5A00E9A74640C0D830034D9C5EC0	33b892ce-018a-4262-82cd-abe3986c128f	2014-01-25 00:00:00
14300	3521 Fourth St.	#607	London	14	W1X3SE	E6100000010C51F39E2DB8C8494044ABB5DF2641C0BF	23cd91fd-ff4d-414b-b629-a272f1683ed7	2013-05-24 00:00:00
14301	Parkstr 4246	\N	Salzgitter	19	38231	E6100000010C9A9BC4A01D154A4049C2533DDAB52440	f267c103-cb9f-4410-a372-d0722fc0f984	2014-03-22 00:00:00
14302	6975 Ridgewood Drive	\N	Glendale	9	91203	E6100000010CF7F8635EEE104140DD60B2D3AC885DC0	d623c667-208e-4ffa-9180-2347301ad588	2013-07-17 00:00:00
14303	5053 Sea Point Way	\N	Lakewood	9	90712	E6100000010C6358FC64E1ED4040ED3B2408F3935DC0	2b686212-aa49-4e25-9848-87eac5296e73	2013-01-21 00:00:00
14304	44, rue du Départ	\N	Roubaix	145	59100	E6100000010C92A87C0A67594940E2C7703B1D7B0940	8d09d0e9-70d9-407f-b374-4d412ac601dd	2013-12-21 10:09:29.423
14305	5093 Greer Ave	\N	Concord	9	94519	E6100000010C861E9F1ED6F342409F71F596237D5EC0	dc9646c0-53b7-40f4-ad19-2431cd9f0289	2012-11-05 00:00:00
14306	30, route de Marseille	\N	Dunkerque	145	59140	E6100000010C17397B46568B49407A503435C0C90240	06b37d98-0c1c-447a-946f-7a14db7ae558	2013-12-21 10:09:29.423
14307	29, rue Jean Mermoz	\N	Metz	143	57000	E6100000010C6C85403479934840BEAD46A378B11840	146d4a75-830a-4c67-ba28-b1a4089d142c	2013-12-21 10:09:29.423
14308	6375 Freda Drive	\N	Victoria	7	V8V	E6100000010C5352242435364840DE37DA9AF5D45EC0	97fefa6f-0de7-4fa4-87f5-55450e49015f	2012-07-03 00:00:00
14309	1519 Birch Bark Road	\N	Chula Vista	9	91910	E6100000010CAB471B70E2504040A367B1939B4B5DC0	88a028a3-957a-4622-88bb-d281d04ca55d	2014-06-08 00:00:00
14310	5473 Sunshine	\N	North Sydney	50	2055	E6100000010CBF2BC3CB20E940C001947E74D5DF6240	bfe80fa5-cc43-49d0-a65c-744ee2effb81	2013-08-12 00:00:00
14311	4723 Zion Avenue	\N	W. Linn	58	97068	E6100000010C266C65B029AD4640C3EAF577D0A75EC0	75791d04-2740-4992-8600-6a65e3b42779	2014-01-05 00:00:00
14312	6218 Alpine Rd	\N	Milwaukie	58	97222	E6100000010CD7FF8FCC70D14640AAFF50897BA65EC0	de15f2da-a3de-487d-976d-aace6a3c755f	2014-05-02 00:00:00
14313	6231 Sequoia Woods Pl.	\N	Milsons Point	50	2061	E6100000010C6BFB70B006F240C0ADBC0A449CED6240	e775c797-78af-4526-8589-fccef0d3a3ec	2013-09-25 00:00:00
14314	Postenweg 4642	\N	Saarbrücken	70	66001	E6100000010CB0FB4E83FF9C484013630EEC3F081C40	b3552825-25d5-4e64-bdf3-6ad1337f358a	2013-05-10 00:00:00
14315	44, rue du Départ	\N	Suresnes	178	92150	E6100000010C5BB6B665DC6C48402E74F72289BE0140	8cd35097-3c0e-4c4a-a1da-849572db2dc7	2013-12-21 10:09:29.423
14316	2333 Fillet Ave	\N	San Gabriel	9	91776	E6100000010C41A63DA8A006414071E396E650835DC0	5c5a54b0-c487-4cb8-bb88-b85946855b05	2012-12-13 00:00:00
14317	4082 Roslyn Road	\N	Langley	7	V3A 4R2	E6100000010CFBD36778F29548408361B7F38EA35EC0	ad5d8e67-07bc-4113-902f-7a2e12b48c36	2013-08-21 00:00:00
14318	500, avenue de la Gare	\N	Saint Germain en Laye	164	78100	E6100000010C16DED592B87948408BE2D01AE1CC0040	dd908a39-eaf0-486c-be8c-cc422c776a63	2013-12-21 10:09:29.423
14319	451 Creed Ave	\N	Lebanon	58	97355	E6100000010CD8551FEF524146405923854FABB05EC0	b8c5897c-5df8-4187-a256-50659af41792	2014-03-15 00:00:00
14320	Galeriestr 6267	\N	Münster	70	48001	E6100000010C00000000000000000000000000000000	2fe3efa7-c8ad-46e7-bd98-d730d117eac3	2013-02-24 00:00:00
14321	7554 Grammercy Lane	\N	Concord	9	94519	E6100000010C479156C766FF424007EB63F770765EC0	e01b8be8-b049-4f17-b0b0-d8e750ff4bd9	2011-09-29 00:00:00
14322	5109 Fawn Glen Circle	\N	Port Orchard	79	98366	E6100000010CFA6B91BFA8CC4740815E054D28A55EC0	f431b90f-6caa-44da-8998-849143d02ed8	2014-04-07 00:00:00
14323	1732 Parakeet	\N	Port Hammond	7	V6B 3P7	E6100000010C47E380204F9B4840CB6DC2EDCFC05EC0	f849beb6-b612-461a-8756-2352927bd730	2013-11-06 00:00:00
14324	9513 Ridge Park Drive	\N	W. York	14	BD1 4SJ	E6100000010C1FF3B7620FE44A408D35F09F510BFCBF	b8c15ce1-3253-427c-b9a4-66dce8097061	2014-01-30 00:00:00
14325	3952 Morello Ave.	\N	York	14	Y03 4TN	E6100000010C2E99193B6EF24A400DBF9AF2C253F1BF	f8170ffc-1067-4a4c-a1dc-c5f3669e2c02	2014-03-11 00:00:00
14326	6645 Sunshine	\N	W. Linn	58	97068	E6100000010CF7691DC9EFB046402A8CEABF24AB5EC0	498e39d7-31c6-4bc3-a2b7-3b2b0eaffcd3	2011-10-07 00:00:00
14327	8943 Mt. Washington	\N	North Sydney	50	2055	E6100000010C25874303A0EF40C03AFC80D282E96240	f4be4016-6c40-44e1-8335-d2582bc3fb3d	2014-02-24 00:00:00
14328	1345 La Luz	\N	Yakima	79	98901	E6100000010C048350C18C544740875BB778CE0D5EC0	f5986292-30fa-435d-b95a-b4e6b86c7ab4	2014-04-19 00:00:00
14329	6154 Geneva Ave.	\N	Milton Keynes	14	MK8 8DF	E6100000010C8E6FEA57BE024A40AFC2F121057AE9BF	3ea7e4f6-5837-4c6b-bfb3-cf84761b49a7	2012-04-24 00:00:00
14330	9208 St. Germain Lane	\N	Everett	79	98201	E6100000010C272AE193AF064840D10B828C2C815EC0	bfd368e3-4e2e-44ce-a1a5-45ac009cf889	2011-11-03 00:00:00
14331	1905 Horseshoe Circle	\N	Oak Bay	7	V8P	E6100000010CA983A8B7B13948400E18AE0EA1DA5EC0	84c9b963-c605-4504-87af-1b120c222ebb	2012-01-24 00:00:00
14332	7111 Stinson	Unit E	Concord	9	94519	E6100000010C1E83FAEF27FD4240B787D5DE8C805EC0	bb06a7e4-0236-4c8b-93b6-74c20dadd394	2014-03-31 00:00:00
14333	242, avenue Reille	\N	Saint Ouen	127	41100	E6100000010C18D52FD7FEEB47408583FD395057F13F	f161fe95-73b5-4d41-be27-70268efda17f	2013-12-21 10:09:29.423
14334	237 El Centro	\N	Lake Oswego	58	97034	E6100000010C0B33656D28B54640D5628B5D9FA05EC0	562521f9-3de7-4032-8870-51690defe792	2014-02-27 00:00:00
14335	6628 Ranch Drive	Box 21	London	14	SW6 SBY	E6100000010C8C4AB9A477C1494039F4347C514AC0BF	d0a0e3a4-2e39-4516-8910-4795bc35b6bb	2014-03-31 00:00:00
14336	280, avenue de la Gare	\N	Croix	145	59170	E6100000010C44BDBF607D5949401A6B715B66420940	31057203-9e6f-44da-a647-de213d5419f2	2013-12-21 10:09:29.423
14337	3187 Hackamore Lane	\N	Grossmont	9	91941	E6100000010C14E8082F2E614040658AC84C8C365DC0	84c52622-6005-40f0-8874-fb506307963d	2013-10-20 00:00:00
14338	8, rue de la Comédie	\N	Cergy	181	95000	E6100000010C870B6EC5268648406E11E597C4880040	c10f6a9d-5546-4e6e-b906-00e3a736289a	2013-12-21 10:09:29.423
14339	1773 Royal Palm Lane	\N	Burbank	9	91502	E6100000010CC37E32A9951C41403FAAFC34E1995DC0	4229396c-85bd-42f4-b215-39bda2cba371	2011-08-06 00:00:00
14340	7632 Oxford Way	\N	Port Orchard	79	98366	E6100000010CD26B0BA0F7C54740A5502E6FA6AA5EC0	0b472946-4deb-4dd7-abc9-8e38bf2681bb	2014-05-14 00:00:00
14341	Wolfgangstraße 28	\N	Frankfurt am Main	20	60082	E6100000010C00000000000000000000000000000000	6f6bf6ea-f985-4286-8629-560a036b4628	2013-06-28 00:00:00
14342	9127 Pinnacle Drive	\N	Bremerton	79	98312	E6100000010C35CBF244F6CB47409DF2B1AB91B25EC0	b89e4091-90fd-4bcd-ae65-e239a28d78b3	2012-04-03 00:00:00
14343	2587 Windmill Way	\N	Kirkland	79	98033	E6100000010C506D599DC6D14740AAF2AD54EB8F5EC0	fd4c7123-16e1-4f46-b00f-740133c7dcb5	2014-04-30 00:00:00
14344	6991 Pembroke Dr	\N	Cranbourne	77	3977	E6100000010C38DE1F50510C43C0DB58EB84AC2E6240	fac1e7fb-f762-4eeb-a2db-310b92390bb5	2013-10-27 00:00:00
14345	3913 Euclid Ave.	\N	Oxon	14	OX16 8RS	E6100000010C00000000000000000000000000000000	73589a95-22b2-4dab-bb19-0bfc778dbafe	2013-06-12 00:00:00
14346	705 Temple Drive	\N	Edmonds	79	98020	E6100000010CA2F03A1E42E84740D1534ABAC68D5EC0	07322741-1bef-418e-8635-ea6a8975c248	2014-04-16 00:00:00
14347	Hansaallee 466	\N	Salzgitter	19	38231	E6100000010C00000000000000000000000000000000	897a17bd-bf7c-4f41-82a5-0df900e24f9d	2014-02-16 00:00:00
14348	5363 Willow Pass Dr	\N	National City	9	91950	E6100000010C3561F683DB574040B7DCB3A5DB455DC0	a3d2d773-9ac2-47c1-8ae3-9235422dd5eb	2013-12-01 00:00:00
14349	1986 St. Andrews Way	\N	Lebanon	58	97355	E6100000010C26BDBE4F954B4640C9948F3707BE5EC0	5d41d659-fbc6-49f3-ad18-75c26827de1d	2012-11-30 00:00:00
14350	9555 Mt. Whitney Way	\N	Santa Cruz	9	95062	E6100000010C623674417E7F424011F539F1B6775EC0	3f69215d-5ed8-4325-a006-e94275776ab4	2014-03-01 00:00:00
14351	Postfach 20 99 99	\N	Hamburg	20	20354	E6100000010CCBBA990A22C44A405B30C96471FE2340	5002a977-fd01-4179-ab78-f25ef5f65f21	2014-04-02 00:00:00
14352	759, rue de Bas Marin	\N	Versailles	164	78000	E6100000010CE35EA23CF0624840F40AA10948F00040	505ce4d0-3ff8-4453-9048-45879943d522	2013-12-21 10:09:29.423
14353	Klara Straße 8464	\N	Werne	53	59368	E6100000010CFAFBADA031D2494002595E74FD7A1E40	ed40c62d-dfcc-4dc0-942b-238249cde210	2013-04-01 00:00:00
14354	4255 Detroit Ave	\N	Kirkland	79	98033	E6100000010CDE6112DCCFDF4740A2817723238F5EC0	63485752-1de9-45e5-b5ba-91dfbe76eef9	2013-08-14 00:00:00
14355	4041 Jam Way	\N	Lincoln Acres	9	91950	E6100000010C5AB997FE9E5B4040B7DCB3A5DB455DC0	c303587d-6e91-44bd-912f-8898d190f2ad	2013-08-16 00:00:00
14356	2119 Little Dr	\N	Lemon Grove	9	91945	E6100000010CD2B7BD134A5E4040FBFD1F8500465DC0	356e50bd-9844-4dd6-b5d2-b6d79f12f561	2013-09-22 00:00:00
14357	4192 East 39th Street	\N	Geelong	77	3220	E6100000010C18E6448BA61643C0841DEC6213116240	a6f41259-e60d-47c1-8fad-8c519211fa56	2013-08-15 00:00:00
14358	9781 Bird Dr.	\N	West Sussex	14	RH15 9UD	E6100000010C00000000000000000000000000000000	ada48f2d-98d6-4cb9-94bf-ca7395bad628	2013-07-11 00:00:00
14359	1101, rue Lauriston	\N	Lynnwood	79	98036	E6100000010C6081C7F78EED474095292387158E5EC0	1c10fb26-4150-4a12-9af8-03c2df78b2f9	2014-01-12 00:00:00
14360	5473 Sunshine	\N	Lakewood	9	90712	E6100000010CC498FDCAE9F0404056D0432F95855DC0	254156eb-754c-45b7-b9f9-725cc601fd10	2013-05-23 00:00:00
14361	6715 North Park Court	\N	Haney	7	V2W 1W2	E6100000010C1FBF4BEC85904840A07080CAE0995EC0	8fd89352-77d9-4db4-a046-f08f72d5d5de	2011-10-18 00:00:00
14362	5785 Ygnacio Valley Road	\N	South Melbourne	77	3205	E6100000010C0BFC190EF6EE42C0E24F638181216240	bf7c1cc2-f8e3-4870-8a17-d1b937d63321	2014-04-23 00:00:00
14363	9919 MacArthur Avenue	\N	Coronado	9	92118	E6100000010C2F19525064564040EF88B0402C495DC0	876c18f5-0d89-4e59-93c2-c7874510a498	2013-05-22 00:00:00
14364	2844 Plymouth Drive	\N	Basingstoke Hants	14	RG24 8PL	E6100000010C4540297EE0A349408B3C0B91630EF1BF	73275951-f89a-4187-9813-4adf01e57237	2014-02-04 00:00:00
14365	1415 Edwards Ave	\N	Coronado	9	92118	E6100000010C9E84621B165D40407806F0076C545DC0	73b9f397-1b89-4329-84b2-e31b58437a7a	2012-07-11 00:00:00
14366	4873 St Francis St	\N	Langford	7	V9	E6100000010CE238E42D653E4840F01E1F488BDA5EC0	3a423e21-7b7f-489d-b221-90af6b3cbf92	2014-05-07 00:00:00
14367	9925 Wildberry Court	\N	St. Leonards	50	2065	E6100000010C6C8B76F314E440C0D0D1B2F7CFE36240	79a151f7-ca99-4859-a29d-674600fcc5f4	2013-07-30 00:00:00
14368	Heiderplatz 918	\N	Bottrop	53	46236	E6100000010CF74B3B13E8B9494011F5190600BA1B40	0410a6ea-1e2f-4c94-9bbf-4dba30de330e	2012-10-06 00:00:00
14369	3623 Bush Avenue	\N	Townsville	64	4810	E6100000010C156B74C8E03F33C00575E020A0546240	8ac46a2a-edbc-4226-b34a-dfd8fe79c5b3	2011-08-03 00:00:00
14370	5647 Larch Ct	\N	Torrance	9	90505	E6100000010C03CA2378AAE14040EDAC0BE814A15DC0	adeb5394-8b1c-49d4-b17b-1050f9cedac2	2014-02-12 00:00:00
14371	306 Spring Hill Drive	\N	Woodland Hills	9	91364	E6100000010C202629CF4819414065F2F062849C5DC0	873f5b8c-e6d9-4a2b-93bd-d6ab84af5dd8	2014-01-19 00:00:00
14372	5662 Leland Way	\N	Les Ulis	177	91940	E6100000010C20575233F95B4840EAB570278D550140	bd14c92e-7755-4ee3-bcdb-39b6de3f7517	2013-12-21 10:09:29.423
14373	6928 Jason Ct	\N	Marysville	79	98270	E6100000010C908797B5D20F4840D9BA94FDB88F5EC0	be4a59de-e83c-4847-a445-58e5cf4ca616	2014-03-17 00:00:00
14374	7776 Forsman Place	\N	North Ryde	50	2113	E6100000010CAEF175CAB5E340C00A19AD0ED4E16240	98974ec1-585a-471f-bad9-557ccc711cd7	2012-07-20 00:00:00
14375	1374 Queens Road	\N	Fremont	9	94536	E6100000010C3742CA1A02CD4240F368A22221855EC0	094fb84a-aae5-4037-aee4-1237e3dfcbde	2013-07-06 00:00:00
14376	8609 Camino Peral	\N	Watford	14	WA3	E6100000010C4634C7CC36CA494047B3D3FC45F8D8BF	c3f50305-f0d0-4d85-a865-1a8216b0939d	2013-09-04 00:00:00
14377	6541 Bonita Ave	\N	Langford	7	V9	E6100000010CDDA64C654B3B4840FA3685D513E05EC0	f46a441d-0bc8-47aa-b471-8e75454d58c7	2014-05-20 00:00:00
14378	6328 Eola	\N	Issaquah	79	98027	E6100000010C34F795F35ABB4740F73F30C840805EC0	43605d70-31c7-46c8-947d-1898e60f9792	2014-05-05 00:00:00
14379	5176 Conifer Court	\N	Matraville	50	2036	E6100000010C1A923BF68CF640C04DFF2F7C2BE56240	af32c8dd-76c7-4c84-8f6c-1ccc41c01782	2013-02-24 00:00:00
14380	9969 Coldwater Drive	\N	Bremerton	79	98312	E6100000010C35C4C98386C94740F2762C3AB6B55EC0	3255167f-cebc-4a5d-8857-bb99bd784eb2	2014-03-24 00:00:00
14381	9467 Morning Glory Dr	\N	Rockhampton	64	4700	E6100000010C6DFF32DAB06537C03D9DEB9D41CB6240	e0944190-d99b-400e-b21a-327658144832	2013-12-06 00:00:00
14382	4405 Grant Street	\N	Salem	58	97301	E6100000010C4F010BAFBF784640CCA97BFBD1B75EC0	76e83211-7a5d-4e4e-b72b-6c41470905fd	2014-04-16 00:00:00
14383	4446 Walnut Lane	\N	Palo Alto	9	94303	E6100000010CF89DEC590DC042405A979C5310895EC0	2e1dceb9-a619-4340-86b2-c169b1ce14c5	2013-09-19 00:00:00
14384	5616 Steele Dr.	\N	Brisbane	64	4000	E6100000010C328C876FBB783BC05FE7A702CF1B6340	4d4f2f1f-cdbc-49b5-ad41-456ba95038e0	2012-04-02 00:00:00
14385	8, rue Lafayette	\N	Paris	161	75010	E6100000010CA71A15EC2470484067753264BDE50240	3590f55c-02d5-4a08-8008-5ae0c2c1114f	2013-12-21 10:09:29.423
14386	1315 Union St	\N	Brisbane	64	4000	E6100000010C4DD4372F1A7F3BC0E643F9EC5E1C6340	23245ad7-9c06-495d-92af-4373d829a1ce	2014-04-27 00:00:00
14387	5433 Park Glenn	\N	Victoria	7	V8V	E6100000010CC6DADEC2F73448402248633E97D25EC0	82d25144-f363-445b-9065-c555a3f3d5d7	2013-10-30 00:00:00
14388	827 Near Dr.	\N	Burbank	9	91502	E6100000010C3BB856B76513414000E8830318965DC0	45ecd26f-28e6-4fc9-9ddf-242b89507d9b	2011-11-09 00:00:00
14389	Carlsplatz 90	\N	Darmstadt	19	64283	E6100000010C1E254DE4AAE9484095B6B9948B472140	33852ef2-fe31-468c-90d3-768ec4dcc2d5	2013-03-12 00:00:00
14390	6045 Holiday Hills Dr.	\N	Perth	66	6006	E6100000010C75C440B167EB3FC057F855804CEC5C40	3c415448-8565-4c35-a18b-eeedf8d3a38e	2012-08-01 00:00:00
14391	6969 Eaker Way	\N	Oakland	9	94611	E6100000010CFABD48A301E84240C69EDCEC5F8E5EC0	83eb5096-b0b5-4ad0-ac2a-f4fc7b15bd06	2014-05-26 00:00:00
14392	1669 Warwick Dr	\N	West Covina	9	91791	E6100000010C83D88488D00B41401A6A013835825DC0	4c1c7dd9-e419-4a48-8a51-d5c2e78af692	2014-04-14 00:00:00
14393	68, avenue de l´ Union Centrale	\N	Croix	145	59170	E6100000010CF48C68DBF95F4940FF8841072F340940	186aa281-34e7-47f1-97ff-c9a71c7b6383	2013-12-21 10:09:29.423
14394	7783 Limewood Pl	\N	Bremerton	79	98312	E6100000010C0122B878E1D3474011CD98F9A3AE5EC0	0dcadf1e-e213-4047-9123-03901da7db8e	2013-10-21 00:00:00
14395	7165 Foothill Way	\N	East Brisbane	64	4169	E6100000010C9B57E4249A743BC0AEDE8E11D1216340	c6512c62-a24e-49e9-a983-8ff6b1d05bc0	2013-02-16 00:00:00
14396	9532 Clay Rd	\N	Lincoln Acres	9	91950	E6100000010CAE8A1381E94F40400793751E9C435DC0	faa9d27d-e9df-40a1-a93b-acfbecdf5642	2012-09-06 00:00:00
14397	5901 Buckthorn Court	\N	Beaverton	58	97005	E6100000010C337183C88AB846401934038B34BB5EC0	29cfdb4e-a33e-47ce-98e3-00aa9ae464ff	2014-05-08 00:00:00
14398	36, rue de Cambrai	\N	Paris	161	75009	E6100000010CF38F29A16D7648409B5A295BB1130340	5a16cc63-3fbf-4aad-8b0c-42279eed4079	2013-12-21 10:09:29.423
14399	561 Lewis Way	\N	Sooke	7	V0	E6100000010C6F7594D8EF2B484074C12FB581E45EC0	abc642bc-f1fc-4445-8c2f-8f79ad125f83	2012-08-22 00:00:00
14400	7182 Benedict Ct	\N	Imperial Beach	9	91932	E6100000010C5CC28B46AB4A4040769FAEEA153D5DC0	e0682c9b-2094-4a9f-9b4a-b1889b3b141d	2011-06-15 00:00:00
14401	4685 York Dr	\N	Burien	79	98168	E6100000010C99E6C7EF8ED847406E7457F85F9B5EC0	b4023d32-6e0a-45b3-8ff3-c5b945421872	2014-03-12 00:00:00
14402	568, avenue de l´ Union Centrale	\N	Paris	161	75009	E6100000010CB29379698576484080D3196A34B00240	2d53a7fc-8017-412d-a591-b10bac54f9b7	2013-12-21 10:09:29.423
14403	86 Sierra Ridge	\N	Cranbourne	77	3977	E6100000010CEF42A241A41343C0FA30996B60256240	fb7c858a-92b5-4a62-bae9-651975287775	2013-03-05 00:00:00
14404	2096 Blackwood Drive	\N	Melton	77	3337	E6100000010C5262A0C450D442C0EE97DCDE0F176240	ff9c776a-31c9-4c90-90e4-559b1c72be05	2011-07-03 00:00:00
14405	6542 Stonewood Drive	\N	Cliffside	7	V8Y 1L1	E6100000010C0FA19C73773F4840ED377FDB97CC5EC0	5f3b9452-0ea1-4bd0-9a56-dd8e699e5813	2013-09-30 00:00:00
14406	8526 El Mundo Dr.	\N	Beverly Hills	9	90210	E6100000010C747208A1A40E4140725959672D9C5DC0	39ac9e1d-8b61-4b2b-a08f-44aea6ba3bc6	2014-05-13 00:00:00
14407	3504 Tossing Way	\N	Billericay	14	CM11	E6100000010C90C690765DC949409A9C83040AB8DA3F	6af21b5e-1133-4bae-b655-75d924ca1231	2012-09-20 00:00:00
14408	1629 Green View Court	\N	Burien	79	98168	E6100000010C27789C405EDB4740CBA5C189398D5EC0	5da8487f-c6ce-4dfe-bd03-d1edfc11bb03	2012-01-31 00:00:00
14409	8128 Kane Circle	\N	Bountiful	74	84010	E6100000010CA801174F94724440075FF0F528FA5BC0	44c19cae-40e2-448e-b7b5-c095f46a0596	2011-11-19 00:00:00
14410	3354 Change Circle	\N	Vancouver	7	V7L 4J4	E6100000010C23D6FBDC209F48406F1946056CCA5EC0	9283c69a-e698-4c3c-a7de-c318e45a8efc	2013-12-06 00:00:00
14411	3140 Gingham Way	\N	West Covina	9	91791	E6100000010C5DC486476E0E41404497DCA1DA705DC0	5bf2c993-6b87-4ff3-9559-1a8636963b84	2013-08-21 00:00:00
14412	2264 Story Lane	\N	Springwood	50	2777	E6100000010CAFFAE5F405DB40C0AE65EA7099D46240	18e91157-375f-4856-a794-0bcb13b6dacf	2011-09-28 00:00:00
14413	8561 Hilltop Road	\N	Bellingham	79	98225	E6100000010C86889E045D6948404432CA7B4B9F5EC0	56ad6324-c2c3-4bda-b773-718127944953	2013-10-30 00:00:00
14414	1258 Yarrow Dr	\N	Wollongong	50	2500	E6100000010CF4A43A7D043A41C0D5D51BA645DD6240	6de302d0-7788-4e60-afee-eebe449cd1f2	2013-03-28 00:00:00
14415	54, boulevard Tremblay	\N	Dunkerque	145	59140	E6100000010C90963A604F7C4940661AC5AF87CF0240	b289f2ac-3425-4fae-b866-c76d6c57c448	2013-12-21 10:09:29.423
14416	2540 Waterview Place	\N	Chula Vista	9	91910	E6100000010CC5D7F4083A544040F7FF1D5B5B4C5DC0	517f38fe-4de7-4a9a-93d3-25c834938fc1	2013-02-10 00:00:00
14417	2901 Ninth Avenue SW Court	\N	Maidenhead	14	SL67RJ	E6100000010C897DCC6751C7494014F3E42C5185E7BF	62b1ca86-71f7-4479-a712-3c5ae3ec02cc	2014-04-30 00:00:00
14418	6985 Countrywood Ct	\N	Renton	79	98055	E6100000010CE81997F2FEB24740136127EA378F5EC0	c65d7b3f-3572-42a0-a4ab-f2e67ebf9fb1	2014-01-24 00:00:00
14419	8480 Zebra Street	\N	Renton	79	98055	E6100000010CB7B968FAEDBD474090A2BD57D5855EC0	6603965d-73c5-46b7-a51a-4d7606c8365d	2012-04-23 00:00:00
14420	8170 Money Dr.	\N	Chula Vista	9	91910	E6100000010CAD15007D77504040E881161AE1385DC0	c7f1f356-d6e3-41d3-8317-38b62ebd6c09	2012-07-13 00:00:00
14421	1939 Meadow Glen Way	\N	West Covina	9	91791	E6100000010CBF75DB078F0D41404497DCA1DA705DC0	b5a19395-4827-4b03-81be-d8053a575bb8	2014-05-10 00:00:00
14422	6344 Dartmouth Way	\N	Portland	58	97205	E6100000010C0712F413EEC74640A993D388BCAC5EC0	e5848c7c-6dac-4c86-931e-b6d06d9aadd9	2014-06-16 00:00:00
14423	8354 Sugar Valley Blv.	\N	Sydney	50	1002	E6100000010CD89D0AA8C9E940C0B63584FA4DE16240	0875c0e5-486d-47bb-8dc1-c08fe2d044ad	2012-10-09 00:00:00
14424	2713 Chinquapin Court	\N	Sedro Woolley	79	98284	E6100000010C64CD103F0F3C48400121B592D08C5EC0	3e1b214c-e99b-4376-9c51-1688a209cf75	2014-02-24 00:00:00
14425	9824 San Rafael	\N	Melton	77	3337	E6100000010C6BF7BA00F2D042C0C74ED07C82116240	399033f0-09c8-485d-8d25-4af667497a26	2013-03-16 00:00:00
14426	5642 La Orinda Pl	\N	Darlinghurst	50	2010	E6100000010C4F2ADE6819EC40C013271D659EED6240	840aad39-b8dc-4f45-bf86-617a56ae21af	2013-10-18 00:00:00
14427	4716 Cougar Way	\N	Olympia	79	98501	E6100000010CA2F64F93E380474060A2BDC89EC05EC0	8840db5a-6729-421e-925c-3170d051c516	2013-10-15 00:00:00
14428	Residenz Straße 431	\N	Hamburg	20	20354	E6100000010C8929030DE0C64A40D7AE5869FAFF2340	1491967b-ce1c-4c06-bb55-1d1445eff698	2014-04-29 00:00:00
14429	331, boulevard Tremblay	\N	Paris La Defense	178	92081	E6100000010C00000000000000000000000000000000	4f9fe04c-2e1c-4456-bf70-67fe658c893e	2013-12-21 10:09:29.423
14430	2553 RaceCourt	\N	Silverwater	50	2264	E6100000010C78BA85254A9140C04F2EA7A0F8F06240	af656a23-349d-487c-bae1-9eee54c34369	2013-09-11 00:00:00
14431	8908 The Trees Drive	\N	Mill Valley	9	94941	E6100000010CA5A7193CE6F042409E713CA24EA15EC0	6e3763ba-44cc-42ca-a46f-088c9143da52	2013-12-24 00:00:00
14432	7522 Santa Ana Drive	\N	Gloucestershire	14	GL7 1RY	E6100000010C78D5528179DA49402D669B1DC190FFBF	47d74d48-65ab-42f8-b554-c82d0f194ae2	2014-02-17 00:00:00
14433	5784 Holiday Hill Dr	\N	Issaquah	79	98027	E6100000010C3C6BE05584C74740AF6DCB3C9F895EC0	bbd7d536-2517-4e64-8e9d-3875c28c000a	2013-07-24 00:00:00
14434	3608 Sinclair Avenue	\N	Sunbury	77	3429	E6100000010C59EC80D657C242C013B6FDFDA8186240	88d82ae7-31a4-429f-ac42-dade88f306e2	2011-09-03 00:00:00
14435	3567 Sierra Street	\N	Melton	77	3337	E6100000010C740F47FC17CD42C0A5855986AC156240	95b44452-e17b-45ac-9bfd-b5814fba4205	2013-03-07 00:00:00
14436	3394 Rock Drive	\N	Coronado	9	92118	E6100000010CEFF02BA4E1534040175F9B536C455DC0	38f85789-42bc-4071-82bd-d25303e7623d	2014-03-04 00:00:00
14437	1472 South Creek Drive	\N	Lincoln Acres	9	91950	E6100000010C4D2FF5168354404080B96E3B9A4C5DC0	b0c274e4-e91d-41e1-aae3-59c361eb7532	2012-06-08 00:00:00
14438	Attaché de Presse	\N	Roubaix	145	59100	E6100000010CA13F99D91A584940FD32A808B0700940	e5d2df23-4cc4-4110-89e0-79a78a9fbc8e	2013-12-21 10:09:29.423
14439	3004 Zulu Court	\N	Colma	9	94014	E6100000010C0A39C0969ADD4240143DFD2226985EC0	43296e7c-452b-4714-9fd4-d6c4039fa227	2013-11-05 00:00:00
14440	2499 Greendell Pl	\N	Renton	79	98055	E6100000010C151F1B791BBC474067373633F6885EC0	e8801aab-7575-4c40-bba1-8ee72ea945ba	2012-09-01 00:00:00
14441	2794 N. Civic Drive	\N	Glendale	9	91203	E6100000010C29062493DD1441408C8FC55207945DC0	2d04b81d-9618-46d1-8acf-0ef15129f3aa	2014-01-16 00:00:00
14442	454, boulevard Tremblay	\N	Paris	161	75007	E6100000010C6E951C54D66448408C340D2A44820240	7fdbd417-442b-42c9-8024-f4786ea0b0ad	2013-12-21 10:09:29.423
14443	4035 Red Maple Ct	\N	York	14	YO15	E6100000010CF0BD756831F54A401D6F91571951F1BF	33dfa0a8-ebaa-42fa-b911-684bda851a7e	2013-06-06 00:00:00
14444	7239 Nicholas Drive	\N	Victoria	7	V8V	E6100000010CF9B8F447ED3948404FF8901FCDD15EC0	71cb313f-05dc-4e2b-ab07-5bb48571fdab	2013-07-10 00:00:00
14445	8734 Oxford Place	\N	Vancouver	7	V7L 4J4	E6100000010C963F41EF46AE48404876E7E925CF5EC0	6b84db23-22d3-4c00-bc29-ea29d5b613a9	2013-07-01 00:00:00
14446	4849 C Olivera Rd	\N	Royal Oak	7	V8X	E6100000010C3EC86F47CC414840A8FE3A217FD15EC0	3e20d84b-33a1-4d2a-9649-bfc84b21fdbe	2014-03-04 00:00:00
14447	6598 Oak Street	\N	Bremerton	79	98312	E6100000010C4ACE49BEABCE47403A241E9579B35EC0	adae0bfd-f3ba-433d-a9d3-7242b300f360	2013-09-04 00:00:00
14448	2967 St. George Dr	\N	Glendale	9	91203	E6100000010CFA0EA40B7D1741403DF1148767865DC0	0e11497c-ec92-4d26-8239-ba9fa78617c1	2014-03-29 00:00:00
14449	906 Cloudview Dr	\N	Newport Beach	9	92625	E6100000010C103E782883C640404A0D368E346C5DC0	37ca0084-0d51-4a61-b2e7-158a20777817	2014-05-26 00:00:00
14450	9351 W Lake Drive	\N	South Melbourne	77	3205	E6100000010C20A4BA4292EB42C075210EC10A216240	beaee7a0-3d50-4c75-96fb-f47107886530	2013-02-04 00:00:00
14451	369, rue de Bas Marin	\N	Paris	161	75003	E6100000010C7AF39656E975484092460B55A5E50240	c42b9bd6-d73d-4d88-9b4c-cab0a13a150e	2013-12-21 10:09:29.423
14452	7527 Brook Way	\N	Sedro Woolley	79	98284	E6100000010CB5D67160A54148402FE9DB0A59875EC0	1c387c67-511f-4135-a429-d6ae5e2d2eda	2012-11-24 00:00:00
14453	2441 Talbart St.	\N	Long Beach	9	90802	E6100000010C8A9C51B292DE4040CB1228CAE38F5DC0	df301449-8766-46a9-b249-30554da20ef3	2014-01-11 00:00:00
14454	3033 F St.	\N	Hervey Bay	64	4655	E6100000010CB4CC98459E5339C051A6E9BEA1136340	c6c49336-5ae2-4566-a53b-da5dc4fab6a8	2014-03-18 00:00:00
14455	7348 Quail Court	\N	Geelong	77	3220	E6100000010C84A36B792F1543C080B53425C40E6240	2d11114e-2a98-4559-8802-5de673dfbf59	2013-11-22 00:00:00
14456	1974 Heritage Oaks	\N	Colma	9	94014	E6100000010C9BAF7FCCB5DA42408638776572935EC0	654f4d90-7572-44ad-9985-25e04e917ca5	2014-05-05 00:00:00
14457	6927 Ricardo Drive	\N	Seattle	79	98104	E6100000010C795547EFB3C44740899A4C1D629B5EC0	f7eb5177-3e8e-4242-abf7-862c1dd15119	2014-04-29 00:00:00
14458	5004 Santa Rita Dr	\N	Issaquah	79	98027	E6100000010CAEFCD15757C94740A390B17E0F885EC0	567fc33f-7953-46f6-9318-5586893e8e33	2013-07-09 00:00:00
14459	Hansaallee 6	\N	Hannover	53	30601	E6100000010C00000000000000000000000000000000	080f391b-39fc-48cf-aff4-457e541554d3	2013-12-18 00:00:00
14460	9605 Pheasant Circle	\N	Findon	66	5023	E6100000010C1169DC02956D41C0DBB6B333804E6140	fdf7ffd6-61bd-4d16-a97a-a7674a86a407	2013-07-02 00:00:00
14461	5281 Miller Avenue	\N	North Ryde	50	2113	E6100000010C944140891DE140C0C6EDD93F58E16240	8bc50016-598b-44ab-bcd1-2fe651a78ea3	2014-05-18 00:00:00
14462	Alderstr 2984	\N	Kassel	19	34117	E6100000010CA3F0DB6D28A749402316BECFA6FE2240	afa6e765-65cc-450a-8f70-027befa59614	2014-01-01 00:00:00
14463	8982 Mt. Etna	\N	Lake Oswego	58	97034	E6100000010CD5B2949DABB146400B6323679BB65EC0	628e7604-023e-4603-bde3-9469bad93afe	2013-08-03 00:00:00
14464	33, rue du Puits Dixme	\N	Paris	161	75009	E6100000010C6A617FAFE26B48405AEAB322A4B10240	552e1dec-52f6-435e-800a-7b16ec19cdae	2013-12-21 10:09:29.423
14465	3406 Raven Court	\N	Leeds	14	LE18	E6100000010C57CAAEB322E94A40FF749A2CA1C5F8BF	cb783216-0981-4868-a22f-f9ec1bd7e40e	2013-12-11 00:00:00
14466	7568 Precipice Court	\N	Townsville	64	4810	E6100000010C6C377992FC3833C0558E0193235C6240	c2757b72-3a11-4eb8-889e-25c76933f16b	2013-02-05 00:00:00
14467	5723 C Wharton Way	\N	Oxford	14	OX1	E6100000010C0BCF375428DE49408ABDAC1B8629F4BF	c219635a-fa98-4392-90e3-0e93c0096f43	2011-10-13 00:00:00
14468	5415 Beechwood Dr.	\N	Burien	79	98168	E6100000010CEFA5CB6780BA4740C892A71869985EC0	ff405e7f-23c7-4167-9088-31f51e506535	2013-07-19 00:00:00
14469	773 Mt. Wilson Place	\N	Spokane	79	99202	E6100000010CAB81546FEED74740CDFB19B6BE4D5DC0	fbe993cd-37af-4c50-9a55-47d65dc23b12	2013-10-15 00:00:00
14470	4058 First Ave	\N	Cliffside	7	V8Y 1L1	E6100000010C0E192D89E03948405FE5C06D62DC5EC0	9d021864-2a76-4789-a627-9edfd09f99dd	2013-09-23 00:00:00
14471	2268 Cobblestone Ct	\N	Downey	9	90241	E6100000010C5FB7BDF7E2F240408485D7C3848B5DC0	5d4a9f7d-5463-46f4-b4c3-f55f9b995995	2014-01-04 00:00:00
14472	Knaackstr 956	\N	Dresden	19	01071	E6100000010C00000000000000000000000000000000	be05845f-dc35-44b8-8f83-66b640a7ba8b	2013-03-10 00:00:00
14473	8382 Cinnabar St	\N	Renton	79	98055	E6100000010C44B610F6DAB7474019A7D0D74E8B5EC0	2408ff32-bb85-41b9-9dbb-3285d9b902da	2013-12-17 00:00:00
14474	132 North Park Court	\N	San Diego	9	92102	E6100000010CB4F56953DC5F40403AB31B857D515DC0	641d2eeb-2d74-4646-82f8-7b7e2723015f	2013-09-25 00:00:00
14475	6500 South Street	\N	Milwaukie	58	97222	E6100000010CECC665EDA2B746404302E5A04DA35EC0	4a28fe34-ea23-4b91-81da-d119f3fbbf27	2014-03-04 00:00:00
14476	338, rue Faubourg St Antoine	\N	Paris	161	75019	E6100000010C7CA292653A674840B50A11F7D90D0340	411dae68-5914-46c2-a1af-350e660cdbcd	2013-12-21 10:09:29.423
14477	1160 Via Del Sol	\N	Oak Bay	7	V8P	E6100000010C771335D3A231484075C62131D8CA5EC0	49b813f3-bf19-4e02-970d-32f55d77b33f	2013-11-09 00:00:00
14478	Nollendorfplatz 5228	\N	Hamburg	20	20354	E6100000010CFDF306904DCA4A4021E2804F47F72340	33364635-3084-436b-a4e5-eb83b83a43ae	2014-03-25 00:00:00
14479	7781 Santa Barbara Rd	\N	Lemon Grove	9	91945	E6100000010CD8F5EF5C195A4040A2267446BE4C5DC0	1d796fa0-2ba6-4f91-a8ed-55369625458e	2013-09-20 00:00:00
14480	Lieblingsweg 4	\N	Saarlouis	70	66740	E6100000010C909EAF9E2CA248403E574BB13CFD1A40	f800403c-1b72-4a23-95da-d37e9ad553e4	2013-12-26 00:00:00
14481	5351 Maryland Drive	\N	Walla Walla	79	99362	E6100000010C0C9754628D134740407A85AC2B9C5DC0	9eabca06-2c2e-4e7a-b259-96f99a18e8df	2013-07-04 00:00:00
14482	2228 Ashford Court	\N	Lebanon	58	97355	E6100000010C09FBD0929A434640A7D206E074BC5EC0	0510b414-1c26-42d5-8a25-5e6bec52cf7a	2013-10-18 00:00:00
14483	5446 Via Estrella	\N	Cliffside	7	V8Y 1L1	E6100000010C549E76548A4748400C0DF8957DE35EC0	0f229b6c-6e0a-4add-a492-85039996ee58	2014-03-12 00:00:00
14484	51 LaCrosse Ave	\N	Los Angeles	9	90012	E6100000010C4F982B65D7044140A48ABEAF288F5DC0	abc0d566-7c84-45d9-988b-50124f22d09d	2013-06-27 00:00:00
14485	9836 Hanson Lane	\N	Downey	9	90241	E6100000010CB12D2182EDF54040A17E7415EF805DC0	8a134d98-2d77-4bdd-8b06-19e5e147cd0b	2014-05-30 00:00:00
14486	1828 Mt. Orange Place	\N	London	14	SW8 4BG	E6100000010C07940A7A6CC04940065FDE000DBDC2BF	40797003-f92e-40b3-ba0a-5841c6e595f9	2011-10-20 00:00:00
14487	7914 Woodpine	\N	Langford	7	V9	E6100000010CC2AEAD50DA33484027C11018CDD55EC0	d14058b3-0878-4467-9df6-162d3220d35a	2013-06-30 00:00:00
14488	2141 Banking Road	\N	Bellflower	9	90706	E6100000010C990F2E2875F2404072E027CCD78E5DC0	98e5723a-f006-4814-a18a-5caa6d2b5bd3	2013-11-01 00:00:00
14489	2243 W St.	\N	Seaford	77	3198	E6100000010C94945854290F43C05D69365FBD216240	ec633931-37a3-48fc-8453-c45ecfcc0bea	2011-06-17 00:00:00
14490	7954 Vista Avenue	\N	Lemon Grove	9	91945	E6100000010CCBC1B5E1525D4040226E4A7E264D5DC0	e2efcd32-6b53-4143-8e3a-49130b1a24cc	2013-07-21 00:00:00
14491	8294 El Rancho Drive	\N	North Ryde	50	2113	E6100000010C67E4FE7F24E440C0D5734685B2E56240	612dc095-a4aa-4b54-9b89-64ab7ad2da06	2012-11-13 00:00:00
14492	Lützowplatz 28	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	a4978449-cc50-4eba-ad64-b3dd68b1db77	2013-06-10 00:00:00
14493	6286 Ronda Ct	\N	Torrance	9	90505	E6100000010C943F7FEBB1E44040E4F748A7059B5DC0	d38f0340-573c-406d-beb8-89b0b0b2f058	2013-07-18 00:00:00
14494	9236 Woodland Drive	\N	Mill Valley	9	94941	E6100000010CC8801E9834F74240BA348DE612AD5EC0	029e87c4-799f-4778-9c77-d5e612f12974	2013-10-20 00:00:00
14495	66, rue des Pyrenees	\N	Orleans	131	45000	E6100000010CF41B055BECF047409659D6F06888FE3F	a6657dd8-301c-475e-9d5c-d59d3395282a	2013-12-21 10:09:29.423
14496	478 Grant St	\N	Burien	79	98168	E6100000010CBEBDB81012B84740B172F68DAB8C5EC0	b7113faa-a5a0-4c4e-adf6-80961e4ecb9b	2013-10-27 00:00:00
14497	2877 Bounty Way	\N	York	14	Y024 1GF	E6100000010C5BA270061FF34A40DF4184C28759F1BF	2a2ba539-23f3-4b91-92d8-e81886d2bf95	2012-06-29 00:00:00
14498	3682 Diablo View Road	\N	Port Hammond	7	V6B 3P7	E6100000010C903BCA7056AC4840DA088CDF72BE5EC0	ad250433-93f0-4dbb-bc35-61060feaedd4	2013-07-23 00:00:00
14499	344, rue Descartes	\N	Port Hammond	7	V6B 3P7	E6100000010C5A8A498713AB4840FB1ABD80DFBC5EC0	96f43cf1-db83-4455-b196-61151502c25d	2013-10-13 00:00:00
14500	2128 Evelyn Court	\N	London	14	SW6 SBY	E6100000010C957F5C7444C749409D349FBC249BB6BF	b9a4a6b3-6b80-4c98-b423-252caca637ba	2012-11-04 00:00:00
14501	2538 Stafford Ave	\N	Tacoma	79	98403	E6100000010C313C8B89B5994740D143B78806935EC0	762a9976-5ba1-4fa1-b1ad-55b360674b7f	2013-07-30 00:00:00
14502	Galeriestr 28	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	9e5cba6a-3c97-4d2f-956d-3f1072d96b47	2014-05-09 00:00:00
14503	6943 Patterson Blvd.	\N	Beverly Hills	9	90210	E6100000010C1FFE9472D3104140600E8D9145A55DC0	22c29ac4-9ca5-47d0-ad54-0742df8b48ab	2012-01-28 00:00:00
14504	1773 Lafayette Street	\N	Gloucestershire	14	GL7 1RY	E6100000010C001375412AD7494099EBF385E98BFFBF	31125dda-e01a-4ff7-8a2d-88bca94e0ab8	2013-07-08 00:00:00
14505	3312 Tanager Court	\N	Metchosin	7	V9	E6100000010C6208D3D3F9314840A58F8BD826D75EC0	b03b51ea-bb5a-479d-9f2d-170c906c927d	2013-07-13 00:00:00
14506	5315 Wildewood Dr	\N	Rockhampton	64	4700	E6100000010C37C71A25496937C0135DE06784D16240	dfe902b5-f2a1-4d3a-8f5e-bd3cdf6d5140	2013-09-22 00:00:00
14507	4594 Springer Court	\N	Portland	58	97205	E6100000010C8DFCB83D83C846405C6970792AAB5EC0	cbabec7d-6702-4ef5-ab41-e3bfc175c1ef	2014-02-12 00:00:00
14508	Postfach 66 07 00	\N	Paderborn	20	33041	E6100000010C00000000000000000000000000000000	8fa6df01-d336-4855-9381-297602fc38a1	2013-01-02 00:00:00
14509	9507 MountainAire Drive	\N	Redmond	79	98052	E6100000010C4263FA4502D04740D7CE57D0F4905EC0	280801b1-d95d-42bc-a789-a74ecaac44bf	2013-07-11 00:00:00
14510	9039 Blocking Ct.	\N	Grossmont	9	91941	E6100000010C8A9D7D2B0D6740400915BA1908415DC0	33519a5a-f671-4c87-a78e-efea3a12540d	2013-01-25 00:00:00
14511	1292 Marsh Elder	\N	Concord	9	94519	E6100000010C4C6AA72A1AFC4240C94EFE9714795EC0	7190267d-8417-4dca-a13b-5171aa9eeae1	2012-06-05 00:00:00
14512	4207 Madrid Lane	\N	Lakewood	9	90712	E6100000010CDCFCFB9003ED404047B7D6E36F925DC0	e8a3b63a-124d-4b8f-8d8b-adae8859d850	2014-06-15 00:00:00
14513	4581 Coldwater Drive	\N	Rockhampton	64	4700	E6100000010C2E13EC86E26937C001F14E53C6CA6240	c111e2fb-3e5e-4172-9576-8f9ada7a0cfa	2014-03-17 00:00:00
14514	3993 Jabber Place	\N	Los Angeles	9	90012	E6100000010CFFD437BEFF0D4140B47112E1B9965DC0	f3018051-2817-4fca-a370-d83d1796cca9	2013-03-14 00:00:00
14515	2071 LindenTree Dr	\N	Vancouver	7	V7L 4J4	E6100000010C963F41EF46AE4840892939888BC25EC0	67a47f61-3b61-495e-be4f-d5c9542378eb	2014-02-10 00:00:00
14516	2, avenue de Norvege	\N	Sèvres	178	92310	E6100000010C19B652FAB25F4840763003E1F7B20140	382cd9bf-348b-465a-95c1-34aef3efa7a0	2013-12-21 10:09:29.423
14517	1500 Polk Street	\N	Silverwater	50	2264	E6100000010C3554F33D1B9540C04552A23210EE6240	2d90a00d-6097-4898-8639-2f089ede3da1	2014-06-29 00:00:00
14518	2111 Ringing Dr	\N	Cliffside	7	V8Y 1L1	E6100000010C549E76548A4748409B8895BACDCB5EC0	06bb0cf1-2ea0-4a57-b43a-4a1a740db77f	2013-08-18 00:00:00
14519	2067 Black Point Pl	\N	Perth	66	6006	E6100000010C708E71F138EC3FC057F855804CEC5C40	387a8b8c-cf33-483d-b5d4-9c02500d32e0	2014-03-13 00:00:00
14520	8139 Clark Creek Lane	\N	Paris	161	75003	E6100000010CE4BE0F1567694840E39E21F390D90240	0554d33a-b54f-4bba-8a9b-b9200e319509	2013-12-21 10:09:29.423
14521	4195 May Way	\N	Hawthorne	64	4171	E6100000010CEE0E00412D6B3BC0A12C9FC29E1F6340	a25f21e4-a02f-478f-bcb4-af881343009a	2012-12-19 00:00:00
14522	3098 Seabourne Ct	\N	Oregon City	58	97045	E6100000010CEDE58D62C6B1464033FC432EC5AC5EC0	1e28c998-62a2-4434-b589-4c3d9746a3c8	2014-06-04 00:00:00
14523	3393 Alpha Way	\N	Santa Monica	9	90401	E6100000010C6D64D1E982FF4040DA4C03358F965DC0	92f7d2f2-00fb-4417-972d-8742dade4972	2014-05-07 00:00:00
14524	4634 Hilltop Rd	\N	Torrance	9	90505	E6100000010C7235E5B6EAEC4040A59DE706FE975DC0	7ad133e3-b74d-4e5f-8fb6-a40c4646b4a8	2013-08-20 00:00:00
14525	Welt Platz 1	Verkaufsabteilung	Frankfurt	19	60323	E6100000010CDAE61415D7084940FCFC56F1F2572140	c2a5d8c2-e8e5-4199-95d4-09db1e26a7b9	2014-01-15 00:00:00
14526	7838 Euclid Ave.	\N	San Francisco	9	94109	E6100000010CBEF4CE5039E742400195541459A85EC0	e10c765d-ca9d-4ccf-91a4-8d390fbb3c85	2013-09-09 00:00:00
14527	9333 Georgia Street	\N	Bendigo	77	3550	E6100000010CF189BF029C6642C048FE9388AD0B6240	835cb684-2695-44ff-a901-8bffafb057cd	2013-11-19 00:00:00
14528	5448 Near Drive	\N	Newton	7	V2M1P1	E6100000010C37F23F924BF94A40F8CBF426D5A85EC0	91e1bedb-b1d9-42f0-9c09-ec61b0b2b4bc	2013-07-14 00:00:00
14529	7197 Fox Way	\N	Royal Oak	7	V8X	E6100000010CD1666F978E40484057510AA964D95EC0	78d14326-c2f6-45ea-a1f4-efb1fb5afc22	2013-11-22 00:00:00
14530	3566 Matterhorn Ct	\N	Bellingham	79	98225	E6100000010C3B86C8E5DF614840F08FD3A8289C5EC0	830beaad-9383-4f50-ae46-eb393a993f30	2012-12-16 00:00:00
14531	8225 Northridge Road	\N	Edmonds	79	98020	E6100000010CA2F03A1E42E84740C9C4D83820905EC0	0aeb54fe-3c51-4228-949d-29af96b627fd	2011-10-12 00:00:00
14532	4848 Lighthouse Way	\N	Metchosin	7	V9	E6100000010C5C3BB2594E294840ABCC9BD60EDF5EC0	49a1e754-ee29-4659-b13e-a0e39b3bf1ff	2013-11-04 00:00:00
14533	Winterfeldtstr 2529	\N	Hamburg	19	22001	E6100000010C00000000000000000000000000000000	2a788130-b197-4f31-86b5-29a5cdf05e13	2014-01-29 00:00:00
14534	1736 Windsor Drive	\N	Caloundra	64	4551	E6100000010C123ED8AED7CE3AC003F1F49E961C6340	50b16760-f908-4262-b10d-de9c637812e8	2012-06-27 00:00:00
14535	9761 Darnett Circle	\N	Lebanon	58	97355	E6100000010C7226AB38274C464078691F5662B55EC0	30b588c1-54ab-4ad8-9fcc-cb34b0f1f517	2014-05-28 00:00:00
14536	9293 Liszt Way	\N	Lakewood	9	90712	E6100000010C81C6FDB458F1404062926AC156865DC0	a1ddb3d7-cdce-44e1-abf6-3e7ec45b0606	2013-10-07 00:00:00
14537	4461 Centennial Way	\N	Newton	7	V2M1P1	E6100000010