      &langchain_community.docstore.in_memoryInMemoryDocstore)}_dict}($b74a924c-c79b-4296-8f18-9135bf22b3e0langchain_core.documents.baseDocument)}(__dict__}(page_content# Code Execution

>💡We have set the `container` mode as default for code execution, especially when the usage of the agent
is open to untrusted users. Refer to [Docker Security](https://docs.docker.com/engine/security/) for better understandingmetadata}(source title# Code Executionchunk_idK utypeh	u__fields_set__(hh__private_attribute_values__}
_lc_kwargs}(hhhhusub$283b3f5c-8668-4927-8343-655d393b8ba5h
)}(h
}(hof the security features of Docker. To opt for the `local` mode, you need to explicitly set the `execution_service.kernel_mode` 
parameter in the `taskweaver_config.json` file to `local`.
h}(hhhhhKuhh	uh(hhh}h}(hh#hh$usub$ea6aee9c-7af1-489e-af2d-ea8d4eb2eb26h
)}(h
}(hXA  TaskWeaver is a code-first agent framework, which means that it always converts the user request into code 
and executes the code to generate the response. In our current implementation, we use a Jupyter Kernel
to execute the code. We choose Jupyter Kernel because it is a well-established tool for interactive computing,h}(hhhhhKuhh	uh(hhh}h}(hh,hh-usub$aef42461-03bd-444f-a5c8-add3c461e594h
)}(h
}(hX  and it supports many programming languages.

## Two Modes of Code Execution

TaskWeaver supports two modes of code execution: `local` and `container`. 
The `container` mode is the default mode. The key difference between the two modes is that the `container` modeh}(hhhhhKuhh	uh(hhh}h}(hh5hh6usub$cbd56393-fc31-4640-9f2b-1b0175167845h
)}(h
}(hX  executes the code inside a Docker container, which provides a more secure environment for code execution, while
the `local` mode executes the code as a subprocess of the TaskWeaver process.
As a result, in the `local` mode, if the user has malicious intent, the user could potentiallyh}(hhhhhKuhh	uh(hhh}h}(hh>hh?usub$5d0ae055-ebaf-4db8-8828-89f9d67eb251h
)}(h
}(hX5  instruct TaskWeaver to execute harmful code on the host machine. In addition, the LLM could also generate
harmful code, leading to potential security risks.

## How to Configure the Code Execution Mode

To configure the code execution mode, you need to set the `execution_service.kernel_mode` parameter in theh}(hhhhhKuhh	uh(hhh}h}(hhGhhHusub$f74b3dfd-c40e-42f6-89c5-5ecc2bb547fbh
)}(h
}(hX  `taskweaver_config.json` file. The value of the parameter could be `local` or `container`. The default value
is `container`.

TaskWeaver supports the `local` mode without any additional setup. However, to use the `container` mode,
there are a few prerequisites:
h}(hhhhhKuhh	uh(hhh}h}(hhPhhQusub$d0d16c95-8865-424e-a12f-845d3704c168h
)}(h
}(h- Docker is installed on the host machine.
- A Docker image is built and available on the host machine for code execution.
- The `execution_service.kernel_mode` parameter is set to `container` in the `taskweaver_config.json` file.
h}(hhhhhKuhh	uh(hhh}h}(hhYhhZusub$01bf391c-3eb0-4388-b773-a1d5c7163560h
)}(h
}(hX   Once the code repository is cloned to your local machine, you can build the Docker image
by running the following command in the root directory of the code repository:

```bash
cd scripts

# based on your OS
./build_executor.ps1 # for Windows
./build_executor.sh # for Linux or macOS
```
h}(hhhhhKuhh	uh(hhh}h}(hhbhhcusub$89acbce3-3aac-4165-a2d1-faf8add49098h
)}(h
}(hAfter the Docker image is built, you can run `docker images` to check if a Docker image 
named `taskweavercontainers/taskweaver-executor` is available. 
If the prerequisite is met, you can now run TaskWeaver in the `container` mode.
h}(hhhhhK	uhh	uh(hhh}h}(hhkhhlusub$dcc63845-be3a-468e-bc3e-5faa8249439eh
)}(h
}(hX   After running TaskWeaver in the `container` mode, you can check if the container is running by running `docker ps`.
You should see a container of image `taskweavercontainers/taskweaver-executor` running after executing some code. 

## How to customize the Docker image for code execution
h}(hhhhhK
uhh	uh(hhh}h}(hhthhuusub$f36c9dfd-3774-486c-9c2b-5011c958435bh
)}(h
}(hX<  You may want to customize the Docker image for code execution to include additional packages or libraries, especially
for your developed plugins. The current Docker image for code execution only includes the dependencies specified in the `TaskWeaver/requirements.txt` file. To customize the Docker image, you need toh}(hhhhhKuhh	uh(hhh}h}(hh}hh~usub$6f444e31-8e34-4990-8478-d374be6dc776h
)}(h
}(hmodify the `Dockerfile` at `TaskWeaver/docker/ces_container/Dockerfile` and rebuild the Docker image.

When you open the `Dockerfile`, you will see the following content, and you can add additional packages or librariesh}(hhhhhKuhh	uh(hhh}h}(hhhhusub$585f029c-f5ce-4a3a-bb23-bbd5f8ef710eh
)}(h
}(hby adding the corresponding `RUN` command. In this example, we add the `sentence-transformers` package to the Docker image.

```Dockerfile
FROM python:3.10-slim
...
# TODO: Install additional packages for pluginsh}(hhhhhK
uhh	uh(hhh}h}(hhhhusub$5cf410ed-d518-42e7-9ef1-f7a137431d65h
)}(h
}(hRUN pip install --no-cache-dir --no-warn-script-location --user sentence-transformers
...
```
Then, you need to rebuild the Docker image by running the `build_executor.sh` script at `TaskWeaver/scripts/build_executor.sh` h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$0e7c0d24-c776-471a-b137-d762124d8b04h
)}(h
}(hX  or `TaskWeaver/scripts/build.ps1` depending on your operating system.

```bash
cd TaskWeaver/scripts
./build_executor.sh
# or ./build_executor.ps1 if you are using Windows
```

If you have successfully rebuilt the Docker image, you can check the new image by running `docker images`.h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$c88ea64c-fe5e-48b2-83e1-2f3bcae05cd3h
)}(h
}(hAfter building the Docker image, you need to restart the TaskWeaver agent to use the new Docker image.

## Limitations of the `container` Mode

The `container` mode is more secure than the `local` mode, but it also has some limitations:
h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$99a8e825-da00-48f9-bcd5-1fdefafaaf72h
)}(h
}(h- The startup time of the `container` mode is longer than the `local` mode, because it needs to start a Docker container. 
- As the Jupyter Kernel is running inside a Docker container, it has limited access to the host machine. We are mapping theh}(hhhhhKuhh	uh(hhh}h}(hhhhusub$cc0a095e-5f59-4b47-ac19-3de96fb31ce3h
)}(h
}(h  `project/workspace/sessions/<session_id>` directory to the container, so the code executed in the container can access the
  files in it. One implication of this is that the user cannot ask the agent to load a file from the host machine, because theh}(hhhhhKuhh	uh(hhh}h}(hhhhusub$277280c6-ef17-40eb-aec2-0c0ded2adb41h
)}(h
}(h  file is not available in the container. Instead, the user needs to upload the file either using the `/upload` command in 
  the console or the `upload` button in the web interface.h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$48103f42-b01d-4555-b45e-0e69893b470eh
)}(h
}(hX  - We have installed required packages in the Docker image to run the Jupyter Kernel. If the user needs to use a package that is
  not available in the Docker image, the user needs to add the package to the Dockerfile (at `TaskWeaver/ces_container/Dockerfile`) h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$84b9aaae-8287-4e8a-ba83-37a3774cee32h
)}(h
}(h  and rebuild the Docker image.

## Restricting External Network Access for Docker Containers

In some cases, the agent developer may want to restrict the Docker container's access to the external network, e.g., the internet.h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$8512188f-97ed-40fb-a6d6-f0bbe42f95feh
)}(h
}(hXG  In other words, the agent developer only wants to run the code in the container but does not allow either 
the plugins or the generated code to access the internet.

The following approach is a common way to restrict a Docker container's access to the internet while still 
allowing inbound connections on specific ports:  
   h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$08dc98e0-3407-48db-a040-6b743a867fd9h
)}(h
}(hX  1. **Creating a Docker network with `enable_ip_masquerade` set to false**:  
  
   By default, Docker uses IP masquerading (a form of network address translation or NAT) to allow containers 
   to communicate with external networks with the source IP address being the host IP address. h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$76ea6c6d-0dbc-4c6e-923b-c4543bd5de55h
)}(h
}(hX/      When you set `enable_ip_masquerade` to false for a custom Docker network, 
    you prevent containers on that network from having their IP addresses masqueraded, effectively blocking them 
    from accessing the internet. To create such a network in Docker, you would use the following command:  
  h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$7b15a599-9e7a-4f0f-801c-84678333d080h
)}(h
}(hX     ```bash  
   docker network create --opt com.docker.network.bridge.enable_ip_masquerade=false my_non_internet_network  
   ```  
  
   Any container connected to `my_non_internet_network` will not have internet access due to the disabled IP masquerade.  
    Now, you can run h}(hhhhhKuhh	uh(hhh}h}(hhhhusub$17978bb3-26f8-40c2-8401-bd55fb89942bh
)}(h
}(h    ```bash
    docker network inspect my_non_internet_network
    ```
   and you will see an output similar to the following:
    ```json
    "Config": [
        {
            "Subnet": "172.19.0.0/16",h}(hhhhhKuhh	uh(hhh}h}(hj  hj  usub$9786df53-cdc9-4346-b8c2-6f8fa5b05db4h
)}(h
}(hX
              "Gateway": "172.19.0.1"
        }
    ]
    ```
   This shows the subnet of the docker network, all containers connected to this network will have an IP address in this subnet.
   
2. **Establishing a rule on the host's firewall or using iptables**:  
  h}(hhhhhKuhh	uh(hhh}h}(hj
  hj  usub$2da2edc9-1d63-4d93-a3b4-abaf7235f043h
)}(h
}(hX8     This step is about setting up rules to block outgoing traffic from the Docker network's subnet 
   to any external addresses. This adds an additional layer of security to ensure that even 
    if IP masquerade is somehow enabled or if the container finds another route, the traffic will still be blocked.  
  h}(hhhhhKuhh	uh(hhh}h}(hj  hj  usub$43fe817f-3579-4ed6-b15a-5f5602ea65c1h
)}(h
}(hX	     - **On a Linux host using iptables**, you might add a rule like this:  
  
     ```bash  
     iptables -I FORWARD -s <docker_network_subnet> -j DROP  
     ```  
       
     Replace `<docker_network_subnet>` with the actual subnet used by your Docker network. h}(hhhhhKuhh	uh(hhh}h}(hj  hj   usub$34dbb9bd-4973-41b9-bffb-25715137f390h
)}(h
}(hX       In the previous example, the subnet is `172.19.0.0/16`. This rule drops all forwarding traffic from that subnet. 
  
   - **On a Windows host**, you would create a similar rule within the Windows Firewall 
     to block outgoing traffic from the Docker network's subnet.  h}(hhhhhKuhh	uh(hhh}h}(hj(  hj)  usub$e517856a-80f2-482b-8ddb-7902fa888058h
)}(h
}(hX     
Keep in mind that this approach can be considered good practice if you understand the implications 
and have a specific need to isolate your container from the internet.
However, it could also complicate network troubleshooting and container communication if not managed properly. h}(hhhhhKuhh	uh(hhh}h}(hj1  hj2  usub$60df0667-aca3-4f8a-bfab-795b12d02c6ah
)}(h
}(htAlways ensure you are testing these configurations in a safe environment before applying them to production systems.h}(hhhhhK uhh	uh(hhh}h}(hj:  hj;  usub$ff826bb3-8698-48ec-998a-a4527ba35ea8h
)}(h
}(h# FAQ

### Q: Why it takes so long to generate the output?

A: In the default setting, TaskWeaver typically goes through the following steps to generate the output:
1. The User sends a query to the Planner.h}(hhh# FAQhK uhh	uh(hhh}h}(hjC  hjD  usub$4b46b367-def3-486c-9c1f-7220da081d64h
)}(h
}(hX  2. The Planner generates a plan based on the query and sends the plan to the CodeInterpreter.
3. The CodeInterpreter executes the plan and sends the execution result back to the Planner.
4. The Planner summarizes the execution result and sends the summary to the User.h}(hhhjE  hKuhh	uh(hhh}h}(hjM  hjN  usub$e39e16f3-e51c-472b-9f28-cf7a13e65437h
)}(h
}(h5. The User receives the summary from the Planner.

In some cases, the Planer and CodeInterpreter can go back and forth multiple times to generate the output.
This process can take a long time, mostly due to the latency of calling the LLMs.h}(hhhjE  hKuhh	uh(hhh}h}(hjV  hjW  usub$631df509-b5ea-409b-8551-013221e2961ah
)}(h
}(hTo speed up the process, you can try the following:
- Use a smaller LLM model, such as GPT-3.5 instead of GPT-4. However, you need to experiment with your use case to see if the smaller model can still generate the output correctly.h}(hhhjE  hKuhh	uh(hhh}h}(hj_  hj`  usub$17c61e90-3db4-4c5a-9d2f-60c370be26f6h
)}(h
}(h- Use the CodeInterpreter only mode, which skips the Planner and generates the code directly from the User query. This mode is faster because it skips the planning step. 
However, you should check if your use case needs the planning step.  
h}(hhhjE  hKuhh	uh(hhh}h}(hjh  hji  usub$87d2a0e7-abe2-441a-999c-0b4304cbb8fch
)}(h
}(h### Q: Why TaskWeaver fails and the logs say "Failed to connect to docker.daemon"?

A: This error typically happens when TaskWeaver is running in the `container` mode and cannot connect to the Docker daemon.h}(hhhjE  hKuhh	uh(hhh}h}(hjq  hjr  usub$79b76170-b6e7-4314-9f02-6476e5d2f040h
)}(h
}(hWe have switched to the `container` mode by default to provide a more secure environment for code execution.
To opt out of the `container` mode, you can set the `execution_service.kernel_mode` parameter to `local` in the `taskweaver_config.json` file.h}(hhhjE  hKuhh	uh(hhh}h}(hjz  hj{  usub$c4206c87-0f00-4b23-9c87-778062c07958h
)}(h
}(hHowever, you should be aware that TaskWeaver can interact with the host machine directly in the `local` mode, which may have security risks.

### Q: Why I see errors saying the Planner failed to generate the `send_to`, `message` or other fields?
h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$e4dd255c-d3a2-4dc0-9c99-cb02a0f59d24h
)}(h
}(hA: This is typically due to that the LLM failed to generate its output follow our schema. In Planner's prompt,
we asked the LLM to generate a JSON object that contains `send_to`, `message`, `init_plan`, `plan`, and `current_plan_step`.h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$cf5cc6cd-15a9-4fa0-9503-d4e443cd1730h
)}(h
}(hMissing any of these fields will cause the parsing error. 
The most effective way to mitigate this issue is to use switch to more powerful LLM model, such as GPT-3.5 or GPT-4.

### Q: How do I know if TaskWeaver can see my plugin?
h}(hhhjE  hK	uhh	uh(hhh}h}(hj  hj  usub$981960d7-f77a-41ec-b9f4-d7c20f17c8fdh
)}(h
}(hX  A: A simple way to check if TaskWeaver can see your plugin is to ask "What can you do?" to TaskWeaver.
The typical response is to list all the available plugins like the following:
```markdown
I can assist you with various tasks, including:

- Detecting anomalies in time series data.h}(hhhjE  hK
uhh	uh(hhh}h}(hj  hj  usub$88f476b9-0a03-46e7-9666-a2206db7559ch
)}(h
}(h- Rendering text into ASCII art.
- Searching and comparing prices from thousands of online shops (US only).
- Telling a joke.

If you have a specific task in mind, please let me know, and I'll do my best to assist you.
```h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$b4b536dc-cc3a-4c87-ba39-6c6efbecfb8ch
)}(h
}(hIf you see your plugin in the list, it means TaskWeaver can see your plugin.
But this is not a reliable way to check if TaskWeaver can see your plugin because the response is generated by the LLM.h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$5c067c4d-9169-499a-8360-368eedd9498dh
)}(h
}(hA more reliable way is to check the prompt of the Planner. You can find the prompts 
from `project/workspace/sessions/<session_id>/planner_prompt_log_xxxx.yaml`.
Then, search for this section as follows:

```markdownh}(hhhjE  hK
uhh	uh(hhh}h}(hj  hj  usub$d80d95d9-eecf-46e2-8ffd-3a1aaa4e28c9h
)}(h
}(hzCodeInterpreter has the following plugin functions and their required parameters need to be provided before the execution:h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$b747459f-929d-4fa7-b257-d3e24779ffa8h
)}(h
}(hXA  - anomaly_detection: anomaly_detection function identifies anomalies from an input DataFrame of time series. It will add a new column \"Is_Anomaly\", where each entry will be marked with \"True\" if the value is an anomaly or \"False\" otherwise. Arguments required: df: DataFrame, time_col_name: str, value_col_name: strh}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$f6bf2383-d1d4-4d5f-8445-494c272b2dc2h
)}(h
}(he- ascii_render: This plugin renders the input text into ASCII art form. Arguments required: text: strh}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$dcc6c59e-04f7-46a5-ab1f-d4013fed3dc7h
)}(h
}(hX   - klarna_search: Search and compare prices from thousands of online shops. Only available in the US. This plugin only takes user requests when searching for merchandise. If not clear, confirm with the user if they want to search for merchandise from Klarna. Arguments required: query: strh}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$bae7fd16-45f7-4c84-a5ed-6a3433c673f7h
)}(h
}(h- tell_joke: Call this plugin to tell a joke.
```
Check if your plugin is in the list. If it is, it means TaskWeaver can see your plugin.

### Q: Why TaskWeaver cannot see my plugin?
h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$f245f261-6489-44d2-9d31-2149ecf69782h
)}(h
}(hFirst, make sure you have read our [Plugin Introduction](https://microsoft.github.io/TaskWeaver/docs/plugin/plugin_intro) and this tutorial carefully.
You should have two files in the `plugins` folder, e.g., `ascii_render.py` and `ascii_render.yaml`.
h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$9614e2e7-f3b9-4a0b-b82e-4e91ec3ede78h
)}(h
}(hX  Now, if TaskWeaver cannot see your plugin, the root cause is typically syntax errors in the yaml file. 
Check the console output if you are using the command line interface, or the console logs if you are using the web interface.
You may see the following error message:
```bashh}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$a9cb7c2a-0cde-4cdf-bee2-3e40c96eef5dh
)}(h
}(hfailed to loading component from <name>.yaml, skipping: Yaml loading failed due to: <reason>
```
The error message will tell you the reason why the yaml file cannot be loaded.h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$fbf48741-bd4a-4769-a887-ad07f2c36356h
)}(h
}(hIt is typically easy to fix the syntax errors by using a yaml linter (e.g., in Visual Studio Code) or an online yaml linter.

If you have checked the syntax of the yaml file and TaskWeaver still cannot see your plugin, please checkh}(hhhjE  hKuhh	uh(hhh}h}(hj
  hj  usub$756653bc-e18d-46b7-b156-9c4e7c23d33ah
)}(h
}(hif the yaml file has included all the required fields such as the `parameters` and `returns` fields.

### Q: Why TaskWeaver can see my plugin but cannot call it?

A: In this case, you may see the generated code has called the plugin function, h}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$a62bc9bb-f6e2-4fde-972e-b01813a5a245h
)}(h
}(hX"  but the execution result is an error message saying that the plugin function is undefined.
If this happens, please check the console output if you are using the command line interface,
or the console logs if you are using the web interface.

You may see the following error message:
```bashh}(hhhjE  hKuhh	uh(hhh}h}(hj  hj  usub$7438aa50-bd02-4f0c-893b-f78ae6946e42h
)}(h
}(hX  Plugin <name> failed to load: Plugin <name> failed to register: failed to load plugin <name> <reason>
```
This error message will tell you the reason why the plugin function cannot be loaded.
It is typically easy to fix the errors by checking the console output or logs.h}(hhhjE  hKuhh	uh(hhh}h}(hj%  hj&  usub$ce56f0b6-f2d7-413f-b38c-e4a5f1514066h
)}(h
}(hX  The root cause is typically errors in the python file that causes the plugin function cannot be loaded.
Typical errors include syntax errors, missing imports, or missing packages.

Note that this sort of error is not caused by the implementation "inside" the plugin function.h}(hhhjE  hKuhh	uh(hhh}h}(hj.  hj/  usub$ac90defe-74d9-41e2-9792-40d2a1679cc9h
)}(h
}(hX  Otherwise, the errors would be caught during the execution of the plugin function, 
not during the loading of the plugin function.

### Q: How to debug my plugin?

A: We are working on a debugging tool to help you debug your plugin. For now, a simple way to debug your plugin is to h}(hhhjE  hKuhh	uh(hhh}h}(hj7  hj8  usub$ca845f4c-58d2-486f-b9f3-3a95fcfe0158h
)}(h
}(hX  define a main function in the python file and run it in your local environment.
For example, you can define a main function in `ascii_render.py` as follows:
```python
if __name__ == "__main__":
    from taskweaver.plugin.context import temp_context

    with temp_context() as temp_ctx:h}(hhhjE  hKuhh	uh(hhh}h}(hj@  hjA  usub$45168460-493f-48c8-8c11-9dbb6b292024h
)}(h
}(h        render = AsciiRenderPlugin(name="ascii_render", ctx=temp_ctx, config={})
        print(render(text="hello world!"))
```
In this main function, we create a temporary context and call the plugin function with some input.h}(hhhjE  hKuhh	uh(hhh}h}(hjI  hjJ  usub$0e02c5c4-a523-4b83-ac6e-21b6ced33e1dh
)}(h
}(hYou need not change the plugin implementation. Just add the main function to the end of the python file.
Then, run the python file in your local environment. If there are any errors, you can see them in the console output.
h}(hhhjE  hKuhh	uh(hhh}h}(hjR  hjS  usub$5d5960fb-bdf4-472a-a49c-4a1afdb5a0f2h
)}(h
}(hX  If you have the `configurations` section in the yaml file, you can manually set the configurations in the `config` parameter of the plugin constructor.
We currently do not read the yaml file, so you need to make sure that the configurations are set correctly in the `config` parameter.h}(hhhjE  hKuhh	uh(hhh}h}(hj[  hj\  usub$1be574a1-d0ae-44f5-9b5a-bca021bce6c0h
)}(h
}(hFor example, if an integer configuration `max_length` is defined in the yaml file, you can set it in the `config` parameter as follows:
```python
config = {
    "max_length": 100
}
```h}(hhhjE  hK uhh	uh(hhh}h}(hjd  hje  usub$943240b8-39fd-4e1f-96c9-117993275a57h
)}(h
}(hThen, pass the `config` to the plugin constructor. As yaml is type sensitive, you need to make sure that the type of the configuration is correct.

### Q: Why I see the error message "RuntimeError: This event loop is already running"?
h}(hhhjE  hK!uhh	uh(hhh}h}(hjm  hjn  usub$9e756a73-5749-4afe-b950-8dbf387c80b0h
)}(h
}(hX  A: We use a Jupyter Kernel to execute the code in TaskWeaver. The Jupyter Kernel uses an event loop to manage the execution of the code.
If you see the error message "RuntimeError: This event loop is already running.", it typically means that the event loop is already running.h}(hhhjE  hK"uhh	uh(hhh}h}(hjv  hjw  usub$91cc66cf-4674-4f32-b69a-dfb0efc04abeh
)}(h
}(hThis is typically caused by the enviroment where TaskWeaver is running. For example, if you are running TaskWeaver in a Jupyter Notebook.h}(hhhjE  hK#uhh	uh(hhh}h}(hj  hj  usub$a600f033-bd88-4472-b5ba-9073be270f06h
)}(h
}(h# Overview
<!-- <div>
<h1 style={{display: flex, padding: 0 20px}}>
<img 
  src={require('../static/img/logo_light.png').default}
  alt="Logo"
  style={{width: 80, height: 80, display: "inline"}}
/>h}(hhh
# OverviewhK uhh	uh(hhh}h}(hj  hj  usub$37781050-0ea5-41d4-b398-6c9cd3e427bfh
)}(h
}(hX  <span style={{lineHeight: "80px"}}>TaskWeaver</span>
</h1> -->
<!-- </div> -->

**TaskWeaver** is a *code-first* agent framework for seamlessly planning and executing data analytics tasks. 
This innovative framework interprets user requests through coded snippets and efficiently h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$a50f5548-08f0-4d3a-809e-bcd20fa74f9bh
)}(h
}(hX
  coordinates a variety of plugins in the form of functions to execute 
data analytics or workflow automation tasks.

![TaskWeaver](../static/img/taskweaver_arch.png)

**Highlighted Features**

- [x] **Rich data structure** - TaskWeaver allows you to work with rich data h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$be68953e-350a-4090-9b17-1c5e79398bceh
)}(h
}(h    structures in Python, such as Lists, Dictionaries, or Pandas DataFrames, instead of having to restrict to 
    text strings.
- [x] **Customized algorithms** - TaskWeaver allows you to encapsulate your h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$d8fb0906-0b60-4443-a44a-6be6b01d35aeh
)}(h
}(h    own algorithms or functions into plugins (in the form of Python functions), 
    and orchestrate them to achieve complex tasks.
- [x] **Incorporating domain-specific knowledge** - TaskWeaver is designed to h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$220ba101-df65-4682-b06c-8ab996d38abeh
)}(h
}(h    be easily incorporating domain-specific knowledge, such as the knowledge or experience in task planning and code generation, to improve the reliability of task execution.
- [x] **Stateful conversation** - TaskWeaver is designed to support stateful h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$cc279eb9-2149-487b-963f-337aa61b2f1ah
)}(h
}(hX"      conversation which means you can interact with your data in memory across multiple chat rounds.
- [x] **Code verification** - TaskWeaver is designed to verify the generated code 
    before execution. It can detect potential issues in the generated code 
    and automatically fix them.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$197a2a4a-1a9e-4858-9682-1701a7cf34b4h
)}(h
}(h- [x] **Security consideration** - TaskWeaver supports running code inside a sandbox 
    environment to prevent malicious code execution. It also provides a basic session management to keep
    different users' data separate.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$7b7a6288-61f8-478e-b5af-3ace01f5d087h
)}(h
}(h- [x] **Easy to debug** - TaskWeaver is designed to be easy to debug. 
    We have detailed logs, metrics, and traces, instrumenting using OpenTelemetry, to help you understand what is going on under the simple chat interface.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$6d2deb13-25d7-452d-9aab-395778481036h
)}(h
}(h- [x] **Easy to extend** - TaskWeaver is designed to be easily extended to accomplish more complex tasks. 
    Beyond the plugins, you can create extra roles, define how they interact with the Planner and orchestrate them to achieve more complex tasks.h}(hhhj  hK	uhh	uh(hhh}h}(hj  hj  usub$d20d405b-0393-4a96-9976-8f0a14ee2424h
)}(h
}(h- [x] **Easy to use** - TaskWeaver is designed to be easy to use. 
    We provide a set of sample plugins and a tutorial to help you get started.
    We also provide a all-in-one Docker image to help you quickly play with TaskWeaver.h}(hhhj  hK
uhh	uh(hhh}h}(hj  hj  usub$cb1015ec-14b8-43a9-a0fe-39e35bbfff25h
)}(h
}(hX  # Quick Start

## Installation
You can install TaskWeaver by running the following command:
```bash
# [optional] create a conda environment to isolate the dependencies
# conda create -n taskweaver python=3.10
# conda activate taskweaver

# clone the repositoryh}(hhh
# Quick StarthK uhh	uh(hhh}h}(hj  hj  usub$e71e6a07-2aec-4476-bc88-80069b966feah
)}(h
}(hX  git clone https://github.com/microsoft/TaskWeaver.git
cd TaskWeaver
# install the requirements
pip install -r requirements.txt
```

## Project Directory
TaskWeaver runs as a process, you need to create a project directory to store plugins and configuration files. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$6961b6aa-eefd-45c8-b9ab-20001fbbc741h
)}(h
}(hX!  We provided a sample project directory in the `project` folder. You can copy the `project` folder to your workspace.
A project directory typically contains the following files and folders:

```bash
📦project
 ┣ 📜taskweaver_config.json # the project configuration file for TaskWeaverh}(hhhj  hKuhh	uh(hhh}h}(hj  hj   usub$54bd99b4-f3ac-4add-a109-225c47915239h
)}(h
}(hX   ┣ 📂plugins # the folder to store plugins
 ┣ 📂planner_examples # the folder to store planner examples
 ┣ 📂codeinterpreter_examples # the folder to store code interpreter examples
 ┣ 📂logs # the folder to store logs, will be generated after program startsh}(hhhj  hKuhh	uh(hhh}h}(hj  hj	  usub$991e0363-2a98-48c7-8e45-0e463323a0f1h
)}(h
}(hX   ┗ 📂workspace # the directory stores session data， will be generated after program starts
    ┗ 📂 session_id 
      ┣ 📂ces # the folder used by the code execution service
      ┣ 📂cwd # the current working directory to run the generated codeh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$99290e4a-171c-45a1-9ed1-476bb9239aach
)}(h
}(h      ┗ other session data
```

## OpenAI Configuration
Before running TaskWeaver, you need to provide your OpenAI API key and other necessary information. 
You can do this by editing the `taskweaver_config.json` file. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$a7165342-9ea4-4cc6-8817-e53bc772f034h
)}(h
}(hIf you are using Azure OpenAI, you need to set the following parameters in the `taskweaver_config.json` file:
### Azure OpenAI
```json
{
"llm.api_base": "https://xxx.openai.azure.com/",
"llm.api_key": "your_api_key",h}(hhhj  hKuhh	uh(hhh}h}(hj#  hj$  usub$f9ca7649-7623-4da3-8a53-29adbbb17cc3h
)}(h
}(h"llm.api_type": "azure",
"llm.api_version": "the api version",
"llm.model": "the model name, e.g., gpt-4" # In Azure OpenAI, the model name is the deployment_name
}
```

### OpenAI
```json
{h}(hhhj  hKuhh	uh(hhh}h}(hj,  hj-  usub$49f4b64a-a3b5-4136-8413-7480dcf9a94dh
)}(h
}(h"llm.api_key": "the api key",
"llm.model": "the model name, e.g., gpt-4"
}
```
>💡 Only the latest OpenAI API supports the `json_object` response format. h}(hhhj  hKuhh	uh(hhh}h}(hj5  hj6  usub$35322a6f-0f12-4cbf-b8ef-06dbdee45201h
)}(h
}(hX  > If you are using an older version of OpenAI API, you need to set the `"llm.response_format"`=`null` in the `taskweaver_config.json` file.

More configuration options can be found in the [configuration documentation](./configurations/overview).

## Start TaskWeaver
```bashh}(hhhj  hK	uhh	uh(hhh}h}(hj>  hj?  usub$6cbb5dc7-e53e-4431-b2b5-266be3fb3efah
)}(h
}(hX  # assume you are in the TaskWeaver folder cloned from the repository
python -m taskweaver -p ./project/ # -p is the path to the project directory
```
This will start the TaskWeaver process and you can interact with it through the command line (CLI) interface. h}(hhhj  hK
uhh	uh(hhh}h}(hjG  hjH  usub$addff6d6-6924-41f2-be97-4181d6662f24h
)}(h
}(hIf everything goes well, you will see the following prompt:

```bash
=========================================================
 ___         _     _       __
|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hhhj  hKuhh	uh(hhh}h}(hjP  hjQ  usub$600c0408-c311-4a1d-b342-9e86518aa9a8h
)}(h
}(ho  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hhhj  hKuhh	uh(hhh}h}(hjY  hjZ  usub$de2db6e5-e24c-4131-a76d-19737c167a7ch
)}(h
}(h  |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================
TaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
Human: ___
```
h}(hhhj  hK
uhh	uh(hhh}h}(hjb  hjc  usub$004290db-bc03-4f78-b8b9-ef7d5791ff6ah
)}(h
}(hX  There are other ways to start TaskWeaver:
- [A Chainlit UI interface](./usage/webui.md): TaskWeaver provides an experimental web-based interface to interact with the system.
- [A Library](./usage/library.md): You can also use TaskWeaver as a library in your Python code.h}(hhhj  hKuhh	uh(hhh}h}(hjk  hjl  usub$0f5f9a2c-d0c6-4b92-8eee-69fceecc7df3h
)}(h
}(h- [The all-in-one Docker image](./usage/docker.md): We provide a Docker image that contains all the dependencies to run TaskWeaver.h}(hhhj  hKuhh	uh(hhh}h}(hjt  hju  usub$bbf73d80-3328-483f-9eb1-e29c813f9676h
)}(h
}(h# CLI Only Mode

TaskWeaver's CLI-only mode enables users to effortlessly communicate with the Command Line Interface (CLI) using natural language. 
CodeInterpreter generates CLI commands, such as bash or PowerShell to address the user's needs.h}(hcli_only.mdh# CLI Only ModehK uhh	uh(hhh}h}(hj}  hj~  usub$8c805f32-9402-46b2-92d5-ef783cd59f5ch
)}(h
}(huThis mode allows users to operate your system by simply chatting with the command line in natural language!

## Demo
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ea8ef440-11ee-4b92-bdb8-c45e8ea8747eh
)}(h
}(hX  <iframe width="560" height="315" src="https://github.com/microsoft/TaskWeaver/assets/32928431/3724d321-0e0b-49e0-8f77-7b3855069a82" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$bb07a603-47ba-4d45-90a8-db380413dab4h
)}(h
}(hX  
## How to enable
Just add the following configuration to the project configuration file `taskweaver_config.json`:
```json
{
  "session.roles": ["code_interpreter_cli_only"]
}
```
Please refer to the [session](../configurations/configurations_in_detail) documentation for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5987665c-7d89-444c-bca2-55890a43d584h
)}(h
}(h# Prompt Compression

After chatting for a few rounds, the chat history can become quite long, especially when we have code and execution results in it.
This can cause the problem of exceeding the context window of the LLMs. h}(hcompression.mdh# Prompt CompressionhK uhh	uh(hhh}h}(hj  hj  usub$92b47f4d-b105-41a6-a531-c9e2a5a19321h
)}(h
}(hX  To solve the problem, one way is to summarize the chat history a few rounds ago, 
and only keep the latest rounds of the chat history.

Another way is to use a vector database to store the chat history entries, and only retrieve the last few rounds of the relevanth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$28d52302-7ebb-491e-8e19-e03cfd974921h
)}(h
}(hX,  part given the current user request. However, in TaskWeaver, code is also part of the chat history.
It is not an option to skip some intermediate code and execution results in order to correctly
generate the code for the current user request. Therefore, we choose the first way to solve the problem.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6eda1d8a-cf20-4701-adaf-aaaf8f762cd0h
)}(h
}(hThe following figure shows the idea of chat history summarization where the chat history is divided into two parts:
- Rounds to compress: this part is summarized and only the summary is kept in the chat history. If the context_summary h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3a4b7d5b-0a8b-42d5-82c5-e8f2223b355bh
)}(h
}(hX<      already exists, a new summary is generated based on the previous summary adding the rounds to be summarized.
- Rounds to retain: this part is kept in the chat history without summarization.

```mermaid
  flowchart LR
      ConversationSummary-->Round1
      subgraph Rounds to compress 
          Round1-->Round2h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ae4c3547-6656-4b63-8cbc-02b31941067ch
)}(h
}(h      end
      subgraph Rounds to retain
          Round2-->Round3-->Round4-->Round5    
      end
```
Imagine that, at the beginning, the ConversationSummary is empty.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$8b5cf9fa-a102-4024-b5c4-96eb152208f7h
)}(h
}(huOnce the chat history reaches the `rounds_to_compress` (default 2) rounds plus `rounds_to_retain` (default 3) rounds,h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5fa4873a-8efb-4a91-8e18-e62a4a3e35bdh
)}(h
}(hthe ConversationSummary is generated based on the `rounds_to_compress` rounds and the `rounds_to_retain` rounds are kept in the chat history.
After that, there will be only `rounds_to_retain` rounds in the chat history.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$909a233f-6681-4df6-bf3d-cec0b07e3d30h
)}(h
}(hX3  The next time the chat history reaches the `rounds_to_compress` rounds plus `rounds_to_retain` rounds,
the ConversationSummary is generated based on the `rounds_to_compress` rounds and the previous ConversationSummary.
We use these two parameters to control the frequency of the chat history summarization.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ffe6a965-f591-48de-a8b7-ab9ec4122d75h
)}(h
}(h]An example of the chat history summarization in the Code Generator is shown below:

```json
{h}(hj  hj  hK	uhh	uh(hhh}h}(hj  hj  usub$40137b9e-7c11-42e4-bd26-6ba5f3c72330h
)}(h
}(hX    "ConversationSummary": "The user requested the generation of 100 random numbers, which was successfully executed. Then, the user asked to show the top 5 largest numbers from the generated random numbers. The assistant provided a code snippet to sort the generated random numbers in descending order and select the top 5 largest numbers, which was also successfully executed. After that, the user requested to plot the distribution of the 100 numbers, which was successfully executed. The user then asked to count the frequency of numbers in each bin of the histogram and identify the bin with the most numbers for the 0.1 bin width, which was also successfully executed.",h}(hj  hj  hK
uhh	uh(hhh}h}(hj  hj   usub$fd696429-1855-446b-817e-8c8d33a94fc8h
)}(h
}(h  "Variables": [
    {
      "name": "random_numbers_100",
      "type": "numpy array",
      "description": "An array containing 100 random numbers generated using np.random.rand()"
    },
    {
      "name": "top_5_largest",h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj	  usub$6ea3e479-8734-440b-b852-f357d9befc94h
)}(h
}(h      "type": "numpy array",
      "description": "An array containing the top 5 largest numbers from the generated random numbers"
    }
  ]
}
```
The JSON object has two fields:
- ConversationSummary: the summary of the chat history.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$8e96a7af-8d85-4d87-bc84-5c5cbf046deeh
)}(h
}(hX  - Variables: the variables in the chat history that could be used in the current user request.

The chat history summary of the Planner has only the ConversationSummary field. 

The actual code generated in the summarized rounds is ignored and only the variables are kept in the summaryh}(hj  hj  hK
uhh	uh(hhh}h}(hj  hj  usub$879d307d-6f36-48ee-8512-ce96cc452fd4h
)}(h
}(hso that the LLM can still refer the these variables in future code generation.

One thing to note is that chat history summarization requires call the LLM which incurs additional latency and cost.h}(hj  hj  hKuhh	uh(hhh}h}(hj#  hj$  usub$7ceac887-6c53-4022-a031-c8d3ba880fb7h
)}(h
}(hThe prompts for chat history summarization could be found for [planner](../../../taskweaver/planner/compression_prompt.yaml)
and [code generator](../../../taskweaver/code_interpreter/code_interpreter/compression_prompt.yaml).

## Configurationsh}(hj  hj  hKuhh	uh(hhh}h}(hj,  hj-  usub$fd71b260-f655-4ba1-b2ef-37bf1e49a752h
)}(h
}(hAs explained above, there are two parameters in controlling the chat history summarization: 
`round_compressor.rounds_to_compress` (default 2) and `round_compressor.rounds_to_retain` (default 3).h}(hj  hj  hKuhh	uh(hhh}h}(hj5  hj6  usub$adcf71c5-6913-4fca-82e8-015a832a1ed8h
)}(h
}(hTo enable the chat history summarization, you need to set `planner.prompt_compression` 
and `code_generator.prompt_compression` to `true`.h}(hj  hj  hKuhh	uh(hhh}h}(hj>  hj?  usub$60c84edd-f1af-4170-a9c1-a85bac72af0fh
)}(h
}(h---
id: plugin_only
description: The Plugin Only Mode
slug: /plugin/plugin_only
---

# The Plugin-Only Mode

## What is the plugin-only mode?
The plugin-only mode is a restricted mode of TaskWeaver that only allows you to use plugins. h}(hplugin_only.mdhid: plugin_onlyhK uhh	uh(hhh}h}(hjG  hjH  usub$94d5631d-366b-4d57-bbd4-da710c44199bh
)}(h
}(hX  Compared to the full mode, the plugin-only mode has the following restrictions:

1. The generated code only contains the calls to the plugins. 
   For example, the following code only calls the `ascii_render` plugin and does not contain any "free-form" code.
    ```pythonh}(hjI  hjJ  hKuhh	uh(hhh}h}(hjR  hjS  usub$a06ae094-db91-4b54-a748-bac78fb97af1h
)}(h
}(h    r1=ascii_render(**{"text":"Hello"})
    r1
    ```
    
2. Only the plugins with `plugin_only: true` in the yaml file will be loaded. 
   For example, the following plugin will be loaded in the plugin-only mode:
    ```yaml
    name: ascii_renderh}(hjI  hjJ  hKuhh	uh(hhh}h}(hj[  hj\  usub$a73f9352-e8cf-4fe5-bcac-58a7a466db10h
)}(h
}(hX      plugin_only: true
    ...
    ```
   If this field is not specified, the default value is `false`.
   For plugins in the plugin-only mode, the argument type can only be `str`, `int`, `boolean`, or `float`.
   Other types such as `DataFrame` are not allowed.h}(hjI  hjJ  hKuhh	uh(hhh}h}(hjd  hje  usub$cf240d6e-299f-420a-910a-a44c971b4186h
)}(h
}(h   Essentially, we consider these plugins only produce "text-like" output that can be directly consumed by the LLM.

To support the plugin-only mode, we developed a new role called `PluginOrchestrator`.h}(hjI  hjJ  hKuhh	uh(hhh}h}(hjm  hjn  usub$6ec86087-a880-4745-9812-3ff81e84363fh
)}(h
}(hX  To enable the plugin-only mode, you can add the configuration `"session.roles": ["planner", "code_interpreter_plugin_only"]` 
in the project configuration file `taskweaver_config.json`.

:::info
Although the plugin-only mode is restricted, it is still useful in some scenarios.h}(hjI  hjJ  hKuhh	uh(hhh}h}(hjv  hjw  usub$92ac9cba-f464-401f-a587-640cbb5d0d65h
)}(h
}(hX  For example, you may want to use TaskWeaver to only generate the code to call a certain plugin, 
and you want to get the response from the plugin directly, without generating any other code 
for safety reasons.
:::

## How is the plugin-only mode implemented?
h}(hjI  hjJ  hKuhh	uh(hhh}h}(hj  hj  usub$e3582211-ec74-4409-8bcd-a1a33d5c0012h
)}(h
}(hThe plugin-only mode is implemented based on the [function calling](https://platform.openai.com/docs/guides/function-calling) mode of LLMs.
In this mode, the LLM is trained to generate a JSON object that contains the function name and the arguments.h}(hjI  hjJ  hKuhh	uh(hhh}h}(hj  hj  usub$1d899621-dafe-4138-b1bf-31cd08c7f1cah
)}(h
}(hFor example, the following JSON object is generated by the LLM:
```json
{
  "function": "ascii_render",
  "arguments": {
    "text": "Hello"
  }
}
```
With this JSON object, we assemble the code to call the plugin:
```pythonh}(hjI  hjJ  hKuhh	uh(hhh}h}(hj  hj  usub$3bb5a2f2-c7c0-4b8b-b061-ceebdfbe04b3h
)}(h
}(hr1=ascii_render(**{"text":"Hello"})
r1
```
Then, we execute the code and get the response from the plugin.
Therefore, the code is not directly generated by the LLM in the plugin-only mode.

## Which models support the plugin-only mode?
h}(hjI  hjJ  hK	uhh	uh(hhh}h}(hj  hj  usub$e89a55ba-89f6-49c5-a4da-5bee8bec242bh
)}(h
}(hCurrently, the plugin-only mode is only supported by 

- [OpenAI models](https://platform.openai.com/docs/guides/function-calling)
- [ZhipuAI models](https://open.bigmodel.cn/dev/api)
h}(hjI  hjJ  hK
uhh	uh(hhh}h}(hj  hj  usub$05687d4a-4791-433e-a136-191397a429eeh
)}(h
}(hfLikely other models that are compatible with the OpenAI models will also support the plugin-only mode.h}(hjI  hjJ  hKuhh	uh(hhh}h}(hj  hj  usub$2872d865-b109-4021-9416-f24818d9cf6bh
)}(h
}(hX;  # Auto Plugin Selection 

In TaskWeaver, we provide an auto plugin selection mechanism to dynamically select the best plugin for each user request.
It targets to solve the following two problems:

1. An excessive number of plugins may cause confusion for LLM, leading to inaccuracies in generating the correct code.h}(hplugin_selection.mdh# Auto Plugin SelectionhK uhh	uh(hhh}h}(hj  hj  usub$53be4622-0a9d-432c-8240-9cfa469b5c7dh
)}(h
}(hX;  2. A large number of plugins could lead to increased token usage (potentially exceeding the token limit of LLM) and extended response time.

## Auto Plugin Selection Overview

Below is the overview workflow of the auto plugin selection mechanism.
![Auto Plugin Selection Overview](../../static/img/APS.png)

:::infoh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b8df4fc6-5f00-4434-9582-2403d271039eh
)}(h
}(hX]  Automatic plugin selection mechanism is only activated during the code generation process in the Code Interpreter and does not affect the planning process of the Planner.
:::

At the start of TaskWeaver initialization, the automatic plugin selector is activated to generate embedding vectors for all plugins, including their names and descriptions. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ffe1c82e-6ff7-4f56-95ed-5a5ed396ffbah
)}(h
}(hThe embedding vectors are created using the specified embedding model configured in the `taskweaver_config.json` file. 
For more information, please refer to the [embedding](../configurations/configurations_in_detail.md) section in documentation.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b9ca40ac-7361-4f65-acd4-af7446a0cbabh
)}(h
}(hXH  When the Planner sends a request to the Code Interpreter, the auto plugin selection mechanism will be triggered.
It will first generate an embedding vector for the request using the same embedding model.
Then, it will calculate the cosine similarity between the request embedding vector and the embedding vectors of all plugins.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5e0cdfa2-36d3-4070-9019-478c74420f16h
)}(h
}(hIt will select the top-k plugins with the highest cosine similarity scores and  load them into the `code_generator` prompt.

Upon completing the code generation, the `code_generator` employs one or more plugins to produce the desired code. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$e0cb6f4e-5ed9-4b86-b941-70b53e5da0c7h
)}(h
}(hX  We have established a plugin pool to store the plugins involved in the code generation process while filtering out any unused ones. 
During the subsequent automatic plugin selection phase, newly chosen plugins are appended to the existing ones. 

## Auto Plugin Selection Configurationh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$aaa2017c-957f-4fe9-96f7-71b1ed1e21dfh
)}(h
}(hX  - `code_generator.enable_auto_plugin_selection`: Whether to enable auto plugin selection. The default value is `false`.
- `code_generator.auto_plugin_selection_topk`:	The number of auto selected plugins in each round. The default value is `3`.

## Auto Plugin Selection Preparation
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$e085a5ab-022b-497e-b585-0151a3aee7ach
)}(h
}(hX  Before using the auto plugin selection mechanism, we need to run the following command to generate the plugin meta files with embeddings.

```bash
cd scripts
python -m plugin_mgt --refresh
```
After that, you can find the `.meta` directory is generated in the `plugins` folder.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj   usub$c69e56a3-7e81-4614-bf0f-06c949d4ef56h
)}(h
}(hX/  Then you can start a new TaskWeaver session with the auto plugin selection mechanism enabled.
Code Generator will automatically load the plugin meta files with embeddings.

🎈Plugin meta files will be treated as invalid if:
  - The plugin embedding vector is not generated.
  - The plugin is modified.h}(hj  hj  hK	uhh	uh(hhh}h}(hj  hj	  usub$19ba5f85-95c9-46db-a393-f1d8de9890e8h
)}(h
}(hX    - The plugin embedding model is changed.

In this case, you cannot start the TaskWeaver and you need to run the above command again to refresh the plugin meta files.

```bash

## Auto Plugin Selection Example

We show the auto plugin selection mechanism in the following example.
h}(hj  hj  hK
uhh	uh(hhh}h}(hj  hj  usub$0e9e85bc-f5b2-4446-a4da-71810b9c7b74h
)}(h
}(hFirst, we start TaskWeaver with the auto plugin selection mechanism enabled.
```bash
=========================================================
 ___         _     _       __
|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$20996639-63c9-412b-98e1-31b580a32d3ah
)}(h
}(ho  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hj  hj  hKuhh	uh(hhh}h}(hj#  hj$  usub$40f59848-b955-491e-aef5-9f2bebe42969h
)}(h
}(h  |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================
TaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
Human: 
```
h}(hj  hj  hK
uhh	uh(hhh}h}(hj,  hj-  usub$1d0f7c74-73d2-47f6-8f88-041f560dba7fh
)}(h
}(hX	  Then we can check the log file `task_weaver.log` in the `logs` folder to see the auto plugin selector is initialized successfully because the `Plugin embeddings generated` message is printed.
```bash
2023-12-18 14:23:44,197 - INFO - Planner initialized successfullyh}(hj  hj  hKuhh	uh(hhh}h}(hj5  hj6  usub$37328d0e-a622-47e5-8524-88db89646151h
)}(h
}(h2023-12-18 14:24:10,488 - INFO - Plugin embeddings generated
2023-12-18 14:24:10,490 - INFO - CodeInterpreter initialized successfully.h}(hj  hj  hKuhh	uh(hhh}h}(hj>  hj?  usub$d9d5e752-a25b-445a-982f-133752dc6620h
)}(h
}(h2023-12-18 14:24:10,490 - INFO - Session 20231218-062343-c18494b1 is initialized
```
We ask TaskWeaver to "search Xbox price for me".
The Planner instructs the Code Interpreter to search Xbox price.

```bashh}(hj  hj  hKuhh	uh(hhh}h}(hjG  hjH  usub$139f7a00-2d92-4baf-b315-3c98a1bc40edh
)}(h
}(hTaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
Human: search xbox price for me
>>> [INIT_PLAN]
1. search xbox price
2. report the result to the user <interactively depends on 1>
>>> [PLAN]h}(hj  hj  hKuhh	uh(hhh}h}(hjP  hjQ  usub$d73ff202-0f44-4d47-9bfa-a4706cbd39b2h
)}(h
}(hX  1. instruct CodeInterpreter to search xbox price
2. report the result to the user
>>> [CURRENT_PLAN_STEP]
1. instruct CodeInterpreter to search xbox price
>>> [SEND_TO]
CodeInterpreter
>>> [MESSAGE]
Please search xbox price
>>> [PLANNER->CODEINTERPRETER]
Please search xbox price
```
h}(hj  hj  hKuhh	uh(hhh}h}(hjY  hjZ  usub$aef3315b-821b-40d0-a814-583d02764128h
)}(h
}(hBack to the Code Interpreter, the auto plugin selection mechanism is triggered.
We can check the log file `task_weaver.log` again to see the auto plugin selector selected the top-3 plugins with the highest cosine similarity scores.
```bashh}(hj  hj  hKuhh	uh(hhh}h}(hjb  hjc  usub$7bcdaea7-f383-4a5e-8197-e96ea7cc6a64h
)}(h
}(ht023-12-18 14:24:34,513 - INFO - Planner talk to CodeInterpreter: Please search xbox price using klarna_search pluginh}(hj  hj  hKuhh	uh(hhh}h}(hjk  hjl  usub$2c6bf629-2337-4827-9fd0-91f6ec140cd4h
)}(h
}(hf2023-12-18 14:24:34,669 - INFO - Selected plugins: ['klarna_search', 'sql_pull_data', 'paper_summary']h}(hj  hj  hKuhh	uh(hhh}h}(hjt  hju  usub$04f61995-8d30-4d4b-98e4-ff86ca230153h
)}(h
}(h2023-12-18 14:24:34,669 - INFO - Selected plugin pool: ['klarna_search', 'sql_pull_data', 'paper_summary']
```

Then the Code Interpreter will generate the code using the selected plugins.
````bash
>>> [THOUGHT]h}(hj  hj  hKuhh	uh(hhh}h}(hj}  hj~  usub$e56b516b-3707-480a-854a-aaaf0e85307ah
)}(h
}(hX.  ProgramApe will call the klarna_search plugin function to search for Xbox prices.
>>> [PYTHON]
search_results, description = klarna_search(query="xbox")
search_results, description
>>> [VERIFICATION]
NONE
>>> [STATUS]
SUCCESS
>>> [RESULT]
The execution of the generated python code above has succeeded
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$57b13b71-bb49-40ba-8300-564f51282410h
)}(h
}(hThe result of above Python code after execution is:
(                                                 name    price                                                url                                         attributesh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6539088c-77ac-456d-bc98-6f08e4916915h
)}(h
}(h 0             Microsoft Xbox Series X - Black Edition  $399.00  https://www.klarna.com/us/shopping/pl/cl52/495...  [Release Year:2020, Included Accessories:1 gam...h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$fccf309d-4ea3-4382-9405-741e6d964fe1h
)}(h
}(hXK   1                 Microsoft Xbox Series S 1TB - Black  $349.00  https://www.klarna.com/us/shopping/pl/cl52/320...  [Included Accessories:1 gamepad, Media Type:DV...
 ..                                                ...      ...                                                ...                                                ...h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$06d0de19-af41-407e-90d2-cffefe52d2f8h
)}(h
}(h 3                      Xbox Series S – Starter Bundle  $239.00  https://www.klarna.com/us/shopping/pl/cl52/320...                                [Platform:Xbox One]h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3135c833-dc4b-445b-a8e2-cbe27254e8e1h
)}(h
}(h 4   Microsoft Xbox Series X 1TB Console - Diablo I...  $385.58  https://www.klarna.com/us/shopping/pl/cl52/320...  [Release Year:2023, Included Accessories:1 gam...

 [5 rows x 4 columns],h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$a0ca69c5-8a98-4219-8e19-7ea94711a5a5h
)}(h
}(h 'The response is a dataframe with the following columns: name, price, url, attributes. The attributes column is a list of tags. The price is in the format of $xx.xx.')
>>> [CODEINTERPRETER->PLANNER]
The following python code has been executed:
```pythonh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0f0c83a4-5f1c-42ed-940d-d327e0140613h
)}(h
}(hXt  search_results, description = klarna_search(query="xbox")
search_results, description
```

The execution of the generated python code above has succeeded

The result of above Python code after execution is:
(                                                 name    price                                                url                                         attributesh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f36b8788-4535-474c-baef-2594b56e6191h
)}(h
}(h 0             Microsoft Xbox Series X - Black Edition  $399.00  https://www.klarna.com/us/shopping/pl/cl52/495...  [Release Year:2020, Included Accessories:1 gam...h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$76a3f06f-0576-45f1-8a85-c3114e298f46h
)}(h
}(hXK   1                 Microsoft Xbox Series S 1TB - Black  $349.00  https://www.klarna.com/us/shopping/pl/cl52/320...  [Included Accessories:1 gamepad, Media Type:DV...
 ..                                                ...      ...                                                ...                                                ...h}(hj  hj  hK uhh	uh(hhh}h}(hj  hj  usub$83f2c9fc-7891-4a29-b366-79619147d90ah
)}(h
}(h 3                      Xbox Series S – Starter Bundle  $239.00  https://www.klarna.com/us/shopping/pl/cl52/320...                                [Platform:Xbox One]h}(hj  hj  hK!uhh	uh(hhh}h}(hj  hj  usub$348e2e6f-60ee-4094-a61c-5b395035ef35h
)}(h
}(h 4   Microsoft Xbox Series X 1TB Console - Diablo I...  $385.58  https://www.klarna.com/us/shopping/pl/cl52/320...  [Release Year:2023, Included Accessories:1 gam...

 [5 rows x 4 columns],h}(hj  hj  hK"uhh	uh(hhh}h}(hj  hj  usub$3e29d5e2-437d-4781-bf1b-c4af85e81c04h
)}(h
}(hX    'The response is a dataframe with the following columns: name, price, url, attributes. The attributes column is a list of tags. The price is in the format of $xx.xx.')
```` 

Finally, the Planner will report the result to the user.
```bash
>>> [INIT_PLAN]h}(hj  hj  hK#uhh	uh(hhh}h}(hj  hj  usub$1d476ef1-3c19-4afb-b6d1-26c69e163cc3h
)}(h
}(h1. search xbox price using klarna_search plugin
2. report the result to the user <interactively depends on 1>
>>> [PLAN]
1. instruct CodeInterpreter to search xbox price using klarna_search plugin
2. report the result to the user
>>> [CURRENT_PLAN_STEP]h}(hj  hj  hK$uhh	uh(hhh}h}(hj  hj  usub$72b3dc9d-74ba-400d-a977-8a75aa77b085h
)}(h
}(h2. report the result to the user
>>> [SEND_TO]
User
>>> [MESSAGE]
Here are some Xbox prices I found:

1. Microsoft Xbox Series X - Black Edition: $399.00
2. Microsoft Xbox Series S 1TB - Black: $349.00h}(hj  hj  hK%uhh	uh(hhh}h}(hj  hj  usub$22ec7c3b-4ec9-4aed-b6f9-5cdea09c47a0h
)}(h
}(h3. Xbox Series S – Starter Bundle: $239.00
4. Microsoft Xbox Series X 1TB Console - Diablo Immortal Edition: $385.58

Please note that these prices are subject to change and availability.
>>> [PLANNER->USER]
Here are some Xbox prices I found:
h}(hj  hj  hK&uhh	uh(hhh}h}(hj
  hj  usub$f71f4676-e234-4912-a76c-6681508c9ae1h
)}(h
}(h1. Microsoft Xbox Series X - Black Edition: $399.00
2. Microsoft Xbox Series S 1TB - Black: $349.00
3. Xbox Series S – Starter Bundle: $239.00
4. Microsoft Xbox Series X 1TB Console - Diablo Immortal Edition: $385.58
h}(hj  hj  hK'uhh	uh(hhh}h}(hj  hj  usub$bf09df48-f9f4-48c8-b408-bd5dd7f0b7cah
)}(h
}(hPlease note that these prices are subject to change and availability.
TaskWeaver: Here are some Xbox prices I found:

1. Microsoft Xbox Series X - Black Edition: $399.00
2. Microsoft Xbox Series S 1TB - Black: $349.00h}(hj  hj  hK(uhh	uh(hhh}h}(hj  hj   usub$5bd892e0-e41d-42e2-a00a-bb2da59a822ah
)}(h
}(h3. Xbox Series S – Starter Bundle: $239.00
4. Microsoft Xbox Series X 1TB Console - Diablo Immortal Edition: $385.58

Please note that these prices are subject to change and availability.
```h}(hj  hj  hK)uhh	uh(hhh}h}(hj(  hj)  usub$380783b3-b416-4a56-82e4-010560e7ae00h
)}(h
}(hX	  # Telemetry

TaskWeaver now supports tracing with OpenTelemetry, 
which is one of the most popular open-source observability frameworks. This allows you to trace the following:

- Interactions between roles, i.e., the Planner, the CodeInterpreter, and the Executor.h}(htelemetry.mdh# TelemetryhK uhh	uh(hhh}h}(hj1  hj2  usub$518c32ed-7d2d-4218-a8da-489ab604c826h
)}(h
}(h- The time consumed by each role and major components of TaskWeaver.
- The prompts sent to the LLM and the responses received from the LLM.
- The status of the tasks and the errors encountered.
- The number of tokens consumed by each role.
h}(hj3  hj4  hKuhh	uh(hhh}h}(hj<  hj=  usub$b9e120b6-b05c-432b-a4af-1810cc349b76h
)}(h
}(hThe following screenshot shows a trace of a simple task: analyzing an uploaded file.

![Tracing](../../static/img/trace.png)

From this view, you can see the timeline of the task execution, which breaks majorly into 
three parts:
h}(hj3  hj4  hKuhh	uh(hhh}h}(hjE  hjF  usub$2a013280-b013-4943-a97e-f7fcc26b14c9h
)}(h
}(hX  - The planning phase, where the Planner decides the sub-tasks to be executed.
- The code generation and execution phase, where the CodeGenerator generates the code and the CodeExecutor executes it.
- The reply phase, where the Planner sends the reply to the user.
h}(hj3  hj4  hKuhh	uh(hhh}h}(hjN  hjO  usub$6b222694-bdab-4a42-8c73-1a8a2fadf853h
)}(h
}(hX'  The bars with a black line represent the critical path of the task execution, which is the longest path through the task execution. 
This is useful for identifying the bottleneck of the task execution.
We can clearly see that, currently, the task execution is dominated by the calls to the LLM.
h}(hj3  hj4  hKuhh	uh(hhh}h}(hjW  hjX  usub$8ddf6b76-6824-455e-b91e-ad3d81cd1af5h
)}(h
}(hX  We can click the span (a unit of work in the trace) to see the details of the span, including the logs and the attributes.

The screenshot below shows the details of the span of Planner's reply function:

![Tracing Prompt](../../static/img/trace_prompt.png)
h}(hj3  hj4  hKuhh	uh(hhh}h}(hj`  hja  usub$dea78dea-ccb7-4d41-8341-99f26786ff0ah
)}(h
}(hFrom this view, we can see the user query, the prompt sent to the LLM, and the tokens consumed (prompt_size and output_size) by the LLM.
We also recorded the generated code, the posts between different roles, etc. in the trace.
h}(hj3  hj4  hKuhh	uh(hhh}h}(hji  hjj  usub$cfc1595c-e7d9-447f-aa61-0bf657a6e53bh
)}(h
}(hThere are also views of the trace, for example the call graph view, which shows the call hierarchy of the spans.
Here is the call graph of the trace:

![Tracing Call Graph](../../static/img/trace_graph.png)

## How to enable tracing
h}(hj3  hj4  hKuhh	uh(hhh}h}(hjr  hjs  usubM      $ed39b689-fc0a-4513-81ef-041998ba4ccfh
)}(h
}(hTracing is by default disabled. To enable tracing, you need to install packages required by OpenTelemetry.
Please check the [OpenTelemetry website](https://opentelemetry.io/docs/languages/python/) for the installation guide.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj{  hj|  usub$38092ce7-11f6-4e62-8c0c-a8247e915aadh
)}(h
}(hIt basically requires you to install the `opentelemetry-api`, `opentelemetry-sdk`, `opentelemetry-exporter-otlp`, 
 `opentelemetry-instrumentation` and `tiktoken` packages.h}(hj3  hj4  hK	uhh	uh(hhh}h}(hj  hj  usub$969f3b29-3765-41ac-809d-09088c4f9c0dh
)}(h
}(hTo count the number of tokens consumed during task execution, you also need to install the [tiktoken](https://github.com/openai/tiktoken) package.
We now only support the tokenizers of the OpenAI models.h}(hj3  hj4  hK
uhh	uh(hhh}h}(hj  hj  usub$0b209875-18b9-4868-9589-39c0b2f9671bh
)}(h
}(hX$  After installing the packages, you can enable tracing by setting the `tracing.enabled=true` in the project configuration file.
The default tokenizer target model is `gpt-4`, if you want to use another model, you can set the `tracing.tokenizer_target_model` 
in the project configuration file.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$1763bca0-418f-42f0-b101-77dc907c1dcch
)}(h
}(hYou can find the available models in the [tiktoken code](https://github.com/openai/tiktoken/blob/main/tiktoken/model.py).

A typical configuration for tracing in the project configuration file is as follows:
```json
{
  "tracing.enabled": true,h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$f3c25702-196e-4c91-b6ac-f8cc2d20993ah
)}(h
}(h  "tracing.exporter": "otlp",
  "tracing.endpoint": "http://127.0.0.1:4317",
  "tracing.tokenizer_target_model": "gpt-4"
}
```
h}(hj3  hj4  hK
uhh	uh(hhh}h}(hj  hj  usub$cdc3e7ea-91f1-4fcb-9608-3f610fc24a2ch
)}(h
}(hNext, we need to set up the infrastructure for tracing. The following diagram shows the architecture of a toy tracing system.
It is a toy system and the data is not persisted. In a real-world scenario, you need to set up a more robust system.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$cfb45ace-d606-4d11-8cfa-2c499b525509h
)}(h
}(hThe instrumentation in the TaskWeaver code will send the traces and metrics to the OpenTelemetry collector. 
An OpenTelemetry collector is a component that receives traces and metrics from the instrumentation, does some processing, and exports them toh}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$aa2c01e1-52d1-4bba-bff1-0ae6331d146ch
)}(h
}(hanother collector or a backend. In our case, we configure the collector to export the traces to a [Jaeger](https://www.jaegertracing.io/) backend and the metrics 
to a [Prometheus](https://prometheus.io/) backend.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$88794c1a-8556-4cf6-8ada-6a89525b52f5h
)}(h
}(hX  ![Tracing Architecture](../../static/img/tracing-arch.png)

You can run the following command to set up the infrastructure:
```bash
cd /TaskWeaver/tracing
docker-compose up
```
You shall see a bunch of logs from the containers.
Take a look at the logs to see if there are any errors.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$8f0ae35d-e6f5-4930-9e16-b22cca81ac92h
)}(h
}(hIf no errors are found, you can access the Prometheus frontend at `http://localhost:9090` and the Jaeger frontend at `http://localhost:16686`.
In this setup, we assume you are running the containers on the same machine of TaskWeaver. h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$d70c7e82-8c7a-47ad-80a2-c7f3ec337d93h
)}(h
}(hIf you are running the containers on different machines, you need to configure the endpoint of the OpenTelemetry collector in the TaskWeaver configuration file.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$16941776-555d-4a00-aa9b-3355c411fef0h
)}(h
}(hThe default endpoint is `http://127.0.0.1:4317`, you can set the `tracing.endpoint` in the project configuration file to change the endpoint address.

## Tracing Infrastructure Configurationh}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$52e155a8-65c4-47d1-a150-376c2d8d0391h
)}(h
}(hX  Both Jaeger and Prometheus are popular open-source monitoring systems. We have prepared a docker-compose file to set up the infrastructure
in `/TaskWeaver/tracing_configure/docker-compose.yaml`. 
The content of the file is as follows:
```yaml
version: '3'
services:
  optl-collector:h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$ab9455a4-9217-48b1-ac5b-26a0b1f9f63ch
)}(h
}(h    image: otel/opentelemetry-collector:0.96.0
    command: ["--config=/etc/collector-config.yaml"]
    volumes:
      - ./collector-config.yaml:/etc/collector-config.yaml
    ports:h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$60d5678b-e932-449f-8d75-72d25efb5562h
)}(h
}(h      - "4317:4317" # Expose the gRPC receiver port for the collector
    depends_on:
      - jaeger

  jaeger:
    image: jaegertracing/all-in-one:1.54
    ports:
      - "16686:16686" # Jaeger UI
h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$b8a95019-0b3d-4b50-8f05-333f6303af9dh
)}(h
}(h  prometheus:
    image: prom/prometheus:latest
    ports:
      - "9090:9090" # Prometheus UI
    volumes:
      - ./prometheus-config.yml:/etc/prometheus/prometheus.yml
    command: ["--config.file=/etc/prometheus/prometheus.yml"]
    depends_on:h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$66751fa5-6f16-480d-a704-b495ade912e9h
)}(h
}(h      - optl-collector
```
If you read the file, you can see that we use the `otl/opentelemetry-collector` image to set up the OpenTelemetry collector,
We only expose the gRPC receiver port for the collector, which is `4317`.h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$1e28d574-4571-41d7-b19e-312ff2d5de70h
)}(h
}(hThe collector configuration file is `collector-config.yaml`, which is mounted to the container.
The configuration file is as follows:
```yaml
receivers:
  otlp:
    protocols:
      grpc:
        endpoint: 0.0.0.0:4317
      http:h}(hj3  hj4  hKuhh	uh(hhh}h}(hj  hj  usub$9da460f5-3fe1-412a-9c91-c9663c57bcf8h
)}(h
}(h        endpoint: 0.0.0.0:4318

exporters:
  debug:
    verbosity: detailed
  otlp:
    endpoint: "jaeger:4317"
    tls:
      insecure: true
  prometheus:h}(hj3  hj4  hKuhh	uh(hhh}h}(hj&  hj'  usub$2365565f-5252-4d67-b51e-ccde14b59939h
)}(h
}(h    endpoint: "0.0.0.0:9464"

service:
  pipelines:
    traces:
      receivers: [otlp]
      exporters: [otlp]
    metrics:
      receivers: [otlp]
      exporters: [prometheus]
    logs:
      receivers: [otlp]h}(hj3  hj4  hKuhh	uh(hhh}h}(hj/  hj0  usub$0c5b077d-7611-4bb8-b534-3ce4918ea573h
)}(h
}(h      exporters: [debug]
```
Because Jaeger is compatible with the OpenTelemetry collector, we can export the traces to Jaeger by setting the `otlp` exporter.
We also export the metrics to Prometheus by setting the `prometheus` exporter. h}(hj3  hj4  hKuhh	uh(hhh}h}(hj8  hj9  usub$0555e2aa-17cd-4224-91cb-fc91ac937c2fh
)}(h
}(hThe `prometheus-config.yml` file is the configuration file for Prometheus, which is as follows:
```yaml
scrape_configs:
  - job_name: optl-collector
    scrape_interval: 5s
    static_configs:
      - targets: ["optl-collector:9464"]
```h}(hj3  hj4  hKuhh	uh(hhh}h}(hjA  hjB  usub$51f2e27a-f192-48a6-9dd8-4bf248303152h
)}(h
}(hX  We only scrape the metrics from the OpenTelemetry collector.

## How to view the metrics

In the first section, we have explained how to view the traces in the Jaeger frontend.
Viewing the metrics in the Prometheus frontend is more complicated as each metric is a time series.h}(hj3  hj4  hKuhh	uh(hhh}h}(hjJ  hjK  usub$e4ff986a-5537-40a9-ad0b-7db07969da66h
)}(h
}(hA time series is a sequence of data points, which are usually timestamped.
OpenTelemetry allows to add attributes to the metrics, so that you can filter the metrics by the attributes.h}(hj3  hj4  hK uhh	uh(hhh}h}(hjS  hjT  usub$fdfc86e1-3043-44bd-b9a6-6c60b4a26475h
)}(h
}(hIn our current implementation, we only have one metric called `prompt_size` which records the size of the prompt sent to the LLM.
In Prometheus, you should be able to see a time series for the `prompt_size` metric, namely `prompt_size_total`.h}(hj3  hj4  hK!uhh	uh(hhh}h}(hj\  hj]  usub$9bf16258-211c-49cb-b8a1-d0f1d767704eh
)}(h
}(hX/  `prompt_size_total` is the accumulated prompt size of all the traces which increases monotonically.

We annotate the traces with the only one attribute called `direction`, which can be either `input` or `output`.
They are indicating the input prompt size and the LLM response output size, respectively.
h}(hj3  hj4  hK"uhh	uh(hhh}h}(hje  hjf  usub$723399f5-41f1-43fd-8b73-b3ba64688ab0h
)}(h
}(h![Tracing Metrics](../../static/img/prometheus_chart.png)

You can query the metrics in the Prometheus frontend. The query language is called PromQL which is quite powerful.h}(hj3  hj4  hK#uhh	uh(hhh}h}(hjn  hjo  usub$51222e24-c8d8-4ff7-9106-0f7f57316ad6h
)}(h
}(hYou can refer to the [Prometheus documentation](https://prometheus.io/docs/prometheus/latest/querying/basics/) for the details of the query language.
The query for the above chart is `increase(prompt_size_total[10m])`,h}(hj3  hj4  hK$uhh	uh(hhh}h}(hjw  hjx  usub$a35a9b29-c566-4c8c-a7f8-48addb7a3144h
)}(h
}(hwhich means to show the increase of the token consumption in the last 10 minutes sliding window.

If you want to use Grafana to visualize the metrics, you can set up a Grafana instance and add Prometheus as the data source.h}(hj3  hj4  hK%uhh	uh(hhh}h}(hj  hj  usub$3437a6b9-8032-4510-98b1-ef74f4423d71h
)}(h
}(hThis can be done by appending the following content to the `docker-compose.yaml` file:
```yaml
    grafana:
        image: grafana/grafana-enterprise:latest
        ports:
          - "3000:3000" # Grafana UI
        environment:h}(hj3  hj4  hK&uhh	uh(hhh}h}(hj  hj  usub$d68a74ee-99a2-4042-ae9b-cb57eae8f950h
)}(h
}(hX            - GF_SECURITY_ADMIN_PASSWORD=secret # You should change 'secret' to a password of your choosing
          - GF_USERS_ALLOW_SIGN_UP=false
        volumes:
          - grafana_data:/var/lib/grafana
        depends_on:
          - prometheus

volumes:
  grafana_data:
```
h}(hj3  hj4  hK'uhh	uh(hhh}h}(hj  hj  usub$8dc8e95e-9d91-4edd-853d-24804734ce1eh
)}(h
}(hX  ## How to customize tracing

The instrumentation of TaskWeaver is done by the OpenTelemetry Python SDK.
So, if you want to customize the tracing, you need to modify the TaskWeaver code.
In TaskWeaver, we add a layer of abstraction to the OpenTelemetry SDK, h}(hj3  hj4  hK(uhh	uh(hhh}h}(hj  hj  usub$86556c06-37e2-4e9e-a6eb-b9791c2c5677h
)}(h
}(hso that it is easier to hide the details of the OpenTelemetry SDK from the TaskWeaver code.
You can find the abstraction layer in the `taskweaver.module.tracing` module.

In the `taskweaver.module.tracing` module, we define the `Tracing` class, h}(hj3  hj4  hK)uhh	uh(hhh}h}(hj  hj  usub$9fa11eda-099c-48cc-8b55-cda3443e88feh
)}(h
}(hwhich is a wrapper of the OpenTelemetry SDK. The `Tracing` class provides the following methods:

- set_span_status: Set the status of the span.
- set_span_attribute: Set the attribute of the span.
- set_span_exception: Set the exception of the span.h}(hj3  hj4  hK*uhh	uh(hhh}h}(hj  hj  usub$195faff5-a339-48ad-8972-c400b1ce1111h
)}(h
}(hX
  - add_prompt_size: Add the prompt size to the span.

In addition, we define the decorator `tracing_decorator` (or the non-class version `tracing_decorator_non_class`) 
to trace the function calls.
When you need to create a context for tracing, you can use

```pythonh}(hj3  hj4  hK+uhh	uh(hhh}h}(hj  hj  usub$3f6a98c0-5441-4847-8d11-e19b5a03fb6dh
)}(h
}(hwith get_tracer().start_as_current_span("span_name") as span:
    # your code
```

When you need to trace a function, you can use

```python
@tracing_decorator
def your_function(self, *args, **kwargs):
    # your code
```h}(hj3  hj4  hK,uhh	uh(hhh}h}(hj  hj  usub$4c207f04-339f-4500-b97a-6050f3c01f99h
)}(h
}(hX3  ---
id: code_verification
description: Code Verification
slug: code_verification
---

# Code Verification

## Why do we need code verification?
Agent developers may want to verify the generated code before running it.
In the following example shown in the figure, the generated code is 
```python
import os
h}(hverification.mdhid: code_verificationhK uhh	uh(hhh}h}(hj  hj  usub$40c86681-881c-4231-a154-dc68a1518914h
)}(h
}(hfile = open("abc.py", "r")
code = file.read()
exec(code)
```

![Code verification workflow](../../static/img/code_verification.png)

In this case, the generated code read the content of a file and execute it, which is potentially dangerous.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$8ceadbf2-182b-4efc-8df8-65817fc881e2h
)}(h
}(hTo prevent this, we can use code verification to check the generated code before running it.
If the code does not pass the verification, the errors will be reported to the CodeGenerator to re-generate the code.

## How to use code verification?h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$2a78f137-792f-4ec2-943e-e1e8af628769h
)}(h
}(hXX  To use code verification, you can add the configuration `"code_interpreter.code_verification_on": true`
in the project configuration file `taskweaver_config.json`.
Then, the generated code will be verified before running it.

After enabling code verification, you can also specify the code verification rules in the project configuration file.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$2808eaad-fafa-4bbe-97ba-c7bf7a1b3414h
)}(h
}(h| Parameter	                          | Description	                                              | Default                                                                                                                                    |
|---|---|---|h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6f072cea-3817-437f-bb90-c92a8374e5c3h
)}(h
}(h| code_interpreter.allowed_modules	   | The list of allowed modules to import in code generation. | 	["pandas", "matplotlib", "numpy", "sklearn", "scipy", "seaborn", "datetime", "typing"], if the list is empty, no modules would be allowed |h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$71b68cd7-4888-4cb4-8a40-ddd4c74310b1h
)}(h
}(h| code_interpreter.blocked_functions	 | The list of functions to block from code generation.      | 	["_\_import__","eval", "exec", "execfile", "compile", "open", "input", "raw_input", "reload"]                                             |
h}(hj  hj  hKuhh	uh(hhh}h}(hj   hj  usub$34b291c2-c3e0-4523-a1f2-d2d6c72fab66h
)}(h
}(hX%  We currently support checking the allowed modules and blocked functions.
If a module is in the `allowed_modules` list, it can be imported in the generated code.
If a function is in the `blocked_functions` list, it cannot be used in the generated code.

## How is code verification implemented?h}(hj  hj  hKuhh	uh(hhh}h}(hj	  hj
  usub$87edce7e-9650-4893-b9a3-b255de42e495h
)}(h
}(hThe code verification is implemented in two parts.
First, we add instructions to CodeGenerator's prompt, so it generates code following the required rules.
For example, if we don't want the generated code to import the `os` module, h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$be079ab9-f670-4027-be8a-326881de4096h
)}(h
}(hX  we will add an instruction to the prompt to tell CodeGenerator not to import the `os` module.

Second, we conduct a static analysis on the generated code to check if it follows the required rules.
The code is parsed into an AST (Abstract Syntax Tree) and we check if the AST  h}(hj  hj  hK	uhh	uh(hhh}h}(hj  hj  usub$e8cad896-826d-4a15-a639-befb136dd881h
)}(h
}(honly imports the allowed modules, and does not use the blocked functions.
The implementation of the static analysis can be found in `taskweaver/code_interpreter/code_verification.py`.h}(hj  hj  hK
uhh	uh(hhh}h}(hj$  hj%  usub$b0336043-6f3e-47eb-83bd-7bee8ad0694bh
)}(h
}(hX   # Application

The `TaskWeaverApp` is the main class of the TaskWeaver library. It is the entry point for the library and is used to create and run tasks.
A `TaskWeaverApp` instance is created by calling the `TaskWeaverApp.__init__` constructor.

```pythonh}(happ.mdh
# ApplicationhK uhh	uh(hhh}h}(hj-  hj.  usub$990546af-cff9-4b74-b620-36433e0acc8fh
)}(h
}(hclass TaskWeaverApp(object):
    def __init__(
        self,
        app_dir: Optional[str] = None,
        use_local_uri: Optional[bool] = None,
        config: Optional[Dict[str, Any]] = None,
        **kwargs: Any,
    ) -> None:
        """h}(hj/  hj0  hKuhh	uh(hhh}h}(hj8  hj9  usub$b44adf15-f79d-4cae-8f84-da843093d65fh
)}(h
}(hX          Initialize the TaskWeaver app.
        :param app_dir: The project directory.
        :param use_local_uri: Whether to use local URI for artifacts.
        :param config: The configuration.
        :param kwargs: The additional arguments.
        """
```
h}(hj/  hj0  hKuhh	uh(hhh}h}(hjA  hjB  usub$3847b504-6324-4341-a95f-6528ffba3024h
)}(h
}(hX  The `app_dir` parameter is the path to the [project](project.md) directory. 
The `use_local_uri` parameter is a boolean that specifies whether to use local URIs for artifacts. 
If the artifacts are stored locally, the `use_local_uri` parameter should be set to `True`.h}(hj/  hj0  hKuhh	uh(hhh}h}(hjJ  hjK  usub$aa26ad00-cfcd-4512-a155-f86f58611fa4h
)}(h
}(hX?  This is useful if TaskWeaver is being used as a remote service and the artifacts are then remote URIs.
The `config` parameter is a dictionary that contains the configuration settings for the app.
Any settings in the `config` parameter will override existing settings in the configuration file or environment variables.
h}(hj/  hj0  hKuhh	uh(hhh}h}(hjS  hjT  usub$d18fdb0d-bba1-492a-b86c-695efa3f22ceh
)}(h
}(hThe `TaskWeaverApp` class has the following methods:

```python
def get_session(
    self,
    session_id: Optional[str] = None,
) -> Session:
    """
    Get the session. Return a new session if the session ID is not provided.h}(hj/  hj0  hKuhh	uh(hhh}h}(hj\  hj]  usub$8f4bb0d6-52c5-44c8-9aea-356de718d84eh
)}(h
}(h    :param session_id: The session ID.
    :return: The session.
    """
```

The `get_session` method is used to get a session. If the `session_id` parameter is not provided, a new session is created.h}(hj/  hj0  hKuhh	uh(hhh}h}(hje  hjf  usub$66eae80d-c4e0-4206-98a9-c38aa1ab969ch
)}(h
}(hX  A session is a conversation instance that the user has with the TaskWeaver app.
We shall discuss the `Session` class [later](session.md).

```python
def stop(self) -> None:
    """
    Stop the TaskWeaver app. This function must be called before the app exits.
    """
```
h}(hj/  hj0  hKuhh	uh(hhh}h}(hjn  hjo  usub$aecbdbf9-fc7c-490e-b87e-38dc1a79efc0h
)}(h
}(hThe `stop` method is used to stop the TaskWeaver app. This method must be called before the app exits.

An example of creating a `TaskWeaverApp` instance is shown below:

```python
from taskweaver.app.app import TaskWeaverApp
h}(hj/  hj0  hKuhh	uh(hhh}h}(hjw  hjx  usub$d48b40f3-1485-4891-bc25-05858b7ba39eh
)}(h
}(happ = TaskWeaverApp(app_dir="path/to/project/")
session = app.get_session()
round = session.send_message("Hello, how can I help you?")

print(round)
app.stop()
```
h}(hj/  hj0  hK	uhh	uh(hhh}h}(hj  hj  usub$bae1c825-1bff-46e9-a8a5-92e77b217c16h
)}(h
}(hIn this example, a `TaskWeaverApp` instance is created with the project directory set to `"path/to/project/"`.
A session is then created using the `get_session` method, and a message is sent to the session.h}(hj/  hj0  hK
uhh	uh(hhh}h}(hj  hj  usub$f808896d-1eb2-436c-934a-4c984072dbabh
)}(h
}(hThe response will be the entire conversation [round](round.md) that was generated by the TaskWeaver app.
Finally, the `stop` method is called to stop the TaskWeaver app.h}(hj/  hj0  hKuhh	uh(hhh}h}(hj  hj  usub$ef51a3db-b35c-4d61-8ef6-2f95561b0840h
)}(h
}(hX
  # Attachment

An attachment is a data concept in TaskWeaver which contains additional data other than the text message in the post.

```python
@dataclass
class Attachment:
    """Attachment is the unified interface for responses attached to the text massage.

    Args:h}(h
attachment.mdh# AttachmenthK uhh	uh(hhh}h}(hj  hj  usub$e66809a4-25d0-40c6-a27e-91866167df92h
)}(h
}(hX          type: the type of the attachment, which can be "thought", "code", "markdown", or "execution_result".
        content: the content of the response element.
        id: the unique id of the response element.
    """

    id: str
    type: AttachmentType
    content: strh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$8814ba83-b7c5-40b2-896c-aa5a5000551fh
)}(h
}(hX	      extra: Optional[Any] = None
```

`AttachmentType` is an Enum class that contains the types of the attachment, which can be "thought", "code", "markdown", or "execution_result".
Among the types, "board" is used to store the information in the board of the round.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$225d093a-8cc9-406d-b2fa-fa9a33c8eca3h
)}(h
}(hWhen the type is set to "board", the `content` will be updated to the key of the board.
`content` is the content of the response element, which can be the code snippet, the markdown text, or the execution result.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$41ee2a7c-44c1-4577-a439-d2f8ec0d58e7h
)}(h
}(hXD  # Conversation

A conversation is a data concept in TaskWeaver which contains a dialog between the user and the TaskWeaver app.
Each [session](session.md) has a corresponding conversation.

```python
@dataclass
class Conversation:
    """A conversation denotes the interaction with the user, which is a collection of rounds.h}(hconversation.mdh# ConversationhK uhh	uh(hhh}h}(hj  hj  usub$dd717060-ba5d-4658-90d0-4de80a54eb1dh
)}(h
}(hX4      The conversation is also used to construct the Examples.

    Args:
        id: the unique id of the conversation.
        rounds: a list of rounds.
        plugins: a list of plugins that are used in the conversation.
        enabled: whether the conversation is enabled, used for Example only.
    """
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0a284a9c-da6b-4944-b456-921c69537fceh
)}(h
}(h    id: str = ""
    rounds: List[Round] = field(default_factory=list)
    plugins: List[PluginEntry] = field(default_factory=list)
    roles: List[str] = field(default_factory=list)
    enabled: bool = True
```
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3152687c-1eb7-4ef9-bc81-776b5a836651h
)}(h
}(hA conversation is a collection of [rounds](round.md), where each round starts with the user's input and ends with the TaskWeaver app's response to the user.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$cc75eeba-dd33-4e6c-acc1-4fa9de0c333eh
)}(h
}(hX  The `plugins` are the [plugins](plugin.md) available in the conversation, and the `roles` are the [roles](role.md) that the conversation is associated with.

In TaskWeaver, the conversation is also used to store the [Examples](../customization/example/example.md).h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$2188b70a-5f0b-4b51-b1ce-e7d4856aa575h
)}(h
}(hThe examples in the project folder are parsed into Conversations in the memory, and then composed into the prompt
of the Planner or the CodeInterpreter.
The `enabled` flag is used to control if this conversation is presented in the prompt.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$84c7d92b-889a-401c-a070-055300df3a6eh
)}(h
}(hXH  # Plugin

Plugins are the user-defined functions that extend TaskWeaver CodeInterpreter's capabilities. 
More details about plugins can be found in the [Plugin Introduction](../customization/plugin/plugin_intro.md).
In TaskWeaver, the collection of available plugins are attached to the [Conversation](./conversation.md) object.h}(h	plugin.mdh# PluginhK uhh	uh(hhh}h}(hj  hj  usub$8611b6a0-1180-480f-a5a9-6b9764f7c591h
)}(h
}(hX  # Post

The post is a data concept in TaskWeaver which contains a single message in the conversation.

```python
@dataclass
class Post:
    """
    A post is the message used to communicate between two roles.
    It should always have a text_message to denote the string message,h}(hpost.mdh# PosthK uhh	uh(hhh}h}(hj	  hj	  usub$4f0d4deb-0e6e-4d6f-a0c1-322c6c6b6026h
)}(h
}(hX	      while other data formats should be put in the attachment.
    The role can be either a User, a Planner, or others.

    Args:
        id: the unique id of the post.
        send_from: the role who sends the post.
        send_to: the role who receives the post.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$a121f51c-6721-42db-b68f-e384dc6cd37eh
)}(h
}(h        message: the text message in the post.
        attachment_list: a list of attachments in the post.

    """

    id: str
    send_from: RoleName
    send_to: RoleName
    message: str
    attachment_list: List[Attachment]
```
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$329d947a-4538-4387-9982-e827d54851e2h
)}(h
}(hA post is the message used to communicate between two roles. It should always have a text `message` to denote the string message.
In addition, a post has `send_from` and `send_to` roles, which are the roles who send and receive the post, respectively.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj!	  hj"	  usub$d5316971-a943-427b-a0dc-4e9f438cb5edh
)}(h
}(hIn some cases, the `send_from` and `send_to` roles are the same, to denote the self-communication of the role.

The `attachment_list` is a list of [attachments](attachment.md) in the post. h}(hj	  hj	  hKuhh	uh(hhh}h}(hj*	  hj+	  usub$ca4e7a26-4112-4ca8-92d6-32c4e1eba605h
)}(h
}(hThe attachment is used to store various data other than the text message, such as the code snippet or an artifact file path.
An attachment may be used only by the role who sends the post, or it may be used by the role who receives the post.
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj3	  hj4	  usub$ca788559-69f8-47b4-b766-19c9b874d46ch
)}(h
}(hX  In usual cases, the `message` will present in the prompt as the past chat rounds. 
However, the message can sometimes be too long and should only be kept in the current round.
In the next round, the message will be deleted from the prompt to keep the prompt short.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj<	  hj=	  usub$020d67e2-002e-4412-b9a1-d8a8d9784019h
)}(h
}(hAs an example, the CodeInterpreter may generate a long execution result, which only needs to be kept in the current round.
In this case, we provide a way of annotating the message (or part of the message) to be kept in the current round only.

```pythonh}(hj	  hj	  hKuhh	uh(hhh}h}(hjE	  hjF	  usub$5d0374e5-9e5a-421c-adaa-c9afd2d7970dh
)}(h
}(hmessage = PromptUtil.wrap_text_with_delimiter(message, delimiter=PromptUtil.DELIMITER_TEMPORAL)
```

In this way, the message will be kept in the current round only, and will not be presented in the prompt since the next round.h}(hj	  hj	  hKuhh	uh(hhh}h}(hjN	  hjO	  usub$5ab07331-ed47-4d52-b8c7-418cc52c5182h
)}(h
}(hX4  # Project

A project folder is a directory that stores the configuration files, plugins, examples, logs, and workspace data.
A TaskWeaverApp instance is associated with a project folder. The project folder is created by the user and contains all the necessary files and folders for the TaskWeaverApp to run.
h}(h
project.mdh	# ProjecthK uhh	uh(hhh}h}(hjW	  hjX	  usub$3300cb81-04a5-4039-a7d8-34c0ec3213e9h
)}(h
}(hX  The following is a typical project directory structure:
```bash
📦project
 ┣ 📜taskweaver_config.json # the project configuration file for TaskWeaver
 ┣ 📂plugins # the folder to store plugins
 ┣ 📂planner_examples # the folder to store planner examplesh}(hjY	  hjZ	  hKuhh	uh(hhh}h}(hjb	  hjc	  usub$fd5be8e0-a473-4da6-8e0a-ffe76e8495efh
)}(h
}(hX   ┣ 📂codeinterpreter_examples # the folder to store code interpreter examples
 ┣ 📂logs # the folder to store logs, will be generated after program starts
 ┗ 📂workspace # the directory stores session data， will be generated after program starts
    ┗ 📂 session_id h}(hjY	  hjZ	  hKuhh	uh(hhh}h}(hjk	  hjl	  usub$24bad959-e684-4421-bbb7-76e23fe7585ch
)}(h
}(h      ┣ 📂ces # the folder used by the code execution service
      ┣ 📂cwd # the current working directory to run the generated code
      ┗ other session data
```
h}(hjY	  hjZ	  hKuhh	uh(hhh}h}(hjt	  hju	  usub$a23adadb-41f7-4154-9780-5a68124569d0h
)}(h
}(hThe `workspace` folder stores the session data, which includes the code execution service (CES) folder and the current working directory (CWD) folder.
Therefore, if the code execution results in any files, they will be stored in the CWD folder.h}(hjY	  hjZ	  hKuhh	uh(hhh}h}(hj}	  hj~	  usub$1d9fab5f-0a8c-4ed9-a93c-b77f84e0bf73h
)}(h
}(hIf you are running in `local` mode and want to load files from your local file system, the CWD is the base directory to load the files from.h}(hjY	  hjZ	  hKuhh	uh(hhh}h}(hj	  hj	  usub$7298f4d2-3c34-4be1-b870-33a6f5a9e5a6h
)}(h
}(hX  # Role

The role is a concept in TaskWeaver which represents the different roles in the conversation system.
The Planner and CodeInterpreter are two examples of roles in TaskWeaver.

```python
class Role:
    @inject
    def __init__(
        self,
        config: ModuleConfig,h}(hrole.mdh# RolehK uhh	uh(hhh}h}(hj	  hj	  usub$dad6e8de-cfc1-4d83-9be9-bf9c9d8bba6eh
)}(h
}(h        logger: TelemetryLogger,
        tracing: Tracing,
        event_emitter: SessionEventEmitter,
        role_entry: Optional[RoleEntry] = None,
    ):
        """
        The base class for all roles.
        """
```
:::infoh}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$5d4e956b-8731-4134-bfc5-a2315e485065h
)}(h
}(hWe use the `inject` decorator from the `injector` package to inject the dependencies into the role class.
:::

We allow adding extra roles into the system by inheriting the `Role` class and implementing the role inh}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$afde6af2-062d-4046-9043-278c424c3a3ah
)}(h
}(hthe `taskweaver.ext_role` module. We have provided examples on how to implement a new role.
A very simple example is the `Echo` role which echoes the user's message back to the user.
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$e83c63e1-65a1-40e6-b93b-dc441213b384h
)}(h
}(hA role should have at least two files: `role_name.py` and `role_name.role.yaml`. 
The files of the role should be put in the `taskweaver/ext_role/role_name` folder.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$e6f48fd5-b7d4-43af-bd70-7261519eb3c6h
)}(h
}(hX  We need to follow the convention of the role name, which is exactly the same as the folder name,
otherwise an exception will be raised.
We typically use the style of `snake_case` for the role name.

In the `role_name.role.yaml` file, we define the role's configuration. h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$ca6e84bb-db9c-4c61-99d1-397d82596f26h
)}(h
}(hThis following is `echo.role.yaml` of the `Echo` role configuration.

```yaml
alias: Echo
module: taskweaver.ext_role.echo.echo.Echo
intro : |-
  - Echo is responsible for echoing the user input.
```
The configuration file contains the following fields:h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$c1e203e1-efc4-4e33-aedb-9d853f219ee2h
)}(h
}(h- `alias`: the alias of the role, which is the name of role shown in the prompt and the conversation.
- `module`: the module path of the role class. TaskWeaver will import the module and instantiate the role class.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$4a54a6ea-c04f-40b0-8342-c8cd64e9b096h
)}(h
}(hX  - `intro`: the introduction of the role, which will be shown in Planner's prompt for choosing the role for certain tasks.

In the `role_name.py` file, we define the role class. The following is `echo.py` of the `Echo` role class.

```python
class EchoConfig(RoleConfig):h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$5a3be10e-29a6-4434-802e-dc1f2a229d81h
)}(h
}(hX*      def _configure(self):
        # configuration for the Echo role
        # can be configured in the project configuration file with `echo.decorator`
        self.decorator = self._get_str("decorator", "")

class Echo(Role):
    @inject
    def __init__(
        self,
        config: EchoConfig,h}(hj	  hj	  hK	uhh	uh(hhh}h}(hj	  hj	  usub$e06cf474-cf45-4358-be49-91e20652698dh
)}(h
}(hX          logger: TelemetryLogger,
        tracing: Tracing,
        event_emitter: SessionEventEmitter,
        role_entry: RoleEntry,
    ):
        # configuration for the parent class; this is required
        super().__init__(config, logger, tracing, event_emitter, role_entry)
h}(hj	  hj	  hK
uhh	uh(hhh}h}(hj	  hj	  usub$55441c17-c96c-4b97-bd35-ae8080c993d3h
)}(h
}(hX      def reply(self, memory: Memory, **kwargs) -> Post:
        rounds = memory.get_role_rounds(
            role=self.alias,
            include_failure_rounds=False,
        )

        # obtain the query from the last round
        last_post = rounds[-1].post_list[-1]
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$5b7411c4-20f4-425f-8285-9e5b5a67580dh
)}(h
}(hX6          post_proxy = self.event_emitter.create_post_proxy(self.alias)

        post_proxy.update_send_to(last_post.send_from)
        post_proxy.update_message(
            self.config.decorator +
            last_post.message +
            self.config.decorator
        )

        return post_proxy.end()
```
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj	  hj	  usub$98c8e762-5546-40cb-95da-49708f3ab176h
)}(h
}(hX  The role implementation should inherit the `Role` class and implement the `reply` method.
The above example demonstrates how to get the query from the last round.
The `reply` function of the Echo role is simply echoing the user's message back to the user with optional decoration.h}(hj	  hj	  hK
uhh	uh(hhh}h}(hj
  hj
  usub$69ec2a57-5cba-46ba-8437-a93a429c7431h
)}(h
}(hThe `reply` function should return a `Post` object, which is the response of the role to the user.

We provide facilities to help the role to interact with the memory, the event emitter, and the logger.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj
  hj
  usub$31424358-3391-4350-b8e0-68ca131e5d09h
)}(h
}(hX  For example, the `event_emitter.create_post_proxy` function is used to create a `PostProxy` object, which is a helper class to create a `Post` object.
The `PostProxy` object is used to update the `Post` object with the new message, send_to, and other attributes.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj
  hj
  usub$f4854ce4-326e-4e5e-8ff7-9cbc7823e24fh
)}(h
}(hOnce the `PostProxy` object is updated, the event emitter will send this event to a handler to display the event to a frontend.

To enable the role in TaskWeaver, we need to add the role configuration to the `taskweaver_config.json` file.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj!
  hj"
  usub$63072497-28d0-4d64-9373-78b082e43e22h
)}(h
}(hX  The following is an example of the `taskweaver_config.json` file with the `Echo` role configuration
in addition to the `Planner` and `CodeInterpreter` roles. Note that the name of the role should be 
the same as the folder name of the role, **not** the alias.
h}(hj	  hj	  hKuhh	uh(hhh}h}(hj*
  hj+
  usub$252a14cc-e397-463a-9abd-13873d47b5bch
)}(h
}(h```json
{
    "session.roles": ["planner", "echo", "code_interpreter"]
}
```

:::tip
**How to determine if I should create a new role? or implement a new plugin for the CodeInterpreter?**
The answer depends on the functionality you want to implement.h}(hj	  hj	  hKuhh	uh(hhh}h}(hj3
  hj4
  usub$262a5adb-e6e2-4c00-a877-50a3a4f68227h
)}(h
}(hX  If the functionality is to reply in text message given a user query, and you don't envision the need to process the reply text in code, 
you should create a new role.
In contrast, if the functionality is to process the user query and return the result in a structured format, h}(hj	  hj	  hKuhh	uh(hhh}h}(hj<
  hj=
  usub$ecd7c847-155f-4f54-a8dc-0984e45f3021h
)}(h
}(hvor if both input and output are in a structured format, you should implement a new plugin for the CodeInterpreter.
:::h}(hj	  hj	  hKuhh	uh(hhh}h}(hjE
  hjF
  usub$c346d148-cb4e-49d4-9e2f-81a643f94066h
)}(h
}(hX  # Round

A round is a data concept in TaskWeaver which contains a single round of chat between the user and the TaskWeaver app.

```python
@dataclass
class Round:
    """A round is the basic unit of conversation in the project, which is a collection of posts.

    Args:h}(hround.mdh# RoundhK uhh	uh(hhh}h}(hjN
  hjO
  usub$8a6af30b-2260-4ede-9b88-18bc7221da9bh
)}(h
}(h        id: the unique id of the round.
        post_list: a list of posts in the round.
        user_query: the query of the user.
        state: the state of the round.
        board: a dict to store the bulletin of the round.
    """

    id: strh}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hjY
  hjZ
  usub$b9c4b742-1691-4c02-b2b8-8a74295e5f78h
)}(h
}(h    user_query: str
    state: RoundState
    post_list: List[Post]
    board: Dict[str, str] = field(default_factory=dict)
```

`user_query` is the query of the user, and `post_list` is a list of [posts](post.md) in the round.h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hjb
  hjc
  usub$c16ad5e1-32b0-4a30-b5a9-b9fc222af8b8h
)}(h
}(hThe `state` is among "finished", "failed", "created". When the round is created, the state is "created".
When the round is finished successfully, the state is "finished". When the round is failed, the state is "failed".
h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hjk
  hjl
  usub$d25fe57b-839c-495b-b75c-361a489edf7ch
)}(h
}(hThe `board` is a dictionary to store the bulletin of the round, which can be used to store the information of the round.
This may sound confusing, given that different roles already have their messages in the posts. h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hjt
  hju
  usub$2d843d75-eff1-445f-a70b-5ddc7c3e3f8dh
)}(h
}(hX  However, the board is used to store critical information that must be aware of in the round context.
A very simple example would be the original user query. 
When the user issues a request to the Planner, the Planner will decompose the task and send a subtask to the CodeInterpreter.h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hj}
  hj~
  usub$746cfc33-a2cc-4765-b28d-6b14eeebca90h
)}(h
}(hX  However, the CodeInterpreter needs to know the original user query and the full plan of the Planner to provide a more accurate response.
In this case, the Planner can store the original user query in the board, and the CodeInterpreter can access it when needed.h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hj
  hj
  usub$da0e51db-2e8d-4be7-b49d-7dc00ce3e21fh
)}(h
}(hX  We provide two methods to access the board: `write_board` and `read_board`.

:::tip
The `board` is a dictionary, and you can store any information you want in the board for the current round.
This is useful to eliminate the issue of information loss between different roles.
:::h}(hjP
  hjQ
  hKuhh	uh(hhh}h}(hj
  hj
  usub$9a419895-a580-4ede-9d24-6233b532ab79h
)}(h
}(hX2  # Session

A session is a conversation instance that the user has with the TaskWeaver app.
A new session is created when the user interacts with the app.
When the user finishes interacting with the app, the session should be closed.
TaskWeaver allows multiple sessions to be created and managed by the app.h}(h
session.mdh	# SessionhK uhh	uh(hhh}h}(hj
  hj
  usub$950f2838-6262-40e3-a2bf-5732af82d0f9h
)}(h
}(hTherefore, multiple users can interact with the app at the same time in different sessions.

![sessions](../../static/img/sessions.png)

A new session is created by calling the `get_session` method of the `TaskWeaverApp` class.h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$b8281eba-bd10-458f-a3b9-75e675cfe6a8h
)}(h
}(hX
  In the background, the `get_session` method creates a new `Session` instance.
```python
class Session:
    @inject
    def __init__(
        self,
        session_id: str,
        workspace: Workspace,
        app_injector: Injector,
        logger: TelemetryLogger,h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$e2b4598f-c7ef-49bb-94f2-0c9a6ce5220ch
)}(h
}(hX           tracing: Tracing,
        config: AppSessionConfig,  
        role_registry: RoleRegistry,
    ) -> None:
        """
        Initialize the session.
        :param session_id: The session ID.
        :param workspace: The workspace.
        :param app_injector: The app injector.h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$0f4148f3-51d8-4943-a2ec-a92af0bfe458h
)}(h
}(hX          :param logger: The logger.
        :param tracing: The tracing.
        :param config: The configuration.
        :param role_registry: The role registry.
        """
```

:::info
In TaskWeaver, we use an `injector` to take care of most dependency injection.
:::
h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$dc71324e-2e5f-4635-8c4e-6c19308d3a02h
)}(h
}(hThe `Session` class has the following methods:

```python
def send_message(
    self,
    message: str,
    event_handler: Optional[SessionEventHandler] = None,
    files: Optional[List[Dict[Literal["name", "path", "content"], Any]]] = None,
) -> Round:h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$35088c06-7974-485a-848c-21e2f608581ah
)}(h
}(h    """
    Send a message.
    :param message: The message.
    :param event_handler: The event handler.
    :param files: The files.
    :return: The chat round.
    """
```
`send_message` is used to send a message to the app.h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$bfd50f33-9db1-4aa7-9315-1d803bcbce1fh
)}(h
}(hX   The `message` parameter is the text message that the user sends to the app.
The `event_handler` parameter is a function that handles events during the conversation.
We have defined a variety of events that can be handled by the event handler.
Each event has a specific type and a message.h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$911ba852-f37f-41fb-ac8a-842136706f80h
)}(h
}(hX(  By implementing the event handler, you can customize the display of events during the conversation.
A very simple example of an event handler is shown below:
```python
class ConsoleEventHandler(SessionEventHandler):
    def handle(self, event: TaskWeaverEvent):
        print(event.t, event.msg)
h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$6f4b2fa7-4158-4870-b48a-92fc29fdb535h
)}(h
}(hX+  session.send_message("Hello, how can I help you?", ConsoleEventHandler())
```
The `ConsoleEventHandler` class is a simple event handler that prints the event type and message to the console.

The `files` parameter is used to upload files to the app for processing.

```python
def stop(self) -> None:h}(hj
  hj
  hK	uhh	uh(hhh}h}(hj
  hj
  usub$72e7cb75-9c97-4f4d-a802-0c71c00cd6d3h
)}(h
}(hX      """
    Stop the session.
    This function must be called before the session exits.
    """
```
The `stop` method is used to stop the session.

```python
def update_session_var(
        self,
        variables: Dict[str, str]
):
    """
    Update the session variables.h}(hj
  hj
  hK
uhh	uh(hhh}h}(hj
  hj
  usub$7b84814a-79a8-433a-b2e8-14eaa8cba2c3h
)}(h
}(hX;      :param variables: The variables to update.
    """
```
The `update_session_var` method is used to update the session variables.
A session variable is a key-value pair that is only available in a specific session.
Session variables can be used in the plugins to store information that is specific to the session.h}(hj
  hj
  hKuhh	uh(hhh}h}(hj
  hj
  usub$38460f4f-868b-4a80-8724-77a88064a006h
)}(h
}(hX  For example, you can store different user names in the session variables of different sessions.
Then, in the plugin, you can access the user name by using the session variable.

```python
@register_plugin
class PluginClass(Plugin):

    def __call__(self, argument1: str):
        ...h}(hj
  hj
  hKuhh	uh(hhh}h}(hj  hj  usub$f91b9774-6fa3-41d8-b661-e5c97a72c0adh
)}(h
}(h        # this line of code in the plugin implementation
        self.ctx.get_session_var("user_name", "anonymous")
        ...
```

The `update_session_var` method can be called multiple times to update multiple session variables.h}(hj
  hj
  hK
uhh	uh(hhh}h}(hj  hj  usub$f6491d47-97f0-4b45-9866-c13d6cf91450h
)}(h
}(h# More about Configurations
More details about important configurations.

## Planner Configuration

- `planner.example_base_path`:	The folder to store planner examples. The default value is `${AppBaseDir}/planner_examples`. h}(hconfigurations_in_detail.mdh# More about ConfigurationshK uhh	uh(hhh}h}(hj  hj  usub$7e394e92-fb8a-4cac-afe1-0107225a8845h
)}(h
}(hIf you want to create your own planner examples, you can add them to this folder. More details about `example` can referred to [example](../customization/example/example.md).h}(hj  hj  hKuhh	uh(hhh}h}(hj#  hj$  usub$ab9ce301-2fbb-4fc4-a8cf-9bc620c936b6h
)}(h
}(hX	  - `planner.prompt_compression`: At times, lengthy conversations with the Planner may exceed the input limitations of the LLM model. 
To address this issue, we can compress the chat history and send it to the LLM model. The default value for this setting is `false`.h}(hj  hj  hKuhh	uh(hhh}h}(hj,  hj-  usub$51417fc4-ec85-4ae9-94b8-c2db05016a25h
)}(h
}(hMore details about `prompt_compression` can be referred to [prompt_compression](../advanced/compression).
- `planner.use_experience`: Whether to use experience summarized from the previous chat history in planner. The default value is `false`.h}(hj  hj  hKuhh	uh(hhh}h}(hj5  hj6  usub$916d489a-ba55-4710-9ab3-f0e607e60cc7h
)}(h
}(h- `planner.llm_alias`: The alias of the LLM used by the Planner. If you do not specify the LLM for the Planner, the primary LLM will be used by default.

## Session Configuration
h}(hj  hj  hKuhh	uh(hhh}h}(hj>  hj?  usub$19462d21-1c92-42ae-9e2d-044469d04bc1h
)}(h
}(h- `session.max_internal_chat_round_num`: the maximum number of internal chat rounds between Planner and Code Interpreter. 
  If the number of internal chat rounds exceeds this number, the session will be terminated. 
  The default value is `10`.h}(hj  hj  hKuhh	uh(hhh}h}(hjG  hjH  usub$fa1c3058-eb73-4418-9a89-167c75972465h
)}(h
}(h- `session.roles`: the roles included for the conversation. The default value is `["planner", "code_interpreter"]`.
  - TaskWeaver has 3 code interpreters: h}(hj  hj  hKuhh	uh(hhh}h}(hjP  hjQ  usub$2dd61864-0d2c-4acc-b694-72ce8adcaef3h
)}(h
}(h    - `code_interpreter`: it will generate Python code to fulfill the user's request. This is the default code interpreter.
    - `code_interpreter_plugin_only`: please refer to [plugin_only_mode](../advanced/plugin_only.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hjY  hjZ  usub$94c6b832-0ca1-4312-af71-456715b08682h
)}(h
}(h    - `code_interpreter_cli_only`: allow users to directly communicate with the Command Line Interface (CLI) in natural language. 
      Please refer to [cli_only_mode](../advanced/cli_only.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hjb  hjc  usub$6a4ecf45-cbb2-48a7-ac58-16880df41bfbh
)}(h
}(h  - If you do not specify `planner` in the roles, you will enter the "no-planner" mode. 
    It allows users to directly communicate with the worker role, such as `code_interpreter`.h}(hj  hj  hK	uhh	uh(hhh}h}(hjk  hjl  usub$dbea63fa-fbc6-4109-a29b-827059408fbbh
)}(h
}(hX      In this mode, users can only send messages to the `CodeInterpreter` and receive messages from the `CodeInterpreter`.
    Note that only single worker role is allowed in the "no-planner" mode because all user requests will be sent to the worker role directly.
    Here is an example:
h}(hj  hj  hK
uhh	uh(hhh}h}(hjt  hju  usub$eb729900-4721-45aa-84aa-3873347c3059h
)}(h
}(h    ``````bash
     =========================================================
     ___         _     _       __
    |_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hj  hj  hKuhh	uh(hhh}h}(hj}  hj~  usub$d0e176f7-3b91-46b4-a3f4-04ce644ed4bch
)}(h
}(hw      | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
      | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$df2a7855-741d-4551-84a9-fdae6bf15b98h
)}(h
}(hX        |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
    =========================================================
    TaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
    Human: generate 10 random numbersh}(hj  hj  hK
uhh	uh(hhh}h}(hj  hj  usub$1b025dab-4206-4185-b8d5-f06a9ef120e1h
)}(h
}(hX      >>> [PYTHON]Starting... 
    import numpy as np
    random_numbers = np.random.rand(10)
    random_numbers
    >>> [VERIFICATION]
    NONE
    >>> [STATUS]Starting...         
    SUCCESS
    >>> [RESULT]
    The execution of the generated python code above has succeeded
    h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0aac4f44-f178-463b-82e5-22f6571b38ebh
)}(h
}(h~    The result of above Python code after execution is:
    array([0.09918602, 0.68732778, 0.44413814, 0.4756623 , 0.48302334,h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$97c95f9b-b468-4a4e-80b0-b39fe081fd2ah
)}(h
}(h           0.8286594 , 0.80994359, 0.35677263, 0.45719317, 0.68240194])
    >>> [CODEINTERPRETER->PLANNER]
    The following python code has been executed:
    ```python
    import numpy as nph}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ec921d20-3271-4b74-8cd8-9d4cdc7487fdh
)}(h
}(h    random_numbers = np.random.rand(10)
    random_numbers
    ```
    
    The execution of the generated python code above has succeeded
    
    The result of above Python code after execution is:h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6a97584c-9fec-4f8e-914a-d5c9e697107dh
)}(h
}(hF    array([0.09918602, 0.68732778, 0.44413814, 0.4756623 , 0.48302334,h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$94d3af26-d00d-4026-91a0-5466018a47feh
)}(h
}(h           0.8286594 , 0.80994359, 0.35677263, 0.45719317, 0.68240194])
    TaskWeaver: The following python code has been executed:
    ```python
    import numpy as nph}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f37479e5-8bc1-42c1-acb4-f015235ac391h
)}(h
}(h    random_numbers = np.random.rand(10)
    random_numbers
    ```
  
    The execution of the generated python code above has succeeded
    
    The result of above Python code after execution is:h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$83839d62-801e-4945-979c-cd2702a1d4a8h
)}(h
}(hF    array([0.09918602, 0.68732778, 0.44413814, 0.4756623 , 0.48302334,h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$1cb5a0ae-8b26-4416-ba81-2a9a1987b0edh
)}(h
}(h           0.8286594 , 0.80994359, 0.35677263, 0.45719317, 0.68240194])
    ``````

## Embedding Configuration

In TaskWeaver, we support various embedding models to generate embeddings for auto plugin selection.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$186b883c-1805-48ef-a95b-c14c986b3d38h
)}(h
}(h- `llm.embedding_api_type`: The type of the embedding API. We support the following types:
  - openai
  - qwen
  - ollama
  - sentence_transformers
  - glm
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$a4abbfc2-7ab4-4faa-97e6-addb8d7bd8dch
)}(h
}(h- `llm.embedding_model`: The embedding model name. The model name should be aligned with `llm.embedding_api_type`.
   We only list some embedding models we have tested below:
  - openai
    - text-embedding-ada-002
  - qwen
    - text-embedding-v1h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$59b74cc3-b983-4ca3-b93e-d75223f1d258h
)}(h
}(h  - ollama
    - llama2
  - sentence_transformers
    - all-mpnet-base-v2
    - multi-qa-mpnet-base-dot-v1
    - all-distilroberta-v1
    - all-MiniLM-L12-v2h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$663c6b31-774c-4679-ac77-3d4bbd91e188h
)}(h
}(h    - multi-qa-MiniLM-L6-cos-v1
  - zhipuai
    - embedding-2
You also can use other embedding models supported by the above embedding APIs.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$dfb12fd5-d1ce-40b2-83e8-4e03a01db788h
)}(h
}(h# Configuration File

An overview of all configurations available in the config file, which is located at `project/taskweaver_config.json`.
You can edit this file to configure TaskWeaver.
:::tiph}(hoverview.mdh# Configuration FilehK uhh	uh(hhh}h}(hj
  hj  usub$234c964b-711d-4fe2-a467-636a3b03bba9h
)}(h
}(hThe configuration file is in JSON format. So for boolean values, use `true` or `false` instead of `True` or `False`.
For null values, use `null` instead of `None` or `"null"`. All other values should be strings in double quotes.
:::h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9b13ee18-232b-413d-9e0c-2d2809054072h
)}(h
}(hX  The following table lists the parameters in the configuration file:

| Parameter                                     | Description                                                                            | Default Value                                                                                                                               |
|---|---|---|
| `llm.model`                                   | The model name used by the language model.                                             | gpt-4                                                                                                                                       |h}(hj  hj  hKuhh	uh(hhh}h}(hj!  hj"  usub$ed188ba2-9a7e-4d30-bb7e-736dd6cfb30bh
)}(h
}(hX1  | `llm.api_base`                                | The base URL of the OpenAI API.                                                        | `https://api.openai.com/v1`                                                                                                                 |
| `llm.api_key`                                 | The API key of the OpenAI API.                                                         | `null`                                                                                                                                      |h}(hj  hj  hKuhh	uh(hhh}h}(hj*  hj+  usub$af26555f-7709-472d-bbc4-bffb5a059649h
)}(h
}(hX  | `llm.api_type`                                | The type of the OpenAI API, could be `openai` or `azure`.                              | `openai`                                                                                                                                    |h}(hj  hj  hKuhh	uh(hhh}h}(hj3  hj4  usub$3085ea0f-09bb-4afc-bb59-02fa2f846e91h
)}(h
}(hX  | `llm.api_version`                             | The version of the OpenAI API.                                                         | `2023-07-01-preview`                                                                                                                        |h}(hj  hj  hKuhh	uh(hhh}h}(hj<  hj=  usub$0cf7ed71-4037-4844-a58b-af0ee2a9a2c0h
)}(h
}(hX  | `llm.response_format`                         | The response format of the OpenAI API, could be `json_object`, `text` or `null`.       | `json_object`                                                                                                                               |h}(hj  hj  hKuhh	uh(hhh}h}(hjE  hjF  usub$3030968a-027e-4e39-b0f6-fb37568978b3h
)}(h
}(hX1  | `llm.embedding_api_type`                      | The type of the embedding API                                                          | `sentence_transformers`                                                                                                                     |
| `llm.embedding_model`                         | The name of the embedding model                                                        | `all-mpnet-base-v2`                                                                                                                         |h}(hj  hj  hKuhh	uh(hhh}h}(hjN  hjO  usub$5e9875fb-5528-4730-8935-1f54a0f96722h
)}(h
}(hX  | `code_interpreter.code_verification_on`       | Whether to enable code verification.                                                   | `false`                                                                                                                                     |h}(hj  hj  hKuhh	uh(hhh}h}(hjW  hjX  usub$1c641db6-9732-4ae2-a753-b89a6e8b00e1h
)}(h
}(hX  | `code_interpreter.allowed_modules`            | The list of allowed modules to import in code generation.                              | `["pandas", "matplotlib", "numpy", "sklearn", "scipy", "seaborn", "datetime", "typing"]`, if the list is empty, no modules would be allowed |h}(hj  hj  hK	uhh	uh(hhh}h}(hj`  hja  usub$c30636b3-678d-48af-aedd-b9e6b683a16ch
)}(h
}(hX  | `code_interpreter.blocked_functions`          | The list of functions to block from code generation.                                   | `["__import__", "eval", "exec", "execfile", "compile", "open", "input", "raw_input", "reload"]`                                             |h}(hj  hj  hK
uhh	uh(hhh}h}(hji  hjj  usub$b8fa57e9-ee37-4dd8-acec-eb53c13cd9d8h
)}(h
}(hX1  | `logging.log_file`                            | The name of the log file.                                                              | `taskweaver.log`                                                                                                                            |
| `logging.log_folder`                          | The folder to store the log file.                                                      | `logs`                                                                                                                                      |h}(hj  hj  hKuhh	uh(hhh}h}(hjr  hjs  usub$899eb736-5aab-4b81-b7c8-7cafb8902e38h
)}(h
}(hX1  | `plugin.base_path`                            | The folder to store plugins.                                                           | `${AppBaseDir}/plugins`                                                                                                                     |
| `planner.example_base_path`                   | The folder to store planner examples.                                                  | `${AppBaseDir}/planner_examples`                                                                                                            |h}(hj  hj  hKuhh	uh(hhh}h}(hj{  hj|  usub$b75d24ef-b021-417b-b6e5-060ec9c7d4b5h
)}(h
}(hX2  | `planner.prompt_compression`                  | Whether to compress the chat history for planner.                                      | `false`                                                                                                                                     | 
| `planner.use_experience`                      | Whether to use experience summarized from the previous chat history in planner.        | `false`                                                                                                                                     |h}(hj  hj  hK
uhh	uh(hhh}h}(hj  hj  usub$50b78ec4-24f1-4c69-b397-f19939235a2ch
)}(h
}(hX1  | `code_generator.example_base_path`            | The folder to store code interpreter examples.                                         | `${AppBaseDir}/codeinterpreter_examples`                                                                                                    |
| `code_generator.prompt_compression`           | Whether to compress the chat history for code interpreter.                             | `false`                                                                                                                                     |h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ec16f16c-09e5-4fed-8243-b5293ded538ch
)}(h
}(hXG  | `code_generator.enable_auto_plugin_selection` | Whether to enable auto plugin selection.                                               | `false`                                                                                                                                     |
| `code_generator.use_experience`               | Whether to use experience summarized from the previous chat history in code generator. | `false`                                                                                                                                     |                      h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$4ab897d7-d342-4841-a29d-ba6fa8d9047fh
)}(h
}(hX1  | `code_generator.auto_plugin_selection_topk`   | The number of auto selected plugins in each round.                                     | `3`                                                                                                                                         |
| `session.max_internal_chat_round_num`         | The maximum number of internal chat rounds between Planner and Code Interpreter.       | `10`                                                                                                                                        |j      h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$d0566684-1ebb-42a8-8347-4407903bd409h
)}(h
}(hX1  | `session.roles`                               | The roles included for the conversation.                                               | ["planner", "code_interpreter"]                                                                                                             |
| `round_compressor.rounds_to_compress`         | The number of rounds to compress.                                                      | `2`                                                                                                                                         |h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$bd756519-ba72-4473-a84e-a794035802fch
)}(h
}(hX9  | `round_compressor.rounds_to_retain`           | The number of rounds to retain.                                                        | `3`                                                                                                                                         |
| `execution_service.kernel_mode`               | The mode of the code executor, could be `local` or `container`.                        | `local`                                                                                                                                     |

:::tiph}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b4333273-fec2-436d-aca8-d8f7672779a5h
)}(h
}(h$\{AppBaseDir\} is the project directory.
:::

:::tip
Up to 11/30/2023, the `json_object` and `text` options of `llm.response_format` is only supported by the OpenAIh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ad78394a-0e2c-487b-93ba-c300a60339b6h
)}(h
}(hmodels later than 1106. If you are using an older version of OpenAI model, you need to set the `llm.response_format`
to `null`.
:::

:::tiph}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$32c62efc-bdc9-47e2-90fa-60b039efe05eh
)}(h
}(hX-  Read [this](../advanced/compression.md) for more information for `planner.prompt_compression` and `code_generator.prompt_compression`.
:::

:::tip
We support to set configurations via environment variables. You need to transform the configuration key to uppercase and replace the dot with underscore. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9fa70341-7e7a-4f33-89f7-81ae02dbe35dh
)}(h
}(hoFor example, `llm.model` should be set as `LLM_MODEL`, `llm.api_base` should be set as `LLM_API_BASE`, etc.
:::h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$266fd7a8-16c8-464f-b948-9d99cde6d051h
)}(h
}(hX  # Experience

## Motivation
The agent developers can add examples to guide the planning and code generation. 
Alternatively, we also provide another way of saving user experiences to long-term memory. 
In practice, if the user asks TaskWeaver to solve a hard problem. h}(h
experience.mdh# ExperiencehK uhh	uh(hhh}h}(hj  hj  usub$56e381b9-335f-4857-a839-4ca14d2e6dc6h
)}(h
}(hX  TaskWeaver can first go wrong. But after several attempts or the user gives more instructions, 
the agent can finally solve the problem. However, next time, if the user asks a similar problem 
or even exactly the same problem. The agent is still hard to come up with the right solution h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$a92551c4-a9c8-4ceb-a33f-de3e89498b15h
)}(h
}(hX  at first because it does not memorize the experiences.  Therefore, we proposed a mechanism called experience memory. 
Here is the basic idea. A user can issue a command to TaskWeaver to save chat history and 
then extract experience tips from it and save them into the experience pool. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$01e80e7d-f9fa-4823-8b2a-d36ab337b193h
)}(h
}(hXD  Later, when the agent sees similar requests, it will retrieve the experience from the memory 
to guide its planning and code generation.
An experience tip is about what should do or should not do when seeing a request like this.
We will add the retrieved experiences to the prompt when received a similar request afterward.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$2dfd1b8a-3215-4034-a76e-e60846de0793h
)}(h
}(hX  ![Save User Experience](../../static/img/experience.png)

## How to use experience memory

1. To enable the experience feature, you only need to set the `planner.use_experience` and `code_generator.use_experience` parameter in the configuration file to `true`.h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$b941347a-dbe2-4dba-b269-0db3a0e342aah
)}(h
}(h2. Start a new conversation with TaskWeaver. You will find `experience` directory is created in your project directory. Note that there is no experience now because we have not saved any chat history yet.h}(hj  hj  hKuhh	uh(hhh}h}(hj

  hj
  usub$a7202722-a40c-4ffd-9a8e-62f4e3fa6322h
)}(h
}(h3. If you think the current chat history is worth saving, you can save it by typing command `/save` and you will find a new file named `raw_exp_{session_id}.yaml` is created in the `experience` directory. h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$6b3ba3ae-533e-4840-a84e-a499fa0a6ca8h
)}(h
}(hXG  4. Restart TaskWeaver and start a new conversation. In the initialization stage, TaskWeaver will read the `raw_exp_{session_id}.yaml` file and make a summarization in a new file named `All_exp_{session_id}.yaml`. This process may take a while. `All_` denotes that this experience will be loaded for Planner and CodeInterpreter.h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj 
  usub$1f0e03f0-f702-44f7-9571-e9a3fdc58815h
)}(h
}(hX  5. When user send a similar query to TaskWeaver, it will retrieve the relevant experience and load it into the system prompt (for Planner and CodeInterpreter). In this way, the experience can be used to guide the future conversation.

## A walk-through example
h}(hj  hj  hKuhh	uh(hhh}h}(hj(
  hj)
  usub$74d50c5c-798c-4f56-a8b9-9d9edda3c950h
)}(h
}(h1. Start a new conversation with TaskWeaver. Send a request "calculate the mean value of ./project/sample_data/data_demo.csv" to TaskWeaver.
2. You will find TaskWeaver made a mistake, calculating the mean value of the non-numerical column. h}(hj  hj  hK	uhh	uh(hhh}h}(hj1
  hj2
  usub$e65a7af8-caab-4b30-ac8a-ed1f286fe220h
)}(h
}(hAfter several attempts, TaskWeaver fixed this issue.
```
=========================================================
 ___         _     _       __
|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hj  hj  hK
uhh	uh(hhh}h}(hj:
  hj;
  usub$2d0f63dd-49d3-48b7-a6ea-d540a3a4ca08h
)}(h
}(ho  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hj  hj  hKuhh	uh(hhh}h}(hjC
  hjD
  usub$1ff52ed3-e25a-4d81-b98a-db9374c11981h
)}(h
}(h  |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================
 TaskWeaver ▶  I am TaskWeaver, an AI assistant. To get started, could you please enter your request?h}(hj  hj  hKuhh	uh(hhh}h}(hjL
  hjM
  usub$1772f40c-cfc1-4b9e-87d4-bb035c73079bh
)}(h
}(h    Human   ▶   calculate the mean value of d:/demo_data.csv
 ╭───< Planner >
 ├─► [init_plan]
 │   1. load the data file
 │   2. calculate the mean value of the loaded data <sequentially depends on 1>h}(hj  hj  hK
uhh	uh(hhh}h}(hjU
  hjV
  usub$fecf75a7-d382-4fea-aee5-f87a68d02da3h
)}(h
}(h │   3. report the result to the user <interactively depends on 2>
 ├─► [plan]
 │   1. instruct CodeInterpreter to load the data file and calculate the mean value of the loaded data
 │   2. report the result to the userh}(hj  hj  hKuhh	uh(hhh}h}(hj^
  hj_
  usub$c649e4a1-9c78-4c63-a5c7-ca4c5e359173h
)}(h
}(hX   ├─► [current_plan_step] 1. instruct CodeInterpreter to load the data file and calculate the mean value of the loaded data
 ├──● Please load the data file d:/demo_data.csv and calculate the mean value of the loaded data
 ╰──● sending message to CodeInterpreterh}(hj  hj  hKuhh	uh(hhh}h}(hjg
  hjh
  usub$544d3d3a-e094-4011-82ca-17025e0063a3h
)}(h
}(h ╭───< CodeInterpreter >
 ├─► [thought] ProgramApe will generate a code snippet to load the data file d:/demo_data.csv and calculate the mean value of the loaded data using pandas.
 ├─► [python]
 │   import pandas as pd
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hjp
  hjq
  usub$2ad04c77-e3d6-4180-bd74-2c5481125016h
)}(h
}(h │   data_file_path = "d:/demo_data.csv"
 │   data_df = pd.read_csv(data_file_path)
 │   mean_value = data_df.mean()
 │   mean_value
 ├─► [verification] NONE
 ├─► [code_error] No code verification is performed.h}(hj  hj  hKuhh	uh(hhh}h}(hjy
  hjz
  usub$2a59bb24-917a-4428-b293-cd95d2daa9a3h
)}(h
}(hX   ├─► [execution_status] FAILURE
 ├─► [execution_result]
 │   The execution of the generated python code above has failed
 │   
 │   During execution, the following messages were logged:
 │   Traceback (most recent call last):
 │   
 │     Cell In[1], line 5h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$a88bab23-149c-40e0-a6df-b106324d143ch
)}(h
}(h │       mean_value = data_df.mean()
 │   
 │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11335 in mean
 │       result = super().mean(axis, skipna, numeric_only, **kwargs)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$4fe3ea68-9c86-4280-b91c-05ef9080de99h
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\generic.py:11984 in mean
 │       return self._stat_function(
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$00d87e5d-ccb3-4e14-82bd-4f1b6b2d7506h
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\generic.py:11941 in _stat_function
 │       return self._reduce(
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$5401abf9-ef21-4002-91d6-12c81a07583dh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11204 in _reduce
 │       res = df._mgr.reduce(blk_func)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$928e9ed4-29bf-4872-b56a-408a45a8825dh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\internals\managers.py:1459 in reduce
 │       nbs = blk.reduce(func)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$60ae12b1-1e38-485d-b63c-0704b89e36cbh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\internals\blocks.py:377 in reduce
 │       result = func(self.values)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$ad129cd0-92cd-465d-bd6e-e3f846a6cc8eh
)}(h
}(hX   │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11136 in blk_func
 │       ret
 │   
 ├─► [artifact_paths] []
 ├──● The following python code has been executed:
 │   ```python
 │   import pandas as pdh}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$acd91c29-5e25-495d-981d-7439766b7a23h
)}(h
}(h │   
 │   data_file_path = "d:/demo_data.csv"
 │   data_df = pd.read_csv(data_file_path)
 │   mean_value = data_df.mean()
 │   mean_value
 │   ```
 │   
 │   
 │   The execution of the generated python code above has failed
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$71f42d2b-3947-46b2-aef9-bb2618f40990h
)}(h
}(h │   During execution, the following messages were logged:
 │   Traceback (most recent call last):
 │   
 │     Cell In[1], line 5
 │       mean_value = data_df.mean()
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$a77346f5-8cdc-49bd-98ff-ae6fb370b51dh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11335 in mean
 │       result = super().mean(axis, skipna, numeric_only, **kwargs)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$51550084-9d33-492f-90fb-2579e97b0a6ah
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\generic.py:11984 in mean
 │       return self._stat_function(
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$ef136e82-6e04-4ecd-8a52-123d5551dfbeh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\generic.py:11941 in _stat_function
 │       return self._reduce(
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$d2319c48-7afc-44ed-b02c-a04519951ec9h
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11204 in _reduce
 │       res = df._mgr.reduce(blk_func)
 │   h}(hj  hj  hKuhh	uh(hhh}h}(hj
  hj
  usub$e256a95b-93a0-42ab-8e7d-33471663783fh
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\internals\managers.py:1459 in reduce
 │       nbs = blk.reduce(func)
 │   h}(hj  hj  hK uhh	uh(hhh}h}(hj   hj  usub$e6e38457-9765-49e1-a738-21e0fecbbb88h
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\internals\blocks.py:377 in reduce
 │       result = func(self.values)
 │   h}(hj  hj  hK!uhh	uh(hhh}h}(hj	  hj
  usub$4f6b5d29-9937-4fc3-a2aa-4ed8db314970h
)}(h
}(h │     File D:\python_project\Octopus\venv\Lib\site-packages\pandas\core\frame.py:11136 in blk_func
 │       ret
 │   
 ├─► [revise_message]h}(hj  hj  hK"uhh	uh(hhh}h}(hj  hj  usub$08711acd-d3f2-4986-9a83-c230d5d9cbadh
)}(h
}(hX(   │   The execution of the previous generated code has failed. If you think you can fix the problem by rewriting the code, please generate code and run it again.
 │   Otherwise, please explain the problem to me.
 ╰──● sending message to CodeInterpreter
 ╭───< CodeInterpreter >h}(hj  hj  hK#uhh	uh(hhh}h}(hj  hj  usub$308ae4c0-85f6-4816-ab27-fed3286a6bedh
)}(h
}(hX   ├─► [thought] ProgramApe will generate a code snippet to load the data file d:/demo_data.csv and calculate the mean value of the loaded data using pandas, considering the execution 
 │   error.
 ├─► [python]
 │   import pandas as pd
 │   h}(hj  hj  hK$uhh	uh(hhh}h}(hj$  hj%  usub$84e271cd-48ac-4c26-afde-c8c61110bf8ah
)}(h
}(h │   data_file_path = "d:/demo_data.csv"
 │   data_df = pd.read_csv(data_file_path)
 │   mean_value = data_df.mean(axis=0, numeric_only=True)
 │   mean_value
 ├─► [verification] NONEh}(hj  hj  hK%uhh	uh(hhh}h}(hj-  hj.  usub$934a2729-2845-4128-ba48-9d2273c6cb85h
)}(h
}(hX    ├─► [code_error] No code verification is performed.
 ├─► [execution_status] SUCCESS
 ├─► [execution_result]
 │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:
 │   Count    78172.75h}(hj  hj  hK&uhh	uh(hhh}h}(hj6  hj7  usub$ea9597cd-fcfc-4df2-b12f-ba394ed4ed76h
)}(h
}(h │   dtype: float64
 ├─► [artifact_paths] []
 ├──● The following python code has been executed:
 │   ```python
 │   import pandas as pd
 │   
 │   data_file_path = "d:/demo_data.csv"
 │   data_df = pd.read_csv(data_file_path)h}(hj  hj  hK'uhh	uh(hhh}h}(hj?  hj@  usub$71d90551-c2d2-46bd-a4f1-e7555b369f74h
)}(h
}(hX
   │   mean_value = data_df.mean(axis=0, numeric_only=True)
 │   mean_value
 │   ```
 │   
 │   
 │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:
 │   Count    78172.75h}(hj  hj  hK(uhh	uh(hhh}h}(hjH  hjI  usub$48c29543-f3fe-478e-b2de-1bf31e2b23efh
)}(h
}(h │   dtype: float64
 ╰──● sending message to Planner
 ╭───< Planner >
 ├─► [init_plan]
 │   1. load the data file
 │   2. calculate the mean value of the loaded data <sequentially depends on 1>h}(hj  hj  hK)uhh	uh(hhh}h}(hjQ  hjR  usub$3f2b8b56-08e2-4046-97a7-5e52954e27ceh
)}(h
}(h │   3. report the result to the user <interactively depends on 2>
 ├─► [plan]
 │   1. instruct CodeInterpreter to load the data file and calculate the mean value of the loaded data
 │   2. report the result to the userh}(hj  hj  hK*uhh	uh(hhh}h}(hjZ  hj[  usub$ec752db6-7b49-454c-a453-d1d1f17f4858h
)}(h
}(h ├─► [current_plan_step] 2. report the result to the user
 ├──● The mean value of the data in d:/demo_data.csv is 78172.75
 ╰──● sending message to Userh}(hj  hj  hK+uhh	uh(hhh}h}(hjc  hjd  usub$7e29bf7f-908d-4784-bcef-86e87cd0fd10h
)}(h
}(h TaskWeaver ▶  The mean value of the data in d:/demo_data.csv is 78172.75
```
3. We can issue the `/save` command from the console chat interface to save the chat history. Then, after we restart TaskWeaver, h}(hj  hj  hK,uhh	uh(hhh}h}(hjl  hjm  usub$79bd71c4-ca78-464c-84e9-6b6e37ae41a6h
)}(h
}(hwe can see the experience summarized from the last chat history is below:
```yaml
exp_id: 20231228-073922-9b411afd
experience_text: "User Query: get the mean value of d:/demo_data.csv
  Error Resolution:h}(hj  hj  hK-uhh	uh(hhh}h}(hju  hjv  usub$a4bb7560-81f2-452f-b8c4-df14b95da722h
)}(h
}(hX    - Error 1: The initial code failed to execute because it tried to calculate the mean value of all columns, including non-numeric columns.
  - Resolution 1: The code was revised to check for non-numeric columns and only calculate the mean value for numeric columns.
  Preferences:h}(hj  hj  hK.uhh	uh(hhh}h}(hj~  hj  usub$b74513a6-d11d-4e56-974d-68f3cf9b4e65h
)}(h
}(h  - Preference 1: The user prefers to calculate the mean value of the "Count" column in the data."
raw_experience_path: D:\project\experience\raw_exp_20231228-073922-9b411afd.yaml
embedding_model: text-embedding-ada-002
embedding: ...
```h}(hj  hj  hK/uhh	uh(hhh}h}(hj  hj  usub$69d478da-d932-4c62-a1d0-91798a192713h
)}(h
}(hXV  4. Send a similar request "calculate the variance value of ./project/sample_data/data_demo.csv" to TaskWeaver. You will find TaskWeaver will not make the same mistake again. It will ask User to confirm the column name to calculate the variance value.
```
=========================================================
 ___         _     _       __h}(hj  hj  hK0uhh	uh(hhh}h}(hj  hj  usub$0fad71ae-eaad-46f0-9056-13311d9847e9h
)}(h
}(hn|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___
  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/h}(hj  hj  hK1uhh	uh(hhh}h}(hj  hj  usub$034938c2-ba8e-4712-b8ad-ab46c2694c7ch
)}(h
}(h  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /
  |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================h}(hj  hj  hK2uhh	uh(hhh}h}(hj  hj  usub$a36b9bd8-1960-4fca-a690-759e8375791fh
)}(h
}(h TaskWeaver ▶  I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
    Human   ▶  calculate the variance value of d:/demo_data.csv
 ╭───< Planner >TaskWeaver] preparing     <=�=>     h}(hj  hj  hK3uhh	uh(hhh}h}(hj  hj  usub$23a3307b-2ff0-4e72-80f6-163c42c411d6h
)}(h
}(h ├─► [init_plan]
 │   1. load the data file
 │   2. confirm the columns to calculate variance <interactively depends on 1>
 │   3. calculate the variance value for the selected columns <sequentially depends on 2>h}(hj  hj  hK4uhh	uh(hhh}h}(hj  hj  usub$e84daca4-0a1e-4139-91e3-d70b3bb92b61h
)}(h
}(h │   4. report the result to the user <interactively depends on 3>
 ├─► [plan] ▶ [Planner][plan] 1. instruct CodeInterpreter to load the data file 2. confirm the columns to calcu    <=�=>      h}(hj  hj  hK5uhh	uh(hhh}h}(hj  hj  usub$43ba2fc9-581d-49d7-9487-45df18666017h
)}(h
}(h │   1. instruct CodeInterpreter to load the data file
 │   2. confirm the columns to calculate variance
 ├─► [current_plan_step] 1. instruct CodeInterpreter to load the data file load the data file        <=�=>  h}(hj  hj  hK6uhh	uh(hhh}h}(hj  hj  usub$08a7a970-9427-4b90-9c95-26ae2354a27fh
)}(h
}(h ├──● Please load the data file d:/demo_data.csva file d:/demo_dat <=�=>         
 ╰──● sending message to CodeInterpreter
 ╭───< CodeInterpreter >h}(hj  hj  hK7uhh	uh(hhh}h}(hj  hj  usub$e49058f8-2129-46b9-a7e1-ef0fa4f4b0b3h
)}(h
}(h ├─► [thought] ProgramApe will generate a code snippet to load the data file d:/demo_data.csv using pandas.demo_data.csv using panda     <=�=>     h}(hj  hj  hK8uhh	uh(hhh}h}(hj  hj  usub$ce89e9cb-ef29-4336-930f-ee4467dba00eh
)}(h
}(h ├─► [python]▶ [CodeInterpreter][python] import pandas as pd  data_file_path = "d:/demo_data.csv" df = pd.read_csv(data_fil      <=�=>    
 │   import pandas as pd
 │   
 │   data_file_path = "d:/demo_data.csv"h}(hj  hj  hK9uhh	uh(hhh}h}(hj  hj  usub$1ab191ce-8a69-4d83-8f19-4da7ef525c3bh
)}(h
}(h │   df = pd.read_csv(data_file_path)
 │   df
 ├─► [verification] NONE
 ├─► [code_error] No code verification is performed.
 ├─► [execution_status] SUCCESS] executing code       <=�=>   
 ├─► [execution_result]h}(hj  hj  hK:uhh	uh(hhh}h}(hj  hj  usub$6e3b7db2-1db3-4cb7-91f9-b137f89fdd83h
)}(h
}(h │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:
 │                  TimeBucket  Count
 │   0    2023-02-01T00:00:00Z  67814h}(hj  hj  hK;uhh	uh(hhh}h}(hj  hj  usub$125d5060-9873-4739-b19e-fd74b510f074h
)}(h
}(hw │   1    2023-02-01T04:00:00Z  84569
 │   ..                    ...    ...
 │   718  2023-05-31T16:00:00Z  89912h}(hj  hj  hK<uhh	uh(hhh}h}(hj  hj  usub$3ec27e11-fb5a-4103-a278-3da71fe9894dh
)}(h
}(h │   719  2023-05-31T20:00:00Z  87249
 │   
 │   [720 rows x 2 columns]
 ├─► [artifact_paths] []
 ├──● The following python code has been executed:
 │   ```python
 │   import pandas as pdh}(hj  hj  hK=uhh	uh(hhh}h}(hj  hj  usub$27f98c5b-38ff-49d8-b62d-356cdeca2400h
)}(h
}(hX   │   
 │   data_file_path = "d:/demo_data.csv"
 │   df = pd.read_csv(data_file_path)
 │   df
 │   ```
 │   
 │   
 │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:h}(hj  hj  hK>uhh	uh(hhh}h}(hj  hj  usub$14955c01-6966-41f9-ac8b-e9d564c2d191h
)}(h
}(h │                  TimeBucket  Count
 │   0    2023-02-01T00:00:00Z  67814
 │   1    2023-02-01T04:00:00Z  84569
 │   ..                    ...    ...h}(hj  hj  hK?uhh	uh(hhh}h}(hj  hj  usub$17c22041-2d59-4130-ac1d-fff8b6a522a9h
)}(h
}(hu │   718  2023-05-31T16:00:00Z  89912
 │   719  2023-05-31T20:00:00Z  87249
 │   
 │   [720 rows x 2 columns]h}(hj  hj  hK@uhh	uh(hhh}h}(hj   hj!  usub$9fe64743-81c5-4b67-9e47-a2a494588360h
)}(h
}(h ╰──● sending message to Planner
 ╭───< Planner >CodeInterpreter] finished  <=�=>        
 ├─► [init_plan]
 │   1. load the data file
 │   2. confirm the columns to calculate variance <interactively depends on 1>h}(hj  hj  hKAuhh	uh(hhh}h}(hj)  hj*  usub$64e73bb8-a551-44c0-a6ac-092d3f828dcdh
)}(h
}(h │   3. calculate the variance value for the selected columns <sequentially depends on 2>
 │   4. report the result to the user <interactively depends on 3>h}(hj  hj  hKBuhh	uh(hhh}h}(hj2  hj3  usub$2fbb2087-cb0f-4cec-8ba7-425cb53eb151h
)}(h
}(h ├─► [plan] ▶ [Planner][plan] 1. instruct CodeInterpreter to load the data file 2. confirm the columns to calculate var       <=�=>   
 │   1. instruct CodeInterpreter to load the data file
 │   2. confirm the columns to calculate varianceh}(hj  hj  hKCuhh	uh(hhh}h}(hj;  hj<  usub$1a72cfe5-9d45-42e1-b49e-1cbdd362ee89h
)}(h
}(h ├─► [current_plan_step] 2. confirm the columns to calculate variance calculate varia      <=�=>    
 ├──● The data file d:/demo_data.csv is loaded. The columns in the data are:
 │   
 │   1. TimeBucket
 │   2. Count
 │   h}(hj  hj  hKDuhh	uh(hhh}h}(hjD  hjE  usub$bc6a2c8a-291d-4e1e-b9ca-d59ee523a82dh
)}(h
}(h │   Please specify which column(s) you would like to calculate the variance for.
 ╰──● sending message to User
 TaskWeaver ▶  The data file d:/demo_data.csv is loaded. The columns in the data are:

1. TimeBucket
2. Count
h}(hj  hj  hKEuhh	uh(hhh}h}(hjM  hjN  usub$03123d4b-f6af-4474-9e09-9330a977951dh
)}(h
}(hPlease specify which column(s) you would like to calculate the variance for.

Human   ▶  Count
 ╭───< Planner >TaskWeaver] preparing    <=�=>      
 ├─► [init_plan]
 │   1. load the data fileh}(hj  hj  hKFuhh	uh(hhh}h}(hjV  hjW  usub$a2d317db-113d-4ce9-b4d7-f9ad6c44cd27h
)}(h
}(h │   2. confirm the columns to calculate variance <interactively depends on 1>
 │   3. calculate the variance value for the selected columns <sequentially depends on 2>
 │   4. report the result to the user <interactively depends on 3>h}(hj  hj  hKGuhh	uh(hhh}h}(hj_  hj`  usub$a9ef1736-515d-4296-8336-5f36ed2cd111h
)}(h
}(h ├─► [plan]
 │   1. instruct CodeInterpreter to load the data file
 │   2. confirm the columns to calculate variance
 │   3. instruct CodeInterpreter to calculate the variance value for the Count column
 │   4. report the result to the userh}(hj  hj  hKHuhh	uh(hhh}h}(hjh  hji  usub$ef481c2f-5e97-4e66-8839-df1e0c8d51e6h
)}(h
}(hX
   ├─► [current_plan_step] 3. instruct CodeInterpreter to calculate the variance value for the Count columnor the Count col  <=�=>        
 ├──● Please calculate the variance value for the Count column in the loaded datalumn in the loaded          <=�=>h}(hj  hj  hKIuhh	uh(hhh}h}(hjq  hjr  usub$3d698c1c-1a87-4394-a396-3053094cb08ah
)}(h
}(hX   ╰──● sending message to CodeInterpreter
 ╭───< CodeInterpreter >
 ├─► [thought] ProgramApe will generate a code snippet to calculate the variance value for the Count column in the loaded data. column in the loaded dat <=�=>         h}(hj  hj  hKJuhh	uh(hhh}h}(hjz  hj{  usub$67aae55a-9777-4345-a038-8a66b3609353h
)}(h
}(h ├─► [python]▶ [CodeInterpreter][python] variance_count = df['Count'].var() varia     <=�=>     
 │   variance_count = df['Count'].var()
 │   variance_count
 ├─► [verification] NONEh}(hj  hj  hKKuhh	uh(hhh}h}(hj  hj  usub$e37df372-36bc-4d04-b2ce-0dc30bedd53ah
)}(h
}(hX(   ├─► [code_error] No code verification is performed.
 ├─► [execution_status] SUCCESS] executing code        <=�=>  
 ├─► [execution_result]
 │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:h}(hj  hj  hKLuhh	uh(hhh}h}(hj  hj  usub$132530f6-f517-4893-9b0c-8e9e492ef66fh
)}(h
}(h │   263514550.45479834
 ├─► [artifact_paths] []
 ├──● The following python code has been executed:
 │   ```python
 │   variance_count = df['Count'].var()
 │   variance_count
 │   ```
 │   
 │   h}(hj  hj  hKMuhh	uh(hhh}h}(hj  hj  usub$70097156-6a1c-454a-91c3-4180aebbdffah
)}(h
}(hX   │   The execution of the generated python code above has succeeded
 │   
 │   The result of above Python code after execution is:
 │   263514550.45479834
 ╰──● sending message to Planner
 ╭───< Planner >CodeInterpreter] finished         <=�=> h}(hj  hj  hKNuhh	uh(hhh}h}(hj  hj  usub$8748e5cc-06ed-46ae-aa71-dac8081341c5h
)}(h
}(h ├─► [init_plan]
 │   1. load the data file
 │   2. confirm the columns to calculate variance <interactively depends on 1>
 │   3. calculate the variance value for the selected columns <sequentially depends on 2>h}(hj  hj  hKOuhh	uh(hhh}h}(hj  hj  usub$47926335-b24b-4b2a-bad1-2cd8cc57e79ah
)}(h
}(h │   4. report the result to the user <interactively depends on 3>
  ├─► [plan]
 │   1. instruct CodeInterpreter to load the data file
 │   2. confirm the columns to calculate varianceh}(hj  hj  hKPuhh	uh(hhh}h}(hj  hj  usub$96a9e065-98d4-47c4-9326-f85da596bf9eh
)}(h
}(h │   3. instruct CodeInterpreter to calculate the variance value for the Count column
 │   4. report the result to the user
 ├─► [current_plan_step] 4. report the result to the user result to the u       <=�=>   h}(hj  hj  hKQuhh	uh(hhh}h}(hj  hj  usub$95351312-4216-4efd-b120-04fe4eb169f4h
)}(h
}(h ├──● The variance value for the Count column in the data file d:/demo_data.csv is 263,514,550.45a.csv is 263,51    <=�=>      
 ╰──● sending message to Userh}(hj  hj  hKRuhh	uh(hhh}h}(hj  hj  usub$b8b7bc26-5e14-44b5-88d0-9c1baa706f0bh
)}(h
}(hp TaskWeaver ▶  The variance value for the Count column in the data file d:/demo_data.csv is 263,514,550.45
```h}(hj  hj  hKSuhh	uh(hhh}h}(hj  hj  usub$7da2d39e-cb8f-4885-928d-2380f6e4b944h
)}(h
}(h---
description: List for all supported customizations 
---
# Supported Customizations 

```mdx-code-block
import DocCardList from '@theme/DocCardList';

<DocCardList />
```h}(hindex.mdh2description: List for all supported customizationshK uhh	uh(hhh}h}(hj  hj  usub$782f2c5c-7d56-4578-bab3-b4172550e69bh
)}(h
}(h# Customizing Examples

There are currently two types of examples: (1) Planner examples and (2) CodeInterpreter examples. 
Planning examples are used to demonstrate how the Planner should plan for a specific query from the User.h}(hexample\example.mdh# Customizing ExampleshK uhh	uh(hhh}h}(hj  hj  usub$d02c9925-006e-4240-9ba6-aa3df2976cd9h
)}(h
}(hX  Code generation examples are used to help the CodeInterpreter generate code or orchestrate plugins to perform a specific task.

Both types of examples are actually the conversation between a collection of roles, such as the User, the Planner, and the CodeInterpreter.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5e055a8b-0a6f-4029-a93f-86050e61f8d5h
)}(h
}(hX   Each conversation consists of one or more rounds, and each round has a User query and contains one or more posts.
A post is a message sent from one role to another role, and it may contain some attachments.

One example looks like this:
```yaml
enabled: True
rounds:
   - User_query: pingh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$d22f5c3e-1c2c-4c88-9e88-dd7ac51f78c0h
)}(h
}(h     state: created
     post_list:
     - message: ping
       send_from: User
       send_to: Planner
       attachment_list: []
     - message: pong
       send_from: Planner
       send_to: User
       attachment_list: []
```h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c4a76b0d-7a09-4f75-835c-da48da0b6c11h
)}(h
}(hX+  We explicitly break all examples into the two types only to make it easier to understand and maintain.
When the roles are initialized, each role will only read the examples of its type.

:::tip
All the text field in the examples such as the messages are in Markdown format.
:::

## Planner Examples
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$e01a4ff0-46af-450b-ac8a-4ed6a41a758ch
)}(h
}(hX,  A planning example tells LLMs how to plan for a specific query from the User, talk to the CodeInterpreter,
receive the execution result from the CodeInterpreter, and summarize the execution result.

The following is an example of a conversation between the User, the Planner, and the CodeInterpreter.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$36b604b5-4cc1-4263-9265-e0cb2d6748f9h
)}(h
}(hX.  One of the purposes of this example is to teach the Planner on the annotation of the dependencies between the steps in the plan.
Another purpose is to teach the Planner to follow the right output format.

```yaml
enabled: True
rounds:
  - User_query: count the rows of /home/data.csv
    state: createdh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5395b0c3-93fd-4058-8cc5-644c5aee0cc9h
)}(h
}(hX&      post_list:
      - message: count the rows of /home/data.csv
        send_from: User
        send_to: Planner
        attachment_list:
      - message: Please load the data file /home/data.csv and count the rows of the loaded data
        send_from: Planner
        send_to: CodeInterpreterh}(hj  hj  hKuhh	uh(hhh}h}(hj   hj!  usub$f3ef1593-f894-4a5f-a214-53384512d6a7h
)}(h
}(hX          attachment_list:
        - type: init_plan
          content: |-
            1. load the data file
            2. count the rows of the loaded data <sequentially depends on 1>
            3. report the result to the User <interactively depends on 2>
        - type: planh}(hj  hj  hKuhh	uh(hhh}h}(hj)  hj*  usub$0070274c-437d-4e56-8631-84f651d03f1ah
)}(h
}(hX3            content: |-
            1. instruct CodeInterpreter to load the data file and count the rows of the loaded data
            2. report the result to the User
        - type: current_plan_step
          content: 1. instruct CodeInterpreter to load the data file and count the rows of the loaded datah}(hj  hj  hK	uhh	uh(hhh}h}(hj2  hj3  usub$628af223-2660-43cd-a3f7-dea3d6877d9dh
)}(h
}(hX        - message: Load the data file /home/data.csv successfully and there are 100 rows in the data file
        send_from: CodeInterpreter
        send_to: Planner
        attachment_list:
      - message: The data file /home/data.csv is loaded and there are 100 rows in the data fileh}(hj  hj  hK
uhh	uh(hhh}h}(hj;  hj<  usub$bdc3a6d2-f800-476b-8da1-63c5a1614e0ch
)}(h
}(h        send_from: Planner
        send_to: User
        attachment_list:
          - type: init_plan
            content: |-
              1. load the data file
              2. count the rows of the loaded data <sequentially depends on 1>h}(hj  hj  hKuhh	uh(hhh}h}(hjD  hjE  usub$17bc35cc-76c6-4b20-a536-2c8996c0f3ceh
)}(h
}(hX3                3. report the result to the User <interactively depends on 2>
          - type: plan
            content: |-
              1. instruct CodeInterpreter to load the data file and count the rows of the loaded data
              2. report the result to the User
          - type: current_plan_steph}(hj  hj  hKuhh	uh(hhh}h}(hjM  hjN  usub$1a3af9ed-a7b7-45a1-8fc2-af5af917b740h
)}(h
}(h            content: 2. report the result to the User
```
:::tip
To better understand the attachments including `init_plan`, `plan`, and `current_plan_step`,  h}(hj  hj  hK
uhh	uh(hhh}h}(hjV  hjW  usub$cfed6b35-612c-4ea6-84b7-169520694577h
)}(h
}(hplease refer to the [Planner's prompt](https://github.com/microsoft/TaskWeaver/blob/main/taskweaver/planner/planner_prompt.yaml).
:::

In this example, there are 4 posts:
1. The first post is sent from the User to the Planner.h}(hj  hj  hKuhh	uh(hhh}h}(hj_  hj`  usub$d1350ef2-06f6-4340-94bc-cfef7121109dh
)}(h
}(hX	     The message is "count the rows of /home/data.csv", which must be the same with the User query.
2. The second post is sent from the Planner to the CodeInterpreter.
   The message is "Please load the data file /home/data.csv and count the rows of the loaded data".h}(hj  hj  hKuhh	uh(hhh}h}(hjh  hji  usub$30f2275c-3c51-4807-805a-71979398fa02h
)}(h
}(hX     The attachment list contains 3 attachments:
   1. The first attachment is the initial plan.
   2. The second attachment is the final plan.
   3. The third attachment is the current plan step.
3. The third post is sent from the CodeInterpreter to the Planner.h}(hj  hj  hKuhh	uh(hhh}h}(hjq  hjr  usub$7ff505d5-5a31-40db-b976-7ab7cb519a90h
)}(h
}(hX     The message is "Load the data file /home/data.csv successfully and there are 100 rows in the data file".
4. The fourth post is sent from the Planner to the User.
   The message is "The data file /home/data.csv is loaded and there are 100 rows in the data file".h}(hj  hj  hKuhh	uh(hhh}h}(hjz  hj{  usub$388b49ed-d3a1-4254-912e-5fd922c263cah
)}(h
}(hX     The attachment list contains 3 attachments, which are the same as the second post.

## CodeInterpreter Examples

A CodeInterpreter example tells CodeInterpreter how to generate code or orchestrate plugins to perform a specific task.
The task is always from the Planner. 
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6e4cfc0c-027f-487a-9feb-60750399a14dh
)}(h
}(hX  The purpose of this example is to teach CodeInterpreter how to handle errors in execution.

```yaml
enabled: True
rounds:
  - User_query: read file /abc/def.txt
    state: finished
    post_list:
      - message: read file /abc/def.txt
        send_from: Plannerh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$38821603-626a-4b4f-b9fc-3a01f4e718d6h
)}(h
}(hX          send_to: CodeInterpreter
        attachment_list: []
      - message: I'm sorry, I cannot find the file /abc/def.txt. An FileNotFoundException has been raised.
        send_from: CodeInterpreter
        send_to: Planner
        attachment_list:
        - type: thoughth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$e38eeb83-08c4-40c1-a4a5-6a07328e676ah
)}(h
}(hX            content: "{ROLE_NAME} will generate a code snippet to read the file /abc/def.txt and present the content to the User."
        - type: python
          content: |-
            file_path = "/abc/def.txt"  

            with open(file_path, "r") as file:  h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5b7190a7-022f-4396-b688-5b0f20bca844h
)}(h
}(hX$                  file_contents = file.read()  
                print(file_contents)
        - type: verification
          content: CORRECT
        - type: code_error
          content: No code error.
        - type: execution_status
          content: FAILURE
        - type: execution_resulth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9f6d01b3-7a51-4ed1-b9d5-4ffc889f2151h
)}(h
}(h          content: FileNotFoundException, the file /abc/def.txt does not exist.
```
:::tip
Read the prompt of the code generation to better understand the attachments in the exampleh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9ceefb49-4de0-4885-8471-2ab5390e2757h
)}(h
}(h[code generator prompt](https://github.com/microsoft/TaskWeaver/blob/main/taskweaver/code_interpreter/code_interpreter/code_generator_prompt.yaml). 
:::

This conversation has two posts:
1. The first post is sent from the Planner to the CodeInterpreter.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b59fb236-c2e7-4341-b864-a62869ac8b9bh
)}(h
}(h   The message is "Please read file /abc/def.txt".
2. The second post is sent from the CodeInterpreter to the Planner.
   The message is "read file /abc/def.txt".
   The attachment list contains 6 attachments:h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$676e2d14-d135-4139-b514-bcff3b63d59dh
)}(h
}(h   1. The first attachment is the thought of the CodeInterpreter.
   2. The second attachment is the generated code, which is in python.
   3. The third attachment is the verification status, which is CORRECT, INCORRECT, or NONE.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b01a1914-e338-44bf-81de-51eb85c28e6ch
)}(h
}(h   4. The fourth attachment is the verification error message.
   5. The fifth attachment is the execution status, which is SUCCESS, FAILURE, or NONE.
   6. The sixth attachment is the execution result, which is a markdown string.
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$64f6c497-e280-4cff-a6f1-2989bab757d9h
)}(h
}(hX	  In this example, `verification` is about whether the generated code is correct or not. 
We implemented a module to verify the generated code. If the code is syntactically incorrect, 
or the code violates the constraints, the verification status will be `INCORRECT` h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c9933675-723a-4704-8e81-2f41ff8e4e56h
)}(h
}(hX  and some error messages will be returned.
A verification of NONE means that the code has not been verified, which means verification has been turned off.

In this example, `execution_status` is about whether the generated code can be executed successfully or not.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0ec6d0ee-1c2a-4a2c-ae58-add0c5314009h
)}(h
}(hX  If the execution is successful, the execution status will be `SUCCESS` and the execution result will be returned.
Otherwise, the execution status will be `FAILURE` and some error messages will be returned.
A execution_status of `NONE` means that the code has not been executed.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$82fb6c24-e940-48de-8f56-2b6fe9148b49h
)}(h
}(hX  ---
id: develop_plugin
description: How to develop a new plugin
slug: /plugin/how_to_develop_a_new_plugin
---
# An Example of Developing a New Plugin

In this tutorial, we will introduce how to develop a strawman plugin in TaskWeaver. This plugin can render a input text in ascii art. 
h}(h%plugin\how_to_develop_a_new_plugin.mdhid: develop_pluginhK uhh	uh(hhh}h}(hj  hj  usub$5c0ef1c9-b209-4947-85f6-209479cc125ch
)}(h
}(h## Implement the python code

Create a python file named `ascii_render.py` in the `plugins` folder. The file name should be the same as the plugin name. The plugin name is defined in the plugin schema. In this example, the plugin name is `ascii_render`.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9e0f8c87-66f4-4fed-b191-b37eab156754h
)}(h
}(hXS  The following code is the template of the plugin implementation.
```python
from taskweaver.plugin import Plugin, register_plugin

@register_plugin
class PluginTemplate(Plugin):
    def __call__(self, *args, **kwargs):
        """Implementation Starts"""
        result, description = YourImplementation()
        """Implementation Ends"""
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj
  usub$ae29e23b-93f2-4ddd-bbc3-d4941f4a0761h
)}(h
}(hX-          # if your want to add artifact from the execution result, uncomment the following code
        # self.ctx.add_artifact(
        #     name="artifact",
        #     file_name="artifact.csv",
        #     type="df",
        #     val=result,
        # )
        return result, description
```
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$7272742b-92c7-4c8d-a04b-2d89e4018285h
)}(h
}(hXP  The typical way of implementing the plugin is to change the code between `Implementation Starts` and `Implementation Ends`. Note that the return are two variables _result_ and _description_. The _result_ stores whatever output required for follow-up processing (e.g., a DataFrame). The _description_ is a string to describe the result. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0ce3f369-eac9-4d51-8d1b-1a3a4edaadb2h
)}(h
}(h
Let's make some changes to the code and the result is as follows:

```python
from taskweaver.plugin import Plugin, register_plugin

@register_plugin
class AsciiRenderPlugin(Plugin):
    def __call__(self, text: str):
        import pyfigleth}(hj  hj  hKuhh	uh(hhh}h}(hj'  hj(  usub$a4759ef0-f162-4987-a236-9ae4c662b5b7h
)}(h
}(h        ascii_art_str = pyfiglet.figlet_format(text, font='isometric1')
        return ascii_art_str
```
Note that this function depends on the package `pyfiglet`, so we need to install it with `pip install pyfiglet`.

## Configure the schema
h}(hj  hj  hKuhh	uh(hhh}h}(hj0  hj1  usub$af1b983c-b577-4e99-8428-4224f890bd2bh
)}(h
}(hNext, we need to configure the schema so that the LLM can understand the function 
of the plugin. In the schema, there are several fields that should be filled, 
including `name`, `enabled`, `required`, `description`, `parameters` and `returns`. h}(hj  hj  hKuhh	uh(hhh}h}(hj9  hj:  usub$c26c55c0-92bf-445a-96f4-382d68d39ea8h
)}(h
}(hX  Please check [Plugin Introduction](https://microsoft.github.io/TaskWeaver/docs/plugin/plugin_intro) 
for more details. 
Create a yaml file named `ascii_render.yaml` and copy the following content into it.

```yaml
name: ascii_render
enabled: true
required: true
description: >-h}(hj  hj  hKuhh	uh(hhh}h}(hjB  hjC  usub$694ebf15-30c8-4364-ba0a-582f105d01a3h
)}(h
}(hX    This plugin renders the input text into ASCII art form. 
  The input should be a string and the output is also a string in ASCII art.
  For example, result = ascii_render(text='Hello World').

parameters:
  - name: text
    type: str
    required: true
    description: >-h}(hj  hj  hK	uhh	uh(hhh}h}(hjK  hjL  usub$2401c2bd-9287-4d99-b5e7-1bca42c33446h
)}(h
}(hX        This is the input text to be rendered into ASCII art form.

returns:
  - name: result
    type: str
    description: >-
      The rendered text in ASCII art.
```

## Call the plugin

After the plugin is implemented and configured, we can call the plugin in the conversation.h}(hj  hj  hK
uhh	uh(hhh}h}(hjT  hjU  usub$dfbc4c41-b9e6-4e1b-a418-308f65de02c8h
)}(h
}(hThe full conversation is as follows:
```bash
=========================================================
 ___         _     _       __
|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hj  hj  hKuhh	uh(hhh}h}(hj]  hj^  usub$05feb5bf-b722-44f6-8462-7d01e69d8fc2h
)}(h
}(ho  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hj  hj  hKuhh	uh(hhh}h}(hjf  hjg  usub$8dff123c-b583-4743-8d18-a3e1fd8cf818h
)}(h
}(hX     |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================
TaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
Human: render ABC in ascii art
>>> [INIT_PLAN]h}(hj  hj  hK
uhh	uh(hhh}h}(hjo  hjp  usub$8aaeb978-c570-4778-b12c-3998c9265c16h
)}(h
}(h1. Render the text 'ABC' into ASCII art
>>> [PLAN]
1. Instruct CodeInterpreter to render the text 'ABC' into ASCII art
>>> [CURRENT_PLAN_STEP]
1. Instruct CodeInterpreter to render the text 'ABC' into ASCII art
>>> [SEND_TO]
CodeInterpreter
>>> [MESSAGE]h}(hj  hj  hKuhh	uh(hhh}h}(hjx  hjy  usub$d07a9cd4-57a3-4376-8352-12720e72de0ch
)}(h
}(hPlease render the text 'ABC' into ASCII art
>>> [PLANNER->CODEINTERPRETER]
Please render the text 'ABC' into ASCII art
>>> [PYTHON]
# Call the plugin function to render the text 'ABC' into ASCII art
ascii_art_result = ascii_render("ABC")
ascii_art_resulth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$29955146-e6bc-4d78-89ef-13cb8165f36ah
)}(h
}(hX  >>> [VERIFICATION]
NONE
>>> [STATUS]
SUCCESS
>>> [RESULT]
The execution of the generated python code above has succeeded

The result of above Python code after execution is:
      ___           ___           ___     
     /\  \         /\  \         /\  \    h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f3150ddf-827c-4a4a-b6a5-6b6a2a5d21d7h
)}(h
}(hU    /::\  \       /::\  \       /::\  \   
   /:/\:\  \     /:/\:\  \     /:/\:\  \  h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f1122ec7-461f-43ac-aa8c-e6de38c6374ah
)}(h
}(hU  /::\~\:\  \   /::\~\:\__\   /:/  \:\  \ 
 /:/\:\ \:\__\ /:/\:\ \:|__| /:/__/ \:\__\h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c3753352-9bc5-4e33-89e0-392decb292b1h
)}(h
}(h \/__\:\/:/  / \:\~\:\/:/  / \:\  \  \/__/
      \::/  /   \:\ \::/  /   \:\  \      
      /:/  /     \:\/:/  /     \:\  \     h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ace90438-44e6-4a73-b34e-007e53718ce8h
)}(h
}(h     /:/  /       \::/__/       \:\__\    
     \/__/         ~~            \/__/    

>>> [CODEINTERPRETER->PLANNER]
The following python code has been executed:

# Call the plugin function to render the text 'ABC' into ASCII arth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$354a2b3f-3654-4003-98d2-fb9e0e966910h
)}(h
}(hX  ascii_art_result = ascii_render("ABC")
ascii_art_result

The execution of the generated python code above has succeeded

The result of above Python code after execution is:
      ___           ___           ___     
     /\  \         /\  \         /\  \    h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$7fd78de8-dfb0-4528-9e9f-b8ef6d601c18h
)}(h
}(hU    /::\  \       /::\  \       /::\  \   
   /:/\:\  \     /:/\:\  \     /:/\:\  \  h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$0267507b-daa6-4abd-a081-1ac112126a74h
)}(h
}(hU  /::\~\:\  \   /::\~\:\__\   /:/  \:\  \ 
 /:/\:\ \:\__\ /:/\:\ \:|__| /:/__/ \:\__\h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$8a0b2432-83d7-49d2-86bf-6b3daec7eaa9h
)}(h
}(h \/__\:\/:/  / \:\~\:\/:/  / \:\  \  \/__/
      \::/  /   \:\ \::/  /   \:\  \      
      /:/  /     \:\/:/  /     \:\  \     h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ca783e3f-68fd-44dd-b1e6-61dcc7737da6h
)}(h
}(h     /:/  /       \::/__/       \:\__\    
     \/__/         ~~            \/__/    

>>> [INIT_PLAN]  
1. Render the text 'ABC' into ASCII art
>>> [PLAN]
1. Instruct CodeInterpreter to render the text 'ABC' into ASCII arth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$1f32ddeb-e33e-4984-a880-30f2ee3b2e52h
)}(h
}(h>>> [CURRENT_PLAN_STEP]
Report the ASCII art to the user
>>> [SEND_TO]
User
>>> [MESSAGE]
Here is the text 'ABC' rendered in ASCII art:
      ___           ___           ___     
     /\  \         /\  \         /\  \    h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$d2899801-b01a-48db-a743-57403525560ch
)}(h
}(hU    /::\  \       /::\  \       /::\  \   
   /:/\:\  \     /:/\:\  \     /:/\:\  \  h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$d69ecfa3-fed7-4796-beaf-d1b9c56293dah
)}(h
}(hU  /::\~\:\  \   /::\~\:\__\   /:/  \:\  \ 
 /:/\:\ \:\__\ /:/\:\ \:|__| /:/__/ \:\__\h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$eef125f4-76de-4945-b695-4d447d2d38dch
)}(h
}(h \/__\:\/:/  / \:\~\:\/:/  / \:\  \  \/__/
      \::/  /   \:\ \::/  /   \:\  \      
      /:/  /     \:\/:/  /     \:\  \     h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj   usub$996248d1-9986-476e-9836-7c2fd69c7282h
)}(h
}(h     /:/  /       \::/__/       \:\__\    
     \/__/         ~~            \/__/    
>>> [PLANNER->USER]
Here is the text 'ABC' rendered in ASCII art:
      ___           ___           ___     
     /\  \         /\  \         /\  \    h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj	  usub$72bc70a9-a94a-4638-9b49-5d41bd3e7116h
)}(h
}(hU    /::\  \       /::\  \       /::\  \   
   /:/\:\  \     /:/\:\  \     /:/\:\  \  h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$875b5a3a-b367-496c-958c-10bcf0baa91dh
)}(h
}(hU  /::\~\:\  \   /::\~\:\__\   /:/  \:\  \ 
 /:/\:\ \:\__\ /:/\:\ \:|__| /:/__/ \:\__\h}(hj  hj  hK uhh	uh(hhh}h}(hj  hj  usub$5c3cff32-3a4d-4961-b197-e1781b3de530h
)}(h
}(h \/__\:\/:/  / \:\~\:\/:/  / \:\  \  \/__/
      \::/  /   \:\ \::/  /   \:\  \      
      /:/  /     \:\/:/  /     \:\  \     h}(hj  hj  hK!uhh	uh(hhh}h}(hj#  hj$  usub$aca57c75-2294-488f-af55-4d03b4bfe429h
)}(h
}(h     /:/  /       \::/__/       \:\__\    
     \/__/         ~~            \/__/    
TaskWeaver: Here is the text 'ABC' rendered in ASCII art:
      ___           ___           ___     
     /\  \         /\  \         /\  \    h}(hj  hj  hK"uhh	uh(hhh}h}(hj,  hj-  usub$f0e68ca2-f404-455e-b8e5-1a92b21f0ccah
)}(h
}(hU    /::\  \       /::\  \       /::\  \   
   /:/\:\  \     /:/\:\  \     /:/\:\  \  h}(hj  hj  hK#uhh	uh(hhh}h}(hj5  hj6  usub$49ac5372-3d84-424c-ad91-5e460aae8208h
)}(h
}(hU  /::\~\:\  \   /::\~\:\__\   /:/  \:\  \ 
 /:/\:\ \:\__\ /:/\:\ \:|__| /:/__/ \:\__\h}(hj  hj  hK$uhh	uh(hhh}h}(hj>  hj?  usub$95086bc0-b73f-4c2a-9148-671538336992h
)}(h
}(h \/__\:\/:/  / \:\~\:\/:/  / \:\  \  \/__/
      \::/  /   \:\ \::/  /   \:\  \      
      /:/  /     \:\/:/  /     \:\  \     h}(hj  hj  hK%uhh	uh(hhh}h}(hjG  hjH  usub$903f6745-3a61-4a43-9181-6c2e73090d5eh
)}(h
}(h     /:/  /       \::/__/       \:\__\    
     \/__/         ~~            \/__/        
```

:::info
Check the [FAQs](../../FAQ.md) if you have any issues in developing a plugin before submitting an issue on GitHub.
:::h}(hj  hj  hK&uhh	uh(hhh}h}(hjP  hjQ  usub$bc7e3830-a8a4-4f42-8475-e3f1f5350f1dh
)}(h
}(hX  ---
id: multi_yaml_single_impl
description: Multiple YAML files to one Python implementation
slug: /plugin/multi_yaml_single_impl
---

# Multiple YAML files to one Python implementation

In practice, you may want to have multiple plugins that share the same implementation.h}(h plugin\multi_yaml_single_impl.mdhid: multi_yaml_single_implhK uhh	uh(hhh}h}(hjY  hjZ  usub$fc4c092b-f502-4655-9406-ed8c9eff099ah
)}(h
}(hX  For example, you may want to have two plugins that both pull data from a database, but one pulls data from database A and the other pulls data from database B.
In this case, the plugin implementation code is the same, but the plugin configuration is different.h}(hj[  hj\  hKuhh	uh(hhh}h}(hjd  hje  usub$be5d8743-7b65-4739-ae15-2c3bd453c6fch
)}(h
}(hXM  It would be cumbersome to copy and paste the same implementation code to two different files.

To solve this problem, TaskWeaver allows you to have multiple plugin configurations that share the same implementation.
Here is an example of the plugin configuration for the two plugins that pull data from database A and B respectively:
h}(hj[  hj\  hKuhh	uh(hhh}h}(hjm  hjn  usub$e17ca550-8672-4768-a695-bebf743e83d8h
)}(h
}(hThe configuration for the plugin that pulls data from database A:
```yaml
name: sql_pull_data_from_A
code: sql_pull_data
...
description: >-
  Pull data from a SQL database A. The database A contains information about merchandise sales.
examples: |-h}(hj[  hj\  hKuhh	uh(hhh}h}(hjv  hjw  usub$2feb6680-f48f-4033-aa45-cbfbf05503e0h
)}(h
}(h  df, description = sql_pull_data_from_A("pull data from time_series table")
parameters:
  ...
returns:
  ...
configurations:
  ...
  sqlite_db_path: /path/to/sqlite_A.db
```

The configuration for the plugin that pulls data from database B:
```yamlh}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$29ac5858-fbd2-49f0-a8c5-06277ea024a6h
)}(h
}(hX   name: sql_pull_data_from_B
code: sql_pull_data
...
description: >-
  Pull data from a SQL database B. The database B contains information about customer information.
examples: |-
  df, description = sql_pull_data_from_B("pull data from time_series table")
parameters:
  ...
returns:
  ...h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$a94a5276-8a3b-4b07-a31e-37fd353e3206h
)}(h
}(hconfigurations:
  ...
  sqlite_db_path: /path/to/sqlite_B.db
```

Let's discuss the differences between the two configurations. 
h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$383c848f-6e3a-4451-8d1d-b8a112835237h
)}(h
}(hX  First, you can see that the `name` field is different, and the names are different from the python file name (without extension) which is `sql_pull_data.py`.
This name is used in CodeInterpreter for code generation. So, you can see that in the `examples` field, h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$032dc545-38a4-4a99-aec7-70d779a629fdh
)}(h
}(hX   the function name is `sql_pull_data_from_A` and `sql_pull_data_from_B`, respectively.

Second, you can see that the `code` field is the same, and the code file name is `sql_pull_data.py`.
This means that the two plugins share the same implementation code. h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$eb7fbeaf-8232-4ff1-a56f-94f901474debh
)}(h
}(hThe `code` field is optional, and if you don't specify it, the plugin name will be used as the code file name without the extension.

Third, you can see that the `configurations` field is different, and the `sqlite_db_path` is different.h}(hj[  hj\  hK	uhh	uh(hhh}h}(hj  hj  usub$53c1aa0c-4b0c-43cf-a990-8245a1ffff7ch
)}(h
}(hX  This means that the two plugins have different configurations.
This is typically the key reason why you want to have multiple plugin configurations that share the same implementation.

Finally, you can see that the `description` field is different, and the descriptions are different.h}(hj[  hj\  hK
uhh	uh(hhh}h}(hj  hj  usub$49da7bac-b636-47a4-9fa1-bd97de70ab08h
)}(h
}(hX6  This is important because the Planner and the CodeInterpreter will use the description to make decisions and generate code.
The two descriptions should be explicit enough to distinguish the two plugins. 
Otherwise, the Planner and the CodeInterpreter may not be able to make the right decisions.

## Conclusionh}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$8e27085a-6c04-4a06-9229-18b77e5c897fh
)}(h
}(hWhen you meet the situation where you want to have multiple plugin configurations that share the same implementation,
you can use the `code` field to specify the code file name, and use the `configurations` field to specify the configurations.h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$3f3fe63d-7d23-42ff-a102-ce87f5a2566eh
)}(h
}(hThe `name` field is used to distinguish the plugins, and the `description` field is used to 
help the Planner and the CodeInterpreter make right decisions.h}(hj[  hj\  hK
uhh	uh(hhh}h}(hj  hj  usub$b94e9561-60eb-4a38-98c1-be2c4972dfaeh
)}(h
}(hX  ---
id: plugin_intro
description: Plugin introduction
slug: /plugin/plugin_intro
---

# Plugin Introduction

Plugins are the units that could be orchestrated by TaskWeaver's CodeInterpreter. One could view the plugins as tools that the LLM can
utilize to accomplish certain tasks.
h}(hplugin\plugin_intro.mdhid: plugin_introhK uhh	uh(hhh}h}(hj  hj  usub$8459d389-1fda-4978-bf04-2c62e265596ah
)}(h
}(hX
  In TaskWeaver, each plugin is represented as a Python function that can be called within the generated code snippet. 
One concrete example would be pulling data from database and apply anomaly detection. The generated code (simplified) looks like
follows:

```pythonh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ee891c12-cd28-4c88-8f8c-5175ed8b67e8h
)}(h
}(hdf, data_description = sql_pull_data(query="pull data from time_series table")  
anomaly_df, anomaly_description = anomaly_detection(df, time_col_name="ts", value_col_name="val") 
```h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$cf61c81f-3b59-4d8f-a2df-70fe8cd4d8dbh
)}(h
}(hX	  The generated code snippet above calls two plugins: `sql_pull_data` and `anomaly_detection`. The `sql_pull_data` plugin
pulls data from a database, and the `anomaly_detection` plugin detects anomalies in the data.

## Plugin Structure

A plugin involves two files:
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$06bbd396-0332-4144-8283-b5ae1565f3b6h
)}(h
}(hXC  * **Plugin Implementation**: a Python file that defines the plugin
* **Plugin Schema**: a file in yaml that defines the schema of the plugin

## Plugin Implementation

The plugin function needs to be implemented in Python.
To be coordinated with the orchestration by TaskWeaver, a plugin python file consists of two parts:
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj   usub$e1eff25d-7793-4098-82e1-a40929e17300h
)}(h
}(hXR  - Plugin function implementation code
- TaskWeaver plugin decorator

Here we exhibit an example of the anomaly detection plugin as the following code:

```python
import pandas as pd
from pandas.api.types import is_numeric_dtype

from taskweaver.plugin import Plugin, register_plugin

@register_plugin
class AnomalyDetectionPlugin(Plugin):h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj	  usub$c3bf001a-2793-4545-88f6-9588deebd7cah
)}(h
}(h    def __call__(self, df: pd.DataFrame, time_col_name: str, value_col_name: str):

        """
        anomaly_detection function identifies anomalies from an input dataframe of time series.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$2854b66c-3aef-4b21-882e-ed4ee3348175h
)}(h
}(hX          It will add a new column "Is_Anomaly", where each entry will be marked with "True" if the value is an anomaly
        or "False" otherwise.

        :param df: the input data, must be a dataframe
        :param time_col_name: name of the column that contains the datetimeh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$a9a44600-9407-4c7a-b95d-0a0c7f2382c8h
)}(h
}(hX          :param value_col_name: name of the column that contains the numeric values.
        :return df: a new df that adds an additional "Is_Anomaly" column based on the input df.
        :return description: the description about the anomaly detection results.
        """
        try:h}(hj  hj  hKuhh	uh(hhh}h}(hj#  hj$  usub$2ee4404a-6cb3-4dc2-ae3b-1122039df742h
)}(h
}(hX,              df[time_col_name] = pd.to_datetime(df[time_col_name])
        except Exception:
            print("Time column is not datetime")
            return

        if not is_numeric_dtype(df[value_col_name]):
            try:
                df[value_col_name] = df[value_col_name].astype(float)h}(hj  hj  hK	uhh	uh(hhh}h}(hj,  hj-  usub$64504bc7-9dbd-422f-8279-08e94ae902b1h
)}(h
}(hX               except ValueError:
                print("Value column is not numeric")
                return

        mean, std = df[value_col_name].mean(), df[value_col_name].std()
        cutoff = std * 3
        lower, upper = mean - cutoff, mean + cutoff|      h}(hj  hj  hK
uhh	uh(hhh}h}(hj5  hj6  usub$abe65de9-bc42-4ba2-ab19-f1a6bbce8f7ah
)}(h
}(h        df["Is_Anomaly"] = df[value_col_name].apply(lambda x: x < lower or x > upper)
        anomaly_count = df["Is_Anomaly"].sum()
        description = "There are {} anomalies in the time series data".format(anomaly_count)
        h}(hj  hj  hKuhh	uh(hhh}h}(hj>  hj?  usub$0d41107d-c15e-49a0-9dd0-b8b93e6883d6h
)}(h
}(hX          self.ctx.add_artifact(
             name="anomaly_detection_results",  # a brief description of the artifact
             file_name="anomaly_detection_results.csv",  # artifact file name
             type="df",  # artifact data type, support chart/df/file/txt/svgh}(hj  hj  hKuhh	uh(hhh}h}(hjG  hjH  usub$e4174115-bff9-4581-9510-c9d21fc35d72h
)}(h
}(hX	               val=df,  # variable to be dumped
        )
        
        return df, description

```

You need to go through the following steps to register a plugin:

1. import the TaskWeaver plugin decorator `from taskWeaver.plugin import Plugin, register_plugin`h}(hj  hj  hK
uhh	uh(hhh}h}(hjP  hjQ  usub$cb5b9943-0f79-41ee-96b6-8f600605bdd5h
)}(h
}(h2. create your plugin class inherited from `Plugin` parent class (e.g., `AnomalyDetectionPlugin(Plugin)`), which is
   decorated by `@register_plugin`
3. implement your plugin function in `__call__` method of the plugin class.  
h}(hj  hj  hKuhh	uh(hhh}h}(hjY  hjZ  usub$a9a83129-026a-4497-8777-6e96327ef109h
)}(h
}(hX5  We provide an example process of developing a new plugin in [this tutorial](./how_to_develop_a_new_plugin.md).

:::tip
A good practice in a plugin implementation is to return a description of
the result in natural language. As LLMs only understand natural language, it is important to let the model understandh}(hj  hj  hKuhh	uh(hhh}h}(hjb  hjc  usub$e03c7e9c-0b5a-40a6-8a51-8ff6478c63cfh
)}(h
}(hX@  what the execution result is. In the example implementation above, the description says how many anomalies are detected.
In other cases such as loading a csv file, a good description could be showing the schema of the loaded data.
This description can be used by the LLM to plan the next steps.
:::

### Important Notes
h}(hj  hj  hKuhh	uh(hhh}h}(hjk  hjl  usub$0e49d7de-2892-413c-beb1-aaf6cbb7dab1h
)}(h
}(hX  1. If the functionality of your plugin depends on additional libraries or packages, it is essential to ensure that they
   are installed before proceeding.

2. If you wish to persist intermediate results, such as data, figures, or prompts, in your plugin implementation,h}(hj  hj  hKuhh	uh(hhh}h}(hjt  hju  usub$44301392-58c5-4c77-935d-7b36dc24ac05h
)}(h
}(h   TaskWeaver provides an `add_artifact` API that allows you to store these results in the workspace. In the example we
   provide, if you have performed anomaly detection and obtained results in the form of a CSV file, you can utilizeh}(hj  hj  hKuhh	uh(hhh}h}(hj}  hj~  usub$06df878e-36cd-4c1c-9ae9-20bfc0c96dceh
)}(h
}(hX     the `add_artifact` API to save this file as an artifact. The artifacts are stored in the `project/workspace/session_id/cwd` folder in the project directory.

   ```python
   self.ctx.add_artifact(
       name="anomaly_detection_results",  # a brief description of the artifacth}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$9b3e6dab-a62f-4cfa-a86f-24b9358f1c56h
)}(h
}(hX         file_name="anomaly_detection_results.csv",  # artifact file name
       type="df",  # artifact data type, support chart/df/file/txt/svg
       val=df,  # variable to be dumped
   )
   ```

## Plugin Schema

The plugin schema is composed of several parts:
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$796b3e93-b8df-4ca3-8211-a992e7ad7ec9h
)}(h
}(hX  - ***name**: The main function name of the Python code.
- **enabled**: determine whether the plugin is enabled for selection during conversations. The default value is true.
- **plugin_only**: determine if this plugin is enabled under the plugin-only mode. The default value is false.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$fea8bf6d-1a85-4731-abd5-7164e03c882ch
)}(h
}(hX   - **code**: the code file name of the plugin. The default value is the same as the plugin name.
- ***descriptions**: A brief description that introduces the plugin function.
- ***parameters**: This section lists all the input parameter information. It includes the parameter's name, type,h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$d5033985-e20b-48cf-949b-eb922c978f44h
)}(h
}(hX-  whether it is required or optional, and a description providing more details about the parameter.
- ***returns**: This section lists all the return value information. It includes the return value's name, type, and
description that provides information about the value that is returned by the function.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c2a89f1d-0d47-4b3e-87e7-232b6b530ea0h
)}(h
}(hX  - **configurations**: the configuration parameters for the plugin. The default value is an empty dictionary.

:::tip
The addition of any extra fields or missing of mandatory fields (marked by * above) would result in a validation failure within the plugin schema.
:::
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$b29b2044-9e0b-45a2-bfa9-f1f05e5fe3b5h
)}(h
}(hX3  The plugin schema is required to be written in YAML format. Here is the plugin schema example of the above anomaly
detection plugin:

```yaml
name: anomaly_detection
enabled: true
plugin_only: false
required: false
description: >-
  anomaly_detection function identifies anomalies from an input DataFrame ofh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$89e3b2f4-8341-4074-86b6-8ba8c5e31391h
)}(h
}(h  time series. It will add a new column "Is_Anomaly", where each entry will be marked with "True" if the value is an anomaly or "False" otherwise.

parameters:
  - name: df
    type: DataFrame
    required: true
    description: >-h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$eb23a6b5-7b62-4be2-af24-ffff1facfef1h
)}(h
}(hX        the input data from which we can identify the anomalies with the 3-sigma
      algorithm.
  - name: time_col_name
    type: str
    required: true
    description: name of the column that contains the datetime
  - name: value_col_name
    type: str
    required: trueh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ed51739c-4efd-41dd-aca7-97365e20223fh
)}(h
}(hX/      description: name of the column that contains the numeric values.

returns:
  - name: df
    type: DataFrame
    description: >-
      This DataFrame extends the input DataFrame with a newly-added column
      "Is_Anomaly" containing the anomaly detection result.
  - name: description
    type: strh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3a672719-a555-41b4-a097-abf078687ed1h
)}(h
}(hX&      description: This is a string describing the anomaly detection results.

```

:::info
Without specifying the `code` field, the plugin schema will use the plugin name as the code file name.
For example, the plugin name is `anomaly_detection` and the code file name is `anomaly_detection.py`.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$50d54774-c350-44d2-84f3-e4cd086353e2h
)}(h
}(hIn cases where the plugin name is not the same as the code file name, you can specify the code name (code file) in
the plugin schema to ensure clarity and accuracy. For example, the plugin name is `anomaly_detection` and the codeh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6474384b-ceeb-4a00-9ca8-4716f2827453h
)}(h
}(hfile name is `anomaly_detection_code.py`. Then, you can specify the code name in the plugin schema as follows:
```yaml
code: anomaly_detection_code
```
Note that the code file name should be the same as the code name without the `.py` extension.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$fe64e0fb-aee2-4a98-a9c5-276c1c0a55e9h
)}(h
}(hXN  Refer to [Multiple YAML files to one Python implementation](./multi_yaml_single_impl.md) for more information on how to 
use this feature.
:::

:::info
When using common code that requires some configuration parameter modifications for different
plugins, it is important to specify these configuration parameters in the plugin schema.h}(hj  hj  hK uhh	uh(hhh}h}(hj  hj  usub$490df3f7-02ee-4ab3-a732-34f1db6aa236h
)}(h
}(hX,  The configuration parameters are specified in the plugin schema as follows:
```yaml
 configurations:
   key1: value1
   key2: value2
 ```
These configuration parameters can be accessed in the plugin implementation as follows:
```python
self.config.get("key1")
self.config.get("key2")
```
:::

:::infoh}(hj  hj  hK!uhh	uh(hhh}h}(hj  hj  usub$662e5142-6577-47a2-88e0-ea4b0a80fee1h
)}(h
}(hWhen this plugin is enabled for the [plugin-only mode](../../advanced/plugin_only.md), set the `plugin_only` field to `true`.
The default value is `false`. Note that all plugins will be loaded in the non-plugin-only mode which is the default mode. h}(hj  hj  hK"uhh	uh(hhh}h}(hj
  hj  usub$cd79c31c-375c-4619-914a-16e24b0f93a3h
)}(h
}(h[But in the plugin-only mode, only the plugins with `plugin_only: true` will be loaded. 
:::h}(hj  hj  hK#uhh	uh(hhh}h}(hj  hj  usub$545fb2bf-33b3-4eff-b1f5-a11912faa02eh
)}(h
}(h---
description: Using LLMs from OpenAI/AOAI
---
# Azure OpenAI

1. Create an account on [Azure OpenAI](https://azure.microsoft.com/en-us/products/ai-services/openai-service) and get your API key.h}(haoai.mdh(description: Using LLMs from OpenAI/AOAIhK uhh	uh(hhh}h}(hj  hj   usub$4c4d4bbd-04c7-42fc-9b58-845637553e4bh
)}(h
}(h2. Add the following to your `taskweaver_config.json` file:
```json showLineNumbers
{
  "llm.api_base":"YOUR_AOAI_ENDPOINT",
  "llm.api_key":"YOUR_API_KEY",
  "llm.api_type":"azure",h}(hj!  hj"  hKuhh	uh(hhh}h}(hj*  hj+  usub$0c5b3afd-117c-4cad-9cbe-cae007a08f5ch
)}(h
}(h  "llm.auth_mode":"api-key",
  "llm.model":"gpt-4-1106-preview", # this is known as deployment_name in Azure OpenAI
  "llm.response_format": "json_object"
}
```

:::infoh}(hj!  hj"  hKuhh	uh(hhh}h}(hj3  hj4  usub$364c30e3-0bbd-41a1-b4dd-6e9cc12c1361h
)}(h
}(hFor model versions or after `1106`, `llm.response_format` can be set to `json_object`.
However, for the earlier models, which do not support JSON response explicitly, `llm.response_format` should be set to `null`.
:::
h}(hj!  hj"  hKuhh	uh(hhh}h}(hj<  hj=  usub$bb67e793-4812-48c4-9e5e-d0ab87ab13e0h
)}(h
}(ht3. Start TaskWeaver and chat with TaskWeaver.
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj!  hj"  hKuhh	uh(hhh}h}(hjE  hjF  usub$3e4d259d-7d37-40da-8330-7984d12a0bb9h
)}(h
}(h# Customized LLM API

We welcome developers to use your customized LLM API in TaskWeaver. 
In this tutorial, we will show you how to contribute your LLM API to TaskWeaver.
h}(hcustomized_llm_api.mdh# Customized LLM APIhK uhh	uh(hhh}h}(hjN  hjO  usub$aa8d79d5-c024-4220-876c-01ebd0048485h
)}(h
}(h1. Create a new Python script `<your_LLM_name>.py` in the `taskweaver/llm` folder. 
2. Import the `CompletionService`, `LLMServiceConfig` and `EmbeddingService` from `taskweaver.llm.base` and other necessary libraries.
```pythonh}(hjP  hjQ  hKuhh	uh(hhh}h}(hjY  hjZ  usub$21ee5d7c-ed4d-492c-a93f-b7773a092779h
)}(h
}(hfrom injector import inject
from taskweaver.llm.base import CompletionService, EmbeddingService, LLMServiceConfig
from taskweaver.llm.util import ChatMessageType
...
```h}(hjP  hjQ  hKuhh	uh(hhh}h}(hjb  hjc  usub$9901d6f3-6305-4c53-94cd-359e9c69245ah
)}(h
}(h3. Create a new class `YourLLMServiceConfig` that inherits from `LLMServiceConfig` and implements the `_configure` method.
In this method, you can set the name, API key, model name, backup model name, and embedding model name of your LLM.
```pythonh}(hjP  hjQ  hKuhh	uh(hhh}h}(hjk  hjl  usub$fa20c117-de47-4c59-85aa-ec50e4da6bd7h
)}(h
}(hX	  class YourLLMServiceConfig(LLMServiceConfig):
    def _configure(self) -> None:
        self._set_name("your_llm_name")

        shared_api_key = self.llm_module_config.api_key
        self.api_key = self._get_str(
            "api_key",
            shared_api_key,h}(hjP  hjQ  hKuhh	uh(hhh}h}(hjt  hju  usub$75811ea9-323d-4526-84fd-86674bdb99bch
)}(h
}(hX          )

        shared_model = self.llm_module_config.model
        self.model = self._get_str(
            "model",
            shared_model if shared_model is not None else "your_llm_model_name",
        )

        shared_backup_model = self.llm_module_config.backup_modelh}(hjP  hjQ  hKuhh	uh(hhh}h}(hj}  hj~  usub$a18592b6-9a9b-4984-88c2-cb17b6ab80f2h
)}(h
}(hX:          self.backup_model = self._get_str(
            "backup_model",
            shared_backup_model if shared_backup_model is not None else self.model,
        )

        shared_embedding_model = self.llm_module_config.embedding_model
        self.embedding_model = self._get_str(
            "embedding_model",h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$27e5b5e4-0e73-4183-98c8-6076ca4e1d44h
)}(h
}(hX              shared_embedding_model if shared_embedding_model is not None else self.model,
        )
```
4. Create a new class `YourLLMService` that inherits from `CompletionService` and `EmbeddingService` and implements the `chat_completion` and `get_embeddings` methods.
```pythonh}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$42be9137-d0b6-4f34-8661-ccc2a3bd9fefh
)}(h
}(hX  class YourLLMService(CompletionService, EmbeddingService):
    @inject
    def __init__(self, config: YourLLMServiceConfig):
        self.config = config
        pass

    def chat_completion(
        self,
        messages: List[ChatMessageType],
        stream: bool = True,h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$0fd386b6-f3a7-4fdc-9ce3-c0e352072b51h
)}(h
}(hX          temperature: Optional[float] = None,
        max_tokens: Optional[int] = None,
        top_p: Optional[float] = None,
        stop: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> Generator[ChatMessageType, None, None]:
        pass
    h}(hjP  hjQ  hK	uhh	uh(hhh}h}(hj  hj  usub$0a7c9ad8-9826-4038-8939-f13f90839be9h
)}(h
}(h    def get_embeddings(self, strings: List[str]) -> List[List[float]]:
        pass
```
Note:
- We set stream mode by default in `chat_completion`.h}(hjP  hjQ  hK
uhh	uh(hhh}h}(hj  hj  usub$9f298f8f-faf8-4a36-bb0a-1253f0cefad5h
)}(h
}(h- You need to use `self.config` to get the configuration variables of your LLM API (e.g., api key/model name) in `YourLLMService` class.
- The `get_embeddings` method is optional. h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$c3fed711-6be1-4a70-a205-eaedc8a8232ah
)}(h
}(h~- If you need to import other libraries for your LLM API, please import them in `__init__` function of `YourLLMService` class.h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$4821b6f5-202e-4cfd-95da-0ce008dadef9h
)}(h
}(hYou can refer to [QWen dashscope library import](https://github.com/microsoft/TaskWeaver/blob/main/taskweaver/llm/qwen.py) for an example.
h}(hjP  hjQ  hK
uhh	uh(hhh}h}(hj  hj  usub$d29bb29c-7c4b-4ddb-a252-ffd5064b82d0h
)}(h
}(h5. Register your LLM service in `taskweaver/llm/__init__.py` by adding your LLM service to the `LLMApi` `__init__` function .
```python 
......
from .your_llm_name import YourLLMService # import your LLM service here
h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$7e47235a-6928-4a41-a854-66f7b9c491b9h
)}(h
}(hclass LLMApi(object):
    @inject
    def __init__(self, config: LLMModuleConfig, injector: Injector) -> None:
        self.config = config
        self.injector = injector

        if self.config.api_type in ["openai", "azure", "azure_ad"]:h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$32e5e812-61cb-4c3e-988c-72a2b3b9f8bah
)}(h
}(h            self._set_completion_service(OpenAIService)
            
        ......
        
        elif self.config.api_type == "your_llm_name":
            self._set_completion_service(YourLLMService) # register your LLM service here
        else:h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$d5a23ab0-62b6-44b4-8d7a-8a20dca8f3a0h
)}(h
}(hX7              raise ValueError(f"API type {self.config.api_type} is not supported")

        if self.config.embedding_api_type in ["openai", "azure", "azure_ad"]:
            self._set_embedding_service(OpenAIService)
            
        ......
        
        elif self.config.embedding_api_type == "azure_ml":h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$72971342-c0e1-4acf-b112-5cdad376d9ceh
)}(h
}(hXO              self.embedding_service = PlaceholderEmbeddingService(
                "Azure ML does not support embeddings yet. Please configure a different embedding API.",
            )
        # register your embedding service here, if do not have embedding service, please use `PlaceholderEmbeddingService` referring to the above lineh}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$a2a62969-4d92-4f8c-b332-ada894696e50h
)}(h
}(hX          elif self.config.embedding_api_type == "your_llm_name": 
            self._set_embedding_service(YourLLMService)
        else:
            raise ValueError(
                f"Embedding API type {self.config.embedding_api_type} is not supported",
            )
```
h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$517867bb-1434-47f5-a49d-b8f5f7ed90e6h
)}(h
}(h5. Configurate `taskweaver_config.json` file in the `project` dir based on your implemented LLM API.
6. Run the following command to test your LLM API. If the LLM API is successfully set up, you will see the response from your LLM API.
```bashh}(hjP  hjQ  hKuhh	uh(hhh}h}(hj  hj  usub$9d3a3136-00e0-4488-82e9-1d7cc1480da3h
)}(h
}(hcd ./scripts
python llm_api_test.py
```
You also can specify the project dir and query to be sent to your LLM API by using the following command:
```bash
python llm_api_test.py --project <your_project_path> --query "hello, what can you do?" 
```h}(hjP  hjQ  hKuhh	uh(hhh}h}(hj
  hj  usub$a66810fa-bd18-4c1a-b04c-ac75496a1fadh
)}(h
}(h# Gemini

1. Create an account on [Google AI](https://ai.google.dev/) and get your API key.
2. Add the following content to your `taskweaver_config.json` file:
```json showLineNumbers
{
"llm.api_type": "google_genai",h}(h	gemini.mdh# GeminihK uhh	uh(hhh}h}(hj  hj  usub$12c8b6e8-3771-4cbb-86ad-b084571f2c4dh
)}(h
}(h"llm.google_genai.api_key": "YOUR_API_KEY",
"llm.google_genai.model": "gemini-pro"
}
```

3. Start TaskWeaver and chat with TaskWeaver.
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hj!  hj"  usub$1faee0bd-01bd-40e2-b7ec-fc3560883909h
)}(h
}(h# GLM
h}(hglm.mdh# GLMhK uhh	uh(hhh}h}(hj*  hj+  usub$f63c9abc-eeda-4482-9d93-262297f51a15h
)}(h
}(h1. GLM (ChatGLM) is a LLM developed by Zhipu AI and Tsinghua KEG. Go to [ZhipuAI](https://open.bigmodel.cn/) and register an account and get the API key. More details can be found [here](https://open.bigmodel.cn/overview).h}(hj,  hj-  hKuhh	uh(hhh}h}(hj5  hj6  usub$ea155b22-52ba-44d9-8cd7-67501b067cb7h
)}(h
}(h2. Install the required packages dashscope.
```bash
pip install zhipuai
```
3. Add the following configuration to `taskweaver_config.json`:
```json showLineNumbers
{
  "llm.api_type": "zhipuai",
  "llm.model": "glm-4",h}(hj,  hj-  hKuhh	uh(hhh}h}(hj>  hj?  usub$2f9fb0d0-4fbf-424c-8f06-7ae1ffa77259h
)}(h
}(h  "llm.embedding_model": "embedding-2",
  "llm.embedding_api_type": "zhipuai",
  "llm.api_key": "YOUR_API_KEY"
}
```
NOTE: `llm.model` is the model name of zhipuai  API. h}(hj,  hj-  hKuhh	uh(hhh}h}(hjG  hjH  usub$5e93de6b-4949-4650-96dd-362dbb5e3939h
)}(h
}(hYou can find the model name in the [GLM model list](https://open.bigmodel.cn/dev/api#language).

4. Start TaskWeaver and chat with TaskWeaver. 
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj,  hj-  hKuhh	uh(hhh}h}(hjP  hjQ  usub$aa80c06d-80de-4976-8158-aa235301b185h
)}(h
}(h# GroqChat
h}(hgroq.mdh
# GroqChathK uhh	uh(hhh}h}(hjY  hjZ  usub$6240da72-6512-45bb-bd88-43cdd592ae13h
)}(h
}(hXi  1. Groq was founded in 2016 by Chief Executive Officer `Jonathan Ross`, a former Google LLC engineer who invented the search giant's TPU machine learning processors. Go to [Groq](https://groq.com/) and register an account and get the API key from [here](https://console.groq.com/keys). More details can be found [here](https://console.groq.com/docs/quickstart).h}(hj[  hj\  hKuhh	uh(hhh}h}(hjd  hje  usub$fc805f02-421e-4ed2-acab-e7832496aaa1h
)}(h
}(h2. Install the required packages `groq`.
```bash
pip install groq
```
3. Add the following configuration to `taskweaver_config.json`:
```json showLineNumbers
{
    "llm.api_base": "https://console.groq.com/",h}(hj[  hj\  hKuhh	uh(hhh}h}(hjm  hjn  usub$65d7e5c8-1a06-4442-86e7-019b445487dch
)}(h
}(hr    "llm.api_key": "YOUR_API_KEY",
    "llm.api_type": "groq",
    "llm.model": "mixtral-8x7b-32768"
}
```

:::tiph}(hj[  hj\  hKuhh	uh(hhh}h}(hjv  hjw  usub$aee03195-bea2-466e-bfdb-abfc73191c5fh
)}(h
}(hNOTE: `llm.model` is the model name of Groq LLM API. 
You can find the model name in the [Groq LLM model list](https://console.groq.com/docs/models).
:::

4. Start TaskWeaver and chat with TaskWeaver. h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$f6382b31-d798-4073-86b1-f5f8da25093dh
)}(h
}(hFYou can refer to the [Quick Start](../quickstart.md) for more details.h}(hj[  hj\  hKuhh	uh(hhh}h}(hj  hj  usub$817c5f6b-2670-4cf6-8c76-6aab570178abh
)}(h
}(h---
description: List for all supported LLMs 
---
# Supported LLMs 

```mdx-code-block
import DocCardList from '@theme/DocCardList';

<DocCardList />
```h}(hindex.mdh(description: List for all supported LLMshK uhh	uh(hhh}h}(hj  hj  usub$559a219f-f50f-4668-9a12-99add6a5cb89h
)}(h
}(h@---
description: Using LLMs from LiteLLM
---

# LiteLLM

:::infoh}(h
liteLLM.mdh$description: Using LLMs from LiteLLMhK uhh	uh(hhh}h}(hj  hj  usub$b0259dd7-7bea-4caa-9a9a-f9d902e44912h
)}(h
}(hXe  [LiteLLM](https://docs.litellm.ai/) provides a unified interface to call 100+ LLMs using the same Input/Output format, including OpenAI, Huggingface, Anthropic, vLLM, Cohere, and even custom LLM API server. Taking LiteLLM as the bridge, many LLMs can be onboarded to TaskWeaver. Here we use the OpenAI Proxy Server provided by LiteLLM to make configuration.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3a93fe7f-6b85-4d74-8b57-d17efbb3802bh
)}(h
}(h:::

1. Install LiteLLM Proxy and configure the LLM server by following the instruction [here](https://docs.litellm.ai/docs/proxy/quick_start). In general, there are a few steps:
    1. Install the package `pip install litellm[proxy]`h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6fe77956-73a6-46a0-9330-264e8a4361b6h
)}(h
}(h    2. Setup the API key and other necessary environment variables which vary by LLM. Taking [Cohere](https://cohere.com/) as an example, it is required to setup `export COHERE_API_KEY=my-api-key`.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$152d9766-8f6e-4424-9f4e-26aec2665d68h
)}(h
}(hX      3. Run LiteLLM proxy server by `litellm --model MODEL_NAME --drop_params`, for example, in Cohere, the model name can be `command-nightly`. The `drop-params` argument is used to ensure the API compatibility. Then, a server will be automatically started on `http://0.0.0.0:8000`.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$ab22a42f-3c57-428a-b599-6bd370e1d671h
)}(h
}(h
:::tip
The full list of supported models by LiteLLM can be found in the [page](https://docs.litellm.ai/docs/providers).
:::

2. Add the following content to your `taskweaver_config.json` file:

```json showLineNumbers
{h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$de17b68a-69a5-44ae-9aa6-ba84b8b9e2cbh
)}(h
}(hs  "llm.api_base": "http://0.0.0.0:8000",
  "llm.api_key": "anything",
  "llm.model": "gpt-3.5-turbo"
}
```

:::infoh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c7301972-22c8-4265-b407-fcaeda8ad21eh
)}(h
}(hX  `llm.api_key` and `llm.model` are mainly used as placeholder for API call, whose actual values are not used. If the configuration does not work, please refer to LiteLLM [documents](https://docs.litellm.ai/docs/proxy/quick_start) to locally test whether you can send requests to the LLM. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$7b772302-46cb-40ea-a46f-14a51286ac1ch
)}(h
}(h~:::

3. Open a new terminal, start TaskWeaver and chat.
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$da0e97ef-11e0-4193-ac00-68fdb617a63fh
)}(h
}(h# Multi LLM APIs

In some cases, you may want to use different LLMs for different components. 
For example, you may want to use OpenAI GPT-4 for the Planner but use Google gemini-pro for the CodeInterpreter.h}(hmulti-llm.mdh# Multi LLM APIshK uhh	uh(hhh}h}(hj  hj  usub$2b2467dd-61e1-4ebe-a4dc-8a3a2f0a906bh
)}(h
}(hIn this part, we show you how to use different LLMs for different components.

If you need only one LLM, you can have only the primary LLM settings in the `taskweaver_config.json` file.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$7cfe9810-8f3a-4607-8777-d708d00b82c6h
)}(h
}(hIf you need multiple LLMs, you need to have `ext_llms.llm_configs` in the `taskweaver_config.json` file to specify the extra LLMs for different components.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f6c04822-a993-427b-a01b-86ea16b8b74eh
)}(h
}(hIn the following, we show you how to configure the `taskweaver_config.json` file to use multiple LLMs.
```json
"llm.api_type":"openai",
"llm.api_base": "https://api.openai.com/v1",
"llm.api_key": "YOUR_API_KEY",h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj
  usub$c390cde6-1709-4fe0-9db0-33e17bf22621h
)}(h
}(h"llm.model": "gpt-3.5-turbo-1106",
"llm.response_format": "json_object"
"ext_llms.llm_configs": {
    "llm_A":
        {
            "llm.api_type": "openai",h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$a5442741-4235-4654-ba72-e952660ca14bh
)}(h
}(h            "llm.api_base": "https://api.openai.com/v1",
            "llm.api_key": "YOUR_API_KEY",
            "llm.model": "gpt-4-1106-preview",
            "llm.response_format": "json_object",
        },
    "llm_B":h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$3d295d47-e3eb-45be-b990-7c3db1b02e5ch
)}(h
}(h        {
            "llm.api_type": "google_genai",
            "llm.api_key": "YOUR_API_KEY",
            "llm.model": "gemini-pro",
        },
},
```

- The primary LLM settings are specified in the `llm.` fields and it is mandatory.h}(hj  hj  hKuhh	uh(hhh}h}(hj'  hj(  usub$8d47ac77-378d-4f65-b18b-408b3ff8b861h
)}(h
}(h- `ext_llms.llm_configs` is optional and is a dict of extra LLMs for different components. If you do not specify it, only the primary LLM will be used.
 

Specify the LLMs for different components in the `taskweaver_config.json`.h}(hj  hj  hKuhh	uh(hhh}h}(hj0  hj1  usub$3902c9e6-f183-476e-978d-257fa1f6c1abh
)}(h
}(hFor example, we want to use OpenAI GPT-4 for the Planner and use Google gemini-pro for the CodeInterpreter.
```json
"planner.llm_alias": "llm_A",
"code_generator.llm_alias": "llm_B"
```
:::tiph}(hj  hj  hKuhh	uh(hhh}h}(hj9  hj:  usub$4b1371a5-9e74-4a32-8108-56539a38380fh
)}(h
}(hIf you do not specify the LLM for a component, the primary LLM will be used by default.
In the above example, `GPT-3.5-turbo-1106` will be used for both the Planner and the CodeInterpreter.
:::h}(hj  hj  hK	uhh	uh(hhh}h}(hjB  hjC  usub$314a76a1-1eae-486b-8283-30d0a6a13b85h
)}(h
}(h# Ollama

1. Go to [Ollama](https://github.com/jmorganca/ollama) and follow the instructions to serve a LLM model on your local environment.h}(h	ollama.mdh# OllamahK uhh	uh(hhh}h}(hjK  hjL  usub$2f33a2d4-41c3-44c0-ba53-b9ea9ae2f06fh
)}(h
}(hWe provide a short example to show how to configure the ollama in the following, which might change if ollama makes updates.

```bash title="install ollama and serve LLMs in local" showLineNumbers
## Install ollama on Linux & WSL2h}(hjM  hjN  hKuhh	uh(hhh}h}(hjV  hjW  usub$36418ef8-8256-40c7-af56-a6523247cc06h
)}(h
}(hcurl https://ollama.ai/install.sh | sh
## Run the serving
ollama serve
```
Open another terminal and run:
```bash
ollama run llama2:13b
```
:::tiph}(hjM  hjN  hKuhh	uh(hhh}h}(hj_  hj`  usub$7f16ff7c-1740-4442-bba9-426ed25c70e1h
)}(h
}(hWe recommend deploying the LLM with a parameter scale exceeding 13B for enhanced performance (such as Llama 2 13B).
:::

:::infoh}(hjM  hjN  hKuhh	uh(hhh}h}(hjh  hji  usub$bd4cf214-f0d2-45c1-a546-3d2b81d76531h
)}(h
}(hWhen serving LLMs via Ollama, it will by default start a server at `http://localhost:11434`, which will later be used as the API base in `taskweaver_config.json`.
:::

2. Add following configuration to `taskweaver_config.json`:
```json showLineNumbers
{h}(hjM  hjN  hKuhh	uh(hhh}h}(hjq  hjr  usub$2dec47fc-2ba9-4ce3-b80a-3898a6a042eah
)}(h
}(h    "llm.api_base": "http://localhost:11434",
    "llm.api_key": "ARBITRARY_STRING",
    "llm.api_type": "ollama",
    "llm.model": "llama2:13b"
}
```h}(hjM  hjN  hKuhh	uh(hhh}h}(hjz  hj{  usub$ecc6d499-46df-446a-bd6a-0f07bfdcf701h
)}(h
}(hNOTE: `llm.api_base` is the URL started in the Ollama LLM server and `llm.model` is the model name of Ollama LLM, it should be same as the one you served before. 

3. Start TaskWeaver and chat with TaskWeaver. h}(hjM  hjN  hKuhh	uh(hhh}h}(hj  hj  usub$8a2968fd-4100-48dd-a5cb-8fac7a332ed1h
)}(h
}(hFYou can refer to the [Quick Start](../quickstart.md) for more details.h}(hjM  hjN  hKuhh	uh(hhh}h}(hj  hj  usub$7127078c-5527-453d-a31b-fd8b330a4d79h
)}(h
}(h---
description: Using LLMs from OpenAI
---
# OpenAI

1. Create an account on [OpenAI](https://beta.openai.com/) and get your [API key](https://platform.openai.com/api-keys).
2. Add the following to your `taskweaver_config.json` file:h}(h	openai.mdh#description: Using LLMs from OpenAIhK uhh	uh(hhh}h}(hj  hj  usub$a9ff8b4a-c97d-4124-a763-8a1433cc58ach
)}(h
}(h```json showLineNumbers
{
  "llm.api_type":"openai",
  "llm.api_base": "https://api.openai.com/v1",
  "llm.api_key": "YOUR_API_KEY",
  "llm.model": "gpt-4",h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$27da3a39-5e58-48a3-8d15-28d461d10f9ch
)}(h
}(h  "llm.response_format": "json_object"
}
```
:::tip
`llm.model` is the model name you want to use.
You can find the list of models [here](https://platform.openai.com/docs/models).
:::

:::infoh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$425a5d24-7f31-4db1-9006-c25fc2f58595h
)}(h
}(hFor model versions equal or after `1106`, `llm.response_format` can be set to `json_object`.
However, for the earlier models which do not support JSON response explicitly, `llm.response_format` should be set to `null`.
:::h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$98fc4dea-b04d-4190-b3b2-3bceffa6a6beh
)}(h
}(ht3. Start TaskWeaver and chat with TaskWeaver.
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$337823f8-63a9-4c5c-865d-aaa8ad77be15h
)}(h
}(h# QWen
h}(hqwen.mdh# QWenhK uhh	uh(hhh}h}(hj  hj  usub$86d250b2-a783-45fa-a0e2-98c2b7e7ea71h
)}(h
}(hXH  1. QWen (Tongyi Qianwen) is a LLM developed by Alibaba. Go to [QWen](https://dashscope.aliyun.com/) and register an account and get the API key. More details can be found [here](https://help.aliyun.com/zh/dashscope/developer-reference/activate-dashscope-and-create-an-api-key?spm=a2c4g.11186623.0.0.7b5749d72j3SYU) (in Chinese).h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6b22795d-a25f-4239-8728-6c97b36c225ah
)}(h
}(h2. Install the required packages dashscope.
```bash
pip install dashscope
```
3. Add the following configuration to `taskweaver_config.json`:
```json showLineNumbers
{
    "llm.api_type": "qwen",
    "llm.model": "qwen-max", h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$7ba11285-ed06-464e-9ebe-8e5933401188h
)}(h
}(h]    "llm.api_key": "YOUR_API_KEY"
}
```
NOTE: `llm.model` is the model name of QWen LLM API. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$5488c368-5622-4123-88e3-f1412357e6dfh
)}(h
}(hYou can find the model name in the [QWen LLM model list](https://help.aliyun.com/zh/dashscope/developer-reference/model-square/?spm=a2c4g.11186623.0.0.35a36ffdt97ljI).
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$f020a526-eb4a-4485-b931-6ae4bca0778eh
)}(h
}(hu4. Start TaskWeaver and chat with TaskWeaver. 
You can refer to the [Quick Start](../quickstart.md) for more details.h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$67d86635-ac13-41d9-8ed5-6caff8310a4ah
)}(h
}(hX$  # Terminal

This is the command line interface for TaskWeaver. You can interact with TaskWeaver through this interface.

Follow the instruction in [Quick Start](../quickstart.md) to clone the repository and fill in the necessary configurations.

Run the following command in terminal.
```bashh}(hcmd.mdh
# TerminalhK uhh	uh(hhh}h}(hj  hj  usub$97856152-faea-4609-bc9d-fa251f78adbdh
)}(h
}(h# assume you are in the TaskWeaver folder
python -m taskweaver -p ./project/ # -p is the path to the project directory
```
This will start the TaskWeaver process, and you can interact with it through the command line interface. h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$4d0a1a9b-9671-4374-a85d-d2273376434ah
)}(h
}(hIf everything goes well, you will see the following prompt:

```bash
=========================================================
 ___         _     _       __
|_   _|_ _ ___| | _ | |     / /__  ___ __   ___  ___h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$59ea3cd9-9b76-4a50-9e3d-4d927f863492h
)}(h
}(ho  | |/ _` / __| |/ /| | /| / / _ \/ __ `/ | / / _ \/ ___/
  | | (_| \__ \   < | |/ |/ /  __/ /_/ /| |/ /  __/ /h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$c1c384c6-52c3-49aa-8491-0276f81d566bh
)}(h
}(h  |_|\__,_|___/_|\_\|__/|__/\___/\__,_/ |___/\___/_/
=========================================================
TaskWeaver: I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
Human: ___
```
h}(hj  hj  hKuhh	uh(hhh}h}(hj"  hj#  usub$dc926f2e-9fa1-43e9-9d93-0a4f4ee08fceh
)}(h
}(hWe have provided a set of commands to interact with TaskWeaver. You can type `help` to see the list of available commands.
All commands start with a `/` character. For example, you can type `/help` to see the list of available commands.

```bashh}(hj  hj  hKuhh	uh(hhh}h}(hj+  hj,  usub$66974d50-c05b-447a-9d98-0dca1c60efa4h
)}(h
}(hX   TaskWeaver ▶  I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
    Human   ▶  /help

TaskWeaver Chat Console
---
/load <file>: load a file
/info: print the information of the current session
/reset: reset the sessionh}(hj  hj  hKuhh	uh(hhh}h}(hj4  hj5  usub$93106d00-b4a8-40ee-b38f-f714892a7047h
)}(h
}(hXO  /clear: clear the console
/exit: exit the chat console
/help: print this help message
/save: save the chat history of the current session for experience extraction
```

The table of commands supported by TaskWeaver is as follows:

| Command        | Description                                                               |
|---|---|h}(hj  hj  hKuhh	uh(hhh}h}(hj=  hj>  usub$cc5c39bd-1fc7-4a6a-b559-9a16664d4954h
)}(h
}(h| `/load <file>` | Load a file by its absolute path, e.g., /load /home/taskweaver/sample.csv |
| `/info`        | Print the session id and the active roles of the current session          |h}(hj  hj  hKuhh	uh(hhh}h}(hjF  hjG  usub$bb1632ce-32c6-47f3-a2bb-8e113976fb62h
)}(h
}(hX{  | `/reset`       | Reset the current session and start a new session                         |
| `/clear`       | Clear the console content                                                 |
| `/exit`        | Exit the chat console                                                     |
| `/help`        | Print the help message                                                    |h}(hj  hj  hK	uhh	uh(hhh}h}(hjO  hjP  usub$a8958b19-1dc6-45bd-8d17-e4ea866bdec2h
)}(h
}(h| `/save`        | Save the chat history of the current session for experience extraction    |

:::tip
When TaskWeaver runs generated code, the CWD (current working directory) is set to the `project/workspace/session_id/cwd` directory.h}(hj  hj  hK
uhh	uh(hhh}h}(hjX  hjY  usub$d2d47c7c-b82a-470f-be1a-1accdb9d90f7h
)}(h
}(hiIf you need to use relative paths in the generated code, the `cwd` directory should be the base path.
:::h}(hj  hj  hKuhh	uh(hhh}h}(hja  hjb  usub$b4705ba0-680c-4e6c-abe5-dceb75b1f3fch
)}(h
}(hX  # All-in-One Docker Image

In this document, we will show you how to run TaskWeaver using the All-in-One Docker Image.
Please note that the All-in-One Docker Image is for development and testing purposes only.

## Prerequisites
You need to have Docker installed on your machine. 
h}(h	docker.mdh# All-in-One Docker ImagehK uhh	uh(hhh}h}(hjj  hjk  usub$b1b57216-63b3-4f16-90b2-0b687bedc71ch
)}(h
}(hX)  For Windows and macOS users, you can use Docker Desktop. You can download it from [Docker's official website](https://www.docker.com/products/docker-desktop).

For Linux users, you can install following the instructions in the [Docker's official website](https://docs.docker.com/engine/install/). h}(hjl  hjm  hKuhh	uh(hhh}h}(hju  hjv  usub$800a8902-4eaa-4330-9e5d-d0539607862fh
)}(h
}(hX9  Please find the installation guide for your specific Linux distribution.

## Run TaskWeaver using the All-in-One Docker Image

There are two versions of the TaskWeaver All-in-One Docker Image:
- `taskweavercontainers/taskweaver-all-in-one:latest`: This version includes the Planner and CodeInterpreter roles only.h}(hjl  hjm  hKuhh	uh(hhh}h}(hj~  hj  usub$81c267b3-6064-4d29-9b44-0d38c1ef38e4h
)}(h
}(hX.  You can use this container for code generation and execution tasks.
- `taskweavercontainers/taskweaver-all-in-one:latest-ws`: This version includes an additional WebSearch role which can search the web for information. 
As it requires dependencies to the `sentence-transformers` library, it is larger.
h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$2df021f5-2514-4dc5-8bb3-55078a40878bh
)}(h
}(hX  Open a terminal and run the following command to obtain the TaskWeaver image:

```bash
docker pull taskweavercontainers/taskweaver-all-in-one:latest
# if you want to use the version with the WebSearch role 
# docker pull taskweavercontainers/taskweaver-all-in-one:latest-ws
```
h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$e5b39832-804b-47bd-b075-67db64143934h
)}(h
}(hOnce the image is pulled, you can run the TaskWeaver container using the following command:

```bash
docker run -it -e LLM_API_BASE=<API_BASE> \
  -e LLM_API_KEY=<API_KEY> \
  -e LLM_API_TYPE=<API_TYPE> \h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$b1d01240-bb9a-4306-a5f2-50e33ec884aah
)}(h
}(h  -e LLM_MODEL=<MODEL> \
  taskweavercontainers/taskweaver-all-in-one:latest
```

If you want to run TaskWeaver in UI mode, you can use the following command:

```bash
docker run -it -e LLM_API_BASE=<API_BASE> \h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$be5108e1-d255-4930-9b91-0db79f49f252h
)}(h
}(h  -e LLM_API_KEY=<API_KEY> \
  -e LLM_API_TYPE=<API_TYPE> \
  -e LLM_MODEL=<MODEL> \
  -p 8000:8000 \
  --entrypoint /app/entrypoint_chainlit.sh \h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$687f6369-6032-4dda-8c60-78663f242868h
)}(h
}(h  taskweavercontainers/taskweaver-all-in-one:latest 
```
Then you can access the TaskWeaver Web UI by visiting [http://localhost:8000](http://localhost:8000) in your web browser.

## How to run TaskWeaver on your own project directoryh}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$97e2f306-19bf-44c2-adbe-d45bb9bfae66h
)}(h
}(hYou can mount your local `project` directory to the container. For example, you can use the following command:

```bash
docker run -it -e LLM_API_BASE=<API_BASE> \
  -e LLM_API_KEY=<API_KEY> \
  -e LLM_API_TYPE=<API_TYPE> \h}(hjl  hjm  hK	uhh	uh(hhh}h}(hj  hj  usub$9eae6558-16b9-4091-9ac7-4780d2cbfe52h
)}(h
}(h  -e LLM_MODEL=<MODEL> \
#  -e TASKWEAVER_UID=$(id -u) \ # uncomment if your host OS is not Windows
#  -e TASKWEAVER_GID=$(id -g) \ # uncomment if your host OS is not Windowsh}(hjl  hjm  hK
uhh	uh(hhh}h}(hj  hj  usub$e93d80cf-10fc-4b7c-af11-b928d3f3b2bfh
)}(h
}(h  --mount type=bind,source=<your_local_project_dir>,target=/app/TaskWeaver/project/ \
  taskweavercontainers/taskweaver-all-in-one:latest
```
Then you can edit the `taskweaver_config.json` file in your local `project` directory to configure TaskWeaver.h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$8522c4cc-dc96-42b4-ba17-42275b365036h
)}(h
}(hIn addition, you also can customize the plugins and examples in your local `project` directory.
The structure of the `project` directory can be referred to the `taskweaver/project` directory.

## How to access your local files in the containerh}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$010f248b-78b1-428b-962a-64ea81aa7a83h
)}(h
}(hYou can mount your local directory to the container. For example, you can use the following command:

```bash
docker run -it -e LLM_API_BASE=<API_BASE> \
  -e LLM_API_KEY=<API_KEY> \
  -e LLM_API_TYPE=<API_TYPE> \h}(hjl  hjm  hK
uhh	uh(hhh}h}(hj  hj  usub$fafef783-0669-4d6e-88b6-a8152d1c2861h
)}(h
}(h  -e LLM_MODEL=<MODEL> \
#  -e TASKWEAVER_UID=$(id -u) \ # uncomment if your host OS is not Windows
#  -e TASKWEAVER_GID=$(id -g) \ # uncomment if your host OS is not Windowsh}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$98d04b4f-64ac-4ad1-9d82-4ed94e1a58e2h
)}(h
}(h  --mount type=bind,source=<your_local_dir>,target=/app/TaskWeaver/local/ \
  taskweavercontainers/taskweaver-all-in-one:latest
```

Then you can access your local files in the container by visiting the `/app/TaskWeaver/local/` directory.h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$d60269b1-ae10-4d6e-875e-483775f40deah
)}(h
}(hYou can load a file under the `/app/TaskWeaver/local/` directory in the TaskWeaver CLI 
with the `/load` command. For example, you can load a file named `example.csv` by running the following command:

```bashh}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$fca95173-4ef1-4f40-b5f3-c2758480d282h
)}(h
}(h TaskWeaver ▶  I am TaskWeaver, an AI assistant. To get started, could you please enter your request?
    Human   ▶  /load /app/TaskWeaver/local/example.csv
    Human   ▶  display the column names of the loaded file
```h}(hjl  hjm  hKuhh	uh(hhh}h}(hj  hj  usub$4bd75d09-4e98-4340-b1ab-594cf94b4f7dh
)}(h
}(hX  # Library

If you want to use TaskWeaver as a library, you can refer to the following code example:

```python
from taskweaver.app.app import TaskWeaverApp

# This is the folder that contains the taskweaver_config.json file and not the repo root. Defaults to "./project/"h}(h
library.mdh	# LibraryhK uhh	uh(hhh}h}(hj  hj  usub$5b1f3936-5aad-4529-9433-687e31bfd0cah
)}(h
}(happ_dir = "./project/"
app = TaskWeaverApp(app_dir=app_dir)
session = app.get_session()

user_query = "hello, what can you do?"
response_round = session.send_message(user_query)
print(response_round.to_dict())
```
h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$1e137c08-4144-4831-b044-4be911cebba6h
)}(h
}(hEssentially, you need to create a [TaskWeaverApp](../concepts/app.md) object and then get a [session](../concepts/session.md) object from it.
Each time, you can send a message to TaskWeaver by calling `session.send_message(user_query)`.h}(hj  hj  hKuhh	uh(hhh}h}(hj"  hj#  usub$cb98ed3f-6436-4e42-887f-6a66374a3c93h
)}(h
}(hX  The return value of `session.send_message(user_query)` is a [Round](../concepts/round.md) object, which contains the response from TaskWeaver.
A round is a conversation round between the user and TaskWeaver, which contains a list of [posts](../concepts/post.md).
h}(hj  hj  hKuhh	uh(hhh}h}(hj+  hj,  usub$7c075f57-e290-4913-8d8f-573a660cab02h
)}(h
}(hAn example of the `Round` object is shown below. To better understand the structure, you can refer to the [Concepts](../concepts) section.
```json
{
    "id": "round-20231201-043134-218a2681",h}(hj  hj  hKuhh	uh(hhh}h}(hj4  hj5  usub$42432cf0-c885-4cff-b5a8-1566b2ea4d86h
)}(h
}(h    "user_query": "hello, what can you do?",
    "state": "finished",
    "post_list": [
        {
            "id": "post-20231201-043134-10eedcca",
            "message": "hello, what can you do?",h}(hj  hj  hKuhh	uh(hhh}h}(hj=  hj>  usub$a9b86058-e15a-487d-9f63-b2950ad67c8ah
)}(h
}(h            "send_from": "User",
            "send_to": "Planner",
            "attachment_list": []
        },
        {
            "id": "post-20231201-043141-86a2aaff",h}(hj  hj  hKuhh	uh(hhh}h}(hjF  hjG  usub$5a6ce7b5-0c9e-4c05-acfb-cc57150f5bb6h
)}(h
}(hXX              "message": "I can help you with various tasks, such as counting rows in a data file, detecting anomalies in a dataset, searching for products on Klarna, summarizing research papers, and pulling data from a SQL database. Please provide more information about the task you want to accomplish, and I'll guide you through the process.",h}(hj  hj  hKuhh	uh(hhh}h}(hjO  hjP  usub$ec1961e3-13d1-4a8e-8e37-4a5588fcfb7ah
)}(h
}(h            "send_from": "Planner",
            "send_to": "User",
            "attachment_list": [
                {
                    "id": "atta-20231201-043141-6bc4da86",
                    "type": "init_plan",h}(hj  hj  hKuhh	uh(hhh}h}(hjX  hjY  usub$e9fae04c-4060-40e0-bb19-f0fecebe1976h
)}(h
}(hX*                      "content": "1. list the available functions"
                },
                {
                    "id": "atta-20231201-043141-6f29f6c9",
                    "type": "plan",
                    "content": "1. list the available functions"
                },
                {h}(hj  hj  hK	uhh	uh(hhh}h}(hja  hjb  usub$7cb4e4f6-8803-464d-bf66-16daa9baa9b6h
)}(h
}(h                    "id": "atta-20231201-043141-76186c7a",
                    "type": "current_plan_step",
                    "content": "1. list the available functions"
                }
            ]
        }
    ]
}
```

:::tiph}(hj  hj  hK
uhh	uh(hhh}h}(hjj  hjk  usub$8d07b210-4848-4a3e-a8a2-05e8ab319b09h
)}(h
}(hX/  If you need to see the intermediate states of the conversation, you need to implement a `SessionEventHandler` class and pass it 
  at calling `session.send_message(user_query, event_handler=your_event_handler)`. 
  Find more information about the event handler in [this section](../concepts/session.md).h}(hj  hj  hKuhh	uh(hhh}h}(hjs  hjt  usub$878c916d-cc24-497e-8778-85a509754638h
)}(h
}(h:::h}(hj  hj  hKuhh	uh(hhh}h}(hj|  hj}  usub$4830fd60-fae0-48e7-8af6-6204f59e7979h
)}(h
}(h# Web UI

Please note that this Web UI is for development and testing purposes only.

Follow the instruction in [Quick Start](../quickstart.md) to clone the repository and fill in the necessary configurations.
h}(hwebui.mdh# Web UIhK uhh	uh(hhh}h}(hj  hj  usub$253de03a-5994-43ea-b538-3bde8a4c5c1fh
)}(h
}(hX  Install the `chainlit` package by `pip install -U chainlit` if you don't have it in your environment.

Start the service by running the following command.

```bash
# assume you are in the TaskWeaver folder
cd playground/UI/
# make sure you are in playground/UI/ folderh}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$6772bd53-1a7f-4caf-84cc-3c0ec4629ecfh
)}(h
}(hchainlit run app.py
```

Open the browser with http://localhost:8000 if it doesn't open automatically. 
:::info
We now support uploading files using the Web UI. 
:::
Below are some screenshots of the Web UI:h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$60f2d829-d60b-4c41-a9d3-98becdfdb1ech
)}(h
}(h![TaskWeaver UI Screenshot 1](../../static/img/ui_screenshot_1.png)
![TaskWeaver UI Screenshot 2](../../static/img/ui_screenshot_2.png)h}(hj  hj  hKuhh	uh(hhh}h}(hj  hj  usub$21c1c0d4-bf82-411c-8e98-a553d66ce5bdh
)}(h
}(h# How to evaluate a LLM agent?

## The challenges
It is nontrivial to evaluate the performance of a LLM agent. 
Existing evaluation methods typically treat the LLM agent as a function that maps input data to output data.h}(hhh# How to evaluate a LLM agent?hK uhh	uh(hhh}h}(hj  hj  usub$9ba167f7-3bcf-463d-8fda-4f3bd29b243ch
)}(h
}(hIf the agent is evaluated against a multi-step task, the evaluation process is then like a chain of calling a stateful function multiple times.
To judge the output of the agent, it is typically compared to a ground truth or a reference output.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$50a113b6-e03b-4152-903c-6f69e5cb5c22h
)}(h
}(hAs the output of the agent is in natural language, the evaluation is typically done by matching keywords or phrases in the output to the ground truth.

This evaluation method has its limitations due to its rigid nature. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$1ec16007-e085-4560-9edb-3882f7d954a9h
)}(h
}(hIt is sometimes hard to use keywords matching to evaluate the output of the agent, especially when the output is long and complex.
For example, if the answer is a date or a number, the evaluation method may not be able to handle the different formats.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$c0a00736-2ce2-4c2d-becd-fc41ebd0ff23h
)}(h
}(hX=  Moreover, the evaluation method should be able to act more like a human, who can understand the context and the meaning of the output.
For example, when different agents are asked to perform the same task, they may behave differently, but still produce correct outputs.

The below example illustrates this point:

```h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$04083521-cfb4-4a30-bc13-ce89c6dab923h
)}(h
}(hHuman: What is the weather today?
Agent 1: It is sunny today in New York.
```

```
Human: What is the weather today?
Agent 2: Do you want to know the weather in New York today?
Human: Yes.
Agent 2: It is sunny today.
```
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$7fa4fc6f-86c1-4550-93e9-7150b260e147h
)}(h
}(hX?  Compared to Agent 1, Agent 2 asks for confirmation before providing the answer, which requires more interaction with the user.
However, both agents provide the correct answer to the question.
But if the evaluation method takes the agent as a function, it may not be able to handle the different behaviors of the agents h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$13570085-404c-4488-aad6-1c26ea6fdab9h
)}(h
}(hX  and consider Agent 2 as incorrect (as the first response does not match the ground truth, e.g., "sunny").

## A new evaluation method
Therefore, we propose a new evaluation method that treats the agent as a conversational partner as shown in the figure below:h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$0ee4b464-d491-48dd-b896-25d9c6aeddbdh
)}(h
}(hX!  ![Evaluation](../static/img/evaluation.png)
We introduce two new roles during the evaluation process: the **Examiner** and the **Judge**.
For each test case, the task description is first given to the Examiner.
The Examiner then asks questions to the agent and supervises the conversation.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$e49d7a23-cdee-4fb8-8ead-35620b3c4cc5h
)}(h
}(hX6  The evaluation target is allowed to ask questions to the Examiner to clarify the task.
The Examiner can only provide the task description and cannot provide any hints or solutions.
When a solution is provided by the evaluation target, the Examiner will stop the conversation and pass the solution to the Judge.h}(hhhj  hK	uhh	uh(hhh}h}(hj  hj  usub$5ea6b5d9-891e-4854-a11b-0bc4295b0677h
)}(h
}(hX8  The Judge will then evaluate the solution based on the ground truth.
Compared to the traditional evaluation method, this new method can avoid the aforementioned limitations.

Let's see an example of how the new evaluation method works. The following YAML file is a task description for the task "Sum of 1 to 50".h}(hhhj  hK
uhh	uh(hhh}h}(hj  hj  usub$56a58cca-fe07-454c-82f2-6b83ce7fbc3dh
)}(h
}(hX  While this task is simple, it is used to test the limitation of conversation rounds and the ability of the agent to keep track of the sum.
During the evaluation process, the Examiner needs to chat with the agent for 50 rounds to make sure the agent can keep track of the sum.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$ab68e71e-8523-4253-89fd-3d64519dcf43h
)}(h
}(hWhen the conversation ends, the Examiner will pass the chat history to the Judge, who will evaluate the sum based on the ground truth.
```yaml
task_description: |-
  The task has many rounds. The initial total sum is 0. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$071553d8-6e07-44d1-aa5b-f903a5a67b24h
)}(h
}(h  Starting from round 1 to round 50, you should ask the agent to add the current round number to the total sum.
  The agent should keep track of the sum and return the sum after the 50th round.h}(hhhj  hK
uhh	uh(hhh}h}(hj!  hj"  usub$37327a0a-aa4c-407e-bcd9-75e0a8f9177dh
)}(h
}(h  Every round, you only need to ask the agent to add the current round number to the total sum and report the sum to you.
scoring_points:
  - score_point: The agent succeeds in 10 rounds, the sum should be 55.
    weight: 1h}(hhhj  hKuhh	uh(hhh}h}(hj*  hj+  usub$5d4f0af8-d3bb-4e63-bb7d-efbc799de2f0h
)}(h
}(h  - score_point: The agent succeeds in 20 rounds, the sum should be 210.
    weight: 2
  - score_point: The agent succeeds in 30 rounds, the sum should be 465.
    weight: 3h}(hhhj  hKuhh	uh(hhh}h}(hj3  hj4  usub$a1dae414-05b8-4f38-9039-3a859ec422c6h
)}(h
}(h  - score_point: The agent succeeds in 40 rounds, the sum should be 820.
    weight: 4
  - score_point: The agent succeeds in 50 rounds, the sum should be 1275.
    weight: 5
```h}(hhhj  hKuhh	uh(hhh}h}(hj<  hj=  usub$f67c043d-fcab-44b9-a9fd-c5574ab63fb8h
)}(h
}(hX   The ground truth is represented by the `scoring_points` field in the YAML file.
Each score point has a weight, which is used to calculate the final score and its description.
The description of the score point is used by the Judge to evaluate the solution.h}(hhhj  hKuhh	uh(hhh}h}(hjE  hjF  usub$8509447e-fc74-44ae-afa1-4cc9d5e297a0h
)}(h
}(hThe Judge will evaluate the solution based on the score points and the chat history.
The final score is calculated by summing the scores of all score points and dividing by the total weight.
Therefore, the normalized score is between 0 and 1.
h}(hhhj  hKuhh	uh(hhh}h}(hjN  hjO  usub$77f3b529-8faa-4afc-b2be-5579fd04d8e3h
)}(h
}(hIn some cases, it may require a more precise way to evaluate the solution, e.g., with code.
This following task description is an example of such a case.
```yaml
task_description: |- h}(hhhj  hKuhh	uh(hhh}h}(hjW  hjX  usub$16ad6154-ea6f-4773-af9f-fd03a894fad9h
)}(h
}(h  The task is to send 3 requests one-by-one and get the agent responses, no need to check the response content: 
  1. generate 1 random integer number and save it to a file named 'a.txt', just tell me if the task is doneh}(hhhj  hKuhh	uh(hhh}h}(hj`  hja  usub$05c19532-d7fb-4551-8c3f-2fbd6d28504ah
)}(h
}(h  2. tell me a random joke
  3. save the previously generated random number to a file named 'b.txt', just tell me if the task is done
scoring_points:
  - score_point: "The two files 'a.txt' and 'b.txt' should contain the same number"h}(hhhj  hKuhh	uh(hhh}h}(hji  hjj  usub$5bac4619-bc13-4ffa-b37b-3598e83b94ddh
)}(h
}(h    weight: 1
    eval_code: |-
      content_a = open('a.txt', 'r').read().strip()
      content_b = open('b.txt', 'r').read().strip()h}(hhhj  hKuhh	uh(hhh}h}(hjr  hjs  usub$07fc7cec-4b38-4294-9c75-4dcf082870deh
)}(h
}(h      assert content_a == content_b, f"content of a.txt: {content_a}, content of b.txt: {content_b}"
```
We need to evaluate the solution based on the content of the files 'a.txt' and 'b.txt'.h}(hhhj  hKuhh	uh(hhh}h}(hj{  hj|  usub$4c76b5bf-aff1-4240-b3f2-fc914cef9ff0h
)}(h
}(hThe `eval_code` field is used to write the evaluation code. 
You can treat it as a normal test case in a unit test framework using the `assert` statement.
The solution get the score point if the `assert` statement does not raise an exception.
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$35177b96-80a3-4cf7-9695-d17d8b77c0d9h
)}(h
}(hXe  We provide additional fields in the YAML file to specify the evaluation environment.

```yaml
version: the version of the evaluation file
config_var: configurations of the agent for this evaluation case
app_dir: the working directory of the agent
dependencies: list of packages required by the agent
data_files: list of files copied to the working directoryh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$c2ab71ce-b4a8-497d-b54b-7be2b9ceed5ch
)}(h
}(hX(  max_rounds: the maximum number of rounds for the conversation
```

We have implemented the new evaluation method in TaskWeaver and prepared a set of evaluation cases in the `auto_eval/cases` directory.
Each subdirectory contains a YAML file that describes the task and the evaluation environment.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$a34ac629-8c1a-4ee1-8842-6bd504d7a0c7h
)}(h
}(hTo run the evaluation, you can find more details in the 
[auto_eval/README.md](https://github.com/microsoft/TaskWeaver/blob/main/auto_eval/README.md) file.

## How to adapt for other agents?h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$95f7e6e8-8665-4737-b007-f835987be26ch
)}(h
}(hX.  Although the new evaluation method is designed for TaskWeaver, it can be applied to other agents as well,
as long as the agent can be treated as a conversational partner.
More specifically, the agent should be able to instantiate as a Python object with necessary configurations and a working directoryh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$daf13a8e-e329-4a49-af56-14dae8a6dcdah
)}(h
}(has we did for TaskWeaver in `auto_eval/taskweaver_eval.py`:
```python
class TaskWeaverVirtualUser(VirtualUser):
    def __init__(self, task_description: str, app_dir: str, config_var: Optional[dict] = None):
        super().__init__(task_description)
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$bf266382-8d93-437e-86e1-79f58fde85e1h
)}(h
}(hX'          self.app = TaskWeaverApp(app_dir=app_dir, config=config_var)
        self.session = self.app.get_session()
        self.session_id = self.session.session_id

    def get_reply_from_agent(self, message: str) -> str:
        response_round = self.session.send_message(
            message,h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$6656f58b-163d-4e2b-8c0b-801b0e0f3d52h
)}(h
}(h            event_handler=None,
        )
        assert response_round.state != "failed", "Failed to get response from agent."
        return response_round.post_list[-1].message

    def close(self):
        self.app.stop()
```h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$1313894e-319c-4fe6-82d1-c7ef91a8d476h
)}(h
}(htTo add another agent, you need to implement the `VirtualUser` class and the `get_reply_from_agent`, `close` methods.h}(hhhj  hK uhh	uh(hhh}h}(hj  hj  usub$6f01c726-7f04-40d0-8c62-f3ebc3d72397h
)}(h
}(hX   # Roles in TaskWeaver

We frame TaskWeaver as a **code-first** agent framework. The term "code-first" means that the agent is designed to
convert the user's request into one or multiple runnable code snippets and then execute them to generate the response.h}(hhh# Roles in TaskWeaverhK uhh	uh(hhh}h}(hj  hj  usub$b99e1d37-fcbd-4a14-95b9-a465a569496fh
)}(h
}(hXk  The philosophy behind this design is to consider programming languages as the de facto language for communication in cyber-physical systems,
just like the natural language for human communication. Therefore, TaskWeaver translates the user's request in natural language into
programming languages, which can be executed by the system to perform the desired tasks.
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$cb42faf8-75a6-44d4-8137-d4396431cfd3h
)}(h
}(hUnder this design, when the developer needs to extend the agent's capability, they can write a new plugin.
A plugin is a piece of code wrapped in a class that can be called as a function by the agent in the generated code snippets.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$6c1ad592-fd8d-4149-8eb4-068f612859c4h
)}(h
}(hX  Let's consider an example: _the agent is asked to load a CSV file and perform anomaly detection on the data_.
The workflow of the agent is in the diagram below. It is very natural to represent data to be processed in variables and this task in code snippets.

```mermaid
flowchart TD>      h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$74835d12-8705-4398-b7be-4443db20eb9eh
)}(h
}(hX	      A[User] --"read a.csv and perform 
    anomaly detection"--> B[Planner]
    subgraph TaskWeaver 
        B --"read a.csv and call the 
        anomaly_detection plugin
        to find anomalies in the data"--> C[Code Generator]
        subgraph Code Interpreterh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$aeca2ffb-790e-4dea-b8e2-8bae5ab742edh
)}(h
}(hX              C --"df=pd.read_csv('a.csv')
            anomaly_df=anomaly_detection(df)"--> D[Code Executor]
        end
    end
    D --result--> B
    B --response--> A
```

However, we do find challenges for other tasks that are not naturally represented in code snippets.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$4214c6c3-554c-4d4b-bccc-dc8d2694b181h
)}(h
}(hX  Let's consider another example: _the agent is asked to read a manual and follow the instructions to process the data_.
We first assume there is a plugin that can read the manual and extract the instructions, called `read_manual`.
The workflow of the agent is in the diagram below. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj
  usub$0ac1e831-770e-439e-b0ed-babc1bbb12fch
)}(h
}(hX1  This diagram only shows the first step of the task, which is to read the manual and extract the instructions.
Although it does obtain the instructions, and the agent can follow them to complete the task, the behavior 
of the agent is less natural compared to the previous example.

```mermaid
flowchart TDh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$cc47e1f9-7f91-44f1-b881-93dd2681046ah
)}(h
}(h    A[User] --"read the manual and follow 
    the instructions to process the data"--> B[Planner]
    subgraph TaskWeaver 
        B --"step 1: read the manual by 
        calling the read_manual h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$05cd7ba8-84d4-4a9e-a753-58fc20a4d60fh
)}(h
}(h        plugin to extract  the instructions"--> C[Code Generator]
        subgraph Code Interpreter
            C --"instructions=read_manual()
            follow_instructions(manual)"--> D[Code Executor]
        end
    end
    D --instructions--> B
```
h}(hhhj  hK	uhh	uh(hhh}h}(hj'  hj(  usub$b1832dc6-189d-4f67-894d-71f6df8a2415h
)}(h
}(hX8  Why? First, there is no need to generate code to read the manual and extract the instructions.
Once the Planner has decided to read the manual, the code to extract the instructions is straightforward.
Even though that there might be dynamic parts in the code such as some arguments in the function `read_manual`,h}(hhhj  hK
uhh	uh(hhh}h}(hj0  hj1  usub$7c16b6df-4788-48dc-b1e7-8566f597813eh
)}(h
}(hX  it could be handled by the Planner. Therefore, the Code Generator is not necessary in this case,
and the current flow actually incurred unnecessary LLM call overhead to generate the code snippets.
Second, it does not make sense to represent the instructions in variables.h}(hhhj  hKuhh	uh(hhh}h}(hj9  hj:  usub$5ec320e3-04c5-4901-9021-aba98519f500h
)}(h
}(hThe instructions are not data to be processed, but a text guide for the agent to follow.

For these reasons, we introduced the concept of [roles](/docs/concepts/role) in TaskWeaver.h}(hhhj  hKuhh	uh(hhh}h}(hjB  hjC  usub$4c0745e6-63f2-4aea-bddc-61561f91e691h
)}(h
}(hRoles are actually not new in TaskWeaver as there are already roles like `Planner` and `CodeInterpreter`.
To add a new role, the developer can follow the documentation [here](/docs/concepts/role).h}(hhhj  hK
uhh	uh(hhh}h}(hjK  hjL  usub$97f2587a-0b07-46ed-b9ca-e60d870313b2h
)}(h
}(hX  In general, a role is a class that inherits the `Role` class and implements the `reply` method.
The `reply` method is the function that the agent calls to interact with the role, which has the 
following signature:

```python
def reply(self, memory: Memory, **kwargs) -> Post:h}(hhhj  hKuhh	uh(hhh}h}(hjT  hjU  usub$3e43dddd-8fc3-49b7-83ab-423a885b662bh
)}(h
}(h    # implementation
```

It takes the `memory` object, which is the memory of the agent, and returns a [Post](/docs/concepts/post) object, which is the response of the role to the Planner.h}(hhhj  hKuhh	uh(hhh}h}(hj]  hj^  usub$5ee43166-a0ff-4ad4-a5bc-8dd286c50c0ah
)}(h
}(hX   With the `memory` object, the role can access the history of the conversation and the context of the conversation.
You may have noticed that all roles in TaskWeaver can only talk to the Planner, not to each other.
If a role needs to talk to another role, it should go through the Planner.h}(hhhj  hKuhh	uh(hhh}h}(hjf  hjg  usub$3fafa954-47b3-4233-a117-62537a0961c2h
)}(h
}(hX&  This design is to ensure that the Planner can control the conversation and the flow of the conversation.
For a task that requires multiple roles to work together, the Planner can orchestrate the roles to work together to complete the task 
as shown in the diagram below.
```mermaid
flowchart TDh}(hhhj  hKuhh	uh(hhh}h}(hjo  hjp  usub$6ffece67-ec71-4a4e-b61d-1e89f571adb4h
)}(h
}(h    A[User] --"request"--> B[Planner]
    subgraph TaskWeaver 
        B --"step 1"--> C[Role 1]
        C --reply--> B
        B --"step 2"--> D[Role 2]
        D --reply--> Bh}(hhhj  hKuhh	uh(hhh}h}(hjx  hjy  usub$a2a8e226-1478-4e62-bec3-a7943aaf5dcdh
)}(h
}(h        B --"step 3"--> E[Role 3]
        E --reply--> B
    end
    B --response--> A
```

The communication between the Planner and the roles is done through the [Post](/docs/concepts/post) object.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$cfcbd481-8686-40ed-84df-a48e6d3117a1h
)}(h
}(hIn other words, they talk to each other by sending messages in natural language.
What if a role needs to send some data to another role? If this is the case, we would recommend to implement a new pluginh}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$f3f4aa8c-b1da-4de2-9dcb-e2f6640844f8h
)}(h
}(hinstead of a new role. Otherwise, you may need to store the data in an external storage like a database and let the other role to access it.

There is a challenge in implementing multiple roles that is missing information.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$fc566527-6739-40a0-8fde-4a5cd68e0a96h
)}(h
}(hX-  Consider the case in our previous example where the agent is asked to read a manual and follow the instructions to process the data.
When the Planner obtains the instructions from a role called `manual_reader`, it needs to pass the instructions to the CodeInterpreter role to execute the instructions.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$990a4cee-72a9-4472-b36e-933df19327a8h
)}(h
}(hX  Sometimes, the Planner may miss critical information that is needed by the CodeInterpreter role.
Even though we can emphasize the importance of the Planner to pass all the necessary information to the roles in the prompt, 
it is still possible that the Planner misses some information.
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$5468d0fb-289e-46f0-92ac-3cd2b3851ec0h
)}(h
}(hTo address this challenge, we introduce the concept of `board` in TaskWeaver. 
The `board` is a shared memory space that can be accessed by all roles, which is associated with the current [Round](/docs/concepts/round).h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$977f361f-4ee7-4b1e-9b57-ffff51294cb6h
)}(h
}(hX  The `board` is a dictionary-like object that can store any information that is needed by the roles.
Each role can decide to write or read any information from the `board`.

```python
 def write_board(self, role_alias: str, bulletin: str) -> None:
    """Add a bulletin to the round."""h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$0d3c3e4d-6efa-4e2d-9cf2-2c8a80238f01h
)}(h
}(hX      self.board[role_alias] = bulletin

def read_board(self, role_alias: Optional[str] = None) -> Union[Dict[str, str], str]:
    """Read the bulletin of the round."""
    if role_alias is None:
        return self.board
    return self.board.get(role_alias, None)
```
h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$ff963e1c-ae70-435f-a79b-e3b925e42276h
)}(h
}(hOne concrete example of using the `board` is to pass the user's request to the CodeInterpreter role.
When the Planner receives the user's request, it can write the request and its step-wise plan to the `board`.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$19e84c0e-7b1d-42f7-ae0c-e82cbe8351fdh
)}(h
}(hThe CodeInterpreter role can then read the request and the plan from the `board` to execute the plan.

In summary, the concept of roles in TaskWeaver is to provide a way to extend the agent's capability by implementing new roles.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$078d42c1-3c06-46f0-b259-9c58ce5e2000h
)}(h
}(hX  This is especially useful when the task is not naturally represented in code snippets such as acquire text information
from a knowledge base or the internet. Implementing a new role is straightforward by inheriting the `Role` class and implementing the `reply` method.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$04e8c59b-a2a4-4659-b10d-80821cb93e30h
)}(h
}(hAll extra roles should be put in the `TaskWeaver/taskweaver/ext_role` folder, which will be automatically loaded by TaskWeaver. h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usub$8e0292f0-a44d-498d-abd1-e5293f8f152ch
)}(h
}(hX  We have provided a few sample roles in the `TaskWeaver/taskweaver/ext_role` folder, such as the `Echo` role that echoes the user's message back to the user.
More advanced role examples are the Planner and the CodeInterpreter roles, which are the core roles in TaskWeaver.h}(hhhj  hKuhh	uh(hhh}h}(hj  hj  usubusb}(K hKhKh(Kh1Kh:KhCKhLKhUKh^K	hgK
hpKhyKhK
hKhKhKhKhKhKhKhKhKhKhKhKhKj   Kj	  Kj  Kj  Kj$  Kj-  K j6  K!j?  K"jI  K#jR  K$j[  K%jd  K&jm  K'jv  K(j  K)j  K*j  K+j  K,j  K-j  K.j  K/j  K0j  K1j  K2j  K3j  K4j  K5j  K6j  K7j  K8j  K9j  K:j!  K;j*  K<j3  K=j<  K>jE  K?jN  K@jW  KAj`  KBji  KCjr  KDj{  KEj  KFj  KGj  KHj  KIj  KJj  KKj  KLj  KMj  KNj  KOj  KPj  KQj  KRj  KSj  KTj
  KUj  KVj  KWj(  KXj1  KYj:  KZjC  K[jL  K\jU  K]j^  K^jg  K_jp  K`jy  Kaj  Kbj  Kcj  Kdj  Kej  Kfj  Kgj  Khj  Kij  Kjj  Kkj  Klj  Kmj  Knj  Koj  Kpj
  Kqj  Krj  Ksj(  Ktj1  Kuj:  KvjC  KwjN  KxjW  Kyj`  Kzji  K{jr  K|j{  K}j  K~j  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj
  Kj  Kj  Kj(  Kj1  Kj:  KjC  KjL  KjU  Kj^  Kjg  Kjp  Kjy  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj   Kj	  Kj  Kj  Kj$  Kj-  Kj8  KjA  KjJ  KjS  Kj\  Kje  Kjn  Kjw  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj"  Kj+  Kj4  Kj=  KjF  KjO  KjX  Kja  Kjj  Kjs  Kj|  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj   Kj)  Kj4  Kj=  KjF  KjO  KjX  Kja  Kjj  Kjs  Kj|  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj  Kj 	  Kj	  Kj	  Kj	  Kj&	  M j/	  Mj8	  MjA	  MjJ	  MjS	  Mj^	  Mjg	  Mjp	  Mjy	  M	j	  M
j	  Mj	  Mj	  M
j	  Mj	  Mj	  Mj	  Mj	  Mj	  Mj	  Mj	  Mj	  Mj	  Mj
  Mj
  Mj
  Mj
  Mj&
  Mj/
  Mj8
  MjA
  MjJ
  M jU
  M!j^
  M"jg
  M#jp
  M$jy
  M%j
  M&j
  M'j
  M(j
  M)j
  M*j
  M+j
  M,j
  M-j
  M.j
  M/j
  M0j
  M1j
  M2j
  M3j  M4j  M5j  M6j  M7j(  M8j1  M9j:  M:jC  M;jL  M<jU  M=j^  M>jg  M?jp  M@jy  MAj  MBj  MCj  MDj  MEj  MFj  MGj  MHj  MIj  MJj  MKj  MLj  MMj  MNj  MOj   MPj	  MQj  MRj  MSj&  MTj/  MUj8  MVjA  MWjJ  MXjS  MYj\  MZje  M[jn  M\jw  M]j  M^j  M_j  M`j  Maj  Mbj  Mcj  Mdj  Mej  Mfj  Mgj  Mhj  Mij  Mjj  Mkj 
  Mlj	
  Mmj
  Mnj
  Moj$
  Mpj-
  Mqj6
  Mrj?
  MsjH
  MtjQ
  MujZ
  Mvjc
  Mwjl
  Mxju
  Myj~
  Mzj
  M{j
  M|j
  M}j
  M~j
  Mj
  Mj
  Mj
  Mj
  Mj
  Mj
  Mj
  Mj
  Mj
  Mj  Mj  Mj  Mj   Mj)  Mj2  Mj;  MjD  MjM  MjV  Mj_  Mjh  Mjq  Mjz  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj
  Mj  Mj  Mj%  Mj.  Mj7  Mj@  MjI  MjR  Mj[  Mjd  Mjm  Mjv  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj
  Mj  Mj  Mj%  Mj.  Mj7  Mj@  MjI  MjR  Mj[  Mjd  Mjm  Mjv  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj#  Mj,  Mj5  Mj>  MjG  MjP  MjY  Mjb  Mjk  Mjt  Mj}  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj
  Mj  Mj  Mj(  Mj1  Mj:  M jC  MjL  MjU  Mj`  Mji  Mjr  Mj{  Mj  Mj  M	j  M
j  Mj  Mj  M
j  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj
  Mj  Mj  Mj(  Mj1  Mj:  MjC  MjL  MjU  Mj^  M jg  M!jp  M"jy  M#j  M$j  M%j  M&j  M'j  M(j  M)j  M*j  M+j  M,j  M-j  M.j  M/j  M0j  M1j   M2j	  M3j  M4j  M5j&  M6j/  M7j8  M8jA  M9jJ  M:jU  M;j^  M<jg  M=jp  M>jy  M?j  M@j  MAj  MBj  MCj  MDj  MEj  MFj  MGj  MHj  MIj  MJj  MKj  MLj  MMj   MNj	  MOj  MPj  MQj&  MRj1  MSj:  MTjC  MUjL  MVjU  MWj`  MXji  MYjr  MZj{  M[j  M\j  M]j  M^j  M_j  M`j  Maj  Mbj  Mcj  Mdj  Mej  Mfj  Mgj  Mhj  Mij  Mjj  Mkj  Mlj#  Mmj,  Mnj5  Moj>  MpjG  MqjR  Mrj[  Msjd  Mtjm  Mujv  Mvj  Mwj  Mxj  Myj  Mzj  M{j  M|j  M}j  M~j  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj'  Mj0  Mj9  MjB  MjK  MjT  Mj]  Mjf  Mjq  Mjz  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj
  Mj  Mj  Mj'  Mj0  Mj9  MjB  MjK  MjT  Mj]  Mjf  Mjo  Mjx  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj&  Mj/  Mj8  MjA  MjJ  MjS  Mj\  Mje  Mjn  Mjw  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj#  Mj,  Mj5  Mj>  MjG  MjP  MjY  Mjb  Mjk  Mjt  Mj}  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  Mj  u.