/      &langchain_community.docstore.in_memoryInMemoryDocstore)}_dict}($739d9c53-1195-4d2b-a8b5-420ecab6ece9langchain_core.documents.baseDocument)}(__dict__}(idNmetadata}(source title# Code Executionchunk_idK upage_content# Code Execution

>💡We have set the `container` mode as default for code execution, especially when the usage of the agent
is open to untrusted users. Refer to [Docker Security](https://docs.docker.com/engine/security/) for better understandingtypeh	u__fields_set__(hh__private_attribute_values__}ub$085e0a5e-b584-4584-abb3-383a6eb50e32h
)}(h
}(hNh}(hhhhhKuhof the security features of Docker. To opt for the `local` mode, you need to explicitly set the `execution_service.kernel_mode` 
parameter in the `taskweaver_config.json` file to `local`.
hh	uh(hhh}ub$e36f1533-880f-47f2-a0e9-18aa20891116h
)}(h
}(hNh}(hhhhhKuhXA  TaskWeaver is a code-first agent framework, which means that it always converts the user request into code 
and executes the code to generate the response. In our current implementation, we use a Jupyter Kernel
to execute the code. We choose Jupyter Kernel because it is a well-established tool for interactive computing,hh	uh(hhh}ub$5c9a1e40-858a-4e73-bbe6-6d74c8aa99cdh
)}(h
}(hNh}(hhhhhKuhX  and it supports many programming languages.

## Two Modes of Code Execution

TaskWeaver supports two modes of code execution: `local` and `container`. 
The `container` mode is the default mode. The key difference between the two modes is that the `container` modehh	uh(hhh}ub$20ccbad2-091b-424a-8a60-38ea2691db7fh
)}(h
}(hNh}(hhhhhKuhX  executes the code inside a Docker container, which provides a more secure environment for code execution, while
the `local` mode executes the code as a subprocess of the TaskWeaver process.
As a result, in the `local` mode, if the user has malicious intent, the user could potentiallyhh	uh(hhh}ub$46a83dcf-62a3-416f-b242-2eeab64e3febh
)}(h
}(hNh}(hhhhhKuhX5  instruct TaskWeaver to execute harmful code on the host machine. In addition, the LLM could also generate
harmful code, leading to potential security risks.

## How to Configure the Code Execution Mode

To configure the code execution mode, you need to set the `execution_service.kernel_mode` parameter in thehh	uh(hhh}ub$2c74b56b-44ef-4782-a020-f5f2a9e0e07ah
)}(h
}(hNh}(hhhhhKuhX  `taskweaver_config.json` file. The value of the parameter could be `local` or `container`. The default value
is `container`.

TaskWeaver supports the `local` mode without any additional setup. However, to use the `container` mode,
there are a few prerequisites:
hh	uh(hhh}ub$53788206-8a2e-40d5-8aac-cf45822c998ah
)}(h
}(hNh}(hhhhhKuh- Docker is installed on the host machine.
- A Docker image is built and available on the host machine for code execution.
- The `execution_service.kernel_mode` parameter is set to `container` in the `taskweaver_config.json` file.
hh	uh(hhh}ub$40c71e04-9dae-481a-b411-a4200741d59ah
)}(h
}(hNh}(hhhhhKuhX   Once the code repository is cloned to your local machine, you can build the Docker image
by running the following command in the root directory of the code repository:

```bash
cd scripts

# based on your OS
./build_executor.ps1 # for Windows
./build_executor.sh # for Linux or macOS
```
hh	uh(hhh}ub$58211e71-86f5-485d-aeae-f87618f245dfh
)}(h
}(hNh}(hhhhhK	uhAfter the Docker image is built, you can run `docker images` to check if a Docker image 
named `taskweavercontainers/taskweaver-executor` is available. 
If the prerequisite is met, you can now run TaskWeaver in the `container` mode.
hh	uh(hhh}ub$a23d3701-7a82-478c-8ce7-fdd9965a78a7h
)}(h
}(hNh}(hhhhhK
uhX   After running TaskWeaver in the `container` mode, you can check if the container is running by running `docker ps`.
You should see a container of image `taskweavercontainers/taskweaver-executor` running after executing some code. 

## How to customize the Docker image for code execution
hh	uh(hhh}ub$a0b2d3f9-6b0f-432c-bb8f-9b59b473c264h
)}(h
}(hNh}(hhhhhKuhX<  You may want to customize the Docker image for code execution to include additional packages or libraries, especially
for your developed plugins. The current Docker image for code execution only includes the dependencies specified in the `TaskWeaver/requirements.txt` file. To customize the Docker image, you need tohh	uh(hhh}ub$69b7f7ee-a140-4569-b029-a8c87d267663h
)}(h
}(hNh}(hhhhhKuhmodify the `Dockerfile` at `TaskWeaver/docker/ces_container/Dockerfile` and rebuild the Docker image.

When you open the `Dockerfile`, you will see the following content, and you can add additional packages or librarieshh	uh(hhh}ub$b1af901f-65bf-4026-bcc8-d6348ed9e632h
)}(h
}(hNh}(hhhhhK
uhby adding the corresponding `RUN` command. In this example, we add the `sentence-transformers` package to the Docker image.

```Dockerfile
FROM python:3.10-slim
...
# TODO: Install additional packages for pluginshh	uh(hhh}ub$d80ae15f-81fc-440a-b6f4-105d2b156df1h
)}(h
}(hNh}(hhhhhKuhRUN pip install --no-cache-dir --no-warn-script-location --user sentence-transformers
...
```
Then, you need to rebuild the Docker image by running the `build_executor.sh` script at `TaskWeaver/scripts/build_executor.sh` hh	uh(hhh}ub$34142f12-e550-4cc6-ab44-94caa2baa034h
)}(h
}(hNh}(hhhhhKuhX  or `TaskWeaver/scripts/build.ps1` depending on your operating system.

```bash
cd TaskWeaver/scripts
./build_executor.sh
# or ./build_executor.ps1 if you are using Windows
```

If you have successfully rebuilt the Docker image, you can check the new image by running `docker images`.hh	uh(hhh}ub$bcbaf5aa-63c4-4a92-9113-a14ae066138eh
)}(h
}(hNh}(hhhhhKuhAfter building the Docker image, you need to restart the TaskWeaver agent to use the new Docker image.

## Limitations of the `container` Mode

The `container` mode is more secure than the `local` mode, but it also has some limitations:
hh	uh(hhh}ub$13551d86-beb2-4db9-970f-65d0e6f4fa1ch
)}(h
}(hNh}(hhhhhKuh- The startup time of the `container` mode is longer than the `local` mode, because it needs to start a Docker container. 
- As the Jupyter Kernel is running inside a Docker container, it has limited access to the host machine. We are mapping thehh	uh(hhh}ub$78bcd131-2d0e-42dd-a237-e4c568d954a2h
)}(h
}(hNh}(hhhhhKuh  `project/workspace/sessions/<session_id>` directory to the container, so the code executed in the container can access the
  files in it. One implication of this is that the user cannot ask the agent to load a file from the host machine, because thehh	uh(hhh}ub$186ff54c-4228-4951-82f1-4ffb801d5d8bh
)}(h
}(hNh}(hhhhhKuh  file is not available in the container. Instead, the user needs to upload the file either using the `/upload` command in 
  the console or the `upload` button in the web interface.hh	uh(hhh}ub$f63ee3ea-e23a-4ea3-88df-c2b2b7459971h
)}(h
}(hNh}(hhhhhKuhX  - We have installed required packages in the Docker image to run the Jupyter Kernel. If the user needs to use a package that is
  not available in the Docker image, the user needs to add the package to the Dockerfile (at `TaskWeaver/ces_container/Dockerfile`) hh	uh(hhh}ub$f33a0050-9a35-49da-a9ad-4f0aea29d8a2h
)}(h
}(hNh}(hhhhhKuh  and rebuild the Docker image.

## Restricting External Network Access for Docker Containers

In some cases, the agent developer may want to restrict the Docker container's access to the external network, e.g., the internet.hh	uh(hhh}ub$8d7b69db-60a6-4c18-ab94-5fd9a292118ah
)}(h
}(hNh}(hhhhhKuhXG  In other words, the agent developer only wants to run the code in the container but does not allow either 
the plugins or the generated code to access the internet.

The following approach is a common way to restrict a Docker container's access to the internet while still 
allowing inbound connections on specific ports:  
   hh	uh(hhh}ub$26fdbc7d-586f-40c0-b647-29265445397eh
)}(h
}(hNh}(hhhhhKuhX  1. **Creating a Docker network with `enable_ip_masquerade` set to false**:  
  
   By default, Docker uses IP masquerading (a form of network address translation or NAT) to allow containers 
   to communicate with external networks with the source IP address being the host IP address. hh	uh(hhh}ub$68f6cdd6-5989-48c8-8a2a-0bd806eb8beah
)}(h
}(hNh}(hhhhhKuhX/      When you set `enable_ip_masquerade` to false for a custom Docker network, 
    you prevent containers on that network from having their IP addresses masqueraded, effectively blocking them 
    from accessing the internet. To create such a network in Docker, you would use the following command:  
  hh	uh(hhh}ub$2dfc97c7-2be5-49c5-8f1e-3a261fc89e74h
)}(h
}(hNh}(hhhhhKuhX     ```bash  
   docker network create --opt com.docker.network.bridge.enable_ip_masquerade=false my_non_internet_network  
   ```  
  
   Any container connected to `my_non_internet_network` will not have internet access due to the disabled IP masquerade.  
    Now, you can run hh	uh(hhh}ub$4545586d-0a6c-4876-917b-e2f8ff3edab8h
)}(h
}(hNh}(hhhhhKuh    ```bash
    docker network inspect my_non_internet_network
    ```
   and you will see an output similar to the following:
    ```json
    "Config": [
        {
            "Subnet": "172.19.0.0/16",hh	uh(hhh}ub$3afefff5-10ca-45dc-a50b-a659eafe7ff9h
)}(h
}(hNh}(hhhhhKuhX
              "Gateway": "172.19.0.1"
        }
    ]
    ```
   This shows the subnet of the docker network, all containers connected to this network will have an IP address in this subnet.
   
2. **Establishing a rule on the host's firewall or using iptables**:  
  hh	uh(hhh}ub$f8c27a2b-7a45-43f5-81a5-9334efe9cdb3h
)}(h
}(hNh}(hhhhhKuhX8     This step is about setting up rules to block outgoing traffic from the Docker network's subnet 
   to any external addresses. This adds an additional layer of security to ensure that even 
    if IP masquerade is somehow enabled or if the container finds another route, the traffic will still be blocked.  
  hh	uh(hhh}ub$61861689-ccb5-4e3b-9bae-81cb4d084eaah
)}(h
}(hNh}(hhhhhKuhX	     - **On a Linux host using iptables**, you might add a rule like this:  
  
     ```bash  
     iptables -I FORWARD -s <docker_network_subnet> -j DROP  
     ```  
       
     Replace `<docker_network_subnet>` with the actual subnet used by your Docker network. hh	uh(hhh}ub$f70ec979-c553-47c3-a90f-778d93320e19h
)}(h
}(hNh}(hhhhhKuhX       In the previous example, the subnet is `172.19.0.0/16`. This rule drops all forwarding traffic from that subnet. 
  
   - **On a Windows host**, you would create a similar rule within the Windows Firewall 
     to block outgoing traffic from the Docker network's subnet.  hh	uh(hhh}ub$73b8e2eb-f6ae-4d8d-ae46-5fc46dadc4f4h
)}(h
}(hNh}(hhhhhKuhX     
Keep in mind that this approach can be considered good practice if you understand the implications 
and have a specific need to isolate your container from the internet.
However, it could also complicate network troubleshooting and container communication if not managed properly. hh	uh(hhh}ub$ad14321c-26d4-4f52-813f-1053d4bc427ah
)}(h
}(hNh}(hhhhhK uhtAlways ensure you are testing these configurations in a safe environment before applying them to production systems.hh	uh(hhh}ubusb}(K hKhKh&Kh.Kh6Kh>KhFKhNKhVK	h^K
hfKhnKhvK
h~KhKhKhKhKhKhKhKhKhKhKhKhKhKhKhKhKj  Kj  K j  u.