# ------------------------------------------------------------------------------
# <auto-generated>
#     This code was generated by a tool.
#     Changes to this file may cause incorrect behavior and will be lost if
#     the code is regenerated.
# </auto-generated>
#
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# ------------------------------------------------------------------------------

from .base_numbers import BaseNumbers
# pylint: disable=line-too-long


class JapaneseNumeric:
    LangMarker = 'Jpn'
    CompoundNumberLanguage = True
    MultiDecimalSeparatorCulture = False
    DecimalSeparatorChar = '.'
    FractionMarkerToken = ''
    NonDecimalSeparatorChar = ','
    HalfADozenText = ''
    WordSeparatorToken = ''
    ZeroChar = '零'
    PairChar = '対'
    RoundNumberMap = dict([("k", 1000),
                           ("m", 1000000),
                           ("g", 1000000000),
                           ("t", 1000000000000),
                           ("b", 1000000000)])
    RoundNumberMapChar = dict([("十", 10),
                               ("百", 100),
                               ("千", 1000),
                               ("万", 10000),
                               ("億", 100000000),
                               ("兆", 1000000000000)])
    ZeroToNineMap = dict([("零", 0),
                          ("〇", 0),
                          ("一", 1),
                          ("二", 2),
                          ("三", 3),
                          ("四", 4),
                          ("五", 5),
                          ("六", 6),
                          ("七", 7),
                          ("八", 8),
                          ("九", 9),
                          ("0", 0),
                          ("1", 1),
                          ("2", 2),
                          ("3", 3),
                          ("4", 4),
                          ("5", 5),
                          ("6", 6),
                          ("7", 7),
                          ("8", 8),
                          ("9", 9),
                          ("半", 0.5)])
    FullToHalfMap = dict([("０", "0"),
                          ("１", "1"),
                          ("２", "2"),
                          ("３", "3"),
                          ("４", "4"),
                          ("５", "5"),
                          ("６", "6"),
                          ("７", "7"),
                          ("８", "8"),
                          ("９", "9"),
                          ("／", "/"),
                          ("－", "-"),
                          ("，", "'"),
                          ("、", "'"),
                          ("Ｇ", "G"),
                          ("Ｍ", "M"),
                          ("Ｔ", "T"),
                          ("Ｋ", "K"),
                          ("ｋ", "k"),
                          ("．", ".")])
    UnitMap = dict([("万万", "億"),
                    ("億万", "兆"),
                    ("万億", "兆"),
                    (" ", ""),
                    ("れい", "〇"),
                    ("ゼロ", "〇"),
                    ("マル", "〇"),
                    ("いち", "一"),
                    ("いっ", "一"),
                    ("に", "二"),
                    ("さん", "三"),
                    ("し", "四"),
                    ("よん", "四"),
                    ("ご", "五"),
                    ("ろく", "六"),
                    ("ろっ", "六"),
                    ("しち", "七"),
                    ("なな", "七"),
                    ("はち", "八"),
                    ("はっ", "八"),
                    ("きゅう", "九"),
                    ("く", "九"),
                    ("じゅう", "十"),
                    ("ひゃく", "百"),
                    ("ぴゃく", "百"),
                    ("びゃく", "百"),
                    ("せん", "千"),
                    ("ぜん", "千"),
                    ("まん", "万"),
                    ("ひゃくまん", "百万"),
                    ("ぴゃくまん", "百万"),
                    ("びゃくまん", "百万"),
                    ("せんまん", "千万"),
                    ("ぜんまん", "千万")])
    RoundDirectList = [r'万', r'億', r'兆']
    TenChars = [r'十']
    RoundNumberIntegerRegex = f'(十|百|千|万(?!万)|億|兆)'
    RoundNumberIntegerHiraganaRegex = f'(じゅう|[ひぴび]ゃく|[せぜ]ん|まん|[ひぴび]ゃくまん|[せぜ]んまん)'
    AllMultiplierLookupRegex = f'({BaseNumbers.MultiplierLookupRegex}|ミリリットル(入れら)?|キロメートル|メートル|ミリメート)'
    DigitalNumberRegex = f'((?<=(\\d|\\b)){BaseNumbers.MultiplierLookupRegex}(?=\\b))'
    ZeroToNineFullHalfRegex = f'[\\d]'
    DigitNumRegex = f'{ZeroToNineFullHalfRegex}+'
    DozenRegex = f'.*ダース$'
    PercentageSymbol = f'(パ\\s*ー\\s*セ\\s*ン\\s*ト|[％%])'
    PercentageRegex = f'.+(?=パ\\s*ー\\s*セ\\s*ン\\s*ト)|.*(?=[％%])'
    DoubleAndRoundRegex = f'{ZeroToNineFullHalfRegex}+(\\.{ZeroToNineFullHalfRegex}+)?\\s*{RoundNumberIntegerRegex}{{1,2}}(\\s*(以上))?'
    FracSplitRegex = f'[はと]|分\\s*の'
    ZeroToNineIntegerRegex = f'[零〇一二三四五六七八九]'
    ZeroToNineIntegerHiraganaRegex = f'(れい|ゼロ|マル|い[ちっ]|に|さん|し|よん|ご|ろ[くっ]|しち|なな|は[ちっ]|きゅう|く)'
    HalfUnitRegex = f'半'
    NegativeNumberTermsRegex = f'(マ\\s*イ\\s*ナ\\s*ス)'
    NegativeNumberTermsRegexNum = f'((?<!(\\d+(\\s*{BaseNumbers.NumberMultiplierRegex})?\\s*)|[-−－])[-−－])'
    NegativeNumberSignRegex = f'^{NegativeNumberTermsRegex}.*|^{NegativeNumberTermsRegexNum}.*'
    SpeGetNumberRegex = f'{ZeroToNineFullHalfRegex}|{ZeroToNineIntegerRegex}|[半対]|[分厘]'
    PairRegex = '.*[対膳足]$'
    AllowListRegex = f'(。|，|、|（|）|”｜国|週間|時間|時|匹|キロ|トン|年|個|足|本|で|は|\\s|$|つ|月|の|と)'
    NotSingleRegex = f'(?<!(第|だい))({RoundNumberIntegerRegex}+(({ZeroToNineIntegerRegex}+|{RoundNumberIntegerRegex})+|{ZeroToNineFullHalfRegex}+|十)(\\s*(以上))?)|(({ZeroToNineIntegerRegex}+|{ZeroToNineFullHalfRegex}+|十)(\\s*{RoundNumberIntegerRegex}){{1,2}})(\\s*([零]?({ZeroToNineIntegerRegex}+|((,\\s*){ZeroToNineFullHalfRegex}{{3}})+|{ZeroToNineFullHalfRegex}+|十)(\\s*{RoundNumberIntegerRegex}){{0,1}}))*(\\s*(以上)?)'
    SingleRegex = f'(({ZeroToNineIntegerRegex}+|{ZeroToNineFullHalfRegex}+|十)(?={AllowListRegex}))'
    AllIntRegex = f'(?<!(ダース))({NotSingleRegex}|({ZeroToNineIntegerRegex}+|{RoundNumberIntegerRegex}+))'
    NotSingleHiraganaRegex = f'(({ZeroToNineIntegerHiraganaRegex}?{RoundNumberIntegerHiraganaRegex})+{ZeroToNineIntegerHiraganaRegex}?)'
    SingleHiriganaRegex = f'({ZeroToNineIntegerHiraganaRegex}+)'
    AllIntHiriganaRegex = f'\\b({NotSingleHiraganaRegex}|{SingleHiriganaRegex})\\b'
    PlaceHolderPureNumber = f'\\b'
    PlaceHolderDefault = f'\\D|\\b'
    NumbersSpecialsCharsAggressive = f'((({NegativeNumberTermsRegexNum}|{NegativeNumberTermsRegex})\\s*)?({ZeroToNineFullHalfRegex}))+(?=\\b|\\D)'
    NumbersSpecialsCharsWithSuffixAggressive = f'({NegativeNumberTermsRegexNum}?{ZeroToNineFullHalfRegex}+(\\s*{BaseNumbers.NumberMultiplierRegex}+)?)(?=\\b|\\D)'
    NumbersSpecialsChars = f'({NumbersSpecialsCharsAggressive})(?!(([\\.．]{ZeroToNineFullHalfRegex}+)?\\s*{AllMultiplierLookupRegex}))'
    NumbersSpecialsCharsWithSuffix = f'({NumbersSpecialsCharsWithSuffixAggressive})(?!(([\\.．]{ZeroToNineFullHalfRegex}+)?\\s*{AllMultiplierLookupRegex}))'
    DottedNumbersSpecialsChar = f'{NegativeNumberTermsRegexNum}?{ZeroToNineFullHalfRegex}{{1,3}}([,，、]{ZeroToNineFullHalfRegex}{{3}})+'
    NumbersWithHalfDozen = f'半({RoundNumberIntegerRegex}|(ダース))'
    NumbersWithDozen = f'({AllIntRegex}([と]?{ZeroToNineIntegerRegex})?|{ZeroToNineFullHalfRegex}+)(ダース)'
    PointRegexStr = f'[\\.．・]'
    AllFloatRegex = f'{NegativeNumberTermsRegex}?{AllIntRegex}\\s*{PointRegexStr}\\s*[一二三四五六七八九](\\s*{ZeroToNineIntegerRegex})*'
    NumbersWithAllowListRegex = f'(?<!(離は))({NegativeNumberTermsRegex}?({NotSingleRegex}|{SingleRegex}|{AllIntHiriganaRegex})(?!({AllIntRegex}*([、.]{ZeroToNineIntegerRegex}+)*|{AllFloatRegex})*\\s*{PercentageSymbol}))(?!(\\s*{AllMultiplierLookupRegex}))'
    NumbersAggressiveRegex = f'(({AllIntRegex}|{AllIntHiriganaRegex})(?!({AllIntRegex}|([、.]{ZeroToNineIntegerRegex})|{AllFloatRegex}|\\s*{PercentageSymbol})))'
    PointRegex = f'{PointRegexStr}'
    DoubleSpecialsCharsAggressive = f'((?<!({ZeroToNineFullHalfRegex}+[\\.．]{ZeroToNineFullHalfRegex}*))({NegativeNumberTermsRegexNum}\\s*)?{ZeroToNineFullHalfRegex}+[\\.．,]{ZeroToNineFullHalfRegex}+(?!({ZeroToNineFullHalfRegex}*[\\.．,]{ZeroToNineFullHalfRegex}+)))(?=\\b|\\D)'
    DoubleSpecialsChars = f'({DoubleSpecialsCharsAggressive})(?!\\s*{AllMultiplierLookupRegex})'
    DoubleRoundNumberSpecialsChars = f'(?<!(({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})+[\\.．・,]({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})*))(({NegativeNumberTermsRegexNum}|{NegativeNumberTermsRegex})\\s*)?({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})+[\\.．・,]({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})+(?!({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})*[\\.．・,]({ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})+)'
    DoubleSpecialsCharsWithNegatives = f'(?<!({ZeroToNineFullHalfRegex}+|\\.\\.|．．))({NegativeNumberTermsRegexNum}\\s*)?[\\.．]{ZeroToNineFullHalfRegex}+(?!{ZeroToNineFullHalfRegex}*([\\.．]{ZeroToNineFullHalfRegex}+))'
    SimpleDoubleSpecialsChars = f'({NegativeNumberTermsRegexNum}\\s*)?{ZeroToNineFullHalfRegex}{{1,3}}([,，]{ZeroToNineFullHalfRegex}{{3}})+[\\.．]{ZeroToNineFullHalfRegex}+'
    DoubleWithMultiplierAggressiveRegex = f'(({NegativeNumberTermsRegexNum}\\s*)?{ZeroToNineFullHalfRegex}+[\\.．]{ZeroToNineFullHalfRegex}+\\s*{BaseNumbers.NumberMultiplierRegex})(?=\\b|\\D)'
    DoubleWithMultiplierRegex = f'({DoubleWithMultiplierAggressiveRegex})(?!{AllMultiplierLookupRegex})'
    DoubleWithThousandsRegex = f'(({NegativeNumberTermsRegex}|{NegativeNumberTermsRegexNum})\\s*)?({ZeroToNineFullHalfRegex}+([\\.．]{ZeroToNineFullHalfRegex}+)?\\s*{RoundNumberIntegerRegex}{{1,2}})'
    DoubleAllFloatRegex = f'(?<!(({AllIntRegex}[.]*)|{AllFloatRegex})*){AllFloatRegex}(?!{ZeroToNineIntegerRegex}*\\s*パーセント)'
    DoubleExponentialNotationRegex = f'(?<!\\d+[\\.])({NegativeNumberTermsRegexNum}\\s*)?(\\d+([\\.]\\d+)?)e(([-+＋]*[1-9]\\d*)|[0](?!\\d+))|(?<!\\d+[\\.])({NegativeNumberTermsRegexNum}\\s*)?(\\d+([\\.]\\d+)?)(×)?(10)?の((([-+＋]*[1-9]\\d*)|[0])[乗](?!\\d+))'
    DoubleExponentialNotationKanjiRegex = f'(?<!({ZeroToNineIntegerRegex})+[\\.．・])(({NegativeNumberTermsRegexNum}|{NegativeNumberTermsRegex})\\s*)?({ZeroToNineIntegerRegex}|[十千五百])+([\\.．・]({ZeroToNineIntegerRegex})+)?(×)?(十)?(の)((((マ\\s*イ\\s*ナ\\s*ス))*({ZeroToNineIntegerRegex}|[十])({ZeroToNineIntegerRegex}|[十])*[乗])(?!({ZeroToNineIntegerRegex}|[十])+))'
    DoubleScientificNotationRegex = f'(?<!\\d+[\\.])({NegativeNumberTermsRegexNum}\\s*)?(\\d+([\\.]\\d+)?)\\^([-+＋]*[1-9]\\d*)'
    OrdinalNumbersRegex = f'(((第|だい)({ZeroToNineFullHalfRegex}+)({RoundNumberIntegerRegex}+)?))|(({ZeroToNineFullHalfRegex}+|{ZeroToNineIntegerRegex}+)({RoundNumberIntegerRegex}+)?(番目|位|等(?!級)))'
    OrdinalRegex = f'(({OrdinalNumbersRegex})|((第|だい)({AllIntRegex})|(({AllIntRegex}+|{NumbersWithAllowListRegex}+)(番目|位|等))))|(最初|1等|ファースト)'
    RelativeOrdinalRegex = f'(?<relativeOrdinal>((最後)(から1つ前のこと|から(3|2|1)番目|(から1つ前)(のもの)|から三番目|から二番目|(から(一|1)つ前)(のもの|のこと)?|(から1つ)?(前))?|(次のもの)(前)?|(前(?=の))(のもの)?|(現在)(のこと)?|次|二位))'
    AllOrdinalRegex = f'({OrdinalRegex}|{RelativeOrdinalRegex})'
    AllFractionNumber = f'((({NegativeNumberTermsRegex}{{0,1}})|{NegativeNumberTermsRegexNum})(({ZeroToNineFullHalfRegex}+|{AllIntRegex})\\s*[はと]{{0,1}}\\s*)?{NegativeNumberTermsRegex}{{0,1}}({ZeroToNineFullHalfRegex}+|{AllIntRegex})\\s*分\\s*の\\s*{NegativeNumberTermsRegex}{{0,1}}({ZeroToNineFullHalfRegex}+|{AllIntRegex})+)|半(分|数)'
    FractionNotationSpecialsCharsRegex = f'({NegativeNumberTermsRegexNum}\\s*)?{ZeroToNineFullHalfRegex}+\\s+{ZeroToNineFullHalfRegex}+[/／]{ZeroToNineFullHalfRegex}+'
    FractionNotationRegex = f'({NegativeNumberTermsRegexNum}\\s*)?{ZeroToNineFullHalfRegex}+[/／]{ZeroToNineFullHalfRegex}+'
    PercentagePointRegex = f'(?<!{AllIntRegex})({AllFloatRegex}|{AllIntRegex})\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    SimplePercentageRegex = f'({AllFloatRegex}|(({NegativeNumberTermsRegex})?({AllIntRegex}|[百])))\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    NumbersPercentagePointRegex = f'(?<!%)(({NegativeNumberTermsRegexNum}|{NegativeNumberTermsRegex})?({ZeroToNineFullHalfRegex})+([\\.．]({ZeroToNineFullHalfRegex})+)?\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|((?<!(%\\d+))%))(?!{ZeroToNineFullHalfRegex}))'
    NumbersPercentageWithSeparatorRegex = f'({ZeroToNineFullHalfRegex}{{1,3}}[,，、]{ZeroToNineFullHalfRegex}{{3}})+([\\.．]{ZeroToNineFullHalfRegex}+)*\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    NumbersPercentageWithMultiplierRegex = f'(?<!{ZeroToNineIntegerRegex}){ZeroToNineFullHalfRegex}+[\\.．]{ZeroToNineFullHalfRegex}+\\s*{BaseNumbers.NumberMultiplierRegex}\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    FractionPercentagePointRegex = f'(?<!({ZeroToNineFullHalfRegex}+[\\.．])){ZeroToNineFullHalfRegex}+[\\.．]{ZeroToNineFullHalfRegex}+(?!([\\.．]{ZeroToNineFullHalfRegex}+))\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    FractionPercentageWithSeparatorRegex = f'{ZeroToNineFullHalfRegex}{{1,3}}([,，、]{ZeroToNineFullHalfRegex}{{3}})+[\\.．]{ZeroToNineFullHalfRegex}+\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    FractionPercentageWithMultiplierRegex = f'{ZeroToNineFullHalfRegex}+[\\.．]{ZeroToNineFullHalfRegex}+\\s*{BaseNumbers.NumberMultiplierRegex}\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    SimpleNumbersPercentageRegex = f'(?<!{ZeroToNineIntegerRegex}){ZeroToNineFullHalfRegex}+\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])(?!([\\.．]{ZeroToNineFullHalfRegex}+))'
    SimpleNumbersPercentageWithMultiplierRegex = f'(?<!{ZeroToNineIntegerRegex}){ZeroToNineFullHalfRegex}+\\s*{BaseNumbers.NumberMultiplierRegex}\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    SimpleNumbersPercentagePointRegex = f'(?!{ZeroToNineIntegerRegex}){ZeroToNineFullHalfRegex}{{1,3}}([,，]{ZeroToNineFullHalfRegex}{{3}})+\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    IntegerPercentageRegex = f'{ZeroToNineFullHalfRegex}+\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    IntegerPercentageWithMultiplierRegex = f'{ZeroToNineFullHalfRegex}+\\s*{BaseNumbers.NumberMultiplierRegex}\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    NumbersFractionPercentageRegex = f'{ZeroToNineFullHalfRegex}{{1,3}}([,，]{ZeroToNineFullHalfRegex}{{3}})+\\s*(パ\\s*ー\\s*セ\\s*ン\\s*ト|[%])'
    SimpleIntegerPercentageRegex = f'(?<!%)(({NegativeNumberTermsRegexNum}|{NegativeNumberTermsRegex})?{ZeroToNineFullHalfRegex}+([\\.．]{ZeroToNineFullHalfRegex}+)?(\\s*)((?<!(%\\d+))%)(?!{ZeroToNineFullHalfRegex}))'
    NumbersFoldsPercentageRegex = f'{ZeroToNineFullHalfRegex}(([\\.．]?|\\s*){ZeroToNineFullHalfRegex})?\\s*[の]*\\s*割引'
    FoldsPercentageRegex = f'{ZeroToNineIntegerRegex}(\\s*[.]?\\s*{ZeroToNineIntegerRegex})?\\s*[の]\\s*割引'
    SimpleFoldsPercentageRegex = f'{ZeroToNineFullHalfRegex}\\s*割(\\s*(半|({ZeroToNineFullHalfRegex}\\s*分\\s*{ZeroToNineFullHalfRegex}\\s*厘)|{ZeroToNineFullHalfRegex}))?'
    SpecialsPercentageRegex = f'({ZeroToNineIntegerRegex}|[十])\\s*割(\\s*(半|{ZeroToNineIntegerRegex}))?'
    NumbersSpecialsPercentageRegex = f'({ZeroToNineFullHalfRegex}[\\.．]{ZeroToNineFullHalfRegex}|10)\\s*割'
    SimpleSpecialsPercentageRegex = f'{ZeroToNineIntegerRegex}\\s*[.]\\s*{ZeroToNineIntegerRegex}\\s*割'
    SpecialsFoldsPercentageRegex = f'半\\s*分|(?<=ダース)'
    TillRegex = f'(から|--|-|—|——|~)'
    MoreRegex = f'(大なり|を超える|大きい|高い|大きく|(?<!<|=)>)'
    LessRegex = f'(小なり|小さい|低い|(?<!>|=)<)'
    EqualRegex = f'(等しい|イコール|(?<!<|>)=)'
    MoreOrEqualPrefixRegex = f'(少なくとも)'
    LessOrEqualPrefixRegex = f'(多くて)'
    MoreOrEqual = f'(({MoreRegex}(か){EqualRegex})|小さくない|以上|最低)'
    MoreOrEqualSuffix = f'(より(大なりイコール|小さくない))'
    LessOrEqual = f'(({LessRegex}\\s*(或|或者)?\\s*{EqualRegex})|({LessRegex}(か){EqualRegex})|大さくない|以下|最大)'
    LessOrEqualSuffix = f'(小なりイコール|大さくない)'
    OneNumberRangeMoreRegex1 = f'(?<number1>(((?!((,(?!\\d+))|。|は)).)+))\\s*((より)\\s*(({MoreOrEqual}|{MoreRegex})))|(?<number1>((?!((,(?!\\d+))|。|は)).)+)\\s*({MoreRegex})'
    OneNumberRangeMoreRegex3 = f'(?<number1>((?!((,(?!\\d+))|。)).)+)\\s*(以上|最低)(?![万億]{{1,2}})'
    OneNumberRangeMoreRegex4 = f'({MoreOrEqualPrefixRegex})\\s*(?<number1>((?!(と|は|((と)?同時に)|((と)?そして)|が|,|(,(?!\\d+))|。)).)*)'
    OneNumberRangeMoreRegex5 = f'(?<number1>((?!((,(?!\\d+))|。)).)+)\\s*((もしくはそれ)(以上)(?![万億]{{1,2}}))'
    OneNumberRangeMoreSeparateRegex = f'^[.]'
    OneNumberRangeLessSeparateRegex = f'^[.]'
    OneNumberRangeLessRegex1 = f'(?<number2>(((?!(((,)(?!\\d+))|。|(\\D)))|(?:[-]|(分の))).)+)\\s*(より)\\s*({LessOrEqual}|{LessRegex})|(?<number2>((?!((,(?!\\d+))|。)).)+)\\s*(小な)'
    OneNumberRangeLessRegex3 = f'(?<number2>(((?!((,(?!\\d+))|。)).)+))\\s*(以下|未満)(の間)?(?![万億]{{1,2}})'
    OneNumberRangeLessRegex4 = f'({LessOrEqual}|{LessRegex}|{LessOrEqualPrefixRegex})\\s*(?<number2>((?!(と|は|((と)?同時に)|((と)?そして)|が|の|,|(,(?!\\d+))|。)).)+)'
    OneNumberRangeEqualRegex = f'(((?<number1>((?!((,(?!\\d+))|。)).)+)\\s*(に)\\s*{EqualRegex})|({EqualRegex}\\s*(?<number1>((?!((,(?!\\d+))|。)).)+)))'
    TwoNumberRangeMoreSuffix = f'({MoreOrEqualPrefixRegex}\\s*(?<number1>((?!(と|は|((と)?同時に)|((と)?そして)|が|,|(,(?!\\d+))|。)).)*))(,{LessOrEqualPrefixRegex})'
    TwoNumberRangeRegex1 = f'(?<number1>((?!((,(?!\\d+))|。)).)+)\\s*(と|{TillRegex})\\s*(?<number2>((?!((,(?!\\d+))|。)).)+)\\s*(の間|未満)'
    TwoNumberRangeRegex2 = f'({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex3}|{OneNumberRangeMoreRegex4})\\s*(と|((と)?同時に)|((と)?そして)|が|,)?\\s*({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex3}|{OneNumberRangeLessRegex4})'
    TwoNumberRangeRegex3 = f'({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex3}|{OneNumberRangeLessRegex4})\\s*(と|((と)?同時に)|((と)?そして)|が|,)?\\s*({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex3}|{OneNumberRangeMoreRegex4})'
    TwoNumberRangeRegex4 = f'(?<number1>((?!((,(?!\\d+))|。)).)+)\\s*{TillRegex}\\s*(?<number2>((?!((,(?!\\d+))|。)).)+)'
    AmbiguousFractionConnectorsRegex = f'^[.]'
    RelativeReferenceOffsetMap = dict([("前", "-1"),
                                       ("現在", "0"),
                                       ("次", "1"),
                                       ("最後", "0"),
                                       ("最後から三番目", "-2"),
                                       ("最後から二番目", "-1"),
                                       ("最後から一つ前", "-1"),
                                       ("最後から一つ前のもの", "-1"),
                                       ("最後から一つ前のこと", "-1"),
                                       ("最後から1つ前のこと", "-1"),
                                       ("最後から1つ前のもの", "-1"),
                                       ("最後から1つ前", "-1"),
                                       ("現在のこと", "0"),
                                       ("前のもの", "-1"),
                                       ("次のもの", "1"),
                                       ("最後から3番目", "-2"),
                                       ("最後から2番目", "-1")])
    RelativeReferenceRelativeToMap = dict([("前", "current"),
                                           ("現在", "current"),
                                           ("次", "current"),
                                           ("最後", "end"),
                                           ("最後から三番目", "end"),
                                           ("最後から二番目", "end"),
                                           ("最後から一つ前", "end"),
                                           ("最後から一つ前のもの", "end"),
                                           ("最後から一つ前のこと", "end"),
                                           ("現在のこと", "current"),
                                           ("最後から1つ前のこと", "end"),
                                           ("最後から1つ前のもの", "end"),
                                           ("最後から1つ前", "end"),
                                           ("前のもの", "current"),
                                           ("次のもの", "current"),
                                           ("最後から3番目", "end"),
                                           ("最後から2番目", "end")])
    AmbiguityFiltersDict = dict([("^に$", "に")])
# pylint: enable=line-too-long
