# ------------------------------------------------------------------------------
# <auto-generated>
#     This code was generated by a tool.
#     Changes to this file may cause incorrect behavior and will be lost if
#     the code is regenerated.
# </auto-generated>
#
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# ------------------------------------------------------------------------------

from .base_numbers import BaseNumbers
# pylint: disable=line-too-long


class ItalianNumeric:
    LangMarker = 'Ita'
    CompoundNumberLanguage = True
    MultiDecimalSeparatorCulture = False
    DigitsNumberRegex = f'\\d|\\d{{1,3}}(\\.\\d{{3}})'
    RoundNumberIntegerRegex = f'(cent(o|(?!\\b)|(?=\'))|mill(e|(?!\\b)|(?=\'))|mila|miliard([oi]|(?!\\b)|(?=\'))|(milion|bilion|trilion)([ei]|(?!\\b)|(?=\')))'
    ZeroToNineIntegerRegex = f'(un[oa]?|due|tre|quattro|cinque|sei|sette|otto|nove|zero)'
    TwoToNineIntegerRegex = f'(due|tre|quattro|cinque|sei|sette|otto|nove)'
    NegativeNumberTermsRegex = f'(?<negTerm>meno\\s+)'
    NegativeNumberSignRegex = f'^{NegativeNumberTermsRegex}.*'
    AnIntRegex = f'(un)(?=\\s)'
    TenToNineteenIntegerRegex = f'(diciott(o|(?!\\b)|(?=\'))|(diciassett|diciannov)(e|(?!\\b)|(?=\'))|(tredic|quattordic|quindic|sedic|undic|dodic|diec)(i|(?!\\b)|(?=\')))'
    TensNumberIntegerRegex = f'(vent(i|(?!\\b)|(?=\'))|(settant|trent|ottant|novant|quarant|cinquant|sessant)(a|(?!\\b)|(?=\')))'
    SeparaIntRegex = f'((({TenToNineteenIntegerRegex}|({TensNumberIntegerRegex}{ZeroToNineIntegerRegex})|{TensNumberIntegerRegex}|{ZeroToNineIntegerRegex})(\\s*{RoundNumberIntegerRegex})*))|((({AnIntRegex})?(\\s*{RoundNumberIntegerRegex})+))'
    AllIntRegex = f'(((({TenToNineteenIntegerRegex}|({TensNumberIntegerRegex}{ZeroToNineIntegerRegex})|{TensNumberIntegerRegex}|{ZeroToNineIntegerRegex}|({AnIntRegex})?)(\\s*{RoundNumberIntegerRegex})+)\\s*(e\\s+)?)*{SeparaIntRegex})'
    PlaceHolderPureNumber = f'\\b'
    PlaceHolderDefault = f'\\D|\\b'

    def NumbersWithPlaceHolder(placeholder):
        return f'(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+(?!(,\\d+[a-zA-Z]))(?={placeholder})'
    NumbersWithSuffix = f'(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)'
    RoundNumberIntegerRegexWithLocks = f'(?<=\\b)({DigitsNumberRegex})+\\s+{RoundNumberIntegerRegex}(?=\\b)'
    NumbersWithDozenSuffix = f'(((?<!\\d+\\s*)-\\s*)|(?<=\\b))\\d+\\s+dozzin[ae](?=\\b)'
    AllIntRegexWithLocks = f'((?<=\\b){AllIntRegex}(?=\\b))'
    AllIntRegexWithDozenSuffixLocks = f'(?<=\\b)(((mezza|una)\\s+dozzina)|({AllIntRegex}\\s+dozzin[ae]))(?=\\b)'
    RoundNumberOrdinalRegex = f'(centesim[oaie]|millesim[oaie]|milionesim[oaie]|miliardesim[oaie]|bilionesim[oaie]|trilionesim[oaie])'
    OneToNineOrdinalRegex = f'(prim[oaie]|second[oaie]|terz[oaie]|quart[oaie]|quint[oaie]|sest[oaie]|settim[oaie]|ottav[oaie]|non[oaie])'
    NumberOrdinalRegex = f'(prim[oaie]|second[oaie]|terz[oaie]|quart[oaie]|quint[oaie]|sest[oaie]|settim[oaie]|ottav[oaie]|non[oaie]|decim[oaie]|undicesim[oaie]|dodicesim[oaie]|tredicesim[oaie]|quattordicesim[oaie]|quindicesim[oaie]|sedicesim[oaie]|diciassettesim[oaie]|diciottesim[oaie]|diciannovesim[oaie]|ventesim[oaie]|trentesim[oaie]|quarantesim[oaie]|cinquantesim[oaie]|sessantesim[oaie]|settantesim[oaie]|ottantesim[oaie]|novantesim[oaie])'
    OneToNineOrdinalCompoundRegex = f'(un|du|tre|quattr|cinqu|sei|sett|ott|nov)esim[oaie]'
    RelativeOrdinalRegex = f'(?<relativeOrdinal>precedent[ei]|seguent[ei]|prossim[aoei]|corrent[ei]|successiv[aoei]|penultim[oaei]|terzultim[oaei]|(l\')?(ultim[oaei]|attual[ei])|quell[ao]\\s+prima\\s+dell\'ultim[ao])'
    BasicOrdinalRegex = f'({NumberOrdinalRegex}(?!\\s*({TwoToNineIntegerRegex}|([2-9]+))\\b))'
    SuffixBasicOrdinalRegex = f'((((({TensNumberIntegerRegex}{ZeroToNineIntegerRegex})|{TensNumberIntegerRegex}|{ZeroToNineIntegerRegex}|({AnIntRegex})|{RoundNumberIntegerRegex})(\\s*{RoundNumberIntegerRegex})*)\\s*(e\\s+)?)*({TensNumberIntegerRegex}?{OneToNineOrdinalCompoundRegex}|{BasicOrdinalRegex}))'
    SuffixRoundNumberOrdinalRegex = f'(({AllIntRegex}\\s*)?{RoundNumberOrdinalRegex})'
    AllOrdinalNumberRegex = f'({SuffixRoundNumberOrdinalRegex}|{SuffixBasicOrdinalRegex})'
    AllOrdinalRegex = f'(?:{AllOrdinalNumberRegex}|{RelativeOrdinalRegex})'
    OrdinalSuffixRegex = f'(?<=\\b)(\\d+(°|(esi)?m[oaie]))'
    OrdinalNumericRegex = f'(?<=\\b)(\\d{{1,3}}(\\s*,\\s*\\d{{3}})*(°|(esi)?m[oaie]))'
    OrdinalRoundNumberRegex = f'(?<!(un)\\s+){RoundNumberOrdinalRegex}'
    OrdinalItalianRegex = f'(?<=\\b){AllOrdinalRegex}(?=\\b)'
    FractionNotationWithSpacesRegex = f'(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s+(e\\s+)?\\d+[/]\\d+(?=(\\b[^/]|$))'
    FractionNotationRegex = f'{BaseNumbers.FractionNotationRegex}'
    FractionMultiplierRegex = f'(?<fracMultiplier>\\s+e\\s+(mezzo|(un|{TwoToNineIntegerRegex})\\s+(mezz[oi]|quart[oi]|terz[oi]|quint[oi]|sest[oi]|settim[oi]|ottav[oi]|non[oi]|decim[oi])))'
    RoundMultiplierWithFraction = f'(?<multiplier>(?:milion[ei]|miliard[oi]|bilion[ei]|trillion[ei]))(?={FractionMultiplierRegex}?$)'
    RoundMultiplierRegex = f'\\b\\s*({RoundMultiplierWithFraction}|(?<multiplier>(cento|mille|mila))$)'
    FractionNounRegex = f'(?<=\\b)({AllIntRegex}\\s+(e\\s+)?)?(({AllIntRegex})(\\s+|\\s*-\\s*)(?!\\bprimo\\b|\\bsecondo\\b)(mezzi|({AllOrdinalNumberRegex})|({RoundNumberOrdinalRegex}))|(mezzo|un\\s+quarto\\s+di)\\s+{RoundNumberIntegerRegex})(?=\\b)'
    FractionNounWithArticleRegex = f'(?<=\\b)((({AllIntRegex}|{RoundNumberIntegerRegexWithLocks})\\s+(e\\s+)?)?((un)(\\s+|\\s*-\\s*)(?!\\bprimo\\b|\\bsecondo\\b)({AllOrdinalNumberRegex}|{RoundNumberOrdinalRegex})|(un\\s+)?mezzo))(?=\\b)'
    FractionPrepositionRegex = f'(?<!{BaseNumbers.CommonCurrencySymbol}\\s*)(?<=\\b)(?<numerator>({AllIntRegex})|((?<!\\.)\\d+))\\s+su\\s+(?<denominator>({AllIntRegex})|(\\d+)(?!\\.))(?=\\b)'
    AllPointRegex = f'((\\s+{ZeroToNineIntegerRegex})+|(\\s+{SeparaIntRegex}))'
    AllFloatRegex = f'({AllIntRegex}(\\s+(virgola|punto)){AllPointRegex})'

    def DoubleDecimalPointRegex(placeholder):
        return f'(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+,)))\\d+,\\d+(?!(,\\d+))(?={placeholder})'

    def DoubleWithoutIntegralRegex(placeholder):
        return f'(?<=\\s|^)(?<!(\\d+)),\\d+(?!(,\\d+))(?={placeholder})'
    DoubleWithMultiplierRegex = f'(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\,)))\\d+,\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)'
    DoubleWithRoundNumber = f'(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\,)))\\d+,\\d+\\s+{RoundNumberIntegerRegex}(?=\\b)'
    DoubleAllFloatRegex = f'((?<=\\b){AllFloatRegex}(?=\\b))'
    ConnectorRegex = f'(?<spacer>e)'
    DoubleExponentialNotationRegex = f'(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+,)))(\\d+(,\\d+)?)e([+-]*[1-9]\\d*)(?=\\b)'
    DoubleCaretExponentialNotationRegex = f'(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+,)))(\\d+(,\\d+)?)\\^([+-]*[1-9]\\d*)(?=\\b)'
    NumberWithSuffixPercentage = f'(?<!%)({BaseNumbers.NumberReplaceToken})(\\s*)(%(?!{BaseNumbers.NumberReplaceToken})|(per cento|percentuale|percento)\\b)'
    NumberWithPrefixPercentage = f'(per cento di|percento di)(\\s*)({BaseNumbers.NumberReplaceToken})'
    TillRegex = f'(a|fino\\s+a|--|-|—|——|~|–)'
    MoreRegex = f'((più\\s+grand[ei]|più\\s+(in\\s+)?alt[oi]|maggior[ei]|al\\s+di\\s+sopra|più)(\\s+di)?|sopra(\\s+i)?|superior[ei](\\s+a)?|(?<!<|=)>)'
    LessRegex = f'((meno|più\\s+(in\\s+)?bass[oi]|più\\s+piccol[oi]|minor[ei]|al\\s+di\\s+sotto)(\\s+di)?|sotto(\\s+i)?|inferior[ei](\\s+a)?|(?<!>|=)<)'
    EqualRegex = f'(ugual[ei](\\s+a)?|(?<!<|>)=)'
    MoreOrEqualPrefix = f'((non\\s+((è|sono)\\s+)?{LessRegex})|(almeno))'
    MoreOrEqual = f'(({MoreRegex}\\s+(o)?\\s+{EqualRegex})|({EqualRegex}\\s+(o)?\\s+{MoreRegex})|{MoreOrEqualPrefix}(\\s+(o)?\\s+{EqualRegex})?|({EqualRegex}\\s+(o)?\\s+)?{MoreOrEqualPrefix}|>\\s*=)'
    MoreOrEqualSuffix = f'((e|o)\\s+(((più\\s+grand[ei]|più\\s+(in\\s+)?alt[oi]|maggior[ei]|al\\s+di\\s+sopra|più)((?!\\s+di)|(\\s+di(?!(\\s*\\d+)))))|((superior[ei])((?!\\s+a)|(\\s+a(?!(\\s*\\d+)))))))'
    LessOrEqualPrefix = f'((non\\s+((è|sono)\\s+)?{MoreRegex})|(al\\s+più))'
    LessOrEqual = f'(({LessRegex}\\s+(o)?\\s+{EqualRegex})|({EqualRegex}\\s+(o)?\\s+{LessRegex})|{LessOrEqualPrefix}(\\s+(o)?\\s+{EqualRegex})?|({EqualRegex}\\s+(o)?\\s+)?{LessOrEqualPrefix}|<\\s*=)'
    LessOrEqualSuffix = f'((e|o)\\s+(((meno|più\\s+(in\\s+)?bass[oi]|più\\s+piccol[oi]|minor[ei]|al\\s+di\\s+sotto)((?!\\s+di)|(\\s+di(?!(\\s*\\d+)))))|((meno|inferior[ei])((?!\\s+a)|(\\s+a(?!(\\s*\\d+)))))))'
    NumberSplitMark = f'(?![,.](?!\\d+))'
    MoreRegexNoNumberSucceed = f'((più\\s+grand[ei]|più\\s+(in\\s+)?alt[oi]|maggior[ei]|al\\s+di\\s+sopra|più)((?!\\s+di)|\\s+(di(?!(\\s*\\d+))))|(sopra(\\s+i)?|superior[ei](\\s+a)?)(?!(\\s*\\d+)))'
    LessRegexNoNumberSucceed = f'((meno|più\\s+(in\\s+)?bass[oi]|più\\s+piccol[oi]|minor[ei]|al\\s+di\\s+sotto)((?!\\s+di)|\\s+(di(?!(\\s*\\d+))))|(sotto(\\s+i)?|inferior[ei](\\s+a)?)(?!(\\s*\\d+)))'
    EqualRegexNoNumberSucceed = f'(ugual[ei]((?!\\s+a)|(\\s+a(?!(\\s*\\d+)))))'
    OneNumberRangeMoreRegex1 = f'({MoreOrEqual}|{MoreRegex})\\s*((il?|de[li])\\s+)?(?<number1>({NumberSplitMark}.)+)'
    OneNumberRangeMoreRegex2 = f'(?<number1>({NumberSplitMark}.)+)\\s*{MoreOrEqualSuffix}'
    OneNumberRangeMoreSeparateRegex = f'({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+or\\s+){MoreRegexNoNumberSucceed})|({MoreRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+or\\s+){EqualRegexNoNumberSucceed})'
    OneNumberRangeLessRegex1 = f'({LessOrEqual}|{LessRegex})\\s*((il?|de[li])\\s+)?(?<number2>({NumberSplitMark}.)+)'
    OneNumberRangeLessRegex2 = f'(?<number2>({NumberSplitMark}.)+)\\s*{LessOrEqualSuffix}'
    OneNumberRangeLessSeparateRegex = f'({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){LessRegexNoNumberSucceed})|({LessRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){EqualRegexNoNumberSucceed})'
    OneNumberRangeEqualRegex = f'{EqualRegex}\\s*((il?|de[li])\\s+)?(?<number1>({NumberSplitMark}.)+)'
    TwoNumberRangeRegex1 = f'(compres[oi]\\s+)?[tf]ra\\s*(il?\\s+)?(?<number1>({NumberSplitMark}.)+)\\s*e\\s*(il?\\s+)?(?<number2>({NumberSplitMark}.)+)'
    TwoNumberRangeRegex2 = f'({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})\\s*(e|(,\\s+)?ma|,)\\s*({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})'
    TwoNumberRangeRegex3 = f'({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})\\s*(e|(,\\s+)?ma|,)\\s*({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})'
    TwoNumberRangeRegex4 = f'(da[li]?\\s+)?(?<number1>({NumberSplitMark}(?!\\bda\\b).)+)\\s*{TillRegex}\\s*([li]\\s+)?(?<number2>({NumberSplitMark}.)+)'
    DecimalSeparatorChar = ','
    FractionMarkerToken = 'su'
    NonDecimalSeparatorChar = '.'
    HalfADozenText = 'sei'
    WordSeparatorToken = 'e'
    WrittenDecimalSeparatorTexts = [r'virgola', r'punto']
    WrittenGroupSeparatorTexts = [r'punto']
    WrittenIntegerSeparatorTexts = [r'e', r'-']
    WrittenFractionSeparatorTexts = [r'e']
    OneHalfTokens = [r'un', r'mezzo']
    HalfADozenRegex = f'mezza\\s+dozzina'
    DigitalNumberRegex = f'((?<=\\b)(cento|mille|milione|milioni|miliardo|miliardi|bilione|bilioni|trilione|trilioni|dozzina|dozzine)(?=\\b))|((?<=(\\d|\\b)){BaseNumbers.MultiplierLookupRegex}(?=\\b))'
    AmbiguousFractionConnectorsRegex = f'(\\bnel\\b)'
    CardinalNumberMap = dict([("zero", 0),
                              ("un", 1),
                              ("una", 1),
                              ("uno", 1),
                              ("due", 2),
                              ("tre", 3),
                              ("quattro", 4),
                              ("cinque", 5),
                              ("sei", 6),
                              ("sette", 7),
                              ("otto", 8),
                              ("tto", 8),
                              ("nove", 9),
                              ("dieci", 10),
                              ("undici", 11),
                              ("dodici", 12),
                              ("dozzina", 12),
                              ("dozzine", 12),
                              ("tredici", 13),
                              ("quattordici", 14),
                              ("quindici", 15),
                              ("sedici", 16),
                              ("diciassette", 17),
                              ("diciotto", 18),
                              ("diciannove", 19),
                              ("venti", 20),
                              ("vent", 20),
                              ("trenta", 30),
                              ("trent", 30),
                              ("quaranta", 40),
                              ("quarant", 40),
                              ("cinquanta", 50),
                              ("cinquant", 50),
                              ("sessanta", 60),
                              ("sessant", 60),
                              ("settanta", 70),
                              ("settant", 70),
                              ("ottanta", 80),
                              ("ottant", 80),
                              ("ttanta", 80),
                              ("ttant", 80),
                              ("novanta", 90),
                              ("novant", 90),
                              ("cento", 100),
                              ("cent", 100),
                              ("mille", 1000),
                              ("mila", 1000),
                              ("milione", 1000000),
                              ("milioni", 1000000),
                              ("miliardo", 1000000000),
                              ("miliardi", 1000000000),
                              ("bilione", 1000000000000),
                              ("bilioni", 1000000000000),
                              ("trilione", 1000000000000000000),
                              ("trilioni", 1000000000000000000)])
    OrdinalNumberMap = dict([("primo", 1),
                             ("prima", 1),
                             ("secondo", 2),
                             ("seconda", 2),
                             ("metà", 2),
                             ("mezzo", 2),
                             ("mezza", 2),
                             ("terzo", 3),
                             ("terza", 3),
                             ("quarto", 4),
                             ("quarta", 4),
                             ("quinto", 5),
                             ("quinta", 5),
                             ("sesto", 6),
                             ("sesta", 6),
                             ("settimo", 7),
                             ("settima", 7),
                             ("ottavo", 8),
                             ("ottava", 8),
                             ("ttavo", 8),
                             ("ttava", 8),
                             ("nono", 9),
                             ("nona", 9),
                             ("decimo", 10),
                             ("decima", 10),
                             ("undicesimo", 11),
                             ("undicesima", 11),
                             ("dodicesimo", 12),
                             ("dodicesima", 12),
                             ("tredicesimo", 13),
                             ("tredicesima", 13),
                             ("quattordicesimo", 14),
                             ("quattordicesima", 14),
                             ("quindicesimo", 15),
                             ("quindicesima", 15),
                             ("sedicesimo", 16),
                             ("sedicesima", 16),
                             ("diciassettesimo", 17),
                             ("diciassettesima", 17),
                             ("diciottesimo", 18),
                             ("diciottesima", 18),
                             ("diciannovesimo", 19),
                             ("diciannovesima", 19),
                             ("ventesimo", 20),
                             ("ventesima", 20),
                             ("ventunesimo", 21),
                             ("ventunesima", 21),
                             ("trentesimo", 30),
                             ("trentesima", 30),
                             ("quarantesimo", 40),
                             ("quarantesima", 40),
                             ("cinquantesimo", 50),
                             ("cinquantesima", 50),
                             ("sessantesimo", 60),
                             ("sessantesima", 60),
                             ("settantesimo", 70),
                             ("settantesima", 70),
                             ("ottantesimo", 80),
                             ("ottantesima", 80),
                             ("ttantesimo", 80),
                             ("ttantesima", 80),
                             ("novantesimo", 90),
                             ("novantesima", 90),
                             ("centesimo", 100),
                             ("centesima", 100),
                             ("millesimo", 1000),
                             ("millesima", 1000),
                             ("milionesimo", 1000000),
                             ("milionesima", 1000000),
                             ("miliardesimo", 1000000000),
                             ("miliardesima", 1000000000),
                             ("bilionesimo", 1000000000000),
                             ("bilionesima", 1000000000000),
                             ("trilionesimo", 1000000000000000000),
                             ("trilionesima", 1000000000000000000),
                             ("primi", 1),
                             ("prime", 1),
                             ("secondi", 2),
                             ("seconde", 2),
                             ("mezzi", 2),
                             ("mezze", 2),
                             ("terzi", 3),
                             ("terze", 3),
                             ("quarti", 4),
                             ("quarte", 4),
                             ("quinti", 5),
                             ("quinte", 5),
                             ("sesti", 6),
                             ("seste", 6),
                             ("settimi", 7),
                             ("settime", 7),
                             ("ottavi", 8),
                             ("ottave", 8),
                             ("noni", 9),
                             ("none", 9),
                             ("unesimo", 1),
                             ("unesima", 1),
                             ("unesime", 1),
                             ("unesimi", 1),
                             ("duesimo", 2),
                             ("duesima", 2),
                             ("duesime", 2),
                             ("duesimi", 2),
                             ("treesimo", 3),
                             ("treesima", 3),
                             ("treesime", 3),
                             ("treesimi", 3),
                             ("quattresimo", 4),
                             ("quattresima", 4),
                             ("quattresime", 4),
                             ("quattresimi", 4),
                             ("cinquesimo", 5),
                             ("cinquesima", 5),
                             ("cinquesime", 5),
                             ("cinquesimi", 5),
                             ("seiesimo", 6),
                             ("seiesima", 6),
                             ("seiesime", 6),
                             ("seiesimi", 6),
                             ("settesimo", 7),
                             ("settesima", 7),
                             ("settesime", 7),
                             ("settesimi", 7),
                             ("ottesimo", 8),
                             ("ottesima", 8),
                             ("ottesime", 8),
                             ("ottesimi", 8),
                             ("novesimo", 9),
                             ("novesima", 9),
                             ("novesime", 9),
                             ("novesimi", 9),
                             ("decimi", 10),
                             ("decime", 10),
                             ("undicesimi", 11),
                             ("undicesime", 11),
                             ("dodicesimi", 12),
                             ("dodicesime", 12),
                             ("tredicesimi", 13),
                             ("tredicesime", 13),
                             ("quattordicesimi", 14),
                             ("quattordicesime", 14),
                             ("quindicesimi", 15),
                             ("quindicesime", 15),
                             ("sedicesimi", 16),
                             ("sedicesime", 16),
                             ("diciassettesimi", 17),
                             ("diciassettesime", 17),
                             ("diciottesimi", 18),
                             ("diciottesime", 18),
                             ("diciannovesimi", 19),
                             ("diciannovesime", 19),
                             ("ventesimi", 20),
                             ("ventesime", 20),
                             ("trentesimi", 30),
                             ("trentesime", 30),
                             ("quarantesimi", 40),
                             ("quarantesime", 40),
                             ("cinquantesimi", 50),
                             ("cinquantesime", 50),
                             ("sessantesimi", 60),
                             ("sessantesime", 60),
                             ("settantesimi", 70),
                             ("settantesime", 70),
                             ("ottantesimi", 80),
                             ("ottantesime", 80),
                             ("ttantesimi", 80),
                             ("ttantesime", 80),
                             ("novantesimi", 90),
                             ("novantesime", 90),
                             ("centesimi", 100),
                             ("centesime", 100),
                             ("millesimi", 1000),
                             ("millesime", 1000),
                             ("milionesimi", 1000000),
                             ("milionesime", 1000000),
                             ("miliardesimi", 1000000000),
                             ("miliardesime", 1000000000),
                             ("bilionesimi", 1000000000000),
                             ("bilionesime", 1000000000000),
                             ("trilionesimi", 1000000000000000000),
                             ("trilionesime", 1000000000000000000)])
    RoundNumberMap = dict([("cento", 100),
                           ("mille", 1000),
                           ("mila", 1000),
                           ("milione", 1000000),
                           ("milioni", 1000000),
                           ("miliardo", 1000000000),
                           ("miliardi", 1000000000),
                           ("bilione", 1000000000000),
                           ("bilioni", 1000000000000),
                           ("trilione", 1000000000000000000),
                           ("trilioni", 1000000000000000000),
                           ("centinaio", 100),
                           ("centinai", 100),
                           ("centinaie", 100),
                           ("millesimo", 1000),
                           ("milionesimo", 1000000),
                           ("miliardesimo", 1000000000),
                           ("bilionesimo", 1000000000000),
                           ("trilionesimo", 1000000000000000000),
                           ("millesima", 1000),
                           ("milionesima", 1000000),
                           ("miliardesima", 1000000000),
                           ("bilionesima", 1000000000000),
                           ("trilionesima", 1000000000000000000),
                           ("millesimi", 1000),
                           ("milionesimi", 1000000),
                           ("miliardesimi", 1000000000),
                           ("bilionesimi", 1000000000000),
                           ("trilionesimi", 1000000000000000000),
                           ("millesime", 1000),
                           ("milionesime", 1000000),
                           ("miliardesime", 1000000000),
                           ("bilionesime", 1000000000000),
                           ("trilionesime", 1000000000000000000),
                           ("centinaia", 100),
                           ("migliaia", 1000),
                           ("milionata", 1000000),
                           ("miliardata", 1000000000),
                           ("bilionata", 1000000000000),
                           ("trilionata", 1000000000000000000),
                           ("dozzina", 12),
                           ("dozzine", 12),
                           ("k", 1000),
                           ("m", 1000000),
                           ("g", 1000000000),
                           ("b", 1000000000),
                           ("t", 1000000000000)])
    AmbiguityFiltersDict = dict([("^[.]", "")])
    RelativeReferenceOffsetMap = dict([("precedente", "-1"),
                                       ("precedenti", "-1"),
                                       ("seguente", "1"),
                                       ("seguenti", "1"),
                                       ("prossima", "1"),
                                       ("prossimo", "1"),
                                       ("prossime", "1"),
                                       ("prossimi", "1"),
                                       ("corrente", "0"),
                                       ("correnti", "0"),
                                       ("attuale", "0"),
                                       ("attuali", "0"),
                                       ("l'attuale", "0"),
                                       ("successiva", "1"),
                                       ("successivo", "1"),
                                       ("successive", "1"),
                                       ("successivi", "1"),
                                       ("penultima", "-1"),
                                       ("penultimo", "-1"),
                                       ("penultime", "-1"),
                                       ("penultimi", "-1"),
                                       ("quello prima dell'ultimo", "-1"),
                                       ("quella prima dell'ultima", "-1"),
                                       ("terzultima", "-2"),
                                       ("terzultimo", "-2"),
                                       ("terzultime", "-2"),
                                       ("terzultimi", "-2"),
                                       ("ultima", "0"),
                                       ("ultimo", "0"),
                                       ("ultime", "0"),
                                       ("ultimi", "0"),
                                       ("l'ultima", "0"),
                                       ("l'ultimo", "0")])
    RelativeReferenceRelativeToMap = dict([("precedente", "current"),
                                           ("precedenti", "current"),
                                           ("seguente", "current"),
                                           ("seguenti", "current"),
                                           ("prossima", "current"),
                                           ("prossimo", "current"),
                                           ("prossime", "current"),
                                           ("prossimi", "current"),
                                           ("corrente", "current"),
                                           ("correnti", "current"),
                                           ("attuale", "current"),
                                           ("attuali", "current"),
                                           ("l'attuale", "current"),
                                           ("successiva", "current"),
                                           ("successivo", "current"),
                                           ("successive", "current"),
                                           ("successivi", "current"),
                                           ("penultima", "end"),
                                           ("penultimo", "end"),
                                           ("penultime", "end"),
                                           ("penultimi", "end"),
                                           ("quello prima dell'ultimo", "end"),
                                           ("quella prima dell'ultima", "end"),
                                           ("terzultima", "end"),
                                           ("terzultimo", "end"),
                                           ("terzultime", "end"),
                                           ("terzultimi", "end"),
                                           ("ultima", "end"),
                                           ("ultimo", "end"),
                                           ("ultime", "end"),
                                           ("ultimi", "end"),
                                           ("l'ultima", "end"),
                                           ("l'ultimo", "end")])
# pylint: enable=line-too-long
